/*
 * Decompiled with CFR 0.152.
 */
package infodynamics.utils.commonsmath3.util;

import infodynamics.utils.commonsmath3.exception.ConvergenceException;
import infodynamics.utils.commonsmath3.exception.MaxCountExceededException;
import infodynamics.utils.commonsmath3.exception.util.Localizable;
import infodynamics.utils.commonsmath3.exception.util.LocalizedFormats;
import infodynamics.utils.commonsmath3.util.FastMath;
import infodynamics.utils.commonsmath3.util.Precision;

public abstract class ContinuedFraction {
    private static final double DEFAULT_EPSILON = 1.0E-8;

    protected ContinuedFraction() {
    }

    protected abstract double getA(int var1, double var2);

    protected abstract double getB(int var1, double var2);

    public double evaluate(double d) throws ConvergenceException {
        return this.evaluate(d, 1.0E-8, Integer.MAX_VALUE);
    }

    public double evaluate(double d, double d2) throws ConvergenceException {
        return this.evaluate(d, d2, Integer.MAX_VALUE);
    }

    public double evaluate(double d, int n) throws ConvergenceException, MaxCountExceededException {
        return this.evaluate(d, 1.0E-8, n);
    }

    public double evaluate(double d, double d2, int n) throws ConvergenceException, MaxCountExceededException {
        int n2;
        double d3 = this.getA(0, d);
        if (Precision.equals(d3, 0.0, 1.0E-50)) {
            d3 = 1.0E-50;
        }
        double d4 = 0.0;
        double d5 = d3;
        double d6 = d3;
        for (n2 = 1; n2 < n; ++n2) {
            double d7;
            double d8;
            double d9;
            double d10 = this.getA(n2, d);
            double d11 = d10 + (d9 = this.getB(n2, d)) * d4;
            if (Precision.equals(d11, 0.0, 1.0E-50)) {
                d11 = 1.0E-50;
            }
            if (Precision.equals(d8 = d10 + d9 / d5, 0.0, 1.0E-50)) {
                d8 = 1.0E-50;
            }
            if (Double.isInfinite(d6 = d3 * (d7 = d8 * (d11 = 1.0 / d11)))) {
                throw new ConvergenceException(LocalizedFormats.CONTINUED_FRACTION_INFINITY_DIVERGENCE, d);
            }
            if (Double.isNaN(d6)) {
                throw new ConvergenceException(LocalizedFormats.CONTINUED_FRACTION_NAN_DIVERGENCE, d);
            }
            if (FastMath.abs(d7 - 1.0) < d2) break;
            d4 = d11;
            d5 = d8;
            d3 = d6;
        }
        if (n2 >= n) {
            throw new MaxCountExceededException((Localizable)LocalizedFormats.NON_CONVERGENT_CONTINUED_FRACTION, n, d);
        }
        return d6;
    }
}

