"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
from orq_poc_python_client.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from orq_poc_python_client.utils import FieldMetadata, QueryParamMetadata
import pydantic
from pydantic import model_serializer
from typing import Any, Dict, List, Optional, Union
from typing_extensions import Annotated, NotRequired, TypedDict


class GetV2DeploymentsRequestTypedDict(TypedDict):
    limit: NotRequired[float]
    r"""A limit on the number of objects to be returned. Limit can range between 1 and 50, and the default is 10"""
    after: NotRequired[str]
    r"""A cursor for use in pagination. `after` is an object ID that defines your place in the list. For instance, if you make a list request and receive 20 objects, ending with `ed33dade-ae32-4959-8c5c-7ae4aad748b5`, your subsequent call can include `after=ed33dade-ae32-4959-8c5c-7ae4aad748b5` in order to fetch the next page of the list."""


class GetV2DeploymentsRequest(BaseModel):
    limit: Annotated[
        Optional[float],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 10
    r"""A limit on the number of objects to be returned. Limit can range between 1 and 50, and the default is 10"""

    after: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""A cursor for use in pagination. `after` is an object ID that defines your place in the list. For instance, if you make a list request and receive 20 objects, ending with `ed33dade-ae32-4959-8c5c-7ae4aad748b5`, your subsequent call can include `after=ed33dade-ae32-4959-8c5c-7ae4aad748b5` in order to fetch the next page of the list."""


class GetV2DeploymentsObject(str, Enum):
    LIST = "list"


class GetV2DeploymentsType(str, Enum):
    r"""The type of the tool. Currently, only `function` is supported."""

    FUNCTION = "function"


class GetV2DeploymentsDeploymentsResponseType(str, Enum):
    OBJECT = "object"


class GetV2DeploymentsParametersTypedDict(TypedDict):
    r"""The parameters the functions accepts, described as a JSON Schema object.

    Omitting `parameters` defines a function with an empty parameter list.
    """

    type: GetV2DeploymentsDeploymentsResponseType
    properties: Dict[str, Any]
    required: NotRequired[List[str]]
    additional_properties: NotRequired[bool]


class GetV2DeploymentsParameters(BaseModel):
    r"""The parameters the functions accepts, described as a JSON Schema object.

    Omitting `parameters` defines a function with an empty parameter list.
    """

    type: GetV2DeploymentsDeploymentsResponseType

    properties: Dict[str, Any]

    required: Optional[List[str]] = None

    additional_properties: Annotated[
        Optional[bool], pydantic.Field(alias="additionalProperties")
    ] = None


class GetV2DeploymentsFunctionTypedDict(TypedDict):
    name: str
    r"""The name of the function to be called. Must be a-z, A-Z, 0-9, or contain underscores and dashes, with a maximum length of 64."""
    parameters: GetV2DeploymentsParametersTypedDict
    r"""The parameters the functions accepts, described as a JSON Schema object.

    Omitting `parameters` defines a function with an empty parameter list.
    """
    description: NotRequired[str]
    r"""A description of what the function does, used by the model to choose when and how to call the function."""
    strict: NotRequired[bool]


class GetV2DeploymentsFunction(BaseModel):
    name: str
    r"""The name of the function to be called. Must be a-z, A-Z, 0-9, or contain underscores and dashes, with a maximum length of 64."""

    parameters: GetV2DeploymentsParameters
    r"""The parameters the functions accepts, described as a JSON Schema object.

    Omitting `parameters` defines a function with an empty parameter list.
    """

    description: Optional[str] = None
    r"""A description of what the function does, used by the model to choose when and how to call the function."""

    strict: Optional[bool] = None


class GetV2DeploymentsToolsTypedDict(TypedDict):
    type: GetV2DeploymentsType
    r"""The type of the tool. Currently, only `function` is supported."""
    function: GetV2DeploymentsFunctionTypedDict
    id: NotRequired[float]


class GetV2DeploymentsTools(BaseModel):
    type: GetV2DeploymentsType
    r"""The type of the tool. Currently, only `function` is supported."""

    function: GetV2DeploymentsFunction

    id: Optional[float] = None


class ModelType(str, Enum):
    r"""The type of the model"""

    CHAT = "chat"
    COMPLETION = "completion"
    EMBEDDING = "embedding"
    VISION = "vision"
    IMAGE = "image"
    TTS = "tts"
    STT = "stt"
    RERANK = "rerank"


class GetV2DeploymentsFormat(str, Enum):
    r"""Only supported on `image` models."""

    URL = "url"
    B64_JSON = "b64_json"
    TEXT = "text"
    JSON_OBJECT = "json_object"


class GetV2DeploymentsQuality(str, Enum):
    r"""Only supported on `image` models."""

    STANDARD = "standard"
    HD = "hd"


class GetV2DeploymentsResponseFormatDeploymentsType(str, Enum):
    JSON_OBJECT = "json_object"


class GetV2DeploymentsResponseFormat2TypedDict(TypedDict):
    type: GetV2DeploymentsResponseFormatDeploymentsType


class GetV2DeploymentsResponseFormat2(BaseModel):
    type: GetV2DeploymentsResponseFormatDeploymentsType


class GetV2DeploymentsResponseFormatType(str, Enum):
    JSON_SCHEMA = "json_schema"


class ResponseFormatJSONSchemaTypedDict(TypedDict):
    name: str
    strict: bool
    schema_: Dict[str, Any]


class ResponseFormatJSONSchema(BaseModel):
    name: str

    strict: bool

    schema_: Annotated[Dict[str, Any], pydantic.Field(alias="schema")]


class GetV2DeploymentsResponseFormat1TypedDict(TypedDict):
    type: GetV2DeploymentsResponseFormatType
    json_schema: ResponseFormatJSONSchemaTypedDict


class GetV2DeploymentsResponseFormat1(BaseModel):
    type: GetV2DeploymentsResponseFormatType

    json_schema: ResponseFormatJSONSchema


GetV2DeploymentsResponseFormatTypedDict = Union[
    GetV2DeploymentsResponseFormat2TypedDict, GetV2DeploymentsResponseFormat1TypedDict
]
r"""An object specifying the format that the model must output.

Setting to `{ \"type\": \"json_schema\", \"json_schema\": {...} }` enables Structured Outputs which ensures the model will match your supplied JSON schema

Setting to `{ \"type\": \"json_object\" }` enables JSON mode, which ensures the message the model generates is valid JSON.

Important: when using JSON mode, you must also instruct the model to produce JSON yourself via a system or user message. Without this, the model may generate an unending stream of whitespace until the generation reaches the token limit, resulting in a long-running and seemingly \"stuck\" request. Also note that the message content may be partially cut off if finish_reason=\"length\", which indicates the generation exceeded max_tokens or the conversation exceeded the max context length.
"""


GetV2DeploymentsResponseFormat = Union[
    GetV2DeploymentsResponseFormat2, GetV2DeploymentsResponseFormat1
]
r"""An object specifying the format that the model must output.

Setting to `{ \"type\": \"json_schema\", \"json_schema\": {...} }` enables Structured Outputs which ensures the model will match your supplied JSON schema

Setting to `{ \"type\": \"json_object\" }` enables JSON mode, which ensures the message the model generates is valid JSON.

Important: when using JSON mode, you must also instruct the model to produce JSON yourself via a system or user message. Without this, the model may generate an unending stream of whitespace until the generation reaches the token limit, resulting in a long-running and seemingly \"stuck\" request. Also note that the message content may be partially cut off if finish_reason=\"length\", which indicates the generation exceeded max_tokens or the conversation exceeded the max context length.
"""


class GetV2DeploymentsPhotoRealVersion(str, Enum):
    r"""The version of photoReal to use. Must be v1 or v2. Only available for `leonardoai` provider"""

    V1 = "v1"
    V2 = "v2"


class GetV2DeploymentsEncodingFormat(str, Enum):
    r"""The format to return the embeddings"""

    FLOAT = "float"
    BASE64 = "base64"


class ModelParametersTypedDict(TypedDict):
    r"""Model Parameters: Not all parameters apply to every model"""

    temperature: NotRequired[float]
    r"""Only supported on `chat` and `completion` models."""
    max_tokens: NotRequired[float]
    r"""Only supported on `chat` and `completion` models."""
    top_k: NotRequired[float]
    r"""Only supported on `chat` and `completion` models."""
    top_p: NotRequired[float]
    r"""Only supported on `chat` and `completion` models."""
    frequency_penalty: NotRequired[float]
    r"""Only supported on `chat` and `completion` models."""
    presence_penalty: NotRequired[float]
    r"""Only supported on `chat` and `completion` models."""
    num_images: NotRequired[float]
    r"""Only supported on `image` models."""
    seed: NotRequired[float]
    r"""Best effort deterministic seed for the model. Currently only OpenAI models support these"""
    format: NotRequired[GetV2DeploymentsFormat]
    r"""Only supported on `image` models."""
    dimensions: NotRequired[str]
    r"""Only supported on `image` models."""
    quality: NotRequired[GetV2DeploymentsQuality]
    r"""Only supported on `image` models."""
    style: NotRequired[str]
    r"""Only supported on `image` models."""
    response_format: NotRequired[Nullable[GetV2DeploymentsResponseFormatTypedDict]]
    r"""An object specifying the format that the model must output.

    Setting to `{ \"type\": \"json_schema\", \"json_schema\": {...} }` enables Structured Outputs which ensures the model will match your supplied JSON schema

    Setting to `{ \"type\": \"json_object\" }` enables JSON mode, which ensures the message the model generates is valid JSON.

    Important: when using JSON mode, you must also instruct the model to produce JSON yourself via a system or user message. Without this, the model may generate an unending stream of whitespace until the generation reaches the token limit, resulting in a long-running and seemingly \"stuck\" request. Also note that the message content may be partially cut off if finish_reason=\"length\", which indicates the generation exceeded max_tokens or the conversation exceeded the max context length.
    """
    photo_real_version: NotRequired[GetV2DeploymentsPhotoRealVersion]
    r"""The version of photoReal to use. Must be v1 or v2. Only available for `leonardoai` provider"""
    encoding_format: NotRequired[GetV2DeploymentsEncodingFormat]
    r"""The format to return the embeddings"""


class ModelParameters(BaseModel):
    r"""Model Parameters: Not all parameters apply to every model"""

    temperature: Optional[float] = None
    r"""Only supported on `chat` and `completion` models."""

    max_tokens: Annotated[Optional[float], pydantic.Field(alias="maxTokens")] = None
    r"""Only supported on `chat` and `completion` models."""

    top_k: Annotated[Optional[float], pydantic.Field(alias="topK")] = None
    r"""Only supported on `chat` and `completion` models."""

    top_p: Annotated[Optional[float], pydantic.Field(alias="topP")] = None
    r"""Only supported on `chat` and `completion` models."""

    frequency_penalty: Annotated[
        Optional[float], pydantic.Field(alias="frequencyPenalty")
    ] = None
    r"""Only supported on `chat` and `completion` models."""

    presence_penalty: Annotated[
        Optional[float], pydantic.Field(alias="presencePenalty")
    ] = None
    r"""Only supported on `chat` and `completion` models."""

    num_images: Annotated[Optional[float], pydantic.Field(alias="numImages")] = None
    r"""Only supported on `image` models."""

    seed: Optional[float] = None
    r"""Best effort deterministic seed for the model. Currently only OpenAI models support these"""

    format: Optional[GetV2DeploymentsFormat] = None
    r"""Only supported on `image` models."""

    dimensions: Optional[str] = None
    r"""Only supported on `image` models."""

    quality: Optional[GetV2DeploymentsQuality] = None
    r"""Only supported on `image` models."""

    style: Optional[str] = None
    r"""Only supported on `image` models."""

    response_format: Annotated[
        OptionalNullable[GetV2DeploymentsResponseFormat],
        pydantic.Field(alias="responseFormat"),
    ] = UNSET
    r"""An object specifying the format that the model must output.

    Setting to `{ \"type\": \"json_schema\", \"json_schema\": {...} }` enables Structured Outputs which ensures the model will match your supplied JSON schema

    Setting to `{ \"type\": \"json_object\" }` enables JSON mode, which ensures the message the model generates is valid JSON.

    Important: when using JSON mode, you must also instruct the model to produce JSON yourself via a system or user message. Without this, the model may generate an unending stream of whitespace until the generation reaches the token limit, resulting in a long-running and seemingly \"stuck\" request. Also note that the message content may be partially cut off if finish_reason=\"length\", which indicates the generation exceeded max_tokens or the conversation exceeded the max context length.
    """

    photo_real_version: Annotated[
        Optional[GetV2DeploymentsPhotoRealVersion],
        pydantic.Field(alias="photoRealVersion"),
    ] = None
    r"""The version of photoReal to use. Must be v1 or v2. Only available for `leonardoai` provider"""

    encoding_format: Optional[GetV2DeploymentsEncodingFormat] = None
    r"""The format to return the embeddings"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "temperature",
            "maxTokens",
            "topK",
            "topP",
            "frequencyPenalty",
            "presencePenalty",
            "numImages",
            "seed",
            "format",
            "dimensions",
            "quality",
            "style",
            "responseFormat",
            "photoRealVersion",
            "encoding_format",
        ]
        nullable_fields = ["responseFormat"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetV2DeploymentsProvider(str, Enum):
    COHERE = "cohere"
    OPENAI = "openai"
    ANTHROPIC = "anthropic"
    HUGGINGFACE = "huggingface"
    REPLICATE = "replicate"
    GOOGLE = "google"
    GOOGLE_AI = "google-ai"
    AZURE = "azure"
    AWS = "aws"
    ANYSCALE = "anyscale"
    PERPLEXITY = "perplexity"
    GROQ = "groq"
    FAL = "fal"
    LEONARDOAI = "leonardoai"
    NVIDIA = "nvidia"


class GetV2DeploymentsRole(str, Enum):
    r"""The role of the prompt message"""

    SYSTEM = "system"
    ASSISTANT = "assistant"
    USER = "user"
    EXCEPTION = "exception"
    TOOL = "tool"
    PROMPT = "prompt"
    CORRECTION = "correction"
    EXPECTED_OUTPUT = "expected_output"


class GetV2Deployments2DeploymentsType(str, Enum):
    IMAGE_URL = "image_url"


class GetV2Deployments2ImageURLTypedDict(TypedDict):
    url: str
    r"""Either a URL of the image or the base64 encoded data URI."""
    id: NotRequired[str]
    r"""The orq.ai id of the image"""
    detail: NotRequired[str]
    r"""Specifies the detail level of the image. Currently only supported with OpenAI models"""


class GetV2Deployments2ImageURL(BaseModel):
    url: str
    r"""Either a URL of the image or the base64 encoded data URI."""

    id: Optional[str] = None
    r"""The orq.ai id of the image"""

    detail: Optional[str] = None
    r"""Specifies the detail level of the image. Currently only supported with OpenAI models"""


class GetV2Deployments22TypedDict(TypedDict):
    r"""The image part of the prompt message. Only supported with vision models."""

    type: GetV2Deployments2DeploymentsType
    image_url: GetV2Deployments2ImageURLTypedDict


class GetV2Deployments22(BaseModel):
    r"""The image part of the prompt message. Only supported with vision models."""

    type: GetV2Deployments2DeploymentsType

    image_url: GetV2Deployments2ImageURL


class GetV2Deployments2Type(str, Enum):
    TEXT = "text"


class GetV2Deployments21TypedDict(TypedDict):
    r"""Text content part of a prompt message"""

    type: GetV2Deployments2Type
    text: str


class GetV2Deployments21(BaseModel):
    r"""Text content part of a prompt message"""

    type: GetV2Deployments2Type

    text: str


GetV2DeploymentsContent2TypedDict = Union[
    GetV2Deployments21TypedDict, GetV2Deployments22TypedDict
]


GetV2DeploymentsContent2 = Union[GetV2Deployments21, GetV2Deployments22]


GetV2DeploymentsContentTypedDict = Union[str, List[GetV2DeploymentsContent2TypedDict]]
r"""The contents of the user message. Either the text content of the message or an array of content parts with a defined type, each can be of type `text` or `image_url` when passing in images. You can pass multiple images by adding multiple `image_url` content parts."""


GetV2DeploymentsContent = Union[str, List[GetV2DeploymentsContent2]]
r"""The contents of the user message. Either the text content of the message or an array of content parts with a defined type, each can be of type `text` or `image_url` when passing in images. You can pass multiple images by adding multiple `image_url` content parts."""


class GetV2DeploymentsDeploymentsType(str, Enum):
    FUNCTION = "function"


class GetV2DeploymentsDeploymentsFunctionTypedDict(TypedDict):
    name: str
    arguments: str
    r"""JSON string arguments for the functions"""


class GetV2DeploymentsDeploymentsFunction(BaseModel):
    name: str

    arguments: str
    r"""JSON string arguments for the functions"""


class GetV2DeploymentsToolCallsTypedDict(TypedDict):
    type: GetV2DeploymentsDeploymentsType
    function: GetV2DeploymentsDeploymentsFunctionTypedDict
    id: NotRequired[str]
    index: NotRequired[float]


class GetV2DeploymentsToolCalls(BaseModel):
    type: GetV2DeploymentsDeploymentsType

    function: GetV2DeploymentsDeploymentsFunction

    id: Optional[str] = None

    index: Optional[float] = None


class GetV2DeploymentsMessagesTypedDict(TypedDict):
    role: GetV2DeploymentsRole
    r"""The role of the prompt message"""
    content: GetV2DeploymentsContentTypedDict
    r"""The contents of the user message. Either the text content of the message or an array of content parts with a defined type, each can be of type `text` or `image_url` when passing in images. You can pass multiple images by adding multiple `image_url` content parts."""
    tool_calls: NotRequired[List[GetV2DeploymentsToolCallsTypedDict]]


class GetV2DeploymentsMessages(BaseModel):
    role: GetV2DeploymentsRole
    r"""The role of the prompt message"""

    content: GetV2DeploymentsContent
    r"""The contents of the user message. Either the text content of the message or an array of content parts with a defined type, each can be of type `text` or `image_url` when passing in images. You can pass multiple images by adding multiple `image_url` content parts."""

    tool_calls: Optional[List[GetV2DeploymentsToolCalls]] = None


class PromptConfigTypedDict(TypedDict):
    tools: List[GetV2DeploymentsToolsTypedDict]
    model: str
    model_type: ModelType
    r"""The type of the model"""
    model_parameters: ModelParametersTypedDict
    r"""Model Parameters: Not all parameters apply to every model"""
    provider: GetV2DeploymentsProvider
    messages: List[GetV2DeploymentsMessagesTypedDict]


class PromptConfig(BaseModel):
    tools: List[GetV2DeploymentsTools]

    model: str

    model_type: ModelType
    r"""The type of the model"""

    model_parameters: ModelParameters
    r"""Model Parameters: Not all parameters apply to every model"""

    provider: GetV2DeploymentsProvider

    messages: List[GetV2DeploymentsMessages]


class GetV2DeploymentsDataTypedDict(TypedDict):
    id: str
    r"""Unique identifier for the object."""
    created: str
    r"""Date in ISO 8601 format at which the object was created."""
    updated: str
    r"""Date in ISO 8601 format at which the object was last updated."""
    key: str
    r"""The deployment unique key"""
    description: str
    r"""An arbitrary string attached to the object. Often useful for displaying to users."""
    prompt_config: PromptConfigTypedDict
    version: str
    r"""THe version of the deployment"""


class GetV2DeploymentsData(BaseModel):
    id: str
    r"""Unique identifier for the object."""

    created: str
    r"""Date in ISO 8601 format at which the object was created."""

    updated: str
    r"""Date in ISO 8601 format at which the object was last updated."""

    key: str
    r"""The deployment unique key"""

    description: str
    r"""An arbitrary string attached to the object. Often useful for displaying to users."""

    prompt_config: PromptConfig

    version: str
    r"""THe version of the deployment"""


class GetV2DeploymentsResponseBodyTypedDict(TypedDict):
    r"""List of deployments"""

    object: GetV2DeploymentsObject
    data: List[GetV2DeploymentsDataTypedDict]
    has_more: bool


class GetV2DeploymentsResponseBody(BaseModel):
    r"""List of deployments"""

    object: GetV2DeploymentsObject

    data: List[GetV2DeploymentsData]

    has_more: bool
