"""Python wrappers around Brain.

This file is MACHINE GENERATED! Do not edit.
"""

import collections

from google.protobuf import text_format

from tensorflow.core.framework import op_def_pb2

# Needed to trigger the call to _set_call_cpp_shape_fn.
from tensorflow.python.framework import common_shapes

from tensorflow.python.framework import op_def_registry
from tensorflow.python.framework import ops
from tensorflow.python.framework import op_def_library
_cudnn_rnn_outputs = ["output", "output_h", "output_c", "reserve_space"]


_CudnnRNNOutput = collections.namedtuple("CudnnRNN", _cudnn_rnn_outputs)


def cudnn_rnn(input, input_h, input_c, params, dropout, rnn_mode=None,
              input_mode=None, direction=None, seed=None, seed2=None,
              is_training=None, name=None):
  r"""Computes the RNN from the input and initial states, with respect to the params

  buffer.

  Args:
    input: A `Tensor`. Must be one of the following types: `float32`.
      a 3-D tensor with the shape of [seq_length, batch_size, input_size].
    input_h: A `Tensor`. Must have the same type as `input`.
      a 3-D tensor with the shape of [num_layer * dir, batch_size,
      num_units].
    input_c: A `Tensor`. Must have the same type as `input`.
      For LSTM, a 3-D tensor with the shape of
      [num_layer * dir, batch, num_units]. For other models, it is ignored.
    params: A `Tensor`. Must have the same type as `input`.
      a 1-D tensor that contains the weights and biases in an opaque layout.
      The size must be created through CudnnRNNParamsSize, and initialized
      separately. Note that they might not be compatible across different
      generations. So it is a good idea to save and restore
    dropout: A `float`.
    rnn_mode: An optional `string` from: `"rnn_relu", "rnn_tanh", "lstm", "gru"`. Defaults to `"lstm"`.
      Indicates the type of the RNN model.
    input_mode: An optional `string` from: `"linear_input", "skip_input", "auto_select"`. Defaults to `"auto_select"`.
      Indicate whether there is a linear projection between the input and
      The actual computation before the first layer. 'skip_input' is only allowed
      when input_size == num_units; 'auto_select' implies 'skip_input' when
      input_size == num_units; otherwise, it implies 'linear_input'.
    direction: An optional `string` from: `"unidirectional", "bidirectional"`. Defaults to `"unidirectional"`.
      Indicates whether a bidirectional model will be used.
      dir = (direction == bidirectional) ? 2 : 1
    seed: An optional `int`. Defaults to `0`.
    seed2: An optional `int`. Defaults to `0`.
    is_training: An optional `bool`. Defaults to `True`.
      Indicates whether this operation is used for inferenece or
      training.
    name: A name for the operation (optional).

  Returns:
    A tuple of `Tensor` objects (output, output_h, output_c, reserve_space).
    output: A `Tensor`. Has the same type as `input`. a 3-D tensor with the shape of [seq_length, batch_size,
      dir * num_units].
    output_h: A `Tensor`. Has the same type as `input`. the same shape has input_h.
    output_c: A `Tensor`. Has the same type as `input`. the same shape as input_c for LSTM. An empty tensor for other models.
    reserve_space: A `Tensor`. Has the same type as `input`. an opaque tensor that can be used in backprop calculation. It
      is only produced if is_training is false.
  """
  result = _op_def_lib.apply_op("CudnnRNN", input=input, input_h=input_h,
                                input_c=input_c, params=params,
                                dropout=dropout, rnn_mode=rnn_mode,
                                input_mode=input_mode, direction=direction,
                                seed=seed, seed2=seed2,
                                is_training=is_training, name=name)
  return _CudnnRNNOutput._make(result)


ops.RegisterShape("CudnnRNN")(None)
_cudnn_rnn_backprop_outputs = ["input_backprop", "input_h_backprop",
                              "input_c_backprop", "params_backprop"]


_CudnnRNNBackpropOutput = collections.namedtuple("CudnnRNNBackprop",
                                                 _cudnn_rnn_backprop_outputs)


def cudnn_rnn_backprop(input, input_h, input_c, params, output, output_h,
                       output_c, output_backprop, output_h_backprop,
                       output_c_backprop, reserve_space, rnn_mode=None,
                       input_mode=None, direction=None, name=None):
  r"""Compute the backprop of both data and weights in a RNN.

  Args:
    input: A `Tensor`. Must be one of the following types: `float32`.
      a 3-D tensor with the shape of [seq_length, batch_size, input_size].
    input_h: A `Tensor`. Must have the same type as `input`.
      a 3-D tensor with the shape of [num_layer * dir, batch_size,
      num_units].
    input_c: A `Tensor`. Must have the same type as `input`.
      For LSTM, a 3-D tensor with the shape of
      [num_layer * dir, batch, num_units]. For other models, it is ignored.
    params: A `Tensor`. Must have the same type as `input`.
      a 1-D tensor that contains the weights and biases in an opaque layout.
      The size must be created through CudnnRNNParamsSize, and initialized
      separately. Note that they might not be compatible across different
      generations. So it is a good idea to save and restore
    output: A `Tensor`. Must have the same type as `input`.
      a 3-D tensor with the shape of [seq_length, batch_size,
      dir * num_units].
    output_h: A `Tensor`. Must have the same type as `input`.
      the same shape has input_h.
    output_c: A `Tensor`. Must have the same type as `input`.
      the same shape as input_c for LSTM. An empty tensor for other models.
    output_backprop: A `Tensor`. Must have the same type as `input`.
      A 3-D tensor with the same shape as output in the forward pass.
    output_h_backprop: A `Tensor`. Must have the same type as `input`.
      A 3-D tensor with the same shape as output_h in the forward
      pass.
    output_c_backprop: A `Tensor`. Must have the same type as `input`.
      A 3-D tensor with the same shape as output_c in the forward
      pass.
    reserve_space: A `Tensor`. Must have the same type as `input`.
      The same reserve_space produced in for forward operation.
    rnn_mode: An optional `string` from: `"rnn_relu", "rnn_tanh", "lstm", "gru"`. Defaults to `"lstm"`.
      Indicates the type of the RNN model.
    input_mode: An optional `string` from: `"linear_input", "skip_input", "auto_select"`. Defaults to `"auto_select"`.
      Indicate whether there is a linear projection between the input and
      The actual computation before the first layer. 'skip_input' is only allowed
      when input_size == num_units; 'auto_select' implies 'skip_input' when
      input_size == num_units; otherwise, it implies 'linear_input'.
    direction: An optional `string` from: `"unidirectional", "bidirectional"`. Defaults to `"unidirectional"`.
      Indicates whether a bidirectional model will be used.
      dir = (direction == bidirectional) ? 2 : 1
    name: A name for the operation (optional).

  Returns:
    A tuple of `Tensor` objects (input_backprop, input_h_backprop, input_c_backprop, params_backprop).
    input_backprop: A `Tensor`. Has the same type as `input`. The backprop to input in the forward pass. Has the same shape
      as input.
    input_h_backprop: A `Tensor`. Has the same type as `input`. The backprop to input_h in the forward pass. Has the same
      shape as input_h.
    input_c_backprop: A `Tensor`. Has the same type as `input`. The backprop to input_c in the forward pass. Has the same
      shape as input_c.
    params_backprop: A `Tensor`. Has the same type as `input`. The backprop to the params buffer in the forward pass. Has the
      same shape as params.
  """
  result = _op_def_lib.apply_op("CudnnRNNBackprop", input=input,
                                input_h=input_h, input_c=input_c,
                                params=params, output=output,
                                output_h=output_h, output_c=output_c,
                                output_backprop=output_backprop,
                                output_h_backprop=output_h_backprop,
                                output_c_backprop=output_c_backprop,
                                reserve_space=reserve_space,
                                rnn_mode=rnn_mode, input_mode=input_mode,
                                direction=direction, name=name)
  return _CudnnRNNBackpropOutput._make(result)


ops.RegisterShape("CudnnRNNBackprop")(None)
_cudnn_rnn_params_from_canonical_outputs = [""]


def cudnn_rnn_params_from_canonical(num_layers, num_units, input_size, params,
                                    canonical_weights, canonical_biases, N,
                                    rnn_mode=None, input_mode=None,
                                    direction=None, name=None):
  r"""Writes a set of weights into the the opaque params buffer so they can be used in

  upcoming training or inferences.

  Args:
    num_layers: A `Tensor` of type `int32`.
    num_units: A `Tensor` of type `int32`.
    input_size: A `Tensor` of type `int32`.
    params: A mutable `Tensor`. Must be one of the following types: `float32`.
    canonical_weights: A `Tensor`. Must have the same type as `params`.
      the canonical form of weights that can be used for saving
      and restoration. They are more likely to be compatible across different
      generations.
    canonical_biases: A `Tensor`. Must have the same type as `params`.
      the canonical form of biases that can be used for saving and
      restoration. They are more likely to be compatible across different
      generations.
    N: An `int` that is `>= 1`.
    rnn_mode: An optional `string` from: `"rnn_relu", "rnn_tanh", "lstm", "gru"`. Defaults to `"lstm"`.
      Indicates the type of the RNN model.
    input_mode: An optional `string` from: `"linear_input", "skip_input", "auto_select"`. Defaults to `"auto_select"`.
      Indicate whether there is a linear projection between the input and
      The actual computation before the first layer. 'skip_input' is only allowed
      when input_size == num_units; 'auto_select' implies 'skip_input' when
      input_size == num_units; otherwise, it implies 'linear_input'.
    direction: An optional `string` from: `"unidirectional", "bidirectional"`. Defaults to `"unidirectional"`.
      Indicates whether a bidirectional model will be used.
          dir = (direction == bidirectional) ? 2 : 1

      Note that the params buffer may not be compatible across different GPUs. So any
      save and restoration should be converted to and from the canonical weights and
      biases.
    name: A name for the operation (optional).

  Returns:
    The created Operation.
  """
  result = _op_def_lib.apply_op("CudnnRNNParamsFromCanonical",
                                num_layers=num_layers, num_units=num_units,
                                input_size=input_size, params=params,
                                canonical_weights=canonical_weights,
                                canonical_biases=canonical_biases, N=N,
                                rnn_mode=rnn_mode, input_mode=input_mode,
                                direction=direction, name=name)
  return result


ops.RegisterShape("CudnnRNNParamsFromCanonical")(None)
_cudnn_rnn_params_size_outputs = ["params_size"]


def cudnn_rnn_params_size(num_layers, num_units, input_size, T, S,
                          rnn_mode=None, input_mode=None, direction=None,
                          name=None):
  r"""Return the params size that can be used by the Cudnn RNN model. Subsequent

  weight allocation and initialization should use this size.

  Args:
    num_layers: A `Tensor` of type `int32`.
      Specifies the number of layers in the RNN model.
    num_units: A `Tensor` of type `int32`.
      Specifies the size of the hidden state.
    input_size: A `Tensor` of type `int32`.
      Specifies the size of the input state.
    T: A `tf.DType` from: `tf.float32`.
    S: A `tf.DType` from: `tf.int32, tf.int64`.
    rnn_mode: An optional `string` from: `"rnn_relu", "rnn_tanh", "lstm", "gru"`. Defaults to `"lstm"`.
      Indicates the type of the RNN model.
    input_mode: An optional `string` from: `"linear_input", "skip_input", "auto_select"`. Defaults to `"auto_select"`.
      Indicate whether there is a linear projection between the input and
      The actual computation before the first layer. 'skip_input' is only allowed
      when input_size == num_units; 'auto_select' implies 'skip_input' when
      input_size == num_units; otherwise, it implies 'linear_input'.
    direction: An optional `string` from: `"unidirectional", "bidirectional"`. Defaults to `"unidirectional"`.
      Indicates whether a bidirectional model will be used.
      dir = (direction == bidirectional) ? 2 : 1
    name: A name for the operation (optional).

  Returns:
    A `Tensor` of type `S`.
    The size of the params buffer that should be allocated and
        initialized for this RNN model. Note that this params buffer may not be
        compatible across GPUs. Please use CudnnRNNParamsWeights and
        CudnnRNNParamsBiases to save and restore them in a way that is compatible
        across different runs.

    Note that the params buffer may not be compatible across different GPUs. So any
    save and restoration should be converted to and from the canonical weights and
    biases.
  """
  result = _op_def_lib.apply_op("CudnnRNNParamsSize", num_layers=num_layers,
                                num_units=num_units, input_size=input_size,
                                T=T, S=S, rnn_mode=rnn_mode,
                                input_mode=input_mode, direction=direction,
                                name=name)
  return result


ops.RegisterShape("CudnnRNNParamsSize")(None)
_cudnn_rnn_params_to_canonical_outputs = ["canonical_weights",
                                         "canonical_biases"]


_CudnnRNNParamsToCanonicalOutput = collections.namedtuple("CudnnRNNParamsToCanonical",
                                                          _cudnn_rnn_params_to_canonical_outputs)


def cudnn_rnn_params_to_canonical(num_layers, num_units, input_size, params,
                                  N, rnn_mode=None, input_mode=None,
                                  direction=None, name=None):
  r"""Retrieves a set of weights from the opaque params buffer that can be saved and

  restored in a way compatible with future runs.

  Args:
    num_layers: A `Tensor` of type `int32`.
    num_units: A `Tensor` of type `int32`.
    input_size: A `Tensor` of type `int32`.
    params: A `Tensor`. Must be one of the following types: `float32`.
    N: An `int` that is `>= 1`.
    rnn_mode: An optional `string` from: `"rnn_relu", "rnn_tanh", "lstm", "gru"`. Defaults to `"lstm"`.
      Indicates the type of the RNN model.
    input_mode: An optional `string` from: `"linear_input", "skip_input", "auto_select"`. Defaults to `"auto_select"`.
      Indicate whether there is a linear projection between the input and
      The actual computation before the first layer. 'skip_input' is only allowed
      when input_size == num_units; 'auto_select' implies 'skip_input' when
      input_size == num_units; otherwise, it implies 'linear_input'.
    direction: An optional `string` from: `"unidirectional", "bidirectional"`. Defaults to `"unidirectional"`.
      Indicates whether a bidirectional model will be used.
          dir = (direction == bidirectional) ? 2 : 1

      Note that the params buffer may not be compatible across different GPUs. So any
      save and restoration should be converted to and from the canonical weights and
      biases.
    name: A name for the operation (optional).

  Returns:
    A tuple of `Tensor` objects (canonical_weights, canonical_biases).
    canonical_weights: A `Tensor`. Has the same type as `params`. the canonical form of weights that can be used for saving
      and restoration. They are more likely to be compatible across different
      generations.
    canonical_biases: A `Tensor`. Has the same type as `params`. the canonical form of biases that can be used for saving and
      restoration. They are more likely to be compatible across different
      generations.
  """
  result = _op_def_lib.apply_op("CudnnRNNParamsToCanonical",
                                num_layers=num_layers, num_units=num_units,
                                input_size=input_size, params=params, N=N,
                                rnn_mode=rnn_mode, input_mode=input_mode,
                                direction=direction, name=name)
  return _CudnnRNNParamsToCanonicalOutput._make(result)


ops.RegisterShape("CudnnRNNParamsToCanonical")(None)
def _InitOpDefLibrary():
  op_list = op_def_pb2.OpList()
  text_format.Merge(_InitOpDefLibrary.op_list_ascii, op_list)
  op_def_registry.register_op_list(op_list)
  op_def_lib = op_def_library.OpDefLibrary()
  op_def_lib.add_op_list(op_list)
  return op_def_lib


_InitOpDefLibrary.op_list_ascii = """op {
  name: "CudnnRNN"
  input_arg {
    name: "input"
    type_attr: "T"
  }
  input_arg {
    name: "input_h"
    type_attr: "T"
  }
  input_arg {
    name: "input_c"
    type_attr: "T"
  }
  input_arg {
    name: "params"
    type_attr: "T"
  }
  output_arg {
    name: "output"
    type_attr: "T"
  }
  output_arg {
    name: "output_h"
    type_attr: "T"
  }
  output_arg {
    name: "output_c"
    type_attr: "T"
  }
  output_arg {
    name: "reserve_space"
    type_attr: "T"
  }
  attr {
    name: "T"
    type: "type"
    allowed_values {
      list {
        type: DT_FLOAT
      }
    }
  }
  attr {
    name: "rnn_mode"
    type: "string"
    default_value {
      s: "lstm"
    }
    allowed_values {
      list {
        s: "rnn_relu"
        s: "rnn_tanh"
        s: "lstm"
        s: "gru"
      }
    }
  }
  attr {
    name: "input_mode"
    type: "string"
    default_value {
      s: "auto_select"
    }
    allowed_values {
      list {
        s: "linear_input"
        s: "skip_input"
        s: "auto_select"
      }
    }
  }
  attr {
    name: "direction"
    type: "string"
    default_value {
      s: "unidirectional"
    }
    allowed_values {
      list {
        s: "unidirectional"
        s: "bidirectional"
      }
    }
  }
  attr {
    name: "dropout"
    type: "float"
  }
  attr {
    name: "seed"
    type: "int"
    default_value {
      i: 0
    }
  }
  attr {
    name: "seed2"
    type: "int"
    default_value {
      i: 0
    }
  }
  attr {
    name: "is_training"
    type: "bool"
    default_value {
      b: true
    }
  }
}
op {
  name: "CudnnRNNBackprop"
  input_arg {
    name: "input"
    type_attr: "T"
  }
  input_arg {
    name: "input_h"
    type_attr: "T"
  }
  input_arg {
    name: "input_c"
    type_attr: "T"
  }
  input_arg {
    name: "params"
    type_attr: "T"
  }
  input_arg {
    name: "output"
    type_attr: "T"
  }
  input_arg {
    name: "output_h"
    type_attr: "T"
  }
  input_arg {
    name: "output_c"
    type_attr: "T"
  }
  input_arg {
    name: "output_backprop"
    type_attr: "T"
  }
  input_arg {
    name: "output_h_backprop"
    type_attr: "T"
  }
  input_arg {
    name: "output_c_backprop"
    type_attr: "T"
  }
  input_arg {
    name: "reserve_space"
    type_attr: "T"
  }
  output_arg {
    name: "input_backprop"
    type_attr: "T"
  }
  output_arg {
    name: "input_h_backprop"
    type_attr: "T"
  }
  output_arg {
    name: "input_c_backprop"
    type_attr: "T"
  }
  output_arg {
    name: "params_backprop"
    type_attr: "T"
  }
  attr {
    name: "T"
    type: "type"
    allowed_values {
      list {
        type: DT_FLOAT
      }
    }
  }
  attr {
    name: "rnn_mode"
    type: "string"
    default_value {
      s: "lstm"
    }
    allowed_values {
      list {
        s: "rnn_relu"
        s: "rnn_tanh"
        s: "lstm"
        s: "gru"
      }
    }
  }
  attr {
    name: "input_mode"
    type: "string"
    default_value {
      s: "auto_select"
    }
    allowed_values {
      list {
        s: "linear_input"
        s: "skip_input"
        s: "auto_select"
      }
    }
  }
  attr {
    name: "direction"
    type: "string"
    default_value {
      s: "unidirectional"
    }
    allowed_values {
      list {
        s: "unidirectional"
        s: "bidirectional"
      }
    }
  }
}
op {
  name: "CudnnRNNParamsFromCanonical"
  input_arg {
    name: "num_layers"
    type: DT_INT32
  }
  input_arg {
    name: "num_units"
    type: DT_INT32
  }
  input_arg {
    name: "input_size"
    type: DT_INT32
  }
  input_arg {
    name: "params"
    type_attr: "T"
    is_ref: true
  }
  input_arg {
    name: "canonical_weights"
    type_attr: "T"
  }
  input_arg {
    name: "canonical_biases"
    type_attr: "T"
  }
  attr {
    name: "T"
    type: "type"
    allowed_values {
      list {
        type: DT_FLOAT
      }
    }
  }
  attr {
    name: "N"
    type: "int"
    has_minimum: true
    minimum: 1
  }
  attr {
    name: "rnn_mode"
    type: "string"
    default_value {
      s: "lstm"
    }
    allowed_values {
      list {
        s: "rnn_relu"
        s: "rnn_tanh"
        s: "lstm"
        s: "gru"
      }
    }
  }
  attr {
    name: "input_mode"
    type: "string"
    default_value {
      s: "auto_select"
    }
    allowed_values {
      list {
        s: "linear_input"
        s: "skip_input"
        s: "auto_select"
      }
    }
  }
  attr {
    name: "direction"
    type: "string"
    default_value {
      s: "unidirectional"
    }
    allowed_values {
      list {
        s: "unidirectional"
        s: "bidirectional"
      }
    }
  }
}
op {
  name: "CudnnRNNParamsSize"
  input_arg {
    name: "num_layers"
    type: DT_INT32
  }
  input_arg {
    name: "num_units"
    type: DT_INT32
  }
  input_arg {
    name: "input_size"
    type: DT_INT32
  }
  output_arg {
    name: "params_size"
    type_attr: "S"
  }
  attr {
    name: "T"
    type: "type"
    allowed_values {
      list {
        type: DT_FLOAT
      }
    }
  }
  attr {
    name: "S"
    type: "type"
    allowed_values {
      list {
        type: DT_INT32
        type: DT_INT64
      }
    }
  }
  attr {
    name: "rnn_mode"
    type: "string"
    default_value {
      s: "lstm"
    }
    allowed_values {
      list {
        s: "rnn_relu"
        s: "rnn_tanh"
        s: "lstm"
        s: "gru"
      }
    }
  }
  attr {
    name: "input_mode"
    type: "string"
    default_value {
      s: "auto_select"
    }
    allowed_values {
      list {
        s: "linear_input"
        s: "skip_input"
        s: "auto_select"
      }
    }
  }
  attr {
    name: "direction"
    type: "string"
    default_value {
      s: "unidirectional"
    }
    allowed_values {
      list {
        s: "unidirectional"
        s: "bidirectional"
      }
    }
  }
}
op {
  name: "CudnnRNNParamsToCanonical"
  input_arg {
    name: "num_layers"
    type: DT_INT32
  }
  input_arg {
    name: "num_units"
    type: DT_INT32
  }
  input_arg {
    name: "input_size"
    type: DT_INT32
  }
  input_arg {
    name: "params"
    type_attr: "T"
  }
  output_arg {
    name: "canonical_weights"
    type_attr: "T"
  }
  output_arg {
    name: "canonical_biases"
    type_attr: "T"
  }
  attr {
    name: "T"
    type: "type"
    allowed_values {
      list {
        type: DT_FLOAT
      }
    }
  }
  attr {
    name: "N"
    type: "int"
    has_minimum: true
    minimum: 1
  }
  attr {
    name: "rnn_mode"
    type: "string"
    default_value {
      s: "lstm"
    }
    allowed_values {
      list {
        s: "rnn_relu"
        s: "rnn_tanh"
        s: "lstm"
        s: "gru"
      }
    }
  }
  attr {
    name: "input_mode"
    type: "string"
    default_value {
      s: "auto_select"
    }
    allowed_values {
      list {
        s: "linear_input"
        s: "skip_input"
        s: "auto_select"
      }
    }
  }
  attr {
    name: "direction"
    type: "string"
    default_value {
      s: "unidirectional"
    }
    allowed_values {
      list {
        s: "unidirectional"
        s: "bidirectional"
      }
    }
  }
}
"""


_op_def_lib = _InitOpDefLibrary()
