
from platform import system
# import subprocess
import crocodile.toolbox as tb
from machineconfig.utils.utils import display_options
from enum import Enum


PROGRAM_PATH = tb.P.tmp().joinpath("shells/python_return_command") + (".ps1" if system() == "Windows" else ".sh")
# needs to be synced with devops.sh and devops.ps1


class Options(Enum):
    update         = 'UPDATE essential repos'
    devaps         = 'DEVAPPS install'
    ve             = 'VE install'
    sym_path_shell = 'SYMLINKS, PATH & SHELL PROFILE'
    sym_new        = 'SYMLINKS new'
    ssh_add_pubkey  = 'SSH add pub key to this machine'
    ssh_add_id     = 'SSH add identity (private key) to this machine'
    ssh_use_pair   = 'SSH use key pair to connect two machines'
    ssh_setup      = 'SSH setup'
    ssh_setup_wsl  = 'SSH setup wsl'
    repos_pull     = 'REPOS pull all'
    repos_commit   = 'REPOS commit all'
    repos_push     = 'REPOS push all'
    backup         = 'BACKUP & RETRIEVE'


def main():
    PROGRAM_PATH.delete(sure=True, verbose=False)
    options = [op.value for op in Options]
    choice_key = display_options(msg="", options=options, header="DEVOPS", default=options[0])

    if choice_key == Options.update.value:
        import machineconfig.scripts.python.devops_update_repos as helper
        program = helper.main()

    elif choice_key == Options.ve.value:
        from machineconfig.jobs.python.python_ve_installer import main
        program = main()

    elif choice_key == Options.devaps.value:
        from machineconfig.scripts.python.devops_devapps_install import main
        program = main()

    elif choice_key == Options.sym_new.value:
        from machineconfig.jobs.python.python_ve_symlink import main
        program = main()

    elif choice_key == Options.sym_path_shell.value:
        from machineconfig.profile.create import main
        main()
        program = "echo 'done with symlinks'"

    elif choice_key == Options.ssh_add_pubkey.value:
        from machineconfig.scripts.python.devops_add_ssh_key import main
        program = main()

    elif choice_key == Options.ssh_use_pair.value:
        raise NotImplementedError

    elif choice_key == Options.ssh_add_id.value:  # so that you can SSH directly withuot pointing to identity key.
        from machineconfig.scripts.python.devops_add_identity import main
        program = main()

    elif choice_key == Options.ssh_setup.value:
        program_windows = f"""Invoke-WebRequest https://raw.githubusercontent.com/thisismygitrepo/machineconfig/main/src/machineconfig/setup_windows/openssh_all.ps1 | Invoke-Expression  # https://github.com/thisismygitrepo.keys"""
        program_linux = f"""curl https://raw.githubusercontent.com/thisismygitrepo/machineconfig/main/src/machineconfig/setup_linux/openssh_all.sh | sudo bash  # https://github.com/thisismygitrepo.keys"""
        program = program_linux if system() == "Linux" else program_windows

    elif choice_key == Options.ssh_setup_wsl.value:
        program = f"""curl https://raw.githubusercontent.com/thisismygitrepo/machineconfig/main/src/machineconfig/setup_linux/openssh_wsl.sh | sudo bash"""

    elif choice_key == Options.backup.value:
        from machineconfig.scripts.python.devops_backup_retrieve import main
        program = main()

    elif choice_key == Options.repos_pull.value:
        from machineconfig.jobs.python.repos import pull_all
        program = pull_all()

    elif choice_key == Options.repos_push.value:
        from machineconfig.jobs.python.repos import push_all
        program = push_all()

    elif choice_key == Options.repos_commit.value:
        from machineconfig.jobs.python.repos import commit_all
        program = commit_all()

    else:
        raise ValueError(f"Unimplemented choice: {choice_key}")

    print(f"Executing {PROGRAM_PATH}")
    if system() == 'Windows':
        PROGRAM_PATH.create(parents_only=True).write_text(program)
    else:
        PROGRAM_PATH.create(parents_only=True).write_text(f"{program}")


if __name__ == "__main__":
    main()
