/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths;

import JSci.GlobalSettings;
import JSci.maths.AbstractMath;
import JSci.maths.Complex;
import JSci.maths.ComplexMapping;
import JSci.maths.Mapping;

public final class ArrayMath
extends AbstractMath {
    private ArrayMath() {
    }

    public static boolean isSquare(double[][] dArray) {
        for (int i = 0; i < dArray.length; ++i) {
            if (dArray[i].length == dArray.length) continue;
            return false;
        }
        return true;
    }

    public static boolean isSquare(int[][] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i].length == nArray.length) continue;
            return false;
        }
        return true;
    }

    public static boolean isSquare(Object[][] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i].length == objectArray.length) continue;
            return false;
        }
        return true;
    }

    public static double[] apply(Mapping mapping, double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = mapping.map(dArray[i]);
        }
        return dArray2;
    }

    public static double[][] apply(Mapping mapping, double[][] dArray) {
        double[][] dArrayArray = new double[dArray.length][];
        for (int i = 0; i < dArray.length; ++i) {
            dArrayArray[i] = ArrayMath.apply(mapping, dArray[i]);
        }
        return dArrayArray;
    }

    public static Complex[] apply(ComplexMapping complexMapping, Complex[] complexArray) {
        Complex[] complexArray2 = new Complex[complexArray.length];
        for (int i = 0; i < complexArray.length; ++i) {
            complexArray2[i] = complexMapping.map(complexArray[i]);
        }
        return complexArray2;
    }

    public static Complex[][] apply(ComplexMapping complexMapping, Complex[][] complexArray) {
        Complex[][] complexArray2 = new Complex[complexArray.length][];
        for (int i = 0; i < complexArray.length; ++i) {
            complexArray2[i] = ArrayMath.apply(complexMapping, complexArray[i]);
        }
        return complexArray2;
    }

    public static double[] normalize(double[] dArray) {
        return ArrayMath.scalarMultiply(1.0 / ArrayMath.norm(dArray), dArray);
    }

    public static double[] setLengthFromEnd(double[] dArray, int n) {
        double[] dArray2 = new double[n];
        int n2 = n - dArray.length < 0 ? dArray.length - n : 0;
        System.arraycopy(dArray, n2, dArray2, -dArray.length + n + n2, dArray.length - n2);
        return dArray2;
    }

    public static double[] setLengthFromBeginning(double[] dArray, int n) {
        double[] dArray2 = new double[n];
        int n2 = n - dArray.length < 0 ? dArray.length - n : 0;
        System.arraycopy(dArray, 0, dArray2, 0, dArray.length - n2);
        return dArray2;
    }

    public static double[] copy(double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        System.arraycopy(dArray, 0, dArray2, 0, dArray.length);
        return dArray2;
    }

    public static double[][] copy(double[][] dArray) {
        double[][] dArrayArray = new double[dArray.length][];
        for (int i = 0; i < dArray.length; ++i) {
            dArrayArray[i] = ArrayMath.copy(dArray[i]);
        }
        return dArrayArray;
    }

    public static double variance(double[] dArray) {
        double d = ArrayMath.mean(dArray);
        double d2 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d2 += (dArray[i] - d) * (dArray[i] - d);
        }
        return d2 / (double)(dArray.length - 1);
    }

    public static double covariance(double[] dArray, double[] dArray2) {
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException("Arrays must have the same length : " + dArray.length + ", " + dArray2.length);
        }
        double d = ArrayMath.mean(dArray);
        double d2 = ArrayMath.mean(dArray2);
        double d3 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d3 += (dArray[i] - d) * (dArray2[i] - d2);
        }
        return d3 / (double)(dArray.length - 1);
    }

    public static double correlation(double[] dArray, double[] dArray2) {
        double d = Math.sqrt(ArrayMath.variance(dArray) * ArrayMath.variance(dArray2));
        if (d != 0.0) {
            return ArrayMath.covariance(dArray, dArray2) / d;
        }
        if (ArrayMath.variance(dArray) == 0.0 && ArrayMath.variance(dArray2) == 0.0) {
            return 1.0;
        }
        return 0.0;
    }

    public static double mean(double[] dArray) {
        if (dArray.length == 0) {
            throw new IllegalArgumentException("Nothing to compute! The array must have at least one element.");
        }
        return ArrayMath.mass(dArray) / (double)dArray.length;
    }

    public static double standardDeviation(double[] dArray) {
        return Math.sqrt(ArrayMath.variance(dArray));
    }

    public static double[] sortMinToMax(double[] dArray) {
        double[] dArray2 = ArrayMath.copy(dArray);
        ArrayMath.quickSortMinToMax(dArray2, 0, dArray2.length - 1);
        return dArray2;
    }

    public static double[] sortMaxToMin(double[] dArray) {
        double[] dArray2 = ArrayMath.copy(dArray);
        ArrayMath.quickSortMaxToMin(dArray2, 0, dArray2.length - 1);
        return dArray2;
    }

    public static double percentile(double[] dArray, double d) {
        return ArrayMath.percentile(dArray, d, false);
    }

    public static double percentile(double[] dArray, double d, boolean bl) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("Percentile must be between 0 and 1 : " + d);
        }
        double[] dArray2 = bl ? dArray : ArrayMath.sortMinToMax(dArray);
        int n = (int)Math.floor(d * (double)(dArray2.length - 1));
        double d2 = d * (double)(dArray2.length - 1) - Math.floor(d * (double)(dArray2.length - 1));
        if (n == dArray2.length - 1) {
            return dArray2[dArray2.length - 1];
        }
        return dArray2[n] * (1.0 - d2) + dArray2[n + 1] * d2;
    }

    public static double median(double[] dArray) {
        if (dArray.length == 3) {
            return ArrayMath.median3(ArrayMath.copy(dArray));
        }
        if (dArray.length == 5) {
            return ArrayMath.median5(ArrayMath.copy(dArray));
        }
        if (dArray.length == 7) {
            return ArrayMath.median7(ArrayMath.copy(dArray));
        }
        if (dArray.length % 2 == 1) {
            return ArrayMath.quickSelect(ArrayMath.copy(dArray), false);
        }
        double[] dArray2 = ArrayMath.copy(dArray);
        double d = ArrayMath.quickSelect(dArray2, false);
        double d2 = ArrayMath.quickSelect(dArray2, true);
        return (d + d2) / 2.0;
    }

    private static void sortInPlace(double[] dArray, int n, int n2) {
        if (dArray[n] > dArray[n2]) {
            double d = dArray[n];
            dArray[n] = dArray[n2];
            dArray[n2] = d;
        }
    }

    private static double median3(double[] dArray) {
        ArrayMath.sortInPlace(dArray, 0, 1);
        ArrayMath.sortInPlace(dArray, 1, 2);
        ArrayMath.sortInPlace(dArray, 0, 1);
        return dArray[1];
    }

    private static double median5(double[] dArray) {
        ArrayMath.sortInPlace(dArray, 0, 1);
        ArrayMath.sortInPlace(dArray, 3, 4);
        ArrayMath.sortInPlace(dArray, 0, 3);
        ArrayMath.sortInPlace(dArray, 1, 4);
        ArrayMath.sortInPlace(dArray, 1, 2);
        ArrayMath.sortInPlace(dArray, 2, 3);
        ArrayMath.sortInPlace(dArray, 1, 2);
        return dArray[2];
    }

    private static double median7(double[] dArray) {
        ArrayMath.sortInPlace(dArray, 0, 5);
        ArrayMath.sortInPlace(dArray, 0, 3);
        ArrayMath.sortInPlace(dArray, 1, 6);
        ArrayMath.sortInPlace(dArray, 2, 4);
        ArrayMath.sortInPlace(dArray, 0, 1);
        ArrayMath.sortInPlace(dArray, 3, 5);
        ArrayMath.sortInPlace(dArray, 2, 6);
        ArrayMath.sortInPlace(dArray, 2, 3);
        ArrayMath.sortInPlace(dArray, 3, 6);
        ArrayMath.sortInPlace(dArray, 4, 5);
        ArrayMath.sortInPlace(dArray, 1, 4);
        ArrayMath.sortInPlace(dArray, 1, 3);
        ArrayMath.sortInPlace(dArray, 3, 4);
        return dArray[3];
    }

    private static double quickSelect(double[] dArray, boolean bl) {
        int n;
        int n2 = 0;
        int n3 = dArray.length - 1;
        int n4 = n = bl ? n3 / 2 + 1 : n3 / 2;
        while (n3 > n2) {
            if (n3 == n2 + 1) {
                if (dArray[n2] > dArray[n3]) {
                    ArrayMath.swap(dArray, n2, n3);
                }
                return dArray[n];
            }
            int n5 = (n2 + n3) / 2;
            if (dArray[n5] > dArray[n3]) {
                ArrayMath.swap(dArray, n5, n3);
            }
            if (dArray[n2] > dArray[n3]) {
                ArrayMath.swap(dArray, n2, n3);
            }
            if (dArray[n5] > dArray[n2]) {
                ArrayMath.swap(dArray, n5, n2);
            }
            ArrayMath.swap(dArray, n5, n2 + 1);
            int n6 = n2 + 1;
            int n7 = n3;
            while (true) {
                if (dArray[n2] > dArray[++n6]) {
                    continue;
                }
                while (dArray[--n7] > dArray[n2]) {
                }
                if (n7 < n6) break;
                ArrayMath.swap(dArray, n6, n7);
            }
            ArrayMath.swap(dArray, n2, n7);
            if (n7 <= n) {
                n2 = n6;
            }
            if (n7 < n) continue;
            n3 = n7 - 1;
        }
        return dArray[n];
    }

    public static boolean equals(double[] dArray, double[] dArray2) {
        if (dArray.length != dArray2.length) {
            return false;
        }
        for (int i = 0; i < dArray.length; ++i) {
            if (!(Math.abs(dArray[i] - dArray2[i]) > GlobalSettings.ZERO_TOL)) continue;
            return false;
        }
        return true;
    }

    public static double[] abs(double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = Math.abs(dArray[i]);
        }
        return dArray2;
    }

    public static double[][] abs(double[][] dArray) {
        double[][] dArrayArray = new double[dArray.length][];
        for (int i = 0; i < dArray.length; ++i) {
            dArrayArray[i] = ArrayMath.abs(dArray[i]);
        }
        return dArrayArray;
    }

    public static double max(double[] dArray) {
        double d = dArray[0];
        for (int i = 1; i < dArray.length; ++i) {
            if (!(d < dArray[i])) continue;
            d = dArray[i];
        }
        return d;
    }

    public static double max(double[][] dArray) {
        double d = ArrayMath.max(dArray[0]);
        for (int i = 1; i < dArray.length; ++i) {
            if (!(d < ArrayMath.max(dArray[i]))) continue;
            d = ArrayMath.max(dArray[i]);
        }
        return d;
    }

    public static double min(double[] dArray) {
        double d = dArray[0];
        for (int i = 1; i < dArray.length; ++i) {
            if (!(d > dArray[i])) continue;
            d = dArray[i];
        }
        return d;
    }

    public static double min(double[][] dArray) {
        double d = ArrayMath.min(dArray[0]);
        for (int i = 1; i < dArray.length; ++i) {
            if (!(d > ArrayMath.min(dArray[i]))) continue;
            d = ArrayMath.min(dArray[i]);
        }
        return d;
    }

    public static double[] mod(Complex[] complexArray) {
        double[] dArray = new double[complexArray.length];
        for (int i = 0; i < complexArray.length; ++i) {
            dArray[i] = complexArray[i].mod();
        }
        return dArray;
    }

    public static double[][] mod(Complex[][] complexArray) {
        double[][] dArrayArray = new double[complexArray.length][];
        for (int i = 0; i < complexArray.length; ++i) {
            dArrayArray[i] = ArrayMath.mod(complexArray[i]);
        }
        return dArrayArray;
    }

    public static double sumModSqrs(Complex[] complexArray) {
        double d = 0.0;
        for (int i = 0; i < complexArray.length; ++i) {
            d += complexArray[i].modSqr();
        }
        return d;
    }

    public static double sumModSqrs(Complex[][] complexArray) {
        double d = 0.0;
        for (int i = 0; i < complexArray.length; ++i) {
            d += ArrayMath.sumModSqrs(complexArray[i]);
        }
        return d;
    }

    public static double norm(double[] dArray) {
        return Math.sqrt(ArrayMath.sumSquares(dArray));
    }

    public static double sumSquares(double[] dArray) {
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += dArray[i] * dArray[i];
        }
        return d;
    }

    public static double sumSquares(double[][] dArray) {
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[i].length; ++j) {
                d += dArray[i][j] * dArray[i][j];
            }
        }
        return d;
    }

    public static double scalarProduct(double[] dArray, double[] dArray2) {
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException("Arrays must have the same length : " + dArray.length + ", " + dArray2.length);
        }
        if (dArray.length == 0) {
            throw new IllegalArgumentException("Nothing to compute! Arrays must have at least one element.");
        }
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += dArray[i] * dArray2[i];
        }
        return d;
    }

    public static double scalarProduct(double[][] dArray, double[][] dArray2) {
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException("Arrays must have the same length : " + dArray.length + ", " + dArray2.length);
        }
        if (dArray.length == 0) {
            throw new IllegalArgumentException("Nothing to compute! Arrays must have at least one element.");
        }
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += ArrayMath.scalarProduct(dArray[i], dArray2[i]);
        }
        return d;
    }

    public static double[] extract(int n, int n2, double[] dArray) {
        if (n < 0 || n2 < 0 || n > dArray.length - 1 || n2 > dArray.length - 1) {
            throw new IllegalArgumentException("The parameters are incorrect : " + n + ", " + n2 + ", " + dArray.length);
        }
        if (n2 > n) {
            double[] dArray2 = new double[n2 - n + 1];
            System.arraycopy(dArray, n, dArray2, 0, n2 - n + 1);
            return dArray2;
        }
        double[] dArray3 = new double[-n2 + n + 1];
        for (int i = n2; i <= n; ++i) {
            dArray3[n - i] = dArray[i];
        }
        return dArray3;
    }

    public static double[] invert(double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[dArray.length - 1 - i] = dArray[i];
        }
        return dArray2;
    }

    public static double[] padding(int n, int n2, double[] dArray) {
        if (dArray.length + n2 > n || n2 < 0) {
            throw new IllegalArgumentException("Array is to long for this : " + n + ", " + n2 + ", " + dArray.length);
        }
        double[] dArray2 = new double[n];
        System.arraycopy(dArray, 0, dArray2, n2, dArray.length);
        return dArray2;
    }

    public static double[] add(double[] dArray, double d, double[] dArray2, int n) {
        if (dArray2.length > dArray.length) {
            throw new IllegalArgumentException("Second array must be shorter or equal to the first one : " + dArray.length + ", " + dArray2.length);
        }
        double[] dArray3 = ArrayMath.copy(dArray);
        for (int i = n; i < n + dArray2.length; ++i) {
            int n2 = i;
            dArray3[n2] = dArray3[n2] + d * dArray2[i - n];
        }
        return dArray3;
    }

    public static double[] add(double[] dArray, double d) {
        double[] dArray2 = ArrayMath.copy(dArray);
        int n = 0;
        while (n < dArray2.length) {
            int n2 = n++;
            dArray2[n2] = dArray2[n2] + d;
        }
        return dArray2;
    }

    public static double[][] transpose(double[][] dArray) {
        double[][] dArray2 = new double[dArray[0].length][dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            if (dArray[i].length != dArray[0].length) {
                throw new IllegalArgumentException("The array is not a matrix.");
            }
            for (int j = 0; j < dArray[0].length; ++j) {
                dArray2[j][i] = dArray[i][j];
            }
        }
        return dArray2;
    }

    public static double[] range(double d, double d2, double d3) {
        if (d3 <= 0.0) {
            throw new IllegalArgumentException("The argument step should be positive: " + d3 + " < 0");
        }
        if (d == d2) {
            double[] dArray = new double[]{d};
            return dArray;
        }
        int n = new Double(Math.abs(d - d2) / d3).intValue() + 1;
        double[] dArray = new double[n];
        dArray[0] = d;
        if (d > d2) {
            d3 = -d3;
        }
        for (int i = 1; i < n; ++i) {
            dArray[i] = dArray[i - 1] + d3;
        }
        return dArray;
    }

    public static double[] range(double d, double d2) {
        return ArrayMath.range(d, d2, 1.0);
    }

    public static double[] range(double d) {
        return ArrayMath.range(0.0, d);
    }

    public static double[] add(double[] dArray, double[] dArray2) {
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException("To add two arrays, they must have the same length : " + dArray.length + ", " + dArray2.length);
        }
        double[] dArray3 = ArrayMath.copy(dArray);
        for (int i = 0; i < dArray.length; ++i) {
            int n = i;
            dArray3[n] = dArray3[n] + dArray2[i];
        }
        return dArray3;
    }

    public static double[] subtract(double[] dArray, double[] dArray2) {
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException("To add two arrays, they must have the same length : " + dArray.length + ", " + dArray2.length);
        }
        double[] dArray3 = ArrayMath.copy(dArray);
        for (int i = 0; i < dArray.length; ++i) {
            int n = i;
            dArray3[n] = dArray3[n] - dArray2[i];
        }
        return dArray3;
    }

    public static double[] scalarMultiply(double d, double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = d * dArray[i];
        }
        return dArray2;
    }

    public static String toString(double[] dArray) {
        int n;
        StringBuffer stringBuffer = new StringBuffer(dArray.length);
        for (n = 0; n < dArray.length - 1; ++n) {
            stringBuffer.append(dArray[n]);
            stringBuffer.append(',');
        }
        stringBuffer.append(dArray[n]);
        return stringBuffer.toString();
    }

    public static String toString(double[][] dArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < dArray.length; ++i) {
            stringBuffer.append(ArrayMath.toString(dArray[i]));
            stringBuffer.append(System.getProperty("line.separator"));
        }
        return stringBuffer.toString();
    }

    public static double mass(double[] dArray) {
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += dArray[i];
        }
        return d;
    }

    public static double[] scalarMultiplyFast(double d, double[] dArray) {
        if (d == 0.0) {
            return new double[dArray.length];
        }
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = d != 0.0 && dArray[i] != 0.0 ? dArray[i] * d : 0.0;
        }
        return dArray2;
    }

    public static void print(double[] dArray) {
        for (int i = 0; i < dArray.length; ++i) {
            System.out.println("array [" + i + "] = " + dArray[i]);
        }
    }

    public static void print(double[][] dArray) {
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[i].length; ++j) {
                System.out.println("array [" + i + "][" + j + "] = " + dArray[i][j]);
            }
        }
    }

    public static int[] setLengthFromEnd(int[] nArray, int n) {
        int[] nArray2 = new int[n];
        int n2 = n - nArray.length < 0 ? nArray.length - n : 0;
        System.arraycopy(nArray, n2, nArray2, -nArray.length + n + n2, nArray.length - n2);
        return nArray2;
    }

    public static int[] setLengthFromBeginning(int[] nArray, int n) {
        int[] nArray2 = new int[n];
        int n2 = n - nArray.length < 0 ? nArray.length - n : 0;
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length - n2);
        return nArray2;
    }

    public static int[] copy(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        return nArray2;
    }

    public static int[][] copy(int[][] nArray) {
        int[][] nArrayArray = new int[nArray.length][];
        for (int i = 0; i < nArray.length; ++i) {
            nArrayArray[i] = ArrayMath.copy(nArray[i]);
        }
        return nArrayArray;
    }

    public static double variance(int[] nArray) {
        double d = ArrayMath.mean(nArray);
        double d2 = 0.0;
        for (int i = 0; i < nArray.length; ++i) {
            d2 += ((double)nArray[i] - d) * ((double)nArray[i] - d);
        }
        return d2 / (double)(nArray.length - 1);
    }

    public static double covariance(int[] nArray, int[] nArray2) {
        if (nArray.length != nArray2.length) {
            throw new IllegalArgumentException("Arrays must have the same length : " + nArray.length + ", " + nArray2.length);
        }
        double d = ArrayMath.mean(nArray);
        double d2 = ArrayMath.mean(nArray2);
        double d3 = 0.0;
        for (int i = 0; i < nArray.length; ++i) {
            d3 += ((double)nArray[i] - d) * ((double)nArray2[i] - d2);
        }
        return d3 / (double)(nArray.length - 1);
    }

    public static double correlation(int[] nArray, int[] nArray2) {
        double d = Math.sqrt(ArrayMath.variance(nArray) * ArrayMath.variance(nArray2));
        if (d != 0.0) {
            return ArrayMath.covariance(nArray, nArray2) / d;
        }
        if (ArrayMath.variance(nArray) == 0.0 && ArrayMath.variance(nArray2) == 0.0) {
            return 1.0;
        }
        return 0.0;
    }

    public static double mean(int[] nArray) {
        if (nArray.length == 0) {
            throw new IllegalArgumentException("Nothing to compute! The array must have at least one element.");
        }
        return (double)ArrayMath.mass(nArray) / (double)nArray.length;
    }

    public static double standardDeviation(int[] nArray) {
        return Math.sqrt(ArrayMath.variance(nArray));
    }

    public static int[] sortMinToMax(int[] nArray) {
        int[] nArray2 = ArrayMath.copy(nArray);
        ArrayMath.quickSortMinToMax(nArray2, 0, nArray2.length - 1);
        return nArray2;
    }

    public static int[] sortMaxToMin(int[] nArray) {
        int[] nArray2 = ArrayMath.copy(nArray);
        ArrayMath.quickSortMaxToMin(nArray2, 0, nArray2.length - 1);
        return nArray2;
    }

    public static String toString(int[] nArray) {
        int n;
        StringBuffer stringBuffer = new StringBuffer(nArray.length);
        for (n = 0; n < nArray.length - 1; ++n) {
            stringBuffer.append(nArray[n]);
            stringBuffer.append(',');
        }
        stringBuffer.append(nArray[n]);
        return stringBuffer.toString();
    }

    public static String toString(int[][] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < nArray.length; ++i) {
            stringBuffer.append(ArrayMath.toString(nArray[i]));
            stringBuffer.append(System.getProperty("line.separator"));
        }
        return stringBuffer.toString();
    }

    public static double percentile(int[] nArray, double d) {
        return ArrayMath.percentile(nArray, d, false);
    }

    public static double percentile(int[] nArray, double d, boolean bl) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("Percentile must be between 0 and 1 : " + d);
        }
        int[] nArray2 = bl ? nArray : ArrayMath.sortMinToMax(nArray);
        int n = (int)Math.floor(d * (double)(nArray2.length - 1));
        double d2 = d * (double)(nArray2.length - 1) - Math.floor(d * (double)(nArray2.length - 1));
        if (n == nArray2.length - 1) {
            return nArray2[nArray2.length - 1];
        }
        return (double)nArray2[n] * (1.0 - d2) + (double)nArray2[n + 1] * d2;
    }

    public static int median(int[] nArray) {
        if (nArray.length == 3) {
            return ArrayMath.median3(ArrayMath.copy(nArray));
        }
        if (nArray.length == 5) {
            return ArrayMath.median5(ArrayMath.copy(nArray));
        }
        if (nArray.length == 7) {
            return ArrayMath.median7(ArrayMath.copy(nArray));
        }
        return ArrayMath.quickSelect(ArrayMath.copy(nArray));
    }

    private static void sortInPlace(int[] nArray, int n, int n2) {
        if (nArray[n] > nArray[n2]) {
            int n3 = nArray[n];
            nArray[n] = nArray[n2];
            nArray[n2] = n3;
        }
    }

    private static int median3(int[] nArray) {
        ArrayMath.sortInPlace(nArray, 0, 1);
        ArrayMath.sortInPlace(nArray, 1, 2);
        ArrayMath.sortInPlace(nArray, 0, 1);
        return nArray[1];
    }

    private static int median5(int[] nArray) {
        ArrayMath.sortInPlace(nArray, 0, 1);
        ArrayMath.sortInPlace(nArray, 3, 4);
        ArrayMath.sortInPlace(nArray, 0, 3);
        ArrayMath.sortInPlace(nArray, 1, 4);
        ArrayMath.sortInPlace(nArray, 1, 2);
        ArrayMath.sortInPlace(nArray, 2, 3);
        ArrayMath.sortInPlace(nArray, 1, 2);
        return nArray[2];
    }

    private static int median7(int[] nArray) {
        ArrayMath.sortInPlace(nArray, 0, 5);
        ArrayMath.sortInPlace(nArray, 0, 3);
        ArrayMath.sortInPlace(nArray, 1, 6);
        ArrayMath.sortInPlace(nArray, 2, 4);
        ArrayMath.sortInPlace(nArray, 0, 1);
        ArrayMath.sortInPlace(nArray, 3, 5);
        ArrayMath.sortInPlace(nArray, 2, 6);
        ArrayMath.sortInPlace(nArray, 2, 3);
        ArrayMath.sortInPlace(nArray, 3, 6);
        ArrayMath.sortInPlace(nArray, 4, 5);
        ArrayMath.sortInPlace(nArray, 1, 4);
        ArrayMath.sortInPlace(nArray, 1, 3);
        ArrayMath.sortInPlace(nArray, 3, 4);
        return nArray[3];
    }

    private static int quickSelect(int[] nArray) {
        int n = 0;
        int n2 = nArray.length - 1;
        int n3 = n2 / 2;
        while (n2 > n) {
            if (n2 == n + 1) {
                if (nArray[n] > nArray[n2]) {
                    ArrayMath.swap(nArray, n, n2);
                }
                return nArray[n3];
            }
            int n4 = (n + n2) / 2;
            if (nArray[n4] > nArray[n2]) {
                ArrayMath.swap(nArray, n4, n2);
            }
            if (nArray[n] > nArray[n2]) {
                ArrayMath.swap(nArray, n, n2);
            }
            if (nArray[n4] > nArray[n]) {
                ArrayMath.swap(nArray, n4, n);
            }
            ArrayMath.swap(nArray, n4, n + 1);
            int n5 = n + 1;
            int n6 = n2;
            while (true) {
                if (nArray[n] > nArray[++n5]) {
                    continue;
                }
                while (nArray[--n6] > nArray[n]) {
                }
                if (n6 < n5) break;
                ArrayMath.swap(nArray, n5, n6);
            }
            ArrayMath.swap(nArray, n, n6);
            if (n6 <= n3) {
                n = n5;
            }
            if (n6 < n3) continue;
            n2 = n6 - 1;
        }
        return nArray[n3];
    }

    public static boolean equals(int[] nArray, int[] nArray2) {
        if (nArray.length != nArray2.length) {
            return false;
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == nArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static int[] abs(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[i] = Math.abs(nArray[i]);
        }
        return nArray2;
    }

    public static int[][] abs(int[][] nArray) {
        int[][] nArrayArray = new int[nArray.length][];
        for (int i = 0; i < nArray.length; ++i) {
            nArrayArray[i] = ArrayMath.abs(nArray[i]);
        }
        return nArrayArray;
    }

    public static int max(int[] nArray) {
        int n = nArray[0];
        for (int i = 1; i < nArray.length; ++i) {
            if (n >= nArray[i]) continue;
            n = nArray[i];
        }
        return n;
    }

    public static int max(int[][] nArray) {
        int n = ArrayMath.max(nArray[0]);
        for (int i = 1; i < nArray.length; ++i) {
            if (n >= ArrayMath.max(nArray[i])) continue;
            n = ArrayMath.max(nArray[i]);
        }
        return n;
    }

    public static int min(int[] nArray) {
        int n = nArray[0];
        for (int i = 1; i < nArray.length; ++i) {
            if (n <= nArray[i]) continue;
            n = nArray[i];
        }
        return n;
    }

    public static int min(int[][] nArray) {
        int n = ArrayMath.min(nArray[0]);
        for (int i = 1; i < nArray.length; ++i) {
            if (n <= ArrayMath.min(nArray[i])) continue;
            n = ArrayMath.min(nArray[i]);
        }
        return n;
    }

    public static double norm(int[] nArray) {
        return Math.sqrt(ArrayMath.sumSquares(nArray));
    }

    public static int sumSquares(int[] nArray) {
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            n += nArray[i] * nArray[i];
        }
        return n;
    }

    public static int sumSquares(int[][] nArray) {
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray[i].length; ++j) {
                n += nArray[i][j] * nArray[i][j];
            }
        }
        return n;
    }

    public static int scalarProduct(int[] nArray, int[] nArray2) {
        if (nArray.length != nArray2.length) {
            throw new IllegalArgumentException("Arrays must have the same length : " + nArray.length + ", " + nArray2.length);
        }
        if (nArray.length == 0) {
            throw new IllegalArgumentException("Nothing to compute! Arrays must have at least one element.");
        }
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            n += nArray[i] * nArray2[i];
        }
        return n;
    }

    public static double scalarProduct(int[][] nArray, int[][] nArray2) {
        if (nArray.length != nArray2.length) {
            throw new IllegalArgumentException("Arrays must have the same length : " + nArray.length + ", " + nArray2.length);
        }
        if (nArray.length == 0) {
            throw new IllegalArgumentException("Nothing to compute! Arrays must have at least one element.");
        }
        double d = 0.0;
        for (int i = 0; i < nArray.length; ++i) {
            d += (double)ArrayMath.scalarProduct(nArray[i], nArray2[i]);
        }
        return d;
    }

    public static int[] extract(int n, int n2, int[] nArray) {
        if (n < 0 || n2 < 0 || n > nArray.length - 1 || n2 > nArray.length - 1) {
            throw new IllegalArgumentException("The parameters are incorrect : " + n + ", " + n2 + ", " + nArray.length);
        }
        if (n2 > n) {
            int[] nArray2 = new int[n2 - n + 1];
            System.arraycopy(nArray, n, nArray2, 0, n2 - n + 1);
            return nArray2;
        }
        int[] nArray3 = new int[-n2 + n + 1];
        for (int i = n2; i <= n; ++i) {
            nArray3[n - i] = nArray[i];
        }
        return nArray3;
    }

    public static int[] invert(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[nArray.length - 1 - i] = nArray[i];
        }
        return nArray2;
    }

    public static int[] padding(int n, int n2, int[] nArray) {
        if (nArray.length + n2 > n || n2 < 0) {
            throw new IllegalArgumentException("The array is too long for this : " + n + ", " + n2 + ", " + nArray.length);
        }
        int[] nArray2 = new int[n];
        System.arraycopy(nArray, 0, nArray2, n2, nArray.length);
        return nArray2;
    }

    public static int[] add(int[] nArray, double d, int[] nArray2, int n) {
        if (nArray2.length > nArray.length) {
            throw new IllegalArgumentException("Second array must be shorter or equal to the first one : " + nArray.length + ", " + nArray2.length);
        }
        int[] nArray3 = ArrayMath.copy(nArray);
        for (int i = n; i < n + nArray2.length; ++i) {
            int n2 = i;
            nArray3[n2] = (int)((double)nArray3[n2] + d * (double)nArray2[i - n]);
        }
        return nArray3;
    }

    public static int[] add(int[] nArray, int n) {
        int[] nArray2 = ArrayMath.copy(nArray);
        int n2 = 0;
        while (n2 < nArray2.length) {
            int n3 = n2++;
            nArray2[n3] = nArray2[n3] + n;
        }
        return nArray2;
    }

    public static int[] range(int n, int n2) {
        return ArrayMath.range(n, n2, 1);
    }

    public static int[] range(int n) {
        return ArrayMath.range(0, n);
    }

    public static int[] range(int n, int n2, int n3) {
        if (n3 <= 0) {
            throw new IllegalArgumentException("The argument step should be positive: " + n3 + " < 0");
        }
        if (n == n2) {
            int[] nArray = new int[]{n};
            return nArray;
        }
        int n4 = new Double(Math.abs(n - n2) / n3).intValue();
        int[] nArray = new int[n4];
        nArray[0] = n;
        if (n > n2) {
            n3 = -n3;
        }
        for (int i = 1; i < n4; ++i) {
            nArray[i] = nArray[i - 1] + n3;
        }
        return nArray;
    }

    public static int[][] transpose(int[][] nArray) {
        int[][] nArray2 = new int[nArray[0].length][nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i].length != nArray[0].length) {
                throw new IllegalArgumentException("The array is not a matrix.");
            }
            for (int j = 0; j < nArray[0].length; ++j) {
                nArray2[j][i] = nArray[i][j];
            }
        }
        return nArray2;
    }

    public static int[] add(int[] nArray, int[] nArray2) {
        if (nArray.length != nArray2.length) {
            throw new IllegalArgumentException("To add two arrays, they must have the same length : " + nArray.length + ", " + nArray2.length);
        }
        int[] nArray3 = ArrayMath.copy(nArray);
        for (int i = 0; i < nArray.length; ++i) {
            int n = i;
            nArray3[n] = nArray3[n] + nArray2[i];
        }
        return nArray3;
    }

    public static int[] subtract(int[] nArray, int[] nArray2) {
        if (nArray.length != nArray2.length) {
            throw new IllegalArgumentException("To add two arrays, they must have the same length : " + nArray.length + ", " + nArray2.length);
        }
        int[] nArray3 = ArrayMath.copy(nArray);
        for (int i = 0; i < nArray.length; ++i) {
            int n = i;
            nArray3[n] = nArray3[n] - nArray2[i];
        }
        return nArray3;
    }

    public static int mass(int[] nArray) {
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            n += nArray[i];
        }
        return n;
    }

    public static double[] scalarMultiply(double d, int[] nArray) {
        double[] dArray = new double[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            dArray[i] = (double)nArray[i] * d;
        }
        return dArray;
    }

    public static double[] scalarMultiplyFast(double d, int[] nArray) {
        if (d == 0.0) {
            return new double[nArray.length];
        }
        double[] dArray = new double[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            dArray[i] = d != 0.0 && nArray[i] != 0 ? (double)nArray[i] * d : 0.0;
        }
        return dArray;
    }

    public static void print(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            System.out.println("array [" + i + "] = " + nArray[i]);
        }
    }

    public static void print(int[][] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray[i].length; ++j) {
                System.out.println("array [" + i + "][" + j + "] = " + nArray[i][j]);
            }
        }
    }

    private static void quickSortMinToMax(int[] nArray, int n, int n2) {
        int n3 = n;
        int n4 = n2;
        if (n2 > n) {
            int n5 = nArray[(int)Math.round((double)(n + n2) / 2.0)];
            while (n3 <= n4) {
                while (n3 < n2 && nArray[n3] < n5) {
                    ++n3;
                }
                while (n4 > n && nArray[n4] > n5) {
                    --n4;
                }
                if (n3 > n4) continue;
                ArrayMath.swap(nArray, n3, n4);
                ++n3;
                --n4;
            }
            if (n < n4) {
                ArrayMath.quickSortMinToMax(nArray, n, n4);
            }
            if (n3 < n2) {
                ArrayMath.quickSortMinToMax(nArray, n3, n2);
            }
        }
    }

    private static void quickSortMaxToMin(int[] nArray, int n, int n2) {
        int n3 = n;
        int n4 = n2;
        if (n2 > n) {
            int n5 = nArray[(int)Math.round((double)(n + n2) / 2.0)];
            while (n3 <= n4) {
                while (n3 < n2 && nArray[n3] > n5) {
                    ++n3;
                }
                while (n4 > n && nArray[n4] < n5) {
                    --n4;
                }
                if (n3 > n4) continue;
                ArrayMath.swap(nArray, n3, n4);
                ++n3;
                --n4;
            }
            if (n < n4) {
                ArrayMath.quickSortMaxToMin(nArray, n, n4);
            }
            if (n3 < n2) {
                ArrayMath.quickSortMaxToMin(nArray, n3, n2);
            }
        }
    }

    private static void quickSortMinToMax(double[] dArray, int n, int n2) {
        int n3 = n;
        int n4 = n2;
        if (n2 > n) {
            double d = dArray[(int)Math.round((double)(n + n2) / 2.0)];
            while (n3 <= n4) {
                while (n3 < n2 && dArray[n3] < d) {
                    ++n3;
                }
                while (n4 > n && dArray[n4] > d) {
                    --n4;
                }
                if (n3 > n4) continue;
                ArrayMath.swap(dArray, n3, n4);
                ++n3;
                --n4;
            }
            if (n < n4) {
                ArrayMath.quickSortMinToMax(dArray, n, n4);
            }
            if (n3 < n2) {
                ArrayMath.quickSortMinToMax(dArray, n3, n2);
            }
        }
    }

    private static void quickSortMaxToMin(double[] dArray, int n, int n2) {
        int n3 = n;
        int n4 = n2;
        if (n2 > n) {
            double d = dArray[(int)Math.round((double)(n + n2) / 2.0)];
            while (n3 <= n4) {
                while (n3 < n2 && dArray[n3] > d) {
                    ++n3;
                }
                while (n4 > n && dArray[n4] < d) {
                    --n4;
                }
                if (n3 > n4) continue;
                ArrayMath.swap(dArray, n3, n4);
                ++n3;
                --n4;
            }
            if (n < n4) {
                ArrayMath.quickSortMaxToMin(dArray, n, n4);
            }
            if (n3 < n2) {
                ArrayMath.quickSortMaxToMin(dArray, n3, n2);
            }
        }
    }

    private static void swap(int[] nArray, int n, int n2) {
        int n3 = nArray[n];
        nArray[n] = nArray[n2];
        nArray[n2] = n3;
    }

    private static void swap(double[] dArray, int n, int n2) {
        double d = dArray[n];
        dArray[n] = dArray[n2];
        dArray[n2] = d;
    }
}

