/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.Fissures.seed.builder;

import edu.iris.Fissures.seed.builder.BuilderFilter;
import edu.iris.Fissures.seed.container.Blockette;
import edu.iris.Fissures.seed.exception.BuilderException;
import java.util.Vector;

public class SeedBuilderFilter
extends BuilderFilter {
    public SeedBuilderFilter() {
        this.addParameter("TIME_ZERO", "0000,000,00:00:00.0000");
        this.addParameter("TIME_INF", "2500,365,23:59:59.9999");
        this.filterType = "SEED";
    }

    public boolean qualify(Object object) throws BuilderException {
        float f;
        Blockette blockette = (Blockette)object;
        int n = blockette.getType();
        try {
            f = blockette.getVersion();
        }
        catch (Exception exception) {
            throw new BuilderException(exception.toString());
        }
        switch (n) {
            case 50: {
                boolean bl = this.testCompare("station", null, blockette, 3);
                boolean bl2 = true;
                if ((double)f >= 2.3) {
                    bl2 = this.testCompare("network", null, blockette, 16);
                }
                boolean bl3 = this.testCompare("min_lat", "max_lat", blockette, 4);
                boolean bl4 = this.testCompare("min_lon", "max_lon", blockette, 5);
                boolean bl5 = this.testCompare("min_elev", "max_elev", blockette, 6);
                boolean bl6 = this.testCompare("start_time", "TIME_INF", blockette, 14);
                boolean bl7 = this.testCompare("TIME_ZERO", "end_time", blockette, 13);
                return bl && bl2 && bl3 && bl4 && bl5 && bl6 && bl7;
            }
            case 52: {
                boolean bl = this.testCompare("location", null, blockette, 3);
                boolean bl8 = this.testCompare("channel", null, blockette, 4);
                boolean bl9 = this.testCompare("start_time", "TIME_INF", blockette, 23);
                boolean bl10 = this.testCompare("TIME_ZERO", "end_time", blockette, 22);
                return bl && bl8 && bl9 && bl10;
            }
            case 72: {
                boolean bl = this.testCompare("station", null, blockette, 3);
                boolean bl11 = this.testCompare("location", null, blockette, 4);
                boolean bl12 = this.testCompare("channel", null, blockette, 5);
                boolean bl13 = true;
                if ((double)f >= 2.3) {
                    bl13 = this.testCompare("network", null, blockette, 12);
                }
                return bl && bl11 && bl12 && bl13;
            }
            case 73: {
                boolean bl = this.testCompare("station", null, blockette, 4);
                boolean bl14 = this.testCompare("location", null, blockette, 5);
                boolean bl15 = this.testCompare("channel", null, blockette, 6);
                boolean bl16 = this.testCompare("start_time", "end_time", blockette, 7);
                return bl && bl14 && bl15 && bl16;
            }
            case 74: {
                boolean bl = this.testCompare("station", null, blockette, 3);
                boolean bl17 = this.testCompare("location", null, blockette, 4);
                boolean bl18 = this.testCompare("channel", null, blockette, 5);
                boolean bl19 = this.testCompare("start_time", "TIME_INF", blockette, 9);
                boolean bl20 = this.testCompare("TIME_ZERO", "end_time", blockette, 6);
                boolean bl21 = true;
                if ((double)f >= 2.3) {
                    bl21 = this.testCompare("network", null, blockette, 16);
                }
                return bl && bl17 && bl18 && bl19 && bl20 && bl21;
            }
            case 999: {
                boolean bl = this.testCompare("station", null, blockette, 4);
                boolean bl22 = this.testCompare("location", null, blockette, 5);
                boolean bl23 = this.testCompare("channel", null, blockette, 6);
                boolean bl24 = true;
                if ((double)f >= 2.3) {
                    bl24 = this.testCompare("network", null, blockette, 7);
                }
                boolean bl25 = this.testCompare("start_time", "end_time", blockette, 8);
                return bl && bl22 && bl23 && bl24 && bl25;
            }
        }
        return true;
    }

    public boolean testCompare(String string, String string2, Blockette blockette, int n) {
        String string3 = blockette.toString(n);
        return this.testCompare(string, string2, string3);
    }

    public boolean testCompare(String string, String string2, String string3) {
        Vector vector = this.getParameter(string);
        Vector vector2 = this.getParameter(string2);
        if (vector == null) {
            return true;
        }
        for (int i = 0; i < vector.size(); ++i) {
            String string4 = vector.get(i).toString();
            if (vector2 == null) {
                if (string.equals("TIME_ZERO")) {
                    return true;
                }
                if (!this.globMatch(string4, string3)) continue;
                return true;
            }
            if (i < vector2.size()) {
                String string5 = vector2.get(i).toString();
                if (this.numCompare(string4, string3) > 0 || this.numCompare(string5, string3) < 0) continue;
                return true;
            }
            return false;
        }
        return false;
    }
}

