/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.seis;

import edu.iris.Fissures.seed.container.Blockette;
import java.util.Vector;
import net.alomax.io.BinaryInputStream;
import net.alomax.math.TimeSeriesFloat;
import net.alomax.seis.BasicSeismogram;
import net.alomax.seis.SEEDVolumeParser;
import net.alomax.seis.SeisDataSEEDBase;

public class SeisDataSEEDFull
extends SeisDataSEEDBase {
    protected String headerFieldString = "";
    protected int numBlockettesRead = 0;
    protected int logicalRecordLength = 0;
    protected String encodingFormat = null;
    Vector controlHeaders = null;

    public void read(SEEDVolumeParser sEEDVolumeParser, Blockette blockette, boolean bl) throws Exception {
        String string = sEEDVolumeParser.getStringValue(blockette, 3);
        String string2 = sEEDVolumeParser.getStringValue(blockette, 4);
        String string3 = sEEDVolumeParser.getStringValue(blockette, 5);
        Blockette blockette2 = sEEDVolumeParser.getStationIdentifierBlockette(string);
        Blockette blockette3 = sEEDVolumeParser.getChannelIdentifierBlockette(blockette2, string3);
        Vector vector = new Vector();
        Vector vector2 = sEEDVolumeParser.getTimeSeries(vector, blockette, bl);
        this.setHeaderFields((Blockette)vector2.elementAt(0));
        this.sample = this.getSampleArray(vector, null);
    }

    protected void setAdditionalHeaderFields(SEEDVolumeParser sEEDVolumeParser, Blockette blockette, Blockette blockette2, Blockette blockette3) throws Exception {
        SeisDataSEEDFull seisDataSEEDFull = this;
    }

    public void getSeismogramFields(BasicSeismogram basicSeismogram) {
    }

    public void setSeismogramFields() {
        SeisDataSEEDFull seisDataSEEDFull = this;
        String string = "counts";
        this.timeSeries = new TimeSeriesFloat(seisDataSEEDFull.sample, 1.0 / this.sampleRate, 0.0, string, "sec");
        this.timeMin = 0.0;
        double d = Double.MAX_VALUE;
        double d2 = Double.MAX_VALUE;
        if (this.channel.chanName.toUpperCase().endsWith("Z")) {
            d = 0.0;
            if (!(d2 > 179.99999) || !(d2 < 180.00001)) {
                d2 = 0.0;
            }
        } else if (this.channel.chanName.toUpperCase().endsWith("N")) {
            d = 0.0;
            d2 = 90.0;
        } else if (this.channel.chanName.toUpperCase().endsWith("E")) {
            d = 90.0;
            d2 = 90.0;
        }
        this.channel.azimuth = d;
        this.channel.inclination = d2;
    }

    public String getHeaderFieldsAsString() {
        String string = System.getProperty("line.separator");
        String string2 = "# [SEED Data Format]" + string;
        string2 = string2 + "# Total number of blockettes read: " + this.numBlockettesRead + string;
        string2 = string2 + this.headerFieldString + string;
        return string2;
    }

    public static int canRead(BinaryInputStream binaryInputStream) {
        try {
            byte[] byArray = new byte[8];
            int n = binaryInputStream.read(byArray);
            if (n == 8) {
                String string = new String(byArray).substring(0, 6);
                int n2 = new Integer(string);
                if (n2 < 0) {
                    return -1;
                }
                if (new String("VAST").indexOf(byArray[6]) < 0) {
                    return -1;
                }
                if (new String("PS ").indexOf(byArray[7]) < 0) {
                    return -1;
                }
                return 1;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return -1;
    }
}

