/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.seisgram2k;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.alomax.animator.Animator;
import net.alomax.animator.AnimatorClient;
import net.alomax.awt.AJLColor;
import net.alomax.graphics3d.Axes3D;
import net.alomax.graphics3d.Line3D;
import net.alomax.graphics3d.Matrix3D;
import net.alomax.graphics3d.Vect3D;
import net.alomax.math.RangeDouble;
import net.alomax.seisgram2k.GatherPanel;
import net.alomax.seisgram2k.Panel3D;
import net.alomax.seisgram2k.SeisGramText;
import net.alomax.seisgram2k.Seismogram;
import net.alomax.swing.AJLJButton;
import net.alomax.swing.SwingExt;

public class ParticleMotionFrame
extends JFrame
implements AnimatorClient,
ActionListener,
KeyListener,
ItemListener {
    protected static final double RPD = Math.PI / 180;
    protected static Point locationOnScreen = null;
    protected static Dimension windowSize = null;
    protected GatherPanel parent;
    protected Seismogram xSeismogram;
    protected Seismogram ySeismogram;
    protected Seismogram zSeismogram;
    protected int xSeismogramSampleOffset;
    protected String staInstID;
    protected RangeDouble timeRange;
    protected RangeDouble ampRange;
    protected boolean fullyInitialized = false;
    protected boolean activated = false;
    protected boolean painted = true;
    protected double worldWidthMax;
    protected double viewScale;
    protected double viewScaleFactor;
    protected double pix2WorldScale;
    protected double secToKmScale;
    protected Vect3D worldCenterPoint = new Vect3D();
    protected double perspDist;
    protected Matrix3D rotMat = new Matrix3D();
    protected Matrix3D tmpMat = new Matrix3D();
    protected Matrix3D worldTransMat = new Matrix3D();
    protected Matrix3D viewMat = new Matrix3D();
    protected Matrix3D projMat = new Matrix3D();
    protected Image backBuffer;
    protected Graphics backBufferGraphics;
    protected Graphics gdrawStatic;
    public static final Color COLOR_AXES = Color.lightGray;
    public static final Color COLOR_AXES_HARDCOPY = Color.gray;
    public static final Color COLOR_AXES_ANIMATE = Color.gray;
    public static final Color COLOR_SEIS_BRIGHT = Color.yellow;
    public static final Color COLOR_SEIS_SAMPLE = Color.yellow;
    public static final Color COLOR_SEIS_BRIGHT_HARDCOPY = Color.black;
    public static final Color COLOR_SEIS_DIM = Color.blue;
    public static final Color COLOR_SEIS_DIM_HARDCOPY = Color.lightGray.brighter();
    public static final int SAMPLE_RADIUS = 2;
    protected Dimension backSize;
    protected Axes3D axes3D;
    protected Line3D seismogram3D;
    protected Panel3D panel3D;
    protected JPanel graphicsPanel = new JPanel();
    protected JPanel menuPanels = new JPanel();
    protected JPanel menuPanel0 = new JPanel();
    protected JLabel messagePanel = new JLabel();
    protected AJLJButton buttonProject;
    protected AJLJButton buttonZoomIn;
    protected AJLJButton buttonZoomOut;
    protected AJLJButton buttonReset;
    protected boolean projectFlag = false;
    protected JCheckBoxMenuItem checkBoxBuffer;
    protected boolean bufferFlag = true;
    protected JCheckBoxMenuItem checkBoxInvertCol;
    protected boolean invertColorFlag = false;
    protected AJLJButton buttonAbove;
    protected AJLJButton buttonBelow;
    protected AJLJButton buttonSouth;
    protected AJLJButton buttonNorth;
    protected AJLJButton buttonEast;
    protected AJLJButton buttonWest;
    protected boolean mouseIsDown = false;
    protected int initSamplePlotFirst;
    protected int initSamplePlotLast;
    protected int samplePlotFirst;
    protected int samplePlotLast;
    protected Animator animatorThread;
    protected boolean animatorThreadSuspended = true;
    protected AJLJButton buttonPlotFirst;
    protected AJLJButton buttonPlotLast;
    protected AJLJButton buttonPlotNext;
    protected AJLJButton buttonPlotPrev;
    protected AJLJButton buttonPlotAll;
    protected AJLJButton buttonPlotPick;
    protected AJLJButton buttonPlotAutoBackwards;
    protected AJLJButton buttonPlotAutoForwards;
    protected AJLJButton buttonPlotAutoSlower;
    protected AJLJButton buttonPlotAutoFaster;
    protected AJLJButton buttonPlotAutoSuspend;
    protected int samplePlotCurrent = 0;

    ParticleMotionFrame(GatherPanel gatherPanel, Seismogram seismogram, Seismogram seismogram2, Seismogram seismogram3, double d, RangeDouble rangeDouble, String string, Image image) {
        super(SeisGramText.PARTICLE_MOTION);
        if (image != null) {
            this.setIconImage(image);
        }
        this.parent = gatherPanel;
        this.xSeismogram = seismogram;
        if (this.xSeismogram == null) {
            this.xSeismogram = seismogram2;
        }
        if (this.xSeismogram == null) {
            this.xSeismogram = seismogram3;
        }
        if (this.xSeismogram == null) {
            this.parent.writeMessage(this.getClass().getName() + ": " + "ERROR: All channels are empty.");
            return;
        }
        this.ySeismogram = seismogram2 == null ? this.xSeismogram : seismogram2;
        this.zSeismogram = seismogram3 == null ? this.xSeismogram : seismogram3;
        this.staInstID = string;
        this.timeRange = rangeDouble;
        int n = this.xSeismogram.sampAtTimeNoVerify(this.timeRange.min);
        int n2 = this.xSeismogram.sampAtTimeNoVerify(this.timeRange.max);
        int n3 = this.ySeismogram.sampAtTimeNoVerify(this.timeRange.min);
        int n4 = this.ySeismogram.sampAtTimeNoVerify(this.timeRange.max);
        int n5 = this.zSeismogram.sampAtTimeNoVerify(this.timeRange.min);
        int n6 = this.zSeismogram.sampAtTimeNoVerify(this.timeRange.max);
        int n7 = n2 - n + 1;
        int n8 = n4 - n3 + 1;
        int n9 = n6 - n5 + 1;
        if (n7 != n8 || n8 != n9 || n9 != n7) {
            String string2 = "WARNING: Initializing particle motion: failed to exactly align x, y, and z sample points.";
            System.out.println(string2);
            this.writeMessage(string2);
        }
        int n10 = n7 < n8 ? n7 : n8;
        n10 = n10 < n9 ? n10 : n9;
        float[] fArray = null;
        if (seismogram != null) {
            fArray = this.xSeismogram.timeSeries.getSampleSubsetAsFloat(n, n + n10 - 1);
        }
        float[] fArray2 = null;
        if (seismogram2 != null) {
            fArray2 = this.ySeismogram.timeSeries.getSampleSubsetAsFloat(n3, n3 + n10 - 1);
        }
        float[] fArray3 = null;
        if (seismogram3 != null) {
            fArray3 = this.zSeismogram.timeSeries.getSampleSubsetAsFloat(n5, n5 + n10 - 1);
        }
        if (fArray != null && fArray2 != null && Math.abs(d) > Double.MIN_VALUE) {
            double d2 = Math.cos(Math.PI / 180 * d);
            double d3 = Math.sin(Math.PI / 180 * d);
            int n11 = Math.min(fArray.length, fArray2.length);
            for (int i = 0; i < n11; ++i) {
                float f = (float)(d2 * (double)fArray[i] + d3 * (double)fArray2[i]);
                fArray2[i] = (float)(-d3 * (double)fArray[i] + d2 * (double)fArray2[i]);
                fArray[i] = f;
            }
        }
        this.seismogram3D = new Line3D(fArray, fArray2, fArray3);
        this.xSeismogramSampleOffset = n;
        this.initSamplePlotFirst = 0;
        this.initSamplePlotLast = n10 - 1;
        this.ampRange = this.parent.getAmpRangeSeismograms(this.timeRange.min, this.timeRange.max);
        if (this.ampRange.min < 0.0 && this.ampRange.max > 0.0) {
            if (-this.ampRange.min > this.ampRange.max) {
                this.ampRange.max = -this.ampRange.min;
            } else {
                this.ampRange.min = -this.ampRange.max;
            }
        }
    }

    public void dispose() {
        this.killAnimatorThread(false);
        this.parent.removeCursorVertical(COLOR_SEIS_BRIGHT);
        if (this.gdrawStatic != null) {
            this.gdrawStatic.dispose();
        }
        super.dispose();
    }

    public void init(int n, int n2) {
        this.menuPanels.setBackground(AJLColor.menu);
        this.setMenuPanel0();
        this.menuPanels.setLayout(new GridLayout(1, 0, 0, 0));
        this.menuPanels.add(this.menuPanel0);
        this.panel3D = new Panel3D(this);
        this.graphicsPanel = new JPanel();
        this.graphicsPanel.setLayout(new BorderLayout(0, 0));
        this.graphicsPanel.add("Center", this.panel3D);
        this.graphicsPanel.add("South", this.messagePanel);
        this.messagePanel.setForeground(Color.green);
        this.messagePanel.setBackground(Color.black);
        this.messagePanel.setOpaque(true);
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        this.getContentPane().add("Center", this.graphicsPanel);
        this.getContentPane().add("East", this.menuPanels);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                windowSize = ParticleMotionFrame.this.getSize();
                locationOnScreen = ParticleMotionFrame.this.getLocationOnScreen();
                ParticleMotionFrame.this.dispose();
                ParticleMotionFrame.this.activated = false;
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                windowSize = ParticleMotionFrame.this.getSize();
                locationOnScreen = ParticleMotionFrame.this.getLocationOnScreen();
            }

            public void componentMoved(ComponentEvent componentEvent) {
                windowSize = ParticleMotionFrame.this.getSize();
                locationOnScreen = ParticleMotionFrame.this.getLocationOnScreen();
            }
        });
        if (windowSize == null) {
            this.setSize(n, n2);
        } else {
            this.setSize(ParticleMotionFrame.windowSize.width, ParticleMotionFrame.windowSize.height);
        }
        if (locationOnScreen == null) {
            SwingExt.setLocationToCenter(this, this.parent.seisFrame.getJFrame(), this.parent.seisFrame.getJFrame().getLocationOnScreen());
        } else {
            this.setLocation(ParticleMotionFrame.locationOnScreen.x, ParticleMotionFrame.locationOnScreen.y);
        }
        this.show();
        this.axes3D = new Axes3D(this.ampRange.min, this.ampRange.max, this.ampRange.min, this.ampRange.max, this.ampRange.min, this.ampRange.max, this, COLOR_AXES);
        this.initializeView();
        double d = (double)this.panel3D.getSize().width / this.worldWidthMax;
        double d2 = (double)this.panel3D.getSize().height / this.worldWidthMax;
        this.pix2WorldScale = (double)0.8f / (this.viewScaleFactor * (d < d2 ? d : d2));
        this.samplePlotFirst = this.initSamplePlotFirst;
        this.samplePlotLast = this.initSamplePlotLast;
        this.axes3D.createLabels(this.pix2WorldScale);
        this.fullyInitialized = true;
        this.activated = true;
    }

    public boolean isActivated() {
        return this.activated;
    }

    private void initializeView() {
        this.projectFlag = false;
        this.worldCenterPoint = new Vect3D((this.axes3D.xmin0 + this.axes3D.xmax0) / 2.0, (this.axes3D.ymin0 + this.axes3D.ymax0) / 2.0, (this.axes3D.zmin0 + this.axes3D.zmax0) / 2.0);
        this.worldTransMat.unit();
        this.worldTransMat.translate(-this.worldCenterPoint.x, -this.worldCenterPoint.y, -this.worldCenterPoint.z);
        this.rotMat.unit();
        this.rotMat.zrot(-20.0);
        this.rotMat.xrot(-60.0);
        double d = this.axes3D.xmax0 - this.axes3D.xmin0;
        double d2 = this.axes3D.ymax0 - this.axes3D.ymin0;
        double d3 = this.axes3D.zmax0 - this.axes3D.zmin0;
        if (d2 > d) {
            d = d2;
        }
        if (d3 > d) {
            d = d3;
        }
        this.worldWidthMax = d;
        this.perspDist = 2.0 * d;
        this.viewScaleFactor = 0.7f;
    }

    private synchronized void newBackBuffer() {
        if (!this.bufferFlag) {
            this.backBuffer = null;
            return;
        }
        this.backBuffer = this.panel3D.createImage(this.panel3D.getSize().width, this.panel3D.getSize().height);
        if (this.backBufferGraphics != null) {
            this.backBufferGraphics.dispose();
        }
        this.backBufferGraphics = this.backBuffer.getGraphics();
        this.backSize = this.panel3D.getSize();
    }

    private void setMenuPanel0() {
        this.menuPanel0.setLayout(new GridLayout(0, 1, 0, 0));
        this.checkBoxBuffer = SwingExt.newJCheckBoxMenuItem(this, "DrawBuffer");
        this.checkBoxBuffer.setState(this.bufferFlag);
        this.checkBoxInvertCol = SwingExt.newJCheckBoxMenuItem(this, "BackGdColor");
        this.checkBoxInvertCol.setState(this.invertColorFlag);
        this.menuPanel0.add(new JLabel(SeisGramText.VIEW + ":"));
        this.buttonZoomIn = new AJLJButton(this, this, "Zoom In", true);
        this.menuPanel0.add(this.buttonZoomIn);
        this.buttonZoomOut = new AJLJButton(this, this, "Zoom Out", true);
        this.menuPanel0.add(this.buttonZoomOut);
        this.buttonProject = new AJLJButton(this, this, "Persp/Ortho");
        this.menuPanel0.add(this.buttonProject);
        this.buttonReset = new AJLJButton(this, this, "Reset");
        this.menuPanel0.add(this.buttonReset);
        this.menuPanel0.add(new JLabel(SeisGramText.VIEW_FROM + ":"));
        this.buttonAbove = new AJLJButton(this, this, "Above");
        this.menuPanel0.add(this.buttonAbove);
        this.buttonBelow = new AJLJButton(this, this, "Below");
        this.menuPanel0.add(this.buttonBelow);
        this.buttonSouth = new AJLJButton(this, this, "South");
        this.menuPanel0.add(this.buttonSouth);
        this.buttonNorth = new AJLJButton(this, this, "North");
        this.menuPanel0.add(this.buttonNorth);
        this.buttonEast = new AJLJButton(this, this, "East");
        this.menuPanel0.add(this.buttonEast);
        this.buttonWest = new AJLJButton(this, this, "West");
        this.menuPanel0.add(this.buttonWest);
        this.menuPanel0.add(new JLabel(SeisGramText.SAMPLE + ":"));
        this.buttonPlotPick = new AJLJButton(this, this, "Pick     + ");
        this.menuPanel0.add(this.buttonPlotPick);
        this.buttonPlotFirst = new AJLJButton(this, this, "First   |< ");
        this.menuPanel0.add(this.buttonPlotFirst);
        this.buttonPlotPrev = new AJLJButton(this, this, "Prev    .< ", true);
        this.menuPanel0.add(this.buttonPlotPrev);
        this.buttonPlotNext = new AJLJButton(this, this, "Next     >.", true);
        this.menuPanel0.add(this.buttonPlotNext);
        this.buttonPlotLast = new AJLJButton(this, this, "Last     >|");
        this.menuPanel0.add(this.buttonPlotLast);
        this.buttonPlotAll = new AJLJButton(this, this, "All     |-|");
        this.menuPanel0.add(this.buttonPlotAll);
        this.menuPanel0.add(new JLabel(SeisGramText.ANIMATE + ":"));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 0, 0, 0));
        this.buttonPlotAutoBackwards = new AJLJButton(this, this, "<");
        jPanel.add(this.buttonPlotAutoBackwards);
        this.buttonPlotAutoSuspend = new AJLJButton(this, this, "||");
        jPanel.add(this.buttonPlotAutoSuspend);
        this.buttonPlotAutoForwards = new AJLJButton(this, this, ">");
        jPanel.add(this.buttonPlotAutoForwards);
        this.menuPanel0.add(jPanel);
        jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 0, 0, 0));
        this.buttonPlotAutoSlower = new AJLJButton(this, this, "-");
        jPanel.add(this.buttonPlotAutoSlower);
        this.buttonPlotAutoFaster = new AJLJButton(this, this, "+");
        jPanel.add(this.buttonPlotAutoFaster);
        this.menuPanel0.add(jPanel);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource().equals(this.checkBoxBuffer)) {
            this.bufferFlag = this.checkBoxBuffer.getState();
        } else if (itemEvent.getSource().equals(this.checkBoxInvertCol)) {
            this.invertColorFlag = this.checkBoxInvertCol.getState();
        }
        this.waitPainted();
        this.repaint();
    }

    public synchronized void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.buttonProject)) {
            this.projectFlag = !this.projectFlag;
        } else if (actionEvent.getSource().equals(this.buttonZoomIn)) {
            if (this.viewScaleFactor > 100.0) {
                return;
            }
            this.viewScaleFactor *= (double)1.2f;
            this.perspDist /= (double)1.2f;
        } else if (actionEvent.getSource().equals(this.buttonZoomOut)) {
            this.viewScaleFactor /= (double)1.2f;
            this.perspDist *= (double)1.2f;
        } else if (actionEvent.getSource().equals(this.buttonReset)) {
            this.initializeView();
        } else if (actionEvent.getSource().equals(this.buttonAbove)) {
            this.rotMat.unit();
            this.rotMat.xrot(0.0);
            this.rotMat.yrot(0.0);
        } else if (actionEvent.getSource().equals(this.buttonBelow)) {
            this.rotMat.unit();
            this.rotMat.xrot(180.0);
            this.rotMat.zrot(180.0);
        } else if (actionEvent.getSource().equals(this.buttonSouth)) {
            this.rotMat.unit();
            this.rotMat.xrot(-90.0);
            this.rotMat.yrot(0.0);
        } else if (actionEvent.getSource().equals(this.buttonNorth)) {
            this.rotMat.unit();
            this.rotMat.xrot(-90.0);
            this.rotMat.yrot(180.0);
        } else if (actionEvent.getSource().equals(this.buttonEast)) {
            this.rotMat.unit();
            this.rotMat.xrot(-90.0);
            this.rotMat.yrot(90.0);
        } else if (actionEvent.getSource().equals(this.buttonWest)) {
            this.rotMat.unit();
            this.rotMat.xrot(-90.0);
            this.rotMat.yrot(-90.0);
        } else if (actionEvent.getSource().equals(this.buttonPlotPick)) {
            this.killAnimatorThread(true);
            this.samplePlotFirst = this.xSeismogram.sampAtTime(this.parent.workingPick.dateTimeToTime(this.parent)) - this.xSeismogramSampleOffset;
            if (this.samplePlotFirst < this.initSamplePlotFirst) {
                this.samplePlotFirst = this.initSamplePlotFirst;
            }
            this.samplePlotLast = this.samplePlotFirst;
            if (this.samplePlotLast > this.initSamplePlotLast) {
                this.samplePlotFirst = this.samplePlotLast = this.initSamplePlotLast;
            }
        } else if (actionEvent.getSource().equals(this.buttonPlotFirst)) {
            this.killAnimatorThread(true);
            this.samplePlotFirst = this.initSamplePlotFirst;
            this.samplePlotLast = this.initSamplePlotFirst;
        } else if (actionEvent.getSource().equals(this.buttonPlotLast)) {
            this.killAnimatorThread(true);
            this.samplePlotFirst = this.initSamplePlotLast;
            this.samplePlotLast = this.initSamplePlotLast;
        } else if (actionEvent.getSource().equals(this.buttonPlotNext)) {
            this.killAnimatorThread(true);
            this.incrementSample();
        } else if (actionEvent.getSource().equals(this.buttonPlotPrev)) {
            this.killAnimatorThread(true);
            this.decrementSample();
        } else if (actionEvent.getSource().equals(this.buttonPlotAll)) {
            this.killAnimatorThread(true);
            this.samplePlotFirst = this.initSamplePlotFirst;
            this.samplePlotLast = this.initSamplePlotLast;
            this.axes3D.setColor(COLOR_AXES);
        } else {
            if (actionEvent.getSource().equals(this.buttonPlotAutoSuspend)) {
                this.suspendAnimatorThread();
                return;
            }
            if (actionEvent.getSource().equals(this.buttonPlotAutoBackwards)) {
                this.startAnimatorThread(1);
                return;
            }
            if (actionEvent.getSource().equals(this.buttonPlotAutoForwards)) {
                this.startAnimatorThread(0);
                return;
            }
            if (actionEvent.getSource().equals(this.buttonPlotAutoSlower)) {
                this.decreaseRateAnimatorThread();
                return;
            }
            if (actionEvent.getSource().equals(this.buttonPlotAutoFaster)) {
                this.increaseRateAnimatorThread();
                return;
            }
        }
        this.waitPainted();
        this.repaint();
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public boolean incrementSample() {
        this.axes3D.setColor(COLOR_AXES_ANIMATE);
        if (this.samplePlotLast < this.initSamplePlotLast) {
            ++this.samplePlotLast;
            this.samplePlotFirst = this.samplePlotLast;
            return false;
        }
        this.samplePlotFirst = this.initSamplePlotFirst;
        this.samplePlotLast = this.initSamplePlotFirst;
        return true;
    }

    public boolean decrementSample() {
        if (this.samplePlotFirst > this.initSamplePlotFirst) {
            --this.samplePlotFirst;
            this.samplePlotLast = this.samplePlotFirst;
            return false;
        }
        this.samplePlotFirst = this.initSamplePlotLast;
        this.samplePlotLast = this.initSamplePlotLast;
        return true;
    }

    private void startAnimatorThread(int n) {
        if (this.animatorThread != null && this.animatorThread.isAlive()) {
            this.animatorThread.setDirection(n);
            this.animatorThread.resume();
            this.animatorThreadSuspended = false;
            this.writeMessage(" ");
            return;
        }
        this.incrementSample();
        this.waitPainted();
        this.repaint();
        this.waitPainted();
        this.animatorThread = new Animator(this, n, 32, 1000);
        this.animatorThread.setPriority(1);
        this.animatorThread.start();
        this.animatorThreadSuspended = false;
        this.writeMessage(" ");
    }

    private void suspendAnimatorThread() {
        if (this.animatorThread != null && this.animatorThread.isAlive()) {
            if (this.animatorThreadSuspended) {
                this.animatorThread.pause(false);
                this.writeMessage(" ");
            } else {
                this.animatorThread.pause(true);
                this.displayCurrentSampleTime();
            }
        }
        this.animatorThreadSuspended = !this.animatorThreadSuspended;
    }

    private void killAnimatorThread(boolean bl) {
        this.animatorThreadSuspended = true;
        if (this.animatorThread == null) {
            return;
        }
        this.animatorThread.stopRunning();
        this.animatorThread.interrupt();
        long l = 50L;
        long l2 = 1000L;
        for (long i = 0L; this.animatorThread != null && this.animatorThread.isAlive() && i < l2; i += l) {
            try {
                Thread.currentThread();
                Thread.sleep(l);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.animatorThread = null;
        if (this.samplePlotLast - this.samplePlotFirst == 0) {
            this.parent.drawCursorVertical(COLOR_SEIS_BRIGHT, this.getTime(this.xSeismogramSampleOffset + this.samplePlotFirst));
        }
        if (bl) {
            this.waitPainted();
            this.repaint();
        }
    }

    private void increaseRateAnimatorThread() {
        this.writeMessage("...");
        if (this.animatorThread != null && this.animatorThread.isAlive()) {
            this.animatorThread.increaseRate();
        }
    }

    private void decreaseRateAnimatorThread() {
        this.writeMessage("...");
        if (this.animatorThread != null && this.animatorThread.isAlive()) {
            this.animatorThread.decreaseRate();
        }
    }

    void newWorldCenter(int n, int n2) {
        Matrix3D matrix3D = new Matrix3D(this.worldTransMat);
        matrix3D.transInvert();
        Matrix3D matrix3D2 = new Matrix3D(this.rotMat);
        matrix3D2.rotInvert();
        Matrix3D matrix3D3 = new Matrix3D();
        matrix3D3.unit();
        matrix3D3.translate(-this.panel3D.getSize().width / 2, -this.panel3D.getSize().height / 2, 0.0);
        matrix3D3.scale(1.0 / this.viewScale, -1.0 / this.viewScale, 1.0 / this.viewScale);
        matrix3D3.mult(matrix3D2);
        matrix3D3.mult(matrix3D);
        Vect3D vect3D = new Vect3D((double)n, (double)n2, 0.0);
        this.worldCenterPoint = vect3D.mult(matrix3D3);
        this.worldTransMat.unit();
        this.worldTransMat.translate(-this.worldCenterPoint.x, -this.worldCenterPoint.y, -this.worldCenterPoint.z);
    }

    public void print(Graphics graphics, Dimension dimension) {
        this.paint(graphics, dimension, true);
    }

    public BufferedImage paintSnapshot(int n) {
        BufferedImage bufferedImage = new BufferedImage(this.graphicsPanel.getWidth(), this.graphicsPanel.getHeight(), n);
        Graphics graphics = bufferedImage.getGraphics();
        this.graphicsPanel.paint(graphics);
        graphics.dispose();
        return bufferedImage;
    }

    public void paint(Graphics graphics, Dimension dimension, boolean bl) {
        if (!this.fullyInitialized) {
            return;
        }
        this.painted = false;
        double d = (double)dimension.width / this.worldWidthMax;
        double d2 = (double)dimension.height / this.worldWidthMax;
        this.viewScale = this.viewScaleFactor * (d > d2 ? d : d2);
        this.viewMat.unit();
        this.viewMat.scale(1.0, 1.0, -1.0);
        this.viewMat.mult(this.worldTransMat);
        this.viewMat.mult(this.rotMat);
        this.projMat.unit();
        this.projMat.scale(this.viewScale, -this.viewScale, this.viewScale);
        this.projMat.translate(dimension.width / 2, dimension.height / 2, 0.0);
        if (this.projectFlag) {
            Matrix3D.setPerspTrans(this.viewMat, this.perspDist, this.projMat);
        } else {
            Matrix3D.setPerspTrans(this.viewMat, -1.0, this.projMat);
        }
        if (this.bufferFlag && this.backBuffer == null) {
            this.newBackBuffer();
        }
        Graphics graphics2 = null;
        if (bl) {
            graphics2 = graphics;
        } else if (this.backBuffer != null) {
            if (!this.backSize.equals(this.panel3D.getSize())) {
                this.newBackBuffer();
            }
            graphics2 = this.backBufferGraphics;
        } else {
            graphics2 = this.panel3D.getGraphics();
        }
        if (bl || this.invertColorFlag) {
            graphics2.setColor(Color.white);
        } else {
            graphics2.setColor(Color.black);
        }
        graphics2.fillRect(0, 0, dimension.width, dimension.height);
        this.axes3D.transform(this.axes3D.getLastTransformationIndex() - 1);
        if (bl) {
            this.axes3D.paint(graphics2, COLOR_AXES_HARDCOPY);
        } else {
            this.axes3D.paint(graphics2);
        }
        this.seismogram3D.paint(graphics2, this.initSamplePlotFirst, this.samplePlotFirst, bl ? COLOR_SEIS_DIM_HARDCOPY : COLOR_SEIS_DIM);
        this.seismogram3D.paint(graphics2, this.samplePlotLast, this.initSamplePlotLast, bl ? COLOR_SEIS_DIM_HARDCOPY : COLOR_SEIS_DIM);
        this.seismogram3D.paint(graphics2, this.samplePlotFirst, this.samplePlotLast, bl ? COLOR_SEIS_BRIGHT_HARDCOPY : COLOR_SEIS_BRIGHT);
        this.seismogram3D.paintSample(graphics2, this.samplePlotFirst, 2, bl ? COLOR_SEIS_BRIGHT_HARDCOPY : COLOR_SEIS_SAMPLE);
        if (this.samplePlotLast - this.samplePlotFirst == 0) {
            this.parent.drawCursorVertical(COLOR_SEIS_BRIGHT, this.getTime(this.samplePlotFirst));
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = fontMetrics.charWidth('_');
        int n2 = fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent();
        graphics2.setColor(bl ? Color.black : Color.white);
        graphics2.drawString(this.getSampleTime(this.initSamplePlotFirst), n, 5 * n2 / 4);
        int n3 = fontMetrics.stringWidth(this.staInstID);
        graphics2.drawString(this.staInstID, dimension.width - n - n3, 5 * n2 / 4);
        if (!bl && this.backBuffer != null) {
            graphics.drawImage(this.backBuffer, 0, 0, this.panel3D);
        }
        if (this.samplePlotLast - this.samplePlotFirst > 0) {
            this.displaySampleTime(this.samplePlotFirst, this.samplePlotLast);
        } else if (this.animatorThreadSuspended) {
            this.displaySampleTime(this.samplePlotFirst);
        }
        this.setPainted();
        this.gdrawStatic = this.panel3D.getGraphics();
    }

    public boolean paintCurrentSample(Color color) {
        if (this.seismogram3D == null || this.gdrawStatic == null) {
            return false;
        }
        if (this.painted) {
            this.painted = false;
            this.seismogram3D.paintSample(this.gdrawStatic, this.samplePlotFirst, 2, color);
            this.setPainted();
            this.parent.drawCursorVertical(COLOR_SEIS_BRIGHT, this.getTime(this.samplePlotFirst));
            return true;
        }
        return false;
    }

    public void displaySampleTime(int n, int n2) {
        this.writeMessage(this.getSampleTime(n) + " -> " + this.getSampleTime(n2));
    }

    public void displaySampleTime(int n) {
        this.writeMessage(this.getSampleTime(n));
    }

    public String getSampleTime(int n) {
        return this.parent.timeToString(this.getTime(n), 0, 1, this.parent.numDecimals, true);
    }

    public double getTime(int n) {
        return this.xSeismogram.timeAtSample(n + this.xSeismogramSampleOffset);
    }

    public void displayCurrentSampleTime() {
        this.displaySampleTime(this.samplePlotFirst);
    }

    private synchronized void setPainted() {
        this.painted = true;
        this.notifyAll();
    }

    public synchronized void waitPainted() {
        while (!this.painted) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void writeMessageToConsole(String string) {
        System.out.println(string);
    }

    void writeMessage(String string) {
        this.messagePanel.setText(string);
    }

    public boolean paintNextFrame(int n, long l) {
        boolean bl = false;
        boolean bl2 = this.paintCurrentSample(COLOR_SEIS_DIM);
        if (bl2) {
            bl = n == 0 ? this.incrementSample() : this.decrementSample();
            this.waitPainted();
            this.paintCurrentSample(COLOR_SEIS_SAMPLE);
            if (l <= 10L) {
                this.displayCurrentSampleTime();
            }
        }
        return bl;
    }
}

