/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.seisgram2k.liveseis;

import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.GregorianCalendar;
import net.alomax.io.GeneralInputStream;
import net.alomax.net.GeneralURLConnection;
import net.alomax.seisgram2k.SeismogramURL;
import net.alomax.seisgram2k.liveseis.TitanLiveSeisManager;
import net.alomax.util.NumberFormat;

public class TitanLiveSeisSegmentURL {
    protected static final boolean VERBOSE = false;
    protected int currentYear = -1;
    protected int currentMonth = -1;
    protected int currentDay = -1;
    protected int currentHour = -1;
    protected int currentMinute = -1;
    protected boolean useHourDirectories = false;
    protected String filenameTermination = ".a.tit";
    protected TitanLiveSeisManager titanLiveSeisManager = null;
    protected SeismogramURL seismogramURL = null;

    public TitanLiveSeisSegmentURL(TitanLiveSeisManager titanLiveSeisManager, SeismogramURL seismogramURL) {
        this.titanLiveSeisManager = titanLiveSeisManager;
        this.seismogramURL = seismogramURL;
    }

    protected String generateURLName(String string) throws MalformedURLException {
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            try {
                uRL = new URL("file:" + string);
            }
            catch (MalformedURLException malformedURLException2) {
                throw malformedURLException;
            }
        }
        return uRL.toString();
    }

    protected String generateURLNameDate() throws MalformedURLException {
        String string = this.seismogramURL.URLname + "/" + NumberFormat.intString(this.currentYear, 4) + "." + NumberFormat.intString(this.currentMonth, 2) + "." + NumberFormat.intString(this.currentDay, 2);
        return this.generateURLName(string);
    }

    protected String generateURLNameHour() throws MalformedURLException {
        String string = this.seismogramURL.URLname + "/" + NumberFormat.intString(this.currentYear, 4) + "." + NumberFormat.intString(this.currentMonth, 2) + "." + NumberFormat.intString(this.currentDay, 2) + "/" + NumberFormat.intString(this.currentHour, 2);
        return this.generateURLName(string);
    }

    protected String generateURLNameMinute() throws MalformedURLException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.seismogramURL.URLname);
        stringBuffer.append("/");
        stringBuffer.append(NumberFormat.intString(this.currentYear, 4));
        stringBuffer.append(".");
        stringBuffer.append(NumberFormat.intString(this.currentMonth, 2));
        stringBuffer.append(".");
        stringBuffer.append(NumberFormat.intString(this.currentDay, 2));
        stringBuffer.append("/");
        stringBuffer.append(NumberFormat.intString(this.currentHour, 2));
        if (this.useHourDirectories) {
            stringBuffer.append("/");
        } else {
            stringBuffer.append(".");
        }
        stringBuffer.append(NumberFormat.intString(this.currentMinute, 2));
        stringBuffer.append(this.filenameTermination);
        return this.generateURLName(stringBuffer.toString());
    }

    protected long setCurrentDataFileToLast() throws Exception {
        long l = -1L;
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        this.currentYear = gregorianCalendar.get(1);
        this.currentMonth = gregorianCalendar.get(2) + 1;
        this.currentDay = gregorianCalendar.get(5);
        int n = 0;
        String string = "";
        this.incrementDay();
        this.incrementDay();
        while (l <= 0L && n++ < 100) {
            this.decrementDay();
            string = this.generateURLNameDate();
            l = this.getLastModified(string);
        }
        if (l <= 0L) {
            throw new Exception(this.titanLiveSeisManager.formatMessage("Cannot open or find last data date directory URL: " + string));
        }
        this.currentHour = 24;
        if (this.useHourDirectories) {
            l = -1L;
            while (l <= 0L && this.currentHour >= 0) {
                this.decrementHour();
                string = this.generateURLNameHour();
                l = this.getLastModified(string);
            }
            if (l <= 0L) {
                throw new Exception(this.titanLiveSeisManager.formatMessage("Cannot open or find last data date/hour directory URL: " + string));
            }
        }
        this.currentMinute = 60;
        l = -1L;
        while (l <= 0L && this.currentMinute >= 0) {
            this.decrementMinute();
            string = this.generateURLNameMinute();
            l = this.getLastModified(string);
        }
        if (l <= 0L) {
            throw new Exception(this.titanLiveSeisManager.formatMessage("Cannot open or find last data date/hour/minute file URL: " + string));
        }
        return l;
    }

    protected synchronized long getLastModified() throws Exception {
        return this.getLastModified(this.generateURLNameMinute());
    }

    protected synchronized long getLastModified(String string) throws Exception {
        File file;
        long l = -1L;
        String string2 = string;
        int n = string.indexOf("file:");
        if (n >= 0) {
            string2 = string.substring(n + 5);
        }
        if ((file = new File(string2)).canRead()) {
            return 1L;
        }
        int n2 = 5;
        while (n2 > 0) {
            --n2;
            try {
                URLConnection uRLConnection = GeneralURLConnection.openURLConnection(new URL(string));
                if (uRLConnection == null) {
                    throw new Exception(this.titanLiveSeisManager.formatMessage("Cannot open data file URL connection: " + string));
                }
                l = uRLConnection.getLastModified();
                uRLConnection = null;
                if (l < 0L) continue;
                break;
            }
            catch (Exception exception) {
                if (n2 <= 0) {
                    throw exception;
                }
                try {
                    Thread.currentThread();
                    Thread.sleep(100L);
                }
                catch (Exception exception2) {}
            }
        }
        return l;
    }

    public InputStream getInputStream(String string) throws Exception {
        URLConnection uRLConnection = GeneralURLConnection.openURLConnection(new URL(string));
        if (uRLConnection == null) {
            throw new Exception(this.getClass().getName() + ": " + "Cannot open URL connection: " + string);
        }
        return GeneralInputStream.getInputStream(uRLConnection);
    }

    public SeismogramURL getSeismogramURL() throws MalformedURLException {
        SeismogramURL seismogramURL = new SeismogramURL(this.seismogramURL);
        seismogramURL.URLname = this.generateURLNameMinute();
        return seismogramURL;
    }

    public void incrementSegment() {
        this.incrementMinute();
    }

    public void incrementMinute() {
        this.currentMinute += 2;
        if (this.currentMinute > 58) {
            this.currentMinute = 0;
            this.incrementHour();
        }
    }

    public void decrementMinute() {
        this.currentMinute -= 2;
        if (this.currentMinute < 0) {
            this.currentMinute = 58;
            this.decrementHour();
        }
    }

    public void incrementHour() {
        ++this.currentHour;
        if (this.currentHour > 23) {
            this.currentHour = 0;
            this.incrementDay();
        }
    }

    public void decrementHour() {
        --this.currentHour;
        if (this.currentHour < 0) {
            this.currentHour = 23;
            this.decrementDay();
        }
    }

    public void incrementDay() {
        ++this.currentDay;
        if (this.currentDay > 31) {
            this.currentDay = 1;
            this.incrementMonth();
        }
    }

    public void decrementDay() {
        --this.currentDay;
        if (this.currentDay < 1) {
            this.currentDay = 31;
            this.decrementMonth();
        }
    }

    public void incrementMonth() {
        ++this.currentMonth;
        if (this.currentMonth > 12) {
            this.currentMonth = 1;
            ++this.currentYear;
        }
    }

    public void decrementMonth() {
        --this.currentMonth;
        if (this.currentMonth < 1) {
            this.currentMonth = 12;
            --this.currentYear;
        }
    }
}

