/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.seisgram2k.toolmanager;

import java.awt.event.ActionEvent;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import net.alomax.seisgram2k.SeisGram2KFrame;
import net.alomax.seisgram2k.SeisGramText;
import net.alomax.swing.AJLJButton;
import net.alomax.swing.JToolManager;
import net.alomax.swing.JToolManagerException;
import net.alomax.swing.SwingExt;
import net.alomax.timedom.TimeDomainException;

public class RotateToolManager
extends JToolManager {
    protected SeisGram2KFrame seisFrame = null;
    protected static final char CHAR_DEG = '\u00b0';
    protected AJLJButton buttonBigIncreaseRotation;
    protected AJLJButton buttonBigDecreaseRotation;
    protected AJLJButton buttonIncreaseRotation;
    protected AJLJButton buttonDecreaseRotation;
    protected JTextField textFieldRotationAngle = null;
    protected String[] commandNames = new String[0];
    protected String[] commandNamesShort = new String[0];
    protected int variant = 0;
    protected String argumentString = "";

    public RotateToolManager(SeisGram2KFrame seisGram2KFrame) {
        this.seisFrame = seisGram2KFrame;
        this.updateLabel();
        this.commandNames = new String[]{"rotate"};
        this.commandNamesShort = new String[]{"rot"};
    }

    public void updateLabel() {
        this.label = SeisGramText.ROTATE;
        this.button = new AJLJButton(this.seisFrame, this.seisFrame, this.label + "...");
    }

    public boolean useButton() {
        return !this.seisFrame.isSchool() || this.seisFrame.isSchoolExpert();
    }

    public void layoutComponents(JToolBar jToolBar) {
        jToolBar.add(new JLabel(this.label + ":"));
        jToolBar.addSeparator();
        jToolBar.add(new JLabel(SeisGramText.ANGLE + ":", 4));
        this.textFieldRotationAngle = SwingExt.newJTextField(this, this, String.valueOf(this.seisFrame.getActiveGather().getRotationAngle()), 3);
        jToolBar.add(this.textFieldRotationAngle);
        jToolBar.addSeparator();
        if (this.buttonBigDecreaseRotation == null) {
            this.buttonBigDecreaseRotation = new AJLJButton(this, this, "-10\u00b0", true);
        }
        jToolBar.add(this.buttonBigDecreaseRotation);
        if (this.buttonDecreaseRotation == null) {
            this.buttonDecreaseRotation = new AJLJButton(this, this, "-1\u00b0", true);
        }
        jToolBar.add(this.buttonDecreaseRotation);
        if (this.buttonIncreaseRotation == null) {
            this.buttonIncreaseRotation = new AJLJButton(this, this, "+1\u00b0", true);
        }
        jToolBar.add(this.buttonIncreaseRotation);
        if (this.buttonBigIncreaseRotation == null) {
            this.buttonBigIncreaseRotation = new AJLJButton(this, this, "+10\u00b0", true);
        }
        jToolBar.add(this.buttonBigIncreaseRotation);
        jToolBar.addSeparator();
        jToolBar.validate();
    }

    public void updateComponents() {
        if (this.textFieldRotationAngle != null) {
            this.textFieldRotationAngle.setText(String.valueOf(this.seisFrame.getActiveGather().getRotationAngle()));
        }
    }

    public void setAWTStates() {
        this.button.setEnabled(this.seisFrame.getActiveGather() != null && this.seisFrame.getActiveGather().isThreeCompSet());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.buttonBigIncreaseRotation)) {
            this.seisFrame.getActiveGather().setRotationAngle(this.seisFrame.getActiveGather().getRotationAngle() + 10);
        } else if (actionEvent.getSource().equals(this.buttonBigDecreaseRotation)) {
            this.seisFrame.getActiveGather().setRotationAngle(this.seisFrame.getActiveGather().getRotationAngle() - 10);
        } else if (actionEvent.getSource().equals(this.buttonIncreaseRotation)) {
            this.seisFrame.getActiveGather().setRotationAngle(this.seisFrame.getActiveGather().getRotationAngle() + 1);
        } else if (actionEvent.getSource().equals(this.buttonDecreaseRotation)) {
            this.seisFrame.getActiveGather().setRotationAngle(this.seisFrame.getActiveGather().getRotationAngle() - 1);
        } else if (actionEvent.getSource().equals(this.textFieldRotationAngle)) {
            if (this.seisFrame.getActiveGather().setRotationAngle(this.textFieldRotationAngle.getText()) < 0) {
                return;
            }
        } else {
            return;
        }
        this.apply();
    }

    protected void apply() {
        if (this.textFieldRotationAngle != null) {
            this.textFieldRotationAngle.setText(String.valueOf(this.seisFrame.getActiveGather().getRotationAngle()));
        }
        this.seisFrame.writeProcessingMessage(this.getCommandString());
        this.seisFrame.writeEndProcessingMessage();
        this.seisFrame.paintGather();
    }

    public boolean isCommandHandler(String string) {
        String string2 = string.trim().toLowerCase();
        try {
            string2 = string2.substring(0, string2.indexOf(32));
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (int i = 0; i < this.commandNames.length; ++i) {
            if (!string2.equals(this.commandNames[i]) && !string2.equals(this.commandNamesShort[i])) continue;
            this.variant = i;
            return true;
        }
        return false;
    }

    public void applyCommand(String string) throws JToolManagerException {
        if (!this.isCommandHandler(string)) {
            throw new JToolManagerException("Not command handler: " + string);
        }
        String string2 = " ";
        this.argumentString = string;
        StringTokenizer stringTokenizer = new StringTokenizer(this.argumentString);
        try {
            if (this.variant >= 0) {
                while (stringTokenizer.hasMoreTokens()) {
                    string2 = stringTokenizer.nextToken();
                    if (!string2.toLowerCase().startsWith("to")) continue;
                    string2 = stringTokenizer.nextToken();
                }
                if (this.seisFrame.getActiveGather().setRotationAngle(string2) < 0) {
                    throw new TimeDomainException("Invalid rotation angle: " + string2);
                }
                this.apply();
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new JToolManagerException("Parsing or applying command", string, string2);
        }
        catch (TimeDomainException timeDomainException) {
            throw new JToolManagerException("Parsing or applying command: ERROR: " + timeDomainException.toString(), string, string2);
        }
    }

    public String getCommandString() {
        if (this.variant < 0) {
            return "???";
        }
        String string = this.commandNamesShort[this.variant];
        string = string + " to " + String.valueOf(this.seisFrame.getActiveGather().getRotationAngle());
        return string;
    }
}

