/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.timedom;

import net.alomax.math.TimeSeries;
import net.alomax.timedom.TimeDomainException;
import net.alomax.timedom.TimeDomainProcess;
import net.alomax.timedom.TimeDomainText;

public class EnergyDuration
extends TimeDomainProcess {
    public static final double COEFF_MED = 1.55E10;
    public double coeff = 1.55E10;
    private static final double COEFF_MIN = -1.7976931348623157E308;
    private static final double COEFF_MAX = Double.MAX_VALUE;
    public static final double POWER_MED = 1.5;
    public double power = 1.5;
    private static final double POWER_MIN = -1.7976931348623157E308;
    private static final double POWER_MAX = Double.MAX_VALUE;
    public static final String RESULT_VALUE = "VALUE";
    public static final String RESULT_MAGNITUDE = "MAGNITUDE";
    public static final String RESULT_ERROR = "ERROR";
    public static final int VALUE = 0;
    public static final int MAGNITUDE = 1;
    public int resultType = 0;
    public String errorMessage;

    public EnergyDuration(String string, double d, double d2) {
        this.coeff = d;
        this.power = d2;
        this.errorMessage = " ";
        TimeDomainText.setLocale(string);
    }

    public void setCoeff(double d) throws TimeDomainException {
        if (d < -1.7976931348623157E308 || d > Double.MAX_VALUE) {
            throw new TimeDomainException(TimeDomainText.invalid_coeff_value);
        }
        this.coeff = d;
    }

    public void setCoeff(String string) throws TimeDomainException {
        double d;
        try {
            d = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new TimeDomainException(TimeDomainText.invalid_coeff_value);
        }
        this.setCoeff(d);
    }

    public void setPower(double d) throws TimeDomainException {
        if (d < -1.7976931348623157E308 || d > Double.MAX_VALUE) {
            throw new TimeDomainException(TimeDomainText.invalid_power_value);
        }
        this.power = d;
    }

    public void setPower(String string) throws TimeDomainException {
        double d;
        try {
            d = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new TimeDomainException(TimeDomainText.invalid_power_value);
        }
        this.setPower(d);
    }

    public void setResultsType(String string) throws TimeDomainException {
        if (RESULT_VALUE.startsWith(string.toUpperCase())) {
            this.resultType = 0;
        } else if (RESULT_MAGNITUDE.startsWith(string.toUpperCase())) {
            this.resultType = 1;
        } else {
            throw new TimeDomainException(TimeDomainText.invalid_result_value + ": " + string);
        }
    }

    public String getResultsTypeString() {
        if (this.resultType == 0) {
            return RESULT_VALUE;
        }
        if (this.resultType == 1) {
            return RESULT_MAGNITUDE;
        }
        return RESULT_ERROR;
    }

    public void checkSettings() throws TimeDomainException {
        String string = "";
        int n = 0;
        if (this.coeff < -1.7976931348623157E308 || this.coeff > Double.MAX_VALUE) {
            string = string + ": " + TimeDomainText.invalid_coeff_value;
            ++n;
        }
        if (this.power < -1.7976931348623157E308 || this.power > Double.MAX_VALUE) {
            string = string + ": " + TimeDomainText.invalid_power_value;
            ++n;
        }
        if (n > 0) {
            throw new TimeDomainException(string + ".");
        }
    }

    public final float[] apply(double d, float[] fArray) {
        double d2 = Math.log(10.0);
        double d3 = 0.6666666666666666;
        double d4 = 9.1;
        fArray[0] = 0.0f;
        double d5 = d;
        for (int i = 1; i < fArray.length; ++i) {
            double d6 = this.coeff * (double)fArray[i] * Math.pow(d5, this.power);
            if (this.resultType == 0) {
                fArray[i] = (float)d6;
            } else {
                double d7 = d3 * (Math.log(d6) / d2 - d4);
                fArray[i] = (float)d7;
            }
            d5 += d;
        }
        return fArray;
    }

    public void updateFields(TimeSeries timeSeries) {
        timeSeries.ampUnits = timeSeries.timeUnits;
    }

    public boolean amplititudeModified() {
        return true;
    }
}

