# coding: utf-8

"""
    FastAPI

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.2.8
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from perian.models.docker_metadata import DockerMetadata
from perian.models.job_status import JobStatus
from perian.models.price_data import PriceData
from perian.models.requirement_metadata import RequirementMetadata
from perian.models.runtime_metadata import RuntimeMetadata
from typing import Optional, Set
from typing_extensions import Self

class JobView(BaseModel):
    """
    Limited View on Model representation of a perian job.
    """ # noqa: E501
    id: Optional[StrictStr] = None
    status: Optional[JobStatus] = None
    started_at: Optional[datetime] = None
    done_at: Optional[datetime] = None
    logs: Optional[StrictStr] = None
    errors: Optional[StrictStr] = None
    price: Optional[PriceData] = None
    docker_metadata: Optional[DockerMetadata] = None
    requirement_metadata: Optional[RequirementMetadata] = None
    runtime_metadata: Optional[RuntimeMetadata] = None
    created_at: Optional[datetime] = None
    updated_at: Optional[datetime] = None
    __properties: ClassVar[List[str]] = ["id", "status", "started_at", "done_at", "logs", "errors", "price", "docker_metadata", "requirement_metadata", "runtime_metadata", "created_at", "updated_at"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of JobView from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of price
        if self.price:
            _dict['price'] = self.price.to_dict()
        # override the default output from pydantic by calling `to_dict()` of docker_metadata
        if self.docker_metadata:
            _dict['docker_metadata'] = self.docker_metadata.to_dict()
        # override the default output from pydantic by calling `to_dict()` of requirement_metadata
        if self.requirement_metadata:
            _dict['requirement_metadata'] = self.requirement_metadata.to_dict()
        # override the default output from pydantic by calling `to_dict()` of runtime_metadata
        if self.runtime_metadata:
            _dict['runtime_metadata'] = self.runtime_metadata.to_dict()
        # set to None if started_at (nullable) is None
        # and model_fields_set contains the field
        if self.started_at is None and "started_at" in self.model_fields_set:
            _dict['started_at'] = None

        # set to None if done_at (nullable) is None
        # and model_fields_set contains the field
        if self.done_at is None and "done_at" in self.model_fields_set:
            _dict['done_at'] = None

        # set to None if logs (nullable) is None
        # and model_fields_set contains the field
        if self.logs is None and "logs" in self.model_fields_set:
            _dict['logs'] = None

        # set to None if errors (nullable) is None
        # and model_fields_set contains the field
        if self.errors is None and "errors" in self.model_fields_set:
            _dict['errors'] = None

        # set to None if docker_metadata (nullable) is None
        # and model_fields_set contains the field
        if self.docker_metadata is None and "docker_metadata" in self.model_fields_set:
            _dict['docker_metadata'] = None

        # set to None if requirement_metadata (nullable) is None
        # and model_fields_set contains the field
        if self.requirement_metadata is None and "requirement_metadata" in self.model_fields_set:
            _dict['requirement_metadata'] = None

        # set to None if runtime_metadata (nullable) is None
        # and model_fields_set contains the field
        if self.runtime_metadata is None and "runtime_metadata" in self.model_fields_set:
            _dict['runtime_metadata'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of JobView from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "status": obj.get("status"),
            "started_at": obj.get("started_at"),
            "done_at": obj.get("done_at"),
            "logs": obj.get("logs"),
            "errors": obj.get("errors"),
            "price": PriceData.from_dict(obj["price"]) if obj.get("price") is not None else None,
            "docker_metadata": DockerMetadata.from_dict(obj["docker_metadata"]) if obj.get("docker_metadata") is not None else None,
            "requirement_metadata": RequirementMetadata.from_dict(obj["requirement_metadata"]) if obj.get("requirement_metadata") is not None else None,
            "runtime_metadata": RuntimeMetadata.from_dict(obj["runtime_metadata"]) if obj.get("runtime_metadata") is not None else None,
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at")
        })
        return _obj


