"""
pidPIL

This module implements a Python Imaging Library PIDDLE canvas.
In other words, this is a PIDDLE backend that renders into a
PIL Image object.  From there, you can save as GIF, plot into
another PIDDLE canvas, etc.

Joe Strout (joe@strout.net), 10/26/99
modified for use with sping.
This requires Imaging to be installed as a package PIL
"""
from PIL import Image
from PIL import ImageDraw
from PIL import ImageFont
from __future__ import annotations
import _io
import math as math
import os as os
import pickle as pickle
import rdkit.sping.colors
from rdkit.sping.colors import Color
from rdkit.sping.colors import HexColor
import rdkit.sping.pid
from rdkit.sping.pid import AffineMatrix
from rdkit.sping.pid import Canvas
from rdkit.sping.pid import Font
from rdkit.sping.pid import StateSaver
from rdkit.sping.pid import getFileObject
__all__ = ['AffineMatrix', 'Canvas', 'Color', 'Font', 'HexColor', 'Image', 'ImageDraw', 'ImageFont', 'PILCanvas', 'StateSaver', 'aliceblue', 'antiquewhite', 'aqua', 'aquamarine', 'azure', 'beige', 'bisque', 'black', 'blanchedalmond', 'blue', 'blueviolet', 'brown', 'burlywood', 'cadetblue', 'chartreuse', 'chocolate', 'cm', 'coral', 'cornflower', 'cornsilk', 'crimson', 'cyan', 'darkblue', 'darkcyan', 'darkgoldenrod', 'darkgray', 'darkgreen', 'darkkhaki', 'darkmagenta', 'darkolivegreen', 'darkorange', 'darkorchid', 'darkred', 'darksalmon', 'darkseagreen', 'darkslateblue', 'darkslategray', 'darkturquoise', 'darkviolet', 'deeppink', 'deepskyblue', 'dimgray', 'dodgerblue', 'f', 'figureArc', 'figureCurve', 'figureLine', 'firebrick', 'floralwhite', 'forestgreen', 'fuchsia', 'gainsboro', 'getFileObject', 'ghostwhite', 'gold', 'goldenrod', 'gray', 'green', 'greenyellow', 'grey', 'honeydew', 'hotpink', 'inch', 'indianred', 'indigo', 'ivory', 'keyBksp', 'keyClear', 'keyDel', 'keyDown', 'keyEnd', 'keyHome', 'keyLeft', 'keyPgDn', 'keyPgUp', 'keyRight', 'keyTab', 'keyUp', 'khaki', 'lavender', 'lavenderblush', 'lawngreen', 'lemonchiffon', 'lightblue', 'lightcoral', 'lightcyan', 'lightgoldenrodyellow', 'lightgreen', 'lightgrey', 'lightpink', 'lightsalmon', 'lightseagreen', 'lightskyblue', 'lightslategray', 'lightsteelblue', 'lightyellow', 'lime', 'limegreen', 'linen', 'magenta', 'maroon', 'math', 'mediumaquamarine', 'mediumblue', 'mediumorchid', 'mediumpurple', 'mediumseagreen', 'mediumslateblue', 'mediumspringgreen', 'mediumturquoise', 'mediumvioletred', 'midnightblue', 'mintcream', 'mistyrose', 'moccasin', 'modControl', 'modShift', 'navajowhite', 'navy', 'oldlace', 'olive', 'olivedrab', 'orange', 'orangered', 'orchid', 'os', 'palegoldenrod', 'palegreen', 'paleturquoise', 'palevioletred', 'papayawhip', 'peachpuff', 'peru', 'pickle', 'pink', 'plum', 'powderblue', 'purple', 'red', 'rosybrown', 'royalblue', 'saddlebrown', 'salmon', 'sandybrown', 'seagreen', 'seashell', 'sienna', 'silver', 'skyblue', 'slateblue', 'slategray', 'snow', 'springgreen', 'steelblue', 'tan', 'teal', 'test', 'test2', 'testit', 'thistle', 'tomato', 'transparent', 'turquoise', 'violet', 'wheat', 'white', 'whitesmoke', 'yellow', 'yellowgreen']
class PILCanvas(rdkit.sping.pid.Canvas):
    def __init__(self, size = (300, 300), name = 'piddlePIL'):
        ...
    def __setattr__(self, attribute, value):
        ...
    def _setColor(self, c):
        """
        Set the pen color from a piddle color.
        """
    def _setFont(self, font):
        ...
    def clear(self):
        ...
    def drawImage(self, image, x1, y1, x2 = None, y2 = None, **kwargs):
        """
        Draw a PIL Image into the specified rectangle.  If x2 and y2 are
                omitted, they are calculated from the image size.
        """
    def drawLine(self, x1, y1, x2, y2, color = None, width = None, dash = None, **kwargs):
        """
        Draw a straight line between x1,y1 and x2,y2.
        """
    def drawPolygon(self, pointlist, edgeColor = None, edgeWidth = None, fillColor = None, closed = 0, dash = None, **kwargs):
        """
        drawPolygon(pointlist) -- draws a polygon
                pointlist: a list of (x,y) tuples defining vertices
                
        """
    def drawString(self, s, x, y, font = None, color = None, angle = 0, **kwargs):
        """
        Draw a string starting at location x,y.
        """
    def fontAscent(self, font = None):
        """
        Find the ascent (height above base) of the given font.
        """
    def fontDescent(self, font = None):
        """
        Find the descent (extent below base) of the given font.
        """
    def getImage(self):
        ...
    def save(self, file = None, format = None):
        """
        format may be a string specifying a file extension corresponding to
                an image file format. Ex: 'png', 'jpeg', 'gif', 'tif' etc.
                These are defined by PIL, not by us so you need to check the docs.
                In general, I just specify an extension and let format default to None
        """
    def stringWidth(self, s, font = None):
        """
        Return the logical width of the string if it were drawn         in the current font (defaults to self.defaultFont).
        """
def _closestSize(size):
    ...
def _matchingFontPath(font):
    ...
def _pilFont(font):
    ...
def _pilFontPath(face, size, bold = 0):
    ...
def test():
    ...
def test2():
    ...
def testit(canvas, s, x, y, font = None):
    ...
_ascents: dict = {'helvetica-bold-10.pil': 8, 'courier-bold-24.pil': 15, 'courier-24.pil': 14, 'symbol-14.pil': 10, 'times-18.pil': 13, 'times-10.pil': 7, 'symbol-10.pil': 7, 'symbol-8.pil': 6, 'helvetica-24.pil': 19, 'symbol-18.pil': 13, 'times-24.pil': 17, 'times-bold-12.pil': 9, 'times-bold-8.pil': 5, 'courier-bold-12.pil': 8, 'times-14.pil': 10, 'helvetica-14.pil': 11, 'symbol-24.pil': 17, 'helvetica-bold-8.pil': 6, 'times-bold-24.pil': 17, 'courier-bold-10.pil': 6, 'helvetica-10.pil': 8, 'times-bold-10.pil': 7, 'times-8.pil': 5, 'helvetica-bold-24.pil': 19, 'courier-bold-18.pil': 11, 'helvetica-18.pil': 14, 'courier-14.pil': 9, 'helvetica-12.pil': 9, 'courier-bold-14.pil': 9, 'courier-12.pil': 8, 'times-12.pil': 9, 'courier-18.pil': 11, 'helvetica-bold-14.pil': 11, 'times-bold-14.pil': 10, 'symbol-12.pil': 9, 'helvetica-bold-18.pil': 14, 'courier-10.pil': 6, 'helvetica-8.pil': 6, 'courier-bold-8.pil': 5, 'courier-8.pil': 5, 'helvetica-bold-12.pil': 9, 'times-bold-18.pil': 13}
_descents: dict = {'helvetica-bold-10.pil': 2, 'courier-bold-24.pil': 5, 'courier-24.pil': 5, 'symbol-14.pil': 3, 'times-18.pil': 4, 'times-10.pil': 2, 'symbol-10.pil': 2, 'symbol-8.pil': 2, 'helvetica-24.pil': 5, 'symbol-18.pil': 4, 'times-24.pil': 5, 'times-bold-12.pil': 3, 'times-bold-8.pil': 2, 'courier-bold-12.pil': 3, 'times-14.pil': 3, 'helvetica-14.pil': 3, 'symbol-24.pil': 5, 'helvetica-bold-8.pil': 1, 'times-bold-24.pil': 5, 'courier-bold-10.pil': 2, 'helvetica-10.pil': 2, 'times-bold-10.pil': 3, 'times-8.pil': 1, 'helvetica-bold-24.pil': 5, 'courier-bold-18.pil': 4, 'helvetica-18.pil': 4, 'courier-14.pil': 3, 'helvetica-12.pil': 3, 'courier-bold-14.pil': 3, 'courier-12.pil': 3, 'times-12.pil': 3, 'courier-18.pil': 4, 'helvetica-bold-14.pil': 3, 'times-bold-14.pil': 3, 'symbol-12.pil': 3, 'helvetica-bold-18.pil': 4, 'courier-10.pil': 2, 'helvetica-8.pil': 1, 'courier-bold-8.pil': 1, 'courier-8.pil': 2, 'helvetica-bold-12.pil': 3, 'times-bold-18.pil': 4}
_fontprefix: str = '/project/build/temp.linux-aarch64-cpython-310/rdkit_install/lib/python3.10/site-packages/rdkit/sping/PIL/pilfonts'
_widthmaps: dict = {'helvetica-bold-10.pil': {'\x7f': 0, '}': 5, '{': 5, 'y': 6, 'w': 8, 'u': 6, 's': 6, 'q': 6, 'o': 6, 'm': 9, 'k': 6, 'i': 3, 'g': 6, 'e': 6, 'c': 5, 'a': 6, '_': 6, ']': 4, '[': 4, 'Y': 9, 'W': 11, 'U': 7, 'S': 7, 'Q': 8, 'O': 8, 'M': 10, 'K': 7, 'I': 3, 'G': 8, 'E': 6, 'C': 8, 'A': 8, '?': 6, '=': 6, ';': 3, '9': 6, '7': 6, '5': 6, '3': 6, '1': 6, '/': 4, '-': 7, '+': 6, ')': 4, "'": 3, '%': 8, '#': 6, '!': 4, '~': 6, '|': 3, 'z': 6, 'x': 7, 'v': 6, 't': 4, 'r': 4, 'p': 6, 'n': 6, 'l': 3, 'j': 3, 'h': 6, 'f': 4, 'd': 6, 'b': 6, '`': 3, '^': 5, '\\': 4, 'Z': 7, 'X': 8, 'V': 8, 'T': 7, 'R': 7, 'P': 7, 'N': 8, 'L': 6, 'J': 6, 'H': 7, 'F': 6, 'D': 7, 'B': 7, '@': 11, '>': 5, '<': 5, ':': 3, '8': 6, '6': 6, '4': 6, '2': 6, '0': 6, '.': 3, ',': 3, '*': 4, '(': 4, '&': 8, '$': 6, '"': 5, ' ': 3}, 'courier-bold-24.pil': {'\x7f': 0, '}': 15, '{': 15, 'y': 15, 'w': 15, 'u': 15, 's': 15, 'q': 15, 'o': 15, 'm': 15, 'k': 15, 'i': 15, 'g': 15, 'e': 15, 'c': 15, 'a': 15, '_': 15, ']': 15, '[': 15, 'Y': 15, 'W': 15, 'U': 15, 'S': 15, 'Q': 15, 'O': 15, 'M': 15, 'K': 15, 'I': 15, 'G': 15, 'E': 15, 'C': 15, 'A': 15, '?': 15, '=': 15, ';': 15, '9': 15, '7': 15, '5': 15, '3': 15, '1': 15, '/': 15, '-': 15, '+': 15, ')': 15, "'": 15, '%': 15, '#': 15, '!': 15, '~': 15, '|': 15, 'z': 15, 'x': 15, 'v': 15, 't': 15, 'r': 15, 'p': 15, 'n': 15, 'l': 15, 'j': 15, 'h': 15, 'f': 15, 'd': 15, 'b': 15, '`': 15, '^': 15, '\\': 15, 'Z': 15, 'X': 15, 'V': 15, 'T': 15, 'R': 15, 'P': 15, 'N': 15, 'L': 15, 'J': 15, 'H': 15, 'F': 15, 'D': 15, 'B': 15, '@': 15, '>': 15, '<': 15, ':': 15, '8': 15, '6': 15, '4': 15, '2': 15, '0': 15, '.': 15, ',': 15, '*': 15, '(': 15, '&': 15, '$': 15, '"': 15, ' ': 15}, 'courier-24.pil': {'\x7f': 0, '}': 15, '{': 15, 'y': 15, 'w': 15, 'u': 15, 's': 15, 'q': 15, 'o': 15, 'm': 15, 'k': 15, 'i': 15, 'g': 15, 'e': 15, 'c': 15, 'a': 15, '_': 15, ']': 15, '[': 15, 'Y': 15, 'W': 15, 'U': 15, 'S': 15, 'Q': 15, 'O': 15, 'M': 15, 'K': 15, 'I': 15, 'G': 15, 'E': 15, 'C': 15, 'A': 15, '?': 15, '=': 15, ';': 15, '9': 15, '7': 15, '5': 15, '3': 15, '1': 15, '/': 15, '-': 15, '+': 15, ')': 15, "'": 15, '%': 15, '#': 15, '!': 15, '~': 15, '|': 15, 'z': 15, 'x': 15, 'v': 15, 't': 15, 'r': 15, 'p': 15, 'n': 15, 'l': 15, 'j': 15, 'h': 15, 'f': 15, 'd': 15, 'b': 15, '`': 15, '^': 15, '\\': 15, 'Z': 15, 'X': 15, 'V': 15, 'T': 15, 'R': 15, 'P': 15, 'N': 15, 'L': 15, 'J': 15, 'H': 15, 'F': 15, 'D': 15, 'B': 15, '@': 15, '>': 15, '<': 15, ':': 15, '8': 15, '6': 15, '4': 15, '2': 15, '0': 15, '.': 15, ',': 15, '*': 15, '(': 15, '&': 15, '$': 15, '"': 15, ' ': 15}, 'symbol-14.pil': {'\x7f': 0, '}': 7, '{': 7, 'y': 9, 'w': 11, 'u': 8, 's': 8, 'q': 7, 'o': 8, 'm': 8, 'k': 8, 'i': 5, 'g': 6, 'e': 6, 'c': 8, 'a': 9, '_': 7, ']': 5, '[': 5, 'Y': 11, 'W': 11, 'U': 9, 'S': 9, 'Q': 10, 'O': 10, 'M': 13, 'K': 10, 'I': 5, 'G': 9, 'E': 9, 'C': 11, 'A': 11, '?': 6, '=': 8, ';': 4, '9': 7, '7': 7, '5': 7, '3': 7, '1': 7, '/': 4, '-': 8, '+': 8, ')': 5, "'": 6, '%': 12, '#': 7, '!': 5, '~': 8, '|': 3, 'z': 7, 'x': 7, 'v': 11, 't': 6, 'r': 8, 'p': 8, 'n': 8, 'l': 8, 'j': 9, 'h': 8, 'f': 9, 'd': 7, 'b': 8, '`': 7, '^': 10, '\\': 10, 'Z': 9, 'X': 9, 'V': 7, 'T': 9, 'R': 8, 'P': 11, 'N': 11, 'L': 10, 'J': 9, 'H': 11, 'F': 11, 'D': 9, 'B': 9, '@': 8, '>': 8, '<': 8, ':': 4, '8': 7, '6': 7, '4': 7, '2': 7, '0': 7, '.': 3, ',': 3, '*': 7, '(': 5, '&': 11, '$': 8, '"': 9, ' ': 4}, 'times-18.pil': {'\x7f': 0, '}': 9, '{': 9, 'y': 8, 'w': 12, 'u': 9, 's': 7, 'q': 9, 'o': 9, 'm': 15, 'k': 9, 'i': 5, 'g': 8, 'e': 8, 'c': 8, 'a': 8, '_': 9, ']': 6, '[': 6, 'Y': 12, 'W': 18, 'U': 13, 'S': 10, 'Q': 14, 'O': 14, 'M': 16, 'K': 13, 'I': 6, 'G': 14, 'E': 11, 'C': 12, 'A': 15, '?': 8, '=': 10, ';': 4, '9': 9, '7': 9, '5': 9, '3': 9, '1': 9, '/': 5, '-': 10, '+': 10, ')': 7, "'": 5, '%': 15, '#': 10, '!': 4, '~': 11, '|': 3, 'z': 8, 'x': 9, 'v': 9, 't': 6, 'r': 7, 'p': 9, 'n': 10, 'l': 5, 'j': 5, 'h': 10, 'f': 6, 'd': 9, 'b': 9, '`': 5, '^': 9, '\\': 5, 'Z': 12, 'X': 12, 'V': 13, 'T': 12, 'R': 12, 'P': 10, 'N': 13, 'L': 11, 'J': 7, 'H': 13, 'F': 11, 'D': 13, 'B': 12, '@': 17, '>': 11, '<': 11, ':': 4, '8': 9, '6': 9, '4': 9, '2': 9, '0': 9, '.': 4, ',': 4, '*': 9, '(': 7, '&': 14, '$': 9, '"': 8, ' ': 4}, 'times-10.pil': {'\x7f': 0, '}': 4, '{': 4, 'y': 5, 'w': 8, 'u': 5, 's': 4, 'q': 5, 'o': 5, 'm': 8, 'k': 5, 'i': 3, 'g': 5, 'e': 4, 'c': 4, 'a': 4, '_': 5, ']': 3, '[': 3, 'Y': 8, 'W': 10, 'U': 8, 'S': 5, 'Q': 7, 'O': 7, 'M': 10, 'K': 7, 'I': 4, 'G': 7, 'E': 6, 'C': 7, 'A': 8, '?': 4, '=': 6, ';': 3, '9': 5, '7': 5, '5': 5, '3': 5, '1': 5, '/': 3, '-': 7, '+': 6, ')': 4, "'": 3, '%': 8, '#': 5, '!': 3, '~': 7, '|': 2, 'z': 5, 'x': 6, 'v': 5, 't': 4, 'r': 4, 'p': 5, 'n': 5, 'l': 4, 'j': 3, 'h': 5, 'f': 4, 'd': 5, 'b': 5, '`': 3, '^': 5, '\\': 3, 'Z': 6, 'X': 8, 'V': 8, 'T': 6, 'R': 7, 'P': 6, 'N': 8, 'L': 6, 'J': 4, 'H': 8, 'F': 6, 'D': 7, 'B': 6, '@': 9, '>': 5, '<': 5, ':': 3, '8': 5, '6': 5, '4': 5, '2': 5, '0': 5, '.': 3, ',': 3, '*': 5, '(': 4, '&': 8, '$': 5, '"': 4, ' ': 2}, 'symbol-10.pil': {'\x7f': 0, '}': 5, '{': 5, 'y': 7, 'w': 8, 'u': 6, 's': 6, 'q': 5, 'o': 5, 'm': 6, 'k': 6, 'i': 4, 'g': 6, 'e': 5, 'c': 6, 'a': 7, '_': 5, ']': 3, '[': 3, 'Y': 9, 'W': 9, 'U': 8, 'S': 6, 'Q': 7, 'O': 7, 'M': 10, 'K': 7, 'I': 3, 'G': 6, 'E': 6, 'C': 8, 'A': 8, '?': 5, '=': 6, ';': 2, '9': 5, '7': 5, '5': 5, '3': 5, '1': 5, '/': 3, '-': 6, '+': 6, ')': 4, "'": 5, '%': 8, '#': 5, '!': 3, '~': 6, '|': 2, 'z': 5, 'x': 5, 'v': 8, 't': 5, 'r': 5, 'p': 6, 'n': 6, 'l': 6, 'j': 6, 'h': 6, 'f': 6, 'd': 5, 'b': 5, '`': 5, '^': 7, '\\': 7, 'Z': 6, 'X': 7, 'V': 5, 'T': 6, 'R': 6, 'P': 8, 'N': 8, 'L': 7, 'J': 7, 'H': 8, 'F': 8, 'D': 7, 'B': 6, '@': 6, '>': 6, '<': 7, ':': 2, '8': 5, '6': 5, '4': 5, '2': 5, '0': 5, '.': 2, ',': 2, '*': 5, '(': 4, '&': 7, '$': 6, '"': 7, ' ': 3}, 'symbol-8.pil': {'\x7f': 0, '}': 4, '{': 4, 'y': 6, 'w': 6, 'u': 5, 's': 5, 'q': 4, 'o': 4, 'm': 5, 'k': 5, 'i': 3, 'g': 5, 'e': 4, 'c': 5, 'a': 6, '_': 4, ']': 2, '[': 2, 'Y': 7, 'W': 7, 'U': 6, 'S': 5, 'Q': 6, 'O': 6, 'M': 8, 'K': 6, 'I': 2, 'G': 5, 'E': 5, 'C': 6, 'A': 6, '?': 4, '=': 5, ';': 2, '9': 4, '7': 4, '5': 4, '3': 4, '1': 4, '/': 2, '-': 5, '+': 5, ')': 3, "'": 4, '%': 6, '#': 4, '!': 2, '~': 5, '|': 2, 'z': 4, 'x': 4, 'v': 6, 't': 4, 'r': 4, 'p': 5, 'n': 5, 'l': 5, 'j': 5, 'h': 5, 'f': 5, 'd': 4, 'b': 4, '`': 4, '^': 6, '\\': 6, 'Z': 5, 'X': 6, 'V': 4, 'T': 5, 'R': 5, 'P': 6, 'N': 6, 'L': 6, 'J': 6, 'H': 6, 'F': 6, 'D': 6, 'B': 5, '@': 5, '>': 5, '<': 6, ':': 2, '8': 4, '6': 4, '4': 4, '2': 4, '0': 4, '.': 2, ',': 2, '*': 4, '(': 3, '&': 6, '$': 5, '"': 6, ' ': 2}, 'helvetica-24.pil': {'\x7f': 0, '}': 8, '{': 8, 'y': 13, 'w': 18, 'u': 14, 's': 12, 'q': 14, 'o': 13, 'm': 20, 'k': 12, 'i': 6, 'g': 14, 'e': 13, 'c': 12, 'a': 13, '_': 14, ']': 7, '[': 7, 'Y': 16, 'W': 22, 'U': 18, 'S': 16, 'Q': 18, 'O': 18, 'M': 21, 'K': 18, 'I': 8, 'G': 19, 'E': 16, 'C': 18, 'A': 17, '?': 12, '=': 15, ';': 6, '9': 13, '7': 13, '5': 13, '3': 13, '1': 13, '/': 7, '-': 15, '+': 14, ')': 8, "'": 6, '%': 22, '#': 14, '!': 6, '~': 14, '|': 6, 'z': 12, 'x': 12, 'v': 13, 't': 8, 'r': 9, 'p': 14, 'n': 14, 'l': 6, 'j': 6, 'h': 13, 'f': 8, 'd': 14, 'b': 14, '`': 6, '^': 12, '\\': 7, 'Z': 15, 'X': 17, 'V': 17, 'T': 16, 'R': 17, 'P': 16, 'N': 18, 'L': 14, 'J': 13, 'H': 18, 'F': 14, 'D': 18, 'B': 17, '@': 25, '>': 15, '<': 15, ':': 6, '8': 13, '6': 13, '4': 13, '2': 13, '0': 13, '.': 6, ',': 6, '*': 10, '(': 8, '&': 17, '$': 13, '"': 8, ' ': 6}, 'symbol-18.pil': {'\x7f': 0, '}': 9, '{': 9, 'y': 13, 'w': 12, 'u': 11, 's': 11, 'q': 10, 'o': 10, 'm': 11, 'k': 10, 'i': 6, 'g': 8, 'e': 8, 'c': 10, 'a': 12, '_': 9, ']': 6, '[': 6, 'Y': 15, 'W': 14, 'U': 13, 'S': 11, 'Q': 13, 'O': 13, 'M': 16, 'K': 14, 'I': 6, 'G': 11, 'E': 11, 'C': 14, 'A': 14, '?': 8, '=': 10, ';': 5, '9': 9, '7': 9, '5': 9, '3': 9, '1': 9, '/': 5, '-': 9, '+': 10, ')': 6, "'": 8, '%': 15, '#': 9, '!': 6, '~': 10, '|': 4, 'z': 9, 'x': 9, 'v': 12, 't': 8, 'r': 10, 'p': 10, 'n': 10, 'l': 10, 'j': 11, 'h': 11, 'f': 11, 'd': 9, 'b': 10, '`': 9, '^': 12, '\\': 14, 'Z': 11, 'X': 12, 'V': 8, 'T': 12, 'R': 10, 'P': 13, 'N': 13, 'L': 13, 'J': 12, 'H': 13, 'F': 14, 'D': 11, 'B': 11, '@': 10, '>': 10, '<': 10, ':': 5, '8': 9, '6': 9, '4': 9, '2': 9, '0': 9, '.': 4, ',': 5, '*': 9, '(': 6, '&': 13, '$': 10, '"': 13, ' ': 5}, 'times-24.pil': {'\x7f': 0, '}': 10, '{': 10, 'y': 11, 'w': 17, 'u': 13, 's': 10, 'q': 12, 'o': 12, 'm': 20, 'k': 12, 'i': 6, 'g': 12, 'e': 11, 'c': 11, 'a': 11, '_': 13, ']': 8, '[': 8, 'Y': 16, 'W': 23, 'U': 18, 'S': 13, 'Q': 18, 'O': 18, 'M': 22, 'K': 17, 'I': 8, 'G': 18, 'E': 15, 'C': 16, 'A': 17, '?': 11, '=': 14, ';': 7, '9': 12, '7': 12, '5': 12, '3': 12, '1': 12, '/': 7, '-': 14, '+': 14, ')': 8, "'": 8, '%': 19, '#': 13, '!': 8, '~': 13, '|': 6, 'z': 10, 'x': 13, 'v': 11, 't': 7, 'r': 8, 'p': 12, 'n': 13, 'l': 6, 'j': 6, 'h': 13, 'f': 7, 'd': 12, 'b': 12, '`': 7, '^': 11, '\\': 7, 'Z': 15, 'X': 18, 'V': 17, 'T': 16, 'R': 16, 'P': 15, 'N': 18, 'L': 14, 'J': 11, 'H': 19, 'F': 14, 'D': 17, 'B': 16, '@': 22, '>': 13, '<': 13, ':': 6, '8': 12, '6': 12, '4': 12, '2': 12, '0': 12, '.': 6, ',': 7, '*': 12, '(': 8, '&': 18, '$': 12, '"': 10, ' ': 6}, 'times-bold-12.pil': {'\x7f': 0, '}': 5, '{': 5, 'y': 6, 'w': 9, 'u': 6, 's': 6, 'q': 6, 'o': 7, 'm': 9, 'k': 7, 'i': 3, 'g': 6, 'e': 7, 'c': 6, 'a': 7, '_': 6, ']': 4, '[': 4, 'Y': 9, 'W': 12, 'U': 9, 'S': 7, 'Q': 9, 'O': 9, 'M': 11, 'K': 10, 'I': 5, 'G': 9, 'E': 8, 'C': 8, 'A': 9, '?': 7, '=': 7, ';': 4, '9': 6, '7': 6, '5': 6, '3': 6, '1': 6, '/': 4, '-': 7, '+': 7, ')': 4, "'": 4, '%': 12, '#': 6, '!': 4, '~': 7, '|': 3, 'z': 6, 'x': 6, 'v': 6, 't': 4, 'r': 5, 'p': 6, 'n': 6, 'l': 3, 'j': 3, 'h': 6, 'f': 4, 'd': 6, 'b': 6, '`': 4, '^': 7, '\\': 3, 'Z': 8, 'X': 9, 'V': 9, 'T': 9, 'R': 9, 'P': 8, 'N': 9, 'L': 8, 'J': 7, 'H': 10, 'F': 8, 'D': 9, 'B': 9, '@': 12, '>': 8, '<': 7, ':': 4, '8': 6, '6': 6, '4': 6, '2': 6, '0': 6, '.': 4, ',': 4, '*': 6, '(': 4, '&': 10, '$': 6, '"': 5, ' ': 3}, 'times-bold-8.pil': {'\x7f': 0, '}': 3, '{': 3, 'y': 4, 'w': 5, 'u': 4, 's': 3, 'q': 4, 'o': 5, 'm': 6, 'k': 4, 'i': 2, 'g': 4, 'e': 4, 'c': 4, 'a': 4, '_': 4, ']': 3, '[': 3, 'Y': 6, 'W': 8, 'U': 6, 'S': 5, 'Q': 6, 'O': 6, 'M': 8, 'K': 6, 'I': 4, 'G': 6, 'E': 6, 'C': 6, 'A': 6, '?': 5, '=': 5, ';': 3, '9': 4, '7': 4, '5': 4, '3': 4, '1': 4, '/': 2, '-': 5, '+': 5, ')': 3, "'": 3, '%': 7, '#': 5, '!': 3, '~': 5, '|': 2, 'z': 4, 'x': 4, 'v': 4, 't': 3, 'r': 3, 'p': 4, 'n': 5, 'l': 2, 'j': 3, 'h': 4, 'f': 2, 'd': 5, 'b': 4, '`': 3, '^': 5, '\\': 2, 'Z': 6, 'X': 6, 'V': 6, 'T': 6, 'R': 6, 'P': 5, 'N': 6, 'L': 6, 'J': 4, 'H': 7, 'F': 6, 'D': 6, 'B': 6, '@': 9, '>': 5, '<': 5, ':': 3, '8': 4, '6': 4, '4': 4, '2': 4, '0': 4, '.': 2, ',': 3, '*': 5, '(': 2, '&': 7, '$': 4, '"': 4, ' ': 2}, 'courier-bold-12.pil': {'\x7f': 0, '}': 7, '{': 7, 'y': 7, 'w': 7, 'u': 7, 's': 7, 'q': 7, 'o': 7, 'm': 7, 'k': 7, 'i': 7, 'g': 7, 'e': 7, 'c': 7, 'a': 7, '_': 7, ']': 7, '[': 7, 'Y': 7, 'W': 7, 'U': 7, 'S': 7, 'Q': 7, 'O': 7, 'M': 7, 'K': 7, 'I': 7, 'G': 7, 'E': 7, 'C': 7, 'A': 7, '?': 7, '=': 7, ';': 7, '9': 7, '7': 7, '5': 7, '3': 7, '1': 7, '/': 7, '-': 7, '+': 7, ')': 7, "'": 7, '%': 7, '#': 7, '!': 7, '~': 7, '|': 7, 'z': 7, 'x': 7, 'v': 7, 't': 7, 'r': 7, 'p': 7, 'n': 7, 'l': 7, 'j': 7, 'h': 7, 'f': 7, 'd': 7, 'b': 7, '`': 7, '^': 7, '\\': 7, 'Z': 7, 'X': 7, 'V': 7, 'T': 7, 'R': 7, 'P': 7, 'N': 7, 'L': 7, 'J': 7, 'H': 7, 'F': 7, 'D': 7, 'B': 7, '@': 7, '>': 7, '<': 7, ':': 7, '8': 7, '6': 7, '4': 7, '2': 7, '0': 7, '.': 7, ',': 7, '*': 7, '(': 7, '&': 7, '$': 7, '"': 7, ' ': 7}, 'times-14.pil': {'\x7f': 0, '}': 7, '{': 7, 'y': 7, 'w': 11, 'u': 7, 's': 6, 'q': 7, 'o': 7, 'm': 11, 'k': 7, 'i': 3, 'g': 7, 'e': 7, 'c': 7, 'a': 7, '_': 7, ']': 5, '[': 5, 'Y': 9, 'W': 13, 'U': 10, 'S': 8, 'Q': 10, 'O': 10, 'M': 13, 'K': 10, 'I': 5, 'G': 11, 'E': 9, 'C': 10, 'A': 11, '?': 6, '=': 8, ';': 4, '9': 7, '7': 7, '5': 7, '3': 7, '1': 7, '/': 4, '-': 9, '+': 8, ')': 5, "'": 4, '%': 12, '#': 7, '!': 5, '~': 8, '|': 3, 'z': 6, 'x': 7, 'v': 7, 't': 4, 'r': 5, 'p': 7, 'n': 7, 'l': 3, 'j': 4, 'h': 7, 'f': 4, 'd': 7, 'b': 7, '`': 4, '^': 7, '\\': 4, 'Z': 8, 'X': 10, 'V': 9, 'T': 9, 'R': 9, 'P': 8, 'N': 11, 'L': 9, 'J': 6, 'H': 10, 'F': 8, 'D': 10, 'B': 9, '@': 13, '>': 8, '<': 8, ':': 4, '8': 7, '6': 7, '4': 7, '2': 7, '0': 7, '.': 3, ',': 3, '*': 7, '(': 5, '&': 11, '$': 7, '"': 6, ' ': 3}, 'helvetica-14.pil': {'\x7f': 0, '}': 5, '{': 5, 'y': 7, 'w': 10, 'u': 8, 's': 8, 'q': 8, 'o': 8, 'm': 11, 'k': 7, 'i': 3, 'g': 8, 'e': 8, 'c': 8, 'a': 8, '_': 8, ']': 4, '[': 4, 'Y': 9, 'W': 15, 'U': 10, 'S': 9, 'Q': 11, 'O': 11, 'M': 13, 'K': 10, 'I': 5, 'G': 11, 'E': 9, 'C': 10, 'A': 11, '?': 8, '=': 9, ';': 4, '9': 8, '7': 8, '5': 8, '3': 8, '1': 8, '/': 4, '-': 9, '+': 9, ')': 5, "'": 3, '%': 12, '#': 8, '!': 4, '~': 8, '|': 3, 'z': 7, 'x': 7, 'v': 8, 't': 4, 'r': 5, 'p': 8, 'n': 8, 'l': 3, 'j': 3, 'h': 8, 'f': 3, 'd': 8, 'b': 8, '`': 3, '^': 7, '\\': 4, 'Z': 9, 'X': 10, 'V': 11, 'T': 9, 'R': 9, 'P': 9, 'N': 10, 'L': 8, 'J': 8, 'H': 10, 'F': 9, 'D': 10, 'B': 9, '@': 13, '>': 8, '<': 8, ':': 3, '8': 8, '6': 8, '4': 8, '2': 8, '0': 8, '.': 3, ',': 3, '*': 7, '(': 5, '&': 10, '$': 8, '"': 5, ' ': 4}, 'symbol-24.pil': {'\x7f': 0, '}': 10, '{': 10, 'y': 18, 'w': 16, 'u': 14, 's': 15, 'q': 12, 'o': 13, 'm': 14, 'k': 14, 'i': 8, 'g': 11, 'e': 11, 'c': 14, 'a': 16, '_': 13, ']': 8, '[': 8, 'Y': 20, 'W': 18, 'U': 16, 'S': 14, 'Q': 18, 'O': 18, 'M': 22, 'K': 17, 'I': 8, 'G': 15, 'E': 15, 'C': 18, 'A': 18, '?': 11, '=': 12, ';': 6, '9': 12, '7': 12, '5': 12, '3': 12, '1': 12, '/': 7, '-': 13, '+': 12, ')': 8, "'": 11, '%': 20, '#': 13, '!': 7, '~': 13, '|': 4, 'z': 12, 'x': 12, 'v': 18, 't': 11, 'r': 12, 'p': 14, 'n': 13, 'l': 14, 'j': 14, 'h': 15, 'f': 14, 'd': 12, 'b': 12, '`': 13, '^': 16, '\\': 18, 'Z': 15, 'X': 16, 'V': 11, 'T': 16, 'R': 14, 'P': 18, 'N': 18, 'L': 17, 'J': 16, 'H': 18, 'F': 19, 'D': 15, 'B': 15, '@': 13, '>': 13, '<': 13, ':': 6, '8': 12, '6': 12, '4': 12, '2': 12, '0': 12, '.': 6, ',': 6, '*': 12, '(': 8, '&': 17, '$': 13, '"': 17, ' ': 6}, 'helvetica-bold-8.pil': {'\x7f': 0, '}': 4, '{': 4, 'y': 5, 'w': 6, 'u': 5, 's': 5, 'q': 5, 'o': 5, 'm': 7, 'k': 5, 'i': 2, 'g': 5, 'e': 5, 'c': 4, 'a': 5, '_': 5, ']': 3, '[': 3, 'Y': 7, 'W': 9, 'U': 6, 'S': 6, 'Q': 6, 'O': 6, 'M': 8, 'K': 6, 'I': 2, 'G': 6, 'E': 5, 'C': 6, 'A': 6, '?': 5, '=': 5, ';': 2, '9': 5, '7': 5, '5': 5, '3': 5, '1': 5, '/': 3, '-': 6, '+': 5, ')': 3, "'": 2, '%': 6, '#': 5, '!': 3, '~': 5, '|': 2, 'z': 5, 'x': 6, 'v': 5, 't': 3, 'r': 3, 'p': 5, 'n': 5, 'l': 2, 'j': 2, 'h': 5, 'f': 3, 'd': 5, 'b': 5, '`': 2, '^': 4, '\\': 3, 'Z': 6, 'X': 6, 'V': 6, 'T': 6, 'R': 6, 'P': 6, 'N': 6, 'L': 5, 'J': 5, 'H': 6, 'F': 5, 'D': 6, 'B': 6, '@': 9, '>': 4, '<': 4, ':': 2, '8': 5, '6': 5, '4': 5, '2': 5, '0': 5, '.': 2, ',': 2, '*': 3, '(': 3, '&': 6, '$': 5, '"': 4, ' ': 2}, 'times-bold-24.pil': {'\x7f': 0, '}': 10, '{': 10, 'y': 12, 'w': 18, 'u': 14, 's': 10, 'q': 14, 'o': 13, 'm': 21, 'k': 15, 'i': 7, 'g': 12, 'e': 11, 'c': 11, 'a': 12, '_': 13, ']': 8, '[': 8, 'Y': 18, 'W': 25, 'U': 18, 'S': 14, 'Q': 19, 'O': 19, 'M': 24, 'K': 19, 'I': 10, 'G': 19, 'E': 17, 'C': 18, 'A': 18, '?': 12, '=': 14, ';': 8, '9': 12, '7': 12, '5': 12, '3': 12, '1': 12, '/': 7, '-': 15, '+': 14, ')': 8, "'": 8, '%': 19, '#': 13, '!': 8, '~': 13, '|': 6, 'z': 11, 'x': 12, 'v': 12, 't': 8, 'r': 11, 'p': 14, 'n': 14, 'l': 7, 'j': 8, 'h': 14, 'f': 8, 'd': 14, 'b': 13, '`': 8, '^': 15, '\\': 7, 'Z': 17, 'X': 18, 'V': 18, 'T': 16, 'R': 18, 'P': 15, 'N': 18, 'L': 16, 'J': 12, 'H': 19, 'F': 15, 'D': 18, 'B': 16, '@': 23, '>': 14, '<': 14, ':': 8, '8': 12, '6': 12, '4': 12, '2': 12, '0': 12, '.': 6, ',': 6, '*': 13, '(': 8, '&': 21, '$': 12, '"': 12, ' ': 6}, 'courier-bold-10.pil': {'\x7f': 0, '}': 6, '{': 6, 'y': 6, 'w': 6, 'u': 6, 's': 6, 'q': 6, 'o': 6, 'm': 6, 'k': 6, 'i': 6, 'g': 6, 'e': 6, 'c': 6, 'a': 6, '_': 6, ']': 6, '[': 6, 'Y': 6, 'W': 6, 'U': 6, 'S': 6, 'Q': 6, 'O': 6, 'M': 6, 'K': 6, 'I': 6, 'G': 6, 'E': 6, 'C': 6, 'A': 6, '?': 6, '=': 6, ';': 6, '9': 6, '7': 6, '5': 6, '3': 6, '1': 6, '/': 6, '-': 6, '+': 6, ')': 6, "'": 6, '%': 6, '#': 6, '!': 6, '~': 6, '|': 6, 'z': 6, 'x': 6, 'v': 6, 't': 6, 'r': 6, 'p': 6, 'n': 6, 'l': 6, 'j': 6, 'h': 6, 'f': 6, 'd': 6, 'b': 6, '`': 6, '^': 6, '\\': 6, 'Z': 6, 'X': 6, 'V': 6, 'T': 6, 'R': 6, 'P': 6, 'N': 6, 'L': 6, 'J': 6, 'H': 6, 'F': 6, 'D': 6, 'B': 6, '@': 6, '>': 6, '<': 6, ':': 6, '8': 6, '6': 6, '4': 6, '2': 6, '0': 6, '.': 6, ',': 6, '*': 6, '(': 6, '&': 6, '$': 6, '"': 6, ' ': 6}, 'helvetica-10.pil': {'\x7f': 0, '}': 3, '{': 3, 'y': 5, 'w': 8, 'u': 5, 's': 5, 'q': 6, 'o': 6, 'm': 8, 'k': 5, 'i': 2, 'g': 6, 'e': 5, 'c': 5, 'a': 5, '_': 6, ']': 3, '[': 3, 'Y': 7, 'W': 9, 'U': 8, 'S': 7, 'Q': 8, 'O': 8, 'M': 9, 'K': 7, 'I': 3, 'G': 8, 'E': 7, 'C': 8, 'A': 7, '?': 6, '=': 5, ';': 3, '9': 6, '7': 6, '5': 6, '3': 6, '1': 6, '/': 3, '-': 7, '+': 6, ')': 4, "'": 3, '%': 9, '#': 6, '!': 3, '~': 7, '|': 3, 'z': 5, 'x': 6, 'v': 6, 't': 4, 'r': 4, 'p': 6, 'n': 6, 'l': 2, 'j': 2, 'h': 6, 'f': 4, 'd': 6, 'b': 6, '`': 3, '^': 6, '\\': 3, 'Z': 7, 'X': 7, 'V': 7, 'T': 5, 'R': 7, 'P': 7, 'N': 8, 'L': 6, 'J': 5, 'H': 8, 'F': 6, 'D': 8, 'B': 7, '@': 11, '>': 6, '<': 6, ':': 3, '8': 6, '6': 6, '4': 6, '2': 6, '0': 6, '.': 3, ',': 3, '*': 4, '(': 4, '&': 8, '$': 6, '"': 4, ' ': 3}, 'times-bold-10.pil': {'\x7f': 0, '}': 4, '{': 4, 'y': 5, 'w': 6, 'u': 5, 's': 4, 'q': 5, 'o': 6, 'm': 8, 'k': 5, 'i': 3, 'g': 5, 'e': 5, 'c': 5, 'a': 5, '_': 5, ']': 4, '[': 4, 'Y': 8, 'W': 10, 'U': 7, 'S': 6, 'Q': 7, 'O': 7, 'M': 10, 'K': 8, 'I': 5, 'G': 7, 'E': 7, 'C': 7, 'A': 7, '?': 6, '=': 6, ';': 4, '9': 5, '7': 5, '5': 5, '3': 5, '1': 5, '/': 3, '-': 7, '+': 6, ')': 4, "'": 4, '%': 9, '#': 6, '!': 4, '~': 6, '|': 3, 'z': 5, 'x': 5, 'v': 5, 't': 4, 'r': 4, 'p': 5, 'n': 6, 'l': 3, 'j': 4, 'h': 5, 'f': 3, 'd': 6, 'b': 5, '`': 4, '^': 6, '\\': 3, 'Z': 7, 'X': 7, 'V': 8, 'T': 7, 'R': 7, 'P': 6, 'N': 8, 'L': 7, 'J': 5, 'H': 9, 'F': 7, 'D': 8, 'B': 7, '@': 11, '>': 6, '<': 6, ':': 4, '8': 5, '6': 5, '4': 5, '2': 5, '0': 5, '.': 3, ',': 4, '*': 6, '(': 4, '&': 9, '$': 5, '"': 5, ' ': 2}, 'times-8.pil': {'\x7f': 0, '}': 3, '{': 3, 'y': 4, 'w': 6, 'u': 4, 's': 3, 'q': 4, 'o': 4, 'm': 6, 'k': 4, 'i': 2, 'g': 4, 'e': 4, 'c': 4, 'a': 3, '_': 4, ']': 2, '[': 2, 'Y': 6, 'W': 8, 'U': 6, 'S': 5, 'Q': 6, 'O': 6, 'M': 8, 'K': 6, 'I': 3, 'G': 6, 'E': 5, 'C': 6, 'A': 6, '?': 3, '=': 5, ';': 2, '9': 4, '7': 4, '5': 4, '3': 4, '1': 4, '/': 2, '-': 6, '+': 5, ')': 3, "'": 2, '%': 6, '#': 4, '!': 2, '~': 6, '|': 2, 'z': 4, 'x': 5, 'v': 4, 't': 3, 'r': 3, 'p': 4, 'n': 4, 'l': 3, 'j': 2, 'h': 4, 'f': 3, 'd': 4, 'b': 4, '`': 2, '^': 4, '\\': 2, 'Z': 5, 'X': 6, 'V': 6, 'T': 5, 'R': 6, 'P': 5, 'N': 6, 'L': 5, 'J': 3, 'H': 6, 'F': 5, 'D': 6, 'B': 5, '@': 7, '>': 4, '<': 4, ':': 2, '8': 4, '6': 4, '4': 4, '2': 4, '0': 4, '.': 2, ',': 2, '*': 4, '(': 3, '&': 6, '$': 4, '"': 3, ' ': 2}, 'helvetica-bold-24.pil': {'\x7f': 0, '}': 10, '{': 10, 'y': 15, 'w': 19, 'u': 15, 's': 13, 'q': 15, 'o': 14, 'm': 21, 'k': 14, 'i': 7, 'g': 15, 'e': 14, 'c': 13, 'a': 14, '_': 14, ']': 8, '[': 8, 'Y': 17, 'W': 23, 'U': 19, 'S': 17, 'Q': 19, 'O': 19, 'M': 23, 'K': 18, 'I': 7, 'G': 19, 'E': 16, 'C': 18, 'A': 18, '?': 15, '=': 14, ';': 7, '9': 13, '7': 13, '5': 13, '3': 13, '1': 13, '/': 8, '-': 15, '+': 15, ')': 8, "'": 7, '%': 22, '#': 14, '!': 7, '~': 14, '|': 7, 'z': 13, 'x': 13, 'v': 14, 't': 9, 'r': 10, 'p': 15, 'n': 15, 'l': 7, 'j': 7, 'h': 15, 'f': 9, 'd': 15, 'b': 15, '`': 7, '^': 14, '\\': 8, 'Z': 16, 'X': 18, 'V': 18, 'T': 15, 'R': 17, 'P': 17, 'N': 19, 'L': 15, 'J': 14, 'H': 19, 'F': 15, 'D': 19, 'B': 18, '@': 24, '>': 14, '<': 15, ':': 7, '8': 13, '6': 13, '4': 13, '2': 13, '0': 13, '.': 7, ',': 7, '*': 10, '(': 8, '&': 18, '$': 13, '"': 9, ' ': 6}, 'courier-bold-18.pil': {'\x7f': 0, '}': 11, '{': 11, 'y': 11, 'w': 11, 'u': 11, 's': 11, 'q': 11, 'o': 11, 'm': 11, 'k': 11, 'i': 11, 'g': 11, 'e': 11, 'c': 11, 'a': 11, '_': 11, ']': 11, '[': 11, 'Y': 11, 'W': 11, 'U': 11, 'S': 11, 'Q': 11, 'O': 11, 'M': 11, 'K': 11, 'I': 11, 'G': 11, 'E': 11, 'C': 11, 'A': 11, '?': 11, '=': 11, ';': 11, '9': 11, '7': 11, '5': 11, '3': 11, '1': 11, '/': 11, '-': 11, '+': 11, ')': 11, "'": 11, '%': 11, '#': 11, '!': 11, '~': 11, '|': 11, 'z': 11, 'x': 11, 'v': 11, 't': 11, 'r': 11, 'p': 11, 'n': 11, 'l': 11, 'j': 11, 'h': 11, 'f': 11, 'd': 11, 'b': 11, '`': 11, '^': 11, '\\': 11, 'Z': 11, 'X': 11, 'V': 11, 'T': 11, 'R': 11, 'P': 11, 'N': 11, 'L': 11, 'J': 11, 'H': 11, 'F': 11, 'D': 11, 'B': 11, '@': 11, '>': 11, '<': 11, ':': 11, '8': 11, '6': 11, '4': 11, '2': 11, '0': 11, '.': 11, ',': 11, '*': 11, '(': 11, '&': 11, '$': 11, '"': 11, ' ': 11}, 'helvetica-18.pil': {'\x7f': 0, '}': 6, '{': 6, 'y': 10, 'w': 14, 'u': 10, 's': 9, 'q': 11, 'o': 11, 'm': 14, 'k': 9, 'i': 4, 'g': 11, 'e': 10, 'c': 10, 'a': 9, '_': 10, ']': 5, '[': 5, 'Y': 14, 'W': 18, 'U': 13, 'S': 13, 'Q': 15, 'O': 15, 'M': 16, 'K': 13, 'I': 6, 'G': 14, 'E': 11, 'C': 14, 'A': 12, '?': 10, '=': 11, ';': 5, '9': 10, '7': 10, '5': 10, '3': 10, '1': 10, '/': 5, '-': 11, '+': 10, ')': 6, "'": 4, '%': 16, '#': 10, '!': 6, '~': 10, '|': 4, 'z': 9, 'x': 10, 'v': 10, 't': 6, 'r': 6, 'p': 11, 'n': 10, 'l': 4, 'j': 4, 'h': 10, 'f': 6, 'd': 11, 'b': 11, '`': 4, '^': 9, '\\': 5, 'Z': 12, 'X': 13, 'V': 14, 'T': 12, 'R': 12, 'P': 12, 'N': 13, 'L': 10, 'J': 10, 'H': 13, 'F': 11, 'D': 13, 'B': 13, '@': 18, '>': 10, '<': 10, ':': 5, '8': 10, '6': 10, '4': 10, '2': 10, '0': 10, '.': 5, ',': 5, '*': 7, '(': 6, '&': 13, '$': 10, '"': 5, ' ': 5}, 'courier-14.pil': {'\x7f': 0, '}': 9, '{': 9, 'y': 9, 'w': 9, 'u': 9, 's': 9, 'q': 9, 'o': 9, 'm': 9, 'k': 9, 'i': 9, 'g': 9, 'e': 9, 'c': 9, 'a': 9, '_': 9, ']': 9, '[': 9, 'Y': 9, 'W': 9, 'U': 9, 'S': 9, 'Q': 9, 'O': 9, 'M': 9, 'K': 9, 'I': 9, 'G': 9, 'E': 9, 'C': 9, 'A': 9, '?': 9, '=': 9, ';': 9, '9': 9, '7': 9, '5': 9, '3': 9, '1': 9, '/': 9, '-': 9, '+': 9, ')': 9, "'": 9, '%': 9, '#': 9, '!': 9, '~': 9, '|': 9, 'z': 9, 'x': 9, 'v': 9, 't': 9, 'r': 9, 'p': 9, 'n': 9, 'l': 9, 'j': 9, 'h': 9, 'f': 9, 'd': 9, 'b': 9, '`': 9, '^': 9, '\\': 9, 'Z': 9, 'X': 9, 'V': 9, 'T': 9, 'R': 9, 'P': 9, 'N': 9, 'L': 9, 'J': 9, 'H': 9, 'F': 9, 'D': 9, 'B': 9, '@': 9, '>': 9, '<': 9, ':': 9, '8': 9, '6': 9, '4': 9, '2': 9, '0': 9, '.': 9, ',': 9, '*': 9, '(': 9, '&': 9, '$': 9, '"': 9, ' ': 9}, 'helvetica-12.pil': {'\x7f': 0, '}': 4, '{': 4, 'y': 7, 'w': 9, 'u': 7, 's': 6, 'q': 7, 'o': 7, 'm': 9, 'k': 6, 'i': 3, 'g': 7, 'e': 7, 'c': 7, 'a': 7, '_': 7, ']': 3, '[': 3, 'Y': 9, 'W': 11, 'U': 8, 'S': 8, 'Q': 10, 'O': 10, 'M': 11, 'K': 8, 'I': 3, 'G': 9, 'E': 8, 'C': 9, 'A': 9, '?': 7, '=': 7, ';': 3, '9': 7, '7': 7, '5': 7, '3': 7, '1': 7, '/': 4, '-': 8, '+': 7, ')': 4, "'": 3, '%': 11, '#': 7, '!': 3, '~': 7, '|': 3, 'z': 6, 'x': 6, 'v': 7, 't': 3, 'r': 4, 'p': 7, 'n': 7, 'l': 3, 'j': 3, 'h': 7, 'f': 3, 'd': 7, 'b': 7, '`': 3, '^': 6, '\\': 4, 'Z': 9, 'X': 9, 'V': 9, 'T': 7, 'R': 8, 'P': 8, 'N': 9, 'L': 7, 'J': 7, 'H': 9, 'F': 8, 'D': 9, 'B': 8, '@': 12, '>': 7, '<': 7, ':': 3, '8': 7, '6': 7, '4': 7, '2': 7, '0': 7, '.': 3, ',': 4, '*': 5, '(': 4, '&': 9, '$': 7, '"': 5, ' ': 4}, 'courier-bold-14.pil': {'\x7f': 0, '}': 9, '{': 9, 'y': 9, 'w': 9, 'u': 9, 's': 9, 'q': 9, 'o': 9, 'm': 9, 'k': 9, 'i': 9, 'g': 9, 'e': 9, 'c': 9, 'a': 9, '_': 9, ']': 9, '[': 9, 'Y': 9, 'W': 9, 'U': 9, 'S': 9, 'Q': 9, 'O': 9, 'M': 9, 'K': 9, 'I': 9, 'G': 9, 'E': 9, 'C': 9, 'A': 9, '?': 9, '=': 9, ';': 9, '9': 9, '7': 9, '5': 9, '3': 9, '1': 9, '/': 9, '-': 9, '+': 9, ')': 9, "'": 9, '%': 9, '#': 9, '!': 9, '~': 9, '|': 9, 'z': 9, 'x': 9, 'v': 9, 't': 9, 'r': 9, 'p': 9, 'n': 9, 'l': 9, 'j': 9, 'h': 9, 'f': 9, 'd': 9, 'b': 9, '`': 9, '^': 9, '\\': 9, 'Z': 9, 'X': 9, 'V': 9, 'T': 9, 'R': 9, 'P': 9, 'N': 9, 'L': 9, 'J': 9, 'H': 9, 'F': 9, 'D': 9, 'B': 9, '@': 9, '>': 9, '<': 9, ':': 9, '8': 9, '6': 9, '4': 9, '2': 9, '0': 9, '.': 9, ',': 9, '*': 9, '(': 9, '&': 9, '$': 9, '"': 9, ' ': 9}, 'courier-12.pil': {'\x7f': 0, '}': 7, '{': 7, 'y': 7, 'w': 7, 'u': 7, 's': 7, 'q': 7, 'o': 7, 'm': 7, 'k': 7, 'i': 7, 'g': 7, 'e': 7, 'c': 7, 'a': 7, '_': 7, ']': 7, '[': 7, 'Y': 7, 'W': 7, 'U': 7, 'S': 7, 'Q': 7, 'O': 7, 'M': 7, 'K': 7, 'I': 7, 'G': 7, 'E': 7, 'C': 7, 'A': 7, '?': 7, '=': 7, ';': 7, '9': 7, '7': 7, '5': 7, '3': 7, '1': 7, '/': 7, '-': 7, '+': 7, ')': 7, "'": 7, '%': 7, '#': 7, '!': 7, '~': 7, '|': 7, 'z': 7, 'x': 7, 'v': 7, 't': 7, 'r': 7, 'p': 7, 'n': 7, 'l': 7, 'j': 7, 'h': 7, 'f': 7, 'd': 7, 'b': 7, '`': 7, '^': 7, '\\': 7, 'Z': 7, 'X': 7, 'V': 7, 'T': 7, 'R': 7, 'P': 7, 'N': 7, 'L': 7, 'J': 7, 'H': 7, 'F': 7, 'D': 7, 'B': 7, '@': 7, '>': 7, '<': 7, ':': 7, '8': 7, '6': 7, '4': 7, '2': 7, '0': 7, '.': 7, ',': 7, '*': 7, '(': 7, '&': 7, '$': 7, '"': 7, ' ': 7}, 'times-12.pil': {'\x7f': 0, '}': 6, '{': 6, 'y': 6, 'w': 9, 'u': 6, 's': 6, 'q': 6, 'o': 6, 'm': 9, 'k': 6, 'i': 3, 'g': 6, 'e': 6, 'c': 6, 'a': 6, '_': 6, ']': 4, '[': 4, 'Y': 9, 'W': 12, 'U': 9, 'S': 7, 'Q': 9, 'O': 9, 'M': 11, 'K': 9, 'I': 4, 'G': 9, 'E': 8, 'C': 8, 'A': 9, '?': 5, '=': 7, ';': 3, '9': 6, '7': 6, '5': 6, '3': 6, '1': 6, '/': 3, '-': 7, '+': 7, ')': 5, "'": 4, '%': 10, '#': 6, '!': 3, '~': 7, '|': 3, 'z': 6, 'x': 6, 'v': 6, 't': 4, 'r': 4, 'p': 6, 'n': 6, 'l': 3, 'j': 3, 'h': 6, 'f': 4, 'd': 6, 'b': 6, '`': 4, '^': 6, '\\': 3, 'Z': 8, 'X': 9, 'V': 9, 'T': 7, 'R': 8, 'P': 7, 'N': 9, 'L': 7, 'J': 5, 'H': 9, 'F': 7, 'D': 9, 'B': 8, '@': 11, '>': 7, '<': 7, ':': 3, '8': 6, '6': 6, '4': 6, '2': 6, '0': 6, '.': 3, ',': 3, '*': 6, '(': 5, '&': 10, '$': 6, '"': 5, ' ': 3}, 'courier-18.pil': {'\x7f': 0, '}': 11, '{': 11, 'y': 11, 'w': 11, 'u': 11, 's': 11, 'q': 11, 'o': 11, 'm': 11, 'k': 11, 'i': 11, 'g': 11, 'e': 11, 'c': 11, 'a': 11, '_': 11, ']': 11, '[': 11, 'Y': 11, 'W': 11, 'U': 11, 'S': 11, 'Q': 11, 'O': 11, 'M': 11, 'K': 11, 'I': 11, 'G': 11, 'E': 11, 'C': 11, 'A': 11, '?': 11, '=': 11, ';': 11, '9': 11, '7': 11, '5': 11, '3': 11, '1': 11, '/': 11, '-': 11, '+': 11, ')': 11, "'": 11, '%': 11, '#': 11, '!': 11, '~': 11, '|': 11, 'z': 11, 'x': 11, 'v': 11, 't': 11, 'r': 11, 'p': 11, 'n': 11, 'l': 11, 'j': 11, 'h': 11, 'f': 11, 'd': 11, 'b': 11, '`': 11, '^': 11, '\\': 11, 'Z': 11, 'X': 11, 'V': 11, 'T': 11, 'R': 11, 'P': 11, 'N': 11, 'L': 11, 'J': 11, 'H': 11, 'F': 11, 'D': 11, 'B': 11, '@': 11, '>': 11, '<': 11, ':': 11, '8': 11, '6': 11, '4': 11, '2': 11, '0': 11, '.': 11, ',': 11, '*': 11, '(': 11, '&': 11, '$': 11, '"': 11, ' ': 11}, 'helvetica-bold-14.pil': {'\x7f': 0, '}': 6, '{': 6, 'y': 8, 'w': 10, 'u': 9, 's': 8, 'q': 9, 'o': 9, 'm': 12, 'k': 8, 'i': 4, 'g': 9, 'e': 8, 'c': 8, 'a': 8, '_': 8, ']': 5, '[': 5, 'Y': 10, 'W': 14, 'U': 11, 'S': 10, 'Q': 12, 'O': 12, 'M': 13, 'K': 10, 'I': 4, 'G': 11, 'E': 9, 'C': 11, 'A': 10, '?': 9, '=': 9, ';': 5, '9': 8, '7': 8, '5': 8, '3': 8, '1': 8, '/': 4, '-': 9, '+': 9, ')': 5, "'": 5, '%': 13, '#': 9, '!': 4, '~': 9, '|': 4, 'z': 6, 'x': 7, 'v': 8, 't': 5, 'r': 6, 'p': 9, 'n': 9, 'l': 4, 'j': 4, 'h': 9, 'f': 4, 'd': 9, 'b': 9, '`': 5, '^': 8, '\\': 4, 'Z': 9, 'X': 9, 'V': 10, 'T': 8, 'R': 11, 'P': 10, 'N': 11, 'L': 8, 'J': 8, 'H': 10, 'F': 9, 'D': 11, 'B': 10, '@': 14, '>': 8, '<': 8, ':': 5, '8': 8, '6': 8, '4': 8, '2': 8, '0': 8, '.': 4, ',': 4, '*': 6, '(': 5, '&': 11, '$': 8, '"': 7, ' ': 4}, 'times-bold-14.pil': {'\x7f': 0, '}': 7, '{': 7, 'y': 7, 'w': 9, 'u': 7, 's': 6, 'q': 7, 'o': 7, 'm': 12, 'k': 8, 'i': 4, 'g': 7, 'e': 7, 'c': 7, 'a': 7, '_': 7, ']': 5, '[': 5, 'Y': 10, 'W': 15, 'U': 9, 'S': 9, 'Q': 11, 'O': 11, 'M': 13, 'K': 11, 'I': 6, 'G': 10, 'E': 10, 'C': 10, 'A': 10, '?': 7, '=': 8, ';': 5, '9': 7, '7': 7, '5': 7, '3': 7, '1': 7, '/': 4, '-': 8, '+': 8, ')': 5, "'": 4, '%': 14, '#': 7, '!': 4, '~': 8, '|': 3, 'z': 7, 'x': 7, 'v': 8, 't': 5, 'r': 6, 'p': 8, 'n': 8, 'l': 5, 'j': 4, 'h': 8, 'f': 5, 'd': 7, 'b': 8, '`': 4, '^': 8, '\\': 4, 'Z': 9, 'X': 10, 'V': 10, 'T': 10, 'R': 11, 'P': 9, 'N': 10, 'L': 9, 'J': 7, 'H': 12, 'F': 10, 'D': 11, 'B': 10, '@': 14, '>': 8, '<': 8, ':': 5, '8': 7, '6': 7, '4': 7, '2': 7, '0': 7, '.': 4, ',': 3, '*': 7, '(': 5, '&': 12, '$': 7, '"': 7, ' ': 4}, 'symbol-12.pil': {'\x7f': 0, '}': 6, '{': 6, 'y': 9, 'w': 9, 'u': 8, 's': 8, 'q': 7, 'o': 7, 'm': 8, 'k': 7, 'i': 3, 'g': 7, 'e': 6, 'c': 7, 'a': 8, '_': 6, ']': 5, '[': 5, 'Y': 10, 'W': 10, 'U': 9, 'S': 7, 'Q': 9, 'O': 9, 'M': 11, 'K': 9, 'I': 4, 'G': 8, 'E': 8, 'C': 9, 'A': 9, '?': 6, '=': 7, ';': 3, '9': 6, '7': 6, '5': 6, '3': 6, '1': 6, '/': 3, '-': 7, '+': 7, ')': 5, "'": 6, '%': 10, '#': 7, '!': 4, '~': 7, '|': 3, 'z': 6, 'x': 6, 'v': 9, 't': 6, 'r': 7, 'p': 7, 'n': 7, 'l': 7, 'j': 8, 'h': 8, 'f': 8, 'd': 7, 'b': 7, '`': 6, '^': 8, '\\': 9, 'Z': 8, 'X': 8, 'V': 7, 'T': 8, 'R': 7, 'P': 9, 'N': 9, 'L': 9, 'J': 8, 'H': 9, 'F': 10, 'D': 8, 'B': 8, '@': 7, '>': 7, '<': 7, ':': 3, '8': 6, '6': 6, '4': 6, '2': 6, '0': 6, '.': 3, ',': 3, '*': 6, '(': 5, '&': 10, '$': 7, '"': 9, ' ': 3}, 'helvetica-bold-18.pil': {'\x7f': 0, '}': 8, '{': 8, 'y': 9, 'w': 13, 'u': 11, 's': 10, 'q': 12, 'o': 12, 'm': 15, 'k': 10, 'i': 5, 'g': 12, 'e': 11, 'c': 10, 'a': 10, '_': 10, ']': 6, '[': 6, 'Y': 13, 'W': 17, 'U': 13, 'S': 12, 'Q': 16, 'O': 16, 'M': 16, 'K': 14, 'I': 5, 'G': 14, 'E': 12, 'C': 14, 'A': 13, '?': 10, '=': 10, ';': 6, '9': 10, '7': 10, '5': 10, '3': 10, '1': 10, '/': 5, '-': 11, '+': 11, ')': 7, "'": 5, '%': 16, '#': 11, '!': 5, '~': 11, '|': 5, 'z': 10, 'x': 9, 'v': 9, 't': 6, 'r': 7, 'p': 12, 'n': 11, 'l': 5, 'j': 5, 'h': 11, 'f': 7, 'd': 12, 'b': 12, '`': 5, '^': 10, '\\': 5, 'Z': 11, 'X': 12, 'V': 13, 'T': 11, 'R': 13, 'P': 12, 'N': 14, 'L': 11, 'J': 10, 'H': 13, 'F': 12, 'D': 14, 'B': 13, '@': 18, '>': 11, '<': 11, ':': 6, '8': 10, '6': 10, '4': 10, '2': 10, '0': 10, '.': 5, ',': 5, '*': 9, '(': 7, '&': 14, '$': 10, '"': 8, ' ': 5}, 'courier-10.pil': {'\x7f': 0, '}': 6, '{': 6, 'y': 6, 'w': 6, 'u': 6, 's': 6, 'q': 6, 'o': 6, 'm': 6, 'k': 6, 'i': 6, 'g': 6, 'e': 6, 'c': 6, 'a': 6, '_': 6, ']': 6, '[': 6, 'Y': 6, 'W': 6, 'U': 6, 'S': 6, 'Q': 6, 'O': 6, 'M': 6, 'K': 6, 'I': 6, 'G': 6, 'E': 6, 'C': 6, 'A': 6, '?': 6, '=': 6, ';': 6, '9': 6, '7': 6, '5': 6, '3': 6, '1': 6, '/': 6, '-': 6, '+': 6, ')': 6, "'": 6, '%': 6, '#': 6, '!': 6, '~': 6, '|': 6, 'z': 6, 'x': 6, 'v': 6, 't': 6, 'r': 6, 'p': 6, 'n': 6, 'l': 6, 'j': 6, 'h': 6, 'f': 6, 'd': 6, 'b': 6, '`': 6, '^': 6, '\\': 6, 'Z': 6, 'X': 6, 'V': 6, 'T': 6, 'R': 6, 'P': 6, 'N': 6, 'L': 6, 'J': 6, 'H': 6, 'F': 6, 'D': 6, 'B': 6, '@': 6, '>': 6, '<': 6, ':': 6, '8': 6, '6': 6, '4': 6, '2': 6, '0': 6, '.': 6, ',': 6, '*': 6, '(': 6, '&': 6, '$': 6, '"': 6, ' ': 6}, 'helvetica-8.pil': {'\x7f': 0, '}': 2, '{': 2, 'y': 4, 'w': 6, 'u': 4, 's': 4, 'q': 5, 'o': 5, 'm': 6, 'k': 4, 'i': 2, 'g': 5, 'e': 4, 'c': 4, 'a': 4, '_': 5, ']': 2, '[': 2, 'Y': 6, 'W': 7, 'U': 6, 'S': 6, 'Q': 6, 'O': 6, 'M': 7, 'K': 6, 'I': 2, 'G': 6, 'E': 6, 'C': 6, 'A': 6, '?': 5, '=': 4, ';': 2, '9': 5, '7': 5, '5': 5, '3': 5, '1': 5, '/': 2, '-': 6, '+': 5, ')': 3, "'": 2, '%': 7, '#': 5, '!': 2, '~': 6, '|': 2, 'z': 4, 'x': 5, 'v': 5, 't': 3, 'r': 3, 'p': 5, 'n': 5, 'l': 2, 'j': 2, 'h': 5, 'f': 3, 'd': 5, 'b': 5, '`': 2, '^': 5, '\\': 2, 'Z': 6, 'X': 6, 'V': 6, 'T': 4, 'R': 6, 'P': 6, 'N': 6, 'L': 5, 'J': 4, 'H': 6, 'F': 5, 'D': 6, 'B': 6, '@': 9, '>': 5, '<': 5, ':': 2, '8': 5, '6': 5, '4': 5, '2': 5, '0': 5, '.': 2, ',': 2, '*': 3, '(': 3, '&': 6, '$': 5, '"': 3, ' ': 2}, 'courier-bold-8.pil': {'\x7f': 0, '}': 5, '{': 5, 'y': 5, 'w': 5, 'u': 5, 's': 5, 'q': 5, 'o': 5, 'm': 5, 'k': 5, 'i': 5, 'g': 5, 'e': 5, 'c': 5, 'a': 5, '_': 5, ']': 5, '[': 5, 'Y': 5, 'W': 5, 'U': 5, 'S': 5, 'Q': 5, 'O': 5, 'M': 5, 'K': 5, 'I': 5, 'G': 5, 'E': 5, 'C': 5, 'A': 5, '?': 5, '=': 5, ';': 5, '9': 5, '7': 5, '5': 5, '3': 5, '1': 5, '/': 5, '-': 5, '+': 5, ')': 5, "'": 5, '%': 5, '#': 5, '!': 5, '~': 5, '|': 5, 'z': 5, 'x': 5, 'v': 5, 't': 5, 'r': 5, 'p': 5, 'n': 5, 'l': 5, 'j': 5, 'h': 5, 'f': 5, 'd': 5, 'b': 5, '`': 5, '^': 5, '\\': 5, 'Z': 5, 'X': 5, 'V': 5, 'T': 5, 'R': 5, 'P': 5, 'N': 5, 'L': 5, 'J': 5, 'H': 5, 'F': 5, 'D': 5, 'B': 5, '@': 5, '>': 5, '<': 5, ':': 5, '8': 5, '6': 5, '4': 5, '2': 5, '0': 5, '.': 5, ',': 5, '*': 5, '(': 5, '&': 5, '$': 5, '"': 5, ' ': 5}, 'courier-8.pil': {'\x7f': 0, '}': 5, '{': 5, 'y': 5, 'w': 5, 'u': 5, 's': 5, 'q': 5, 'o': 5, 'm': 5, 'k': 5, 'i': 5, 'g': 5, 'e': 5, 'c': 5, 'a': 5, '_': 5, ']': 5, '[': 5, 'Y': 5, 'W': 5, 'U': 5, 'S': 5, 'Q': 5, 'O': 5, 'M': 5, 'K': 5, 'I': 5, 'G': 5, 'E': 5, 'C': 5, 'A': 5, '?': 5, '=': 5, ';': 5, '9': 5, '7': 5, '5': 5, '3': 5, '1': 5, '/': 5, '-': 5, '+': 5, ')': 5, "'": 5, '%': 5, '#': 5, '!': 5, '~': 5, '|': 5, 'z': 5, 'x': 5, 'v': 5, 't': 5, 'r': 5, 'p': 5, 'n': 5, 'l': 5, 'j': 5, 'h': 5, 'f': 5, 'd': 5, 'b': 5, '`': 5, '^': 5, '\\': 5, 'Z': 5, 'X': 5, 'V': 5, 'T': 5, 'R': 5, 'P': 5, 'N': 5, 'L': 5, 'J': 5, 'H': 5, 'F': 5, 'D': 5, 'B': 5, '@': 5, '>': 5, '<': 5, ':': 5, '8': 5, '6': 5, '4': 5, '2': 5, '0': 5, '.': 5, ',': 5, '*': 5, '(': 5, '&': 5, '$': 5, '"': 5, ' ': 5}, 'helvetica-bold-12.pil': {'\x7f': 0, '}': 5, '{': 5, 'y': 8, 'w': 11, 'u': 7, 's': 7, 'q': 7, 'o': 7, 'm': 11, 'k': 7, 'i': 3, 'g': 7, 'e': 7, 'c': 7, 'a': 7, '_': 7, ']': 4, '[': 4, 'Y': 8, 'W': 10, 'U': 9, 'S': 9, 'Q': 10, 'O': 10, 'M': 11, 'K': 9, 'I': 4, 'G': 10, 'E': 8, 'C': 8, 'A': 8, '?': 8, '=': 7, ';': 4, '9': 7, '7': 7, '5': 7, '3': 7, '1': 7, '/': 4, '-': 8, '+': 7, ')': 6, "'": 4, '%': 12, '#': 8, '!': 4, '~': 7, '|': 4, 'z': 6, 'x': 7, 'v': 8, 't': 5, 'r': 5, 'p': 7, 'n': 7, 'l': 3, 'j': 3, 'h': 7, 'f': 5, 'd': 7, 'b': 7, '`': 4, '^': 7, '\\': 4, 'Z': 7, 'X': 8, 'V': 8, 'T': 8, 'R': 9, 'P': 8, 'N': 9, 'L': 7, 'J': 7, 'H': 9, 'F': 7, 'D': 9, 'B': 9, '@': 12, '>': 7, '<': 7, ':': 4, '8': 7, '6': 7, '4': 7, '2': 7, '0': 7, '.': 4, ',': 4, '*': 6, '(': 6, '&': 9, '$': 7, '"': 5, ' ': 4}, 'times-bold-18.pil': {'\x7f': 0, '}': 8, '{': 8, 'y': 9, 'w': 12, 'u': 11, 's': 7, 'q': 9, 'o': 9, 'm': 16, 'k': 10, 'i': 5, 'g': 9, 'e': 8, 'c': 8, 'a': 9, '_': 9, ']': 6, '[': 6, 'Y': 13, 'W': 18, 'U': 13, 'S': 11, 'Q': 15, 'O': 15, 'M': 17, 'K': 15, 'I': 7, 'G': 15, 'E': 12, 'C': 13, 'A': 13, '?': 9, '=': 11, ';': 5, '9': 9, '7': 9, '5': 9, '3': 9, '1': 9, '/': 6, '-': 11, '+': 11, ')': 6, "'": 6, '%': 18, '#': 9, '!': 6, '~': 10, '|': 4, 'z': 8, 'x': 9, 'v': 9, 't': 7, 'r': 8, 'p': 10, 'n': 11, 'l': 6, 'j': 5, 'h': 11, 'f': 6, 'd': 10, 'b': 9, '`': 6, '^': 11, '\\': 5, 'Z': 12, 'X': 13, 'V': 14, 'T': 12, 'R': 13, 'P': 11, 'N': 14, 'L': 12, 'J': 9, 'H': 15, 'F': 11, 'D': 14, 'B': 12, '@': 17, '>': 11, '<': 11, ':': 5, '8': 9, '6': 9, '4': 9, '2': 9, '0': 9, '.': 5, ',': 5, '*': 9, '(': 6, '&': 16, '$': 9, '"': 10, ' ': 4}}
aliceblue: rdkit.sping.colors.Color  # value = Color(0.94,0.97,1.00)
antiquewhite: rdkit.sping.colors.Color  # value = Color(0.98,0.92,0.84)
aqua: rdkit.sping.colors.Color  # value = Color(0.00,1.00,1.00)
aquamarine: rdkit.sping.colors.Color  # value = Color(0.50,1.00,0.83)
azure: rdkit.sping.colors.Color  # value = Color(0.94,1.00,1.00)
beige: rdkit.sping.colors.Color  # value = Color(0.96,0.96,0.86)
bisque: rdkit.sping.colors.Color  # value = Color(1.00,0.89,0.77)
black: rdkit.sping.colors.Color  # value = Color(0.00,0.00,0.00)
blanchedalmond: rdkit.sping.colors.Color  # value = Color(1.00,0.92,0.80)
blue: rdkit.sping.colors.Color  # value = Color(0.00,0.00,1.00)
blueviolet: rdkit.sping.colors.Color  # value = Color(0.54,0.17,0.89)
brown: rdkit.sping.colors.Color  # value = Color(0.65,0.16,0.16)
burlywood: rdkit.sping.colors.Color  # value = Color(0.87,0.72,0.53)
cadetblue: rdkit.sping.colors.Color  # value = Color(0.37,0.62,0.63)
chartreuse: rdkit.sping.colors.Color  # value = Color(0.50,1.00,0.00)
chocolate: rdkit.sping.colors.Color  # value = Color(0.82,0.41,0.12)
cm: float = 28.346456692913385
coral: rdkit.sping.colors.Color  # value = Color(1.00,0.50,0.31)
cornflower: rdkit.sping.colors.Color  # value = Color(0.39,0.58,0.93)
cornsilk: rdkit.sping.colors.Color  # value = Color(1.00,0.97,0.86)
crimson: rdkit.sping.colors.Color  # value = Color(0.86,0.08,0.24)
cyan: rdkit.sping.colors.Color  # value = Color(0.00,1.00,1.00)
darkblue: rdkit.sping.colors.Color  # value = Color(0.00,0.00,0.55)
darkcyan: rdkit.sping.colors.Color  # value = Color(0.00,0.55,0.55)
darkgoldenrod: rdkit.sping.colors.Color  # value = Color(0.72,0.53,0.04)
darkgray: rdkit.sping.colors.Color  # value = Color(0.66,0.66,0.66)
darkgreen: rdkit.sping.colors.Color  # value = Color(0.00,0.39,0.00)
darkkhaki: rdkit.sping.colors.Color  # value = Color(0.74,0.72,0.42)
darkmagenta: rdkit.sping.colors.Color  # value = Color(0.55,0.00,0.55)
darkolivegreen: rdkit.sping.colors.Color  # value = Color(0.33,0.42,0.18)
darkorange: rdkit.sping.colors.Color  # value = Color(1.00,0.55,0.00)
darkorchid: rdkit.sping.colors.Color  # value = Color(0.60,0.20,0.80)
darkred: rdkit.sping.colors.Color  # value = Color(0.55,0.00,0.00)
darksalmon: rdkit.sping.colors.Color  # value = Color(0.91,0.59,0.48)
darkseagreen: rdkit.sping.colors.Color  # value = Color(0.56,0.74,0.55)
darkslateblue: rdkit.sping.colors.Color  # value = Color(0.28,0.24,0.55)
darkslategray: rdkit.sping.colors.Color  # value = Color(0.18,0.31,0.31)
darkturquoise: rdkit.sping.colors.Color  # value = Color(0.00,0.81,0.82)
darkviolet: rdkit.sping.colors.Color  # value = Color(0.58,0.00,0.83)
deeppink: rdkit.sping.colors.Color  # value = Color(1.00,0.08,0.58)
deepskyblue: rdkit.sping.colors.Color  # value = Color(0.00,0.75,1.00)
dimgray: rdkit.sping.colors.Color  # value = Color(0.41,0.41,0.41)
dodgerblue: rdkit.sping.colors.Color  # value = Color(0.12,0.56,1.00)
f: _io.BufferedReader  # value = <_io.BufferedReader name='/project/build/temp.linux-aarch64-cpython-310/rdkit_install/lib/python3.10/site-packages/rdkit/sping/PIL/pilfonts/metrics.dat'>
figureArc: int = 2
figureCurve: int = 3
figureLine: int = 1
firebrick: rdkit.sping.colors.Color  # value = Color(0.70,0.13,0.13)
floralwhite: rdkit.sping.colors.Color  # value = Color(1.00,0.98,0.94)
forestgreen: rdkit.sping.colors.Color  # value = Color(0.13,0.55,0.13)
fuchsia: rdkit.sping.colors.Color  # value = Color(1.00,0.00,1.00)
gainsboro: rdkit.sping.colors.Color  # value = Color(0.86,0.86,0.86)
ghostwhite: rdkit.sping.colors.Color  # value = Color(0.97,0.97,1.00)
gold: rdkit.sping.colors.Color  # value = Color(1.00,0.84,0.00)
goldenrod: rdkit.sping.colors.Color  # value = Color(0.85,0.65,0.13)
gray: rdkit.sping.colors.Color  # value = Color(0.50,0.50,0.50)
green: rdkit.sping.colors.Color  # value = Color(0.00,0.50,0.00)
greenyellow: rdkit.sping.colors.Color  # value = Color(0.68,1.00,0.18)
grey: rdkit.sping.colors.Color  # value = Color(0.50,0.50,0.50)
honeydew: rdkit.sping.colors.Color  # value = Color(0.94,1.00,0.94)
hotpink: rdkit.sping.colors.Color  # value = Color(1.00,0.41,0.71)
inch: int = 72
indianred: rdkit.sping.colors.Color  # value = Color(0.80,0.36,0.36)
indigo: rdkit.sping.colors.Color  # value = Color(0.29,0.00,0.51)
ivory: rdkit.sping.colors.Color  # value = Color(1.00,1.00,0.94)
keyBksp: str = '\x08'
keyClear: str = '\x1b'
keyDel: str = '\x7f'
keyDown: str = '\x1f'
keyEnd: str = '\x04'
keyHome: str = '\x01'
keyLeft: str = '\x1c'
keyPgDn: str = '\x0c'
keyPgUp: str = '\x0b'
keyRight: str = '\x1d'
keyTab: str = '\t'
keyUp: str = '\x1e'
khaki: rdkit.sping.colors.Color  # value = Color(0.94,0.90,0.55)
lavender: rdkit.sping.colors.Color  # value = Color(0.90,0.90,0.98)
lavenderblush: rdkit.sping.colors.Color  # value = Color(1.00,0.94,0.96)
lawngreen: rdkit.sping.colors.Color  # value = Color(0.49,0.99,0.00)
lemonchiffon: rdkit.sping.colors.Color  # value = Color(1.00,0.98,0.80)
lightblue: rdkit.sping.colors.Color  # value = Color(0.68,0.85,0.90)
lightcoral: rdkit.sping.colors.Color  # value = Color(0.94,0.50,0.50)
lightcyan: rdkit.sping.colors.Color  # value = Color(0.88,1.00,1.00)
lightgoldenrodyellow: rdkit.sping.colors.Color  # value = Color(0.98,0.98,0.82)
lightgreen: rdkit.sping.colors.Color  # value = Color(0.56,0.93,0.56)
lightgrey: rdkit.sping.colors.Color  # value = Color(0.83,0.83,0.83)
lightpink: rdkit.sping.colors.Color  # value = Color(1.00,0.71,0.76)
lightsalmon: rdkit.sping.colors.Color  # value = Color(1.00,0.63,0.48)
lightseagreen: rdkit.sping.colors.Color  # value = Color(0.13,0.70,0.67)
lightskyblue: rdkit.sping.colors.Color  # value = Color(0.53,0.81,0.98)
lightslategray: rdkit.sping.colors.Color  # value = Color(0.47,0.53,0.60)
lightsteelblue: rdkit.sping.colors.Color  # value = Color(0.69,0.77,0.87)
lightyellow: rdkit.sping.colors.Color  # value = Color(1.00,1.00,0.88)
lime: rdkit.sping.colors.Color  # value = Color(0.00,1.00,0.00)
limegreen: rdkit.sping.colors.Color  # value = Color(0.20,0.80,0.20)
linen: rdkit.sping.colors.Color  # value = Color(0.98,0.94,0.90)
magenta: rdkit.sping.colors.Color  # value = Color(1.00,0.00,1.00)
maroon: rdkit.sping.colors.Color  # value = Color(0.50,0.00,0.00)
mediumaquamarine: rdkit.sping.colors.Color  # value = Color(0.40,0.80,0.67)
mediumblue: rdkit.sping.colors.Color  # value = Color(0.00,0.00,0.80)
mediumorchid: rdkit.sping.colors.Color  # value = Color(0.73,0.33,0.83)
mediumpurple: rdkit.sping.colors.Color  # value = Color(0.58,0.44,0.86)
mediumseagreen: rdkit.sping.colors.Color  # value = Color(0.24,0.70,0.44)
mediumslateblue: rdkit.sping.colors.Color  # value = Color(0.48,0.41,0.93)
mediumspringgreen: rdkit.sping.colors.Color  # value = Color(0.00,0.98,0.60)
mediumturquoise: rdkit.sping.colors.Color  # value = Color(0.28,0.82,0.80)
mediumvioletred: rdkit.sping.colors.Color  # value = Color(0.78,0.08,0.52)
midnightblue: rdkit.sping.colors.Color  # value = Color(0.10,0.10,0.44)
mintcream: rdkit.sping.colors.Color  # value = Color(0.96,1.00,0.98)
mistyrose: rdkit.sping.colors.Color  # value = Color(1.00,0.89,0.88)
moccasin: rdkit.sping.colors.Color  # value = Color(1.00,0.89,0.71)
modControl: int = 2
modShift: int = 1
navajowhite: rdkit.sping.colors.Color  # value = Color(1.00,0.87,0.68)
navy: rdkit.sping.colors.Color  # value = Color(0.00,0.00,0.50)
oldlace: rdkit.sping.colors.Color  # value = Color(0.99,0.96,0.90)
olive: rdkit.sping.colors.Color  # value = Color(0.50,0.50,0.00)
olivedrab: rdkit.sping.colors.Color  # value = Color(0.42,0.56,0.14)
orange: rdkit.sping.colors.Color  # value = Color(1.00,0.65,0.00)
orangered: rdkit.sping.colors.Color  # value = Color(1.00,0.27,0.00)
orchid: rdkit.sping.colors.Color  # value = Color(0.85,0.44,0.84)
palegoldenrod: rdkit.sping.colors.Color  # value = Color(0.93,0.91,0.67)
palegreen: rdkit.sping.colors.Color  # value = Color(0.60,0.98,0.60)
paleturquoise: rdkit.sping.colors.Color  # value = Color(0.69,0.93,0.93)
palevioletred: rdkit.sping.colors.Color  # value = Color(0.86,0.44,0.58)
papayawhip: rdkit.sping.colors.Color  # value = Color(1.00,0.94,0.84)
peachpuff: rdkit.sping.colors.Color  # value = Color(1.00,0.85,0.73)
peru: rdkit.sping.colors.Color  # value = Color(0.80,0.52,0.25)
pink: rdkit.sping.colors.Color  # value = Color(1.00,0.75,0.80)
plum: rdkit.sping.colors.Color  # value = Color(0.87,0.63,0.87)
powderblue: rdkit.sping.colors.Color  # value = Color(0.69,0.88,0.90)
purple: rdkit.sping.colors.Color  # value = Color(0.50,0.00,0.50)
red: rdkit.sping.colors.Color  # value = Color(1.00,0.00,0.00)
rosybrown: rdkit.sping.colors.Color  # value = Color(0.74,0.56,0.56)
royalblue: rdkit.sping.colors.Color  # value = Color(0.25,0.41,0.88)
saddlebrown: rdkit.sping.colors.Color  # value = Color(0.55,0.27,0.07)
salmon: rdkit.sping.colors.Color  # value = Color(0.98,0.50,0.45)
sandybrown: rdkit.sping.colors.Color  # value = Color(0.96,0.64,0.38)
seagreen: rdkit.sping.colors.Color  # value = Color(0.18,0.55,0.34)
seashell: rdkit.sping.colors.Color  # value = Color(1.00,0.96,0.93)
sienna: rdkit.sping.colors.Color  # value = Color(0.63,0.32,0.18)
silver: rdkit.sping.colors.Color  # value = Color(0.75,0.75,0.75)
skyblue: rdkit.sping.colors.Color  # value = Color(0.53,0.81,0.92)
slateblue: rdkit.sping.colors.Color  # value = Color(0.42,0.35,0.80)
slategray: rdkit.sping.colors.Color  # value = Color(0.44,0.50,0.56)
snow: rdkit.sping.colors.Color  # value = Color(1.00,0.98,0.98)
springgreen: rdkit.sping.colors.Color  # value = Color(0.00,1.00,0.50)
steelblue: rdkit.sping.colors.Color  # value = Color(0.27,0.51,0.71)
tan: rdkit.sping.colors.Color  # value = Color(0.82,0.71,0.55)
teal: rdkit.sping.colors.Color  # value = Color(0.00,0.50,0.50)
thistle: rdkit.sping.colors.Color  # value = Color(0.85,0.75,0.85)
tomato: rdkit.sping.colors.Color  # value = Color(1.00,0.39,0.28)
transparent: rdkit.sping.colors.Color  # value = Color(-1.00,-1.00,-1.00)
turquoise: rdkit.sping.colors.Color  # value = Color(0.25,0.88,0.82)
violet: rdkit.sping.colors.Color  # value = Color(0.93,0.51,0.93)
wheat: rdkit.sping.colors.Color  # value = Color(0.96,0.87,0.70)
white: rdkit.sping.colors.Color  # value = Color(1.00,1.00,1.00)
whitesmoke: rdkit.sping.colors.Color  # value = Color(0.96,0.96,0.96)
yellow: rdkit.sping.colors.Color  # value = Color(1.00,1.00,0.00)
yellowgreen: rdkit.sping.colors.Color  # value = Color(0.60,0.80,0.20)
