# coding: utf-8

"""
    Adzerk Decision API

    Adzerk Decision API  # noqa: E501

    The version of the OpenAPI document: 1.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from adzerk_decision_sdk.api_client import ApiClient
from adzerk_decision_sdk.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class UserdbApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_custom_properties(self, network_id, user_key, **kwargs):  # noqa: E501
        """add_custom_properties  # noqa: E501

        Add Custom Properties to a User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_custom_properties(network_id, user_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int network_id: Your Network Id (required)
        :param str user_key: The User's UserDB Key (required)
        :param object body:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.add_custom_properties_with_http_info(network_id, user_key, **kwargs)  # noqa: E501

    def add_custom_properties_with_http_info(self, network_id, user_key, **kwargs):  # noqa: E501
        """add_custom_properties  # noqa: E501

        Add Custom Properties to a User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_custom_properties_with_http_info(network_id, user_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int network_id: Your Network Id (required)
        :param str user_key: The User's UserDB Key (required)
        :param object body:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(file, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'network_id',
            'user_key',
            'body'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_custom_properties" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'network_id' is set
        if self.api_client.client_side_validation and ('network_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['network_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `network_id` when calling `add_custom_properties`")  # noqa: E501
        # verify the required parameter 'user_key' is set
        if self.api_client.client_side_validation and ('user_key' not in local_var_params or  # noqa: E501
                                                        local_var_params['user_key'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `user_key` when calling `add_custom_properties`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'network_id' in local_var_params:
            path_params['networkId'] = local_var_params['network_id']  # noqa: E501

        query_params = []
        if 'user_key' in local_var_params and local_var_params['user_key'] is not None:  # noqa: E501
            query_params.append(('userKey', local_var_params['user_key']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['image/gif'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/udb/{networkId}/custom', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_interests(self, network_id, user_key, interest, **kwargs):  # noqa: E501
        """add_interests  # noqa: E501

        Add Interests to a User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_interests(network_id, user_key, interest, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int network_id: Your Network Id (required)
        :param str user_key: The User's UserDB Key (required)
        :param str interest: Comma Seperated list of interests (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.add_interests_with_http_info(network_id, user_key, interest, **kwargs)  # noqa: E501

    def add_interests_with_http_info(self, network_id, user_key, interest, **kwargs):  # noqa: E501
        """add_interests  # noqa: E501

        Add Interests to a User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_interests_with_http_info(network_id, user_key, interest, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int network_id: Your Network Id (required)
        :param str user_key: The User's UserDB Key (required)
        :param str interest: Comma Seperated list of interests (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(file, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'network_id',
            'user_key',
            'interest'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_interests" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'network_id' is set
        if self.api_client.client_side_validation and ('network_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['network_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `network_id` when calling `add_interests`")  # noqa: E501
        # verify the required parameter 'user_key' is set
        if self.api_client.client_side_validation and ('user_key' not in local_var_params or  # noqa: E501
                                                        local_var_params['user_key'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `user_key` when calling `add_interests`")  # noqa: E501
        # verify the required parameter 'interest' is set
        if self.api_client.client_side_validation and ('interest' not in local_var_params or  # noqa: E501
                                                        local_var_params['interest'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `interest` when calling `add_interests`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'network_id' in local_var_params:
            path_params['networkId'] = local_var_params['network_id']  # noqa: E501

        query_params = []
        if 'user_key' in local_var_params and local_var_params['user_key'] is not None:  # noqa: E501
            query_params.append(('userKey', local_var_params['user_key']))  # noqa: E501
        if 'interest' in local_var_params and local_var_params['interest'] is not None:  # noqa: E501
            query_params.append(('interest', local_var_params['interest']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['image/gif'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/udb/{networkId}/interest/i.gif', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_retargeting_segment(self, network_id, advertiser_id, retargeting_segment_id, user_key, **kwargs):  # noqa: E501
        """add_retargeting_segment  # noqa: E501

        Add User to a Retargeting Segment  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_retargeting_segment(network_id, advertiser_id, retargeting_segment_id, user_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int network_id: Your Network Id (required)
        :param int advertiser_id: The Advertiser's ID (required)
        :param int retargeting_segment_id: The Segment's ID (required)
        :param str user_key: The User's UserDB Key (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.add_retargeting_segment_with_http_info(network_id, advertiser_id, retargeting_segment_id, user_key, **kwargs)  # noqa: E501

    def add_retargeting_segment_with_http_info(self, network_id, advertiser_id, retargeting_segment_id, user_key, **kwargs):  # noqa: E501
        """add_retargeting_segment  # noqa: E501

        Add User to a Retargeting Segment  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_retargeting_segment_with_http_info(network_id, advertiser_id, retargeting_segment_id, user_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int network_id: Your Network Id (required)
        :param int advertiser_id: The Advertiser's ID (required)
        :param int retargeting_segment_id: The Segment's ID (required)
        :param str user_key: The User's UserDB Key (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(file, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'network_id',
            'advertiser_id',
            'retargeting_segment_id',
            'user_key'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_retargeting_segment" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'network_id' is set
        if self.api_client.client_side_validation and ('network_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['network_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `network_id` when calling `add_retargeting_segment`")  # noqa: E501
        # verify the required parameter 'advertiser_id' is set
        if self.api_client.client_side_validation and ('advertiser_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['advertiser_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `advertiser_id` when calling `add_retargeting_segment`")  # noqa: E501
        # verify the required parameter 'retargeting_segment_id' is set
        if self.api_client.client_side_validation and ('retargeting_segment_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['retargeting_segment_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `retargeting_segment_id` when calling `add_retargeting_segment`")  # noqa: E501
        # verify the required parameter 'user_key' is set
        if self.api_client.client_side_validation and ('user_key' not in local_var_params or  # noqa: E501
                                                        local_var_params['user_key'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `user_key` when calling `add_retargeting_segment`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'network_id' in local_var_params:
            path_params['networkId'] = local_var_params['network_id']  # noqa: E501
        if 'advertiser_id' in local_var_params:
            path_params['advertiserId'] = local_var_params['advertiser_id']  # noqa: E501
        if 'retargeting_segment_id' in local_var_params:
            path_params['retargetingSegmentId'] = local_var_params['retargeting_segment_id']  # noqa: E501

        query_params = []
        if 'user_key' in local_var_params and local_var_params['user_key'] is not None:  # noqa: E501
            query_params.append(('userKey', local_var_params['user_key']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['image/gif'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/udb/{networkId}/rt/{advertiserId}/{retargetingSegmentId}/i.gif', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def forget(self, network_id, user_key, **kwargs):  # noqa: E501
        """forget  # noqa: E501

        Forget User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.forget(network_id, user_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int network_id: Your Network Id (required)
        :param str user_key: The User's UserDB Key (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.forget_with_http_info(network_id, user_key, **kwargs)  # noqa: E501

    def forget_with_http_info(self, network_id, user_key, **kwargs):  # noqa: E501
        """forget  # noqa: E501

        Forget User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.forget_with_http_info(network_id, user_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int network_id: Your Network Id (required)
        :param str user_key: The User's UserDB Key (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'network_id',
            'user_key'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method forget" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'network_id' is set
        if self.api_client.client_side_validation and ('network_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['network_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `network_id` when calling `forget`")  # noqa: E501
        # verify the required parameter 'user_key' is set
        if self.api_client.client_side_validation and ('user_key' not in local_var_params or  # noqa: E501
                                                        local_var_params['user_key'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `user_key` when calling `forget`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'network_id' in local_var_params:
            path_params['networkId'] = local_var_params['network_id']  # noqa: E501

        query_params = []
        if 'user_key' in local_var_params and local_var_params['user_key'] is not None:  # noqa: E501
            query_params.append(('userKey', local_var_params['user_key']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/udb/{networkId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def gdpr_consent(self, network_id, **kwargs):  # noqa: E501
        """gdpr_consent  # noqa: E501

        GDPR Consent  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.gdpr_consent(network_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int network_id: Your Network Id (required)
        :param ConsentRequest consent_request:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.gdpr_consent_with_http_info(network_id, **kwargs)  # noqa: E501

    def gdpr_consent_with_http_info(self, network_id, **kwargs):  # noqa: E501
        """gdpr_consent  # noqa: E501

        GDPR Consent  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.gdpr_consent_with_http_info(network_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int network_id: Your Network Id (required)
        :param ConsentRequest consent_request:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(file, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'network_id',
            'consent_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method gdpr_consent" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'network_id' is set
        if self.api_client.client_side_validation and ('network_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['network_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `network_id` when calling `gdpr_consent`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'network_id' in local_var_params:
            path_params['networkId'] = local_var_params['network_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'consent_request' in local_var_params:
            body_params = local_var_params['consent_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['image/gif'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/udb/{networkId}/consent', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def ip_override(self, network_id, user_key, ip, **kwargs):  # noqa: E501
        """ip_override  # noqa: E501

        IP Address Override  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.ip_override(network_id, user_key, ip, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int network_id: Your Network Id (required)
        :param str user_key: The User's UserDB Key (required)
        :param str ip: This is the IP to exclude (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.ip_override_with_http_info(network_id, user_key, ip, **kwargs)  # noqa: E501

    def ip_override_with_http_info(self, network_id, user_key, ip, **kwargs):  # noqa: E501
        """ip_override  # noqa: E501

        IP Address Override  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.ip_override_with_http_info(network_id, user_key, ip, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int network_id: Your Network Id (required)
        :param str user_key: The User's UserDB Key (required)
        :param str ip: This is the IP to exclude (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(file, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'network_id',
            'user_key',
            'ip'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method ip_override" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'network_id' is set
        if self.api_client.client_side_validation and ('network_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['network_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `network_id` when calling `ip_override`")  # noqa: E501
        # verify the required parameter 'user_key' is set
        if self.api_client.client_side_validation and ('user_key' not in local_var_params or  # noqa: E501
                                                        local_var_params['user_key'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `user_key` when calling `ip_override`")  # noqa: E501
        # verify the required parameter 'ip' is set
        if self.api_client.client_side_validation and ('ip' not in local_var_params or  # noqa: E501
                                                        local_var_params['ip'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `ip` when calling `ip_override`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'network_id' in local_var_params:
            path_params['networkId'] = local_var_params['network_id']  # noqa: E501

        query_params = []
        if 'user_key' in local_var_params and local_var_params['user_key'] is not None:  # noqa: E501
            query_params.append(('userKey', local_var_params['user_key']))  # noqa: E501
        if 'ip' in local_var_params and local_var_params['ip'] is not None:  # noqa: E501
            query_params.append(('ip', local_var_params['ip']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['image/gif'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/udb/{networkId}/ip/i.gif', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def match_user(self, network_id, user_key, partner_id, user_id, **kwargs):  # noqa: E501
        """match_user  # noqa: E501

        User Matching  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.match_user(network_id, user_key, partner_id, user_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int network_id: Your Network Id (required)
        :param str user_key: The User's UserDB Key (required)
        :param int partner_id: The ID of the RTB provider in Adzerk. Contact Support if you don't have the ID. (required)
        :param int user_id: This is the UserID the individual RTB provider has of the user. This is NOT the UserDB userkey. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.match_user_with_http_info(network_id, user_key, partner_id, user_id, **kwargs)  # noqa: E501

    def match_user_with_http_info(self, network_id, user_key, partner_id, user_id, **kwargs):  # noqa: E501
        """match_user  # noqa: E501

        User Matching  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.match_user_with_http_info(network_id, user_key, partner_id, user_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int network_id: Your Network Id (required)
        :param str user_key: The User's UserDB Key (required)
        :param int partner_id: The ID of the RTB provider in Adzerk. Contact Support if you don't have the ID. (required)
        :param int user_id: This is the UserID the individual RTB provider has of the user. This is NOT the UserDB userkey. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(file, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'network_id',
            'user_key',
            'partner_id',
            'user_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method match_user" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'network_id' is set
        if self.api_client.client_side_validation and ('network_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['network_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `network_id` when calling `match_user`")  # noqa: E501
        # verify the required parameter 'user_key' is set
        if self.api_client.client_side_validation and ('user_key' not in local_var_params or  # noqa: E501
                                                        local_var_params['user_key'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `user_key` when calling `match_user`")  # noqa: E501
        # verify the required parameter 'partner_id' is set
        if self.api_client.client_side_validation and ('partner_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['partner_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `partner_id` when calling `match_user`")  # noqa: E501
        # verify the required parameter 'user_id' is set
        if self.api_client.client_side_validation and ('user_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['user_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `user_id` when calling `match_user`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'network_id' in local_var_params:
            path_params['networkId'] = local_var_params['network_id']  # noqa: E501

        query_params = []
        if 'user_key' in local_var_params and local_var_params['user_key'] is not None:  # noqa: E501
            query_params.append(('userKey', local_var_params['user_key']))  # noqa: E501
        if 'partner_id' in local_var_params and local_var_params['partner_id'] is not None:  # noqa: E501
            query_params.append(('partnerId', local_var_params['partner_id']))  # noqa: E501
        if 'user_id' in local_var_params and local_var_params['user_id'] is not None:  # noqa: E501
            query_params.append(('userId', local_var_params['user_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['image/gif'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/udb/{networkId}/sync/i.gif', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def opt_out(self, network_id, user_key, **kwargs):  # noqa: E501
        """opt_out  # noqa: E501

        Opt-Out a User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.opt_out(network_id, user_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int network_id: Your Network Id (required)
        :param str user_key: The User's UserDB Key (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.opt_out_with_http_info(network_id, user_key, **kwargs)  # noqa: E501

    def opt_out_with_http_info(self, network_id, user_key, **kwargs):  # noqa: E501
        """opt_out  # noqa: E501

        Opt-Out a User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.opt_out_with_http_info(network_id, user_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int network_id: Your Network Id (required)
        :param str user_key: The User's UserDB Key (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(file, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'network_id',
            'user_key'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method opt_out" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'network_id' is set
        if self.api_client.client_side_validation and ('network_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['network_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `network_id` when calling `opt_out`")  # noqa: E501
        # verify the required parameter 'user_key' is set
        if self.api_client.client_side_validation and ('user_key' not in local_var_params or  # noqa: E501
                                                        local_var_params['user_key'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `user_key` when calling `opt_out`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'network_id' in local_var_params:
            path_params['networkId'] = local_var_params['network_id']  # noqa: E501

        query_params = []
        if 'user_key' in local_var_params and local_var_params['user_key'] is not None:  # noqa: E501
            query_params.append(('userKey', local_var_params['user_key']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['image/gif'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/udb/{networkId}/optout/i.gif', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def read(self, network_id, user_key, **kwargs):  # noqa: E501
        """read  # noqa: E501

        Read a User's UserDB Record  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.read(network_id, user_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int network_id: Your Network Id (required)
        :param str user_key: The User's UserDB Key (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.read_with_http_info(network_id, user_key, **kwargs)  # noqa: E501

    def read_with_http_info(self, network_id, user_key, **kwargs):  # noqa: E501
        """read  # noqa: E501

        Read a User's UserDB Record  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.read_with_http_info(network_id, user_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int network_id: Your Network Id (required)
        :param str user_key: The User's UserDB Key (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(object, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'network_id',
            'user_key'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'network_id' is set
        if self.api_client.client_side_validation and ('network_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['network_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `network_id` when calling `read`")  # noqa: E501
        # verify the required parameter 'user_key' is set
        if self.api_client.client_side_validation and ('user_key' not in local_var_params or  # noqa: E501
                                                        local_var_params['user_key'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `user_key` when calling `read`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'network_id' in local_var_params:
            path_params['networkId'] = local_var_params['network_id']  # noqa: E501

        query_params = []
        if 'user_key' in local_var_params and local_var_params['user_key'] is not None:  # noqa: E501
            query_params.append(('userKey', local_var_params['user_key']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/udb/{networkId}/read', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def set_user_cookie(self, network_id, user_key, **kwargs):  # noqa: E501
        """set_user_cookie  # noqa: E501

        Set User Cookie  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_user_cookie(network_id, user_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int network_id: Your Network Id (required)
        :param str user_key: UserDB Id for the user (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.set_user_cookie_with_http_info(network_id, user_key, **kwargs)  # noqa: E501

    def set_user_cookie_with_http_info(self, network_id, user_key, **kwargs):  # noqa: E501
        """set_user_cookie  # noqa: E501

        Set User Cookie  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_user_cookie_with_http_info(network_id, user_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int network_id: Your Network Id (required)
        :param str user_key: UserDB Id for the user (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(file, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'network_id',
            'user_key'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_user_cookie" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'network_id' is set
        if self.api_client.client_side_validation and ('network_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['network_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `network_id` when calling `set_user_cookie`")  # noqa: E501
        # verify the required parameter 'user_key' is set
        if self.api_client.client_side_validation and ('user_key' not in local_var_params or  # noqa: E501
                                                        local_var_params['user_key'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `user_key` when calling `set_user_cookie`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'network_id' in local_var_params:
            path_params['networkId'] = local_var_params['network_id']  # noqa: E501

        query_params = []
        if 'user_key' in local_var_params and local_var_params['user_key'] is not None:  # noqa: E501
            query_params.append(('userKey', local_var_params['user_key']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['image/gif'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/udb/{networkId}/set/i.gif', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
