"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/lambda/lambda.ts
var lambda_exports = {};
__export(lambda_exports, {
  onEvent: () => onEvent
});
module.exports = __toCommonJS(lambda_exports);

// src/lambda/request-quota.ts
var import_client_service_quotas = require("@aws-sdk/client-service-quotas");
var getCurrentQuotaValue = async (region, service, quota) => {
  const client = new import_client_service_quotas.ServiceQuotasClient({
    region
  });
  const res = await client.send(
    new import_client_service_quotas.GetServiceQuotaCommand({
      ServiceCode: service,
      QuotaCode: quota
    })
  );
  if (typeof res.Quota?.Value === "undefined") {
    throw new Error(`Invalid response for ${service}/${quota}`);
  }
  return res.Quota.Value;
};
var getRequestedQuotaChanges = async (region, service, quota) => {
  const client = new import_client_service_quotas.ServiceQuotasClient({
    region
  });
  const changes = (0, import_client_service_quotas.paginateListRequestedServiceQuotaChangeHistoryByQuota)(
    {
      client
    },
    {
      ServiceCode: service,
      QuotaCode: quota
    }
  );
  const agg = [];
  for await (const code of changes) {
    agg.push(...code.RequestedQuotas ?? []);
  }
  return agg;
};
var getPendingQuotaValue = async (region, service, quota) => {
  const requestedChanges = await getRequestedQuotaChanges(region, service, quota);
  console.log("requestedChanges", requestedChanges);
  const requests = requestedChanges.map((value) => {
    if (!value.DesiredValue || !value.Created) {
      throw new Error("invalid quota change request");
    }
    return {
      status: value.Status,
      value: value.DesiredValue,
      createdAt: value.Created
    };
  });
  return requests;
};
var deniedStatuses = [
  import_client_service_quotas.RequestStatus.DENIED,
  import_client_service_quotas.RequestStatus.NOT_APPROVED,
  import_client_service_quotas.RequestStatus.CASE_CLOSED,
  import_client_service_quotas.RequestStatus.INVALID_REQUEST
];
var pendingStatuses = [import_client_service_quotas.RequestStatus.CASE_OPENED, import_client_service_quotas.RequestStatus.PENDING, import_client_service_quotas.RequestStatus.APPROVED];
var makeRequest = async (region, service, quota, desiredValue) => {
  const client = new import_client_service_quotas.ServiceQuotasClient({
    region
  });
  const res = await client.send(
    new import_client_service_quotas.RequestServiceQuotaIncreaseCommand({
      DesiredValue: desiredValue,
      QuotaCode: quota,
      ServiceCode: service
    })
  );
  const req = res.RequestedQuota;
  if (!req) {
    throw new Error("bad response from RequestServiceQuotaIncreaseCommand");
  }
  return req;
};
var getStatus = (status) => {
  const isDenied = deniedStatuses.includes(status);
  if (isDenied) {
    return 2 /* DENIED */;
  }
  const isPending = pendingStatuses.includes(status);
  if (isPending) {
    return 1 /* REQUESTED */;
  }
  return 0 /* GRANTED */;
};
var createdAtSort = (a, b) => {
  return new Date(b.createdAt).getTime() - new Date(a.createdAt).getTime();
};
var dqvCache = {};
var clearDQVCache = () => {
  Object.keys(dqvCache).forEach((key) => {
    delete dqvCache[key];
  });
};
var getDefaultQuotaValues = async (region, service) => {
  const key = [region, service].join(":");
  if (!dqvCache[key]) {
    const agg = [];
    const client = new import_client_service_quotas.ServiceQuotasClient({
      region
    });
    const defaultQuotas = (0, import_client_service_quotas.paginateListAWSDefaultServiceQuotas)(
      {
        client
      },
      {
        ServiceCode: service
      }
    );
    for await (const quota of defaultQuotas) {
      agg.push(...quota.Quotas ?? []);
    }
    dqvCache[key] = agg;
  }
  return dqvCache[key];
};
var getDefaultQuotaValue = async (region, service, quota) => {
  const agg = await getDefaultQuotaValues(region, service);
  return agg.find((sq) => sq.QuotaCode === quota)?.Value;
};
var getCurrentOrDefaultQuotaValue = async (region, service, quota) => {
  let currentValue;
  try {
    currentValue = await getCurrentQuotaValue(region, service, quota);
  } catch (e) {
    currentValue = await getDefaultQuotaValue(region, service, quota);
  }
  if (typeof currentValue === "undefined") {
    throw new Error(`unable to get current or default value of quota: ${service}/${quota}`);
  }
  return currentValue;
};
var requestQuota = async ({ desiredValue, quota, region, service }, { rerequestWhenDenied }) => {
  if (typeof desiredValue === "string") {
    desiredValue = parseInt(desiredValue, 10);
  }
  const currentValue = await getCurrentOrDefaultQuotaValue(region, service, quota);
  if (desiredValue >= currentValue) {
    const pending = await getPendingQuotaValue(region, service, quota);
    const greaterThan = pending.filter((req) => {
      return req.value >= desiredValue;
    });
    greaterThan.sort(createdAtSort);
    if (greaterThan.length) {
      const [mostRecent] = greaterThan;
      const status2 = getStatus(mostRecent.status);
      if (rerequestWhenDenied) {
        if (status2 !== 2 /* DENIED */) {
          return status2;
        }
      } else {
        return status2;
      }
    }
    const requested = await makeRequest(region, service, quota, desiredValue);
    const status = requested.Status;
    if (!status) {
      throw new Error("no status returned from request");
    }
    return getStatus(status);
  }
  return 0 /* GRANTED */;
};
var requestQuotas = async (quotas, config) => {
  const results = [];
  for (const quota of quotas) {
    const status = await requestQuota(quota, config);
    results.push({
      quota,
      status
    });
  }
  console.table(
    results.map(({ quota, status }) => ({
      ...quota,
      status
    }))
  );
  if (config.failIfNotGranted) {
    const notGranted = results.filter((result) => result.status !== 0 /* GRANTED */);
    if (notGranted.length) {
      throw new Error(`config.failIfNotGranted is true, and ${notGranted.length} quotas are not yet granted`);
    }
  }
  clearDQVCache();
  return results;
};

// ../../modules/custom-resource-wrapper/src/custom-resource-wrapper.ts
var successEvent = (event, { data }) => {
  const { physicalResourceId, ...rest } = data ?? {};
  const restData = Object.keys(rest).length ? rest : void 0;
  return {
    ...event,
    Status: "SUCCESS",
    Data: restData,
    PhysicalResourceId: physicalResourceId ?? event.PhysicalResourceId ?? event.LogicalResourceId
  };
};
var failureEvent = (event, { reason }) => {
  return {
    ...event,
    Status: "FAILED",
    Reason: reason,
    PhysicalResourceId: event.PhysicalResourceId || event.LogicalResourceId
  };
};
var errToString = (e) => {
  return `[${e.name}] ${e.message}: ${e.stack}`;
};
var customResourceWrapper = (handler) => {
  return async (event) => {
    console.log(JSON.stringify(event));
    const { ServiceToken, ...rp } = event.ResourceProperties;
    const augmentedRP = {
      ...rp,
      requestId: event.RequestId,
      serviceToken: ServiceToken
    };
    try {
      switch (event.RequestType) {
        case "Create": {
          const data = await handler.onCreate(augmentedRP);
          return successEvent(event, { data });
        }
        case "Delete": {
          if (handler.onDelete) {
            await handler.onDelete({
              ...augmentedRP,
              physicalResourceId: event.PhysicalResourceId
            });
          }
          return successEvent(event, {});
        }
        case "Update": {
          if (handler.onUpdate) {
            const data = await handler.onUpdate(
              {
                ...augmentedRP,
                physicalResourceId: event.PhysicalResourceId
              },
              event.OldResourceProperties
            );
            return successEvent(event, { data });
          }
          return successEvent(event, {});
        }
      }
    } catch (e) {
      console.error(e);
      return failureEvent(event, { reason: errToString(e) });
    }
  };
};

// src/lambda/lambda.ts
var onEvent = customResourceWrapper({
  onCreate: ({ quotas, config }) => requestQuotas(quotas, config),
  onUpdate: ({ quotas, config }) => requestQuotas(quotas, config)
});
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  onEvent
});
