"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ServiceQuotas = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const constructs_1 = require("constructs");
const aws_lambda_1 = require("aws-cdk-lib/aws-lambda");
const path = require("path");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const custom_resources_1 = require("aws-cdk-lib/custom-resources");
class ServiceQuotas extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.quotas = [];
        this.config = props;
        const lambda = new aws_lambda_1.Function(this, 'lambda', {
            code: aws_lambda_1.Code.fromAsset(path.join(__dirname, '..', 'dist', 'lambda')),
            handler: 'lambda.onEvent',
            runtime: aws_lambda_1.Runtime.NODEJS_18_X,
            timeout: aws_cdk_lib_1.Duration.minutes(15),
        });
        lambda.addToRolePolicy(new aws_iam_1.PolicyStatement({
            actions: [
                'servicequotas:ListRequestedServiceQuotaChangeHistoryByQuota',
                'servicequotas:GetServiceQuota',
                'servicequotas:RequestServiceQuotaIncrease',
                'servicequotas:ListAWSDefaultServiceQuotas',
            ],
            resources: ['*'],
        }));
        // If we're the first thing in the account to request a service quota increase,
        // we must be able to create the service-linked role:
        // https://repost.aws/questions/QUXbD4KCv6Q6qVl8zBRqcUKA/dependencyaccessdeniedexception-when-calling-the-requestservicequotaincrease-operation-for-appstream
        lambda.addToRolePolicy(new aws_iam_1.PolicyStatement({
            actions: ['iam:CreateServiceLinkedRole'],
            resources: ['arn:aws:iam::*:role/aws-service-role/servicequotas.amazonaws.com/AWSServiceRoleForServiceQuotas*'],
            conditions: {
                StringLike: {
                    'iam:AWSServiceName': 'servicequotas.amazonaws.com',
                },
            },
        }));
        lambda.addToRolePolicy(new aws_iam_1.PolicyStatement({
            actions: ['iam:AttachRolePolicy', 'iam:PutRolePolicy'],
            resources: ['arn:aws:iam::*:role/aws-service-role/servicequotas.amazonaws.com/AWSServiceRoleForServiceQuotas*'],
        }));
        const provider = new custom_resources_1.Provider(this, 'provider', {
            onEventHandler: lambda,
        });
        const self = this;
        new aws_cdk_lib_1.CustomResource(this, 'custom-resource', {
            serviceToken: provider.serviceToken,
            properties: {
                config: this.config,
                quotas: aws_cdk_lib_1.Lazy.any({
                    produce() {
                        return self.quotas;
                    },
                }),
            },
        });
    }
    requestQuota(region, service, quota, desiredValue) {
        this.quotas.push({
            desiredValue,
            quota: quota,
            region,
            service,
        });
    }
}
exports.ServiceQuotas = ServiceQuotas;
_a = JSII_RTTI_SYMBOL_1;
ServiceQuotas[_a] = { fqn: "@reapit-cdk/service-quotas.ServiceQuotas", version: "0.1.2" };
//# sourceMappingURL=data:application/json;base64,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