'''
# @reapit-cdk/service-quotas

![npm version](https://img.shields.io/npm/v/@reapit-cdk/service-quotas)
![npm downloads](https://img.shields.io/npm/dm/@reapit-cdk/service-quotas)
![coverage: 0%25](https://img.shields.io/badge/coverage-0%25-red)
![Integ Tests: X](https://img.shields.io/badge/Integ%20Tests-X-red)

This construct allows you to IaC your service quotas

## Package Installation:

```sh
yarn add --dev @reapit-cdk/service-quotas
# or
npm install @reapit-cdk/service-quotas --save-dev
```

## Usage

```python
import { Stack, App } from 'aws-cdk-lib'
import { AWSService, AmazonCloudFrontQuota, ServiceQuotas } from '@reapit-cdk/service-quotas'

const app = new App()
const stack = new Stack(app, 'stack-name')
const quotas = new ServiceQuotas(stack, 'service-quotas', {
  // Fail the stack if your requests aren't granted yet
  failIfNotGranted: true,
  // Make another request if an existing one is denied
  rerequestWhenDenied: true,
})

quotas.requestQuota(
  // region
  'us-east-1',
  // service (use the AWSService.${Service} helper or specify the e.g. 'cloudfront' string as any)
  AWSService.AMAZON_CLOUD_FRONT,
  // quota (use the ${Service}Quota e.g. AmazonCloudFrontQuota helper or specify the 'LL-' string as any)
  AmazonCloudFrontQuota.CACHE_BEHAVIORS_PER_DISTRIBUTION,
  // desired value
  100,
)
```
'''
import abc
import builtins
import datetime
import enum
import typing

import jsii
import publication
import typing_extensions

from typeguard import check_type

from ._jsii import *

import constructs as _constructs_77d1e7e8


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AWSService")
class AWSService(enum.Enum):
    AWS_CLOUD_MAP = "AWS_CLOUD_MAP"
    ACCESS_ANALYZER = "ACCESS_ANALYZER"
    AWS_ACCOUNT_MANAGEMENT = "AWS_ACCOUNT_MANAGEMENT"
    AWS_CERTIFICATE_MANAGER_ACM = "AWS_CERTIFICATE_MANAGER_ACM"
    AWS_PRIVATE_CERTIFICATE_AUTHORITY = "AWS_PRIVATE_CERTIFICATE_AUTHORITY"
    AMAZON_MANAGED_WORKFLOWS_FOR_APACHE_AIRFLOW = "AMAZON_MANAGED_WORKFLOWS_FOR_APACHE_AIRFLOW"
    AWS_AMPLIFY = "AWS_AMPLIFY"
    AMPLIFY_UI_BUILDER = "AMPLIFY_UI_BUILDER"
    AMAZON_OPEN_SEARCH_SERVERLESS = "AMAZON_OPEN_SEARCH_SERVERLESS"
    AMAZON_API_GATEWAY = "AMAZON_API_GATEWAY"
    AMAZON_CONNECT_APPLICATION_INTEGRATIONS = "AMAZON_CONNECT_APPLICATION_INTEGRATIONS"
    AWS_APP_CONFIG = "AWS_APP_CONFIG"
    AWS_APP_FABRIC = "AWS_APP_FABRIC"
    AMAZON_APP_FLOW = "AMAZON_APP_FLOW"
    APPLICATION_AUTO_SCALING = "APPLICATION_AUTO_SCALING"
    AWS_APPLICATION_COST_PROFILER = "AWS_APPLICATION_COST_PROFILER"
    AWS_APP_MESH = "AWS_APP_MESH"
    AWS_APP_RUNNER = "AWS_APP_RUNNER"
    AMAZON_APP_STREAM_2_0 = "AMAZON_APP_STREAM_2_0"
    AWS_APP_SYNC = "AWS_APP_SYNC"
    AMAZON_MANAGED_PROMETHEUS = "AMAZON_MANAGED_PROMETHEUS"
    AMAZON_ATHENA = "AMAZON_ATHENA"
    AWS_AUDIT_MANAGER = "AWS_AUDIT_MANAGER"
    AMAZON_EC2_AUTO_SCALING = "AMAZON_EC2_AUTO_SCALING"
    AWS_AUTO_SCALING_PLANS = "AWS_AUTO_SCALING_PLANS"
    AWS_MARKETPLACE_DEPLOYMENT_SERVICE = "AWS_MARKETPLACE_DEPLOYMENT_SERVICE"
    B2_B_DATA_INTERCHANGE = "B2_B_DATA_INTERCHANGE"
    AWS_BACKUP = "AWS_BACKUP"
    AWS_BATCH = "AWS_BATCH"
    AWS_BILLING_AND_COST_MANAGEMENT_DATA_EXPORTS = "AWS_BILLING_AND_COST_MANAGEMENT_DATA_EXPORTS"
    AMAZON_BEDROCK = "AMAZON_BEDROCK"
    AMAZON_BEDROCK_AGENT = "AMAZON_BEDROCK_AGENT"
    AWS_BILLING_CONDUCTOR = "AWS_BILLING_CONDUCTOR"
    AMAZON_BRAKET = "AMAZON_BRAKET"
    AWS_BUGBUST = "AWS_BUGBUST"
    AMAZON_CONNECT_CASES = "AMAZON_CONNECT_CASES"
    AMAZON_KEYSPACES_FOR_APACHE_CASSANDRA = "AMAZON_KEYSPACES_FOR_APACHE_CASSANDRA"
    AWS_COST_EXPLORER = "AWS_COST_EXPLORER"
    AWS_CHATBOT = "AWS_CHATBOT"
    AMAZON_CHIME = "AMAZON_CHIME"
    AWS_CLEAN_ROOMS = "AWS_CLEAN_ROOMS"
    AWS_CLOUD9 = "AWS_CLOUD9"
    AWS_CLOUD_FORMATION = "AWS_CLOUD_FORMATION"
    AMAZON_CLOUD_FRONT = "AMAZON_CLOUD_FRONT"
    AWS_CLOUD_HSM = "AWS_CLOUD_HSM"
    AWS_CLOUD_SHELL = "AWS_CLOUD_SHELL"
    AWS_CLOUD_TRAIL = "AWS_CLOUD_TRAIL"
    AWS_CODE_ARTIFACT = "AWS_CODE_ARTIFACT"
    AWS_CODE_BUILD = "AWS_CODE_BUILD"
    AWS_CODE_COMMIT = "AWS_CODE_COMMIT"
    AWS_CODE_DEPLOY = "AWS_CODE_DEPLOY"
    AMAZON_CODE_GURU_PROFILER = "AMAZON_CODE_GURU_PROFILER"
    AMAZON_CODE_GURU_REVIEWER = "AMAZON_CODE_GURU_REVIEWER"
    AWS_CODE_PIPELINE = "AWS_CODE_PIPELINE"
    AMAZON_COGNITO_FEDERATED_IDENTITIES = "AMAZON_COGNITO_FEDERATED_IDENTITIES"
    AMAZON_COGNITO_USER_POOLS = "AMAZON_COGNITO_USER_POOLS"
    AMAZON_COGNITO_SYNC = "AMAZON_COGNITO_SYNC"
    AMAZON_COMPREHEND = "AMAZON_COMPREHEND"
    AMAZON_COMPREHEND_MEDICAL = "AMAZON_COMPREHEND_MEDICAL"
    AWS_COMPUTE_OPTIMIZER = "AWS_COMPUTE_OPTIMIZER"
    AWS_CONFIG = "AWS_CONFIG"
    AMAZON_CONNECT = "AMAZON_CONNECT"
    AMAZON_CONNECT_OUTBOUND_CAMPAIGNS = "AMAZON_CONNECT_OUTBOUND_CAMPAIGNS"
    MECHANICAL_TURK = "MECHANICAL_TURK"
    AWS_GLUE_DATA_BREW = "AWS_GLUE_DATA_BREW"
    AWS_DATA_EXCHANGE = "AWS_DATA_EXCHANGE"
    AWS_DATA_PIPELINE = "AWS_DATA_PIPELINE"
    AWS_DATA_SYNC = "AWS_DATA_SYNC"
    AMAZON_DATA_ZONE = "AMAZON_DATA_ZONE"
    AMAZON_DYNAMO_DB_ACCELERATOR_DAX = "AMAZON_DYNAMO_DB_ACCELERATOR_DAX"
    AWS_DEEP_RACER = "AWS_DEEP_RACER"
    AWS_DIRECT_CONNECT = "AWS_DIRECT_CONNECT"
    AWS_APPLICATION_DISCOVERY_SERVICE = "AWS_APPLICATION_DISCOVERY_SERVICE"
    AMAZON_DATA_LIFECYCLE_MANAGER = "AMAZON_DATA_LIFECYCLE_MANAGER"
    AWS_DATABASE_MIGRATION_SERVICE_AWS_DMS = "AWS_DATABASE_MIGRATION_SERVICE_AWS_DMS"
    AMAZON_DOCUMENT_DB_WITH_MONGO_DB_COMPATIBILITY = "AMAZON_DOCUMENT_DB_WITH_MONGO_DB_COMPATIBILITY"
    AMAZON_DOCUMENT_DB_ELASTIC_CLUSTERS = "AMAZON_DOCUMENT_DB_ELASTIC_CLUSTERS"
    ELASTIC_DISASTER_RECOVERY = "ELASTIC_DISASTER_RECOVERY"
    AWS_DIRECTORY_SERVICE = "AWS_DIRECTORY_SERVICE"
    AMAZON_DYNAMO_DB = "AMAZON_DYNAMO_DB"
    AMAZON_ELASTIC_BLOCK_STORE_AMAZON_EBS = "AMAZON_ELASTIC_BLOCK_STORE_AMAZON_EBS"
    AMAZON_ELASTIC_COMPUTE_CLOUD_AMAZON_EC2 = "AMAZON_ELASTIC_COMPUTE_CLOUD_AMAZON_EC2"
    IPAM = "IPAM"
    EC2_FAST_LAUNCH = "EC2_FAST_LAUNCH"
    AMAZON_ELASTIC_CONTAINER_REGISTRY_AMAZON_ECR = "AMAZON_ELASTIC_CONTAINER_REGISTRY_AMAZON_ECR"
    AMAZON_ELASTIC_CONTAINER_REGISTRY_PUBLIC_AMAZON_ECR_PUBLIC = "AMAZON_ELASTIC_CONTAINER_REGISTRY_PUBLIC_AMAZON_ECR_PUBLIC"
    AMAZON_ELASTIC_CONTAINER_SERVICE_AMAZON_ECS = "AMAZON_ELASTIC_CONTAINER_SERVICE_AMAZON_ECS"
    AMAZON_ELASTIC_KUBERNETES_SERVICE_AMAZON_EKS = "AMAZON_ELASTIC_KUBERNETES_SERVICE_AMAZON_EKS"
    AMAZON_ELASTIC_INFERENCE = "AMAZON_ELASTIC_INFERENCE"
    AMAZON_ELASTI_CACHE = "AMAZON_ELASTI_CACHE"
    AWS_ELASTIC_BEANSTALK = "AWS_ELASTIC_BEANSTALK"
    AMAZON_ELASTIC_FILE_SYSTEM_EFS = "AMAZON_ELASTIC_FILE_SYSTEM_EFS"
    ELASTIC_LOAD_BALANCING_ELB = "ELASTIC_LOAD_BALANCING_ELB"
    AMAZON_EMR = "AMAZON_EMR"
    AMAZON_ELASTIC_TRANSCODER = "AMAZON_ELASTIC_TRANSCODER"
    AMAZON_EMR_SERVERLESS = "AMAZON_EMR_SERVERLESS"
    AWS_ENTITY_RESOLUTION = "AWS_ENTITY_RESOLUTION"
    AMAZON_OPEN_SEARCH_SERVICE = "AMAZON_OPEN_SEARCH_SERVICE"
    AMAZON_EVENT_BRIDGE_CLOUD_WATCH_EVENTS = "AMAZON_EVENT_BRIDGE_CLOUD_WATCH_EVENTS"
    AMAZON_CLOUD_WATCH_EVIDENTLY = "AMAZON_CLOUD_WATCH_EVIDENTLY"
    AWS_FARGATE = "AWS_FARGATE"
    AMAZON_FIN_SPACE = "AMAZON_FIN_SPACE"
    AMAZON_KINESIS_DATA_FIREHOSE = "AMAZON_KINESIS_DATA_FIREHOSE"
    AWS_FAULT_INJECTION_SERVICE_FIS = "AWS_FAULT_INJECTION_SERVICE_FIS"
    AWS_FIREWALL_MANAGER = "AWS_FIREWALL_MANAGER"
    AMAZON_FORECAST = "AMAZON_FORECAST"
    AMAZON_FRAUD_DETECTOR = "AMAZON_FRAUD_DETECTOR"
    AMAZON_F_SX = "AMAZON_F_SX"
    AMAZON_GAME_LIFT = "AMAZON_GAME_LIFT"
    AMAZON_LOCATION_SERVICE_AMAZON_LOCATION = "AMAZON_LOCATION_SERVICE_AMAZON_LOCATION"
    AMAZON_GLACIER = "AMAZON_GLACIER"
    AWS_GLOBAL_ACCELERATOR = "AWS_GLOBAL_ACCELERATOR"
    AWS_GLUE = "AWS_GLUE"
    AMAZON_MANAGED_GRAFANA = "AMAZON_MANAGED_GRAFANA"
    AWS_IO_T_GREENGRASS = "AWS_IO_T_GREENGRASS"
    AWS_GROUND_STATION = "AWS_GROUND_STATION"
    AMAZON_GUARD_DUTY = "AMAZON_GUARD_DUTY"
    AWS_HEALTH_LAKE = "AWS_HEALTH_LAKE"
    AWS_IDENTITY_AND_ACCESS_MANAGEMENT_IAM = "AWS_IDENTITY_AND_ACCESS_MANAGEMENT_IAM"
    EC2_IMAGE_BUILDER = "EC2_IMAGE_BUILDER"
    AMAZON_INSPECTOR_CLASSIC = "AMAZON_INSPECTOR_CLASSIC"
    AMAZON_INSPECTOR = "AMAZON_INSPECTOR"
    CLOUD_WATCH_INTERNET_MONITOR = "CLOUD_WATCH_INTERNET_MONITOR"
    AWS_IO_T = "AWS_IO_T"
    AWS_IO_T_1_CLICK = "AWS_IO_T_1_CLICK"
    AWS_IO_T_ANALYTICS = "AWS_IO_T_ANALYTICS"
    AWS_IO_T_CORE = "AWS_IO_T_CORE"
    AWS_IO_T_CORE_DEVICE_ADVISOR = "AWS_IO_T_CORE_DEVICE_ADVISOR"
    AWS_IO_T_EVENTS = "AWS_IO_T_EVENTS"
    AWS_IO_T_FLEET_HUB = "AWS_IO_T_FLEET_HUB"
    AWS_IO_T_FLEET_WISE = "AWS_IO_T_FLEET_WISE"
    AWS_IO_T_ROBO_RUNNER = "AWS_IO_T_ROBO_RUNNER"
    AWS_IO_T_SITE_WISE = "AWS_IO_T_SITE_WISE"
    AWS_IO_T_THINGS_GRAPH = "AWS_IO_T_THINGS_GRAPH"
    AWS_IO_T_TWIN_MAKER = "AWS_IO_T_TWIN_MAKER"
    AWS_IO_T_WIRELESS = "AWS_IO_T_WIRELESS"
    AMAZON_INTERACTIVE_VIDEO_SERVICE = "AMAZON_INTERACTIVE_VIDEO_SERVICE"
    AMAZON_INTERACTIVE_VIDEO_SERVICE_CHAT = "AMAZON_INTERACTIVE_VIDEO_SERVICE_CHAT"
    AMAZON_MANAGED_STREAMING_FOR_KAFKA_MSK = "AMAZON_MANAGED_STREAMING_FOR_KAFKA_MSK"
    MANAGED_STREAMING_FOR_KAFKA_CONNECT = "MANAGED_STREAMING_FOR_KAFKA_CONNECT"
    AMAZON_KENDRA = "AMAZON_KENDRA"
    AMAZON_KENDRA_INTELLIGENT_RANKING = "AMAZON_KENDRA_INTELLIGENT_RANKING"
    AMAZON_KINESIS_DATA_STREAMS = "AMAZON_KINESIS_DATA_STREAMS"
    AMAZON_MANAGED_SERVICE_FOR_APACHE_FLINK = "AMAZON_MANAGED_SERVICE_FOR_APACHE_FLINK"
    AMAZON_KINESIS_VIDEO_STREAMS = "AMAZON_KINESIS_VIDEO_STREAMS"
    AWS_KEY_MANAGEMENT_SERVICE_AWS_KMS = "AWS_KEY_MANAGEMENT_SERVICE_AWS_KMS"
    AWS_LAKE_FORMATION = "AWS_LAKE_FORMATION"
    AWS_LAMBDA = "AWS_LAMBDA"
    AWS_LAUNCH_WIZARD = "AWS_LAUNCH_WIZARD"
    AMAZON_LEX = "AMAZON_LEX"
    AWS_LICENSE_MANAGER = "AWS_LICENSE_MANAGER"
    AWS_LICENSE_MANAGER_LINUX_SUBSCRIPTIONS = "AWS_LICENSE_MANAGER_LINUX_SUBSCRIPTIONS"
    AWS_LICENSE_MANAGER_USER_SUBSCRIPTIONS = "AWS_LICENSE_MANAGER_USER_SUBSCRIPTIONS"
    AMAZON_LIGHTSAIL = "AMAZON_LIGHTSAIL"
    AMAZON_CLOUD_WATCH_LOGS = "AMAZON_CLOUD_WATCH_LOGS"
    AMAZON_LOOKOUT_FOR_EQUIPMENT = "AMAZON_LOOKOUT_FOR_EQUIPMENT"
    AMAZON_LOOKOUT_FOR_METRICS = "AMAZON_LOOKOUT_FOR_METRICS"
    AMAZON_LOOKOUT_FOR_VISION = "AMAZON_LOOKOUT_FOR_VISION"
    AWS_MAINFRAME_MODERNIZATION = "AWS_MAINFRAME_MODERNIZATION"
    AMAZON_MACHINE_LEARNING = "AMAZON_MACHINE_LEARNING"
    AMAZON_MACIE = "AMAZON_MACIE"
    AMAZON_MANAGED_BLOCKCHAIN = "AMAZON_MANAGED_BLOCKCHAIN"
    AMAZON_MANAGED_BLOCKCHAIN_QUERY = "AMAZON_MANAGED_BLOCKCHAIN_QUERY"
    AWS_ELEMENTAL_MEDIA_CONNECT = "AWS_ELEMENTAL_MEDIA_CONNECT"
    AWS_ELEMENTAL_MEDIA_CONVERT = "AWS_ELEMENTAL_MEDIA_CONVERT"
    AWS_ELEMENTAL_MEDIA_LIVE = "AWS_ELEMENTAL_MEDIA_LIVE"
    AWS_ELEMENTAL_MEDIA_PACKAGE = "AWS_ELEMENTAL_MEDIA_PACKAGE"
    AWS_ELEMENTAL_MEDIA_PACKAGE_V2 = "AWS_ELEMENTAL_MEDIA_PACKAGE_V2"
    AWS_ELEMENTAL_MEDIA_STORE = "AWS_ELEMENTAL_MEDIA_STORE"
    AWS_ELEMENTAL_MEDIA_TAILOR = "AWS_ELEMENTAL_MEDIA_TAILOR"
    AWS_HEALTH_IMAGING = "AWS_HEALTH_IMAGING"
    APPLICATION_MIGRATION = "APPLICATION_MIGRATION"
    MIGRATION_HUB_ORCHESTRATOR = "MIGRATION_HUB_ORCHESTRATOR"
    MIGRATION_HUB_STRATEGY_RECOMMENDATIONS = "MIGRATION_HUB_STRATEGY_RECOMMENDATIONS"
    AMAZON_CLOUD_WATCH = "AMAZON_CLOUD_WATCH"
    AMAZON_MONITRON = "AMAZON_MONITRON"
    AMAZON_MQ = "AMAZON_MQ"
    AMAZON_NEPTUNE = "AMAZON_NEPTUNE"
    AMAZON_NEPTUNE_ANALYTICS = "AMAZON_NEPTUNE_ANALYTICS"
    AWS_NETWORK_FIREWALL = "AWS_NETWORK_FIREWALL"
    NETWORK_INSIGHTS = "NETWORK_INSIGHTS"
    AWS_CLOUD_WAN = "AWS_CLOUD_WAN"
    AMAZON_CLOUD_WATCH_NETWORK_MONITOR = "AMAZON_CLOUD_WATCH_NETWORK_MONITOR"
    AMAZON_NIMBLE_STUDIO = "AMAZON_NIMBLE_STUDIO"
    AWS_USER_NOTIFICATIONS = "AWS_USER_NOTIFICATIONS"
    AMAZON_CLOUD_WATCH_OBSERVABILITY_ACCESS_MANAGER = "AMAZON_CLOUD_WATCH_OBSERVABILITY_ACCESS_MANAGER"
    AWS_HEALTH_OMICS = "AWS_HEALTH_OMICS"
    AWS_OPS_WORKS_STACKS = "AWS_OPS_WORKS_STACKS"
    AWS_OPS_WORKS_FOR_CHEF_AUTOMATE_AND_AWS_OPS_WORKS_FOR_PUPPET_ENTERPRISE = "AWS_OPS_WORKS_FOR_CHEF_AUTOMATE_AND_AWS_OPS_WORKS_FOR_PUPPET_ENTERPRISE"
    AWS_ORGANIZATIONS = "AWS_ORGANIZATIONS"
    AWS_OUTPOSTS = "AWS_OUTPOSTS"
    AWS_PANORAMA = "AWS_PANORAMA"
    AWS_PAYMENT_CRYPTOGRAPHY = "AWS_PAYMENT_CRYPTOGRAPHY"
    PRIVATE_CA_CONNECTOR_FOR_ACTIVE_DIRECTORY = "PRIVATE_CA_CONNECTOR_FOR_ACTIVE_DIRECTORY"
    AMAZON_PERSONALIZE = "AMAZON_PERSONALIZE"
    AMAZON_PINPOINT = "AMAZON_PINPOINT"
    AMAZON_POLLY = "AMAZON_POLLY"
    AWS_PRIVATE_5_G = "AWS_PRIVATE_5_G"
    AMAZON_CONNECT_CUSTOMER_PROFILES = "AMAZON_CONNECT_CUSTOMER_PROFILES"
    AWS_PROTON = "AWS_PROTON"
    AMAZON_Q = "AMAZON_Q"
    AMAZON_QLDB = "AMAZON_QLDB"
    AMAZON_QUICK_SIGHT = "AMAZON_QUICK_SIGHT"
    AWS_RESOURCE_ACCESS_MANAGER = "AWS_RESOURCE_ACCESS_MANAGER"
    AMAZON_RECYCLE_BIN = "AMAZON_RECYCLE_BIN"
    AMAZON_RELATIONAL_DATABASE_SERVICE_AMAZON_RDS = "AMAZON_RELATIONAL_DATABASE_SERVICE_AMAZON_RDS"
    AMAZON_REDSHIFT = "AMAZON_REDSHIFT"
    AWS_MIGRATION_HUB_REFACTOR_SPACES = "AWS_MIGRATION_HUB_REFACTOR_SPACES"
    AMAZON_REKOGNITION = "AMAZON_REKOGNITION"
    AWS_RESILIENCE_HUB = "AWS_RESILIENCE_HUB"
    AWS_RESOURCE_EXPLORER = "AWS_RESOURCE_EXPLORER"
    AWS_RESOURCE_GROUPS = "AWS_RESOURCE_GROUPS"
    AWS_ROBO_MAKER = "AWS_ROBO_MAKER"
    IAM_ROLES_ANYWHERE = "IAM_ROLES_ANYWHERE"
    AMAZON_ROUTE_53 = "AMAZON_ROUTE_53"
    ROUTE_53_RESOLVER = "ROUTE_53_RESOLVER"
    AMAZON_CLOUD_WATCH_RUM = "AMAZON_CLOUD_WATCH_RUM"
    AMAZON_SIMPLE_STORAGE_SERVICE_AMAZON_S3 = "AMAZON_SIMPLE_STORAGE_SERVICE_AMAZON_S3"
    AWS_S3_OUTPOSTS = "AWS_S3_OUTPOSTS"
    AMAZON_SAGE_MAKER = "AMAZON_SAGE_MAKER"
    AMAZON_EVENT_BRIDGE_SCHEDULER = "AMAZON_EVENT_BRIDGE_SCHEDULER"
    AMAZON_EVENT_BRIDGE_SCHEMA_REGISTRY = "AMAZON_EVENT_BRIDGE_SCHEMA_REGISTRY"
    AWS_SUPPLY_CHAIN = "AWS_SUPPLY_CHAIN"
    AMAZON_SIMPLE_DB = "AMAZON_SIMPLE_DB"
    AWS_SECRETS_MANAGER = "AWS_SECRETS_MANAGER"
    AWS_SECURITY_HUB = "AWS_SECURITY_HUB"
    AWS_SERVERLESS_APPLICATION_REPOSITORY = "AWS_SERVERLESS_APPLICATION_REPOSITORY"
    AWS_SERVICE_CATALOG = "AWS_SERVICE_CATALOG"
    SERVICE_QUOTAS = "SERVICE_QUOTAS"
    AMAZON_SIMPLE_EMAIL_SERVICE_AMAZON_SES = "AMAZON_SIMPLE_EMAIL_SERVICE_AMAZON_SES"
    AWS_SHIELD_ADVANCED = "AWS_SHIELD_ADVANCED"
    AWS_SIGNER = "AWS_SIGNER"
    AWS_SIM_SPACE_WEAVER = "AWS_SIM_SPACE_WEAVER"
    AWS_SERVER_MIGRATION_SERVICE = "AWS_SERVER_MIGRATION_SERVICE"
    AWS_SNOW_DEVICE_MANAGEMENT = "AWS_SNOW_DEVICE_MANAGEMENT"
    AWS_SNOW_FAMILY = "AWS_SNOW_FAMILY"
    AMAZON_SIMPLE_NOTIFICATION_SERVICE_AMAZON_SNS = "AMAZON_SIMPLE_NOTIFICATION_SERVICE_AMAZON_SNS"
    AMAZON_SIMPLE_QUEUE_SERVICE_AMAZON_SQS = "AMAZON_SIMPLE_QUEUE_SERVICE_AMAZON_SQS"
    AWS_SYSTEMS_MANAGER = "AWS_SYSTEMS_MANAGER"
    AWS_SYSTEMS_MANAGER_INCIDENT_MANAGER_CONTACTS = "AWS_SYSTEMS_MANAGER_INCIDENT_MANAGER_CONTACTS"
    AWS_SYSTEMS_MANAGER_GUI_CONNECT = "AWS_SYSTEMS_MANAGER_GUI_CONNECT"
    AWS_SYSTEMS_MANAGER_INCIDENT_MANAGER = "AWS_SYSTEMS_MANAGER_INCIDENT_MANAGER"
    AWS_SYSTEMS_MANAGER_FOR_SAP = "AWS_SYSTEMS_MANAGER_FOR_SAP"
    AWS_IAM_IDENTITY_CENTER_SUCCESSOR_TO_AWS_SINGLE_SIGN_ON = "AWS_IAM_IDENTITY_CENTER_SUCCESSOR_TO_AWS_SINGLE_SIGN_ON"
    AWS_STEP_FUNCTIONS = "AWS_STEP_FUNCTIONS"
    AWS_STORAGE_GATEWAY = "AWS_STORAGE_GATEWAY"
    AWS_SUPPORT = "AWS_SUPPORT"
    AWS_SUPPORT_APP = "AWS_SUPPORT_APP"
    AMAZON_SIMPLE_WORKFLOW_SERVICE = "AMAZON_SIMPLE_WORKFLOW_SERVICE"
    AMAZON_TEXTRACT = "AMAZON_TEXTRACT"
    AMAZON_TIMESTREAM = "AMAZON_TIMESTREAM"
    AWS_TELCO_NETWORK_BUILDER = "AWS_TELCO_NETWORK_BUILDER"
    AMAZON_TRANSCRIBE = "AMAZON_TRANSCRIBE"
    AWS_TRANSFER_FAMILY = "AWS_TRANSFER_FAMILY"
    AMAZON_TRANSLATE = "AMAZON_TRANSLATE"
    AWS_TRUSTED_ADVISOR = "AWS_TRUSTED_ADVISOR"
    AWS_MARKETPLACE_VENDOR_INSIGHTS = "AWS_MARKETPLACE_VENDOR_INSIGHTS"
    AMAZON_VERIFIED_PERMISSIONS = "AMAZON_VERIFIED_PERMISSIONS"
    EC2_VM_IMPORT_EXPORT = "EC2_VM_IMPORT_EXPORT"
    AMAZON_CONNECT_VOICE_ID = "AMAZON_CONNECT_VOICE_ID"
    AMAZON_VIRTUAL_PRIVATE_CLOUD_AMAZON_VPC = "AMAZON_VIRTUAL_PRIVATE_CLOUD_AMAZON_VPC"
    VPC_LATTICE = "VPC_LATTICE"
    AWS_WAF_CLASSIC_GLOBAL = "AWS_WAF_CLASSIC_GLOBAL"
    AWS_WAF_CLASSIC_REGIONAL = "AWS_WAF_CLASSIC_REGIONAL"
    AWS_WAF = "AWS_WAF"
    AMAZON_WORK_SPACES_APPLICATION_MANAGER = "AMAZON_WORK_SPACES_APPLICATION_MANAGER"
    AWS_WELL_ARCHITECTED_TOOL = "AWS_WELL_ARCHITECTED_TOOL"
    AMAZON_Q_IN_CONNECT = "AMAZON_Q_IN_CONNECT"
    AMAZON_WORK_SPACES = "AMAZON_WORK_SPACES"
    AMAZON_WORK_SPACES_WEB = "AMAZON_WORK_SPACES_WEB"
    AWS_X_RAY = "AWS_X_RAY"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AccessAnalyzerQuota")
class AccessAnalyzerQuota(enum.Enum):
    POLICY_GENERATION_CLOUD_TRAIL_DATA_SIZE = "POLICY_GENERATION_CLOUD_TRAIL_DATA_SIZE"
    ARCHIVE_RULES_PER_ANALYZER = "ARCHIVE_RULES_PER_ANALYZER"
    ACCOUNT_LEVEL_ANALYZER = "ACCOUNT_LEVEL_ANALYZER"
    POLICY_GENERATION_CLOUD_TRAIL_TIME_RANGE = "POLICY_GENERATION_CLOUD_TRAIL_TIME_RANGE"
    ACCESS_PREVIEWS_PER_ANALYZER_PER_HOUR = "ACCESS_PREVIEWS_PER_ANALYZER_PER_HOUR"
    CONCURRENT_POLICY_GENERATIONS = "CONCURRENT_POLICY_GENERATIONS"
    CLOUD_TRAIL_LOG_FILES_PROCESSED_PER_POLICY_GENERATION = "CLOUD_TRAIL_LOG_FILES_PROCESSED_PER_POLICY_GENERATION"
    ORGANIZATION_LEVEL_ANALYZER = "ORGANIZATION_LEVEL_ANALYZER"
    POLICY_GENERATIONS_PER_DAY = "POLICY_GENERATIONS_PER_DAY"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AmazonApiGatewayQuota")
class AmazonApiGatewayQuota(enum.Enum):
    REGIONAL_AP_IS = "REGIONAL_AP_IS"
    MAXIMUM_ITERATIONS_IN_MAPPING_TEMPLATE = "MAXIMUM_ITERATIONS_IN_MAPPING_TEMPLATE"
    THROTTLE_RATE = "THROTTLE_RATE"
    RESOURCES_ROUTES_PER_REST_WEB_SOCKET_API = "RESOURCES_ROUTES_PER_REST_WEB_SOCKET_API"
    WEB_SOCKET_MESSAGE_PAYLOAD_SIZE = "WEB_SOCKET_MESSAGE_PAYLOAD_SIZE"
    EDGE_OPTIMIZED_AP_IS = "EDGE_OPTIMIZED_AP_IS"
    ROUTES_PER_HTTP_API = "ROUTES_PER_HTTP_API"
    WEB_SOCKET_NEW_CONNECTIONS_BURST_RATE = "WEB_SOCKET_NEW_CONNECTIONS_BURST_RATE"
    STAGE_VARIABLES_PER_STAGE = "STAGE_VARIABLES_PER_STAGE"
    WEB_SOCKET_FRAME_SIZE = "WEB_SOCKET_FRAME_SIZE"
    API_KEYS = "API_KEYS"
    TAGS_PER_STAGE = "TAGS_PER_STAGE"
    VPC_LINKS_V2 = "VPC_LINKS_V2"
    EDGE_API_URL_LENGTH = "EDGE_API_URL_LENGTH"
    STAGES_PER_API = "STAGES_PER_API"
    WEB_SOCKET_NEW_CONNECTIONS_RATE = "WEB_SOCKET_NEW_CONNECTIONS_RATE"
    MAXIMUM_COMBINED_HEADER_SIZE = "MAXIMUM_COMBINED_HEADER_SIZE"
    REGIONAL_API_URL_LENGTH = "REGIONAL_API_URL_LENGTH"
    CUSTOM_DOMAIN_NAMES = "CUSTOM_DOMAIN_NAMES"
    USAGE_PLANS = "USAGE_PLANS"
    STAGE_VARIABLE_KEY_LENGTH = "STAGE_VARIABLE_KEY_LENGTH"
    AWS_LAMBDA_AUTHORIZER_RESULT_SIZE = "AWS_LAMBDA_AUTHORIZER_RESULT_SIZE"
    VPC_LINKS = "VPC_LINKS"
    SUBNETS_PER_VPC_LINK_V2 = "SUBNETS_PER_VPC_LINK_V2"
    STAGE_VARIABLE_VALUE_LENGTH = "STAGE_VARIABLE_VALUE_LENGTH"
    MAXIMUM_CACHED_RESPONSE_SIZE = "MAXIMUM_CACHED_RESPONSE_SIZE"
    USAGE_PLANS_PER_API_KEY = "USAGE_PLANS_PER_API_KEY"
    THROTTLE_BURST_RATE = "THROTTLE_BURST_RATE"
    WEB_SOCKET_IDLE_CONNECTION_TIMEOUT = "WEB_SOCKET_IDLE_CONNECTION_TIMEOUT"
    METHOD_ARN_LENGTH = "METHOD_ARN_LENGTH"
    MAXIMUM_INTEGRATION_TIMEOUT_IN_MILLISECONDS = "MAXIMUM_INTEGRATION_TIMEOUT_IN_MILLISECONDS"
    MAXIMUM_API_CACHING_TTL = "MAXIMUM_API_CACHING_TTL"
    API_PAYLOAD_SIZE = "API_PAYLOAD_SIZE"
    MAXIMUM_RESOURCE_POLICY_SIZE_IN_BYTES = "MAXIMUM_RESOURCE_POLICY_SIZE_IN_BYTES"
    PRIVATE_AP_IS = "PRIVATE_AP_IS"
    CLIENT_CERTIFICATES = "CLIENT_CERTIFICATES"
    CONNECTION_DURATION_FOR_WEB_SOCKET_API = "CONNECTION_DURATION_FOR_WEB_SOCKET_API"
    API_STAGE_THROTTLES_IN_A_USAGE_PLAN = "API_STAGE_THROTTLES_IN_A_USAGE_PLAN"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AmazonAppFlowQuota")
class AmazonAppFlowQuota(enum.Enum):
    RATE_OF_SALESFORCE_FLOW_RUNS = "RATE_OF_SALESFORCE_FLOW_RUNS"
    RATE_OF_DYNATRACE_FLOW_RUNS = "RATE_OF_DYNATRACE_FLOW_RUNS"
    MARKETO_FLOW_RUN_SIZE = "MARKETO_FLOW_RUN_SIZE"
    RATE_OF_SINGULAR_FLOW_RUNS = "RATE_OF_SINGULAR_FLOW_RUNS"
    RATE_OF_ZENDESK_FLOW_RUNS = "RATE_OF_ZENDESK_FLOW_RUNS"
    TOTAL_FLOWS = "TOTAL_FLOWS"
    GOOGLE_ANALYTICS_DIMENSIONS = "GOOGLE_ANALYTICS_DIMENSIONS"
    SALESFORCE_FLOW_RUN_DATA_IMPORT_SIZE = "SALESFORCE_FLOW_RUN_DATA_IMPORT_SIZE"
    MONTHLY_FLOW_RUNS = "MONTHLY_FLOW_RUNS"
    SALESFORCE_FLOW_RUN_DATA_EXPORT_SIZE = "SALESFORCE_FLOW_RUN_DATA_EXPORT_SIZE"
    RATE_OF_VEEVA_FLOW_RUNS = "RATE_OF_VEEVA_FLOW_RUNS"
    RATE_OF_AMAZON_S3_FLOW_RUNS = "RATE_OF_AMAZON_S3_FLOW_RUNS"
    AMAZON_APP_FLOW_FLOW_RUN_SIZE = "AMAZON_APP_FLOW_FLOW_RUN_SIZE"
    CONCURRENT_FLOW_RUNS = "CONCURRENT_FLOW_RUNS"
    RATE_OF_MARKETO_FLOW_RUNS = "RATE_OF_MARKETO_FLOW_RUNS"
    GOOGLE_ANALYTICS_METRICS = "GOOGLE_ANALYTICS_METRICS"
    AMPLITUDE_FLOW_RUN_SIZE = "AMPLITUDE_FLOW_RUN_SIZE"
    CONNECTOR_PROFILES = "CONNECTOR_PROFILES"
    RATE_OF_SLACK_FLOW_RUNS = "RATE_OF_SLACK_FLOW_RUNS"
    SALESFORCE_EVENT_SIZE = "SALESFORCE_EVENT_SIZE"
    AMAZON_EVENT_BRIDGE_EVENT_SIZE = "AMAZON_EVENT_BRIDGE_EVENT_SIZE"
    RATE_OF_TREND_MICRO_FLOW_RUNS = "RATE_OF_TREND_MICRO_FLOW_RUNS"
    SERVICE_NOW_RECORDS = "SERVICE_NOW_RECORDS"
    RATE_OF_INFOR_NEXUS_FLOW_RUNS = "RATE_OF_INFOR_NEXUS_FLOW_RUNS"
    RATE_OF_GOOGLE_ANALYTICS_FLOW_RUNS = "RATE_OF_GOOGLE_ANALYTICS_FLOW_RUNS"
    RATE_OF_SERVICE_NOW_FLOW_RUNS = "RATE_OF_SERVICE_NOW_FLOW_RUNS"
    RATE_OF_SALESFORCE_PARDOT_FLOW_RUNS = "RATE_OF_SALESFORCE_PARDOT_FLOW_RUNS"
    RATE_OF_DATADOG_FLOW_RUNS = "RATE_OF_DATADOG_FLOW_RUNS"
    RATE_OF_AMPLITUDE_FLOW_RUNS = "RATE_OF_AMPLITUDE_FLOW_RUNS"
    RATE_OF_AMAZON_APP_FLOW_FLOW_RUNS = "RATE_OF_AMAZON_APP_FLOW_FLOW_RUNS"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AmazonAppStream20Quota")
class AmazonAppStream20Quota(enum.Enum):
    MEMORY_OPTIMIZED_Z1D_3XLARGE_STREAMING_INSTANCES_FOR_IMAGE_BUILDERS = "MEMORY_OPTIMIZED_Z1D_3XLARGE_STREAMING_INSTANCES_FOR_IMAGE_BUILDERS"
    MEMORY_OPTIMIZED_Z1D_12XLARGE_STREAMING_INSTANCES_FOR_IMAGE_BUILDERS = "MEMORY_OPTIMIZED_Z1D_12XLARGE_STREAMING_INSTANCES_FOR_IMAGE_BUILDERS"
    GRAPHICS_G5_8XLARGE_STREAMING_INSTANCES_FOR_FLEETS = "GRAPHICS_G5_8XLARGE_STREAMING_INSTANCES_FOR_FLEETS"
    GRAPHICS_G4_DN_XLARGE_STREAMING_INSTANCES_FOR_IMAGE_BUILDERS = "GRAPHICS_G4_DN_XLARGE_STREAMING_INSTANCES_FOR_IMAGE_BUILDERS"
    GRAPHICS_G4_DN_12XLARGE_STREAMING_INSTANCES_FOR_FLEETS = "GRAPHICS_G4_DN_12XLARGE_STREAMING_INSTANCES_FOR_FLEETS"
    MAX_APP_BLOCK_BUILDERS_WITH_WINDOWS_SERVER_2019_PLATFORM_AND_STREAM_STANDARD_SMALL_INSTANCE_TYPE = "MAX_APP_BLOCK_BUILDERS_WITH_WINDOWS_SERVER_2019_PLATFORM_AND_STREAM_STANDARD_SMALL_INSTANCE_TYPE"
    STANDARD_MEDIUM_STREAMING_INSTANCES_FOR_FLEETS = "STANDARD_MEDIUM_STREAMING_INSTANCES_FOR_FLEETS"
    GRAPHICS_G5_4XLARGE_STREAMING_INSTANCES_FOR_FLEETS = "GRAPHICS_G5_4XLARGE_STREAMING_INSTANCES_FOR_FLEETS"
    FLEETS = "FLEETS"
    STANDARD_LARGE_STREAMING_INSTANCES_FOR_IMAGE_BUILDERS = "STANDARD_LARGE_STREAMING_INSTANCES_FOR_IMAGE_BUILDERS"
    APP_BLOCK_BUILDERS = "APP_BLOCK_BUILDERS"
    GRAPHICS_DESIGN_2XLARGE_STREAMING_INSTANCES_FOR_FLEETS = "GRAPHICS_DESIGN_2XLARGE_STREAMING_INSTANCES_FOR_FLEETS"
    GRAPHICS_G5_12XLARGE_STREAMING_INSTANCES_FOR_IMAGE_BUILDERS = "GRAPHICS_G5_12XLARGE_STREAMING_INSTANCES_FOR_IMAGE_BUILDERS"
    GRAPHICS_G4_DN_8XLARGE_STREAMING_INSTANCES_FOR_IMAGE_BUILDERS = "GRAPHICS_G4_DN_8XLARGE_STREAMING_INSTANCES_FOR_IMAGE_BUILDERS"
    GRAPHICS_G4_DN_4XLARGE_STREAMING_INSTANCES_FOR_FLEETS = "GRAPHICS_G4_DN_4XLARGE_STREAMING_INSTANCES_FOR_FLEETS"
    MAX_CONCURRENT_SESSIONS_FOR_ELASTIC_FLEETS_WITH_AMAZON_LINUX_2_PLATFORM_AND_STREAM_STANDARD_XLARGE_INSTANCE_TYPE = "MAX_CONCURRENT_SESSIONS_FOR_ELASTIC_FLEETS_WITH_AMAZON_LINUX_2_PLATFORM_AND_STREAM_STANDARD_XLARGE_INSTANCE_TYPE"
    GRAPHICS_G5_2XLARGE_STREAMING_INSTANCES_FOR_FLEETS = "GRAPHICS_G5_2XLARGE_STREAMING_INSTANCES_FOR_FLEETS"
    MAX_APP_BLOCK_BUILDERS_WITH_WINDOWS_SERVER_2019_PLATFORM_AND_STREAM_STANDARD_MEDIUM_INSTANCE_TYPE = "MAX_APP_BLOCK_BUILDERS_WITH_WINDOWS_SERVER_2019_PLATFORM_AND_STREAM_STANDARD_MEDIUM_INSTANCE_TYPE"
    MEMORY_OPTIMIZED_LARGE_STREAMING_INSTANCES_FOR_IMAGE_BUILDERS = "MEMORY_OPTIMIZED_LARGE_STREAMING_INSTANCES_FOR_IMAGE_BUILDERS"
    GRAPHICS_PRO_16XLARGE_STREAMING_INSTANCES_FOR_FLEETS = "GRAPHICS_PRO_16XLARGE_STREAMING_INSTANCES_FOR_FLEETS"
    GRAPHICS_DESIGN_LARGE_STREAMING_INSTANCES_FOR_FLEETS = "GRAPHICS_DESIGN_LARGE_STREAMING_INSTANCES_FOR_FLEETS"
    GRAPHICS_G4_DN_2XLARGE_STREAMING_INSTANCES_FOR_IMAGE_BUILDERS = "GRAPHICS_G4_DN_2XLARGE_STREAMING_INSTANCES_FOR_IMAGE_BUILDERS"
    MEMORY_OPTIMIZED_XLARGE_STREAMING_INSTANCES_FOR_FLEETS = "MEMORY_OPTIMIZED_XLARGE_STREAMING_INSTANCES_FOR_FLEETS"
    MEMORY_OPTIMIZED_Z1D_6XLARGE_STREAMING_INSTANCES_FOR_FLEETS = "MEMORY_OPTIMIZED_Z1D_6XLARGE_STREAMING_INSTANCES_FOR_FLEETS"
    GRAPHICS_G4_DN_16XLARGE_STREAMING_INSTANCES_FOR_FLEETS = "GRAPHICS_G4_DN_16XLARGE_STREAMING_INSTANCES_FOR_FLEETS"
    MAX_CONCURRENT_SESSIONS_FOR_ELASTIC_FLEETS_WITH_AMAZON_LINUX_2_PLATFORM_AND_STREAM_STANDARD_MEDIUM_INSTANCE_TYPE = "MAX_CONCURRENT_SESSIONS_FOR_ELASTIC_FLEETS_WITH_AMAZON_LINUX_2_PLATFORM_AND_STREAM_STANDARD_MEDIUM_INSTANCE_TYPE"
    GRAPHICS_DESKTOP_2XLARGE_STREAMING_INSTANCES_FOR_IMAGE_BUILDERS = "GRAPHICS_DESKTOP_2XLARGE_STREAMING_INSTANCES_FOR_IMAGE_BUILDERS"
    GRAPHICS_G5_24XLARGE_STREAMING_INSTANCES_FOR_FLEETS = "GRAPHICS_G5_24XLARGE_STREAMING_INSTANCES_FOR_FLEETS"
    GRAPHICS_G4_DN_4XLARGE_STREAMING_INSTANCES_FOR_IMAGE_BUILDERS = "GRAPHICS_G4_DN_4XLARGE_STREAMING_INSTANCES_FOR_IMAGE_BUILDERS"
    MEMORY_OPTIMIZED_8XLARGE_STREAMING_INSTANCES_FOR_FLEETS = "MEMORY_OPTIMIZED_8XLARGE_STREAMING_INSTANCES_FOR_FLEETS"
    STANDARD_XLARGE_STREAMING_INSTANCES_FOR_IMAGE_BUILDERS = "STANDARD_XLARGE_STREAMING_INSTANCES_FOR_IMAGE_BUILDERS"
    COMPUTE_OPTIMIZED_2XLARGE_STREAMING_INSTANCES_FOR_FLEETS = "COMPUTE_OPTIMIZED_2XLARGE_STREAMING_INSTANCES_FOR_FLEETS"
    GRAPHICS_G5_8XLARGE_STREAMING_INSTANCES_FOR_IMAGE_BUILDERS = "GRAPHICS_G5_8XLARGE_STREAMING_INSTANCES_FOR_IMAGE_BUILDERS"
    GRAPHICS_G4_DN_16XLARGE_STREAMING_INSTANCES_FOR_IMAGE_BUILDERS = "GRAPHICS_G4_DN_16XLARGE_STREAMING_INSTANCES_FOR_IMAGE_BUILDERS"
    STACKS = "STACKS"
    MEMORY_OPTIMIZED_LARGE_STREAMING_INSTANCES_FOR_FLEETS = "MEMORY_OPTIMIZED_LARGE_STREAMING_INSTANCES_FOR_FLEETS"
    COMPUTE_OPTIMIZED_8XLARGE_STREAMING_INSTANCES_FOR_IMAGE_BUILDERS = "COMPUTE_OPTIMIZED_8XLARGE_STREAMING_INSTANCES_FOR_IMAGE_BUILDERS"
    MAX_CONCURRENT_SESSIONS_FOR_ELASTIC_FLEETS_WITH_WINDOWS_SERVER_2019_PLATFORM_AND_STREAM_STANDARD_2XLARGE_INSTANCE_TYPE = "MAX_CONCURRENT_SESSIONS_FOR_ELASTIC_FLEETS_WITH_WINDOWS_SERVER_2019_PLATFORM_AND_STREAM_STANDARD_2XLARGE_INSTANCE_TYPE"
    STANDARD_MEDIUM_STREAMING_INSTANCES_FOR_IMAGE_BUILDERS = "STANDARD_MEDIUM_STREAMING_INSTANCES_FOR_IMAGE_BUILDERS"
    IMAGE_BUILDERS = "IMAGE_BUILDERS"
    GRAPHICS_G5_XLARGE_STREAMING_INSTANCES_FOR_FLEETS = "GRAPHICS_G5_XLARGE_STREAMING_INSTANCES_FOR_FLEETS"
    MEMORY_OPTIMIZED_8XLARGE_STREAMING_INSTANCES_FOR_IMAGE_BUILDERS = "MEMORY_OPTIMIZED_8XLARGE_STREAMING_INSTANCES_FOR_IMAGE_BUILDERS"
    COMPUTE_OPTIMIZED_4XLARGE_STREAMING_INSTANCES_FOR_FLEETS = "COMPUTE_OPTIMIZED_4XLARGE_STREAMING_INSTANCES_FOR_FLEETS"
    MEMORY_OPTIMIZED_Z1D_XLARGE_STREAMING_INSTANCES_FOR_IMAGE_BUILDERS = "MEMORY_OPTIMIZED_Z1D_XLARGE_STREAMING_INSTANCES_FOR_IMAGE_BUILDERS"
    MEMORY_OPTIMIZED_Z1D_3XLARGE_STREAMING_INSTANCES_FOR_FLEETS = "MEMORY_OPTIMIZED_Z1D_3XLARGE_STREAMING_INSTANCES_FOR_FLEETS"
    IMAGE_SHARING_LIMIT = "IMAGE_SHARING_LIMIT"
    COMPUTE_OPTIMIZED_LARGE_STREAMING_INSTANCES_FOR_FLEETS = "COMPUTE_OPTIMIZED_LARGE_STREAMING_INSTANCES_FOR_FLEETS"
    MEMORY_OPTIMIZED_Z1D_LARGE_STREAMING_INSTANCES_FOR_FLEETS = "MEMORY_OPTIMIZED_Z1D_LARGE_STREAMING_INSTANCES_FOR_FLEETS"
    MEMORY_OPTIMIZED_Z1D_12XLARGE_STREAMING_INSTANCES_FOR_FLEETS = "MEMORY_OPTIMIZED_Z1D_12XLARGE_STREAMING_INSTANCES_FOR_FLEETS"
    STANDARD_SMALL_STREAMING_INSTANCES_FOR_IMAGE_BUILDERS = "STANDARD_SMALL_STREAMING_INSTANCES_FOR_IMAGE_BUILDERS"
    GRAPHICS_DESIGN_4XLARGE_STREAMING_INSTANCES_FOR_FLEETS = "GRAPHICS_DESIGN_4XLARGE_STREAMING_INSTANCES_FOR_FLEETS"
    MEMORY_OPTIMIZED_XLARGE_STREAMING_INSTANCES_FOR_IMAGE_BUILDERS = "MEMORY_OPTIMIZED_XLARGE_STREAMING_INSTANCES_FOR_IMAGE_BUILDERS"
    COMPUTE_OPTIMIZED_XLARGE_STREAMING_INSTANCES_FOR_IMAGE_BUILDERS = "COMPUTE_OPTIMIZED_XLARGE_STREAMING_INSTANCES_FOR_IMAGE_BUILDERS"
    STANDARD_2XLARGE_STREAMING_INSTANCES_FOR_IMAGE_BUILDERS = "STANDARD_2XLARGE_STREAMING_INSTANCES_FOR_IMAGE_BUILDERS"
    GRAPHICS_G5_12XLARGE_STREAMING_INSTANCES_FOR_FLEETS = "GRAPHICS_G5_12XLARGE_STREAMING_INSTANCES_FOR_FLEETS"
    GRAPHICS_DESIGN_XLARGE_STREAMING_INSTANCES_FOR_IMAGE_BUILDERS = "GRAPHICS_DESIGN_XLARGE_STREAMING_INSTANCES_FOR_IMAGE_BUILDERS"
    COMPUTE_OPTIMIZED_2XLARGE_STREAMING_INSTANCES_FOR_IMAGE_BUILDERS = "COMPUTE_OPTIMIZED_2XLARGE_STREAMING_INSTANCES_FOR_IMAGE_BUILDERS"
    GRAPHICS_PRO_16XLARGE_STREAMING_INSTANCES_FOR_IMAGE_BUILDERS = "GRAPHICS_PRO_16XLARGE_STREAMING_INSTANCES_FOR_IMAGE_BUILDERS"
    STANDARD_SMALL_STREAMING_INSTANCES_FOR_FLEETS = "STANDARD_SMALL_STREAMING_INSTANCES_FOR_FLEETS"
    MEMORY_OPTIMIZED_2XLARGE_STREAMING_INSTANCES_FOR_IMAGE_BUILDERS = "MEMORY_OPTIMIZED_2XLARGE_STREAMING_INSTANCES_FOR_IMAGE_BUILDERS"
    GRAPHICS_G5_4XLARGE_STREAMING_INSTANCES_FOR_IMAGE_BUILDERS = "GRAPHICS_G5_4XLARGE_STREAMING_INSTANCES_FOR_IMAGE_BUILDERS"
    MEMORY_OPTIMIZED_Z1D_2XLARGE_STREAMING_INSTANCES_FOR_IMAGE_BUILDERS = "MEMORY_OPTIMIZED_Z1D_2XLARGE_STREAMING_INSTANCES_FOR_IMAGE_BUILDERS"
    USERS_IN_THE_USER_POOL = "USERS_IN_THE_USER_POOL"
    MEMORY_OPTIMIZED_Z1D_LARGE_STREAMING_INSTANCES_FOR_IMAGE_BUILDERS = "MEMORY_OPTIMIZED_Z1D_LARGE_STREAMING_INSTANCES_FOR_IMAGE_BUILDERS"
    MAX_CONCURRENT_SESSIONS_FOR_ELASTIC_FLEETS_WITH_WINDOWS_SERVER_2019_PLATFORM_AND_STREAM_STANDARD_MEDIUM_INSTANCE_TYPE = "MAX_CONCURRENT_SESSIONS_FOR_ELASTIC_FLEETS_WITH_WINDOWS_SERVER_2019_PLATFORM_AND_STREAM_STANDARD_MEDIUM_INSTANCE_TYPE"
    COMPUTE_OPTIMIZED_XLARGE_STREAMING_INSTANCES_FOR_FLEETS = "COMPUTE_OPTIMIZED_XLARGE_STREAMING_INSTANCES_FOR_FLEETS"
    MAX_CONCURRENT_SESSIONS_FOR_ELASTIC_FLEETS_WITH_WINDOWS_SERVER_2019_PLATFORM_AND_STREAM_STANDARD_LARGE_INSTANCE_TYPE = "MAX_CONCURRENT_SESSIONS_FOR_ELASTIC_FLEETS_WITH_WINDOWS_SERVER_2019_PLATFORM_AND_STREAM_STANDARD_LARGE_INSTANCE_TYPE"
    MAX_APP_BLOCK_BUILDERS_WITH_WINDOWS_SERVER_2019_PLATFORM_AND_STREAM_STANDARD_2XLARGE_INSTANCE_TYPE = "MAX_APP_BLOCK_BUILDERS_WITH_WINDOWS_SERVER_2019_PLATFORM_AND_STREAM_STANDARD_2XLARGE_INSTANCE_TYPE"
    GRAPHICS_DESKTOP_2XLARGE_STREAMING_INSTANCES_FOR_FLEETS = "GRAPHICS_DESKTOP_2XLARGE_STREAMING_INSTANCES_FOR_FLEETS"
    ACTIVE_FLEETS = "ACTIVE_FLEETS"
    COMPUTE_OPTIMIZED_LARGE_STREAMING_INSTANCES_FOR_IMAGE_BUILDERS = "COMPUTE_OPTIMIZED_LARGE_STREAMING_INSTANCES_FOR_IMAGE_BUILDERS"
    GRAPHICS_DESIGN_LARGE_STREAMING_INSTANCES_FOR_IMAGE_BUILDERS = "GRAPHICS_DESIGN_LARGE_STREAMING_INSTANCES_FOR_IMAGE_BUILDERS"
    GRAPHICS_G5_16XLARGE_STREAMING_INSTANCES_FOR_IMAGE_BUILDERS = "GRAPHICS_G5_16XLARGE_STREAMING_INSTANCES_FOR_IMAGE_BUILDERS"
    GRAPHICS_PRO_8XLARGE_STREAMING_INSTANCES_FOR_IMAGE_BUILDERS = "GRAPHICS_PRO_8XLARGE_STREAMING_INSTANCES_FOR_IMAGE_BUILDERS"
    STANDARD_XLARGE_STREAMING_INSTANCES_FOR_FLEETS = "STANDARD_XLARGE_STREAMING_INSTANCES_FOR_FLEETS"
    MEMORY_OPTIMIZED_Z1D_6XLARGE_STREAMING_INSTANCES_FOR_IMAGE_BUILDERS = "MEMORY_OPTIMIZED_Z1D_6XLARGE_STREAMING_INSTANCES_FOR_IMAGE_BUILDERS"
    MAX_APP_BLOCK_BUILDERS_WITH_WINDOWS_SERVER_2019_PLATFORM_AND_STREAM_STANDARD_LARGE_INSTANCE_TYPE = "MAX_APP_BLOCK_BUILDERS_WITH_WINDOWS_SERVER_2019_PLATFORM_AND_STREAM_STANDARD_LARGE_INSTANCE_TYPE"
    MAX_CONCURRENT_SESSIONS_FOR_ELASTIC_FLEETS_WITH_WINDOWS_SERVER_2019_PLATFORM_AND_STREAM_STANDARD_XLARGE_INSTANCE_TYPE = "MAX_CONCURRENT_SESSIONS_FOR_ELASTIC_FLEETS_WITH_WINDOWS_SERVER_2019_PLATFORM_AND_STREAM_STANDARD_XLARGE_INSTANCE_TYPE"
    MEMORY_OPTIMIZED_Z1D_XLARGE_STREAMING_INSTANCES_FOR_FLEETS = "MEMORY_OPTIMIZED_Z1D_XLARGE_STREAMING_INSTANCES_FOR_FLEETS"
    GRAPHICS_G5_16XLARGE_STREAMING_INSTANCES_FOR_FLEETS = "GRAPHICS_G5_16XLARGE_STREAMING_INSTANCES_FOR_FLEETS"
    MEMORY_OPTIMIZED_4XLARGE_STREAMING_INSTANCES_FOR_IMAGE_BUILDERS = "MEMORY_OPTIMIZED_4XLARGE_STREAMING_INSTANCES_FOR_IMAGE_BUILDERS"
    GRAPHICS_G4_DN_XLARGE_STREAMING_INSTANCES_FOR_FLEETS = "GRAPHICS_G4_DN_XLARGE_STREAMING_INSTANCES_FOR_FLEETS"
    MAX_CONCURRENT_SESSIONS_FOR_ELASTIC_FLEETS_WITH_WINDOWS_SERVER_2019_PLATFORM_AND_STREAM_STANDARD_SMALL_INSTANCE_TYPE = "MAX_CONCURRENT_SESSIONS_FOR_ELASTIC_FLEETS_WITH_WINDOWS_SERVER_2019_PLATFORM_AND_STREAM_STANDARD_SMALL_INSTANCE_TYPE"
    MAX_CONCURRENT_SESSIONS_FOR_ELASTIC_FLEETS_WITH_AMAZON_LINUX_2_PLATFORM_AND_STREAM_STANDARD_SMALL_INSTANCE_TYPE = "MAX_CONCURRENT_SESSIONS_FOR_ELASTIC_FLEETS_WITH_AMAZON_LINUX_2_PLATFORM_AND_STREAM_STANDARD_SMALL_INSTANCE_TYPE"
    GRAPHICS_G5_24XLARGE_STREAMING_INSTANCES_FOR_IMAGE_BUILDERS = "GRAPHICS_G5_24XLARGE_STREAMING_INSTANCES_FOR_IMAGE_BUILDERS"
    GRAPHICS_G4_DN_2XLARGE_STREAMING_INSTANCES_FOR_FLEETS = "GRAPHICS_G4_DN_2XLARGE_STREAMING_INSTANCES_FOR_FLEETS"
    GRAPHICS_G4_DN_8XLARGE_STREAMING_INSTANCES_FOR_FLEETS = "GRAPHICS_G4_DN_8XLARGE_STREAMING_INSTANCES_FOR_FLEETS"
    STANDARD_LARGE_STREAMING_INSTANCES_FOR_FLEETS = "STANDARD_LARGE_STREAMING_INSTANCES_FOR_FLEETS"
    CONCURRENT_IMAGE_COPIES_PER_DESTINATION_REGION = "CONCURRENT_IMAGE_COPIES_PER_DESTINATION_REGION"
    MAX_CONCURRENT_SESSIONS_FOR_ELASTIC_FLEETS_WITH_AMAZON_LINUX_2_PLATFORM_AND_STREAM_STANDARD_LARGE_INSTANCE_TYPE = "MAX_CONCURRENT_SESSIONS_FOR_ELASTIC_FLEETS_WITH_AMAZON_LINUX_2_PLATFORM_AND_STREAM_STANDARD_LARGE_INSTANCE_TYPE"
    MEMORY_OPTIMIZED_2XLARGE_STREAMING_INSTANCES_FOR_FLEETS = "MEMORY_OPTIMIZED_2XLARGE_STREAMING_INSTANCES_FOR_FLEETS"
    MEMORY_OPTIMIZED_4XLARGE_STREAMING_INSTANCES_FOR_FLEETS = "MEMORY_OPTIMIZED_4XLARGE_STREAMING_INSTANCES_FOR_FLEETS"
    MEMORY_OPTIMIZED_Z1D_2XLARGE_STREAMING_INSTANCES_FOR_FLEETS = "MEMORY_OPTIMIZED_Z1D_2XLARGE_STREAMING_INSTANCES_FOR_FLEETS"
    GRAPHICS_DESIGN_XLARGE_STREAMING_INSTANCES_FOR_FLEETS = "GRAPHICS_DESIGN_XLARGE_STREAMING_INSTANCES_FOR_FLEETS"
    GRAPHICS_G5_2XLARGE_STREAMING_INSTANCES_FOR_IMAGE_BUILDERS = "GRAPHICS_G5_2XLARGE_STREAMING_INSTANCES_FOR_IMAGE_BUILDERS"
    GRAPHICS_DESIGN_2XLARGE_STREAMING_INSTANCES_FOR_IMAGE_BUILDERS = "GRAPHICS_DESIGN_2XLARGE_STREAMING_INSTANCES_FOR_IMAGE_BUILDERS"
    GRAPHICS_DESIGN_4XLARGE_STREAMING_INSTANCES_FOR_IMAGE_BUILDERS = "GRAPHICS_DESIGN_4XLARGE_STREAMING_INSTANCES_FOR_IMAGE_BUILDERS"
    GRAPHICS_G5_XLARGE_STREAMING_INSTANCES_FOR_IMAGE_BUILDERS = "GRAPHICS_G5_XLARGE_STREAMING_INSTANCES_FOR_IMAGE_BUILDERS"
    STANDARD_2XLARGE_STREAMING_INSTANCES_FOR_FLEETS = "STANDARD_2XLARGE_STREAMING_INSTANCES_FOR_FLEETS"
    MAX_APP_BLOCK_BUILDERS_WITH_WINDOWS_SERVER_2019_PLATFORM_AND_STREAM_STANDARD_XLARGE_INSTANCE_TYPE = "MAX_APP_BLOCK_BUILDERS_WITH_WINDOWS_SERVER_2019_PLATFORM_AND_STREAM_STANDARD_XLARGE_INSTANCE_TYPE"
    PRIVATE_IMAGES = "PRIVATE_IMAGES"
    COMPUTE_OPTIMIZED_4XLARGE_STREAMING_INSTANCES_FOR_IMAGE_BUILDERS = "COMPUTE_OPTIMIZED_4XLARGE_STREAMING_INSTANCES_FOR_IMAGE_BUILDERS"
    GRAPHICS_PRO_4XLARGE_STREAMING_INSTANCES_FOR_FLEETS = "GRAPHICS_PRO_4XLARGE_STREAMING_INSTANCES_FOR_FLEETS"
    GRAPHICS_PRO_4XLARGE_STREAMING_INSTANCES_FOR_IMAGE_BUILDERS = "GRAPHICS_PRO_4XLARGE_STREAMING_INSTANCES_FOR_IMAGE_BUILDERS"
    GRAPHICS_PRO_8XLARGE_STREAMING_INSTANCES_FOR_FLEETS = "GRAPHICS_PRO_8XLARGE_STREAMING_INSTANCES_FOR_FLEETS"
    MAX_CONCURRENT_SESSIONS_FOR_ELASTIC_FLEETS_WITH_AMAZON_LINUX_2_PLATFORM_AND_STREAM_STANDARD_2XLARGE_INSTANCE_TYPE = "MAX_CONCURRENT_SESSIONS_FOR_ELASTIC_FLEETS_WITH_AMAZON_LINUX_2_PLATFORM_AND_STREAM_STANDARD_2XLARGE_INSTANCE_TYPE"
    COMPUTE_OPTIMIZED_8XLARGE_STREAMING_INSTANCES_FOR_FLEETS = "COMPUTE_OPTIMIZED_8XLARGE_STREAMING_INSTANCES_FOR_FLEETS"
    GRAPHICS_G4_DN_12XLARGE_STREAMING_INSTANCES_FOR_IMAGE_BUILDERS = "GRAPHICS_G4_DN_12XLARGE_STREAMING_INSTANCES_FOR_IMAGE_BUILDERS"
    CONCURRENT_IMAGE_UPDATES = "CONCURRENT_IMAGE_UPDATES"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AmazonAthenaQuota")
class AmazonAthenaQuota(enum.Enum):
    ACTIVE_DML_QUERIES = "ACTIVE_DML_QUERIES"
    ACTIVE_DDL_QUERIES = "ACTIVE_DDL_QUERIES"
    APACHE_SPARK_DPU_CONCURRENCY = "APACHE_SPARK_DPU_CONCURRENCY"
    DML_QUERY_TIMEOUT = "DML_QUERY_TIMEOUT"
    DDL_QUERY_TIMEOUT = "DDL_QUERY_TIMEOUT"
    PROVISIONED_DPU = "PROVISIONED_DPU"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AmazonBedrockAgentQuota")
class AmazonBedrockAgentQuota(enum.Enum):
    CHARACTERS_IN_AGENT_INSTRUCTIONS = "CHARACTERS_IN_AGENT_INSTRUCTIONS"
    ASSOCIATED_KNOWLEDGE_BASES_PER_AGENT = "ASSOCIATED_KNOWLEDGE_BASES_PER_AGENT"
    AP_IS_PER_AGENT = "AP_IS_PER_AGENT"
    AGENTS_PER_ACCOUNT = "AGENTS_PER_ACCOUNT"
    ASSOCIATED_ALIASES_PER_AGENT = "ASSOCIATED_ALIASES_PER_AGENT"
    ACTION_GROUPS_PER_AGENT = "ACTION_GROUPS_PER_AGENT"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AmazonBedrockQuota")
class AmazonBedrockQuota(enum.Enum):
    ON_DEMAND_INVOKE_MODEL_TOKENS_PER_MINUTE_FOR_AMAZON_TITAN_IMAGE_GENERATOR_G1 = "ON_DEMAND_INVOKE_MODEL_TOKENS_PER_MINUTE_FOR_AMAZON_TITAN_IMAGE_GENERATOR_G1"
    CUSTOM_MODELS_PER_ACCOUNT = "CUSTOM_MODELS_PER_ACCOUNT"
    ON_DEMAND_INVOKE_MODEL_REQUESTS_PER_MINUTE_FOR_META_LLAMA2_CHAT_70_B = "ON_DEMAND_INVOKE_MODEL_REQUESTS_PER_MINUTE_FOR_META_LLAMA2_CHAT_70_B"
    ON_DEMAND_INVOKE_MODEL_TOKENS_PER_MINUTE_FOR_AMAZON_TITAN_EXPRESS = "ON_DEMAND_INVOKE_MODEL_TOKENS_PER_MINUTE_FOR_AMAZON_TITAN_EXPRESS"
    ON_DEMAND_INVOKE_MODEL_TOKENS_PER_MINUTE_FOR_ANTHROPIC_CLAUDE_INSTANT = "ON_DEMAND_INVOKE_MODEL_TOKENS_PER_MINUTE_FOR_ANTHROPIC_CLAUDE_INSTANT"
    ON_DEMAND_INVOKE_MODEL_REQUESTS_PER_MINUTE_FOR_COHERE_COMMAND_LIGHT = "ON_DEMAND_INVOKE_MODEL_REQUESTS_PER_MINUTE_FOR_COHERE_COMMAND_LIGHT"
    ON_DEMAND_INVOKE_MODEL_TOKENS_PER_MINUTE_FOR_COHERE_EMBED_ENGLISH = "ON_DEMAND_INVOKE_MODEL_TOKENS_PER_MINUTE_FOR_COHERE_EMBED_ENGLISH"
    MODEL_UNITS_PER_PROVISIONED_MODEL_FOR_COHERE_COMMAND = "MODEL_UNITS_PER_PROVISIONED_MODEL_FOR_COHERE_COMMAND"
    ON_DEMAND_INVOKE_MODEL_TOKENS_PER_MINUTE_FOR_AI21_LABS_JURASSIC_2_ULTRA = "ON_DEMAND_INVOKE_MODEL_TOKENS_PER_MINUTE_FOR_AI21_LABS_JURASSIC_2_ULTRA"
    MODEL_UNITS_PER_PROVISIONED_MODEL_FOR_ANTHROPIC_CLAUDE_V2_100_K = "MODEL_UNITS_PER_PROVISIONED_MODEL_FOR_ANTHROPIC_CLAUDE_V2_100_K"
    ON_DEMAND_INVOKE_MODEL_REQUESTS_PER_MINUTE_FOR_AMAZON_TITAN_TEXT_EMBEDDINGS = "ON_DEMAND_INVOKE_MODEL_REQUESTS_PER_MINUTE_FOR_AMAZON_TITAN_TEXT_EMBEDDINGS"
    ON_DEMAND_INVOKE_MODEL_TOKENS_PER_MINUTE_FOR_COHERE_COMMAND_LIGHT = "ON_DEMAND_INVOKE_MODEL_TOKENS_PER_MINUTE_FOR_COHERE_COMMAND_LIGHT"
    ON_DEMAND_INVOKE_MODEL_REQUESTS_PER_MINUTE_FOR_COHERE_COMMAND = "ON_DEMAND_INVOKE_MODEL_REQUESTS_PER_MINUTE_FOR_COHERE_COMMAND"
    ON_DEMAND_INVOKE_MODEL_TOKENS_PER_MINUTE_FOR_AMAZON_TITAN_TEXT_EMBEDDINGS = "ON_DEMAND_INVOKE_MODEL_TOKENS_PER_MINUTE_FOR_AMAZON_TITAN_TEXT_EMBEDDINGS"
    MODEL_UNITS_PER_PROVISIONED_MODEL_FOR_ANTHROPIC_CLAUDE_V2_1_200_K = "MODEL_UNITS_PER_PROVISIONED_MODEL_FOR_ANTHROPIC_CLAUDE_V2_1_200_K"
    SCHEDULED_CUSTOMIZATION_JOBS = "SCHEDULED_CUSTOMIZATION_JOBS"
    ON_DEMAND_INVOKE_MODEL_TOKENS_PER_MINUTE_FOR_META_LLAMA2_CHAT_70_B = "ON_DEMAND_INVOKE_MODEL_TOKENS_PER_MINUTE_FOR_META_LLAMA2_CHAT_70_B"
    MODEL_UNITS_PER_PROVISIONED_MODEL_FOR_ANTHROPIC_CLAUDE_V2_18_K = "MODEL_UNITS_PER_PROVISIONED_MODEL_FOR_ANTHROPIC_CLAUDE_V2_18_K"
    MODEL_UNITS_PER_PROVISIONED_MODEL_FOR_META_LLAMA_2_CHAT_70_B = "MODEL_UNITS_PER_PROVISIONED_MODEL_FOR_META_LLAMA_2_CHAT_70_B"
    MODEL_UNITS_PER_PROVISIONED_MODEL_FOR_STABLE_DIFFUSION_XL_1_0 = "MODEL_UNITS_PER_PROVISIONED_MODEL_FOR_STABLE_DIFFUSION_XL_1_0"
    ON_DEMAND_INVOKE_MODEL_REQUESTS_PER_MINUTE_FOR_META_LLAMA2_CHAT_13_B = "ON_DEMAND_INVOKE_MODEL_REQUESTS_PER_MINUTE_FOR_META_LLAMA2_CHAT_13_B"
    ON_DEMAND_INVOKE_MODEL_TOKENS_PER_MINUTE_FOR_AMAZON_TITAN_MULTIMODAL_EMBEDDINGS_G1 = "ON_DEMAND_INVOKE_MODEL_TOKENS_PER_MINUTE_FOR_AMAZON_TITAN_MULTIMODAL_EMBEDDINGS_G1"
    ON_DEMAND_INVOKE_MODEL_REQUESTS_PER_MINUTE_FOR_AI21_LABS_JURASSIC_2_MID = "ON_DEMAND_INVOKE_MODEL_REQUESTS_PER_MINUTE_FOR_AI21_LABS_JURASSIC_2_MID"
    MODEL_UNITS_PER_PROVISIONED_MODEL_FOR_TITAN_EMBEDDINGS_G1_TEXT = "MODEL_UNITS_PER_PROVISIONED_MODEL_FOR_TITAN_EMBEDDINGS_G1_TEXT"
    ON_DEMAND_INVOKE_MODEL_REQUESTS_PER_MINUTE_FOR_ANTHROPIC_CLAUDE_INSTANT = "ON_DEMAND_INVOKE_MODEL_REQUESTS_PER_MINUTE_FOR_ANTHROPIC_CLAUDE_INSTANT"
    ON_DEMAND_INVOKE_MODEL_REQUESTS_PER_MINUTE_FOR_TITAN_IMAGE_GENERATOR_G1 = "ON_DEMAND_INVOKE_MODEL_REQUESTS_PER_MINUTE_FOR_TITAN_IMAGE_GENERATOR_G1"
    MODEL_UNITS_PER_PROVISIONED_MODEL_FOR_META_LLAMA_2_70_B = "MODEL_UNITS_PER_PROVISIONED_MODEL_FOR_META_LLAMA_2_70_B"
    MODEL_UNITS_PER_PROVISIONED_MODEL_FOR_META_LLAMA_2_13_B = "MODEL_UNITS_PER_PROVISIONED_MODEL_FOR_META_LLAMA_2_13_B"
    ON_DEMAND_INVOKE_MODEL_REQUESTS_PER_MINUTE_FOR_STABILITY_AI_DIFFUSION_XL_0_8 = "ON_DEMAND_INVOKE_MODEL_REQUESTS_PER_MINUTE_FOR_STABILITY_AI_DIFFUSION_XL_0_8"
    MODEL_UNITS_PER_PROVISIONED_MODEL_FOR_TITAN_TEXT_G1_EXPRESS_8_K = "MODEL_UNITS_PER_PROVISIONED_MODEL_FOR_TITAN_TEXT_G1_EXPRESS_8_K"
    MODEL_UNITS_PER_PROVISIONED_MODEL_FOR_META_LLAMA_2_CHAT_13_B = "MODEL_UNITS_PER_PROVISIONED_MODEL_FOR_META_LLAMA_2_CHAT_13_B"
    MODEL_UNITS_PER_PROVISIONED_MODEL_FOR_TITAN_IMAGE_GENERATOR_G1 = "MODEL_UNITS_PER_PROVISIONED_MODEL_FOR_TITAN_IMAGE_GENERATOR_G1"
    ON_DEMAND_INVOKE_MODEL_TOKENS_PER_MINUTE_FOR_ANTHROPIC_CLAUDE_V2 = "ON_DEMAND_INVOKE_MODEL_TOKENS_PER_MINUTE_FOR_ANTHROPIC_CLAUDE_V2"
    ON_DEMAND_INVOKE_MODEL_TOKENS_PER_MINUTE_FOR_COHERE_COMMAND = "ON_DEMAND_INVOKE_MODEL_TOKENS_PER_MINUTE_FOR_COHERE_COMMAND"
    ON_DEMAND_INVOKE_MODEL_REQUESTS_PER_MINUTE_FOR_AMAZON_TITAN_EXPRESS = "ON_DEMAND_INVOKE_MODEL_REQUESTS_PER_MINUTE_FOR_AMAZON_TITAN_EXPRESS"
    MODEL_UNITS_PER_PROVISIONED_MODEL_FOR_COHERE_COMMAND_LIGHT = "MODEL_UNITS_PER_PROVISIONED_MODEL_FOR_COHERE_COMMAND_LIGHT"
    ON_DEMAND_INVOKE_MODEL_TOKENS_PER_MINUTE_FOR_AI21_LABS_JURASSIC_2_MID = "ON_DEMAND_INVOKE_MODEL_TOKENS_PER_MINUTE_FOR_AI21_LABS_JURASSIC_2_MID"
    ON_DEMAND_INVOKE_MODEL_REQUESTS_PER_MINUTE_FOR_ANTHROPIC_CLAUDE_V2 = "ON_DEMAND_INVOKE_MODEL_REQUESTS_PER_MINUTE_FOR_ANTHROPIC_CLAUDE_V2"
    ON_DEMAND_INVOKE_MODEL_REQUESTS_PER_MINUTE_FOR_COHERE_EMBED_MULTILINGUAL = "ON_DEMAND_INVOKE_MODEL_REQUESTS_PER_MINUTE_FOR_COHERE_EMBED_MULTILINGUAL"
    ON_DEMAND_INVOKE_MODEL_REQUESTS_PER_MINUTE_FOR_TITAN_MULTIMODAL_EMBEDDINGS_G1 = "ON_DEMAND_INVOKE_MODEL_REQUESTS_PER_MINUTE_FOR_TITAN_MULTIMODAL_EMBEDDINGS_G1"
    MODEL_UNITS_PER_PROVISIONED_MODEL_FOR_ANTHROPIC_CLAUDE_V2_1_18_K = "MODEL_UNITS_PER_PROVISIONED_MODEL_FOR_ANTHROPIC_CLAUDE_V2_1_18_K"
    ON_DEMAND_INVOKE_MODEL_TOKENS_PER_MINUTE_FOR_META_LLAMA2_CHAT_13_B = "ON_DEMAND_INVOKE_MODEL_TOKENS_PER_MINUTE_FOR_META_LLAMA2_CHAT_13_B"
    MODEL_UNITS_PER_PROVISIONED_MODEL_FOR_ANTHROPIC_CLAUDE_INSTANT_V1_100_K = "MODEL_UNITS_PER_PROVISIONED_MODEL_FOR_ANTHROPIC_CLAUDE_INSTANT_V1_100_K"
    ON_DEMAND_INVOKE_MODEL_REQUESTS_PER_MINUTE_FOR_COHERE_EMBED_ENGLISH = "ON_DEMAND_INVOKE_MODEL_REQUESTS_PER_MINUTE_FOR_COHERE_EMBED_ENGLISH"
    ON_DEMAND_INVOKE_MODEL_TOKENS_PER_MINUTE_FOR_COHERE_EMBED_MULTILINGUAL = "ON_DEMAND_INVOKE_MODEL_TOKENS_PER_MINUTE_FOR_COHERE_EMBED_MULTILINGUAL"
    ON_DEMAND_INVOKE_MODEL_REQUESTS_PER_MINUTE_FOR_STABILITY_AI_DIFFUSION_XL_1_0 = "ON_DEMAND_INVOKE_MODEL_REQUESTS_PER_MINUTE_FOR_STABILITY_AI_DIFFUSION_XL_1_0"
    ON_DEMAND_INVOKE_MODEL_REQUESTS_PER_MINUTE_FOR_AI21_LABS_JURASSIC_2_ULTRA = "ON_DEMAND_INVOKE_MODEL_REQUESTS_PER_MINUTE_FOR_AI21_LABS_JURASSIC_2_ULTRA"
    MODEL_UNITS_PER_PROVISIONED_MODEL_FOR_TITAN_MULTIMODAL_EMBEDDINGS_G1 = "MODEL_UNITS_PER_PROVISIONED_MODEL_FOR_TITAN_MULTIMODAL_EMBEDDINGS_G1"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AmazonBraketQuota")
class AmazonBraketQuota(enum.Enum):
    MAXIMUM_NUMBER_OF_INSTANCES_OF_ML_G5_48XLARGE_FOR_JOBS = "MAXIMUM_NUMBER_OF_INSTANCES_OF_ML_G5_48XLARGE_FOR_JOBS"
    NUMBER_OF_CONCURRENT_DM1_TASKS = "NUMBER_OF_CONCURRENT_DM1_TASKS"
    MAXIMUM_NUMBER_OF_INSTANCES_OF_ML_P2_16XLARGE_FOR_JOBS = "MAXIMUM_NUMBER_OF_INSTANCES_OF_ML_P2_16XLARGE_FOR_JOBS"
    MAXIMUM_NUMBER_OF_INSTANCES_OF_ML_G5_8XLARGE_FOR_JOBS = "MAXIMUM_NUMBER_OF_INSTANCES_OF_ML_G5_8XLARGE_FOR_JOBS"
    MAXIMUM_NUMBER_OF_INSTANCES_OF_ML_C5_9XLARGE_FOR_JOBS = "MAXIMUM_NUMBER_OF_INSTANCES_OF_ML_C5_9XLARGE_FOR_JOBS"
    RATE_OF_GET_DEVICE_REQUESTS = "RATE_OF_GET_DEVICE_REQUESTS"
    NUMBER_OF_CONCURRENT_SV1_TASKS = "NUMBER_OF_CONCURRENT_SV1_TASKS"
    MAXIMUM_NUMBER_OF_INSTANCES_OF_ML_G4DN_16XLARGE_FOR_JOBS = "MAXIMUM_NUMBER_OF_INSTANCES_OF_ML_G4DN_16XLARGE_FOR_JOBS"
    MAXIMUM_NUMBER_OF_INSTANCES_OF_ML_C5_2XLARGE_FOR_JOBS = "MAXIMUM_NUMBER_OF_INSTANCES_OF_ML_C5_2XLARGE_FOR_JOBS"
    ONE_QUBIT_GATE_LIMIT_FOR_ARIA = "ONE_QUBIT_GATE_LIMIT_FOR_ARIA"
    RATE_OF_GET_JOB_REQUESTS = "RATE_OF_GET_JOB_REQUESTS"
    MAXIMUM_NUMBER_OF_INSTANCES_OF_ML_P3_2XLARGE_FOR_JOBS = "MAXIMUM_NUMBER_OF_INSTANCES_OF_ML_P3_2XLARGE_FOR_JOBS"
    MAXIMUM_NUMBER_OF_INSTANCES_OF_ML_P4D_24XLARGE_FOR_JOBS = "MAXIMUM_NUMBER_OF_INSTANCES_OF_ML_P4D_24XLARGE_FOR_JOBS"
    RATE_OF_GET_QUANTUM_TASK_REQUESTS = "RATE_OF_GET_QUANTUM_TASK_REQUESTS"
    RATE_OF_CANCEL_JOB_REQUESTS = "RATE_OF_CANCEL_JOB_REQUESTS"
    MAXIMUM_NUMBER_OF_INSTANCES_OF_ML_M5_2XLARGE_FOR_JOBS = "MAXIMUM_NUMBER_OF_INSTANCES_OF_ML_M5_2XLARGE_FOR_JOBS"
    MAXIMUM_NUMBER_OF_INSTANCES_OF_ML_M4_2XLARGE_FOR_JOBS = "MAXIMUM_NUMBER_OF_INSTANCES_OF_ML_M4_2XLARGE_FOR_JOBS"
    RATE_OF_API_REQUESTS = "RATE_OF_API_REQUESTS"
    MAXIMUM_NUMBER_OF_INSTANCES_OF_ML_M5_XLARGE_FOR_JOBS = "MAXIMUM_NUMBER_OF_INSTANCES_OF_ML_M5_XLARGE_FOR_JOBS"
    MAXIMUM_NUMBER_OF_INSTANCES_OF_ML_G5_2XLARGE_FOR_JOBS = "MAXIMUM_NUMBER_OF_INSTANCES_OF_ML_G5_2XLARGE_FOR_JOBS"
    RATE_OF_CREATE_QUANTUM_TASK_REQUESTS = "RATE_OF_CREATE_QUANTUM_TASK_REQUESTS"
    MAXIMUM_NUMBER_OF_INSTANCES_OF_ML_M4_10XLARGE_FOR_JOBS = "MAXIMUM_NUMBER_OF_INSTANCES_OF_ML_M4_10XLARGE_FOR_JOBS"
    MAXIMUM_NUMBER_OF_INSTANCES_OF_ML_C4_4XLARGE_FOR_JOBS = "MAXIMUM_NUMBER_OF_INSTANCES_OF_ML_C4_4XLARGE_FOR_JOBS"
    NUMBER_OF_CONCURRENT_TN1_TASKS = "NUMBER_OF_CONCURRENT_TN1_TASKS"
    RATE_OF_SEARCH_JOBS_REQUESTS = "RATE_OF_SEARCH_JOBS_REQUESTS"
    MAXIMUM_NUMBER_OF_INSTANCES_OF_ML_M4_XLARGE_FOR_JOBS = "MAXIMUM_NUMBER_OF_INSTANCES_OF_ML_M4_XLARGE_FOR_JOBS"
    RATE_OF_CREATE_JOB_REQUESTS = "RATE_OF_CREATE_JOB_REQUESTS"
    MAXIMUM_NUMBER_OF_INSTANCES_OF_ML_C5N_9XLARGE_FOR_JOBS = "MAXIMUM_NUMBER_OF_INSTANCES_OF_ML_C5N_9XLARGE_FOR_JOBS"
    MAXIMUM_NUMBER_OF_INSTANCES_OF_ML_G4DN_XLARGE_FOR_JOBS = "MAXIMUM_NUMBER_OF_INSTANCES_OF_ML_G4DN_XLARGE_FOR_JOBS"
    MAXIMUM_NUMBER_OF_INSTANCES_OF_ML_C5_XLARGE_FOR_JOBS = "MAXIMUM_NUMBER_OF_INSTANCES_OF_ML_C5_XLARGE_FOR_JOBS"
    MAXIMUM_NUMBER_OF_INSTANCES_OF_ML_C5N_18XLARGE_FOR_JOBS = "MAXIMUM_NUMBER_OF_INSTANCES_OF_ML_C5N_18XLARGE_FOR_JOBS"
    RATE_OF_SEARCH_DEVICES_REQUESTS = "RATE_OF_SEARCH_DEVICES_REQUESTS"
    MAXIMUM_NUMBER_OF_INSTANCES_OF_ML_P3_8XLARGE_FOR_JOBS = "MAXIMUM_NUMBER_OF_INSTANCES_OF_ML_P3_8XLARGE_FOR_JOBS"
    RATE_OF_SEARCH_QUANTUM_TASKS_REQUESTS = "RATE_OF_SEARCH_QUANTUM_TASKS_REQUESTS"
    TWO_QUBIT_GATE_LIMIT_FOR_ARIA = "TWO_QUBIT_GATE_LIMIT_FOR_ARIA"
    MAXIMUM_NUMBER_OF_INSTANCES_OF_ML_G4DN_4XLARGE_FOR_JOBS = "MAXIMUM_NUMBER_OF_INSTANCES_OF_ML_G4DN_4XLARGE_FOR_JOBS"
    MAXIMUM_NUMBER_OF_INSTANCES_OF_ML_C5N_4XLARGE_FOR_JOBS = "MAXIMUM_NUMBER_OF_INSTANCES_OF_ML_C5N_4XLARGE_FOR_JOBS"
    MAXIMUM_NUMBER_OF_INSTANCES_OF_ML_C4_8XLARGE_FOR_JOBS = "MAXIMUM_NUMBER_OF_INSTANCES_OF_ML_C4_8XLARGE_FOR_JOBS"
    MAXIMUM_NUMBER_OF_INSTANCES_OF_ML_M5_4XLARGE_FOR_JOBS = "MAXIMUM_NUMBER_OF_INSTANCES_OF_ML_M5_4XLARGE_FOR_JOBS"
    MAXIMUM_NUMBER_OF_INSTANCES_OF_ML_M4_4XLARGE_FOR_JOBS = "MAXIMUM_NUMBER_OF_INSTANCES_OF_ML_M4_4XLARGE_FOR_JOBS"
    MAXIMUM_NUMBER_OF_INSTANCES_OF_ML_M5_24XLARGE_FOR_JOBS = "MAXIMUM_NUMBER_OF_INSTANCES_OF_ML_M5_24XLARGE_FOR_JOBS"
    MAXIMUM_NUMBER_OF_INSTANCES_OF_ML_G4DN_8XLARGE_FOR_JOBS = "MAXIMUM_NUMBER_OF_INSTANCES_OF_ML_G4DN_8XLARGE_FOR_JOBS"
    MAXIMUM_NUMBER_OF_INSTANCES_OF_ML_G5_XLARGE_FOR_JOBS = "MAXIMUM_NUMBER_OF_INSTANCES_OF_ML_G5_XLARGE_FOR_JOBS"
    MAXIMUM_NUMBER_OF_INSTANCES_OF_ML_P3_16XLARGE_FOR_JOBS = "MAXIMUM_NUMBER_OF_INSTANCES_OF_ML_P3_16XLARGE_FOR_JOBS"
    MAXIMUM_NUMBER_OF_INSTANCES_OF_ML_G4DN_2XLARGE_FOR_JOBS = "MAXIMUM_NUMBER_OF_INSTANCES_OF_ML_G4DN_2XLARGE_FOR_JOBS"
    MAXIMUM_NUMBER_OF_INSTANCES_OF_ML_C5N_XLARGE_FOR_JOBS = "MAXIMUM_NUMBER_OF_INSTANCES_OF_ML_C5N_XLARGE_FOR_JOBS"
    MAXIMUM_NUMBER_OF_INSTANCES_OF_ML_P2_XLARGE_FOR_JOBS = "MAXIMUM_NUMBER_OF_INSTANCES_OF_ML_P2_XLARGE_FOR_JOBS"
    MAXIMUM_NUMBER_OF_INSTANCES_OF_ML_C4_XLARGE_FOR_JOBS = "MAXIMUM_NUMBER_OF_INSTANCES_OF_ML_C4_XLARGE_FOR_JOBS"
    MAXIMUM_NUMBER_OF_INSTANCES_OF_ML_P3DN_24XLARGE_FOR_JOBS = "MAXIMUM_NUMBER_OF_INSTANCES_OF_ML_P3DN_24XLARGE_FOR_JOBS"
    MAXIMUM_NUMBER_OF_INSTANCES_OF_ML_G5_4XLARGE_FOR_JOBS = "MAXIMUM_NUMBER_OF_INSTANCES_OF_ML_G5_4XLARGE_FOR_JOBS"
    MAXIMUM_NUMBER_OF_INSTANCES_OF_ML_P2_8XLARGE_FOR_JOBS = "MAXIMUM_NUMBER_OF_INSTANCES_OF_ML_P2_8XLARGE_FOR_JOBS"
    MAXIMUM_NUMBER_OF_INSTANCES_OF_ML_M5_12XLARGE_FOR_JOBS = "MAXIMUM_NUMBER_OF_INSTANCES_OF_ML_M5_12XLARGE_FOR_JOBS"
    MAXIMUM_NUMBER_OF_INSTANCES_OF_ML_C5_4XLARGE_FOR_JOBS = "MAXIMUM_NUMBER_OF_INSTANCES_OF_ML_C5_4XLARGE_FOR_JOBS"
    MAXIMUM_NUMBER_OF_INSTANCES_OF_ML_G5_12XLARGE_FOR_JOBS = "MAXIMUM_NUMBER_OF_INSTANCES_OF_ML_G5_12XLARGE_FOR_JOBS"
    MAXIMUM_NUMBER_OF_INSTANCES_OF_ML_G5_24XLARGE_FOR_JOBS = "MAXIMUM_NUMBER_OF_INSTANCES_OF_ML_G5_24XLARGE_FOR_JOBS"
    MAXIMUM_NUMBER_OF_INSTANCES_OF_ML_G5_16XLARGE_FOR_JOBS = "MAXIMUM_NUMBER_OF_INSTANCES_OF_ML_G5_16XLARGE_FOR_JOBS"
    RATE_OF_CANCEL_QUANTUM_TASK_REQUESTS = "RATE_OF_CANCEL_QUANTUM_TASK_REQUESTS"
    MAXIMUM_NUMBER_OF_INSTANCES_OF_ML_G4DN_12XLARGE_FOR_JOBS = "MAXIMUM_NUMBER_OF_INSTANCES_OF_ML_G4DN_12XLARGE_FOR_JOBS"
    MAXIMUM_NUMBER_OF_INSTANCES_OF_ML_M5_LARGE_FOR_JOBS = "MAXIMUM_NUMBER_OF_INSTANCES_OF_ML_M5_LARGE_FOR_JOBS"
    MAXIMUM_NUMBER_OF_INSTANCES_OF_ML_C5_18XLARGE_FOR_JOBS = "MAXIMUM_NUMBER_OF_INSTANCES_OF_ML_C5_18XLARGE_FOR_JOBS"
    MAXIMUM_NUMBER_OF_INSTANCES_OF_ML_C5N_2XLARGE_FOR_JOBS = "MAXIMUM_NUMBER_OF_INSTANCES_OF_ML_C5N_2XLARGE_FOR_JOBS"
    MAXIMUM_NUMBER_OF_INSTANCES_OF_ML_C4_2XLARGE_FOR_JOBS = "MAXIMUM_NUMBER_OF_INSTANCES_OF_ML_C4_2XLARGE_FOR_JOBS"
    NUMBER_OF_CONCURRENT_JOBS = "NUMBER_OF_CONCURRENT_JOBS"
    MAXIMUM_NUMBER_OF_INSTANCES_OF_ML_M4_16XLARGE_FOR_JOBS = "MAXIMUM_NUMBER_OF_INSTANCES_OF_ML_M4_16XLARGE_FOR_JOBS"
    BURST_RATE_OF_GET_JOB_REQUESTS = "BURST_RATE_OF_GET_JOB_REQUESTS"
    BURST_RATE_OF_API_REQUESTS = "BURST_RATE_OF_API_REQUESTS"
    BURST_RATE_OF_SEARCH_QUANTUM_TASKS_REQUESTS = "BURST_RATE_OF_SEARCH_QUANTUM_TASKS_REQUESTS"
    BURST_RATE_OF_CANCEL_QUANTUM_TASK_REQUESTS = "BURST_RATE_OF_CANCEL_QUANTUM_TASK_REQUESTS"
    BURST_RATE_OF_GET_DEVICE_REQUESTS = "BURST_RATE_OF_GET_DEVICE_REQUESTS"
    BURST_RATE_OF_CREATE_JOB_REQUESTS = "BURST_RATE_OF_CREATE_JOB_REQUESTS"
    BURST_RATE_OF_SEARCH_DEVICES_REQUESTS = "BURST_RATE_OF_SEARCH_DEVICES_REQUESTS"
    BURST_RATE_OF_GET_QUANTUM_TASK_REQUESTS = "BURST_RATE_OF_GET_QUANTUM_TASK_REQUESTS"
    BURST_RATE_OF_CREATE_QUANTUM_TASK_REQUESTS = "BURST_RATE_OF_CREATE_QUANTUM_TASK_REQUESTS"
    BURST_RATE_OF_SEARCH_JOBS_REQUESTS = "BURST_RATE_OF_SEARCH_JOBS_REQUESTS"
    MAXIMUM_ALLOWED_COMPUTE_INSTANCES_FOR_A_JOB = "MAXIMUM_ALLOWED_COMPUTE_INSTANCES_FOR_A_JOB"
    BURST_RATE_OF_CANCEL_JOB_REQUESTS = "BURST_RATE_OF_CANCEL_JOB_REQUESTS"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AmazonChimeQuota")
class AmazonChimeQuota(enum.Enum):
    AMAZON_CHIME_SDK_MEETINGS_CREATE_MEETING_API_BURST_RATE_IN_REQUESTS_PER_SECOND = "AMAZON_CHIME_SDK_MEETINGS_CREATE_MEETING_API_BURST_RATE_IN_REQUESTS_PER_SECOND"
    AMAZON_CHIME_SDK_MEETINGS_LEGACY_ENDPOINT_CREATE_ATTENDEE_API_RATE_IN_REQUESTS_PER_SECOND = "AMAZON_CHIME_SDK_MEETINGS_LEGACY_ENDPOINT_CREATE_ATTENDEE_API_RATE_IN_REQUESTS_PER_SECOND"
    AMAZON_CHIME_SDK_MEETINGS_GET_MEETING_API_RATE_IN_REQUESTS_PER_SECOND = "AMAZON_CHIME_SDK_MEETINGS_GET_MEETING_API_RATE_IN_REQUESTS_PER_SECOND"
    AMAZON_CHIME_SDK_MEETINGS_CREATE_ATTENDEE_API_BURST_RATE_IN_REQUESTS_PER_SECOND = "AMAZON_CHIME_SDK_MEETINGS_CREATE_ATTENDEE_API_BURST_RATE_IN_REQUESTS_PER_SECOND"
    AMAZON_CHIME_SDK_MEETINGS_LEGACY_ENDPOINT_DELETE_ATTENDEE_API_BURST_RATE_IN_REQUESTS_PER_SECOND = "AMAZON_CHIME_SDK_MEETINGS_LEGACY_ENDPOINT_DELETE_ATTENDEE_API_BURST_RATE_IN_REQUESTS_PER_SECOND"
    AMAZON_CHIME_SDK_CALL_ANALYTICS_MAXIMUM_PIPELINES = "AMAZON_CHIME_SDK_CALL_ANALYTICS_MAXIMUM_PIPELINES"
    AMAZON_CHIME_SDK_MEETINGS_TAG_RESOURCE_API_RATE_IN_REQUESTS_PER_SECOND = "AMAZON_CHIME_SDK_MEETINGS_TAG_RESOURCE_API_RATE_IN_REQUESTS_PER_SECOND"
    AMAZON_CHIME_SDK_MEETINGS_DELETE_MEETING_API_RATE_IN_REQUESTS_PER_SECOND = "AMAZON_CHIME_SDK_MEETINGS_DELETE_MEETING_API_RATE_IN_REQUESTS_PER_SECOND"
    AMAZON_CHIME_SDK_MEETINGS_LEGACY_ENDPOINT_LIST_MEETINGS_API_BURST_RATE_IN_REQUESTS_PER_SECOND = "AMAZON_CHIME_SDK_MEETINGS_LEGACY_ENDPOINT_LIST_MEETINGS_API_BURST_RATE_IN_REQUESTS_PER_SECOND"
    AMAZON_CHIME_SDK_MEETINGS_LEGACY_ENDPOINT_BATCH_CREATE_ATTENDEES_API_RATE_IN_REQUESTS_PER_SECOND = "AMAZON_CHIME_SDK_MEETINGS_LEGACY_ENDPOINT_BATCH_CREATE_ATTENDEES_API_RATE_IN_REQUESTS_PER_SECOND"
    AMAZON_CHIME_SDK_MEETINGS_REPLICA_MEETINGS_PER_PRIMARY_MEETING = "AMAZON_CHIME_SDK_MEETINGS_REPLICA_MEETINGS_PER_PRIMARY_MEETING"
    AMAZON_CHIME_SDK_MEETINGS_CREATE_ATTENDEE_API_RATE_IN_REQUESTS_PER_SECOND = "AMAZON_CHIME_SDK_MEETINGS_CREATE_ATTENDEE_API_RATE_IN_REQUESTS_PER_SECOND"
    AMAZON_CHIME_SDK_MEETINGS_CREATE_MEETING_WITH_ATTENDEES_API_BURST_RATE_IN_REQUESTS_PER_SECOND = "AMAZON_CHIME_SDK_MEETINGS_CREATE_MEETING_WITH_ATTENDEES_API_BURST_RATE_IN_REQUESTS_PER_SECOND"
    AMAZON_CHIME_SDK_MEETINGS_UN_TAG_RESOURCE_API_RATE_IN_REQUESTS_PER_SECOND = "AMAZON_CHIME_SDK_MEETINGS_UN_TAG_RESOURCE_API_RATE_IN_REQUESTS_PER_SECOND"
    AMAZON_CHIME_SDK_MEETINGS_LEGACY_ENDPOINT_DELETE_ATTENDEE_API_RATE_IN_REQUESTS_PER_SECOND = "AMAZON_CHIME_SDK_MEETINGS_LEGACY_ENDPOINT_DELETE_ATTENDEE_API_RATE_IN_REQUESTS_PER_SECOND"
    AMAZON_CHIME_SDK_MEETINGS_LEGACY_ENDPOINT_CONCURRENT_MEETING_QUOTA = "AMAZON_CHIME_SDK_MEETINGS_LEGACY_ENDPOINT_CONCURRENT_MEETING_QUOTA"
    AMAZON_CHIME_SDK_MEDIA_PIPELINE_MAXIMUM_AMAZON_KINESIS_VIDEO_STREAM_POOLS = "AMAZON_CHIME_SDK_MEDIA_PIPELINE_MAXIMUM_AMAZON_KINESIS_VIDEO_STREAM_POOLS"
    AMAZON_CHIME_SDK_MEETINGS_LEGACY_ENDPOINT_CREATE_MEETING_WITH_ATTENDEES_API_BURST_RATE_IN_REQUESTS_PER_SECOND = "AMAZON_CHIME_SDK_MEETINGS_LEGACY_ENDPOINT_CREATE_MEETING_WITH_ATTENDEES_API_BURST_RATE_IN_REQUESTS_PER_SECOND"
    AMAZON_CHIME_SDK_MEETINGS_LIST_ATTENDEES_API_RATE_IN_REQUESTS_PER_SECOND = "AMAZON_CHIME_SDK_MEETINGS_LIST_ATTENDEES_API_RATE_IN_REQUESTS_PER_SECOND"
    AMAZON_CHIME_SDK_MEETINGS_UPDATE_ATTENDEE_CAPABILITIES_API_BURST_RATE_IN_REQUESTS_PER_SECOND = "AMAZON_CHIME_SDK_MEETINGS_UPDATE_ATTENDEE_CAPABILITIES_API_BURST_RATE_IN_REQUESTS_PER_SECOND"
    AMAZON_CHIME_SDK_MEETINGS_BATCH_CREATE_ATTENDEES_API_BURST_RATE_IN_REQUESTS_PER_SECOND = "AMAZON_CHIME_SDK_MEETINGS_BATCH_CREATE_ATTENDEES_API_BURST_RATE_IN_REQUESTS_PER_SECOND"
    AMAZON_CHIME_SDK_MEETINGS_LEGACY_ENDPOINT_CREATE_MEETING_API_RATE_IN_REQUESTS_PER_SECOND = "AMAZON_CHIME_SDK_MEETINGS_LEGACY_ENDPOINT_CREATE_MEETING_API_RATE_IN_REQUESTS_PER_SECOND"
    AMAZON_CHIME_SDK_MEETINGS_LIST_TAGS_FOR_RESOURCE_API_RATE_IN_REQUESTS_PER_SECOND = "AMAZON_CHIME_SDK_MEETINGS_LIST_TAGS_FOR_RESOURCE_API_RATE_IN_REQUESTS_PER_SECOND"
    AMAZON_CHIME_SDK_MEETINGS_CONCURRENT_VIDEO_STREAMS_PUBLISHED_PER_MEETING = "AMAZON_CHIME_SDK_MEETINGS_CONCURRENT_VIDEO_STREAMS_PUBLISHED_PER_MEETING"
    AMAZON_CHIME_SDK_MEDIA_PIPELINE_API_RATE = "AMAZON_CHIME_SDK_MEDIA_PIPELINE_API_RATE"
    AMAZON_CHIME_SDK_MEETINGS_CONCURRENT_MEETING_QUOTA = "AMAZON_CHIME_SDK_MEETINGS_CONCURRENT_MEETING_QUOTA"
    AMAZON_CHIME_SDK_MEETINGS_ALL_MEETING_MANAGEMENT_API_RATE_IN_REQUESTS_PER_SECOND = "AMAZON_CHIME_SDK_MEETINGS_ALL_MEETING_MANAGEMENT_API_RATE_IN_REQUESTS_PER_SECOND"
    AMAZON_CHIME_SDK_MEETINGS_BATCH_CREATE_ATTENDEES_API_RATE_IN_REQUESTS_PER_SECOND = "AMAZON_CHIME_SDK_MEETINGS_BATCH_CREATE_ATTENDEES_API_RATE_IN_REQUESTS_PER_SECOND"
    AMAZON_CHIME_SDK_MEETINGS_LEGACY_ENDPOINT_LIST_ATTENDEES_API_RATE_IN_REQUESTS_PER_SECOND = "AMAZON_CHIME_SDK_MEETINGS_LEGACY_ENDPOINT_LIST_ATTENDEES_API_RATE_IN_REQUESTS_PER_SECOND"
    AMAZON_CHIME_SDK_MEETINGS_DELETE_MEETING_API_BURST_RATE_IN_REQUESTS_PER_SECOND = "AMAZON_CHIME_SDK_MEETINGS_DELETE_MEETING_API_BURST_RATE_IN_REQUESTS_PER_SECOND"
    AMAZON_CHIME_SDK_MEDIA_PIPELINE_AMAZON_KINESIS_VIDEO_STREAM_POOL_API_RATE = "AMAZON_CHIME_SDK_MEDIA_PIPELINE_AMAZON_KINESIS_VIDEO_STREAM_POOL_API_RATE"
    AMAZON_CHIME_SDK_MEETINGS_LIST_MEETINGS_API_RATE_IN_REQUESTS_PER_SECOND = "AMAZON_CHIME_SDK_MEETINGS_LIST_MEETINGS_API_RATE_IN_REQUESTS_PER_SECOND"
    AMAZON_CHIME_SDK_MEETINGS_LEGACY_ENDPOINT_LIST_MEETINGS_API_RATE_IN_REQUESTS_PER_SECOND = "AMAZON_CHIME_SDK_MEETINGS_LEGACY_ENDPOINT_LIST_MEETINGS_API_RATE_IN_REQUESTS_PER_SECOND"
    AMAZON_CHIME_SDK_MEETINGS_TAG_RESOURCE_API_BURST_RATE_IN_REQUESTS_PER_SECOND = "AMAZON_CHIME_SDK_MEETINGS_TAG_RESOURCE_API_BURST_RATE_IN_REQUESTS_PER_SECOND"
    AMAZON_CHIME_SDK_MEETINGS_LEGACY_ENDPOINT_ATTENDEES_PER_MEETING = "AMAZON_CHIME_SDK_MEETINGS_LEGACY_ENDPOINT_ATTENDEES_PER_MEETING"
    AMAZON_CHIME_SDK_MEETINGS_BATCH_UPDATE_ATTENDEE_CAPABILITIES_EXCEPT_API_BURST_RATE_IN_REQUESTS_PER_SECOND = "AMAZON_CHIME_SDK_MEETINGS_BATCH_UPDATE_ATTENDEE_CAPABILITIES_EXCEPT_API_BURST_RATE_IN_REQUESTS_PER_SECOND"
    AMAZON_CHIME_SDK_MEETINGS_LEGACY_ENDPOINT_GET_MEETING_API_RATE_IN_REQUESTS_PER_SECOND = "AMAZON_CHIME_SDK_MEETINGS_LEGACY_ENDPOINT_GET_MEETING_API_RATE_IN_REQUESTS_PER_SECOND"
    AMAZON_CHIME_SDK_MEETINGS_LEGACY_ENDPOINT_LIST_ATTENDEES_API_BURST_RATE_IN_REQUESTS_PER_SECOND = "AMAZON_CHIME_SDK_MEETINGS_LEGACY_ENDPOINT_LIST_ATTENDEES_API_BURST_RATE_IN_REQUESTS_PER_SECOND"
    AMAZON_CHIME_SDK_MEETINGS_DELETE_ATTENDEE_API_RATE_IN_REQUESTS_PER_SECOND = "AMAZON_CHIME_SDK_MEETINGS_DELETE_ATTENDEE_API_RATE_IN_REQUESTS_PER_SECOND"
    AMAZON_CHIME_SDK_MEETINGS_LEGACY_ENDPOINT_CREATE_MEETING_WITH_ATTENDEES_API_RATE_IN_REQUESTS_PER_SECOND = "AMAZON_CHIME_SDK_MEETINGS_LEGACY_ENDPOINT_CREATE_MEETING_WITH_ATTENDEES_API_RATE_IN_REQUESTS_PER_SECOND"
    AMAZON_CHIME_SDK_MEETINGS_GET_MEETING_API_BURST_RATE_IN_REQUESTS_PER_SECOND = "AMAZON_CHIME_SDK_MEETINGS_GET_MEETING_API_BURST_RATE_IN_REQUESTS_PER_SECOND"
    AMAZON_CHIME_SDK_MEETINGS_CREATE_MEETING_WITH_ATTENDEES_API_RATE_IN_REQUESTS_PER_SECOND = "AMAZON_CHIME_SDK_MEETINGS_CREATE_MEETING_WITH_ATTENDEES_API_RATE_IN_REQUESTS_PER_SECOND"
    AMAZON_CHIME_SDK_MEETINGS_LEGACY_ENDPOINT_BATCH_CREATE_ATTENDEES_BURST_QUOTA = "AMAZON_CHIME_SDK_MEETINGS_LEGACY_ENDPOINT_BATCH_CREATE_ATTENDEES_BURST_QUOTA"
    AMAZON_CHIME_SDK_MEETINGS_CONCURRENT_VIDEO_STREAMS_SUBSCRIBED_PER_ATTENDEE = "AMAZON_CHIME_SDK_MEETINGS_CONCURRENT_VIDEO_STREAMS_SUBSCRIBED_PER_ATTENDEE"
    AMAZON_CHIME_SDK_CALL_ANALYTICS_MAXIMUM_CONFIGURATIONS = "AMAZON_CHIME_SDK_CALL_ANALYTICS_MAXIMUM_CONFIGURATIONS"
    AMAZON_CHIME_SDK_MEETINGS_LIST_MEETINGS_API_BURST_RATE_IN_REQUESTS_PER_SECOND = "AMAZON_CHIME_SDK_MEETINGS_LIST_MEETINGS_API_BURST_RATE_IN_REQUESTS_PER_SECOND"
    AMAZON_CHIME_SDK_MEETINGS_UPDATE_ATTENDEE_CAPABILITIES_API_RATE_IN_REQUESTS_PER_SECOND = "AMAZON_CHIME_SDK_MEETINGS_UPDATE_ATTENDEE_CAPABILITIES_API_RATE_IN_REQUESTS_PER_SECOND"
    AMAZON_CHIME_SDK_MEETINGS_LEGACY_ENDPOINT_CREATE_ATTENDEE_API_BURST_RATE_IN_REQUESTS_PER_SECOND = "AMAZON_CHIME_SDK_MEETINGS_LEGACY_ENDPOINT_CREATE_ATTENDEE_API_BURST_RATE_IN_REQUESTS_PER_SECOND"
    AMAZON_CHIME_SDK_MEETINGS_ATTENDEES_PER_MEETING = "AMAZON_CHIME_SDK_MEETINGS_ATTENDEES_PER_MEETING"
    AMAZON_CHIME_SDK_MEDIA_PIPELINE_MAXIMUM_PIPELINES = "AMAZON_CHIME_SDK_MEDIA_PIPELINE_MAXIMUM_PIPELINES"
    AMAZON_CHIME_SDK_MEETINGS_BATCH_UPDATE_ATTENDEE_CAPABILITIES_EXCEPT_API_RATE_IN_REQUESTS_PER_SECOND = "AMAZON_CHIME_SDK_MEETINGS_BATCH_UPDATE_ATTENDEE_CAPABILITIES_EXCEPT_API_RATE_IN_REQUESTS_PER_SECOND"
    AMAZON_CHIME_SDK_MEETINGS_LEGACY_ENDPOINT_DELETE_MEETING_API_RATE_IN_REQUESTS_PER_SECOND = "AMAZON_CHIME_SDK_MEETINGS_LEGACY_ENDPOINT_DELETE_MEETING_API_RATE_IN_REQUESTS_PER_SECOND"
    AMAZON_CHIME_SDK_MEETINGS_LEGACY_ENDPOINT_ALL_MEETING_MANAGEMENT_API_RATE_IN_REQUESTS_PER_SECOND = "AMAZON_CHIME_SDK_MEETINGS_LEGACY_ENDPOINT_ALL_MEETING_MANAGEMENT_API_RATE_IN_REQUESTS_PER_SECOND"
    AMAZON_CHIME_SDK_MEETINGS_UN_TAG_RESOURCE_API_BURST_RATE_IN_REQUESTS_PER_SECOND = "AMAZON_CHIME_SDK_MEETINGS_UN_TAG_RESOURCE_API_BURST_RATE_IN_REQUESTS_PER_SECOND"
    AMAZON_CHIME_SDK_MEETINGS_LEGACY_ENDPOINT_DELETE_MEETING_API_BURST_RATE_IN_REQUESTS_PER_SECOND = "AMAZON_CHIME_SDK_MEETINGS_LEGACY_ENDPOINT_DELETE_MEETING_API_BURST_RATE_IN_REQUESTS_PER_SECOND"
    AMAZON_CHIME_SDK_CALL_ANALYTICS_API_RATE = "AMAZON_CHIME_SDK_CALL_ANALYTICS_API_RATE"
    AMAZON_CHIME_SDK_MEETINGS_LEGACY_ENDPOINT_ALL_MEETING_MANAGEMENT_API_BURST_RATE_IN_REQUESTS_PER_SECOND = "AMAZON_CHIME_SDK_MEETINGS_LEGACY_ENDPOINT_ALL_MEETING_MANAGEMENT_API_BURST_RATE_IN_REQUESTS_PER_SECOND"
    AMAZON_CHIME_SDK_MEETINGS_LIST_ATTENDEES_API_BURST_RATE_IN_REQUESTS_PER_SECOND = "AMAZON_CHIME_SDK_MEETINGS_LIST_ATTENDEES_API_BURST_RATE_IN_REQUESTS_PER_SECOND"
    AMAZON_CHIME_SDK_MEETINGS_CREATE_MEETING_API_RATE_IN_REQUESTS_PER_SECOND = "AMAZON_CHIME_SDK_MEETINGS_CREATE_MEETING_API_RATE_IN_REQUESTS_PER_SECOND"
    AMAZON_CHIME_SDK_MEETINGS_ALL_MEETING_MANAGEMENT_API_BURST_RATE_IN_REQUESTS_PER_SECOND = "AMAZON_CHIME_SDK_MEETINGS_ALL_MEETING_MANAGEMENT_API_BURST_RATE_IN_REQUESTS_PER_SECOND"
    AMAZON_CHIME_SDK_MEETINGS_DELETE_ATTENDEE_API_BURST_RATE_IN_REQUESTS_PER_SECOND = "AMAZON_CHIME_SDK_MEETINGS_DELETE_ATTENDEE_API_BURST_RATE_IN_REQUESTS_PER_SECOND"
    AMAZON_CHIME_SDK_MEETINGS_LEGACY_ENDPOINT_CREATE_MEETING_API_BURST_RATE_IN_REQUESTS_PER_SECOND = "AMAZON_CHIME_SDK_MEETINGS_LEGACY_ENDPOINT_CREATE_MEETING_API_BURST_RATE_IN_REQUESTS_PER_SECOND"
    AMAZON_CHIME_SDK_MEETINGS_LEGACY_ENDPOINT_GET_MEETING_API_BURST_RATE_IN_REQUESTS_PER_SECOND = "AMAZON_CHIME_SDK_MEETINGS_LEGACY_ENDPOINT_GET_MEETING_API_BURST_RATE_IN_REQUESTS_PER_SECOND"
    AMAZON_CHIME_SDK_MESSAGING_LISTING_CHANNEL_MEMBERSHIPS_API_REQUESTS_PER_SECOND = "AMAZON_CHIME_SDK_MESSAGING_LISTING_CHANNEL_MEMBERSHIPS_API_REQUESTS_PER_SECOND"
    AMAZON_CHIME_SDK_MEDIA_PIPELINE_LEGACY_ENDPOINT_API_RATE_IN_REQUESTS_PER_SECOND = "AMAZON_CHIME_SDK_MEDIA_PIPELINE_LEGACY_ENDPOINT_API_RATE_IN_REQUESTS_PER_SECOND"
    AMAZON_CHIME_SDK_CALL_ANALYTICS_VOICE_PROFILE_DOMAIN_API_RATE = "AMAZON_CHIME_SDK_CALL_ANALYTICS_VOICE_PROFILE_DOMAIN_API_RATE"
    AMAZON_CHIME_SDK_IDENTITY_APP_INSTANCE_API_REQUESTS_PER_SECOND = "AMAZON_CHIME_SDK_IDENTITY_APP_INSTANCE_API_REQUESTS_PER_SECOND"
    AMAZON_CHIME_SDK_MESSAGING_WEBSOCKET_CONNECT_API_REQUESTS_PER_SECOND = "AMAZON_CHIME_SDK_MESSAGING_WEBSOCKET_CONNECT_API_REQUESTS_PER_SECOND"
    AMAZON_CHIME_SDK_MESSAGING_REQUESTS_PER_SECOND_OF_CREATE_OR_DELETE_CHANNEL_MEMBERSHIPS_BANS_AND_MODERATORS_FOR_A_SPECIFIC_CHANNEL = "AMAZON_CHIME_SDK_MESSAGING_REQUESTS_PER_SECOND_OF_CREATE_OR_DELETE_CHANNEL_MEMBERSHIPS_BANS_AND_MODERATORS_FOR_A_SPECIFIC_CHANNEL"
    AMAZON_CHIME_SDK_IDENTITY_DESCRIBE_APP_INSTANCE_API_REQUESTS_PER_SECOND = "AMAZON_CHIME_SDK_IDENTITY_DESCRIBE_APP_INSTANCE_API_REQUESTS_PER_SECOND"
    AMAZON_CHIME_SDK_MESSAGING_MAXIMUM_ELASTIC_CHANNELS_PER_APP_INSTANCE = "AMAZON_CHIME_SDK_MESSAGING_MAXIMUM_ELASTIC_CHANNELS_PER_APP_INSTANCE"
    AMAZON_CHIME_SDK_SIP_TRUNKING_AND_VOICE_VOICE_CONNECTORS = "AMAZON_CHIME_SDK_SIP_TRUNKING_AND_VOICE_VOICE_CONNECTORS"
    AMAZON_CHIME_SDK_MESSAGING_MAXIMUM_CHANNEL_MEMBERSHIPS_PER_SUB_CHANNEL = "AMAZON_CHIME_SDK_MESSAGING_MAXIMUM_CHANNEL_MEMBERSHIPS_PER_SUB_CHANNEL"
    AMAZON_CHIME_SDK_IDENTITY_MAXIMUM_APP_INSTANCES_PER_AWS_ACCOUNT = "AMAZON_CHIME_SDK_IDENTITY_MAXIMUM_APP_INSTANCES_PER_AWS_ACCOUNT"
    AMAZON_CHIME_SDK_SIP_TRUNKING_AND_VOICE_UPDATE_SIP_MEDIA_APPLICATION_CALL_API_RATE_LIMIT = "AMAZON_CHIME_SDK_SIP_TRUNKING_AND_VOICE_UPDATE_SIP_MEDIA_APPLICATION_CALL_API_RATE_LIMIT"
    AMAZON_CHIME_SDK_IDENTITY_DESCRIBE_APP_INSTANCE_USER_API_REQUESTS_PER_SECOND = "AMAZON_CHIME_SDK_IDENTITY_DESCRIBE_APP_INSTANCE_USER_API_REQUESTS_PER_SECOND"
    AMAZON_CHIME_SDK_IDENTITY_MAXIMUM_APP_INSTANCE_USERS_PER_APP_INSTANCE = "AMAZON_CHIME_SDK_IDENTITY_MAXIMUM_APP_INSTANCE_USERS_PER_APP_INSTANCE"
    AMAZON_CHIME_SDK_SIP_TRUNKING_AND_VOICE_CALLS_PER_SECOND_CPS = "AMAZON_CHIME_SDK_SIP_TRUNKING_AND_VOICE_CALLS_PER_SECOND_CPS"
    AMAZON_CHIME_SDK_MESSAGING_MAXIMUM_CHANNEL_MODERATORS_PER_CHANNEL = "AMAZON_CHIME_SDK_MESSAGING_MAXIMUM_CHANNEL_MODERATORS_PER_CHANNEL"
    AMAZON_CHIME_SDK_MESSAGING_APP_INSTANCE_USER_API_REQUESTS_PER_SECOND = "AMAZON_CHIME_SDK_MESSAGING_APP_INSTANCE_USER_API_REQUESTS_PER_SECOND"
    AMAZON_CHIME_SDK_IDENTITY_LIST_APP_INSTANCE_USERS_API_REQUESTS_PER_SECOND = "AMAZON_CHIME_SDK_IDENTITY_LIST_APP_INSTANCE_USERS_API_REQUESTS_PER_SECOND"
    AMAZON_CHIME_SDK_CALL_ANALYTICS_SPEAKER_SEARCH_API_RATE = "AMAZON_CHIME_SDK_CALL_ANALYTICS_SPEAKER_SEARCH_API_RATE"
    AMAZON_CHIME_SDK_MESSAGING_LIST_CHANNEL_MEMBERSHIPS_FOR_APP_INSTANCE_USER_API_REQUESTS_PER_SECOND = "AMAZON_CHIME_SDK_MESSAGING_LIST_CHANNEL_MEMBERSHIPS_FOR_APP_INSTANCE_USER_API_REQUESTS_PER_SECOND"
    AMAZON_CHIME_SDK_MESSAGING_MAXIMUM_CONCURRENT_ACTIVE_CONNECTIONS_PER_APP_INSTANCE_USER = "AMAZON_CHIME_SDK_MESSAGING_MAXIMUM_CONCURRENT_ACTIVE_CONNECTIONS_PER_APP_INSTANCE_USER"
    AMAZON_CHIME_SDK_MESSAGING_MAXIMUM_CHANNELS_PER_APP_INSTANCE = "AMAZON_CHIME_SDK_MESSAGING_MAXIMUM_CHANNELS_PER_APP_INSTANCE"
    AMAZON_CHIME_SDK_MESSAGING_MAXIMUM_CHANNEL_DETAILS_EVENTS_FOR_PREFETCH = "AMAZON_CHIME_SDK_MESSAGING_MAXIMUM_CHANNEL_DETAILS_EVENTS_FOR_PREFETCH"
    AMAZON_CHIME_SDK_MESSAGING_MAXIMUM_CHANNEL_FLOWS_PER_APP_INSTANCE = "AMAZON_CHIME_SDK_MESSAGING_MAXIMUM_CHANNEL_FLOWS_PER_APP_INSTANCE"
    AMAZON_CHIME_SDK_MEETINGS_LEGACY_ENDPOINT_CONCURRENT_VIDEO_STREAMS_PUBLISHED_PER_MEETING = "AMAZON_CHIME_SDK_MEETINGS_LEGACY_ENDPOINT_CONCURRENT_VIDEO_STREAMS_PUBLISHED_PER_MEETING"
    AMAZON_CHIME_SDK_MESSAGING_DESCRIBE_CHANNEL_API_REQUESTS_PER_SECOND = "AMAZON_CHIME_SDK_MESSAGING_DESCRIBE_CHANNEL_API_REQUESTS_PER_SECOND"
    AMAZON_CHIME_SDK_MESSAGING_MAXIMUM_SUB_CHANNELS_PER_ELASTIC_CHANNEL = "AMAZON_CHIME_SDK_MESSAGING_MAXIMUM_SUB_CHANNELS_PER_ELASTIC_CHANNEL"
    AMAZON_CHIME_SDK_SIP_TRUNKING_AND_VOICE_PROVISIONED_PHONE_NUMBERS = "AMAZON_CHIME_SDK_SIP_TRUNKING_AND_VOICE_PROVISIONED_PHONE_NUMBERS"
    AMAZON_CHIME_SDK_MEETINGS_LEGACY_ENDPOINT_CONCURRENT_VIDEO_STREAMS_SUBSCRIBED_PER_ATTENDEE = "AMAZON_CHIME_SDK_MEETINGS_LEGACY_ENDPOINT_CONCURRENT_VIDEO_STREAMS_SUBSCRIBED_PER_ATTENDEE"
    AMAZON_CHIME_SDK_SIP_TRUNKING_AND_VOICE_CREATE_SIP_MEDIA_APPLICATION_CALL_API_RATE_LIMIT = "AMAZON_CHIME_SDK_SIP_TRUNKING_AND_VOICE_CREATE_SIP_MEDIA_APPLICATION_CALL_API_RATE_LIMIT"
    AMAZON_CHIME_SDK_IDENTITY_APP_INSTANCE_USER_API_REQUESTS_PER_SECOND = "AMAZON_CHIME_SDK_IDENTITY_APP_INSTANCE_USER_API_REQUESTS_PER_SECOND"
    AMAZON_CHIME_SDK_MESSAGING_MAXIMUM_CHANNEL_MEMBERSHIPS_IN_CHANNEL_DETAILS_EVENTS_FOR_PREFETCH = "AMAZON_CHIME_SDK_MESSAGING_MAXIMUM_CHANNEL_MEMBERSHIPS_IN_CHANNEL_DETAILS_EVENTS_FOR_PREFETCH"
    AMAZON_CHIME_SDK_CALL_ANALYTICS_VOICE_TONE_ANALYSIS_API_RATE = "AMAZON_CHIME_SDK_CALL_ANALYTICS_VOICE_TONE_ANALYSIS_API_RATE"
    AMAZON_CHIME_SDK_CALL_ANALYTICS_VOICE_PROFILE_API_RATE = "AMAZON_CHIME_SDK_CALL_ANALYTICS_VOICE_PROFILE_API_RATE"
    AMAZON_CHIME_SDK_MEDIA_PIPELINE_LEGACY_ENDPOINT_MAXIMUM_MEDIA_PIPELINES = "AMAZON_CHIME_SDK_MEDIA_PIPELINE_LEGACY_ENDPOINT_MAXIMUM_MEDIA_PIPELINES"
    AMAZON_CHIME_SDK_MESSAGING_LIST_CHANNEL_MESSAGES_API_REQUESTS_PER_SECOND = "AMAZON_CHIME_SDK_MESSAGING_LIST_CHANNEL_MESSAGES_API_REQUESTS_PER_SECOND"
    AMAZON_CHIME_SDK_SIP_TRUNKING_AND_VOICE_SIP_MEDIA_APPLICATIONS_PER_SIP_RULE = "AMAZON_CHIME_SDK_SIP_TRUNKING_AND_VOICE_SIP_MEDIA_APPLICATIONS_PER_SIP_RULE"
    AMAZON_CHIME_SDK_MESSAGING_MAXIMUM_CHANNEL_MESSAGES_IN_CHANNEL_DETAILS_EVENTS_FOR_PREFETCH = "AMAZON_CHIME_SDK_MESSAGING_MAXIMUM_CHANNEL_MESSAGES_IN_CHANNEL_DETAILS_EVENTS_FOR_PREFETCH"
    AMAZON_CHIME_SDK_SIP_TRUNKING_AND_VOICE_VOICE_CONNECTORS_PER_VOICE_CONNECTOR_GROUP = "AMAZON_CHIME_SDK_SIP_TRUNKING_AND_VOICE_VOICE_CONNECTORS_PER_VOICE_CONNECTOR_GROUP"
    AMAZON_CHIME_SDK_SIP_TRUNKING_AND_VOICE_VOICE_CONNECTOR_GROUPS = "AMAZON_CHIME_SDK_SIP_TRUNKING_AND_VOICE_VOICE_CONNECTOR_GROUPS"
    AMAZON_CHIME_SDK_CALL_ANALYTICS_MAXIMUM_VOICE_ANALYTICS_TASKS = "AMAZON_CHIME_SDK_CALL_ANALYTICS_MAXIMUM_VOICE_ANALYTICS_TASKS"
    AMAZON_CHIME_SDK_MESSAGING_LIST_SUB_CHANNELS_API_REQUESTS_PER_SECOND = "AMAZON_CHIME_SDK_MESSAGING_LIST_SUB_CHANNELS_API_REQUESTS_PER_SECOND"
    AMAZON_CHIME_SDK_IDENTITY_LIST_APP_INSTANCES_API_REQUESTS_PER_SECOND = "AMAZON_CHIME_SDK_IDENTITY_LIST_APP_INSTANCES_API_REQUESTS_PER_SECOND"
    AMAZON_CHIME_SDK_MESSAGING_BATCH_CREATE_CHANNEL_MEMBERSHIP_API_REQUESTS_PER_SECOND = "AMAZON_CHIME_SDK_MESSAGING_BATCH_CREATE_CHANNEL_MEMBERSHIP_API_REQUESTS_PER_SECOND"
    AMAZON_CHIME_SDK_MESSAGING_MAXIMUM_CHANNEL_MEMBERSHIPS_PER_CHANNEL = "AMAZON_CHIME_SDK_MESSAGING_MAXIMUM_CHANNEL_MEMBERSHIPS_PER_CHANNEL"
    AMAZON_CHIME_SDK_IDENTITY_CHIME_SDK_IDENTITY_API_REQUESTS_PER_SECOND = "AMAZON_CHIME_SDK_IDENTITY_CHIME_SDK_IDENTITY_API_REQUESTS_PER_SECOND"
    AMAZON_CHIME_SDK_CALL_ANALYTICS_MAXIMUM_VOICE_PROFILE_DOMAINS = "AMAZON_CHIME_SDK_CALL_ANALYTICS_MAXIMUM_VOICE_PROFILE_DOMAINS"
    AMAZON_CHIME_SDK_IDENTITY_MAXIMUM_APP_INSTANCE_USER_ADMINS_PER_APP_INSTANCE = "AMAZON_CHIME_SDK_IDENTITY_MAXIMUM_APP_INSTANCE_USER_ADMINS_PER_APP_INSTANCE"
    AMAZON_CHIME_SDK_MESSAGING_CHANNEL_API_REQUESTS_PER_SECOND = "AMAZON_CHIME_SDK_MESSAGING_CHANNEL_API_REQUESTS_PER_SECOND"
    AMAZON_CHIME_SDK_MEDIA_PIPELINE_LEGACY_ENDPOINT_MEDIA_CAPTURE_API_BURST_RATE_IN_REQUESTS_PER_SECOND = "AMAZON_CHIME_SDK_MEDIA_PIPELINE_LEGACY_ENDPOINT_MEDIA_CAPTURE_API_BURST_RATE_IN_REQUESTS_PER_SECOND"
    AMAZON_CHIME_SDK_MESSAGING_CHANNEL_MESSAGE_API_REQUESTS_PER_SECOND = "AMAZON_CHIME_SDK_MESSAGING_CHANNEL_MESSAGE_API_REQUESTS_PER_SECOND"
    AMAZON_CHIME_SDK_CALL_ANALYTICS_VOICE_PROFILES_PER_VOICE_PROFILE_DOMAIN = "AMAZON_CHIME_SDK_CALL_ANALYTICS_VOICE_PROFILES_PER_VOICE_PROFILE_DOMAIN"
    AMAZON_CHIME_SDK_MESSAGING_LIST_CHANNELS_API_REQUESTS_PER_SECOND = "AMAZON_CHIME_SDK_MESSAGING_LIST_CHANNELS_API_REQUESTS_PER_SECOND"
    AMAZON_CHIME_SDK_IDENTITY_MAXIMUM_APP_INSTANCE_USER_ENDPOINTS_PER_APP_INSTANCE_USER = "AMAZON_CHIME_SDK_IDENTITY_MAXIMUM_APP_INSTANCE_USER_ENDPOINTS_PER_APP_INSTANCE_USER"
    AMAZON_CHIME_SDK_SIP_TRUNKING_AND_VOICE_SIP_MEDIA_APPLICATIONS = "AMAZON_CHIME_SDK_SIP_TRUNKING_AND_VOICE_SIP_MEDIA_APPLICATIONS"
    AMAZON_CHIME_SDK_MESSAGING_GET_CHANNEL_MESSAGE_API_REQUESTS_PER_SECOND = "AMAZON_CHIME_SDK_MESSAGING_GET_CHANNEL_MESSAGE_API_REQUESTS_PER_SECOND"
    AMAZON_CHIME_SDK_MESSAGING_MAXIMUM_CHANNEL_PROCESSORS_PER_CHANNEL_FLOW = "AMAZON_CHIME_SDK_MESSAGING_MAXIMUM_CHANNEL_PROCESSORS_PER_CHANNEL_FLOW"
    AMAZON_CHIME_SDK_MESSAGING_LIST_CHANNELS_MODERATED_BY_APP_INSTANCE_USER_API_REQUESTS_PER_SECOND = "AMAZON_CHIME_SDK_MESSAGING_LIST_CHANNELS_MODERATED_BY_APP_INSTANCE_USER_API_REQUESTS_PER_SECOND"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AmazonCloudFrontQuota")
class AmazonCloudFrontQuota(enum.Enum):
    DISTRIBUTIONS_ASSOCIATED_WITH_THE_SAME_ORIGIN_REQUEST_POLICY = "DISTRIBUTIONS_ASSOCIATED_WITH_THE_SAME_ORIGIN_REQUEST_POLICY"
    FILE_INVALIDATION_MAXIMUM_NUMBER_OF_FILES_ALLOWED_IN_ACTIVE_INVALIDATION_REQUESTS_EXCLUDING_WILDCARD_INVALIDATIONS = "FILE_INVALIDATION_MAXIMUM_NUMBER_OF_FILES_ALLOWED_IN_ACTIVE_INVALIDATION_REQUESTS_EXCLUDING_WILDCARD_INVALIDATIONS"
    HEADERS_PER_ORIGIN_REQUEST_POLICY = "HEADERS_PER_ORIGIN_REQUEST_POLICY"
    ORIGINS_PER_DISTRIBUTION = "ORIGINS_PER_DISTRIBUTION"
    MAXIMUM_LENGTH_OF_A_FIELD_TO_ENCRYPT = "MAXIMUM_LENGTH_OF_A_FIELD_TO_ENCRYPT"
    MAXIMUM_NUMBER_OF_FIELDS_IN_A_REQUEST_BODY_WHEN_FIELD_LEVEL_ENCRYPTION_IS_CONFIGURED = "MAXIMUM_NUMBER_OF_FIELDS_IN_A_REQUEST_BODY_WHEN_FIELD_LEVEL_ENCRYPTION_IS_CONFIGURED"
    PUBLIC_KEYS_IN_A_SINGLE_KEY_GROUP = "PUBLIC_KEYS_IN_A_SINGLE_KEY_GROUP"
    DISTRIBUTIONS_PER_AWS_ACCOUNT_THAT_YOU_CAN_CREATE_TRIGGERS_FOR = "DISTRIBUTIONS_PER_AWS_ACCOUNT_THAT_YOU_CAN_CREATE_TRIGGERS_FOR"
    KEY_GROUPS_PER_AWS_ACCOUNT = "KEY_GROUPS_PER_AWS_ACCOUNT"
    FUNCTION_TIMEOUT_FOR_A_VIEWER_REQUEST_AND_RESPONSE_EVENT = "FUNCTION_TIMEOUT_FOR_A_VIEWER_REQUEST_AND_RESPONSE_EVENT"
    CLOUD_FRONT_FUNCTIONS_MAXIMUM_NUMBER_OF_DISTRIBUTIONS_ASSOCIATED_WITH_A_SINGLE_FUNCTION = "CLOUD_FRONT_FUNCTIONS_MAXIMUM_NUMBER_OF_DISTRIBUTIONS_ASSOCIATED_WITH_A_SINGLE_FUNCTION"
    CONNECTION_ATTEMPTS_PER_ORIGIN = "CONNECTION_ATTEMPTS_PER_ORIGIN"
    CACHE_BEHAVIORS_PER_DISTRIBUTION = "CACHE_BEHAVIORS_PER_DISTRIBUTION"
    CACHE_POLICIES_PER_AWS_ACCOUNT = "CACHE_POLICIES_PER_AWS_ACCOUNT"
    MAXIMUM_NUMBER_OF_FIELDS_TO_ENCRYPT_THAT_CAN_BE_SPECIFIED_IN_ONE_PROFILE = "MAXIMUM_NUMBER_OF_FIELDS_TO_ENCRYPT_THAT_CAN_BE_SPECIFIED_IN_ONE_PROFILE"
    WHITELISTED_HEADERS_PER_CACHE_BEHAVIOR = "WHITELISTED_HEADERS_PER_CACHE_BEHAVIOR"
    COOKIES_PER_CACHE_POLICY = "COOKIES_PER_CACHE_POLICY"
    SSL_CERTIFICATES_PER_AWS_ACCOUNT_WHEN_SERVING_HTTPS_REQUESTS_USING_DEDICATED_IP_ADDRESSES = "SSL_CERTIFICATES_PER_AWS_ACCOUNT_WHEN_SERVING_HTTPS_REQUESTS_USING_DEDICATED_IP_ADDRESSES"
    CUSTOM_HEADERS_MAXIMUM_LENGTH_OF_ALL_HEADER_VALUES_AND_NAMES_COMBINED = "CUSTOM_HEADERS_MAXIMUM_LENGTH_OF_ALL_HEADER_VALUES_AND_NAMES_COMBINED"
    ORIGIN_REQUEST_POLICIES_PER_AWS_ACCOUNT = "ORIGIN_REQUEST_POLICIES_PER_AWS_ACCOUNT"
    CONNECTION_TIMEOUT_PER_ORIGIN = "CONNECTION_TIMEOUT_PER_ORIGIN"
    CUSTOM_HEADERS_MAXIMUM_LENGTH_OF_A_HEADER_VALUE = "CUSTOM_HEADERS_MAXIMUM_LENGTH_OF_A_HEADER_VALUE"
    MAXIMUM_NUMBER_OF_CLOUD_FRONT_DISTRIBUTIONS_THAT_CAN_BE_ASSOCIATED_WITH_A_FIELD_LEVEL_ENCRYPTION_CONFIGURATION = "MAXIMUM_NUMBER_OF_CLOUD_FRONT_DISTRIBUTIONS_THAT_CAN_BE_ASSOCIATED_WITH_A_FIELD_LEVEL_ENCRYPTION_CONFIGURATION"
    REQUEST_TIMEOUT = "REQUEST_TIMEOUT"
    ORIGIN_GROUPS_PER_DISTRIBUTION = "ORIGIN_GROUPS_PER_DISTRIBUTION"
    WHITELISTED_QUERY_STRINGS_PER_CACHE_BEHAVIOR = "WHITELISTED_QUERY_STRINGS_PER_CACHE_BEHAVIOR"
    WHITELISTED_COOKIES_PER_CACHE_BEHAVIOR = "WHITELISTED_COOKIES_PER_CACHE_BEHAVIOR"
    MAXIMUM_LENGTH_OF_A_URL = "MAXIMUM_LENGTH_OF_A_URL"
    SIZE_OF_A_RESPONSE_THAT_IS_GENERATED_BY_A_LAMBDA_FUNCTION_INCLUDING_HEADERS_AND_BODY_ORIGIN_REQUEST_AND_RESPONSE_EVENT = "SIZE_OF_A_RESPONSE_THAT_IS_GENERATED_BY_A_LAMBDA_FUNCTION_INCLUDING_HEADERS_AND_BODY_ORIGIN_REQUEST_AND_RESPONSE_EVENT"
    CUSTOM_HEADERS_MAXIMUM_NUMBER_OF_CUSTOM_HEADERS_THAT_YOU_CAN_CONFIGURE_CLOUD_FRONT_TO_ADD_TO_ORIGIN_REQUESTS = "CUSTOM_HEADERS_MAXIMUM_NUMBER_OF_CUSTOM_HEADERS_THAT_YOU_CAN_CONFIGURE_CLOUD_FRONT_TO_ADD_TO_ORIGIN_REQUESTS"
    COOKIES_PER_ORIGIN_REQUEST_POLICY = "COOKIES_PER_ORIGIN_REQUEST_POLICY"
    MAXIMUM_NUMBER_OF_CHARACTERS_TOTAL_FOR_ALL_WHITELISTED_QUERY_STRINGS_IN_THE_SAME_PARAMETER = "MAXIMUM_NUMBER_OF_CHARACTERS_TOTAL_FOR_ALL_WHITELISTED_QUERY_STRINGS_IN_THE_SAME_PARAMETER"
    RANGE_OF_FILE_SIZES_THAT_CLOUD_FRONT_COMPRESSES = "RANGE_OF_FILE_SIZES_THAT_CLOUD_FRONT_COMPRESSES"
    REQUEST_BODY_SIZE_FOR_VIEWER_REQUESTS_WHEN_RETURNING_FROM_A_LAMBDA_FUNCTION_TEXT_ENCODING = "REQUEST_BODY_SIZE_FOR_VIEWER_REQUESTS_WHEN_RETURNING_FROM_A_LAMBDA_FUNCTION_TEXT_ENCODING"
    REQUESTS_PER_SECOND = "REQUESTS_PER_SECOND"
    TRIGGERS_PER_DISTRIBUTION = "TRIGGERS_PER_DISTRIBUTION"
    REQUEST_BODY_SIZE_FOR_ORIGIN_REQUESTS_EXPOSED_TO_A_LAMBDA_EDGE_FUNCTION = "REQUEST_BODY_SIZE_FOR_ORIGIN_REQUESTS_EXPOSED_TO_A_LAMBDA_EDGE_FUNCTION"
    CUSTOM_HEADERS_MAXIMUM_LENGTH_OF_A_HEADER_NAME = "CUSTOM_HEADERS_MAXIMUM_LENGTH_OF_A_HEADER_NAME"
    WEB_DISTRIBUTIONS_PER_AWS_ACCOUNT = "WEB_DISTRIBUTIONS_PER_AWS_ACCOUNT"
    REQUEST_BODY_SIZE_FOR_VIEWER_REQUESTS_EXPOSED_TO_A_LAMBDA_EDGE_FUNCTION = "REQUEST_BODY_SIZE_FOR_VIEWER_REQUESTS_EXPOSED_TO_A_LAMBDA_EDGE_FUNCTION"
    MAXIMUM_NUMBER_OF_PUBLIC_KEYS_THAT_CAN_BE_ADDED_TO_ONE_AWS_ACCOUNT = "MAXIMUM_NUMBER_OF_PUBLIC_KEYS_THAT_CAN_BE_ADDED_TO_ONE_AWS_ACCOUNT"
    SIZE_OF_A_RESPONSE_THAT_IS_GENERATED_BY_A_LAMBDA_FUNCTION_INCLUDING_HEADERS_AND_BODY_VIEWER_REQUEST_AND_RESPONSE_EVENT = "SIZE_OF_A_RESPONSE_THAT_IS_GENERATED_BY_A_LAMBDA_FUNCTION_INCLUDING_HEADERS_AND_BODY_VIEWER_REQUEST_AND_RESPONSE_EVENT"
    QUERY_STRINGS_PER_CACHE_POLICY = "QUERY_STRINGS_PER_CACHE_POLICY"
    MAXIMUM_NUMBER_OF_QUERY_ARGUMENT_PROFILE_MAPPINGS_THAT_CAN_BE_INCLUDED_IN_A_FIELD_LEVEL_ENCRYPTION_CONFIGURATION = "MAXIMUM_NUMBER_OF_QUERY_ARGUMENT_PROFILE_MAPPINGS_THAT_CAN_BE_INCLUDED_IN_A_FIELD_LEVEL_ENCRYPTION_CONFIGURATION"
    REQUEST_BODY_SIZE_FOR_ORIGIN_REQUESTS_WHEN_RETURNING_FROM_A_LAMBDA_FUNCTION_BASE64_ENCODING = "REQUEST_BODY_SIZE_FOR_ORIGIN_REQUESTS_WHEN_RETURNING_FROM_A_LAMBDA_FUNCTION_BASE64_ENCODING"
    MAXIMUM_LENGTH_OF_A_REQUEST_INCLUDING_HEADERS_AND_QUERY_STRINGS_BUT_NOT_INCLUDING_THE_BODY_CONTENT = "MAXIMUM_LENGTH_OF_A_REQUEST_INCLUDING_HEADERS_AND_QUERY_STRINGS_BUT_NOT_INCLUDING_THE_BODY_CONTENT"
    ALTERNATE_DOMAIN_NAMES_CNAM_ES_PER_DISTRIBUTION = "ALTERNATE_DOMAIN_NAMES_CNAM_ES_PER_DISTRIBUTION"
    RESPONSE_TIMEOUT_PER_ORIGIN = "RESPONSE_TIMEOUT_PER_ORIGIN"
    REQUESTS_PER_SECOND_PER_DISTRIBUTION = "REQUESTS_PER_SECOND_PER_DISTRIBUTION"
    ORIGIN_ACCESS_IDENTITIES_PER_ACCOUNT = "ORIGIN_ACCESS_IDENTITIES_PER_ACCOUNT"
    TOTAL_LENGTH_OF_THE_URI_INCLUDING_QUERY_STRING_IN_A_LAMBDA_EDGE_FUNCTION = "TOTAL_LENGTH_OF_THE_URI_INCLUDING_QUERY_STRING_IN_A_LAMBDA_EDGE_FUNCTION"
    DATA_TRANSFER_RATE_PER_DISTRIBUTION = "DATA_TRANSFER_RATE_PER_DISTRIBUTION"
    KEY_GROUPS_ASSOCIATED_WITH_A_SINGLE_DISTRIBUTION = "KEY_GROUPS_ASSOCIATED_WITH_A_SINGLE_DISTRIBUTION"
    CONCURRENT_EXECUTIONS = "CONCURRENT_EXECUTIONS"
    ORIGIN_RESPONSE_TIMEOUT_IDLE_TIMEOUT = "ORIGIN_RESPONSE_TIMEOUT_IDLE_TIMEOUT"
    MAXIMUM_COMPRESSED_SIZE_OF_A_LAMBDA_FUNCTION_AND_ANY_INCLUDED_LIBRARIES_VIEWER_REQUEST_AND_RESPONSE_EVENT = "MAXIMUM_COMPRESSED_SIZE_OF_A_LAMBDA_FUNCTION_AND_ANY_INCLUDED_LIBRARIES_VIEWER_REQUEST_AND_RESPONSE_EVENT"
    DISTRIBUTIONS_ASSOCIATED_WITH_THE_SAME_CACHE_POLICY = "DISTRIBUTIONS_ASSOCIATED_WITH_THE_SAME_CACHE_POLICY"
    MAXIMUM_FILE_SIZE_FOR_HTTP_GET_POST_AND_PUT_REQUESTS = "MAXIMUM_FILE_SIZE_FOR_HTTP_GET_POST_AND_PUT_REQUESTS"
    FILE_INVALIDATION_MAXIMUM_NUMBER_OF_ACTIVE_WILDCARD_INVALIDATIONS_ALLOWED = "FILE_INVALIDATION_MAXIMUM_NUMBER_OF_ACTIVE_WILDCARD_INVALIDATIONS_ALLOWED"
    DISTRIBUTIONS_ASSOCIATED_WITH_A_SINGLE_KEY_GROUP = "DISTRIBUTIONS_ASSOCIATED_WITH_A_SINGLE_KEY_GROUP"
    MAXIMUM_COMPRESSED_SIZE_OF_A_LAMBDA_FUNCTION_AND_ANY_INCLUDED_LIBRARIES_ORIGIN_REQUEST_AND_RESPONSE_EVENT = "MAXIMUM_COMPRESSED_SIZE_OF_A_LAMBDA_FUNCTION_AND_ANY_INCLUDED_LIBRARIES_ORIGIN_REQUEST_AND_RESPONSE_EVENT"
    TOTAL_NUMBER_OF_BYTES_IN_WHITELISTED_COOKIE_NAMES_DOESN_T_APPLY_IF_YOU_CONFIGURE_CLOUD_FRONT_TO_FORWARD_ALL_COOKIES_TO_THE_ORIGIN = "TOTAL_NUMBER_OF_BYTES_IN_WHITELISTED_COOKIE_NAMES_DOESN_T_APPLY_IF_YOU_CONFIGURE_CLOUD_FRONT_TO_FORWARD_ALL_COOKIES_TO_THE_ORIGIN"
    MAXIMUM_NUMBER_OF_CHARACTERS_IN_A_WHITELISTED_QUERY_STRING = "MAXIMUM_NUMBER_OF_CHARACTERS_IN_A_WHITELISTED_QUERY_STRING"
    QUERY_STRINGS_PER_ORIGIN_REQUEST_POLICY = "QUERY_STRINGS_PER_ORIGIN_REQUEST_POLICY"
    TAGS_THAT_CAN_BE_ADDED_TO_A_DISTRIBUTION = "TAGS_THAT_CAN_BE_ADDED_TO_A_DISTRIBUTION"
    FUNCTION_TIMEOUT_ORIGIN_REQUEST_AND_RESPONSE_EVENT = "FUNCTION_TIMEOUT_ORIGIN_REQUEST_AND_RESPONSE_EVENT"
    MAXIMUM_LENGTH_OF_A_REQUEST_BODY_WHEN_FIELD_LEVEL_ENCRYPTION_IS_CONFIGURED = "MAXIMUM_LENGTH_OF_A_REQUEST_BODY_WHEN_FIELD_LEVEL_ENCRYPTION_IS_CONFIGURED"
    MAXIMUM_NUMBER_OF_FIELD_LEVEL_ENCRYPTION_PROFILES_THAT_CAN_BE_ASSOCIATED_WITH_ONE_AWS_ACCOUNT = "MAXIMUM_NUMBER_OF_FIELD_LEVEL_ENCRYPTION_PROFILES_THAT_CAN_BE_ASSOCIATED_WITH_ONE_AWS_ACCOUNT"
    SSL_CERTIFICATES_THAT_CAN_BE_ASSOCIATED_WITH_A_CLOUD_FRONT_WEB_DISTRIBUTION = "SSL_CERTIFICATES_THAT_CAN_BE_ASSOCIATED_WITH_A_CLOUD_FRONT_WEB_DISTRIBUTION"
    REQUEST_BODY_SIZE_FOR_ORIGIN_REQUESTS_WHEN_RETURNING_FROM_A_LAMBDA_FUNCTION_TEXT_ENCODING = "REQUEST_BODY_SIZE_FOR_ORIGIN_REQUESTS_WHEN_RETURNING_FROM_A_LAMBDA_FUNCTION_TEXT_ENCODING"
    MAXIMUM_NUMBER_OF_FIELD_LEVEL_ENCRYPTION_CONFIGURATIONS_THAT_CAN_BE_ASSOCIATED_WITH_ONE_AWS_ACCOUNT = "MAXIMUM_NUMBER_OF_FIELD_LEVEL_ENCRYPTION_CONFIGURATIONS_THAT_CAN_BE_ASSOCIATED_WITH_ONE_AWS_ACCOUNT"
    FUNCTION_MEMORY_SIZE_VIEWER_REQUEST_AND_RESPONSE_EVENT = "FUNCTION_MEMORY_SIZE_VIEWER_REQUEST_AND_RESPONSE_EVENT"
    RTMP_DISTRIBUTIONS_PER_AWS_ACCOUNT = "RTMP_DISTRIBUTIONS_PER_AWS_ACCOUNT"
    HEADERS_PER_CACHE_POLICY = "HEADERS_PER_CACHE_POLICY"
    REQUEST_BODY_SIZE_FOR_VIEWER_REQUESTS_WHEN_RETURNING_FROM_A_LAMBDA_FUNCTION_BASE64_ENCODING = "REQUEST_BODY_SIZE_FOR_VIEWER_REQUESTS_WHEN_RETURNING_FROM_A_LAMBDA_FUNCTION_BASE64_ENCODING"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AmazonCloudWatchEvidentlyQuota")
class AmazonCloudWatchEvidentlyQuota(enum.Enum):
    RUNNING_EXPERIMENTS_PER_PROJECT = "RUNNING_EXPERIMENTS_PER_PROJECT"
    RATE_OF_POST_PROJECT_EVENTS_REQUESTS = "RATE_OF_POST_PROJECT_EVENTS_REQUESTS"
    RATE_OF_BATCH_EVALUATE_FEATURE_REQUESTS = "RATE_OF_BATCH_EVALUATE_FEATURE_REQUESTS"
    PROJECTS_PER_AWS_ACCOUNT = "PROJECTS_PER_AWS_ACCOUNT"
    RUNNING_LAUNCHES_PER_PROJECT = "RUNNING_LAUNCHES_PER_PROJECT"
    RATE_OF_EVALUATE_FEATURE_REQUESTS = "RATE_OF_EVALUATE_FEATURE_REQUESTS"
    TOTAL_EXPERIMENTS_PER_PROJECT = "TOTAL_EXPERIMENTS_PER_PROJECT"
    TOTAL_LAUNCHES_PER_PROJECT = "TOTAL_LAUNCHES_PER_PROJECT"
    FEATURES_PER_PROJECT = "FEATURES_PER_PROJECT"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AmazonCloudWatchLogsQuota")
class AmazonCloudWatchLogsQuota(enum.Enum):
    DESCRIBE_LOG_STREAMS_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "DESCRIBE_LOG_STREAMS_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    BATCH_SIZE = "BATCH_SIZE"
    PUT_RETENTION_POLICY_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "PUT_RETENTION_POLICY_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    PUT_METRIC_FILTER_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "PUT_METRIC_FILTER_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    GET_QUERY_RESULTS_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "GET_QUERY_RESULTS_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    LOG_GROUPS = "LOG_GROUPS"
    DELETE_RETENTION_POLICY_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "DELETE_RETENTION_POLICY_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    EVENT_SIZE = "EVENT_SIZE"
    LIST_TAGS_LOG_GROUP_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "LIST_TAGS_LOG_GROUP_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    PUT_LOG_EVENTS_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "PUT_LOG_EVENTS_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    ACTIVE_EXPORT_TASK = "ACTIVE_EXPORT_TASK"
    DESCRIBE_METRIC_FILTERS_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "DESCRIBE_METRIC_FILTERS_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    LIST_TAGS_FOR_RESOURCE_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "LIST_TAGS_FOR_RESOURCE_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    DESCRIBE_LOG_GROUPS_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "DESCRIBE_LOG_GROUPS_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    TEST_METRIC_FILTER_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "TEST_METRIC_FILTER_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    START_LIVE_TAIL_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "START_LIVE_TAIL_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    START_QUERY_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "START_QUERY_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    CANCEL_EXPORT_TASK_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "CANCEL_EXPORT_TASK_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    DELETE_LOG_GROUP_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "DELETE_LOG_GROUP_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    PUT_SUBSCRIPTION_FILTER_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "PUT_SUBSCRIPTION_FILTER_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    GET_LOG_EVENTS_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "GET_LOG_EVENTS_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    DELETE_LOG_STREAM_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "DELETE_LOG_STREAM_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    METRICS_FILTERS_PER_LOG_GROUP = "METRICS_FILTERS_PER_LOG_GROUP"
    CREATE_LOG_GROUP_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "CREATE_LOG_GROUP_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    DESCRIBE_EXPORT_TASKS_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "DESCRIBE_EXPORT_TASKS_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    FILTER_LOG_EVENTS_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "FILTER_LOG_EVENTS_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    UNTAG_RESOURCE_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "UNTAG_RESOURCE_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    UNTAG_LOG_GROUP_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "UNTAG_LOG_GROUP_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    SUBSCRIPTION_FILTERS_PER_LOG_GROUP = "SUBSCRIPTION_FILTERS_PER_LOG_GROUP"
    PUT_DESTINATION_POLICY_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "PUT_DESTINATION_POLICY_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    DELETE_METRIC_FILTER_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "DELETE_METRIC_FILTER_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    CREATE_EXPORT_TASK_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "CREATE_EXPORT_TASK_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    DATA_ARCHIVING = "DATA_ARCHIVING"
    CREATE_LOG_STREAM_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "CREATE_LOG_STREAM_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    PUT_DESTINATION_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "PUT_DESTINATION_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    ASSOCIATE_KMS_KEY_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "ASSOCIATE_KMS_KEY_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    DELETE_SUBSCRIPTION_FILTER_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "DELETE_SUBSCRIPTION_FILTER_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    DELETE_DESTINATION_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "DELETE_DESTINATION_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    TAG_LOG_GROUP_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "TAG_LOG_GROUP_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    TAG_RESOURCE_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "TAG_RESOURCE_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    DESCRIBE_DESTINATIONS_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "DESCRIBE_DESTINATIONS_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    DESCRIBE_SUBSCRIPTION_FILTERS_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "DESCRIBE_SUBSCRIPTION_FILTERS_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AmazonCloudWatchNetworkMonitorQuota")
class AmazonCloudWatchNetworkMonitorQuota(enum.Enum):
    NUMBER_OF_PROBES_PER_SUBNET_FOR_EACH_MONITOR = "NUMBER_OF_PROBES_PER_SUBNET_FOR_EACH_MONITOR"
    NUMBER_OF_PROBES_PER_MONITOR = "NUMBER_OF_PROBES_PER_MONITOR"
    NUMBER_OF_MONITORS_PER_ACCOUNT_PER_AWS_REGION = "NUMBER_OF_MONITORS_PER_ACCOUNT_PER_AWS_REGION"


@jsii.enum(
    jsii_type="@reapit-cdk/service-quotas.AmazonCloudWatchObservabilityAccessManagerQuota"
)
class AmazonCloudWatchObservabilityAccessManagerQuota(enum.Enum):
    RATE_OF_DELETE_LINK_REQUESTS = "RATE_OF_DELETE_LINK_REQUESTS"
    RATE_OF_LIST_SINKS_REQUESTS = "RATE_OF_LIST_SINKS_REQUESTS"
    RATE_OF_DELETE_SINK_REQUESTS = "RATE_OF_DELETE_SINK_REQUESTS"
    RATE_OF_GET_LINK_REQUESTS = "RATE_OF_GET_LINK_REQUESTS"
    RATE_OF_UNTAG_RESOURCE_REQUESTS = "RATE_OF_UNTAG_RESOURCE_REQUESTS"
    RATE_OF_LIST_ATTACHED_LINKS_REQUESTS = "RATE_OF_LIST_ATTACHED_LINKS_REQUESTS"
    RATE_OF_UPDATE_LINK_REQUESTS = "RATE_OF_UPDATE_LINK_REQUESTS"
    NUMBER_OF_LINKS = "NUMBER_OF_LINKS"
    RATE_OF_GET_SINK_REQUESTS = "RATE_OF_GET_SINK_REQUESTS"
    RATE_OF_TAG_RESOURCE_REQUESTS = "RATE_OF_TAG_RESOURCE_REQUESTS"
    RATE_OF_CREATE_SINK_REQUESTS = "RATE_OF_CREATE_SINK_REQUESTS"
    RATE_OF_GET_SINK_POLICY_REQUESTS = "RATE_OF_GET_SINK_POLICY_REQUESTS"
    RATE_OF_LIST_LINKS_REQUESTS = "RATE_OF_LIST_LINKS_REQUESTS"
    LINKS_PER_SINK = "LINKS_PER_SINK"
    RATE_OF_LIST_TAGS_FOR_RESOURCE_REQUESTS = "RATE_OF_LIST_TAGS_FOR_RESOURCE_REQUESTS"
    NUMBER_OF_SINKS = "NUMBER_OF_SINKS"
    RATE_OF_CREATE_LINK_REQUESTS = "RATE_OF_CREATE_LINK_REQUESTS"
    RATE_OF_PUT_SINK_POLICY_REQUESTS = "RATE_OF_PUT_SINK_POLICY_REQUESTS"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AmazonCloudWatchQuota")
class AmazonCloudWatchQuota(enum.Enum):
    RATE_OF_DESCRIBE_ALARM_HISTORY_REQUESTS = "RATE_OF_DESCRIBE_ALARM_HISTORY_REQUESTS"
    NUMBER_OF_CONTRIBUTOR_INSIGHTS_RULES = "NUMBER_OF_CONTRIBUTOR_INSIGHTS_RULES"
    RATE_OF_UPDATE_SERVICE_LEVEL_OBJECTIVE_REQUESTS = "RATE_OF_UPDATE_SERVICE_LEVEL_OBJECTIVE_REQUESTS"
    RATE_OF_PUT_METRIC_DATA_REQUESTS = "RATE_OF_PUT_METRIC_DATA_REQUESTS"
    RATE_OF_LIST_SERVICE_LEVEL_OBJECTIVES_REQUESTS = "RATE_OF_LIST_SERVICE_LEVEL_OBJECTIVES_REQUESTS"
    RATE_OF_ENABLE_TOPOLOGY_DISCOVERY_REQUESTS = "RATE_OF_ENABLE_TOPOLOGY_DISCOVERY_REQUESTS"
    RATE_OF_GET_METRIC_DATA_REQUESTS = "RATE_OF_GET_METRIC_DATA_REQUESTS"
    RATE_OF_START_METRIC_STREAMS_REQUESTS = "RATE_OF_START_METRIC_STREAMS_REQUESTS"
    RATE_OF_STOP_METRIC_STREAMS_REQUESTS = "RATE_OF_STOP_METRIC_STREAMS_REQUESTS"
    RATE_OF_DISABLE_ALARM_ACTIONS_REQUESTS = "RATE_OF_DISABLE_ALARM_ACTIONS_REQUESTS"
    RATE_OF_DELETE_INSIGHT_RULES_REQUESTS = "RATE_OF_DELETE_INSIGHT_RULES_REQUESTS"
    RATE_OF_GET_SERVICE_LEVEL_OBJECTIVE_REQUESTS = "RATE_OF_GET_SERVICE_LEVEL_OBJECTIVE_REQUESTS"
    RATE_OF_ENABLE_INSIGHT_RULES_REQUESTS = "RATE_OF_ENABLE_INSIGHT_RULES_REQUESTS"
    RATE_OF_LIST_TAGS_FOR_RESOURCE_REQUESTS = "RATE_OF_LIST_TAGS_FOR_RESOURCE_REQUESTS"
    NUMBER_OF_SL_OS_PER_SERVICE = "NUMBER_OF_SL_OS_PER_SERVICE"
    RATE_OF_DISABLE_INSIGHT_RULES_REQUESTS = "RATE_OF_DISABLE_INSIGHT_RULES_REQUESTS"
    RATE_OF_TAG_RESOURCE_REQUESTS = "RATE_OF_TAG_RESOURCE_REQUESTS"
    RATE_OF_BATCH_GET_SERVICE_LEVEL_INDICATOR_REPORT_REQUESTS = "RATE_OF_BATCH_GET_SERVICE_LEVEL_INDICATOR_REPORT_REQUESTS"
    RATE_OF_PUT_METRIC_STREAM_REQUESTS = "RATE_OF_PUT_METRIC_STREAM_REQUESTS"
    RATE_OF_GET_METRIC_STATISTICS_REQUESTS = "RATE_OF_GET_METRIC_STATISTICS_REQUESTS"
    NUMBER_OF_SL_OS_PER_REGION = "NUMBER_OF_SL_OS_PER_REGION"
    DIMENSIONS_PER_METRIC = "DIMENSIONS_PER_METRIC"
    RATE_OF_PUT_INSIGHT_RULE_REQUESTS = "RATE_OF_PUT_INSIGHT_RULE_REQUESTS"
    RATE_OF_GET_TOPOLOGY_MAP_REQUESTS = "RATE_OF_GET_TOPOLOGY_MAP_REQUESTS"
    RATE_OF_BATCH_GET_SERVICE_LEVEL_OBJECTIVE_BUDGET_REPORT_REQUESTS = "RATE_OF_BATCH_GET_SERVICE_LEVEL_OBJECTIVE_BUDGET_REPORT_REQUESTS"
    DATA_RETENTION = "DATA_RETENTION"
    PAYLOAD_SIZE_FOR_PUT_METRIC_DATA_REQUESTS = "PAYLOAD_SIZE_FOR_PUT_METRIC_DATA_REQUESTS"
    RATE_OF_GET_METRIC_WIDGET_IMAGE_REQUESTS = "RATE_OF_GET_METRIC_WIDGET_IMAGE_REQUESTS"
    RATE_OF_LIST_METRICS_REQUESTS = "RATE_OF_LIST_METRICS_REQUESTS"
    CANARY_LIMIT = "CANARY_LIMIT"
    METRIC_DATUM_ITEMS_PER_PUT_METRIC_DATA_REQUEST = "METRIC_DATUM_ITEMS_PER_PUT_METRIC_DATA_REQUEST"
    RATE_OF_ENABLE_ALARM_ACTIONS_REQUESTS = "RATE_OF_ENABLE_ALARM_ACTIONS_REQUESTS"
    RATE_OF_LIST_METRIC_STREAMS_REQUESTS = "RATE_OF_LIST_METRIC_STREAMS_REQUESTS"
    RATE_OF_DESCRIBE_ALARMS_FOR_METRIC_REQUESTS = "RATE_OF_DESCRIBE_ALARMS_FOR_METRIC_REQUESTS"
    RATE_OF_LIST_SERVICES_REQUESTS = "RATE_OF_LIST_SERVICES_REQUESTS"
    RATE_OF_DESCRIBE_INSIGHT_RULES_REQUESTS = "RATE_OF_DESCRIBE_INSIGHT_RULES_REQUESTS"
    RATE_OF_UNTAG_RESOURCE_REQUESTS = "RATE_OF_UNTAG_RESOURCE_REQUESTS"
    RATE_OF_DELETE_SERVICE_LEVEL_OBJECTIVE_REQUESTS = "RATE_OF_DELETE_SERVICE_LEVEL_OBJECTIVE_REQUESTS"
    RATE_OF_DELETE_METRIC_STREAM_REQUESTS = "RATE_OF_DELETE_METRIC_STREAM_REQUESTS"
    RATE_OF_SET_ALARM_STATE_REQUESTS = "RATE_OF_SET_ALARM_STATE_REQUESTS"
    RATE_OF_DELETE_ALARMS_REQUESTS = "RATE_OF_DELETE_ALARMS_REQUESTS"
    RATE_OF_GET_METRIC_STREAM_REQUESTS = "RATE_OF_GET_METRIC_STREAM_REQUESTS"
    RATE_OF_GET_SERVICE_REQUESTS = "RATE_OF_GET_SERVICE_REQUESTS"
    RATE_OF_PUT_METRIC_ALARM_REQUESTS = "RATE_OF_PUT_METRIC_ALARM_REQUESTS"
    RATE_OF_DESCRIBE_ALARMS_REQUESTS = "RATE_OF_DESCRIBE_ALARMS_REQUESTS"
    RATE_OF_PUT_DASHBOARD_REQUESTS = "RATE_OF_PUT_DASHBOARD_REQUESTS"
    RATE_OF_DELETE_DASHBOARDS_REQUESTS = "RATE_OF_DELETE_DASHBOARDS_REQUESTS"
    RATE_OF_CREATE_SERVICE_LEVEL_OBJECTIVE_REQUESTS = "RATE_OF_CREATE_SERVICE_LEVEL_OBJECTIVE_REQUESTS"
    RATE_OF_LIST_DASHBOARDS_REQUESTS = "RATE_OF_LIST_DASHBOARDS_REQUESTS"
    RATE_OF_GET_DASHBOARD_REQUESTS = "RATE_OF_GET_DASHBOARD_REQUESTS"
    RATE_OF_GET_METRIC_DATA_DATAPOINTS_FOR_THE_LAST_THREE_HOURS_OF_METRICS = "RATE_OF_GET_METRIC_DATA_DATAPOINTS_FOR_THE_LAST_THREE_HOURS_OF_METRICS"
    ACTIONS_PER_CLOUD_WATCH_ALARM_PER_STATE = "ACTIONS_PER_CLOUD_WATCH_ALARM_PER_STATE"
    METRICS_PER_DASHBOARD_WIDGET = "METRICS_PER_DASHBOARD_WIDGET"
    NUMBER_OF_METRICS_INSIGHTS_ALARMS = "NUMBER_OF_METRICS_INSIGHTS_ALARMS"
    RATE_OF_GET_INSIGHT_RULE_REPORT_REQUESTS = "RATE_OF_GET_INSIGHT_RULE_REPORT_REQUESTS"
    RATE_OF_GET_METRIC_DATA_DATAPOINTS_FOR_METRICS_OLDER_THAN_THREE_HOURS = "RATE_OF_GET_METRIC_DATA_DATAPOINTS_FOR_METRICS_OLDER_THAN_THREE_HOURS"
    MINIMUM_FREQUENCY = "MINIMUM_FREQUENCY"
    METRICS_PER_DASHBOARD = "METRICS_PER_DASHBOARD"
    METRIC_DATA_QUERIES_PER_GET_METRIC_DATA_REQUEST = "METRIC_DATA_QUERIES_PER_GET_METRIC_DATA_REQUEST"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AmazonCloudWatchRumQuota")
class AmazonCloudWatchRumQuota(enum.Enum):
    RUM_EVENTS_PER_SECOND_PER_AWS_ACCOUNT = "RUM_EVENTS_PER_SECOND_PER_AWS_ACCOUNT"
    RUM_APP_MONITORS = "RUM_APP_MONITORS"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AmazonCodeGuruProfilerQuota")
class AmazonCodeGuruProfilerQuota(enum.Enum):
    NUMBER_OF_PROFILING_GROUPS_PER_ACCOUNT_AND_REGION = "NUMBER_OF_PROFILING_GROUPS_PER_ACCOUNT_AND_REGION"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AmazonCodeGuruReviewerQuota")
class AmazonCodeGuruReviewerQuota(enum.Enum):
    ALLOWED_CODE_REVIEWS = "ALLOWED_CODE_REVIEWS"


@jsii.enum(
    jsii_type="@reapit-cdk/service-quotas.AmazonCognitoFederatedIdentitiesQuota"
)
class AmazonCognitoFederatedIdentitiesQuota(enum.Enum):
    RATE_OF_UNTAG_RESOURCE_REQUESTS = "RATE_OF_UNTAG_RESOURCE_REQUESTS"
    RATE_OF_LIST_TAGS_FOR_RESOURCE_REQUESTS = "RATE_OF_LIST_TAGS_FOR_RESOURCE_REQUESTS"
    RATE_OF_LIST_IDENTITIES_REQUESTS = "RATE_OF_LIST_IDENTITIES_REQUESTS"
    RATE_OF_GET_OPEN_ID_TOKEN_FOR_DEVELOPER_IDENTITY_REQUESTS = "RATE_OF_GET_OPEN_ID_TOKEN_FOR_DEVELOPER_IDENTITY_REQUESTS"
    RATE_OF_GET_OPEN_ID_TOKEN_REQUESTS = "RATE_OF_GET_OPEN_ID_TOKEN_REQUESTS"
    RATE_OF_GET_ID_REQUESTS = "RATE_OF_GET_ID_REQUESTS"
    RATE_OF_GET_CREDENTIALS_FOR_IDENTITY_REQUESTS = "RATE_OF_GET_CREDENTIALS_FOR_IDENTITY_REQUESTS"
    RATE_OF_TAG_RESOURCE_REQUESTS = "RATE_OF_TAG_RESOURCE_REQUESTS"
    ROLE_BASED_ACCESS_CONTROL_RULES = "ROLE_BASED_ACCESS_CONTROL_RULES"
    IDENTITY_POOLS_PER_ACCOUNT = "IDENTITY_POOLS_PER_ACCOUNT"
    LIST_API_CALL_RESULTS = "LIST_API_CALL_RESULTS"
    LOGIN_PROVIDER_NAME_SIZE = "LOGIN_PROVIDER_NAME_SIZE"
    IDENTITY_POOL_NAME_SIZE = "IDENTITY_POOL_NAME_SIZE"
    USER_POOL_PROVIDERS_PER_IDENTITY_POOL = "USER_POOL_PROVIDERS_PER_IDENTITY_POOL"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AmazonCognitoSyncQuota")
class AmazonCognitoSyncQuota(enum.Enum):
    RECORDS_PER_DATASET = "RECORDS_PER_DATASET"
    DATASET_SIZE = "DATASET_SIZE"
    BULK_PUBLISH_WAIT_TIME = "BULK_PUBLISH_WAIT_TIME"
    DATASETS_PER_IDENTITY = "DATASETS_PER_IDENTITY"
    DATASET_NAME_SIZE = "DATASET_NAME_SIZE"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AmazonCognitoUserPoolsQuota")
class AmazonCognitoUserPoolsQuota(enum.Enum):
    RATE_OF_USER_TOKEN_REQUESTS = "RATE_OF_USER_TOKEN_REQUESTS"
    RATE_OF_USER_FEDERATION_REQUESTS = "RATE_OF_USER_FEDERATION_REQUESTS"
    USER_IMPORT_JOBS_PER_USER_POOL = "USER_IMPORT_JOBS_PER_USER_POOL"
    IDENTITY_PROVIDERS_PER_USER_POOL = "IDENTITY_PROVIDERS_PER_USER_POOL"
    RATE_OF_USER_POOL_RESOURCE_READ_REQUESTS_PER_ACCOUNT = "RATE_OF_USER_POOL_RESOURCE_READ_REQUESTS_PER_ACCOUNT"
    RATE_OF_USER_RESOURCE_UPDATE_REQUESTS = "RATE_OF_USER_RESOURCE_UPDATE_REQUESTS"
    RATE_OF_USER_LIST_REQUESTS = "RATE_OF_USER_LIST_REQUESTS"
    RATE_OF_USER_POOL_READ_REQUESTS = "RATE_OF_USER_POOL_READ_REQUESTS"
    RATE_OF_USER_RESOURCE_READ_REQUESTS = "RATE_OF_USER_RESOURCE_READ_REQUESTS"
    RATE_OF_USER_ACCOUNT_RECOVERY_REQUESTS = "RATE_OF_USER_ACCOUNT_RECOVERY_REQUESTS"
    RATE_OF_USER_AUTHENTICATION_REQUESTS = "RATE_OF_USER_AUTHENTICATION_REQUESTS"
    RATE_OF_USER_POOL_UPDATE_REQUESTS = "RATE_OF_USER_POOL_UPDATE_REQUESTS"
    USER_POOLS_PER_ACCOUNT = "USER_POOLS_PER_ACCOUNT"
    RATE_OF_USER_READ_REQUESTS = "RATE_OF_USER_READ_REQUESTS"
    RATE_OF_USER_POOL_RESOURCE_UPDATE_REQUESTS_PER_ACCOUNT = "RATE_OF_USER_POOL_RESOURCE_UPDATE_REQUESTS_PER_ACCOUNT"
    APPS_PER_USER_POOL = "APPS_PER_USER_POOL"
    RATE_OF_USER_UPDATE_REQUESTS = "RATE_OF_USER_UPDATE_REQUESTS"
    RESOURCE_SERVERS_PER_USER_POOL = "RESOURCE_SERVERS_PER_USER_POOL"
    RATE_OF_USER_CREATION_REQUESTS = "RATE_OF_USER_CREATION_REQUESTS"
    RATE_OF_USER_POOL_CLIENT_UPDATE_REQUESTS_PER_ACCOUNT = "RATE_OF_USER_POOL_CLIENT_UPDATE_REQUESTS_PER_ACCOUNT"
    RATE_OF_USER_POOL_CLIENT_READ_REQUESTS_PER_ACCOUNT = "RATE_OF_USER_POOL_CLIENT_READ_REQUESTS_PER_ACCOUNT"
    RATE_OF_USER_POOL_CLIENT_READ_REQUESTS_PER_USER_POOL = "RATE_OF_USER_POOL_CLIENT_READ_REQUESTS_PER_USER_POOL"
    SCOPES_PER_RESOURCE_SERVER = "SCOPES_PER_RESOURCE_SERVER"
    GROUPS_PER_USER = "GROUPS_PER_USER"
    CUSTOM_DOMAINS_PER_ACCOUNT = "CUSTOM_DOMAINS_PER_ACCOUNT"
    GROUPS_PER_USER_POOL = "GROUPS_PER_USER_POOL"
    RATE_OF_USER_POOL_RESOURCE_READ_REQUESTS_PER_USER_POOL = "RATE_OF_USER_POOL_RESOURCE_READ_REQUESTS_PER_USER_POOL"
    RATE_OF_CLIENT_AUTHENTICATION_REQUESTS_PER_ACCOUNT = "RATE_OF_CLIENT_AUTHENTICATION_REQUESTS_PER_ACCOUNT"
    RATE_OF_USER_POOL_CLIENT_UPDATE_REQUESTS_PER_USER_POOL = "RATE_OF_USER_POOL_CLIENT_UPDATE_REQUESTS_PER_USER_POOL"
    RATE_OF_USER_POOL_RESOURCE_UPDATE_REQUESTS_PER_USER_POOL = "RATE_OF_USER_POOL_RESOURCE_UPDATE_REQUESTS_PER_USER_POOL"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AmazonComprehendMedicalQuota")
class AmazonComprehendMedicalQuota(enum.Enum):
    TRANSACTIONS_PER_SECOND_TPS_FOR_THE_STOP_ICD10_CM_INFERENCE_JOB_OPERATION = "TRANSACTIONS_PER_SECOND_TPS_FOR_THE_STOP_ICD10_CM_INFERENCE_JOB_OPERATION"
    TRANSACTIONS_PER_SECOND_TPS_FOR_THE_DETECT_PHI_OPERATION = "TRANSACTIONS_PER_SECOND_TPS_FOR_THE_DETECT_PHI_OPERATION"
    TRANSACTIONS_PER_SECOND_TPS_FOR_THE_STOP_SNOMEDCT_INFERENCE_JOB_OPERATION = "TRANSACTIONS_PER_SECOND_TPS_FOR_THE_STOP_SNOMEDCT_INFERENCE_JOB_OPERATION"
    MAXIMUM_DOCUMENT_SIZE_UTF_8_CHARACTERS_FOR_THE_DETECT_PHI_OPERATION = "MAXIMUM_DOCUMENT_SIZE_UTF_8_CHARACTERS_FOR_THE_DETECT_PHI_OPERATION"
    MAXIMUM_DOCUMENT_SIZE_UTF_8_CHARACTERS_FOR_THE_DETECT_ENTITIES_OPERATION = "MAXIMUM_DOCUMENT_SIZE_UTF_8_CHARACTERS_FOR_THE_DETECT_ENTITIES_OPERATION"
    TRANSACTIONS_PER_SECOND_TPS_FOR_THE_LIST_RX_NORM_INFERENCE_JOBS_OPERATION = "TRANSACTIONS_PER_SECOND_TPS_FOR_THE_LIST_RX_NORM_INFERENCE_JOBS_OPERATION"
    TRANSACTIONS_PER_SECOND_TPS_FOR_THE_START_SNOMEDCT_INFERENCE_JOB_OPERATION = "TRANSACTIONS_PER_SECOND_TPS_FOR_THE_START_SNOMEDCT_INFERENCE_JOB_OPERATION"
    TRANSACTIONS_PER_SECOND_TPS_FOR_THE_START_RX_NORM_INFERENCE_JOB_OPERATION = "TRANSACTIONS_PER_SECOND_TPS_FOR_THE_START_RX_NORM_INFERENCE_JOB_OPERATION"
    TRANSACTIONS_PER_SECOND_TPS_FOR_THE_INFER_ICD10_CM_OPERATION = "TRANSACTIONS_PER_SECOND_TPS_FOR_THE_INFER_ICD10_CM_OPERATION"
    MAXIMUM_DOCUMENT_SIZE_UTF_8_CHARACTERS_FOR_THE_INFER_RX_NORM_OPERATION = "MAXIMUM_DOCUMENT_SIZE_UTF_8_CHARACTERS_FOR_THE_INFER_RX_NORM_OPERATION"
    TRANSACTIONS_PER_SECOND_TPS_FOR_THE_INFER_RX_NORM_OPERATION = "TRANSACTIONS_PER_SECOND_TPS_FOR_THE_INFER_RX_NORM_OPERATION"
    TRANSACTIONS_PER_SECOND_TPS_FOR_THE_DETECT_ENTITIES_OPERATION = "TRANSACTIONS_PER_SECOND_TPS_FOR_THE_DETECT_ENTITIES_OPERATION"
    TRANSACTIONS_PER_SECOND_TPS_FOR_THE_DESCRIBE_ICD10_CM_INFERENCE_JOB_OPERATION = "TRANSACTIONS_PER_SECOND_TPS_FOR_THE_DESCRIBE_ICD10_CM_INFERENCE_JOB_OPERATION"
    TRANSACTIONS_PER_SECOND_TPS_FOR_THE_DESCRIBE_RX_NORM_INFERENCE_JOB_OPERATION = "TRANSACTIONS_PER_SECOND_TPS_FOR_THE_DESCRIBE_RX_NORM_INFERENCE_JOB_OPERATION"
    MAXIMUM_DOCUMENT_SIZE_UTF_8_CHARACTERS_FOR_INFER_SNOMEDCT = "MAXIMUM_DOCUMENT_SIZE_UTF_8_CHARACTERS_FOR_INFER_SNOMEDCT"
    CHARACTERS_PER_SECOND_CPS_FOR_THE_INFER_RX_NORM_OPERATION = "CHARACTERS_PER_SECOND_CPS_FOR_THE_INFER_RX_NORM_OPERATION"
    MAXIMUM_DOCUMENT_SIZE_UTF_8_CHARACTERS_FOR_THE_INFER_ICD10_CM_OPERATION = "MAXIMUM_DOCUMENT_SIZE_UTF_8_CHARACTERS_FOR_THE_INFER_ICD10_CM_OPERATION"
    MAXIMUM_INDIVIDUAL_FILE_SIZE_FOR_BATCH_JOBS = "MAXIMUM_INDIVIDUAL_FILE_SIZE_FOR_BATCH_JOBS"
    MAXIMUM_INDIVIDUAL_FILE_SIZE_FOR_INFER_SNOMEDCT_BATCH_JOBS = "MAXIMUM_INDIVIDUAL_FILE_SIZE_FOR_INFER_SNOMEDCT_BATCH_JOBS"
    TRANSACTIONS_PER_SECOND_TPS_FOR_THE_DESCRIBE_ENTITIES_DETECTION_V2_JOB_OPERATION = "TRANSACTIONS_PER_SECOND_TPS_FOR_THE_DESCRIBE_ENTITIES_DETECTION_V2_JOB_OPERATION"
    CHARACTERS_PER_SECOND_CPS_FOR_THE_DETECT_PHI_OPERATION = "CHARACTERS_PER_SECOND_CPS_FOR_THE_DETECT_PHI_OPERATION"
    TRANSACTIONS_PER_SECOND_TPS_FOR_THE_DESCRIBE_PHI_DETECTION_JOB_OPERATION = "TRANSACTIONS_PER_SECOND_TPS_FOR_THE_DESCRIBE_PHI_DETECTION_JOB_OPERATION"
    ONTOLOGY_ICD10_RX_N_NORM_SNOMEDCT_LINKING_MAXIMUM_BATCH_JOB_SIZE_SUM_TOTAL_FOR_ALL_THE_FILES_SUBMITTED_IN_A_BATCH_JOB = "ONTOLOGY_ICD10_RX_N_NORM_SNOMEDCT_LINKING_MAXIMUM_BATCH_JOB_SIZE_SUM_TOTAL_FOR_ALL_THE_FILES_SUBMITTED_IN_A_BATCH_JOB"
    TRANSACTIONS_PER_SECOND_TPS_FOR_THE_START_ENTITIES_DETECTION_V2_JOB_OPERATION = "TRANSACTIONS_PER_SECOND_TPS_FOR_THE_START_ENTITIES_DETECTION_V2_JOB_OPERATION"
    TRANSACTIONS_PER_SECOND_TPS_FOR_THE_START_ICD10_CM_INFERENCE_JOB_OPERATION = "TRANSACTIONS_PER_SECOND_TPS_FOR_THE_START_ICD10_CM_INFERENCE_JOB_OPERATION"
    TRANSACTIONS_PER_SECOND_TPS_FOR_THE_START_PHI_DETECTION_JOB_OPERATION = "TRANSACTIONS_PER_SECOND_TPS_FOR_THE_START_PHI_DETECTION_JOB_OPERATION"
    CHARACTERS_PER_SECOND_CPS_FOR_THE_DETECT_ENTITIES_OPERATION = "CHARACTERS_PER_SECOND_CPS_FOR_THE_DETECT_ENTITIES_OPERATION"
    MINIMUM_SIZE_OF_BATCH_JOBS_ALL_FILES = "MINIMUM_SIZE_OF_BATCH_JOBS_ALL_FILES"
    TRANSACTIONS_PER_SECOND_TPS_FOR_THE_STOP_RX_NORM_INFERENCE_JOB_OPERATION = "TRANSACTIONS_PER_SECOND_TPS_FOR_THE_STOP_RX_NORM_INFERENCE_JOB_OPERATION"
    MAXIMUM_DOCUMENT_SIZE_UTF_8_CHARACTERS_FOR_THE_DETECT_ENTITIES_V2_OPERATION = "MAXIMUM_DOCUMENT_SIZE_UTF_8_CHARACTERS_FOR_THE_DETECT_ENTITIES_V2_OPERATION"
    TRANSACTIONS_PER_SECOND_TPS_FOR_THE_LIST_ICD10_CM_INFERENCE_JOBS_OPERATION = "TRANSACTIONS_PER_SECOND_TPS_FOR_THE_LIST_ICD10_CM_INFERENCE_JOBS_OPERATION"
    TRANSACTIONS_PER_SECOND_TPS_FOR_THE_STOP_ENTITIES_DETECTION_V2_JOB_OPERATION = "TRANSACTIONS_PER_SECOND_TPS_FOR_THE_STOP_ENTITIES_DETECTION_V2_JOB_OPERATION"
    TRANSACTIONS_PER_SECOND_TPS_FOR_THE_STOP_PHI_DETECTION_JOB_OPERATION = "TRANSACTIONS_PER_SECOND_TPS_FOR_THE_STOP_PHI_DETECTION_JOB_OPERATION"
    TRANSACTIONS_PER_SECOND_TPS_FOR_THE_LIST_PHI_DETECTION_JOBS_OPERATION = "TRANSACTIONS_PER_SECOND_TPS_FOR_THE_LIST_PHI_DETECTION_JOBS_OPERATION"
    CHARACTERS_PER_SECOND_CPS_FOR_THE_INFER_ICD10_CM_OPERATION = "CHARACTERS_PER_SECOND_CPS_FOR_THE_INFER_ICD10_CM_OPERATION"
    MAXIMUM_BATCH_JOB_SIZE_SUM_TOTAL_FOR_ALL_THE_FILES_SUBMITTED_IN_A_BATCH_JOB = "MAXIMUM_BATCH_JOB_SIZE_SUM_TOTAL_FOR_ALL_THE_FILES_SUBMITTED_IN_A_BATCH_JOB"
    CHARACTERS_PER_SECOND_CPS_FOR_THE_INFER_SNOMEDCT_OPERATION = "CHARACTERS_PER_SECOND_CPS_FOR_THE_INFER_SNOMEDCT_OPERATION"
    TRANSACTIONS_PER_SECOND_TPS_FOR_THE_DETECT_ENTITIES_V2_OPERATION = "TRANSACTIONS_PER_SECOND_TPS_FOR_THE_DETECT_ENTITIES_V2_OPERATION"
    TRANSACTIONS_PER_SECOND_TPS_FOR_THE_LIST_ENTITIES_DETECTION_V2_JOBS_OPERATION = "TRANSACTIONS_PER_SECOND_TPS_FOR_THE_LIST_ENTITIES_DETECTION_V2_JOBS_OPERATION"
    TRANSACTIONS_PER_SECOND_TPS_FOR_THE_INFER_SNOMEDCT_OPERATION = "TRANSACTIONS_PER_SECOND_TPS_FOR_THE_INFER_SNOMEDCT_OPERATION"
    CHARACTERS_PER_SECOND_CPS_FOR_THE_DETECT_ENTITIES_V2_OPERATION = "CHARACTERS_PER_SECOND_CPS_FOR_THE_DETECT_ENTITIES_V2_OPERATION"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AmazonComprehendQuota")
class AmazonComprehendQuota(enum.Enum):
    LIST_DOCUMENT_CLASSIFICATION_JOBS_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "LIST_DOCUMENT_CLASSIFICATION_JOBS_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    LIST_ENTITIES_DETECTION_JOBS_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "LIST_ENTITIES_DETECTION_JOBS_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    STOP_SENTIMENT_DETECTION_JOB_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "STOP_SENTIMENT_DETECTION_JOB_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    DESCRIBE_ENTITY_RECOGNIZER_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "DESCRIBE_ENTITY_RECOGNIZER_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    CREATE_FLYWHEEL_MAX_ACTIVE_FLYWHEELS = "CREATE_FLYWHEEL_MAX_ACTIVE_FLYWHEELS"
    START_FLYWHEEL_ITERATION_MAX_CONCURRENT_FLYWHEEL_ITERATIONS = "START_FLYWHEEL_ITERATION_MAX_CONCURRENT_FLYWHEEL_ITERATIONS"
    DETECT_ENTITIES_MAX_ACTIVE_JOBS = "DETECT_ENTITIES_MAX_ACTIVE_JOBS"
    DETECT_PII_ENTITIES_MAX_ACTIVE_JOBS = "DETECT_PII_ENTITIES_MAX_ACTIVE_JOBS"
    ENDPOINTS_MAX_ACTIVE_ENDPOINTS = "ENDPOINTS_MAX_ACTIVE_ENDPOINTS"
    CREATE_ENTITY_RECOGNIZER_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "CREATE_ENTITY_RECOGNIZER_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    DATASETS_MAX_CONCURRENT_CREATES = "DATASETS_MAX_CONCURRENT_CREATES"
    MAX_TRAIN_DATASETS_PER_FLYWHEEL = "MAX_TRAIN_DATASETS_PER_FLYWHEEL"
    START_DOCUMENT_CLASSIFICATION_JOB_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "START_DOCUMENT_CLASSIFICATION_JOB_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    DESCRIBE_DOCUMENT_CLASSIFICATION_JOB_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "DESCRIBE_DOCUMENT_CLASSIFICATION_JOB_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    DELETE_ENTITY_RECOGNIZER_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "DELETE_ENTITY_RECOGNIZER_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    DESCRIBE_DOMINANT_LANGUAGE_DETECTION_JOB_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "DESCRIBE_DOMINANT_LANGUAGE_DETECTION_JOB_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    ENDPOINTS_MAX_INFERENCE_UNITS_PER_ENDPOINT = "ENDPOINTS_MAX_INFERENCE_UNITS_PER_ENDPOINT"
    LIST_DOMINANT_LANGUAGE_DETECTION_JOBS_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "LIST_DOMINANT_LANGUAGE_DETECTION_JOBS_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    CREATE_FLYWHEEL_MAX_CONCURRENT = "CREATE_FLYWHEEL_MAX_CONCURRENT"
    ENTITY_RECOGNIZER_MAX_ACTIVE_JOBS = "ENTITY_RECOGNIZER_MAX_ACTIVE_JOBS"
    DESCRIBE_DOCUMENT_CLASSIFIER_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "DESCRIBE_DOCUMENT_CLASSIFIER_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    DETECT_DOMINANT_LANGUAGE_MAX_ACTIVE_JOBS = "DETECT_DOMINANT_LANGUAGE_MAX_ACTIVE_JOBS"
    START_KEY_PHRASES_DETECTION_JOB_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "START_KEY_PHRASES_DETECTION_JOB_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    DOCUMENT_CLASSIFIER_MAX_ACTIVE_JOBS = "DOCUMENT_CLASSIFIER_MAX_ACTIVE_JOBS"
    LIST_DOCUMENT_CLASSIFIERS_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "LIST_DOCUMENT_CLASSIFIERS_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    START_DOMINANT_LANGUAGE_DETECTION_JOB_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "START_DOMINANT_LANGUAGE_DETECTION_JOB_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    LIST_SENTIMENT_DETECTION_JOBS_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "LIST_SENTIMENT_DETECTION_JOBS_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    LIST_TOPICS_DETECTION_JOBS_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "LIST_TOPICS_DETECTION_JOBS_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    ENDPOINTS_MAX_INFERENCE_UNITS_PER_ACCOUNT = "ENDPOINTS_MAX_INFERENCE_UNITS_PER_ACCOUNT"
    START_SENTIMENT_DETECTION_JOB_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "START_SENTIMENT_DETECTION_JOB_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    STOP_DOMINANT_LANGUAGE_DETECTION_JOB_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "STOP_DOMINANT_LANGUAGE_DETECTION_JOB_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    DESCRIBE_KEY_PHRASES_DETECTION_JOB_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "DESCRIBE_KEY_PHRASES_DETECTION_JOB_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    START_ENTITIES_DETECTION_JOB_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "START_ENTITIES_DETECTION_JOB_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    STOP_ENTITIES_DETECTION_JOB_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "STOP_ENTITIES_DETECTION_JOB_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    STOP_KEY_PHRASES_DETECTION_JOB_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "STOP_KEY_PHRASES_DETECTION_JOB_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    DETECT_KEY_PHRASES_MAX_ACTIVE_JOBS = "DETECT_KEY_PHRASES_MAX_ACTIVE_JOBS"
    STOP_TRAINING_DOCUMENT_CLASSIFIER_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "STOP_TRAINING_DOCUMENT_CLASSIFIER_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    UNTAG_RESOURCE_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "UNTAG_RESOURCE_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    LIST_TAGS_FOR_RESOURCE_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "LIST_TAGS_FOR_RESOURCE_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    START_TOPICS_DETECTION_JOB_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "START_TOPICS_DETECTION_JOB_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    DESCRIBE_ENTITIES_DETECTION_JOB_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "DESCRIBE_ENTITIES_DETECTION_JOB_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    DETECT_EVENTS_MAX_ACTIVE_JOBS = "DETECT_EVENTS_MAX_ACTIVE_JOBS"
    DELETE_DOCUMENT_CLASSIFIER_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "DELETE_DOCUMENT_CLASSIFIER_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    MAX_TEST_DATASETS_PER_FLYWHEEL = "MAX_TEST_DATASETS_PER_FLYWHEEL"
    LIST_KEY_PHRASES_DETECTION_JOBS_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "LIST_KEY_PHRASES_DETECTION_JOBS_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    STOP_TRAINING_ENTITY_RECOGNIZER_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "STOP_TRAINING_ENTITY_RECOGNIZER_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    DESCRIBE_TOPICS_DETECTION_JOB_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "DESCRIBE_TOPICS_DETECTION_JOB_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    CREATE_DOCUMENT_CLASSIFIER_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "CREATE_DOCUMENT_CLASSIFIER_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    DETECT_SENTIMENT_MAX_ACTIVE_JOBS = "DETECT_SENTIMENT_MAX_ACTIVE_JOBS"
    TOPICS_DETECTION_MAX_ACTIVE_JOBS = "TOPICS_DETECTION_MAX_ACTIVE_JOBS"
    TAG_RESOURCE_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "TAG_RESOURCE_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    DOCUMENT_CLASSIFICATION_MAX_ACTIVE_JOBS = "DOCUMENT_CLASSIFICATION_MAX_ACTIVE_JOBS"
    DETECT_TARGETED_SENTIMENT_MAX_ACTIVE_JOBS = "DETECT_TARGETED_SENTIMENT_MAX_ACTIVE_JOBS"
    LIST_ENTITY_RECOGNIZERS_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "LIST_ENTITY_RECOGNIZERS_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    DESCRIBE_SENTIMENT_DETECTION_JOB_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "DESCRIBE_SENTIMENT_DETECTION_JOB_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    LIST_TARGETED_SENTIMENT_DETECTION_JOBS_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "LIST_TARGETED_SENTIMENT_DETECTION_JOBS_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    DESCRIBE_PII_ENTITIES_DETECTION_JOB_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "DESCRIBE_PII_ENTITIES_DETECTION_JOB_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    START_TARGETED_SENTIMENT_DETECTION_JOB_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "START_TARGETED_SENTIMENT_DETECTION_JOB_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    DESCRIBE_TARGETED_SENTIMENT_DETECTION_JOB_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "DESCRIBE_TARGETED_SENTIMENT_DETECTION_JOB_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    LIST_PII_ENTITIES_DETECTION_JOBS_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "LIST_PII_ENTITIES_DETECTION_JOBS_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    STOP_TARGETED_SENTIMENT_DETECTION_JOB_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "STOP_TARGETED_SENTIMENT_DETECTION_JOB_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    START_EVENTS_DETECTION_JOB_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "START_EVENTS_DETECTION_JOB_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    DESCRIBE_EVENTS_DETECTION_JOB_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "DESCRIBE_EVENTS_DETECTION_JOB_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    STOP_PII_ENTITIES_DETECTION_JOB_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "STOP_PII_ENTITIES_DETECTION_JOB_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    LIST_EVENTS_DETECTION_JOBS_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "LIST_EVENTS_DETECTION_JOBS_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    STOP_EVENTS_DETECTION_JOB_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "STOP_EVENTS_DETECTION_JOB_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    START_PII_ENTITIES_DETECTION_JOB_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "START_PII_ENTITIES_DETECTION_JOB_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"


@jsii.enum(
    jsii_type="@reapit-cdk/service-quotas.AmazonConnectApplicationIntegrationsQuota"
)
class AmazonConnectApplicationIntegrationsQuota(enum.Enum):
    DATA_INTEGRATION_ASSOCIATIONS_PER_DATA_INTEGRATION = "DATA_INTEGRATION_ASSOCIATIONS_PER_DATA_INTEGRATION"
    EVENT_INTEGRATION_ASSOCIATIONS_PER_EVENT_INTEGRATION = "EVENT_INTEGRATION_ASSOCIATIONS_PER_EVENT_INTEGRATION"
    EVENT_INTEGRATIONS_PER_REGION = "EVENT_INTEGRATIONS_PER_REGION"
    DATA_INTEGRATIONS_PER_REGION = "DATA_INTEGRATIONS_PER_REGION"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AmazonConnectCasesQuota")
class AmazonConnectCasesQuota(enum.Enum):
    LIST_TEMPLATES_RATE_QUOTA = "LIST_TEMPLATES_RATE_QUOTA"
    GET_LAYOUT_RATE_QUOTA = "GET_LAYOUT_RATE_QUOTA"
    CREATE_DOMAIN_RATE_QUOTA = "CREATE_DOMAIN_RATE_QUOTA"
    LIST_TAGS_FOR_RESOURCE_BURST_QUOTA = "LIST_TAGS_FOR_RESOURCE_BURST_QUOTA"
    GET_CASE_RATE_QUOTA = "GET_CASE_RATE_QUOTA"
    LAYOUTS_PER_DOMAIN = "LAYOUTS_PER_DOMAIN"
    GET_TEMPLATE_RATE_QUOTA = "GET_TEMPLATE_RATE_QUOTA"
    UNTAG_RESOURCE_RATE_QUOTA = "UNTAG_RESOURCE_RATE_QUOTA"
    BATCH_PUT_FIELD_OPTIONS_BURST_QUOTA = "BATCH_PUT_FIELD_OPTIONS_BURST_QUOTA"
    CREATE_LAYOUT_RATE_QUOTA = "CREATE_LAYOUT_RATE_QUOTA"
    FIELDS_PER_DOMAIN = "FIELDS_PER_DOMAIN"
    FIELD_OPTIONS_PER_FIELD = "FIELD_OPTIONS_PER_FIELD"
    SEARCH_CASES_BURST_QUOTA = "SEARCH_CASES_BURST_QUOTA"
    LIST_CASES_FOR_CONTACT_RATE_QUOTA = "LIST_CASES_FOR_CONTACT_RATE_QUOTA"
    GET_LAYOUT_BURST_QUOTA = "GET_LAYOUT_BURST_QUOTA"
    GET_DOMAIN_RATE_QUOTA = "GET_DOMAIN_RATE_QUOTA"
    LIST_LAYOUTS_RATE_QUOTA = "LIST_LAYOUTS_RATE_QUOTA"
    GET_CASE_BURST_QUOTA = "GET_CASE_BURST_QUOTA"
    UPDATE_CASE_BURST_QUOTA = "UPDATE_CASE_BURST_QUOTA"
    CASE_FIELDS_PER_LAYOUT = "CASE_FIELDS_PER_LAYOUT"
    SEARCH_RELATED_ITEMS_BURST_QUOTA = "SEARCH_RELATED_ITEMS_BURST_QUOTA"
    CREATE_LAYOUT_BURST_QUOTA = "CREATE_LAYOUT_BURST_QUOTA"
    UPDATE_FIELD_BURST_QUOTA = "UPDATE_FIELD_BURST_QUOTA"
    PUT_CASE_EVENT_CONFIGURATION_RATE_QUOTA = "PUT_CASE_EVENT_CONFIGURATION_RATE_QUOTA"
    BATCH_GET_FIELD_BURST_QUOTA = "BATCH_GET_FIELD_BURST_QUOTA"
    CREATE_RELATED_ITEM_RATE_QUOTA = "CREATE_RELATED_ITEM_RATE_QUOTA"
    UPDATE_LAYOUT_BURST_QUOTA = "UPDATE_LAYOUT_BURST_QUOTA"
    BATCH_PUT_FIELD_OPTIONS_RATE_QUOTA = "BATCH_PUT_FIELD_OPTIONS_RATE_QUOTA"
    GET_TEMPLATE_BURST_QUOTA = "GET_TEMPLATE_BURST_QUOTA"
    GET_DOMAIN_BURST_QUOTA = "GET_DOMAIN_BURST_QUOTA"
    UPDATE_TEMPLATE_RATE_QUOTA = "UPDATE_TEMPLATE_RATE_QUOTA"
    CREATE_TEMPLATE_BURST_QUOTA = "CREATE_TEMPLATE_BURST_QUOTA"
    LIST_FIELDS_RATE_QUOTA = "LIST_FIELDS_RATE_QUOTA"
    CREATE_TEMPLATE_RATE_QUOTA = "CREATE_TEMPLATE_RATE_QUOTA"
    UPDATE_FIELD_RATE_QUOTA = "UPDATE_FIELD_RATE_QUOTA"
    LIST_FIELD_OPTIONS_RATE_QUOTA = "LIST_FIELD_OPTIONS_RATE_QUOTA"
    LIST_FIELDS_BURST_QUOTA = "LIST_FIELDS_BURST_QUOTA"
    UPDATE_TEMPLATE_BURST_QUOTA = "UPDATE_TEMPLATE_BURST_QUOTA"
    LIST_LAYOUTS_BURST_QUOTA = "LIST_LAYOUTS_BURST_QUOTA"
    TAG_RESOURCE_BURST_QUOTA = "TAG_RESOURCE_BURST_QUOTA"
    PUT_CASE_EVENT_CONFIGURATION_BURST_QUOTA = "PUT_CASE_EVENT_CONFIGURATION_BURST_QUOTA"
    LIST_TEMPLATES_BURST_QUOTA = "LIST_TEMPLATES_BURST_QUOTA"
    SEARCH_RELATED_ITEMS_RATE_QUOTA = "SEARCH_RELATED_ITEMS_RATE_QUOTA"
    CREATE_DOMAIN_BURST_QUOTA = "CREATE_DOMAIN_BURST_QUOTA"
    LIST_DOMAINS_RATE_QUOTA = "LIST_DOMAINS_RATE_QUOTA"
    DOMAINS = "DOMAINS"
    GET_CASE_EVENT_CONFIGURATION_BURST_QUOTA = "GET_CASE_EVENT_CONFIGURATION_BURST_QUOTA"
    CREATE_FIELD_RATE_QUOTA = "CREATE_FIELD_RATE_QUOTA"
    TEMPLATES_PER_DOMAIN = "TEMPLATES_PER_DOMAIN"
    SEARCH_CASES_RATE_QUOTA = "SEARCH_CASES_RATE_QUOTA"
    UPDATE_LAYOUT_RATE_QUOTA = "UPDATE_LAYOUT_RATE_QUOTA"
    CREATE_FIELD_BURST_QUOTA = "CREATE_FIELD_BURST_QUOTA"
    LIST_FIELD_OPTIONS_BURST_QUOTA = "LIST_FIELD_OPTIONS_BURST_QUOTA"
    LIST_CASES_FOR_CONTACT_BURST_QUOTA = "LIST_CASES_FOR_CONTACT_BURST_QUOTA"
    CREATE_RELATED_ITEM_BURST_QUOTA = "CREATE_RELATED_ITEM_BURST_QUOTA"
    TAG_RESOURCE_RATE_QUOTA = "TAG_RESOURCE_RATE_QUOTA"
    LIST_TAGS_FOR_RESOURCE_RATE_QUOTA = "LIST_TAGS_FOR_RESOURCE_RATE_QUOTA"
    BATCH_GET_FIELD_RATE_QUOTA = "BATCH_GET_FIELD_RATE_QUOTA"
    RELATED_ITEMS_PER_CASE = "RELATED_ITEMS_PER_CASE"
    LIST_DOMAINS_BURST_QUOTA = "LIST_DOMAINS_BURST_QUOTA"
    CREATE_CASE_RATE_QUOTA = "CREATE_CASE_RATE_QUOTA"
    GET_CASE_EVENT_CONFIGURATION_RATE_QUOTA = "GET_CASE_EVENT_CONFIGURATION_RATE_QUOTA"
    UPDATE_CASE_RATE_QUOTA = "UPDATE_CASE_RATE_QUOTA"
    UNTAG_RESOURCE_BURST_QUOTA = "UNTAG_RESOURCE_BURST_QUOTA"
    CREATE_CASE_BURST_QUOTA = "CREATE_CASE_BURST_QUOTA"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AmazonConnectCustomerProfilesQuota")
class AmazonConnectCustomerProfilesQuota(enum.Enum):
    MAXIMUM_NUMBER_OF_CALCULATED_ATTRIBUTES_PER_DOMAIN = "MAXIMUM_NUMBER_OF_CALCULATED_ATTRIBUTES_PER_DOMAIN"
    MAXIMUM_EXPIRATION_IN_DAYS = "MAXIMUM_EXPIRATION_IN_DAYS"
    MAXIMUM_SIZE_OF_ALL_OBJECTS_FOR_A_PROFILE = "MAXIMUM_SIZE_OF_ALL_OBJECTS_FOR_A_PROFILE"
    OBJECTS_PER_PROFILE = "OBJECTS_PER_PROFILE"
    OBJECT_AND_PROFILE_MAXIMUM_SIZE = "OBJECT_AND_PROFILE_MAXIMUM_SIZE"
    KEYS_PER_OBJECT_TYPE = "KEYS_PER_OBJECT_TYPE"
    OBJECT_TYPES_PER_DOMAIN = "OBJECT_TYPES_PER_DOMAIN"
    MAXIMUM_NUMBER_OF_INTEGRATIONS = "MAXIMUM_NUMBER_OF_INTEGRATIONS"
    MAXIMUM_NUMBER_OF_EVENT_STREAM_PER_DOMAIN = "MAXIMUM_NUMBER_OF_EVENT_STREAM_PER_DOMAIN"
    AMAZON_CONNECT_CUSTOMER_PROFILES_DOMAIN_COUNT = "AMAZON_CONNECT_CUSTOMER_PROFILES_DOMAIN_COUNT"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AmazonConnectOutboundCampaignsQuota")
class AmazonConnectOutboundCampaignsQuota(enum.Enum):
    CAMPAIGNS = "CAMPAIGNS"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AmazonConnectQuota")
class AmazonConnectQuota(enum.Enum):
    RATE_OF_UNTAG_CONTACT_API_REQUESTS = "RATE_OF_UNTAG_CONTACT_API_REQUESTS"
    RATE_OF_LIST_PREDEFINED_ATTRIBUTES_API_REQUESTS = "RATE_OF_LIST_PREDEFINED_ATTRIBUTES_API_REQUESTS"
    RATE_OF_CREATE_QUICK_CONNECT_API_REQUESTS = "RATE_OF_CREATE_QUICK_CONNECT_API_REQUESTS"
    RATE_OF_DELETE_RULE_API_REQUESTS = "RATE_OF_DELETE_RULE_API_REQUESTS"
    RATE_OF_LIST_ROUTING_PROFILES_API_REQUESTS = "RATE_OF_LIST_ROUTING_PROFILES_API_REQUESTS"
    RATE_OF_GET_CONTACT_ATTRIBUTES_API_REQUESTS = "RATE_OF_GET_CONTACT_ATTRIBUTES_API_REQUESTS"
    RATE_OF_LIST_TASK_TEMPLATES_API_REQUESTS = "RATE_OF_LIST_TASK_TEMPLATES_API_REQUESTS"
    RATE_OF_STOP_CONTACT_API_REQUESTS = "RATE_OF_STOP_CONTACT_API_REQUESTS"
    RATE_OF_DISASSOCIATE_ROUTING_PROFILE_QUEUES_API_REQUESTS = "RATE_OF_DISASSOCIATE_ROUTING_PROFILE_QUEUES_API_REQUESTS"
    RATE_OF_LIST_TRAFFIC_DISTRIBUTION_GROUPS_API_REQUESTS = "RATE_OF_LIST_TRAFFIC_DISTRIBUTION_GROUPS_API_REQUESTS"
    RATE_OF_UPDATE_SECURITY_PROFILE_API_REQUESTS = "RATE_OF_UPDATE_SECURITY_PROFILE_API_REQUESTS"
    RATE_OF_UPDATE_QUEUE_HOURS_OF_OPERATION_API_REQUESTS = "RATE_OF_UPDATE_QUEUE_HOURS_OF_OPERATION_API_REQUESTS"
    RATE_OF_DESCRIBE_PHONE_NUMBER_API_REQUESTS = "RATE_OF_DESCRIBE_PHONE_NUMBER_API_REQUESTS"
    RATE_OF_DISASSOCIATE_QUEUE_QUICK_CONNECTS_API_REQUESTS = "RATE_OF_DISASSOCIATE_QUEUE_QUICK_CONNECTS_API_REQUESTS"
    RATE_OF_LIST_CONTACT_FLOW_MODULES_API_REQUESTS = "RATE_OF_LIST_CONTACT_FLOW_MODULES_API_REQUESTS"
    RATE_OF_REPLICATE_INSTANCE_API_REQUESTS = "RATE_OF_REPLICATE_INSTANCE_API_REQUESTS"
    RATE_OF_CREATE_USER_HIERARCHY_GROUP_API_REQUESTS = "RATE_OF_CREATE_USER_HIERARCHY_GROUP_API_REQUESTS"
    RATE_OF_DELETE_INTEGRATION_ASSOCIATION_API_REQUESTS = "RATE_OF_DELETE_INTEGRATION_ASSOCIATION_API_REQUESTS"
    RATE_OF_LIST_USER_PROFICIENCIES_API_REQUESTS = "RATE_OF_LIST_USER_PROFICIENCIES_API_REQUESTS"
    RATE_OF_DESCRIBE_CONTACT_FLOW_MODULE_API_REQUESTS = "RATE_OF_DESCRIBE_CONTACT_FLOW_MODULE_API_REQUESTS"
    RATE_OF_LIST_CONTACT_REFERENCES_API_REQUESTS = "RATE_OF_LIST_CONTACT_REFERENCES_API_REQUESTS"
    RATE_OF_MONITOR_CONTACT_API_REQUESTS = "RATE_OF_MONITOR_CONTACT_API_REQUESTS"
    RATE_OF_UPDATE_USER_HIERARCHY_STRUCTURE_API_REQUESTS = "RATE_OF_UPDATE_USER_HIERARCHY_STRUCTURE_API_REQUESTS"
    RATE_OF_UPDATE_CONTACT_FLOW_CONTENT_API_REQUESTS = "RATE_OF_UPDATE_CONTACT_FLOW_CONTENT_API_REQUESTS"
    RATE_OF_TAG_RESOURCE_API_REQUESTS = "RATE_OF_TAG_RESOURCE_API_REQUESTS"
    RATE_OF_UPDATE_QUICK_CONNECT_NAME_API_REQUESTS = "RATE_OF_UPDATE_QUICK_CONNECT_NAME_API_REQUESTS"
    RATE_OF_START_CONTACT_STREAMING_API_REQUESTS = "RATE_OF_START_CONTACT_STREAMING_API_REQUESTS"
    RATE_OF_LIST_USER_HIERARCHY_GROUPS_API_REQUESTS = "RATE_OF_LIST_USER_HIERARCHY_GROUPS_API_REQUESTS"
    RATE_OF_SUSPEND_CONTACT_RECORDING_API_REQUESTS = "RATE_OF_SUSPEND_CONTACT_RECORDING_API_REQUESTS"
    RATE_OF_CREATE_HOURS_OF_OPERATION_API_REQUESTS = "RATE_OF_CREATE_HOURS_OF_OPERATION_API_REQUESTS"
    RATE_OF_LIST_BOTS_API_REQUESTS = "RATE_OF_LIST_BOTS_API_REQUESTS"
    AWS_LAMBDA_FUNCTIONS_PER_INSTANCE = "AWS_LAMBDA_FUNCTIONS_PER_INSTANCE"
    RATE_OF_DELETE_HOURS_OF_OPERATION_API_REQUESTS = "RATE_OF_DELETE_HOURS_OF_OPERATION_API_REQUESTS"
    RATE_OF_UNTAG_RESOURCE_API_REQUESTS = "RATE_OF_UNTAG_RESOURCE_API_REQUESTS"
    RATE_OF_DELETE_TASK_TEMPLATE_API_REQUESTS = "RATE_OF_DELETE_TASK_TEMPLATE_API_REQUESTS"
    RATE_OF_GET_FEDERATION_TOKEN_API_REQUESTS = "RATE_OF_GET_FEDERATION_TOKEN_API_REQUESTS"
    USER_HIERARCHY_GROUPS_PER_INSTANCE = "USER_HIERARCHY_GROUPS_PER_INSTANCE"
    RATE_OF_UPDATE_INSTANCE_ATTRIBUTE_API_REQUESTS = "RATE_OF_UPDATE_INSTANCE_ATTRIBUTE_API_REQUESTS"
    RATE_OF_START_WEB_RTC_CONTACT_API_REQUESTS = "RATE_OF_START_WEB_RTC_CONTACT_API_REQUESTS"
    RATE_OF_PUT_USER_STATUS_API_REQUESTS = "RATE_OF_PUT_USER_STATUS_API_REQUESTS"
    RATE_OF_ASSOCIATE_SECURITY_KEY_API_REQUESTS = "RATE_OF_ASSOCIATE_SECURITY_KEY_API_REQUESTS"
    RATE_OF_DESCRIBE_INSTANCE_ATTRIBUTE_API_REQUESTS = "RATE_OF_DESCRIBE_INSTANCE_ATTRIBUTE_API_REQUESTS"
    RATE_OF_UPDATE_USER_SECURITY_PROFILES_API_REQUESTS = "RATE_OF_UPDATE_USER_SECURITY_PROFILES_API_REQUESTS"
    HOURS_OF_OPERATION_PER_INSTANCE = "HOURS_OF_OPERATION_PER_INSTANCE"
    RATE_OF_SEARCH_VOCABULARIES_API_REQUESTS = "RATE_OF_SEARCH_VOCABULARIES_API_REQUESTS"
    RATE_OF_LIST_USE_CASES_API_REQUESTS = "RATE_OF_LIST_USE_CASES_API_REQUESTS"
    PREDEFINED_ATTRIBUTES = "PREDEFINED_ATTRIBUTES"
    RATE_OF_ASSOCIATE_LAMBDA_FUNCTION_API_REQUESTS = "RATE_OF_ASSOCIATE_LAMBDA_FUNCTION_API_REQUESTS"
    RATE_OF_CREATE_QUEUE_API_REQUESTS = "RATE_OF_CREATE_QUEUE_API_REQUESTS"
    RATE_OF_SEARCH_QUEUES_API_REQUESTS = "RATE_OF_SEARCH_QUEUES_API_REQUESTS"
    RATE_OF_UPDATE_CONTACT_ATTRIBUTES_API_REQUESTS = "RATE_OF_UPDATE_CONTACT_ATTRIBUTES_API_REQUESTS"
    RATE_OF_SEARCH_PREDEFINED_ATTRIBUTES_API_REQUESTS = "RATE_OF_SEARCH_PREDEFINED_ATTRIBUTES_API_REQUESTS"
    RATE_OF_ASSOCIATE_DEFAULT_VOCABULARY_API_REQUESTS = "RATE_OF_ASSOCIATE_DEFAULT_VOCABULARY_API_REQUESTS"
    RATE_OF_ASSOCIATE_PHONE_NUMBER_CONTACT_FLOW_API_REQUESTS = "RATE_OF_ASSOCIATE_PHONE_NUMBER_CONTACT_FLOW_API_REQUESTS"
    ROUTING_PROFILES_PER_INSTANCE = "ROUTING_PROFILES_PER_INSTANCE"
    RATE_OF_UPDATE_USER_PROFICIENCIES_API_REQUESTS = "RATE_OF_UPDATE_USER_PROFICIENCIES_API_REQUESTS"
    RATE_OF_LIST_PHONE_NUMBERS_API_REQUESTS = "RATE_OF_LIST_PHONE_NUMBERS_API_REQUESTS"
    RATE_OF_SEARCH_AVAILABLE_PHONE_NUMBERS_API_REQUESTS = "RATE_OF_SEARCH_AVAILABLE_PHONE_NUMBERS_API_REQUESTS"
    RATE_OF_SEARCH_PROMPTS_API_REQUESTS = "RATE_OF_SEARCH_PROMPTS_API_REQUESTS"
    RATE_OF_CLAIM_PHONE_NUMBER_API_REQUESTS = "RATE_OF_CLAIM_PHONE_NUMBER_API_REQUESTS"
    AMAZON_CONNECT_INSTANCE_COUNT = "AMAZON_CONNECT_INSTANCE_COUNT"
    RATE_OF_UPDATE_RULE_API_REQUESTS = "RATE_OF_UPDATE_RULE_API_REQUESTS"
    RATE_OF_LIST_ROUTING_PROFILE_QUEUES_API_REQUESTS = "RATE_OF_LIST_ROUTING_PROFILE_QUEUES_API_REQUESTS"
    RATE_OF_LIST_PHONE_NUMBERS_V2_API_REQUESTS = "RATE_OF_LIST_PHONE_NUMBERS_V2_API_REQUESTS"
    RATE_OF_UPDATE_TASK_TEMPLATE_API_REQUESTS = "RATE_OF_UPDATE_TASK_TEMPLATE_API_REQUESTS"
    RATE_OF_CREATE_ROUTING_PROFILE_API_REQUESTS = "RATE_OF_CREATE_ROUTING_PROFILE_API_REQUESTS"
    RATE_OF_DESCRIBE_ROUTING_PROFILE_API_REQUESTS = "RATE_OF_DESCRIBE_ROUTING_PROFILE_API_REQUESTS"
    RATE_OF_ASSOCIATE_LEX_BOT_API_REQUESTS = "RATE_OF_ASSOCIATE_LEX_BOT_API_REQUESTS"
    QUEUES_PER_ROUTING_PROFILE_PER_INSTANCE = "QUEUES_PER_ROUTING_PROFILE_PER_INSTANCE"
    RATE_OF_UPDATE_QUICK_CONNECT_CONFIG_API_REQUESTS = "RATE_OF_UPDATE_QUICK_CONNECT_CONFIG_API_REQUESTS"
    RATE_OF_DESCRIBE_USER_HIERARCHY_GROUP_API_REQUESTS = "RATE_OF_DESCRIBE_USER_HIERARCHY_GROUP_API_REQUESTS"
    RATE_OF_SEARCH_HOURS_OF_OPERATIONS_API_REQUESTS = "RATE_OF_SEARCH_HOURS_OF_OPERATIONS_API_REQUESTS"
    RATE_OF_TRANSFER_CONTACT_API_REQUESTS = "RATE_OF_TRANSFER_CONTACT_API_REQUESTS"
    RATE_OF_DELETE_USE_CASE_API_REQUESTS = "RATE_OF_DELETE_USE_CASE_API_REQUESTS"
    AMAZON_LEX_V2_BOT_ALIASES_PER_INSTANCE = "AMAZON_LEX_V2_BOT_ALIASES_PER_INSTANCE"
    RATE_OF_UPDATE_CONTACT_FLOW_METADATA_API_REQUESTS = "RATE_OF_UPDATE_CONTACT_FLOW_METADATA_API_REQUESTS"
    RATE_OF_CREATE_VOCABULARY_API_REQUESTS = "RATE_OF_CREATE_VOCABULARY_API_REQUESTS"
    RATE_OF_LIST_HOURS_OF_OPERATIONS_API_REQUESTS = "RATE_OF_LIST_HOURS_OF_OPERATIONS_API_REQUESTS"
    RATE_OF_UPDATE_HOURS_OF_OPERATION_API_REQUESTS = "RATE_OF_UPDATE_HOURS_OF_OPERATION_API_REQUESTS"
    RATE_OF_DISASSOCIATE_BOT_API_REQUESTS = "RATE_OF_DISASSOCIATE_BOT_API_REQUESTS"
    RATE_OF_ASSOCIATE_ROUTING_PROFILE_QUEUES_API_REQUESTS = "RATE_OF_ASSOCIATE_ROUTING_PROFILE_QUEUES_API_REQUESTS"
    RATE_OF_UPDATE_CONTACT_SCHEDULE_API_REQUESTS = "RATE_OF_UPDATE_CONTACT_SCHEDULE_API_REQUESTS"
    RATE_OF_START_CHAT_CONTACT_API_REQUESTS = "RATE_OF_START_CHAT_CONTACT_API_REQUESTS"
    RATE_OF_GET_CURRENT_USER_DATA_API_REQUESTS = "RATE_OF_GET_CURRENT_USER_DATA_API_REQUESTS"
    RATE_OF_DESCRIBE_HOURS_OF_OPERATION_API_REQUESTS = "RATE_OF_DESCRIBE_HOURS_OF_OPERATION_API_REQUESTS"
    RATE_OF_DELETE_QUICK_CONNECT_API_REQUESTS = "RATE_OF_DELETE_QUICK_CONNECT_API_REQUESTS"
    RATE_OF_SEARCH_RESOURCE_TAGS_API_REQUESTS = "RATE_OF_SEARCH_RESOURCE_TAGS_API_REQUESTS"
    RATE_OF_LIST_INSTANCE_STORAGE_CONFIGS_API_REQUESTS = "RATE_OF_LIST_INSTANCE_STORAGE_CONFIGS_API_REQUESTS"
    AMAZON_LEX_BOTS_PER_INSTANCE = "AMAZON_LEX_BOTS_PER_INSTANCE"
    RATE_OF_LIST_INSTANCES_API_REQUESTS = "RATE_OF_LIST_INSTANCES_API_REQUESTS"
    RATE_OF_UPDATE_PREDEFINED_ATTRIBUTE_API_REQUESTS = "RATE_OF_UPDATE_PREDEFINED_ATTRIBUTE_API_REQUESTS"
    SECURITY_PROFILES_PER_INSTANCE = "SECURITY_PROFILES_PER_INSTANCE"
    RATE_OF_DELETE_INSTANCE_API_REQUESTS = "RATE_OF_DELETE_INSTANCE_API_REQUESTS"
    RATE_OF_CREATE_INTEGRATION_ASSOCIATION_API_REQUESTS = "RATE_OF_CREATE_INTEGRATION_ASSOCIATION_API_REQUESTS"
    PHONE_NUMBERS_PER_INSTANCE = "PHONE_NUMBERS_PER_INSTANCE"
    CONCURRENT_ACTIVE_TASKS_PER_INSTANCE = "CONCURRENT_ACTIVE_TASKS_PER_INSTANCE"
    RATE_OF_UPDATE_INSTANCE_STORAGE_CONFIG_API_REQUESTS = "RATE_OF_UPDATE_INSTANCE_STORAGE_CONFIG_API_REQUESTS"
    RATE_OF_RELEASE_PHONE_NUMBER_API_REQUESTS = "RATE_OF_RELEASE_PHONE_NUMBER_API_REQUESTS"
    RATE_OF_UPDATE_TRAFFIC_DISTRIBUTION_API_REQUESTS = "RATE_OF_UPDATE_TRAFFIC_DISTRIBUTION_API_REQUESTS"
    RATE_OF_CREATE_PARTICIPANT_API_REQUESTS = "RATE_OF_CREATE_PARTICIPANT_API_REQUESTS"
    RATE_OF_DESCRIBE_SECURITY_PROFILE_API_REQUESTS = "RATE_OF_DESCRIBE_SECURITY_PROFILE_API_REQUESTS"
    RATE_OF_DELETE_USER_API_REQUESTS = "RATE_OF_DELETE_USER_API_REQUESTS"
    QUEUES_PER_INSTANCE = "QUEUES_PER_INSTANCE"
    RATE_OF_START_TASK_CONTACT_API_REQUESTS = "RATE_OF_START_TASK_CONTACT_API_REQUESTS"
    RATE_OF_UPDATE_ROUTING_PROFILE_CONCURRENCY_API_REQUESTS = "RATE_OF_UPDATE_ROUTING_PROFILE_CONCURRENCY_API_REQUESTS"
    RATE_OF_CREATE_AGENT_STATUS_API_REQUESTS = "RATE_OF_CREATE_AGENT_STATUS_API_REQUESTS"
    RATE_OF_DISASSOCIATE_USER_PROFICIENCIES_API_REQUESTS = "RATE_OF_DISASSOCIATE_USER_PROFICIENCIES_API_REQUESTS"
    CONTACT_FLOWS_PER_INSTANCE = "CONTACT_FLOWS_PER_INSTANCE"
    RATE_OF_UPDATE_ROUTING_PROFILE_DEFAULT_OUTBOUND_QUEUE_API_REQUESTS = "RATE_OF_UPDATE_ROUTING_PROFILE_DEFAULT_OUTBOUND_QUEUE_API_REQUESTS"
    RATE_OF_LIST_SECURITY_KEYS_API_REQUESTS = "RATE_OF_LIST_SECURITY_KEYS_API_REQUESTS"
    RATE_OF_ASSOCIATE_QUEUE_QUICK_CONNECTS_API_REQUESTS = "RATE_OF_ASSOCIATE_QUEUE_QUICK_CONNECTS_API_REQUESTS"
    RATE_OF_DELETE_USER_HIERARCHY_GROUP_API_REQUESTS = "RATE_OF_DELETE_USER_HIERARCHY_GROUP_API_REQUESTS"
    REPORTS_PER_INSTANCE = "REPORTS_PER_INSTANCE"
    RATE_OF_GET_CURRENT_METRIC_DATA_API_REQUESTS = "RATE_OF_GET_CURRENT_METRIC_DATA_API_REQUESTS"
    RATE_OF_CREATE_USE_CASE_API_REQUESTS = "RATE_OF_CREATE_USE_CASE_API_REQUESTS"
    RATE_OF_DESCRIBE_AGENT_STATUS_API_REQUESTS = "RATE_OF_DESCRIBE_AGENT_STATUS_API_REQUESTS"
    RATE_OF_UPDATE_PHONE_NUMBER_API_REQUESTS = "RATE_OF_UPDATE_PHONE_NUMBER_API_REQUESTS"
    RATE_OF_LIST_APPROVED_ORIGINS_API_REQUESTS = "RATE_OF_LIST_APPROVED_ORIGINS_API_REQUESTS"
    RATE_OF_PAUSE_CONTACT_API_REQUESTS = "RATE_OF_PAUSE_CONTACT_API_REQUESTS"
    RATE_OF_START_OUTBOUND_VOICE_CONTACT_API_REQUESTS = "RATE_OF_START_OUTBOUND_VOICE_CONTACT_API_REQUESTS"
    RATE_OF_LIST_CONTACT_FLOWS_API_REQUESTS = "RATE_OF_LIST_CONTACT_FLOWS_API_REQUESTS"
    RATE_OF_DISASSOCIATE_LAMBDA_FUNCTION_API_REQUESTS = "RATE_OF_DISASSOCIATE_LAMBDA_FUNCTION_API_REQUESTS"
    RATE_OF_DESCRIBE_TRAFFIC_DISTRIBUTION_GROUP_API_REQUESTS = "RATE_OF_DESCRIBE_TRAFFIC_DISTRIBUTION_GROUP_API_REQUESTS"
    RATE_OF_LIST_RULES_API_REQUESTS = "RATE_OF_LIST_RULES_API_REQUESTS"
    RATE_OF_LIST_SECURITY_PROFILE_PERMISSIONS_API_REQUESTS = "RATE_OF_LIST_SECURITY_PROFILE_PERMISSIONS_API_REQUESTS"
    RATE_OF_UPDATE_CONTACT_FLOW_MODULE_METADATA_API_REQUESTS = "RATE_OF_UPDATE_CONTACT_FLOW_MODULE_METADATA_API_REQUESTS"
    RATE_OF_DISASSOCIATE_PHONE_NUMBER_CONTACT_FLOW_API_REQUESTS = "RATE_OF_DISASSOCIATE_PHONE_NUMBER_CONTACT_FLOW_API_REQUESTS"
    RATE_OF_DESCRIBE_PROMPT_API_REQUESTS = "RATE_OF_DESCRIBE_PROMPT_API_REQUESTS"
    CONCURRENT_ACTIVE_CHATS_PER_INSTANCE = "CONCURRENT_ACTIVE_CHATS_PER_INSTANCE"
    RATE_OF_DISASSOCIATE_INSTANCE_STORAGE_CONFIG_API_REQUESTS = "RATE_OF_DISASSOCIATE_INSTANCE_STORAGE_CONFIG_API_REQUESTS"
    RATE_OF_LIST_LEX_BOTS_API_REQUESTS = "RATE_OF_LIST_LEX_BOTS_API_REQUESTS"
    RATE_OF_LIST_INSTANCE_ATTRIBUTES_API_REQUESTS = "RATE_OF_LIST_INSTANCE_ATTRIBUTES_API_REQUESTS"
    RATE_OF_LIST_LAMBDA_FUNCTIONS_API_REQUESTS = "RATE_OF_LIST_LAMBDA_FUNCTIONS_API_REQUESTS"
    RATE_OF_CREATE_INSTANCE_API_REQUESTS = "RATE_OF_CREATE_INSTANCE_API_REQUESTS"
    RATE_OF_UPDATE_QUEUE_NAME_API_REQUESTS = "RATE_OF_UPDATE_QUEUE_NAME_API_REQUESTS"
    RATE_OF_RESUME_CONTACT_RECORDING_API_REQUESTS = "RATE_OF_RESUME_CONTACT_RECORDING_API_REQUESTS"
    RATE_OF_TAG_CONTACT_API_REQUESTS = "RATE_OF_TAG_CONTACT_API_REQUESTS"
    RATE_OF_CREATE_TASK_TEMPLATE_API_REQUESTS = "RATE_OF_CREATE_TASK_TEMPLATE_API_REQUESTS"
    PROFICIENCIES_PER_AGENT = "PROFICIENCIES_PER_AGENT"
    RATE_OF_CREATE_CONTACT_FLOW_API_REQUESTS = "RATE_OF_CREATE_CONTACT_FLOW_API_REQUESTS"
    RATE_OF_DESCRIBE_CONTACT_FLOW_API_REQUESTS = "RATE_OF_DESCRIBE_CONTACT_FLOW_API_REQUESTS"
    RATE_OF_UPDATE_ROUTING_PROFILE_NAME_API_REQUESTS = "RATE_OF_UPDATE_ROUTING_PROFILE_NAME_API_REQUESTS"
    RATE_OF_UPDATE_USER_HIERARCHY_API_REQUESTS = "RATE_OF_UPDATE_USER_HIERARCHY_API_REQUESTS"
    RATE_OF_ASSOCIATE_BOT_API_REQUESTS = "RATE_OF_ASSOCIATE_BOT_API_REQUESTS"
    RATE_OF_UPDATE_USER_IDENTITY_INFO_API_REQUESTS = "RATE_OF_UPDATE_USER_IDENTITY_INFO_API_REQUESTS"
    RATE_OF_CREATE_PREDEFINED_ATTRIBUTE_API_REQUESTS = "RATE_OF_CREATE_PREDEFINED_ATTRIBUTE_API_REQUESTS"
    RATE_OF_DESCRIBE_PREDEFINED_ATTRIBUTE_API_REQUESTS = "RATE_OF_DESCRIBE_PREDEFINED_ATTRIBUTE_API_REQUESTS"
    RATE_OF_DISMISS_USER_CONTACT_API_REQUESTS = "RATE_OF_DISMISS_USER_CONTACT_API_REQUESTS"
    CONCURRENT_CAMPAIGN_ACTIVE_CALLS_PER_INSTANCE = "CONCURRENT_CAMPAIGN_ACTIVE_CALLS_PER_INSTANCE"
    RATE_OF_LIST_AGENT_STATUSES_API_REQUESTS = "RATE_OF_LIST_AGENT_STATUSES_API_REQUESTS"
    RATE_OF_DELETE_CONTACT_FLOW_API_REQUESTS = "RATE_OF_DELETE_CONTACT_FLOW_API_REQUESTS"
    PROMPTS_PER_INSTANCE = "PROMPTS_PER_INSTANCE"
    RATE_OF_DESCRIBE_USER_API_REQUESTS = "RATE_OF_DESCRIBE_USER_API_REQUESTS"
    RATE_OF_LIST_QUICK_CONNECTS_API_REQUESTS = "RATE_OF_LIST_QUICK_CONNECTS_API_REQUESTS"
    RATE_OF_DESCRIBE_QUICK_CONNECT_API_REQUESTS = "RATE_OF_DESCRIBE_QUICK_CONNECT_API_REQUESTS"
    RATE_OF_BATCH_PUT_CONTACT_API_REQUESTS = "RATE_OF_BATCH_PUT_CONTACT_API_REQUESTS"
    SCHEDULED_REPORTS_PER_INSTANCE = "SCHEDULED_REPORTS_PER_INSTANCE"
    RATE_OF_DISASSOCIATE_APPROVED_ORIGIN_API_REQUESTS = "RATE_OF_DISASSOCIATE_APPROVED_ORIGIN_API_REQUESTS"
    RATE_OF_STOP_CONTACT_STREAMING_API_REQUESTS = "RATE_OF_STOP_CONTACT_STREAMING_API_REQUESTS"
    RATE_OF_UPDATE_QUEUE_MAX_CONTACTS_API_REQUESTS = "RATE_OF_UPDATE_QUEUE_MAX_CONTACTS_API_REQUESTS"
    RATE_OF_SEARCH_QUICK_CONNECTS_API_REQUESTS = "RATE_OF_SEARCH_QUICK_CONNECTS_API_REQUESTS"
    RATE_OF_LIST_USERS_API_REQUESTS = "RATE_OF_LIST_USERS_API_REQUESTS"
    USERS_PER_INSTANCE = "USERS_PER_INSTANCE"
    RATE_OF_CREATE_TRAFFIC_DISTRIBUTION_GROUP_API_REQUESTS = "RATE_OF_CREATE_TRAFFIC_DISTRIBUTION_GROUP_API_REQUESTS"
    RATE_OF_DISASSOCIATE_LEX_BOT_API_REQUESTS = "RATE_OF_DISASSOCIATE_LEX_BOT_API_REQUESTS"
    RATE_OF_UPDATE_QUEUE_STATUS_API_REQUESTS = "RATE_OF_UPDATE_QUEUE_STATUS_API_REQUESTS"
    RATE_OF_UPDATE_AGENT_STATUS_API_REQUESTS = "RATE_OF_UPDATE_AGENT_STATUS_API_REQUESTS"
    RATE_OF_GET_TRAFFIC_DISTRIBUTION_API_REQUESTS = "RATE_OF_GET_TRAFFIC_DISTRIBUTION_API_REQUESTS"
    RATE_OF_START_CONTACT_RECORDING_API_REQUESTS = "RATE_OF_START_CONTACT_RECORDING_API_REQUESTS"
    QUICK_CONNECTS_PER_INSTANCE = "QUICK_CONNECTS_PER_INSTANCE"
    RATE_OF_CREATE_RULE_API_REQUESTS = "RATE_OF_CREATE_RULE_API_REQUESTS"
    RATE_OF_UPDATE_CONTACT_FLOW_NAME_API_REQUESTS = "RATE_OF_UPDATE_CONTACT_FLOW_NAME_API_REQUESTS"
    RATE_OF_GET_TASK_TEMPLATE_API_REQUESTS = "RATE_OF_GET_TASK_TEMPLATE_API_REQUESTS"
    RATE_OF_LIST_INTEGRATION_ASSOCIATIONS_API_REQUESTS = "RATE_OF_LIST_INTEGRATION_ASSOCIATIONS_API_REQUESTS"
    RATE_OF_DESCRIBE_VOCABULARY_API_REQUESTS = "RATE_OF_DESCRIBE_VOCABULARY_API_REQUESTS"
    RATE_OF_UPDATE_CONTACT_API_REQUESTS = "RATE_OF_UPDATE_CONTACT_API_REQUESTS"
    RATE_OF_LIST_QUEUES_API_REQUESTS = "RATE_OF_LIST_QUEUES_API_REQUESTS"
    RATE_OF_SEARCH_ROUTING_PROFILES_API_REQUESTS = "RATE_OF_SEARCH_ROUTING_PROFILES_API_REQUESTS"
    RATE_OF_DELETE_TRAFFIC_DISTRIBUTION_GROUP_API_REQUESTS = "RATE_OF_DELETE_TRAFFIC_DISTRIBUTION_GROUP_API_REQUESTS"
    RATE_OF_RESUME_CONTACT_API_REQUESTS = "RATE_OF_RESUME_CONTACT_API_REQUESTS"
    RATE_OF_DESCRIBE_QUEUE_API_REQUESTS = "RATE_OF_DESCRIBE_QUEUE_API_REQUESTS"
    RATE_OF_SEARCH_SECURITY_PROFILES_API_REQUESTS = "RATE_OF_SEARCH_SECURITY_PROFILES_API_REQUESTS"
    RATE_OF_CREATE_USER_API_REQUESTS = "RATE_OF_CREATE_USER_API_REQUESTS"
    RATE_OF_DESCRIBE_CONTACT_API_REQUESTS = "RATE_OF_DESCRIBE_CONTACT_API_REQUESTS"
    RATE_OF_UPDATE_ROUTING_PROFILE_QUEUES_API_REQUESTS = "RATE_OF_UPDATE_ROUTING_PROFILE_QUEUES_API_REQUESTS"
    AGENT_STATUS_PER_INSTANCE = "AGENT_STATUS_PER_INSTANCE"
    FLOW_MODULES_PER_INSTANCE = "FLOW_MODULES_PER_INSTANCE"
    RATE_OF_LIST_TAGS_FOR_RESOURCE_API_REQUESTS = "RATE_OF_LIST_TAGS_FOR_RESOURCE_API_REQUESTS"
    RATE_OF_UPDATE_USER_PHONE_CONFIG_API_REQUESTS = "RATE_OF_UPDATE_USER_PHONE_CONFIG_API_REQUESTS"
    RATE_OF_DESCRIBE_INSTANCE_STORAGE_CONFIG_API_REQUESTS = "RATE_OF_DESCRIBE_INSTANCE_STORAGE_CONFIG_API_REQUESTS"
    RATE_OF_ASSOCIATE_APPROVED_ORIGIN_API_REQUESTS = "RATE_OF_ASSOCIATE_APPROVED_ORIGIN_API_REQUESTS"
    RATE_OF_DISASSOCIATE_SECURITY_KEY_API_REQUESTS = "RATE_OF_DISASSOCIATE_SECURITY_KEY_API_REQUESTS"
    CONCURRENT_ACTIVE_CALLS_PER_INSTANCE = "CONCURRENT_ACTIVE_CALLS_PER_INSTANCE"
    RATE_OF_GET_METRIC_DATA_V2_API_REQUESTS = "RATE_OF_GET_METRIC_DATA_V2_API_REQUESTS"
    RATE_OF_LIST_DEFAULT_VOCABULARIES_API_REQUESTS = "RATE_OF_LIST_DEFAULT_VOCABULARIES_API_REQUESTS"
    RATE_OF_UPDATE_USER_ROUTING_PROFILE_API_REQUESTS = "RATE_OF_UPDATE_USER_ROUTING_PROFILE_API_REQUESTS"
    RATE_OF_UPDATE_PARTICIPANT_ROLE_CONFIG_API_REQUESTS = "RATE_OF_UPDATE_PARTICIPANT_ROLE_CONFIG_API_REQUESTS"
    RATE_OF_ASSOCIATE_INSTANCE_STORAGE_CONFIG_API_REQUESTS = "RATE_OF_ASSOCIATE_INSTANCE_STORAGE_CONFIG_API_REQUESTS"
    RATE_OF_CREATE_SECURITY_PROFILE_API_REQUESTS = "RATE_OF_CREATE_SECURITY_PROFILE_API_REQUESTS"
    RATE_OF_UPDATE_CONTACT_FLOW_MODULE_CONTENT_API_REQUESTS = "RATE_OF_UPDATE_CONTACT_FLOW_MODULE_CONTENT_API_REQUESTS"
    RATE_OF_DELETE_SECURITY_PROFILE_API_REQUESTS = "RATE_OF_DELETE_SECURITY_PROFILE_API_REQUESTS"
    RATE_OF_CREATE_CONTACT_FLOW_MODULE_API_REQUESTS = "RATE_OF_CREATE_CONTACT_FLOW_MODULE_API_REQUESTS"
    RATE_OF_DELETE_PREDEFINED_ATTRIBUTE_API_REQUESTS = "RATE_OF_DELETE_PREDEFINED_ATTRIBUTE_API_REQUESTS"
    RATE_OF_DESCRIBE_RULE_API_REQUESTS = "RATE_OF_DESCRIBE_RULE_API_REQUESTS"
    RATE_OF_STOP_CONTACT_RECORDING_API_REQUESTS = "RATE_OF_STOP_CONTACT_RECORDING_API_REQUESTS"
    RATE_OF_UPDATE_QUEUE_OUTBOUND_CALLER_CONFIG_API_REQUESTS = "RATE_OF_UPDATE_QUEUE_OUTBOUND_CALLER_CONFIG_API_REQUESTS"
    RATE_OF_LIST_PROMPTS_API_REQUESTS = "RATE_OF_LIST_PROMPTS_API_REQUESTS"
    RATE_OF_ASSOCIATE_USER_PROFICIENCIES_API_REQUESTS = "RATE_OF_ASSOCIATE_USER_PROFICIENCIES_API_REQUESTS"
    RATE_OF_LIST_SECURITY_PROFILES_API_REQUESTS = "RATE_OF_LIST_SECURITY_PROFILES_API_REQUESTS"
    RATE_OF_LIST_QUEUE_QUICK_CONNECTS_API_REQUESTS = "RATE_OF_LIST_QUEUE_QUICK_CONNECTS_API_REQUESTS"
    RATE_OF_DELETE_VOCABULARY_API_REQUESTS = "RATE_OF_DELETE_VOCABULARY_API_REQUESTS"
    RATE_OF_DELETE_CONTACT_FLOW_MODULE_API_REQUESTS = "RATE_OF_DELETE_CONTACT_FLOW_MODULE_API_REQUESTS"
    RATE_OF_GET_METRIC_DATA_API_REQUESTS = "RATE_OF_GET_METRIC_DATA_API_REQUESTS"
    RATE_OF_SEARCH_USERS_API_REQUESTS = "RATE_OF_SEARCH_USERS_API_REQUESTS"
    RATE_OF_DESCRIBE_INSTANCE_API_REQUESTS = "RATE_OF_DESCRIBE_INSTANCE_API_REQUESTS"
    RATE_OF_UPDATE_USER_HIERARCHY_GROUP_NAME_API_REQUESTS = "RATE_OF_UPDATE_USER_HIERARCHY_GROUP_NAME_API_REQUESTS"
    RATE_OF_DESCRIBE_USER_HIERARCHY_STRUCTURE_API_REQUESTS = "RATE_OF_DESCRIBE_USER_HIERARCHY_STRUCTURE_API_REQUESTS"
    CAPACITY_PLANNING_SCENARIOS_PER_INSTANCE = "CAPACITY_PLANNING_SCENARIOS_PER_INSTANCE"
    CONCURRENT_UPLOADS_PER_INSTANCE = "CONCURRENT_UPLOADS_PER_INSTANCE"
    FILE_SIZE_PER_UPLOAD_OF_CAPACITY_PLAN_USER_DATA = "FILE_SIZE_PER_UPLOAD_OF_CAPACITY_PLAN_USER_DATA"
    QUEUES_PER_FORECAST_GROUP = "QUEUES_PER_FORECAST_GROUP"
    STAFFING_GROUPS_PER_SUPERVISOR = "STAFFING_GROUPS_PER_SUPERVISOR"
    SUPERVISORS_PER_STAFFING_GROUP = "SUPERVISORS_PER_STAFFING_GROUP"
    SHIFT_ACTIVITIES_PER_SHIFT_PROFILE = "SHIFT_ACTIVITIES_PER_SHIFT_PROFILE"
    AGENTS_PER_SCHEDULE = "AGENTS_PER_SCHEDULE"
    FORECAST_GROUPS_PER_INSTANCE = "FORECAST_GROUPS_PER_INSTANCE"
    CAPACITY_PLAN_USER_DATA_UPLOADS_PER_INSTANCE = "CAPACITY_PLAN_USER_DATA_UPLOADS_PER_INSTANCE"
    STAFFING_GROUPS_PER_INSTANCE = "STAFFING_GROUPS_PER_INSTANCE"
    FILE_SIZE_PER_UPLOAD_OF_HISTORICAL_ACTUALS = "FILE_SIZE_PER_UPLOAD_OF_HISTORICAL_ACTUALS"
    STAFFING_GROUPS_PER_FORECAST_GROUP = "STAFFING_GROUPS_PER_FORECAST_GROUP"
    FILE_SIZE_PER_UPLOAD_OF_CAPACITY_PLAN_OVERRIDES = "FILE_SIZE_PER_UPLOAD_OF_CAPACITY_PLAN_OVERRIDES"
    AGENTS_PER_STAFFING_GROUP = "AGENTS_PER_STAFFING_GROUP"
    CAPACITY_PLANS_PER_INSTANCE = "CAPACITY_PLANS_PER_INSTANCE"
    SCHEDULES_PER_INSTANCE = "SCHEDULES_PER_INSTANCE"
    CAPACITY_PLAN_OVERRIDE_UPLOADS_PER_INSTANCE = "CAPACITY_PLAN_OVERRIDE_UPLOADS_PER_INSTANCE"
    SHIFT_PROFILES_PER_INSTANCE = "SHIFT_PROFILES_PER_INSTANCE"
    HISTORICAL_ACTUALS_UPLOADS_PER_INSTANCE = "HISTORICAL_ACTUALS_UPLOADS_PER_INSTANCE"
    FORECAST_OVERRIDE_UPLOADS_PER_INSTANCE = "FORECAST_OVERRIDE_UPLOADS_PER_INSTANCE"
    SHIFT_ACTIVITIES_PER_INSTANCE = "SHIFT_ACTIVITIES_PER_INSTANCE"
    FILE_SIZE_PER_UPLOAD_OF_FORECAST_OVERRIDES = "FILE_SIZE_PER_UPLOAD_OF_FORECAST_OVERRIDES"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AmazonConnectVoiceIdQuota")
class AmazonConnectVoiceIdQuota(enum.Enum):
    ACTIVE_SPEAKER_ENROLLMENT_JOBS_PER_DOMAIN = "ACTIVE_SPEAKER_ENROLLMENT_JOBS_PER_DOMAIN"
    WATCHLISTS_PER_DOMAIN = "WATCHLISTS_PER_DOMAIN"
    SPEAKERS_PER_DOMAIN = "SPEAKERS_PER_DOMAIN"
    ACTIVE_FRAUDSTER_REGISTRATION_JOBS_PER_DOMAIN = "ACTIVE_FRAUDSTER_REGISTRATION_JOBS_PER_DOMAIN"
    FRAUDSTER_REGISTRATION_REQUESTS_PER_FRAUDSTER_REGISTRATION_JOB = "FRAUDSTER_REGISTRATION_REQUESTS_PER_FRAUDSTER_REGISTRATION_JOB"
    SPEAKER_ENROLLMENT_REQUESTS_PER_SPEAKER_ENROLLMENT_JOB = "SPEAKER_ENROLLMENT_REQUESTS_PER_SPEAKER_ENROLLMENT_JOB"
    DOMAINS_PER_REGION = "DOMAINS_PER_REGION"
    ACTIVE_STREAMING_SESSIONS_PER_DOMAIN = "ACTIVE_STREAMING_SESSIONS_PER_DOMAIN"
    FRAUDSTERS_PER_WATCHLIST = "FRAUDSTERS_PER_WATCHLIST"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AmazonDataLifecycleManagerQuota")
class AmazonDataLifecycleManagerQuota(enum.Enum):
    TARGET_ACCOUNTS_PER_SHARING_RULE = "TARGET_ACCOUNTS_PER_SHARING_RULE"
    POLICIES_PER_REGION = "POLICIES_PER_REGION"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AmazonDataZoneQuota")
class AmazonDataZoneQuota(enum.Enum):
    ASSETS = "ASSETS"
    GLOSSARIES = "GLOSSARIES"
    ASSET_TYPES = "ASSET_TYPES"
    ENVIRONMENTS_IN_A_DOMAIN = "ENVIRONMENTS_IN_A_DOMAIN"
    BUSINESS_GLOSSARY_TERMS = "BUSINESS_GLOSSARY_TERMS"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AmazonDocumentDbElasticClustersQuota")
class AmazonDocumentDbElasticClustersQuota(enum.Enum):
    SHARDS_PER_ELASTIC_CLUSTER = "SHARDS_PER_ELASTIC_CLUSTER"
    TAGS_PER_RESOURCE = "TAGS_PER_RESOURCE"
    MANUAL_CLUSTER_SNAPSHOTS = "MANUAL_CLUSTER_SNAPSHOTS"
    ELASTIC_CLUSTERS = "ELASTIC_CLUSTERS"
    ELASTIC_CLUSTERS_V_CPU_LIMIT = "ELASTIC_CLUSTERS_V_CPU_LIMIT"


@jsii.enum(
    jsii_type="@reapit-cdk/service-quotas.AmazonDocumentDbWithMongoDbCompatibilityQuota"
)
class AmazonDocumentDbWithMongoDbCompatibilityQuota(enum.Enum):
    READ_REPLICAS_PER_CLUSTER = "READ_REPLICAS_PER_CLUSTER"
    INSTANCES = "INSTANCES"
    CLUSTER_PARAMETER_GROUPS = "CLUSTER_PARAMETER_GROUPS"
    EVENT_SUBSCRIPTIONS = "EVENT_SUBSCRIPTIONS"
    SUBNET_GROUPS = "SUBNET_GROUPS"
    VPC_SECURITY_GROUPS_PER_INSTANCE = "VPC_SECURITY_GROUPS_PER_INSTANCE"
    CLUSTERS = "CLUSTERS"
    MANUAL_CLUSTER_SNAPSHOTS = "MANUAL_CLUSTER_SNAPSHOTS"
    SUBNETS_PER_SUBNET_GROUP = "SUBNETS_PER_SUBNET_GROUP"
    TAGS_PER_RESOURCE = "TAGS_PER_RESOURCE"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AmazonDynamoDbAcceleratorDaxQuota")
class AmazonDynamoDbAcceleratorDaxQuota(enum.Enum):
    SUBNETS_PER_SUBNET_GROUP = "SUBNETS_PER_SUBNET_GROUP"
    PARAMETER_GROUPS = "PARAMETER_GROUPS"
    TOTAL_NUMBER_OF_NODES = "TOTAL_NUMBER_OF_NODES"
    SUBNET_GROUPS = "SUBNET_GROUPS"
    NODES_PER_CLUSTER = "NODES_PER_CLUSTER"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AmazonDynamoDbQuota")
class AmazonDynamoDbQuota(enum.Enum):
    GLOBAL_SECONDARY_INDEXES_PER_TABLE = "GLOBAL_SECONDARY_INDEXES_PER_TABLE"
    WRITE_THROUGHPUT_LIMIT_FOR_DYNAMO_DB_STREAMS_PROVISIONED_MODE = "WRITE_THROUGHPUT_LIMIT_FOR_DYNAMO_DB_STREAMS_PROVISIONED_MODE"
    MAXIMUM_NUMBER_OF_TABLES = "MAXIMUM_NUMBER_OF_TABLES"
    CONCURRENT_CONTROL_PLANE_OPERATIONS = "CONCURRENT_CONTROL_PLANE_OPERATIONS"
    PROVISIONED_CAPACITY_DECREASES_PER_DAY = "PROVISIONED_CAPACITY_DECREASES_PER_DAY"
    TABLE_LEVEL_WRITE_THROUGHPUT_LIMIT = "TABLE_LEVEL_WRITE_THROUGHPUT_LIMIT"
    ACCOUNT_LEVEL_WRITE_THROUGHPUT_LIMIT_PROVISIONED_MODE = "ACCOUNT_LEVEL_WRITE_THROUGHPUT_LIMIT_PROVISIONED_MODE"
    TABLE_LEVEL_READ_THROUGHPUT_LIMIT = "TABLE_LEVEL_READ_THROUGHPUT_LIMIT"
    ACCOUNT_LEVEL_READ_THROUGHPUT_LIMIT_PROVISIONED_MODE = "ACCOUNT_LEVEL_READ_THROUGHPUT_LIMIT_PROVISIONED_MODE"
    MAXIMUM_INCREMENTAL_EXPORT_PERIOD_WINDOW = "MAXIMUM_INCREMENTAL_EXPORT_PERIOD_WINDOW"
    MINIMUM_INCREMENTAL_EXPORT_PERIOD_WINDOW = "MINIMUM_INCREMENTAL_EXPORT_PERIOD_WINDOW"
    MAXIMUM_INCREMENTAL_EXPORT_CONCURRENT_DATA_SIZE = "MAXIMUM_INCREMENTAL_EXPORT_CONCURRENT_DATA_SIZE"
    MAXIMUM_INCREMENTAL_EXPORT_CONCURRENT_REQUESTS = "MAXIMUM_INCREMENTAL_EXPORT_CONCURRENT_REQUESTS"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AmazonEc2AutoScalingQuota")
class AmazonEc2AutoScalingQuota(enum.Enum):
    LAUNCH_CONFIGURATIONS_PER_REGION = "LAUNCH_CONFIGURATIONS_PER_REGION"
    AUTO_SCALING_GROUPS_PER_REGION = "AUTO_SCALING_GROUPS_PER_REGION"
    CLASSIC_LOAD_BALANCERS_PER_AUTO_SCALING_GROUP = "CLASSIC_LOAD_BALANCERS_PER_AUTO_SCALING_GROUP"
    STEP_ADJUSTMENTS_PER_STEP_SCALING_POLICY = "STEP_ADJUSTMENTS_PER_STEP_SCALING_POLICY"
    SCALING_POLICIES_PER_AUTO_SCALING_GROUP = "SCALING_POLICIES_PER_AUTO_SCALING_GROUP"
    TARGET_GROUPS_PER_AUTO_SCALING_GROUP = "TARGET_GROUPS_PER_AUTO_SCALING_GROUP"
    SCHEDULED_ACTIONS_PER_AUTO_SCALING_GROUP = "SCHEDULED_ACTIONS_PER_AUTO_SCALING_GROUP"
    SNS_TOPICS_PER_AUTO_SCALING_GROUP = "SNS_TOPICS_PER_AUTO_SCALING_GROUP"
    LIFECYCLE_HOOKS_PER_AUTO_SCALING_GROUP = "LIFECYCLE_HOOKS_PER_AUTO_SCALING_GROUP"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AmazonElastiCacheQuota")
class AmazonElastiCacheQuota(enum.Enum):
    SHARDS_PER_CLUSTER_REDIS_CLUSTER_MODE_DISABLED = "SHARDS_PER_CLUSTER_REDIS_CLUSTER_MODE_DISABLED"
    SECURITY_GROUPS_PER_REGION = "SECURITY_GROUPS_PER_REGION"
    NODES_PER_CLUSTER_PER_INSTANCE_TYPE_REDIS_CLUSTER_MODE_ENABLED = "NODES_PER_CLUSTER_PER_INSTANCE_TYPE_REDIS_CLUSTER_MODE_ENABLED"
    NODES_PER_REGION = "NODES_PER_REGION"
    NODES_PER_SHARD_REDIS = "NODES_PER_SHARD_REDIS"
    SUBNET_GROUPS_PER_REGION = "SUBNET_GROUPS_PER_REGION"
    SUBNETS_PER_SUBNET_GROUP = "SUBNETS_PER_SUBNET_GROUP"
    NODES_PER_CLUSTER_MEMCACHED = "NODES_PER_CLUSTER_MEMCACHED"
    PARAMETER_GROUPS_PER_REGION = "PARAMETER_GROUPS_PER_REGION"


@jsii.enum(
    jsii_type="@reapit-cdk/service-quotas.AmazonElasticBlockStoreAmazonEbsQuota"
)
class AmazonElasticBlockStoreAmazonEbsQuota(enum.Enum):
    LIST_SNAPSHOT_BLOCKS_REQUESTS_PER_ACCOUNT = "LIST_SNAPSHOT_BLOCKS_REQUESTS_PER_ACCOUNT"
    PUT_SNAPSHOT_BLOCK_REQUESTS_PER_SNAPSHOT = "PUT_SNAPSHOT_BLOCK_REQUESTS_PER_SNAPSHOT"
    PENDING_SNAPSHOTS_PER_ACCOUNT = "PENDING_SNAPSHOTS_PER_ACCOUNT"
    START_SNAPSHOT_REQUESTS_PER_ACCOUNT = "START_SNAPSHOT_REQUESTS_PER_ACCOUNT"
    IOPS_FOR_PROVISIONED_IOPS_SSD_IO2_VOLUMES = "IOPS_FOR_PROVISIONED_IOPS_SSD_IO2_VOLUMES"
    STORAGE_MODIFICATIONS_FOR_PROVISIONED_IOPS_SSD_IO2_VOLUMES_IN_TI_B = "STORAGE_MODIFICATIONS_FOR_PROVISIONED_IOPS_SSD_IO2_VOLUMES_IN_TI_B"
    STORAGE_MODIFICATIONS_FOR_COLD_HDD_SC1_VOLUMES_IN_TI_B = "STORAGE_MODIFICATIONS_FOR_COLD_HDD_SC1_VOLUMES_IN_TI_B"
    STORAGE_MODIFICATIONS_FOR_GENERAL_PURPOSE_SSD_GP3_VOLUMES_IN_TI_B = "STORAGE_MODIFICATIONS_FOR_GENERAL_PURPOSE_SSD_GP3_VOLUMES_IN_TI_B"
    IOPS_MODIFICATIONS_FOR_PROVISIONED_IOPS_SSD_IO1_VOLUMES = "IOPS_MODIFICATIONS_FOR_PROVISIONED_IOPS_SSD_IO1_VOLUMES"
    STORAGE_MODIFICATIONS_FOR_PROVISIONED_IOPS_SSD_IO1_VOLUMES_IN_TI_B = "STORAGE_MODIFICATIONS_FOR_PROVISIONED_IOPS_SSD_IO1_VOLUMES_IN_TI_B"
    ARCHIVED_SNAPSHOTS_PER_VOLUME = "ARCHIVED_SNAPSHOTS_PER_VOLUME"
    SNAPSHOTS_PER_REGION = "SNAPSHOTS_PER_REGION"
    STORAGE_FOR_MAGNETIC_STANDARD_VOLUMES_IN_TI_B = "STORAGE_FOR_MAGNETIC_STANDARD_VOLUMES_IN_TI_B"
    STORAGE_FOR_PROVISIONED_IOPS_SSD_IO2_VOLUMES_IN_TI_B = "STORAGE_FOR_PROVISIONED_IOPS_SSD_IO2_VOLUMES_IN_TI_B"
    STORAGE_FOR_PROVISIONED_IOPS_SSD_IO1_VOLUMES_IN_TI_B = "STORAGE_FOR_PROVISIONED_IOPS_SSD_IO1_VOLUMES_IN_TI_B"
    STORAGE_FOR_COLD_HDD_SC1_VOLUMES_IN_TI_B = "STORAGE_FOR_COLD_HDD_SC1_VOLUMES_IN_TI_B"
    STORAGE_MODIFICATIONS_FOR_MAGNETIC_STANDARD_VOLUMES_IN_TI_B = "STORAGE_MODIFICATIONS_FOR_MAGNETIC_STANDARD_VOLUMES_IN_TI_B"
    GET_SNAPSHOT_BLOCK_REQUESTS_PER_SNAPSHOT = "GET_SNAPSHOT_BLOCK_REQUESTS_PER_SNAPSHOT"
    LIST_CHANGED_BLOCKS_REQUESTS_PER_ACCOUNT = "LIST_CHANGED_BLOCKS_REQUESTS_PER_ACCOUNT"
    PUT_SNAPSHOT_BLOCK_REQUESTS_PER_ACCOUNT = "PUT_SNAPSHOT_BLOCK_REQUESTS_PER_ACCOUNT"
    GET_SNAPSHOT_BLOCK_REQUESTS_PER_ACCOUNT = "GET_SNAPSHOT_BLOCK_REQUESTS_PER_ACCOUNT"
    COMPLETE_SNAPSHOT_REQUESTS_PER_ACCOUNT = "COMPLETE_SNAPSHOT_REQUESTS_PER_ACCOUNT"
    STORAGE_MODIFICATIONS_FOR_GENERAL_PURPOSE_SSD_GP2_VOLUMES_IN_TI_B = "STORAGE_MODIFICATIONS_FOR_GENERAL_PURPOSE_SSD_GP2_VOLUMES_IN_TI_B"
    IOPS_FOR_PROVISIONED_IOPS_SSD_IO1_VOLUMES = "IOPS_FOR_PROVISIONED_IOPS_SSD_IO1_VOLUMES"
    IN_PROGRESS_SNAPSHOT_ARCHIVES_PER_ACCOUNT = "IN_PROGRESS_SNAPSHOT_ARCHIVES_PER_ACCOUNT"
    STORAGE_FOR_THROUGHPUT_OPTIMIZED_HDD_ST1_VOLUMES_IN_TI_B = "STORAGE_FOR_THROUGHPUT_OPTIMIZED_HDD_ST1_VOLUMES_IN_TI_B"
    IN_PROGRESS_SNAPSHOT_RESTORES_FROM_ARCHIVE_PER_ACCOUNT = "IN_PROGRESS_SNAPSHOT_RESTORES_FROM_ARCHIVE_PER_ACCOUNT"
    STORAGE_FOR_GENERAL_PURPOSE_SSD_GP2_VOLUMES_IN_TI_B = "STORAGE_FOR_GENERAL_PURPOSE_SSD_GP2_VOLUMES_IN_TI_B"
    STORAGE_MODIFICATIONS_FOR_THROUGHPUT_OPTIMIZED_HDD_ST1_VOLUMES_IN_TI_B = "STORAGE_MODIFICATIONS_FOR_THROUGHPUT_OPTIMIZED_HDD_ST1_VOLUMES_IN_TI_B"
    IOPS_MODIFICATIONS_FOR_PROVISIONED_IOPS_SSD_IO2_VOLUMES = "IOPS_MODIFICATIONS_FOR_PROVISIONED_IOPS_SSD_IO2_VOLUMES"
    FAST_SNAPSHOT_RESTORE = "FAST_SNAPSHOT_RESTORE"
    STORAGE_FOR_GENERAL_PURPOSE_SSD_GP3_VOLUMES_IN_TI_B = "STORAGE_FOR_GENERAL_PURPOSE_SSD_GP3_VOLUMES_IN_TI_B"
    CONCURRENT_SNAPSHOTS_PER_THROUGHPUT_OPTIMIZED_HDD_ST1_VOLUME = "CONCURRENT_SNAPSHOTS_PER_THROUGHPUT_OPTIMIZED_HDD_ST1_VOLUME"
    CONCURRENT_SNAPSHOTS_PER_COLD_HDD_SC1_VOLUME = "CONCURRENT_SNAPSHOTS_PER_COLD_HDD_SC1_VOLUME"
    CONCURRENT_SNAPSHOTS_PER_PROVISIONED_IOPS_SSD_IO1_VOLUME = "CONCURRENT_SNAPSHOTS_PER_PROVISIONED_IOPS_SSD_IO1_VOLUME"
    CONCURRENT_SNAPSHOT_COPIES_PER_DESTINATION_REGION = "CONCURRENT_SNAPSHOT_COPIES_PER_DESTINATION_REGION"
    CONCURRENT_SNAPSHOTS_PER_PROVISIONED_IOPS_SSD_IO2_VOLUME = "CONCURRENT_SNAPSHOTS_PER_PROVISIONED_IOPS_SSD_IO2_VOLUME"
    CONCURRENT_SNAPSHOTS_PER_MAGNETIC_STANDARD_VOLUME = "CONCURRENT_SNAPSHOTS_PER_MAGNETIC_STANDARD_VOLUME"
    CONCURRENT_SNAPSHOTS_PER_GENERAL_PURPOSE_SSD_GP3_VOLUME = "CONCURRENT_SNAPSHOTS_PER_GENERAL_PURPOSE_SSD_GP3_VOLUME"
    CONCURRENT_SNAPSHOTS_PER_GENERAL_PURPOSE_SSD_GP2_VOLUME = "CONCURRENT_SNAPSHOTS_PER_GENERAL_PURPOSE_SSD_GP2_VOLUME"


@jsii.enum(
    jsii_type="@reapit-cdk/service-quotas.AmazonElasticComputeCloudAmazonEc2Quota"
)
class AmazonElasticComputeCloudAmazonEc2Quota(enum.Enum):
    RUNNING_DEDICATED_R6IDN_HOSTS = "RUNNING_DEDICATED_R6IDN_HOSTS"
    RUNNING_DEDICATED_MAC2_HOSTS = "RUNNING_DEDICATED_MAC2_HOSTS"
    RUNNING_DEDICATED_C3_HOSTS = "RUNNING_DEDICATED_C3_HOSTS"
    RUNNING_DEDICATED_C6GN_HOSTS = "RUNNING_DEDICATED_C6GN_HOSTS"
    RUNNING_DEDICATED_M5D_HOSTS = "RUNNING_DEDICATED_M5D_HOSTS"
    RUNNING_DEDICATED_G4DN_HOSTS = "RUNNING_DEDICATED_G4DN_HOSTS"
    RUNNING_DEDICATED_R5_HOSTS = "RUNNING_DEDICATED_R5_HOSTS"
    RUNNING_DEDICATED_C7A_HOSTS = "RUNNING_DEDICATED_C7A_HOSTS"
    RUNNING_DEDICATED_I3_HOSTS = "RUNNING_DEDICATED_I3_HOSTS"
    RUNNING_DEDICATED_I3EN_HOSTS = "RUNNING_DEDICATED_I3EN_HOSTS"
    RUNNING_ON_DEMAND_DL_INSTANCES = "RUNNING_ON_DEMAND_DL_INSTANCES"
    RUNNING_DEDICATED_I2_HOSTS = "RUNNING_DEDICATED_I2_HOSTS"
    RUNNING_DEDICATED_M7I_HOSTS = "RUNNING_DEDICATED_M7I_HOSTS"
    RUNNING_DEDICATED_MAC2_M2PRO_HOSTS = "RUNNING_DEDICATED_MAC2_M2PRO_HOSTS"
    CLIENT_VPN_ENDPOINTS_PER_REGION = "CLIENT_VPN_ENDPOINTS_PER_REGION"
    AM_IS = "AM_IS"
    MULTICAST_DOMAIN_ASSOCIATIONS_PER_VPC = "MULTICAST_DOMAIN_ASSOCIATIONS_PER_VPC"
    MULTICAST_NETWORK_INTERFACES_PER_TRANSIT_GATEWAY = "MULTICAST_NETWORK_INTERFACES_PER_TRANSIT_GATEWAY"
    ALL_DL_SPOT_INSTANCE_REQUESTS = "ALL_DL_SPOT_INSTANCE_REQUESTS"
    RUNNING_DEDICATED_TRN1N_HOSTS = "RUNNING_DEDICATED_TRN1N_HOSTS"
    RUNNING_DEDICATED_X2IDN_HOSTS = "RUNNING_DEDICATED_X2IDN_HOSTS"
    RUNNING_DEDICATED_U_12TB1_HOSTS = "RUNNING_DEDICATED_U_12TB1_HOSTS"
    RUNNING_DEDICATED_Z1D_HOSTS = "RUNNING_DEDICATED_Z1D_HOSTS"
    RUNNING_DEDICATED_DL1_HOSTS = "RUNNING_DEDICATED_DL1_HOSTS"
    RUNNING_DEDICATED_R6ID_HOSTS = "RUNNING_DEDICATED_R6ID_HOSTS"
    ALL_X_SPOT_INSTANCE_REQUESTS = "ALL_X_SPOT_INSTANCE_REQUESTS"
    RUNNING_DEDICATED_C5_HOSTS = "RUNNING_DEDICATED_C5_HOSTS"
    RUNNING_DEDICATED_C7GN_HOSTS = "RUNNING_DEDICATED_C7GN_HOSTS"
    RUNNING_DEDICATED_M5AD_HOSTS = "RUNNING_DEDICATED_M5AD_HOSTS"
    RUNNING_DEDICATED_M7A_HOSTS = "RUNNING_DEDICATED_M7A_HOSTS"
    RUNNING_DEDICATED_A1_HOSTS = "RUNNING_DEDICATED_A1_HOSTS"
    RUNNING_ON_DEMAND_P_INSTANCES = "RUNNING_ON_DEMAND_P_INSTANCES"
    RUNNING_DEDICATED_INF_HOSTS = "RUNNING_DEDICATED_INF_HOSTS"
    RUNNING_DEDICATED_C4_HOSTS = "RUNNING_DEDICATED_C4_HOSTS"
    VERIFIED_ACCESS_GROUPS = "VERIFIED_ACCESS_GROUPS"
    NEW_RESERVED_INSTANCES_PER_MONTH = "NEW_RESERVED_INSTANCES_PER_MONTH"
    ATTACHMENTS_PER_TRANSIT_GATEWAY = "ATTACHMENTS_PER_TRANSIT_GATEWAY"
    TRANSIT_GATEWAYS_PER_ACCOUNT = "TRANSIT_GATEWAYS_PER_ACCOUNT"
    RUNNING_DEDICATED_U_3TB1_HOSTS = "RUNNING_DEDICATED_U_3TB1_HOSTS"
    RUNNING_DEDICATED_U_18TB1_HOSTS = "RUNNING_DEDICATED_U_18TB1_HOSTS"
    RUNNING_DEDICATED_IM4GN_HOSTS = "RUNNING_DEDICATED_IM4GN_HOSTS"
    RUNNING_DEDICATED_G4AD_HOSTS = "RUNNING_DEDICATED_G4AD_HOSTS"
    RUNNING_DEDICATED_F1_HOSTS = "RUNNING_DEDICATED_F1_HOSTS"
    RUNNING_DEDICATED_C6IN_HOSTS = "RUNNING_DEDICATED_C6IN_HOSTS"
    RUNNING_DEDICATED_X1_HOSTS = "RUNNING_DEDICATED_X1_HOSTS"
    RUNNING_DEDICATED_R6A_HOSTS = "RUNNING_DEDICATED_R6A_HOSTS"
    RUNNING_ON_DEMAND_F_INSTANCES = "RUNNING_ON_DEMAND_F_INSTANCES"
    RUNNING_DEDICATED_M6IN_HOSTS = "RUNNING_DEDICATED_M6IN_HOSTS"
    RUNNING_DEDICATED_R7A_HOSTS = "RUNNING_DEDICATED_R7A_HOSTS"
    RUNNING_DEDICATED_C7I_HOSTS = "RUNNING_DEDICATED_C7I_HOSTS"
    RUNNING_DEDICATED_C6ID_HOSTS = "RUNNING_DEDICATED_C6ID_HOSTS"
    RUNNING_DEDICATED_C6A_HOSTS = "RUNNING_DEDICATED_C6A_HOSTS"
    RUNNING_ON_DEMAND_X_INSTANCES = "RUNNING_ON_DEMAND_X_INSTANCES"
    CONCURRENT_CLIENT_CONNECTIONS_PER_CLIENT_VPN_ENDPOINT = "CONCURRENT_CLIENT_CONNECTIONS_PER_CLIENT_VPN_ENDPOINT"
    VPN_CONNECTIONS_PER_VGW = "VPN_CONNECTIONS_PER_VGW"
    VPN_CONNECTIONS_PER_REGION = "VPN_CONNECTIONS_PER_REGION"
    ALL_F_SPOT_INSTANCE_REQUESTS = "ALL_F_SPOT_INSTANCE_REQUESTS"
    RUNNING_DEDICATED_U_24TB1_HOSTS = "RUNNING_DEDICATED_U_24TB1_HOSTS"
    RUNNING_DEDICATED_G5G_HOSTS = "RUNNING_DEDICATED_G5G_HOSTS"
    RUNNING_DEDICATED_R6I_HOSTS = "RUNNING_DEDICATED_R6I_HOSTS"
    RUNNING_DEDICATED_MAC2_M2_HOSTS = "RUNNING_DEDICATED_MAC2_M2_HOSTS"
    RUNNING_DEDICATED_C6G_HOSTS = "RUNNING_DEDICATED_C6G_HOSTS"
    RUNNING_DEDICATED_X2IEZN_HOSTS = "RUNNING_DEDICATED_X2IEZN_HOSTS"
    RUNNING_DEDICATED_VT1_HOSTS = "RUNNING_DEDICATED_VT1_HOSTS"
    RUNNING_DEDICATED_P3_HOSTS = "RUNNING_DEDICATED_P3_HOSTS"
    RUNNING_DEDICATED_H1_HOSTS = "RUNNING_DEDICATED_H1_HOSTS"
    RUNNING_DEDICATED_C6I_HOSTS = "RUNNING_DEDICATED_C6I_HOSTS"
    RUNNING_DEDICATED_R7IZ_HOSTS = "RUNNING_DEDICATED_R7IZ_HOSTS"
    RUNNING_DEDICATED_X2IEDN_HOSTS = "RUNNING_DEDICATED_X2IEDN_HOSTS"
    RUNNING_DEDICATED_M6A_HOSTS = "RUNNING_DEDICATED_M6A_HOSTS"
    RUNNING_DEDICATED_M6GD_HOSTS = "RUNNING_DEDICATED_M6GD_HOSTS"
    RUNNING_DEDICATED_M5DN_HOSTS = "RUNNING_DEDICATED_M5DN_HOSTS"
    PENDING_PEERING_ATTACHMENTS_PER_TRANSIT_GATEWAY = "PENDING_PEERING_ATTACHMENTS_PER_TRANSIT_GATEWAY"
    MEMBERS_PER_TRANSIT_GATEWAY_MULTICAST_GROUP = "MEMBERS_PER_TRANSIT_GATEWAY_MULTICAST_GROUP"
    VERIFIED_ACCESS_TRUST_PROVIDERS = "VERIFIED_ACCESS_TRUST_PROVIDERS"
    RUNNING_DEDICATED_C7G_HOSTS = "RUNNING_DEDICATED_C7G_HOSTS"
    RUNNING_DEDICATED_C5N_HOSTS = "RUNNING_DEDICATED_C5N_HOSTS"
    RUNNING_DEDICATED_C6GD_HOSTS = "RUNNING_DEDICATED_C6GD_HOSTS"
    RUNNING_ON_DEMAND_G_AND_VT_INSTANCES = "RUNNING_ON_DEMAND_G_AND_VT_INSTANCES"
    RUNNING_DEDICATED_R5N_HOSTS = "RUNNING_DEDICATED_R5N_HOSTS"
    RUNNING_DEDICATED_M5_HOSTS = "RUNNING_DEDICATED_M5_HOSTS"
    RUNNING_DEDICATED_P3DN_HOSTS = "RUNNING_DEDICATED_P3DN_HOSTS"
    RUNNING_DEDICATED_R7I_HOSTS = "RUNNING_DEDICATED_R7I_HOSTS"
    RUNNING_ON_DEMAND_INF_INSTANCES = "RUNNING_ON_DEMAND_INF_INSTANCES"
    ALL_INF_SPOT_INSTANCE_REQUESTS = "ALL_INF_SPOT_INSTANCE_REQUESTS"
    RUNNING_ON_DEMAND_HIGH_MEMORY_INSTANCES = "RUNNING_ON_DEMAND_HIGH_MEMORY_INSTANCES"
    RUNNING_DEDICATED_R5DN_HOSTS = "RUNNING_DEDICATED_R5DN_HOSTS"
    RUNNING_DEDICATED_INF2_HOSTS = "RUNNING_DEDICATED_INF2_HOSTS"
    RUNNING_ON_DEMAND_STANDARD_A_C_D_H_I_M_R_T_Z_INSTANCES = "RUNNING_ON_DEMAND_STANDARD_A_C_D_H_I_M_R_T_Z_INSTANCES"
    SOURCES_PER_TRANSIT_GATEWAY_MULTICAST_GROUP = "SOURCES_PER_TRANSIT_GATEWAY_MULTICAST_GROUP"
    ROUTES_PER_TRANSIT_GATEWAY = "ROUTES_PER_TRANSIT_GATEWAY"
    MULTICAST_DOMAINS_PER_TRANSIT_GATEWAY = "MULTICAST_DOMAINS_PER_TRANSIT_GATEWAY"
    ALL_G_AND_VT_SPOT_INSTANCE_REQUESTS = "ALL_G_AND_VT_SPOT_INSTANCE_REQUESTS"
    RUNNING_DEDICATED_M7GD_HOSTS = "RUNNING_DEDICATED_M7GD_HOSTS"
    RUNNING_DEDICATED_R5B_HOSTS = "RUNNING_DEDICATED_R5B_HOSTS"
    RUNNING_DEDICATED_R6G_HOSTS = "RUNNING_DEDICATED_R6G_HOSTS"
    RUNNING_DEDICATED_R6GD_HOSTS = "RUNNING_DEDICATED_R6GD_HOSTS"
    RUNNING_DEDICATED_R7G_HOSTS = "RUNNING_DEDICATED_R7G_HOSTS"
    RUNNING_DEDICATED_IS4GEN_HOSTS = "RUNNING_DEDICATED_IS4GEN_HOSTS"
    RUNNING_DEDICATED_R6IN_HOSTS = "RUNNING_DEDICATED_R6IN_HOSTS"
    RUNNING_DEDICATED_M6G_HOSTS = "RUNNING_DEDICATED_M6G_HOSTS"
    RUNNING_DEDICATED_U_9TB1_HOSTS = "RUNNING_DEDICATED_U_9TB1_HOSTS"
    RUNNING_DEDICATED_C7GD_HOSTS = "RUNNING_DEDICATED_C7GD_HOSTS"
    RUNNING_DEDICATED_M5ZN_HOSTS = "RUNNING_DEDICATED_M5ZN_HOSTS"
    RUNNING_DEDICATED_X1E_HOSTS = "RUNNING_DEDICATED_X1E_HOSTS"
    ALL_STANDARD_A_C_D_H_I_M_R_T_Z_SPOT_INSTANCE_REQUESTS = "ALL_STANDARD_A_C_D_H_I_M_R_T_Z_SPOT_INSTANCE_REQUESTS"
    RUNNING_DEDICATED_R5AD_HOSTS = "RUNNING_DEDICATED_R5AD_HOSTS"
    VERIFIED_ACCESS_ENDPOINTS = "VERIFIED_ACCESS_ENDPOINTS"
    AMI_SHARING = "AMI_SHARING"
    CUSTOMER_GATEWAYS_PER_REGION = "CUSTOMER_GATEWAYS_PER_REGION"
    ROUTES_PER_CLIENT_VPN_ENDPOINT = "ROUTES_PER_CLIENT_VPN_ENDPOINT"
    ATTACHMENTS_PER_VPC = "ATTACHMENTS_PER_VPC"
    RUNNING_DEDICATED_T3_HOSTS = "RUNNING_DEDICATED_T3_HOSTS"
    ALL_TRN_SPOT_INSTANCE_REQUESTS = "ALL_TRN_SPOT_INSTANCE_REQUESTS"
    RUNNING_DEDICATED_R3_HOSTS = "RUNNING_DEDICATED_R3_HOSTS"
    RUNNING_DEDICATED_M6ID_HOSTS = "RUNNING_DEDICATED_M6ID_HOSTS"
    RUNNING_DEDICATED_D2_HOSTS = "RUNNING_DEDICATED_D2_HOSTS"
    RUNNING_DEDICATED_C5D_HOSTS = "RUNNING_DEDICATED_C5D_HOSTS"
    RUNNING_DEDICATED_P5_HOSTS = "RUNNING_DEDICATED_P5_HOSTS"
    RUNNING_DEDICATED_M4_HOSTS = "RUNNING_DEDICATED_M4_HOSTS"
    RUNNING_DEDICATED_G3_HOSTS = "RUNNING_DEDICATED_G3_HOSTS"
    RUNNING_ON_DEMAND_HPC_INSTANCES = "RUNNING_ON_DEMAND_HPC_INSTANCES"
    RUNNING_DEDICATED_M7G_HOSTS = "RUNNING_DEDICATED_M7G_HOSTS"
    RUNNING_DEDICATED_R5A_HOSTS = "RUNNING_DEDICATED_R5A_HOSTS"
    RUNNING_DEDICATED_M6I_HOSTS = "RUNNING_DEDICATED_M6I_HOSTS"
    RUNNING_DEDICATED_X2GD_HOSTS = "RUNNING_DEDICATED_X2GD_HOSTS"
    RUNNING_DEDICATED_P2_HOSTS = "RUNNING_DEDICATED_P2_HOSTS"
    RUNNING_DEDICATED_M5A_HOSTS = "RUNNING_DEDICATED_M5A_HOSTS"
    RUNNING_DEDICATED_M3_HOSTS = "RUNNING_DEDICATED_M3_HOSTS"
    ALL_P4_P3_AND_P2_SPOT_INSTANCE_REQUESTS = "ALL_P4_P3_AND_P2_SPOT_INSTANCE_REQUESTS"
    VERIFIED_ACCESS_INSTANCES = "VERIFIED_ACCESS_INSTANCES"
    LAUNCH_TEMPLATE_VERSIONS = "LAUNCH_TEMPLATE_VERSIONS"
    RUNNING_ON_DEMAND_TRN_INSTANCES = "RUNNING_ON_DEMAND_TRN_INSTANCES"
    RUNNING_DEDICATED_M5N_HOSTS = "RUNNING_DEDICATED_M5N_HOSTS"
    RUNNING_DEDICATED_MAC1_HOSTS = "RUNNING_DEDICATED_MAC1_HOSTS"
    RUNNING_DEDICATED_M6IDN_HOSTS = "RUNNING_DEDICATED_M6IDN_HOSTS"
    RUNNING_DEDICATED_I4I_HOSTS = "RUNNING_DEDICATED_I4I_HOSTS"
    RUNNING_DEDICATED_TRN1_HOSTS = "RUNNING_DEDICATED_TRN1_HOSTS"
    RUNNING_DEDICATED_U_6TB1_HOSTS = "RUNNING_DEDICATED_U_6TB1_HOSTS"
    RUNNING_DEDICATED_R7GD_HOSTS = "RUNNING_DEDICATED_R7GD_HOSTS"
    RUNNING_DEDICATED_R4_HOSTS = "RUNNING_DEDICATED_R4_HOSTS"
    RUNNING_DEDICATED_I4G_HOSTS = "RUNNING_DEDICATED_I4G_HOSTS"
    RUNNING_DEDICATED_P4D_HOSTS = "RUNNING_DEDICATED_P4D_HOSTS"
    RUNNING_DEDICATED_R5D_HOSTS = "RUNNING_DEDICATED_R5D_HOSTS"
    ALL_P5_SPOT_INSTANCE_REQUESTS = "ALL_P5_SPOT_INSTANCE_REQUESTS"
    RUNNING_DEDICATED_G5_HOSTS = "RUNNING_DEDICATED_G5_HOSTS"
    RUNNING_DEDICATED_G3S_HOSTS = "RUNNING_DEDICATED_G3S_HOSTS"
    AUTHORIZATION_RULES_PER_CLIENT_VPN_ENDPOINT = "AUTHORIZATION_RULES_PER_CLIENT_VPN_ENDPOINT"
    PEERING_ATTACHMENTS_PER_TRANSIT_GATEWAY = "PEERING_ATTACHMENTS_PER_TRANSIT_GATEWAY"
    VIRTUAL_PRIVATE_GATEWAYS_PER_REGION = "VIRTUAL_PRIVATE_GATEWAYS_PER_REGION"
    PUBLIC_AM_IS = "PUBLIC_AM_IS"
    RUNNING_DEDICATED_C5A_HOSTS = "RUNNING_DEDICATED_C5A_HOSTS"
    EC2_VPC_ELASTIC_I_PS = "EC2_VPC_ELASTIC_I_PS"
    LAUNCH_TEMPLATES = "LAUNCH_TEMPLATES"
    EC2_CLASSIC_ELASTIC_I_PS = "EC2_CLASSIC_ELASTIC_I_PS"
    ROUTE_TABLES_PER_TRANSIT_GATEWAY = "ROUTE_TABLES_PER_TRANSIT_GATEWAY"
    CONCURRENT_OPERATIONS_PER_CLIENT_VPN_ENDPOINT = "CONCURRENT_OPERATIONS_PER_CLIENT_VPN_ENDPOINT"
    ROUTES_ADVERTISED_FROM_VPN_CONNECTION_TO_CGW = "ROUTES_ADVERTISED_FROM_VPN_CONNECTION_TO_CGW"
    VPC_ATTACHMENT_BANDWIDTH = "VPC_ATTACHMENT_BANDWIDTH"
    NUMBER_OF_ELASTIC_GRAPHICS_ACCELERATORS = "NUMBER_OF_ELASTIC_GRAPHICS_ACCELERATORS"
    DIRECT_CONNECT_GATEWAYS_PER_TRANSIT_GATEWAY = "DIRECT_CONNECT_GATEWAYS_PER_TRANSIT_GATEWAY"
    AMAZON_FPGA_IMAGES_AF_IS = "AMAZON_FPGA_IMAGES_AF_IS"
    TRANSIT_GATEWAYS_PER_DIRECT_CONNECT_GATEWAY = "TRANSIT_GATEWAYS_PER_DIRECT_CONNECT_GATEWAY"
    DYNAMIC_ROUTES_ADVERTISED_FROM_CGW_TO_VPN_CONNECTION = "DYNAMIC_ROUTES_ADVERTISED_FROM_CGW_TO_VPN_CONNECTION"
    ENTRIES_IN_A_CLIENT_CERTIFICATE_REVOCATION_LIST_FOR_CLIENT_VPN_ENDPOINTS = "ENTRIES_IN_A_CLIENT_CERTIFICATE_REVOCATION_LIST_FOR_CLIENT_VPN_ENDPOINTS"


@jsii.enum(
    jsii_type="@reapit-cdk/service-quotas.AmazonElasticContainerRegistryAmazonEcrQuota"
)
class AmazonElasticContainerRegistryAmazonEcrQuota(enum.Enum):
    PULL_THROUGH_CACHE_RULES_PER_REGISTRY = "PULL_THROUGH_CACHE_RULES_PER_REGISTRY"
    RATE_OF_PUT_IMAGE_REQUESTS = "RATE_OF_PUT_IMAGE_REQUESTS"
    RATE_OF_UPLOAD_LAYER_PART_REQUESTS = "RATE_OF_UPLOAD_LAYER_PART_REQUESTS"
    RATE_OF_GET_DOWNLOAD_URL_FOR_LAYER_REQUESTS = "RATE_OF_GET_DOWNLOAD_URL_FOR_LAYER_REQUESTS"
    RATE_OF_INITIATE_LAYER_UPLOAD_REQUESTS = "RATE_OF_INITIATE_LAYER_UPLOAD_REQUESTS"
    RATE_OF_GET_AUTHORIZATION_TOKEN_REQUESTS = "RATE_OF_GET_AUTHORIZATION_TOKEN_REQUESTS"
    RATE_OF_COMPLETE_LAYER_UPLOAD_REQUESTS = "RATE_OF_COMPLETE_LAYER_UPLOAD_REQUESTS"
    RATE_OF_BATCH_CHECK_LAYER_AVAILABILITY_REQUESTS = "RATE_OF_BATCH_CHECK_LAYER_AVAILABILITY_REQUESTS"
    RATE_OF_BATCH_GET_IMAGE_REQUESTS = "RATE_OF_BATCH_GET_IMAGE_REQUESTS"
    RULES_PER_LIFECYCLE_POLICY = "RULES_PER_LIFECYCLE_POLICY"
    UNIQUE_DESTINATIONS_ACROSS_ALL_RULES_IN_A_REPLICATION_CONFIGURATION = "UNIQUE_DESTINATIONS_ACROSS_ALL_RULES_IN_A_REPLICATION_CONFIGURATION"
    RATE_OF_IMAGE_SCANS = "RATE_OF_IMAGE_SCANS"
    TAGS_PER_IMAGE = "TAGS_PER_IMAGE"
    MAXIMUM_LAYER_PART_SIZE = "MAXIMUM_LAYER_PART_SIZE"
    MAXIMUM_LAYER_SIZE = "MAXIMUM_LAYER_SIZE"
    LAYER_PARTS = "LAYER_PARTS"
    MINIMUM_LAYER_PART_SIZE = "MINIMUM_LAYER_PART_SIZE"
    RULES_PER_REPLICATION_CONFIGURATION = "RULES_PER_REPLICATION_CONFIGURATION"
    REGISTERED_REPOSITORIES = "REGISTERED_REPOSITORIES"
    IMAGES_PER_REPOSITORY = "IMAGES_PER_REPOSITORY"
    LIFECYCLE_POLICY_LENGTH = "LIFECYCLE_POLICY_LENGTH"
    FILTERS_PER_RULE_IN_A_REPLICATION_CONFIGURATION = "FILTERS_PER_RULE_IN_A_REPLICATION_CONFIGURATION"


@jsii.enum(
    jsii_type="@reapit-cdk/service-quotas.AmazonElasticContainerRegistryPublicAmazonEcrPublicQuota"
)
class AmazonElasticContainerRegistryPublicAmazonEcrPublicQuota(enum.Enum):
    RATE_OF_BATCH_CHECK_LAYER_AVAILABILITY_REQUESTS = "RATE_OF_BATCH_CHECK_LAYER_AVAILABILITY_REQUESTS"
    MAXIMUM_LAYER_SIZE = "MAXIMUM_LAYER_SIZE"
    TAGS_PER_IMAGE = "TAGS_PER_IMAGE"
    RATE_OF_IMAGE_PULLS_TO_AWS_RESOURCES = "RATE_OF_IMAGE_PULLS_TO_AWS_RESOURCES"
    REGISTERED_REPOSITORIES = "REGISTERED_REPOSITORIES"
    LAYER_PARTS = "LAYER_PARTS"
    RATE_OF_COMPLETE_LAYER_UPLOAD_REQUESTS = "RATE_OF_COMPLETE_LAYER_UPLOAD_REQUESTS"
    RATE_OF_UPLOAD_LAYER_PART_REQUESTS = "RATE_OF_UPLOAD_LAYER_PART_REQUESTS"
    RATE_OF_PUT_IMAGE_REQUESTS = "RATE_OF_PUT_IMAGE_REQUESTS"
    MAXIMUM_LAYER_PART_SIZE = "MAXIMUM_LAYER_PART_SIZE"
    RATE_OF_UNAUTHENTICATED_IMAGE_PULLS = "RATE_OF_UNAUTHENTICATED_IMAGE_PULLS"
    RATE_OF_INITIATE_LAYER_UPLOAD_REQUESTS = "RATE_OF_INITIATE_LAYER_UPLOAD_REQUESTS"
    IMAGES_PER_REPOSITORY = "IMAGES_PER_REPOSITORY"
    RATE_OF_AUTHENTICATED_IMAGE_PULLS = "RATE_OF_AUTHENTICATED_IMAGE_PULLS"
    MINIMUM_LAYER_PART_SIZE = "MINIMUM_LAYER_PART_SIZE"
    RATE_OF_GET_AUTHORIZATION_TOKEN_REQUESTS = "RATE_OF_GET_AUTHORIZATION_TOKEN_REQUESTS"


@jsii.enum(
    jsii_type="@reapit-cdk/service-quotas.AmazonElasticContainerServiceAmazonEcsQuota"
)
class AmazonElasticContainerServiceAmazonEcsQuota(enum.Enum):
    CLASSIC_LOAD_BALANCERS_PER_SERVICE = "CLASSIC_LOAD_BALANCERS_PER_SERVICE"
    CAPACITY_PROVIDERS_PER_CLUSTER = "CAPACITY_PROVIDERS_PER_CLUSTER"
    SERVICES_PER_NAMESPACE = "SERVICES_PER_NAMESPACE"
    RATE_OF_TASKS_LAUNCHED_BY_A_SERVICE_ON_AWS_FARGATE = "RATE_OF_TASKS_LAUNCHED_BY_A_SERVICE_ON_AWS_FARGATE"
    TARGET_GROUPS_PER_SERVICE = "TARGET_GROUPS_PER_SERVICE"
    TASK_DEFINITION_SIZE = "TASK_DEFINITION_SIZE"
    TASKS_IN_PROVISIONING_STATE_PER_CLUSTER = "TASKS_IN_PROVISIONING_STATE_PER_CLUSTER"
    SERVICES_PER_CLUSTER = "SERVICES_PER_CLUSTER"
    CLUSTERS_PER_ACCOUNT = "CLUSTERS_PER_ACCOUNT"
    CONTAINERS_PER_TASK_DEFINITION = "CONTAINERS_PER_TASK_DEFINITION"
    TAGS_PER_RESOURCE = "TAGS_PER_RESOURCE"
    REVISIONS_PER_TASK_DEFINITION_FAMILY = "REVISIONS_PER_TASK_DEFINITION_FAMILY"
    TASKS_PER_SERVICE = "TASKS_PER_SERVICE"
    CONTAINER_INSTANCES_PER_START_TASK = "CONTAINER_INSTANCES_PER_START_TASK"
    SUBNETS_PER_AWSVPC_CONFIGURATION = "SUBNETS_PER_AWSVPC_CONFIGURATION"
    TASKS_LAUNCHED_PER_RUN_TASK = "TASKS_LAUNCHED_PER_RUN_TASK"
    RATE_OF_TASKS_LAUNCHED_BY_A_SERVICE_ON_AN_AMAZON_EC2_OR_EXTERNAL_INSTANCE = "RATE_OF_TASKS_LAUNCHED_BY_A_SERVICE_ON_AN_AMAZON_EC2_OR_EXTERNAL_INSTANCE"
    ECS_EXEC_SESSIONS = "ECS_EXEC_SESSIONS"
    SECURITY_GROUPS_PER_AWSVPC_CONFIGURATION = "SECURITY_GROUPS_PER_AWSVPC_CONFIGURATION"
    CONTAINER_INSTANCES_PER_CLUSTER = "CONTAINER_INSTANCES_PER_CLUSTER"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AmazonElasticFileSystemEfsQuota")
class AmazonElasticFileSystemEfsQuota(enum.Enum):
    SECURITY_GROUPS_PER_MOUNT_TARGET = "SECURITY_GROUPS_PER_MOUNT_TARGET"
    FILE_HARD_LINKS = "FILE_HARD_LINKS"
    VP_CS_PER_FILE_SYSTEM = "VP_CS_PER_FILE_SYSTEM"
    LOCKS_ACROSS_UNIQUE_FILE_PROCESS_PAIRS = "LOCKS_ACROSS_UNIQUE_FILE_PROCESS_PAIRS"
    DIRECTORY_DEPTH = "DIRECTORY_DEPTH"
    ACTIVE_USERS_PER_NFS_CLIENT = "ACTIVE_USERS_PER_NFS_CLIENT"
    MINIMUM_WAIT_TIME_BETWEEN_PROVISIONED_THROUGHPUT_DECREASES = "MINIMUM_WAIT_TIME_BETWEEN_PROVISIONED_THROUGHPUT_DECREASES"
    FILE_SYSTEMS_PER_ACCOUNT = "FILE_SYSTEMS_PER_ACCOUNT"
    PROVISIONED_THROUGHPUT = "PROVISIONED_THROUGHPUT"
    MOUNT_TARGETS_PER_VPC = "MOUNT_TARGETS_PER_VPC"
    OPEN_FILES_PER_NFS_CLIENT = "OPEN_FILES_PER_NFS_CLIENT"
    MOUNT_TARGETS_PER_AVAILABILITY_ZONE = "MOUNT_TARGETS_PER_AVAILABILITY_ZONE"
    MINIMUM_WAIT_TIME_BETWEEN_THROUGHPUT_MODE_CHANGES = "MINIMUM_WAIT_TIME_BETWEEN_THROUGHPUT_MODE_CHANGES"
    BURSTING_THROUGHPUT = "BURSTING_THROUGHPUT"
    THROUGHPUT_PER_NFS_CLIENT = "THROUGHPUT_PER_NFS_CLIENT"
    RATE_OF_FILE_SYSTEM_OPERATIONS = "RATE_OF_FILE_SYSTEM_OPERATIONS"
    FILE_SYSTEM_NAME_LENGTH = "FILE_SYSTEM_NAME_LENGTH"
    EFS_FILE_LOCKS = "EFS_FILE_LOCKS"
    TAGS = "TAGS"
    FILE_SYSTEM_SYMBOLIC_LINK_SYMLINK_LENGTH = "FILE_SYSTEM_SYMBOLIC_LINK_SYMLINK_LENGTH"
    FILE_SIZE = "FILE_SIZE"
    ACCESS_POINTS_PER_FILE_SYSTEM = "ACCESS_POINTS_PER_FILE_SYSTEM"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AmazonElasticInferenceQuota")
class AmazonElasticInferenceQuota(enum.Enum):
    NUMBER_OF_ELASTIC_INFERENCE_ACCELERATORS = "NUMBER_OF_ELASTIC_INFERENCE_ACCELERATORS"


@jsii.enum(
    jsii_type="@reapit-cdk/service-quotas.AmazonElasticKubernetesServiceAmazonEksQuota"
)
class AmazonElasticKubernetesServiceAmazonEksQuota(enum.Enum):
    CONTROL_PLANE_SECURITY_GROUPS_PER_CLUSTER = "CONTROL_PLANE_SECURITY_GROUPS_PER_CLUSTER"
    EKS_ANYWHERE_ENTERPRISE_SUBSCRIPTIONS = "EKS_ANYWHERE_ENTERPRISE_SUBSCRIPTIONS"
    REGISTERED_CLUSTERS = "REGISTERED_CLUSTERS"
    NODES_PER_MANAGED_NODE_GROUP = "NODES_PER_MANAGED_NODE_GROUP"
    FARGATE_PROFILES_PER_CLUSTER = "FARGATE_PROFILES_PER_CLUSTER"
    LABEL_PAIRS_PER_FARGATE_PROFILE_SELECTOR = "LABEL_PAIRS_PER_FARGATE_PROFILE_SELECTOR"
    SELECTORS_PER_FARGATE_PROFILE = "SELECTORS_PER_FARGATE_PROFILE"
    MANAGED_NODE_GROUPS_PER_CLUSTER = "MANAGED_NODE_GROUPS_PER_CLUSTER"
    PUBLIC_ENDPOINT_ACCESS_CIDR_RANGES_PER_CLUSTER = "PUBLIC_ENDPOINT_ACCESS_CIDR_RANGES_PER_CLUSTER"
    CLUSTERS = "CLUSTERS"
    ACCESS_ENTRIES_PER_CLUSTER = "ACCESS_ENTRIES_PER_CLUSTER"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AmazonElasticTranscoderQuota")
class AmazonElasticTranscoderQuota(enum.Enum):
    USER_DEFINED_PRESETS = "USER_DEFINED_PRESETS"
    PIPELINES = "PIPELINES"
    RATE_OF_READ_JOB_REQUESTS = "RATE_OF_READ_JOB_REQUESTS"
    QUEUED_JOBS_PER_PIPELINE = "QUEUED_JOBS_PER_PIPELINE"
    BURST_SIZE_OF_READ_JOB_REQUESTS = "BURST_SIZE_OF_READ_JOB_REQUESTS"
    CONCURRENT_JOBS_PER_PIPELINE = "CONCURRENT_JOBS_PER_PIPELINE"
    RATE_OF_CREATE_JOB_REQUESTS = "RATE_OF_CREATE_JOB_REQUESTS"
    BURST_SIZE_OF_CREATE_JOB_REQUESTS = "BURST_SIZE_OF_CREATE_JOB_REQUESTS"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AmazonEmrQuota")
class AmazonEmrQuota(enum.Enum):
    THE_MAXIMUM_NUMBER_OF_ADD_INSTANCE_FLEET_API_REQUESTS_THAT_YOU_CAN_MAKE_PER_SECOND = "THE_MAXIMUM_NUMBER_OF_ADD_INSTANCE_FLEET_API_REQUESTS_THAT_YOU_CAN_MAKE_PER_SECOND"
    EMR_WAL_WORKSPACES = "EMR_WAL_WORKSPACES"
    REPLENISHMENT_RATE_OF_LIST_INSTANCE_GROUPS_CALLS = "REPLENISHMENT_RATE_OF_LIST_INSTANCE_GROUPS_CALLS"
    THE_MAXIMUM_NUMBER_OF_ADD_TAGS_API_REQUESTS_THAT_YOU_CAN_MAKE_PER_SECOND = "THE_MAXIMUM_NUMBER_OF_ADD_TAGS_API_REQUESTS_THAT_YOU_CAN_MAKE_PER_SECOND"
    REPLENISHMENT_RATE_OF_SET_VISIBLE_TO_ALL_USERS_CALLS = "REPLENISHMENT_RATE_OF_SET_VISIBLE_TO_ALL_USERS_CALLS"
    REPLENISHMENT_RATE_OF_DESCRIBE_STEP_CALLS = "REPLENISHMENT_RATE_OF_DESCRIBE_STEP_CALLS"
    REPLENISHMENT_RATE_OF_DESCRIBE_SECURITY_CONFIGURATION_CALLS = "REPLENISHMENT_RATE_OF_DESCRIBE_SECURITY_CONFIGURATION_CALLS"
    THE_MAXIMUM_NUMBER_OF_API_REQUESTS_THAT_YOU_CAN_MAKE_PER_SECOND = "THE_MAXIMUM_NUMBER_OF_API_REQUESTS_THAT_YOU_CAN_MAKE_PER_SECOND"
    THE_MAXIMUM_NUMBER_OF_MODIFY_INSTANCE_FLEET_API_REQUESTS_THAT_YOU_CAN_MAKE_PER_SECOND = "THE_MAXIMUM_NUMBER_OF_MODIFY_INSTANCE_FLEET_API_REQUESTS_THAT_YOU_CAN_MAKE_PER_SECOND"
    REPLENISHMENT_RATE_OF_SET_TERMINATION_PROTECTION_CALLS = "REPLENISHMENT_RATE_OF_SET_TERMINATION_PROTECTION_CALLS"
    THE_MAXIMUM_NUMBER_OF_LIST_INSTANCE_GROUPS_API_REQUESTS_THAT_YOU_CAN_MAKE_PER_SECOND = "THE_MAXIMUM_NUMBER_OF_LIST_INSTANCE_GROUPS_API_REQUESTS_THAT_YOU_CAN_MAKE_PER_SECOND"
    REPLENISHMENT_RATE_OF_DESCRIBE_CLUSTER_CALLS = "REPLENISHMENT_RATE_OF_DESCRIBE_CLUSTER_CALLS"
    THE_MAXIMUM_NUMBER_OF_DELETE_SECURITY_CONFIGURATION_API_REQUESTS_THAT_YOU_CAN_MAKE_PER_SECOND = "THE_MAXIMUM_NUMBER_OF_DELETE_SECURITY_CONFIGURATION_API_REQUESTS_THAT_YOU_CAN_MAKE_PER_SECOND"
    REPLENISHMENT_RATE_OF_ADD_INSTANCE_FLEET_CALLS = "REPLENISHMENT_RATE_OF_ADD_INSTANCE_FLEET_CALLS"
    REPLENISHMENT_RATE_OF_REMOVE_TAGS_CALLS = "REPLENISHMENT_RATE_OF_REMOVE_TAGS_CALLS"
    REPLENISHMENT_RATE_OF_ADD_INSTANCE_GROUPS_CALLS = "REPLENISHMENT_RATE_OF_ADD_INSTANCE_GROUPS_CALLS"
    THE_MAXIMUM_NUMBER_OF_RUN_JOB_FLOW_API_REQUESTS_THAT_YOU_CAN_MAKE_PER_SECOND = "THE_MAXIMUM_NUMBER_OF_RUN_JOB_FLOW_API_REQUESTS_THAT_YOU_CAN_MAKE_PER_SECOND"
    THE_MAXIMUM_NUMBER_OF_ADD_JOB_FLOW_STEPS_API_REQUESTS_THAT_YOU_CAN_MAKE_PER_SECOND = "THE_MAXIMUM_NUMBER_OF_ADD_JOB_FLOW_STEPS_API_REQUESTS_THAT_YOU_CAN_MAKE_PER_SECOND"
    THE_MAXIMUM_NUMBER_OF_MODIFY_INSTANCE_GROUPS_API_REQUESTS_THAT_YOU_CAN_MAKE_PER_SECOND = "THE_MAXIMUM_NUMBER_OF_MODIFY_INSTANCE_GROUPS_API_REQUESTS_THAT_YOU_CAN_MAKE_PER_SECOND"
    REPLENISHMENT_RATE_OF_LIST_INSTANCES_CALLS = "REPLENISHMENT_RATE_OF_LIST_INSTANCES_CALLS"
    THE_MAXIMUM_NUMBER_OF_PUT_AUTO_SCALING_POLICY_API_REQUESTS_THAT_YOU_CAN_MAKE_PER_SECOND = "THE_MAXIMUM_NUMBER_OF_PUT_AUTO_SCALING_POLICY_API_REQUESTS_THAT_YOU_CAN_MAKE_PER_SECOND"
    REPLENISHMENT_RATE_OF_LIST_CLUSTERS_CALLS = "REPLENISHMENT_RATE_OF_LIST_CLUSTERS_CALLS"
    REPLENISHMENT_RATE_OF_REMOVE_AUTO_SCALING_POLICY_CALLS = "REPLENISHMENT_RATE_OF_REMOVE_AUTO_SCALING_POLICY_CALLS"
    THE_MAXIMUM_NUMBER_OF_CREATE_SECURITY_CONFIGURATION_API_REQUESTS_THAT_YOU_CAN_MAKE_PER_SECOND = "THE_MAXIMUM_NUMBER_OF_CREATE_SECURITY_CONFIGURATION_API_REQUESTS_THAT_YOU_CAN_MAKE_PER_SECOND"
    REPLENISHMENT_RATE_OF_LIST_STEPS_CALLS = "REPLENISHMENT_RATE_OF_LIST_STEPS_CALLS"
    REPLENISHMENT_RATE_OF_ADD_TAGS_CALLS = "REPLENISHMENT_RATE_OF_ADD_TAGS_CALLS"
    THE_MAXIMUM_NUMBER_OF_LIST_INSTANCE_FLEETS_API_REQUESTS_THAT_YOU_CAN_MAKE_PER_SECOND = "THE_MAXIMUM_NUMBER_OF_LIST_INSTANCE_FLEETS_API_REQUESTS_THAT_YOU_CAN_MAKE_PER_SECOND"
    REPLENISHMENT_RATE_OF_LIST_BOOTSTRAP_ACTIONS_CALLS = "REPLENISHMENT_RATE_OF_LIST_BOOTSTRAP_ACTIONS_CALLS"
    REPLENISHMENT_RATE_OF_CREATE_SECURITY_CONFIGURATION_CALLS = "REPLENISHMENT_RATE_OF_CREATE_SECURITY_CONFIGURATION_CALLS"
    REPLENISHMENT_RATE_OF_DESCRIBE_JOB_FLOWS_CALLS = "REPLENISHMENT_RATE_OF_DESCRIBE_JOB_FLOWS_CALLS"
    THE_MAXIMUM_NUMBER_OF_LIST_CLUSTERS_API_REQUESTS_THAT_YOU_CAN_MAKE_PER_SECOND = "THE_MAXIMUM_NUMBER_OF_LIST_CLUSTERS_API_REQUESTS_THAT_YOU_CAN_MAKE_PER_SECOND"
    THE_MAXIMUM_NUMBER_OF_ACTIVE_INSTANCES_PER_INSTANCE_GROUP = "THE_MAXIMUM_NUMBER_OF_ACTIVE_INSTANCES_PER_INSTANCE_GROUP"
    THE_MAXIMUM_NUMBER_OF_ACTIVE_CLUSTERS_CAN_BE_RUN_AT_THE_SAME_TIME = "THE_MAXIMUM_NUMBER_OF_ACTIVE_CLUSTERS_CAN_BE_RUN_AT_THE_SAME_TIME"
    THE_MAXIMUM_NUMBER_OF_LIST_INSTANCES_API_REQUESTS_THAT_YOU_CAN_MAKE_PER_SECOND = "THE_MAXIMUM_NUMBER_OF_LIST_INSTANCES_API_REQUESTS_THAT_YOU_CAN_MAKE_PER_SECOND"
    WRITE_AHEAD_LOGS_EMR_WAL = "WRITE_AHEAD_LOGS_EMR_WAL"
    THE_MAXIMUM_NUMBER_OF_REMOVE_TAGS_API_REQUESTS_THAT_YOU_CAN_MAKE_PER_SECOND = "THE_MAXIMUM_NUMBER_OF_REMOVE_TAGS_API_REQUESTS_THAT_YOU_CAN_MAKE_PER_SECOND"
    REPLENISHMENT_RATE_OF_PUT_AUTO_SCALING_POLICY_CALLS = "REPLENISHMENT_RATE_OF_PUT_AUTO_SCALING_POLICY_CALLS"
    REPLENISHMENT_RATE_OF_MODIFY_CLUSTER_CALLS = "REPLENISHMENT_RATE_OF_MODIFY_CLUSTER_CALLS"
    THE_MAXIMUM_NUMBER_OF_CANCEL_STEPS_API_REQUESTS_THAT_YOU_CAN_MAKE_PER_SECOND = "THE_MAXIMUM_NUMBER_OF_CANCEL_STEPS_API_REQUESTS_THAT_YOU_CAN_MAKE_PER_SECOND"
    REPLENISHMENT_RATE_OF_MODIFY_INSTANCE_FLEET_CALLS = "REPLENISHMENT_RATE_OF_MODIFY_INSTANCE_FLEET_CALLS"
    THE_MAXIMUM_NUMBER_OF_LIST_STEPS_API_REQUESTS_THAT_YOU_CAN_MAKE_PER_SECOND = "THE_MAXIMUM_NUMBER_OF_LIST_STEPS_API_REQUESTS_THAT_YOU_CAN_MAKE_PER_SECOND"
    THE_MAXIMUM_NUMBER_OF_TERMINATE_JOB_FLOWS_API_REQUESTS_THAT_YOU_CAN_MAKE_PER_SECOND = "THE_MAXIMUM_NUMBER_OF_TERMINATE_JOB_FLOWS_API_REQUESTS_THAT_YOU_CAN_MAKE_PER_SECOND"
    THE_MAXIMUM_RATE_AT_WHICH_YOUR_BUCKET_REPLENISHES_FOR_ALL_EMR_OPERATIONS = "THE_MAXIMUM_RATE_AT_WHICH_YOUR_BUCKET_REPLENISHES_FOR_ALL_EMR_OPERATIONS"
    REPLENISHMENT_RATE_OF_MODIFY_INSTANCE_GROUPS_CALLS = "REPLENISHMENT_RATE_OF_MODIFY_INSTANCE_GROUPS_CALLS"
    THE_MAXIMUM_NUMBER_OF_SET_TERMINATION_PROTECTION_API_REQUESTS_THAT_YOU_CAN_MAKE_PER_SECOND = "THE_MAXIMUM_NUMBER_OF_SET_TERMINATION_PROTECTION_API_REQUESTS_THAT_YOU_CAN_MAKE_PER_SECOND"
    THE_MAXIMUM_NUMBER_OF_MODIFY_CLUSTER_API_REQUESTS_THAT_YOU_CAN_MAKE_PER_SECOND = "THE_MAXIMUM_NUMBER_OF_MODIFY_CLUSTER_API_REQUESTS_THAT_YOU_CAN_MAKE_PER_SECOND"
    THE_MAXIMUM_NUMBER_OF_DESCRIBE_SECURITY_CONFIGURATION_API_REQUESTS_THAT_YOU_CAN_MAKE_PER_SECOND = "THE_MAXIMUM_NUMBER_OF_DESCRIBE_SECURITY_CONFIGURATION_API_REQUESTS_THAT_YOU_CAN_MAKE_PER_SECOND"
    THE_MAXIMUM_NUMBER_OF_DESCRIBE_STEP_API_REQUESTS_THAT_YOU_CAN_MAKE_PER_SECOND = "THE_MAXIMUM_NUMBER_OF_DESCRIBE_STEP_API_REQUESTS_THAT_YOU_CAN_MAKE_PER_SECOND"
    REPLENISHMENT_RATE_OF_TERMINATE_JOB_FLOWS_CALLS = "REPLENISHMENT_RATE_OF_TERMINATE_JOB_FLOWS_CALLS"
    THE_MAXIMUM_NUMBER_OF_DESCRIBE_CLUSTER_API_REQUESTS_THAT_YOU_CAN_MAKE_PER_SECOND = "THE_MAXIMUM_NUMBER_OF_DESCRIBE_CLUSTER_API_REQUESTS_THAT_YOU_CAN_MAKE_PER_SECOND"
    THE_MAXIMUM_NUMBER_OF_LIST_SECURITY_CONFIGURATIONS_API_REQUESTS_THAT_YOU_CAN_MAKE_PER_SECOND = "THE_MAXIMUM_NUMBER_OF_LIST_SECURITY_CONFIGURATIONS_API_REQUESTS_THAT_YOU_CAN_MAKE_PER_SECOND"
    REPLENISHMENT_RATE_OF_LIST_SECURITY_CONFIGURATIONS_CALLS = "REPLENISHMENT_RATE_OF_LIST_SECURITY_CONFIGURATIONS_CALLS"
    THE_MAXIMUM_NUMBER_OF_DESCRIBE_JOB_FLOWS_API_REQUESTS_THAT_YOU_CAN_MAKE_PER_SECOND = "THE_MAXIMUM_NUMBER_OF_DESCRIBE_JOB_FLOWS_API_REQUESTS_THAT_YOU_CAN_MAKE_PER_SECOND"
    REPLENISHMENT_RATE_OF_LIST_INSTANCE_FLEETS_CALLS = "REPLENISHMENT_RATE_OF_LIST_INSTANCE_FLEETS_CALLS"
    THE_MAXIMUM_NUMBER_OF_LIST_BOOTSTRAP_ACTIONS_API_REQUESTS_THAT_YOU_CAN_MAKE_PER_SECOND = "THE_MAXIMUM_NUMBER_OF_LIST_BOOTSTRAP_ACTIONS_API_REQUESTS_THAT_YOU_CAN_MAKE_PER_SECOND"
    REPLENISHMENT_RATE_OF_ADD_JOB_FLOW_STEPS_CALLS = "REPLENISHMENT_RATE_OF_ADD_JOB_FLOW_STEPS_CALLS"
    REPLENISHMENT_RATE_OF_CANCEL_STEPS_CALLS = "REPLENISHMENT_RATE_OF_CANCEL_STEPS_CALLS"
    REPLENISHMENT_RATE_OF_DELETE_SECURITY_CONFIGURATION_CALLS = "REPLENISHMENT_RATE_OF_DELETE_SECURITY_CONFIGURATION_CALLS"
    THE_MAXIMUM_NUMBER_OF_REMOVE_AUTO_SCALING_POLICY_API_REQUESTS_THAT_YOU_CAN_MAKE_PER_SECOND = "THE_MAXIMUM_NUMBER_OF_REMOVE_AUTO_SCALING_POLICY_API_REQUESTS_THAT_YOU_CAN_MAKE_PER_SECOND"
    THE_MAXIMUM_NUMBER_OF_ADD_INSTANCE_GROUPS_API_REQUESTS_THAT_YOU_CAN_MAKE_PER_SECOND = "THE_MAXIMUM_NUMBER_OF_ADD_INSTANCE_GROUPS_API_REQUESTS_THAT_YOU_CAN_MAKE_PER_SECOND"
    REPLENISHMENT_RATE_OF_RUN_JOB_FLOW_CALLS = "REPLENISHMENT_RATE_OF_RUN_JOB_FLOW_CALLS"
    THE_MAXIMUM_NUMBER_OF_SET_VISIBILE_TO_ALL_USERS_API_REQUESTS_THAT_YOU_CAN_MAKE_PER_SECOND = "THE_MAXIMUM_NUMBER_OF_SET_VISIBILE_TO_ALL_USERS_API_REQUESTS_THAT_YOU_CAN_MAKE_PER_SECOND"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AmazonEmrServerlessQuota")
class AmazonEmrServerlessQuota(enum.Enum):
    MAX_CONCURRENT_V_CP_US_PER_ACCOUNT = "MAX_CONCURRENT_V_CP_US_PER_ACCOUNT"


@jsii.enum(
    jsii_type="@reapit-cdk/service-quotas.AmazonEventBridgeCloudWatchEventsQuota"
)
class AmazonEventBridgeCloudWatchEventsQuota(enum.Enum):
    THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    EVENT_PATTERN_SIZE = "EVENT_PATTERN_SIZE"
    INVOCATIONS_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "INVOCATIONS_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    CREATE_ENDPOINT_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "CREATE_ENDPOINT_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    RATE_OF_INVOCATIONS_PER_API_DESTINATION = "RATE_OF_INVOCATIONS_PER_API_DESTINATION"
    NUMBER_OF_RULES = "NUMBER_OF_RULES"
    EVENT_BUS_POLICY_SIZE = "EVENT_BUS_POLICY_SIZE"
    EVENT_BUSES = "EVENT_BUSES"
    API_DESTINATIONS = "API_DESTINATIONS"
    PUT_EVENTS_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "PUT_EVENTS_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    CONNECTIONS = "CONNECTIONS"
    DELETE_ENDPOINT_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "DELETE_ENDPOINT_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    ENDPOINTS = "ENDPOINTS"
    TARGETS_PER_RULE = "TARGETS_PER_RULE"
    UPDATE_ENDPOINT_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "UPDATE_ENDPOINT_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AmazonEventBridgeSchedulerQuota")
class AmazonEventBridgeSchedulerQuota(enum.Enum):
    NUMBER_OF_SCHEDULES = "NUMBER_OF_SCHEDULES"
    CREATE_SCHEDULE_REQUEST_RATE = "CREATE_SCHEDULE_REQUEST_RATE"
    GET_SCHEDULE_REQUEST_RATE = "GET_SCHEDULE_REQUEST_RATE"
    LIST_SCHEDULES_REQUEST_RATE = "LIST_SCHEDULES_REQUEST_RATE"
    UPDATE_SCHEDULE_REQUEST_RATE = "UPDATE_SCHEDULE_REQUEST_RATE"
    LIST_TAGS_FOR_RESOURCE_REQUEST_RATE = "LIST_TAGS_FOR_RESOURCE_REQUEST_RATE"
    DELETE_SCHEDULE_REQUEST_RATE = "DELETE_SCHEDULE_REQUEST_RATE"
    INVOCATIONS_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "INVOCATIONS_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    NUMBER_OF_SCHEDULE_GROUPS = "NUMBER_OF_SCHEDULE_GROUPS"
    LIST_SCHEDULE_GROUPS_REQUEST_RATE = "LIST_SCHEDULE_GROUPS_REQUEST_RATE"
    GET_SCHEDULE_GROUP_REQUEST_RATE = "GET_SCHEDULE_GROUP_REQUEST_RATE"
    CREATE_SCHEDULE_GROUP_REQUEST_RATE = "CREATE_SCHEDULE_GROUP_REQUEST_RATE"
    UNTAG_RESOURCE_REQUEST_RATE = "UNTAG_RESOURCE_REQUEST_RATE"
    TAG_RESOURCE_REQUEST_RATE = "TAG_RESOURCE_REQUEST_RATE"
    DELETE_SCHEDULE_GROUP_REQUEST_RATE = "DELETE_SCHEDULE_GROUP_REQUEST_RATE"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AmazonEventBridgeSchemaRegistryQuota")
class AmazonEventBridgeSchemaRegistryQuota(enum.Enum):
    SCHEMA_VERSIONS = "SCHEMA_VERSIONS"
    REGISTRIES = "REGISTRIES"
    DISCOVERED_SCHEMAS = "DISCOVERED_SCHEMAS"
    SCHEMAS = "SCHEMAS"
    DISCOVERERS = "DISCOVERERS"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AmazonFSxQuota")
class AmazonFSxQuota(enum.Enum):
    LUSTRE_SCRATCH_FILE_SYSTEMS = "LUSTRE_SCRATCH_FILE_SYSTEMS"
    LUSTRE_PERSISTENT_1_FILE_SYSTEMS = "LUSTRE_PERSISTENT_1_FILE_SYSTEMS"
    OPEN_ZFS_BACKUPS = "OPEN_ZFS_BACKUPS"
    LUSTRE_CACHE_1_STORAGE_CAPACITY = "LUSTRE_CACHE_1_STORAGE_CAPACITY"
    LUSTRE_BACKUPS = "LUSTRE_BACKUPS"
    WINDOWS_BACKUPS = "WINDOWS_BACKUPS"
    ONTAP_THROUGHPUT_CAPACITY = "ONTAP_THROUGHPUT_CAPACITY"
    WINDOWS_FILE_SYSTEMS = "WINDOWS_FILE_SYSTEMS"
    ONTAP_FILE_SYSTEMS = "ONTAP_FILE_SYSTEMS"
    WINDOWS_TOTAL_SSD_IOPS = "WINDOWS_TOTAL_SSD_IOPS"
    OPEN_ZFS_FILE_SYSTEMS = "OPEN_ZFS_FILE_SYSTEMS"
    LUSTRE_PERSISTENT_HDD_STORAGE_CAPACITY_PER_FILE_SYSTEM = "LUSTRE_PERSISTENT_HDD_STORAGE_CAPACITY_PER_FILE_SYSTEM"
    LUSTRE_CACHE_1_CACHES = "LUSTRE_CACHE_1_CACHES"
    ONTAP_SSD_IOPS = "ONTAP_SSD_IOPS"
    LUSTRE_PERSISTENT_2_FILE_SYSTEMS = "LUSTRE_PERSISTENT_2_FILE_SYSTEMS"
    LUSTRE_PERSISTENT_1_STORAGE_CAPACITY = "LUSTRE_PERSISTENT_1_STORAGE_CAPACITY"
    OPEN_ZFS_SSD_STORAGE_CAPACITY = "OPEN_ZFS_SSD_STORAGE_CAPACITY"
    WINDOWS_THROUGHPUT_CAPACITY = "WINDOWS_THROUGHPUT_CAPACITY"
    OPEN_ZFS_SSD_STORAGE_CAPACITY_PER_FILE_SYSTEM = "OPEN_ZFS_SSD_STORAGE_CAPACITY_PER_FILE_SYSTEM"
    LUSTRE_SCRATCH_STORAGE_CAPACITY = "LUSTRE_SCRATCH_STORAGE_CAPACITY"
    ONTAP_SSD_STORAGE_CAPACITY = "ONTAP_SSD_STORAGE_CAPACITY"
    WINDOWS_HDD_STORAGE_CAPACITY = "WINDOWS_HDD_STORAGE_CAPACITY"
    WINDOWS_SSD_STORAGE_CAPACITY = "WINDOWS_SSD_STORAGE_CAPACITY"
    OPEN_ZFS_DISK_IOPS = "OPEN_ZFS_DISK_IOPS"
    ONTAP_BACKUPS = "ONTAP_BACKUPS"
    LUSTRE_PERSISTENT_2_STORAGE_CAPACITY = "LUSTRE_PERSISTENT_2_STORAGE_CAPACITY"
    OPEN_ZFS_THROUGHPUT_CAPACITY = "OPEN_ZFS_THROUGHPUT_CAPACITY"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AmazonFinSpaceQuota")
class AmazonFinSpaceQuota(enum.Enum):
    KX_S_2XLARGE_NODES = "KX_S_2XLARGE_NODES"
    TOTAL_KDB_ENVIRONMENTS = "TOTAL_KDB_ENVIRONMENTS"
    KX_SG_4XLARGE_SCALING_GROUP_NODES = "KX_SG_4XLARGE_SCALING_GROUP_NODES"
    MANAGED_KDB_VOLUME_WRITE_MOUNTS = "MANAGED_KDB_VOLUME_WRITE_MOUNTS"
    KX_SG_32XLARGE_SCALING_GROUP_NODES = "KX_SG_32XLARGE_SCALING_GROUP_NODES"
    KX_S_8XLARGE_NODES = "KX_S_8XLARGE_NODES"
    KX_SG_8XLARGE_SCALING_GROUP_NODES = "KX_SG_8XLARGE_SCALING_GROUP_NODES"
    KX_S_4XLARGE_NODES = "KX_S_4XLARGE_NODES"
    MANAGED_KDB_CLUSTER_USERS = "MANAGED_KDB_CLUSTER_USERS"
    MANAGED_KDB_SCALING_GROUPS = "MANAGED_KDB_SCALING_GROUPS"
    KX_S_XLARGE_NODES = "KX_S_XLARGE_NODES"
    MANAGED_KDB_VOLUMES = "MANAGED_KDB_VOLUMES"
    MANAGED_KDB_CONCURRENT_CHANGESET_INGESTIONS = "MANAGED_KDB_CONCURRENT_CHANGESET_INGESTIONS"
    KX_S_16XLARGE_NODES = "KX_S_16XLARGE_NODES"
    KX_SG1_24XLARGE_SCALING_GROUP_NODES = "KX_SG1_24XLARGE_SCALING_GROUP_NODES"
    MANAGED_KDB_SAVEDOWN_STORAGE = "MANAGED_KDB_SAVEDOWN_STORAGE"
    MANAGED_KDB_VOLUME_READ_MOUNTS = "MANAGED_KDB_VOLUME_READ_MOUNTS"
    MANAGED_KDB_CLUSTERS = "MANAGED_KDB_CLUSTERS"
    MANAGED_KDB_DATAVIEWS = "MANAGED_KDB_DATAVIEWS"
    MANAGED_KDB_DATABASES = "MANAGED_KDB_DATABASES"
    MANAGED_KDB_DATABASE_CLUSTER_CACHE_SIZE = "MANAGED_KDB_DATABASE_CLUSTER_CACHE_SIZE"
    MANAGED_KDB_VOLUME_STORAGE = "MANAGED_KDB_VOLUME_STORAGE"
    CONCURRENT_DATAVIEW_VERSION_PROCESSING = "CONCURRENT_DATAVIEW_VERSION_PROCESSING"
    KX_SG1_16XLARGE_SCALING_GROUP_NODES = "KX_SG1_16XLARGE_SCALING_GROUP_NODES"
    MANAGED_KDB_MULTI_AZ_CLUSTERS = "MANAGED_KDB_MULTI_AZ_CLUSTERS"
    KX_S_32XLARGE_NODES = "KX_S_32XLARGE_NODES"
    MANAGED_KDB_SINGLE_AZ_CLUSTERS = "MANAGED_KDB_SINGLE_AZ_CLUSTERS"
    KX_SG_16XLARGE_SCALING_GROUP_NODES = "KX_SG_16XLARGE_SCALING_GROUP_NODES"
    KX_S_LARGE_NODES = "KX_S_LARGE_NODES"
    CONTROLLED_VOCABULARIES_AND_CATEGORIES = "CONTROLLED_VOCABULARIES_AND_CATEGORIES"
    DATA_VIEWS_PER_DATASET = "DATA_VIEWS_PER_DATASET"
    USERS = "USERS"
    CLUSTERS_PER_USER = "CLUSTERS_PER_USER"
    PERMISSION_GROUPS = "PERMISSION_GROUPS"
    NOTEBOOK_STORAGE = "NOTEBOOK_STORAGE"
    DATASETS = "DATASETS"
    FILES_PER_CHANGESET = "FILES_PER_CHANGESET"
    DATASETS_PER_PERMISSION_GROUP = "DATASETS_PER_PERMISSION_GROUP"
    CONCURRENT_DATA_VIEWS_PROCESSING = "CONCURRENT_DATA_VIEWS_PROCESSING"
    CONCURRENT_CHANGESETS_PROCESSING = "CONCURRENT_CHANGESETS_PROCESSING"
    FILE_SIZE_PER_CHANGESET = "FILE_SIZE_PER_CHANGESET"
    ENVIRONMENTS = "ENVIRONMENTS"
    ATTRIBUTE_SETS = "ATTRIBUTE_SETS"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AmazonForecastQuota")
class AmazonForecastQuota(enum.Enum):
    MAXIMUM_NUMBER_OF_COLUMNS_IN_AN_ITEM_METADATA_DATASET = "MAXIMUM_NUMBER_OF_COLUMNS_IN_AN_ITEM_METADATA_DATASET"
    MAXIMUM_NUMBER_OF_PREDICTOR_BACKTEST_EXPORT_JOBS = "MAXIMUM_NUMBER_OF_PREDICTOR_BACKTEST_EXPORT_JOBS"
    MAXIMUM_NUMBER_OF_DATASETS = "MAXIMUM_NUMBER_OF_DATASETS"
    THE_MAXIMUM_NUMBER_OF_WHAT_IF_ANALYSES = "THE_MAXIMUM_NUMBER_OF_WHAT_IF_ANALYSES"
    MAXIMUM_PARALLEL_RUNNING_CREATE_PREDICTOR_TASKS_USING_AUTO_ML = "MAXIMUM_PARALLEL_RUNNING_CREATE_PREDICTOR_TASKS_USING_AUTO_ML"
    MAXIMUM_PARALLEL_RUNNING_CREATE_FORECAST_TASKS = "MAXIMUM_PARALLEL_RUNNING_CREATE_FORECAST_TASKS"
    MAXIMUM_NUMBER_OF_DATASETS_IN_A_DATASET_GROUP = "MAXIMUM_NUMBER_OF_DATASETS_IN_A_DATASET_GROUP"
    MAXIMUM_NUMBER_OF_TAGS_YOU_CAN_ADD_TO_A_RESOURCE = "MAXIMUM_NUMBER_OF_TAGS_YOU_CAN_ADD_TO_A_RESOURCE"
    MAXIMUM_PARALLEL_RUNNING_CREATE_FORECAST_EXPORT_JOB_TASKS = "MAXIMUM_PARALLEL_RUNNING_CREATE_FORECAST_EXPORT_JOB_TASKS"
    MAXIMUM_NUMBER_OF_PREDICTORS = "MAXIMUM_NUMBER_OF_PREDICTORS"
    MAXIMUM_PARALLEL_RUNNING_CREATE_WHAT_IF_ANALYSIS_TASKS = "MAXIMUM_PARALLEL_RUNNING_CREATE_WHAT_IF_ANALYSIS_TASKS"
    MAXIMUM_NUMBER_OF_COLUMNS_IN_A_TARGET_TIME_SERIES_DATASET = "MAXIMUM_NUMBER_OF_COLUMNS_IN_A_TARGET_TIME_SERIES_DATASET"
    THE_MAXIMUM_NUMBER_OF_WHAT_IF_FORECASTS = "THE_MAXIMUM_NUMBER_OF_WHAT_IF_FORECASTS"
    MAXIMUM_NUMBER_OF_FILES_IN_YOUR_AMAZON_S3_BUCKET = "MAXIMUM_NUMBER_OF_FILES_IN_YOUR_AMAZON_S3_BUCKET"
    MAXIMUM_TIME_FOR_WHICH_A_FORECAST_CAN_BE_QUERIED_ON_CONSOLE_OR_QUERY_FORECAST_API = "MAXIMUM_TIME_FOR_WHICH_A_FORECAST_CAN_BE_QUERIED_ON_CONSOLE_OR_QUERY_FORECAST_API"
    MAXIMUM_PARALLEL_RUNNING_QUERY_FORECAST_API_TASKS = "MAXIMUM_PARALLEL_RUNNING_QUERY_FORECAST_API_TASKS"
    MAXIMUM_NUMBER_OF_BACKTEST_WINDOWS = "MAXIMUM_NUMBER_OF_BACKTEST_WINDOWS"
    MAXIMUM_NUMBER_OF_FORECAST_EXPORT_JOBS = "MAXIMUM_NUMBER_OF_FORECAST_EXPORT_JOBS"
    MAXIMUM_NUMBER_OF_DATASET_GROUPS = "MAXIMUM_NUMBER_OF_DATASET_GROUPS"
    MAXIMUM_PARALLEL_RUNNING_CREATE_DATASET_IMPORT_JOB_TASKS = "MAXIMUM_PARALLEL_RUNNING_CREATE_DATASET_IMPORT_JOB_TASKS"
    MAXIMUM_NUMBER_OF_ROWS_IN_A_DATASET = "MAXIMUM_NUMBER_OF_ROWS_IN_A_DATASET"
    THE_MAXIMUM_NUMBER_OF_WHAT_IF_FORECASTS_IN_A_CREATE_WHAT_IF_FORECAST_EXPORT_TASK = "THE_MAXIMUM_NUMBER_OF_WHAT_IF_FORECASTS_IN_A_CREATE_WHAT_IF_FORECAST_EXPORT_TASK"
    MAXIMUM_PARALLEL_RUNNING_CREATE_WHAT_IF_FORECAST_TASKS = "MAXIMUM_PARALLEL_RUNNING_CREATE_WHAT_IF_FORECAST_TASKS"
    MAXIMUM_PARALLEL_RUNNING_CREATE_PREDICTOR_BACKTEST_EXPORT_JOB_TASKS = "MAXIMUM_PARALLEL_RUNNING_CREATE_PREDICTOR_BACKTEST_EXPORT_JOB_TASKS"
    THE_MAXIMUM_NUMBER_OF_WHAT_IF_FORECAST_EXPORTS = "THE_MAXIMUM_NUMBER_OF_WHAT_IF_FORECAST_EXPORTS"
    MAXIMUM_NUMBER_OF_TIME_SERIES_PER_PREDICTOR = "MAXIMUM_NUMBER_OF_TIME_SERIES_PER_PREDICTOR"
    MAXIMUM_NUMBER_OF_DATASET_IMPORT_JOBS = "MAXIMUM_NUMBER_OF_DATASET_IMPORT_JOBS"
    MAXIMUM_NUMBER_OF_FORECASTS = "MAXIMUM_NUMBER_OF_FORECASTS"
    MAXIMUM_FORECAST_HORIZON = "MAXIMUM_FORECAST_HORIZON"
    MAXIMUM_NUMBER_OF_COLUMNS_IN_A_RELATED_TIME_SERIES_DATASET = "MAXIMUM_NUMBER_OF_COLUMNS_IN_A_RELATED_TIME_SERIES_DATASET"
    MAXIMUM_PARALLEL_RUNNING_CREATE_WHAT_IF_FORECAST_EXPORT_TASKS = "MAXIMUM_PARALLEL_RUNNING_CREATE_WHAT_IF_FORECAST_EXPORT_TASKS"
    MAXIMUM_CUMULATIVE_SIZE_OF_ALL_FILES_IN_YOUR_AMAZON_S3_BUCKET = "MAXIMUM_CUMULATIVE_SIZE_OF_ALL_FILES_IN_YOUR_AMAZON_S3_BUCKET"
    MAXIMUM_PARALLEL_RUNNING_CREATE_PREDICTOR_TASKS = "MAXIMUM_PARALLEL_RUNNING_CREATE_PREDICTOR_TASKS"
    THE_MAXIMUM_NUMBER_OF_AUTO_PREDICTORS = "THE_MAXIMUM_NUMBER_OF_AUTO_PREDICTORS"
    MAXIMUM_PARALLEL_RUNNING_CREATE_EXPLAINABILITY_TASKS = "MAXIMUM_PARALLEL_RUNNING_CREATE_EXPLAINABILITY_TASKS"
    MAXIMUM_PARALLEL_RUNNING_CREATE_AUTO_PREDICTOR_TASKS = "MAXIMUM_PARALLEL_RUNNING_CREATE_AUTO_PREDICTOR_TASKS"
    MAXIMUM_PARALLEL_RUNNING_CREATE_EXPLAINABILITY_EXPORT_TASKS = "MAXIMUM_PARALLEL_RUNNING_CREATE_EXPLAINABILITY_EXPORT_TASKS"
    MAXIMUM_NUMBER_OF_EXPLAINABILITY_EXPORTS = "MAXIMUM_NUMBER_OF_EXPLAINABILITY_EXPORTS"
    MAXIMUM_PARALLEL_RUNNING_STOP_JOBS_PER_RESOURCE_TYPE = "MAXIMUM_PARALLEL_RUNNING_STOP_JOBS_PER_RESOURCE_TYPE"
    MAXIMUM_NUMBER_OF_EXPLAINABILITIES = "MAXIMUM_NUMBER_OF_EXPLAINABILITIES"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AmazonFraudDetectorQuota")
class AmazonFraudDetectorQuota(enum.Enum):
    MODELS_PER_ACCOUNT = "MODELS_PER_ACCOUNT"
    OUTCOMES_PER_ACCOUNT = "OUTCOMES_PER_ACCOUNT"
    VERSIONS_PER_MODEL = "VERSIONS_PER_MODEL"
    DEPLOYED_MODEL_VERSIONS = "DEPLOYED_MODEL_VERSIONS"
    SIZE_OF_GET_PREDICTION_REQUESTS = "SIZE_OF_GET_PREDICTION_REQUESTS"
    RATE_OF_GET_PREDICTION_REQUESTS = "RATE_OF_GET_PREDICTION_REQUESTS"
    MODELS_INCLUDING_EXTERNAL_MODELS_PER_DETECTOR_VERSION = "MODELS_INCLUDING_EXTERNAL_MODELS_PER_DETECTOR_VERSION"
    TRAINING_DATA_SIZE = "TRAINING_DATA_SIZE"
    VARIABLES_PER_ACCOUNT = "VARIABLES_PER_ACCOUNT"
    DETECTORS_PER_ACCOUNT = "DETECTORS_PER_ACCOUNT"
    VERSIONS_PER_DETECTOR = "VERSIONS_PER_DETECTOR"
    TOTAL_CONCURRENT_TRAINING_JOBS = "TOTAL_CONCURRENT_TRAINING_JOBS"
    RULES_PER_ACCOUNT = "RULES_PER_ACCOUNT"
    CONCURRENT_TRAINING_JOBS_PER_MODEL = "CONCURRENT_TRAINING_JOBS_PER_MODEL"
    LISTS_PER_ACCOUNT = "LISTS_PER_ACCOUNT"
    LABELS_PER_ACCOUNT = "LABELS_PER_ACCOUNT"
    EVENT_TYPE_PER_ACCOUNT = "EVENT_TYPE_PER_ACCOUNT"
    ENTITY_TYPE_PER_ACCOUNT = "ENTITY_TYPE_PER_ACCOUNT"
    TOTAL_CONCURRENT_EVENT_TYPE_STATISTICS_UPDATE_OPERATIONS = "TOTAL_CONCURRENT_EVENT_TYPE_STATISTICS_UPDATE_OPERATIONS"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AmazonGameLiftQuota")
class AmazonGameLiftQuota(enum.Enum):
    QUEUE_DESTINATIONS_PER_GAME_SESSION_QUEUE = "QUEUE_DESTINATIONS_PER_GAME_SESSION_QUEUE"
    COMPUTE_PER_ANYWHERE_FLEET = "COMPUTE_PER_ANYWHERE_FLEET"
    SCRIPT_CAPACITY = "SCRIPT_CAPACITY"
    CUSTOM_LOCATIONS_PER_REGION = "CUSTOM_LOCATIONS_PER_REGION"
    GAME_SERVER_GROUPS_PER_REGION = "GAME_SERVER_GROUPS_PER_REGION"
    SERVER_PROCESSES_PER_INSTANCE_GAME_LIFT_SDK_V3_AND_UP = "SERVER_PROCESSES_PER_INSTANCE_GAME_LIFT_SDK_V3_AND_UP"
    MATCHMAKING_RULE_SETS_PER_REGION = "MATCHMAKING_RULE_SETS_PER_REGION"
    MATCHMAKING_CONFIGURATIONS_PER_REGION = "MATCHMAKING_CONFIGURATIONS_PER_REGION"
    ALIASES_PER_REGION = "ALIASES_PER_REGION"
    KEY_VALUE_PAIRS_PER_STRING_TO_DOUBLE_MAP_MATCHMAKING_PLAYER_ATTRIBUTE = "KEY_VALUE_PAIRS_PER_STRING_TO_DOUBLE_MAP_MATCHMAKING_PLAYER_ATTRIBUTE"
    PLAYER_SESSION_TIMEOUT = "PLAYER_SESSION_TIMEOUT"
    GAME_SERVERS_PER_GAME_SERVER_GROUP = "GAME_SERVERS_PER_GAME_SERVER_GROUP"
    BUILDS_PER_REGION = "BUILDS_PER_REGION"
    STRINGS_PER_STRING_LIST_MATCHMAKING_PLAYER_ATTRIBUTE = "STRINGS_PER_STRING_LIST_MATCHMAKING_PLAYER_ATTRIBUTE"
    MAXIMUM_NEW_GAME_SESSIONS_PER_CREATOR_PER_FLEET_CONFIGURATION = "MAXIMUM_NEW_GAME_SESSIONS_PER_CREATOR_PER_FLEET_CONFIGURATION"
    SCRIPTS_PER_REGION = "SCRIPTS_PER_REGION"
    PLAYER_ATTRIBUTES_PER_MATCHMAKING_PLAYER = "PLAYER_ATTRIBUTES_PER_MATCHMAKING_PLAYER"
    MAXIMUM_POLICY_PERIOD_IN_MINUTES_PER_FLEET_CONFIGURATION = "MAXIMUM_POLICY_PERIOD_IN_MINUTES_PER_FLEET_CONFIGURATION"
    PLAYERS_PER_MATCHMAKING_TICKET = "PLAYERS_PER_MATCHMAKING_TICKET"
    PLAYER_SESSIONS_PER_GAME_SESSION = "PLAYER_SESSIONS_PER_GAME_SESSION"
    MANAGED_EC2_FLEET_EBS_VOLUME = "MANAGED_EC2_FLEET_EBS_VOLUME"
    MANAGED_EC2_FLEETS_PER_REGION = "MANAGED_EC2_FLEETS_PER_REGION"
    BUILD_CAPACITY = "BUILD_CAPACITY"
    GAME_SESSION_LOG_FILE_SIZE = "GAME_SESSION_LOG_FILE_SIZE"
    GAME_SESSION_QUEUES_PER_REGION = "GAME_SESSION_QUEUES_PER_REGION"
    ANYWHERE_FLEETS_PER_REGION = "ANYWHERE_FLEETS_PER_REGION"
    LOCATIONS_IN_A_FLEET_PER_REGION = "LOCATIONS_IN_A_FLEET_PER_REGION"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AmazonGlacierQuota")
class AmazonGlacierQuota(enum.Enum):
    MULTIPART_PARTS_SIZE = "MULTIPART_PARTS_SIZE"
    NUMBER_OF_RANDOM_RESTORE_REQUESTS = "NUMBER_OF_RANDOM_RESTORE_REQUESTS"
    VAULTS_PER_ACCOUNT = "VAULTS_PER_ACCOUNT"
    NUMBER_OF_VAULT_TAGS = "NUMBER_OF_VAULT_TAGS"
    ARCHIVE_SIZE = "ARCHIVE_SIZE"
    NUMBER_OF_MULTIPART_PARTS = "NUMBER_OF_MULTIPART_PARTS"
    PROVISIONED_CAPACITY_UNITS = "PROVISIONED_CAPACITY_UNITS"
    ARCHIVE_SIZE_IN_GB = "ARCHIVE_SIZE_IN_GB"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AmazonGuardDutyQuota")
class AmazonGuardDutyQuota(enum.Enum):
    THREAT_INTEL_SETS = "THREAT_INTEL_SETS"
    FILTERS = "FILTERS"
    DETECTORS = "DETECTORS"
    MEMBER_ACCOUNTS_THROUGH_AWS_ORGANIZATIONS = "MEMBER_ACCOUNTS_THROUGH_AWS_ORGANIZATIONS"
    FINDING_RETENTION_PERIOD = "FINDING_RETENTION_PERIOD"
    TRUSTED_IP_SETS = "TRUSTED_IP_SETS"
    MEMBER_ACCOUNTS_BY_INVITATION = "MEMBER_ACCOUNTS_BY_INVITATION"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AmazonInspectorClassicQuota")
class AmazonInspectorClassicQuota(enum.Enum):
    INSTANCES_IN_RUNNING_ASSESSMENTS = "INSTANCES_IN_RUNNING_ASSESSMENTS"
    ASSESSMENT_TARGETS = "ASSESSMENT_TARGETS"
    ASSESSMENT_RUNS = "ASSESSMENT_RUNS"
    ASSESSMENT_TEMPLATES = "ASSESSMENT_TEMPLATES"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AmazonInspectorQuota")
class AmazonInspectorQuota(enum.Enum):
    NUMBER_OF_SUPPRESSION_RULES = "NUMBER_OF_SUPPRESSION_RULES"


@jsii.enum(
    jsii_type="@reapit-cdk/service-quotas.AmazonInteractiveVideoServiceChatQuota"
)
class AmazonInteractiveVideoServiceChatQuota(enum.Enum):
    RATE_OF_DISCONNECT_USER_REQUESTS = "RATE_OF_DISCONNECT_USER_REQUESTS"
    ROOMS = "ROOMS"
    LOGGING_CONFIGURATIONS = "LOGGING_CONFIGURATIONS"
    RATE_OF_DELETE_MESSAGE_REQUESTS = "RATE_OF_DELETE_MESSAGE_REQUESTS"
    RATE_OF_SEND_MESSAGE_REQUESTS = "RATE_OF_SEND_MESSAGE_REQUESTS"
    CONCURRENT_CHAT_CONNECTIONS = "CONCURRENT_CHAT_CONNECTIONS"
    RATE_OF_MESSAGING_REQUESTS_PER_CONNECTION = "RATE_OF_MESSAGING_REQUESTS_PER_CONNECTION"
    MESSAGE_REVIEW_HANDLER_TIMEOUT_PERIOD = "MESSAGE_REVIEW_HANDLER_TIMEOUT_PERIOD"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AmazonInteractiveVideoServiceQuota")
class AmazonInteractiveVideoServiceQuota(enum.Enum):
    STAGES = "STAGES"
    TOTAL_NUMBER_OF_DESTINATIONS_PER_COMPOSITION = "TOTAL_NUMBER_OF_DESTINATIONS_PER_COMPOSITION"
    COMPOSITIONS = "COMPOSITIONS"
    STAGE_PARTICIPANTS_SUBSCRIBERS = "STAGE_PARTICIPANTS_SUBSCRIBERS"
    STAGE_PARTICIPANTS_PUBLISHERS = "STAGE_PARTICIPANTS_PUBLISHERS"
    CONCURRENT_VIEWS = "CONCURRENT_VIEWS"
    RECORDING_CONFIGURATIONS = "RECORDING_CONFIGURATIONS"
    CHANNELS = "CHANNELS"
    MAX_COMPOSITION_DURATION = "MAX_COMPOSITION_DURATION"
    STORAGE_CONFIGURATIONS = "STORAGE_CONFIGURATIONS"
    CONCURRENT_STREAMS = "CONCURRENT_STREAMS"
    STREAM_KEY = "STREAM_KEY"
    PLAYBACK_RESTRICTION_POLICIES = "PLAYBACK_RESTRICTION_POLICIES"
    ENCODER_CONFIGURATIONS = "ENCODER_CONFIGURATIONS"
    PLAYBACK_TOKEN_SIZE = "PLAYBACK_TOKEN_SIZE"
    PUT_METADATA_RATE_PER_CHANNEL = "PUT_METADATA_RATE_PER_CHANNEL"
    INGEST_BITRATE_CHANNEL_TYPE_STANDARD = "INGEST_BITRATE_CHANNEL_TYPE_STANDARD"
    PLAYBACK_AUTHORIZATION_KEY_PAIRS = "PLAYBACK_AUTHORIZATION_KEY_PAIRS"
    INGEST_BITRATE_CHANNEL_TYPE_BASIC = "INGEST_BITRATE_CHANNEL_TYPE_BASIC"
    METADATA_PAYLOAD = "METADATA_PAYLOAD"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AmazonKendraIntelligentRankingQuota")
class AmazonKendraIntelligentRankingQuota(enum.Enum):
    MAXIMUM_TOKENS_PER_DOCUMENT_BODY = "MAXIMUM_TOKENS_PER_DOCUMENT_BODY"
    MAXIMUM_TOKENS_PER_DOCUMENT_TITLE = "MAXIMUM_TOKENS_PER_DOCUMENT_TITLE"
    MAXIMUM_DOCUMENTS_PER_GROUP_PER_RESCORE_REQUEST = "MAXIMUM_DOCUMENTS_PER_GROUP_PER_RESCORE_REQUEST"
    RESCORE_CAPACITY_UNITS_PER_ACCOUNT = "RESCORE_CAPACITY_UNITS_PER_ACCOUNT"
    MAXIMUM_RESCORE_CAPACITY_UNITS_PER_EXECUTION_PLAN = "MAXIMUM_RESCORE_CAPACITY_UNITS_PER_EXECUTION_PLAN"
    MAXIMUM_UNIQUE_DOCUMENTS_PER_RESCORE_REQUEST = "MAXIMUM_UNIQUE_DOCUMENTS_PER_RESCORE_REQUEST"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AmazonKendraQuota")
class AmazonKendraQuota(enum.Enum):
    CHARACTERS_IN_QUERY_TEXT = "CHARACTERS_IN_QUERY_TEXT"
    DATA_SOURCES_ENTERPRISE_EDITION = "DATA_SOURCES_ENTERPRISE_EDITION"
    SYNONYMS_PER_TERM = "SYNONYMS_PER_TERM"
    QUERY_SUGGESTIONS_MAX_ADDITIONAL_RESPONSE_ATTRIBUTES_IN_API = "QUERY_SUGGESTIONS_MAX_ADDITIONAL_RESPONSE_ATTRIBUTES_IN_API"
    SYNONYM_RULES_PER_THESAURUS = "SYNONYM_RULES_PER_THESAURUS"
    FA_QS = "FA_QS"
    DEVELOPER_EDITION_INDEXES = "DEVELOPER_EDITION_INDEXES"
    ENTERPRISE_EDITION_INDEXES = "ENTERPRISE_EDITION_INDEXES"
    THESAURI = "THESAURI"
    COLLAPSED_RESULTS_TO_EXPAND = "COLLAPSED_RESULTS_TO_EXPAND"
    QUERY_SUGGESTIONS_BLOCK_LISTS = "QUERY_SUGGESTIONS_BLOCK_LISTS"
    FEATURED_DOCUMENTS_PER_FEATURED_RESULTS_SET = "FEATURED_DOCUMENTS_PER_FEATURED_RESULTS_SET"
    SORT_CONFIGURATIONS = "SORT_CONFIGURATIONS"
    FEATURED_RESULTS_SETS_PER_INDEX = "FEATURED_RESULTS_SETS_PER_INDEX"
    INGESTION_ATTRIBUTES_STRING_LIST_SIZE = "INGESTION_ATTRIBUTES_STRING_LIST_SIZE"
    QUERY_CAPACITY_UNITS = "QUERY_CAPACITY_UNITS"
    QUERY_ATTRIBUTES_USER_GROUP_LIST_SIZE = "QUERY_ATTRIBUTES_USER_GROUP_LIST_SIZE"
    DATA_SOURCES_DEVELOPER_EDITION = "DATA_SOURCES_DEVELOPER_EDITION"
    THESAURUS_FILE_SIZE = "THESAURUS_FILE_SIZE"
    QUERY_SUGGESTIONS_RETURNED_IN_API = "QUERY_SUGGESTIONS_RETURNED_IN_API"
    FILE_SIZE = "FILE_SIZE"
    QUERY_SUGGESTIONS_BLOCK_LIST_FILE_SIZE = "QUERY_SUGGESTIONS_BLOCK_LIST_FILE_SIZE"
    ITEMS_IN_A_QUERY_SUGGESTIONS_BLOCK_LIST = "ITEMS_IN_A_QUERY_SUGGESTIONS_BLOCK_LIST"
    QUERY_SUGGESTIONS_MAX_SUGGESTABLE_ATTRIBUTES_IN_API = "QUERY_SUGGESTIONS_MAX_SUGGESTABLE_ATTRIBUTES_IN_API"
    STORAGE_CAPACITY_UNITS = "STORAGE_CAPACITY_UNITS"
    SPELL_CORRECTION_QUERY_SUGGESTIONS = "SPELL_CORRECTION_QUERY_SUGGESTIONS"
    EXTRACTED_TEXT_SIZE = "EXTRACTED_TEXT_SIZE"
    EXPANDED_RESULTS_PER_COLLAPSED_RESULT_ITEM = "EXPANDED_RESULTS_PER_COLLAPSED_RESULT_ITEM"


@jsii.enum(
    jsii_type="@reapit-cdk/service-quotas.AmazonKeyspacesForApacheCassandraQuota"
)
class AmazonKeyspacesForApacheCassandraQuota(enum.Enum):
    TABLE_LEVEL_WRITE_THROUGHPUT_QUOTA = "TABLE_LEVEL_WRITE_THROUGHPUT_QUOTA"
    MAX_CLUSTERING_KEY_SIZE = "MAX_CLUSTERING_KEY_SIZE"
    TABLES_PER_REGION = "TABLES_PER_REGION"
    MAX_SCHEMA_SIZE = "MAX_SCHEMA_SIZE"
    ACCOUNT_LEVEL_READ_THROUGHPUT_QUOTA_PROVISIONED_MODE = "ACCOUNT_LEVEL_READ_THROUGHPUT_QUOTA_PROVISIONED_MODE"
    CONCURRENT_DDL_OPERATIONS = "CONCURRENT_DDL_OPERATIONS"
    KEYSPACES_PER_REGION = "KEYSPACES_PER_REGION"
    MAX_CONCURRENT_TABLE_RESTORES_USING_POINT_IN_TIME_RECOVERY_PITR = "MAX_CONCURRENT_TABLE_RESTORES_USING_POINT_IN_TIME_RECOVERY_PITR"
    MAX_ROW_SIZE = "MAX_ROW_SIZE"
    ACCOUNT_LEVEL_WRITE_THROUGHPUT_QUOTA_PROVISIONED_MODE = "ACCOUNT_LEVEL_WRITE_THROUGHPUT_QUOTA_PROVISIONED_MODE"
    MAX_AMOUNT_OF_DATA_RESTORED_USING_POINT_IN_TIME_RECOVERY_PITR = "MAX_AMOUNT_OF_DATA_RESTORED_USING_POINT_IN_TIME_RECOVERY_PITR"
    MAX_SUBQUERIES_PER_IN_SELECT_STATEMENT = "MAX_SUBQUERIES_PER_IN_SELECT_STATEMENT"
    TABLE_LEVEL_READ_THROUGHPUT_QUOTA = "TABLE_LEVEL_READ_THROUGHPUT_QUOTA"
    MAX_PARTITION_KEY_SIZE = "MAX_PARTITION_KEY_SIZE"
    MAX_STATIC_DATA_PER_LOGICAL_PARTITION = "MAX_STATIC_DATA_PER_LOGICAL_PARTITION"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AmazonKinesisDataFirehoseQuota")
class AmazonKinesisDataFirehoseQuota(enum.Enum):
    DELIVERY_STREAMS = "DELIVERY_STREAMS"
    RATE_OF_DELETE_DELIVERY_STREAM_REQUESTS = "RATE_OF_DELETE_DELIVERY_STREAM_REQUESTS"
    RATE_OF_LIST_DELIVERY_STREAM_REQUESTS = "RATE_OF_LIST_DELIVERY_STREAM_REQUESTS"
    RATE_OF_LIST_TAGS_FOR_DELIVERY_STREAM_REQUESTS = "RATE_OF_LIST_TAGS_FOR_DELIVERY_STREAM_REQUESTS"
    DYNAMIC_PARTITIONS = "DYNAMIC_PARTITIONS"
    RATE_OF_RECORDS = "RATE_OF_RECORDS"
    RATE_OF_DESCRIBE_DELIVERY_STREAM_REQUESTS = "RATE_OF_DESCRIBE_DELIVERY_STREAM_REQUESTS"
    RATE_OF_DATA = "RATE_OF_DATA"
    RATE_OF_STOP_DELIVERY_STREAM_ENCRYPTION_REQUESTS = "RATE_OF_STOP_DELIVERY_STREAM_ENCRYPTION_REQUESTS"
    RATE_OF_TAG_DELIVERY_STREAM_REQUESTS = "RATE_OF_TAG_DELIVERY_STREAM_REQUESTS"
    RATE_OF_UPDATE_DESTINATION_REQUESTS = "RATE_OF_UPDATE_DESTINATION_REQUESTS"
    RATE_OF_START_DELIVERY_STREAM_ENCRYPTION_REQUESTS = "RATE_OF_START_DELIVERY_STREAM_ENCRYPTION_REQUESTS"
    RATE_OF_CREATE_DELIVERY_STREAM_REQUESTS = "RATE_OF_CREATE_DELIVERY_STREAM_REQUESTS"
    RATE_OF_PUT_REQUESTS = "RATE_OF_PUT_REQUESTS"
    RATE_OF_UNTAG_DELIVERY_STREAM_REQUESTS = "RATE_OF_UNTAG_DELIVERY_STREAM_REQUESTS"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AmazonKinesisDataStreamsQuota")
class AmazonKinesisDataStreamsQuota(enum.Enum):
    SHARDS_PER_REGION = "SHARDS_PER_REGION"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AmazonKinesisVideoStreamsQuota")
class AmazonKinesisVideoStreamsQuota(enum.Enum):
    RATE_OF_LIST_TAGS_FOR_RESOURCE_API_REQUESTS = "RATE_OF_LIST_TAGS_FOR_RESOURCE_API_REQUESTS"
    GET_MEDIA_FOR_FRAGMENT_LIST_FRAGMENTS = "GET_MEDIA_FOR_FRAGMENT_LIST_FRAGMENTS"
    RATE_OF_UPDATE_DATA_RETENTION_API_REQUESTS_PER_STREAM = "RATE_OF_UPDATE_DATA_RETENTION_API_REQUESTS_PER_STREAM"
    RATE_OF_CREATE_SIGNALING_CHANNEL_API_REQUESTS = "RATE_OF_CREATE_SIGNALING_CHANNEL_API_REQUESTS"
    PUT_MEDIA_MINIMUM_FRAGMENT_DURATION = "PUT_MEDIA_MINIMUM_FRAGMENT_DURATION"
    RATE_OF_UNTAG_STREAM_API_REQUESTS_PER_STREAM = "RATE_OF_UNTAG_STREAM_API_REQUESTS_PER_STREAM"
    GET_CLIP_FRAGMENTS = "GET_CLIP_FRAGMENTS"
    RATE_OF_DESCRIBE_MAPPED_RESOURCE_CONFIGURATION_API_REQUESTS = "RATE_OF_DESCRIBE_MAPPED_RESOURCE_CONFIGURATION_API_REQUESTS"
    RATE_OF_DELETE_STREAM_API_REQUESTS = "RATE_OF_DELETE_STREAM_API_REQUESTS"
    TURN_SESSION_BANDWIDTH = "TURN_SESSION_BANDWIDTH"
    RATE_OF_DELETE_SIGNALING_CHANNEL_API_REQUESTS = "RATE_OF_DELETE_SIGNALING_CHANNEL_API_REQUESTS"
    RATE_OF_DELETE_SIGNALING_CHANNEL_API_REQUESTS_PER_SIGNALING_CHANNEL = "RATE_OF_DELETE_SIGNALING_CHANNEL_API_REQUESTS_PER_SIGNALING_CHANNEL"
    RATE_OF_UPDATE_SIGNALING_CHANNEL_API_REQUESTS_PER_SIGNALING_CHANNEL = "RATE_OF_UPDATE_SIGNALING_CHANNEL_API_REQUESTS_PER_SIGNALING_CHANNEL"
    RATE_OF_GET_DASH_MANIFEST_PLAYLIST_API_REQUESTS_PER_SESSION = "RATE_OF_GET_DASH_MANIFEST_PLAYLIST_API_REQUESTS_PER_SESSION"
    GET_HLS_MEDIA_PLAYLIST_FRAGMENTS = "GET_HLS_MEDIA_PLAYLIST_FRAGMENTS"
    RATE_OF_UNTAG_RESOURCE_API_REQUESTS = "RATE_OF_UNTAG_RESOURCE_API_REQUESTS"
    RATE_OF_CONNECT_AS_VIEWER_API_REQUESTS_PER_SIGNALING_CHANNEL = "RATE_OF_CONNECT_AS_VIEWER_API_REQUESTS_PER_SIGNALING_CHANNEL"
    RATE_OF_LIST_TAGS_FOR_STREAM_API_REQUESTS_PER_STREAM = "RATE_OF_LIST_TAGS_FOR_STREAM_API_REQUESTS_PER_STREAM"
    RATE_OF_UNTAG_STREAM_API_REQUESTS = "RATE_OF_UNTAG_STREAM_API_REQUESTS"
    PUT_MEDIA_FRAGMENT_DURATION = "PUT_MEDIA_FRAGMENT_DURATION"
    RATE_OF_GET_HLS_MEDIA_PLAYLIST_API_REQUESTS_PER_SESSION = "RATE_OF_GET_HLS_MEDIA_PLAYLIST_API_REQUESTS_PER_SESSION"
    CONNECT_AS_MASTER_GO_AWAY_MESSAGE_GRACE_PERIOD = "CONNECT_AS_MASTER_GO_AWAY_MESSAGE_GRACE_PERIOD"
    CONNECT_AS_VIEWER_IDLE_CONNECTION_TIMEOUT = "CONNECT_AS_VIEWER_IDLE_CONNECTION_TIMEOUT"
    TURN_SESSION_CONCURRENT_ALLOCATIONS_PER_SIGNALING_CHANNEL = "TURN_SESSION_CONCURRENT_ALLOCATIONS_PER_SIGNALING_CHANNEL"
    RATE_OF_DELETE_STREAM_API_REQUESTS_PER_STREAM = "RATE_OF_DELETE_STREAM_API_REQUESTS_PER_STREAM"
    RATE_OF_SEND_SDP_ANSWER_API_REQUESTS_PER_WEBSOCKET_CONNECTION = "RATE_OF_SEND_SDP_ANSWER_API_REQUESTS_PER_WEBSOCKET_CONNECTION"
    CONNECT_AS_VIEWER_CONNECTION_DURATION = "CONNECT_AS_VIEWER_CONNECTION_DURATION"
    RATE_OF_LIST_STREAMS_API_REQUESTS = "RATE_OF_LIST_STREAMS_API_REQUESTS"
    RATE_OF_LIST_TAGS_FOR_STREAM_API_REQUESTS = "RATE_OF_LIST_TAGS_FOR_STREAM_API_REQUESTS"
    GET_CLIP_FILE_SIZE = "GET_CLIP_FILE_SIZE"
    CONNECT_AS_MASTER_CONNECTION_DURATION = "CONNECT_AS_MASTER_CONNECTION_DURATION"
    CONNECT_AS_MASTER_CONNECTIONS_PER_SIGNALING_CHANNEL = "CONNECT_AS_MASTER_CONNECTIONS_PER_SIGNALING_CHANNEL"
    RATE_OF_UNTAG_RESOURCE_API_REQUESTS_PER_RESOURCE = "RATE_OF_UNTAG_RESOURCE_API_REQUESTS_PER_RESOURCE"
    RATE_OF_START_EDGE_CONFIGURATION_UPDATE_API_REQUESTS = "RATE_OF_START_EDGE_CONFIGURATION_UPDATE_API_REQUESTS"
    RATE_OF_GET_HLS_MASTER_PLAYLIST_API_REQUESTS_PER_SESSION = "RATE_OF_GET_HLS_MASTER_PLAYLIST_API_REQUESTS_PER_SESSION"
    RATE_OF_GET_MP4_INIT_FRAGMENT_API_REQUESTS_PER_SESSION = "RATE_OF_GET_MP4_INIT_FRAGMENT_API_REQUESTS_PER_SESSION"
    RATE_OF_GET_MEDIA_API_REQUESTS_PER_STREAM = "RATE_OF_GET_MEDIA_API_REQUESTS_PER_STREAM"
    SEND_SDP_OFFER_MESSAGE_PAYLOAD_SIZE = "SEND_SDP_OFFER_MESSAGE_PAYLOAD_SIZE"
    RATE_OF_UPDATE_MEDIA_STORAGE_CONFIGURATION_API_REQUESTS_PER_RESOURCE = "RATE_OF_UPDATE_MEDIA_STORAGE_CONFIGURATION_API_REQUESTS_PER_RESOURCE"
    RATE_OF_DESCRIBE_STREAM_API_REQUESTS_PER_STREAM = "RATE_OF_DESCRIBE_STREAM_API_REQUESTS_PER_STREAM"
    SEND_ICE_CANDIDATE_MESSAGE_PAYLOAD_SIZE = "SEND_ICE_CANDIDATE_MESSAGE_PAYLOAD_SIZE"
    RATE_OF_CONNECT_AS_MASTER_API_REQUESTS_PER_SIGNALING_CHANNEL = "RATE_OF_CONNECT_AS_MASTER_API_REQUESTS_PER_SIGNALING_CHANNEL"
    GET_MEDIA_BANDWIDTH = "GET_MEDIA_BANDWIDTH"
    NUMBER_OF_VIDEO_STREAMS = "NUMBER_OF_VIDEO_STREAMS"
    RATE_OF_UPDATE_STREAM_API_REQUESTS_PER_STREAM = "RATE_OF_UPDATE_STREAM_API_REQUESTS_PER_STREAM"
    RATE_OF_GET_DASH_STREAMING_SESSION_URLAPI_REQUESTS_PER_STREAM = "RATE_OF_GET_DASH_STREAMING_SESSION_URLAPI_REQUESTS_PER_STREAM"
    RATE_OF_UPDATE_STREAM_API_REQUESTS = "RATE_OF_UPDATE_STREAM_API_REQUESTS"
    RATE_OF_UPDATE_MEDIA_STORAGE_CONFIGURATION_API_REQUESTS = "RATE_OF_UPDATE_MEDIA_STORAGE_CONFIGURATION_API_REQUESTS"
    RATE_OF_DESCRIBE_MEDIA_STORAGE_CONFIGURATION_API_REQUESTS = "RATE_OF_DESCRIBE_MEDIA_STORAGE_CONFIGURATION_API_REQUESTS"
    RATE_OF_DESCRIBE_STREAM_API_REQUESTS = "RATE_OF_DESCRIBE_STREAM_API_REQUESTS"
    RATE_OF_GET_ICE_SERVER_CONFIG_API_REQUESTS_PER_SIGNALING_CHANNEL = "RATE_OF_GET_ICE_SERVER_CONFIG_API_REQUESTS_PER_SIGNALING_CHANNEL"
    TURN_SESSION_EXPIRATION = "TURN_SESSION_EXPIRATION"
    RATE_OF_GET_TS_FRAGMENT_API_REQUESTS_PER_SESSION = "RATE_OF_GET_TS_FRAGMENT_API_REQUESTS_PER_SESSION"
    GET_MEDIA_FOR_FRAGMENT_LIST_CONNECTIONS_PER_STREAM = "GET_MEDIA_FOR_FRAGMENT_LIST_CONNECTIONS_PER_STREAM"
    RATE_OF_UPDATE_SIGNALING_CHANNEL_API_REQUESTS = "RATE_OF_UPDATE_SIGNALING_CHANNEL_API_REQUESTS"
    CONNECT_AS_MASTER_IDLE_CONNECTION_TIMEOUT = "CONNECT_AS_MASTER_IDLE_CONNECTION_TIMEOUT"
    RATE_OF_DELETE_EDGE_CONFIGURATION_API_REQUESTS_PER_RESOURCE = "RATE_OF_DELETE_EDGE_CONFIGURATION_API_REQUESTS_PER_RESOURCE"
    RATE_OF_TAG_RESOURCE_API_REQUESTS_PER_RESOURCE = "RATE_OF_TAG_RESOURCE_API_REQUESTS_PER_RESOURCE"
    RATE_OF_PUT_MEDIA_API_REQUESTS_PER_STREAM = "RATE_OF_PUT_MEDIA_API_REQUESTS_PER_STREAM"
    NUMBER_OF_SIGNALING_CHANNELS = "NUMBER_OF_SIGNALING_CHANNELS"
    RATE_OF_SEND_ALEXA_OFFER_TO_MASTER_API_REQUESTS_PER_SIGNALING_CHANNEL = "RATE_OF_SEND_ALEXA_OFFER_TO_MASTER_API_REQUESTS_PER_SIGNALING_CHANNEL"
    RATE_OF_DESCRIBE_SIGNALING_CHANNEL_API_REQUESTS_PER_SIGNALING_CHANNEL = "RATE_OF_DESCRIBE_SIGNALING_CHANNEL_API_REQUESTS_PER_SIGNALING_CHANNEL"
    RATE_OF_LIST_TAGS_FOR_RESOURCE_API_REQUESTS_PER_RESOURCE = "RATE_OF_LIST_TAGS_FOR_RESOURCE_API_REQUESTS_PER_RESOURCE"
    RATE_OF_LIST_EDGE_AGENT_CONFIGURATIONS_API_REQUESTS = "RATE_OF_LIST_EDGE_AGENT_CONFIGURATIONS_API_REQUESTS"
    PUT_MEDIA_BANDWIDTH = "PUT_MEDIA_BANDWIDTH"
    CONNECT_AS_VIEWER_CONNECTIONS_PER_SIGNALING_CHANNEL = "CONNECT_AS_VIEWER_CONNECTIONS_PER_SIGNALING_CHANNEL"
    GET_DASH_MANIFEST_PLAYLIST_FRAGMENTS = "GET_DASH_MANIFEST_PLAYLIST_FRAGMENTS"
    GET_MEDIA_CONCURRENT_CONNECTIONS_PER_STREAM = "GET_MEDIA_CONCURRENT_CONNECTIONS_PER_STREAM"
    RATE_OF_DESCRIBE_MAPPED_RESOURCE_CONFIGURATION_API_REQUESTS_PER_RESOURCE = "RATE_OF_DESCRIBE_MAPPED_RESOURCE_CONFIGURATION_API_REQUESTS_PER_RESOURCE"
    RATE_OF_SEND_SDP_OFFER_API_REQUESTS_PER_WEBSOCKET_CONNECTION = "RATE_OF_SEND_SDP_OFFER_API_REQUESTS_PER_WEBSOCKET_CONNECTION"
    PUT_MEDIA_FRAGMENT_SIZE = "PUT_MEDIA_FRAGMENT_SIZE"
    RATE_OF_GET_MP4_MEDIA_FRAGMENT_API_REQUESTS_PER_SESSION = "RATE_OF_GET_MP4_MEDIA_FRAGMENT_API_REQUESTS_PER_SESSION"
    PUT_MEDIA_CONCURRENT_CONNECTIONS_PER_STREAM = "PUT_MEDIA_CONCURRENT_CONNECTIONS_PER_STREAM"
    RATE_OF_GET_DATA_ENDPOINT_API_REQUESTS = "RATE_OF_GET_DATA_ENDPOINT_API_REQUESTS"
    GET_MEDIA_FOR_FRAGMENT_LIST_BANDWIDTH = "GET_MEDIA_FOR_FRAGMENT_LIST_BANDWIDTH"
    RATE_OF_LIST_SIGNALING_CHANNELS_API_REQUESTS = "RATE_OF_LIST_SIGNALING_CHANNELS_API_REQUESTS"
    RATE_OF_START_EDGE_CONFIGURATION_UPDATE_API_REQUESTS_PER_RESOURCE = "RATE_OF_START_EDGE_CONFIGURATION_UPDATE_API_REQUESTS_PER_RESOURCE"
    RATE_OF_TAG_STREAM_API_REQUESTS_PER_STREAM = "RATE_OF_TAG_STREAM_API_REQUESTS_PER_STREAM"
    RATE_OF_DESCRIBE_SIGNALING_CHANNEL_API_REQUESTS = "RATE_OF_DESCRIBE_SIGNALING_CHANNEL_API_REQUESTS"
    SEND_SDP_ANSWER_MESSAGE_PAYLOAD_SIZE = "SEND_SDP_ANSWER_MESSAGE_PAYLOAD_SIZE"
    RATE_OF_UPDATE_DATA_RETENTION_API_REQUESTS = "RATE_OF_UPDATE_DATA_RETENTION_API_REQUESTS"
    RATE_OF_TAG_RESOURCE_API_REQUESTS = "RATE_OF_TAG_RESOURCE_API_REQUESTS"
    RATE_OF_DELETE_EDGE_CONFIGURATION_API_REQUESTS = "RATE_OF_DELETE_EDGE_CONFIGURATION_API_REQUESTS"
    RATE_OF_GET_DATA_ENDPOINT_API_REQUESTS_PER_STREAM = "RATE_OF_GET_DATA_ENDPOINT_API_REQUESTS_PER_STREAM"
    RATE_OF_TAG_STREAM_API_REQUESTS = "RATE_OF_TAG_STREAM_API_REQUESTS"
    NUMBER_OF_MEDIA_STORAGE_CHANNELS = "NUMBER_OF_MEDIA_STORAGE_CHANNELS"
    PUT_MEDIA_TRACKS = "PUT_MEDIA_TRACKS"
    RATE_OF_SEND_ICE_CANDIDATE_API_REQUESTS_PER_WEBSOCKET_CONNECTION = "RATE_OF_SEND_ICE_CANDIDATE_API_REQUESTS_PER_WEBSOCKET_CONNECTION"
    CONNECT_AS_VIEWER_GO_AWAY_MESSAGE_GRACE_PERIOD = "CONNECT_AS_VIEWER_GO_AWAY_MESSAGE_GRACE_PERIOD"
    RATE_OF_GET_SIGNALING_CHANNEL_ENDPOINT_API_REQUESTS_PER_SIGNALING_CHANNEL = "RATE_OF_GET_SIGNALING_CHANNEL_ENDPOINT_API_REQUESTS_PER_SIGNALING_CHANNEL"
    RATE_OF_DESCRIBE_EDGE_CONFIGURATION_API_REQUESTS = "RATE_OF_DESCRIBE_EDGE_CONFIGURATION_API_REQUESTS"
    RATE_OF_CREATE_STREAM_API_REQUESTS = "RATE_OF_CREATE_STREAM_API_REQUESTS"
    RATE_OF_GET_HLS_STREAMING_SESSION_URLAPI_REQUESTS_PER_STREAM = "RATE_OF_GET_HLS_STREAMING_SESSION_URLAPI_REQUESTS_PER_STREAM"
    RATE_OF_DESCRIBE_EDGE_CONFIGURATION_API_REQUESTS_PER_RESOURCE = "RATE_OF_DESCRIBE_EDGE_CONFIGURATION_API_REQUESTS_PER_RESOURCE"
    RATE_OF_GET_SIGNALING_CHANNEL_ENDPOINT_API_REQUESTS = "RATE_OF_GET_SIGNALING_CHANNEL_ENDPOINT_API_REQUESTS"
    RATE_OF_DESCRIBE_MEDIA_STORAGE_CONFIGURATION_API_REQUESTS_PER_RESOURCE = "RATE_OF_DESCRIBE_MEDIA_STORAGE_CONFIGURATION_API_REQUESTS_PER_RESOURCE"
    RATE_OF_ARCHIVED_FRAGMENT_METADATA_PER_STREAM = "RATE_OF_ARCHIVED_FRAGMENT_METADATA_PER_STREAM"
    RATE_OF_ARCHIVED_FRAGMENT_MEDIA_PER_STREAM = "RATE_OF_ARCHIVED_FRAGMENT_MEDIA_PER_STREAM"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AmazonLexQuota")
class AmazonLexQuota(enum.Enum):
    CHARACTERS_PER_SAMPLE_UTTERANCE_V2 = "CHARACTERS_PER_SAMPLE_UTTERANCE_V2"
    SAMPLE_UTTERANCES_PER_INTENT_V2 = "SAMPLE_UTTERANCES_PER_INTENT_V2"
    BOT_CHANNEL_ASSOCIATIONS_PER_BOT_ALIAS_V2 = "BOT_CHANNEL_ASSOCIATIONS_PER_BOT_ALIAS_V2"
    SAMPLE_UTTERANCES_PER_SLOT_V2 = "SAMPLE_UTTERANCES_PER_SLOT_V2"
    VALUES_AND_SYNONYMS_PER_CUSTOM_SLOT_TYPE_V2 = "VALUES_AND_SYNONYMS_PER_CUSTOM_SLOT_TYPE_V2"
    CUSTOM_SLOT_TYPES_PER_BOT_LOCALE_V2 = "CUSTOM_SLOT_TYPES_PER_BOT_LOCALE_V2"
    CHARACTERS_PER_CUSTOM_SLOT_TYPE_VALUE_V2 = "CHARACTERS_PER_CUSTOM_SLOT_TYPE_VALUE_V2"
    CUSTOM_SLOT_TYPE_VALUES_AND_SYNONYMS_PER_BOT_LOCALE_V2 = "CUSTOM_SLOT_TYPE_VALUES_AND_SYNONYMS_PER_BOT_LOCALE_V2"
    SLOTS_PER_INTENT_V2 = "SLOTS_PER_INTENT_V2"
    SLOTS_PER_BOT_LOCALE_V2 = "SLOTS_PER_BOT_LOCALE_V2"
    VERSIONS_PER_BOT_V2 = "VERSIONS_PER_BOT_V2"
    TOTAL_CHARACTERS_IN_SAMPLE_UTTERANCES_PER_BOT_LOCALE_V2 = "TOTAL_CHARACTERS_IN_SAMPLE_UTTERANCES_PER_BOT_LOCALE_V2"
    BOTS_PER_ACCOUNT_V2 = "BOTS_PER_ACCOUNT_V2"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AmazonLightsailQuota")
class AmazonLightsailQuota(enum.Enum):
    STATIC_IP_ADDRESSES = "STATIC_IP_ADDRESSES"
    CONTAINER_SERVICE_CUSTOM_DOMAINS = "CONTAINER_SERVICE_CUSTOM_DOMAINS"
    CONTAINER_SERVICE_DEPLOYMENT_VERSIONS = "CONTAINER_SERVICE_DEPLOYMENT_VERSIONS"
    DEFAULT_BEHAVIORS_DEFAULT_CACHE_BEHAVIOR_PER_DISTRIBUTION = "DEFAULT_BEHAVIORS_DEFAULT_CACHE_BEHAVIOR_PER_DISTRIBUTION"
    CONTAINER_SERVICE_LOGS_STORAGE_DAYS = "CONTAINER_SERVICE_LOGS_STORAGE_DAYS"
    DNS_ZONES_OR_DOMAINS = "DNS_ZONES_OR_DOMAINS"
    TOTAL_ATTACHED_BLOCK_STORAGE_DISK_SPACE = "TOTAL_ATTACHED_BLOCK_STORAGE_DISK_SPACE"
    MAXIMUM_BLOCK_STORAGE_DISK_SPACE = "MAXIMUM_BLOCK_STORAGE_DISK_SPACE"
    PARALLEL_RDP_CONNECTIONS_USING_THE_BROWSER_BASED_RDP_CLIENT = "PARALLEL_RDP_CONNECTIONS_USING_THE_BROWSER_BASED_RDP_CLIENT"
    MAXIMUM_BUCKETS_PER_ACCOUNT = "MAXIMUM_BUCKETS_PER_ACCOUNT"
    CONTAINER_SERVICE_STORED_CONTAINER_IMAGES = "CONTAINER_SERVICE_STORED_CONTAINER_IMAGES"
    ALLOWED_QUERY_STRINGS_PER_CACHE_BEHAVIOR_FOR_A_DISTRIBUTION = "ALLOWED_QUERY_STRINGS_PER_CACHE_BEHAVIOR_FOR_A_DISTRIBUTION"
    MINIMUM_BLOCK_STORAGE_DISK_SPACE = "MINIMUM_BLOCK_STORAGE_DISK_SPACE"
    LOAD_BALANCERS = "LOAD_BALANCERS"
    TAGS = "TAGS"
    DIRECTORY_AND_FILE_OVERRIDES_PER_DISTRIBUTION = "DIRECTORY_AND_FILE_OVERRIDES_PER_DISTRIBUTION"
    BLOCK_STORAGE_DISKS_PER_INSTANCE = "BLOCK_STORAGE_DISKS_PER_INSTANCE"
    RESPONSE_TIMEOUT_PER_ORIGIN_FOR_A_DISTRIBUTION = "RESPONSE_TIMEOUT_PER_ORIGIN_FOR_A_DISTRIBUTION"
    MAXIMUM_ACTIVE_CERTIFICATES = "MAXIMUM_ACTIVE_CERTIFICATES"
    ALLOWED_COOKIES_PER_CACHE_BEHAVIOR_FOR_A_DISTRIBUTION = "ALLOWED_COOKIES_PER_CACHE_BEHAVIOR_FOR_A_DISTRIBUTION"
    CUSTOM_DOMAIN_NAMES_PER_DISTRIBUTION = "CUSTOM_DOMAIN_NAMES_PER_DISTRIBUTION"
    CONTAINER_SERVICE_NODES = "CONTAINER_SERVICE_NODES"
    DISTRIBUTIONS = "DISTRIBUTIONS"
    DATA_TRANSFER_RATE_PER_DISTRIBUTION = "DATA_TRANSFER_RATE_PER_DISTRIBUTION"
    PARALLEL_SSH_CONNECTIONS_USING_THE_BROWSER_BASED_SSH_CLIENT = "PARALLEL_SSH_CONNECTIONS_USING_THE_BROWSER_BASED_SSH_CLIENT"
    MAXIMUM_CERTIFICATES = "MAXIMUM_CERTIFICATES"
    ORIGINS_PER_DISTRIBUTION = "ORIGINS_PER_DISTRIBUTION"
    CONTAINER_SERVICE_CERTIFICATES = "CONTAINER_SERVICE_CERTIFICATES"
    DATABASES = "DATABASES"
    MAXIMUM_KEYS_PER_BUCKET = "MAXIMUM_KEYS_PER_BUCKET"
    CONTAINER_SERVICE_DEPLOYMENT_CONTAINERS = "CONTAINER_SERVICE_DEPLOYMENT_CONTAINERS"
    INSTANCES = "INSTANCES"
    CONTAINER_SERVICES = "CONTAINER_SERVICES"
    ALLOWED_HEADERS_PER_CACHE_BEHAVIOR_FOR_A_DISTRIBUTION = "ALLOWED_HEADERS_PER_CACHE_BEHAVIOR_FOR_A_DISTRIBUTION"


@jsii.enum(
    jsii_type="@reapit-cdk/service-quotas.AmazonLocationServiceAmazonLocationQuota"
)
class AmazonLocationServiceAmazonLocationQuota(enum.Enum):
    RATE_OF_CREATE_KEY_API_REQUESTS = "RATE_OF_CREATE_KEY_API_REQUESTS"
    RATE_OF_BATCH_PUT_GEOFENCE_API_REQUESTS = "RATE_OF_BATCH_PUT_GEOFENCE_API_REQUESTS"
    RATE_OF_UPDATE_TRACKER_API_REQUESTS = "RATE_OF_UPDATE_TRACKER_API_REQUESTS"
    RATE_OF_UPDATE_KEY_API_REQUESTS = "RATE_OF_UPDATE_KEY_API_REQUESTS"
    RATE_OF_UPDATE_PLACE_INDEX_API_REQUESTS = "RATE_OF_UPDATE_PLACE_INDEX_API_REQUESTS"
    RATE_OF_DELETE_GEOFENCE_COLLECTION_API_REQUESTS = "RATE_OF_DELETE_GEOFENCE_COLLECTION_API_REQUESTS"
    ROUTE_CALCULATOR_RESOURCES_PER_ACCOUNT = "ROUTE_CALCULATOR_RESOURCES_PER_ACCOUNT"
    RATE_OF_LIST_TRACKER_CONSUMERS_API_REQUESTS = "RATE_OF_LIST_TRACKER_CONSUMERS_API_REQUESTS"
    RATE_OF_BATCH_GET_DEVICE_POSITION_API_REQUESTS = "RATE_OF_BATCH_GET_DEVICE_POSITION_API_REQUESTS"
    RATE_OF_LIST_TAGS_FOR_RESOURCE_API_REQUESTS = "RATE_OF_LIST_TAGS_FOR_RESOURCE_API_REQUESTS"
    RATE_OF_DESCRIBE_ROUTE_CALCULATOR_API_REQUESTS = "RATE_OF_DESCRIBE_ROUTE_CALCULATOR_API_REQUESTS"
    RATE_OF_CREATE_TRACKER_API_REQUESTS = "RATE_OF_CREATE_TRACKER_API_REQUESTS"
    RATE_OF_BATCH_EVALUATE_GEOFENCES_API_REQUESTS = "RATE_OF_BATCH_EVALUATE_GEOFENCES_API_REQUESTS"
    RATE_OF_TAG_RESOURCE_API_REQUESTS = "RATE_OF_TAG_RESOURCE_API_REQUESTS"
    RATE_OF_GET_GEOFENCE_API_REQUESTS = "RATE_OF_GET_GEOFENCE_API_REQUESTS"
    RATE_OF_DESCRIBE_PLACE_INDEX_API_REQUESTS = "RATE_OF_DESCRIBE_PLACE_INDEX_API_REQUESTS"
    RATE_OF_GET_MAP_SPRITES_API_REQUESTS = "RATE_OF_GET_MAP_SPRITES_API_REQUESTS"
    RATE_OF_BATCH_DELETE_DEVICE_POSITION_HISTORY_API_REQUESTS = "RATE_OF_BATCH_DELETE_DEVICE_POSITION_HISTORY_API_REQUESTS"
    TRACKER_CONSUMERS_PER_TRACKER = "TRACKER_CONSUMERS_PER_TRACKER"
    RATE_OF_UNTAG_RESOURCE_API_REQUESTS = "RATE_OF_UNTAG_RESOURCE_API_REQUESTS"
    RATE_OF_DELETE_KEY_API_REQUESTS = "RATE_OF_DELETE_KEY_API_REQUESTS"
    RATE_OF_UPDATE_GEOFENCE_COLLECTION_API_REQUESTS = "RATE_OF_UPDATE_GEOFENCE_COLLECTION_API_REQUESTS"
    RATE_OF_LIST_TRACKERS_API_REQUESTS = "RATE_OF_LIST_TRACKERS_API_REQUESTS"
    RATE_OF_CREATE_GEOFENCE_COLLECTION_API_REQUESTS = "RATE_OF_CREATE_GEOFENCE_COLLECTION_API_REQUESTS"
    RATE_OF_GET_DEVICE_POSITION_HISTORY_API_REQUESTS = "RATE_OF_GET_DEVICE_POSITION_HISTORY_API_REQUESTS"
    GEOFENCE_COLLECTION_RESOURCES_PER_ACCOUNT = "GEOFENCE_COLLECTION_RESOURCES_PER_ACCOUNT"
    RATE_OF_BATCH_DELETE_GEOFENCE_API_REQUESTS = "RATE_OF_BATCH_DELETE_GEOFENCE_API_REQUESTS"
    RATE_OF_CALCULATE_ROUTE_API_REQUESTS = "RATE_OF_CALCULATE_ROUTE_API_REQUESTS"
    RATE_OF_LIST_DEVICE_POSITIONS_API_REQUESTS = "RATE_OF_LIST_DEVICE_POSITIONS_API_REQUESTS"
    PLACE_INDEX_RESOURCES_PER_ACCOUNT = "PLACE_INDEX_RESOURCES_PER_ACCOUNT"
    RATE_OF_ASSOCIATE_TRACKER_CONSUMER_API_REQUESTS = "RATE_OF_ASSOCIATE_TRACKER_CONSUMER_API_REQUESTS"
    RATE_OF_DESCRIBE_KEY_API_REQUESTS = "RATE_OF_DESCRIBE_KEY_API_REQUESTS"
    RATE_OF_DELETE_PLACE_INDEX_API_REQUESTS = "RATE_OF_DELETE_PLACE_INDEX_API_REQUESTS"
    RATE_OF_PUT_GEOFENCE_API_REQUESTS = "RATE_OF_PUT_GEOFENCE_API_REQUESTS"
    RATE_OF_DISASSOCIATE_TRACKER_CONSUMER_API_REQUESTS = "RATE_OF_DISASSOCIATE_TRACKER_CONSUMER_API_REQUESTS"
    RATE_OF_LIST_GEOFENCE_COLLECTIONS_API_REQUESTS = "RATE_OF_LIST_GEOFENCE_COLLECTIONS_API_REQUESTS"
    RATE_OF_DESCRIBE_GEOFENCE_COLLECTION_API_REQUESTS = "RATE_OF_DESCRIBE_GEOFENCE_COLLECTION_API_REQUESTS"
    RATE_OF_SEARCH_PLACE_INDEX_FOR_POSITION_API_REQUESTS = "RATE_OF_SEARCH_PLACE_INDEX_FOR_POSITION_API_REQUESTS"
    RATE_OF_DESCRIBE_TRACKER_API_REQUESTS = "RATE_OF_DESCRIBE_TRACKER_API_REQUESTS"
    RATE_OF_UPDATE_ROUTE_CALCULATOR_API_REQUESTS = "RATE_OF_UPDATE_ROUTE_CALCULATOR_API_REQUESTS"
    RATE_OF_CREATE_PLACE_INDEX_API_REQUESTS = "RATE_OF_CREATE_PLACE_INDEX_API_REQUESTS"
    RATE_OF_DESCRIBE_MAP_API_REQUESTS = "RATE_OF_DESCRIBE_MAP_API_REQUESTS"
    RATE_OF_SEARCH_PLACE_INDEX_FOR_TEXT_API_REQUESTS = "RATE_OF_SEARCH_PLACE_INDEX_FOR_TEXT_API_REQUESTS"
    RATE_OF_UPDATE_MAP_API_REQUESTS = "RATE_OF_UPDATE_MAP_API_REQUESTS"
    RATE_OF_LIST_ROUTE_CALCULATORS_API_REQUESTS = "RATE_OF_LIST_ROUTE_CALCULATORS_API_REQUESTS"
    RATE_OF_GET_MAP_STYLE_DESCRIPTOR_API_REQUESTS = "RATE_OF_GET_MAP_STYLE_DESCRIPTOR_API_REQUESTS"
    RATE_OF_LIST_KEYS_API_REQUESTS = "RATE_OF_LIST_KEYS_API_REQUESTS"
    RATE_OF_SEARCH_PLACE_INDEX_FOR_SUGGESTIONS_API_REQUESTS = "RATE_OF_SEARCH_PLACE_INDEX_FOR_SUGGESTIONS_API_REQUESTS"
    RATE_OF_LIST_GEOFENCES_API_REQUESTS = "RATE_OF_LIST_GEOFENCES_API_REQUESTS"
    GEOFENCES_PER_GEOFENCE_COLLECTION = "GEOFENCES_PER_GEOFENCE_COLLECTION"
    API_KEY_RESOURCES_PER_ACCOUNT = "API_KEY_RESOURCES_PER_ACCOUNT"
    MAP_RESOURCES_PER_ACCOUNT = "MAP_RESOURCES_PER_ACCOUNT"
    RATE_OF_GET_DEVICE_POSITION_API_REQUESTS = "RATE_OF_GET_DEVICE_POSITION_API_REQUESTS"
    TRACKER_RESOURCES_PER_ACCOUNT = "TRACKER_RESOURCES_PER_ACCOUNT"
    RATE_OF_CALCULATE_ROUTE_MATRIX_API_REQUESTS = "RATE_OF_CALCULATE_ROUTE_MATRIX_API_REQUESTS"
    RATE_OF_GET_PLACE_API_REQUESTS = "RATE_OF_GET_PLACE_API_REQUESTS"
    RATE_OF_DELETE_MAP_API_REQUESTS = "RATE_OF_DELETE_MAP_API_REQUESTS"
    RATE_OF_DELETE_TRACKER_API_REQUESTS = "RATE_OF_DELETE_TRACKER_API_REQUESTS"
    RATE_OF_LIST_MAPS_API_REQUESTS = "RATE_OF_LIST_MAPS_API_REQUESTS"
    RATE_OF_GET_MAP_TILE_API_REQUESTS = "RATE_OF_GET_MAP_TILE_API_REQUESTS"
    RATE_OF_DELETE_ROUTE_CALCULATOR_API_REQUESTS = "RATE_OF_DELETE_ROUTE_CALCULATOR_API_REQUESTS"
    RATE_OF_BATCH_UPDATE_DEVICE_POSITION_API_REQUESTS = "RATE_OF_BATCH_UPDATE_DEVICE_POSITION_API_REQUESTS"
    RATE_OF_CREATE_MAP_API_REQUESTS = "RATE_OF_CREATE_MAP_API_REQUESTS"
    RATE_OF_GET_MAP_GLYPHS_API_REQUESTS = "RATE_OF_GET_MAP_GLYPHS_API_REQUESTS"
    RATE_OF_LIST_PLACE_INDEXES_API_REQUESTS = "RATE_OF_LIST_PLACE_INDEXES_API_REQUESTS"
    RATE_OF_CREATE_ROUTE_CALCULATOR_API_REQUESTS = "RATE_OF_CREATE_ROUTE_CALCULATOR_API_REQUESTS"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AmazonLookoutForEquipmentQuota")
class AmazonLookoutForEquipmentQuota(enum.Enum):
    NUMBER_OF_ROWS_IN_INFERENCE_INPUT_DATA_AFTER_RESAMPLING_10_MIN_SCHEDULING_FREQUENCY = "NUMBER_OF_ROWS_IN_INFERENCE_INPUT_DATA_AFTER_RESAMPLING_10_MIN_SCHEDULING_FREQUENCY"
    SIZE_OF_RAW_DATA_IN_INFERENCE_INPUT_DATA_10_MIN_SCHEDULING_FREQUENCY = "SIZE_OF_RAW_DATA_IN_INFERENCE_INPUT_DATA_10_MIN_SCHEDULING_FREQUENCY"
    COMPONENTS_PER_DATASET = "COMPONENTS_PER_DATASET"
    NUMBER_OF_ROWS_IN_INFERENCE_INPUT_DATA_AFTER_RESAMPLING_30_MIN_SCHEDULING_FREQUENCY = "NUMBER_OF_ROWS_IN_INFERENCE_INPUT_DATA_AFTER_RESAMPLING_30_MIN_SCHEDULING_FREQUENCY"
    NUMBER_OF_COLUMNS_ACROSS_COMPONENTS_IN_TRAINING_DATA_EXCLUDING_TIMESTAMP = "NUMBER_OF_COLUMNS_ACROSS_COMPONENTS_IN_TRAINING_DATA_EXCLUDING_TIMESTAMP"
    SIZE_OF_RAW_DATA_IN_INFERENCE_INPUT_DATA_30_MIN_SCHEDULING_FREQUENCY = "SIZE_OF_RAW_DATA_IN_INFERENCE_INPUT_DATA_30_MIN_SCHEDULING_FREQUENCY"
    PENDING_MODELS = "PENDING_MODELS"
    SIZE_PER_FILE = "SIZE_PER_FILE"
    DATASETS = "DATASETS"
    NUMBER_OF_ROWS_IN_INFERENCE_INPUT_DATA_AFTER_RESAMPLING_15_MIN_SCHEDULING_FREQUENCY = "NUMBER_OF_ROWS_IN_INFERENCE_INPUT_DATA_AFTER_RESAMPLING_15_MIN_SCHEDULING_FREQUENCY"
    NUMBER_OF_IMPORT_DATASET_JOBS_IN_PROGRESS = "NUMBER_OF_IMPORT_DATASET_JOBS_IN_PROGRESS"
    LENGTH_OF_COMPONENT_NAME = "LENGTH_OF_COMPONENT_NAME"
    NUMBER_OF_FILES_PER_COMPONENT_PER_INFERENCE_EXECUTION = "NUMBER_OF_FILES_PER_COMPONENT_PER_INFERENCE_EXECUTION"
    MODELS = "MODELS"
    SIZE_PER_DATASET = "SIZE_PER_DATASET"
    NUMBER_OF_LABELS_PER_LABEL_GROUP = "NUMBER_OF_LABELS_PER_LABEL_GROUP"
    SIZE_OF_RAW_DATA_IN_INFERENCE_INPUT_DATA_5_MIN_SCHEDULING_FREQUENCY = "SIZE_OF_RAW_DATA_IN_INFERENCE_INPUT_DATA_5_MIN_SCHEDULING_FREQUENCY"
    LABEL_GROUPS = "LABEL_GROUPS"
    SIZE_OF_RAW_DATA_IN_INFERENCE_INPUT_DATA_1_HOUR_SCHEDULING_FREQUENCY = "SIZE_OF_RAW_DATA_IN_INFERENCE_INPUT_DATA_1_HOUR_SCHEDULING_FREQUENCY"
    NUMBER_OF_FILES_PER_COMPONENT_PER_DATASET = "NUMBER_OF_FILES_PER_COMPONENT_PER_DATASET"
    PENDING_DATA_INGESTION_JOBS = "PENDING_DATA_INGESTION_JOBS"
    NUMBER_OF_IMPORT_MODEL_JOBS_IN_PROGRESS = "NUMBER_OF_IMPORT_MODEL_JOBS_IN_PROGRESS"
    SIZE_OF_RAW_DATA_IN_INFERENCE_INPUT_DATA_15_MIN_SCHEDULING_FREQUENCY = "SIZE_OF_RAW_DATA_IN_INFERENCE_INPUT_DATA_15_MIN_SCHEDULING_FREQUENCY"
    INFERENCE_SCHEDULERS_PER_MODEL = "INFERENCE_SCHEDULERS_PER_MODEL"
    NUMBER_OF_ROWS_IN_INFERENCE_INPUT_DATA_AFTER_RESAMPLING_5_MIN_SCHEDULING_FREQUENCY = "NUMBER_OF_ROWS_IN_INFERENCE_INPUT_DATA_AFTER_RESAMPLING_5_MIN_SCHEDULING_FREQUENCY"
    NUMBER_OF_ROWS_IN_TRAINING_DATA_AFTER_RESAMPLING = "NUMBER_OF_ROWS_IN_TRAINING_DATA_AFTER_RESAMPLING"
    NUMBER_OF_COLUMNS_ACROSS_COMPONENTS_PER_DATASET_EXCLUDING_TIMESTAMP = "NUMBER_OF_COLUMNS_ACROSS_COMPONENTS_PER_DATASET_EXCLUDING_TIMESTAMP"
    TIMESPAN_OF_TRAINING_DATA = "TIMESPAN_OF_TRAINING_DATA"
    NUMBER_OF_ROWS_IN_INFERENCE_INPUT_DATA_AFTER_RESAMPLING_1_HOUR_SCHEDULING_FREQUENCY = "NUMBER_OF_ROWS_IN_INFERENCE_INPUT_DATA_AFTER_RESAMPLING_1_HOUR_SCHEDULING_FREQUENCY"
    NUMBER_OF_COMPONENTS_IN_TRAINING_DATA = "NUMBER_OF_COMPONENTS_IN_TRAINING_DATA"
    NUMBER_OF_ROWS_IN_EVALUATION_DATA_AFTER_RESAMPLING = "NUMBER_OF_ROWS_IN_EVALUATION_DATA_AFTER_RESAMPLING"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AmazonLookoutForMetricsQuota")
class AmazonLookoutForMetricsQuota(enum.Enum):
    THROTTLE_RATE_LIST_METRIC_SETS = "THROTTLE_RATE_LIST_METRIC_SETS"
    TIME_SERIES_PER_INTERVAL_5M = "TIME_SERIES_PER_INTERVAL_5M"
    THROTTLE_RATE_GET_ANOMALY_GROUP = "THROTTLE_RATE_GET_ANOMALY_GROUP"
    RECORDS_PER_INTERVAL_1H = "RECORDS_PER_INTERVAL_1H"
    THROTTLE_RATE_BACK_TEST_ANOMALY_DETECTOR = "THROTTLE_RATE_BACK_TEST_ANOMALY_DETECTOR"
    TIME_SERIES_PER_INTERVAL_10M = "TIME_SERIES_PER_INTERVAL_10M"
    MEASURES_PER_DATASET = "MEASURES_PER_DATASET"
    DATASETS_PER_DETECTOR = "DATASETS_PER_DETECTOR"
    THROTTLE_RATE_LIST_ANOMALY_GROUP_TIME_SERIES = "THROTTLE_RATE_LIST_ANOMALY_GROUP_TIME_SERIES"
    THROTTLE_RATE_DELETE_ANOMALY_DETECTOR = "THROTTLE_RATE_DELETE_ANOMALY_DETECTOR"
    THROTTLE_RATE_UPDATE_METRIC_SET = "THROTTLE_RATE_UPDATE_METRIC_SET"
    DIMENSIONS_PER_DATASET = "DIMENSIONS_PER_DATASET"
    VALUE_LENGTH = "VALUE_LENGTH"
    THROTTLE_RATE_CREATE_METRIC_SET = "THROTTLE_RATE_CREATE_METRIC_SET"
    FILES_PER_INTERVAL_1D = "FILES_PER_INTERVAL_1D"
    RECORDS_PER_INTERVAL_5M = "RECORDS_PER_INTERVAL_5M"
    THROTTLE_RATE_CREATE_ALERT = "THROTTLE_RATE_CREATE_ALERT"
    THROTTLE_RATE_UPDATE_ANOMALY_DETECTOR = "THROTTLE_RATE_UPDATE_ANOMALY_DETECTOR"
    THROTTLE_RATE_DELETE_ALERT = "THROTTLE_RATE_DELETE_ALERT"
    THROTTLE_RATE_LIST_ANOMALY_DETECTORS = "THROTTLE_RATE_LIST_ANOMALY_DETECTORS"
    TIME_SERIES_PER_INTERVAL_1H = "TIME_SERIES_PER_INTERVAL_1H"
    THROTTLE_RATE_DESCRIBE_ANOMALY_DETECTOR = "THROTTLE_RATE_DESCRIBE_ANOMALY_DETECTOR"
    FILES_PER_INTERVAL_10M = "FILES_PER_INTERVAL_10M"
    THROTTLE_RATE_ACTIVATE_ANOMALY_DETECTOR = "THROTTLE_RATE_ACTIVATE_ANOMALY_DETECTOR"
    TIME_SERIES_PER_INTERVAL_1D = "TIME_SERIES_PER_INTERVAL_1D"
    THROTTLE_RATE_GET_DATA_QUALITY_METRICS = "THROTTLE_RATE_GET_DATA_QUALITY_METRICS"
    THROTTLE_RATE_GET_SAMPLE_DATA = "THROTTLE_RATE_GET_SAMPLE_DATA"
    THROTTLE_RATE = "THROTTLE_RATE"
    FILES_PER_INTERVAL_1H = "FILES_PER_INTERVAL_1H"
    THROTTLE_RATE_PUT_FEEDBACK = "THROTTLE_RATE_PUT_FEEDBACK"
    DATASOURCES_PER_DATASET = "DATASOURCES_PER_DATASET"
    THROTTLE_RATE_LIST_ANOMALY_GROUP_RELATED_METRICS = "THROTTLE_RATE_LIST_ANOMALY_GROUP_RELATED_METRICS"
    THROTTLE_RATE_DESCRIBE_METRIC_SET = "THROTTLE_RATE_DESCRIBE_METRIC_SET"
    THROTTLE_RATE_GET_FEEDBACK = "THROTTLE_RATE_GET_FEEDBACK"
    FILES_PER_INTERVAL_5M = "FILES_PER_INTERVAL_5M"
    RECORDS_PER_INTERVAL_10M = "RECORDS_PER_INTERVAL_10M"
    ALERTS = "ALERTS"
    RECORDS_PER_INTERVAL_1D = "RECORDS_PER_INTERVAL_1D"
    THROTTLE_RATE_CREATE_ANOMALY_DETECTOR = "THROTTLE_RATE_CREATE_ANOMALY_DETECTOR"
    DETECTORS = "DETECTORS"
    THROTTLE_RATE_DESCRIBE_ANOMALY_DETECTION_EXECUTIONS = "THROTTLE_RATE_DESCRIBE_ANOMALY_DETECTION_EXECUTIONS"
    THROTTLE_RATE_LIST_ALERTS = "THROTTLE_RATE_LIST_ALERTS"
    THROTTLE_RATE_DESCRIBE_ALERT = "THROTTLE_RATE_DESCRIBE_ALERT"
    THROTTLE_RATE_LIST_ANOMALY_GROUP_SUMMARIES = "THROTTLE_RATE_LIST_ANOMALY_GROUP_SUMMARIES"
    THROTTLE_RATE_DETECT_METRIC_SET_CONFIG = "THROTTLE_RATE_DETECT_METRIC_SET_CONFIG"
    VALUE_FILTERS_PER_DIMENSION_FILTER = "VALUE_FILTERS_PER_DIMENSION_FILTER"
    THROTTLE_RATE_UNTAG_RESOURCE = "THROTTLE_RATE_UNTAG_RESOURCE"
    THROTTLE_RATE_TAG_RESOURCE = "THROTTLE_RATE_TAG_RESOURCE"
    THROTTLE_RATE_DEACTIVATE_ANOMALY_DETECTOR = "THROTTLE_RATE_DEACTIVATE_ANOMALY_DETECTOR"
    DATA_SIZE_FOR_HISTORICAL_DATA_CONTINUOUS_MODE = "DATA_SIZE_FOR_HISTORICAL_DATA_CONTINUOUS_MODE"
    DIMENSIONS_FILTERS_PER_DATASET = "DIMENSIONS_FILTERS_PER_DATASET"
    DATA_SIZE_PER_INTERVAL_1H = "DATA_SIZE_PER_INTERVAL_1H"
    THROTTLE_RATE_LIST_TAGS_FOR_RESOURCE = "THROTTLE_RATE_LIST_TAGS_FOR_RESOURCE"
    INTERVALS_IN_HISTORICAL_DATA_BACKTEST_MODE = "INTERVALS_IN_HISTORICAL_DATA_BACKTEST_MODE"
    DATA_SIZE_PER_INTERVAL_5M = "DATA_SIZE_PER_INTERVAL_5M"
    DATA_SIZE_PER_INTERVAL_10M = "DATA_SIZE_PER_INTERVAL_10M"
    DATA_SIZE_PER_INTERVAL_1D = "DATA_SIZE_PER_INTERVAL_1D"
    INTERVALS_IN_HISTORICAL_DATA_CONTINUOUS_MODE = "INTERVALS_IN_HISTORICAL_DATA_CONTINUOUS_MODE"
    DATA_SIZE_FOR_HISTORICAL_DATA_BACKTEST_MODE = "DATA_SIZE_FOR_HISTORICAL_DATA_BACKTEST_MODE"
    FILES_IN_HISTORICAL_DATA = "FILES_IN_HISTORICAL_DATA"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AmazonLookoutForVisionQuota")
class AmazonLookoutForVisionQuota(enum.Enum):
    MAXIMUM_IMAGE_FILE_SIZE_IN_MB_FOR_A_TRAINING_OR_TEST_IMAGE = "MAXIMUM_IMAGE_FILE_SIZE_IN_MB_FOR_A_TRAINING_OR_TEST_IMAGE"
    MAXIMUM_NUMBER_OF_MODELS_PER_PROJECT = "MAXIMUM_NUMBER_OF_MODELS_PER_PROJECT"
    MAXIMUM_NUMBER_OF_DETECT_ANOMALIES_API_REQUESTS_PER_SECOND = "MAXIMUM_NUMBER_OF_DETECT_ANOMALIES_API_REQUESTS_PER_SECOND"
    MAXIMUM_NUMBER_OF_PROJECTS = "MAXIMUM_NUMBER_OF_PROJECTS"
    MINIMUM_IMAGE_DIMENSION_IN_PIXELS_FOR_A_TRAINING_OR_TEST_IMAGE = "MINIMUM_IMAGE_DIMENSION_IN_PIXELS_FOR_A_TRAINING_OR_TEST_IMAGE"
    MAXIMUM_NUMBER_OF_IMAGES_IN_A_TRIAL_DETECTION_DATASET = "MAXIMUM_NUMBER_OF_IMAGES_IN_A_TRIAL_DETECTION_DATASET"
    MAXIMUM_NUMBER_OF_INFERENCE_UNITS_PER_STARTED_MODEL = "MAXIMUM_NUMBER_OF_INFERENCE_UNITS_PER_STARTED_MODEL"
    MAXIMUM_NUMBER_OF_CONCURRENT_TRIAL_DETECTION_TASKS = "MAXIMUM_NUMBER_OF_CONCURRENT_TRIAL_DETECTION_TASKS"
    MAXIMUM_NUMBER_OF_RUNNING_MODELS = "MAXIMUM_NUMBER_OF_RUNNING_MODELS"
    MAXIMUM_NUMBER_OF_CONCURRENT_TRAINING_JOBS = "MAXIMUM_NUMBER_OF_CONCURRENT_TRAINING_JOBS"
    MAXIMUM_NUMBER_OF_IMAGES_IN_A_TEST_DATASET = "MAXIMUM_NUMBER_OF_IMAGES_IN_A_TEST_DATASET"
    MAXIMUM_IMAGE_DIMENSION_FOR_A_TRAINING_OR_TEST_IMAGE_IN_PIXELS = "MAXIMUM_IMAGE_DIMENSION_FOR_A_TRAINING_OR_TEST_IMAGE_IN_PIXELS"
    MAXIMUM_NUMBER_OF_CONCURRENT_MODEL_PACKAGING_JOBS = "MAXIMUM_NUMBER_OF_CONCURRENT_MODEL_PACKAGING_JOBS"
    MAXIMUM_NUMBER_OF_API_REQUESTS_PER_SECOND_EXCLUDING_DETECT_ANOMALIES = "MAXIMUM_NUMBER_OF_API_REQUESTS_PER_SECOND_EXCLUDING_DETECT_ANOMALIES"
    MAXIMUM_NUMBER_OF_IMAGES_IN_A_TRAINING_DATASET = "MAXIMUM_NUMBER_OF_IMAGES_IN_A_TRAINING_DATASET"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AmazonMachineLearningQuota")
class AmazonMachineLearningQuota(enum.Enum):
    TOTAL_RATE_OF_ALL_REAL_TIME_PREDICTION_REQUESTS = "TOTAL_RATE_OF_ALL_REAL_TIME_PREDICTION_REQUESTS"
    CLASSES_FOR_MULTICLASS_ML_MODELS = "CLASSES_FOR_MULTICLASS_ML_MODELS"
    VARIABLES_PER_DATA_FILE = "VARIABLES_PER_DATA_FILE"
    TRAINING_DATA_SIZE = "TRAINING_DATA_SIZE"
    RECIPE_COMPLEXITY = "RECIPE_COMPLEXITY"
    JOB_RUNTIME = "JOB_RUNTIME"
    BATCH_PREDICTION_INPUT_SIZE = "BATCH_PREDICTION_INPUT_SIZE"
    ML_MODEL_SIZE = "ML_MODEL_SIZE"
    SIMULTANEOUS_JOBS = "SIMULTANEOUS_JOBS"
    OBSERVATION_SIZE = "OBSERVATION_SIZE"
    BATCH_PREDICTION_INPUT_RECORDS = "BATCH_PREDICTION_INPUT_RECORDS"
    TOTAL_RAM_FOR_ALL_REAL_TIME_PREDICTION_ENDPOINTS = "TOTAL_RAM_FOR_ALL_REAL_TIME_PREDICTION_ENDPOINTS"
    RATE_OF_REAL_TIME_PREDICTION_REQUESTS_PER_ENDPOINT = "RATE_OF_REAL_TIME_PREDICTION_REQUESTS_PER_ENDPOINT"
    TAGS_PER_OBJECT = "TAGS_PER_OBJECT"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AmazonMacieQuota")
class AmazonMacieQuota(enum.Enum):
    SENSITIVE_DATA_DISCOVERY_PER_MONTH_PER_ACCOUNT = "SENSITIVE_DATA_DISCOVERY_PER_MONTH_PER_ACCOUNT"
    CUSTOM_DATA_IDENTIFIERS_PER_SENSITIVE_DATA_DISCOVERY_JOB = "CUSTOM_DATA_IDENTIFIERS_PER_SENSITIVE_DATA_DISCOVERY_JOB"
    NON_BINARY_TEXT_FILE_SIZE = "NON_BINARY_TEXT_FILE_SIZE"
    FINDINGS_RULES = "FINDINGS_RULES"
    APACHE_PARQUET_PARQUET_FILE_SIZE = "APACHE_PARQUET_PARQUET_FILE_SIZE"
    GNU_ZIP_COMPRESSED_ARCHIVE_GZ_OR_GZIP_FILE_SIZE = "GNU_ZIP_COMPRESSED_ARCHIVE_GZ_OR_GZIP_FILE_SIZE"
    FULL_NAMES_DETECTED = "FULL_NAMES_DETECTED"
    PORTABLE_DOCUMENT_FORMAT_PDF_FILE_SIZE = "PORTABLE_DOCUMENT_FORMAT_PDF_FILE_SIZE"
    S3_BUCKETS_PER_SENSITIVE_DATA_DISCOVERY_JOB = "S3_BUCKETS_PER_SENSITIVE_DATA_DISCOVERY_JOB"
    APACHE_AVRO_CONTAINER_AVRO_FILE_SIZE = "APACHE_AVRO_CONTAINER_AVRO_FILE_SIZE"
    ZIP_COMPRESSED_ARCHIVE_ZIP_FILE_SIZE = "ZIP_COMPRESSED_ARCHIVE_ZIP_FILE_SIZE"
    EXTRACTED_ARCHIVE_BYTES = "EXTRACTED_ARCHIVE_BYTES"
    SENSITIVE_DATA_DISCOVERY_OCCURRENCES = "SENSITIVE_DATA_DISCOVERY_OCCURRENCES"
    MEMBER_ACCOUNTS_BY_INVITATION = "MEMBER_ACCOUNTS_BY_INVITATION"
    MAILING_ADDRESSES_DETECTED = "MAILING_ADDRESSES_DETECTED"
    CUSTOM_DATA_IDENTIFIERS_PER_ACCOUNT = "CUSTOM_DATA_IDENTIFIERS_PER_ACCOUNT"
    EXTRACTED_ARCHIVE_FILES = "EXTRACTED_ARCHIVE_FILES"
    MEMBER_ACCOUNTS_THROUGH_AWS_ORGANIZATIONS = "MEMBER_ACCOUNTS_THROUGH_AWS_ORGANIZATIONS"
    NESTED_LEVELS = "NESTED_LEVELS"
    MICROSOFT_EXCEL_WORKBOOK_XLS_OR_XLSX_FILE_SIZE = "MICROSOFT_EXCEL_WORKBOOK_XLS_OR_XLSX_FILE_SIZE"
    NESTED_LEVELS_IN_STRUCTURED_DATA = "NESTED_LEVELS_IN_STRUCTURED_DATA"
    SENSITIVE_DATA_FINDING_OCCURRENCES = "SENSITIVE_DATA_FINDING_OCCURRENCES"
    TAR_ARCHIVE_TAR_FILE_SIZE = "TAR_ARCHIVE_TAR_FILE_SIZE"
    MICROSOFT_WORD_DOCUMENT_DOC_OR_DOCX_FILE_SIZE = "MICROSOFT_WORD_DOCUMENT_DOC_OR_DOCX_FILE_SIZE"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AmazonManagedBlockchainQueryQuota")
class AmazonManagedBlockchainQueryQuota(enum.Enum):
    NUMBER_OF_LIST_ASSET_CONTRACTS_REQUESTS_PER_SECOND = "NUMBER_OF_LIST_ASSET_CONTRACTS_REQUESTS_PER_SECOND"
    NUMBER_OF_GET_TOKEN_BALANCE_REQUESTS_PER_SECOND = "NUMBER_OF_GET_TOKEN_BALANCE_REQUESTS_PER_SECOND"
    NUMBER_OF_LIST_TOKEN_BALANCES_REQUESTS_PER_SECOND = "NUMBER_OF_LIST_TOKEN_BALANCES_REQUESTS_PER_SECOND"
    NUMBER_OF_LIST_TRANSACTIONS_REQUESTS_PER_SECOND = "NUMBER_OF_LIST_TRANSACTIONS_REQUESTS_PER_SECOND"
    NUMBER_OF_GET_TRANSACTION_REQUESTS_PER_SECOND = "NUMBER_OF_GET_TRANSACTION_REQUESTS_PER_SECOND"
    NUMBER_OF_GET_ASSET_CONTRACT_REQUESTS_PER_SECOND = "NUMBER_OF_GET_ASSET_CONTRACT_REQUESTS_PER_SECOND"
    NUMBER_OF_BATCH_GET_TOKEN_BALANCE_REQUESTS_PER_SECOND = "NUMBER_OF_BATCH_GET_TOKEN_BALANCE_REQUESTS_PER_SECOND"
    NUMBER_OF_LIST_TRANSACTION_EVENTS_REQUESTS_PER_SECOND = "NUMBER_OF_LIST_TRANSACTION_EVENTS_REQUESTS_PER_SECOND"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AmazonManagedBlockchainQuota")
class AmazonManagedBlockchainQuota(enum.Enum):
    NUMBER_OF_HYPERLEDGER_FABRIC_CHANNELS_PER_STANDARD_EDITION_NETWORK = "NUMBER_OF_HYPERLEDGER_FABRIC_CHANNELS_PER_STANDARD_EDITION_NETWORK"
    NUMBER_OF_ETHEREUM_NODES_AN_AWS_ACCOUNT_CAN_HAVE = "NUMBER_OF_ETHEREUM_NODES_AN_AWS_ACCOUNT_CAN_HAVE"
    NUMBER_OF_STARTER_EDITION_NETWORKS_IN_WHICH_AN_AWS_ACCOUNT_CAN_HAVE_A_MEMBER = "NUMBER_OF_STARTER_EDITION_NETWORKS_IN_WHICH_AN_AWS_ACCOUNT_CAN_HAVE_A_MEMBER"
    NUMBER_OF_STANDARD_EDITION_NETWORKS_IN_WHICH_AN_AWS_ACCOUNT_CAN_HAVE_A_MEMBER = "NUMBER_OF_STANDARD_EDITION_NETWORKS_IN_WHICH_AN_AWS_ACCOUNT_CAN_HAVE_A_MEMBER"
    NUMBER_OF_HYPERLEDGER_FABRIC_CHANNELS_PER_STARTER_EDITION_NETWORK = "NUMBER_OF_HYPERLEDGER_FABRIC_CHANNELS_PER_STARTER_EDITION_NETWORK"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AmazonManagedGrafanaQuota")
class AmazonManagedGrafanaQuota(enum.Enum):
    NUMBER_OF_WORKSPACES = "NUMBER_OF_WORKSPACES"
    RATE_OF_UPDATE_PERMISSIONS_REQUESTS = "RATE_OF_UPDATE_PERMISSIONS_REQUESTS"
    RATE_OF_DESCRIBE_WORKSPACE_REQUESTS = "RATE_OF_DESCRIBE_WORKSPACE_REQUESTS"
    RATE_OF_CREATE_WORKSPACE_REQUESTS = "RATE_OF_CREATE_WORKSPACE_REQUESTS"
    RATE_OF_DISASSOCIATE_LICENSE_REQUESTS = "RATE_OF_DISASSOCIATE_LICENSE_REQUESTS"
    RATE_OF_LIST_PERMISSIONS_REQUESTS = "RATE_OF_LIST_PERMISSIONS_REQUESTS"
    RATE_OF_ASSOCIATE_LICENSE_REQUESTS = "RATE_OF_ASSOCIATE_LICENSE_REQUESTS"
    RATE_OF_LIST_WORKSPACES_REQUESTS = "RATE_OF_LIST_WORKSPACES_REQUESTS"
    RATE_OF_UPDATE_WORKSPACE_AUTHENTICATION_REQUESTS = "RATE_OF_UPDATE_WORKSPACE_AUTHENTICATION_REQUESTS"
    RATE_OF_UPDATE_WORKSPACE_REQUESTS = "RATE_OF_UPDATE_WORKSPACE_REQUESTS"
    RATE_OF_DELETE_WORKSPACE_REQUESTS = "RATE_OF_DELETE_WORKSPACE_REQUESTS"
    RATE_OF_DESCRIBE_WORKSPACE_AUTHENTICATION_REQUESTS = "RATE_OF_DESCRIBE_WORKSPACE_AUTHENTICATION_REQUESTS"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AmazonManagedPrometheusQuota")
class AmazonManagedPrometheusQuota(enum.Enum):
    NODES_IN_ALERT_MANAGER_ROUTING_TREE = "NODES_IN_ALERT_MANAGER_ROUTING_TREE"
    WORKSPACES_PER_REGION_PER_ACCOUNT = "WORKSPACES_PER_REGION_PER_ACCOUNT"
    ALERT_MANAGER_DEFINITION_FILE_SIZE = "ALERT_MANAGER_DEFINITION_FILE_SIZE"
    RULE_EVALUATION_INTERVAL = "RULE_EVALUATION_INTERVAL"
    NUMBER_OF_API_OPERATIONS_IN_TRANSACTIONS_PER_SECOND = "NUMBER_OF_API_OPERATIONS_IN_TRANSACTIONS_PER_SECOND"
    REQUEST_SIZE = "REQUEST_SIZE"
    METADATA_PER_METRIC = "METADATA_PER_METRIC"
    RULES_PER_WORKSPACE = "RULES_PER_WORKSPACE"
    QUERY_CHUNKS_FETCHED = "QUERY_CHUNKS_FETCHED"
    ALERT_PAYLOAD_SIZE_IN_ALERT_MANAGER = "ALERT_PAYLOAD_SIZE_IN_ALERT_MANAGER"
    QUERY_SAMPLES = "QUERY_SAMPLES"
    LABEL_SIZE = "LABEL_SIZE"
    ALERTS_IN_ALERT_MANAGER = "ALERTS_IN_ALERT_MANAGER"
    QUERY_BYTES_FOR_RANGE_QUERIES = "QUERY_BYTES_FOR_RANGE_QUERIES"
    RULE_GROUP_NAMESPACE_DEFINITION_FILE_SIZE = "RULE_GROUP_NAMESPACE_DEFINITION_FILE_SIZE"
    ACTIVE_SERIES_PER_WORKSPACE = "ACTIVE_SERIES_PER_WORKSPACE"
    HA_TRACKER_CLUSTERS = "HA_TRACKER_CLUSTERS"
    INGESTION_BURST_SIZE_PER_WORKSPACE = "INGESTION_BURST_SIZE_PER_WORKSPACE"
    QUERY_SERIES_FETCHED = "QUERY_SERIES_FETCHED"
    QUERY_TIME_RANGE_IN_DAYS = "QUERY_TIME_RANGE_IN_DAYS"
    ALERT_AGGREGATION_GROUP_SIZE_IN_ALERT_MANAGER_DEFINITION_FILE = "ALERT_AGGREGATION_GROUP_SIZE_IN_ALERT_MANAGER_DEFINITION_FILE"
    RETENTION_TIME_FOR_INGESTED_DATA_IN_DAYS = "RETENTION_TIME_FOR_INGESTED_DATA_IN_DAYS"
    INHIBITION_RULES_IN_ALERT_MANAGER_DEFINITION_FILE = "INHIBITION_RULES_IN_ALERT_MANAGER_DEFINITION_FILE"
    ACTIVE_METRICS_WITH_METADATA_PER_WORKSPACE = "ACTIVE_METRICS_WITH_METADATA_PER_WORKSPACE"
    LABELS_PER_METRIC_SERIES = "LABELS_PER_METRIC_SERIES"
    TEMPLATES_IN_ALERT_MANAGER_DEFINITION_FILE = "TEMPLATES_IN_ALERT_MANAGER_DEFINITION_FILE"
    QUERY_BYTES_FOR_INSTANT_QUERIES = "QUERY_BYTES_FOR_INSTANT_QUERIES"
    INGESTION_RATE_PER_WORKSPACE = "INGESTION_RATE_PER_WORKSPACE"
    METADATA_LENGTH = "METADATA_LENGTH"


@jsii.enum(
    jsii_type="@reapit-cdk/service-quotas.AmazonManagedServiceForApacheFlinkQuota"
)
class AmazonManagedServiceForApacheFlinkQuota(enum.Enum):
    APACHE_FLINK_KINESIS_PROCESSING_UNITS_KP_US = "APACHE_FLINK_KINESIS_PROCESSING_UNITS_KP_US"
    INPUT_PARALLELISM_IN_INPUT_STREAMS_FOR_SQL_APPLICATIONS = "INPUT_PARALLELISM_IN_INPUT_STREAMS_FOR_SQL_APPLICATIONS"
    APPLICATION_COUNT = "APPLICATION_COUNT"
    SQL_KINESIS_PROCESSING_UNITS_KP_US = "SQL_KINESIS_PROCESSING_UNITS_KP_US"


@jsii.enum(
    jsii_type="@reapit-cdk/service-quotas.AmazonManagedStreamingForKafkaMskQuota"
)
class AmazonManagedStreamingForKafkaMskQuota(enum.Enum):
    NUMBER_OF_BROKERS_PER_CLUSTER = "NUMBER_OF_BROKERS_PER_CLUSTER"
    NUMBER_OF_REVISIONS_PER_CONFIGURATION = "NUMBER_OF_REVISIONS_PER_CONFIGURATION"
    NUMBER_OF_REPLICATORS_PER_ACCOUNT = "NUMBER_OF_REPLICATORS_PER_ACCOUNT"
    NUMBER_OF_BROKERS_PER_ACCOUNT = "NUMBER_OF_BROKERS_PER_ACCOUNT"
    NUMBER_OF_CONFIGURATIONS_PER_ACCOUNT = "NUMBER_OF_CONFIGURATIONS_PER_ACCOUNT"


@jsii.enum(
    jsii_type="@reapit-cdk/service-quotas.AmazonManagedWorkflowsForApacheAirflowQuota"
)
class AmazonManagedWorkflowsForApacheAirflowQuota(enum.Enum):
    ENVIRONMENTS_PER_ACCOUNT_PER_REGION = "ENVIRONMENTS_PER_ACCOUNT_PER_REGION"
    WORKERS_PER_ENVIRONMENT = "WORKERS_PER_ENVIRONMENT"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AmazonMonitronQuota")
class AmazonMonitronQuota(enum.Enum):
    GATEWAYS_PER_SITE = "GATEWAYS_PER_SITE"
    USERS_PER_SITE = "USERS_PER_SITE"
    PROJECTS_PER_ACCOUNT = "PROJECTS_PER_ACCOUNT"
    SITES_PER_PROJECT = "SITES_PER_PROJECT"
    POSITIONS_PER_ASSET = "POSITIONS_PER_ASSET"
    ASSETS_PER_SITE = "ASSETS_PER_SITE"
    ASSET_CLASSES_PER_PROJECT = "ASSET_CLASSES_PER_PROJECT"
    POSITIONS_PER_CUSTOM_CLASS = "POSITIONS_PER_CUSTOM_CLASS"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AmazonMqQuota")
class AmazonMqQuota(enum.Enum):
    API_BURST_LIMIT = "API_BURST_LIMIT"
    DESTINATIONS_MONITORED_IN_CLOUD_WATCH_RABBIT_MQ = "DESTINATIONS_MONITORED_IN_CLOUD_WATCH_RABBIT_MQ"
    TEMPORARY_STORAGE_CAPACITY_PER_SMALLER_BROKER = "TEMPORARY_STORAGE_CAPACITY_PER_SMALLER_BROKER"
    REVISIONS_PER_CONFIGURATION = "REVISIONS_PER_CONFIGURATION"
    API_RATE_LIMIT = "API_RATE_LIMIT"
    STORAGE_CAPACITY_PER_SMALLER_BROKER = "STORAGE_CAPACITY_PER_SMALLER_BROKER"
    TAGS_PER_BROKER = "TAGS_PER_BROKER"
    WIRE_LEVEL_CONNECTIONS_PER_SMALLER_BROKER = "WIRE_LEVEL_CONNECTIONS_PER_SMALLER_BROKER"
    USERS_PER_BROKER_SIMPLE_AUTH = "USERS_PER_BROKER_SIMPLE_AUTH"
    TEMPORARY_STORAGE_CAPACITY_PER_LARGER_BROKER = "TEMPORARY_STORAGE_CAPACITY_PER_LARGER_BROKER"
    NUMBER_OF_BROKERS_PER_REGION = "NUMBER_OF_BROKERS_PER_REGION"
    SECURITY_GROUPS_PER_BROKER = "SECURITY_GROUPS_PER_BROKER"
    DESTINATIONS_MONITORED_IN_CLOUD_WATCH_ACTIVE_MQ = "DESTINATIONS_MONITORED_IN_CLOUD_WATCH_ACTIVE_MQ"
    WIRE_LEVEL_CONNECTIONS_PER_LARGER_BROKER = "WIRE_LEVEL_CONNECTIONS_PER_LARGER_BROKER"
    JOB_SCHEDULER_USAGE_LIMIT_PER_BROKER_BACKED_BY_AMAZON_EBS = "JOB_SCHEDULER_USAGE_LIMIT_PER_BROKER_BACKED_BY_AMAZON_EBS"
    GROUPS_PER_USER_SIMPLE_AUTH = "GROUPS_PER_USER_SIMPLE_AUTH"
    STORAGE_CAPACITY_PER_LARGER_BROKER = "STORAGE_CAPACITY_PER_LARGER_BROKER"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AmazonNeptuneAnalyticsQuota")
class AmazonNeptuneAnalyticsQuota(enum.Enum):
    RATE_OF_TAG_RESOURCE_API_REQUESTS = "RATE_OF_TAG_RESOURCE_API_REQUESTS"
    RATE_OF_LIST_GRAPH_SNAPSHOTS_API_REQUESTS = "RATE_OF_LIST_GRAPH_SNAPSHOTS_API_REQUESTS"
    RATE_OF_CREATE_GRAPH_SNAPSHOT_API_REQUESTS = "RATE_OF_CREATE_GRAPH_SNAPSHOT_API_REQUESTS"
    RATE_OF_DELETE_PRIVATE_GRAPH_ENDPOINT_API_REQUESTS = "RATE_OF_DELETE_PRIVATE_GRAPH_ENDPOINT_API_REQUESTS"
    MAXIMUM_PROVISIONED_MEMORY_FOR_EACH_GRAPH = "MAXIMUM_PROVISIONED_MEMORY_FOR_EACH_GRAPH"
    RATE_OF_CREATE_GRAPH_API_REQUESTS = "RATE_OF_CREATE_GRAPH_API_REQUESTS"
    RATE_OF_CANCEL_IMPORT_TASK_API_REQUESTS = "RATE_OF_CANCEL_IMPORT_TASK_API_REQUESTS"
    RATE_OF_UPDATE_GRAPH_API_REQUESTS = "RATE_OF_UPDATE_GRAPH_API_REQUESTS"
    RATE_OF_GET_GRAPH_SNAPSHOT_API_REQUESTS = "RATE_OF_GET_GRAPH_SNAPSHOT_API_REQUESTS"
    RATE_OF_LIST_TAGS_FOR_RESOURCE_API_REQUESTS = "RATE_OF_LIST_TAGS_FOR_RESOURCE_API_REQUESTS"
    RATE_OF_DELETE_GRAPH_SNAPSHOT_API_REQUESTS = "RATE_OF_DELETE_GRAPH_SNAPSHOT_API_REQUESTS"
    RATE_OF_LIST_PRIVATE_GRAPH_ENDPOINTS_API_REQUESTS = "RATE_OF_LIST_PRIVATE_GRAPH_ENDPOINTS_API_REQUESTS"
    RATE_OF_GET_PRIVATE_GRAPH_ENDPOINT_API_REQUESTS = "RATE_OF_GET_PRIVATE_GRAPH_ENDPOINT_API_REQUESTS"
    RATE_OF_CREATE_PRIVATE_GRAPH_ENDPOINT_API_REQUESTS = "RATE_OF_CREATE_PRIVATE_GRAPH_ENDPOINT_API_REQUESTS"
    RATE_OF_LIST_GRAPHS_API_REQUESTS = "RATE_OF_LIST_GRAPHS_API_REQUESTS"
    RATE_OF_RESTORE_GRAPH_FROM_SNAPSHOT_API_REQUESTS = "RATE_OF_RESTORE_GRAPH_FROM_SNAPSHOT_API_REQUESTS"
    MAXIMUM_GRAPHS = "MAXIMUM_GRAPHS"
    RATE_OF_GET_GRAPH_API_REQUESTS = "RATE_OF_GET_GRAPH_API_REQUESTS"
    RATE_OF_UNTAG_RESOURCE_API_REQUESTS = "RATE_OF_UNTAG_RESOURCE_API_REQUESTS"
    MAXIMUM_GRAPH_SNAPSHOTS = "MAXIMUM_GRAPH_SNAPSHOTS"
    RATE_OF_LIST_IMPORT_TASKS_API_REQUESTS = "RATE_OF_LIST_IMPORT_TASKS_API_REQUESTS"
    RATE_OF_RESET_GRAPH_API_REQUESTS = "RATE_OF_RESET_GRAPH_API_REQUESTS"
    RATE_OF_DELETE_GRAPH_API_REQUESTS = "RATE_OF_DELETE_GRAPH_API_REQUESTS"
    RATE_OF_GET_IMPORT_TASK_API_REQUESTS = "RATE_OF_GET_IMPORT_TASK_API_REQUESTS"
    RATE_OF_CREATE_GRAPH_USING_IMPORT_TASK_API_REQUESTS = "RATE_OF_CREATE_GRAPH_USING_IMPORT_TASK_API_REQUESTS"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AmazonNeptuneQuota")
class AmazonNeptuneQuota(enum.Enum):
    DB_SUBNET_GROUPS = "DB_SUBNET_GROUPS"
    DB_INSTANCES = "DB_INSTANCES"
    EVENT_SUBSCRIPTIONS = "EVENT_SUBSCRIPTIONS"
    READ_REPLICAS_PER_CLUSTER = "READ_REPLICAS_PER_CLUSTER"
    DB_INSTANCE_PARAMETER_GROUPS = "DB_INSTANCE_PARAMETER_GROUPS"
    TAGS_PER_RESOURCE = "TAGS_PER_RESOURCE"
    RESERVED_DB_INSTANCES = "RESERVED_DB_INSTANCES"
    DB_CLUSTER_ROLES = "DB_CLUSTER_ROLES"
    DB_CLUSTER_MANUALS_SNAPSHOTS = "DB_CLUSTER_MANUALS_SNAPSHOTS"
    CLUSTER_ENDPOINTS_PER_DB_CLUSTER = "CLUSTER_ENDPOINTS_PER_DB_CLUSTER"
    CROSS_REGION_SNAPSHOT_COPY_REQUESTS = "CROSS_REGION_SNAPSHOT_COPY_REQUESTS"
    DB_CLUSTER_PARAMETER_GROUPS = "DB_CLUSTER_PARAMETER_GROUPS"
    DB_CLUSTERS = "DB_CLUSTERS"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AmazonNimbleStudioQuota")
class AmazonNimbleStudioQuota(enum.Enum):
    CUSTOM_STREAMING_IMAGES_PER_STUDIO = "CUSTOM_STREAMING_IMAGES_PER_STUDIO"
    STUDIO_COMPONENTS_PER_STUDIO = "STUDIO_COMPONENTS_PER_STUDIO"
    STREAMING_SESSION_BACKUPS_PER_STUDIO = "STREAMING_SESSION_BACKUPS_PER_STUDIO"
    G5_STREAMING_SESSIONS_PER_STUDIO = "G5_STREAMING_SESSIONS_PER_STUDIO"
    ACTIVE_DIRECTORY_STUDIO_COMPONENTS_PER_STUDIO = "ACTIVE_DIRECTORY_STUDIO_COMPONENTS_PER_STUDIO"
    LAUNCH_PROFILES_PER_STUDIO = "LAUNCH_PROFILES_PER_STUDIO"
    STUDIO_CREATION_PER_ACCOUNT = "STUDIO_CREATION_PER_ACCOUNT"
    SHARED_FILE_SYSTEM_STUDIO_COMPONENTS_PER_STUDIO = "SHARED_FILE_SYSTEM_STUDIO_COMPONENTS_PER_STUDIO"
    STREAMING_SESSIONS_PER_STUDIO = "STREAMING_SESSIONS_PER_STUDIO"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AmazonOpenSearchServerlessQuota")
class AmazonOpenSearchServerlessQuota(enum.Enum):
    ENCRYPTION_POLICY_SIZE = "ENCRYPTION_POLICY_SIZE"
    NETWORK_POLICY_SIZE = "NETWORK_POLICY_SIZE"
    DEFAULT_INDEXING_CAPACITY_OC_US = "DEFAULT_INDEXING_CAPACITY_OC_US"
    SAML_PROVIDERS = "SAML_PROVIDERS"
    DATA_ACCESS_POLICY_SIZE = "DATA_ACCESS_POLICY_SIZE"
    NETWORK_POLICIES = "NETWORK_POLICIES"
    RETENTION_POLICY_SIZE = "RETENTION_POLICY_SIZE"
    RETENTION_POLICIES = "RETENTION_POLICIES"
    DEFAULT_SEARCH_CAPACITY_OC_US = "DEFAULT_SEARCH_CAPACITY_OC_US"
    ENCRYPTION_POLICIES = "ENCRYPTION_POLICIES"
    DATA_ACCESS_POLICIES = "DATA_ACCESS_POLICIES"
    MAXIMUM_INDEXING_CAPACITY_OC_US = "MAXIMUM_INDEXING_CAPACITY_OC_US"
    MAXIMUM_SEARCH_CAPACITY_OC_US = "MAXIMUM_SEARCH_CAPACITY_OC_US"
    SAML_PROVIDER_SIZE = "SAML_PROVIDER_SIZE"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AmazonOpenSearchServiceQuota")
class AmazonOpenSearchServiceQuota(enum.Enum):
    WARM_INSTANCES_PER_DOMAIN = "WARM_INSTANCES_PER_DOMAIN"
    INSTANCES_PER_DOMAIN = "INSTANCES_PER_DOMAIN"
    DEDICATED_MASTER_INSTANCES_PER_DOMAIN = "DEDICATED_MASTER_INSTANCES_PER_DOMAIN"
    DOMAINS_PER_REGION = "DOMAINS_PER_REGION"
    INSTANCES_PER_DOMAIN_T2_INSTANCE_TYPE = "INSTANCES_PER_DOMAIN_T2_INSTANCE_TYPE"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AmazonPersonalizeQuota")
class AmazonPersonalizeQuota(enum.Enum):
    RATE_OF_DELETE_DATASET_GROUP_REQUESTS = "RATE_OF_DELETE_DATASET_GROUP_REQUESTS"
    RATE_OF_PUT_EVENTS_REQUESTS_PER_DATASET_GROUP = "RATE_OF_PUT_EVENTS_REQUESTS_PER_DATASET_GROUP"
    NUMBER_OF_INTERACTIONS_FOR_MODEL_TRAINING = "NUMBER_OF_INTERACTIONS_FOR_MODEL_TRAINING"
    RATE_OF_GET_PERSONALIZED_RANKING_REQUESTS_PER_CAMPAIGN = "RATE_OF_GET_PERSONALIZED_RANKING_REQUESTS_PER_CAMPAIGN"
    RATE_OF_CREATE_SOLUTION_VERSION_REQUESTS = "RATE_OF_CREATE_SOLUTION_VERSION_REQUESTS"
    RATE_OF_DESCRIBE_DATASET_GROUP_REQUESTS = "RATE_OF_DESCRIBE_DATASET_GROUP_REQUESTS"
    RATE_OF_CREATE_CAMPAIGN_REQUESTS = "RATE_OF_CREATE_CAMPAIGN_REQUESTS"
    RATE_OF_DESCRIBE_DATASET_IMPORT_JOB_REQUESTS = "RATE_OF_DESCRIBE_DATASET_IMPORT_JOB_REQUESTS"
    RATE_OF_DELETE_DATASET_IMPORT_JOB_REQUESTS = "RATE_OF_DELETE_DATASET_IMPORT_JOB_REQUESTS"
    NUMBER_OF_ACTION_INTERACTIONS_FOR_MODEL_TRAINING = "NUMBER_OF_ACTION_INTERACTIONS_FOR_MODEL_TRAINING"
    RATE_OF_LIST_EVENT_TRACKERS_REQUESTS = "RATE_OF_LIST_EVENT_TRACKERS_REQUESTS"
    RATE_OF_DESCRIBE_SOLUTION_REQUESTS = "RATE_OF_DESCRIBE_SOLUTION_REQUESTS"
    RATE_OF_DELETE_EVENT_TRACKER_REQUESTS = "RATE_OF_DELETE_EVENT_TRACKER_REQUESTS"
    RATE_OF_LIST_DATASET_IMPORT_JOBS_REQUESTS = "RATE_OF_LIST_DATASET_IMPORT_JOBS_REQUESTS"
    MAXIMUM_NUMBER_OF_INTERACTIONS_PER_EVENT_TYPE_PER_USER_CONSIDERED_BY_A_FILTER = "MAXIMUM_NUMBER_OF_INTERACTIONS_PER_EVENT_TYPE_PER_USER_CONSIDERED_BY_A_FILTER"
    RATE_OF_DELETE_DATASET_REQUESTS = "RATE_OF_DELETE_DATASET_REQUESTS"
    RATE_OF_PUT_ACTION_INTERACTIONS_REQUESTS_PER_DATASET_GROUP = "RATE_OF_PUT_ACTION_INTERACTIONS_REQUESTS_PER_DATASET_GROUP"
    RATE_OF_DELETE_SOLUTION_REQUESTS = "RATE_OF_DELETE_SOLUTION_REQUESTS"
    RATE_OF_GET_RECOMMENDATIONS_REQUESTS_PER_CAMPAIGN = "RATE_OF_GET_RECOMMENDATIONS_REQUESTS_PER_CAMPAIGN"
    EVENT_SIZE = "EVENT_SIZE"
    RATE_OF_LIST_SCHEMAS_REQUESTS = "RATE_OF_LIST_SCHEMAS_REQUESTS"
    AMOUNT_OF_DATA_FOR_POPULARITY_COUNT_RECIPE = "AMOUNT_OF_DATA_FOR_POPULARITY_COUNT_RECIPE"
    NUMBER_OF_SCHEMAS = "NUMBER_OF_SCHEMAS"
    NUMBER_OF_ITEMS_USED_IN_MODEL_TRAINING = "NUMBER_OF_ITEMS_USED_IN_MODEL_TRAINING"
    RATE_OF_DESCRIBE_EVENT_TRACKER_REQUESTS = "RATE_OF_DESCRIBE_EVENT_TRACKER_REQUESTS"
    AMOUNT_OF_USERS_AND_ITEMS_DATA_COMBINED_FOR_HRNN_METADATA_RECIPE = "AMOUNT_OF_USERS_AND_ITEMS_DATA_COMBINED_FOR_HRNN_METADATA_RECIPE"
    RATE_OF_CREATE_SOLUTION_REQUESTS = "RATE_OF_CREATE_SOLUTION_REQUESTS"
    RATE_OF_UPDATE_DATASET_REQUESTS = "RATE_OF_UPDATE_DATASET_REQUESTS"
    RATE_OF_LIST_CAMPAIGNS_REQUESTS = "RATE_OF_LIST_CAMPAIGNS_REQUESTS"
    RATE_OF_DELETE_CAMPAIGN_REQUESTS = "RATE_OF_DELETE_CAMPAIGN_REQUESTS"
    RATE_OF_UPDATE_CAMPAIGN_REQUESTS = "RATE_OF_UPDATE_CAMPAIGN_REQUESTS"
    RATE_OF_GET_ACTION_RECOMMENDATIONS_REQUESTS_PER_CAMPAIGN = "RATE_OF_GET_ACTION_RECOMMENDATIONS_REQUESTS_PER_CAMPAIGN"
    RATE_OF_CREATE_EVENT_TRACKER_REQUESTS = "RATE_OF_CREATE_EVENT_TRACKER_REQUESTS"
    NUMBER_OF_ACTIONS_USED_IN_MODEL_TRAINING = "NUMBER_OF_ACTIONS_USED_IN_MODEL_TRAINING"
    RATE_OF_DESCRIBE_RECIPE_REQUESTS = "RATE_OF_DESCRIBE_RECIPE_REQUESTS"
    ACTIVE_FILTERS_PER_DATASET_GROUP = "ACTIVE_FILTERS_PER_DATASET_GROUP"
    MINIMUM_DATA_POINTS_FOR_MODEL_TRAINING = "MINIMUM_DATA_POINTS_FOR_MODEL_TRAINING"
    RATE_OF_LIST_RECIPES_REQUESTS = "RATE_OF_LIST_RECIPES_REQUESTS"
    MAXIMUM_NUMBER_OF_ACTION_INTERACTIONS_PER_EVENT_TYPE_PER_USER_CONSIDERED_BY_A_FILTER = "MAXIMUM_NUMBER_OF_ACTION_INTERACTIONS_PER_EVENT_TYPE_PER_USER_CONSIDERED_BY_A_FILTER"
    AMOUNT_OF_USERS_AND_ITEMS_DATA_COMBINED_FOR_HRNN_COLDSTART_RECIPE = "AMOUNT_OF_USERS_AND_ITEMS_DATA_COMBINED_FOR_HRNN_COLDSTART_RECIPE"
    AMOUNT_OF_DATA_FOR_SIMS_RECIPE = "AMOUNT_OF_DATA_FOR_SIMS_RECIPE"
    NUMBER_OF_ACTION_INTERACTION_EVENTS_IN_A_PUT_ACTION_INTERACTIONS_CALL = "NUMBER_OF_ACTION_INTERACTION_EVENTS_IN_A_PUT_ACTION_INTERACTIONS_CALL"
    RATE_OF_LIST_SOLUTIONS_REQUESTS = "RATE_OF_LIST_SOLUTIONS_REQUESTS"
    ACTIVE_CAMPAIGNS_PER_DATASET_GROUP = "ACTIVE_CAMPAIGNS_PER_DATASET_GROUP"
    RATE_OF_DESCRIBE_DATASET_REQUESTS = "RATE_OF_DESCRIBE_DATASET_REQUESTS"
    ACTIVE_DATASET_GROUPS = "ACTIVE_DATASET_GROUPS"
    RATE_OF_DESCRIBE_SCHEMA_REQUESTS = "RATE_OF_DESCRIBE_SCHEMA_REQUESTS"
    ACTIVE_SOLUTIONS_PER_DATASET_GROUP = "ACTIVE_SOLUTIONS_PER_DATASET_GROUP"
    RATE_OF_LIST_DATASETS_REQUESTS = "RATE_OF_LIST_DATASETS_REQUESTS"
    RATE_OF_TRANSACTIONS_PER_ACCOUNT = "RATE_OF_TRANSACTIONS_PER_ACCOUNT"
    PENDING_OR_IN_PROGRESS_BATCH_INFERENCE_JOBS = "PENDING_OR_IN_PROGRESS_BATCH_INFERENCE_JOBS"
    PENDING_OR_IN_PROGRESS_SOLUTION_VERSIONS = "PENDING_OR_IN_PROGRESS_SOLUTION_VERSIONS"
    RATE_OF_DESCRIBE_FEATURE_TRANSFORMATION_REQUESTS = "RATE_OF_DESCRIBE_FEATURE_TRANSFORMATION_REQUESTS"
    MINIMUM_UNIQUE_USERS_FOR_MODEL_TRAINING = "MINIMUM_UNIQUE_USERS_FOR_MODEL_TRAINING"
    RATE_OF_LIST_DATASET_IMPORT_JOB_RUNS_REQUESTS = "RATE_OF_LIST_DATASET_IMPORT_JOB_RUNS_REQUESTS"
    RATE_OF_CREATE_DATASET_GROUP_REQUESTS = "RATE_OF_CREATE_DATASET_GROUP_REQUESTS"
    MAXIMUM_NUMBER_OF_RECOMMENDERS_PER_DATASET_GROUP = "MAXIMUM_NUMBER_OF_RECOMMENDERS_PER_DATASET_GROUP"
    AMOUNT_OF_DATA_PER_INCREMENTAL_IMPORT = "AMOUNT_OF_DATA_PER_INCREMENTAL_IMPORT"
    AMOUNT_OF_DATA_FOR_PERSONALIZED_RANKING_RECIPE = "AMOUNT_OF_DATA_FOR_PERSONALIZED_RANKING_RECIPE"
    AMOUNT_OF_INTERACTIONS_DATA_FOR_HRNN_COLDSTART_RECIPE = "AMOUNT_OF_INTERACTIONS_DATA_FOR_HRNN_COLDSTART_RECIPE"
    AMOUNT_OF_INTERACTIONS_DATA_FOR_HRNN_METADATA_RECIPE = "AMOUNT_OF_INTERACTIONS_DATA_FOR_HRNN_METADATA_RECIPE"
    RATE_OF_GET_SOLUTION_METRICS_REQUESTS = "RATE_OF_GET_SOLUTION_METRICS_REQUESTS"
    RATE_OF_CREATE_DATASET_REQUESTS = "RATE_OF_CREATE_DATASET_REQUESTS"
    RATE_OF_CREATE_DATASET_IMPORT_JOB_REQUESTS = "RATE_OF_CREATE_DATASET_IMPORT_JOB_REQUESTS"
    AMOUNT_OF_DATA_FOR_HRNN_RECIPE = "AMOUNT_OF_DATA_FOR_HRNN_RECIPE"
    RATE_OF_DESCRIBE_CAMPAIGN_REQUESTS = "RATE_OF_DESCRIBE_CAMPAIGN_REQUESTS"
    NUMBER_OF_EVENTS_IN_PUT_EVENTS_CALL = "NUMBER_OF_EVENTS_IN_PUT_EVENTS_CALL"
    RATE_OF_DESCRIBE_ALGORITHM_REQUESTS = "RATE_OF_DESCRIBE_ALGORITHM_REQUESTS"
    RATE_OF_LIST_DATASET_GROUPS_REQUESTS = "RATE_OF_LIST_DATASET_GROUPS_REQUESTS"
    RATE_OF_LIST_SOLUTION_VERSIONS_REQUESTS = "RATE_OF_LIST_SOLUTION_VERSIONS_REQUESTS"
    RATE_OF_CREATE_SCHEMA_REQUESTS = "RATE_OF_CREATE_SCHEMA_REQUESTS"
    RATE_OF_DELETE_SCHEMA_REQUESTS = "RATE_OF_DELETE_SCHEMA_REQUESTS"
    PUT_ACTION_INTERACTIONS_EVENT_SIZE = "PUT_ACTION_INTERACTIONS_EVENT_SIZE"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AmazonPinpointQuota")
class AmazonPinpointQuota(enum.Enum):
    UPDATE_SMS_TEMPLATE_OPERATION_RATE_QUOTA = "UPDATE_SMS_TEMPLATE_OPERATION_RATE_QUOTA"
    UPDATE_ENDPOINT_OPERATION_RATE_QUOTA = "UPDATE_ENDPOINT_OPERATION_RATE_QUOTA"
    UPDATE_IN_APP_TEMPLATE_OPERATION_BURST_QUOTA = "UPDATE_IN_APP_TEMPLATE_OPERATION_BURST_QUOTA"
    ACTIVE_CAMPAIGNS_PER_ACCOUNT = "ACTIVE_CAMPAIGNS_PER_ACCOUNT"
    UPDATE_EMAIL_TEMPLATE_OPERATION_RATE_QUOTA = "UPDATE_EMAIL_TEMPLATE_OPERATION_RATE_QUOTA"
    DELETE_ENDPOINT_OPERATION_RATE_QUOTA = "DELETE_ENDPOINT_OPERATION_RATE_QUOTA"
    UPDATE_ENDPOINT_OPERATION_BURST_QUOTA = "UPDATE_ENDPOINT_OPERATION_BURST_QUOTA"
    PUT_EVENTS_OPERATION_RATE_QUOTA = "PUT_EVENTS_OPERATION_RATE_QUOTA"
    NUMBER_OF_IMPORT_FILES_PER_IMPORT_JOB = "NUMBER_OF_IMPORT_FILES_PER_IMPORT_JOB"
    CREATE_EMAIL_TEMPLATE_OPERATION_BURST_QUOTA = "CREATE_EMAIL_TEMPLATE_OPERATION_BURST_QUOTA"
    DELETE_ENDPOINT_OPERATION_BURST_QUOTA = "DELETE_ENDPOINT_OPERATION_BURST_QUOTA"
    UPDATE_VOICE_TEMPLATE_OPERATION_BURST_QUOTA = "UPDATE_VOICE_TEMPLATE_OPERATION_BURST_QUOTA"
    UPDATE_IN_APP_TEMPLATE_OPERATION_RATE_QUOTA = "UPDATE_IN_APP_TEMPLATE_OPERATION_RATE_QUOTA"
    GET_ENDPOINT_OPERATION_BURST_QUOTA = "GET_ENDPOINT_OPERATION_BURST_QUOTA"
    CREATE_VOICE_TEMPLATE_OPERATION_BURST_QUOTA = "CREATE_VOICE_TEMPLATE_OPERATION_BURST_QUOTA"
    CREATE_IN_APP_TEMPLATE_OPERATION_BURST_QUOTA = "CREATE_IN_APP_TEMPLATE_OPERATION_BURST_QUOTA"
    CREATE_EMAIL_TEMPLATE_OPERATION_RATE_QUOTA = "CREATE_EMAIL_TEMPLATE_OPERATION_RATE_QUOTA"
    MAXIMUM_NUMBER_OF_JOURNEY_ACTIVITIES_PER_JOURNEY = "MAXIMUM_NUMBER_OF_JOURNEY_ACTIVITIES_PER_JOURNEY"
    CREATE_PUSH_TEMPLATE_OPERATION_BURST_QUOTA = "CREATE_PUSH_TEMPLATE_OPERATION_BURST_QUOTA"
    NUMBER_OF_EVENT_BASED_CAMPAIGNS = "NUMBER_OF_EVENT_BASED_CAMPAIGNS"
    UPDATE_PUSH_TEMPLATE_OPERATION_BURST_QUOTA = "UPDATE_PUSH_TEMPLATE_OPERATION_BURST_QUOTA"
    PUT_EVENTS_OPERATION_BURST_QUOTA = "PUT_EVENTS_OPERATION_BURST_QUOTA"
    CREATE_SMS_TEMPLATE_OPERATION_BURST_QUOTA = "CREATE_SMS_TEMPLATE_OPERATION_BURST_QUOTA"
    ACTIVE_IN_APP_CAMPAIGNS_PER_PROJECT = "ACTIVE_IN_APP_CAMPAIGNS_PER_PROJECT"
    UPDATE_ENDPOINTS_BATCH_OPERATION_BURST_QUOTA = "UPDATE_ENDPOINTS_BATCH_OPERATION_BURST_QUOTA"
    MAXIMUM_NUMBER_OF_ACTIVE_EVENT_TRIGGERED_JOURNEYS_PER_ACCOUNT = "MAXIMUM_NUMBER_OF_ACTIVE_EVENT_TRIGGERED_JOURNEYS_PER_ACCOUNT"
    CREATE_PUSH_TEMPLATE_OPERATION_RATE_QUOTA = "CREATE_PUSH_TEMPLATE_OPERATION_RATE_QUOTA"
    UPDATE_ENDPOINTS_BATCH_OPERATION_RATE_QUOTA = "UPDATE_ENDPOINTS_BATCH_OPERATION_RATE_QUOTA"
    UPDATE_SMS_TEMPLATE_OPERATION_BURST_QUOTA = "UPDATE_SMS_TEMPLATE_OPERATION_BURST_QUOTA"
    UPDATE_PUSH_TEMPLATE_OPERATION_RATE_QUOTA = "UPDATE_PUSH_TEMPLATE_OPERATION_RATE_QUOTA"
    CREATE_SMS_TEMPLATE_OPERATION_RATE_QUOTA = "CREATE_SMS_TEMPLATE_OPERATION_RATE_QUOTA"
    CREATE_IN_APP_TEMPLATE_OPERATION_RATE_QUOTA = "CREATE_IN_APP_TEMPLATE_OPERATION_RATE_QUOTA"
    UPDATE_EMAIL_TEMPLATE_OPERATION_BURST_QUOTA = "UPDATE_EMAIL_TEMPLATE_OPERATION_BURST_QUOTA"
    CREATE_VOICE_TEMPLATE_OPERATION_RATE_QUOTA = "CREATE_VOICE_TEMPLATE_OPERATION_RATE_QUOTA"
    GET_ENDPOINT_OPERATION_RATE_QUOTA = "GET_ENDPOINT_OPERATION_RATE_QUOTA"
    MAXIMUM_NUMBER_OF_ACTIVE_JOURNEYS_PER_ACCOUNT = "MAXIMUM_NUMBER_OF_ACTIVE_JOURNEYS_PER_ACCOUNT"
    UPDATE_VOICE_TEMPLATE_OPERATION_RATE_QUOTA = "UPDATE_VOICE_TEMPLATE_OPERATION_RATE_QUOTA"
    MAXIMUM_NUMBER_OF_EVENT_ATTRIBUTES_PER_ENDPOINT_IN_A_CUSTOM_CHANNEL_RESPONSE = "MAXIMUM_NUMBER_OF_EVENT_ATTRIBUTES_PER_ENDPOINT_IN_A_CUSTOM_CHANNEL_RESPONSE"
    NUMBER_OF_VOICE_MESSAGES_THAT_CAN_BE_SENT_TO_A_SINGLE_RECIPIENT_DURING_A_24_HOUR_PERIOD = "NUMBER_OF_VOICE_MESSAGES_THAT_CAN_BE_SENT_TO_A_SINGLE_RECIPIENT_DURING_A_24_HOUR_PERIOD"
    MAXIMUM_NUMBER_OF_CUSTOM_ATTRIBUTE_VALUES_PER_ATTRIBUTE_KEY = "MAXIMUM_NUMBER_OF_CUSTOM_ATTRIBUTE_VALUES_PER_ATTRIBUTE_KEY"
    MAXIMUM_SIZE_OF_A_REQUEST = "MAXIMUM_SIZE_OF_A_REQUEST"
    NUMBER_OF_ATTRIBUTES_ASSIGNED_TO_THE_METRICS_PARAMETER = "NUMBER_OF_ATTRIBUTES_ASSIGNED_TO_THE_METRICS_PARAMETER"
    MAXIMUM_NUMBER_OF_ATTEMPTS_TO_INVOKE_A_LAMBDA_FUNCTION = "MAXIMUM_NUMBER_OF_ATTEMPTS_TO_INVOKE_A_LAMBDA_FUNCTION"
    MAXIMUM_NUMBER_OF_DIMENSIONS_THAT_CAN_BE_USED_TO_CREATE_A_SEGMENT = "MAXIMUM_NUMBER_OF_DIMENSIONS_THAT_CAN_BE_USED_TO_CREATE_A_SEGMENT"
    MAXIMUM_NUMBER_OF_CHARACTERS_PER_ATTRIBUTE_VALUE = "MAXIMUM_NUMBER_OF_CHARACTERS_PER_ATTRIBUTE_VALUE"
    MAXIMUM_NUMBER_OF_MODEL_CONFIGURATIONS_PER_ACCOUNT = "MAXIMUM_NUMBER_OF_MODEL_CONFIGURATIONS_PER_ACCOUNT"
    MAXIMUM_NUMBER_OF_CHARACTERS_IN_ADM_SPECIFIC_TEMPLATE_PARTS_OF_A_PUSH_NOTIFICATION_TEMPLATE = "MAXIMUM_NUMBER_OF_CHARACTERS_IN_ADM_SPECIFIC_TEMPLATE_PARTS_OF_A_PUSH_NOTIFICATION_TEMPLATE"
    MAXIMUM_NUMBER_OF_RECOMMENDED_ATTRIBUTES_PER_ENDPOINT_OR_USER_AWS_LAMBDA_FUNCTION = "MAXIMUM_NUMBER_OF_RECOMMENDED_ATTRIBUTES_PER_ENDPOINT_OR_USER_AWS_LAMBDA_FUNCTION"
    MAXIMUM_LENGTH_OF_A_RECOMMENDED_ATTRIBUTE_VALUE_THAT_S_RETRIEVED_FROM_AMAZON_PERSONALIZE = "MAXIMUM_LENGTH_OF_A_RECOMMENDED_ATTRIBUTE_VALUE_THAT_S_RETRIEVED_FROM_AMAZON_PERSONALIZE"
    VOICE_MESSAGE_LENGTH = "VOICE_MESSAGE_LENGTH"
    MAXIMUM_NUMBER_OF_CHARACTERS_IN_FCM_SPECIFIC_TEMPLATE_PARTS_OF_A_PUSH_NOTIFICATION_TEMPLATE = "MAXIMUM_NUMBER_OF_CHARACTERS_IN_FCM_SPECIFIC_TEMPLATE_PARTS_OF_A_PUSH_NOTIFICATION_TEMPLATE"
    MAXIMUM_SEGMENT_SIZE_PER_JOURNEY = "MAXIMUM_SEGMENT_SIZE_PER_JOURNEY"
    NUMBER_OF_ENDPOINT_BATCH_ITEM_OBJECTS_IN_AN_ENDPOINT_BATCH_REQUEST_PAYLOAD = "NUMBER_OF_ENDPOINT_BATCH_ITEM_OBJECTS_IN_AN_ENDPOINT_BATCH_REQUEST_PAYLOAD"
    MAXIMUM_NUMBER_OF_CHARACTERS_IN_APN_SPECIFIC_TEMPLATE_PARTS_OF_A_PUSH_NOTIFICATION_TEMPLATE = "MAXIMUM_NUMBER_OF_CHARACTERS_IN_APN_SPECIFIC_TEMPLATE_PARTS_OF_A_PUSH_NOTIFICATION_TEMPLATE"
    NUMBER_OF_VOICE_MESSAGES_THAT_CAN_BE_SENT_FROM_A_SINGLE_ORIGINATING_PHONE_NUMBER_PER_SECOND = "NUMBER_OF_VOICE_MESSAGES_THAT_CAN_BE_SENT_FROM_A_SINGLE_ORIGINATING_PHONE_NUMBER_PER_SECOND"
    SEND_MESSAGES_OPERATION_BURST_QUOTA = "SEND_MESSAGES_OPERATION_BURST_QUOTA"
    NUMBER_OF_VALUES_ASSIGNED_TO_THE_USER_ATTRIBUTES_PARAMETER_ATTRIBUTES_PER_ATTRIBUTE = "NUMBER_OF_VALUES_ASSIGNED_TO_THE_USER_ATTRIBUTES_PARAMETER_ATTRIBUTES_PER_ATTRIBUTE"
    NUMBER_OF_SMS_MESSAGES_THAT_CAN_BE_SENT_TO_A_SINGLE_RECIPIENT_EACH_SECOND = "NUMBER_OF_SMS_MESSAGES_THAT_CAN_BE_SENT_TO_A_SINGLE_RECIPIENT_EACH_SECOND"
    MAXIMUM_NUMBER_OF_CHARACTERS_PER_ATTRIBUTE_KEY = "MAXIMUM_NUMBER_OF_CHARACTERS_PER_ATTRIBUTE_KEY"
    NUMBER_OF_AMAZON_PINPOINT_PROJECTS = "NUMBER_OF_AMAZON_PINPOINT_PROJECTS"
    MAXIMUM_SIZE_PER_ENDPOINT = "MAXIMUM_SIZE_PER_ENDPOINT"
    NUMBER_OF_RECIPIENTS_PER_MESSAGE = "NUMBER_OF_RECIPIENTS_PER_MESSAGE"
    PHONE_NUMBER_VALIDATE_OPERATION_BURST_QUOTA = "PHONE_NUMBER_VALIDATE_OPERATION_BURST_QUOTA"
    MAXIMUM_NUMBER_OF_CUSTOM_ATTRIBUTE_KEYS_PER_APP = "MAXIMUM_NUMBER_OF_CUSTOM_ATTRIBUTE_KEYS_PER_APP"
    NUMBER_OF_SMS_MESSAGES_THAT_CAN_BE_SENT_EACH_SECOND_SENDING_RATE = "NUMBER_OF_SMS_MESSAGES_THAT_CAN_BE_SENT_EACH_SECOND_SENDING_RATE"
    INVOCATION_PAYLOAD_SIZE = "INVOCATION_PAYLOAD_SIZE"
    NUMBER_OF_CHARACTERS_IN_A_VOICE_MESSAGE = "NUMBER_OF_CHARACTERS_IN_A_VOICE_MESSAGE"
    NUMBER_OF_ENDPOINTS_WITH_THE_SAME_USER_ID = "NUMBER_OF_ENDPOINTS_WITH_THE_SAME_USER_ID"
    ATTRIBUTE_VALUE_LENGTH = "ATTRIBUTE_VALUE_LENGTH"
    MAXIMUM_NUMBER_OF_RECOMMENDED_ATTRIBUTES_PER_ENDPOINT_OR_USER = "MAXIMUM_NUMBER_OF_RECOMMENDED_ATTRIBUTES_PER_ENDPOINT_OR_USER"
    MAXIMUM_NUMBER_OF_EVENTS_IN_A_REQUEST = "MAXIMUM_NUMBER_OF_EVENTS_IN_A_REQUEST"
    NUMBER_OF_VOICE_MESSAGES_THAT_CAN_BE_SENT_PER_MINUTE = "NUMBER_OF_VOICE_MESSAGES_THAT_CAN_BE_SENT_PER_MINUTE"
    MAXIMUM_NUMBER_OF_CUSTOM_EVENT_TYPES_PER_APP = "MAXIMUM_NUMBER_OF_CUSTOM_EVENT_TYPES_PER_APP"
    DELETE_SEGMENT_OPERATION_BURST_QUOTA = "DELETE_SEGMENT_OPERATION_BURST_QUOTA"
    MAXIMUM_LENGTH_OF_A_RECOMMENDED_ATTRIBUTE_DISPLAY_NAME = "MAXIMUM_LENGTH_OF_A_RECOMMENDED_ATTRIBUTE_DISPLAY_NAME"
    MAXIMUM_NUMBER_OF_RECOMMENDATIONS_PER_ENDPOINT_OR_USER = "MAXIMUM_NUMBER_OF_RECOMMENDATIONS_PER_ENDPOINT_OR_USER"
    MAXIMUM_NUMBER_OF_CHARACTERS_IN_AN_SMS_TEMPLATE = "MAXIMUM_NUMBER_OF_CHARACTERS_IN_AN_SMS_TEMPLATE"
    ATTRIBUTE_NAME_LENGTH = "ATTRIBUTE_NAME_LENGTH"
    AMAZON_DEVICE_MESSAGING_ADM_MESSAGE_PAYLOAD_SIZE_PER_MESSAGE = "AMAZON_DEVICE_MESSAGING_ADM_MESSAGE_PAYLOAD_SIZE_PER_MESSAGE"
    DELETE_SEGMENT_OPERATION_RATE_QUOTA = "DELETE_SEGMENT_OPERATION_RATE_QUOTA"
    MAXIMUM_LENGTH_OF_A_RECOMMENDED_ATTRIBUTE_NAME = "MAXIMUM_LENGTH_OF_A_RECOMMENDED_ATTRIBUTE_NAME"
    SEND_USERS_MESSAGES_OPERATION_BURST_QUOTA = "SEND_USERS_MESSAGES_OPERATION_BURST_QUOTA"
    NUMBER_OF_VOICE_CONFIGURATION_SETS_PER_AWS_REGION = "NUMBER_OF_VOICE_CONFIGURATION_SETS_PER_AWS_REGION"
    MAXIMUM_AMOUNT_OF_TIME_TO_WAIT_FOR_A_LAMBDA_FUNCTION_TO_PROCESS_DATA = "MAXIMUM_AMOUNT_OF_TIME_TO_WAIT_FOR_A_LAMBDA_FUNCTION_TO_PROCESS_DATA"
    NUMBER_OF_ATTRIBUTES_ASSIGNED_TO_THE_ATTRIBUTES_METRICS_AND_USER_ATTRIBUTES_PARAMETERS_COLLECTIVELY = "NUMBER_OF_ATTRIBUTES_ASSIGNED_TO_THE_ATTRIBUTES_METRICS_AND_USER_ATTRIBUTES_PARAMETERS_COLLECTIVELY"
    APPLE_PUSH_NOTIFICATION_SERVICE_AP_NS_MESSAGE_PAYLOAD_SIZE_PER_MESSAGE = "APPLE_PUSH_NOTIFICATION_SERVICE_AP_NS_MESSAGE_PAYLOAD_SIZE_PER_MESSAGE"
    UPDATE_SEGMENT_OPERATION_RATE_QUOTA = "UPDATE_SEGMENT_OPERATION_RATE_QUOTA"
    MAXIMUM_SIZE_OF_AN_INVOCATION_PAYLOAD_REQUEST_AND_RESPONSE_FOR_A_LAMBDA_FUNCTION = "MAXIMUM_SIZE_OF_AN_INVOCATION_PAYLOAD_REQUEST_AND_RESPONSE_FOR_A_LAMBDA_FUNCTION"
    ALL_OTHER_OPERATIONS_BURST_QUOTA = "ALL_OTHER_OPERATIONS_BURST_QUOTA"
    BAIDU_CLOUD_PUSH_MESSAGE_PAYLOAD_SIZE_PER_MESSAGE = "BAIDU_CLOUD_PUSH_MESSAGE_PAYLOAD_SIZE_PER_MESSAGE"
    SMS_SPENDING_THRESHOLD = "SMS_SPENDING_THRESHOLD"
    SEND_USERS_MESSAGES_OPERATION_RATE_QUOTA = "SEND_USERS_MESSAGES_OPERATION_RATE_QUOTA"
    CREATE_SEGMENT_OPERATION_RATE_QUOTA = "CREATE_SEGMENT_OPERATION_RATE_QUOTA"
    DELETE_CAMPAIGN_OPERATION_RATE_QUOTA = "DELETE_CAMPAIGN_OPERATION_RATE_QUOTA"
    MAXIMUM_SIZE_OF_AN_INDIVIDUAL_EVENT = "MAXIMUM_SIZE_OF_AN_INDIVIDUAL_EVENT"
    MAXIMUM_MESSAGE_SIZE_INCLUDING_ATTACHMENTS = "MAXIMUM_MESSAGE_SIZE_INCLUDING_ATTACHMENTS"
    CREATE_CAMPAIGN_OPERATION_RATE_QUOTA = "CREATE_CAMPAIGN_OPERATION_RATE_QUOTA"
    NUMBER_OF_EMAILS_THAT_CAN_BE_SENT_PER_24_HOUR_PERIOD_SENDING_QUOTA = "NUMBER_OF_EMAILS_THAT_CAN_BE_SENT_PER_24_HOUR_PERIOD_SENDING_QUOTA"
    NUMBER_OF_VALUES_ASSIGNED_TO_THE_ATTRIBUTES_PARAMETER_ATTRIBUTES_PER_ATTRIBUTE = "NUMBER_OF_VALUES_ASSIGNED_TO_THE_ATTRIBUTES_PARAMETER_ATTRIBUTES_PER_ATTRIBUTE"
    MAXIMUM_NUMBER_OF_MODEL_CONFIGURATIONS_PER_MESSAGE_TEMPLATE = "MAXIMUM_NUMBER_OF_MODEL_CONFIGURATIONS_PER_MESSAGE_TEMPLATE"
    MAXIMUM_NUMBER_OF_PUSH_NOTIFICATIONS_THAT_CAN_BE_SENT_PER_SECOND_IN_A_CAMPAIGN = "MAXIMUM_NUMBER_OF_PUSH_NOTIFICATIONS_THAT_CAN_BE_SENT_PER_SECOND_IN_A_CAMPAIGN"
    MAXIMUM_NUMBER_OF_MESSAGE_TEMPLATES_PER_ACCOUNT = "MAXIMUM_NUMBER_OF_MESSAGE_TEMPLATES_PER_ACCOUNT"
    DELETE_CAMPAIGN_OPERATION_BURST_QUOTA = "DELETE_CAMPAIGN_OPERATION_BURST_QUOTA"
    UPDATE_CAMPAIGN_OPERATION_BURST_QUOTA = "UPDATE_CAMPAIGN_OPERATION_BURST_QUOTA"
    MAXIMUM_NUMBER_OF_ATTRIBUTE_KEYS_AND_METRIC_KEYS_FOR_EACH_EVENT_PER_REQUEST = "MAXIMUM_NUMBER_OF_ATTRIBUTE_KEYS_AND_METRIC_KEYS_FOR_EACH_EVENT_PER_REQUEST"
    NUMBER_OF_IDENTITIES_THAT_YOU_CAN_VERIFY = "NUMBER_OF_IDENTITIES_THAT_YOU_CAN_VERIFY"
    MAXIMUM_NUMBER_OF_CHARACTERS_IN_A_VOICE_TEMPLATE = "MAXIMUM_NUMBER_OF_CHARACTERS_IN_A_VOICE_TEMPLATE"
    NUMBER_OF_VERIFIED_IDENTITIES = "NUMBER_OF_VERIFIED_IDENTITIES"
    PHONE_NUMBER_VALIDATE_OPERATION_RATE_QUOTA = "PHONE_NUMBER_VALIDATE_OPERATION_RATE_QUOTA"
    NUMBER_OF_CONCURRENT_IMPORT_JOBS = "NUMBER_OF_CONCURRENT_IMPORT_JOBS"
    SEND_MESSAGES_OPERATION_RATE_QUOTA = "SEND_MESSAGES_OPERATION_RATE_QUOTA"
    MAXIMUM_SEGMENT_SIZE_PER_CAMPAIGN = "MAXIMUM_SEGMENT_SIZE_PER_CAMPAIGN"
    CREATE_SEGMENT_OPERATION_BURST_QUOTA = "CREATE_SEGMENT_OPERATION_BURST_QUOTA"
    MAXIMUM_NUMBER_OF_CHARACTERS_FOR_AN_EVENT_ATTRIBUTE_VALUE_IN_A_CUSTOM_CHANNEL_RESPONSE = "MAXIMUM_NUMBER_OF_CHARACTERS_FOR_AN_EVENT_ATTRIBUTE_VALUE_IN_A_CUSTOM_CHANNEL_RESPONSE"
    MAXIMUM_NUMBER_OF_VERSIONS_PER_TEMPLATE = "MAXIMUM_NUMBER_OF_VERSIONS_PER_TEMPLATE"
    NUMBER_OF_EMAILS_THAT_CAN_BE_SENT_EACH_SECOND_SENDING_RATE = "NUMBER_OF_EMAILS_THAT_CAN_BE_SENT_EACH_SECOND_SENDING_RATE"
    FIREBASE_CLOUD_MESSAGING_FCM_MESSAGE_PAYLOAD_SIZE_PER_MESSAGE = "FIREBASE_CLOUD_MESSAGING_FCM_MESSAGE_PAYLOAD_SIZE_PER_MESSAGE"
    IMPORT_SIZE_PER_IMPORT_JOB = "IMPORT_SIZE_PER_IMPORT_JOB"
    MAXIMUM_NUMBER_OF_CHARACTERS_IN_AN_EMAIL_TEMPLATE = "MAXIMUM_NUMBER_OF_CHARACTERS_IN_AN_EMAIL_TEMPLATE"
    MAXIMUM_NUMBER_OF_CHARACTERS_IN_BAIDU_SPECIFIC_TEMPLATE_PARTS_OF_A_PUSH_NOTIFICATION_TEMPLATE = "MAXIMUM_NUMBER_OF_CHARACTERS_IN_BAIDU_SPECIFIC_TEMPLATE_PARTS_OF_A_PUSH_NOTIFICATION_TEMPLATE"
    UPDATE_CAMPAIGN_OPERATION_RATE_QUOTA = "UPDATE_CAMPAIGN_OPERATION_RATE_QUOTA"
    MAXIMUM_NUMBER_OF_CHARACTERS_FOR_AN_EVENT_ATTRIBUTE_NAME_IN_A_CUSTOM_CHANNEL_RESPONSE = "MAXIMUM_NUMBER_OF_CHARACTERS_FOR_AN_EVENT_ATTRIBUTE_NAME_IN_A_CUSTOM_CHANNEL_RESPONSE"
    MAXIMUM_NUMBER_OF_CHARACTERS_IN_THE_DEFAULT_TEMPLATE_PARTS_OF_A_PUSH_NOTIFICATION_TEMPLATE = "MAXIMUM_NUMBER_OF_CHARACTERS_IN_THE_DEFAULT_TEMPLATE_PARTS_OF_A_PUSH_NOTIFICATION_TEMPLATE"
    UPDATE_SEGMENT_OPERATION_BURST_QUOTA = "UPDATE_SEGMENT_OPERATION_BURST_QUOTA"
    AP_NS_SANDBOX_MESSAGE_PAYLOAD_SIZE_PER_MESSAGE = "AP_NS_SANDBOX_MESSAGE_PAYLOAD_SIZE_PER_MESSAGE"
    NUMBER_OF_AMAZON_SNS_TOPICS_FOR_TWO_WAY_SMS_PER_ACCOUNT = "NUMBER_OF_AMAZON_SNS_TOPICS_FOR_TWO_WAY_SMS_PER_ACCOUNT"
    NUMBER_OF_VOICE_MESSAGES_THAT_CAN_BE_SENT_DURING_A_24_HOUR_PERIOD = "NUMBER_OF_VOICE_MESSAGES_THAT_CAN_BE_SENT_DURING_A_24_HOUR_PERIOD"
    MAXIMUM_NUMBER_OF_CUSTOM_METRIC_KEYS_PER_APP = "MAXIMUM_NUMBER_OF_CUSTOM_METRIC_KEYS_PER_APP"
    NUMBER_OF_ATTRIBUTES_ASSIGNED_TO_THE_ATTRIBUTES_PARAMETER = "NUMBER_OF_ATTRIBUTES_ASSIGNED_TO_THE_ATTRIBUTES_PARAMETER"
    NUMBER_OF_ATTRIBUTES_ASSIGNED_TO_THE_USER_ATTRIBUTES_PARAMETER = "NUMBER_OF_ATTRIBUTES_ASSIGNED_TO_THE_USER_ATTRIBUTES_PARAMETER"
    CREATE_CAMPAIGN_OPERATION_BURST_QUOTA = "CREATE_CAMPAIGN_OPERATION_BURST_QUOTA"
    ALL_OTHER_OPERATIONS_RATE_QUOTA = "ALL_OTHER_OPERATIONS_RATE_QUOTA"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AmazonPollyQuota")
class AmazonPollyQuota(enum.Enum):
    RATE_OF_LEXICON_MANAGEMENT_REQUESTS = "RATE_OF_LEXICON_MANAGEMENT_REQUESTS"
    SYNTHESIZE_SPEECH_LEXICON_COUNT = "SYNTHESIZE_SPEECH_LEXICON_COUNT"
    RATE_OF_SYNTHESIZE_SPEECH_NEURAL_REQUESTS = "RATE_OF_SYNTHESIZE_SPEECH_NEURAL_REQUESTS"
    START_SPEECH_SYNTHESIS_TASK_BILLED_CHARACTERS_COUNT = "START_SPEECH_SYNTHESIS_TASK_BILLED_CHARACTERS_COUNT"
    SYNTHESIZE_SPEECH_BILLED_CHARACTER_COUNT = "SYNTHESIZE_SPEECH_BILLED_CHARACTER_COUNT"
    LEXICON_COUNT = "LEXICON_COUNT"
    LEXICON_SIZE = "LEXICON_SIZE"
    RATE_OF_SYNTHESIZE_SPEECH_LONG_FORM_REQUESTS = "RATE_OF_SYNTHESIZE_SPEECH_LONG_FORM_REQUESTS"
    START_SPEECH_SYNTHESIS_TASK_LEXICON_COUNT = "START_SPEECH_SYNTHESIS_TASK_LEXICON_COUNT"
    RATE_OF_START_SPEECH_SYNTHESIS_TASK_STANDARD_REQUESTS = "RATE_OF_START_SPEECH_SYNTHESIS_TASK_STANDARD_REQUESTS"
    RATE_OF_GET_SPEECH_SYNTHESIS_TASK_AND_LIST_SPEECH_SYNTHESIS_TASKS_REQUESTS = "RATE_OF_GET_SPEECH_SYNTHESIS_TASK_AND_LIST_SPEECH_SYNTHESIS_TASKS_REQUESTS"
    START_SPEECH_SYNTHESIS_TASK_TOTAL_CHARACTERS_LIMIT = "START_SPEECH_SYNTHESIS_TASK_TOTAL_CHARACTERS_LIMIT"
    RATE_OF_START_SPEECH_SYNTHESIS_TASK_NEURAL_REQUESTS = "RATE_OF_START_SPEECH_SYNTHESIS_TASK_NEURAL_REQUESTS"
    SYNTHESIZE_SPEECH_TOTAL_CHARACTER_COUNT = "SYNTHESIZE_SPEECH_TOTAL_CHARACTER_COUNT"
    RATE_OF_START_SPEECH_SYNTHESIS_TASK_LONG_FORM_REQUESTS = "RATE_OF_START_SPEECH_SYNTHESIS_TASK_LONG_FORM_REQUESTS"
    RATE_OF_SYNTHESIZE_SPEECH_STANDARD_REQUESTS = "RATE_OF_SYNTHESIZE_SPEECH_STANDARD_REQUESTS"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AmazonQInConnectQuota")
class AmazonQInConnectQuota(enum.Enum):
    RATE_OF_API_REQUESTS_FOR_GET_CONTENT = "RATE_OF_API_REQUESTS_FOR_GET_CONTENT"
    RATE_OF_API_REQUESTS_FOR_DELETE_ASSISTANT_ASSOCIATION = "RATE_OF_API_REQUESTS_FOR_DELETE_ASSISTANT_ASSOCIATION"
    RATE_OF_API_REQUESTS_FOR_SEARCH_SESSIONS = "RATE_OF_API_REQUESTS_FOR_SEARCH_SESSIONS"
    RATE_OF_API_REQUESTS_FOR_START_IMPORT_JOB = "RATE_OF_API_REQUESTS_FOR_START_IMPORT_JOB"
    RATE_OF_API_REQUESTS_FOR_GET_QUICK_RESPONSE = "RATE_OF_API_REQUESTS_FOR_GET_QUICK_RESPONSE"
    RATE_OF_API_REQUESTS_FOR_GET_ASSISTANT_ASSOCIATION = "RATE_OF_API_REQUESTS_FOR_GET_ASSISTANT_ASSOCIATION"
    RATE_OF_API_REQUESTS_FOR_UPDATE_KNOWLEDGE_BASE_TEMPLATE_URI = "RATE_OF_API_REQUESTS_FOR_UPDATE_KNOWLEDGE_BASE_TEMPLATE_URI"
    RATE_OF_API_REQUESTS_FOR_REMOVE_KNOWLEDGE_BASE_TEMPLATE_URI = "RATE_OF_API_REQUESTS_FOR_REMOVE_KNOWLEDGE_BASE_TEMPLATE_URI"
    RATE_OF_API_REQUESTS_FOR_CREATE_ASSISTANT = "RATE_OF_API_REQUESTS_FOR_CREATE_ASSISTANT"
    RATE_OF_API_REQUESTS_FOR_DELETE_CONTENT = "RATE_OF_API_REQUESTS_FOR_DELETE_CONTENT"
    RATE_OF_API_REQUESTS_FOR_LIST_ASSISTANT_ASSOCIATIONS = "RATE_OF_API_REQUESTS_FOR_LIST_ASSISTANT_ASSOCIATIONS"
    RATE_OF_API_REQUESTS_FOR_LIST_IMPORT_JOBS = "RATE_OF_API_REQUESTS_FOR_LIST_IMPORT_JOBS"
    RATE_OF_API_REQUESTS_FOR_GET_RECOMMENDATIONS = "RATE_OF_API_REQUESTS_FOR_GET_RECOMMENDATIONS"
    RATE_OF_API_REQUESTS_FOR_GET_IMPORT_JOB = "RATE_OF_API_REQUESTS_FOR_GET_IMPORT_JOB"
    RATE_OF_API_REQUESTS_FOR_CREATE_ASSISTANT_ASSOCIATION = "RATE_OF_API_REQUESTS_FOR_CREATE_ASSISTANT_ASSOCIATION"
    RATE_OF_API_REQUESTS_FOR_DELETE_IMPORT_JOB = "RATE_OF_API_REQUESTS_FOR_DELETE_IMPORT_JOB"
    RATE_OF_API_REQUESTS_FOR_LIST_QUICK_RESPONSES = "RATE_OF_API_REQUESTS_FOR_LIST_QUICK_RESPONSES"
    RATE_OF_API_REQUESTS_FOR_GET_CONTENT_SUMMARY = "RATE_OF_API_REQUESTS_FOR_GET_CONTENT_SUMMARY"
    RATE_OF_API_REQUESTS_FOR_DELETE_ASSISTANT = "RATE_OF_API_REQUESTS_FOR_DELETE_ASSISTANT"
    RATE_OF_API_REQUESTS_FOR_DELETE_QUICK_RESPONSE = "RATE_OF_API_REQUESTS_FOR_DELETE_QUICK_RESPONSE"
    RATE_OF_API_REQUESTS_FOR_SEARCH_CONTENT = "RATE_OF_API_REQUESTS_FOR_SEARCH_CONTENT"
    RATE_OF_API_REQUESTS_FOR_UPDATE_QUICK_RESPONSE = "RATE_OF_API_REQUESTS_FOR_UPDATE_QUICK_RESPONSE"
    RATE_OF_API_REQUESTS_FOR_CREATE_SESSION = "RATE_OF_API_REQUESTS_FOR_CREATE_SESSION"
    RATE_OF_API_REQUESTS_FOR_SEARCH_QUICK_RESPONSES = "RATE_OF_API_REQUESTS_FOR_SEARCH_QUICK_RESPONSES"
    RATE_OF_API_REQUESTS_FOR_LIST_KNOWLEDGE_BASES = "RATE_OF_API_REQUESTS_FOR_LIST_KNOWLEDGE_BASES"
    RATE_OF_API_REQUESTS_FOR_TAG_RESOURCE = "RATE_OF_API_REQUESTS_FOR_TAG_RESOURCE"
    RATE_OF_API_REQUESTS_FOR_UNTAG_RESOURCE = "RATE_OF_API_REQUESTS_FOR_UNTAG_RESOURCE"
    RATE_OF_API_REQUESTS_FOR_NOTIFY_RECOMMENDATIONS_RECEIVED = "RATE_OF_API_REQUESTS_FOR_NOTIFY_RECOMMENDATIONS_RECEIVED"
    RATE_OF_API_REQUESTS_FOR_GET_SESSION = "RATE_OF_API_REQUESTS_FOR_GET_SESSION"
    RATE_OF_API_REQUESTS_FOR_GET_KNOWLEDGE_BASE = "RATE_OF_API_REQUESTS_FOR_GET_KNOWLEDGE_BASE"
    RATE_OF_API_REQUESTS_FOR_QUERY_ASSISTANT = "RATE_OF_API_REQUESTS_FOR_QUERY_ASSISTANT"
    RATE_OF_API_REQUESTS_FOR_GET_ASSISTANT = "RATE_OF_API_REQUESTS_FOR_GET_ASSISTANT"
    RATE_OF_API_REQUESTS_FOR_CREATE_QUICK_RESPONSE = "RATE_OF_API_REQUESTS_FOR_CREATE_QUICK_RESPONSE"
    RATE_OF_API_REQUESTS_FOR_DELETE_KNOWLEDGE_BASE = "RATE_OF_API_REQUESTS_FOR_DELETE_KNOWLEDGE_BASE"
    RATE_OF_API_REQUESTS_FOR_LIST_ASSISTANTS = "RATE_OF_API_REQUESTS_FOR_LIST_ASSISTANTS"
    RATE_OF_API_REQUESTS_FOR_START_CONTENT_UPLOAD = "RATE_OF_API_REQUESTS_FOR_START_CONTENT_UPLOAD"
    RATE_OF_API_REQUESTS_FOR_CREATE_CONTENT = "RATE_OF_API_REQUESTS_FOR_CREATE_CONTENT"
    RATE_OF_API_REQUESTS_FOR_UPDATE_CONTENT = "RATE_OF_API_REQUESTS_FOR_UPDATE_CONTENT"
    RATE_OF_API_REQUESTS_FOR_LIST_TAGS_FOR_RESOURCE = "RATE_OF_API_REQUESTS_FOR_LIST_TAGS_FOR_RESOURCE"
    RATE_OF_API_REQUESTS_FOR_CREATE_KNOWLEDGE_BASE = "RATE_OF_API_REQUESTS_FOR_CREATE_KNOWLEDGE_BASE"
    AMAZON_Q_IN_CONNECT_ASSISTANT_COUNT = "AMAZON_Q_IN_CONNECT_ASSISTANT_COUNT"
    CONTENT_PER_KNOWLEDGE_BASE = "CONTENT_PER_KNOWLEDGE_BASE"
    ASSISTANT_ASSOCIATION = "ASSISTANT_ASSOCIATION"
    AMAZON_Q_IN_CONNECT_KNOWLEDGE_BASE_COUNT = "AMAZON_Q_IN_CONNECT_KNOWLEDGE_BASE_COUNT"
    CONTENT_SIZE = "CONTENT_SIZE"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AmazonQQuota")
class AmazonQQuota(enum.Enum):
    MAXIMUM_NUMBER_OF_PLUGINS_PER_APPLICATION = "MAXIMUM_NUMBER_OF_PLUGINS_PER_APPLICATION"
    MAXIMUM_NUMBER_OF_APPLICATIONS_PER_ACCOUNT = "MAXIMUM_NUMBER_OF_APPLICATIONS_PER_ACCOUNT"
    MAXIMUM_NUMBER_OF_DATA_SOURCES_PER_APPLICATION = "MAXIMUM_NUMBER_OF_DATA_SOURCES_PER_APPLICATION"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AmazonQldbQuota")
class AmazonQldbQuota(enum.Enum):
    QLDB_EXPORTS_PER_LEDGER = "QLDB_EXPORTS_PER_LEDGER"
    LEDGERS = "LEDGERS"
    QLDB_STREAMS_PER_LEDGER = "QLDB_STREAMS_PER_LEDGER"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AmazonQuickSightQuota")
class AmazonQuickSightQuota(enum.Enum):
    CUSTOM_ACTIONS_PER_VISUAL = "CUSTOM_ACTIONS_PER_VISUAL"
    API_CREATE_INGESTION_CALLS_PER_24_HOUR_PERIOD_FROM_STANDARD_EDITION = "API_CREATE_INGESTION_CALLS_PER_24_HOUR_PERIOD_FROM_STANDARD_EDITION"
    EMAIL_ALIASES_PER_GROUP_FOR_EMAIL_REPORTS = "EMAIL_ALIASES_PER_GROUP_FOR_EMAIL_REPORTS"
    CALCULATED_FIELD_EXPRESSION_LENGTH = "CALCULATED_FIELD_EXPRESSION_LENGTH"
    API_CREATE_INGESTION_CALLS_PER_24_HOUR_PERIOD_FROM_ENTERPRISE_EDITION = "API_CREATE_INGESTION_CALLS_PER_24_HOUR_PERIOD_FROM_ENTERPRISE_EDITION"
    DATA_PREP_FIELDS_PER_DATASET = "DATA_PREP_FIELDS_PER_DATASET"
    DISPLAY_ITEMS_PER_SHEET_CONTROL = "DISPLAY_ITEMS_PER_SHEET_CONTROL"
    CUSTOM_ACTION_NAME_LENGTH = "CUSTOM_ACTION_NAME_LENGTH"
    MAXIMUM_NUMBER_OF_CHARACTERS_PER_SPECIFIED_CONTROL_VALUES = "MAXIMUM_NUMBER_OF_CHARACTERS_PER_SPECIFIED_CONTROL_VALUES"
    QUERY_TIMEOUT_FOR_VISUALS = "QUERY_TIMEOUT_FOR_VISUALS"
    THE_MAXIMUM_AMOUNT_OF_TIME_TO_WAIT_FOR_A_DATASET_PREVIEW = "THE_MAXIMUM_AMOUNT_OF_TIME_TO_WAIT_FOR_A_DATASET_PREVIEW"
    URL_ACTION_HYPERLINK_LENGTH = "URL_ACTION_HYPERLINK_LENGTH"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AmazonRecycleBinQuota")
class AmazonRecycleBinQuota(enum.Enum):
    TAGS_PER_RULE = "TAGS_PER_RULE"
    RULES_PER_REGION = "RULES_PER_REGION"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AmazonRedshiftQuota")
class AmazonRedshiftQuota(enum.Enum):
    NODES_IN_A_CLUSTER = "NODES_IN_A_CLUSTER"
    PARTITIONS_IN_AN_ACCOUNT_WHEN_USING_AMAZON_ATHENA = "PARTITIONS_IN_AN_ACCOUNT_WHEN_USING_AMAZON_ATHENA"
    PARAMETER_GROUPS = "PARAMETER_GROUPS"
    COLUMN_LIMIT_FOR_EXTERNAL_TABLES_WITH_PSEUDOCOLUMNS_WHEN_USING_AMAZON_ATHENA = "COLUMN_LIMIT_FOR_EXTERNAL_TABLES_WITH_PSEUDOCOLUMNS_WHEN_USING_AMAZON_ATHENA"
    ALLOWED_STRING_VALUE_SIZE_PER_ION_OR_JSON_FILE_WHEN_USING_AMAZON_ATHENA = "ALLOWED_STRING_VALUE_SIZE_PER_ION_OR_JSON_FILE_WHEN_USING_AMAZON_ATHENA"
    TABLES_FOR_LARGE_CLUSTER_NODE_TYPE = "TABLES_FOR_LARGE_CLUSTER_NODE_TYPE"
    SECURITY_GROUPS = "SECURITY_GROUPS"
    RA3_NODES_IN_A_CLUSTER = "RA3_NODES_IN_A_CLUSTER"
    ALLOWED_ROW_OBJECT_SIZE_PER_ION_OR_JSON_FILE_WHEN_USING_AMAZON_ATHENA = "ALLOWED_ROW_OBJECT_SIZE_PER_ION_OR_JSON_FILE_WHEN_USING_AMAZON_ATHENA"
    SCHEMAS_IN_EACH_DATABASE_PER_CLUSTER = "SCHEMAS_IN_EACH_DATABASE_PER_CLUSTER"
    TABLES_FOR_XLPLUS_CLUSTER_NODE_TYPE_WITH_A_SINGLE_NODE_CLUSTER = "TABLES_FOR_XLPLUS_CLUSTER_NODE_TYPE_WITH_A_SINGLE_NODE_CLUSTER"
    PARTITIONS_IN_A_TABLE_WHEN_USING_AWS_GLUE_DATA_CATALOG = "PARTITIONS_IN_A_TABLE_WHEN_USING_AWS_GLUE_DATA_CATALOG"
    EVENT_SUBSCRIPTIONS = "EVENT_SUBSCRIPTIONS"
    TABLES_FOR_8XLARGE_CLUSTER_NODE_TYPE = "TABLES_FOR_8XLARGE_CLUSTER_NODE_TYPE"
    STORED_PROCEDURES_IN_A_DATABASE = "STORED_PROCEDURES_IN_A_DATABASE"
    COLUMN_LIMIT_FOR_EXTERNAL_TABLES_WHEN_USING_AMAZON_ATHENA_OR_AWS_GLUE_DATA_CATALOG = "COLUMN_LIMIT_FOR_EXTERNAL_TABLES_WHEN_USING_AMAZON_ATHENA_OR_AWS_GLUE_DATA_CATALOG"
    TABLES_FOR_16XLARGE_CLUSTER_NODE_TYPE = "TABLES_FOR_16XLARGE_CLUSTER_NODE_TYPE"
    SUBNET_GROUPS = "SUBNET_GROUPS"
    PARTITIONS_IN_AN_ACCOUNT_WHEN_USING_AWS_GLUE_DATA_CATALOG = "PARTITIONS_IN_AN_ACCOUNT_WHEN_USING_AWS_GLUE_DATA_CATALOG"
    DC2_NODES_IN_A_CLUSTER = "DC2_NODES_IN_A_CLUSTER"
    SINGLE_ROW_SIZE_WHEN_LOADING_BY_COPY = "SINGLE_ROW_SIZE_WHEN_LOADING_BY_COPY"
    TABLES_FOR_4XLARGE_CLUSTER_NODE_TYPE = "TABLES_FOR_4XLARGE_CLUSTER_NODE_TYPE"
    TABLES_FOR_XLARGE_CLUSTER_NODE_TYPE = "TABLES_FOR_XLARGE_CLUSTER_NODE_TYPE"
    TABLES_IN_A_DATABASE_WHEN_USING_AWS_GLUE_DATA_CATALOG = "TABLES_IN_A_DATABASE_WHEN_USING_AWS_GLUE_DATA_CATALOG"
    DATABASES_IN_AN_ACCOUNT_WHEN_USING_AWS_GLUE_DATA_CATALOG = "DATABASES_IN_AN_ACCOUNT_WHEN_USING_AWS_GLUE_DATA_CATALOG"
    CLUSTER_IAM_ROLES_FOR_AMAZON_REDSHIFT_TO_ACCESS_OTHER_AWS_SERVICES = "CLUSTER_IAM_ROLES_FOR_AMAZON_REDSHIFT_TO_ACCESS_OTHER_AWS_SERVICES"
    SNAPSHOTS = "SNAPSHOTS"
    CONCURRENCY_LEVEL_FOR_ALL_USER_DEFINED_QUEUES = "CONCURRENCY_LEVEL_FOR_ALL_USER_DEFINED_QUEUES"
    TABLES_FOR_XLPLUS_CLUSTER_NODE_TYPE_WITH_A_MULTIPLE_NODE_CLUSTER = "TABLES_FOR_XLPLUS_CLUSTER_NODE_TYPE_WITH_A_MULTIPLE_NODE_CLUSTER"
    NODES = "NODES"
    USER_DEFINED_DATABASES_IN_A_CLUSTER = "USER_DEFINED_DATABASES_IN_A_CLUSTER"
    PARTITIONS_IN_A_TABLE_WHEN_USING_AMAZON_ATHENA = "PARTITIONS_IN_A_TABLE_WHEN_USING_AMAZON_ATHENA"
    SUBNETS_IN_A_SUBNET_GROUP = "SUBNETS_IN_A_SUBNET_GROUP"
    COLUMN_LIMIT_FOR_EXTERNAL_TABLES_WITH_PSEUDOCOLUMNS_WHEN_USING_AWS_GLUE_DATA_CATALOG = "COLUMN_LIMIT_FOR_EXTERNAL_TABLES_WITH_PSEUDOCOLUMNS_WHEN_USING_AWS_GLUE_DATA_CATALOG"
    AWS_ACCOUNTS_YOU_CAN_AUTHORIZE_TO_RESTORE_A_SNAPSHOT_PER_SNAPSHOT = "AWS_ACCOUNTS_YOU_CAN_AUTHORIZE_TO_RESTORE_A_SNAPSHOT_PER_SNAPSHOT"
    CONCURRENT_USER_CONNECTIONS_TO_A_CLUSTER = "CONCURRENT_USER_CONNECTIONS_TO_A_CLUSTER"
    DS2_NODES_IN_A_CLUSTER = "DS2_NODES_IN_A_CLUSTER"
    TABLES_IN_A_DATABASE_WHEN_USING_AMAZON_ATHENA = "TABLES_IN_A_DATABASE_WHEN_USING_AMAZON_ATHENA"
    AWS_ACCOUNTS_YOU_CAN_AUTHORIZE_TO_RESTORE_A_SNAPSHOT_PER_AWS_KMS_KEY = "AWS_ACCOUNTS_YOU_CAN_AUTHORIZE_TO_RESTORE_A_SNAPSHOT_PER_AWS_KMS_KEY"
    DATABASES_IN_AN_ACCOUNT_WHEN_USING_AMAZON_ATHENA = "DATABASES_IN_AN_ACCOUNT_WHEN_USING_AMAZON_ATHENA"
    RESERVED_NODES = "RESERVED_NODES"
    ALLOWED_STRING_VALUE_SIZE_PER_ION_OR_JSON_FILE_WHEN_USING_AWS_GLUE_DATA_CATALOG = "ALLOWED_STRING_VALUE_SIZE_PER_ION_OR_JSON_FILE_WHEN_USING_AWS_GLUE_DATA_CATALOG"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AmazonRekognitionQuota")
class AmazonRekognitionQuota(enum.Enum):
    TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_CUSTOM_LABELS_OPERATION_UPDATE_DATASET_ENTRIES = "TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_CUSTOM_LABELS_OPERATION_UPDATE_DATASET_ENTRIES"
    TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_OPERATION_DELETE_USER = "TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_OPERATION_DELETE_USER"
    TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_IMAGE_OPERATION_DELETE_FACES = "TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_IMAGE_OPERATION_DELETE_FACES"
    TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_CUSTOM_LABELS_OPERATION_DELETE_PROJECT = "TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_CUSTOM_LABELS_OPERATION_DELETE_PROJECT"
    TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_IMAGE_OPERATION_DETECT_MODERATION_LABELS = "TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_IMAGE_OPERATION_DETECT_MODERATION_LABELS"
    TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_IMAGE_OPERATION_DETECT_TEXT = "TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_IMAGE_OPERATION_DETECT_TEXT"
    TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_OPERATION_LIST_TAGS_FOR_RESOURCE = "TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_OPERATION_LIST_TAGS_FOR_RESOURCE"
    TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_STREAMING_VIDEO_EVENTS_OPERATION_LIST_STREAM_PROCESSORS = "TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_STREAMING_VIDEO_EVENTS_OPERATION_LIST_STREAM_PROCESSORS"
    TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_VIDEO_STORED_VIDEO_GET_OPERATION_GET_PERSON_TRACKING = "TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_VIDEO_STORED_VIDEO_GET_OPERATION_GET_PERSON_TRACKING"
    CONCURRENT_AMAZON_REKOGNITION_CUSTOM_LABELS_TRAINING_JOBS_PER_ACCOUNT = "CONCURRENT_AMAZON_REKOGNITION_CUSTOM_LABELS_TRAINING_JOBS_PER_ACCOUNT"
    TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_IMAGE_OPERATION_RECOGNIZE_CELEBRITIES = "TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_IMAGE_OPERATION_RECOGNIZE_CELEBRITIES"
    MAXIMUM_NUMBER_OF_PROJECT_POLICIES_PER_AMAZON_REKOGNITION_CUSTOM_LABELS_PROJECT = "MAXIMUM_NUMBER_OF_PROJECT_POLICIES_PER_AMAZON_REKOGNITION_CUSTOM_LABELS_PROJECT"
    TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_IMAGE_OPERATION_LIST_COLLECTIONS = "TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_IMAGE_OPERATION_LIST_COLLECTIONS"
    TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_CUSTOM_LABELS_OPERATION_LIST_DATASET_ENTRIES = "TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_CUSTOM_LABELS_OPERATION_LIST_DATASET_ENTRIES"
    TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_OPERATION_LIST_MEDIA_ANALYSIS_JOBS = "TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_OPERATION_LIST_MEDIA_ANALYSIS_JOBS"
    TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_OPERATION_TAG_RESOURCE = "TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_OPERATION_TAG_RESOURCE"
    TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_CUSTOM_LABELS_OPERATION_LIST_PROJECT_POLICIES = "TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_CUSTOM_LABELS_OPERATION_LIST_PROJECT_POLICIES"
    TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_VIDEO_STORED_VIDEO_START_OPERATION_START_PERSON_TRACKING = "TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_VIDEO_STORED_VIDEO_START_OPERATION_START_PERSON_TRACKING"
    TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_VIDEO_STORED_VIDEO_START_OPERATION_START_FACE_SEARCH = "TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_VIDEO_STORED_VIDEO_START_OPERATION_START_FACE_SEARCH"
    TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_VIDEO_STORED_VIDEO_START_OPERATION_START_SEGMENT_DETECTION = "TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_VIDEO_STORED_VIDEO_START_OPERATION_START_SEGMENT_DETECTION"
    TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_IMAGE_OPERATION_LIST_FACES = "TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_IMAGE_OPERATION_LIST_FACES"
    TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_CUSTOM_LABELS_OPERATION_DESCRIBE_PROJECT_VERSIONS = "TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_CUSTOM_LABELS_OPERATION_DESCRIBE_PROJECT_VERSIONS"
    TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_CUSTOM_LABELS_OPERATION_START_PROJECT_VERSION = "TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_CUSTOM_LABELS_OPERATION_START_PROJECT_VERSION"
    TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_FACE_LIVENESS_OPERATION_GET_FACE_LIVENESS_SESSION_RESULTS = "TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_FACE_LIVENESS_OPERATION_GET_FACE_LIVENESS_SESSION_RESULTS"
    TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_VIDEO_STORED_VIDEO_GET_OPERATION_GET_FACE_DETECTION = "TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_VIDEO_STORED_VIDEO_GET_OPERATION_GET_FACE_DETECTION"
    AMAZON_REKOGNITION_STREAMING_VIDEO_EVENTS_LABEL_DETECTION_STREAM_PROCESSORS_PER_ACCOUNT_THAT_CAN_BE_PROCESSED_CONCURRENTLY = "AMAZON_REKOGNITION_STREAMING_VIDEO_EVENTS_LABEL_DETECTION_STREAM_PROCESSORS_PER_ACCOUNT_THAT_CAN_BE_PROCESSED_CONCURRENTLY"
    TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_IMAGE_PERSONAL_PROTECTIVE_EQUIPMENT_OPERATION_DETECT_PROTECTIVE_EQUIPMENT = "TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_IMAGE_PERSONAL_PROTECTIVE_EQUIPMENT_OPERATION_DETECT_PROTECTIVE_EQUIPMENT"
    CONCURRENTLY_RUNNING_AMAZON_REKOGNITION_CUSTOM_LABELS_MODELS_PER_ACCOUNT = "CONCURRENTLY_RUNNING_AMAZON_REKOGNITION_CUSTOM_LABELS_MODELS_PER_ACCOUNT"
    TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_CUSTOM_LABELS_OPERATION_LIST_DATASET_LABELS = "TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_CUSTOM_LABELS_OPERATION_LIST_DATASET_LABELS"
    AMAZON_REKOGNITION_STREAMING_VIDEO_EVENTS_STREAM_PROCESSORS_PER_ACCOUNT_THAT_CAN_SIMULTANEOUSLY_EXIST = "AMAZON_REKOGNITION_STREAMING_VIDEO_EVENTS_STREAM_PROCESSORS_PER_ACCOUNT_THAT_CAN_SIMULTANEOUSLY_EXIST"
    TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_IMAGE_OPERATION_SEARCH_FACES = "TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_IMAGE_OPERATION_SEARCH_FACES"
    TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_OPERATION_CREATE_USER = "TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_OPERATION_CREATE_USER"
    TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_OPERATION_SEARCH_USERS_BY_IMAGE = "TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_OPERATION_SEARCH_USERS_BY_IMAGE"
    CONCURRENT_AMAZON_REKOGNITION_MEDIA_ANALYSIS_JOBS_PER_ACCOUNT = "CONCURRENT_AMAZON_REKOGNITION_MEDIA_ANALYSIS_JOBS_PER_ACCOUNT"
    TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_VIDEO_STORED_VIDEO_GET_OPERATION_GET_CELEBRITY_RECOGNITION = "TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_VIDEO_STORED_VIDEO_GET_OPERATION_GET_CELEBRITY_RECOGNITION"
    TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_OPERATION_SEARCH_USERS = "TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_OPERATION_SEARCH_USERS"
    TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_VIDEO_STORED_VIDEO_START_OPERATION_START_TEXT_DETECTION = "TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_VIDEO_STORED_VIDEO_START_OPERATION_START_TEXT_DETECTION"
    TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_OPERATION_DISASSOCIATE_FACES = "TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_OPERATION_DISASSOCIATE_FACES"
    TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_STREAMING_VIDEO_EVENTS_OPERATION_UPDATE_STREAM_PROCESSOR = "TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_STREAMING_VIDEO_EVENTS_OPERATION_UPDATE_STREAM_PROCESSOR"
    TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_CUSTOM_LABELS_OPERATION_DESCRIBE_DATASET = "TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_CUSTOM_LABELS_OPERATION_DESCRIBE_DATASET"
    TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_VIDEO_STORED_VIDEO_GET_OPERATION_GET_SEGMENT_DETECTION = "TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_VIDEO_STORED_VIDEO_GET_OPERATION_GET_SEGMENT_DETECTION"
    TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_VIDEO_STORED_VIDEO_GET_OPERATION_GET_TEXT_DETECTION = "TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_VIDEO_STORED_VIDEO_GET_OPERATION_GET_TEXT_DETECTION"
    TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_OPERATION_UNTAG_RESOURCE = "TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_OPERATION_UNTAG_RESOURCE"
    TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_VIDEO_STORED_VIDEO_START_OPERATION_START_CONTENT_MODERATION = "TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_VIDEO_STORED_VIDEO_START_OPERATION_START_CONTENT_MODERATION"
    MAXIMUM_NUMBER_OF_IMAGES_PER_AMAZON_REKOGNITION_MEDIA_ANALYSIS_JOB = "MAXIMUM_NUMBER_OF_IMAGES_PER_AMAZON_REKOGNITION_MEDIA_ANALYSIS_JOB"
    TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_CUSTOM_LABELS_OPERATION_CREATE_DATASET = "TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_CUSTOM_LABELS_OPERATION_CREATE_DATASET"
    TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_STREAMING_VIDEO_EVENTS_OPERATION_CREATE_STREAM_PROCESSOR = "TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_STREAMING_VIDEO_EVENTS_OPERATION_CREATE_STREAM_PROCESSOR"
    AMAZON_REKOGNITION_STREAMING_VIDEO_EVENTS_FACE_SEARCH_STREAM_PROCESSORS_PER_ACCOUNT_THAT_CAN_BE_PROCESSED_CONCURRENTLY = "AMAZON_REKOGNITION_STREAMING_VIDEO_EVENTS_FACE_SEARCH_STREAM_PROCESSORS_PER_ACCOUNT_THAT_CAN_BE_PROCESSED_CONCURRENTLY"
    MAXIMUM_NUMBER_OF_IMAGES_PER_AMAZON_REKOGNITION_CUSTOM_LABELS_CLASSIFICATION_TRAINING_DATASET = "MAXIMUM_NUMBER_OF_IMAGES_PER_AMAZON_REKOGNITION_CUSTOM_LABELS_CLASSIFICATION_TRAINING_DATASET"
    AMAZON_REKOGNITION_STREAMING_VIDEO_EVENTS_FACE_SEARCH_STREAM_PROCESSORS_PER_AMAZON_KINESIS_DATA_OUTPUT_STREAM = "AMAZON_REKOGNITION_STREAMING_VIDEO_EVENTS_FACE_SEARCH_STREAM_PROCESSORS_PER_AMAZON_KINESIS_DATA_OUTPUT_STREAM"
    TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_CUSTOM_LABELS_OPERATION_DELETE_PROJECT_POLICY = "TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_CUSTOM_LABELS_OPERATION_DELETE_PROJECT_POLICY"
    TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_STREAMING_VIDEO_EVENTS_OPERATION_DESCRIBE_STREAM_PROCESSOR = "TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_STREAMING_VIDEO_EVENTS_OPERATION_DESCRIBE_STREAM_PROCESSOR"
    TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_INDIVIDUAL_AMAZON_REKOGNITION_CUSTOM_LABELS_DATA_PLANE_OPERATION_DETECT_CUSTOM_LABELS = "TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_INDIVIDUAL_AMAZON_REKOGNITION_CUSTOM_LABELS_DATA_PLANE_OPERATION_DETECT_CUSTOM_LABELS"
    TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_IMAGE_OPERATION_DETECT_FACES = "TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_IMAGE_OPERATION_DETECT_FACES"
    TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_VIDEO_STORED_VIDEO_START_OPERATION_START_LABEL_DETECTION = "TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_VIDEO_STORED_VIDEO_START_OPERATION_START_LABEL_DETECTION"
    CONCURRENT_AMAZON_REKOGNITION_VIDEO_STORED_VIDEO_JOBS_PER_ACCOUNT = "CONCURRENT_AMAZON_REKOGNITION_VIDEO_STORED_VIDEO_JOBS_PER_ACCOUNT"
    TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_OPERATION_ASSOCIATE_FACES = "TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_OPERATION_ASSOCIATE_FACES"
    TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_FACE_LIVENESS_OPERATION_CREATE_FACE_LIVENESS_SESSION = "TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_FACE_LIVENESS_OPERATION_CREATE_FACE_LIVENESS_SESSION"
    TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_CUSTOM_LABELS_OPERATION_DESCRIBE_PROJECTS = "TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_CUSTOM_LABELS_OPERATION_DESCRIBE_PROJECTS"
    TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_CUSTOM_LABELS_OPERATION_PUT_PROJECT_POLICY = "TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_CUSTOM_LABELS_OPERATION_PUT_PROJECT_POLICY"
    TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_VIDEO_STORED_VIDEO_GET_OPERATION_GET_CONTENT_MODERATION = "TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_VIDEO_STORED_VIDEO_GET_OPERATION_GET_CONTENT_MODERATION"
    TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_CUSTOM_LABELS_OPERATION_COPY_PROJECT_VERSION = "TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_CUSTOM_LABELS_OPERATION_COPY_PROJECT_VERSION"
    TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_IMAGE_OPERATION_DELETE_COLLECTION = "TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_IMAGE_OPERATION_DELETE_COLLECTION"
    TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_IMAGE_OPERATION_DESCRIBE_COLLECTION = "TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_IMAGE_OPERATION_DESCRIBE_COLLECTION"
    TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_OPERATION_START_MEDIA_ANALYSIS_JOB = "TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_OPERATION_START_MEDIA_ANALYSIS_JOB"
    TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_CUSTOM_LABELS_OPERATION_STOP_PROJECT_VERSION = "TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_CUSTOM_LABELS_OPERATION_STOP_PROJECT_VERSION"
    TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_VIDEO_STORED_VIDEO_START_OPERATION_START_CELEBRITY_RECOGNITION = "TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_VIDEO_STORED_VIDEO_START_OPERATION_START_CELEBRITY_RECOGNITION"
    TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_VIDEO_STORED_VIDEO_GET_OPERATION_GET_FACE_SEARCH = "TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_VIDEO_STORED_VIDEO_GET_OPERATION_GET_FACE_SEARCH"
    TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_VIDEO_STORED_VIDEO_GET_OPERATION_GET_LABEL_DETECTION = "TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_VIDEO_STORED_VIDEO_GET_OPERATION_GET_LABEL_DETECTION"
    TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_IMAGE_OPERATION_INDEX_FACES = "TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_IMAGE_OPERATION_INDEX_FACES"
    TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_OPERATION_LIST_USERS = "TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_OPERATION_LIST_USERS"
    TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_IMAGE_OPERATION_GET_CELEBRITY_INFO = "TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_IMAGE_OPERATION_GET_CELEBRITY_INFO"
    MAXIMUM_INFERENCE_UNITS_PER_RUNNING_AMAZON_REKOGNITION_CUSTOM_LABELS_MODEL = "MAXIMUM_INFERENCE_UNITS_PER_RUNNING_AMAZON_REKOGNITION_CUSTOM_LABELS_MODEL"
    TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_CUSTOM_LABELS_OPERATION_CREATE_PROJECT = "TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_CUSTOM_LABELS_OPERATION_CREATE_PROJECT"
    AMAZON_REKOGNITION_STREAMING_VIDEO_EVENTS_STREAM_PROCESSORS_PER_AMAZON_KINESIS_VIDEO_INPUT_STREAM = "AMAZON_REKOGNITION_STREAMING_VIDEO_EVENTS_STREAM_PROCESSORS_PER_AMAZON_KINESIS_VIDEO_INPUT_STREAM"
    TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_IMAGE_OPERATION_CREATE_COLLECTION = "TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_IMAGE_OPERATION_CREATE_COLLECTION"
    TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_CUSTOM_LABELS_OPERATION_DELETE_PROJECT_VERSION = "TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_CUSTOM_LABELS_OPERATION_DELETE_PROJECT_VERSION"
    MAXIMUM_NUMBER_OF_IMAGES_PER_AMAZON_REKOGNITION_CUSTOM_LABELS_CLASSIFICATION_TEST_DATASET = "MAXIMUM_NUMBER_OF_IMAGES_PER_AMAZON_REKOGNITION_CUSTOM_LABELS_CLASSIFICATION_TEST_DATASET"
    MAXIMUM_NUMBER_OF_IMAGES_PER_AMAZON_REKOGNITION_CUSTOM_LABELS_DETECTION_TEST_DATASET = "MAXIMUM_NUMBER_OF_IMAGES_PER_AMAZON_REKOGNITION_CUSTOM_LABELS_DETECTION_TEST_DATASET"
    TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_OPERATION_GET_MEDIA_ANALYSIS_JOB = "TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_OPERATION_GET_MEDIA_ANALYSIS_JOB"
    TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_STREAMING_VIDEO_EVENTS_OPERATION_STOP_STREAM_PROCESSOR = "TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_STREAMING_VIDEO_EVENTS_OPERATION_STOP_STREAM_PROCESSOR"
    TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_CUSTOM_LABELS_OPERATION_DELETE_DATASET = "TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_CUSTOM_LABELS_OPERATION_DELETE_DATASET"
    CONCURRENT_AMAZON_REKOGNITION_CUSTOM_LABELS_MODEL_COPY_JOBS_PER_ACCOUNT = "CONCURRENT_AMAZON_REKOGNITION_CUSTOM_LABELS_MODEL_COPY_JOBS_PER_ACCOUNT"
    TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_STREAMING_VIDEO_EVENTS_OPERATION_START_STREAM_PROCESSOR = "TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_STREAMING_VIDEO_EVENTS_OPERATION_START_STREAM_PROCESSOR"
    MAXIMUM_NUMBER_OF_IMAGES_PER_AMAZON_REKOGNITION_CUSTOM_LABELS_DETECTION_TRAINING_DATASET = "MAXIMUM_NUMBER_OF_IMAGES_PER_AMAZON_REKOGNITION_CUSTOM_LABELS_DETECTION_TRAINING_DATASET"
    AMAZON_REKOGNITION_CUSTOM_LABELS_PROJECTS_PER_ACCOUNT = "AMAZON_REKOGNITION_CUSTOM_LABELS_PROJECTS_PER_ACCOUNT"
    TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_VIDEO_STORED_VIDEO_START_OPERATION_START_FACE_DETECTION = "TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_VIDEO_STORED_VIDEO_START_OPERATION_START_FACE_DETECTION"
    TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_IMAGE_OPERATION_SEARCH_FACES_BY_IMAGE = "TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_IMAGE_OPERATION_SEARCH_FACES_BY_IMAGE"
    AMAZON_REKOGNITION_CUSTOM_LABELS_MODELS_PER_PROJECT = "AMAZON_REKOGNITION_CUSTOM_LABELS_MODELS_PER_PROJECT"
    TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_IMAGE_OPERATION_COMPARE_FACES = "TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_IMAGE_OPERATION_COMPARE_FACES"
    TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_CUSTOM_LABELS_OPERATION_CREATE_PROJECT_VERSION = "TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_CUSTOM_LABELS_OPERATION_CREATE_PROJECT_VERSION"
    TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_CUSTOM_LABELS_OPERATION_DISTRIBUTE_DATASET_ENTRIES = "TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_CUSTOM_LABELS_OPERATION_DISTRIBUTE_DATASET_ENTRIES"
    TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_IMAGE_OPERATION_DETECT_LABELS = "TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_IMAGE_OPERATION_DETECT_LABELS"
    TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_STREAMING_VIDEO_EVENTS_OPERATION_DELETE_STREAM_PROCESSOR = "TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_STREAMING_VIDEO_EVENTS_OPERATION_DELETE_STREAM_PROCESSOR"
    CONCURRENT_AMAZON_REKOGNITION_FACE_LIVENESS_SESSIONS_PER_ACCOUNT = "CONCURRENT_AMAZON_REKOGNITION_FACE_LIVENESS_SESSIONS_PER_ACCOUNT"
    TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_FACE_LIVENESS_OPERATION_START_FACE_LIVENESS_SESSION = "TRANSACTIONS_PER_SECOND_PER_ACCOUNT_FOR_THE_AMAZON_REKOGNITION_FACE_LIVENESS_OPERATION_START_FACE_LIVENESS_SESSION"


@jsii.enum(
    jsii_type="@reapit-cdk/service-quotas.AmazonRelationalDatabaseServiceAmazonRdsQuota"
)
class AmazonRelationalDatabaseServiceAmazonRdsQuota(enum.Enum):
    DATA_API_MAXIMUM_CONCURRENT_REQUESTS = "DATA_API_MAXIMUM_CONCURRENT_REQUESTS"
    DATA_API_HTTP_REQUEST_BODY_SIZE = "DATA_API_HTTP_REQUEST_BODY_SIZE"
    TOTAL_STORAGE_FOR_ALL_DB_INSTANCES = "TOTAL_STORAGE_FOR_ALL_DB_INSTANCES"
    MANUAL_DB_CLUSTER_SNAPSHOTS = "MANUAL_DB_CLUSTER_SNAPSHOTS"
    PARAMETER_GROUPS = "PARAMETER_GROUPS"
    MANUAL_DB_INSTANCE_SNAPSHOTS = "MANUAL_DB_INSTANCE_SNAPSHOTS"
    DB_CLUSTERS = "DB_CLUSTERS"
    READ_REPLICAS_PER_PRIMARY = "READ_REPLICAS_PER_PRIMARY"
    IAM_ROLES_PER_DB_CLUSTER = "IAM_ROLES_PER_DB_CLUSTER"
    SECURITY_GROUPS = "SECURITY_GROUPS"
    DATA_API_MAXIMUM_CONCURRENT_CLUSTER_SECRET_PAIRS = "DATA_API_MAXIMUM_CONCURRENT_CLUSTER_SECRET_PAIRS"
    DATA_API_REQUESTS_PER_SECOND = "DATA_API_REQUESTS_PER_SECOND"
    PROXIES = "PROXIES"
    DATA_API_MAXIMUM_SIZE_OF_JSON_RESPONSE_STRING = "DATA_API_MAXIMUM_SIZE_OF_JSON_RESPONSE_STRING"
    DATA_API_MAXIMUM_RESULT_SET_SIZE = "DATA_API_MAXIMUM_RESULT_SET_SIZE"
    RESERVED_DB_INSTANCES = "RESERVED_DB_INSTANCES"
    DB_CLUSTER_PARAMETER_GROUPS = "DB_CLUSTER_PARAMETER_GROUPS"
    DB_INSTANCES = "DB_INSTANCES"
    SUBNETS_PER_DB_SUBNET_GROUP = "SUBNETS_PER_DB_SUBNET_GROUP"
    EVENT_SUBSCRIPTIONS = "EVENT_SUBSCRIPTIONS"
    AUTHORIZATIONS_PER_DB_SECURITY_GROUP = "AUTHORIZATIONS_PER_DB_SECURITY_GROUP"
    OPTION_GROUPS = "OPTION_GROUPS"
    DB_SUBNET_GROUPS = "DB_SUBNET_GROUPS"
    IAM_ROLES_PER_DB_INSTANCE = "IAM_ROLES_PER_DB_INSTANCE"
    RULES_PER_SECURITY_GROUP = "RULES_PER_SECURITY_GROUP"
    SECURITY_GROUPS_VPC = "SECURITY_GROUPS_VPC"
    CUSTOM_ENGINE_VERSIONS = "CUSTOM_ENGINE_VERSIONS"
    TAGS_PER_RESOURCE = "TAGS_PER_RESOURCE"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AmazonRoute53Quota")
class AmazonRoute53Quota(enum.Enum):
    DOMAIN_COUNT_LIMIT = "DOMAIN_COUNT_LIMIT"
    TRAFFIC_FLOW_POLICIES = "TRAFFIC_FLOW_POLICIES"
    HOSTED_ZONES = "HOSTED_ZONES"
    HEALTH_CHECKS = "HEALTH_CHECKS"
    TRAFFIC_FLOW_POLICY_RECORDS = "TRAFFIC_FLOW_POLICY_RECORDS"
    REUSABLE_DELEGATION_SETS = "REUSABLE_DELEGATION_SETS"
    CHILD_HEALTH_CHECKS_THAT_A_CALCULATED_HEALTH_CHECK_CAN_MONITOR = "CHILD_HEALTH_CHECKS_THAT_A_CALCULATED_HEALTH_CHECK_CAN_MONITOR"
    RECORDS_PER_HOSTED_ZONE = "RECORDS_PER_HOSTED_ZONE"
    CIDR_BLOCKS_PER_COLLECTION = "CIDR_BLOCKS_PER_COLLECTION"
    CIDR_COLLECTIONS = "CIDR_COLLECTIONS"
    HOSTED_ZONES_THAT_CAN_USE_THE_SAME_REUSABLE_DELEGATION_SET = "HOSTED_ZONES_THAT_CAN_USE_THE_SAME_REUSABLE_DELEGATION_SET"
    AMAZON_VP_CS_THAT_YOU_CAN_ASSOCIATE_WITH_A_PRIVATE_HOSTED_ZONE = "AMAZON_VP_CS_THAT_YOU_CAN_ASSOCIATE_WITH_A_PRIVATE_HOSTED_ZONE"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AmazonSageMakerQuota")
class AmazonSageMakerQuota(enum.Enum):
    ML_C4_XLARGE_FOR_SPOT_TRAINING_JOB_USAGE = "ML_C4_XLARGE_FOR_SPOT_TRAINING_JOB_USAGE"
    STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_R5_4XLARGE_INSTANCES = "STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_R5_4XLARGE_INSTANCES"
    TOTAL_NUMBER_OF_TRIALS_A_SINGLE_TRIAL_COMPONENT_CAN_BE_ASSOCIATED_TO = "TOTAL_NUMBER_OF_TRIALS_A_SINGLE_TRIAL_COMPONENT_CAN_BE_ASSOCIATED_TO"
    ML_C7I_12XLARGE_FOR_ENDPOINT_USAGE = "ML_C7I_12XLARGE_FOR_ENDPOINT_USAGE"
    ML_P2_XLARGE_FOR_TRAINING_WARM_POOL_USAGE = "ML_P2_XLARGE_FOR_TRAINING_WARM_POOL_USAGE"
    ML_P2_8XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE = "ML_P2_8XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE"
    STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_M5D_12XLARGE_INSTANCE = "STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_M5D_12XLARGE_INSTANCE"
    ML_C5_24XLARGE_FOR_ENDPOINT_USAGE = "ML_C5_24XLARGE_FOR_ENDPOINT_USAGE"
    ML_C4_XLARGE_FOR_TRAINING_JOB_USAGE = "ML_C4_XLARGE_FOR_TRAINING_JOB_USAGE"
    ML_C4_8XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE = "ML_C4_8XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE"
    ML_TRN1N_32XLARGE_FOR_TRAINING_JOB_USAGE = "ML_TRN1N_32XLARGE_FOR_TRAINING_JOB_USAGE"
    ML_M5D_XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE = "ML_M5D_XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE"
    ML_C4_8XLARGE_FOR_TRAINING_WARM_POOL_USAGE = "ML_C4_8XLARGE_FOR_TRAINING_WARM_POOL_USAGE"
    ML_M5_2XLARGE_FOR_SPOT_TRAINING_JOB_USAGE = "ML_M5_2XLARGE_FOR_SPOT_TRAINING_JOB_USAGE"
    ML_C5N_9XLARGE_FOR_ENDPOINT_USAGE = "ML_C5N_9XLARGE_FOR_ENDPOINT_USAGE"
    ML_G5_4XLARGE_FOR_SPOT_TRAINING_JOB_USAGE = "ML_G5_4XLARGE_FOR_SPOT_TRAINING_JOB_USAGE"
    ML_G4DN_16XLARGE_FOR_TRAINING_JOB_USAGE = "ML_G4DN_16XLARGE_FOR_TRAINING_JOB_USAGE"
    STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_C5_LARGE_INSTANCES = "STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_C5_LARGE_INSTANCES"
    STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_C5_XLARGE_INSTANCE = "STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_C5_XLARGE_INSTANCE"
    ML_C5_2XLARGE_FOR_TRAINING_JOB_USAGE = "ML_C5_2XLARGE_FOR_TRAINING_JOB_USAGE"
    ML_G4DN_2XLARGE_FOR_TRAINING_WARM_POOL_USAGE = "ML_G4DN_2XLARGE_FOR_TRAINING_WARM_POOL_USAGE"
    STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_G5_16XLARGE_INSTANCES = "STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_G5_16XLARGE_INSTANCES"
    ML_C6GD_LARGE_FOR_ENDPOINT_USAGE = "ML_C6GD_LARGE_FOR_ENDPOINT_USAGE"
    ML_M5_XLARGE_FOR_TRAINING_JOB_USAGE = "ML_M5_XLARGE_FOR_TRAINING_JOB_USAGE"
    ML_R5DN_24XLARGE_FOR_ENDPOINT_USAGE = "ML_R5DN_24XLARGE_FOR_ENDPOINT_USAGE"
    RATE_OF_LIST_ENDPOINTS_REQUESTS = "RATE_OF_LIST_ENDPOINTS_REQUESTS"
    ML_G4DN_12XLARGE_FOR_TRANSFORM_JOB_USAGE = "ML_G4DN_12XLARGE_FOR_TRANSFORM_JOB_USAGE"
    STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_C5_12XLARGE_INSTANCES = "STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_C5_12XLARGE_INSTANCES"
    NUMBER_OF_INSTANCES_ACROSS_ALL_SPOT_TRAINING_JOBS = "NUMBER_OF_INSTANCES_ACROSS_ALL_SPOT_TRAINING_JOBS"
    ML_C5N_9XLARGE_FOR_SPOT_TRAINING_JOB_USAGE = "ML_C5N_9XLARGE_FOR_SPOT_TRAINING_JOB_USAGE"
    ML_M6G_8XLARGE_FOR_ENDPOINT_USAGE = "ML_M6G_8XLARGE_FOR_ENDPOINT_USAGE"
    STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_P3DN_24XLARGE_INSTANCES = "STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_P3DN_24XLARGE_INSTANCES"
    ML_G5_2XLARGE_FOR_TRAINING_WARM_POOL_USAGE = "ML_G5_2XLARGE_FOR_TRAINING_WARM_POOL_USAGE"
    TOTAL_NUMBER_OF_TRIAL_COMPONENTS_ALLOWED_FROM_A_SAGE_MAKER_CONTEXT_EXCLUDING_THOSE_AUTOMATICALLY_CREATED_BY_SAGE_MAKER = "TOTAL_NUMBER_OF_TRIAL_COMPONENTS_ALLOWED_FROM_A_SAGE_MAKER_CONTEXT_EXCLUDING_THOSE_AUTOMATICALLY_CREATED_BY_SAGE_MAKER"
    ML_G5_16XLARGE_FOR_SPOT_TRAINING_JOB_USAGE = "ML_G5_16XLARGE_FOR_SPOT_TRAINING_JOB_USAGE"
    ML_C5_18XLARGE_FOR_ENDPOINT_USAGE = "ML_C5_18XLARGE_FOR_ENDPOINT_USAGE"
    TOTAL_EBS_VOLUME_SIZE_IN_GB_ACROSS_ALL_STUDIO_SPACES = "TOTAL_EBS_VOLUME_SIZE_IN_GB_ACROSS_ALL_STUDIO_SPACES"
    ML_T2_XLARGE_FOR_ENDPOINT_USAGE = "ML_T2_XLARGE_FOR_ENDPOINT_USAGE"
    RATE_OF_STOP_NOTEBOOK_INSTANCE_REQUESTS = "RATE_OF_STOP_NOTEBOOK_INSTANCE_REQUESTS"
    ML_C6I_2XLARGE_FOR_SPOT_TRAINING_JOB_USAGE = "ML_C6I_2XLARGE_FOR_SPOT_TRAINING_JOB_USAGE"
    R_SESSION_GATEWAY_APPS_RUNNING_ON_ML_T3_MICRO_INSTANCE = "R_SESSION_GATEWAY_APPS_RUNNING_ON_ML_T3_MICRO_INSTANCE"
    ML_M5_16XLARGE_FOR_ENDPOINT_USAGE = "ML_M5_16XLARGE_FOR_ENDPOINT_USAGE"
    STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_R5_24XLARGE_INSTANCE = "STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_R5_24XLARGE_INSTANCE"
    TIME_AT_WHICH_PIPELINE_EXECUTIONS_TIME_OUT = "TIME_AT_WHICH_PIPELINE_EXECUTIONS_TIME_OUT"
    ML_C4_4XLARGE_FOR_ENDPOINT_USAGE = "ML_C4_4XLARGE_FOR_ENDPOINT_USAGE"
    ML_TRN1_2XLARGE_FOR_TRAINING_WARM_POOL_USAGE = "ML_TRN1_2XLARGE_FOR_TRAINING_WARM_POOL_USAGE"
    STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_G5_2XLARGE_INSTANCES = "STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_G5_2XLARGE_INSTANCES"
    STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_G4DN_2XLARGE_INSTANCES = "STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_G4DN_2XLARGE_INSTANCES"
    ML_M4_4XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE = "ML_M4_4XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE"
    STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_R5_8XLARGE_INSTANCES = "STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_R5_8XLARGE_INSTANCES"
    STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_M5D_4XLARGE_INSTANCE = "STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_M5D_4XLARGE_INSTANCE"
    ML_P2_8XLARGE_FOR_ENDPOINT_USAGE = "ML_P2_8XLARGE_FOR_ENDPOINT_USAGE"
    ML_M6I_8XLARGE_FOR_TRAINING_WARM_POOL_USAGE = "ML_M6I_8XLARGE_FOR_TRAINING_WARM_POOL_USAGE"
    ML_C5_4XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE = "ML_C5_4XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE"
    ML_C6I_32XLARGE_FOR_TRAINING_JOB_USAGE = "ML_C6I_32XLARGE_FOR_TRAINING_JOB_USAGE"
    ML_P2_XLARGE_FOR_TRAINING_JOB_USAGE = "ML_P2_XLARGE_FOR_TRAINING_JOB_USAGE"
    ML_C4_8XLARGE_FOR_TRANSFORM_JOB_USAGE = "ML_C4_8XLARGE_FOR_TRANSFORM_JOB_USAGE"
    STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_R5_12XLARGE_INSTANCE = "STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_R5_12XLARGE_INSTANCE"
    ML_G4DN_XLARGE_FOR_TRANSFORM_JOB_USAGE = "ML_G4DN_XLARGE_FOR_TRANSFORM_JOB_USAGE"
    ML_M4_16XLARGE_FOR_TRAINING_WARM_POOL_USAGE = "ML_M4_16XLARGE_FOR_TRAINING_WARM_POOL_USAGE"
    ML_C7I_LARGE_FOR_ENDPOINT_USAGE = "ML_C7I_LARGE_FOR_ENDPOINT_USAGE"
    ML_C7I_2XLARGE_FOR_ENDPOINT_USAGE = "ML_C7I_2XLARGE_FOR_ENDPOINT_USAGE"
    STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_M5_12XLARGE_INSTANCES = "STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_M5_12XLARGE_INSTANCES"
    STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_M5_4XLARGE_INSTANCE = "STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_M5_4XLARGE_INSTANCE"
    ML_M5_12XLARGE_FOR_CLUSTER_USAGE = "ML_M5_12XLARGE_FOR_CLUSTER_USAGE"
    ML_M5D_LARGE_FOR_ENDPOINT_USAGE = "ML_M5D_LARGE_FOR_ENDPOINT_USAGE"
    STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_G4DN_8XLARGE_INSTANCES = "STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_G4DN_8XLARGE_INSTANCES"
    MAXIMUM_NUMBER_OF_DEPLOYMENT_PLANS_THAT_CAN_BE_SIMULTANEOUSLY_CREATED = "MAXIMUM_NUMBER_OF_DEPLOYMENT_PLANS_THAT_CAN_BE_SIMULTANEOUSLY_CREATED"
    ML_C7I_XLARGE_FOR_ENDPOINT_USAGE = "ML_C7I_XLARGE_FOR_ENDPOINT_USAGE"
    STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_G4DN_2XLARGE_INSTANCE = "STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_G4DN_2XLARGE_INSTANCE"
    MAXIMUM_NUMBER_OF_A2_I_HUMAN_TASK_U_IS = "MAXIMUM_NUMBER_OF_A2_I_HUMAN_TASK_U_IS"
    R_SESSION_GATEWAY_APPS_RUNNING_ON_ML_T3_XLARGE_INSTANCE = "R_SESSION_GATEWAY_APPS_RUNNING_ON_ML_T3_XLARGE_INSTANCE"
    ML_M6I_16XLARGE_FOR_TRAINING_WARM_POOL_USAGE = "ML_M6I_16XLARGE_FOR_TRAINING_WARM_POOL_USAGE"
    ML_C6GD_4XLARGE_FOR_ENDPOINT_USAGE = "ML_C6GD_4XLARGE_FOR_ENDPOINT_USAGE"
    ML_M6G_12XLARGE_FOR_ENDPOINT_USAGE = "ML_M6G_12XLARGE_FOR_ENDPOINT_USAGE"
    MAXIMUM_NUMBER_OF_SAGE_MAKER_MODEL_PACKAGE_ALLOWED_PER_ACCOUNT = "MAXIMUM_NUMBER_OF_SAGE_MAKER_MODEL_PACKAGE_ALLOWED_PER_ACCOUNT"
    ML_C4_4XLARGE_FOR_TRAINING_JOB_USAGE = "ML_C4_4XLARGE_FOR_TRAINING_JOB_USAGE"
    ML_TRN1_32XLARGE_FOR_CLUSTER_USAGE = "ML_TRN1_32XLARGE_FOR_CLUSTER_USAGE"
    ML_TRN1N_32XLARGE_FOR_CLUSTER_USAGE = "ML_TRN1N_32XLARGE_FOR_CLUSTER_USAGE"
    MAXIMUM_NUMBER_OF_STEPS_ALLOWED_PER_PIPELINE = "MAXIMUM_NUMBER_OF_STEPS_ALLOWED_PER_PIPELINE"
    ML_G5_12XLARGE_FOR_TRAINING_JOB_USAGE = "ML_G5_12XLARGE_FOR_TRAINING_JOB_USAGE"
    ML_M5_LARGE_FOR_SPOT_TRAINING_JOB_USAGE = "ML_M5_LARGE_FOR_SPOT_TRAINING_JOB_USAGE"
    ML_T2_LARGE_FOR_NOTEBOOK_INSTANCE_USAGE = "ML_T2_LARGE_FOR_NOTEBOOK_INSTANCE_USAGE"
    ML_M4_2XLARGE_FOR_ENDPOINT_USAGE = "ML_M4_2XLARGE_FOR_ENDPOINT_USAGE"
    STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_R5_24XLARGE_INSTANCES = "STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_R5_24XLARGE_INSTANCES"
    STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_T3_2XLARGE_INSTANCES = "STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_T3_2XLARGE_INSTANCES"
    ML_P3DN_24XLARGE_FOR_TRAINING_JOB_USAGE = "ML_P3DN_24XLARGE_FOR_TRAINING_JOB_USAGE"
    ML_M5N_LARGE_FOR_ENDPOINT_USAGE = "ML_M5N_LARGE_FOR_ENDPOINT_USAGE"
    ML_M5D_24XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE = "ML_M5D_24XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE"
    ML_M5N_8XLARGE_FOR_ENDPOINT_USAGE = "ML_M5N_8XLARGE_FOR_ENDPOINT_USAGE"
    ML_R6G_2XLARGE_FOR_ENDPOINT_USAGE = "ML_R6G_2XLARGE_FOR_ENDPOINT_USAGE"
    RATE_OF_DESCRIBE_MODEL_REQUESTS = "RATE_OF_DESCRIBE_MODEL_REQUESTS"
    ML_C6I_4XLARGE_FOR_SPOT_TRAINING_JOB_USAGE = "ML_C6I_4XLARGE_FOR_SPOT_TRAINING_JOB_USAGE"
    ML_T3_LARGE_FOR_NOTEBOOK_INSTANCE_USAGE = "ML_T3_LARGE_FOR_NOTEBOOK_INSTANCE_USAGE"
    STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_G4DN_4XLARGE_INSTANCE = "STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_G4DN_4XLARGE_INSTANCE"
    ML_C5_2XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE = "ML_C5_2XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE"
    ML_P3_2XLARGE_FOR_SPOT_TRAINING_JOB_USAGE = "ML_P3_2XLARGE_FOR_SPOT_TRAINING_JOB_USAGE"
    ML_C6GD_2XLARGE_FOR_ENDPOINT_USAGE = "ML_C6GD_2XLARGE_FOR_ENDPOINT_USAGE"
    ML_R5N_16XLARGE_FOR_ENDPOINT_USAGE = "ML_R5N_16XLARGE_FOR_ENDPOINT_USAGE"
    RATE_OF_DELETE_NOTEBOOK_INSTANCE_REQUESTS = "RATE_OF_DELETE_NOTEBOOK_INSTANCE_REQUESTS"
    ML_M4_16XLARGE_FOR_TRANSFORM_JOB_USAGE = "ML_M4_16XLARGE_FOR_TRANSFORM_JOB_USAGE"
    R_SESSION_GATEWAY_APPS_RUNNING_ON_ML_M5_2XLARGE_INSTANCE = "R_SESSION_GATEWAY_APPS_RUNNING_ON_ML_M5_2XLARGE_INSTANCE"
    ML_C4_2XLARGE_FOR_ENDPOINT_USAGE = "ML_C4_2XLARGE_FOR_ENDPOINT_USAGE"
    RATE_OF_CREATE_STUDIO_LIFECYCLE_CONFIG_REQUESTS = "RATE_OF_CREATE_STUDIO_LIFECYCLE_CONFIG_REQUESTS"
    ML_P2_16XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE = "ML_P2_16XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE"
    STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_R5_16XLARGE_INSTANCES = "STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_R5_16XLARGE_INSTANCES"
    STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_G4DN_12XLARGE_INSTANCES = "STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_G4DN_12XLARGE_INSTANCES"
    ML_G4DN_16XLARGE_FOR_ENDPOINT_USAGE = "ML_G4DN_16XLARGE_FOR_ENDPOINT_USAGE"
    STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_G4DN_4XLARGE_INSTANCES = "STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_G4DN_4XLARGE_INSTANCES"
    STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_G5_12XLARGE_INSTANCES = "STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_G5_12XLARGE_INSTANCES"
    ML_P2_16XLARGE_FOR_TRAINING_JOB_USAGE = "ML_P2_16XLARGE_FOR_TRAINING_JOB_USAGE"
    LONGEST_RUN_TIME_FOR_A_PROCESSING_JOB = "LONGEST_RUN_TIME_FOR_A_PROCESSING_JOB"
    ML_C5N_XLARGE_FOR_TRAINING_JOB_USAGE = "ML_C5N_XLARGE_FOR_TRAINING_JOB_USAGE"
    ML_M5_XLARGE_FOR_ENDPOINT_USAGE = "ML_M5_XLARGE_FOR_ENDPOINT_USAGE"
    ML_T3_2XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE = "ML_T3_2XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE"
    STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_M5_4XLARGE_INSTANCES = "STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_M5_4XLARGE_INSTANCES"
    ML_P5_48XLARGE_FOR_SPOT_TRAINING_JOB_USAGE = "ML_P5_48XLARGE_FOR_SPOT_TRAINING_JOB_USAGE"
    STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_M5D_XLARGE_INSTANCES = "STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_M5D_XLARGE_INSTANCES"
    ML_R5DN_4XLARGE_FOR_ENDPOINT_USAGE = "ML_R5DN_4XLARGE_FOR_ENDPOINT_USAGE"
    ML_M5N_2XLARGE_FOR_ENDPOINT_USAGE = "ML_M5N_2XLARGE_FOR_ENDPOINT_USAGE"
    ML_R5D_24XLARGE_FOR_ENDPOINT_USAGE = "ML_R5D_24XLARGE_FOR_ENDPOINT_USAGE"
    R_STUDIO_SERVER_PRO_APPS_RUNNING_ON_ML_C5_9XLARGE_INSTANCES = "R_STUDIO_SERVER_PRO_APPS_RUNNING_ON_ML_C5_9XLARGE_INSTANCES"
    RATE_OF_UPDATE_MONITORING_ALERT_REQUESTS = "RATE_OF_UPDATE_MONITORING_ALERT_REQUESTS"
    MAXIMUM_NUMBER_OF_HYPER_PARAMETER_TUNING_JOBS_THAT_CAN_RUN_AT_ONCE_IN_PARALLEL = "MAXIMUM_NUMBER_OF_HYPER_PARAMETER_TUNING_JOBS_THAT_CAN_RUN_AT_ONCE_IN_PARALLEL"
    ML_T3_2XLARGE_FOR_PROCESSING_JOB_USAGE = "ML_T3_2XLARGE_FOR_PROCESSING_JOB_USAGE"
    ML_M7I_4XLARGE_FOR_ENDPOINT_USAGE = "ML_M7I_4XLARGE_FOR_ENDPOINT_USAGE"
    ML_G5_8XLARGE_FOR_SPOT_TRAINING_JOB_USAGE = "ML_G5_8XLARGE_FOR_SPOT_TRAINING_JOB_USAGE"
    RATE_OF_CREATE_MODEL_REQUESTS = "RATE_OF_CREATE_MODEL_REQUESTS"
    R_SESSION_GATEWAY_APPS_RUNNING_ON_ML_C5_9XLARGE_INSTANCE = "R_SESSION_GATEWAY_APPS_RUNNING_ON_ML_C5_9XLARGE_INSTANCE"
    STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_M5_2XLARGE_INSTANCES = "STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_M5_2XLARGE_INSTANCES"
    ML_M5_24XLARGE_FOR_TRAINING_WARM_POOL_USAGE = "ML_M5_24XLARGE_FOR_TRAINING_WARM_POOL_USAGE"
    RATE_OF_LIST_MONITORING_ALERTS_REQUESTS = "RATE_OF_LIST_MONITORING_ALERTS_REQUESTS"
    ML_M5_2XLARGE_FOR_ENDPOINT_USAGE = "ML_M5_2XLARGE_FOR_ENDPOINT_USAGE"
    ML_P3_16XLARGE_FOR_ENDPOINT_USAGE = "ML_P3_16XLARGE_FOR_ENDPOINT_USAGE"
    R_SESSION_GATEWAY_APPS_RUNNING_ON_ML_C5_12XLARGE_INSTANCE = "R_SESSION_GATEWAY_APPS_RUNNING_ON_ML_C5_12XLARGE_INSTANCE"
    ML_C6I_8XLARGE_FOR_TRAINING_JOB_USAGE = "ML_C6I_8XLARGE_FOR_TRAINING_JOB_USAGE"
    ML_M5_24XLARGE_FOR_TRAINING_JOB_USAGE = "ML_M5_24XLARGE_FOR_TRAINING_JOB_USAGE"
    ML_R7I_12XLARGE_FOR_ENDPOINT_USAGE = "ML_R7I_12XLARGE_FOR_ENDPOINT_USAGE"
    ML_C6I_24XLARGE_FOR_TRAINING_JOB_USAGE = "ML_C6I_24XLARGE_FOR_TRAINING_JOB_USAGE"
    ML_C6I_24XLARGE_FOR_TRAINING_WARM_POOL_USAGE = "ML_C6I_24XLARGE_FOR_TRAINING_WARM_POOL_USAGE"
    STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_G5_48XLARGE_INSTANCES = "STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_G5_48XLARGE_INSTANCES"
    STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_G4DN_16XLARGE_INSTANCES = "STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_G4DN_16XLARGE_INSTANCES"
    ML_G5_16XLARGE_FOR_CLUSTER_USAGE = "ML_G5_16XLARGE_FOR_CLUSTER_USAGE"
    NUMBER_OF_WORKTEAMS = "NUMBER_OF_WORKTEAMS"
    ML_TRN1_2XLARGE_FOR_ENDPOINT_USAGE = "ML_TRN1_2XLARGE_FOR_ENDPOINT_USAGE"
    ML_G5_48XLARGE_FOR_ENDPOINT_USAGE = "ML_G5_48XLARGE_FOR_ENDPOINT_USAGE"
    R_SESSION_GATEWAY_APPS_RUNNING_ON_ML_C5_2XLARGE_INSTANCE = "R_SESSION_GATEWAY_APPS_RUNNING_ON_ML_C5_2XLARGE_INSTANCE"
    ML_P3_16XLARGE_FOR_SPOT_TRAINING_JOB_USAGE = "ML_P3_16XLARGE_FOR_SPOT_TRAINING_JOB_USAGE"
    ML_T3_XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE = "ML_T3_XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE"
    R_SESSION_GATEWAY_APPS_RUNNING_ON_ML_M5D_24XLARGE_INSTANCE = "R_SESSION_GATEWAY_APPS_RUNNING_ON_ML_M5D_24XLARGE_INSTANCE"
    ML_C7I_8XLARGE_FOR_ENDPOINT_USAGE = "ML_C7I_8XLARGE_FOR_ENDPOINT_USAGE"
    ML_M5_8XLARGE_FOR_CLUSTER_USAGE = "ML_M5_8XLARGE_FOR_CLUSTER_USAGE"
    ML_M7I_8XLARGE_FOR_ENDPOINT_USAGE = "ML_M7I_8XLARGE_FOR_ENDPOINT_USAGE"
    ML_C4_XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE = "ML_C4_XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE"
    ML_M5_4XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE = "ML_M5_4XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE"
    STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_M5D_8XLARGE_INSTANCE = "STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_M5D_8XLARGE_INSTANCE"
    ML_R5_12XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE = "ML_R5_12XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE"
    MAXIMUM_NUMBER_OF_TRAINING_JOBS_THAT_EACH_HYPERPARAMETER_TUNING_JOB_WITH_RANDOM_SEARCH_STRATEGY_CAN_CREATE = "MAXIMUM_NUMBER_OF_TRAINING_JOBS_THAT_EACH_HYPERPARAMETER_TUNING_JOB_WITH_RANDOM_SEARCH_STRATEGY_CAN_CREATE"
    ML_C6GN_2XLARGE_FOR_ENDPOINT_USAGE = "ML_C6GN_2XLARGE_FOR_ENDPOINT_USAGE"
    ML_M4_XLARGE_FOR_TRANSFORM_JOB_USAGE = "ML_M4_XLARGE_FOR_TRANSFORM_JOB_USAGE"
    R_SESSION_GATEWAY_APPS_RUNNING_ON_ML_P4D_24XLARGE_INSTANCE = "R_SESSION_GATEWAY_APPS_RUNNING_ON_ML_P4D_24XLARGE_INSTANCE"
    STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_M5D_8XLARGE_INSTANCES = "STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_M5D_8XLARGE_INSTANCES"
    ML_M5_16XLARGE_FOR_CLUSTER_USAGE = "ML_M5_16XLARGE_FOR_CLUSTER_USAGE"
    ML_C5_4XLARGE_FOR_TRAINING_WARM_POOL_USAGE = "ML_C5_4XLARGE_FOR_TRAINING_WARM_POOL_USAGE"
    ML_M5DN_8XLARGE_FOR_ENDPOINT_USAGE = "ML_M5DN_8XLARGE_FOR_ENDPOINT_USAGE"
    ML_C5N_2XLARGE_FOR_TRAINING_JOB_USAGE = "ML_C5N_2XLARGE_FOR_TRAINING_JOB_USAGE"
    ML_C4_2XLARGE_FOR_TRANSFORM_JOB_USAGE = "ML_C4_2XLARGE_FOR_TRANSFORM_JOB_USAGE"
    ML_G5_24XLARGE_FOR_TRAINING_WARM_POOL_USAGE = "ML_G5_24XLARGE_FOR_TRAINING_WARM_POOL_USAGE"
    ML_M5DN_LARGE_FOR_ENDPOINT_USAGE = "ML_M5DN_LARGE_FOR_ENDPOINT_USAGE"
    STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_M5_12XLARGE_INSTANCES = "STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_M5_12XLARGE_INSTANCES"
    ML_C5N_18XLARGE_FOR_ENDPOINT_USAGE = "ML_C5N_18XLARGE_FOR_ENDPOINT_USAGE"
    MAXIMUM_NUMBER_OF_INSTANCES_PER_SPOT_TRAINING_JOB = "MAXIMUM_NUMBER_OF_INSTANCES_PER_SPOT_TRAINING_JOB"
    ML_M6GD_XLARGE_FOR_ENDPOINT_USAGE = "ML_M6GD_XLARGE_FOR_ENDPOINT_USAGE"
    RATE_OF_CREATE_TRANSFORM_JOB_REQUESTS = "RATE_OF_CREATE_TRANSFORM_JOB_REQUESTS"
    ML_EIA1_MEDIUM_FOR_ENDPOINT_USAGE = "ML_EIA1_MEDIUM_FOR_ENDPOINT_USAGE"
    ML_C6I_12XLARGE_FOR_TRAINING_JOB_USAGE = "ML_C6I_12XLARGE_FOR_TRAINING_JOB_USAGE"
    ML_M4_4XLARGE_FOR_TRAINING_WARM_POOL_USAGE = "ML_M4_4XLARGE_FOR_TRAINING_WARM_POOL_USAGE"
    ML_C4_8XLARGE_FOR_ENDPOINT_USAGE = "ML_C4_8XLARGE_FOR_ENDPOINT_USAGE"
    STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_M5_16XLARGE_INSTANCE = "STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_M5_16XLARGE_INSTANCE"
    ML_M6I_XLARGE_FOR_SPOT_TRAINING_JOB_USAGE = "ML_M6I_XLARGE_FOR_SPOT_TRAINING_JOB_USAGE"
    R_SESSION_GATEWAY_APPS_RUNNING_ON_ML_M5_12XLARGE_INSTANCE = "R_SESSION_GATEWAY_APPS_RUNNING_ON_ML_M5_12XLARGE_INSTANCE"
    ML_R5_2XLARGE_FOR_ENDPOINT_USAGE = "ML_R5_2XLARGE_FOR_ENDPOINT_USAGE"
    ML_M5_4XLARGE_FOR_TRANSFORM_JOB_USAGE = "ML_M5_4XLARGE_FOR_TRANSFORM_JOB_USAGE"
    STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_C5_XLARGE_INSTANCES = "STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_C5_XLARGE_INSTANCES"
    RATE_OF_CREATE_ENDPOINT_CONFIG_REQUESTS = "RATE_OF_CREATE_ENDPOINT_CONFIG_REQUESTS"
    ML_C7I_48XLARGE_FOR_ENDPOINT_USAGE = "ML_C7I_48XLARGE_FOR_ENDPOINT_USAGE"
    ML_P5_48XLARGE_FOR_CLUSTER_USAGE = "ML_P5_48XLARGE_FOR_CLUSTER_USAGE"
    ML_C5D_18XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE = "ML_C5D_18XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE"
    ML_M4_4XLARGE_FOR_TRAINING_JOB_USAGE = "ML_M4_4XLARGE_FOR_TRAINING_JOB_USAGE"
    ML_G4DN_12XLARGE_FOR_ENDPOINT_USAGE = "ML_G4DN_12XLARGE_FOR_ENDPOINT_USAGE"
    ML_C7G_8XLARGE_FOR_ENDPOINT_USAGE = "ML_C7G_8XLARGE_FOR_ENDPOINT_USAGE"
    R_SESSION_GATEWAY_APPS_RUNNING_ON_ML_P3_2XLARGE_INSTANCE = "R_SESSION_GATEWAY_APPS_RUNNING_ON_ML_P3_2XLARGE_INSTANCE"
    MAXIMUM_NUMBER_OF_PARALLEL_COMPILATION_JOBS = "MAXIMUM_NUMBER_OF_PARALLEL_COMPILATION_JOBS"
    ML_C6I_12XLARGE_FOR_SPOT_TRAINING_JOB_USAGE = "ML_C6I_12XLARGE_FOR_SPOT_TRAINING_JOB_USAGE"
    STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_G4DN_8XLARGE_INSTANCES = "STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_G4DN_8XLARGE_INSTANCES"
    ML_M6I_LARGE_FOR_TRAINING_WARM_POOL_USAGE = "ML_M6I_LARGE_FOR_TRAINING_WARM_POOL_USAGE"
    STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_G4DN_16XLARGE_INSTANCE = "STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_G4DN_16XLARGE_INSTANCE"
    ML_M5_LARGE_FOR_TRAINING_WARM_POOL_USAGE = "ML_M5_LARGE_FOR_TRAINING_WARM_POOL_USAGE"
    ML_C5_4XLARGE_FOR_PROCESSING_JOB_USAGE = "ML_C5_4XLARGE_FOR_PROCESSING_JOB_USAGE"
    ML_C4_8XLARGE_FOR_SPOT_TRAINING_JOB_USAGE = "ML_C4_8XLARGE_FOR_SPOT_TRAINING_JOB_USAGE"
    ML_C6I_8XLARGE_FOR_TRAINING_WARM_POOL_USAGE = "ML_C6I_8XLARGE_FOR_TRAINING_WARM_POOL_USAGE"
    ML_T3_MEDIUM_FOR_NOTEBOOK_INSTANCE_USAGE = "ML_T3_MEDIUM_FOR_NOTEBOOK_INSTANCE_USAGE"
    ML_M4_XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE = "ML_M4_XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE"
    STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_P3_8XLARGE_INSTANCES = "STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_P3_8XLARGE_INSTANCES"
    ML_G4DN_12XLARGE_FOR_CLUSTER_USAGE = "ML_G4DN_12XLARGE_FOR_CLUSTER_USAGE"
    MAXIMUM_NUMBER_OF_SAGE_MAKER_IMAGE_IMAGES_ALLOWED_PER_ACCOUNT = "MAXIMUM_NUMBER_OF_SAGE_MAKER_IMAGE_IMAGES_ALLOWED_PER_ACCOUNT"
    ML_P3_8XLARGE_FOR_PROCESSING_JOB_USAGE = "ML_P3_8XLARGE_FOR_PROCESSING_JOB_USAGE"
    ML_M6I_4XLARGE_FOR_TRAINING_WARM_POOL_USAGE = "ML_M6I_4XLARGE_FOR_TRAINING_WARM_POOL_USAGE"
    CANVAS_APPS_RUNNING_ON_SYSTEM_INSTANCES = "CANVAS_APPS_RUNNING_ON_SYSTEM_INSTANCES"
    STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_T3_LARGE_INSTANCES = "STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_T3_LARGE_INSTANCES"
    ML_M5_XLARGE_FOR_TRANSFORM_JOB_USAGE = "ML_M5_XLARGE_FOR_TRANSFORM_JOB_USAGE"
    ML_P4DE_24XLARGE_FOR_ENDPOINT_USAGE = "ML_P4DE_24XLARGE_FOR_ENDPOINT_USAGE"
    ML_P2_8XLARGE_FOR_PROCESSING_JOB_USAGE = "ML_P2_8XLARGE_FOR_PROCESSING_JOB_USAGE"
    ML_INF1_6XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE = "ML_INF1_6XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE"
    ML_R5_12XLARGE_FOR_ENDPOINT_USAGE = "ML_R5_12XLARGE_FOR_ENDPOINT_USAGE"
    MAXIMUM_NUMBER_OF_INSTANCES_PER_ENDPOINT = "MAXIMUM_NUMBER_OF_INSTANCES_PER_ENDPOINT"
    ML_C5_9XLARGE_FOR_SPOT_TRAINING_JOB_USAGE = "ML_C5_9XLARGE_FOR_SPOT_TRAINING_JOB_USAGE"
    R_SESSION_GATEWAY_APPS_RUNNING_ON_ML_R5_4XLARGE_INSTANCE = "R_SESSION_GATEWAY_APPS_RUNNING_ON_ML_R5_4XLARGE_INSTANCE"
    ML_P5_48XLARGE_FOR_TRAINING_JOB_USAGE = "ML_P5_48XLARGE_FOR_TRAINING_JOB_USAGE"
    ML_M5_2XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE = "ML_M5_2XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE"
    R_SESSION_GATEWAY_APPS_RUNNING_ON_ML_R5_24XLARGE_INSTANCE = "R_SESSION_GATEWAY_APPS_RUNNING_ON_ML_R5_24XLARGE_INSTANCE"
    ML_C5_XLARGE_FOR_SPOT_TRAINING_JOB_USAGE = "ML_C5_XLARGE_FOR_SPOT_TRAINING_JOB_USAGE"
    ML_P2_8XLARGE_FOR_SPOT_TRAINING_JOB_USAGE = "ML_P2_8XLARGE_FOR_SPOT_TRAINING_JOB_USAGE"
    ML_C6GD_16XLARGE_FOR_ENDPOINT_USAGE = "ML_C6GD_16XLARGE_FOR_ENDPOINT_USAGE"
    ML_M4_XLARGE_FOR_SPOT_TRAINING_JOB_USAGE = "ML_M4_XLARGE_FOR_SPOT_TRAINING_JOB_USAGE"
    MAXIMUM_NUMBER_OF_PIPELINES_ALLOWED_PER_ACCOUNT = "MAXIMUM_NUMBER_OF_PIPELINES_ALLOWED_PER_ACCOUNT"
    R_SESSION_GATEWAY_APPS_RUNNING_ON_ML_C5_XLARGE_INSTANCE = "R_SESSION_GATEWAY_APPS_RUNNING_ON_ML_C5_XLARGE_INSTANCE"
    ML_T3_LARGE_FOR_CLUSTER_USAGE = "ML_T3_LARGE_FOR_CLUSTER_USAGE"
    R_SESSION_GATEWAY_APPS_RUNNING_ON_ML_R5_LARGE_INSTANCE = "R_SESSION_GATEWAY_APPS_RUNNING_ON_ML_R5_LARGE_INSTANCE"
    ML_G5_12XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE = "ML_G5_12XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE"
    R_SESSION_GATEWAY_APPS_RUNNING_ON_ML_R5_16XLARGE_INSTANCE = "R_SESSION_GATEWAY_APPS_RUNNING_ON_ML_R5_16XLARGE_INSTANCE"
    MAXIMUM_NUMBER_OF_GROUND_TRUTH_STREAMING_LABELING_JOBS = "MAXIMUM_NUMBER_OF_GROUND_TRUTH_STREAMING_LABELING_JOBS"
    STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_T3_XLARGE_INSTANCES = "STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_T3_XLARGE_INSTANCES"
    ML_G5_8XLARGE_FOR_CLUSTER_USAGE = "ML_G5_8XLARGE_FOR_CLUSTER_USAGE"
    ML_M7I_12XLARGE_FOR_ENDPOINT_USAGE = "ML_M7I_12XLARGE_FOR_ENDPOINT_USAGE"
    ML_C5N_9XLARGE_FOR_TRAINING_JOB_USAGE = "ML_C5N_9XLARGE_FOR_TRAINING_JOB_USAGE"
    ML_G4DN_4XLARGE_FOR_TRAINING_JOB_USAGE = "ML_G4DN_4XLARGE_FOR_TRAINING_JOB_USAGE"
    ML_G4DN_8XLARGE_FOR_CLUSTER_USAGE = "ML_G4DN_8XLARGE_FOR_CLUSTER_USAGE"
    ML_C6G_2XLARGE_FOR_ENDPOINT_USAGE = "ML_C6G_2XLARGE_FOR_ENDPOINT_USAGE"
    STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_C5_4XLARGE_INSTANCE = "STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_C5_4XLARGE_INSTANCE"
    MAXIMUM_NUMBER_INSTANCES_ALLOWED_PER_SAGE_MAKER_HYPER_POD_CLUSTER = "MAXIMUM_NUMBER_INSTANCES_ALLOWED_PER_SAGE_MAKER_HYPER_POD_CLUSTER"
    ML_G4DN_XLARGE_FOR_SPOT_TRAINING_JOB_USAGE = "ML_G4DN_XLARGE_FOR_SPOT_TRAINING_JOB_USAGE"
    ML_M6GD_16XLARGE_FOR_ENDPOINT_USAGE = "ML_M6GD_16XLARGE_FOR_ENDPOINT_USAGE"
    STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_M5D_16XLARGE_INSTANCE = "STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_M5D_16XLARGE_INSTANCE"
    ML_G4DN_8XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE = "ML_G4DN_8XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE"
    ML_P2_8XLARGE_FOR_TRAINING_JOB_USAGE = "ML_P2_8XLARGE_FOR_TRAINING_JOB_USAGE"
    ML_G4DN_8XLARGE_FOR_PROCESSING_JOB_USAGE = "ML_G4DN_8XLARGE_FOR_PROCESSING_JOB_USAGE"
    ML_C4_LARGE_FOR_ENDPOINT_USAGE = "ML_C4_LARGE_FOR_ENDPOINT_USAGE"
    ML_C5_2XLARGE_FOR_CLUSTER_USAGE = "ML_C5_2XLARGE_FOR_CLUSTER_USAGE"
    ML_TRN1N_32XLARGE_FOR_ENDPOINT_USAGE = "ML_TRN1N_32XLARGE_FOR_ENDPOINT_USAGE"
    ML_M4_4XLARGE_FOR_TRANSFORM_JOB_USAGE = "ML_M4_4XLARGE_FOR_TRANSFORM_JOB_USAGE"
    ML_C5N_LARGE_FOR_ENDPOINT_USAGE = "ML_C5N_LARGE_FOR_ENDPOINT_USAGE"
    ML_C5N_2XLARGE_FOR_CLUSTER_USAGE = "ML_C5N_2XLARGE_FOR_CLUSTER_USAGE"
    ML_G4DN_4XLARGE_FOR_TRANSFORM_JOB_USAGE = "ML_G4DN_4XLARGE_FOR_TRANSFORM_JOB_USAGE"
    R_SESSION_GATEWAY_APPS_RUNNING_ON_ML_P3DN_24XLARGE_INSTANCE = "R_SESSION_GATEWAY_APPS_RUNNING_ON_ML_P3DN_24XLARGE_INSTANCE"
    ML_R6GD_LARGE_FOR_ENDPOINT_USAGE = "ML_R6GD_LARGE_FOR_ENDPOINT_USAGE"
    ML_M6I_16XLARGE_FOR_TRAINING_JOB_USAGE = "ML_M6I_16XLARGE_FOR_TRAINING_JOB_USAGE"
    MAXIMUM_NUMBER_OF_SAGE_MAKER_MODEL_PACKAGE_GROUPS_ALLOWED_PER_ACCOUNT = "MAXIMUM_NUMBER_OF_SAGE_MAKER_MODEL_PACKAGE_GROUPS_ALLOWED_PER_ACCOUNT"
    STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_P3_8XLARGE_INSTANCES = "STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_P3_8XLARGE_INSTANCES"
    ML_R6GD_12XLARGE_FOR_ENDPOINT_USAGE = "ML_R6GD_12XLARGE_FOR_ENDPOINT_USAGE"
    STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_M5D_8XLARGE_INSTANCES = "STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_M5D_8XLARGE_INSTANCES"
    ML_G5_XLARGE_FOR_SPOT_TRAINING_JOB_USAGE = "ML_G5_XLARGE_FOR_SPOT_TRAINING_JOB_USAGE"
    ML_M5_4XLARGE_FOR_SPOT_TRAINING_JOB_USAGE = "ML_M5_4XLARGE_FOR_SPOT_TRAINING_JOB_USAGE"
    R_SESSION_GATEWAY_APPS_RUNNING_ON_ML_P3_8XLARGE_INSTANCE = "R_SESSION_GATEWAY_APPS_RUNNING_ON_ML_P3_8XLARGE_INSTANCE"
    ML_G5_12XLARGE_FOR_SPOT_TRAINING_JOB_USAGE = "ML_G5_12XLARGE_FOR_SPOT_TRAINING_JOB_USAGE"
    ML_C5_2XLARGE_FOR_ENDPOINT_USAGE = "ML_C5_2XLARGE_FOR_ENDPOINT_USAGE"
    RATE_OF_DELETE_MODEL_REQUESTS = "RATE_OF_DELETE_MODEL_REQUESTS"
    RATE_OF_DESCRIBE_TRANSFORM_JOB_REQUESTS = "RATE_OF_DESCRIBE_TRANSFORM_JOB_REQUESTS"
    STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_P3_16XLARGE_INSTANCES = "STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_P3_16XLARGE_INSTANCES"
    ML_R6G_XLARGE_FOR_ENDPOINT_USAGE = "ML_R6G_XLARGE_FOR_ENDPOINT_USAGE"
    ML_C6I_12XLARGE_FOR_TRAINING_WARM_POOL_USAGE = "ML_C6I_12XLARGE_FOR_TRAINING_WARM_POOL_USAGE"
    ML_P3DN_24XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE = "ML_P3DN_24XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE"
    ML_R5_2XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE = "ML_R5_2XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE"
    STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_C5_18XLARGE_INSTANCE = "STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_C5_18XLARGE_INSTANCE"
    ML_P2_16XLARGE_FOR_SPOT_TRAINING_JOB_USAGE = "ML_P2_16XLARGE_FOR_SPOT_TRAINING_JOB_USAGE"
    ML_M5_24XLARGE_FOR_CLUSTER_USAGE = "ML_M5_24XLARGE_FOR_CLUSTER_USAGE"
    ML_G5_XLARGE_FOR_ENDPOINT_USAGE = "ML_G5_XLARGE_FOR_ENDPOINT_USAGE"
    MAXIMUM_NUMBER_OF_CONCURRENT_PIPELINE_EXECUTIONS_ALLOWED_PER_ACCOUNT = "MAXIMUM_NUMBER_OF_CONCURRENT_PIPELINE_EXECUTIONS_ALLOWED_PER_ACCOUNT"
    ML_R6G_LARGE_FOR_ENDPOINT_USAGE = "ML_R6G_LARGE_FOR_ENDPOINT_USAGE"
    ML_C5_12XLARGE_FOR_ENDPOINT_USAGE = "ML_C5_12XLARGE_FOR_ENDPOINT_USAGE"
    ML_G4DN_4XLARGE_FOR_SPOT_TRAINING_JOB_USAGE = "ML_G4DN_4XLARGE_FOR_SPOT_TRAINING_JOB_USAGE"
    ML_G4DN_12XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE = "ML_G4DN_12XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE"
    STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_T3_2XLARGE_INSTANCES = "STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_T3_2XLARGE_INSTANCES"
    ML_G5_2XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE = "ML_G5_2XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE"
    ML_M5DN_4XLARGE_FOR_ENDPOINT_USAGE = "ML_M5DN_4XLARGE_FOR_ENDPOINT_USAGE"
    ML_M5N_12XLARGE_FOR_ENDPOINT_USAGE = "ML_M5N_12XLARGE_FOR_ENDPOINT_USAGE"
    ML_G5_2XLARGE_FOR_TRAINING_JOB_USAGE = "ML_G5_2XLARGE_FOR_TRAINING_JOB_USAGE"
    RATE_OF_STOP_TRANSFORM_JOB_REQUESTS = "RATE_OF_STOP_TRANSFORM_JOB_REQUESTS"
    ML_G4DN_2XLARGE_FOR_PROCESSING_JOB_USAGE = "ML_G4DN_2XLARGE_FOR_PROCESSING_JOB_USAGE"
    ML_C6GN_4XLARGE_FOR_ENDPOINT_USAGE = "ML_C6GN_4XLARGE_FOR_ENDPOINT_USAGE"
    ML_M6I_2XLARGE_FOR_TRAINING_WARM_POOL_USAGE = "ML_M6I_2XLARGE_FOR_TRAINING_WARM_POOL_USAGE"
    ML_P2_XLARGE_FOR_TRANSFORM_JOB_USAGE = "ML_P2_XLARGE_FOR_TRANSFORM_JOB_USAGE"
    ML_R5_2XLARGE_FOR_PROCESSING_JOB_USAGE = "ML_R5_2XLARGE_FOR_PROCESSING_JOB_USAGE"
    STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_G5_48XLARGE_INSTANCE = "STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_G5_48XLARGE_INSTANCE"
    ML_M5_12XLARGE_FOR_TRANSFORM_JOB_USAGE = "ML_M5_12XLARGE_FOR_TRANSFORM_JOB_USAGE"
    STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_R5_XLARGE_INSTANCES = "STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_R5_XLARGE_INSTANCES"
    ML_P4D_24XLARGE_FOR_TRAINING_JOB_USAGE = "ML_P4D_24XLARGE_FOR_TRAINING_JOB_USAGE"
    ML_M6I_XLARGE_FOR_TRAINING_JOB_USAGE = "ML_M6I_XLARGE_FOR_TRAINING_JOB_USAGE"
    STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_P3_8XLARGE_INSTANCE = "STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_P3_8XLARGE_INSTANCE"
    R_SESSION_GATEWAY_APPS_RUNNING_ON_ML_G4DN_2XLARGE_INSTANCE = "R_SESSION_GATEWAY_APPS_RUNNING_ON_ML_G4DN_2XLARGE_INSTANCE"
    ML_M5N_XLARGE_FOR_ENDPOINT_USAGE = "ML_M5N_XLARGE_FOR_ENDPOINT_USAGE"
    ML_C6G_XLARGE_FOR_ENDPOINT_USAGE = "ML_C6G_XLARGE_FOR_ENDPOINT_USAGE"
    ML_M5D_LARGE_FOR_NOTEBOOK_INSTANCE_USAGE = "ML_M5D_LARGE_FOR_NOTEBOOK_INSTANCE_USAGE"
    ML_R5_4XLARGE_FOR_ENDPOINT_USAGE = "ML_R5_4XLARGE_FOR_ENDPOINT_USAGE"
    ML_C4_2XLARGE_FOR_TRAINING_JOB_USAGE = "ML_C4_2XLARGE_FOR_TRAINING_JOB_USAGE"
    ML_M4_XLARGE_FOR_TRAINING_JOB_USAGE = "ML_M4_XLARGE_FOR_TRAINING_JOB_USAGE"
    RATE_OF_LIST_TRANSFORM_JOBS_REQUESTS = "RATE_OF_LIST_TRANSFORM_JOBS_REQUESTS"
    ML_R6GD_4XLARGE_FOR_ENDPOINT_USAGE = "ML_R6GD_4XLARGE_FOR_ENDPOINT_USAGE"
    ML_INF1_2XLARGE_FOR_ENDPOINT_USAGE = "ML_INF1_2XLARGE_FOR_ENDPOINT_USAGE"
    STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_R5_12XLARGE_INSTANCES = "STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_R5_12XLARGE_INSTANCES"
    ML_G5_48XLARGE_FOR_SPOT_TRAINING_JOB_USAGE = "ML_G5_48XLARGE_FOR_SPOT_TRAINING_JOB_USAGE"
    ML_R5D_XLARGE_FOR_ENDPOINT_USAGE = "ML_R5D_XLARGE_FOR_ENDPOINT_USAGE"
    ML_R5DN_2XLARGE_FOR_ENDPOINT_USAGE = "ML_R5DN_2XLARGE_FOR_ENDPOINT_USAGE"
    ML_C6I_32XLARGE_FOR_ENDPOINT_USAGE = "ML_C6I_32XLARGE_FOR_ENDPOINT_USAGE"
    ML_C5_2XLARGE_FOR_PROCESSING_JOB_USAGE = "ML_C5_2XLARGE_FOR_PROCESSING_JOB_USAGE"
    RATE_OF_UPDATE_ENDPOINT_WEIGHTS_AND_CAPACITIES_REQUESTS = "RATE_OF_UPDATE_ENDPOINT_WEIGHTS_AND_CAPACITIES_REQUESTS"
    ML_M5_4XLARGE_FOR_CLUSTER_USAGE = "ML_M5_4XLARGE_FOR_CLUSTER_USAGE"
    ML_C5_4XLARGE_FOR_CLUSTER_USAGE = "ML_C5_4XLARGE_FOR_CLUSTER_USAGE"
    TOTAL_EBS_VOLUME_SIZE_IN_GB_ACROSS_ALL_NOTEBOOK_INSTANCES = "TOTAL_EBS_VOLUME_SIZE_IN_GB_ACROSS_ALL_NOTEBOOK_INSTANCES"
    ML_C6I_32XLARGE_FOR_SPOT_TRAINING_JOB_USAGE = "ML_C6I_32XLARGE_FOR_SPOT_TRAINING_JOB_USAGE"
    STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_P4DE_24XLARGE_INSTANCES = "STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_P4DE_24XLARGE_INSTANCES"
    STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_R5_2XLARGE_INSTANCES = "STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_R5_2XLARGE_INSTANCES"
    ML_M6GD_4XLARGE_FOR_ENDPOINT_USAGE = "ML_M6GD_4XLARGE_FOR_ENDPOINT_USAGE"
    STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_M5D_2XLARGE_INSTANCE = "STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_M5D_2XLARGE_INSTANCE"
    ML_M4_XLARGE_FOR_TRAINING_WARM_POOL_USAGE = "ML_M4_XLARGE_FOR_TRAINING_WARM_POOL_USAGE"
    STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_M5_LARGE_INSTANCES = "STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_M5_LARGE_INSTANCES"
    ML_C5N_XLARGE_FOR_SPOT_TRAINING_JOB_USAGE = "ML_C5N_XLARGE_FOR_SPOT_TRAINING_JOB_USAGE"
    ML_C5_4XLARGE_FOR_ENDPOINT_USAGE = "ML_C5_4XLARGE_FOR_ENDPOINT_USAGE"
    ML_M6G_LARGE_FOR_ENDPOINT_USAGE = "ML_M6G_LARGE_FOR_ENDPOINT_USAGE"
    ML_C5D_2XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE = "ML_C5D_2XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE"
    ML_C5_9XLARGE_FOR_TRAINING_JOB_USAGE = "ML_C5_9XLARGE_FOR_TRAINING_JOB_USAGE"
    STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_G4DN_2XLARGE_INSTANCES = "STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_G4DN_2XLARGE_INSTANCES"
    ML_C5_XLARGE_FOR_TRANSFORM_JOB_USAGE = "ML_C5_XLARGE_FOR_TRANSFORM_JOB_USAGE"
    ML_G5_2XLARGE_FOR_SPOT_TRAINING_JOB_USAGE = "ML_G5_2XLARGE_FOR_SPOT_TRAINING_JOB_USAGE"
    MAXIMUM_NUMBER_OF_CONCURRENTLY_RUNNING_MODEL_CARD_EXPORT_JOBS_ALLOWED_PER_ACCOUNT = "MAXIMUM_NUMBER_OF_CONCURRENTLY_RUNNING_MODEL_CARD_EXPORT_JOBS_ALLOWED_PER_ACCOUNT"
    ML_G4DN_8XLARGE_FOR_SPOT_TRAINING_JOB_USAGE = "ML_G4DN_8XLARGE_FOR_SPOT_TRAINING_JOB_USAGE"
    ML_G4DN_8XLARGE_FOR_TRAINING_WARM_POOL_USAGE = "ML_G4DN_8XLARGE_FOR_TRAINING_WARM_POOL_USAGE"
    ML_G4DN_12XLARGE_FOR_PROCESSING_JOB_USAGE = "ML_G4DN_12XLARGE_FOR_PROCESSING_JOB_USAGE"
    ML_C6GD_8XLARGE_FOR_ENDPOINT_USAGE = "ML_C6GD_8XLARGE_FOR_ENDPOINT_USAGE"
    ML_C6I_XLARGE_FOR_TRAINING_WARM_POOL_USAGE = "ML_C6I_XLARGE_FOR_TRAINING_WARM_POOL_USAGE"
    ML_G4DN_4XLARGE_FOR_ENDPOINT_USAGE = "ML_G4DN_4XLARGE_FOR_ENDPOINT_USAGE"
    ML_C6G_4XLARGE_FOR_ENDPOINT_USAGE = "ML_C6G_4XLARGE_FOR_ENDPOINT_USAGE"
    STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_M5D_12XLARGE_INSTANCES = "STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_M5D_12XLARGE_INSTANCES"
    ML_M4_16XLARGE_FOR_PROCESSING_JOB_USAGE = "ML_M4_16XLARGE_FOR_PROCESSING_JOB_USAGE"
    ML_C5_LARGE_FOR_CLUSTER_USAGE = "ML_C5_LARGE_FOR_CLUSTER_USAGE"
    ML_INF2_48XLARGE_FOR_ENDPOINT_USAGE = "ML_INF2_48XLARGE_FOR_ENDPOINT_USAGE"
    RATE_OF_LIST_NOTEBOOK_INSTANCES_REQUESTS = "RATE_OF_LIST_NOTEBOOK_INSTANCES_REQUESTS"
    ML_C6I_16XLARGE_FOR_ENDPOINT_USAGE = "ML_C6I_16XLARGE_FOR_ENDPOINT_USAGE"
    R_SESSION_GATEWAY_APPS_RUNNING_ON_ML_G4DN_12XLARGE_INSTANCE = "R_SESSION_GATEWAY_APPS_RUNNING_ON_ML_G4DN_12XLARGE_INSTANCE"
    R_SESSION_GATEWAY_APPS_RUNNING_ON_ML_R5_2XLARGE_INSTANCE = "R_SESSION_GATEWAY_APPS_RUNNING_ON_ML_R5_2XLARGE_INSTANCE"
    ML_P3DN_24XLARGE_FOR_SPOT_TRAINING_JOB_USAGE = "ML_P3DN_24XLARGE_FOR_SPOT_TRAINING_JOB_USAGE"
    ML_P4D_24XLARGE_FOR_CLUSTER_USAGE = "ML_P4D_24XLARGE_FOR_CLUSTER_USAGE"
    STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_M5D_24XLARGE_INSTANCES = "STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_M5D_24XLARGE_INSTANCES"
    ML_M6I_4XLARGE_FOR_TRAINING_JOB_USAGE = "ML_M6I_4XLARGE_FOR_TRAINING_JOB_USAGE"
    MAXIMUM_NUMBER_OF_TRAINING_JOBS_EACH_HYPER_PARAMETER_TUNING_JOB_CAN_RUN_IN_PARALLEL_AT_ONCE = "MAXIMUM_NUMBER_OF_TRAINING_JOBS_EACH_HYPER_PARAMETER_TUNING_JOB_CAN_RUN_IN_PARALLEL_AT_ONCE"
    ML_M4_10XLARGE_FOR_TRAINING_WARM_POOL_USAGE = "ML_M4_10XLARGE_FOR_TRAINING_WARM_POOL_USAGE"
    ML_M4_4XLARGE_FOR_SPOT_TRAINING_JOB_USAGE = "ML_M4_4XLARGE_FOR_SPOT_TRAINING_JOB_USAGE"
    R_SESSION_GATEWAY_APPS_RUNNING_ON_ML_M5D_12XLARGE_INSTANCE = "R_SESSION_GATEWAY_APPS_RUNNING_ON_ML_M5D_12XLARGE_INSTANCE"
    ML_C5D_LARGE_FOR_ENDPOINT_USAGE = "ML_C5D_LARGE_FOR_ENDPOINT_USAGE"
    ML_G5_XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE = "ML_G5_XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE"
    ML_R5_XLARGE_FOR_ENDPOINT_USAGE = "ML_R5_XLARGE_FOR_ENDPOINT_USAGE"
    ML_M4_4XLARGE_FOR_ENDPOINT_USAGE = "ML_M4_4XLARGE_FOR_ENDPOINT_USAGE"
    LONGEST_RUN_TIME_FOR_A_TRAINING_JOB = "LONGEST_RUN_TIME_FOR_A_TRAINING_JOB"
    ML_R5D_16XLARGE_FOR_ENDPOINT_USAGE = "ML_R5D_16XLARGE_FOR_ENDPOINT_USAGE"
    ML_M4_2XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE = "ML_M4_2XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE"
    STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_TRN1N_32XLARGE_INSTANCES = "STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_TRN1N_32XLARGE_INSTANCES"
    STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_T3_XLARGE_INSTANCE = "STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_T3_XLARGE_INSTANCE"
    ML_M5_LARGE_FOR_TRANSFORM_JOB_USAGE = "ML_M5_LARGE_FOR_TRANSFORM_JOB_USAGE"
    ML_M4_10XLARGE_FOR_TRAINING_JOB_USAGE = "ML_M4_10XLARGE_FOR_TRAINING_JOB_USAGE"
    ML_M5D_2XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE = "ML_M5D_2XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE"
    ML_G4DN_2XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE = "ML_G4DN_2XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE"
    ML_C5N_4XLARGE_FOR_CLUSTER_USAGE = "ML_C5N_4XLARGE_FOR_CLUSTER_USAGE"
    ML_G5_24XLARGE_FOR_SPOT_TRAINING_JOB_USAGE = "ML_G5_24XLARGE_FOR_SPOT_TRAINING_JOB_USAGE"
    ML_G5_12XLARGE_FOR_ENDPOINT_USAGE = "ML_G5_12XLARGE_FOR_ENDPOINT_USAGE"
    ML_C5_18XLARGE_FOR_TRAINING_WARM_POOL_USAGE = "ML_C5_18XLARGE_FOR_TRAINING_WARM_POOL_USAGE"
    ML_G5_12XLARGE_FOR_CLUSTER_USAGE = "ML_G5_12XLARGE_FOR_CLUSTER_USAGE"
    R_SESSION_GATEWAY_APPS_RUNNING_ON_ML_M5D_XLARGE_INSTANCE = "R_SESSION_GATEWAY_APPS_RUNNING_ON_ML_M5D_XLARGE_INSTANCE"
    TOTAL_DOMAINS = "TOTAL_DOMAINS"
    ML_P3_8XLARGE_FOR_TRAINING_JOB_USAGE = "ML_P3_8XLARGE_FOR_TRAINING_JOB_USAGE"
    ML_C5N_18XLARGE_FOR_CLUSTER_USAGE = "ML_C5N_18XLARGE_FOR_CLUSTER_USAGE"
    ML_M5_LARGE_FOR_TRAINING_JOB_USAGE = "ML_M5_LARGE_FOR_TRAINING_JOB_USAGE"
    ML_G4DN_XLARGE_FOR_TRAINING_JOB_USAGE = "ML_G4DN_XLARGE_FOR_TRAINING_JOB_USAGE"
    ML_C4_XLARGE_FOR_TRANSFORM_JOB_USAGE = "ML_C4_XLARGE_FOR_TRANSFORM_JOB_USAGE"
    R_SESSION_GATEWAY_APPS_RUNNING_ON_ML_M5_24XLARGE_INSTANCE = "R_SESSION_GATEWAY_APPS_RUNNING_ON_ML_M5_24XLARGE_INSTANCE"
    ML_G5_4XLARGE_FOR_TRAINING_WARM_POOL_USAGE = "ML_G5_4XLARGE_FOR_TRAINING_WARM_POOL_USAGE"
    ML_M6GD_LARGE_FOR_ENDPOINT_USAGE = "ML_M6GD_LARGE_FOR_ENDPOINT_USAGE"
    ML_P2_XLARGE_FOR_ENDPOINT_USAGE = "ML_P2_XLARGE_FOR_ENDPOINT_USAGE"
    ML_M6I_16XLARGE_FOR_SPOT_TRAINING_JOB_USAGE = "ML_M6I_16XLARGE_FOR_SPOT_TRAINING_JOB_USAGE"
    STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_C5_9XLARGE_INSTANCE = "STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_C5_9XLARGE_INSTANCE"
    ML_M4_10XLARGE_FOR_SPOT_TRAINING_JOB_USAGE = "ML_M4_10XLARGE_FOR_SPOT_TRAINING_JOB_USAGE"
    ML_R6G_16XLARGE_FOR_ENDPOINT_USAGE = "ML_R6G_16XLARGE_FOR_ENDPOINT_USAGE"
    STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_G4DN_XLARGE_INSTANCES = "STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_G4DN_XLARGE_INSTANCES"
    STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_C5_2XLARGE_INSTANCES = "STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_C5_2XLARGE_INSTANCES"
    RATE_OF_UPDATE_NOTEBOOK_INSTANCE_LIFECYCLE_CONFIG_REQUESTS = "RATE_OF_UPDATE_NOTEBOOK_INSTANCE_LIFECYCLE_CONFIG_REQUESTS"
    ML_INF1_24XLARGE_FOR_ENDPOINT_USAGE = "ML_INF1_24XLARGE_FOR_ENDPOINT_USAGE"
    ML_C5_18XLARGE_FOR_SPOT_TRAINING_JOB_USAGE = "ML_C5_18XLARGE_FOR_SPOT_TRAINING_JOB_USAGE"
    STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_P3_16XLARGE_INSTANCE = "STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_P3_16XLARGE_INSTANCE"
    ML_M5_4XLARGE_FOR_TRAINING_WARM_POOL_USAGE = "ML_M5_4XLARGE_FOR_TRAINING_WARM_POOL_USAGE"
    ML_M4_16XLARGE_FOR_SPOT_TRAINING_JOB_USAGE = "ML_M4_16XLARGE_FOR_SPOT_TRAINING_JOB_USAGE"
    ML_M5_2XLARGE_FOR_TRANSFORM_JOB_USAGE = "ML_M5_2XLARGE_FOR_TRANSFORM_JOB_USAGE"
    ML_C5_9XLARGE_FOR_TRAINING_WARM_POOL_USAGE = "ML_C5_9XLARGE_FOR_TRAINING_WARM_POOL_USAGE"
    ML_C4_XLARGE_FOR_TRAINING_WARM_POOL_USAGE = "ML_C4_XLARGE_FOR_TRAINING_WARM_POOL_USAGE"
    TOTAL_NUMBER_OF_INSTANCES_ALLOWED_ACROSS_SAGE_MAKER_HYPER_POD_CLUSTERS = "TOTAL_NUMBER_OF_INSTANCES_ALLOWED_ACROSS_SAGE_MAKER_HYPER_POD_CLUSTERS"
    ML_C5_18XLARGE_FOR_TRAINING_JOB_USAGE = "ML_C5_18XLARGE_FOR_TRAINING_JOB_USAGE"
    ML_M5_4XLARGE_FOR_TRAINING_JOB_USAGE = "ML_M5_4XLARGE_FOR_TRAINING_JOB_USAGE"
    ML_M5N_16XLARGE_FOR_ENDPOINT_USAGE = "ML_M5N_16XLARGE_FOR_ENDPOINT_USAGE"
    STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_G4DN_16XLARGE_INSTANCES = "STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_G4DN_16XLARGE_INSTANCES"
    ML_R5DN_16XLARGE_FOR_ENDPOINT_USAGE = "ML_R5DN_16XLARGE_FOR_ENDPOINT_USAGE"
    STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_TRN1_32XLARGE_INSTANCES = "STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_TRN1_32XLARGE_INSTANCES"
    TOTAL_NUMBER_OF_EXPERIMENTS_ALLOWED_EXCLUDING_THOSE_AUTOMATICALLY_CREATED_BY_SAGE_MAKER = "TOTAL_NUMBER_OF_EXPERIMENTS_ALLOWED_EXCLUDING_THOSE_AUTOMATICALLY_CREATED_BY_SAGE_MAKER"
    ML_M7I_48XLARGE_FOR_ENDPOINT_USAGE = "ML_M7I_48XLARGE_FOR_ENDPOINT_USAGE"
    ML_C6G_16XLARGE_FOR_ENDPOINT_USAGE = "ML_C6G_16XLARGE_FOR_ENDPOINT_USAGE"
    ML_G4DN_4XLARGE_FOR_CLUSTER_USAGE = "ML_G4DN_4XLARGE_FOR_CLUSTER_USAGE"
    STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_T3_XLARGE_INSTANCES = "STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_T3_XLARGE_INSTANCES"
    STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_T3_LARGE_INSTANCE = "STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_T3_LARGE_INSTANCE"
    STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_G5_4XLARGE_INSTANCE = "STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_G5_4XLARGE_INSTANCE"
    ML_G4DN_4XLARGE_FOR_PROCESSING_JOB_USAGE = "ML_G4DN_4XLARGE_FOR_PROCESSING_JOB_USAGE"
    ML_P3_8XLARGE_FOR_TRANSFORM_JOB_USAGE = "ML_P3_8XLARGE_FOR_TRANSFORM_JOB_USAGE"
    ML_C5_4XLARGE_FOR_TRANSFORM_JOB_USAGE = "ML_C5_4XLARGE_FOR_TRANSFORM_JOB_USAGE"
    ML_P2_16XLARGE_FOR_TRAINING_WARM_POOL_USAGE = "ML_P2_16XLARGE_FOR_TRAINING_WARM_POOL_USAGE"
    ML_T2_MEDIUM_FOR_NOTEBOOK_INSTANCE_USAGE = "ML_T2_MEDIUM_FOR_NOTEBOOK_INSTANCE_USAGE"
    STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_G4DN_XLARGE_INSTANCES = "STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_G4DN_XLARGE_INSTANCES"
    MAXIMUM_NUMBER_OF_DATASET_OBJECTS_PER_LABELING_JOB = "MAXIMUM_NUMBER_OF_DATASET_OBJECTS_PER_LABELING_JOB"
    R_SESSION_GATEWAY_APPS_RUNNING_ON_ML_C5_LARGE_INSTANCE = "R_SESSION_GATEWAY_APPS_RUNNING_ON_ML_C5_LARGE_INSTANCE"
    ML_R6GD_8XLARGE_FOR_ENDPOINT_USAGE = "ML_R6GD_8XLARGE_FOR_ENDPOINT_USAGE"
    R_SESSION_GATEWAY_APPS_RUNNING_ON_ML_T3_2XLARGE_INSTANCE = "R_SESSION_GATEWAY_APPS_RUNNING_ON_ML_T3_2XLARGE_INSTANCE"
    ML_C5_XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE = "ML_C5_XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE"
    STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_P4DE_24XLARGE_INSTANCES = "STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_P4DE_24XLARGE_INSTANCES"
    R_SESSION_GATEWAY_APPS_RUNNING_ON_ML_G4DN_XLARGE_INSTANCE = "R_SESSION_GATEWAY_APPS_RUNNING_ON_ML_G4DN_XLARGE_INSTANCE"
    STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_P4DE_24XLARGE_INSTANCES = "STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_P4DE_24XLARGE_INSTANCES"
    ML_C4_8XLARGE_FOR_PROCESSING_JOB_USAGE = "ML_C4_8XLARGE_FOR_PROCESSING_JOB_USAGE"
    RATE_OF_START_NOTEBOOK_INSTANCE_REQUESTS = "RATE_OF_START_NOTEBOOK_INSTANCE_REQUESTS"
    STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_G5_8XLARGE_INSTANCE = "STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_G5_8XLARGE_INSTANCE"
    ML_M6G_XLARGE_FOR_ENDPOINT_USAGE = "ML_M6G_XLARGE_FOR_ENDPOINT_USAGE"
    ML_P3_8XLARGE_FOR_TRAINING_WARM_POOL_USAGE = "ML_P3_8XLARGE_FOR_TRAINING_WARM_POOL_USAGE"
    ML_R7I_16XLARGE_FOR_ENDPOINT_USAGE = "ML_R7I_16XLARGE_FOR_ENDPOINT_USAGE"
    ML_P3_16XLARGE_FOR_TRANSFORM_JOB_USAGE = "ML_P3_16XLARGE_FOR_TRANSFORM_JOB_USAGE"
    ML_C4_4XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE = "ML_C4_4XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE"
    ML_G4DN_16XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE = "ML_G4DN_16XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE"
    MAXIMUM_DATASET_SIZE_AUTO_ML_JOB_CAN_BE_RUN_ON = "MAXIMUM_DATASET_SIZE_AUTO_ML_JOB_CAN_BE_RUN_ON"
    STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_P4D_24XLARGE_INSTANCES = "STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_P4D_24XLARGE_INSTANCES"
    ML_G4DN_2XLARGE_FOR_TRANSFORM_JOB_USAGE = "ML_G4DN_2XLARGE_FOR_TRANSFORM_JOB_USAGE"
    STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_T3_MEDIUM_INSTANCES = "STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_T3_MEDIUM_INSTANCES"
    R_SESSION_GATEWAY_APPS_RUNNING_ON_ML_M5_8XLARGE_INSTANCE = "R_SESSION_GATEWAY_APPS_RUNNING_ON_ML_M5_8XLARGE_INSTANCE"
    ML_M5D_4XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE = "ML_M5D_4XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE"
    R_SESSION_GATEWAY_APPS_RUNNING_ON_ML_R5_8XLARGE_INSTANCE = "R_SESSION_GATEWAY_APPS_RUNNING_ON_ML_R5_8XLARGE_INSTANCE"
    ML_G4DN_XLARGE_FOR_PROCESSING_JOB_USAGE = "ML_G4DN_XLARGE_FOR_PROCESSING_JOB_USAGE"
    RATE_OF_INVOKE_ENDPOINT_REQUESTS = "RATE_OF_INVOKE_ENDPOINT_REQUESTS"
    ML_C5N_18XLARGE_FOR_TRAINING_WARM_POOL_USAGE = "ML_C5N_18XLARGE_FOR_TRAINING_WARM_POOL_USAGE"
    STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_M5D_LARGE_INSTANCES = "STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_M5D_LARGE_INSTANCES"
    ML_TRN1N_32XLARGE_FOR_SPOT_TRAINING_JOB_USAGE = "ML_TRN1N_32XLARGE_FOR_SPOT_TRAINING_JOB_USAGE"
    STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_G5_16XLARGE_INSTANCES = "STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_G5_16XLARGE_INSTANCES"
    ML_C5_4XLARGE_FOR_SPOT_TRAINING_JOB_USAGE = "ML_C5_4XLARGE_FOR_SPOT_TRAINING_JOB_USAGE"
    STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_M5D_LARGE_INSTANCES = "STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_M5D_LARGE_INSTANCES"
    ML_C5D_18XLARGE_FOR_ENDPOINT_USAGE = "ML_C5D_18XLARGE_FOR_ENDPOINT_USAGE"
    ML_P2_XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE = "ML_P2_XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE"
    MAXIMUM_NUMBER_OF_TRAINING_JOBS_THAT_EACH_HYPERPARAMETER_TUNING_JOB_CAN_CREATE = "MAXIMUM_NUMBER_OF_TRAINING_JOBS_THAT_EACH_HYPERPARAMETER_TUNING_JOB_CAN_CREATE"
    ML_G5_16XLARGE_FOR_ENDPOINT_USAGE = "ML_G5_16XLARGE_FOR_ENDPOINT_USAGE"
    STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_M5_XLARGE_INSTANCES = "STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_M5_XLARGE_INSTANCES"
    ML_G4DN_12XLARGE_FOR_TRAINING_JOB_USAGE = "ML_G4DN_12XLARGE_FOR_TRAINING_JOB_USAGE"
    ML_M5D_24XLARGE_FOR_ENDPOINT_USAGE = "ML_M5D_24XLARGE_FOR_ENDPOINT_USAGE"
    ML_R7I_48XLARGE_FOR_ENDPOINT_USAGE = "ML_R7I_48XLARGE_FOR_ENDPOINT_USAGE"
    ML_TRN1_32XLARGE_FOR_ENDPOINT_USAGE = "ML_TRN1_32XLARGE_FOR_ENDPOINT_USAGE"
    ML_R5DN_XLARGE_FOR_ENDPOINT_USAGE = "ML_R5DN_XLARGE_FOR_ENDPOINT_USAGE"
    ML_R5_XLARGE_FOR_PROCESSING_JOB_USAGE = "ML_R5_XLARGE_FOR_PROCESSING_JOB_USAGE"
    ML_G5_48XLARGE_FOR_TRAINING_JOB_USAGE = "ML_G5_48XLARGE_FOR_TRAINING_JOB_USAGE"
    STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_P4D_24XLARGE_INSTANCES = "STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_P4D_24XLARGE_INSTANCES"
    ML_C5N_9XLARGE_FOR_CLUSTER_USAGE = "ML_C5N_9XLARGE_FOR_CLUSTER_USAGE"
    ML_C6I_LARGE_FOR_ENDPOINT_USAGE = "ML_C6I_LARGE_FOR_ENDPOINT_USAGE"
    ML_P3_16XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE = "ML_P3_16XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE"
    ML_R5N_8XLARGE_FOR_ENDPOINT_USAGE = "ML_R5N_8XLARGE_FOR_ENDPOINT_USAGE"
    ML_EIA2_XLARGE_FOR_ENDPOINT_USAGE = "ML_EIA2_XLARGE_FOR_ENDPOINT_USAGE"
    ML_R5N_2XLARGE_FOR_ENDPOINT_USAGE = "ML_R5N_2XLARGE_FOR_ENDPOINT_USAGE"
    ML_M6I_LARGE_FOR_TRAINING_JOB_USAGE = "ML_M6I_LARGE_FOR_TRAINING_JOB_USAGE"
    ML_M5_4XLARGE_FOR_PROCESSING_JOB_USAGE = "ML_M5_4XLARGE_FOR_PROCESSING_JOB_USAGE"
    STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_C5_LARGE_INSTANCE = "STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_C5_LARGE_INSTANCE"
    CANVAS_APPS_RUNNING_ON_ML_M5_4XLARGE_INSTANCES = "CANVAS_APPS_RUNNING_ON_ML_M5_4XLARGE_INSTANCES"
    STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_C5_4XLARGE_INSTANCES = "STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_C5_4XLARGE_INSTANCES"
    MAXIMUM_NUMBER_OF_RUNNING_STUDIO_APPS_ALLOWED_PER_ACCOUNT = "MAXIMUM_NUMBER_OF_RUNNING_STUDIO_APPS_ALLOWED_PER_ACCOUNT"
    R_SESSION_GATEWAY_APPS_RUNNING_ON_ML_C5_4XLARGE_INSTANCE = "R_SESSION_GATEWAY_APPS_RUNNING_ON_ML_C5_4XLARGE_INSTANCE"
    ML_M5_12XLARGE_FOR_ENDPOINT_USAGE = "ML_M5_12XLARGE_FOR_ENDPOINT_USAGE"
    ML_M5D_8XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE = "ML_M5D_8XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE"
    ML_C6I_4XLARGE_FOR_TRAINING_JOB_USAGE = "ML_C6I_4XLARGE_FOR_TRAINING_JOB_USAGE"
    STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_G4DN_12XLARGE_INSTANCES = "STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_G4DN_12XLARGE_INSTANCES"
    ML_M5_2XLARGE_FOR_TRAINING_JOB_USAGE = "ML_M5_2XLARGE_FOR_TRAINING_JOB_USAGE"
    ML_P2_XLARGE_FOR_SPOT_TRAINING_JOB_USAGE = "ML_P2_XLARGE_FOR_SPOT_TRAINING_JOB_USAGE"
    NUMBER_OF_INSTANCES_ACROSS_ALL_TRANSFORM_JOBS = "NUMBER_OF_INSTANCES_ACROSS_ALL_TRANSFORM_JOBS"
    R_SESSION_GATEWAY_APPS_RUNNING_ON_ML_R5_XLARGE_INSTANCE = "R_SESSION_GATEWAY_APPS_RUNNING_ON_ML_R5_XLARGE_INSTANCE"
    ML_C5_XLARGE_FOR_ENDPOINT_USAGE = "ML_C5_XLARGE_FOR_ENDPOINT_USAGE"
    ML_M4_16XLARGE_FOR_ENDPOINT_USAGE = "ML_M4_16XLARGE_FOR_ENDPOINT_USAGE"
    ML_C4_2XLARGE_FOR_SPOT_TRAINING_JOB_USAGE = "ML_C4_2XLARGE_FOR_SPOT_TRAINING_JOB_USAGE"
    ML_G5_12XLARGE_FOR_TRAINING_WARM_POOL_USAGE = "ML_G5_12XLARGE_FOR_TRAINING_WARM_POOL_USAGE"
    ML_C5N_4XLARGE_FOR_ENDPOINT_USAGE = "ML_C5N_4XLARGE_FOR_ENDPOINT_USAGE"
    RATE_OF_DELETE_STUDIO_LIFECYCLE_CONFIG_REQUESTS = "RATE_OF_DELETE_STUDIO_LIFECYCLE_CONFIG_REQUESTS"
    ML_G4DN_16XLARGE_FOR_SPOT_TRAINING_JOB_USAGE = "ML_G4DN_16XLARGE_FOR_SPOT_TRAINING_JOB_USAGE"
    STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_R5_12XLARGE_INSTANCES = "STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_R5_12XLARGE_INSTANCES"
    ML_M6I_24XLARGE_FOR_TRAINING_JOB_USAGE = "ML_M6I_24XLARGE_FOR_TRAINING_JOB_USAGE"
    R_SESSION_GATEWAY_APPS_RUNNING_ON_ML_M5_XLARGE_INSTANCE = "R_SESSION_GATEWAY_APPS_RUNNING_ON_ML_M5_XLARGE_INSTANCE"
    ML_M5_XLARGE_FOR_CLUSTER_USAGE = "ML_M5_XLARGE_FOR_CLUSTER_USAGE"
    RATE_OF_UPDATE_TRAINING_JOB_REQUESTS = "RATE_OF_UPDATE_TRAINING_JOB_REQUESTS"
    ML_T3_MEDIUM_FOR_PROCESSING_JOB_USAGE = "ML_T3_MEDIUM_FOR_PROCESSING_JOB_USAGE"
    ML_M5_XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE = "ML_M5_XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE"
    ML_M7I_2XLARGE_FOR_ENDPOINT_USAGE = "ML_M7I_2XLARGE_FOR_ENDPOINT_USAGE"
    SIZE_OF_EBS_VOLUME_FOR_A_TRANSFORM_JOB_INSTANCE = "SIZE_OF_EBS_VOLUME_FOR_A_TRANSFORM_JOB_INSTANCE"
    ML_M5_LARGE_FOR_ENDPOINT_USAGE = "ML_M5_LARGE_FOR_ENDPOINT_USAGE"
    R_SESSION_GATEWAY_APPS_RUNNING_ON_ML_G4DN_8XLARGE_INSTANCE = "R_SESSION_GATEWAY_APPS_RUNNING_ON_ML_G4DN_8XLARGE_INSTANCE"
    ML_M5_12XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE = "ML_M5_12XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE"
    STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_M5_8XLARGE_INSTANCE = "STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_M5_8XLARGE_INSTANCE"
    ML_M6I_8XLARGE_FOR_TRAINING_JOB_USAGE = "ML_M6I_8XLARGE_FOR_TRAINING_JOB_USAGE"
    ML_R5_LARGE_FOR_ENDPOINT_USAGE = "ML_R5_LARGE_FOR_ENDPOINT_USAGE"
    STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_G4DN_12XLARGE_INSTANCE = "STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_G4DN_12XLARGE_INSTANCE"
    STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_C5_12XLARGE_INSTANCE = "STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_C5_12XLARGE_INSTANCE"
    ML_C5_18XLARGE_FOR_PROCESSING_JOB_USAGE = "ML_C5_18XLARGE_FOR_PROCESSING_JOB_USAGE"
    ML_R7I_8XLARGE_FOR_ENDPOINT_USAGE = "ML_R7I_8XLARGE_FOR_ENDPOINT_USAGE"
    SIZE_OF_EBS_VOLUME_FOR_A_PROCESSING_JOB_INSTANCE = "SIZE_OF_EBS_VOLUME_FOR_A_PROCESSING_JOB_INSTANCE"
    STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_M5D_12XLARGE_INSTANCES = "STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_M5D_12XLARGE_INSTANCES"
    STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_M5D_4XLARGE_INSTANCES = "STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_M5D_4XLARGE_INSTANCES"
    ML_C6I_12XLARGE_FOR_ENDPOINT_USAGE = "ML_C6I_12XLARGE_FOR_ENDPOINT_USAGE"
    STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_M5D_2XLARGE_INSTANCES = "STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_M5D_2XLARGE_INSTANCES"
    ML_TRN1N_32XLARGE_FOR_TRAINING_WARM_POOL_USAGE = "ML_TRN1N_32XLARGE_FOR_TRAINING_WARM_POOL_USAGE"
    ML_G5_24XLARGE_FOR_TRAINING_JOB_USAGE = "ML_G5_24XLARGE_FOR_TRAINING_JOB_USAGE"
    ML_C4_XLARGE_FOR_ENDPOINT_USAGE = "ML_C4_XLARGE_FOR_ENDPOINT_USAGE"
    RATE_OF_DESCRIBE_ENDPOINT_REQUESTS = "RATE_OF_DESCRIBE_ENDPOINT_REQUESTS"
    ML_G5_24XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE = "ML_G5_24XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE"
    ML_C4_4XLARGE_FOR_PROCESSING_JOB_USAGE = "ML_C4_4XLARGE_FOR_PROCESSING_JOB_USAGE"
    ML_T3_XLARGE_FOR_CLUSTER_USAGE = "ML_T3_XLARGE_FOR_CLUSTER_USAGE"
    ML_C5_9XLARGE_FOR_CLUSTER_USAGE = "ML_C5_9XLARGE_FOR_CLUSTER_USAGE"
    ML_P3_2XLARGE_FOR_TRANSFORM_JOB_USAGE = "ML_P3_2XLARGE_FOR_TRANSFORM_JOB_USAGE"
    ML_R5D_4XLARGE_FOR_ENDPOINT_USAGE = "ML_R5D_4XLARGE_FOR_ENDPOINT_USAGE"
    ML_R5_LARGE_FOR_NOTEBOOK_INSTANCE_USAGE = "ML_R5_LARGE_FOR_NOTEBOOK_INSTANCE_USAGE"
    STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_T3_MEDIUM_INSTANCE = "STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_T3_MEDIUM_INSTANCE"
    ML_M5D_16XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE = "ML_M5D_16XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE"
    R_SESSION_GATEWAY_APPS_RUNNING_ON_ML_P3_16XLARGE_INSTANCE = "R_SESSION_GATEWAY_APPS_RUNNING_ON_ML_P3_16XLARGE_INSTANCE"
    ML_G5_4XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE = "ML_G5_4XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE"
    ML_P4D_24XLARGE_FOR_ENDPOINT_USAGE = "ML_P4D_24XLARGE_FOR_ENDPOINT_USAGE"
    ML_C5D_9XLARGE_FOR_ENDPOINT_USAGE = "ML_C5D_9XLARGE_FOR_ENDPOINT_USAGE"
    STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_M5D_24XLARGE_INSTANCE = "STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_M5D_24XLARGE_INSTANCE"
    MAXIMUM_NUMBER_OF_CONCURRENT_AUTO_ML_JOBS = "MAXIMUM_NUMBER_OF_CONCURRENT_AUTO_ML_JOBS"
    ML_G4DN_8XLARGE_FOR_TRANSFORM_JOB_USAGE = "ML_G4DN_8XLARGE_FOR_TRANSFORM_JOB_USAGE"
    MAXIMUM_NUMBER_OF_STUDIO_USER_PROFILES_ALLOWED_PER_ACCOUNT = "MAXIMUM_NUMBER_OF_STUDIO_USER_PROFILES_ALLOWED_PER_ACCOUNT"
    ML_M5_12XLARGE_FOR_SPOT_TRAINING_JOB_USAGE = "ML_M5_12XLARGE_FOR_SPOT_TRAINING_JOB_USAGE"
    ML_C7G_LARGE_FOR_ENDPOINT_USAGE = "ML_C7G_LARGE_FOR_ENDPOINT_USAGE"
    ML_P2_8XLARGE_FOR_TRAINING_WARM_POOL_USAGE = "ML_P2_8XLARGE_FOR_TRAINING_WARM_POOL_USAGE"
    ML_M5_2XLARGE_FOR_CLUSTER_USAGE = "ML_M5_2XLARGE_FOR_CLUSTER_USAGE"
    ML_C5N_18XLARGE_FOR_TRAINING_JOB_USAGE = "ML_C5N_18XLARGE_FOR_TRAINING_JOB_USAGE"
    STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_M5D_16XLARGE_INSTANCES = "STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_M5D_16XLARGE_INSTANCES"
    ML_C6I_24XLARGE_FOR_ENDPOINT_USAGE = "ML_C6I_24XLARGE_FOR_ENDPOINT_USAGE"
    ML_G5_XLARGE_FOR_CLUSTER_USAGE = "ML_G5_XLARGE_FOR_CLUSTER_USAGE"
    ML_T3_XLARGE_FOR_PROCESSING_JOB_USAGE = "ML_T3_XLARGE_FOR_PROCESSING_JOB_USAGE"
    ML_C5_XLARGE_FOR_CLUSTER_USAGE = "ML_C5_XLARGE_FOR_CLUSTER_USAGE"
    ML_R7I_4XLARGE_FOR_ENDPOINT_USAGE = "ML_R7I_4XLARGE_FOR_ENDPOINT_USAGE"
    ML_C6I_16XLARGE_FOR_SPOT_TRAINING_JOB_USAGE = "ML_C6I_16XLARGE_FOR_SPOT_TRAINING_JOB_USAGE"
    ML_R5N_24XLARGE_FOR_ENDPOINT_USAGE = "ML_R5N_24XLARGE_FOR_ENDPOINT_USAGE"
    ML_G5_2XLARGE_FOR_ENDPOINT_USAGE = "ML_G5_2XLARGE_FOR_ENDPOINT_USAGE"
    ML_P3_16XLARGE_FOR_PROCESSING_JOB_USAGE = "ML_P3_16XLARGE_FOR_PROCESSING_JOB_USAGE"
    ML_T2_2XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE = "ML_T2_2XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE"
    MAXIMUM_NUMBER_OF_GROUND_TRUTH_LABELING_JOBS = "MAXIMUM_NUMBER_OF_GROUND_TRUTH_LABELING_JOBS"
    ML_R6GD_16XLARGE_FOR_ENDPOINT_USAGE = "ML_R6GD_16XLARGE_FOR_ENDPOINT_USAGE"
    ML_INF2_8XLARGE_FOR_ENDPOINT_USAGE = "ML_INF2_8XLARGE_FOR_ENDPOINT_USAGE"
    STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_R5_4XLARGE_INSTANCE = "STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_R5_4XLARGE_INSTANCE"
    ML_R5_LARGE_FOR_PROCESSING_JOB_USAGE = "ML_R5_LARGE_FOR_PROCESSING_JOB_USAGE"
    STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_C5_12XLARGE_INSTANCES = "STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_C5_12XLARGE_INSTANCES"
    MAXIMUM_NUMBER_OF_DEVICE_FLEETS = "MAXIMUM_NUMBER_OF_DEVICE_FLEETS"
    ML_C6I_XLARGE_FOR_TRAINING_JOB_USAGE = "ML_C6I_XLARGE_FOR_TRAINING_JOB_USAGE"
    ML_C7I_4XLARGE_FOR_ENDPOINT_USAGE = "ML_C7I_4XLARGE_FOR_ENDPOINT_USAGE"
    RATE_OF_CREATE_ENDPOINT_REQUESTS = "RATE_OF_CREATE_ENDPOINT_REQUESTS"
    ML_P3_16XLARGE_FOR_TRAINING_JOB_USAGE = "ML_P3_16XLARGE_FOR_TRAINING_JOB_USAGE"
    ML_G5_8XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE = "ML_G5_8XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE"
    TOTAL_NUMBER_OF_TRIALS_ALLOWED_IN_A_SINGLE_EXPERIMENT_EXCLUDING_THOSE_AUTOMATICALLY_CREATED_BY_SAGE_MAKER = "TOTAL_NUMBER_OF_TRIALS_ALLOWED_IN_A_SINGLE_EXPERIMENT_EXCLUDING_THOSE_AUTOMATICALLY_CREATED_BY_SAGE_MAKER"
    ML_R5_4XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE = "ML_R5_4XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE"
    RATE_OF_LIST_MODELS_REQUESTS = "RATE_OF_LIST_MODELS_REQUESTS"
    ML_G4DN_12XLARGE_FOR_TRAINING_WARM_POOL_USAGE = "ML_G4DN_12XLARGE_FOR_TRAINING_WARM_POOL_USAGE"
    STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_T3_MEDIUM_INSTANCES = "STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_T3_MEDIUM_INSTANCES"
    ML_C4_2XLARGE_FOR_TRAINING_WARM_POOL_USAGE = "ML_C4_2XLARGE_FOR_TRAINING_WARM_POOL_USAGE"
    ML_M4_16XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE = "ML_M4_16XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE"
    ML_M4_2XLARGE_FOR_PROCESSING_JOB_USAGE = "ML_M4_2XLARGE_FOR_PROCESSING_JOB_USAGE"
    ML_C5_4XLARGE_FOR_TRAINING_JOB_USAGE = "ML_C5_4XLARGE_FOR_TRAINING_JOB_USAGE"
    ML_C5_2XLARGE_FOR_TRANSFORM_JOB_USAGE = "ML_C5_2XLARGE_FOR_TRANSFORM_JOB_USAGE"
    ML_M6I_2XLARGE_FOR_SPOT_TRAINING_JOB_USAGE = "ML_M6I_2XLARGE_FOR_SPOT_TRAINING_JOB_USAGE"
    TOTAL_NUMBER_OF_TRIAL_COMPONENTS_ALLOWED_IN_A_SINGLE_TRIAL_EXCLUDING_THOSE_AUTOMATICALLY_CREATED_BY_SAGE_MAKER = "TOTAL_NUMBER_OF_TRIAL_COMPONENTS_ALLOWED_IN_A_SINGLE_TRIAL_EXCLUDING_THOSE_AUTOMATICALLY_CREATED_BY_SAGE_MAKER"
    ML_M5D_2XLARGE_FOR_ENDPOINT_USAGE = "ML_M5D_2XLARGE_FOR_ENDPOINT_USAGE"
    RATE_OF_DELETE_NOTEBOOK_INSTANCE_LIFECYCLE_CONFIG_REQUESTS = "RATE_OF_DELETE_NOTEBOOK_INSTANCE_LIFECYCLE_CONFIG_REQUESTS"
    ML_M5_24XLARGE_FOR_PROCESSING_JOB_USAGE = "ML_M5_24XLARGE_FOR_PROCESSING_JOB_USAGE"
    ML_G4DN_16XLARGE_FOR_TRAINING_WARM_POOL_USAGE = "ML_G4DN_16XLARGE_FOR_TRAINING_WARM_POOL_USAGE"
    ML_C6GN_16XLARGE_FOR_ENDPOINT_USAGE = "ML_C6GN_16XLARGE_FOR_ENDPOINT_USAGE"
    ML_C5N_2XLARGE_FOR_TRAINING_WARM_POOL_USAGE = "ML_C5N_2XLARGE_FOR_TRAINING_WARM_POOL_USAGE"
    ML_M7I_16XLARGE_FOR_ENDPOINT_USAGE = "ML_M7I_16XLARGE_FOR_ENDPOINT_USAGE"
    ML_M6I_2XLARGE_FOR_TRAINING_JOB_USAGE = "ML_M6I_2XLARGE_FOR_TRAINING_JOB_USAGE"
    ML_M4_2XLARGE_FOR_TRAINING_WARM_POOL_USAGE = "ML_M4_2XLARGE_FOR_TRAINING_WARM_POOL_USAGE"
    ML_C4_4XLARGE_FOR_SPOT_TRAINING_JOB_USAGE = "ML_C4_4XLARGE_FOR_SPOT_TRAINING_JOB_USAGE"
    MAXIMUM_NUMBER_OF_SERVERLESS_ENDPOINTS = "MAXIMUM_NUMBER_OF_SERVERLESS_ENDPOINTS"
    STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_R5_16XLARGE_INSTANCE = "STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_R5_16XLARGE_INSTANCE"
    ML_C6GD_12XLARGE_FOR_ENDPOINT_USAGE = "ML_C6GD_12XLARGE_FOR_ENDPOINT_USAGE"
    ML_TRN1_32XLARGE_FOR_TRAINING_JOB_USAGE = "ML_TRN1_32XLARGE_FOR_TRAINING_JOB_USAGE"
    ML_C6I_XLARGE_FOR_SPOT_TRAINING_JOB_USAGE = "ML_C6I_XLARGE_FOR_SPOT_TRAINING_JOB_USAGE"
    ML_C6I_24XLARGE_FOR_SPOT_TRAINING_JOB_USAGE = "ML_C6I_24XLARGE_FOR_SPOT_TRAINING_JOB_USAGE"
    STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_M5_12XLARGE_INSTANCE = "STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_M5_12XLARGE_INSTANCE"
    ML_R5_16XLARGE_FOR_PROCESSING_JOB_USAGE = "ML_R5_16XLARGE_FOR_PROCESSING_JOB_USAGE"
    STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_C5_24XLARGE_INSTANCE = "STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_C5_24XLARGE_INSTANCE"
    ML_M5D_12XLARGE_FOR_ENDPOINT_USAGE = "ML_M5D_12XLARGE_FOR_ENDPOINT_USAGE"
    R_SESSION_GATEWAY_APPS_RUNNING_ON_ML_M5D_8XLARGE_INSTANCE = "R_SESSION_GATEWAY_APPS_RUNNING_ON_ML_M5D_8XLARGE_INSTANCE"
    ML_G5_4XLARGE_FOR_TRAINING_JOB_USAGE = "ML_G5_4XLARGE_FOR_TRAINING_JOB_USAGE"
    ML_C4_2XLARGE_FOR_PROCESSING_JOB_USAGE = "ML_C4_2XLARGE_FOR_PROCESSING_JOB_USAGE"
    RATE_OF_UPDATE_NOTEBOOK_INSTANCE_REQUESTS = "RATE_OF_UPDATE_NOTEBOOK_INSTANCE_REQUESTS"
    ML_R5D_LARGE_FOR_ENDPOINT_USAGE = "ML_R5D_LARGE_FOR_ENDPOINT_USAGE"
    STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_G5_24XLARGE_INSTANCE = "STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_G5_24XLARGE_INSTANCE"
    ML_M6I_4XLARGE_FOR_SPOT_TRAINING_JOB_USAGE = "ML_M6I_4XLARGE_FOR_SPOT_TRAINING_JOB_USAGE"
    ML_C5D_4XLARGE_FOR_ENDPOINT_USAGE = "ML_C5D_4XLARGE_FOR_ENDPOINT_USAGE"
    STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_M5D_16XLARGE_INSTANCES = "STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_M5D_16XLARGE_INSTANCES"
    NUMBER_OF_INSTANCES_ACROSS_ALL_TRAINING_JOBS = "NUMBER_OF_INSTANCES_ACROSS_ALL_TRAINING_JOBS"
    MAXIMUM_SUBSAMPLED_DATASET_SIZE_AUTO_ML_JOB_CAN_BE_RUN_ON = "MAXIMUM_SUBSAMPLED_DATASET_SIZE_AUTO_ML_JOB_CAN_BE_RUN_ON"
    TOTAL_NUMBER_OF_NOTEBOOK_INSTANCES = "TOTAL_NUMBER_OF_NOTEBOOK_INSTANCES"
    ML_T2_2XLARGE_FOR_ENDPOINT_USAGE = "ML_T2_2XLARGE_FOR_ENDPOINT_USAGE"
    STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_R5_LARGE_INSTANCES = "STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_R5_LARGE_INSTANCES"
    TENSOR_BOARD_APPS_RUNNING_ON_SYSTEM_INSTANCES = "TENSOR_BOARD_APPS_RUNNING_ON_SYSTEM_INSTANCES"
    MAXIMUM_NUMBER_OF_INSTANCES_PER_PROCESSING_JOB = "MAXIMUM_NUMBER_OF_INSTANCES_PER_PROCESSING_JOB"
    ML_C7G_XLARGE_FOR_ENDPOINT_USAGE = "ML_C7G_XLARGE_FOR_ENDPOINT_USAGE"
    STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_G5_8XLARGE_INSTANCES = "STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_G5_8XLARGE_INSTANCES"
    STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_T3_LARGE_INSTANCES = "STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_T3_LARGE_INSTANCES"
    ML_C6I_4XLARGE_FOR_ENDPOINT_USAGE = "ML_C6I_4XLARGE_FOR_ENDPOINT_USAGE"
    MAXIMUM_NUMBER_OF_PARALLEL_EDGE_DEPLOYMENTS = "MAXIMUM_NUMBER_OF_PARALLEL_EDGE_DEPLOYMENTS"
    ML_G4DN_2XLARGE_FOR_CLUSTER_USAGE = "ML_G4DN_2XLARGE_FOR_CLUSTER_USAGE"
    ML_M6G_4XLARGE_FOR_ENDPOINT_USAGE = "ML_M6G_4XLARGE_FOR_ENDPOINT_USAGE"
    NUMBER_OF_INSTANCES_ACROSS_ACTIVE_ENDPOINTS = "NUMBER_OF_INSTANCES_ACROSS_ACTIVE_ENDPOINTS"
    STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_C5_24XLARGE_INSTANCES = "STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_C5_24XLARGE_INSTANCES"
    ML_R5_8XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE = "ML_R5_8XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE"
    ML_C6GN_LARGE_FOR_ENDPOINT_USAGE = "ML_C6GN_LARGE_FOR_ENDPOINT_USAGE"
    ML_M5N_4XLARGE_FOR_ENDPOINT_USAGE = "ML_M5N_4XLARGE_FOR_ENDPOINT_USAGE"
    STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_M5_16XLARGE_INSTANCES = "STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_M5_16XLARGE_INSTANCES"
    ML_R6G_12XLARGE_FOR_ENDPOINT_USAGE = "ML_R6G_12XLARGE_FOR_ENDPOINT_USAGE"
    ML_G5_8XLARGE_FOR_TRAINING_WARM_POOL_USAGE = "ML_G5_8XLARGE_FOR_TRAINING_WARM_POOL_USAGE"
    ML_P3_8XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE = "ML_P3_8XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE"
    ML_R5D_2XLARGE_FOR_ENDPOINT_USAGE = "ML_R5D_2XLARGE_FOR_ENDPOINT_USAGE"
    STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_C5_9XLARGE_INSTANCES = "STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_C5_9XLARGE_INSTANCES"
    STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_R5_XLARGE_INSTANCE = "STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_R5_XLARGE_INSTANCE"
    ML_M4_10XLARGE_FOR_ENDPOINT_USAGE = "ML_M4_10XLARGE_FOR_ENDPOINT_USAGE"
    ML_G4DN_XLARGE_FOR_CLUSTER_USAGE = "ML_G4DN_XLARGE_FOR_CLUSTER_USAGE"
    ML_M4_10XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE = "ML_M4_10XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE"
    ML_M5D_XLARGE_FOR_ENDPOINT_USAGE = "ML_M5D_XLARGE_FOR_ENDPOINT_USAGE"
    MAXIMUM_TOTAL_CONCURRENCY_THAT_CAN_BE_ALLOCATED_ACROSS_ALL_SERVERLESS_ENDPOINTS = "MAXIMUM_TOTAL_CONCURRENCY_THAT_CAN_BE_ALLOCATED_ACROSS_ALL_SERVERLESS_ENDPOINTS"
    ML_G4DN_2XLARGE_FOR_TRAINING_JOB_USAGE = "ML_G4DN_2XLARGE_FOR_TRAINING_JOB_USAGE"
    ML_C7I_16XLARGE_FOR_ENDPOINT_USAGE = "ML_C7I_16XLARGE_FOR_ENDPOINT_USAGE"
    ML_C4_XLARGE_FOR_PROCESSING_JOB_USAGE = "ML_C4_XLARGE_FOR_PROCESSING_JOB_USAGE"
    ML_C6I_16XLARGE_FOR_TRAINING_JOB_USAGE = "ML_C6I_16XLARGE_FOR_TRAINING_JOB_USAGE"
    R_SESSION_GATEWAY_APPS_RUNNING_ON_ML_T3_SMALL_INSTANCE = "R_SESSION_GATEWAY_APPS_RUNNING_ON_ML_T3_SMALL_INSTANCE"
    ML_M7I_24XLARGE_FOR_ENDPOINT_USAGE = "ML_M7I_24XLARGE_FOR_ENDPOINT_USAGE"
    ML_P4D_24XLARGE_FOR_SPOT_TRAINING_JOB_USAGE = "ML_P4D_24XLARGE_FOR_SPOT_TRAINING_JOB_USAGE"
    ML_M6I_24XLARGE_FOR_SPOT_TRAINING_JOB_USAGE = "ML_M6I_24XLARGE_FOR_SPOT_TRAINING_JOB_USAGE"
    ML_R7I_2XLARGE_FOR_ENDPOINT_USAGE = "ML_R7I_2XLARGE_FOR_ENDPOINT_USAGE"
    RATE_OF_STOP_TRAINING_JOB_REQUESTS = "RATE_OF_STOP_TRAINING_JOB_REQUESTS"
    ML_M6I_8XLARGE_FOR_SPOT_TRAINING_JOB_USAGE = "ML_M6I_8XLARGE_FOR_SPOT_TRAINING_JOB_USAGE"
    ML_G5_4XLARGE_FOR_ENDPOINT_USAGE = "ML_G5_4XLARGE_FOR_ENDPOINT_USAGE"
    STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_C5_4XLARGE_INSTANCES = "STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_C5_4XLARGE_INSTANCES"
    ML_C4_4XLARGE_FOR_TRANSFORM_JOB_USAGE = "ML_C4_4XLARGE_FOR_TRANSFORM_JOB_USAGE"
    ML_M6I_32XLARGE_FOR_TRAINING_WARM_POOL_USAGE = "ML_M6I_32XLARGE_FOR_TRAINING_WARM_POOL_USAGE"
    STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_C5_2XLARGE_INSTANCES = "STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_C5_2XLARGE_INSTANCES"
    ML_M6G_2XLARGE_FOR_ENDPOINT_USAGE = "ML_M6G_2XLARGE_FOR_ENDPOINT_USAGE"
    ML_P5_48XLARGE_FOR_ENDPOINT_USAGE = "ML_P5_48XLARGE_FOR_ENDPOINT_USAGE"
    ML_C6G_LARGE_FOR_ENDPOINT_USAGE = "ML_C6G_LARGE_FOR_ENDPOINT_USAGE"
    ML_R5_8XLARGE_FOR_ENDPOINT_USAGE = "ML_R5_8XLARGE_FOR_ENDPOINT_USAGE"
    RATE_OF_DESCRIBE_TRAINING_JOB_REQUESTS = "RATE_OF_DESCRIBE_TRAINING_JOB_REQUESTS"
    STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_R5_24XLARGE_INSTANCES = "STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_R5_24XLARGE_INSTANCES"
    R_SESSION_GATEWAY_APPS_RUNNING_ON_ML_G4DN_16XLARGE_INSTANCE = "R_SESSION_GATEWAY_APPS_RUNNING_ON_ML_G4DN_16XLARGE_INSTANCE"
    STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_G5_XLARGE_INSTANCES = "STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_G5_XLARGE_INSTANCES"
    STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_G5_12XLARGE_INSTANCES = "STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_G5_12XLARGE_INSTANCES"
    ML_M6GD_2XLARGE_FOR_ENDPOINT_USAGE = "ML_M6GD_2XLARGE_FOR_ENDPOINT_USAGE"
    ML_P5_48XLARGE_FOR_TRAINING_WARM_POOL_USAGE = "ML_P5_48XLARGE_FOR_TRAINING_WARM_POOL_USAGE"
    R_SESSION_GATEWAY_APPS_RUNNING_ON_ML_M5D_LARGE_INSTANCE = "R_SESSION_GATEWAY_APPS_RUNNING_ON_ML_M5D_LARGE_INSTANCE"
    ML_M5_8XLARGE_FOR_ENDPOINT_USAGE = "ML_M5_8XLARGE_FOR_ENDPOINT_USAGE"
    STUDIO_JUPYTER_APPS_RUNNING_ON_SYSTEM_INSTANCES = "STUDIO_JUPYTER_APPS_RUNNING_ON_SYSTEM_INSTANCES"
    SIZE_OF_EBS_VOLUME_FOR_A_TRAINING_JOB_INSTANCE = "SIZE_OF_EBS_VOLUME_FOR_A_TRAINING_JOB_INSTANCE"
    STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_G4DN_XLARGE_INSTANCE = "STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_G4DN_XLARGE_INSTANCE"
    ML_P3_16XLARGE_FOR_TRAINING_WARM_POOL_USAGE = "ML_P3_16XLARGE_FOR_TRAINING_WARM_POOL_USAGE"
    NUMBER_OF_ELASTIC_INFERENCE_ACCELERATORS_ACROSS_ACTIVE_ENDPOINTS = "NUMBER_OF_ELASTIC_INFERENCE_ACCELERATORS_ACROSS_ACTIVE_ENDPOINTS"
    STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_G5_48XLARGE_INSTANCES = "STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_G5_48XLARGE_INSTANCES"
    ML_M5_4XLARGE_FOR_ENDPOINT_USAGE = "ML_M5_4XLARGE_FOR_ENDPOINT_USAGE"
    R_SESSION_GATEWAY_APPS_RUNNING_ON_ML_G4DN_4XLARGE_INSTANCE = "R_SESSION_GATEWAY_APPS_RUNNING_ON_ML_G4DN_4XLARGE_INSTANCE"
    ML_G4DN_4XLARGE_FOR_TRAINING_WARM_POOL_USAGE = "ML_G4DN_4XLARGE_FOR_TRAINING_WARM_POOL_USAGE"
    ML_C6GN_8XLARGE_FOR_ENDPOINT_USAGE = "ML_C6GN_8XLARGE_FOR_ENDPOINT_USAGE"
    STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_P3_2XLARGE_INSTANCES = "STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_P3_2XLARGE_INSTANCES"
    ML_C5_9XLARGE_FOR_TRANSFORM_JOB_USAGE = "ML_C5_9XLARGE_FOR_TRANSFORM_JOB_USAGE"
    ML_M5_24XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE = "ML_M5_24XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE"
    MAXIMUM_NUMBER_OF_MODEL_CARD_VERSIONS_ALLOWED_PER_ACCOUNT = "MAXIMUM_NUMBER_OF_MODEL_CARD_VERSIONS_ALLOWED_PER_ACCOUNT"
    ML_T3_MEDIUM_FOR_CLUSTER_USAGE = "ML_T3_MEDIUM_FOR_CLUSTER_USAGE"
    MAXIMUM_NUMBER_OF_A2_I_FLOW_DEFINITIONS = "MAXIMUM_NUMBER_OF_A2_I_FLOW_DEFINITIONS"
    ML_G4DN_16XLARGE_FOR_PROCESSING_JOB_USAGE = "ML_G4DN_16XLARGE_FOR_PROCESSING_JOB_USAGE"
    ML_G4DN_XLARGE_FOR_ENDPOINT_USAGE = "ML_G4DN_XLARGE_FOR_ENDPOINT_USAGE"
    ML_M4_2XLARGE_FOR_TRAINING_JOB_USAGE = "ML_M4_2XLARGE_FOR_TRAINING_JOB_USAGE"
    ML_TRN1_2XLARGE_FOR_TRAINING_JOB_USAGE = "ML_TRN1_2XLARGE_FOR_TRAINING_JOB_USAGE"
    R_SESSION_GATEWAY_APPS_RUNNING_ON_ML_M5_LARGE_INSTANCE = "R_SESSION_GATEWAY_APPS_RUNNING_ON_ML_M5_LARGE_INSTANCE"
    ML_M5_12XLARGE_FOR_TRAINING_JOB_USAGE = "ML_M5_12XLARGE_FOR_TRAINING_JOB_USAGE"
    ML_M5_XLARGE_FOR_SPOT_TRAINING_JOB_USAGE = "ML_M5_XLARGE_FOR_SPOT_TRAINING_JOB_USAGE"
    ML_M4_16XLARGE_FOR_TRAINING_JOB_USAGE = "ML_M4_16XLARGE_FOR_TRAINING_JOB_USAGE"
    MAXIMUM_NUMBER_OF_PARAMETERS_ALLOWED_PER_PIPELINE = "MAXIMUM_NUMBER_OF_PARAMETERS_ALLOWED_PER_PIPELINE"
    ML_M4_XLARGE_FOR_PROCESSING_JOB_USAGE = "ML_M4_XLARGE_FOR_PROCESSING_JOB_USAGE"
    ML_R5_XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE = "ML_R5_XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE"
    ML_G5_XLARGE_FOR_TRAINING_JOB_USAGE = "ML_G5_XLARGE_FOR_TRAINING_JOB_USAGE"
    ML_G4DN_2XLARGE_FOR_SPOT_TRAINING_JOB_USAGE = "ML_G4DN_2XLARGE_FOR_SPOT_TRAINING_JOB_USAGE"
    ML_G5_16XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE = "ML_G5_16XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE"
    ML_M5_24XLARGE_FOR_TRANSFORM_JOB_USAGE = "ML_M5_24XLARGE_FOR_TRANSFORM_JOB_USAGE"
    NUMBER_OF_INSTANCES_ACROSS_ALL_PROCESSING_JOBS = "NUMBER_OF_INSTANCES_ACROSS_ALL_PROCESSING_JOBS"
    ML_M4_10XLARGE_FOR_TRANSFORM_JOB_USAGE = "ML_M4_10XLARGE_FOR_TRANSFORM_JOB_USAGE"
    ML_M5_2XLARGE_FOR_TRAINING_WARM_POOL_USAGE = "ML_M5_2XLARGE_FOR_TRAINING_WARM_POOL_USAGE"
    ML_M5DN_XLARGE_FOR_ENDPOINT_USAGE = "ML_M5DN_XLARGE_FOR_ENDPOINT_USAGE"
    ML_G4DN_4XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE = "ML_G4DN_4XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE"
    SAGE_MAKER_PROFILER_APPS_RUNNING_ON_SYSTEM_INSTANCES = "SAGE_MAKER_PROFILER_APPS_RUNNING_ON_SYSTEM_INSTANCES"
    RATE_OF_DESCRIBE_ENDPOINT_CONFIG_REQUESTS = "RATE_OF_DESCRIBE_ENDPOINT_CONFIG_REQUESTS"
    ML_C6I_XLARGE_FOR_ENDPOINT_USAGE = "ML_C6I_XLARGE_FOR_ENDPOINT_USAGE"
    STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_M5_24XLARGE_INSTANCES = "STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_M5_24XLARGE_INSTANCES"
    ML_T3_2XLARGE_FOR_CLUSTER_USAGE = "ML_T3_2XLARGE_FOR_CLUSTER_USAGE"
    ML_R5_12XLARGE_FOR_PROCESSING_JOB_USAGE = "ML_R5_12XLARGE_FOR_PROCESSING_JOB_USAGE"
    TOTAL_MONITORING_SCHEDULES = "TOTAL_MONITORING_SCHEDULES"
    ML_G5_4XLARGE_FOR_CLUSTER_USAGE = "ML_G5_4XLARGE_FOR_CLUSTER_USAGE"
    ML_T2_XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE = "ML_T2_XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE"
    ML_M6G_16XLARGE_FOR_ENDPOINT_USAGE = "ML_M6G_16XLARGE_FOR_ENDPOINT_USAGE"
    ML_M5_XLARGE_FOR_TRAINING_WARM_POOL_USAGE = "ML_M5_XLARGE_FOR_TRAINING_WARM_POOL_USAGE"
    ML_P3_2XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE = "ML_P3_2XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE"
    STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_G5_2XLARGE_INSTANCE = "STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_G5_2XLARGE_INSTANCE"
    R_SESSION_GATEWAY_APPS_RUNNING_ON_ML_M5D_4XLARGE_INSTANCE = "R_SESSION_GATEWAY_APPS_RUNNING_ON_ML_M5D_4XLARGE_INSTANCE"
    STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_C5_18XLARGE_INSTANCES = "STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_C5_18XLARGE_INSTANCES"
    RATE_OF_LIST_STUDIO_LIFECYCLE_CONFIGS_REQUESTS = "RATE_OF_LIST_STUDIO_LIFECYCLE_CONFIGS_REQUESTS"
    RATE_OF_LIST_MONITORING_ALERT_HISTORY_REQUESTS = "RATE_OF_LIST_MONITORING_ALERT_HISTORY_REQUESTS"
    ML_R6GD_2XLARGE_FOR_ENDPOINT_USAGE = "ML_R6GD_2XLARGE_FOR_ENDPOINT_USAGE"
    R_STUDIO_SERVER_PRO_APPS_RUNNING_ON_ML_C5_4XLARGE_INSTANCES = "R_STUDIO_SERVER_PRO_APPS_RUNNING_ON_ML_C5_4XLARGE_INSTANCES"
    ML_C6I_8XLARGE_FOR_ENDPOINT_USAGE = "ML_C6I_8XLARGE_FOR_ENDPOINT_USAGE"
    ML_M5_12XLARGE_FOR_PROCESSING_JOB_USAGE = "ML_M5_12XLARGE_FOR_PROCESSING_JOB_USAGE"
    STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_G4DN_8XLARGE_INSTANCE = "STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_G4DN_8XLARGE_INSTANCE"
    ML_G5_24XLARGE_FOR_ENDPOINT_USAGE = "ML_G5_24XLARGE_FOR_ENDPOINT_USAGE"
    ML_G4DN_16XLARGE_FOR_CLUSTER_USAGE = "ML_G4DN_16XLARGE_FOR_CLUSTER_USAGE"
    ML_C5_18XLARGE_FOR_TRANSFORM_JOB_USAGE = "ML_C5_18XLARGE_FOR_TRANSFORM_JOB_USAGE"
    ML_R5D_12XLARGE_FOR_ENDPOINT_USAGE = "ML_R5D_12XLARGE_FOR_ENDPOINT_USAGE"
    STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_M5D_24XLARGE_INSTANCES = "STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_M5D_24XLARGE_INSTANCES"
    ML_C6GN_12XLARGE_FOR_ENDPOINT_USAGE = "ML_C6GN_12XLARGE_FOR_ENDPOINT_USAGE"
    STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_M5_XLARGE_INSTANCES = "STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_M5_XLARGE_INSTANCES"
    STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_G5_2XLARGE_INSTANCES = "STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_G5_2XLARGE_INSTANCES"
    ML_M5_24XLARGE_FOR_ENDPOINT_USAGE = "ML_M5_24XLARGE_FOR_ENDPOINT_USAGE"
    ML_TRN1_32XLARGE_FOR_SPOT_TRAINING_JOB_USAGE = "ML_TRN1_32XLARGE_FOR_SPOT_TRAINING_JOB_USAGE"
    STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_G5_XLARGE_INSTANCES = "STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_G5_XLARGE_INSTANCES"
    STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_G5_4XLARGE_INSTANCES = "STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_G5_4XLARGE_INSTANCES"
    STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_C5_24XLARGE_INSTANCES = "STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_C5_24XLARGE_INSTANCES"
    ML_C5D_2XLARGE_FOR_ENDPOINT_USAGE = "ML_C5D_2XLARGE_FOR_ENDPOINT_USAGE"
    ML_G4DN_XLARGE_FOR_TRAINING_WARM_POOL_USAGE = "ML_G4DN_XLARGE_FOR_TRAINING_WARM_POOL_USAGE"
    RATE_OF_CREATE_TRAINING_JOB_REQUESTS = "RATE_OF_CREATE_TRAINING_JOB_REQUESTS"
    ML_C5N_LARGE_FOR_CLUSTER_USAGE = "ML_C5N_LARGE_FOR_CLUSTER_USAGE"
    ML_INF1_24XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE = "ML_INF1_24XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE"
    STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_M5_24XLARGE_INSTANCE = "STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_M5_24XLARGE_INSTANCE"
    ML_C6I_4XLARGE_FOR_TRAINING_WARM_POOL_USAGE = "ML_C6I_4XLARGE_FOR_TRAINING_WARM_POOL_USAGE"
    R_SESSION_GATEWAY_APPS_RUNNING_ON_ML_R5_12XLARGE_INSTANCE = "R_SESSION_GATEWAY_APPS_RUNNING_ON_ML_R5_12XLARGE_INSTANCE"
    ML_P3_2XLARGE_FOR_TRAINING_WARM_POOL_USAGE = "ML_P3_2XLARGE_FOR_TRAINING_WARM_POOL_USAGE"
    ML_M6GD_8XLARGE_FOR_ENDPOINT_USAGE = "ML_M6GD_8XLARGE_FOR_ENDPOINT_USAGE"
    ML_M5D_8XLARGE_FOR_ENDPOINT_USAGE = "ML_M5D_8XLARGE_FOR_ENDPOINT_USAGE"
    STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_M5_2XLARGE_INSTANCES = "STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_M5_2XLARGE_INSTANCES"
    RATE_OF_DESCRIBE_STUDIO_LIFECYCLE_CONFIG_REQUESTS = "RATE_OF_DESCRIBE_STUDIO_LIFECYCLE_CONFIG_REQUESTS"
    STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_M5_8XLARGE_INSTANCES = "STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_M5_8XLARGE_INSTANCES"
    ML_R5_4XLARGE_FOR_PROCESSING_JOB_USAGE = "ML_R5_4XLARGE_FOR_PROCESSING_JOB_USAGE"
    ML_C6I_16XLARGE_FOR_TRAINING_WARM_POOL_USAGE = "ML_C6I_16XLARGE_FOR_TRAINING_WARM_POOL_USAGE"
    ML_C6G_8XLARGE_FOR_ENDPOINT_USAGE = "ML_C6G_8XLARGE_FOR_ENDPOINT_USAGE"
    ML_M5_24XLARGE_FOR_SPOT_TRAINING_JOB_USAGE = "ML_M5_24XLARGE_FOR_SPOT_TRAINING_JOB_USAGE"
    ML_G4DN_12XLARGE_FOR_SPOT_TRAINING_JOB_USAGE = "ML_G4DN_12XLARGE_FOR_SPOT_TRAINING_JOB_USAGE"
    ML_G4DN_8XLARGE_FOR_ENDPOINT_USAGE = "ML_G4DN_8XLARGE_FOR_ENDPOINT_USAGE"
    ML_G4DN_8XLARGE_FOR_TRAINING_JOB_USAGE = "ML_G4DN_8XLARGE_FOR_TRAINING_JOB_USAGE"
    ML_M5N_24XLARGE_FOR_ENDPOINT_USAGE = "ML_M5N_24XLARGE_FOR_ENDPOINT_USAGE"
    ML_P2_16XLARGE_FOR_PROCESSING_JOB_USAGE = "ML_P2_16XLARGE_FOR_PROCESSING_JOB_USAGE"
    ML_M5D_16XLARGE_FOR_ENDPOINT_USAGE = "ML_M5D_16XLARGE_FOR_ENDPOINT_USAGE"
    STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_M5_16XLARGE_INSTANCES = "STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_M5_16XLARGE_INSTANCES"
    STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_G5_16XLARGE_INSTANCE = "STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_G5_16XLARGE_INSTANCE"
    R_SESSION_GATEWAY_APPS_RUNNING_ON_ML_C5_18XLARGE_INSTANCE = "R_SESSION_GATEWAY_APPS_RUNNING_ON_ML_C5_18XLARGE_INSTANCE"
    ML_C5N_2XLARGE_FOR_ENDPOINT_USAGE = "ML_C5N_2XLARGE_FOR_ENDPOINT_USAGE"
    STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_R5_LARGE_INSTANCES = "STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_R5_LARGE_INSTANCES"
    ML_M5_LARGE_FOR_PROCESSING_JOB_USAGE = "ML_M5_LARGE_FOR_PROCESSING_JOB_USAGE"
    ML_R5_8XLARGE_FOR_PROCESSING_JOB_USAGE = "ML_R5_8XLARGE_FOR_PROCESSING_JOB_USAGE"
    STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_P3_2XLARGE_INSTANCES = "STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_P3_2XLARGE_INSTANCES"
    ML_R6G_4XLARGE_FOR_ENDPOINT_USAGE = "ML_R6G_4XLARGE_FOR_ENDPOINT_USAGE"
    ML_INF1_6XLARGE_FOR_ENDPOINT_USAGE = "ML_INF1_6XLARGE_FOR_ENDPOINT_USAGE"
    ML_M6I_12XLARGE_FOR_SPOT_TRAINING_JOB_USAGE = "ML_M6I_12XLARGE_FOR_SPOT_TRAINING_JOB_USAGE"
    ML_M4_2XLARGE_FOR_SPOT_TRAINING_JOB_USAGE = "ML_M4_2XLARGE_FOR_SPOT_TRAINING_JOB_USAGE"
    ML_TRN1_2XLARGE_FOR_SPOT_TRAINING_JOB_USAGE = "ML_TRN1_2XLARGE_FOR_SPOT_TRAINING_JOB_USAGE"
    ML_C7G_2XLARGE_FOR_ENDPOINT_USAGE = "ML_C7G_2XLARGE_FOR_ENDPOINT_USAGE"
    STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_M5D_LARGE_INSTANCE = "STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_M5D_LARGE_INSTANCE"
    STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_T3_2XLARGE_INSTANCE = "STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_T3_2XLARGE_INSTANCE"
    ML_G5_8XLARGE_FOR_ENDPOINT_USAGE = "ML_G5_8XLARGE_FOR_ENDPOINT_USAGE"
    ML_P4D_24XLARGE_FOR_TRAINING_WARM_POOL_USAGE = "ML_P4D_24XLARGE_FOR_TRAINING_WARM_POOL_USAGE"
    ML_G5_2XLARGE_FOR_CLUSTER_USAGE = "ML_G5_2XLARGE_FOR_CLUSTER_USAGE"
    ML_M6I_12XLARGE_FOR_TRAINING_JOB_USAGE = "ML_M6I_12XLARGE_FOR_TRAINING_JOB_USAGE"
    ML_T2_MEDIUM_FOR_ENDPOINT_USAGE = "ML_T2_MEDIUM_FOR_ENDPOINT_USAGE"
    ML_INF2_XLARGE_FOR_ENDPOINT_USAGE = "ML_INF2_XLARGE_FOR_ENDPOINT_USAGE"
    STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_M5_LARGE_INSTANCE = "STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_M5_LARGE_INSTANCE"
    ML_M5DN_16XLARGE_FOR_ENDPOINT_USAGE = "ML_M5DN_16XLARGE_FOR_ENDPOINT_USAGE"
    ML_C6I_8XLARGE_FOR_SPOT_TRAINING_JOB_USAGE = "ML_C6I_8XLARGE_FOR_SPOT_TRAINING_JOB_USAGE"
    STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_G4DN_4XLARGE_INSTANCES = "STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_G4DN_4XLARGE_INSTANCES"
    ML_INF1_XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE = "ML_INF1_XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE"
    STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_C5_9XLARGE_INSTANCES = "STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_C5_9XLARGE_INSTANCES"
    STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_G5_24XLARGE_INSTANCES = "STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_G5_24XLARGE_INSTANCES"
    STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_P3DN_24XLARGE_INSTANCES = "STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_P3DN_24XLARGE_INSTANCES"
    ML_P2_XLARGE_FOR_PROCESSING_JOB_USAGE = "ML_P2_XLARGE_FOR_PROCESSING_JOB_USAGE"
    ML_G4DN_16XLARGE_FOR_TRANSFORM_JOB_USAGE = "ML_G4DN_16XLARGE_FOR_TRANSFORM_JOB_USAGE"
    ML_C4_8XLARGE_FOR_TRAINING_JOB_USAGE = "ML_C4_8XLARGE_FOR_TRAINING_JOB_USAGE"
    RATE_OF_CREATE_NOTEBOOK_INSTANCE_LIFECYCLE_CONFIG_REQUESTS = "RATE_OF_CREATE_NOTEBOOK_INSTANCE_LIFECYCLE_CONFIG_REQUESTS"
    ML_C5D_9XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE = "ML_C5D_9XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE"
    ML_P2_16XLARGE_FOR_ENDPOINT_USAGE = "ML_P2_16XLARGE_FOR_ENDPOINT_USAGE"
    STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_R5_16XLARGE_INSTANCES = "STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_R5_16XLARGE_INSTANCES"
    ML_C5_XLARGE_FOR_TRAINING_JOB_USAGE = "ML_C5_XLARGE_FOR_TRAINING_JOB_USAGE"
    STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_C5_XLARGE_INSTANCES = "STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_C5_XLARGE_INSTANCES"
    ML_M4_10XLARGE_FOR_PROCESSING_JOB_USAGE = "ML_M4_10XLARGE_FOR_PROCESSING_JOB_USAGE"
    ML_C7I_24XLARGE_FOR_ENDPOINT_USAGE = "ML_C7I_24XLARGE_FOR_ENDPOINT_USAGE"
    ML_R6GD_XLARGE_FOR_ENDPOINT_USAGE = "ML_R6GD_XLARGE_FOR_ENDPOINT_USAGE"
    RATE_OF_LIST_TRAINING_JOBS_REQUESTS = "RATE_OF_LIST_TRAINING_JOBS_REQUESTS"
    RATE_OF_UPDATE_ENDPOINT_REQUESTS = "RATE_OF_UPDATE_ENDPOINT_REQUESTS"
    ML_T2_LARGE_FOR_ENDPOINT_USAGE = "ML_T2_LARGE_FOR_ENDPOINT_USAGE"
    ML_C7G_12XLARGE_FOR_ENDPOINT_USAGE = "ML_C7G_12XLARGE_FOR_ENDPOINT_USAGE"
    ML_C5_12XLARGE_FOR_CLUSTER_USAGE = "ML_C5_12XLARGE_FOR_CLUSTER_USAGE"
    ML_M7I_XLARGE_FOR_ENDPOINT_USAGE = "ML_M7I_XLARGE_FOR_ENDPOINT_USAGE"
    ML_M6I_12XLARGE_FOR_TRAINING_WARM_POOL_USAGE = "ML_M6I_12XLARGE_FOR_TRAINING_WARM_POOL_USAGE"
    STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_R5_2XLARGE_INSTANCES = "STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_R5_2XLARGE_INSTANCES"
    ML_G5_16XLARGE_FOR_TRAINING_WARM_POOL_USAGE = "ML_G5_16XLARGE_FOR_TRAINING_WARM_POOL_USAGE"
    ML_P4D_24XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE = "ML_P4D_24XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE"
    ML_M4_2XLARGE_FOR_TRANSFORM_JOB_USAGE = "ML_M4_2XLARGE_FOR_TRANSFORM_JOB_USAGE"
    ML_M5_LARGE_FOR_CLUSTER_USAGE = "ML_M5_LARGE_FOR_CLUSTER_USAGE"
    ML_C5_2XLARGE_FOR_TRAINING_WARM_POOL_USAGE = "ML_C5_2XLARGE_FOR_TRAINING_WARM_POOL_USAGE"
    ML_C5_9XLARGE_FOR_ENDPOINT_USAGE = "ML_C5_9XLARGE_FOR_ENDPOINT_USAGE"
    STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_G5_12XLARGE_INSTANCE = "STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_G5_12XLARGE_INSTANCE"
    STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_G5_4XLARGE_INSTANCES = "STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_G5_4XLARGE_INSTANCES"
    ML_TRN1_32XLARGE_FOR_TRAINING_WARM_POOL_USAGE = "ML_TRN1_32XLARGE_FOR_TRAINING_WARM_POOL_USAGE"
    ML_M7I_LARGE_FOR_ENDPOINT_USAGE = "ML_M7I_LARGE_FOR_ENDPOINT_USAGE"
    STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_R5_LARGE_INSTANCE = "STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_R5_LARGE_INSTANCE"
    STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_R5_XLARGE_INSTANCES = "STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_R5_XLARGE_INSTANCES"
    RATE_OF_LIST_ENDPOINT_CONFIGS_REQUESTS = "RATE_OF_LIST_ENDPOINT_CONFIGS_REQUESTS"
    ML_P3_2XLARGE_FOR_PROCESSING_JOB_USAGE = "ML_P3_2XLARGE_FOR_PROCESSING_JOB_USAGE"
    ML_G5_16XLARGE_FOR_TRAINING_JOB_USAGE = "ML_G5_16XLARGE_FOR_TRAINING_JOB_USAGE"
    RATE_OF_DESCRIBE_NOTEBOOK_INSTANCE_LIFECYCLE_CONFIG_REQUESTS = "RATE_OF_DESCRIBE_NOTEBOOK_INSTANCE_LIFECYCLE_CONFIG_REQUESTS"
    ML_C7G_4XLARGE_FOR_ENDPOINT_USAGE = "ML_C7G_4XLARGE_FOR_ENDPOINT_USAGE"
    ML_C5N_XLARGE_FOR_TRAINING_WARM_POOL_USAGE = "ML_C5N_XLARGE_FOR_TRAINING_WARM_POOL_USAGE"
    MAXIMUM_NUMBER_OF_DEVICES = "MAXIMUM_NUMBER_OF_DEVICES"
    ML_P2_8XLARGE_FOR_TRANSFORM_JOB_USAGE = "ML_P2_8XLARGE_FOR_TRANSFORM_JOB_USAGE"
    ML_M5D_4XLARGE_FOR_ENDPOINT_USAGE = "ML_M5D_4XLARGE_FOR_ENDPOINT_USAGE"
    ML_R5_24XLARGE_FOR_PROCESSING_JOB_USAGE = "ML_R5_24XLARGE_FOR_PROCESSING_JOB_USAGE"
    ML_M5_12XLARGE_FOR_TRAINING_WARM_POOL_USAGE = "ML_M5_12XLARGE_FOR_TRAINING_WARM_POOL_USAGE"
    STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_C5_2XLARGE_INSTANCE = "STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_C5_2XLARGE_INSTANCE"
    ML_M6I_24XLARGE_FOR_TRAINING_WARM_POOL_USAGE = "ML_M6I_24XLARGE_FOR_TRAINING_WARM_POOL_USAGE"
    STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_P4D_24XLARGE_INSTANCES = "STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_P4D_24XLARGE_INSTANCES"
    STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_M5_24XLARGE_INSTANCES = "STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_M5_24XLARGE_INSTANCES"
    ML_P3_8XLARGE_FOR_ENDPOINT_USAGE = "ML_P3_8XLARGE_FOR_ENDPOINT_USAGE"
    ML_R7I_XLARGE_FOR_ENDPOINT_USAGE = "ML_R7I_XLARGE_FOR_ENDPOINT_USAGE"
    ML_C6I_32XLARGE_FOR_TRAINING_WARM_POOL_USAGE = "ML_C6I_32XLARGE_FOR_TRAINING_WARM_POOL_USAGE"
    ML_R5DN_12XLARGE_FOR_ENDPOINT_USAGE = "ML_R5DN_12XLARGE_FOR_ENDPOINT_USAGE"
    R_SESSION_GATEWAY_APPS_RUNNING_ON_ML_M5_4XLARGE_INSTANCE = "R_SESSION_GATEWAY_APPS_RUNNING_ON_ML_M5_4XLARGE_INSTANCE"
    MAXIMUM_NUMBER_OF_PARALLEL_EDGE_PACKAGING_JOBS = "MAXIMUM_NUMBER_OF_PARALLEL_EDGE_PACKAGING_JOBS"
    STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_P3DN_24XLARGE_INSTANCE = "STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_P3DN_24XLARGE_INSTANCE"
    R_STUDIO_SERVER_PRO_APPS_RUNNING_ON_SYSTEM_INSTANCES = "R_STUDIO_SERVER_PRO_APPS_RUNNING_ON_SYSTEM_INSTANCES"
    ML_INF1_XLARGE_FOR_ENDPOINT_USAGE = "ML_INF1_XLARGE_FOR_ENDPOINT_USAGE"
    ML_M5DN_12XLARGE_FOR_ENDPOINT_USAGE = "ML_M5DN_12XLARGE_FOR_ENDPOINT_USAGE"
    ML_G5_XLARGE_FOR_TRAINING_WARM_POOL_USAGE = "ML_G5_XLARGE_FOR_TRAINING_WARM_POOL_USAGE"
    ML_R5_16XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE = "ML_R5_16XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE"
    ML_M6I_32XLARGE_FOR_SPOT_TRAINING_JOB_USAGE = "ML_M6I_32XLARGE_FOR_SPOT_TRAINING_JOB_USAGE"
    R_SESSION_GATEWAY_APPS_RUNNING_ON_ML_C5_24XLARGE_INSTANCE = "R_SESSION_GATEWAY_APPS_RUNNING_ON_ML_C5_24XLARGE_INSTANCE"
    ML_C5_18XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE = "ML_C5_18XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE"
    ML_R5DN_LARGE_FOR_ENDPOINT_USAGE = "ML_R5DN_LARGE_FOR_ENDPOINT_USAGE"
    ML_P3_2XLARGE_FOR_ENDPOINT_USAGE = "ML_P3_2XLARGE_FOR_ENDPOINT_USAGE"
    R_SESSION_GATEWAY_APPS_RUNNING_ON_ML_M5_16XLARGE_INSTANCE = "R_SESSION_GATEWAY_APPS_RUNNING_ON_ML_M5_16XLARGE_INSTANCE"
    STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_G5_24XLARGE_INSTANCES = "STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_G5_24XLARGE_INSTANCES"
    ML_EIA1_LARGE_FOR_ENDPOINT_USAGE = "ML_EIA1_LARGE_FOR_ENDPOINT_USAGE"
    ML_M6I_LARGE_FOR_SPOT_TRAINING_JOB_USAGE = "ML_M6I_LARGE_FOR_SPOT_TRAINING_JOB_USAGE"
    ML_M5D_12XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE = "ML_M5D_12XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE"
    STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_R5_4XLARGE_INSTANCES = "STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_R5_4XLARGE_INSTANCES"
    ML_C5_2XLARGE_FOR_SPOT_TRAINING_JOB_USAGE = "ML_C5_2XLARGE_FOR_SPOT_TRAINING_JOB_USAGE"
    ML_C5_XLARGE_FOR_PROCESSING_JOB_USAGE = "ML_C5_XLARGE_FOR_PROCESSING_JOB_USAGE"
    ML_C6GN_XLARGE_FOR_ENDPOINT_USAGE = "ML_C6GN_XLARGE_FOR_ENDPOINT_USAGE"
    ML_R5N_12XLARGE_FOR_ENDPOINT_USAGE = "ML_R5N_12XLARGE_FOR_ENDPOINT_USAGE"
    ML_P3DN_24XLARGE_FOR_TRAINING_WARM_POOL_USAGE = "ML_P3DN_24XLARGE_FOR_TRAINING_WARM_POOL_USAGE"
    RATE_OF_CREATE_PRESIGNED_NOTEBOOK_INSTANCE_URL_REQUESTS = "RATE_OF_CREATE_PRESIGNED_NOTEBOOK_INSTANCE_URL_REQUESTS"
    ML_R7I_LARGE_FOR_ENDPOINT_USAGE = "ML_R7I_LARGE_FOR_ENDPOINT_USAGE"
    ML_G5_8XLARGE_FOR_TRAINING_JOB_USAGE = "ML_G5_8XLARGE_FOR_TRAINING_JOB_USAGE"
    ML_C7G_16XLARGE_FOR_ENDPOINT_USAGE = "ML_C7G_16XLARGE_FOR_ENDPOINT_USAGE"
    MAXIMUM_NUMBER_OF_SAGE_MAKER_PROJECTS_ALLOWED_PER_ACCOUNT = "MAXIMUM_NUMBER_OF_SAGE_MAKER_PROJECTS_ALLOWED_PER_ACCOUNT"
    ML_M6GD_12XLARGE_FOR_ENDPOINT_USAGE = "ML_M6GD_12XLARGE_FOR_ENDPOINT_USAGE"
    R_SESSION_GATEWAY_APPS_RUNNING_ON_ML_M5D_2XLARGE_INSTANCE = "R_SESSION_GATEWAY_APPS_RUNNING_ON_ML_M5D_2XLARGE_INSTANCE"
    ML_R5_16XLARGE_FOR_ENDPOINT_USAGE = "ML_R5_16XLARGE_FOR_ENDPOINT_USAGE"
    ML_P4DE_24XLARGE_FOR_CLUSTER_USAGE = "ML_P4DE_24XLARGE_FOR_CLUSTER_USAGE"
    STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_M5_4XLARGE_INSTANCES = "STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_M5_4XLARGE_INSTANCES"
    ML_EIA2_LARGE_FOR_ENDPOINT_USAGE = "ML_EIA2_LARGE_FOR_ENDPOINT_USAGE"
    STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_M5D_XLARGE_INSTANCE = "STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_M5D_XLARGE_INSTANCE"
    ML_P3_8XLARGE_FOR_SPOT_TRAINING_JOB_USAGE = "ML_P3_8XLARGE_FOR_SPOT_TRAINING_JOB_USAGE"
    ML_C5N_XLARGE_FOR_ENDPOINT_USAGE = "ML_C5N_XLARGE_FOR_ENDPOINT_USAGE"
    STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_M5D_XLARGE_INSTANCES = "STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_M5D_XLARGE_INSTANCES"
    ML_C5_9XLARGE_FOR_PROCESSING_JOB_USAGE = "ML_C5_9XLARGE_FOR_PROCESSING_JOB_USAGE"
    ML_M6I_XLARGE_FOR_TRAINING_WARM_POOL_USAGE = "ML_M6I_XLARGE_FOR_TRAINING_WARM_POOL_USAGE"
    ML_C6G_12XLARGE_FOR_ENDPOINT_USAGE = "ML_C6G_12XLARGE_FOR_ENDPOINT_USAGE"
    ML_C5D_XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE = "ML_C5D_XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE"
    R_SESSION_GATEWAY_APPS_RUNNING_ON_ML_M5D_16XLARGE_INSTANCE = "R_SESSION_GATEWAY_APPS_RUNNING_ON_ML_M5D_16XLARGE_INSTANCE"
    ML_P4DE_24XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE = "ML_P4DE_24XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE"
    STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_C5_18XLARGE_INSTANCES = "STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_C5_18XLARGE_INSTANCES"
    STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_P3_2XLARGE_INSTANCE = "STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_P3_2XLARGE_INSTANCE"
    ML_C5N_18XLARGE_FOR_SPOT_TRAINING_JOB_USAGE = "ML_C5N_18XLARGE_FOR_SPOT_TRAINING_JOB_USAGE"
    R_SESSION_GATEWAY_APPS_RUNNING_ON_ML_T3_MEDIUM_INSTANCE = "R_SESSION_GATEWAY_APPS_RUNNING_ON_ML_T3_MEDIUM_INSTANCE"
    ML_M5_2XLARGE_FOR_PROCESSING_JOB_USAGE = "ML_M5_2XLARGE_FOR_PROCESSING_JOB_USAGE"
    LONGEST_RUN_TIME_FOR_AN_AUTO_ML_JOB_FROM_CREATION_TO_TERMINATION = "LONGEST_RUN_TIME_FOR_AN_AUTO_ML_JOB_FROM_CREATION_TO_TERMINATION"
    ML_C5_XLARGE_FOR_TRAINING_WARM_POOL_USAGE = "ML_C5_XLARGE_FOR_TRAINING_WARM_POOL_USAGE"
    ML_M4_XLARGE_FOR_ENDPOINT_USAGE = "ML_M4_XLARGE_FOR_ENDPOINT_USAGE"
    RATE_OF_DELETE_ENDPOINT_REQUESTS = "RATE_OF_DELETE_ENDPOINT_REQUESTS"
    ML_EIA1_XLARGE_FOR_ENDPOINT_USAGE = "ML_EIA1_XLARGE_FOR_ENDPOINT_USAGE"
    ML_R5N_XLARGE_FOR_ENDPOINT_USAGE = "ML_R5N_XLARGE_FOR_ENDPOINT_USAGE"
    STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_R5_8XLARGE_INSTANCE = "STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_R5_8XLARGE_INSTANCE"
    ML_C5D_XLARGE_FOR_ENDPOINT_USAGE = "ML_C5D_XLARGE_FOR_ENDPOINT_USAGE"
    ML_T3_LARGE_FOR_PROCESSING_JOB_USAGE = "ML_T3_LARGE_FOR_PROCESSING_JOB_USAGE"
    ML_P3_2XLARGE_FOR_TRAINING_JOB_USAGE = "ML_P3_2XLARGE_FOR_TRAINING_JOB_USAGE"
    ML_C5D_4XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE = "ML_C5D_4XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE"
    STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_M5_8XLARGE_INSTANCES = "STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_M5_8XLARGE_INSTANCES"
    ML_C5N_9XLARGE_FOR_TRAINING_WARM_POOL_USAGE = "ML_C5N_9XLARGE_FOR_TRAINING_WARM_POOL_USAGE"
    ML_R7I_24XLARGE_FOR_ENDPOINT_USAGE = "ML_R7I_24XLARGE_FOR_ENDPOINT_USAGE"
    ML_INF2_24XLARGE_FOR_ENDPOINT_USAGE = "ML_INF2_24XLARGE_FOR_ENDPOINT_USAGE"
    STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_M5_LARGE_INSTANCES = "STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_M5_LARGE_INSTANCES"
    ML_C5N_2XLARGE_FOR_SPOT_TRAINING_JOB_USAGE = "ML_C5N_2XLARGE_FOR_SPOT_TRAINING_JOB_USAGE"
    ML_R5N_LARGE_FOR_ENDPOINT_USAGE = "ML_R5N_LARGE_FOR_ENDPOINT_USAGE"
    STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_P3_16XLARGE_INSTANCES = "STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_P3_16XLARGE_INSTANCES"
    STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_M5_XLARGE_INSTANCE = "STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_M5_XLARGE_INSTANCE"
    STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_M5D_2XLARGE_INSTANCES = "STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_M5D_2XLARGE_INSTANCES"
    STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_TRN1_2XLARGE_INSTANCES = "STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_TRN1_2XLARGE_INSTANCES"
    ML_R5_24XLARGE_FOR_ENDPOINT_USAGE = "ML_R5_24XLARGE_FOR_ENDPOINT_USAGE"
    ML_C6I_2XLARGE_FOR_ENDPOINT_USAGE = "ML_C6I_2XLARGE_FOR_ENDPOINT_USAGE"
    ML_M4_4XLARGE_FOR_PROCESSING_JOB_USAGE = "ML_M4_4XLARGE_FOR_PROCESSING_JOB_USAGE"
    ML_C6I_2XLARGE_FOR_TRAINING_WARM_POOL_USAGE = "ML_C6I_2XLARGE_FOR_TRAINING_WARM_POOL_USAGE"
    STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_R5_8XLARGE_INSTANCES = "STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_R5_8XLARGE_INSTANCES"
    ML_P2_16XLARGE_FOR_TRANSFORM_JOB_USAGE = "ML_P2_16XLARGE_FOR_TRANSFORM_JOB_USAGE"
    ML_R5N_4XLARGE_FOR_ENDPOINT_USAGE = "ML_R5N_4XLARGE_FOR_ENDPOINT_USAGE"
    ML_G4DN_2XLARGE_FOR_ENDPOINT_USAGE = "ML_G4DN_2XLARGE_FOR_ENDPOINT_USAGE"
    ML_C6I_2XLARGE_FOR_TRAINING_JOB_USAGE = "ML_C6I_2XLARGE_FOR_TRAINING_JOB_USAGE"
    ML_C6GD_XLARGE_FOR_ENDPOINT_USAGE = "ML_C6GD_XLARGE_FOR_ENDPOINT_USAGE"
    ML_C5_9XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE = "ML_C5_9XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE"
    ML_G5_24XLARGE_FOR_CLUSTER_USAGE = "ML_G5_24XLARGE_FOR_CLUSTER_USAGE"
    ML_C4_4XLARGE_FOR_TRAINING_WARM_POOL_USAGE = "ML_C4_4XLARGE_FOR_TRAINING_WARM_POOL_USAGE"
    RATE_OF_DELETE_TRANSFORM_JOB_REQUESTS = "RATE_OF_DELETE_TRANSFORM_JOB_REQUESTS"
    ML_R6G_8XLARGE_FOR_ENDPOINT_USAGE = "ML_R6G_8XLARGE_FOR_ENDPOINT_USAGE"
    ML_INF1_2XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE = "ML_INF1_2XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE"
    RATE_OF_CREATE_NOTEBOOK_INSTANCE_REQUESTS = "RATE_OF_CREATE_NOTEBOOK_INSTANCE_REQUESTS"
    ML_C4_2XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE = "ML_C4_2XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE"
    ML_EIA2_MEDIUM_FOR_ENDPOINT_USAGE = "ML_EIA2_MEDIUM_FOR_ENDPOINT_USAGE"
    STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_M5_2XLARGE_INSTANCE = "STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_M5_2XLARGE_INSTANCE"
    ML_R5D_8XLARGE_FOR_ENDPOINT_USAGE = "ML_R5D_8XLARGE_FOR_ENDPOINT_USAGE"
    STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_M5D_4XLARGE_INSTANCES = "STUDIO_CODE_EDITOR_APPS_RUNNING_ON_ML_M5D_4XLARGE_INSTANCES"
    R_SESSION_GATEWAY_APPS_RUNNING_ON_ML_T3_LARGE_INSTANCE = "R_SESSION_GATEWAY_APPS_RUNNING_ON_ML_T3_LARGE_INSTANCE"
    MAXIMUM_NUMBER_OF_INSTANCES_PER_TRAINING_JOB = "MAXIMUM_NUMBER_OF_INSTANCES_PER_TRAINING_JOB"
    ML_C5_LARGE_FOR_ENDPOINT_USAGE = "ML_C5_LARGE_FOR_ENDPOINT_USAGE"
    STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_R5_2XLARGE_INSTANCE = "STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_R5_2XLARGE_INSTANCE"
    ML_M5_XLARGE_FOR_PROCESSING_JOB_USAGE = "ML_M5_XLARGE_FOR_PROCESSING_JOB_USAGE"
    ML_G4DN_XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE = "ML_G4DN_XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE"
    STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_G5_XLARGE_INSTANCE = "STUDIO_KERNEL_GATEWAY_APPS_RUNNING_ON_ML_G5_XLARGE_INSTANCE"
    ML_R5_24XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE = "ML_R5_24XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE"
    ML_C5N_4XLARGE_FOR_TRAINING_JOB_USAGE = "ML_C5N_4XLARGE_FOR_TRAINING_JOB_USAGE"
    ML_C5N_4XLARGE_FOR_SPOT_TRAINING_JOB_USAGE = "ML_C5N_4XLARGE_FOR_SPOT_TRAINING_JOB_USAGE"
    ML_M5DN_24XLARGE_FOR_ENDPOINT_USAGE = "ML_M5DN_24XLARGE_FOR_ENDPOINT_USAGE"
    MAXIMUM_NUMBER_OF_STUDIO_SPACES_ALLOWED_PER_ACCOUNT = "MAXIMUM_NUMBER_OF_STUDIO_SPACES_ALLOWED_PER_ACCOUNT"
    ML_G5_48XLARGE_FOR_CLUSTER_USAGE = "ML_G5_48XLARGE_FOR_CLUSTER_USAGE"
    ML_G5_48XLARGE_FOR_TRAINING_WARM_POOL_USAGE = "ML_G5_48XLARGE_FOR_TRAINING_WARM_POOL_USAGE"
    STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_G5_8XLARGE_INSTANCES = "STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_G5_8XLARGE_INSTANCES"
    RATE_OF_LIST_NOTEBOOK_INSTANCE_LIFECYCLE_CONFIGS_REQUESTS = "RATE_OF_LIST_NOTEBOOK_INSTANCE_LIFECYCLE_CONFIGS_REQUESTS"
    ML_M5DN_2XLARGE_FOR_ENDPOINT_USAGE = "ML_M5DN_2XLARGE_FOR_ENDPOINT_USAGE"
    ML_C5_24XLARGE_FOR_CLUSTER_USAGE = "ML_C5_24XLARGE_FOR_CLUSTER_USAGE"
    ML_C5N_4XLARGE_FOR_TRAINING_WARM_POOL_USAGE = "ML_C5N_4XLARGE_FOR_TRAINING_WARM_POOL_USAGE"
    ML_R5DN_8XLARGE_FOR_ENDPOINT_USAGE = "ML_R5DN_8XLARGE_FOR_ENDPOINT_USAGE"
    ML_M6I_32XLARGE_FOR_TRAINING_JOB_USAGE = "ML_M6I_32XLARGE_FOR_TRAINING_JOB_USAGE"
    ML_C5_18XLARGE_FOR_CLUSTER_USAGE = "ML_C5_18XLARGE_FOR_CLUSTER_USAGE"
    STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_C5_LARGE_INSTANCES = "STUDIO_JUPYTER_LAB_APPS_RUNNING_ON_ML_C5_LARGE_INSTANCES"
    RATE_OF_DELETE_ENDPOINT_CONFIG_REQUESTS = "RATE_OF_DELETE_ENDPOINT_CONFIG_REQUESTS"
    ML_G5_48XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE = "ML_G5_48XLARGE_FOR_NOTEBOOK_INSTANCE_USAGE"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AmazonSimpleDbQuota")
class AmazonSimpleDbQuota(enum.Enum):
    ATTRIBUTE_COUNT_PER_DOMAIN = "ATTRIBUTE_COUNT_PER_DOMAIN"
    DOMAIN_NAME_LENGTH = "DOMAIN_NAME_LENGTH"
    MINIMUM_DOMAIN_NAME_LENGTH = "MINIMUM_DOMAIN_NAME_LENGTH"
    ATTRIBUTE_VALUE_SIZE = "ATTRIBUTE_VALUE_SIZE"
    ITEM_NAME_SIZE = "ITEM_NAME_SIZE"
    ATTRIBUTES_REQUESTED_PER_SELECT_OPERATION = "ATTRIBUTES_REQUESTED_PER_SELECT_OPERATION"
    ATTRIBUTES_PER_PUT_ATTRIBUTES_OPERATION = "ATTRIBUTES_PER_PUT_ATTRIBUTES_OPERATION"
    ITEMS_PER_BATCH_PUT_ATTRIBUTES_OPERATION = "ITEMS_PER_BATCH_PUT_ATTRIBUTES_OPERATION"
    ITEMS_PER_SELECT_RESPONSE = "ITEMS_PER_SELECT_RESPONSE"
    TOTAL_DOMAINS = "TOTAL_DOMAINS"
    ATTRIBUTE_NAME_SIZE = "ATTRIBUTE_NAME_SIZE"
    ATTRIBUTE_NAME_VALUE_PAIRS_PER_ITEM = "ATTRIBUTE_NAME_VALUE_PAIRS_PER_ITEM"
    SELECT_RESPONSE_SIZE = "SELECT_RESPONSE_SIZE"
    UNIQUE_ATTRIBUTES_PER_SELECT_EXPRESSION = "UNIQUE_ATTRIBUTES_PER_SELECT_EXPRESSION"
    ITEMS_PER_BATCH_DELETE_ATTRIBUTES_OPERATION = "ITEMS_PER_BATCH_DELETE_ATTRIBUTES_OPERATION"
    SIZE_PER_DOMAIN = "SIZE_PER_DOMAIN"
    QUERY_EXECUTION_TIME = "QUERY_EXECUTION_TIME"
    COMPARISONS_PER_SELECT_EXPRESSION = "COMPARISONS_PER_SELECT_EXPRESSION"


@jsii.enum(
    jsii_type="@reapit-cdk/service-quotas.AmazonSimpleEmailServiceAmazonSesQuota"
)
class AmazonSimpleEmailServiceAmazonSesQuota(enum.Enum):
    SENDING_QUOTA = "SENDING_QUOTA"
    SENDING_RATE = "SENDING_RATE"


@jsii.enum(
    jsii_type="@reapit-cdk/service-quotas.AmazonSimpleNotificationServiceAmazonSnsQuota"
)
class AmazonSimpleNotificationServiceAmazonSnsQuota(enum.Enum):
    LIST_SUBSCRIPTIONS_BY_TOPIC_TRANSACTIONS_PER_SECOND = "LIST_SUBSCRIPTIONS_BY_TOPIC_TRANSACTIONS_PER_SECOND"
    LIST_ORIGINATION_NUMBERS_TRANSACTIONS_PER_SECOND = "LIST_ORIGINATION_NUMBERS_TRANSACTIONS_PER_SECOND"
    ADD_PERMISSION_TRANSACTIONS_PER_SECOND = "ADD_PERMISSION_TRANSACTIONS_PER_SECOND"
    SET_ENDPOINT_ATTRIBUTES_TRANSACTIONS_PER_SECOND = "SET_ENDPOINT_ATTRIBUTES_TRANSACTIONS_PER_SECOND"
    SET_SUBSCRIPTION_ATTRIBUTES_TRANSACTIONS_PER_SECOND = "SET_SUBSCRIPTION_ATTRIBUTES_TRANSACTIONS_PER_SECOND"
    DELETE_PLATFORM_APPLICATION_TRANSACTIONS_PER_SECOND = "DELETE_PLATFORM_APPLICATION_TRANSACTIONS_PER_SECOND"
    SET_SMS_ATTRIBUTES_TRANSACTIONS_PER_SECOND = "SET_SMS_ATTRIBUTES_TRANSACTIONS_PER_SECOND"
    VERIFY_SMS_SANDBOX_PHONE_NUMBER_TRANSACTIONS_PER_SECOND = "VERIFY_SMS_SANDBOX_PHONE_NUMBER_TRANSACTIONS_PER_SECOND"
    FILTER_POLICIES_PER_ACCOUNT = "FILTER_POLICIES_PER_ACCOUNT"
    LIST_PLATFORM_APPLICATIONS_TRANSACTIONS_PER_SECOND = "LIST_PLATFORM_APPLICATIONS_TRANSACTIONS_PER_SECOND"
    GET_SMS_SANDBOX_ACCOUNT_STATUS_TRANSACTIONS_PER_SECOND = "GET_SMS_SANDBOX_ACCOUNT_STATUS_TRANSACTIONS_PER_SECOND"
    DELETE_SMS_SANDBOX_PHONE_NUMBER_TRANSACTIONS_PER_SECOND = "DELETE_SMS_SANDBOX_PHONE_NUMBER_TRANSACTIONS_PER_SECOND"
    CREATE_TOPIC_TRANSACTIONS_PER_SECOND = "CREATE_TOPIC_TRANSACTIONS_PER_SECOND"
    LIST_SUBSCRIPTIONS_TRANSACTIONS_PER_SECOND = "LIST_SUBSCRIPTIONS_TRANSACTIONS_PER_SECOND"
    GET_PLATFORM_APPLICATION_ATTRIBUTES_TRANSACTIONS_PER_SECOND = "GET_PLATFORM_APPLICATION_ATTRIBUTES_TRANSACTIONS_PER_SECOND"
    DELETE_TOPIC_TRANSACTIONS_PER_SECOND = "DELETE_TOPIC_TRANSACTIONS_PER_SECOND"
    LIST_TAGS_FOR_RESOURCE_TRANSACTIONS_PER_SECOND = "LIST_TAGS_FOR_RESOURCE_TRANSACTIONS_PER_SECOND"
    UNTAG_RESOURCE_TRANSACTIONS_PER_SECOND = "UNTAG_RESOURCE_TRANSACTIONS_PER_SECOND"
    PENDING_SUBSCRIPTIONS_PER_ACCOUNT = "PENDING_SUBSCRIPTIONS_PER_ACCOUNT"
    SUBSCRIPTIONS_PER_TOPIC = "SUBSCRIPTIONS_PER_TOPIC"
    LIST_SMS_SANDBOX_PHONE_NUMBERS_TRANSACTIONS_PER_SECOND = "LIST_SMS_SANDBOX_PHONE_NUMBERS_TRANSACTIONS_PER_SECOND"
    CREATE_SMS_SANDBOX_PHONE_NUMBER_TRANSACTIONS_PER_SECOND = "CREATE_SMS_SANDBOX_PHONE_NUMBER_TRANSACTIONS_PER_SECOND"
    TAG_RESOURCE_TRANSACTIONS_PER_SECOND = "TAG_RESOURCE_TRANSACTIONS_PER_SECOND"
    LIST_TOPICS_TRANSACTIONS_PER_SECOND = "LIST_TOPICS_TRANSACTIONS_PER_SECOND"
    SUBSCRIBE_TRANSACTIONS_PER_SECOND = "SUBSCRIBE_TRANSACTIONS_PER_SECOND"
    SET_PLATFORM_APPLICATION_ATTRIBUTES_TRANSACTIONS_PER_SECOND = "SET_PLATFORM_APPLICATION_ATTRIBUTES_TRANSACTIONS_PER_SECOND"
    SET_TOPIC_ATTRIBUTES_TRANSACTIONS_PER_SECOND = "SET_TOPIC_ATTRIBUTES_TRANSACTIONS_PER_SECOND"
    CREATE_PLATFORM_APPLICATION_TRANSACTIONS_PER_SECOND = "CREATE_PLATFORM_APPLICATION_TRANSACTIONS_PER_SECOND"
    TOPICS_PER_ACCOUNT = "TOPICS_PER_ACCOUNT"
    FILTER_POLICIES_PER_TOPIC = "FILTER_POLICIES_PER_TOPIC"
    UNSUBSCRIBE_TRANSACTIONS_PER_SECOND = "UNSUBSCRIBE_TRANSACTIONS_PER_SECOND"
    GET_SMS_ATTRIBUTES_TRANSACTIONS_PER_SECOND = "GET_SMS_ATTRIBUTES_TRANSACTIONS_PER_SECOND"
    MESSAGES_PUBLISHED_PER_SECOND = "MESSAGES_PUBLISHED_PER_SECOND"
    REMOVE_PERMISSION_TRANSACTIONS_PER_SECOND = "REMOVE_PERMISSION_TRANSACTIONS_PER_SECOND"
    LIST_ENDPOINTS_BY_PLATFORM_APPLICATION_TRANSACTIONS_PER_SECOND = "LIST_ENDPOINTS_BY_PLATFORM_APPLICATION_TRANSACTIONS_PER_SECOND"
    LIST_PHONE_NUMBERS_OPTED_OUT_TRANSACTIONS_PER_SECOND = "LIST_PHONE_NUMBERS_OPTED_OUT_TRANSACTIONS_PER_SECOND"
    CHECK_IF_PHONE_NUMBER_IS_OPTED_OUT_TRANSACTIONS_PER_SECOND = "CHECK_IF_PHONE_NUMBER_IS_OPTED_OUT_TRANSACTIONS_PER_SECOND"
    CREATE_PLATFORM_ENDPOINT_TRANSACTIONS_PER_SECOND = "CREATE_PLATFORM_ENDPOINT_TRANSACTIONS_PER_SECOND"
    GET_TOPIC_ATTRIBUTES_TRANSACTIONS_PER_SECOND = "GET_TOPIC_ATTRIBUTES_TRANSACTIONS_PER_SECOND"
    CONFIRM_SUBSCRIPTION_TRANSACTIONS_PER_SECOND = "CONFIRM_SUBSCRIPTION_TRANSACTIONS_PER_SECOND"
    GET_SUBSCRIPTION_ATTRIBUTES_TRANSACTIONS_PER_SECOND = "GET_SUBSCRIPTION_ATTRIBUTES_TRANSACTIONS_PER_SECOND"
    OPT_IN_PHONE_NUMBER_TRANSACTIONS_PER_SECOND = "OPT_IN_PHONE_NUMBER_TRANSACTIONS_PER_SECOND"
    GET_ENDPOINT_ATTRIBUTES_TRANSACTIONS_PER_SECOND = "GET_ENDPOINT_ATTRIBUTES_TRANSACTIONS_PER_SECOND"
    DELETE_ENDPOINT_TRANSACTIONS_PER_SECOND = "DELETE_ENDPOINT_TRANSACTIONS_PER_SECOND"
    SMS_MESSAGE_SPENDING_IN_USD = "SMS_MESSAGE_SPENDING_IN_USD"
    TRANSACTIONAL_SMS_MESSAGE_DELIVERY_RATE_PER_SECOND = "TRANSACTIONAL_SMS_MESSAGE_DELIVERY_RATE_PER_SECOND"
    EMAIL_DELIVERY_RATE_PER_SECOND = "EMAIL_DELIVERY_RATE_PER_SECOND"
    PROMOTIONAL_SMS_MESSAGE_DELIVERY_RATE_PER_SECOND = "PROMOTIONAL_SMS_MESSAGE_DELIVERY_RATE_PER_SECOND"


@jsii.enum(
    jsii_type="@reapit-cdk/service-quotas.AmazonSimpleQueueServiceAmazonSqsQuota"
)
class AmazonSimpleQueueServiceAmazonSqsQuota(enum.Enum):
    ATTRIBUTES_PER_MESSAGE = "ATTRIBUTES_PER_MESSAGE"
    TAGS_PER_QUEUE = "TAGS_PER_QUEUE"
    UTF_8_QUEUE_TAG_VALUE_LENGTH = "UTF_8_QUEUE_TAG_VALUE_LENGTH"
    CONDITIONS_PER_QUEUE_POLICY = "CONDITIONS_PER_QUEUE_POLICY"
    MESSAGES_PER_BATCH = "MESSAGES_PER_BATCH"
    STATEMENTS_PER_QUEUE_POLICY = "STATEMENTS_PER_QUEUE_POLICY"
    PRINCIPALS_PER_QUEUE_POLICY = "PRINCIPALS_PER_QUEUE_POLICY"
    QUEUE_NAME_LENGTH = "QUEUE_NAME_LENGTH"
    UTF_8_QUEUE_TAG_KEY_LENGTH = "UTF_8_QUEUE_TAG_KEY_LENGTH"
    MESSAGE_SIZE = "MESSAGE_SIZE"
    MESSAGE_RETENTION_TIME = "MESSAGE_RETENTION_TIME"
    UNBATCHED_MESSAGE_THROUGHPUT_FOR_FIFO_QUEUES = "UNBATCHED_MESSAGE_THROUGHPUT_FOR_FIFO_QUEUES"
    BATCHED_MESSAGE_THROUGHPUT_FOR_FIFO_QUEUES = "BATCHED_MESSAGE_THROUGHPUT_FOR_FIFO_QUEUES"
    MESSAGE_SIZE_IN_S3_BUCKET = "MESSAGE_SIZE_IN_S3_BUCKET"
    BATCHED_MESSAGE_ID_LENGTH = "BATCHED_MESSAGE_ID_LENGTH"
    MESSAGE_INVISIBILITY_PERIOD = "MESSAGE_INVISIBILITY_PERIOD"
    ACTIONS_PER_QUEUE_POLICY = "ACTIONS_PER_QUEUE_POLICY"
    QUEUE_POLICY_SIZE = "QUEUE_POLICY_SIZE"
    IN_FLIGHT_MESSAGES_PER_FIFO_QUEUE = "IN_FLIGHT_MESSAGES_PER_FIFO_QUEUE"
    IN_FLIGHT_MESSAGES_PER_STANDARD_QUEUE = "IN_FLIGHT_MESSAGES_PER_STANDARD_QUEUE"
    QUEUE_DELIVERY_DELAY = "QUEUE_DELIVERY_DELAY"


@jsii.enum(
    jsii_type="@reapit-cdk/service-quotas.AmazonSimpleStorageServiceAmazonS3Quota"
)
class AmazonSimpleStorageServiceAmazonS3Quota(enum.Enum):
    EVENT_NOTIFICATIONS = "EVENT_NOTIFICATIONS"
    S3_GLACIER_RETRIEVAL_REQUEST_RATE_PER_SECOND = "S3_GLACIER_RETRIEVAL_REQUEST_RATE_PER_SECOND"
    OBJECT_SIZE_CONSOLE_UPLOAD = "OBJECT_SIZE_CONSOLE_UPLOAD"
    PARTS = "PARTS"
    DIRECTORY_BUCKETS = "DIRECTORY_BUCKETS"
    S3_GLACIER_NUMBER_OF_RANDOM_RESTORE_REQUESTS = "S3_GLACIER_NUMBER_OF_RANDOM_RESTORE_REQUESTS"
    GENERAL_PURPOSE_BUCKETS = "GENERAL_PURPOSE_BUCKETS"
    MULTI_REGION_ACCESS_POINT_REGIONS = "MULTI_REGION_ACCESS_POINT_REGIONS"
    MINIMUM_PART_SIZE = "MINIMUM_PART_SIZE"
    REPLICATION_RULES = "REPLICATION_RULES"
    BUCKET_TAGS = "BUCKET_TAGS"
    MAXIMUM_PART_SIZE = "MAXIMUM_PART_SIZE"
    BUCKET_POLICY = "BUCKET_POLICY"
    REPLICATION_DESTINATIONS = "REPLICATION_DESTINATIONS"
    MULTI_REGION_ACCESS_POINTS = "MULTI_REGION_ACCESS_POINTS"
    S3_GLACIER_PROVISIONED_CAPACITY_UNITS = "S3_GLACIER_PROVISIONED_CAPACITY_UNITS"
    REPLICATION_TRANSFER_RATE = "REPLICATION_TRANSFER_RATE"
    OBJECT_TAGS = "OBJECT_TAGS"
    ACCESS_POINTS = "ACCESS_POINTS"
    LIFECYCLE_RULES = "LIFECYCLE_RULES"
    OBJECT_SIZE = "OBJECT_SIZE"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AmazonSimpleWorkflowServiceQuota")
class AmazonSimpleWorkflowServiceQuota(enum.Enum):
    SWF_TASK_RETENTION_TIME_IN_QUEUE = "SWF_TASK_RETENTION_TIME_IN_QUEUE"
    UNTAG_RESOURCE_THROTTLE_BURST_LIMIT_IN_TRANSACTIONS_PER_SECOND = "UNTAG_RESOURCE_THROTTLE_BURST_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    LIST_TAGS_FOR_RESOURCE_THROTTLE_BURST_LIMIT_IN_TRANSACTIONS_PER_SECOND = "LIST_TAGS_FOR_RESOURCE_THROTTLE_BURST_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    REGISTERED_DOMAINS = "REGISTERED_DOMAINS"
    UNDEPRECATE_WORKFLOW_TYPE_THROTTLE_REFILL_LIMIT_IN_TRANSACTIONS_PER_SECOND = "UNDEPRECATE_WORKFLOW_TYPE_THROTTLE_REFILL_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    GET_WORKFLOW_EXECUTION_HISTORY_THROTTLE_BURST_LIMIT_IN_TRANSACTIONS_PER_SECOND = "GET_WORKFLOW_EXECUTION_HISTORY_THROTTLE_BURST_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    UNDEPRECATE_ACTIVITY_TYPE_THROTTLE_BURST_LIMIT_IN_TRANSACTIONS_PER_SECOND = "UNDEPRECATE_ACTIVITY_TYPE_THROTTLE_BURST_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    UNTAG_RESOURCE_THROTTLE_REFILL_LIMIT_IN_TRANSACTIONS_PER_SECOND = "UNTAG_RESOURCE_THROTTLE_REFILL_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    START_WORKFLOW_EXECUTION_THROTTLE_REFILL_LIMIT_IN_TRANSACTIONS_PER_SECOND = "START_WORKFLOW_EXECUTION_THROTTLE_REFILL_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    SIGNAL_WORKFLOW_EXECUTION_THROTTLE_BURST_LIMIT_IN_TRANSACTIONS_PER_SECOND = "SIGNAL_WORKFLOW_EXECUTION_THROTTLE_BURST_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    UNDEPRECATE_DOMAIN_THROTTLE_BURST_LIMIT_IN_TRANSACTIONS_PER_SECOND = "UNDEPRECATE_DOMAIN_THROTTLE_BURST_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    LIST_OPEN_WORKFLOW_EXECUTIONS_THROTTLE_BURST_LIMIT_IN_TRANSACTIONS_PER_SECOND = "LIST_OPEN_WORKFLOW_EXECUTIONS_THROTTLE_BURST_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    RESPOND_ACTIVITY_TASK_COMPLETED_THROTTLE_BURST_LIMIT_IN_TRANSACTIONS_PER_SECOND = "RESPOND_ACTIVITY_TASK_COMPLETED_THROTTLE_BURST_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    LIST_DOMAINS_THROTTLE_REFILL_LIMIT_IN_TRANSACTIONS_PER_SECOND = "LIST_DOMAINS_THROTTLE_REFILL_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    COUNT_PENDING_ACTIVITY_TASKS_THROTTLE_REFILL_LIMIT_IN_TRANSACTIONS_PER_SECOND = "COUNT_PENDING_ACTIVITY_TASKS_THROTTLE_REFILL_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    RESPOND_ACTIVITY_TASK_FAILED_THROTTLE_BURST_LIMIT_IN_TRANSACTIONS_PER_SECOND = "RESPOND_ACTIVITY_TASK_FAILED_THROTTLE_BURST_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    LIST_TAGS_FOR_RESOURCE_THROTTLE_REFILL_LIMIT_IN_TRANSACTIONS_PER_SECOND = "LIST_TAGS_FOR_RESOURCE_THROTTLE_REFILL_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    POLL_FOR_ACTIVITY_TASK_THROTTLE_REFILL_LIMIT_IN_TRANSACTIONS_PER_SECOND = "POLL_FOR_ACTIVITY_TASK_THROTTLE_REFILL_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    DESCRIBE_DOMAIN_THROTTLE_BURST_LIMIT_IN_TRANSACTIONS_PER_SECOND = "DESCRIBE_DOMAIN_THROTTLE_BURST_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    START_CHILD_WORKFLOW_EXECUTION_THROTTLE_BURST_LIMIT_IN_TRANSACTIONS_PER_SECOND = "START_CHILD_WORKFLOW_EXECUTION_THROTTLE_BURST_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    DESCRIBE_WORKFLOW_EXECUTION_THROTTLE_REFILL_LIMIT_IN_TRANSACTIONS_PER_SECOND = "DESCRIBE_WORKFLOW_EXECUTION_THROTTLE_REFILL_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    LIST_WORKFLOW_TYPES_THROTTLE_BURST_LIMIT_IN_TRANSACTIONS_PER_SECOND = "LIST_WORKFLOW_TYPES_THROTTLE_BURST_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    DEPRECATE_ACTIVITY_TYPE_THROTTLE_BURST_LIMIT_IN_TRANSACTIONS_PER_SECOND = "DEPRECATE_ACTIVITY_TYPE_THROTTLE_BURST_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    TAG_RESOURCE_THROTTLE_REFILL_LIMIT_IN_TRANSACTIONS_PER_SECOND = "TAG_RESOURCE_THROTTLE_REFILL_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    LIST_CLOSED_WORKFLOW_EXECUTIONS_THROTTLE_BURST_LIMIT_IN_TRANSACTIONS_PER_SECOND = "LIST_CLOSED_WORKFLOW_EXECUTIONS_THROTTLE_BURST_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    DESCRIBE_WORKFLOW_TYPE_THROTTLE_BURST_LIMIT_IN_TRANSACTIONS_PER_SECOND = "DESCRIBE_WORKFLOW_TYPE_THROTTLE_BURST_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    UNDEPRECATE_DOMAIN_THROTTLE_REFILL_LIMIT_IN_TRANSACTIONS_PER_SECOND = "UNDEPRECATE_DOMAIN_THROTTLE_REFILL_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    REGISTER_WORKFLOW_TYPE_THROTTLE_REFILL_LIMIT_IN_TRANSACTIONS_PER_SECOND = "REGISTER_WORKFLOW_TYPE_THROTTLE_REFILL_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    REGISTER_DOMAIN_THROTTLE_BURST_LIMIT_IN_TRANSACTIONS_PER_SECOND = "REGISTER_DOMAIN_THROTTLE_BURST_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    RESPOND_DECISION_TASK_COMPLETED_THROTTLE_BURST_LIMIT_IN_TRANSACTIONS_PER_SECOND = "RESPOND_DECISION_TASK_COMPLETED_THROTTLE_BURST_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    SCHEDULE_ACTIVITY_TASK_THROTTLE_BURST_LIMIT_IN_TRANSACTIONS_PER_SECOND = "SCHEDULE_ACTIVITY_TASK_THROTTLE_BURST_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    DEPRECATE_WORKFLOW_TYPE_THROTTLE_REFILL_LIMIT_IN_TRANSACTIONS_PER_SECOND = "DEPRECATE_WORKFLOW_TYPE_THROTTLE_REFILL_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    WORKFLOW_EXECUTION_IDLE_TIME = "WORKFLOW_EXECUTION_IDLE_TIME"
    WORKFLOW_EXECUTION_TIME = "WORKFLOW_EXECUTION_TIME"
    OPEN_WORKFLOW_EXECUTIONS_PER_DOMAIN = "OPEN_WORKFLOW_EXECUTIONS_PER_DOMAIN"
    LIST_WORKFLOW_TYPES_THROTTLE_REFILL_LIMIT_IN_TRANSACTIONS_PER_SECOND = "LIST_WORKFLOW_TYPES_THROTTLE_REFILL_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    START_TIMER_THROTTLE_BURST_LIMIT_IN_TRANSACTIONS_PER_SECOND = "START_TIMER_THROTTLE_BURST_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    RESPOND_ACTIVITY_TASK_FAILED_THROTTLE_REFILL_LIMIT_IN_TRANSACTIONS_PER_SECOND = "RESPOND_ACTIVITY_TASK_FAILED_THROTTLE_REFILL_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    GET_WORKFLOW_EXECUTION_HISTORY_THROTTLE_REFILL_LIMIT_IN_TRANSACTIONS_PER_SECOND = "GET_WORKFLOW_EXECUTION_HISTORY_THROTTLE_REFILL_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    COUNT_PENDING_DECISION_TASKS_THROTTLE_REFILL_LIMIT_IN_TRANSACTIONS_PER_SECOND = "COUNT_PENDING_DECISION_TASKS_THROTTLE_REFILL_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    POLL_FOR_ACTIVITY_TASK_THROTTLE_BURST_LIMIT_IN_TRANSACTIONS_PER_SECOND = "POLL_FOR_ACTIVITY_TASK_THROTTLE_BURST_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    DESCRIBE_ACTIVITY_TYPE_THROTTLE_BURST_LIMIT_IN_TRANSACTIONS_PER_SECOND = "DESCRIBE_ACTIVITY_TYPE_THROTTLE_BURST_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    START_WORKFLOW_EXECUTION_THROTTLE_BURST_LIMIT_IN_TRANSACTIONS_PER_SECOND = "START_WORKFLOW_EXECUTION_THROTTLE_BURST_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    REQUEST_CANCEL_EXTERNAL_WORKFLOW_EXECUTION_THROTTLE_BURST_LIMIT_IN_TRANSACTIONS_PER_SECOND = "REQUEST_CANCEL_EXTERNAL_WORKFLOW_EXECUTION_THROTTLE_BURST_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    SCHEDULE_ACTIVITY_TASK_THROTTLE_REFILL_LIMIT_IN_TRANSACTIONS_PER_SECOND = "SCHEDULE_ACTIVITY_TASK_THROTTLE_REFILL_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    DESCRIBE_ACTIVITY_TYPE_THROTTLE_REFILL_LIMIT_IN_TRANSACTIONS_PER_SECOND = "DESCRIBE_ACTIVITY_TYPE_THROTTLE_REFILL_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    REGISTER_ACTIVITY_TYPE_THROTTLE_BURST_LIMIT_IN_TRANSACTIONS_PER_SECOND = "REGISTER_ACTIVITY_TYPE_THROTTLE_BURST_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    WORKFLOW_AND_ACTIVITY_TYPES_PER_DOMAIN = "WORKFLOW_AND_ACTIVITY_TYPES_PER_DOMAIN"
    REQUEST_CANCEL_WORKFLOW_EXECUTION_THROTTLE_REFILL_LIMIT_IN_TRANSACTIONS_PER_SECOND = "REQUEST_CANCEL_WORKFLOW_EXECUTION_THROTTLE_REFILL_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    TERMINATE_WORKFLOW_EXECUTION_THROTTLE_REFILL_LIMIT_IN_TRANSACTIONS_PER_SECOND = "TERMINATE_WORKFLOW_EXECUTION_THROTTLE_REFILL_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    WORKFLOW_RETENTION_TIME = "WORKFLOW_RETENTION_TIME"
    SIGNAL_WORKFLOW_EXECUTION_THROTTLE_REFILL_LIMIT_IN_TRANSACTIONS_PER_SECOND = "SIGNAL_WORKFLOW_EXECUTION_THROTTLE_REFILL_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    OPEN_ACTIVITY_TASKS_PER_WORKFLOW_EXECUTION = "OPEN_ACTIVITY_TASKS_PER_WORKFLOW_EXECUTION"
    DEPRECATE_DOMAIN_THROTTLE_REFILL_LIMIT_IN_TRANSACTIONS_PER_SECOND = "DEPRECATE_DOMAIN_THROTTLE_REFILL_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    DESCRIBE_WORKFLOW_EXECUTION_THROTTLE_BURST_LIMIT_IN_TRANSACTIONS_PER_SECOND = "DESCRIBE_WORKFLOW_EXECUTION_THROTTLE_BURST_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    COUNT_CLOSED_WORKFLOW_EXECUTIONS_THROTTLE_REFILL_LIMIT_IN_TRANSACTIONS_PER_SECOND = "COUNT_CLOSED_WORKFLOW_EXECUTIONS_THROTTLE_REFILL_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    OPEN_CHILD_WORKFLOW_EXECUTIONS = "OPEN_CHILD_WORKFLOW_EXECUTIONS"
    COUNT_CLOSED_WORKFLOW_EXECUTIONS_THROTTLE_BURST_LIMIT_IN_TRANSACTIONS_PER_SECOND = "COUNT_CLOSED_WORKFLOW_EXECUTIONS_THROTTLE_BURST_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    POLL_FOR_DECISION_TASK_THROTTLE_BURST_LIMIT_IN_TRANSACTIONS_PER_SECOND = "POLL_FOR_DECISION_TASK_THROTTLE_BURST_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    COUNT_OPEN_WORKFLOW_EXECUTIONS_THROTTLE_REFILL_LIMIT_IN_TRANSACTIONS_PER_SECOND = "COUNT_OPEN_WORKFLOW_EXECUTIONS_THROTTLE_REFILL_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    REQUEST_CANCEL_WORKFLOW_EXECUTION_THROTTLE_BURST_LIMIT_IN_TRANSACTIONS_PER_SECOND = "REQUEST_CANCEL_WORKFLOW_EXECUTION_THROTTLE_BURST_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    RECORD_ACTIVITY_TASK_HEARTBEAT_THROTTLE_BURST_LIMIT_IN_TRANSACTIONS_PER_SECOND = "RECORD_ACTIVITY_TASK_HEARTBEAT_THROTTLE_BURST_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    SIGNAL_EXTERNAL_WORKFLOW_EXECUTION_THROTTLE_REFILL_LIMIT_IN_TRANSACTIONS_PER_SECOND = "SIGNAL_EXTERNAL_WORKFLOW_EXECUTION_THROTTLE_REFILL_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    LIST_OPEN_WORKFLOW_EXECUTIONS_THROTTLE_REFILL_LIMIT_IN_TRANSACTIONS_PER_SECOND = "LIST_OPEN_WORKFLOW_EXECUTIONS_THROTTLE_REFILL_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    LIST_ACTIVITY_TYPES_THROTTLE_BURST_LIMIT_IN_TRANSACTIONS_PER_SECOND = "LIST_ACTIVITY_TYPES_THROTTLE_BURST_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    POLL_FOR_DECISION_TASK_THROTTLE_REFILL_LIMIT_IN_TRANSACTIONS_PER_SECOND = "POLL_FOR_DECISION_TASK_THROTTLE_REFILL_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    INPUT_OR_OUTPUT_RESULT_DATA_SIZE = "INPUT_OR_OUTPUT_RESULT_DATA_SIZE"
    DESCRIBE_WORKFLOW_TYPE_THROTTLE_REFILL_LIMIT_IN_TRANSACTIONS_PER_SECOND = "DESCRIBE_WORKFLOW_TYPE_THROTTLE_REFILL_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    RESPOND_DECISION_TASK_COMPLETED_THROTTLE_REFILL_LIMIT_IN_TRANSACTIONS_PER_SECOND = "RESPOND_DECISION_TASK_COMPLETED_THROTTLE_REFILL_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    COUNT_PENDING_DECISION_TASKS_THROTTLE_BURST_LIMIT_IN_TRANSACTIONS_PER_SECOND = "COUNT_PENDING_DECISION_TASKS_THROTTLE_BURST_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    TAG_RESOURCE_THROTTLE_BURST_LIMIT_IN_TRANSACTIONS_PER_SECOND = "TAG_RESOURCE_THROTTLE_BURST_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    RESPOND_ACTIVITY_TASK_CANCELED_THROTTLE_REFILL_LIMIT_IN_TRANSACTIONS_PER_SECOND = "RESPOND_ACTIVITY_TASK_CANCELED_THROTTLE_REFILL_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    RESPOND_ACTIVITY_TASK_CANCELED_THROTTLE_BURST_LIMIT_IN_TRANSACTIONS_PER_SECOND = "RESPOND_ACTIVITY_TASK_CANCELED_THROTTLE_BURST_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    REQUEST_CANCEL_EXTERNAL_WORKFLOW_EXECUTION_THROTTLE_REFILL_LIMIT_IN_TRANSACTIONS_PER_SECOND = "REQUEST_CANCEL_EXTERNAL_WORKFLOW_EXECUTION_THROTTLE_REFILL_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    RECORD_ACTIVITY_TASK_HEARTBEAT_THROTTLE_REFILL_LIMIT_IN_TRANSACTIONS_PER_SECOND = "RECORD_ACTIVITY_TASK_HEARTBEAT_THROTTLE_REFILL_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    START_CHILD_WORKFLOW_EXECUTION_THROTTLE_REFILL_LIMIT_IN_TRANSACTIONS_PER_SECOND = "START_CHILD_WORKFLOW_EXECUTION_THROTTLE_REFILL_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    OPEN_TIMERS_PER_WORKFLOW_EXECUTION = "OPEN_TIMERS_PER_WORKFLOW_EXECUTION"
    REGISTER_ACTIVITY_TYPE_THROTTLE_REFILL_LIMIT_IN_TRANSACTIONS_PER_SECOND = "REGISTER_ACTIVITY_TYPE_THROTTLE_REFILL_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    UNDEPRECATE_ACTIVITY_TYPE_THROTTLE_REFILL_LIMIT_IN_TRANSACTIONS_PER_SECOND = "UNDEPRECATE_ACTIVITY_TYPE_THROTTLE_REFILL_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    REQUEST_SIZE = "REQUEST_SIZE"
    REGISTER_WORKFLOW_TYPE_THROTTLE_BURST_LIMIT_IN_TRANSACTIONS_PER_SECOND = "REGISTER_WORKFLOW_TYPE_THROTTLE_BURST_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    DEPRECATE_WORKFLOW_TYPE_THROTTLE_BURST_LIMIT_IN_TRANSACTIONS_PER_SECOND = "DEPRECATE_WORKFLOW_TYPE_THROTTLE_BURST_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    START_TIMER_THROTTLE_REFILL_LIMIT_IN_TRANSACTIONS_PER_SECOND = "START_TIMER_THROTTLE_REFILL_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    REGISTER_DOMAIN_THROTTLE_REFILL_LIMIT_IN_TRANSACTIONS_PER_SECOND = "REGISTER_DOMAIN_THROTTLE_REFILL_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    TASK_EXECUTION_TIME_IN_YEAR = "TASK_EXECUTION_TIME_IN_YEAR"
    DEPRECATE_DOMAIN_THROTTLE_BURST_LIMIT_IN_TRANSACTIONS_PER_SECOND = "DEPRECATE_DOMAIN_THROTTLE_BURST_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    COUNT_PENDING_ACTIVITY_TASKS_THROTTLE_BURST_LIMIT_IN_TRANSACTIONS_PER_SECOND = "COUNT_PENDING_ACTIVITY_TASKS_THROTTLE_BURST_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    LIST_ACTIVITY_TYPES_THROTTLE_REFILL_LIMIT_IN_TRANSACTIONS_PER_SECOND = "LIST_ACTIVITY_TYPES_THROTTLE_REFILL_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    UNDEPRECATE_WORKFLOW_TYPE_THROTTLE_BURST_LIMIT_IN_TRANSACTIONS_PER_SECOND = "UNDEPRECATE_WORKFLOW_TYPE_THROTTLE_BURST_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    POLLERS_PER_TASK_LIST = "POLLERS_PER_TASK_LIST"
    EVENTS_IN_WORKFLOW_EXECUTION_HISTORY = "EVENTS_IN_WORKFLOW_EXECUTION_HISTORY"
    LIST_CLOSED_WORKFLOW_EXECUTIONS_THROTTLE_REFILL_LIMIT_IN_TRANSACTIONS_PER_SECOND = "LIST_CLOSED_WORKFLOW_EXECUTIONS_THROTTLE_REFILL_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    RESPOND_ACTIVITY_TASK_COMPLETED_THROTTLE_REFILL_LIMIT_IN_TRANSACTIONS_PER_SECOND = "RESPOND_ACTIVITY_TASK_COMPLETED_THROTTLE_REFILL_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    TERMINATE_WORKFLOW_EXECUTION_THROTTLE_BURST_LIMIT_IN_TRANSACTIONS_PER_SECOND = "TERMINATE_WORKFLOW_EXECUTION_THROTTLE_BURST_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    COUNT_OPEN_WORKFLOW_EXECUTIONS_THROTTLE_BURST_LIMIT_IN_TRANSACTIONS_PER_SECOND = "COUNT_OPEN_WORKFLOW_EXECUTIONS_THROTTLE_BURST_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    DESCRIBE_DOMAIN_THROTTLE_REFILL_LIMIT_IN_TRANSACTIONS_PER_SECOND = "DESCRIBE_DOMAIN_THROTTLE_REFILL_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    DEPRECATE_ACTIVITY_TYPE_THROTTLE_REFILL_LIMIT_IN_TRANSACTIONS_PER_SECOND = "DEPRECATE_ACTIVITY_TYPE_THROTTLE_REFILL_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    SIGNAL_EXTERNAL_WORKFLOW_EXECUTION_THROTTLE_BURST_LIMIT_IN_TRANSACTIONS_PER_SECOND = "SIGNAL_EXTERNAL_WORKFLOW_EXECUTION_THROTTLE_BURST_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    LIST_DOMAINS_THROTTLE_BURST_LIMIT_IN_TRANSACTIONS_PER_SECOND = "LIST_DOMAINS_THROTTLE_BURST_LIMIT_IN_TRANSACTIONS_PER_SECOND"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AmazonTextractQuota")
class AmazonTextractQuota(enum.Enum):
    ASYNC_DOCUMENT_TEXT_DETECTION_THROTTLE_LIMIT_FOR_MAX_NUMBER_OF_CONCURRENT_JOBS = "ASYNC_DOCUMENT_TEXT_DETECTION_THROTTLE_LIMIT_FOR_MAX_NUMBER_OF_CONCURRENT_JOBS"
    GET_LENDING_ANALYSIS_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "GET_LENDING_ANALYSIS_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    ASYNC_DOCUMENT_ANALYSIS_THROTTLE_LIMIT_FOR_MAX_NUMBER_OF_CONCURRENT_JOBS = "ASYNC_DOCUMENT_ANALYSIS_THROTTLE_LIMIT_FOR_MAX_NUMBER_OF_CONCURRENT_JOBS"
    CREATE_ADAPTER_VERSION_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "CREATE_ADAPTER_VERSION_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    START_DOCUMENT_ANALYSIS_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "START_DOCUMENT_ANALYSIS_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    UPDATE_ADAPTER_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "UPDATE_ADAPTER_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    CREATE_ADAPTER_VERSION_THROTTLE_LIMIT_FOR_MAX_NUMBER_OF_IN_PROGRESS_ADAPTER_VERSIONS_PER_ACCOUNT = "CREATE_ADAPTER_VERSION_THROTTLE_LIMIT_FOR_MAX_NUMBER_OF_IN_PROGRESS_ADAPTER_VERSIONS_PER_ACCOUNT"
    GET_EXPENSE_ANALYSIS_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "GET_EXPENSE_ANALYSIS_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    UNTAG_RESOURCE_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "UNTAG_RESOURCE_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    ASYNC_EXPENSE_ANALYSIS_THROTTLE_LIMIT_FOR_MAX_NUMBER_OF_CONCURRENT_JOBS = "ASYNC_EXPENSE_ANALYSIS_THROTTLE_LIMIT_FOR_MAX_NUMBER_OF_CONCURRENT_JOBS"
    GET_LENDING_ANALYSIS_SUMMARY_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "GET_LENDING_ANALYSIS_SUMMARY_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    GET_ADAPTER_VERSION_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "GET_ADAPTER_VERSION_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    ANALYZE_ID_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "ANALYZE_ID_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    CREATE_ADAPTER_THROTTLE_LIMIT_FOR_MAX_NUMBER_OF_ADAPTERS_PER_ACCOUNT = "CREATE_ADAPTER_THROTTLE_LIMIT_FOR_MAX_NUMBER_OF_ADAPTERS_PER_ACCOUNT"
    START_EXPENSE_ANALYSIS_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "START_EXPENSE_ANALYSIS_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    DETECT_DOCUMENT_TEXT_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "DETECT_DOCUMENT_TEXT_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    GET_ADAPTER_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "GET_ADAPTER_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    GET_DOCUMENT_TEXT_DETECTION_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "GET_DOCUMENT_TEXT_DETECTION_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    ASYNC_LENDING_ANALYSIS_THROTTLE_LIMIT_FOR_MAX_NUMBER_OF_CONCURRENT_JOBS = "ASYNC_LENDING_ANALYSIS_THROTTLE_LIMIT_FOR_MAX_NUMBER_OF_CONCURRENT_JOBS"
    DELETE_ADAPTER_VERSION_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "DELETE_ADAPTER_VERSION_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    CREATE_ADAPTER_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "CREATE_ADAPTER_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    LIST_ADAPTER_VERSIONS_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "LIST_ADAPTER_VERSIONS_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    ANALYZE_DOCUMENT_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "ANALYZE_DOCUMENT_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    ANALYZE_EXPENSE_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "ANALYZE_EXPENSE_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    START_LENDING_ANALYSIS_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "START_LENDING_ANALYSIS_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    CREATE_ADAPTER_VERSION_THROTTLE_LIMIT_FOR_MAX_NUMBER_OF_NEW_SUCCESSFUL_ADAPTER_VERSIONS_PER_MONTH = "CREATE_ADAPTER_VERSION_THROTTLE_LIMIT_FOR_MAX_NUMBER_OF_NEW_SUCCESSFUL_ADAPTER_VERSIONS_PER_MONTH"
    DELETE_ADAPTER_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "DELETE_ADAPTER_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    LIST_ADAPTERS_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "LIST_ADAPTERS_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    START_DOCUMENT_TEXT_DETECTION_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "START_DOCUMENT_TEXT_DETECTION_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    GET_DOCUMENT_ANALYSIS_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "GET_DOCUMENT_ANALYSIS_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    TAG_RESOURCE_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "TAG_RESOURCE_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"
    LIST_TAGS_FOR_RESOURCE_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND = "LIST_TAGS_FOR_RESOURCE_THROTTLE_LIMIT_IN_TRANSACTIONS_PER_SECOND"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AmazonTimestreamQuota")
class AmazonTimestreamQuota(enum.Enum):
    COMPOSITE_PARTITION_KEY_ATTRIBUTES_PER_TABLE = "COMPOSITE_PARTITION_KEY_ATTRIBUTES_PER_TABLE"
    DIMENSIONS_PER_TABLE = "DIMENSIONS_PER_TABLE"
    TABLES_PER_ACCOUNT = "TABLES_PER_ACCOUNT"
    MEASURES_PER_TABLE = "MEASURES_PER_TABLE"
    MEASURES_PER_MULTI_MEASURE_RECORD = "MEASURES_PER_MULTI_MEASURE_RECORD"
    FUTURE_INGESTION_PERIOD_IN_MINUTES = "FUTURE_INGESTION_PERIOD_IN_MINUTES"
    MAXIMUM_RETENTION_PERIOD_FOR_MAGNETIC_STORE_IN_DAYS = "MAXIMUM_RETENTION_PERIOD_FOR_MAGNETIC_STORE_IN_DAYS"
    DATABASE_NAME_LENGTH = "DATABASE_NAME_LENGTH"
    MINIMUM_RETENTION_PERIOD_FOR_MEMORY_STORE_IN_HOURS = "MINIMUM_RETENTION_PERIOD_FOR_MEMORY_STORE_IN_HOURS"
    MEASURE_NAME_LENGTH = "MEASURE_NAME_LENGTH"
    THROTTLE_RATE_FOR_CRUD_AP_IS = "THROTTLE_RATE_FOR_CRUD_AP_IS"
    MINIMUM_RETENTION_PERIOD_FOR_MAGNETIC_STORE_IN_DAYS = "MINIMUM_RETENTION_PERIOD_FOR_MAGNETIC_STORE_IN_DAYS"
    DIMENSION_NAME_DIMENSION_VALUE_PAIR_SIZE_PER_SERIES = "DIMENSION_NAME_DIMENSION_VALUE_PAIR_SIZE_PER_SERIES"
    RECORDS_PER_WRITE_RECORDS_API_REQUEST = "RECORDS_PER_WRITE_RECORDS_API_REQUEST"
    DATA_SIZE_FOR_QUERY_RESULT = "DATA_SIZE_FOR_QUERY_RESULT"
    MAXIMUM_RETENTION_PERIOD_FOR_MEMORY_STORE_IN_HOURS = "MAXIMUM_RETENTION_PERIOD_FOR_MEMORY_STORE_IN_HOURS"
    METADATA_SIZE_FOR_QUERY_RESULT = "METADATA_SIZE_FOR_QUERY_RESULT"
    UNIQUE_MEASURES_ACROSS_MULTI_MEASURE_RECORDS_PER_TABLE = "UNIQUE_MEASURES_ACROSS_MULTI_MEASURE_RECORDS_PER_TABLE"
    EXECUTION_DURATION_FOR_QUERIES_IN_HOURS = "EXECUTION_DURATION_FOR_QUERIES_IN_HOURS"
    MAXIMUM_COUNT_OF_ACTIVE_MAGNETIC_STORE_PARTITIONS_PER_DATABASE = "MAXIMUM_COUNT_OF_ACTIVE_MAGNETIC_STORE_PARTITIONS_PER_DATABASE"
    SCHEDULED_QUERIES_PER_ACCOUNT = "SCHEDULED_QUERIES_PER_ACCOUNT"
    TABLE_NAME_LENGTH = "TABLE_NAME_LENGTH"
    DIMENSION_NAME_LENGTH = "DIMENSION_NAME_LENGTH"
    QUERY_STRING_LENGTH_IN_KI_B = "QUERY_STRING_LENGTH_IN_KI_B"
    MEASURE_VALUE_SIZE_PER_MULTI_MEASURE_RECORD = "MEASURE_VALUE_SIZE_PER_MULTI_MEASURE_RECORD"
    DATABASES_PER_ACCOUNT = "DATABASES_PER_ACCOUNT"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AmazonTranscribeQuota")
class AmazonTranscribeQuota(enum.Enum):
    MAXIMUM_AUDIO_FILE_SIZE_FOR_MEDICAL_SCRIBE_JOBS = "MAXIMUM_AUDIO_FILE_SIZE_FOR_MEDICAL_SCRIBE_JOBS"
    MAXIMUM_AUDIO_FILE_LENGTH_FOR_MEDICAL_SCRIBE_JOBS = "MAXIMUM_AUDIO_FILE_LENGTH_FOR_MEDICAL_SCRIBE_JOBS"
    TRANSACTIONS_PER_SECOND_START_CALL_ANALYTICS_STREAM_TRANSCRIPTION_WEBSOCKET_OPERATION = "TRANSACTIONS_PER_SECOND_START_CALL_ANALYTICS_STREAM_TRANSCRIPTION_WEBSOCKET_OPERATION"
    TRANSACTIONS_PER_SECOND_START_CALL_ANALYTICS_STREAM_TRANSCRIPTION_OPERATION = "TRANSACTIONS_PER_SECOND_START_CALL_ANALYTICS_STREAM_TRANSCRIPTION_OPERATION"
    TRANSACTIONS_PER_SECOND_LIST_CALL_ANALYTICS_CATEGORIES_OPERATION = "TRANSACTIONS_PER_SECOND_LIST_CALL_ANALYTICS_CATEGORIES_OPERATION"
    TRANSACTIONS_PER_SECOND_DELETE_VOCABULARY_OPERATION = "TRANSACTIONS_PER_SECOND_DELETE_VOCABULARY_OPERATION"
    TRANSACTIONS_PER_SECOND_DELETE_MEDICAL_SCRIBE_JOB_OPERATION = "TRANSACTIONS_PER_SECOND_DELETE_MEDICAL_SCRIBE_JOB_OPERATION"
    NUMBER_OF_CONCURRENT_CALL_ANALYTICS_BATCH_JOBS = "NUMBER_OF_CONCURRENT_CALL_ANALYTICS_BATCH_JOBS"
    THE_NUMBER_OF_CONCURRENT_START_CALL_ANALYTICS_STREAM_TRANSCRIPTION_HTTP_2_STREAMING_REQUESTS = "THE_NUMBER_OF_CONCURRENT_START_CALL_ANALYTICS_STREAM_TRANSCRIPTION_HTTP_2_STREAMING_REQUESTS"
    TRANSACTIONS_PER_SECOND_GET_CALL_ANALYTICS_CATEGORY_OPERATION = "TRANSACTIONS_PER_SECOND_GET_CALL_ANALYTICS_CATEGORY_OPERATION"
    TRANSACTIONS_PER_SECOND_GET_CALL_ANALYTICS_JOB_OPERATION = "TRANSACTIONS_PER_SECOND_GET_CALL_ANALYTICS_JOB_OPERATION"
    MAXIMUM_AUDIO_FILE_SIZE = "MAXIMUM_AUDIO_FILE_SIZE"
    MAXIMUM_AUDIO_FILE_SIZE_MEDICAL = "MAXIMUM_AUDIO_FILE_SIZE_MEDICAL"
    JOB_QUEUE_BANDWIDTH_RATIO = "JOB_QUEUE_BANDWIDTH_RATIO"
    TRANSACTIONS_PER_SECOND_LIST_MEDICAL_VOCABULARIES_OPERATION = "TRANSACTIONS_PER_SECOND_LIST_MEDICAL_VOCABULARIES_OPERATION"
    MAXIMUM_NUMBER_OF_RULES_PER_CATEGORY_FOR_CALL_ANALYTICS_BATCH_JOBS = "MAXIMUM_NUMBER_OF_RULES_PER_CATEGORY_FOR_CALL_ANALYTICS_BATCH_JOBS"
    TRANSACTIONS_PER_SECOND_DELETE_MEDICAL_TRANSCRIPTION_JOB_OPERATION = "TRANSACTIONS_PER_SECOND_DELETE_MEDICAL_TRANSCRIPTION_JOB_OPERATION"
    MAXIMUM_LENGTH_OF_A_CUSTOM_VOCABULARY_PHRASE = "MAXIMUM_LENGTH_OF_A_CUSTOM_VOCABULARY_PHRASE"
    NUMBER_OF_DAYS_THAT_JOB_RECORDS_ARE_RETAINED = "NUMBER_OF_DAYS_THAT_JOB_RECORDS_ARE_RETAINED"
    TRANSACTIONS_PER_SECOND_CREATE_CALL_ANALYTICS_CATEGORY_OPERATION = "TRANSACTIONS_PER_SECOND_CREATE_CALL_ANALYTICS_CATEGORY_OPERATION"
    TRANSACTIONS_PER_SECOND_START_CALL_ANALYTICS_JOB_OPERATION = "TRANSACTIONS_PER_SECOND_START_CALL_ANALYTICS_JOB_OPERATION"
    NUMBER_OF_DAYS_THAT_JOB_RECORDS_ARE_RETAINED_MEDICAL = "NUMBER_OF_DAYS_THAT_JOB_RECORDS_ARE_RETAINED_MEDICAL"
    TRANSACTIONS_PER_SECOND_LIST_TRANSCRIPTION_JOBS_OPERATION = "TRANSACTIONS_PER_SECOND_LIST_TRANSCRIPTION_JOBS_OPERATION"
    NUMBER_OF_CONCURRENT_BATCH_TRANSCRIPTION_JOBS = "NUMBER_OF_CONCURRENT_BATCH_TRANSCRIPTION_JOBS"
    TRANSACTIONS_PER_SECOND_GET_MEDICAL_VOCABULARY_OPERATION = "TRANSACTIONS_PER_SECOND_GET_MEDICAL_VOCABULARY_OPERATION"
    MAXIMUM_NUMBER_OF_VOCABULARY_FILTERS = "MAXIMUM_NUMBER_OF_VOCABULARY_FILTERS"
    TRANSACTIONS_PER_SECOND_UPDATE_MEDICAL_VOCABULARY_OPERATION = "TRANSACTIONS_PER_SECOND_UPDATE_MEDICAL_VOCABULARY_OPERATION"
    MINIMUM_AUDIO_FILE_DURATION_FOR_CALL_ANALYTICS_BATCH_JOBS = "MINIMUM_AUDIO_FILE_DURATION_FOR_CALL_ANALYTICS_BATCH_JOBS"
    NUMBER_OF_CHANNELS_FOR_CHANNEL_IDENTIFICATION_FOR_CALL_ANALYTICS_BATCH_JOBS = "NUMBER_OF_CHANNELS_FOR_CHANNEL_IDENTIFICATION_FOR_CALL_ANALYTICS_BATCH_JOBS"
    MAXIMUM_AUDIO_FILE_LENGTH_MEDICAL = "MAXIMUM_AUDIO_FILE_LENGTH_MEDICAL"
    TOTAL_NUMBER_OF_MEDICAL_VOCABULARIES_PER_ACCOUNT = "TOTAL_NUMBER_OF_MEDICAL_VOCABULARIES_PER_ACCOUNT"
    MAXIMUM_SIZE_OF_A_VOCABULARY_FILTER = "MAXIMUM_SIZE_OF_A_VOCABULARY_FILTER"
    MAXIMUM_AUDIO_FILE_SIZE_FOR_CALL_ANALYTICS_BATCH_JOBS = "MAXIMUM_AUDIO_FILE_SIZE_FOR_CALL_ANALYTICS_BATCH_JOBS"
    TRANSACTIONS_PER_SECOND_DELETE_MEDICAL_VOCABULARY_OPERATION = "TRANSACTIONS_PER_SECOND_DELETE_MEDICAL_VOCABULARY_OPERATION"
    TRANSACTIONS_PER_SECOND_UPDATE_CALL_ANALYTICS_CATEGORY_OPERATION = "TRANSACTIONS_PER_SECOND_UPDATE_CALL_ANALYTICS_CATEGORY_OPERATION"
    TRANSACTIONS_PER_SECOND_START_MEDICAL_TRANSCRIPTION_JOB_OPERATION = "TRANSACTIONS_PER_SECOND_START_MEDICAL_TRANSCRIPTION_JOB_OPERATION"
    TRANSACTIONS_PER_SECOND_START_STREAM_TRANSCRIPTION_OPERATION = "TRANSACTIONS_PER_SECOND_START_STREAM_TRANSCRIPTION_OPERATION"
    MAXIMUM_NUMBER_OF_TARGETS_ALLOWED_PER_CATEGORY_FOR_CALL_ANALYTICS_BATCH_JOBS = "MAXIMUM_NUMBER_OF_TARGETS_ALLOWED_PER_CATEGORY_FOR_CALL_ANALYTICS_BATCH_JOBS"
    TRANSACTIONS_PER_SECOND_LIST_VOCABULARIES_OPERATION = "TRANSACTIONS_PER_SECOND_LIST_VOCABULARIES_OPERATION"
    NUMBER_OF_CONCURRENTLY_TRAINING_CUSTOM_LANGUAGE_MODELS = "NUMBER_OF_CONCURRENTLY_TRAINING_CUSTOM_LANGUAGE_MODELS"
    NUMBER_OF_CONCURRENT_MEDICAL_BATCH_TRANSCRIPTION_JOBS = "NUMBER_OF_CONCURRENT_MEDICAL_BATCH_TRANSCRIPTION_JOBS"
    TRANSACTIONS_PER_SECOND_START_MEDICAL_STREAM_TRANSCRIPTION_OPERATION = "TRANSACTIONS_PER_SECOND_START_MEDICAL_STREAM_TRANSCRIPTION_OPERATION"
    TRANSACTIONS_PER_SECOND_GET_TRANSCRIPTION_JOB_OPERATION = "TRANSACTIONS_PER_SECOND_GET_TRANSCRIPTION_JOB_OPERATION"
    TRANSACTIONS_PER_SECOND_GET_MEDICAL_TRANSCRIPTION_JOB_OPERATION = "TRANSACTIONS_PER_SECOND_GET_MEDICAL_TRANSCRIPTION_JOB_OPERATION"
    TRANSACTIONS_PER_SECOND_GET_MEDICAL_SCRIBE_JOB_OPERATION = "TRANSACTIONS_PER_SECOND_GET_MEDICAL_SCRIBE_JOB_OPERATION"
    NUMBER_OF_DAYS_THAT_JOB_RECORDS_ARE_RETAINED_FOR_CALL_ANALYTICS_BATCH_JOBS = "NUMBER_OF_DAYS_THAT_JOB_RECORDS_ARE_RETAINED_FOR_CALL_ANALYTICS_BATCH_JOBS"
    TRANSACTIONS_PER_SECOND_LIST_MEDICAL_SCRIBE_JOBS_OPERATION = "TRANSACTIONS_PER_SECOND_LIST_MEDICAL_SCRIBE_JOBS_OPERATION"
    MAXIMUM_NUMBER_OF_CATEGORIES_FOR_CALL_ANALYTICS_BATCH_JOBS = "MAXIMUM_NUMBER_OF_CATEGORIES_FOR_CALL_ANALYTICS_BATCH_JOBS"
    TRANSACTIONS_PER_SECOND_GET_VOCABULARY_OPERATION = "TRANSACTIONS_PER_SECOND_GET_VOCABULARY_OPERATION"
    NUMBER_OF_PENDING_MEDICAL_VOCABULARIES = "NUMBER_OF_PENDING_MEDICAL_VOCABULARIES"
    TRANSACTIONS_PER_SECOND_DELETE_CALL_ANALYTICS_JOB_OPERATION = "TRANSACTIONS_PER_SECOND_DELETE_CALL_ANALYTICS_JOB_OPERATION"
    TOTAL_NUMBER_OF_CUSTOM_LANGUAGE_MODELS_PER_ACCOUNT = "TOTAL_NUMBER_OF_CUSTOM_LANGUAGE_MODELS_PER_ACCOUNT"
    NUMBER_OF_START_MEDICAL_STREAM_TRANSCRIPTION_WEBSOCKET_REQUESTS = "NUMBER_OF_START_MEDICAL_STREAM_TRANSCRIPTION_WEBSOCKET_REQUESTS"
    TRANSACTIONS_PER_SECOND_START_MEDICAL_SCRIBE_JOB_OPERATION = "TRANSACTIONS_PER_SECOND_START_MEDICAL_SCRIBE_JOB_OPERATION"
    NUMBER_OF_CHANNELS_FOR_CHANNEL_IDENTIFICATION = "NUMBER_OF_CHANNELS_FOR_CHANNEL_IDENTIFICATION"
    NUMBER_OF_PENDING_VOCABULARIES = "NUMBER_OF_PENDING_VOCABULARIES"
    MINIMUM_AUDIO_FILE_DURATION_MEDICAL = "MINIMUM_AUDIO_FILE_DURATION_MEDICAL"
    TRANSACTIONS_PER_SECOND_START_TRANSCRIPTION_JOB_OPERATION = "TRANSACTIONS_PER_SECOND_START_TRANSCRIPTION_JOB_OPERATION"
    MAXIMUM_AUDIO_FILE_LENGTH = "MAXIMUM_AUDIO_FILE_LENGTH"
    TOTAL_NUMBER_OF_VOCABULARIES_PER_ACCOUNT = "TOTAL_NUMBER_OF_VOCABULARIES_PER_ACCOUNT"
    TRANSACTIONS_PER_SECOND_LIST_MEDICAL_TRANSCRIPTION_JOBS_OPERATION = "TRANSACTIONS_PER_SECOND_LIST_MEDICAL_TRANSCRIPTION_JOBS_OPERATION"
    TRANSACTIONS_PER_SECOND_LIST_CALL_ANALYTICS_JOBS_OPERATION = "TRANSACTIONS_PER_SECOND_LIST_CALL_ANALYTICS_JOBS_OPERATION"
    TRANSACTIONS_PER_SECOND_CREATE_VOCABULARY_OPERATION = "TRANSACTIONS_PER_SECOND_CREATE_VOCABULARY_OPERATION"
    MAXIMUM_AUDIO_FILE_LENGTH_FOR_CALL_ANALYTICS_BATCH_JOBS = "MAXIMUM_AUDIO_FILE_LENGTH_FOR_CALL_ANALYTICS_BATCH_JOBS"
    MAXIMUM_SIZE_OF_A_CUSTOM_VOCABULARY = "MAXIMUM_SIZE_OF_A_CUSTOM_VOCABULARY"
    NUMBER_OF_CHANNELS_FOR_CHANNEL_IDENTIFICATION_MEDICAL = "NUMBER_OF_CHANNELS_FOR_CHANNEL_IDENTIFICATION_MEDICAL"
    TRANSACTIONS_PER_SECOND_UPDATE_VOCABULARY_OPERATION = "TRANSACTIONS_PER_SECOND_UPDATE_VOCABULARY_OPERATION"
    NUMBER_OF_CONCURRENT_MEDICAL_SCRIBE_BATCH_JOBS = "NUMBER_OF_CONCURRENT_MEDICAL_SCRIBE_BATCH_JOBS"
    TRANSACTIONS_PER_SECOND_DELETE_TRANSCRIPTION_JOB_OPERATION = "TRANSACTIONS_PER_SECOND_DELETE_TRANSCRIPTION_JOB_OPERATION"
    TRANSACTIONS_PER_SECOND_DELETE_CALL_ANALYTICS_CATEGORY_OPERATION = "TRANSACTIONS_PER_SECOND_DELETE_CALL_ANALYTICS_CATEGORY_OPERATION"
    NUMBER_OF_CONCURRENT_HTTP_2_STREAMS_FOR_STREAMING_TRANSCRIPTION = "NUMBER_OF_CONCURRENT_HTTP_2_STREAMS_FOR_STREAMING_TRANSCRIPTION"
    NUMBER_OF_START_STREAM_TRANSCRIPTION_WEBSOCKET_REQUESTS = "NUMBER_OF_START_STREAM_TRANSCRIPTION_WEBSOCKET_REQUESTS"
    MINIMUM_AUDIO_FILE_DURATION = "MINIMUM_AUDIO_FILE_DURATION"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AmazonTranslateQuota")
class AmazonTranslateQuota(enum.Enum):
    CONCURRENT_BATCH_TRANSLATION_JOBS = "CONCURRENT_BATCH_TRANSLATION_JOBS"
    PARALLEL_DATA_RESOURCES = "PARALLEL_DATA_RESOURCES"
    CUSTOM_TERMINOLOGY_FILES = "CUSTOM_TERMINOLOGY_FILES"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AmazonVerifiedPermissionsQuota")
class AmazonVerifiedPermissionsQuota(enum.Enum):
    GET_POLICY_STORE_REQUESTS_PER_SECOND_PER_REGION_PER_ACCOUNT = "GET_POLICY_STORE_REQUESTS_PER_SECOND_PER_REGION_PER_ACCOUNT"
    BATCH_IS_AUTHORIZED_REQUESTS_PER_SECOND_PER_REGION_PER_ACCOUNT = "BATCH_IS_AUTHORIZED_REQUESTS_PER_SECOND_PER_REGION_PER_ACCOUNT"
    CREATE_POLICY_TEMPLATE_REQUESTS_PER_SECOND_PER_REGION_PER_ACCOUNT = "CREATE_POLICY_TEMPLATE_REQUESTS_PER_SECOND_PER_REGION_PER_ACCOUNT"
    CREATE_POLICY_STORE_REQUESTS_PER_SECOND_PER_REGION_PER_ACCOUNT = "CREATE_POLICY_STORE_REQUESTS_PER_SECOND_PER_REGION_PER_ACCOUNT"
    UPDATE_POLICY_TEMPLATE_REQUESTS_PER_SECOND_PER_REGION_PER_ACCOUNT = "UPDATE_POLICY_TEMPLATE_REQUESTS_PER_SECOND_PER_REGION_PER_ACCOUNT"
    IS_AUTHORIZED_REQUESTS_PER_SECOND_PER_REGION_PER_ACCOUNT = "IS_AUTHORIZED_REQUESTS_PER_SECOND_PER_REGION_PER_ACCOUNT"
    LIST_POLICY_STORES_REQUESTS_PER_SECOND_PER_REGION_PER_ACCOUNT = "LIST_POLICY_STORES_REQUESTS_PER_SECOND_PER_REGION_PER_ACCOUNT"
    PUT_SCHEMA_REQUESTS_PER_SECOND_PER_REGION_PER_ACCOUNT = "PUT_SCHEMA_REQUESTS_PER_SECOND_PER_REGION_PER_ACCOUNT"
    GET_POLICY_REQUESTS_PER_SECOND_PER_REGION_PER_ACCOUNT = "GET_POLICY_REQUESTS_PER_SECOND_PER_REGION_PER_ACCOUNT"
    POLICY_TEMPLATES_PER_POLICY_STORE = "POLICY_TEMPLATES_PER_POLICY_STORE"
    UPDATE_POLICY_REQUESTS_PER_SECOND_PER_REGION_PER_ACCOUNT = "UPDATE_POLICY_REQUESTS_PER_SECOND_PER_REGION_PER_ACCOUNT"
    LIST_POLICY_TEMPLATES_REQUESTS_PER_SECOND_PER_REGION_PER_ACCOUNT = "LIST_POLICY_TEMPLATES_REQUESTS_PER_SECOND_PER_REGION_PER_ACCOUNT"
    DELETE_POLICY_REQUESTS_PER_SECOND_PER_REGION_PER_ACCOUNT = "DELETE_POLICY_REQUESTS_PER_SECOND_PER_REGION_PER_ACCOUNT"
    DELETE_POLICY_TEMPLATE_REQUESTS_PER_SECOND_PER_REGION_PER_ACCOUNT = "DELETE_POLICY_TEMPLATE_REQUESTS_PER_SECOND_PER_REGION_PER_ACCOUNT"
    LIST_POLICIES_REQUESTS_PER_SECOND_PER_REGION_PER_ACCOUNT = "LIST_POLICIES_REQUESTS_PER_SECOND_PER_REGION_PER_ACCOUNT"
    CREATE_POLICY_REQUESTS_PER_SECOND_PER_REGION_PER_ACCOUNT = "CREATE_POLICY_REQUESTS_PER_SECOND_PER_REGION_PER_ACCOUNT"
    GET_SCHEMA_REQUESTS_PER_SECOND_PER_REGION_PER_ACCOUNT = "GET_SCHEMA_REQUESTS_PER_SECOND_PER_REGION_PER_ACCOUNT"
    DELETE_POLICY_STORE_REQUESTS_PER_SECOND_PER_REGION_PER_ACCOUNT = "DELETE_POLICY_STORE_REQUESTS_PER_SECOND_PER_REGION_PER_ACCOUNT"
    POLICY_STORES_PER_REGION_PER_ACCOUNT = "POLICY_STORES_PER_REGION_PER_ACCOUNT"
    IS_AUTHORIZED_WITH_TOKEN_REQUESTS_PER_SECOND_PER_REGION_PER_ACCOUNT = "IS_AUTHORIZED_WITH_TOKEN_REQUESTS_PER_SECOND_PER_REGION_PER_ACCOUNT"
    GET_POLICY_TEMPLATE_REQUESTS_PER_SECOND_PER_REGION_PER_ACCOUNT = "GET_POLICY_TEMPLATE_REQUESTS_PER_SECOND_PER_REGION_PER_ACCOUNT"


@jsii.enum(
    jsii_type="@reapit-cdk/service-quotas.AmazonVirtualPrivateCloudAmazonVpcQuota"
)
class AmazonVirtualPrivateCloudAmazonVpcQuota(enum.Enum):
    ELASTIC_IP_ADDRESS_QUOTA_PER_NAT_GATEWAY = "ELASTIC_IP_ADDRESS_QUOTA_PER_NAT_GATEWAY"
    NAT_GATEWAYS_PER_AVAILABILITY_ZONE = "NAT_GATEWAYS_PER_AVAILABILITY_ZONE"
    ACTIVE_VPC_PEERING_CONNECTIONS_PER_VPC = "ACTIVE_VPC_PEERING_CONNECTIONS_PER_VPC"
    PARTICIPANT_ACCOUNTS_PER_VPC = "PARTICIPANT_ACCOUNTS_PER_VPC"
    GATEWAY_VPC_ENDPOINTS_PER_REGION = "GATEWAY_VPC_ENDPOINTS_PER_REGION"
    INBOUND_OR_OUTBOUND_RULES_PER_SECURITY_GROUP = "INBOUND_OR_OUTBOUND_RULES_PER_SECURITY_GROUP"
    ROUTES_PER_ROUTE_TABLE = "ROUTES_PER_ROUTE_TABLE"
    OUTSTANDING_VPC_PEERING_CONNECTION_REQUESTS = "OUTSTANDING_VPC_PEERING_CONNECTION_REQUESTS"
    ROUTE_TABLES_PER_VPC = "ROUTE_TABLES_PER_VPC"
    INTERNET_GATEWAYS_PER_REGION = "INTERNET_GATEWAYS_PER_REGION"
    RULES_PER_NETWORK_ACL = "RULES_PER_NETWORK_ACL"
    PRIVATE_IP_ADDRESS_QUOTA_PER_NAT_GATEWAY = "PRIVATE_IP_ADDRESS_QUOTA_PER_NAT_GATEWAY"
    SECURITY_GROUPS_PER_NETWORK_INTERFACE = "SECURITY_GROUPS_PER_NETWORK_INTERFACE"
    INTERFACE_VPC_ENDPOINTS_PER_VPC = "INTERFACE_VPC_ENDPOINTS_PER_VPC"
    I_PV4_CIDR_BLOCKS_PER_VPC = "I_PV4_CIDR_BLOCKS_PER_VPC"
    VPC_SECURITY_GROUPS_PER_REGION = "VPC_SECURITY_GROUPS_PER_REGION"
    NETWORK_INTERFACES_PER_REGION = "NETWORK_INTERFACES_PER_REGION"
    SUBNETS_PER_VPC = "SUBNETS_PER_VPC"
    VP_CS_PER_REGION = "VP_CS_PER_REGION"
    NETWORK_AC_LS_PER_VPC = "NETWORK_AC_LS_PER_VPC"
    VPC_PEERING_CONNECTION_REQUEST_EXPIRY_HOURS = "VPC_PEERING_CONNECTION_REQUEST_EXPIRY_HOURS"
    EGRESS_ONLY_INTERNET_GATEWAYS_PER_REGION = "EGRESS_ONLY_INTERNET_GATEWAYS_PER_REGION"
    SUBNETS_THAT_CAN_BE_SHARED_WITH_AN_ACCOUNT = "SUBNETS_THAT_CAN_BE_SHARED_WITH_AN_ACCOUNT"
    NETWORK_ADDRESS_USAGE = "NETWORK_ADDRESS_USAGE"
    I_PV6_CIDR_BLOCKS_PER_VPC = "I_PV6_CIDR_BLOCKS_PER_VPC"
    PEERED_NETWORK_ADDRESS_USAGE = "PEERED_NETWORK_ADDRESS_USAGE"
    CHARACTERS_PER_VPC_ENDPOINT_POLICY = "CHARACTERS_PER_VPC_ENDPOINT_POLICY"


@jsii.enum(
    jsii_type="@reapit-cdk/service-quotas.AmazonWorkSpacesApplicationManagerQuota"
)
class AmazonWorkSpacesApplicationManagerQuota(enum.Enum):
    TOTAL_PACKAGE_SIZE_WITHOUT_STORAGE_FEES = "TOTAL_PACKAGE_SIZE_WITHOUT_STORAGE_FEES"
    USER_WORK_SPACE_OR_GROUP_ASSIGNMENTS_PER_APPLICATION = "USER_WORK_SPACE_OR_GROUP_ASSIGNMENTS_PER_APPLICATION"
    APPLICATION_SIZE = "APPLICATION_SIZE"
    APPLICATION_ASSIGNMENTS_PER_USER = "APPLICATION_ASSIGNMENTS_PER_USER"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AmazonWorkSpacesQuota")
class AmazonWorkSpacesQuota(enum.Enum):
    STANDBY_WORK_SPACES = "STANDBY_WORK_SPACES"
    GRAPHICS_PRO_WORK_SPACES = "GRAPHICS_PRO_WORK_SPACES"
    CONNECTION_ALIASES = "CONNECTION_ALIASES"
    RULES_PER_IP_ACCESS_CONTROL_GROUP = "RULES_PER_IP_ACCESS_CONTROL_GROUP"
    IP_ACCESS_CONTROL_GROUPS = "IP_ACCESS_CONTROL_GROUPS"
    GRAPHICS_PRO_G4DN_WORK_SPACES = "GRAPHICS_PRO_G4DN_WORK_SPACES"
    BUNDLES = "BUNDLES"
    WORK_SPACES = "WORK_SPACES"
    GRAPHICS_G4DN_WORK_SPACES = "GRAPHICS_G4DN_WORK_SPACES"
    DIRECTORIES = "DIRECTORIES"
    IMAGES = "IMAGES"
    IP_ACCESS_CONTROL_GROUPS_PER_DIRECTORY = "IP_ACCESS_CONTROL_GROUPS_PER_DIRECTORY"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AmazonWorkSpacesWebQuota")
class AmazonWorkSpacesWebQuota(enum.Enum):
    NUMBER_OF_BROWSER_SETTINGS = "NUMBER_OF_BROWSER_SETTINGS"
    NUMBER_OF_NETWORK_SETTINGS = "NUMBER_OF_NETWORK_SETTINGS"
    NUMBER_OF_IP_ACCESS_SETTINGS = "NUMBER_OF_IP_ACCESS_SETTINGS"
    NUMBER_OF_USER_SETTINGS = "NUMBER_OF_USER_SETTINGS"
    NUMBER_OF_WEB_PORTALS = "NUMBER_OF_WEB_PORTALS"
    NUMBER_OF_USER_ACCESS_LOGGING_SETTINGS = "NUMBER_OF_USER_ACCESS_LOGGING_SETTINGS"
    NUMBER_OF_CERTIFICATES_PER_TRUST_STORE = "NUMBER_OF_CERTIFICATES_PER_TRUST_STORE"
    NUMBER_OF_IDENTITY_PROVIDERS_PER_PORTAL = "NUMBER_OF_IDENTITY_PROVIDERS_PER_PORTAL"
    NUMBER_OF_TRUST_STORES = "NUMBER_OF_TRUST_STORES"
    RATE_OF_DELETE_USER_ACCESS_LOGGING_SETTINGS_REQUESTS = "RATE_OF_DELETE_USER_ACCESS_LOGGING_SETTINGS_REQUESTS"
    RATE_OF_GET_PORTAL_REQUESTS = "RATE_OF_GET_PORTAL_REQUESTS"
    RATE_OF_UPDATE_USER_ACCESS_LOGGING_SETTINGS_REQUESTS = "RATE_OF_UPDATE_USER_ACCESS_LOGGING_SETTINGS_REQUESTS"
    RATE_OF_UPDATE_USER_SETTINGS_REQUESTS = "RATE_OF_UPDATE_USER_SETTINGS_REQUESTS"
    RATE_OF_CREATE_PORTAL_REQUESTS = "RATE_OF_CREATE_PORTAL_REQUESTS"
    RATE_OF_LIST_USER_SETTINGS_REQUESTS = "RATE_OF_LIST_USER_SETTINGS_REQUESTS"
    RATE_OF_ASSOCIATE_BROWSER_SETTINGS_REQUESTS = "RATE_OF_ASSOCIATE_BROWSER_SETTINGS_REQUESTS"
    RATE_OF_ASSOCIATE_TRUST_STORE_REQUESTS = "RATE_OF_ASSOCIATE_TRUST_STORE_REQUESTS"
    RATE_OF_CREATE_TRUST_STORE_REQUESTS = "RATE_OF_CREATE_TRUST_STORE_REQUESTS"
    RATE_OF_LIST_NETWORK_SETTINGS_REQUESTS = "RATE_OF_LIST_NETWORK_SETTINGS_REQUESTS"
    RATE_OF_ASSOCIATE_NETWORK_SETTINGS_REQUESTS = "RATE_OF_ASSOCIATE_NETWORK_SETTINGS_REQUESTS"
    RATE_OF_LIST_TRUST_STORE_CERTIFICATES_REQUESTS = "RATE_OF_LIST_TRUST_STORE_CERTIFICATES_REQUESTS"
    RATE_OF_CREATE_USER_SETTINGS_REQUESTS = "RATE_OF_CREATE_USER_SETTINGS_REQUESTS"
    RATE_OF_LIST_TRUST_STORES_REQUESTS = "RATE_OF_LIST_TRUST_STORES_REQUESTS"
    RATE_OF_UPDATE_IP_ACCESS_SETTINGS_REQUESTS = "RATE_OF_UPDATE_IP_ACCESS_SETTINGS_REQUESTS"
    RATE_OF_UNTAG_RESOURCE_REQUESTS = "RATE_OF_UNTAG_RESOURCE_REQUESTS"
    RATE_OF_GET_BROWSER_SETTINGS_REQUESTS = "RATE_OF_GET_BROWSER_SETTINGS_REQUESTS"
    RATE_OF_DISASSOCIATE_USER_SETTINGS_REQUESTS = "RATE_OF_DISASSOCIATE_USER_SETTINGS_REQUESTS"
    RATE_OF_DISASSOCIATE_IP_ACCESS_SETTINGS_REQUESTS = "RATE_OF_DISASSOCIATE_IP_ACCESS_SETTINGS_REQUESTS"
    RATE_OF_GET_USER_SETTINGS_REQUESTS = "RATE_OF_GET_USER_SETTINGS_REQUESTS"
    RATE_OF_GET_IP_ACCESS_SETTINGS_REQUESTS = "RATE_OF_GET_IP_ACCESS_SETTINGS_REQUESTS"
    RATE_OF_DELETE_PORTAL_REQUESTS = "RATE_OF_DELETE_PORTAL_REQUESTS"
    RATE_OF_ASSOCIATE_USER_SETTINGS_REQUESTS = "RATE_OF_ASSOCIATE_USER_SETTINGS_REQUESTS"
    RATE_OF_ASSOCIATE_IP_ACCESS_SETTINGS_REQUESTS = "RATE_OF_ASSOCIATE_IP_ACCESS_SETTINGS_REQUESTS"
    RATE_OF_DELETE_IP_ACCESS_SETTINGS_REQUESTS = "RATE_OF_DELETE_IP_ACCESS_SETTINGS_REQUESTS"
    RATE_OF_CREATE_IDENTITY_PROVIDER_REQUESTS = "RATE_OF_CREATE_IDENTITY_PROVIDER_REQUESTS"
    RATE_OF_GET_USER_ACCESS_LOGGING_SETTINGS_REQUESTS = "RATE_OF_GET_USER_ACCESS_LOGGING_SETTINGS_REQUESTS"
    RATE_OF_UPDATE_TRUST_STORE_REQUESTS = "RATE_OF_UPDATE_TRUST_STORE_REQUESTS"
    RATE_OF_DISASSOCIATE_TRUST_STORE_REQUESTS = "RATE_OF_DISASSOCIATE_TRUST_STORE_REQUESTS"
    RATE_OF_DELETE_NETWORK_SETTINGS_REQUESTS = "RATE_OF_DELETE_NETWORK_SETTINGS_REQUESTS"
    RATE_OF_UPDATE_PORTAL_REQUESTS = "RATE_OF_UPDATE_PORTAL_REQUESTS"
    NUMBER_OF_MAXIMUM_CONCURRENT_SESSIONS_PER_PORTAL = "NUMBER_OF_MAXIMUM_CONCURRENT_SESSIONS_PER_PORTAL"
    RATE_OF_UPDATE_IDENTITY_PROVIDER_REQUESTS = "RATE_OF_UPDATE_IDENTITY_PROVIDER_REQUESTS"
    RATE_OF_UPDATE_NETWORK_SETTINGS_REQUESTS = "RATE_OF_UPDATE_NETWORK_SETTINGS_REQUESTS"
    RATE_OF_DISASSOCIATE_USER_ACCESS_LOGGING_SETTINGS_REQUESTS = "RATE_OF_DISASSOCIATE_USER_ACCESS_LOGGING_SETTINGS_REQUESTS"
    RATE_OF_CREATE_USER_ACCESS_LOGGING_SETTINGS_REQUESTS = "RATE_OF_CREATE_USER_ACCESS_LOGGING_SETTINGS_REQUESTS"
    RATE_OF_LIST_USER_ACCESS_LOGGING_SETTINGS_REQUESTS = "RATE_OF_LIST_USER_ACCESS_LOGGING_SETTINGS_REQUESTS"
    RATE_OF_DELETE_IDENTITY_PROVIDER_REQUESTS = "RATE_OF_DELETE_IDENTITY_PROVIDER_REQUESTS"
    RATE_OF_DISASSOCIATE_BROWSER_SETTINGS_REQUESTS = "RATE_OF_DISASSOCIATE_BROWSER_SETTINGS_REQUESTS"
    RATE_OF_DELETE_BROWSER_SETTINGS_REQUESTS = "RATE_OF_DELETE_BROWSER_SETTINGS_REQUESTS"
    RATE_OF_LIST_PORTALS_REQUESTS = "RATE_OF_LIST_PORTALS_REQUESTS"
    RATE_OF_DELETE_TRUST_STORE_REQUESTS = "RATE_OF_DELETE_TRUST_STORE_REQUESTS"
    RATE_OF_ASSOCIATE_USER_ACCESS_LOGGING_SETTINGS_REQUESTS = "RATE_OF_ASSOCIATE_USER_ACCESS_LOGGING_SETTINGS_REQUESTS"
    RATE_OF_LIST_IDENTITY_PROVIDERS_REQUESTS = "RATE_OF_LIST_IDENTITY_PROVIDERS_REQUESTS"
    RATE_OF_DISASSOCIATE_NETWORK_SETTINGS_REQUESTS = "RATE_OF_DISASSOCIATE_NETWORK_SETTINGS_REQUESTS"
    RATE_OF_CREATE_BROWSER_SETTINGS_REQUESTS = "RATE_OF_CREATE_BROWSER_SETTINGS_REQUESTS"
    RATE_OF_TAG_RESOURCE_REQUESTS = "RATE_OF_TAG_RESOURCE_REQUESTS"
    RATE_OF_GET_NETWORK_SETTINGS_REQUESTS = "RATE_OF_GET_NETWORK_SETTINGS_REQUESTS"
    RATE_OF_CREATE_IP_ACCESS_SETTINGS_REQUESTS = "RATE_OF_CREATE_IP_ACCESS_SETTINGS_REQUESTS"
    RATE_OF_LIST_TAGS_FOR_RESOURCE_REQUESTS = "RATE_OF_LIST_TAGS_FOR_RESOURCE_REQUESTS"
    RATE_OF_CREATE_NETWORK_SETTINGS_REQUESTS = "RATE_OF_CREATE_NETWORK_SETTINGS_REQUESTS"
    RATE_OF_UPDATE_BROWSER_SETTINGS_REQUESTS = "RATE_OF_UPDATE_BROWSER_SETTINGS_REQUESTS"
    RATE_OF_LIST_BROWSER_SETTINGS_REQUESTS = "RATE_OF_LIST_BROWSER_SETTINGS_REQUESTS"
    RATE_OF_DELETE_USER_SETTINGS_REQUESTS = "RATE_OF_DELETE_USER_SETTINGS_REQUESTS"
    RATE_OF_LIST_IP_ACCESS_SETTINGS_REQUESTS = "RATE_OF_LIST_IP_ACCESS_SETTINGS_REQUESTS"
    RATE_OF_GET_IDENTITY_PROVIDER_REQUESTS = "RATE_OF_GET_IDENTITY_PROVIDER_REQUESTS"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AmplifyUiBuilderQuota")
class AmplifyUiBuilderQuota(enum.Enum):
    THEME_SIZE = "THEME_SIZE"
    FORM_SIZE = "FORM_SIZE"
    VIEWS_PER_APP = "VIEWS_PER_APP"
    COMPONENTS_PER_APP = "COMPONENTS_PER_APP"
    THEMES_PER_APP = "THEMES_PER_APP"
    COMPONENT_SIZE = "COMPONENT_SIZE"
    VIEW_SIZE = "VIEW_SIZE"
    FORMS_PER_APP = "FORMS_PER_APP"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.ApplicationAutoScalingQuota")
class ApplicationAutoScalingQuota(enum.Enum):
    SCALABLE_TARGETS_FOR_DYNAMO_DB = "SCALABLE_TARGETS_FOR_DYNAMO_DB"
    SCALABLE_TARGETS_FOR_COMPREHEND = "SCALABLE_TARGETS_FOR_COMPREHEND"
    SCALABLE_TARGETS_FOR_APP_STREAM = "SCALABLE_TARGETS_FOR_APP_STREAM"
    SCHEDULED_ACTIONS_PER_SCALABLE_TARGET = "SCHEDULED_ACTIONS_PER_SCALABLE_TARGET"
    SCALABLE_TARGETS_FOR_EC2 = "SCALABLE_TARGETS_FOR_EC2"
    SCALABLE_TARGETS_FOR_LAMBDA = "SCALABLE_TARGETS_FOR_LAMBDA"
    SCALABLE_TARGETS_FOR_AMAZON_KEYSPACES = "SCALABLE_TARGETS_FOR_AMAZON_KEYSPACES"
    SCALABLE_TARGETS_FOR_AMAZON_MSK = "SCALABLE_TARGETS_FOR_AMAZON_MSK"
    SCALABLE_TARGETS_FOR_RDS = "SCALABLE_TARGETS_FOR_RDS"
    SCALABLE_TARGETS_FOR_EMR = "SCALABLE_TARGETS_FOR_EMR"
    SCALING_POLICIES_PER_SCALABLE_TARGET = "SCALING_POLICIES_PER_SCALABLE_TARGET"
    SCALABLE_TARGETS_FOR_SAGE_MAKER = "SCALABLE_TARGETS_FOR_SAGE_MAKER"
    STEP_ADJUSTMENTS_PER_STEP_SCALING_POLICY = "STEP_ADJUSTMENTS_PER_STEP_SCALING_POLICY"
    SCALABLE_TARGETS_FOR_CUSTOM_RESOURCES = "SCALABLE_TARGETS_FOR_CUSTOM_RESOURCES"
    SCALABLE_TARGETS_FOR_AMAZON_ELASTI_CACHE = "SCALABLE_TARGETS_FOR_AMAZON_ELASTI_CACHE"
    SCALABLE_TARGETS_FOR_ECS = "SCALABLE_TARGETS_FOR_ECS"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.ApplicationMigrationQuota")
class ApplicationMigrationQuota(enum.Enum):
    MAX_ACTIVE_APPLICATIONS = "MAX_ACTIVE_APPLICATIONS"
    MAX_TOTAL_SOURCE_SERVERS_PER_AWS_ACCOUNT = "MAX_TOTAL_SOURCE_SERVERS_PER_AWS_ACCOUNT"
    MAX_ARCHIVED_WAVES = "MAX_ARCHIVED_WAVES"
    MAX_ACTIONS_PER_SOURCE_SERVER = "MAX_ACTIONS_PER_SOURCE_SERVER"
    MAX_ACTIONS_PER_TEMPLATE = "MAX_ACTIONS_PER_TEMPLATE"
    MAX_ACTIVE_SOURCE_SERVERS = "MAX_ACTIVE_SOURCE_SERVERS"
    MAX_ACTIVE_WAVES = "MAX_ACTIVE_WAVES"
    MAX_SOURCE_SERVERS_PER_APPLICATION = "MAX_SOURCE_SERVERS_PER_APPLICATION"
    MAX_APPLICATIONS_PER_WAVE = "MAX_APPLICATIONS_PER_WAVE"
    MAX_ARCHIVED_APPLICATIONS = "MAX_ARCHIVED_APPLICATIONS"
    MAX_SOURCE_SERVERS_IN_A_SINGLE_JOB = "MAX_SOURCE_SERVERS_IN_A_SINGLE_JOB"
    MAX_SOURCE_SERVERS_IN_ALL_JOBS = "MAX_SOURCE_SERVERS_IN_ALL_JOBS"
    CONCURRENT_JOBS_IN_PROGRESS = "CONCURRENT_JOBS_IN_PROGRESS"
    MAX_CONCURRENT_JOBS_PER_SOURCE_SERVER = "MAX_CONCURRENT_JOBS_PER_SOURCE_SERVER"
    MAX_NON_ARCHIVED_SOURCE_SERVERS = "MAX_NON_ARCHIVED_SOURCE_SERVERS"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsAccountManagementQuota")
class AwsAccountManagementQuota(enum.Enum):
    RATE_OF_DELETE_ALTERNATE_CONTACT_REQUESTS_PER_ACCOUNT = "RATE_OF_DELETE_ALTERNATE_CONTACT_REQUESTS_PER_ACCOUNT"
    RATE_OF_GET_CONTACT_INFORMATION_REQUESTS_PER_ACCOUNT = "RATE_OF_GET_CONTACT_INFORMATION_REQUESTS_PER_ACCOUNT"
    RATE_OF_PUT_CONTACT_INFORMATION_REQUESTS_PER_ACCOUNT = "RATE_OF_PUT_CONTACT_INFORMATION_REQUESTS_PER_ACCOUNT"
    RATE_OF_PUT_ALTERNATE_CONTACT_REQUESTS_PER_ACCOUNT = "RATE_OF_PUT_ALTERNATE_CONTACT_REQUESTS_PER_ACCOUNT"
    RATE_OF_LIST_REGIONS_REQUESTS_PER_ACCOUNT = "RATE_OF_LIST_REGIONS_REQUESTS_PER_ACCOUNT"
    RATE_OF_ENABLE_REGION_REQUESTS_PER_ACCOUNT = "RATE_OF_ENABLE_REGION_REQUESTS_PER_ACCOUNT"
    RATE_OF_DISABLE_REGION_REQUESTS_PER_ACCOUNT = "RATE_OF_DISABLE_REGION_REQUESTS_PER_ACCOUNT"
    RATE_OF_GET_REGION_OPT_STATUS_REQUESTS_PER_ACCOUNT = "RATE_OF_GET_REGION_OPT_STATUS_REQUESTS_PER_ACCOUNT"
    RATE_OF_GET_ALTERNATE_CONTACT_REQUESTS_PER_ACCOUNT = "RATE_OF_GET_ALTERNATE_CONTACT_REQUESTS_PER_ACCOUNT"
    NUMBER_OF_CONCURRENT_REGION_OPT_REQUESTS_PER_ACCOUNT = "NUMBER_OF_CONCURRENT_REGION_OPT_REQUESTS_PER_ACCOUNT"
    NUMBER_OF_CONCURRENT_REGION_OPT_REQUESTS_PER_ORGANIZATION = "NUMBER_OF_CONCURRENT_REGION_OPT_REQUESTS_PER_ORGANIZATION"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsAmplifyQuota")
class AwsAmplifyQuota(enum.Enum):
    BUILD_ARTIFACT_SIZE = "BUILD_ARTIFACT_SIZE"
    CACHE_ARTIFACT_SIZE = "CACHE_ARTIFACT_SIZE"
    APPS = "APPS"
    WEBHOOKS_PER_APP = "WEBHOOKS_PER_APP"
    ENVIRONMENT_CACHE_ARTIFACT_SIZE = "ENVIRONMENT_CACHE_ARTIFACT_SIZE"
    MANUAL_DEPLOY_ZIP_FILE_SIZE = "MANUAL_DEPLOY_ZIP_FILE_SIZE"
    MAXIMUM_APP_CREATIONS_PER_HOUR = "MAXIMUM_APP_CREATIONS_PER_HOUR"
    BRANCHES_PER_APP = "BRANCHES_PER_APP"
    CONCURRENT_JOBS = "CONCURRENT_JOBS"
    SUBDOMAINS_PER_DOMAIN = "SUBDOMAINS_PER_DOMAIN"
    DOMAINS_PER_APP = "DOMAINS_PER_APP"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsAppConfigQuota")
class AwsAppConfigQuota(enum.Enum):
    MAXIMUM_NUMBER_OF_APPLICATIONS = "MAXIMUM_NUMBER_OF_APPLICATIONS"
    MAXIMUM_NUMBER_OF_ENVIRONMENTS_PER_APPLICATION = "MAXIMUM_NUMBER_OF_ENVIRONMENTS_PER_APPLICATION"
    DEPLOYMENT_SIZE_LIMIT = "DEPLOYMENT_SIZE_LIMIT"
    CONFIGURATION_SIZE_LIMIT_IN_AWS_APP_CONFIG_HOSTED_CONFIGURATION_STORE = "CONFIGURATION_SIZE_LIMIT_IN_AWS_APP_CONFIG_HOSTED_CONFIGURATION_STORE"
    MAXIMUM_NUMBER_OF_CONFIGURATION_PROFILES_PER_APPLICATION = "MAXIMUM_NUMBER_OF_CONFIGURATION_PROFILES_PER_APPLICATION"
    MAXIMUM_NUMBER_OF_DEPLOYMENT_STRATEGIES = "MAXIMUM_NUMBER_OF_DEPLOYMENT_STRATEGIES"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsAppFabricQuota")
class AwsAppFabricQuota(enum.Enum):
    APPLICATION_AUTHORIZATIONS = "APPLICATION_AUTHORIZATIONS"
    APPLICATION_BUNDLES = "APPLICATION_BUNDLES"
    INGESTION_DESTINATIONS = "INGESTION_DESTINATIONS"
    INGESTIONS = "INGESTIONS"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsAppMeshQuota")
class AwsAppMeshQuota(enum.Enum):
    VIRTUAL_NODES_PER_MESH = "VIRTUAL_NODES_PER_MESH"
    GATEWAY_ROUTES_PER_VIRTUAL_GATEWAY = "GATEWAY_ROUTES_PER_VIRTUAL_GATEWAY"
    VIRTUAL_SERVICES_PER_MESH = "VIRTUAL_SERVICES_PER_MESH"
    BACKENDS_PER_VIRTUAL_NODE = "BACKENDS_PER_VIRTUAL_NODE"
    VIRTUAL_ROUTERS_PER_MESH = "VIRTUAL_ROUTERS_PER_MESH"
    CONNECTED_ENVOY_PROCESSES_PER_VIRTUAL_NODE = "CONNECTED_ENVOY_PROCESSES_PER_VIRTUAL_NODE"
    VIRTUAL_GATEWAYS_PER_MESH = "VIRTUAL_GATEWAYS_PER_MESH"
    ROUTES_PER_VIRTUAL_ROUTER = "ROUTES_PER_VIRTUAL_ROUTER"
    WEIGHTED_TARGETS_PER_ROUTE = "WEIGHTED_TARGETS_PER_ROUTE"
    MESHES_PER_ACCOUNT = "MESHES_PER_ACCOUNT"
    CONNECTED_ENVOY_PROCESSES_PER_VIRTUAL_GATEWAY = "CONNECTED_ENVOY_PROCESSES_PER_VIRTUAL_GATEWAY"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsAppRunnerQuota")
class AwsAppRunnerQuota(enum.Enum):
    SERVICES = "SERVICES"
    OBSERVABILITY_CONFIGURATIONS = "OBSERVABILITY_CONFIGURATIONS"
    CONNECTIONS = "CONNECTIONS"
    AUTO_SCALING_CONFIGURATIONS = "AUTO_SCALING_CONFIGURATIONS"
    VPC_CONNECTORS = "VPC_CONNECTORS"
    VPC_INGRESS_CONNECTIONS = "VPC_INGRESS_CONNECTIONS"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsAppSyncQuota")
class AwsAppSyncQuota(enum.Enum):
    RATE_OF_REQUEST_TOKENS = "RATE_OF_REQUEST_TOKENS"
    API_KEYS_PER_API = "API_KEYS_PER_API"
    REQUEST_EXECUTION_TIME_FOR_MUTATIONS_QUERIES_AND_SUBSCRIPTIONS = "REQUEST_EXECUTION_TIME_FOR_MUTATIONS_QUERIES_AND_SUBSCRIPTIONS"
    SUBSCRIPTIONS_PER_CONNECTION = "SUBSCRIPTIONS_PER_CONNECTION"
    MAX_BATCH_SIZE = "MAX_BATCH_SIZE"
    SCHEMA_DOCUMENT_SIZE = "SCHEMA_DOCUMENT_SIZE"
    AP_IS_PER_REGION = "AP_IS_PER_REGION"
    NUMBER_OF_CUSTOM_DOMAIN_NAMES = "NUMBER_OF_CUSTOM_DOMAIN_NAMES"
    FUNCTIONS_PER_PIPELINE_RESOLVER = "FUNCTIONS_PER_PIPELINE_RESOLVER"
    NUMBER_OF_CACHING_KEYS = "NUMBER_OF_CACHING_KEYS"
    RESPONSE_MAPPING_TEMPLATE_SIZE = "RESPONSE_MAPPING_TEMPLATE_SIZE"
    SUBSCRIPTION_PAYLOAD_SIZE = "SUBSCRIPTION_PAYLOAD_SIZE"
    RATE_OF_SUBSCRIPTION_INVALIDATION_REQUESTS = "RATE_OF_SUBSCRIPTION_INVALIDATION_REQUESTS"
    ITERATIONS_IN_A_FOREACH_LOOP_IN_MAPPING_TEMPLATES = "ITERATIONS_IN_A_FOREACH_LOOP_IN_MAPPING_TEMPLATES"
    AUTHENTICATION_PROVIDERS_PER_API = "AUTHENTICATION_PROVIDERS_PER_API"
    REQUEST_MAPPING_TEMPLATE_SIZE = "REQUEST_MAPPING_TEMPLATE_SIZE"
    EVALUATED_RESOLVER_TEMPLATE_SIZE = "EVALUATED_RESOLVER_TEMPLATE_SIZE"
    RESOLVERS_EXECUTED_IN_A_SINGLE_REQUEST = "RESOLVERS_EXECUTED_IN_A_SINGLE_REQUEST"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsApplicationCostProfilerQuota")
class AwsApplicationCostProfilerQuota(enum.Enum):
    RATE_OF_DELETE_REPORT_DEFINITION_REQUESTS = "RATE_OF_DELETE_REPORT_DEFINITION_REQUESTS"
    IMPORT_APPLICATION_USAGE_THROTTLE_BURST_LIMIT = "IMPORT_APPLICATION_USAGE_THROTTLE_BURST_LIMIT"
    LIST_REPORT_DEFINITIONS_THROTTLE_BURST_LIMIT = "LIST_REPORT_DEFINITIONS_THROTTLE_BURST_LIMIT"
    RATE_OF_GET_REPORT_DEFINITION_REQUESTS = "RATE_OF_GET_REPORT_DEFINITION_REQUESTS"
    DELETE_REPORT_DEFINITION_THROTTLE_BURST_LIMIT = "DELETE_REPORT_DEFINITION_THROTTLE_BURST_LIMIT"
    UPDATE_REPORT_DEFINITION_THROTTLE_BURST_LIMIT = "UPDATE_REPORT_DEFINITION_THROTTLE_BURST_LIMIT"
    RATE_OF_PUT_REPORT_DEFINITION_REQUESTS = "RATE_OF_PUT_REPORT_DEFINITION_REQUESTS"
    GET_REPORT_DEFINITION_THROTTLE_BURST_LIMIT = "GET_REPORT_DEFINITION_THROTTLE_BURST_LIMIT"
    MAXIMUM_SIZE_OF_AN_HOURLY_INSTRUMENTATION_FILE = "MAXIMUM_SIZE_OF_AN_HOURLY_INSTRUMENTATION_FILE"
    RATE_OF_LIST_REPORT_DEFINITIONS_REQUESTS = "RATE_OF_LIST_REPORT_DEFINITIONS_REQUESTS"
    RATE_OF_UPDATE_REPORT_DEFINITION_REQUESTS = "RATE_OF_UPDATE_REPORT_DEFINITION_REQUESTS"
    PUT_REPORT_DEFINITION_THROTTLE_BURST_LIMIT = "PUT_REPORT_DEFINITION_THROTTLE_BURST_LIMIT"
    RATE_OF_IMPORT_APPLICATION_USAGE_REQUESTS = "RATE_OF_IMPORT_APPLICATION_USAGE_REQUESTS"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsApplicationDiscoveryServiceQuota")
class AwsApplicationDiscoveryServiceQuota(enum.Enum):
    DELETIONS_OF_IMPORT_RECORDS_PER_DAY = "DELETIONS_OF_IMPORT_RECORDS_PER_DAY"
    APPLICATIONS_PER_ACCOUNT = "APPLICATIONS_PER_ACCOUNT"
    IMPORTED_SERVER_RECORDS_PER_ACCOUNT = "IMPORTED_SERVER_RECORDS_PER_ACCOUNT"
    ACTIVE_AGENTS_SENDING_DATA_TO_THE_SERVICE = "ACTIVE_AGENTS_SENDING_DATA_TO_THE_SERVICE"
    IMPORTED_SERVERS_PER_ACCOUNT = "IMPORTED_SERVERS_PER_ACCOUNT"
    SERVERS_PER_APPLICATION = "SERVERS_PER_APPLICATION"
    INACTIVE_AGENTS_HEARTBEATING_BUT_NOT_COLLECTING_DATA = "INACTIVE_AGENTS_HEARTBEATING_BUT_NOT_COLLECTING_DATA"
    TAGS_PER_SERVER = "TAGS_PER_SERVER"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsAuditManagerQuota")
class AwsAuditManagerQuota(enum.Enum):
    CUSTOM_FRAMEWORKS = "CUSTOM_FRAMEWORKS"
    RUNNING_ASSESSMENTS = "RUNNING_ASSESSMENTS"
    CUSTOM_CONTROLS = "CUSTOM_CONTROLS"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsAutoScalingPlansQuota")
class AwsAutoScalingPlansQuota(enum.Enum):
    SCALING_PLANS = "SCALING_PLANS"
    SCALING_INSTRUCTIONS_PER_SCALING_PLAN = "SCALING_INSTRUCTIONS_PER_SCALING_PLAN"
    TARGET_TRACKING_CONFIGURATIONS_PER_SCALING_INSTRUCTION = "TARGET_TRACKING_CONFIGURATIONS_PER_SCALING_INSTRUCTION"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsBackupQuota")
class AwsBackupQuota(enum.Enum):
    FRAMEWORKS_PER_REPORT_PLAN = "FRAMEWORKS_PER_REPORT_PLAN"
    BACKUP_VAULTS_PER_REGION_PER_ACCOUNT = "BACKUP_VAULTS_PER_REGION_PER_ACCOUNT"
    FRAMEWORKS_PER_REGION_PER_ACCOUNT = "FRAMEWORKS_PER_REGION_PER_ACCOUNT"
    FRAMEWORK_CONTROLS_PER_REGION_PER_ACCOUNT = "FRAMEWORK_CONTROLS_PER_REGION_PER_ACCOUNT"
    VERSIONS_PER_BACKUP_PLAN = "VERSIONS_PER_BACKUP_PLAN"
    RECOVERY_POINTS_PER_BACKUP_VAULT = "RECOVERY_POINTS_PER_BACKUP_VAULT"
    MAXIMUM_BACKUP_NEST_LEVEL = "MAXIMUM_BACKUP_NEST_LEVEL"
    CONCURRENT_BACKUP_JOBS_PER_RESOURCE = "CONCURRENT_BACKUP_JOBS_PER_RESOURCE"
    BACKUP_PLANS_PER_REGION_PER_ACCOUNT = "BACKUP_PLANS_PER_REGION_PER_ACCOUNT"
    REPORT_PLANS_PER_REGION_PER_ACCOUNT = "REPORT_PLANS_PER_REGION_PER_ACCOUNT"
    METADATA_TAGS_PER_BACKUP = "METADATA_TAGS_PER_BACKUP"
    CONCURRENT_BACKUP_COPIES_PER_SUPPORTED_SERVICE_PER_ACCOUNT = "CONCURRENT_BACKUP_COPIES_PER_SUPPORTED_SERVICE_PER_ACCOUNT"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsBatchQuota")
class AwsBatchQuota(enum.Enum):
    JOB_PAYLOAD_SIZE_LIMIT = "JOB_PAYLOAD_SIZE_LIMIT"
    COMPUTE_ENVIRONMENTS_PER_JOB_QUEUE_LIMIT = "COMPUTE_ENVIRONMENTS_PER_JOB_QUEUE_LIMIT"
    TRANSACTIONS_PER_SECOND_FOR_SUBMIT_JOB_LIMIT = "TRANSACTIONS_PER_SECOND_FOR_SUBMIT_JOB_LIMIT"
    JOB_DEFINITION_SIZE_LIMIT = "JOB_DEFINITION_SIZE_LIMIT"
    JOB_DEPENDENCIES_LIMIT = "JOB_DEPENDENCIES_LIMIT"
    SUBMITTED_STATE_JOBS_LIMIT = "SUBMITTED_STATE_JOBS_LIMIT"
    MAXIMUM_ARRAY_SIZE_LIMIT = "MAXIMUM_ARRAY_SIZE_LIMIT"
    COMPUTE_ENVIRONMENT_LIMIT = "COMPUTE_ENVIRONMENT_LIMIT"
    JOB_QUEUE_LIMIT = "JOB_QUEUE_LIMIT"
    SHARE_IDENTIFIERS_PER_JOB_QUEUE_LIMIT = "SHARE_IDENTIFIERS_PER_JOB_QUEUE_LIMIT"


@jsii.enum(
    jsii_type="@reapit-cdk/service-quotas.AwsBillingAndCostManagementDataExportsQuota"
)
class AwsBillingAndCostManagementDataExportsQuota(enum.Enum):
    RATE_OF_CREATE_EXPORT_REQUESTS = "RATE_OF_CREATE_EXPORT_REQUESTS"
    RATE_OF_GET_EXPORT_REQUESTS = "RATE_OF_GET_EXPORT_REQUESTS"
    RATE_OF_GET_EXECUTION_REQUESTS = "RATE_OF_GET_EXECUTION_REQUESTS"
    RATE_OF_LIST_TABLES_REQUESTS = "RATE_OF_LIST_TABLES_REQUESTS"
    RATE_OF_LIST_TAGS_FOR_RESOURCE_REQUESTS = "RATE_OF_LIST_TAGS_FOR_RESOURCE_REQUESTS"
    RATE_OF_UNTAG_RESOURCE_REQUESTS = "RATE_OF_UNTAG_RESOURCE_REQUESTS"
    NUMBER_OF_EXPORTS_FOR_COST_AND_USAGE_DASHBOARD_TABLE = "NUMBER_OF_EXPORTS_FOR_COST_AND_USAGE_DASHBOARD_TABLE"
    RATE_OF_LIST_EXPORTS_REQUESTS = "RATE_OF_LIST_EXPORTS_REQUESTS"
    RATE_OF_DELETE_EXPORT_REQUESTS = "RATE_OF_DELETE_EXPORT_REQUESTS"
    RATE_OF_GET_TABLE_REQUESTS = "RATE_OF_GET_TABLE_REQUESTS"
    RATE_OF_UPDATE_EXPORT_REQUESTS = "RATE_OF_UPDATE_EXPORT_REQUESTS"
    RATE_OF_LIST_EXECUTIONS_REQUESTS = "RATE_OF_LIST_EXECUTIONS_REQUESTS"
    RATE_OF_TAG_RESOURCE_REQUESTS = "RATE_OF_TAG_RESOURCE_REQUESTS"
    NUMBER_OF_EXPORTS_FOR_COST_AND_USAGE_REPORT_TABLE = "NUMBER_OF_EXPORTS_FOR_COST_AND_USAGE_REPORT_TABLE"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsBillingConductorQuota")
class AwsBillingConductorQuota(enum.Enum):
    CUSTOM_LINE_ITEMS = "CUSTOM_LINE_ITEMS"
    PRICING_RULES_PER_PRICING_PLAN = "PRICING_RULES_PER_PRICING_PLAN"
    PRICING_RULES = "PRICING_RULES"
    ACCOUNTS_PER_BILLING_GROUP = "ACCOUNTS_PER_BILLING_GROUP"
    BILLING_GROUPS = "BILLING_GROUPS"
    CUSTOM_LINE_ITEMS_WITH_LINE_ITEM_FILTERS = "CUSTOM_LINE_ITEMS_WITH_LINE_ITEM_FILTERS"
    RESOURCE_VALUES_PER_PERCENTAGE_CUSTOM_LINE_ITEM = "RESOURCE_VALUES_PER_PERCENTAGE_CUSTOM_LINE_ITEM"
    PRICING_PLANS = "PRICING_PLANS"
    ASSOCIATIONS_PER_FLAT_CUSTOM_LINE_ITEM = "ASSOCIATIONS_PER_FLAT_CUSTOM_LINE_ITEM"
    PRICING_PLANS_PER_PRICING_RULE = "PRICING_PLANS_PER_PRICING_RULE"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsBugbustQuota")
class AwsBugbustQuota(enum.Enum):
    PARTICIPANTS_PER_BUG_BUST_EVENT = "PARTICIPANTS_PER_BUG_BUST_EVENT"
    EVENTS_PER_AWS_REGION = "EVENTS_PER_AWS_REGION"
    REPOSITORIES_PER_BUG_BUST_EVENT = "REPOSITORIES_PER_BUG_BUST_EVENT"
    PROFILING_GROUPS_PER_BUG_BUST_EVENT = "PROFILING_GROUPS_PER_BUG_BUST_EVENT"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsCertificateManagerAcmQuota")
class AwsCertificateManagerAcmQuota(enum.Enum):
    ACM_CERTIFICATES_CREATED_IN_LAST_365_DAYS = "ACM_CERTIFICATES_CREATED_IN_LAST_365_DAYS"
    IMPORTED_CERTIFICATES = "IMPORTED_CERTIFICATES"
    DOMAIN_NAMES_PER_ACM_CERTIFICATE = "DOMAIN_NAMES_PER_ACM_CERTIFICATE"
    ACM_CERTIFICATES = "ACM_CERTIFICATES"
    IMPORTED_CERTIFICATES_IN_LAST_365_DAYS = "IMPORTED_CERTIFICATES_IN_LAST_365_DAYS"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsChatbotQuota")
class AwsChatbotQuota(enum.Enum):
    MAXIMUM_NUMBER_OF_CHIME_WEBHOOK_CONFIGURATIONS_PER_AWS_ACCOUNT = "MAXIMUM_NUMBER_OF_CHIME_WEBHOOK_CONFIGURATIONS_PER_AWS_ACCOUNT"
    MAXIMUM_NUMBER_OF_SLACK_CHANNEL_CONFIGURATIONS_PER_AWS_ACCOUNT = "MAXIMUM_NUMBER_OF_SLACK_CHANNEL_CONFIGURATIONS_PER_AWS_ACCOUNT"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsCleanRoomsQuota")
class AwsCleanRoomsQuota(enum.Enum):
    CONFIGURED_AUDIENCE_MODEL_ASSOCIATIONS_PER_MEMBERSHIP = "CONFIGURED_AUDIENCE_MODEL_ASSOCIATIONS_PER_MEMBERSHIP"
    RATE_OF_GET_SCHEMA_ANALYSIS_RULE_REQUESTS = "RATE_OF_GET_SCHEMA_ANALYSIS_RULE_REQUESTS"
    RATE_OF_LIST_COLLABORATIONS_REQUESTS = "RATE_OF_LIST_COLLABORATIONS_REQUESTS"
    ANALYSIS_TEMPLATES_PER_MEMBERSHIP = "ANALYSIS_TEMPLATES_PER_MEMBERSHIP"
    MEMBERS_INVITED_PER_COLLABORATION = "MEMBERS_INVITED_PER_COLLABORATION"
    RATE_OF_GET_MEMBERSHIP_REQUESTS = "RATE_OF_GET_MEMBERSHIP_REQUESTS"
    RATE_OF_CREATE_MEMBERSHIP_REQUESTS = "RATE_OF_CREATE_MEMBERSHIP_REQUESTS"
    RATE_OF_LIST_MEMBERS_REQUESTS = "RATE_OF_LIST_MEMBERS_REQUESTS"
    RATE_OF_GET_CONFIGURED_TABLE_ANALYSIS_RULE_REQUESTS = "RATE_OF_GET_CONFIGURED_TABLE_ANALYSIS_RULE_REQUESTS"
    ANALYSIS_RULE_SIZE = "ANALYSIS_RULE_SIZE"
    TABLE_ASSOCIATIONS_PER_MEMBERSHIP = "TABLE_ASSOCIATIONS_PER_MEMBERSHIP"
    RATE_OF_LIST_MEMBERSHIPS_REQUESTS = "RATE_OF_LIST_MEMBERSHIPS_REQUESTS"
    RATE_OF_DELETE_CONFIGURED_TABLE_ASSOCIATION_REQUESTS = "RATE_OF_DELETE_CONFIGURED_TABLE_ASSOCIATION_REQUESTS"
    RATE_OF_UPDATE_COLLABORATION_REQUESTS = "RATE_OF_UPDATE_COLLABORATION_REQUESTS"
    RATE_OF_CREATE_CONFIGURED_TABLE_REQUESTS = "RATE_OF_CREATE_CONFIGURED_TABLE_REQUESTS"
    RATE_OF_BATCH_GET_SCHEMA_REQUESTS = "RATE_OF_BATCH_GET_SCHEMA_REQUESTS"
    RATE_OF_DELETE_CONFIGURED_TABLE_ANALYSIS_RULE_REQUESTS = "RATE_OF_DELETE_CONFIGURED_TABLE_ANALYSIS_RULE_REQUESTS"
    RATE_OF_START_PROTECTED_QUERY_REQUESTS = "RATE_OF_START_PROTECTED_QUERY_REQUESTS"
    MEMBERSHIPS_PER_ACCOUNT = "MEMBERSHIPS_PER_ACCOUNT"
    COLLABORATIONS_CREATED_PER_ACCOUNT = "COLLABORATIONS_CREATED_PER_ACCOUNT"
    RATE_OF_DELETE_MEMBER_REQUESTS = "RATE_OF_DELETE_MEMBER_REQUESTS"
    COLUMNS_PER_CONFIGURED_TABLE_ALLOWLIST = "COLUMNS_PER_CONFIGURED_TABLE_ALLOWLIST"
    RATE_OF_GET_CONFIGURED_TABLE_REQUESTS = "RATE_OF_GET_CONFIGURED_TABLE_REQUESTS"
    CONFIGURED_TABLES_PER_PROTECTED_QUERY = "CONFIGURED_TABLES_PER_PROTECTED_QUERY"
    RATE_OF_LIST_CONFIGURED_TABLES_REQUESTS = "RATE_OF_LIST_CONFIGURED_TABLES_REQUESTS"
    RATE_OF_DELETE_CONFIGURED_TABLE_REQUESTS = "RATE_OF_DELETE_CONFIGURED_TABLE_REQUESTS"
    RATE_OF_LIST_SCHEMAS_REQUESTS = "RATE_OF_LIST_SCHEMAS_REQUESTS"
    RATE_OF_GET_PROTECTED_QUERY_REQUESTS = "RATE_OF_GET_PROTECTED_QUERY_REQUESTS"
    RATE_OF_UPDATE_CONFIGURED_TABLE_ASSOCIATION_REQUESTS = "RATE_OF_UPDATE_CONFIGURED_TABLE_ASSOCIATION_REQUESTS"
    RATE_OF_CREATE_COLLABORATION_REQUESTS = "RATE_OF_CREATE_COLLABORATION_REQUESTS"
    QUERY_TEXT_LENGTH = "QUERY_TEXT_LENGTH"
    RATE_OF_GET_COLLABORATION_REQUESTS = "RATE_OF_GET_COLLABORATION_REQUESTS"
    RATE_OF_CREATE_CONFIGURED_TABLE_ANALYSIS_RULE_REQUESTS = "RATE_OF_CREATE_CONFIGURED_TABLE_ANALYSIS_RULE_REQUESTS"
    RATE_OF_GET_SCHEMA_REQUESTS = "RATE_OF_GET_SCHEMA_REQUESTS"
    RATE_OF_CREATE_CONFIGURED_TABLE_ASSOCIATION_REQUESTS = "RATE_OF_CREATE_CONFIGURED_TABLE_ASSOCIATION_REQUESTS"
    CONFIGURED_TABLES_PER_ACCOUNT = "CONFIGURED_TABLES_PER_ACCOUNT"
    RATE_OF_DELETE_MEMBERSHIP_REQUESTS = "RATE_OF_DELETE_MEMBERSHIP_REQUESTS"
    RATE_OF_LIST_CONFIGURED_TABLE_ASSOCIATIONS_REQUESTS = "RATE_OF_LIST_CONFIGURED_TABLE_ASSOCIATIONS_REQUESTS"
    RATE_OF_GET_CONFIGURED_TABLE_ASSOCIATION_REQUESTS = "RATE_OF_GET_CONFIGURED_TABLE_ASSOCIATION_REQUESTS"
    CONCURRENT_ONGOING_QUERIES_PER_MEMBERSHIP = "CONCURRENT_ONGOING_QUERIES_PER_MEMBERSHIP"
    RATE_OF_DELETE_COLLABORATION_REQUESTS = "RATE_OF_DELETE_COLLABORATION_REQUESTS"
    RATE_OF_UPDATE_CONFIGURED_TABLE_REQUESTS = "RATE_OF_UPDATE_CONFIGURED_TABLE_REQUESTS"
    RATE_OF_UPDATE_CONFIGURED_TABLE_ANALYSIS_RULE_REQUESTS = "RATE_OF_UPDATE_CONFIGURED_TABLE_ANALYSIS_RULE_REQUESTS"
    RATE_OF_LIST_PROTECTED_QUERIES_REQUESTS = "RATE_OF_LIST_PROTECTED_QUERIES_REQUESTS"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsCloud9Quota")
class AwsCloud9Quota(enum.Enum):
    SSH_DEVELOPMENT_ENVIRONMENTS_FOR_THIS_USER = "SSH_DEVELOPMENT_ENVIRONMENTS_FOR_THIS_USER"
    SSH_DEVELOPMENT_ENVIRONMENTS_FOR_THIS_ACCOUNT = "SSH_DEVELOPMENT_ENVIRONMENTS_FOR_THIS_ACCOUNT"
    EC2_DEVELOPMENT_ENVIRONMENTS_FOR_THIS_USER = "EC2_DEVELOPMENT_ENVIRONMENTS_FOR_THIS_USER"
    EC2_DEVELOPMENT_ENVIRONMENTS_FOR_THIS_ACCOUNT = "EC2_DEVELOPMENT_ENVIRONMENTS_FOR_THIS_ACCOUNT"
    MEMBERS_PER_DEVELOPMENT_ENVIRONMENT = "MEMBERS_PER_DEVELOPMENT_ENVIRONMENT"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsCloudFormationQuota")
class AwsCloudFormationQuota(enum.Enum):
    STACK_SETS_PER_ADMINISTRATOR_ACCOUNT = "STACK_SETS_PER_ADMINISTRATOR_ACCOUNT"
    STACK_INSTANCE_OPERATIONS_PER_ADMINISTRATOR_ACCOUNT = "STACK_INSTANCE_OPERATIONS_PER_ADMINISTRATOR_ACCOUNT"
    STACK_INSTANCES_PER_STACK_SET = "STACK_INSTANCES_PER_STACK_SET"
    STACK_COUNT = "STACK_COUNT"
    OUTPUT_COUNT_IN_CLOUD_FORMATION_TEMPLATE = "OUTPUT_COUNT_IN_CLOUD_FORMATION_TEMPLATE"
    MODULE_LIMIT_PER_ACCOUNT = "MODULE_LIMIT_PER_ACCOUNT"
    PARAMETERS_DECLARED_IN_CLOUD_FORMATION_TEMPLATE = "PARAMETERS_DECLARED_IN_CLOUD_FORMATION_TEMPLATE"
    VERSION_LIMIT_PER_MODULE = "VERSION_LIMIT_PER_MODULE"
    NESTED_MODULES = "NESTED_MODULES"
    ATTRIBUTES_PER_MAPPING_IN_CLOUD_FORMATION_TEMPLATE = "ATTRIBUTES_PER_MAPPING_IN_CLOUD_FORMATION_TEMPLATE"
    DECLARED_MAPPINGS_IN_CLOUD_FORMATION_TEMPLATE = "DECLARED_MAPPINGS_IN_CLOUD_FORMATION_TEMPLATE"
    SIZE_OF_MAPPING_ATTRIBUTE_NAME = "SIZE_OF_MAPPING_ATTRIBUTE_NAME"
    SIZE_OF_OUTPUT_NAME_IN_CLOUD_FORMATION_TEMPLATE = "SIZE_OF_OUTPUT_NAME_IN_CLOUD_FORMATION_TEMPLATE"
    SIZE_OF_PARAMETER_NAME_IN_CLOUD_FORMATION_TEMPLATE = "SIZE_OF_PARAMETER_NAME_IN_CLOUD_FORMATION_TEMPLATE"
    SIZE_OF_A_RESOURCE_NAME_IN_CLOUD_FORMATION_TEMPLATE = "SIZE_OF_A_RESOURCE_NAME_IN_CLOUD_FORMATION_TEMPLATE"
    DATA_IN_CUSTOM_RESOURCE_PROVIDER = "DATA_IN_CUSTOM_RESOURCE_PROVIDER"
    SIZE_OF_A_PARAMETER_VALUE_IN_CLOUD_FORMATION_TEMPLATE = "SIZE_OF_A_PARAMETER_VALUE_IN_CLOUD_FORMATION_TEMPLATE"
    SIZE_OF_A_TEMPLATE_BODY_IN_S3_OBJECT_FOR_A_VALIDATE_STACK_REQUEST = "SIZE_OF_A_TEMPLATE_BODY_IN_S3_OBJECT_FOR_A_VALIDATE_STACK_REQUEST"
    CFN_SIGNAL_WAIT_CONDITION_DATA = "CFN_SIGNAL_WAIT_CONDITION_DATA"
    SIZE_OF_TEMPLATE_BODY_IN_CREATE_STACK_REQUEST = "SIZE_OF_TEMPLATE_BODY_IN_CREATE_STACK_REQUEST"
    RESOURCE_LIMIT_PER_ACCOUNT = "RESOURCE_LIMIT_PER_ACCOUNT"
    MAXIMUM_SIZE_OF_A_TEMPLATE_DESCRIPTION_IN_A_CLOUD_FORMATION_TEMPLATE = "MAXIMUM_SIZE_OF_A_TEMPLATE_DESCRIPTION_IN_A_CLOUD_FORMATION_TEMPLATE"
    VERSION_LIMIT_PER_RESOURCE = "VERSION_LIMIT_PER_RESOURCE"
    RESOURCES_DECLARED_IN_A_CLOUD_FORMATION_TEMPLATE = "RESOURCES_DECLARED_IN_A_CLOUD_FORMATION_TEMPLATE"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsCloudHsmQuota")
class AwsCloudHsmQuota(enum.Enum):
    HS_MS_PER_AWS_REGION_AND_AWS_ACCOUNT = "HS_MS_PER_AWS_REGION_AND_AWS_ACCOUNT"
    CLUSTERS_PER_AWS_REGION_AND_AWS_ACCOUNT = "CLUSTERS_PER_AWS_REGION_AND_AWS_ACCOUNT"
    KEYS_PER_CLOUD_HSM_CLUSTER = "KEYS_PER_CLOUD_HSM_CLUSTER"
    LENGTH_OF_A_PASSWORD = "LENGTH_OF_A_PASSWORD"
    HS_MS_PER_CLOUD_HSM_CLUSTER = "HS_MS_PER_CLOUD_HSM_CLUSTER"
    NUMBER_OF_CONCURRENT_CLIENTS = "NUMBER_OF_CONCURRENT_CLIENTS"
    USERS_PER_CLOUD_HSM_CLUSTER = "USERS_PER_CLOUD_HSM_CLUSTER"
    LENGTH_OF_A_USERNAME = "LENGTH_OF_A_USERNAME"
    MINIMUM_LENGTH_OF_A_PASSWORD = "MINIMUM_LENGTH_OF_A_PASSWORD"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsCloudMapQuota")
class AwsCloudMapQuota(enum.Enum):
    NAMESPACES_PER_REGION = "NAMESPACES_PER_REGION"
    DISCOVER_INSTANCES_OPERATION_PER_ACCOUNT_BURST_RATE = "DISCOVER_INSTANCES_OPERATION_PER_ACCOUNT_BURST_RATE"
    DISCOVER_INSTANCES_REVISION_OPERATION_PER_ACCOUNT_RATE = "DISCOVER_INSTANCES_REVISION_OPERATION_PER_ACCOUNT_RATE"
    DISCOVER_INSTANCES_OPERATION_PER_ACCOUNT_STEADY_RATE = "DISCOVER_INSTANCES_OPERATION_PER_ACCOUNT_STEADY_RATE"
    INSTANCES_PER_NAMESPACE = "INSTANCES_PER_NAMESPACE"
    INSTANCES_PER_SERVICE = "INSTANCES_PER_SERVICE"
    CUSTOM_ATTRIBUTES_PER_INSTANCE = "CUSTOM_ATTRIBUTES_PER_INSTANCE"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsCloudShellQuota")
class AwsCloudShellQuota(enum.Enum):
    DATA_RETENTION = "DATA_RETENTION"
    HOME_DIRECTORY_SIZE = "HOME_DIRECTORY_SIZE"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsCloudTrailQuota")
class AwsCloudTrailQuota(enum.Enum):
    TRANSACTIONS_PER_SECOND_TPS_FOR_THE_CANCEL_QUERY_START_QUERY_AP_IS = "TRANSACTIONS_PER_SECOND_TPS_FOR_THE_CANCEL_QUERY_START_QUERY_AP_IS"
    TRANSACTIONS_PER_SECOND_TPS_FOR_THE_LOOKUP_EVENTS_API = "TRANSACTIONS_PER_SECOND_TPS_FOR_THE_LOOKUP_EVENTS_API"
    DATA_RESOURCES_ACROSS_ALL_EVENT_SELECTORS_IN_A_TRAIL = "DATA_RESOURCES_ACROSS_ALL_EVENT_SELECTORS_IN_A_TRAIL"
    EVENT_DATA_STORES = "EVENT_DATA_STORES"
    EVENT_SIZE = "EVENT_SIZE"
    TRANSACTIONS_PER_SECOND_TPS_FOR_ALL_OTHER_AP_IS = "TRANSACTIONS_PER_SECOND_TPS_FOR_ALL_OTHER_AP_IS"
    TRAILS_PER_REGION = "TRAILS_PER_REGION"
    EVENT_SELECTORS = "EVENT_SELECTORS"
    CONDITIONS_ACROSS_ALL_ADVANCED_EVENT_SELECTORS = "CONDITIONS_ACROSS_ALL_ADVANCED_EVENT_SELECTORS"
    TRANSACTIONS_PER_SECOND_TPS_FOR_THE_GET_DESCRIBE_AND_LIST_AP_IS = "TRANSACTIONS_PER_SECOND_TPS_FOR_THE_GET_DESCRIBE_AND_LIST_AP_IS"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsCloudWanQuota")
class AwsCloudWanQuota(enum.Enum):
    DEVICES_PER_GLOBAL_NETWORK = "DEVICES_PER_GLOBAL_NETWORK"
    RETENTION_DURATION_IN_SECONDS_FOR_CORE_NETWORK_POLICIES_WITH_OUT_OF_DATE_CHANGE_SETS = "RETENTION_DURATION_IN_SECONDS_FOR_CORE_NETWORK_POLICIES_WITH_OUT_OF_DATE_CHANGE_SETS"
    PEERINGS_PER_CORE_NETWORK = "PEERINGS_PER_CORE_NETWORK"
    CONNECTIONS_PER_GLOBAL_NETWORK = "CONNECTIONS_PER_GLOBAL_NETWORK"
    CORE_NETWORK_POLICY_SIZE_IN_KB = "CORE_NETWORK_POLICY_SIZE_IN_KB"
    GLOBAL_NETWORKS_PER_ACCOUNT = "GLOBAL_NETWORKS_PER_ACCOUNT"
    EDGES_PER_REGION_PER_CORE_NETWORK = "EDGES_PER_REGION_PER_CORE_NETWORK"
    CORE_NETWORKS_PER_GLOBAL_NETWORK = "CORE_NETWORKS_PER_GLOBAL_NETWORK"
    SEGMENTS_PER_CORE_NETWORK = "SEGMENTS_PER_CORE_NETWORK"
    LINKS_PER_GLOBAL_NETWORK = "LINKS_PER_GLOBAL_NETWORK"
    ATTACHMENTS_PER_CORE_NETWORK = "ATTACHMENTS_PER_CORE_NETWORK"
    SITES_PER_GLOBAL_NETWORK = "SITES_PER_GLOBAL_NETWORK"
    CONNECT_PEERS_PER_CONNECT_ATTACHMENT = "CONNECT_PEERS_PER_CONNECT_ATTACHMENT"
    POLICY_VERSIONS_PER_CORE_NETWORK = "POLICY_VERSIONS_PER_CORE_NETWORK"
    CORE_NETWORK_ATTACHMENTS_PER_VPC = "CORE_NETWORK_ATTACHMENTS_PER_VPC"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsCodeArtifactQuota")
class AwsCodeArtifactQuota(enum.Enum):
    REQUESTS_WITHOUT_AUTHENTICATION_TOKEN_PER_IP_ADDRESS = "REQUESTS_WITHOUT_AUTHENTICATION_TOKEN_PER_IP_ADDRESS"
    LIST_PACKAGE_VERSION_ASSETS_REQUESTS_PER_SECOND = "LIST_PACKAGE_VERSION_ASSETS_REQUESTS_PER_SECOND"
    LIST_PACKAGES_REQUESTS_PER_SECOND = "LIST_PACKAGES_REQUESTS_PER_SECOND"
    WRITE_REQUESTS_PER_SECOND_FROM_A_SINGLE_AWS_ACCOUNT = "WRITE_REQUESTS_PER_SECOND_FROM_A_SINGLE_AWS_ACCOUNT"
    PUBLISH_PACKAGE_VERSION_REQUESTS_PER_SECOND = "PUBLISH_PACKAGE_VERSION_REQUESTS_PER_SECOND"
    LIST_PACKAGE_VERSIONS_REQUESTS_PER_SECOND = "LIST_PACKAGE_VERSIONS_REQUESTS_PER_SECOND"
    REQUESTS_PER_SECOND_USING_A_SINGLE_AUTHENTICATION_TOKEN = "REQUESTS_PER_SECOND_USING_A_SINGLE_AUTHENTICATION_TOKEN"
    COPY_PACKAGE_VERSIONS_REQUESTS_PER_SECOND = "COPY_PACKAGE_VERSIONS_REQUESTS_PER_SECOND"
    GET_AUTHORIZATION_TOKEN_REQUESTS_PER_SECOND = "GET_AUTHORIZATION_TOKEN_REQUESTS_PER_SECOND"
    UPSTREAM_REPOSITORIES_SEARCHED = "UPSTREAM_REPOSITORIES_SEARCHED"
    READ_REQUESTS_PER_SECOND_FROM_A_SINGLE_AWS_ACCOUNT = "READ_REQUESTS_PER_SECOND_FROM_A_SINGLE_AWS_ACCOUNT"
    DIRECT_UPSTREAMS_PER_REPOSITORY = "DIRECT_UPSTREAMS_PER_REPOSITORY"
    REPOSITORIES_PER_DOMAIN = "REPOSITORIES_PER_DOMAIN"
    DOMAINS_PER_AWS_ACCOUNT = "DOMAINS_PER_AWS_ACCOUNT"
    ASSETS_PER_PACKAGE_VERSION = "ASSETS_PER_PACKAGE_VERSION"
    ASSET_FILE_SIZE = "ASSET_FILE_SIZE"
    GET_PACKAGE_VERSION_ASSET_REQUESTS_PER_SECOND = "GET_PACKAGE_VERSION_ASSET_REQUESTS_PER_SECOND"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsCodeBuildQuota")
class AwsCodeBuildQuota(enum.Enum):
    CONCURRENTLY_RUNNING_BUILDS_FOR_LINUX_LAMBDA_2_GB_ENVIRONMENT = "CONCURRENTLY_RUNNING_BUILDS_FOR_LINUX_LAMBDA_2_GB_ENVIRONMENT"
    CONCURRENTLY_RUNNING_BUILDS_FOR_WINDOWS_SERVER_2019_MEDIUM_ENVIRONMENT = "CONCURRENTLY_RUNNING_BUILDS_FOR_WINDOWS_SERVER_2019_MEDIUM_ENVIRONMENT"
    CONCURRENTLY_RUNNING_BUILDS_FOR_LINUX_GPU_SMALL_ENVIRONMENT = "CONCURRENTLY_RUNNING_BUILDS_FOR_LINUX_GPU_SMALL_ENVIRONMENT"
    CONCURRENTLY_RUNNING_BUILDS_FOR_LINUX_LAMBDA_4_GB_ENVIRONMENT = "CONCURRENTLY_RUNNING_BUILDS_FOR_LINUX_LAMBDA_4_GB_ENVIRONMENT"
    CONCURRENTLY_RUNNING_BUILDS_FOR_WINDOWS_MEDIUM_ENVIRONMENT = "CONCURRENTLY_RUNNING_BUILDS_FOR_WINDOWS_MEDIUM_ENVIRONMENT"
    BUILD_PROJECTS = "BUILD_PROJECTS"
    CONCURRENTLY_RUNNING_BUILDS_FOR_ARM_LAMBDA_4_GB_ENVIRONMENT = "CONCURRENTLY_RUNNING_BUILDS_FOR_ARM_LAMBDA_4_GB_ENVIRONMENT"
    CONCURRENTLY_RUNNING_BUILDS_FOR_ARM_LAMBDA_1_GB_ENVIRONMENT = "CONCURRENTLY_RUNNING_BUILDS_FOR_ARM_LAMBDA_1_GB_ENVIRONMENT"
    CONCURRENTLY_RUNNING_BUILDS_FOR_LINUX_GPU_LARGE_ENVIRONMENT = "CONCURRENTLY_RUNNING_BUILDS_FOR_LINUX_GPU_LARGE_ENVIRONMENT"
    CONCURRENTLY_RUNNING_BUILDS_FOR_LINUX_LAMBDA_10_GB_ENVIRONMENT = "CONCURRENTLY_RUNNING_BUILDS_FOR_LINUX_LAMBDA_10_GB_ENVIRONMENT"
    CONCURRENTLY_RUNNING_BUILDS_FOR_LINUX_X_LARGE_ENVIRONMENT = "CONCURRENTLY_RUNNING_BUILDS_FOR_LINUX_X_LARGE_ENVIRONMENT"
    CONCURRENTLY_RUNNING_BUILDS_FOR_ARM_SMALL_ENVIRONMENT = "CONCURRENTLY_RUNNING_BUILDS_FOR_ARM_SMALL_ENVIRONMENT"
    CONCURRENTLY_RUNNING_BUILDS_FOR_LINUX_2_X_LARGE_ENVIRONMENT = "CONCURRENTLY_RUNNING_BUILDS_FOR_LINUX_2_X_LARGE_ENVIRONMENT"
    CONCURRENTLY_RUNNING_BUILDS_FOR_LINUX_LAMBDA_8_GB_ENVIRONMENT = "CONCURRENTLY_RUNNING_BUILDS_FOR_LINUX_LAMBDA_8_GB_ENVIRONMENT"
    CONCURRENTLY_RUNNING_BUILDS_FOR_LINUX_MEDIUM_ENVIRONMENT = "CONCURRENTLY_RUNNING_BUILDS_FOR_LINUX_MEDIUM_ENVIRONMENT"
    CONCURRENTLY_RUNNING_BUILDS_FOR_ARM_LARGE_ENVIRONMENT = "CONCURRENTLY_RUNNING_BUILDS_FOR_ARM_LARGE_ENVIRONMENT"
    CONCURRENTLY_RUNNING_BUILDS_FOR_ARM_LAMBDA_2_GB_ENVIRONMENT = "CONCURRENTLY_RUNNING_BUILDS_FOR_ARM_LAMBDA_2_GB_ENVIRONMENT"
    CONCURRENTLY_RUNNING_BUILDS_FOR_LINUX_LARGE_ENVIRONMENT = "CONCURRENTLY_RUNNING_BUILDS_FOR_LINUX_LARGE_ENVIRONMENT"
    CONCURRENTLY_RUNNING_BUILDS_FOR_ARM_LAMBDA_10_GB_ENVIRONMENT = "CONCURRENTLY_RUNNING_BUILDS_FOR_ARM_LAMBDA_10_GB_ENVIRONMENT"
    CONCURRENTLY_RUNNING_BUILDS_FOR_LINUX_SMALL_ENVIRONMENT = "CONCURRENTLY_RUNNING_BUILDS_FOR_LINUX_SMALL_ENVIRONMENT"
    CONCURRENTLY_RUNNING_BUILDS_FOR_WINDOWS_SERVER_2019_LARGE_ENVIRONMENT = "CONCURRENTLY_RUNNING_BUILDS_FOR_WINDOWS_SERVER_2019_LARGE_ENVIRONMENT"
    CONCURRENTLY_RUNNING_BUILDS_FOR_LINUX_LAMBDA_1_GB_ENVIRONMENT = "CONCURRENTLY_RUNNING_BUILDS_FOR_LINUX_LAMBDA_1_GB_ENVIRONMENT"
    CONCURRENTLY_RUNNING_BUILDS_FOR_ARM_LAMBDA_8_GB_ENVIRONMENT = "CONCURRENTLY_RUNNING_BUILDS_FOR_ARM_LAMBDA_8_GB_ENVIRONMENT"
    CONCURRENTLY_RUNNING_BUILDS_FOR_WINDOWS_LARGE_ENVIRONMENT = "CONCURRENTLY_RUNNING_BUILDS_FOR_WINDOWS_LARGE_ENVIRONMENT"
    MINIMUM_PERIOD_FOR_BUILD_TIMEOUT_IN_MINUTES = "MINIMUM_PERIOD_FOR_BUILD_TIMEOUT_IN_MINUTES"
    SECURITY_GROUPS_UNDER_VPC_CONFIGURATION = "SECURITY_GROUPS_UNDER_VPC_CONFIGURATION"
    CONCURRENT_REQUEST_FOR_INFORMATION_ABOUT_BUILDS = "CONCURRENT_REQUEST_FOR_INFORMATION_ABOUT_BUILDS"
    SUBNETS_UNDER_VPC_CONFIGURATION = "SUBNETS_UNDER_VPC_CONFIGURATION"
    ASSOCIATED_TAGS_PER_PROJECT = "ASSOCIATED_TAGS_PER_PROJECT"
    CONCURRENT_REQUESTS_FOR_INFORMATION_ON_BUILD_PROJECTS = "CONCURRENT_REQUESTS_FOR_INFORMATION_ON_BUILD_PROJECTS"
    BUILD_TIMEOUT_IN_MINUTES = "BUILD_TIMEOUT_IN_MINUTES"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsCodeCommitQuota")
class AwsCodeCommitQuota(enum.Enum):
    ALLOWED_REPOSITORIES = "ALLOWED_REPOSITORIES"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsCodeDeployQuota")
class AwsCodeDeployQuota(enum.Enum):
    AWS_LAMBDA_DEPLOYMENT_RUN_IN_HOURS = "AWS_LAMBDA_DEPLOYMENT_RUN_IN_HOURS"
    TRAFFIC_THAT_CAN_BE_SHIFTED_IN_ONE_INCREMENT_DURING_AN_AWS_LAMBDA_DEPLOYMENT = "TRAFFIC_THAT_CAN_BE_SHIFTED_IN_ONE_INCREMENT_DURING_AN_AWS_LAMBDA_DEPLOYMENT"
    MINUTES_BETWEEN_THE_FIRST_AND_LAST_TRAFFIC_SHIFT_DURING_AN_AWS_LAMBDA_CANARY_OR_LINEAR_DEPLOYMENT = "MINUTES_BETWEEN_THE_FIRST_AND_LAST_TRAFFIC_SHIFT_DURING_AN_AWS_LAMBDA_CANARY_OR_LINEAR_DEPLOYMENT"
    NUMBER_OF_INSTANCES_USED_BY_CONCURRENT_DEPLOYMENTS_THAT_ARE_IN_PROGRESS_PER_ACCOUNT = "NUMBER_OF_INSTANCES_USED_BY_CONCURRENT_DEPLOYMENTS_THAT_ARE_IN_PROGRESS_PER_ACCOUNT"
    EC2_ON_PREMISES_BLUE_GREEN_DEPLOYMENT_RUN_IN_HOURS = "EC2_ON_PREMISES_BLUE_GREEN_DEPLOYMENT_RUN_IN_HOURS"
    SIZE_OF_DEPLOYMENT_GROUP_NAME = "SIZE_OF_DEPLOYMENT_GROUP_NAME"
    SIZE_OF_TAG_VALUE = "SIZE_OF_TAG_VALUE"
    SECONDS_UNTIL_A_DEPLOYMENT_LIFECYCLE_EVENT_FAILS_IF_NOT_COMPLETED = "SECONDS_UNTIL_A_DEPLOYMENT_LIFECYCLE_EVENT_FAILS_IF_NOT_COMPLETED"
    NUMBER_OF_LISTENERS_FOR_A_TRAFFIC_ROUTE_DURING_AN_AMAZON_ECS_DEPLOYMENT = "NUMBER_OF_LISTENERS_FOR_A_TRAFFIC_ROUTE_DURING_AN_AMAZON_ECS_DEPLOYMENT"
    MINUTES_UNTIL_A_DEPLOYMENT_FAILS_IF_A_LIFECYCLE_EVENT_DOESN_T_START = "MINUTES_UNTIL_A_DEPLOYMENT_FAILS_IF_A_LIFECYCLE_EVENT_DOESN_T_START"
    NUMBER_OF_INSTANCES_THAT_CAN_BE_PASSED_TO_THE_BATCH_GET_ON_PREMISES_INSTANCES_API_ACTION = "NUMBER_OF_INSTANCES_THAT_CAN_BE_PASSED_TO_THE_BATCH_GET_ON_PREMISES_INSTANCES_API_ACTION"
    EC2_ON_PREMISES_IN_PLACE_DEPLOYMENT_RUN_IN_HOURS = "EC2_ON_PREMISES_IN_PLACE_DEPLOYMENT_RUN_IN_HOURS"
    DEPLOYMENT_GROUPS_ASSOCIATED_WITH_A_SINGLE_APPLICATION = "DEPLOYMENT_GROUPS_ASSOCIATED_WITH_A_SINGLE_APPLICATION"
    CONCURRENT_DEPLOYMENTS_PER_DEPLOYMENT_GROUP = "CONCURRENT_DEPLOYMENTS_PER_DEPLOYMENT_GROUP"
    MINUTES_A_BLUE_GREEN_DEPLOYMENT_CAN_WAIT_AFTER_A_SUCCESSFUL_DEPLOYMENT_BEFORE_TERMINATING_INSTANCES_FROM_THE_ORIGINAL_DEPLOYMENT = "MINUTES_A_BLUE_GREEN_DEPLOYMENT_CAN_WAIT_AFTER_A_SUCCESSFUL_DEPLOYMENT_BEFORE_TERMINATING_INSTANCES_FROM_THE_ORIGINAL_DEPLOYMENT"
    EVENT_NOTIFICATION_TRIGGERS_IN_A_DEPLOYMENT_GROUP = "EVENT_NOTIFICATION_TRIGGERS_IN_A_DEPLOYMENT_GROUP"
    GIT_HUB_CONNECTION_TOKENS_PER_ACCOUNT = "GIT_HUB_CONNECTION_TOKENS_PER_ACCOUNT"
    SIZE_OF_TAG_KEY = "SIZE_OF_TAG_KEY"
    APPLICATIONS_ASSOCIATED_PER_ACCOUNT_PER_REGION = "APPLICATIONS_ASSOCIATED_PER_ACCOUNT_PER_REGION"
    TAGS_IN_A_DEPLOYMENT_GROUP = "TAGS_IN_A_DEPLOYMENT_GROUP"
    AUTO_SCALING_GROUPS_IN_A_DEPLOYMENT_GROUP = "AUTO_SCALING_GROUPS_IN_A_DEPLOYMENT_GROUP"
    CONCURRENT_DEPLOYMENTS_PER_ACCOUNT = "CONCURRENT_DEPLOYMENTS_PER_ACCOUNT"
    HOURS_BETWEEN_THE_COMPLETION_OF_A_DEPLOYMENT_AND_THE_TERMINATION_OF_THE_ORIGINAL_INSTANCES_DURING_AN_EC2_ON_PREMISES_BLUE_GREEN_DEPLOYMENT = "HOURS_BETWEEN_THE_COMPLETION_OF_A_DEPLOYMENT_AND_THE_TERMINATION_OF_THE_ORIGINAL_INSTANCES_DURING_AN_EC2_ON_PREMISES_BLUE_GREEN_DEPLOYMENT"
    CUSTOM_DEPLOYMENT_CONFIGURATIONS_PER_ACCOUNT = "CUSTOM_DEPLOYMENT_CONFIGURATIONS_PER_ACCOUNT"
    INSTANCES_COUNT_PER_DEPLOYMENT = "INSTANCES_COUNT_PER_DEPLOYMENT"
    NUMBER_OF_DEPLOYMENT_GROUPS_THAT_CAN_BE_ASSOCIATED_WITH_AN_AMAZON_ECS_SERVICE = "NUMBER_OF_DEPLOYMENT_GROUPS_THAT_CAN_BE_ASSOCIATED_WITH_AN_AMAZON_ECS_SERVICE"
    HOURS_BETWEEN_THE_DEPLOYMENT_OF_A_REVISION_AND_WHEN_TRAFFIC_SHIFTS_TO_THE_REPLACEMENT_INSTANCES_DURING_AN_EC2_ON_PREMISES_BLUE_GREEN_DEPLOYMENT = "HOURS_BETWEEN_THE_DEPLOYMENT_OF_A_REVISION_AND_WHEN_TRAFFIC_SHIFTS_TO_THE_REPLACEMENT_INSTANCES_DURING_AN_EC2_ON_PREMISES_BLUE_GREEN_DEPLOYMENT"
    ASSOCIATED_ALARMS_PER_DEPLOYMENT_GROUP = "ASSOCIATED_ALARMS_PER_DEPLOYMENT_GROUP"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsCodePipelineQuota")
class AwsCodePipelineQuota(enum.Enum):
    TOTAL_PIPELINES = "TOTAL_PIPELINES"
    TOTAL_ACTIONS_PER_PIPELINE = "TOTAL_ACTIONS_PER_PIPELINE"
    TOTAL_PARALLEL_ACTIONS_PER_STAGE = "TOTAL_PARALLEL_ACTIONS_PER_STAGE"
    MINIMUM_ACTIONS = "MINIMUM_ACTIONS"
    TOTAL_PIPELINES_WITH_CHANGE_DETECTION_SET_TO_PERIODICALLY_CHECKING_FOR_SOURCE_CHANGES = "TOTAL_PIPELINES_WITH_CHANGE_DETECTION_SET_TO_PERIODICALLY_CHECKING_FOR_SOURCE_CHANGES"
    TOTAL_SEQUENTIAL_ACTIONS_PER_STAGE = "TOTAL_SEQUENTIAL_ACTIONS_PER_STAGE"
    TOTAL_CUSTOM_ACTIONS = "TOTAL_CUSTOM_ACTIONS"
    MINIMUM_STAGES_PER_PIPELINE = "MINIMUM_STAGES_PER_PIPELINE"
    TOTAL_STAGES_PER_PIPELINE = "TOTAL_STAGES_PER_PIPELINE"
    TOTAL_WEBHOOKS = "TOTAL_WEBHOOKS"
    TOTAL_ACTIONS_PER_STAGE = "TOTAL_ACTIONS_PER_STAGE"
    TOTAL_JSON_OBJECT_SIZE_FOR_PARAMETER_OVERRIDES = "TOTAL_JSON_OBJECT_SIZE_FOR_PARAMETER_OVERRIDES"
    AWS_CODE_DEPLOY_ECS_BLUE_GREEN_ACTION_TIMEOUT = "AWS_CODE_DEPLOY_ECS_BLUE_GREEN_ACTION_TIMEOUT"
    AWS_CODE_DEPLOY_ACTION_TIMEOUT = "AWS_CODE_DEPLOY_ACTION_TIMEOUT"
    TOTAL_IMAGE_DEFINITIONS_JSON_FILE_SIZE = "TOTAL_IMAGE_DEFINITIONS_JSON_FILE_SIZE"
    APPROVAL_ACTION_TIMEOUT = "APPROVAL_ACTION_TIMEOUT"
    ACTION_CONFIGURATION_KEY_LENGTH = "ACTION_CONFIGURATION_KEY_LENGTH"
    TOTAL_PERIOD_FOR_EXECUTION_HISTORY = "TOTAL_PERIOD_FOR_EXECUTION_HISTORY"
    TOTAL_SOURCE_ARTIFACT_SIZE_FOR_AMAZON_EBS_DEPLOYMENTS = "TOTAL_SOURCE_ARTIFACT_SIZE_FOR_AMAZON_EBS_DEPLOYMENTS"
    ACTION_CONFIGURATION_VALUE_LENGTH = "ACTION_CONFIGURATION_VALUE_LENGTH"
    AWS_CLOUD_FORMATION_ACTION_TIMEOUT = "AWS_CLOUD_FORMATION_ACTION_TIMEOUT"
    AWS_LAMBDA_ACTION_TIMEOUT = "AWS_LAMBDA_ACTION_TIMEOUT"
    AMAZON_S3_DEPLOYMENT_ACTION_TIMEOUT = "AMAZON_S3_DEPLOYMENT_ACTION_TIMEOUT"
    TOTAL_AMAZON_S3_SOURCE_ARTIFACT_SIZE = "TOTAL_AMAZON_S3_SOURCE_ARTIFACT_SIZE"
    AWS_CODE_BUILD_ACTION_TIMEOUT = "AWS_CODE_BUILD_ACTION_TIMEOUT"
    TOTAL_INPUT_ARTIFACT_SIZE_FOR_AWS_CLOUD_FORMATION_DEPLOYMENTS = "TOTAL_INPUT_ARTIFACT_SIZE_FOR_AWS_CLOUD_FORMATION_DEPLOYMENTS"
    ACTION_TIMEOUT = "ACTION_TIMEOUT"
    TOTAL_AWS_CODE_COMMIT_OR_GIT_HUB_SOURCE_ARTIFACT_SIZE = "TOTAL_AWS_CODE_COMMIT_OR_GIT_HUB_SOURCE_ARTIFACT_SIZE"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsComputeOptimizerQuota")
class AwsComputeOptimizerQuota(enum.Enum):
    THE_NUMBER_OF_API_CALLS_PER_SECOND_PER_ACCOUNT = "THE_NUMBER_OF_API_CALLS_PER_SECOND_PER_ACCOUNT"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsConfigQuota")
class AwsConfigQuota(enum.Enum):
    AWS_CONFIG_RULES_PER_REGION = "AWS_CONFIG_RULES_PER_REGION"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsCostExplorerQuota")
class AwsCostExplorerQuota(enum.Enum):
    NUMBER_OF_ANOMALY_ALERT_SUBSCRIPTIONS = "NUMBER_OF_ANOMALY_ALERT_SUBSCRIPTIONS"
    NUMBER_OF_LINKED_ACCOUNT_COST_CATEGORY_AND_COST_ALLOCATION_TAG_ANOMALY_MONITORS = "NUMBER_OF_LINKED_ACCOUNT_COST_CATEGORY_AND_COST_ALLOCATION_TAG_ANOMALY_MONITORS"
    NUMBER_OF_AWS_SERVICES_ANOMALY_MONITORS = "NUMBER_OF_AWS_SERVICES_ANOMALY_MONITORS"
    NUMBER_OF_ACTIVE_COST_ALLOCATION_TAG_KEYS = "NUMBER_OF_ACTIVE_COST_ALLOCATION_TAG_KEYS"
    NUMBER_OF_REFRESH_REQUESTS_FOR_SAVINGS_PLANS_RECOMMENDATIONS_PER_DAY = "NUMBER_OF_REFRESH_REQUESTS_FOR_SAVINGS_PLANS_RECOMMENDATIONS_PER_DAY"
    NUMBER_OF_RULES_PER_COST_CATEGORY_UI = "NUMBER_OF_RULES_PER_COST_CATEGORY_UI"
    NUMBER_OF_COST_CATEGORIES = "NUMBER_OF_COST_CATEGORIES"
    COST_EXPLORER_SAVED_REPORTS = "COST_EXPLORER_SAVED_REPORTS"
    NUMBER_OF_RULES_PER_COST_CATEGORY_API = "NUMBER_OF_RULES_PER_COST_CATEGORY_API"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsDataExchangeQuota")
class AwsDataExchangeQuota(enum.Enum):
    CONCURRENT_IN_PROGRESS_JOBS_TO_CREATE_DATA_GRANTS = "CONCURRENT_IN_PROGRESS_JOBS_TO_CREATE_DATA_GRANTS"
    REVISIONS_PER_AMAZON_S3_DATA_ACCESS_DATA_SET = "REVISIONS_PER_AMAZON_S3_DATA_ACCESS_DATA_SET"
    AWS_LAKE_FORMATION_DATA_PERMISSION_ASSETS_PER_REVISION = "AWS_LAKE_FORMATION_DATA_PERMISSION_ASSETS_PER_REVISION"
    ASSET_PER_EXPORT_JOB_FROM_AMAZON_S3 = "ASSET_PER_EXPORT_JOB_FROM_AMAZON_S3"
    CONCURRENT_IN_PROGRESS_JOBS_TO_IMPORT_ASSETS_FROM_AMAZON_S3 = "CONCURRENT_IN_PROGRESS_JOBS_TO_IMPORT_ASSETS_FROM_AMAZON_S3"
    CONCURRENT_IN_PROGRESS_JOBS_TO_IMPORT_ASSETS_FROM_AN_AWS_LAKE_FORMATION_TAG_POLICY = "CONCURRENT_IN_PROGRESS_JOBS_TO_IMPORT_ASSETS_FROM_AN_AWS_LAKE_FORMATION_TAG_POLICY"
    CONCURRENT_IN_PROGRESS_JOBS_TO_IMPORT_ASSETS_FROM_AMAZON_API_GATEWAY = "CONCURRENT_IN_PROGRESS_JOBS_TO_IMPORT_ASSETS_FROM_AMAZON_API_GATEWAY"
    PENDING_DATA_GRANTS_PER_CONSUMER = "PENDING_DATA_GRANTS_PER_CONSUMER"
    CONCURRENT_IN_PROGRESS_JOBS_TO_CREATE_AMAZON_S3_DATA_ACCESS_ASSETS_FROM_S3_BUCKETS = "CONCURRENT_IN_PROGRESS_JOBS_TO_CREATE_AMAZON_S3_DATA_ACCESS_ASSETS_FROM_S3_BUCKETS"
    ASSETS_PER_IMPORT_JOB_FROM_AMAZON_S3 = "ASSETS_PER_IMPORT_JOB_FROM_AMAZON_S3"
    REVISIONS_PER_ADD_REVISIONS_CHANGE_SET = "REVISIONS_PER_ADD_REVISIONS_CHANGE_SET"
    PRIVATE_OFFERS_PER_ACCOUNT = "PRIVATE_OFFERS_PER_ACCOUNT"
    DATA_SETS_PER_PRODUCT = "DATA_SETS_PER_PRODUCT"
    REVISIONS_PER_DATA_SET = "REVISIONS_PER_DATA_SET"
    ASSETS_PER_REVISION = "ASSETS_PER_REVISION"
    PRODUCTS_PER_ACCOUNT = "PRODUCTS_PER_ACCOUNT"
    REVISIONS_PER_AMAZON_API_GATEWAY_API_DATA_SET = "REVISIONS_PER_AMAZON_API_GATEWAY_API_DATA_SET"
    REVISIONS_PER_AWS_LAKE_FORMATION_DATA_PERMISSION_DATA_SET = "REVISIONS_PER_AWS_LAKE_FORMATION_DATA_PERMISSION_DATA_SET"
    BRING_YOUR_OWN_SUBSCRIPTION_OFFERS_PER_ACCOUNT = "BRING_YOUR_OWN_SUBSCRIPTION_OFFERS_PER_ACCOUNT"
    CONCURRENT_IN_PROGRESS_JOBS_TO_IMPORT_ASSETS_FROM_A_SIGNED_URL = "CONCURRENT_IN_PROGRESS_JOBS_TO_IMPORT_ASSETS_FROM_A_SIGNED_URL"
    CONCURRENT_IN_PROGRESS_JOBS_TO_EXPORT_ASSETS_TO_AMAZON_S3 = "CONCURRENT_IN_PROGRESS_JOBS_TO_EXPORT_ASSETS_TO_AMAZON_S3"
    DATA_SETS_PER_ACCOUNT = "DATA_SETS_PER_ACCOUNT"
    ASSET_SIZE_IN_GB = "ASSET_SIZE_IN_GB"
    PRODUCTS_PER_DATA_SET = "PRODUCTS_PER_DATA_SET"
    AMAZON_API_GATEWAY_API_ASSETS_PER_REVISION = "AMAZON_API_GATEWAY_API_ASSETS_PER_REVISION"
    CONCURRENT_IN_PROGRESS_JOBS_TO_DELETE_DATA_GRANTS = "CONCURRENT_IN_PROGRESS_JOBS_TO_DELETE_DATA_GRANTS"
    CONCURRENT_IN_PROGRESS_JOBS_TO_EXPORT_REVISIONS_TO_AMAZON_S3 = "CONCURRENT_IN_PROGRESS_JOBS_TO_EXPORT_REVISIONS_TO_AMAZON_S3"
    CONCURRENT_IN_PROGRESS_JOBS_TO_EXPORT_ASSETS_TO_A_SIGNED_URL = "CONCURRENT_IN_PROGRESS_JOBS_TO_EXPORT_ASSETS_TO_A_SIGNED_URL"
    ACTIVE_AND_PENDING_DATA_GRANTS = "ACTIVE_AND_PENDING_DATA_GRANTS"
    AMAZON_S3_DATA_ACCESS_ASSETS_PER_REVISION = "AMAZON_S3_DATA_ACCESS_ASSETS_PER_REVISION"
    AMAZON_REDSHIFT_DATASHARE_ASSETS_PER_IMPORT_JOB_FROM_REDSHIFT = "AMAZON_REDSHIFT_DATASHARE_ASSETS_PER_IMPORT_JOB_FROM_REDSHIFT"
    AMAZON_REDSHIFT_DATASHARE_ASSETS_PER_REVISION = "AMAZON_REDSHIFT_DATASHARE_ASSETS_PER_REVISION"
    EVENT_ACTIONS_PER_ACCOUNT = "EVENT_ACTIONS_PER_ACCOUNT"
    CONCURRENT_IN_PROGRESS_JOBS_TO_IMPORT_ASSETS_FROM_AMAZON_REDSHIFT_DATASHARES = "CONCURRENT_IN_PROGRESS_JOBS_TO_IMPORT_ASSETS_FROM_AMAZON_REDSHIFT_DATASHARES"
    SAMPLE_FILE_SIZE_IN_MB = "SAMPLE_FILE_SIZE_IN_MB"
    SAMPLES_PER_PRODUCT = "SAMPLES_PER_PRODUCT"
    REVISIONS_PER_AMAZON_REDSHIFT_DATASHARE_DATA_SET = "REVISIONS_PER_AMAZON_REDSHIFT_DATASHARE_DATA_SET"
    AUTO_EXPORT_EVENT_ACTIONS_PER_DATA_SET = "AUTO_EXPORT_EVENT_ACTIONS_PER_DATA_SET"
    DATA_DICTIONARY_FILE_SIZE_IN_MB = "DATA_DICTIONARY_FILE_SIZE_IN_MB"
    DATA_DICTIONARIES_PER_PRODUCT = "DATA_DICTIONARIES_PER_PRODUCT"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsDataPipelineQuota")
class AwsDataPipelineQuota(enum.Enum):
    RATE_OF_CREATION_OF_AN_INSTANCE_FROM_AN_OBJECT = "RATE_OF_CREATION_OF_AN_INSTANCE_FROM_AN_OBJECT"
    NUMBER_OF_OBJECTS_PER_PIPELINE = "NUMBER_OF_OBJECTS_PER_PIPELINE"
    NUMBER_OF_FIELDS_PER_OBJECT = "NUMBER_OF_FIELDS_PER_OBJECT"
    NUMBER_OF_ROLL_UPS_INTO_A_SINGLE_OBJECT = "NUMBER_OF_ROLL_UPS_INTO_A_SINGLE_OBJECT"
    NUMBER_OF_EC2_INSTANCES_PER_EC2_RESOURCE_OBJECT = "NUMBER_OF_EC2_INSTANCES_PER_EC2_RESOURCE_OBJECT"
    NUMBER_OF_UTF8_BYTES_PER_OBJECT = "NUMBER_OF_UTF8_BYTES_PER_OBJECT"
    NUMBER_OF_UTF8_BYTES_PER_FIELD = "NUMBER_OF_UTF8_BYTES_PER_FIELD"
    RETRIES_OF_A_PIPELINE_ACTIVITY_PER_TASK = "RETRIES_OF_A_PIPELINE_ACTIVITY_PER_TASK"
    NUMBER_OF_PIPELINES_YOU_CAN_CREATE = "NUMBER_OF_PIPELINES_YOU_CAN_CREATE"
    MINIMUM_DELAY_BETWEEN_RETRY_ATTEMPTS_IN_MINUTES = "MINIMUM_DELAY_BETWEEN_RETRY_ATTEMPTS_IN_MINUTES"
    NUMBER_OF_ACTIVE_INSTANCES_PER_OBJECT = "NUMBER_OF_ACTIVE_INSTANCES_PER_OBJECT"
    MINIMUM_SCHEDULING_INTERVAL_IN_MINUTES = "MINIMUM_SCHEDULING_INTERVAL_IN_MINUTES"
    NUMBER_OF_UTF8_BYTES_PER_FIELD_NAME_OR_IDENTIFIER = "NUMBER_OF_UTF8_BYTES_PER_FIELD_NAME_OR_IDENTIFIER"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsDataSyncQuota")
class AwsDataSyncQuota(enum.Enum):
    TASKS = "TASKS"
    THROUGHPUT_PER_TASK = "THROUGHPUT_PER_TASK"
    FILES_PER_TASK = "FILES_PER_TASK"


@jsii.enum(
    jsii_type="@reapit-cdk/service-quotas.AwsDatabaseMigrationServiceAwsDmsQuota"
)
class AwsDatabaseMigrationServiceAwsDmsQuota(enum.Enum):
    ENDPOINT_COUNT = "ENDPOINT_COUNT"
    TASK_COUNT = "TASK_COUNT"
    SERVERLESS_REPLICATIONS = "SERVERLESS_REPLICATIONS"
    ENDPOINTS_PER_INSTANCE = "ENDPOINTS_PER_INSTANCE"
    SUBNET_GROUPS = "SUBNET_GROUPS"
    EVENT_SUBSCRIPTIONS = "EVENT_SUBSCRIPTIONS"
    SUBNETS_PER_SUBNET_GROUP = "SUBNETS_PER_SUBNET_GROUP"
    CERTIFICATE_COUNT = "CERTIFICATE_COUNT"
    TOTAL_STORAGE = "TOTAL_STORAGE"
    REPLICATION_INSTANCES = "REPLICATION_INSTANCES"
    NUMBER_OF_RUNNING_DATA_MIGRATIONS = "NUMBER_OF_RUNNING_DATA_MIGRATIONS"
    NUMBER_OF_MONITORED_OBJECTS_IN_DMS_FLEET_ADVISOR_COLLECTOR = "NUMBER_OF_MONITORED_OBJECTS_IN_DMS_FLEET_ADVISOR_COLLECTOR"
    NUMBER_OF_DMS_FLEET_ADVISOR_COLLECTOR_INSTANCES = "NUMBER_OF_DMS_FLEET_ADVISOR_COLLECTOR_INSTANCES"
    NUMBER_OF_DATA_FILES_DMS_FLEET_ADVISOR_CAN_SEND_PER_HOUR = "NUMBER_OF_DATA_FILES_DMS_FLEET_ADVISOR_CAN_SEND_PER_HOUR"
    NUMBER_OF_DATA_MIGRATIONS = "NUMBER_OF_DATA_MIGRATIONS"
    NUMBER_OF_DATABASE_OBJECTS_DMS_FLEET_ADVISOR_CAN_PROCESS = "NUMBER_OF_DATABASE_OBJECTS_DMS_FLEET_ADVISOR_CAN_PROCESS"
    NUMBER_OF_MIGRATION_PROJECTS = "NUMBER_OF_MIGRATION_PROJECTS"
    THE_AMOUNT_OF_COLLECTED_DATA_IN_DMS_FLEET_ADVISOR = "THE_AMOUNT_OF_COLLECTED_DATA_IN_DMS_FLEET_ADVISOR"
    NUMBER_OF_DATA_MIGRATIONS_PER_MIGRATION_PROJECT = "NUMBER_OF_DATA_MIGRATIONS_PER_MIGRATION_PROJECT"
    NUMBER_OF_INSTANCE_PROFILES = "NUMBER_OF_INSTANCE_PROFILES"
    NUMBER_OF_DATA_PROVIDERS = "NUMBER_OF_DATA_PROVIDERS"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsDeepRacerQuota")
class AwsDeepRacerQuota(enum.Enum):
    EVALUATION_JOBS = "EVALUATION_JOBS"
    CARS = "CARS"
    TRAINING_JOBS = "TRAINING_JOBS"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsDirectConnectQuota")
class AwsDirectConnectQuota(enum.Enum):
    ACTIVE_AWS_DIRECT_CONNECT_DEDICATED_CONNECTIONS_PER_LOCATION = "ACTIVE_AWS_DIRECT_CONNECT_DEDICATED_CONNECTIONS_PER_LOCATION"
    TRANSIT_GATEWAYS_PER_AWS_DIRECT_CONNECT_GATEWAY = "TRANSIT_GATEWAYS_PER_AWS_DIRECT_CONNECT_GATEWAY"
    DEDICATED_CONNECTIONS_OR_INTERCONNECTS_PER_LINK_AGGREGATION_GROUP_LAG = "DEDICATED_CONNECTIONS_OR_INTERCONNECTS_PER_LINK_AGGREGATION_GROUP_LAG"
    NUMBER_OF_PREFIXES_PER_AWS_TRANSIT_GATEWAY_FROM_AWS_TO_ON_PREMISES_ON_A_TRANSIT_VIRTUAL_INTERFACE = "NUMBER_OF_PREFIXES_PER_AWS_TRANSIT_GATEWAY_FROM_AWS_TO_ON_PREMISES_ON_A_TRANSIT_VIRTUAL_INTERFACE"
    LINK_AGGREGATION_GROUPS_LA_GS_PER_AWS_REGION = "LINK_AGGREGATION_GROUPS_LA_GS_PER_AWS_REGION"
    VIRTUAL_PRIVATE_GATEWAYS_PER_AWS_DIRECT_CONNECT_GATEWAY = "VIRTUAL_PRIVATE_GATEWAYS_PER_AWS_DIRECT_CONNECT_GATEWAY"
    GLOBAL_MAXIMUM_NUMBER_OF_AWS_DIRECT_CONNECT_GATEWAYS = "GLOBAL_MAXIMUM_NUMBER_OF_AWS_DIRECT_CONNECT_GATEWAYS"
    PRIVATE_OR_PUBLIC_VIRTUAL_INTERFACES_PER_AWS_DIRECT_CONNECT_DEDICATED_CONNECTION = "PRIVATE_OR_PUBLIC_VIRTUAL_INTERFACES_PER_AWS_DIRECT_CONNECT_DEDICATED_CONNECTION"
    VIRTUAL_INTERFACES_PER_AWS_DIRECT_CONNECT_GATEWAY = "VIRTUAL_INTERFACES_PER_AWS_DIRECT_CONNECT_GATEWAY"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsDirectoryServiceQuota")
class AwsDirectoryServiceQuota(enum.Enum):
    AWS_MANAGED_MICROSOFT_AD_MANUAL_SNAPSHOTS = "AWS_MANAGED_MICROSOFT_AD_MANUAL_SNAPSHOTS"
    AWS_MANAGED_MICROSOFT_AD_DOMAIN_CONTROLLERS = "AWS_MANAGED_MICROSOFT_AD_DOMAIN_CONTROLLERS"
    SIMPLE_AD_MANUAL_SNAPSHOTS = "SIMPLE_AD_MANUAL_SNAPSHOTS"
    AWS_MANAGED_MICROSOFT_AD_DIRECTORIES = "AWS_MANAGED_MICROSOFT_AD_DIRECTORIES"
    AD_CONNECTOR_DIRECTORIES = "AD_CONNECTOR_DIRECTORIES"
    SIMPLE_AD_DIRECTORIES = "SIMPLE_AD_DIRECTORIES"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsElasticBeanstalkQuota")
class AwsElasticBeanstalkQuota(enum.Enum):
    CONFIGURATION_TEMPLATES = "CONFIGURATION_TEMPLATES"
    APPLICATIONS = "APPLICATIONS"
    APPLICATION_VERSIONS = "APPLICATION_VERSIONS"
    CUSTOM_PLATFORM_VERSIONS = "CUSTOM_PLATFORM_VERSIONS"
    ENVIRONMENTS = "ENVIRONMENTS"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsElementalMediaConnectQuota")
class AwsElementalMediaConnectQuota(enum.Enum):
    FLOWS = "FLOWS"
    OUTPUTS = "OUTPUTS"
    ENTITLEMENTS = "ENTITLEMENTS"
    BRIDGES = "BRIDGES"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsElementalMediaConvertQuota")
class AwsElementalMediaConvertQuota(enum.Enum):
    REQUEST_RATE_FOR_DESCRIBE_ENDPOINTS_IN_A_BURST = "REQUEST_RATE_FOR_DESCRIBE_ENDPOINTS_IN_A_BURST"
    REQUEST_RATE_FOR_DESCRIBE_ENDPOINTS = "REQUEST_RATE_FOR_DESCRIBE_ENDPOINTS"
    CUSTOM_OUTPUT_PRESETS = "CUSTOM_OUTPUT_PRESETS"
    CUSTOM_JOB_TEMPLATES = "CUSTOM_JOB_TEMPLATES"
    REQUEST_RATE_FOR_API_CALLS_PER_OPERATION = "REQUEST_RATE_FOR_API_CALLS_PER_OPERATION"
    QUEUES_RESERVED_PER_REGION_PER_ACCOUNT = "QUEUES_RESERVED_PER_REGION_PER_ACCOUNT"
    QUEUES_ON_DEMAND_PER_REGION_PER_ACCOUNT = "QUEUES_ON_DEMAND_PER_REGION_PER_ACCOUNT"
    CONCURRENT_JOBS_PER_ON_DEMAND_QUEUE_PEAK = "CONCURRENT_JOBS_PER_ON_DEMAND_QUEUE_PEAK"
    REQUEST_RATE_FOR_API_CALLS_PER_OPERATION_IN_A_BURST = "REQUEST_RATE_FOR_API_CALLS_PER_OPERATION_IN_A_BURST"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsElementalMediaLiveQuota")
class AwsElementalMediaLiveQuota(enum.Enum):
    INPUT_SECURITY_GROUPS = "INPUT_SECURITY_GROUPS"
    MULTIPLEXES = "MULTIPLEXES"
    VPC_INPUTS = "VPC_INPUTS"
    RESERVATIONS = "RESERVATIONS"
    HEVC_CHANNELS = "HEVC_CHANNELS"
    MEDIA_LIVE_DESCRIBE_THUMBNAILS_TPS = "MEDIA_LIVE_DESCRIBE_THUMBNAILS_TPS"
    PULL_INPUTS = "PULL_INPUTS"
    DEVICE_INPUTS = "DEVICE_INPUTS"
    UHD_CHANNELS = "UHD_CHANNELS"
    CHANNELS = "CHANNELS"
    CDI_CHANNELS = "CDI_CHANNELS"
    PUSH_INPUTS = "PUSH_INPUTS"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsElementalMediaPackageQuota")
class AwsElementalMediaPackageQuota(enum.Enum):
    BURST_RATE_OF_REST_API_REQUESTS_LIVE = "BURST_RATE_OF_REST_API_REQUESTS_LIVE"
    RATE_OF_REST_API_REQUESTS_VOD = "RATE_OF_REST_API_REQUESTS_VOD"
    ENDPOINTS_PER_CHANNEL = "ENDPOINTS_PER_CHANNEL"
    RATE_OF_MANIFEST_EGRESS_REQUESTS_PER_ASSET = "RATE_OF_MANIFEST_EGRESS_REQUESTS_PER_ASSET"
    PACKAGING_CONFIGURATIONS_PER_PACKAGING_GROUP = "PACKAGING_CONFIGURATIONS_PER_PACKAGING_GROUP"
    RATE_OF_SEGMENT_EGRESS_REQUESTS_PER_ORIGIN_ENDPOINT = "RATE_OF_SEGMENT_EGRESS_REQUESTS_PER_ORIGIN_ENDPOINT"
    PACKAGING_GROUPS = "PACKAGING_GROUPS"
    CHANNELS = "CHANNELS"
    RATE_OF_REST_API_REQUESTS_LIVE = "RATE_OF_REST_API_REQUESTS_LIVE"
    BURST_RATE_OF_REST_API_REQUESTS_VOD = "BURST_RATE_OF_REST_API_REQUESTS_VOD"
    CONTENT_RETENTION = "CONTENT_RETENTION"
    ASSETS_PER_PACKAGING_GROUP = "ASSETS_PER_PACKAGING_GROUP"
    LIVE_MANIFEST_LENGTH = "LIVE_MANIFEST_LENGTH"
    RATE_OF_SEGMENT_EGRESS_REQUESTS_PER_ASSET = "RATE_OF_SEGMENT_EGRESS_REQUESTS_PER_ASSET"
    INGEST_STREAMS_PER_ASSET = "INGEST_STREAMS_PER_ASSET"
    CONCURRENT_HARVEST_JOBS = "CONCURRENT_HARVEST_JOBS"
    TRACKS_PER_INGEST_STREAM_LIVE = "TRACKS_PER_INGEST_STREAM_LIVE"
    INGEST_STREAMS_PER_CHANNEL = "INGEST_STREAMS_PER_CHANNEL"
    TRACKS_PER_INGEST_STREAM_VOD = "TRACKS_PER_INGEST_STREAM_VOD"
    RATE_OF_INGEST_REQUESTS_PER_CHANNEL = "RATE_OF_INGEST_REQUESTS_PER_CHANNEL"
    RATE_OF_MANIFEST_EGRESS_REQUESTS_PER_ORIGIN_ENDPOINT = "RATE_OF_MANIFEST_EGRESS_REQUESTS_PER_ORIGIN_ENDPOINT"
    TIME_SHIFTED_MANIFEST_LENGTH = "TIME_SHIFTED_MANIFEST_LENGTH"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsElementalMediaPackageV2Quota")
class AwsElementalMediaPackageV2Quota(enum.Enum):
    CHANNEL_GROUPS = "CHANNEL_GROUPS"
    ORIGIN_ENDPOINTS_PER_CHANNEL = "ORIGIN_ENDPOINTS_PER_CHANNEL"
    RATE_OF_INGEST_REQUESTS_PER_CHANNEL = "RATE_OF_INGEST_REQUESTS_PER_CHANNEL"
    MANIFESTS_PER_ORIGIN_ENDPOINT = "MANIFESTS_PER_ORIGIN_ENDPOINT"
    BURST_RATE_OF_REST_API_REQUESTS = "BURST_RATE_OF_REST_API_REQUESTS"
    CHANNELS_PER_CHANNEL_GROUP = "CHANNELS_PER_CHANNEL_GROUP"
    RATE_OF_REST_API_REQUESTS = "RATE_OF_REST_API_REQUESTS"
    INGEST_STREAMS_PER_CHANNEL = "INGEST_STREAMS_PER_CHANNEL"
    TIME_SHIFTED_MANIFEST_LENGTH = "TIME_SHIFTED_MANIFEST_LENGTH"
    TRACKS_PER_INGEST_STREAM = "TRACKS_PER_INGEST_STREAM"
    LIVE_MANIFEST_LENGTH = "LIVE_MANIFEST_LENGTH"
    RATE_OF_SEGMENT_EGRESS_REQUESTS_PER_ORIGIN_ENDPOINT = "RATE_OF_SEGMENT_EGRESS_REQUESTS_PER_ORIGIN_ENDPOINT"
    CONTENT_RETENTION = "CONTENT_RETENTION"
    RATE_OF_MANIFEST_EGRESS_REQUESTS_PER_ORIGIN_ENDPOINT = "RATE_OF_MANIFEST_EGRESS_REQUESTS_PER_ORIGIN_ENDPOINT"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsElementalMediaStoreQuota")
class AwsElementalMediaStoreQuota(enum.Enum):
    RATE_OF_DELETE_OBJECT_API_REQUESTS = "RATE_OF_DELETE_OBJECT_API_REQUESTS"
    RATE_OF_DESCRIBE_OBJECT_API_REQUESTS = "RATE_OF_DESCRIBE_OBJECT_API_REQUESTS"
    RATE_OF_PUT_OBJECT_API_REQUESTS_FOR_CHUNKED_TRANSFER_ENCODING_ALSO_KNOWN_AS_STREAMING_UPLOAD_AVAILABILITY = "RATE_OF_PUT_OBJECT_API_REQUESTS_FOR_CHUNKED_TRANSFER_ENCODING_ALSO_KNOWN_AS_STREAMING_UPLOAD_AVAILABILITY"
    RATE_OF_GET_OBJECT_API_REQUESTS_FOR_STANDARD_UPLOAD_AVAILABILITY = "RATE_OF_GET_OBJECT_API_REQUESTS_FOR_STANDARD_UPLOAD_AVAILABILITY"
    RATE_OF_LIST_ITEMS_API_REQUESTS = "RATE_OF_LIST_ITEMS_API_REQUESTS"
    RATE_OF_GET_OBJECT_API_REQUESTS_FOR_STREAMING_UPLOAD_AVAILABILITY = "RATE_OF_GET_OBJECT_API_REQUESTS_FOR_STREAMING_UPLOAD_AVAILABILITY"
    RATE_OF_PUT_OBJECT_API_REQUESTS_FOR_STANDARD_UPLOAD_AVAILABILITY = "RATE_OF_PUT_OBJECT_API_REQUESTS_FOR_STANDARD_UPLOAD_AVAILABILITY"
    OBJECT_SIZE = "OBJECT_SIZE"
    CONTAINERS = "CONTAINERS"
    FOLDER_LEVELS = "FOLDER_LEVELS"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsElementalMediaTailorQuota")
class AwsElementalMediaTailorQuota(enum.Enum):
    SOURCE_LOCATIONS = "SOURCE_LOCATIONS"
    PROGRAMS_PER_CHANNEL = "PROGRAMS_PER_CHANNEL"
    CONTENT_ORIGIN_SERVER_TIMEOUT = "CONTENT_ORIGIN_SERVER_TIMEOUT"
    AD_DECISION_SERVER_ADS_TIMEOUT = "AD_DECISION_SERVER_ADS_TIMEOUT"
    CHANNEL_MANIFEST_REQUESTS = "CHANNEL_MANIFEST_REQUESTS"
    PACKAGE_CONFIGURATIONS = "PACKAGE_CONFIGURATIONS"
    SESSION_EXPIRATION = "SESSION_EXPIRATION"
    AD_DECISION_SERVER_ADS_LENGTH = "AD_DECISION_SERVER_ADS_LENGTH"
    MANIFEST_REQUESTS = "MANIFEST_REQUESTS"
    CONTENT_ORIGIN_LENGTH = "CONTENT_ORIGIN_LENGTH"
    CHANNELS_PER_ACCOUNT = "CHANNELS_PER_ACCOUNT"
    AD_INSERTION_REQUESTS = "AD_INSERTION_REQUESTS"
    CONFIGURATIONS = "CONFIGURATIONS"
    CHANNEL_OUTPUTS = "CHANNEL_OUTPUTS"
    SEGMENT_DELIVERY_CONFIGURATIONS_PER_SOURCE = "SEGMENT_DELIVERY_CONFIGURATIONS_PER_SOURCE"
    MANIFEST_SIZE = "MANIFEST_SIZE"
    VOD_SOURCES = "VOD_SOURCES"
    LIVE_SOURCES = "LIVE_SOURCES"
    AD_DECISION_SERVER_ADS_REDIRECTS = "AD_DECISION_SERVER_ADS_REDIRECTS"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsEntityResolutionQuota")
class AwsEntityResolutionQuota(enum.Enum):
    CONCURRENT_MATCHING_JOBS = "CONCURRENT_MATCHING_JOBS"
    CONCURRENT_ID_MAPPING_JOBS = "CONCURRENT_ID_MAPPING_JOBS"
    SCHEMA_MAPPINGS = "SCHEMA_MAPPINGS"
    MATCHING_WORKFLOWS = "MATCHING_WORKFLOWS"
    ID_MAPPING_WORKFLOWS = "ID_MAPPING_WORKFLOWS"
    RATE_OF_GET_MATCH_ID_API_REQUESTS = "RATE_OF_GET_MATCH_ID_API_REQUESTS"
    CONCURRENT_PROVIDER_SERVICE_MATCHING_JOBS = "CONCURRENT_PROVIDER_SERVICE_MATCHING_JOBS"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsFargateQuota")
class AwsFargateQuota(enum.Enum):
    FARGATE_ON_DEMAND_V_CPU_RESOURCE_COUNT = "FARGATE_ON_DEMAND_V_CPU_RESOURCE_COUNT"
    FARGATE_SPOT_V_CPU_RESOURCE_COUNT = "FARGATE_SPOT_V_CPU_RESOURCE_COUNT"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsFaultInjectionServiceFisQuota")
class AwsFaultInjectionServiceFisQuota(enum.Enum):
    TARGET_SUBNETS_FOR_AWS_NETWORK_DISRUPT_CONNECTIVITY = "TARGET_SUBNETS_FOR_AWS_NETWORK_DISRUPT_CONNECTIVITY"
    TARGET_TASKS_FOR_AWS_ECS_TASK_KILL_PROCESS = "TARGET_TASKS_FOR_AWS_ECS_TASK_KILL_PROCESS"
    TARGET_REPLICATION_GROUPS_FOR_AWS_ELASTICACHE_INTERRUPT_CLUSTER_AZ_POWER = "TARGET_REPLICATION_GROUPS_FOR_AWS_ELASTICACHE_INTERRUPT_CLUSTER_AZ_POWER"
    EXPERIMENT_DURATION_IN_HOURS = "EXPERIMENT_DURATION_IN_HOURS"
    TARGET_PODS_FOR_AWS_EKS_POD_IO_STRESS = "TARGET_PODS_FOR_AWS_EKS_POD_IO_STRESS"
    TARGET_ACCOUNT_CONFIGURATIONS_PER_EXPERIMENT_TEMPLATE = "TARGET_ACCOUNT_CONFIGURATIONS_PER_EXPERIMENT_TEMPLATE"
    TARGET_TASKS_FOR_AWS_ECS_TASK_NETWORK_PACKET_LOSS = "TARGET_TASKS_FOR_AWS_ECS_TASK_NETWORK_PACKET_LOSS"
    TARGET_TASKS_FOR_AWS_ECS_TASK_NETWORK_LATENCY = "TARGET_TASKS_FOR_AWS_ECS_TASK_NETWORK_LATENCY"
    TARGET_AUTO_SCALING_GROUPS_FOR_AWS_EC2_ASG_INSUFFICIENT_INSTANCE_CAPACITY_ERROR = "TARGET_AUTO_SCALING_GROUPS_FOR_AWS_EC2_ASG_INSUFFICIENT_INSTANCE_CAPACITY_ERROR"
    STOP_CONDITIONS_PER_EXPERIMENT_TEMPLATE = "STOP_CONDITIONS_PER_EXPERIMENT_TEMPLATE"
    TARGET_SUBNETS_FOR_AWS_NETWORK_ROUTE_TABLE_DISRUPT_CROSS_REGION_CONNECTIVITY = "TARGET_SUBNETS_FOR_AWS_NETWORK_ROUTE_TABLE_DISRUPT_CROSS_REGION_CONNECTIVITY"
    TARGET_PODS_FOR_AWS_EKS_POD_CPU_STRESS = "TARGET_PODS_FOR_AWS_EKS_POD_CPU_STRESS"
    TARGET_TASKS_FOR_AWS_ECS_TASK_IO_STRESS = "TARGET_TASKS_FOR_AWS_ECS_TASK_IO_STRESS"
    MAXIMUM_NUMBER_OF_MANAGED_PREFIX_LISTS_IN_AWS_NETWORK_ROUTE_TABLE_DISRUPT_CROSS_REGION_CONNECTIVITY = "MAXIMUM_NUMBER_OF_MANAGED_PREFIX_LISTS_IN_AWS_NETWORK_ROUTE_TABLE_DISRUPT_CROSS_REGION_CONNECTIVITY"
    TARGET_PODS_FOR_AWS_EKS_POD_NETWORK_LATENCY = "TARGET_PODS_FOR_AWS_EKS_POD_NETWORK_LATENCY"
    PARALLEL_ACTIONS_PER_EXPERIMENT = "PARALLEL_ACTIONS_PER_EXPERIMENT"
    ACTION_DURATION_IN_HOURS = "ACTION_DURATION_IN_HOURS"
    TARGET_CLUSTERS_FOR_AWS_ECS_DRAIN_CONTAINER_INSTANCES = "TARGET_CLUSTERS_FOR_AWS_ECS_DRAIN_CONTAINER_INSTANCES"
    ACTIVE_EXPERIMENTS = "ACTIVE_EXPERIMENTS"
    TARGET_INSTANCES_FOR_AWS_SSM_SEND_COMMAND = "TARGET_INSTANCES_FOR_AWS_SSM_SEND_COMMAND"
    MAXIMUM_NUMBER_OF_ROUTES_IN_AWS_NETWORK_ROUTE_TABLE_DISRUPT_CROSS_REGION_CONNECTIVITY = "MAXIMUM_NUMBER_OF_ROUTES_IN_AWS_NETWORK_ROUTE_TABLE_DISRUPT_CROSS_REGION_CONNECTIVITY"
    COMPLETED_EXPERIMENT_DATA_RETENTION_IN_DAYS = "COMPLETED_EXPERIMENT_DATA_RETENTION_IN_DAYS"
    TARGET_TASKS_FOR_AWS_ECS_TASK_CPU_STRESS = "TARGET_TASKS_FOR_AWS_ECS_TASK_CPU_STRESS"
    TARGET_TASKS_FOR_AWS_ECS_STOP_TASK = "TARGET_TASKS_FOR_AWS_ECS_STOP_TASK"
    TARGET_PODS_FOR_AWS_EKS_POD_DELETE = "TARGET_PODS_FOR_AWS_EKS_POD_DELETE"
    TARGET_INSTANCES_FOR_AWS_EC2_REBOOT_INSTANCES = "TARGET_INSTANCES_FOR_AWS_EC2_REBOOT_INSTANCES"
    TARGET_TRANSIT_GATEWAYS_FOR_AWS_NETWORK_TRANSIT_GATEWAY_DISRUPT_CROSS_REGION_CONNECTIVITY = "TARGET_TRANSIT_GATEWAYS_FOR_AWS_NETWORK_TRANSIT_GATEWAY_DISRUPT_CROSS_REGION_CONNECTIVITY"
    TARGET_NODEGROUPS_FOR_AWS_EKS_TERMINATE_NODEGROUP_INSTANCES = "TARGET_NODEGROUPS_FOR_AWS_EKS_TERMINATE_NODEGROUP_INSTANCES"
    TARGET_SPOT_INSTANCES_FOR_AWS_EC2_SEND_SPOT_INSTANCE_INTERRUPTIONS = "TARGET_SPOT_INSTANCES_FOR_AWS_EC2_SEND_SPOT_INSTANCE_INTERRUPTIONS"
    ACTIONS_PER_EXPERIMENT_TEMPLATE = "ACTIONS_PER_EXPERIMENT_TEMPLATE"
    TARGET_BUCKETS_FOR_AWS_S3_BUCKET_PAUSE_REPLICATION = "TARGET_BUCKETS_FOR_AWS_S3_BUCKET_PAUSE_REPLICATION"
    TARGET_TASKS_FOR_AWS_ECS_TASK_NETWORK_BLACKHOLE_PORT = "TARGET_TASKS_FOR_AWS_ECS_TASK_NETWORK_BLACKHOLE_PORT"
    MAXIMUM_NUMBER_OF_ROUTE_TABLES_IN_AWS_NETWORK_ROUTE_TABLE_DISRUPT_CROSS_REGION_CONNECTIVITY = "MAXIMUM_NUMBER_OF_ROUTE_TABLES_IN_AWS_NETWORK_ROUTE_TABLE_DISRUPT_CROSS_REGION_CONNECTIVITY"
    TARGET_INSTANCES_FOR_AWS_EC2_STOP_INSTANCES = "TARGET_INSTANCES_FOR_AWS_EC2_STOP_INSTANCES"
    TARGET_PODS_FOR_AWS_EKS_POD_NETWORK_PACKET_LOSS = "TARGET_PODS_FOR_AWS_EKS_POD_NETWORK_PACKET_LOSS"
    TARGET_CLUSTERS_FOR_AWS_RDS_FAILOVER_DB_CLUSTER = "TARGET_CLUSTERS_FOR_AWS_RDS_FAILOVER_DB_CLUSTER"
    TARGET_DB_INSTANCES_FOR_AWS_RDS_REBOOT_DB_INSTANCES = "TARGET_DB_INSTANCES_FOR_AWS_RDS_REBOOT_DB_INSTANCES"
    EXPERIMENT_TEMPLATES = "EXPERIMENT_TEMPLATES"
    TARGET_PODS_FOR_AWS_EKS_POD_NETWORK_BLACKHOLE_PORT = "TARGET_PODS_FOR_AWS_EKS_POD_NETWORK_BLACKHOLE_PORT"
    TARGET_PODS_FOR_AWS_EKS_POD_MEMORY_STRESS = "TARGET_PODS_FOR_AWS_EKS_POD_MEMORY_STRESS"
    TARGET_INSTANCES_FOR_AWS_EC2_TERMINATE_INSTANCES = "TARGET_INSTANCES_FOR_AWS_EC2_TERMINATE_INSTANCES"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsFirewallManagerQuota")
class AwsFirewallManagerQuota(enum.Enum):
    ROUTE_53_RESOLVER_DNS_FIREWALL_RULE_GROUPS_PER_DNS_FIREWALL_POLICY = "ROUTE_53_RESOLVER_DNS_FIREWALL_RULE_GROUPS_PER_DNS_FIREWALL_POLICY"
    RULE_GROUPS_PER_AWS_WAF_POLICY = "RULE_GROUPS_PER_AWS_WAF_POLICY"
    TAGS_TO_INCLUDE_OR_EXCLUDE_RESOURCES_PER_POLICY = "TAGS_TO_INCLUDE_OR_EXCLUDE_RESOURCES_PER_POLICY"
    WEB_ACL_CAPACITY_UNITS_WCU_USED_IN_AN_AWS_WAF_POLICY = "WEB_ACL_CAPACITY_UNITS_WCU_USED_IN_AN_AWS_WAF_POLICY"
    AMAZON_VPC_INSTANCES_IN_SCOPE_OF_A_COMMON_SECURITY_GROUP_POLICY = "AMAZON_VPC_INSTANCES_IN_SCOPE_OF_A_COMMON_SECURITY_GROUP_POLICY"
    VP_CS_THAT_A_SINGLE_NETWORK_FIREWALL_POLICY_CAN_AUTOMATICALLY_REMEDIATE = "VP_CS_THAT_A_SINGLE_NETWORK_FIREWALL_POLICY_CAN_AUTOMATICALLY_REMEDIATE"
    PROTOCOLS_PER_PROTOCOL_LIST = "PROTOCOLS_PER_PROTOCOL_LIST"
    EXPLICITLY_INCLUDED_OR_EXCLUDED_ACCOUNTS_PER_POLICY_PER_REGION = "EXPLICITLY_INCLUDED_OR_EXCLUDED_ACCOUNTS_PER_POLICY_PER_REGION"
    APPLICATIONS_PER_APPLICATION_LIST = "APPLICATIONS_PER_APPLICATION_LIST"
    CUSTOM_MANAGED_APPLICATION_LISTS_IN_ANY_CONTENT_AUDIT_SECURITY_GROUP_POLICY_SETTING = "CUSTOM_MANAGED_APPLICATION_LISTS_IN_ANY_CONTENT_AUDIT_SECURITY_GROUP_POLICY_SETTING"
    AUDIT_SECURITY_GROUPS_PER_SECURITY_GROUP_CONTENT_AUDIT_POLICY = "AUDIT_SECURITY_GROUPS_PER_SECURITY_GROUP_CONTENT_AUDIT_POLICY"
    PRIMARY_SECURITY_GROUPS_PER_COMMON_SECURITY_GROUP_POLICY = "PRIMARY_SECURITY_GROUPS_PER_COMMON_SECURITY_GROUP_POLICY"
    CUSTOM_MANAGED_APPLICATION_LISTS_PER_ACCOUNT = "CUSTOM_MANAGED_APPLICATION_LISTS_PER_ACCOUNT"
    ORGANIZATIONAL_UNITS_IN_SCOPE_PER_POLICY_PER_REGION = "ORGANIZATIONAL_UNITS_IN_SCOPE_PER_POLICY_PER_REGION"
    AWS_WAF_CLASSIC_RULE_GROUPS_PER_AWS_WAF_CLASSIC_POLICY = "AWS_WAF_CLASSIC_RULE_GROUPS_PER_AWS_WAF_CLASSIC_POLICY"
    IPV4_CID_RS_FOR_A_NETWORK_FIREWALL_POLICY = "IPV4_CID_RS_FOR_A_NETWORK_FIREWALL_POLICY"
    CUSTOM_MANAGED_PROTOCOL_LISTS_IN_ANY_CONTENT_AUDIT_SECURITY_GROUP_POLICY_SETTING = "CUSTOM_MANAGED_PROTOCOL_LISTS_IN_ANY_CONTENT_AUDIT_SECURITY_GROUP_POLICY_SETTING"
    CUSTOM_MANAGED_PROTOCOL_LISTS_PER_ACCOUNT = "CUSTOM_MANAGED_PROTOCOL_LISTS_PER_ACCOUNT"
    FIREWALL_MANAGER_POLICIES_PER_ORGANIZATION_PER_REGION = "FIREWALL_MANAGER_POLICIES_PER_ORGANIZATION_PER_REGION"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsGlobalAcceleratorQuota")
class AwsGlobalAcceleratorQuota(enum.Enum):
    CUSTOM_ROUTING_ACCELERATORS_PER_AWS_ACCOUNT = "CUSTOM_ROUTING_ACCELERATORS_PER_AWS_ACCOUNT"
    ENDPOINTS_PER_ENDPOINT_GROUP_EC2_INSTANCES = "ENDPOINTS_PER_ENDPOINT_GROUP_EC2_INSTANCES"
    ENDPOINTS_PER_ENDPOINT_GROUP_APPLICATION_LOAD_BALANCERS = "ENDPOINTS_PER_ENDPOINT_GROUP_APPLICATION_LOAD_BALANCERS"
    STANDARD_ACCELERATORS_PER_AWS_ACCOUNT = "STANDARD_ACCELERATORS_PER_AWS_ACCOUNT"
    PORT_OVERRIDES_PER_ENDPOINT_GROUP = "PORT_OVERRIDES_PER_ENDPOINT_GROUP"
    TAGS_PER_ACCELERATOR = "TAGS_PER_ACCELERATOR"
    ENDPOINTS_PER_ENDPOINT_GROUP_ELASTIC_IP_ADDRESSES = "ENDPOINTS_PER_ENDPOINT_GROUP_ELASTIC_IP_ADDRESSES"
    ENDPOINTS_PER_ENDPOINT_GROUP_NETWORK_LOAD_BALANCERS = "ENDPOINTS_PER_ENDPOINT_GROUP_NETWORK_LOAD_BALANCERS"
    LISTENERS_PER_ACCELERATOR = "LISTENERS_PER_ACCELERATOR"
    ENDPOINTS_PER_ENDPOINT_GROUP_VPC_SUBNETS = "ENDPOINTS_PER_ENDPOINT_GROUP_VPC_SUBNETS"
    ENDPOINTS_PER_ENDPOINT_GROUP_MORE_THAN_ONE_ENDPOINT_TYPE = "ENDPOINTS_PER_ENDPOINT_GROUP_MORE_THAN_ONE_ENDPOINT_TYPE"
    CROSS_ACCOUNT_ATTACHMENTS_PER_AWS_ACCOUNT = "CROSS_ACCOUNT_ATTACHMENTS_PER_AWS_ACCOUNT"
    PRINCIPALS_PER_CROSS_ACCOUNT_ATTACHMENT = "PRINCIPALS_PER_CROSS_ACCOUNT_ATTACHMENT"
    PORT_RANGES_PER_LISTENER = "PORT_RANGES_PER_LISTENER"
    ENDPOINT_GROUPS_PER_ACCELERATOR = "ENDPOINT_GROUPS_PER_ACCELERATOR"
    ENDPOINT_RESOURCES_PER_CROSS_ACCOUNT_ATTACHMENT = "ENDPOINT_RESOURCES_PER_CROSS_ACCOUNT_ATTACHMENT"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsGlueDataBrewQuota")
class AwsGlueDataBrewQuota(enum.Enum):
    JOBS_PER_AWS_ACCOUNT = "JOBS_PER_AWS_ACCOUNT"
    RECIPES_PER_AWS_ACCOUNT = "RECIPES_PER_AWS_ACCOUNT"
    VERSIONS_PER_RECIPE = "VERSIONS_PER_RECIPE"
    OPEN_PROJECTS_PER_AWS_ACCOUNT = "OPEN_PROJECTS_PER_AWS_ACCOUNT"
    RULESETS_PER_DATASET = "RULESETS_PER_DATASET"
    RULESETS_PER_AWS_ACCOUNT = "RULESETS_PER_AWS_ACCOUNT"
    RULES_PER_RULESET = "RULES_PER_RULESET"
    PROJECTS_PER_AWS_ACCOUNT = "PROJECTS_PER_AWS_ACCOUNT"
    CONCURRENT_JOBS_PER_AWS_ACCOUNT = "CONCURRENT_JOBS_PER_AWS_ACCOUNT"
    SCHEDULES_PER_AWS_ACCOUNT = "SCHEDULES_PER_AWS_ACCOUNT"
    DATASETS_PER_AWS_ACCOUNT = "DATASETS_PER_AWS_ACCOUNT"
    NODE_CAPACITY_PER_AWS_ACCOUNT = "NODE_CAPACITY_PER_AWS_ACCOUNT"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsGlueQuota")
class AwsGlueQuota(enum.Enum):
    MAXIMUM_NUMBER_OF_IN_FLIGHT_COMPLETION_REQUESTS_ALLOWED_PER_ACCOUNT = "MAXIMUM_NUMBER_OF_IN_FLIGHT_COMPLETION_REQUESTS_ALLOWED_PER_ACCOUNT"
    MAX_TASK_DP_US_PER_ACCOUNT = "MAX_TASK_DP_US_PER_ACCOUNT"
    MAX_DATABASES_PER_ACCOUNT = "MAX_DATABASES_PER_ACCOUNT"
    CONCURRENT_COMPUTE_CAPACITY_FOR_RAY_WORKER_INSTANCES_IN_M_DP_US_PER_ACCOUNT = "CONCURRENT_COMPUTE_CAPACITY_FOR_RAY_WORKER_INSTANCES_IN_M_DP_US_PER_ACCOUNT"
    MAX_TABLES_PER_DATABASE = "MAX_TABLES_PER_DATABASE"
    MAX_TRIGGERS_PER_ACCOUNT = "MAX_TRIGGERS_PER_ACCOUNT"
    NUMBER_OF_COLUMN_STATISTICS_TASKS_RUNNING_CONCURRENTLY_PER_ACCOUNT = "NUMBER_OF_COLUMN_STATISTICS_TASKS_RUNNING_CONCURRENTLY_PER_ACCOUNT"
    MAX_JOBS_PER_ACCOUNT = "MAX_JOBS_PER_ACCOUNT"
    MAX_TABLES_PER_ACCOUNT = "MAX_TABLES_PER_ACCOUNT"
    MAX_JOBS_PER_TRIGGER = "MAX_JOBS_PER_TRIGGER"
    MAX_CONCURRENT_JOB_RUNS_PER_ACCOUNT = "MAX_CONCURRENT_JOB_RUNS_PER_ACCOUNT"
    MAX_PARTITIONS_PER_ACCOUNT = "MAX_PARTITIONS_PER_ACCOUNT"
    MAX_DP_US_PER_DEV_ENDPOINT = "MAX_DP_US_PER_DEV_ENDPOINT"
    MAX_DATA_QUALITY_RULESETS_PER_ACCOUNT = "MAX_DATA_QUALITY_RULESETS_PER_ACCOUNT"
    CONCURRENT_MACHINE_LEARNING_TASK_RUNS_PER_TRANSFORM = "CONCURRENT_MACHINE_LEARNING_TASK_RUNS_PER_TRANSFORM"
    MAX_CONCURRENT_DATA_QUALITY_RULESET_EVALUATION_RUNS_PER_ACCOUNT = "MAX_CONCURRENT_DATA_QUALITY_RULESET_EVALUATION_RUNS_PER_ACCOUNT"
    MAX_CONNECTION_PER_ACCOUNT = "MAX_CONNECTION_PER_ACCOUNT"
    MAX_PARTITIONS_PER_TABLE = "MAX_PARTITIONS_PER_TABLE"
    NUMBER_OF_CRAWLERS_PER_ACCOUNT = "NUMBER_OF_CRAWLERS_PER_ACCOUNT"
    LABEL_FILE_SIZE = "LABEL_FILE_SIZE"
    NUMBER_OF_CRAWLERS_RUNNING_CONCURRENTLY_PER_ACCOUNT = "NUMBER_OF_CRAWLERS_RUNNING_CONCURRENTLY_PER_ACCOUNT"
    MAX_CONCURRENT_DATA_QUALITY_RULESET_RECOMMENDATION_RUNS_PER_ACCOUNT = "MAX_CONCURRENT_DATA_QUALITY_RULESET_RECOMMENDATION_RUNS_PER_ACCOUNT"
    MAX_CONCURRENT_JOB_RUNS_PER_JOB = "MAX_CONCURRENT_JOB_RUNS_PER_JOB"
    TOTAL_CONCURRENT_MACHINE_LEARNING_TASK_RUNS_FOR_TRANSFORMS_PER_ACCOUNT = "TOTAL_CONCURRENT_MACHINE_LEARNING_TASK_RUNS_FOR_TRANSFORMS_PER_ACCOUNT"
    MAX_TABLE_VERSIONS_PER_TABLE = "MAX_TABLE_VERSIONS_PER_TABLE"
    MAX_FUNCTIONS_PER_ACCOUNT = "MAX_FUNCTIONS_PER_ACCOUNT"
    MAX_DEVELOPMENT_ENDPOINT_PER_ACCOUNT = "MAX_DEVELOPMENT_ENDPOINT_PER_ACCOUNT"
    MAX_SECURITY_CONFIGURATIONS_PER_ACCOUNT = "MAX_SECURITY_CONFIGURATIONS_PER_ACCOUNT"
    NUMBER_OF_WORKFLOWS = "NUMBER_OF_WORKFLOWS"
    MAX_FUNCTIONS_PER_DATABASE = "MAX_FUNCTIONS_PER_DATABASE"
    MAX_SPARE_COMPUTE_CAPACITY_CONSUMED_IN_DATA_PROCESSING_UNITS_DP_US_PER_ACCOUNT = "MAX_SPARE_COMPUTE_CAPACITY_CONSUMED_IN_DATA_PROCESSING_UNITS_DP_US_PER_ACCOUNT"
    MAX_TABLE_VERSIONS_PER_ACCOUNT = "MAX_TABLE_VERSIONS_PER_ACCOUNT"
    MAX_DATABASES_PER_CATALOG = "MAX_DATABASES_PER_CATALOG"
    NUMBER_OF_MACHINE_LEARNING_TRANSFORMS = "NUMBER_OF_MACHINE_LEARNING_TRANSFORMS"
    NUMBER_OF_METADATA_KEY_VALUE_PAIRS_PER_SCHEMA_VERSION = "NUMBER_OF_METADATA_KEY_VALUE_PAIRS_PER_SCHEMA_VERSION"
    NUMBER_OF_SCHEMA_VERSIONS = "NUMBER_OF_SCHEMA_VERSIONS"
    NUMBER_OF_SCHEMA_REGISTRIES = "NUMBER_OF_SCHEMA_REGISTRIES"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsGroundStationQuota")
class AwsGroundStationQuota(enum.Enum):
    CONFIG_LIMIT = "CONFIG_LIMIT"
    EPHEMERIS_VALIDATION_LIMIT = "EPHEMERIS_VALIDATION_LIMIT"
    SCHEDULED_CONTACTS_LIMIT = "SCHEDULED_CONTACTS_LIMIT"
    SCHEDULED_MINUTES_LIMIT = "SCHEDULED_MINUTES_LIMIT"
    CONTACT_LEAD_TIME_MAXIMUM = "CONTACT_LEAD_TIME_MAXIMUM"
    ENABLED_EPHEMERIDES_LIMIT = "ENABLED_EPHEMERIDES_LIMIT"
    MAXIMUM_CONTACT_DURATION = "MAXIMUM_CONTACT_DURATION"
    DATAFLOW_ENDPOINTS_PER_GROUP_LIMIT = "DATAFLOW_ENDPOINTS_PER_GROUP_LIMIT"
    DATAFLOW_ENDPOINT_GROUP_LIMIT = "DATAFLOW_ENDPOINT_GROUP_LIMIT"
    MISSION_PROFILE_LIMIT = "MISSION_PROFILE_LIMIT"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsHealthImagingQuota")
class AwsHealthImagingQuota(enum.Enum):
    MAXIMUM_NUMBER_OF_NESTED_FOLDERS_IN_A_DICOM_IMPORT_JOB = "MAXIMUM_NUMBER_OF_NESTED_FOLDERS_IN_A_DICOM_IMPORT_JOB"
    MAXIMUM_CONCURRENT_DELETE_IMAGE_SET_REQUESTS_PER_DATA_STORE = "MAXIMUM_CONCURRENT_DELETE_IMAGE_SET_REQUESTS_PER_DATA_STORE"
    MAXIMUM_NUMBER_OF_FILES_IN_A_DICOM_IMPORT_JOB = "MAXIMUM_NUMBER_OF_FILES_IN_A_DICOM_IMPORT_JOB"
    MAXIMUM_PAYLOAD_SIZE_LIMIT_IN_KB_ACCEPTED_BY_UPDATE_IMAGE_SET_METADATA = "MAXIMUM_PAYLOAD_SIZE_LIMIT_IN_KB_ACCEPTED_BY_UPDATE_IMAGE_SET_METADATA"
    MAXIMUM_SIZE_IN_GB_OF_ALL_FILES_IN_A_DICOM_IMPORT_JOB = "MAXIMUM_SIZE_IN_GB_OF_ALL_FILES_IN_A_DICOM_IMPORT_JOB"
    MAXIMUM_NUMBER_OF_IMAGE_FRAMES_ALLOWED_TO_BE_COPIED_PER_COPY_IMAGE_SET_REQUEST = "MAXIMUM_NUMBER_OF_IMAGE_FRAMES_ALLOWED_TO_BE_COPIED_PER_COPY_IMAGE_SET_REQUEST"
    MAXIMUM_SIZE_LIMIT_IN_MB_ON_IMAGE_SET_METADATA_PER_IMPORT_COPY_AND_UPDATE_IMAGE_SET = "MAXIMUM_SIZE_LIMIT_IN_MB_ON_IMAGE_SET_METADATA_PER_IMPORT_COPY_AND_UPDATE_IMAGE_SET"
    MAXIMUM_SIZE_IN_GB_OF_EACH_DICOM_P10_FILE_IN_A_DICOM_IMPORT_JOB = "MAXIMUM_SIZE_IN_GB_OF_EACH_DICOM_P10_FILE_IN_A_DICOM_IMPORT_JOB"
    MAXIMUM_CONCURRENT_COPY_IMAGE_SET_REQUESTS_PER_DATA_STORE = "MAXIMUM_CONCURRENT_COPY_IMAGE_SET_REQUESTS_PER_DATA_STORE"
    MAXIMUM_DATA_STORES = "MAXIMUM_DATA_STORES"
    MAXIMUM_CONCURRENT_IMPORT_JOBS_PER_DATA_STORE = "MAXIMUM_CONCURRENT_IMPORT_JOBS_PER_DATA_STORE"
    MAXIMUM_CONCURRENT_UPDATE_IMAGE_SET_METADATA_REQUESTS_PER_DATA_STORE = "MAXIMUM_CONCURRENT_UPDATE_IMAGE_SET_METADATA_REQUESTS_PER_DATA_STORE"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsHealthLakeQuota")
class AwsHealthLakeQuota(enum.Enum):
    RATE_OF_START_FHIR_EXPORT_JOB_REQUESTS_PER_ACCOUNT = "RATE_OF_START_FHIR_EXPORT_JOB_REQUESTS_PER_ACCOUNT"
    RATE_OF_SEARCH_REQUESTS_USING_GET_PER_ACCOUNT = "RATE_OF_SEARCH_REQUESTS_USING_GET_PER_ACCOUNT"
    RATE_OF_PUT_REQUESTS_PER_DATA_STORE = "RATE_OF_PUT_REQUESTS_PER_DATA_STORE"
    RATE_OF_SEARCH_REQUESTS_USING_POST_PER_DATA_STORE = "RATE_OF_SEARCH_REQUESTS_USING_POST_PER_DATA_STORE"
    RATE_OF_START_FHIR_IMPORT_JOB_REQUESTS_PER_ACCOUNT = "RATE_OF_START_FHIR_IMPORT_JOB_REQUESTS_PER_ACCOUNT"
    RATE_OF_DESCRIBE_FHIR_DATASTORE_REQUESTS_PER_ACCOUNT = "RATE_OF_DESCRIBE_FHIR_DATASTORE_REQUESTS_PER_ACCOUNT"
    RATE_OF_POST_REQUESTS_PER_DATA_STORE = "RATE_OF_POST_REQUESTS_PER_DATA_STORE"
    NUMBER_OF_RESOURCES_PER_BUNDLE = "NUMBER_OF_RESOURCES_PER_BUNDLE"
    SIZE_OF_INDIVIDUAL_IMPORTED_FILE = "SIZE_OF_INDIVIDUAL_IMPORTED_FILE"
    RATE_OF_PUT_REQUESTS_PER_ACCOUNT = "RATE_OF_PUT_REQUESTS_PER_ACCOUNT"
    RATE_OF_BUNDLE_REQUESTS_PER_DATA_STORE = "RATE_OF_BUNDLE_REQUESTS_PER_DATA_STORE"
    RATE_OF_LIST_TAGSFOR_RESOURCE_REQUESTS_PER_ACCOUNT = "RATE_OF_LIST_TAGSFOR_RESOURCE_REQUESTS_PER_ACCOUNT"
    RATE_OF_DELETE_REQUESTS_PER_DATA_STORE = "RATE_OF_DELETE_REQUESTS_PER_DATA_STORE"
    RATE_OF_DISCOVERY_REQUESTS_PER_ACCOUNT = "RATE_OF_DISCOVERY_REQUESTS_PER_ACCOUNT"
    TOTAL_IMPORT_JOB_SIZE = "TOTAL_IMPORT_JOB_SIZE"
    RATE_OF_BUNDLE_REQUESTS_PER_ACCOUNT = "RATE_OF_BUNDLE_REQUESTS_PER_ACCOUNT"
    NUMBER_OF_FILES_IN_A_START_FHIR_IMPORT_JOB = "NUMBER_OF_FILES_IN_A_START_FHIR_IMPORT_JOB"
    NUMBER_OF_CONCURRENT_START_FHIR_IMPORT_JOB_JOBS = "NUMBER_OF_CONCURRENT_START_FHIR_IMPORT_JOB_JOBS"
    RATE_OF_UNTAG_RESOURCE_REQUESTS_PER_ACCOUNT = "RATE_OF_UNTAG_RESOURCE_REQUESTS_PER_ACCOUNT"
    RATE_OF_CREATE_FHIR_DATASTORE_REQUESTS_PER_ACCOUNT = "RATE_OF_CREATE_FHIR_DATASTORE_REQUESTS_PER_ACCOUNT"
    RATE_OF_LIST_FHIR_IMPORT_JOBS_REQUESTS_PER_ACCOUNT = "RATE_OF_LIST_FHIR_IMPORT_JOBS_REQUESTS_PER_ACCOUNT"
    RATE_OF_SEARCH_REQUESTS_USING_GET_PER_DATA_STORE = "RATE_OF_SEARCH_REQUESTS_USING_GET_PER_DATA_STORE"
    RATE_OF_DELETE_REQUESTS_PER_ACCOUNT = "RATE_OF_DELETE_REQUESTS_PER_ACCOUNT"
    RATE_OF_GET_REQUESTS_PER_ACCOUNT = "RATE_OF_GET_REQUESTS_PER_ACCOUNT"
    NUMBER_OF_CHARACTERS_IN_A_MEDICAL_NOTE = "NUMBER_OF_CHARACTERS_IN_A_MEDICAL_NOTE"
    RATE_OF_DESCRIBE_FHIR_EXPORT_JOB_REQUESTS_PER_ACCOUNT = "RATE_OF_DESCRIBE_FHIR_EXPORT_JOB_REQUESTS_PER_ACCOUNT"
    NUMBER_OF_DATA_STORES_PER_ACCOUNT = "NUMBER_OF_DATA_STORES_PER_ACCOUNT"
    RATE_OF_POST_REQUESTS_PER_ACCOUNT = "RATE_OF_POST_REQUESTS_PER_ACCOUNT"
    NUMBER_OF_CONCURRENT_START_FHIR_EXPORT_JOB_JOBS = "NUMBER_OF_CONCURRENT_START_FHIR_EXPORT_JOB_JOBS"
    RATE_OF_DESCRIBE_FHIR_EXPORT_JOB_REQUESTS_USING_GET_PER_ACCOUNT = "RATE_OF_DESCRIBE_FHIR_EXPORT_JOB_REQUESTS_USING_GET_PER_ACCOUNT"
    RATE_OF_LIST_FHIR_DATASTORES_REQUESTS_PER_ACCOUNT = "RATE_OF_LIST_FHIR_DATASTORES_REQUESTS_PER_ACCOUNT"
    RATE_OF_DESCRIBE_FHIR_IMPORT_JOB_REQUESTS_PER_ACCOUNT = "RATE_OF_DESCRIBE_FHIR_IMPORT_JOB_REQUESTS_PER_ACCOUNT"
    RATE_OF_START_FHIR_EXPORT_JOB_REQUESTS_USING_POST_PER_ACCOUNT = "RATE_OF_START_FHIR_EXPORT_JOB_REQUESTS_USING_POST_PER_ACCOUNT"
    RATE_OF_GET_REQUESTS_PER_DATA_STORE = "RATE_OF_GET_REQUESTS_PER_DATA_STORE"
    RATE_OF_LIST_FHIR_EXPORT_JOBS_REQUESTS_PER_ACCOUNT = "RATE_OF_LIST_FHIR_EXPORT_JOBS_REQUESTS_PER_ACCOUNT"
    RATE_OF_SEARCH_REQUESTS_USING_POST_PER_ACCOUNT = "RATE_OF_SEARCH_REQUESTS_USING_POST_PER_ACCOUNT"
    RATE_OF_TAG_RESOURCE_REQUESTS_PER_ACCOUNT = "RATE_OF_TAG_RESOURCE_REQUESTS_PER_ACCOUNT"
    RATE_OF_GET_CAPABILITIES_REQUESTS_PER_ACCOUNT = "RATE_OF_GET_CAPABILITIES_REQUESTS_PER_ACCOUNT"
    RATE_OF_CANCEL_FHIR_EXPORT_JOB_REQUESTS_USING_DELETE_PER_ACCOUNT = "RATE_OF_CANCEL_FHIR_EXPORT_JOB_REQUESTS_USING_DELETE_PER_ACCOUNT"
    RATE_OF_DELETE_FHIR_DATASTORE_REQUESTS_PER_ACCOUNT = "RATE_OF_DELETE_FHIR_DATASTORE_REQUESTS_PER_ACCOUNT"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsHealthOmicsQuota")
class AwsHealthOmicsQuota(enum.Enum):
    MAXIMUM_ACTIVE_RUNS = "MAXIMUM_ACTIVE_RUNS"
    MAXIMUM_ACTIVATION_JOBS = "MAXIMUM_ACTIVATION_JOBS"
    MAXIMUM_RUNS = "MAXIMUM_RUNS"
    MAXIMUM_ACTIVE_CP_US = "MAXIMUM_ACTIVE_CP_US"
    MAXIMUM_VARIANT_STORES = "MAXIMUM_VARIANT_STORES"
    MAXIMUM_REFERENCE_STORES = "MAXIMUM_REFERENCE_STORES"
    MAXIMUM_ANNOTATION_STORES = "MAXIMUM_ANNOTATION_STORES"
    MAXIMUM_EXPORT_JOBS = "MAXIMUM_EXPORT_JOBS"
    MAXIMUM_REFERENCES = "MAXIMUM_REFERENCES"
    MAXIMUM_NUMBER_OF_SHARES_PER_ANNOTATION_VERSION = "MAXIMUM_NUMBER_OF_SHARES_PER_ANNOTATION_VERSION"
    MAXIMUM_NUMBER_OF_SHARES_PER_VARIANT_STORE = "MAXIMUM_NUMBER_OF_SHARES_PER_VARIANT_STORE"
    MAXIMUM_ACTIVE_GP_US = "MAXIMUM_ACTIVE_GP_US"
    MAXIMUM_RUN_GROUPS = "MAXIMUM_RUN_GROUPS"
    MAXIMUM_VERSIONS_PER_ANNOTATION_STORE = "MAXIMUM_VERSIONS_PER_ANNOTATION_STORE"
    MAXIMUM_FILES_PER_VARIANT_IMPORT_JOB = "MAXIMUM_FILES_PER_VARIANT_IMPORT_JOB"
    MAXIMUM_SIZE_IN_GB_OF_EACH_FILE_IN_A_VARIANT_IMPORT_JOB = "MAXIMUM_SIZE_IN_GB_OF_EACH_FILE_IN_A_VARIANT_IMPORT_JOB"
    MAXIMUM_NUMBER_OF_SHARES_PER_ANNOTATION_STORE = "MAXIMUM_NUMBER_OF_SHARES_PER_ANNOTATION_STORE"
    MAXIMUM_FILES_PER_ANNOTATION_IMPORT_JOB = "MAXIMUM_FILES_PER_ANNOTATION_IMPORT_JOB"
    MAXIMUM_IMPORT_JOBS = "MAXIMUM_IMPORT_JOBS"
    MAXIMUM_DURATION = "MAXIMUM_DURATION"
    MAXIMUM_IMPORT_JOB_READ_SETS = "MAXIMUM_IMPORT_JOB_READ_SETS"
    MAXIMUM_WORKFLOW_STORAGE_CAPACITY = "MAXIMUM_WORKFLOW_STORAGE_CAPACITY"
    MAXIMUM_SEQUENCE_STORES = "MAXIMUM_SEQUENCE_STORES"
    MAXIMUM_RUN_TASKS = "MAXIMUM_RUN_TASKS"
    MAXIMUM_READ_SETS = "MAXIMUM_READ_SETS"
    MAXIMUM_EXPORT_JOB_READ_SETS = "MAXIMUM_EXPORT_JOB_READ_SETS"
    MAXIMUM_WORKFLOWS = "MAXIMUM_WORKFLOWS"
    MAXIMUM_SIZE_IN_GB_OF_EACH_FILE_IN_AN_ANNOTATION_IMPORT_JOB = "MAXIMUM_SIZE_IN_GB_OF_EACH_FILE_IN_AN_ANNOTATION_IMPORT_JOB"
    MAXIMUM_CONCURRENT_IMPORT_JOBS = "MAXIMUM_CONCURRENT_IMPORT_JOBS"
    MAXIMUM_ACTIVATION_JOB_READ_SETS = "MAXIMUM_ACTIVATION_JOB_READ_SETS"


@jsii.enum(
    jsii_type="@reapit-cdk/service-quotas.AwsIamIdentityCenterSuccessorToAwsSingleSignOnQuota"
)
class AwsIamIdentityCenterSuccessorToAwsSingleSignOnQuota(enum.Enum):
    FILE_SIZE_OF_SERVICE_PROVIDER_SAML_2_0_CERTIFICATES_IN_PEM_FORMAT = "FILE_SIZE_OF_SERVICE_PROVIDER_SAML_2_0_CERTIFICATES_IN_PEM_FORMAT"
    NUMBER_OF_UNIQUE_GROUPS_THAT_CAN_BE_USED_TO_EVALUATE_THE_PERMISSIONS_FOR_A_USER = "NUMBER_OF_UNIQUE_GROUPS_THAT_CAN_BE_USED_TO_EVALUATE_THE_PERMISSIONS_FOR_A_USER"
    NUMBER_OF_PERMISSION_SETS_ALLOWED_PER_AWS_ACCOUNT = "NUMBER_OF_PERMISSION_SETS_ALLOWED_PER_AWS_ACCOUNT"
    NUMBER_OF_USERS_SUPPORTED_IN_IAM_IDENTITY_CENTER = "NUMBER_OF_USERS_SUPPORTED_IN_IAM_IDENTITY_CENTER"
    NUMBER_OF_PERMISSION_SETS_ALLOWED_IN_IAM_IDENTITY_CENTER = "NUMBER_OF_PERMISSION_SETS_ALLOWED_IN_IAM_IDENTITY_CENTER"
    NUMBER_OF_GROUPS_SUPPORTED_IN_IAM_IDENTITY_CENTER = "NUMBER_OF_GROUPS_SUPPORTED_IN_IAM_IDENTITY_CENTER"
    TOTAL_NUMBER_OF_AWS_ACCOUNTS_OR_APPLICATIONS_THAT_CAN_BE_CONFIGURED = "TOTAL_NUMBER_OF_AWS_ACCOUNTS_OR_APPLICATIONS_THAT_CAN_BE_CONFIGURED"


@jsii.enum(
    jsii_type="@reapit-cdk/service-quotas.AwsIdentityAndAccessManagementIamQuota"
)
class AwsIdentityAndAccessManagementIamQuota(enum.Enum):
    MANAGED_POLICIES_PER_ROLE = "MANAGED_POLICIES_PER_ROLE"
    SERVER_CERTIFICATES_PER_ACCOUNT = "SERVER_CERTIFICATES_PER_ACCOUNT"
    USERS_PER_ACCOUNT = "USERS_PER_ACCOUNT"
    TAGS_PER_USER = "TAGS_PER_USER"
    ROLE_TRUST_POLICY_LENGTH = "ROLE_TRUST_POLICY_LENGTH"
    IDENTITY_PROVIDERS_PER_IAM_SAML_PROVIDER_OBJECT = "IDENTITY_PROVIDERS_PER_IAM_SAML_PROVIDER_OBJECT"
    GROUPS_PER_ACCOUNT = "GROUPS_PER_ACCOUNT"
    VERSIONS_PER_MANAGED_POLICY = "VERSIONS_PER_MANAGED_POLICY"
    MANAGED_POLICY_LENGTH = "MANAGED_POLICY_LENGTH"
    INSTANCE_PROFILES_PER_ACCOUNT = "INSTANCE_PROFILES_PER_ACCOUNT"
    MANAGED_POLICIES_PER_USER = "MANAGED_POLICIES_PER_USER"
    TAGS_PER_ROLE = "TAGS_PER_ROLE"
    ROLES_PER_ACCOUNT = "ROLES_PER_ACCOUNT"
    SSH_PUBLIC_KEYS_PER_USER = "SSH_PUBLIC_KEYS_PER_USER"
    KEYS_PER_SAML_PROVIDER = "KEYS_PER_SAML_PROVIDER"
    CUSTOMER_MANAGED_POLICIES_PER_ACCOUNT = "CUSTOMER_MANAGED_POLICIES_PER_ACCOUNT"
    SAML_PROVIDERS_PER_ACCOUNT = "SAML_PROVIDERS_PER_ACCOUNT"
    MANAGED_POLICIES_PER_GROUP = "MANAGED_POLICIES_PER_GROUP"
    ACCESS_KEYS_PER_USER = "ACCESS_KEYS_PER_USER"
    IAM_GROUPS_PER_USER = "IAM_GROUPS_PER_USER"
    OPEN_ID_CONNECT_PROVIDERS_PER_ACCOUNT = "OPEN_ID_CONNECT_PROVIDERS_PER_ACCOUNT"
    MFA_DEVICES_PER_USER = "MFA_DEVICES_PER_USER"
    SIGNING_CERTIFICATES_PER_USER = "SIGNING_CERTIFICATES_PER_USER"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsIoT1ClickQuota")
class AwsIoT1ClickQuota(enum.Enum):
    UNTAG_RESOURCE_API_TPS = "UNTAG_RESOURCE_API_TPS"
    LIST_PROJECTS_API_TPS = "LIST_PROJECTS_API_TPS"
    CREATE_PROJECT_API_TPS = "CREATE_PROJECT_API_TPS"
    LIST_TAGS_FOR_RESOURCE_API_TPS = "LIST_TAGS_FOR_RESOURCE_API_TPS"
    ASSOCIATE_DEVICE_WITH_PLACEMENT_API_TPS = "ASSOCIATE_DEVICE_WITH_PLACEMENT_API_TPS"
    DISASSOCIATE_DEVICE_FROM_PLACEMENT_API_TPS = "DISASSOCIATE_DEVICE_FROM_PLACEMENT_API_TPS"
    LIST_PLACEMENTS_API_TPS = "LIST_PLACEMENTS_API_TPS"
    UPDATE_PROJECT_API_TPS = "UPDATE_PROJECT_API_TPS"
    TAG_RESOURCE_API_TPS = "TAG_RESOURCE_API_TPS"
    CREATE_PLACEMENT_API_TPS = "CREATE_PLACEMENT_API_TPS"
    GET_DEVICES_IN_PLACEMENT_API_TPS = "GET_DEVICES_IN_PLACEMENT_API_TPS"
    DESCRIBE_PLACEMENT_API_TPS = "DESCRIBE_PLACEMENT_API_TPS"
    DELETE_PLACEMENT_API_TPS = "DELETE_PLACEMENT_API_TPS"
    DELETE_PROJECT_API_TPS = "DELETE_PROJECT_API_TPS"
    UPDATE_PLACEMENT_API_TPS = "UPDATE_PLACEMENT_API_TPS"
    DESCRIBE_PROJECT_API_TPS = "DESCRIBE_PROJECT_API_TPS"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsIoTAnalyticsQuota")
class AwsIoTAnalyticsQuota(enum.Enum):
    NUMBER_OF_START_PIPELINE_REPROCESSING_REQUESTS = "NUMBER_OF_START_PIPELINE_REPROCESSING_REQUESTS"
    NUMBER_OF_PARTITIONS_IN_A_DATA_STORE = "NUMBER_OF_PARTITIONS_IN_A_DATA_STORE"
    DATA_STORES_PER_ACCOUNT = "DATA_STORES_PER_ACCOUNT"
    CONCURRENT_CONTAINER_DATASET_RUNS = "CONCURRENT_CONTAINER_DATASET_RUNS"
    NUMBER_OF_PARQUET_SCHEMA_DEFINITION_COLUMNS = "NUMBER_OF_PARQUET_SCHEMA_DEFINITION_COLUMNS"
    SIZE_OF_BATCH_PUT_MESSAGE_MESSAGES = "SIZE_OF_BATCH_PUT_MESSAGE_MESSAGES"
    RATE_OF_BATCH_PUT_MESSAGE_MESSAGES = "RATE_OF_BATCH_PUT_MESSAGE_MESSAGES"
    CONTAINER_DATASETS_TRIGGERED_PER_SQL_DATA_SET = "CONTAINER_DATASETS_TRIGGERED_PER_SQL_DATA_SET"
    BATCH_SIZE_OF_BATCH_PUT_MESSAGE_MESSAGES = "BATCH_SIZE_OF_BATCH_PUT_MESSAGE_MESSAGES"
    MINIMUM_DATA_SET_REFRESH_INTERVAL = "MINIMUM_DATA_SET_REFRESH_INTERVAL"
    PIPELINES_PER_ACCOUNT = "PIPELINES_PER_ACCOUNT"
    DATA_SETS_PER_ACCOUNT = "DATA_SETS_PER_ACCOUNT"
    CHANNELS_PER_ACCOUNT = "CHANNELS_PER_ACCOUNT"
    CONCURRENT_DATA_SET_CONTENT_GENERATION = "CONCURRENT_DATA_SET_CONTENT_GENERATION"
    RATE_OF_CREATE_DATASET_CONTENT_REQUESTS = "RATE_OF_CREATE_DATASET_CONTENT_REQUESTS"
    DEPTH_OF_PARQUET_SCHEMA_DEFINITION_COLUMN = "DEPTH_OF_PARQUET_SCHEMA_DEFINITION_COLUMN"
    ACTIVITIES_PER_PIPELINE = "ACTIVITIES_PER_PIPELINE"
    RATE_OF_RUN_PIPELINE_ACTIVITY_REQUESTS = "RATE_OF_RUN_PIPELINE_ACTIVITY_REQUESTS"
    RATE_OF_SAMPLE_CHANNEL_DATA_REQUESTS = "RATE_OF_SAMPLE_CHANNEL_DATA_REQUESTS"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsIoTCoreDeviceAdvisorQuota")
class AwsIoTCoreDeviceAdvisorQuota(enum.Enum):
    RATE_OF_GET_SUITE_DEFINITION_API_REQUESTS = "RATE_OF_GET_SUITE_DEFINITION_API_REQUESTS"
    RATE_OF_GET_SUITE_RUN_API_REQUESTS = "RATE_OF_GET_SUITE_RUN_API_REQUESTS"
    RATE_OF_UNTAG_RESOURCE_API_REQUESTS = "RATE_OF_UNTAG_RESOURCE_API_REQUESTS"
    RATE_OF_LIST_SUITE_DEFINITIONS_API_REQUESTS = "RATE_OF_LIST_SUITE_DEFINITIONS_API_REQUESTS"
    CONCURRENTLY_CONNECTED_DEVICES = "CONCURRENTLY_CONNECTED_DEVICES"
    RATE_OF_LIST_TEST_CASES_API_REQUESTS = "RATE_OF_LIST_TEST_CASES_API_REQUESTS"
    TEST_CASE_EXECUTION_TIME = "TEST_CASE_EXECUTION_TIME"
    CONNECTIONS_PER_TEST_ENDPOINT = "CONNECTIONS_PER_TEST_ENDPOINT"
    RATE_OF_DELETE_SUITE_DEFINITION_API_REQUESTS = "RATE_OF_DELETE_SUITE_DEFINITION_API_REQUESTS"
    MQTT_CONNECT_REQUESTS_PER_CLIENT_ID = "MQTT_CONNECT_REQUESTS_PER_CLIENT_ID"
    MQTT_CONNECT_REQUESTS_PER_ACCOUNT = "MQTT_CONNECT_REQUESTS_PER_ACCOUNT"
    RATE_OF_START_SUITE_RUN_API_REQUESTS = "RATE_OF_START_SUITE_RUN_API_REQUESTS"
    RATE_OF_TAG_RESOURCE_API_REQUESTS = "RATE_OF_TAG_RESOURCE_API_REQUESTS"
    CONCURRENTLY_RUNNING_TEST_SUITES = "CONCURRENTLY_RUNNING_TEST_SUITES"
    TEST_CASES_PER_TEST_SUITE = "TEST_CASES_PER_TEST_SUITE"
    RATE_OF_CREATE_SUITE_DEFINITION_API_REQUESTS = "RATE_OF_CREATE_SUITE_DEFINITION_API_REQUESTS"
    RATE_OF_LIST_TAGS_FOR_RESOURCE_API_REQUESTS = "RATE_OF_LIST_TAGS_FOR_RESOURCE_API_REQUESTS"
    RATE_OF_LIST_SUITE_RUNS_API_REQUESTS = "RATE_OF_LIST_SUITE_RUNS_API_REQUESTS"
    RATE_OF_GET_SUITE_RUN_REPORT_API_REQUESTS = "RATE_OF_GET_SUITE_RUN_REPORT_API_REQUESTS"
    RATE_OF_UPDATE_SUITE_DEFINITION_API_REQUESTS = "RATE_OF_UPDATE_SUITE_DEFINITION_API_REQUESTS"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsIoTCoreQuota")
class AwsIoTCoreQuota(enum.Enum):
    REMOVE_THING_FROM_BILLING_GROUP_API_TPS = "REMOVE_THING_FROM_BILLING_GROUP_API_TPS"
    DELETE_BILLING_GROUP_API_TPS = "DELETE_BILLING_GROUP_API_TPS"
    CREATE_CERTIFICATE_PROVIDER_API_TPS = "CREATE_CERTIFICATE_PROVIDER_API_TPS"
    LIST_BILLING_GROUPS_API_TPS = "LIST_BILLING_GROUPS_API_TPS"
    DETACH_THING_PRINCIPAL_API_TPS = "DETACH_THING_PRINCIPAL_API_TPS"
    DESCRIBE_THING_TYPE_API_TPS = "DESCRIBE_THING_TYPE_API_TPS"
    DESCRIBE_BILLING_GROUP_API_TPS = "DESCRIBE_BILLING_GROUP_API_TPS"
    CREATE_DYNAMIC_THING_GROUP_API_TPS = "CREATE_DYNAMIC_THING_GROUP_API_TPS"
    DELETE_THING_TYPE_API_TPS = "DELETE_THING_TYPE_API_TPS"
    CREATE_THING_TYPE_API_TPS = "CREATE_THING_TYPE_API_TPS"
    LIST_THING_GROUPS_API_TPS = "LIST_THING_GROUPS_API_TPS"
    CREATE_THING_GROUP_API_TPS = "CREATE_THING_GROUP_API_TPS"
    UPDATE_CERTIFICATE_PROVIDER_API_TPS = "UPDATE_CERTIFICATE_PROVIDER_API_TPS"
    REMOVE_THING_FROM_THING_GROUP_API_TPS = "REMOVE_THING_FROM_THING_GROUP_API_TPS"
    LIST_CERTIFICATE_PROVIDERS_API_TPS = "LIST_CERTIFICATE_PROVIDERS_API_TPS"
    UPDATE_THING_GROUP_API_TPS = "UPDATE_THING_GROUP_API_TPS"
    DEPRECATE_THING_TYPE_API_TPS = "DEPRECATE_THING_TYPE_API_TPS"
    LIST_THINGS_IN_THING_GROUP_API_TPS = "LIST_THINGS_IN_THING_GROUP_API_TPS"
    ADD_THING_TO_THING_GROUP_API_TPS = "ADD_THING_TO_THING_GROUP_API_TPS"
    LIST_THING_PRINCIPALS_API_TPS = "LIST_THING_PRINCIPALS_API_TPS"
    UPDATE_THING_API_TPS = "UPDATE_THING_API_TPS"
    DELETE_THING_API_TPS = "DELETE_THING_API_TPS"
    ADD_THING_TO_BILLING_GROUP_API_TPS = "ADD_THING_TO_BILLING_GROUP_API_TPS"
    DELETE_DYNAMIC_THING_GROUP_API_TPS = "DELETE_DYNAMIC_THING_GROUP_API_TPS"
    TAG_RESOURCE_API_TPS = "TAG_RESOURCE_API_TPS"
    LIST_THING_TYPES_API_TPS = "LIST_THING_TYPES_API_TPS"
    LIST_PRINCIPAL_THINGS_API_TPS = "LIST_PRINCIPAL_THINGS_API_TPS"
    DELETE_THING_GROUP_API_TPS = "DELETE_THING_GROUP_API_TPS"
    UPDATE_DYNAMIC_THING_GROUP_API_TPS = "UPDATE_DYNAMIC_THING_GROUP_API_TPS"
    UNTAG_RESOURCE_API_TPS = "UNTAG_RESOURCE_API_TPS"
    DESCRIBE_THING_API_TPS = "DESCRIBE_THING_API_TPS"
    LIST_THINGS_IN_BILLING_GROUP_API_TPS = "LIST_THINGS_IN_BILLING_GROUP_API_TPS"
    DESCRIBE_THING_GROUP_API_TPS = "DESCRIBE_THING_GROUP_API_TPS"
    UPDATE_BILLING_GROUP_API_TPS = "UPDATE_BILLING_GROUP_API_TPS"
    ATTACH_THING_PRINCIPAL_API_TPS = "ATTACH_THING_PRINCIPAL_API_TPS"
    DELETE_CERTIFICATE_PROVIDER_API_TPS = "DELETE_CERTIFICATE_PROVIDER_API_TPS"
    CREATE_BILLING_GROUP_API_TPS = "CREATE_BILLING_GROUP_API_TPS"
    LIST_TAGS_FOR_RESOURCE_API_TPS = "LIST_TAGS_FOR_RESOURCE_API_TPS"
    LIST_THINGS_API_TPS = "LIST_THINGS_API_TPS"
    CREATE_THING_API_TPS = "CREATE_THING_API_TPS"
    LIST_THING_GROUPS_FOR_THING_API_TPS = "LIST_THING_GROUPS_FOR_THING_API_TPS"
    DESCRIBE_CERTIFICATE_PROVIDER_API_TPS = "DESCRIBE_CERTIFICATE_PROVIDER_API_TPS"
    MAXIMUM_NUMBER_OF_IN_FLIGHT_UNACKNOWLEDGED_MESSAGES_PER_THING = "MAXIMUM_NUMBER_OF_IN_FLIGHT_UNACKNOWLEDGED_MESSAGES_PER_THING"
    SHARED_SUBSCRIPTION_GROUPS_PER_ACCOUNT = "SHARED_SUBSCRIPTION_GROUPS_PER_ACCOUNT"
    MAXIMUM_NUMBER_OF_RETAINED_MESSAGES_PER_ACCOUNT = "MAXIMUM_NUMBER_OF_RETAINED_MESSAGES_PER_ACCOUNT"
    CONNECT_REQUESTS_PER_SECOND_PER_CLIENT_ID = "CONNECT_REQUESTS_PER_SECOND_PER_CLIENT_ID"
    MAXIMUM_SIZE_OF_A_THING_GROUP_ATTRIBUTE_VALUE_IN_CHARS = "MAXIMUM_SIZE_OF_A_THING_GROUP_ATTRIBUTE_VALUE_IN_CHARS"
    GET_RETAINED_MESSAGE_API_TPS = "GET_RETAINED_MESSAGE_API_TPS"
    MAXIMUM_MQTT5_PACKET_SIZE = "MAXIMUM_MQTT5_PACKET_SIZE"
    MAXIMUM_MQTT5_CORRELATION_DATA_SIZE = "MAXIMUM_MQTT5_CORRELATION_DATA_SIZE"
    UPDATE_CERTIFICATE_API_TPS = "UPDATE_CERTIFICATE_API_TPS"
    LIST_TOPIC_RULE_DESTINATIONS_API_TPS = "LIST_TOPIC_RULE_DESTINATIONS_API_TPS"
    MAXIMUM_LINE_LENGTH = "MAXIMUM_LINE_LENGTH"
    HTTP_ACTION_MAXIMUM_SIZE_OF_A_HEADER_KEY = "HTTP_ACTION_MAXIMUM_SIZE_OF_A_HEADER_KEY"
    HTTP_ACTION_REQUEST_TIMEOUT = "HTTP_ACTION_REQUEST_TIMEOUT"
    DELETE_CERTIFICATE_API_TPS = "DELETE_CERTIFICATE_API_TPS"
    REJECT_CERTIFICATE_TRANSFER_API_TPS = "REJECT_CERTIFICATE_TRANSFER_API_TPS"
    CREATE_TOPIC_RULE_DESTINATION_API_TPS = "CREATE_TOPIC_RULE_DESTINATION_API_TPS"
    CONNECTION_INACTIVITY_KEEP_ALIVE_INTERVAL = "CONNECTION_INACTIVITY_KEEP_ALIVE_INTERVAL"
    MINIMUM_MQTT5_MAXIMUM_PACKET_SIZE = "MINIMUM_MQTT5_MAXIMUM_PACKET_SIZE"
    LIST_PROVISIONING_TEMPLATES_API_TPS = "LIST_PROVISIONING_TEMPLATES_API_TPS"
    ENABLE_TOPIC_RULE_API_TPS = "ENABLE_TOPIC_RULE_API_TPS"
    NUMBER_OF_THING_TYPES_THAT_CAN_BE_ASSOCIATED_WITH_A_THING = "NUMBER_OF_THING_TYPES_THAT_CAN_BE_ASSOCIATED_WITH_A_THING"
    MAXIMUM_SHADOW_NAME_SIZE = "MAXIMUM_SHADOW_NAME_SIZE"
    RETAINED_MESSAGE_INBOUND_PUBLISH_REQUESTS_PER_SECOND_PER_TOPIC = "RETAINED_MESSAGE_INBOUND_PUBLISH_REQUESTS_PER_SECOND_PER_TOPIC"
    DELETE_CA_CERTIFICATE_API_TPS = "DELETE_CA_CERTIFICATE_API_TPS"
    FLEET_PROVISIONING_REGISTER_THING_MQTT_API_TPS = "FLEET_PROVISIONING_REGISTER_THING_MQTT_API_TPS"
    MAXIMUM_DEPTH_OF_JSON_DEVICE_STATE_DOCUMENTS = "MAXIMUM_DEPTH_OF_JSON_DEVICE_STATE_DOCUMENTS"
    REGISTER_CERTIFICATE_API_TPS = "REGISTER_CERTIFICATE_API_TPS"
    REQUESTS_PER_SECOND_PER_THING = "REQUESTS_PER_SECOND_PER_THING"
    MAXIMUM_MESSAGE_EXPIRY_INTERVAL = "MAXIMUM_MESSAGE_EXPIRY_INTERVAL"
    DELETE_POLICY_VERSION_API_TPS = "DELETE_POLICY_VERSION_API_TPS"
    SET_LOGGING_OPTIONS_API_TPS = "SET_LOGGING_OPTIONS_API_TPS"
    REGISTER_CERTIFICATE_WITHOUT_CA_API_TPS = "REGISTER_CERTIFICATE_WITHOUT_CA_API_TPS"
    MAXIMUM_NUMBER_OF_DYNAMIC_GROUPS = "MAXIMUM_NUMBER_OF_DYNAMIC_GROUPS"
    OUTBOUND_PUBLISH_REQUESTS_PER_SECOND_PER_ACCOUNT = "OUTBOUND_PUBLISH_REQUESTS_PER_SECOND_PER_ACCOUNT"
    REGISTRATION_TASK_TERMINATION = "REGISTRATION_TASK_TERMINATION"
    SUBSCRIBE_AND_UNSUBSCRIBE_REQUESTS_PER_SECOND_PER_GROUP = "SUBSCRIBE_AND_UNSUBSCRIBE_REQUESTS_PER_SECOND_PER_GROUP"
    CREATE_ROLE_ALIAS_API_TPS = "CREATE_ROLE_ALIAS_API_TPS"
    ATTACH_POLICY_API_TPS = "ATTACH_POLICY_API_TPS"
    MAXIMUM_RETRY_INTERVAL_FOR_DELIVERING_QO_S_1_MESSAGES = "MAXIMUM_RETRY_INTERVAL_FOR_DELIVERING_QO_S_1_MESSAGES"
    HTTP_ACTION_MAXIMUM_TOPIC_RULE_DESTINATIONS_PER_AWS_ACCOUNT = "HTTP_ACTION_MAXIMUM_TOPIC_RULE_DESTINATIONS_PER_AWS_ACCOUNT"
    MAXIMUM_NUMBER_OF_RESOURCE_SPECIFIC_LOGGING_CONFIGURATIONS_PER_AWS_ACCOUNT = "MAXIMUM_NUMBER_OF_RESOURCE_SPECIFIC_LOGGING_CONFIGURATIONS_PER_AWS_ACCOUNT"
    MAXIMUM_NUMBER_OF_CA_CERTIFICATES_WITH_THE_SAME_SUBJECT_FIELD_ALLOWED_PER_AWS_ACCOUNT_PER_REGION = "MAXIMUM_NUMBER_OF_CA_CERTIFICATES_WITH_THE_SAME_SUBJECT_FIELD_ALLOWED_PER_AWS_ACCOUNT_PER_REGION"
    WEB_SOCKET_CONNECTION_DURATION = "WEB_SOCKET_CONNECTION_DURATION"
    MAXIMUM_MQTT5_TOPIC_ALIAS_VALUE = "MAXIMUM_MQTT5_TOPIC_ALIAS_VALUE"
    CUSTOM_AUTHENTICATION_MAXIMUM_NUMBER_OF_AUTHORIZERS_PER_ACCOUNT = "CUSTOM_AUTHENTICATION_MAXIMUM_NUMBER_OF_AUTHORIZERS_PER_ACCOUNT"
    RULE_EVALUATIONS_PER_SECOND_PER_AWS_ACCOUNT = "RULE_EVALUATIONS_PER_SECOND_PER_AWS_ACCOUNT"
    DELETE_REGISTRATION_CODE_API_TPS = "DELETE_REGISTRATION_CODE_API_TPS"
    UPDATE_CA_CERTIFICATE_API_TPS = "UPDATE_CA_CERTIFICATE_API_TPS"
    GET_REGISTRATION_CODE_API_TPS = "GET_REGISTRATION_CODE_API_TPS"
    MAXIMUM_NUMBER_OF_POLICIES_THAT_CAN_BE_ATTACHED_TO_A_CERTIFICATE_OR_AMAZON_COGNITO_IDENTITY = "MAXIMUM_NUMBER_OF_POLICIES_THAT_CAN_BE_ATTACHED_TO_A_CERTIFICATE_OR_AMAZON_COGNITO_IDENTITY"
    MAXIMUM_NUMBER_OF_THING_GROUPS_A_THING_CAN_BELONG_TO = "MAXIMUM_NUMBER_OF_THING_GROUPS_A_THING_CAN_BELONG_TO"
    DESCRIBE_EVENT_CONFIGURATIONS_API_TPS = "DESCRIBE_EVENT_CONFIGURATIONS_API_TPS"
    DELETE_PROVISIONING_TEMPLATE_API_TPS = "DELETE_PROVISIONING_TEMPLATE_API_TPS"
    DELETE_DOMAIN_CONFIGURATION_API_TPS = "DELETE_DOMAIN_CONFIGURATION_API_TPS"
    MAXIMUM_NUMBER_OF_SLASHES_IN_TOPIC_AND_TOPIC_FILTER = "MAXIMUM_NUMBER_OF_SLASHES_IN_TOPIC_AND_TOPIC_FILTER"
    UPDATE_EVENT_CONFIGURATIONS_API_TPS = "UPDATE_EVENT_CONFIGURATIONS_API_TPS"
    REGISTER_THING_API_TPS = "REGISTER_THING_API_TPS"
    LIST_CERTIFICATES_API_TPS = "LIST_CERTIFICATES_API_TPS"
    MAXIMUM_SIZE_OF_FLEET_PROVISIONING_TEMPLATE = "MAXIMUM_SIZE_OF_FLEET_PROVISIONING_TEMPLATE"
    LIST_PRINCIPAL_POLICIES_API_TPS = "LIST_PRINCIPAL_POLICIES_API_TPS"
    FLEET_PROVISIONING_CREATE_CERTIFICATE_FROM_CSR_MQTT_API_TPS = "FLEET_PROVISIONING_CREATE_CERTIFICATE_FROM_CSR_MQTT_API_TPS"
    DESCRIBE_PROVISIONING_TEMPLATE_API_TPS = "DESCRIBE_PROVISIONING_TEMPLATE_API_TPS"
    CREATE_PROVISIONING_TEMPLATE_VERSION_API_TPS = "CREATE_PROVISIONING_TEMPLATE_VERSION_API_TPS"
    MAXIMUM_INBOUND_UNACKNOWLEDGED_QO_S_1_PUBLISH_REQUESTS = "MAXIMUM_INBOUND_UNACKNOWLEDGED_QO_S_1_PUBLISH_REQUESTS"
    DELETE_TOPIC_RULE_API_TPS = "DELETE_TOPIC_RULE_API_TPS"
    SET_V2_LOGGING_OPTIONS_API_TPS = "SET_V2_LOGGING_OPTIONS_API_TPS"
    UPDATE_ROLE_ALIAS_API_TPS = "UPDATE_ROLE_ALIAS_API_TPS"
    UPDATE_AUTHORIZER_API_TPS = "UPDATE_AUTHORIZER_API_TPS"
    DELETE_AUTHORIZER_API_TPS = "DELETE_AUTHORIZER_API_TPS"
    LIST_TARGETS_FOR_POLICY_API_TPS = "LIST_TARGETS_FOR_POLICY_API_TPS"
    DATA_RETENTION_POLICY = "DATA_RETENTION_POLICY"
    RULE_SIZE = "RULE_SIZE"
    MAXIMUM_THING_NAME_SIZE = "MAXIMUM_THING_NAME_SIZE"
    CREATE_POLICY_VERSION_API_TPS = "CREATE_POLICY_VERSION_API_TPS"
    ATTACH_PRINCIPAL_POLICY_API_TPS = "ATTACH_PRINCIPAL_POLICY_API_TPS"
    LIST_CA_CERTIFICATES_API_TPS = "LIST_CA_CERTIFICATES_API_TPS"
    SIZE_OF_THING_ATTRIBUTES_PER_THING = "SIZE_OF_THING_ATTRIBUTES_PER_THING"
    MAXIMUM_SIZE_OF_A_THING_GROUP_ATTRIBUTE_NAME_IN_CHARS = "MAXIMUM_SIZE_OF_A_THING_GROUP_ATTRIBUTE_NAME_IN_CHARS"
    MAXIMUM_NUMBER_OF_FLEET_PROVISIONING_TEMPLATES_PER_CUSTOMER = "MAXIMUM_NUMBER_OF_FLEET_PROVISIONING_TEMPLATES_PER_CUSTOMER"
    DELETE_POLICY_API_TPS = "DELETE_POLICY_API_TPS"
    LIST_OUTGOING_CERTIFICATES_API_TPS = "LIST_OUTGOING_CERTIFICATES_API_TPS"
    DESCRIBE_ENDPOINT_API_TPS = "DESCRIBE_ENDPOINT_API_TPS"
    CANCEL_CERTIFICATE_TRANSFER_API_TPS = "CANCEL_CERTIFICATE_TRANSFER_API_TPS"
    MQTT_PAYLOAD_SIZE = "MQTT_PAYLOAD_SIZE"
    MAXIMUM_NUMBER_OF_ACTIONS_PER_RULE = "MAXIMUM_NUMBER_OF_ACTIONS_PER_RULE"
    CONNECT_REQUESTS_PER_SECOND_PER_ACCOUNT = "CONNECT_REQUESTS_PER_SECOND_PER_ACCOUNT"
    RETAINED_MESSAGE_INBOUND_PUBLISH_REQUESTS_PER_SECOND_PER_ACCOUNT = "RETAINED_MESSAGE_INBOUND_PUBLISH_REQUESTS_PER_SECOND_PER_ACCOUNT"
    MAXIMUM_NUMBER_OF_THING_ATTRIBUTES_FOR_A_THING_WITHOUT_A_THING_TYPE = "MAXIMUM_NUMBER_OF_THING_ATTRIBUTES_FOR_A_THING_WITHOUT_A_THING_TYPE"
    DESCRIBE_CA_CERTIFICATE_API_TPS = "DESCRIBE_CA_CERTIFICATE_API_TPS"
    CREATE_TOPIC_RULE_API_TPS = "CREATE_TOPIC_RULE_API_TPS"
    HTTP_ACTION_MAXIMUM_LENGTH_OF_AN_ENDPOINT_URL = "HTTP_ACTION_MAXIMUM_LENGTH_OF_AN_ENDPOINT_URL"
    DELETE_PROVISIONING_TEMPLATE_VERSION_API_TPS = "DELETE_PROVISIONING_TEMPLATE_VERSION_API_TPS"
    LIST_PROVISIONING_TEMPLATE_VERSIONS_API_TPS = "LIST_PROVISIONING_TEMPLATE_VERSIONS_API_TPS"
    LIST_POLICY_VERSIONS_API_TPS = "LIST_POLICY_VERSIONS_API_TPS"
    MAXIMUM_THING_GROUP_NAME_SIZE = "MAXIMUM_THING_GROUP_NAME_SIZE"
    MAXIMUM_USER_PROPERTIES_TOTAL_SIZE = "MAXIMUM_USER_PROPERTIES_TOTAL_SIZE"
    GET_POLICY_VERSION_API_TPS = "GET_POLICY_VERSION_API_TPS"
    QUEUED_MESSAGES_PER_SECOND_PER_ACCOUNT = "QUEUED_MESSAGES_PER_SECOND_PER_ACCOUNT"
    MAXIMUM_NUMBER_OF_AWS_IO_T_CORE_ROLE_ALIASES = "MAXIMUM_NUMBER_OF_AWS_IO_T_CORE_ROLE_ALIASES"
    DESCRIBE_DOMAIN_CONFIGURATION_API_TPS = "DESCRIBE_DOMAIN_CONFIGURATION_API_TPS"
    CLEAR_DEFAULT_AUTHORIZER_API_TPS = "CLEAR_DEFAULT_AUTHORIZER_API_TPS"
    UPDATE_TOPIC_RULE_DESTINATION_API_TPS = "UPDATE_TOPIC_RULE_DESTINATION_API_TPS"
    LIST_TOPIC_RULES_API_TPS = "LIST_TOPIC_RULES_API_TPS"
    LIST_ATTACHED_POLICIES_API_TPS = "LIST_ATTACHED_POLICIES_API_TPS"
    CREATE_CERTIFICATE_FROM_CSR_API_TPS = "CREATE_CERTIFICATE_FROM_CSR_API_TPS"
    UPDATE_DOMAIN_CONFIGURATION_API_TPS = "UPDATE_DOMAIN_CONFIGURATION_API_TPS"
    FLEET_PROVISIONING_CREATE_KEYS_AND_CERTIFICATE_MQTT_API_TPS = "FLEET_PROVISIONING_CREATE_KEYS_AND_CERTIFICATE_MQTT_API_TPS"
    GET_V2_LOGGING_OPTIONS_API_TPS = "GET_V2_LOGGING_OPTIONS_API_TPS"
    LIST_DOMAIN_CONFIGURATIONS_API_TPS = "LIST_DOMAIN_CONFIGURATIONS_API_TPS"
    SET_DEFAULT_AUTHORIZER_API_TPS = "SET_DEFAULT_AUTHORIZER_API_TPS"
    LIST_V2_LOGGING_LEVELS_API_TPS = "LIST_V2_LOGGING_LEVELS_API_TPS"
    LIST_THING_REGISTRATION_TASK_API_TPS = "LIST_THING_REGISTRATION_TASK_API_TPS"
    DESCRIBE_THING_REGISTRATION_TASK_API_TPS = "DESCRIBE_THING_REGISTRATION_TASK_API_TPS"
    STOP_THING_REGISTRATION_TASK_API_TPS = "STOP_THING_REGISTRATION_TASK_API_TPS"
    MAXIMUM_POLICY_DOCUMENT_SIZE = "MAXIMUM_POLICY_DOCUMENT_SIZE"
    GET_TOPIC_RULE_DESTINATION_API_TPS = "GET_TOPIC_RULE_DESTINATION_API_TPS"
    MAXIMUM_DEPTH_OF_A_THING_GROUP_HIERARCHY = "MAXIMUM_DEPTH_OF_A_THING_GROUP_HIERARCHY"
    UPDATE_PROVISIONING_TEMPLATE_API_TPS = "UPDATE_PROVISIONING_TEMPLATE_API_TPS"
    MAXIMUM_NUMBER_OF_DOMAIN_CONFIGURATIONS_PER_ACCOUNT_PER_REGION = "MAXIMUM_NUMBER_OF_DOMAIN_CONFIGURATIONS_PER_ACCOUNT_PER_REGION"
    MAXIMUM_CONCURRENT_CLIENT_CONNECTIONS_PER_ACCOUNT = "MAXIMUM_CONCURRENT_CLIENT_CONNECTIONS_PER_ACCOUNT"
    ACCEPT_CERTIFICATE_TRANSFER_API_TPS = "ACCEPT_CERTIFICATE_TRANSFER_API_TPS"
    MAXIMUM_NUMBER_OF_THING_ATTRIBUTES_FOR_A_THING_WITH_A_THING_TYPE = "MAXIMUM_NUMBER_OF_THING_ATTRIBUTES_FOR_A_THING_WITH_A_THING_TYPE"
    MAXIMUM_NUMBER_OF_PROVISIONING_CLAIMS_THAT_CAN_BE_GENERATED_PER_SECOND_BY_TRUSTED_USER = "MAXIMUM_NUMBER_OF_PROVISIONING_CLAIMS_THAT_CAN_BE_GENERATED_PER_SECOND_BY_TRUSTED_USER"
    CLIENT_ID_SIZE = "CLIENT_ID_SIZE"
    DESCRIBE_PROVISIONING_TEMPLATE_VERSION_API_TPS = "DESCRIBE_PROVISIONING_TEMPLATE_VERSION_API_TPS"
    CONFIGURABLE_ENDPOINTS_MAXIMUM_NUMBER_OF_DOMAIN_CONFIGURATIONS_PER_ACCOUNT = "CONFIGURABLE_ENDPOINTS_MAXIMUM_NUMBER_OF_DOMAIN_CONFIGURATIONS_PER_ACCOUNT"
    TOPIC_SIZE = "TOPIC_SIZE"
    DESCRIBE_DEFAULT_AUTHORIZER_API_TPS = "DESCRIBE_DEFAULT_AUTHORIZER_API_TPS"
    LIST_ROLE_ALIASES_API_TPS = "LIST_ROLE_ALIASES_API_TPS"
    SUBSCRIPTIONS_PER_SECOND_PER_ACCOUNT = "SUBSCRIPTIONS_PER_SECOND_PER_ACCOUNT"
    MAXIMUM_OUTBOUND_UNACKNOWLEDGED_QO_S_1_PUBLISH_REQUESTS = "MAXIMUM_OUTBOUND_UNACKNOWLEDGED_QO_S_1_PUBLISH_REQUESTS"
    DELETE_V2_LOGGING_LEVEL_API_TPS = "DELETE_V2_LOGGING_LEVEL_API_TPS"
    DETACH_PRINCIPAL_POLICY_API_TPS = "DETACH_PRINCIPAL_POLICY_API_TPS"
    INBOUND_PUBLISH_REQUESTS_PER_SECOND_PER_ACCOUNT = "INBOUND_PUBLISH_REQUESTS_PER_SECOND_PER_ACCOUNT"
    LIST_AUTHORIZERS_API_TPS = "LIST_AUTHORIZERS_API_TPS"
    CREATE_KEYS_AND_CERTIFICATE_API_TPS = "CREATE_KEYS_AND_CERTIFICATE_API_TPS"
    ALLOWED_REGISTRATION_TASKS = "ALLOWED_REGISTRATION_TASKS"
    UPDATE_CERTIFICATE_TAG_API_TPS = "UPDATE_CERTIFICATE_TAG_API_TPS"
    SET_DEFAULT_POLICY_VERSION_API_TPS = "SET_DEFAULT_POLICY_VERSION_API_TPS"
    LIST_POLICY_PRINCIPALS_API_TPS = "LIST_POLICY_PRINCIPALS_API_TPS"
    CREATE_DOMAIN_CONFIGURATION_API_TPS = "CREATE_DOMAIN_CONFIGURATION_API_TPS"
    REGISTER_CA_CERTIFICATE_API_TPS = "REGISTER_CA_CERTIFICATE_API_TPS"
    ASSUME_ROLE_WITH_CERTIFICATE_API_TPS = "ASSUME_ROLE_WITH_CERTIFICATE_API_TPS"
    PERSISTENT_SESSION_EXPIRY_PERIOD = "PERSISTENT_SESSION_EXPIRY_PERIOD"
    SHARED_SUBSCRIPTIONS_PER_GROUP = "SHARED_SUBSCRIPTIONS_PER_GROUP"
    CREATE_AUTHORIZER_API_TPS = "CREATE_AUTHORIZER_API_TPS"
    MAXIMUM_SIZE_OF_A_JSON_STATE_DOCUMENT = "MAXIMUM_SIZE_OF_A_JSON_STATE_DOCUMENT"
    LIST_POLICIES_API_TPS = "LIST_POLICIES_API_TPS"
    DETACH_POLICY_API_TPS = "DETACH_POLICY_API_TPS"
    LIST_CERTIFICATES_BY_CA_API_TPS = "LIST_CERTIFICATES_BY_CA_API_TPS"
    DESCRIBE_CERTIFICATE_TAG_API_TPS = "DESCRIBE_CERTIFICATE_TAG_API_TPS"
    MAXIMUM_NUMBER_OF_DEVICE_CERTIFICATES_THAT_CAN_BE_REGISTERED_PER_SECOND = "MAXIMUM_NUMBER_OF_DEVICE_CERTIFICATES_THAT_CAN_BE_REGISTERED_PER_SECOND"
    GET_POLICY_API_TPS = "GET_POLICY_API_TPS"
    GET_EFFECTIVE_POLICIES_API_TPS = "GET_EFFECTIVE_POLICIES_API_TPS"
    THROUGHPUT_PER_SECOND_PER_CONNECTION = "THROUGHPUT_PER_SECOND_PER_CONNECTION"
    DELETE_TOPIC_RULE_DESTINATION_API_TPS = "DELETE_TOPIC_RULE_DESTINATION_API_TPS"
    DEVICE_SHADOW_API_REQUESTS_SECOND_PER_ACCOUNT = "DEVICE_SHADOW_API_REQUESTS_SECOND_PER_ACCOUNT"
    CREATE_POLICY_API_TPS = "CREATE_POLICY_API_TPS"
    MAXIMUM_NUMBER_OF_FLEET_PROVISIONING_TEMPLATE_VERSIONS_PER_TEMPLATE = "MAXIMUM_NUMBER_OF_FLEET_PROVISIONING_TEMPLATE_VERSIONS_PER_TEMPLATE"
    MAXIMUM_NUMBER_OF_ATTRIBUTES_ASSOCIATED_WITH_A_THING_GROUP = "MAXIMUM_NUMBER_OF_ATTRIBUTES_ASSOCIATED_WITH_A_THING_GROUP"
    DESCRIBE_CERTIFICATE_API_TPS = "DESCRIBE_CERTIFICATE_API_TPS"
    SUBSCRIPTIONS_PER_CONNECTION = "SUBSCRIPTIONS_PER_CONNECTION"
    MAXIMUM_SUBSCRIPTIONS_PER_SUBSCRIBE_REQUEST = "MAXIMUM_SUBSCRIPTIONS_PER_SUBSCRIBE_REQUEST"
    LIST_THING_REGISTRATION_TASK_REPORTS_API_TPS = "LIST_THING_REGISTRATION_TASK_REPORTS_API_TPS"
    GET_TOPIC_RULE_API_TPS = "GET_TOPIC_RULE_API_TPS"
    GET_LOGGING_OPTIONS_API_TPS = "GET_LOGGING_OPTIONS_API_TPS"
    MAXIMUM_NUMBER_OF_RULES_PER_AWS_ACCOUNT = "MAXIMUM_NUMBER_OF_RULES_PER_AWS_ACCOUNT"
    START_THING_REGISTRATION_TASK_API_TPS = "START_THING_REGISTRATION_TASK_API_TPS"
    MAXIMUM_NUMBER_OF_DIRECT_CHILD_GROUPS = "MAXIMUM_NUMBER_OF_DIRECT_CHILD_GROUPS"
    LIST_RETAINED_MESSAGES_API_TPS = "LIST_RETAINED_MESSAGES_API_TPS"
    DESCRIBE_AUTHORIZER_API_TPS = "DESCRIBE_AUTHORIZER_API_TPS"
    REPLACE_TOPIC_RULE_API_TPS = "REPLACE_TOPIC_RULE_API_TPS"
    MAXIMUM_NUMBER_OF_NAMED_POLICY_VERSIONS = "MAXIMUM_NUMBER_OF_NAMED_POLICY_VERSIONS"
    PUBLISH_REQUESTS_PER_SECOND_PER_CONNECTION = "PUBLISH_REQUESTS_PER_SECOND_PER_CONNECTION"
    TEST_INVOKE_AUTHORIZER_API_TPS = "TEST_INVOKE_AUTHORIZER_API_TPS"
    MAXIMUM_MQTT5_CONTENT_TYPE_SIZE = "MAXIMUM_MQTT5_CONTENT_TYPE_SIZE"
    DESCRIBE_ROLE_ALIAS_API_TPS = "DESCRIBE_ROLE_ALIAS_API_TPS"
    DISABLE_TOPIC_RULE_API_TPS = "DISABLE_TOPIC_RULE_API_TPS"
    TEST_AUTHORIZATION_API_TPS = "TEST_AUTHORIZATION_API_TPS"
    HTTP_ACTION_MAXIMUM_NUMBER_OF_HEADERS_PER_ACTION = "HTTP_ACTION_MAXIMUM_NUMBER_OF_HEADERS_PER_ACTION"
    CREATE_PROVISIONING_TEMPLATE_API_TPS = "CREATE_PROVISIONING_TEMPLATE_API_TPS"
    TRANSFER_CERTIFICATE_API_TPS = "TRANSFER_CERTIFICATE_API_TPS"
    SUBSCRIPTIONS_PER_ACCOUNT = "SUBSCRIPTIONS_PER_ACCOUNT"
    UPDATE_CERTIFICATE_MODE_API_TPS = "UPDATE_CERTIFICATE_MODE_API_TPS"
    DELETE_ROLE_ALIAS_API_TPS = "DELETE_ROLE_ALIAS_API_TPS"
    CREATE_PROVISIONING_CLAIM_API_TPS = "CREATE_PROVISIONING_CLAIM_API_TPS"
    CUSTOM_AUTHENTICATION_MAXIMUM_NUMBER_OF_ACTIVE_AUTHORIZERS_PER_ACCOUNT = "CUSTOM_AUTHENTICATION_MAXIMUM_NUMBER_OF_ACTIVE_AUTHORIZERS_PER_ACCOUNT"
    SET_V2_LOGGING_LEVEL_API_TPS = "SET_V2_LOGGING_LEVEL_API_TPS"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsIoTEventsQuota")
class AwsIoTEventsQuota(enum.Enum):
    MAXIMUM_ALARM_MODELS_PER_INPUT = "MAXIMUM_ALARM_MODELS_PER_INPUT"
    DETECTOR_MODEL_DEFINITION_SIZE = "DETECTOR_MODEL_DEFINITION_SIZE"
    MAXIMUM_ACTIONS_PER_EVENT = "MAXIMUM_ACTIONS_PER_EVENT"
    MAXIMUM_TRANSITION_EVENTS_PER_STATE = "MAXIMUM_TRANSITION_EVENTS_PER_STATE"
    MAXIMUM_ALARM_MODELS_PER_ACCOUNT = "MAXIMUM_ALARM_MODELS_PER_ACCOUNT"
    MESSAGES_PER_DETECTOR_PER_SECOND = "MESSAGES_PER_DETECTOR_PER_SECOND"
    MAXIMUM_TOTAL_MESSAGES_EVALUATED_PER_SECOND = "MAXIMUM_TOTAL_MESSAGES_EVALUATED_PER_SECOND"
    MAXIMUM_NUMBER_OF_RECIPIENTS_PER_NOTIFICATION_ACTION_IN_AN_ALARM_MODEL = "MAXIMUM_NUMBER_OF_RECIPIENTS_PER_NOTIFICATION_ACTION_IN_AN_ALARM_MODEL"
    MAXIMUM_ALARM_MODEL_VERSIONS_PER_ALARM_MODEL = "MAXIMUM_ALARM_MODEL_VERSIONS_PER_ALARM_MODEL"
    MAXIMUM_EVENTS_PER_STATE = "MAXIMUM_EVENTS_PER_STATE"
    MESSAGE_SIZE = "MESSAGE_SIZE"
    TRIGGER_EXPRESSIONS = "TRIGGER_EXPRESSIONS"
    DETECTOR_MODEL_VERSIONS = "DETECTOR_MODEL_VERSIONS"
    MAXIMUM_ALARMS_PER_ALARM_MODEL = "MAXIMUM_ALARMS_PER_ALARM_MODEL"
    INPUTS = "INPUTS"
    MAXIMUM_MESSAGES_PER_ALARM_PER_SECOND = "MAXIMUM_MESSAGES_PER_ALARM_PER_SECOND"
    MAXIMUM_NUMBER_OF_ALARM_MODELS_PER_PROPERTY_IN_AN_AWS_IO_T_SITE_WISE_ASSET_MODEL = "MAXIMUM_NUMBER_OF_ALARM_MODELS_PER_PROPERTY_IN_AN_AWS_IO_T_SITE_WISE_ASSET_MODEL"
    TIMERS_SCHEDULED_PER_DETECTOR = "TIMERS_SCHEDULED_PER_DETECTOR"
    STATES_PER_DETECTOR_MODEL = "STATES_PER_DETECTOR_MODEL"
    DETECTORS_PER_DETECTOR_MODEL = "DETECTORS_PER_DETECTOR_MODEL"
    NUMBER_OF_DETECTOR_MODEL_ANALYSES_IN_RUNNING_STATUS = "NUMBER_OF_DETECTOR_MODEL_ANALYSES_IN_RUNNING_STATUS"
    STATE_VARIABLES_PER_DETECTOR_MODEL_DEFINITION = "STATE_VARIABLES_PER_DETECTOR_MODEL_DEFINITION"
    MINIMUM_TIMER_DURATION = "MINIMUM_TIMER_DURATION"
    MAXIMUM_ACTIONS_PER_ALARM_MODEL = "MAXIMUM_ACTIONS_PER_ALARM_MODEL"
    DETECTOR_MODELS = "DETECTOR_MODELS"
    DETECTOR_MODELS_PER_INPUT = "DETECTOR_MODELS_PER_INPUT"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsIoTFleetHubQuota")
class AwsIoTFleetHubQuota(enum.Enum):
    NUMBER_OF_APPLICATIONS_PER_REGION_PER_AWS_ACCOUNT = "NUMBER_OF_APPLICATIONS_PER_REGION_PER_AWS_ACCOUNT"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsIoTFleetWiseQuota")
class AwsIoTFleetWiseQuota(enum.Enum):
    NUMBER_OF_MODEL_MANIFESTS_FOR_EACH_ACCOUNT_IN_AN_AWS_REGION = "NUMBER_OF_MODEL_MANIFESTS_FOR_EACH_ACCOUNT_IN_AN_AWS_REGION"
    NUMBER_OF_SIGNAL_CATALOGS_FOR_EACH_ACCOUNT_IN_AN_AWS_REGION = "NUMBER_OF_SIGNAL_CATALOGS_FOR_EACH_ACCOUNT_IN_AN_AWS_REGION"
    NUMBER_OF_VEHICLES_IN_A_FLEET_FOR_EACH_ACCOUNT_IN_AN_AWS_REGION = "NUMBER_OF_VEHICLES_IN_A_FLEET_FOR_EACH_ACCOUNT_IN_AN_AWS_REGION"
    NUMBER_OF_CAMPAIGNS_FOR_EACH_ACCOUNT_IN_AN_AWS_REGION = "NUMBER_OF_CAMPAIGNS_FOR_EACH_ACCOUNT_IN_AN_AWS_REGION"
    NUMBER_OF_DECODER_MANIFESTS_FOR_A_MODEL_MANIFEST_FOR_EACH_ACCOUNT_IN_AN_AWS_REGION = "NUMBER_OF_DECODER_MANIFESTS_FOR_A_MODEL_MANIFEST_FOR_EACH_ACCOUNT_IN_AN_AWS_REGION"
    NUMBER_OF_NODES_IN_A_SIGNAL_CATALOG_FOR_EACH_ACCOUNT_IN_AN_AWS_REGION = "NUMBER_OF_NODES_IN_A_SIGNAL_CATALOG_FOR_EACH_ACCOUNT_IN_AN_AWS_REGION"
    NUMBER_OF_SIGNALS_IN_A_CAMPAIGN_FOR_EACH_ACCOUNT_IN_AN_AWS_REGION = "NUMBER_OF_SIGNALS_IN_A_CAMPAIGN_FOR_EACH_ACCOUNT_IN_AN_AWS_REGION"
    RATE_OF_INGESTING_MESSAGES_FOR_EACH_ACCOUNT_IN_AN_AWS_REGION = "RATE_OF_INGESTING_MESSAGES_FOR_EACH_ACCOUNT_IN_AN_AWS_REGION"
    RATE_OF_INGESTING_MESSAGES_FOR_EACH_VEHICLE_IN_AN_AWS_REGION = "RATE_OF_INGESTING_MESSAGES_FOR_EACH_VEHICLE_IN_AN_AWS_REGION"
    RATE_OF_API_REQUESTS_FOR_EACH_ACCOUNT_IN_AN_AWS_REGION = "RATE_OF_API_REQUESTS_FOR_EACH_ACCOUNT_IN_AN_AWS_REGION"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsIoTGreengrassQuota")
class AwsIoTGreengrassQuota(enum.Enum):
    DEPLOYMENT_DOCUMENT_SIZE_WITH_LARGE_CONFIGURATION_SUPPORT = "DEPLOYMENT_DOCUMENT_SIZE_WITH_LARGE_CONFIGURATION_SUPPORT"
    RESOURCES_PER_LAMBDA_FUNCTION_V1 = "RESOURCES_PER_LAMBDA_FUNCTION_V1"
    RATE_OF_CREATE_COMPONENT_VERSION_REQUESTS = "RATE_OF_CREATE_COMPONENT_VERSION_REQUESTS"
    TOTAL_COMPONENT_ARTIFACT_SIZE = "TOTAL_COMPONENT_ARTIFACT_SIZE"
    RATE_OF_CREATE_DEPLOYMENT_REQUESTS_V1 = "RATE_OF_CREATE_DEPLOYMENT_REQUESTS_V1"
    THING_GROUP_DEPLOYMENT_DOCUMENT_SIZE_WITHOUT_LARGE_CONFIGURATION_SUPPORT = "THING_GROUP_DEPLOYMENT_DOCUMENT_SIZE_WITHOUT_LARGE_CONFIGURATION_SUPPORT"
    COMPONENTS = "COMPONENTS"
    THING_DEPLOYMENT_DOCUMENT_SIZE_WITHOUT_LARGE_CONFIGURATION_SUPPORT = "THING_DEPLOYMENT_DOCUMENT_SIZE_WITHOUT_LARGE_CONFIGURATION_SUPPORT"
    RESOURCES_PER_GREENGRASS_GROUP = "RESOURCES_PER_GREENGRASS_GROUP"
    SUBSCRIPTIONS_WITH_CLOUD_MESSAGE_SOURCE_PER_GREENGRASS_GROUP = "SUBSCRIPTIONS_WITH_CLOUD_MESSAGE_SOURCE_PER_GREENGRASS_GROUP"
    CORE_DEVICE_THING_NAME_LENGTH = "CORE_DEVICE_THING_NAME_LENGTH"
    LAMBDA_FUNCTIONS_PER_GREENGRASS_GROUP = "LAMBDA_FUNCTIONS_PER_GREENGRASS_GROUP"
    AWS_IO_T_DEVICES_PER_GREENGRASS_GROUP = "AWS_IO_T_DEVICES_PER_GREENGRASS_GROUP"
    COMPONENT_RECIPE_SIZE = "COMPONENT_RECIPE_SIZE"
    SUBSCRIPTIONS_PER_GREENGRASS_GROUP = "SUBSCRIPTIONS_PER_GREENGRASS_GROUP"
    VERSIONS_PER_COMPONENT = "VERSIONS_PER_COMPONENT"
    RATE_OF_API_REQUESTS = "RATE_OF_API_REQUESTS"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsIoTQuota")
class AwsIoTQuota(enum.Enum):
    LIST_AUDIT_MITIGATION_ACTIONS_TASKS_API_TPS = "LIST_AUDIT_MITIGATION_ACTIONS_TASKS_API_TPS"
    DESCRIBE_TUNNEL_API_THROTTLE_LIMIT = "DESCRIBE_TUNNEL_API_THROTTLE_LIMIT"
    METRIC_DIMENSIONS = "METRIC_DIMENSIONS"
    GET_JOB_DOCUMENT_THROTTLE_LIMIT = "GET_JOB_DOCUMENT_THROTTLE_LIMIT"
    LIST_METRIC_VALUES_API_TPS = "LIST_METRIC_VALUES_API_TPS"
    DELETE_SECURITY_PROFILE_API_TPS = "DELETE_SECURITY_PROFILE_API_TPS"
    CREATE_AUDIT_SUPPRESSION_API_TPS = "CREATE_AUDIT_SUPPRESSION_API_TPS"
    UPDATE_MITIGATION_ACTION_API_TPS = "UPDATE_MITIGATION_ACTION_API_TPS"
    DELETE_DIMENSION_API_TPS = "DELETE_DIMENSION_API_TPS"
    MAXIMUM_NUMBER_OF_WILDCARD_OPERATORS_PER_QUERY_TERM = "MAXIMUM_NUMBER_OF_WILDCARD_OPERATORS_PER_QUERY_TERM"
    MAXIMUM_LENGTH_OF_A_QUERY = "MAXIMUM_LENGTH_OF_A_QUERY"
    MAXIMUM_NUMBER_OF_CUSTOM_FIELDS_IN_AWS_THING_GROUPS_INDEX = "MAXIMUM_NUMBER_OF_CUSTOM_FIELDS_IN_AWS_THING_GROUPS_INDEX"
    STATUS_DETAIL_MAP_KEY_VALUE_PAIRS = "STATUS_DETAIL_MAP_KEY_VALUE_PAIRS"
    LIST_JOB_EXECUTIONS_FOR_JOB_THROTTLE_LIMIT = "LIST_JOB_EXECUTIONS_FOR_JOB_THROTTLE_LIMIT"
    GET_OTA_UPDATE_API_TPS = "GET_OTA_UPDATE_API_TPS"
    DESCRIBE_ACCOUNT_AUDIT_CONFIGURATION_API_TPS = "DESCRIBE_ACCOUNT_AUDIT_CONFIGURATION_API_TPS"
    LIST_AUDIT_TASKS_API_TPS = "LIST_AUDIT_TASKS_API_TPS"
    MAXIMUM_BANDWIDTH_PER_TUNNEL = "MAXIMUM_BANDWIDTH_PER_TUNNEL"
    DELETE_OTA_UPDATE_API_TPS = "DELETE_OTA_UPDATE_API_TPS"
    DESCRIBE_AUDIT_FINDING_API_TPS = "DESCRIBE_AUDIT_FINDING_API_TPS"
    MITIGATION_ACTIONS = "MITIGATION_ACTIONS"
    LIST_JOBS_THROTTLE_LIMIT = "LIST_JOBS_THROTTLE_LIMIT"
    DESCRIBE_CUSTOM_METRIC_API_TPS = "DESCRIBE_CUSTOM_METRIC_API_TPS"
    LIST_JOB_EXECUTIONS_FOR_THING_THROTTLE_LIMIT = "LIST_JOB_EXECUTIONS_FOR_THING_THROTTLE_LIMIT"
    CUSTOM_METRICS = "CUSTOM_METRICS"
    S3_JOB_DOCUMENT_LENGTH = "S3_JOB_DOCUMENT_LENGTH"
    MAXIMUM_NUMBER_OF_QUERY_TERMS_PER_DYNAMIC_GROUP = "MAXIMUM_NUMBER_OF_QUERY_TERMS_PER_DYNAMIC_GROUP"
    BEHAVIOR_METRIC_VALUE_ELEMENTS_FOR_EACH_SECURITY_PROFILE = "BEHAVIOR_METRIC_VALUE_ELEMENTS_FOR_EACH_SECURITY_PROFILE"
    SCHEDULED_AUDITS = "SCHEDULED_AUDITS"
    DATA_RETENTION = "DATA_RETENTION"
    LIST_SECURITY_PROFILES_FOR_TARGET_API_TPS = "LIST_SECURITY_PROFILES_FOR_TARGET_API_TPS"
    PRE_SIGNED_URL_LIFETIME = "PRE_SIGNED_URL_LIFETIME"
    STATUS_DETAIL_MAP_KEY_LENGTH = "STATUS_DETAIL_MAP_KEY_LENGTH"
    DESCRIBE_DETECT_MITIGATION_ACTIONS_TASK_API_TPS = "DESCRIBE_DETECT_MITIGATION_ACTIONS_TASK_API_TPS"
    MAXIMUM_TAG_VALUE_LENGTH = "MAXIMUM_TAG_VALUE_LENGTH"
    MAXIMUM_NUMBER_OF_JOB_TEMPLATES = "MAXIMUM_NUMBER_OF_JOB_TEMPLATES"
    CREATE_JOB_THROTTLE_LIMIT = "CREATE_JOB_THROTTLE_LIMIT"
    LIST_INDICES_RATE = "LIST_INDICES_RATE"
    UNTAG_RESOURCE_API_TROTTLE_LIMIT = "UNTAG_RESOURCE_API_TROTTLE_LIMIT"
    LIST_OTA_UPDATES_API_TPS = "LIST_OTA_UPDATES_API_TPS"
    STEP_TIMER = "STEP_TIMER"
    CANCEL_AUDIT_TASK_API_TPS = "CANCEL_AUDIT_TASK_API_TPS"
    STATUS_DETAIL_MAP_VALUE_LENGTH = "STATUS_DETAIL_MAP_VALUE_LENGTH"
    COMMENT_LENGTH = "COMMENT_LENGTH"
    DELETE_ACCOUNT_AUDIT_CONFIGURATION_API_TPS = "DELETE_ACCOUNT_AUDIT_CONFIGURATION_API_TPS"
    GET_CARDINALITY_RATE = "GET_CARDINALITY_RATE"
    STORAGE_DURATION_FOR_AUDIT_FINDINGS = "STORAGE_DURATION_FOR_AUDIT_FINDINGS"
    LIST_MITIGATION_ACTIONS_API_TPS = "LIST_MITIGATION_ACTIONS_API_TPS"
    UPDATE_AUDIT_SUPPRESSION_API_TPS = "UPDATE_AUDIT_SUPPRESSION_API_TPS"
    DESCRIBE_AUDIT_SUPPRESSION_API_TPS = "DESCRIBE_AUDIT_SUPPRESSION_API_TPS"
    DELETE_AUDIT_SUPPRESSION_API_TPS = "DELETE_AUDIT_SUPPRESSION_API_TPS"
    MAXIMUM_NUMBER_OF_PERCENTILE_VALUES_PER_FLEET_METRIC = "MAXIMUM_NUMBER_OF_PERCENTILE_VALUES_PER_FLEET_METRIC"
    LIST_ACTIVE_VIOLATIONS_API_TPS = "LIST_ACTIVE_VIOLATIONS_API_TPS"
    IN_PROGRESS_TIMEOUT = "IN_PROGRESS_TIMEOUT"
    CREATE_STREAM_API_TPS = "CREATE_STREAM_API_TPS"
    GET_PERCENTILES_RATE = "GET_PERCENTILES_RATE"
    CLOSE_TUNNEL_API_THROTTLE_LIMIT = "CLOSE_TUNNEL_API_THROTTLE_LIMIT"
    SIMULTANEOUS_IN_PROGRESS_ON_DEMAND_AUDITS = "SIMULTANEOUS_IN_PROGRESS_ON_DEMAND_AUDITS"
    START_ON_DEMAND_AUDIT_TASK_API_TPS = "START_ON_DEMAND_AUDIT_TASK_API_TPS"
    STREAMS_PER_ACCOUNT = "STREAMS_PER_ACCOUNT"
    MAXIMUM_NUMBER_OF_QUERY_TERMS_PER_FLEET_METRIC = "MAXIMUM_NUMBER_OF_QUERY_TERMS_PER_FLEET_METRIC"
    MINIMUM_PERIOD_OF_A_FLEET_METRIC = "MINIMUM_PERIOD_OF_A_FLEET_METRIC"
    MAXIMUM_NUMBER_OF_CUSTOM_FIELDS_IN_AWS_THINGS_INDEX = "MAXIMUM_NUMBER_OF_CUSTOM_FIELDS_IN_AWS_THINGS_INDEX"
    ACTIVE_SNAPSHOT_JOBS = "ACTIVE_SNAPSHOT_JOBS"
    LIST_AUDIT_SUPPRESSIONS_API_TPS = "LIST_AUDIT_SUPPRESSIONS_API_TPS"
    LIST_STREAMS_API_TPS = "LIST_STREAMS_API_TPS"
    MAXIMUM_NUMBER_OF_TAGS_PER_RESOURCE = "MAXIMUM_NUMBER_OF_TAGS_PER_RESOURCE"
    MAXIMUM_TUNNEL_LIFETIME = "MAXIMUM_TUNNEL_LIFETIME"
    UPDATE_CUSTOM_METRIC_API_TPS = "UPDATE_CUSTOM_METRIC_API_TPS"
    JOB_TARGETS = "JOB_TARGETS"
    DESCRIBE_JOB_TEMPLATE_THROTTLE_LIMIT = "DESCRIBE_JOB_TEMPLATE_THROTTLE_LIMIT"
    CREATE_OTA_UPDATE_API_TPS = "CREATE_OTA_UPDATE_API_TPS"
    LIST_DETECT_MITIGATION_ACTIONS_EXECUTIONS_API_TPS = "LIST_DETECT_MITIGATION_ACTIONS_EXECUTIONS_API_TPS"
    START_NEXT_PENDING_JOB_EXECUTION_UPDATE_JOB_EXECUTION_THROTTLE_LIMIT = "START_NEXT_PENDING_JOB_EXECUTION_UPDATE_JOB_EXECUTION_THROTTLE_LIMIT"
    MAXIMUM_NUMBER_OF_TARGETS_IN_THE_GEO_LOCATIONS_FILTER = "MAXIMUM_NUMBER_OF_TARGETS_IN_THE_GEO_LOCATIONS_FILTER"
    MAXIMUM_NUMBER_OF_DYNAMIC_GROUPS = "MAXIMUM_NUMBER_OF_DYNAMIC_GROUPS"
    DELETE_STREAM_API_TPS = "DELETE_STREAM_API_TPS"
    DESCRIBE_MITIGATION_ACTION_API_TPS = "DESCRIBE_MITIGATION_ACTION_API_TPS"
    LIST_RESULTS_PER_PAGE = "LIST_RESULTS_PER_PAGE"
    FILE_SIZE = "FILE_SIZE"
    JOB_DESCRIPTION_LENGTH = "JOB_DESCRIPTION_LENGTH"
    SEARCH_INDEX_RATE = "SEARCH_INDEX_RATE"
    MAXIMUM_NUMBER_OF_NAMES_IN_THE_NAMED_SHADOW_NAMES_FILTER = "MAXIMUM_NUMBER_OF_NAMES_IN_THE_NAMED_SHADOW_NAMES_FILTER"
    DESCRIBE_JOB_THROTTLE_LIMIT = "DESCRIBE_JOB_THROTTLE_LIMIT"
    LIST_AUDIT_MITIGATION_ACTIONS_EXECUTIONS_API_TPS = "LIST_AUDIT_MITIGATION_ACTIONS_EXECUTIONS_API_TPS"
    TAG_RESOURCE_API_THROTTLE_LIMIT = "TAG_RESOURCE_API_THROTTLE_LIMIT"
    CREATE_SCHEDULED_AUDIT_API_TPS = "CREATE_SCHEDULED_AUDIT_API_TPS"
    UPDATE_ACCOUNT_AUDIT_CONFIGURATION_API_TPS = "UPDATE_ACCOUNT_AUDIT_CONFIGURATION_API_TPS"
    LIST_AUDIT_FINDINGS_API_TPS = "LIST_AUDIT_FINDINGS_API_TPS"
    CREATE_MITIGATION_ACTION_API_TPS = "CREATE_MITIGATION_ACTION_API_TPS"
    DESCRIBE_SECURITY_PROFILE_API_TPS = "DESCRIBE_SECURITY_PROFILE_API_TPS"
    LIST_JOB_TEMPLATES_THROTTLE_LIMIT = "LIST_JOB_TEMPLATES_THROTTLE_LIMIT"
    MAXIMUM_NUMBER_OF_QUERY_TERMS_PER_QUERY = "MAXIMUM_NUMBER_OF_QUERY_TERMS_PER_QUERY"
    ACTIVE_CONTINUOUS_JOBS = "ACTIVE_CONTINUOUS_JOBS"
    UPDATE_STREAM_API_TPS = "UPDATE_STREAM_API_TPS"
    JOB_TEMPLATE_DESCRIPTION_LENGTH = "JOB_TEMPLATE_DESCRIPTION_LENGTH"
    LIST_SCHEDULED_AUDITS_API_TPS = "LIST_SCHEDULED_AUDITS_API_TPS"
    DESCRIBE_AUDIT_TASK_API_TPS = "DESCRIBE_AUDIT_TASK_API_TPS"
    LIST_TARGETS_FOR_SECURITY_PROFILE_API_TPS = "LIST_TARGETS_FOR_SECURITY_PROFILE_API_TPS"
    DESCRIBE_DIMENSION_API_TPS = "DESCRIBE_DIMENSION_API_TPS"
    MAXIMUM_TAG_KEY_LENGTH = "MAXIMUM_TAG_KEY_LENGTH"
    STORAGE_DURATION_FOR_DETECT_METRICS = "STORAGE_DURATION_FOR_DETECT_METRICS"
    DELETE_JOB_EXECUTION_THROTTLE_LIMIT = "DELETE_JOB_EXECUTION_THROTTLE_LIMIT"
    LIST_VIOLATION_EVENTS_API_TPS = "LIST_VIOLATION_EVENTS_API_TPS"
    START_DETECT_MITIGATION_ACTIONS_TASK_API_TPS = "START_DETECT_MITIGATION_ACTIONS_TASK_API_TPS"
    DEVICE_METRIC_PEAK_REPORTING_RATE_FOR_AN_ACCOUNT = "DEVICE_METRIC_PEAK_REPORTING_RATE_FOR_AN_ACCOUNT"
    LIST_DETECT_MITIGATION_ACTIONS_TASKS_API_TPS = "LIST_DETECT_MITIGATION_ACTIONS_TASKS_API_TPS"
    OPEN_TUNNEL_API_THROTTLE_LIMIT = "OPEN_TUNNEL_API_THROTTLE_LIMIT"
    DESCRIBE_SCHEDULED_AUDIT_API_TPS = "DESCRIBE_SCHEDULED_AUDIT_API_TPS"
    DESCRIBE_INDEX_RATE = "DESCRIBE_INDEX_RATE"
    DESCRIBE_JOB_EXECUTION_GET_PENDING_JOB_EXECUTIONS_THROTTLE_LIMIT = "DESCRIBE_JOB_EXECUTION_GET_PENDING_JOB_EXECUTIONS_THROTTLE_LIMIT"
    DEVICE_METRIC_MINIMUM_DELAY = "DEVICE_METRIC_MINIMUM_DELAY"
    JOB_ID_LENGTH = "JOB_ID_LENGTH"
    MAXIMUM_PERIOD_OF_A_FLEET_METRIC = "MAXIMUM_PERIOD_OF_A_FLEET_METRIC"
    MAXIMUM_CONNECTION_RATE = "MAXIMUM_CONNECTION_RATE"
    DESCRIBE_STREAM_API_TPS = "DESCRIBE_STREAM_API_TPS"
    LIST_DIMENSIONS_API_TPS = "LIST_DIMENSIONS_API_TPS"
    LIST_SECURITY_PROFILES_API_TPS = "LIST_SECURITY_PROFILES_API_TPS"
    VALIDATE_SECURITY_PROFILE_BEHAVIORS_API_TPS = "VALIDATE_SECURITY_PROFILE_BEHAVIORS_API_TPS"
    UPDATE_INDEXING_CONFIGURATION_RATE = "UPDATE_INDEXING_CONFIGURATION_RATE"
    DELETE_SCHEDULED_AUDIT_API_TPS = "DELETE_SCHEDULED_AUDIT_API_TPS"
    GET_STATISTICS_RATE = "GET_STATISTICS_RATE"
    MAXIMUM_NUMBER_OF_FLEET_METRICS = "MAXIMUM_NUMBER_OF_FLEET_METRICS"
    DELETE_CUSTOM_METRIC_API_TPS = "DELETE_CUSTOM_METRIC_API_TPS"
    MINIMUM_PRE_SIGNED_URL_LIFETIME = "MINIMUM_PRE_SIGNED_URL_LIFETIME"
    GET_INDEXING_CONFIGURATION_RATE = "GET_INDEXING_CONFIGURATION_RATE"
    MINIMUM_JOB_EXECUTION_ROLL_OUT_RATE = "MINIMUM_JOB_EXECUTION_ROLL_OUT_RATE"
    PUT_VERIFICATION_STATE_ON_VIOLATION_API_TPS = "PUT_VERIFICATION_STATE_ON_VIOLATION_API_TPS"
    DELETE_MITIGATION_ACTION_API_TPS = "DELETE_MITIGATION_ACTION_API_TPS"
    JOB_EXECUTION_ROLL_OUT_RATE = "JOB_EXECUTION_ROLL_OUT_RATE"
    ASSOCIATE_TARGETS_WITH_JOB_THROTTLE_LIMIT = "ASSOCIATE_TARGETS_WITH_JOB_THROTTLE_LIMIT"
    SECURITY_PROFILES_FOR_EACH_TARGET = "SECURITY_PROFILES_FOR_EACH_TARGET"
    CANCEL_AUDIT_MITIGATION_ACTIONS_TASK_API_TPS = "CANCEL_AUDIT_MITIGATION_ACTIONS_TASK_API_TPS"
    CREATE_SECURITY_PROFILE_API_TPS = "CREATE_SECURITY_PROFILE_API_TPS"
    BEHAVIORS_FOR_EACH_SECURITY_PROFILE = "BEHAVIORS_FOR_EACH_SECURITY_PROFILE"
    CANCEL_JOB_EXECUTION_THROTTLE_LIMIT = "CANCEL_JOB_EXECUTION_THROTTLE_LIMIT"
    CREATE_JOB_TEMPLATE_THROTTLE_LIMIT = "CREATE_JOB_TEMPLATE_THROTTLE_LIMIT"
    CANCEL_DETECT_MITIGATION_ACTIONS_TASK_API_TPS = "CANCEL_DETECT_MITIGATION_ACTIONS_TASK_API_TPS"
    LIST_CUSTOM_METRICS_API_TPS = "LIST_CUSTOM_METRICS_API_TPS"
    DELETE_JOB_TEMPLATE_THROTTLE_LIMIT = "DELETE_JOB_TEMPLATE_THROTTLE_LIMIT"
    UPDATE_JOB_THROTTLE_LIMIT = "UPDATE_JOB_THROTTLE_LIMIT"
    UPDATE_SECURITY_PROFILE_API_TPS = "UPDATE_SECURITY_PROFILE_API_TPS"
    JOB_TEMPLATE_ID_LENGTH = "JOB_TEMPLATE_ID_LENGTH"
    DOCUMENT_SOURCE_LENGTH = "DOCUMENT_SOURCE_LENGTH"
    ATTACH_SECURITY_PROFILE_API_TPS = "ATTACH_SECURITY_PROFILE_API_TPS"
    FILES_PER_STREAM = "FILES_PER_STREAM"
    UPDATE_SCHEDULED_AUDIT_API_TPS = "UPDATE_SCHEDULED_AUDIT_API_TPS"
    DETACH_SECURITY_PROFILE_API_TPS = "DETACH_SECURITY_PROFILE_API_TPS"
    LIST_TAGS_FOR_RESOURCE_API_THROTTLE_LIMIT = "LIST_TAGS_FOR_RESOURCE_API_THROTTLE_LIMIT"
    START_AUDIT_MITIGATION_ACTIONS_TASK_API_TPS = "START_AUDIT_MITIGATION_ACTIONS_TASK_API_TPS"
    DESCRIBE_JOB_EXECUTION_THROTTLE_LIMIT = "DESCRIBE_JOB_EXECUTION_THROTTLE_LIMIT"
    CANCEL_JOB_THROTTLE_LIMIT = "CANCEL_JOB_THROTTLE_LIMIT"
    DESCRIBE_AUDIT_MITIGATION_ACTIONS_TASK_API_TPS = "DESCRIBE_AUDIT_MITIGATION_ACTIONS_TASK_API_TPS"
    MAXIMUM_LENGTH_OF_A_CUSTOM_FIELD_NAME = "MAXIMUM_LENGTH_OF_A_CUSTOM_FIELD_NAME"
    CREATE_CUSTOM_METRIC_API_TPS = "CREATE_CUSTOM_METRIC_API_TPS"
    CONCURRENT_JOBS = "CONCURRENT_JOBS"
    DELETE_JOB_THROTTLE_LIMIT = "DELETE_JOB_THROTTLE_LIMIT"
    UPDATE_DIMENSION_API_TPS = "UPDATE_DIMENSION_API_TPS"
    LIST_TUNNELS_API_THROTTLE_LIMIT = "LIST_TUNNELS_API_THROTTLE_LIMIT"
    STORAGE_DURATION_FOR_DETECT_VIOLATIONS = "STORAGE_DURATION_FOR_DETECT_VIOLATIONS"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsIoTRoboRunnerQuota")
class AwsIoTRoboRunnerQuota(enum.Enum):
    RATE_OF_LIST_WORKER_FLEETS_REQUESTS = "RATE_OF_LIST_WORKER_FLEETS_REQUESTS"
    RATE_OF_DELETE_WORKER_REQUESTS = "RATE_OF_DELETE_WORKER_REQUESTS"
    RATE_OF_CREATE_DESTINATION_REQUESTS = "RATE_OF_CREATE_DESTINATION_REQUESTS"
    RATE_OF_LIST_SITES_REQUESTS = "RATE_OF_LIST_SITES_REQUESTS"
    WORKER_FLEETS = "WORKER_FLEETS"
    RATE_OF_GET_WORKER_REQUESTS = "RATE_OF_GET_WORKER_REQUESTS"
    RATE_OF_DELETE_DESTINATION_REQUESTS = "RATE_OF_DELETE_DESTINATION_REQUESTS"
    RATE_OF_LIST_DESTINATIONS_REQUESTS = "RATE_OF_LIST_DESTINATIONS_REQUESTS"
    WORKERS = "WORKERS"
    RATE_OF_CREATE_WORKER_FLEET_REQUESTS = "RATE_OF_CREATE_WORKER_FLEET_REQUESTS"
    RATE_OF_CREATE_WORKER_REQUESTS = "RATE_OF_CREATE_WORKER_REQUESTS"
    RATE_OF_UPDATE_WORKER_REQUESTS = "RATE_OF_UPDATE_WORKER_REQUESTS"
    SITES = "SITES"
    RATE_OF_DELETE_WORKER_FLEET_REQUESTS = "RATE_OF_DELETE_WORKER_FLEET_REQUESTS"
    RATE_OF_DELETE_SITE_REQUESTS = "RATE_OF_DELETE_SITE_REQUESTS"
    RATE_OF_UPDATE_DESTINATION_REQUESTS = "RATE_OF_UPDATE_DESTINATION_REQUESTS"
    RATE_OF_UPDATE_WORKER_FLEET_REQUESTS = "RATE_OF_UPDATE_WORKER_FLEET_REQUESTS"
    RATE_OF_GET_SITE_REQUESTS = "RATE_OF_GET_SITE_REQUESTS"
    RATE_OF_LIST_WORKERS_REQUESTS = "RATE_OF_LIST_WORKERS_REQUESTS"
    RATE_OF_CREATE_SITE_REQUESTS = "RATE_OF_CREATE_SITE_REQUESTS"
    RATE_OF_GET_WORKER_FLEET_REQUESTS = "RATE_OF_GET_WORKER_FLEET_REQUESTS"
    RATE_OF_GET_DESTINATION_REQUESTS = "RATE_OF_GET_DESTINATION_REQUESTS"
    RATE_OF_UPDATE_SITE_REQUESTS = "RATE_OF_UPDATE_SITE_REQUESTS"
    DESTINATIONS = "DESTINATIONS"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsIoTSiteWiseQuota")
class AwsIoTSiteWiseQuota(enum.Enum):
    RATE_OF_GET_ASSET_PROPERTY_AGGREGATES_REQUEST_AND_BATCH_GET_ASSET_PROPERTY_AGGREGATES_ENTRY_QUERIES_PER_ASSET_PROPERTY = "RATE_OF_GET_ASSET_PROPERTY_AGGREGATES_REQUEST_AND_BATCH_GET_ASSET_PROPERTY_AGGREGATES_ENTRY_QUERIES_PER_ASSET_PROPERTY"
    REQUEST_RATE_FOR_CREATE_ASSET_MODEL = "REQUEST_RATE_FOR_CREATE_ASSET_MODEL"
    NUMBER_OF_PROPERTIES_PER_ASSET_MODEL = "NUMBER_OF_PROPERTIES_PER_ASSET_MODEL"
    RATE_OF_GET_INTERPOLATED_ASSET_PROPERTY_VALUES_REQUESTS = "RATE_OF_GET_INTERPOLATED_ASSET_PROPERTY_VALUES_REQUESTS"
    REQUEST_RATE_FOR_BATCH_PUT_ASSET_PROPERTY_VALUE = "REQUEST_RATE_FOR_BATCH_PUT_ASSET_PROPERTY_VALUE"
    REQUEST_RATE_FOR_LIST_ACTIONS = "REQUEST_RATE_FOR_LIST_ACTIONS"
    REQUEST_RATE_FOR_EXECUTE_ACTION = "REQUEST_RATE_FOR_EXECUTE_ACTION"
    REQUEST_RATE_FOR_DISASSOCIATE_ASSETS = "REQUEST_RATE_FOR_DISASSOCIATE_ASSETS"
    REQUEST_RATE_FOR_DELETE_ASSET_MODEL_COMPOSITE_MODEL = "REQUEST_RATE_FOR_DELETE_ASSET_MODEL_COMPOSITE_MODEL"
    NUMBER_OF_PROPERTIES_AT_ROOT_OF_EACH_ASSET_MODEL_OF_TYPE_ASSET_MODEL = "NUMBER_OF_PROPERTIES_AT_ROOT_OF_EACH_ASSET_MODEL_OF_TYPE_ASSET_MODEL"
    NUMBER_OF_CHILD_ASSETS_PER_PARENT_ASSET = "NUMBER_OF_CHILD_ASSETS_PER_PARENT_ASSET"
    NUMBER_OF_PROPERTIES_PER_COMPOSITE_MODEL = "NUMBER_OF_PROPERTIES_PER_COMPOSITE_MODEL"
    NUMBER_OF_PROJECTS_PER_PORTAL = "NUMBER_OF_PROJECTS_PER_PORTAL"
    NUMBER_OF_COMPOSITE_MODELS_PER_ASSET_MODEL = "NUMBER_OF_COMPOSITE_MODELS_PER_ASSET_MODEL"
    NUMBER_OF_METRICS_PER_DASHBOARD_VISUALIZATION = "NUMBER_OF_METRICS_PER_DASHBOARD_VISUALIZATION"
    NUMBER_OF_PROPERTY_VARIABLES_PER_PROPERTY_FORMULA_EXPRESSION = "NUMBER_OF_PROPERTY_VARIABLES_PER_PROPERTY_FORMULA_EXPRESSION"
    REQUEST_RATE_FOR_DESCRIBE_ASSET_MODEL = "REQUEST_RATE_FOR_DESCRIBE_ASSET_MODEL"
    RATE_OF_DATAPOINTS_RETRIEVED_FROM_GET_ASSET_PROPERTY_VALUE_HISTORY_AND_BATCH_GET_ASSET_PROPERTY_VALUE_HISTORY = "RATE_OF_DATAPOINTS_RETRIEVED_FROM_GET_ASSET_PROPERTY_VALUE_HISTORY_AND_BATCH_GET_ASSET_PROPERTY_VALUE_HISTORY"
    REQUEST_RATE_FOR_LIST_ASSET_RELATIONSHIPS = "REQUEST_RATE_FOR_LIST_ASSET_RELATIONSHIPS"
    REQUEST_RATE_FOR_LIST_TIME_SERIES = "REQUEST_RATE_FOR_LIST_TIME_SERIES"
    REQUEST_RATE_FOR_ASSOCIATE_ASSETS = "REQUEST_RATE_FOR_ASSOCIATE_ASSETS"
    NUMBER_OF_DASHBOARDS_PER_PROJECT = "NUMBER_OF_DASHBOARDS_PER_PROJECT"
    NUMBER_OF_ASSET_MODELS_PER_REGION_PER_AWS_ACCOUNT = "NUMBER_OF_ASSET_MODELS_PER_REGION_PER_AWS_ACCOUNT"
    NUMBER_OF_DAYS_BETWEEN_THE_TIMESTAMP_IN_THE_PAST_AND_TODAY = "NUMBER_OF_DAYS_BETWEEN_THE_TIMESTAMP_IN_THE_PAST_AND_TODAY"
    REQUEST_RATE_FOR_GET_ASSET_PROPERTY_VALUE = "REQUEST_RATE_FOR_GET_ASSET_PROPERTY_VALUE"
    REQUEST_RATE_FOR_TAG_RESOURCE = "REQUEST_RATE_FOR_TAG_RESOURCE"
    REQUEST_RATE_FOR_LIST_ASSET_MODEL_COMPOSITE_MODELS = "REQUEST_RATE_FOR_LIST_ASSET_MODEL_COMPOSITE_MODELS"
    REQUEST_RATE_FOR_LIST_COMPOSITION_RELATIONSHIPS = "REQUEST_RATE_FOR_LIST_COMPOSITION_RELATIONSHIPS"
    NUMBER_OF_ASSET_MODELS_PER_HIERARCHY_TREE = "NUMBER_OF_ASSET_MODELS_PER_HIERARCHY_TREE"
    REQUEST_RATE_FOR_PUT_DEFAULT_ENCRYPTION_CONFIGURATION = "REQUEST_RATE_FOR_PUT_DEFAULT_ENCRYPTION_CONFIGURATION"
    NUMBER_OF_GATEWAYS_PER_REGION_PER_AWS_ACCOUNT = "NUMBER_OF_GATEWAYS_PER_REGION_PER_AWS_ACCOUNT"
    NUMBER_OF_OPC_UA_SOURCES_PER_GATEWAY = "NUMBER_OF_OPC_UA_SOURCES_PER_GATEWAY"
    REQUEST_RATE_FOR_LIST_ASSOCIATED_ASSETS = "REQUEST_RATE_FOR_LIST_ASSOCIATED_ASSETS"
    NUMBER_OF_UNIQUE_MEASUREMENTS_PER_PARQUET_ROW_GROUP = "NUMBER_OF_UNIQUE_MEASUREMENTS_PER_PARQUET_ROW_GROUP"
    NUMBER_OF_FUNCTIONS_PER_PROPERTY_FORMULA_EXPRESSION = "NUMBER_OF_FUNCTIONS_PER_PROPERTY_FORMULA_EXPRESSION"
    REQUEST_RATE_FOR_GET_ASSET_PROPERTY_VALUE_HISTORY = "REQUEST_RATE_FOR_GET_ASSET_PROPERTY_VALUE_HISTORY"
    REQUEST_RATE_FOR_LIST_TAGS_FOR_RESOURCE = "REQUEST_RATE_FOR_LIST_TAGS_FOR_RESOURCE"
    REQUEST_RATE_FOR_CREATE_ASSET_MODEL_COMPOSITE_MODEL = "REQUEST_RATE_FOR_CREATE_ASSET_MODEL_COMPOSITE_MODEL"
    REQUEST_RATE_FOR_DESCRIBE_STORAGE_CONFIGURATION = "REQUEST_RATE_FOR_DESCRIBE_STORAGE_CONFIGURATION"
    REQUEST_RATE_FOR_CREATE_ASSET = "REQUEST_RATE_FOR_CREATE_ASSET"
    NUMBER_OF_PROPERTIES_THAT_DEPEND_ON_A_SINGLE_PROPERTY = "NUMBER_OF_PROPERTIES_THAT_DEPEND_ON_A_SINGLE_PROPERTY"
    REQUEST_RATE_FOR_DELETE_ASSET = "REQUEST_RATE_FOR_DELETE_ASSET"
    REQUEST_RATE_FOR_UPDATE_ASSET = "REQUEST_RATE_FOR_UPDATE_ASSET"
    REQUEST_RATE_FOR_PUT_LOGGING_OPTIONS = "REQUEST_RATE_FOR_PUT_LOGGING_OPTIONS"
    NUMBER_OF_PORTALS_PER_REGION_PER_AWS_ACCOUNT = "NUMBER_OF_PORTALS_PER_REGION_PER_AWS_ACCOUNT"
    REQUEST_RATE_FOR_DISASSOCIATE_TIME_SERIES_FROM_ASSET_PROPERTY = "REQUEST_RATE_FOR_DISASSOCIATE_TIME_SERIES_FROM_ASSET_PROPERTY"
    RATE_OF_GET_ASSET_PROPERTY_VALUE_HISTORY_REQUEST_AND_BATCH_GET_ASSET_PROPERTY_VALUE_HISTORY_ENTRY_QUERIES_PER_ASSET_PROPERTY = "RATE_OF_GET_ASSET_PROPERTY_VALUE_HISTORY_REQUEST_AND_BATCH_GET_ASSET_PROPERTY_VALUE_HISTORY_ENTRY_QUERIES_PER_ASSET_PROPERTY"
    RATE_OF_GET_ASSET_PROPERTY_VALUE_REQUEST_AND_BATCH_GET_ASSET_PROPERTY_VALUE_ENTRY_QUERIES_PER_ASSET_PROPERTY = "RATE_OF_GET_ASSET_PROPERTY_VALUE_REQUEST_AND_BATCH_GET_ASSET_PROPERTY_VALUE_ENTRY_QUERIES_PER_ASSET_PROPERTY"
    NUMBER_OF_VISUALIZATIONS_PER_DASHBOARD = "NUMBER_OF_VISUALIZATIONS_PER_DASHBOARD"
    REQUEST_RATE_FOR_DESCRIBE_ASSET_COMPOSITE_MODEL = "REQUEST_RATE_FOR_DESCRIBE_ASSET_COMPOSITE_MODEL"
    REQUEST_RATE_FOR_BATCH_GET_ASSET_PROPERTY_VALUE = "REQUEST_RATE_FOR_BATCH_GET_ASSET_PROPERTY_VALUE"
    REQUEST_RATE_FOR_GET_ASSET_PROPERTY_AGGREGATES = "REQUEST_RATE_FOR_GET_ASSET_PROPERTY_AGGREGATES"
    REQUEST_RATE_FOR_UPDATE_ASSET_PROPERTY = "REQUEST_RATE_FOR_UPDATE_ASSET_PROPERTY"
    REQUEST_RATE_FOR_DESCRIBE_LOGGING_OPTIONS = "REQUEST_RATE_FOR_DESCRIBE_LOGGING_OPTIONS"
    COMPOSITE_MODEL_DEPTH = "COMPOSITE_MODEL_DEPTH"
    REQUEST_RATE_FOR_BATCH_GET_ASSET_PROPERTY_AGGREGATES = "REQUEST_RATE_FOR_BATCH_GET_ASSET_PROPERTY_AGGREGATES"
    NUMBER_OF_PROPERTIES_THAT_DIRECTLY_DEPEND_ON_A_SINGLE_PROPERTY = "NUMBER_OF_PROPERTIES_THAT_DIRECTLY_DEPEND_ON_A_SINGLE_PROPERTY"
    SIZE_OF_THE_CSV_FILE_FOR_ADAPTIVE_INGESTION = "SIZE_OF_THE_CSV_FILE_FOR_ADAPTIVE_INGESTION"
    REQUEST_RATE_FOR_DESCRIBE_ASSET_MODEL_COMPOSITE_MODEL = "REQUEST_RATE_FOR_DESCRIBE_ASSET_MODEL_COMPOSITE_MODEL"
    SIZE_OF_THE_UNCOMPRESSED_PARQUET_ROW_GROUP = "SIZE_OF_THE_UNCOMPRESSED_PARQUET_ROW_GROUP"
    REQUEST_RATE_FOR_UPDATE_ASSET_MODEL = "REQUEST_RATE_FOR_UPDATE_ASSET_MODEL"
    REQUEST_RATE_FOR_DESCRIBE_TIME_SERIES = "REQUEST_RATE_FOR_DESCRIBE_TIME_SERIES"
    NUMBER_OF_ASSETS_PER_ASSET_MODEL = "NUMBER_OF_ASSETS_PER_ASSET_MODEL"
    NUMBER_OF_DATA_POINTS_PER_SECOND_PER_DATA_QUALITY_PER_ASSET_PROPERTY = "NUMBER_OF_DATA_POINTS_PER_SECOND_PER_DATA_QUALITY_PER_ASSET_PROPERTY"
    REQUEST_RATE_FOR_LIST_ASSET_MODELS = "REQUEST_RATE_FOR_LIST_ASSET_MODELS"
    NUMBER_OF_UNIQUE_ASSET_MODELS_THAT_USE_THE_SAME_COMPONENT_MODEL = "NUMBER_OF_UNIQUE_ASSET_MODELS_THAT_USE_THE_SAME_COMPONENT_MODEL"
    REQUEST_RATE_FOR_UNTAG_RESOURCE = "REQUEST_RATE_FOR_UNTAG_RESOURCE"
    SIZE_OF_THE_UNCOMPRESSED_PARQUET_FILE = "SIZE_OF_THE_UNCOMPRESSED_PARQUET_FILE"
    REQUEST_RATE_FOR_DESCRIBE_DEFAULT_ENCRYPTION_CONFIGURATION = "REQUEST_RATE_FOR_DESCRIBE_DEFAULT_ENCRYPTION_CONFIGURATION"
    REQUEST_RATE_FOR_LIST_ASSETS = "REQUEST_RATE_FOR_LIST_ASSETS"
    RATE_OF_BATCH_PUT_ASSET_PROPERTY_VALUE_ENTRIES_INGESTED_PER_ASSET_PROPERTY = "RATE_OF_BATCH_PUT_ASSET_PROPERTY_VALUE_ENTRIES_INGESTED_PER_ASSET_PROPERTY"
    REQUEST_RATE_FOR_ASSOCIATE_TIME_SERIES_TO_ASSET_PROPERTY = "REQUEST_RATE_FOR_ASSOCIATE_TIME_SERIES_TO_ASSET_PROPERTY"
    REQUEST_RATE_FOR_PUT_STORAGE_CONFIGURATION = "REQUEST_RATE_FOR_PUT_STORAGE_CONFIGURATION"
    NUMBER_OF_ROOT_ASSETS_PER_PROJECT = "NUMBER_OF_ROOT_ASSETS_PER_PROJECT"
    REQUEST_RATE_FOR_BATCH_GET_ASSET_PROPERTY_VALUE_HISTORY = "REQUEST_RATE_FOR_BATCH_GET_ASSET_PROPERTY_VALUE_HISTORY"
    REQUEST_RATE_FOR_DELETE_TIME_SERIES = "REQUEST_RATE_FOR_DELETE_TIME_SERIES"
    REQUEST_RATE_FOR_DESCRIBE_ASSET_PROPERTY = "REQUEST_RATE_FOR_DESCRIBE_ASSET_PROPERTY"
    DEPTH_OF_ASSET_MODEL_HIERARCHY_TREE = "DEPTH_OF_ASSET_MODEL_HIERARCHY_TREE"
    RATE_OF_DATA_POINTS_INGESTED = "RATE_OF_DATA_POINTS_INGESTED"
    NUMBER_OF_PARENT_ASSET_MODELS_PER_CHILD_ASSET_MODEL = "NUMBER_OF_PARENT_ASSET_MODELS_PER_CHILD_ASSET_MODEL"
    NUMBER_OF_HIERARCHY_DEFINITIONS_PER_ASSET_MODEL = "NUMBER_OF_HIERARCHY_DEFINITIONS_PER_ASSET_MODEL"
    REQUEST_RATE_FOR_DESCRIBE_ASSET = "REQUEST_RATE_FOR_DESCRIBE_ASSET"
    REQUEST_RATE_FOR_DELETE_ASSET_MODEL = "REQUEST_RATE_FOR_DELETE_ASSET_MODEL"
    REQUEST_RATE_FOR_UPDATE_ASSET_MODEL_COMPOSITE_MODEL = "REQUEST_RATE_FOR_UPDATE_ASSET_MODEL_COMPOSITE_MODEL"
    NUMBER_OF_RESULTS_PER_GET_INTERPOLATED_ASSET_PROPERTY_VALUES_REQUEST = "NUMBER_OF_RESULTS_PER_GET_INTERPOLATED_ASSET_PROPERTY_VALUES_REQUEST"
    REQUEST_RATE_FOR_DESCRIBE_ACTION = "REQUEST_RATE_FOR_DESCRIBE_ACTION"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsIoTThingsGraphQuota")
class AwsIoTThingsGraphQuota(enum.Enum):
    TPS_LIMIT_FOR_GET_SYSTEM_TEMPLATE = "TPS_LIMIT_FOR_GET_SYSTEM_TEMPLATE"
    TPS_LIMIT_FOR_UPDATE_SYSTEM_TEMPLATE = "TPS_LIMIT_FOR_UPDATE_SYSTEM_TEMPLATE"
    TPS_LIMIT_FOR_CREATE_SYSTEM_TEMPLATE = "TPS_LIMIT_FOR_CREATE_SYSTEM_TEMPLATE"
    TPS_LIMIT_FOR_CREATE_FLOW_TEMPLATE = "TPS_LIMIT_FOR_CREATE_FLOW_TEMPLATE"
    TPS_LIMIT_FOR_GET_FLOW_TEMPLATE = "TPS_LIMIT_FOR_GET_FLOW_TEMPLATE"
    TOTAL_FLOW_DEFINITIONS_IN_A_NAMESPACE = "TOTAL_FLOW_DEFINITIONS_IN_A_NAMESPACE"
    TPS_LIMIT_FOR_GET_SYSTEM_TEMPLATE_REVISIONS = "TPS_LIMIT_FOR_GET_SYSTEM_TEMPLATE_REVISIONS"
    TPS_LIMIT_FOR_UPLOAD_ENTITY_DEFINITIONS = "TPS_LIMIT_FOR_UPLOAD_ENTITY_DEFINITIONS"
    MAXIMUM_NUMBER_OF_STEPS_EXECUTED_PER_DEPLOYMENT = "MAXIMUM_NUMBER_OF_STEPS_EXECUTED_PER_DEPLOYMENT"
    TPS_LIMIT_FOR_SEARCH_THINGS = "TPS_LIMIT_FOR_SEARCH_THINGS"
    TPS_LIMIT_FOR_DESCRIBE_NAMESPACE = "TPS_LIMIT_FOR_DESCRIBE_NAMESPACE"
    TPS_LIMIT_FOR_UPDATE_FLOW_TEMPLATE = "TPS_LIMIT_FOR_UPDATE_FLOW_TEMPLATE"
    TPS_LIMIT_FOR_DELETE_NAMESPACE = "TPS_LIMIT_FOR_DELETE_NAMESPACE"
    TOTAL_DEPLOYMENT_CONFIGURATIONS_IN_A_NAMESPACE = "TOTAL_DEPLOYMENT_CONFIGURATIONS_IN_A_NAMESPACE"
    TPS_LIMIT_FOR_GET_RECENT_UPLOADS = "TPS_LIMIT_FOR_GET_RECENT_UPLOADS"
    TPS_LIMIT_FOR_ASSOCIATE_ENTITY_TO_THING = "TPS_LIMIT_FOR_ASSOCIATE_ENTITY_TO_THING"
    TPS_LIMIT_FOR_DEPRECATE_SYSTEM_TEMPLATE = "TPS_LIMIT_FOR_DEPRECATE_SYSTEM_TEMPLATE"
    TPS_LIMIT_FOR_LIST_MAPPING_PATHS = "TPS_LIMIT_FOR_LIST_MAPPING_PATHS"
    TPS_LIMIT_FOR_CREATE_DEPLOYMENT_CONFIGURATION = "TPS_LIMIT_FOR_CREATE_DEPLOYMENT_CONFIGURATION"
    TPS_LIMIT_FOR_GET_SYSTEM_INSTANCE = "TPS_LIMIT_FOR_GET_SYSTEM_INSTANCE"
    TPS_LIMIT_FOR_CREATE_SYSTEM_INSTANCE = "TPS_LIMIT_FOR_CREATE_SYSTEM_INSTANCE"
    TPS_LIMIT_FOR_DEPLOY_SYSTEM_INSTANCE = "TPS_LIMIT_FOR_DEPLOY_SYSTEM_INSTANCE"
    TPS_LIMIT_FOR_DEPLOY_CONFIGURATION_TO_TARGET = "TPS_LIMIT_FOR_DEPLOY_CONFIGURATION_TO_TARGET"
    FLOW_DEFINITION_SIZE = "FLOW_DEFINITION_SIZE"
    TPS_LIMIT_FOR_SEARCH_DEPLOYMENT_CONFIGURATIONS = "TPS_LIMIT_FOR_SEARCH_DEPLOYMENT_CONFIGURATIONS"
    TPS_LIMIT_FOR_VALIDATE_ENTITY_DEFINITIONS = "TPS_LIMIT_FOR_VALIDATE_ENTITY_DEFINITIONS"
    TPS_LIMIT_FOR_DEPRECATE_DEPLOYMENT_CONFIGURATION = "TPS_LIMIT_FOR_DEPRECATE_DEPLOYMENT_CONFIGURATION"
    TPS_LIMIT_FOR_DELETE_FLOW_TEMPLATE = "TPS_LIMIT_FOR_DELETE_FLOW_TEMPLATE"
    TPS_LIMIT_FOR_DEPRECATE_FLOW_TEMPLATE = "TPS_LIMIT_FOR_DEPRECATE_FLOW_TEMPLATE"
    UPLOAD_REQUEST_SIZE = "UPLOAD_REQUEST_SIZE"
    TPS_LIMIT_FOR_SEARCH_ENTITIES = "TPS_LIMIT_FOR_SEARCH_ENTITIES"
    TPS_LIMIT_FOR_GET_UPLOAD_STATUS = "TPS_LIMIT_FOR_GET_UPLOAD_STATUS"
    TPS_LIMIT_FOR_DISSOCIATE_ENTITY_FROM_THING = "TPS_LIMIT_FOR_DISSOCIATE_ENTITY_FROM_THING"
    TPS_LIMIT_FOR_LIST_FLOW_EXECUTION_MESSAGES = "TPS_LIMIT_FOR_LIST_FLOW_EXECUTION_MESSAGES"
    TPS_LIMIT_FOR_GET_NAMESPACE_DELETION_STATUS = "TPS_LIMIT_FOR_GET_NAMESPACE_DELETION_STATUS"
    TPS_LIMIT_FOR_GET_ENTITIES = "TPS_LIMIT_FOR_GET_ENTITIES"
    TOTAL_ENTITIES_IN_A_NAMESPACE = "TOTAL_ENTITIES_IN_A_NAMESPACE"
    TPS_LIMIT_FOR_SEARCH_FLOW_TEMPLATES = "TPS_LIMIT_FOR_SEARCH_FLOW_TEMPLATES"
    TPS_LIMIT_FOR_UNDEPLOY_SYSTEM_INSTANCE = "TPS_LIMIT_FOR_UNDEPLOY_SYSTEM_INSTANCE"
    TPS_LIMIT_FOR_DELETE_SYSTEM_TEMPLATE = "TPS_LIMIT_FOR_DELETE_SYSTEM_TEMPLATE"
    TPS_LIMIT_FOR_SEARCH_SYSTEM_TEMPLATES = "TPS_LIMIT_FOR_SEARCH_SYSTEM_TEMPLATES"
    TPS_LIMIT_FOR_SEARCH_FLOW_EXECUTIONS = "TPS_LIMIT_FOR_SEARCH_FLOW_EXECUTIONS"
    TPS_LIMIT_FOR_DELETE_SYSTEM_INSTANCE = "TPS_LIMIT_FOR_DELETE_SYSTEM_INSTANCE"
    MAXIMUM_NUMBER_OF_FLOWS_TRIGGERED = "MAXIMUM_NUMBER_OF_FLOWS_TRIGGERED"
    TPS_LIMIT_FOR_GET_FLOW_TEMPLATE_REVISIONS = "TPS_LIMIT_FOR_GET_FLOW_TEMPLATE_REVISIONS"
    TPS_LIMIT_FOR_SEARCH_SYSTEM_INSTANCE = "TPS_LIMIT_FOR_SEARCH_SYSTEM_INSTANCE"
    TPS_LIMIT_FOR_GET_DEPLOYMENT_CONFIGURATION = "TPS_LIMIT_FOR_GET_DEPLOYMENT_CONFIGURATION"
    TPS_LIMIT_FOR_DELETE_DEPLOYMENT_CONFIGURATION = "TPS_LIMIT_FOR_DELETE_DEPLOYMENT_CONFIGURATION"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsIoTTwinMakerQuota")
class AwsIoTTwinMakerQuota(enum.Enum):
    TAGS_PER_RESOURCE = "TAGS_PER_RESOURCE"
    WORKSPACES_IN_THIS_ACCOUNT_IN_THE_CURRENT_REGION = "WORKSPACES_IN_THIS_ACCOUNT_IN_THE_CURRENT_REGION"
    COMPONENTS_PER_ENTITY = "COMPONENTS_PER_ENTITY"
    COMPONENT_TYPE_COMPOSITION_TREE_DEPTH = "COMPONENT_TYPE_COMPOSITION_TREE_DEPTH"
    SIZE_OF_THE_METADATA_TRANSFER_JOB_IMPORT_FILE = "SIZE_OF_THE_METADATA_TRANSFER_JOB_IMPORT_FILE"
    ENTITIES_PER_WORKSPACE = "ENTITIES_PER_WORKSPACE"
    PROPERTIES_PER_COMPONENT_TYPE_OR_COMPONENT = "PROPERTIES_PER_COMPONENT_TYPE_OR_COMPONENT"
    SCENES_PER_WORKSPACE = "SCENES_PER_WORKSPACE"
    DEPTH_OF_ENTITY_HIERARCHY = "DEPTH_OF_ENTITY_HIERARCHY"
    DEPTH_OF_COMPONENT_TYPE_HIERARCHY = "DEPTH_OF_COMPONENT_TYPE_HIERARCHY"
    COMPONENT_TYPES_PER_WORKSPACE = "COMPONENT_TYPES_PER_WORKSPACE"
    PARENT_COMPONENT_TYPES_PER_CHILD_COMPONENT_TYPE = "PARENT_COMPONENT_TYPES_PER_CHILD_COMPONENT_TYPE"
    COMPONENT_TYPE_COMPOSITION_TREE_SIZE = "COMPONENT_TYPE_COMPOSITION_TREE_SIZE"
    NUMBER_OF_METADATA_TRANSFER_JOBS_IN_QUEUE = "NUMBER_OF_METADATA_TRANSFER_JOBS_IN_QUEUE"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsIoTWirelessQuota")
class AwsIoTWirelessQuota(enum.Enum):
    TPS_LIMIT_FOR_RESET_RESOURCE_LOG_LEVEL = "TPS_LIMIT_FOR_RESET_RESOURCE_LOG_LEVEL"
    TPS_LIMIT_FOR_ASSOCIATE_WIRELESS_DEVICE_WITH_FUOTA_TASK = "TPS_LIMIT_FOR_ASSOCIATE_WIRELESS_DEVICE_WITH_FUOTA_TASK"
    TPS_LIMIT_FOR_GET_WIRELESS_GATEWAY_TASK_DEFINITION = "TPS_LIMIT_FOR_GET_WIRELESS_GATEWAY_TASK_DEFINITION"
    TPS_LIMIT_FOR_DELETE_WIRELESS_GATEWAY = "TPS_LIMIT_FOR_DELETE_WIRELESS_GATEWAY"
    TPS_LIMIT_FOR_DELETE_NETWORK_ANALYZER_CONFIGURATION = "TPS_LIMIT_FOR_DELETE_NETWORK_ANALYZER_CONFIGURATION"
    TPS_LIMIT_FOR_GET_PARTNER_ACCOUNT = "TPS_LIMIT_FOR_GET_PARTNER_ACCOUNT"
    TPS_LIMIT_FOR_UPDATE_DESTINATION = "TPS_LIMIT_FOR_UPDATE_DESTINATION"
    TPS_LIMIT_FOR_SEND_DATA_TO_MULTICAST_GROUP = "TPS_LIMIT_FOR_SEND_DATA_TO_MULTICAST_GROUP"
    TPS_LIMIT_FOR_CREATE_NETWORK_ANALYZER_CONFIGURATION = "TPS_LIMIT_FOR_CREATE_NETWORK_ANALYZER_CONFIGURATION"
    TPS_LIMIT_FOR_UPDATE_RESOURCE_POSITION = "TPS_LIMIT_FOR_UPDATE_RESOURCE_POSITION"
    TPS_LIMIT_FOR_DELETE_WIRELESS_GATEWAY_TASK_DEFINITION = "TPS_LIMIT_FOR_DELETE_WIRELESS_GATEWAY_TASK_DEFINITION"
    TPS_LIMIT_FOR_GET_POSITION_ESTIMATE = "TPS_LIMIT_FOR_GET_POSITION_ESTIMATE"
    TPS_LIMIT_FOR_LIST_WIRELESS_GATEWAY_TASK_DEFINITIONS = "TPS_LIMIT_FOR_LIST_WIRELESS_GATEWAY_TASK_DEFINITIONS"
    TPS_LIMIT_FOR_DISASSOCIATE_MULTICAST_GROUP_FROM_FUOTA_TASK = "TPS_LIMIT_FOR_DISASSOCIATE_MULTICAST_GROUP_FROM_FUOTA_TASK"
    TPS_LIMIT_FOR_GET_FUOTA_TASK = "TPS_LIMIT_FOR_GET_FUOTA_TASK"
    TPS_LIMIT_FOR_CREATE_DEVICE_PROFILE = "TPS_LIMIT_FOR_CREATE_DEVICE_PROFILE"
    TPS_LIMIT_FOR_LIST_DEVICES_FOR_WIRELESS_DEVICE_IMPORT_TASK = "TPS_LIMIT_FOR_LIST_DEVICES_FOR_WIRELESS_DEVICE_IMPORT_TASK"
    TPS_LIMIT_FOR_GET_WIRELESS_DEVICE = "TPS_LIMIT_FOR_GET_WIRELESS_DEVICE"
    TPS_LIMIT_FOR_CREATE_WIRELESS_DEVICE = "TPS_LIMIT_FOR_CREATE_WIRELESS_DEVICE"
    TPS_LIMIT_FOR_LIST_NETWORK_ANALYZER_CONFIGURATIONS = "TPS_LIMIT_FOR_LIST_NETWORK_ANALYZER_CONFIGURATIONS"
    TPS_LIMIT_FOR_ASSOCIATE_MULTICAST_GROUP_WITH_FUOTA_TASK = "TPS_LIMIT_FOR_ASSOCIATE_MULTICAST_GROUP_WITH_FUOTA_TASK"
    TPS_LIMIT_FOR_UPDATE_WIRELESS_DEVICE = "TPS_LIMIT_FOR_UPDATE_WIRELESS_DEVICE"
    TPS_LIMIT_FOR_DISASSOCIATE_WIRELESS_DEVICE_FROM_MULTICAST_GROUP = "TPS_LIMIT_FOR_DISASSOCIATE_WIRELESS_DEVICE_FROM_MULTICAST_GROUP"
    TPS_LIMIT_FOR_LIST_DEVICE_PROFILES = "TPS_LIMIT_FOR_LIST_DEVICE_PROFILES"
    TPS_LIMIT_FOR_DELETE_SERVICE_PROFILE = "TPS_LIMIT_FOR_DELETE_SERVICE_PROFILE"
    TPS_LIMIT_FOR_LIST_PARTNER_ACCOUNTS = "TPS_LIMIT_FOR_LIST_PARTNER_ACCOUNTS"
    TPS_LIMIT_FOR_LIST_QUEUED_MESSAGES = "TPS_LIMIT_FOR_LIST_QUEUED_MESSAGES"
    TPS_LIMIT_FOR_TAG_RESOURCE = "TPS_LIMIT_FOR_TAG_RESOURCE"
    TPS_LIMIT_FOR_ASSOCIATE_WIRELESS_GATEWAY_WITH_CERTIFICATE = "TPS_LIMIT_FOR_ASSOCIATE_WIRELESS_GATEWAY_WITH_CERTIFICATE"
    TPS_LIMIT_FOR_GET_SERVICE_ENDPOINT = "TPS_LIMIT_FOR_GET_SERVICE_ENDPOINT"
    TPS_LIMIT_FOR_ASSOCIATE_WIRELESS_DEVICE_WITH_MULTICAST_GROUP = "TPS_LIMIT_FOR_ASSOCIATE_WIRELESS_DEVICE_WITH_MULTICAST_GROUP"
    TPS_LIMIT_FOR_CANCEL_MULTICAST_GROUP_SESSION = "TPS_LIMIT_FOR_CANCEL_MULTICAST_GROUP_SESSION"
    TPS_LIMIT_FOR_CREATE_WIRELESS_GATEWAY_TASK = "TPS_LIMIT_FOR_CREATE_WIRELESS_GATEWAY_TASK"
    TPS_LIMIT_FOR_LIST_DESTINATIONS = "TPS_LIMIT_FOR_LIST_DESTINATIONS"
    TPS_LIMIT_FOR_DEREGISTER_WIRELESS_DEVICE = "TPS_LIMIT_FOR_DEREGISTER_WIRELESS_DEVICE"
    TPS_LIMIT_FOR_START_WIRELESS_DEVICE_IMPORT_TASK = "TPS_LIMIT_FOR_START_WIRELESS_DEVICE_IMPORT_TASK"
    TPS_LIMIT_FOR_GET_WIRELESS_DEVICE_STATISTICS = "TPS_LIMIT_FOR_GET_WIRELESS_DEVICE_STATISTICS"
    TPS_LIMIT_FOR_GET_SERVICE_PROFILE = "TPS_LIMIT_FOR_GET_SERVICE_PROFILE"
    TPS_LIMIT_FOR_LIST_EVENT_CONFIGURATIONS = "TPS_LIMIT_FOR_LIST_EVENT_CONFIGURATIONS"
    TPS_LIMIT_FOR_RESET_ALL_RESOURCE_LOG_LEVELS = "TPS_LIMIT_FOR_RESET_ALL_RESOURCE_LOG_LEVELS"
    TPS_LIMIT_FOR_CREATE_WIRELESS_GATEWAY_TASK_DEFINITION = "TPS_LIMIT_FOR_CREATE_WIRELESS_GATEWAY_TASK_DEFINITION"
    TPS_LIMIT_FOR_GET_NETWORK_ANALYZER_CONFIGURATION = "TPS_LIMIT_FOR_GET_NETWORK_ANALYZER_CONFIGURATION"
    TPS_LIMIT_FOR_DISASSOCIATE_WIRELESS_GATEWAY_FROM_THING = "TPS_LIMIT_FOR_DISASSOCIATE_WIRELESS_GATEWAY_FROM_THING"
    TPS_LIMIT_FOR_DISASSOCIATE_AWS_ACCOUNT_FROM_PARTNER_ACCOUNT = "TPS_LIMIT_FOR_DISASSOCIATE_AWS_ACCOUNT_FROM_PARTNER_ACCOUNT"
    TPS_LIMIT_FOR_DELETE_WIRELESS_DEVICE_IMPORT_TASK = "TPS_LIMIT_FOR_DELETE_WIRELESS_DEVICE_IMPORT_TASK"
    TPS_LIMIT_FOR_GET_RESOURCE_EVENT_CONFIGURATION = "TPS_LIMIT_FOR_GET_RESOURCE_EVENT_CONFIGURATION"
    TPS_LIMIT_FOR_PUT_RESOURCE_LOG_LEVEL = "TPS_LIMIT_FOR_PUT_RESOURCE_LOG_LEVEL"
    TPS_LIMIT_FOR_TEST_WIRELESS_DEVICE = "TPS_LIMIT_FOR_TEST_WIRELESS_DEVICE"
    TPS_LIMIT_FOR_GET_DESTINATION = "TPS_LIMIT_FOR_GET_DESTINATION"
    TPS_LIMIT_FOR_LIST_MULTICAST_GROUPS = "TPS_LIMIT_FOR_LIST_MULTICAST_GROUPS"
    TPS_LIMIT_FOR_LIST_WIRELESS_DEVICE_IMPORT_TASKS = "TPS_LIMIT_FOR_LIST_WIRELESS_DEVICE_IMPORT_TASKS"
    TPS_LIMIT_FOR_GET_RESOURCE_POSITION = "TPS_LIMIT_FOR_GET_RESOURCE_POSITION"
    TPS_LIMIT_FOR_UPDATE_MULTICAST_GROUP = "TPS_LIMIT_FOR_UPDATE_MULTICAST_GROUP"
    TPS_LIMIT_FOR_UPDATE_FUOTA_TASK = "TPS_LIMIT_FOR_UPDATE_FUOTA_TASK"
    TPS_LIMIT_FOR_DISASSOCIATE_WIRELESS_DEVICE_FROM_FUOTA_TASK = "TPS_LIMIT_FOR_DISASSOCIATE_WIRELESS_DEVICE_FROM_FUOTA_TASK"
    TPS_LIMIT_FOR_CREATE_MULTICAST_GROUP = "TPS_LIMIT_FOR_CREATE_MULTICAST_GROUP"
    TPS_LIMIT_FOR_UPDATE_EVENT_CONFIGURATION_BY_RESOURCE_TYPES = "TPS_LIMIT_FOR_UPDATE_EVENT_CONFIGURATION_BY_RESOURCE_TYPES"
    TPS_LIMIT_FOR_DISASSOCIATE_WIRELESS_DEVICE_FROM_THING = "TPS_LIMIT_FOR_DISASSOCIATE_WIRELESS_DEVICE_FROM_THING"
    TPS_LIMIT_FOR_START_MULTICAST_GROUP_SESSION = "TPS_LIMIT_FOR_START_MULTICAST_GROUP_SESSION"
    TPS_LIMIT_FOR_ASSOCIATE_AWS_ACCOUNT_WITH_PARTNER_ACCOUNT = "TPS_LIMIT_FOR_ASSOCIATE_AWS_ACCOUNT_WITH_PARTNER_ACCOUNT"
    TPS_LIMIT_FOR_UPDATE_RESOURCE_EVENT_CONFIGURATION = "TPS_LIMIT_FOR_UPDATE_RESOURCE_EVENT_CONFIGURATION"
    TPS_LIMIT_FOR_DISASSOCIATE_WIRELESS_GATEWAY_FROM_CERTIFICATE = "TPS_LIMIT_FOR_DISASSOCIATE_WIRELESS_GATEWAY_FROM_CERTIFICATE"
    TPS_LIMIT_FOR_CREATE_WIRELESS_GATEWAY = "TPS_LIMIT_FOR_CREATE_WIRELESS_GATEWAY"
    TPS_LIMIT_FOR_DELETE_DEVICE_PROFILE = "TPS_LIMIT_FOR_DELETE_DEVICE_PROFILE"
    TPS_LIMIT_FOR_GET_EVENT_CONFIGURATION_BY_RESOURCE_TYPES = "TPS_LIMIT_FOR_GET_EVENT_CONFIGURATION_BY_RESOURCE_TYPES"
    TPS_LIMIT_FOR_LIST_WIRELESS_DEVICES = "TPS_LIMIT_FOR_LIST_WIRELESS_DEVICES"
    TPS_LIMIT_FOR_LIST_MULTICAST_GROUPS_BY_FUOTA_TASK = "TPS_LIMIT_FOR_LIST_MULTICAST_GROUPS_BY_FUOTA_TASK"
    TPS_LIMIT_FOR_GET_RESOURCE_LOG_LEVEL = "TPS_LIMIT_FOR_GET_RESOURCE_LOG_LEVEL"
    TPS_LIMIT_FOR_SEND_DATA_TO_WIRELESS_DEVICE = "TPS_LIMIT_FOR_SEND_DATA_TO_WIRELESS_DEVICE"
    TPS_LIMIT_FOR_LIST_WIRELESS_GATEWAYS = "TPS_LIMIT_FOR_LIST_WIRELESS_GATEWAYS"
    TPS_LIMIT_FOR_START_SINGLE_WIRELESS_DEVICE_IMPORT_TASK = "TPS_LIMIT_FOR_START_SINGLE_WIRELESS_DEVICE_IMPORT_TASK"
    TPS_LIMIT_FOR_GET_MULTICAST_GROUP = "TPS_LIMIT_FOR_GET_MULTICAST_GROUP"
    TPS_LIMIT_FOR_GET_WIRELESS_GATEWAY_STATISTICS = "TPS_LIMIT_FOR_GET_WIRELESS_GATEWAY_STATISTICS"
    TPS_LIMIT_FOR_LIST_POSITION_CONFIGURATIONS = "TPS_LIMIT_FOR_LIST_POSITION_CONFIGURATIONS"
    TPS_LIMIT_FOR_START_BULK_DISASSOCIATE_WIRELESS_DEVICE_FROM_MULTICAST_GROUP = "TPS_LIMIT_FOR_START_BULK_DISASSOCIATE_WIRELESS_DEVICE_FROM_MULTICAST_GROUP"
    TPS_LIMIT_FOR_PUT_POSITION_CONFIGURATION = "TPS_LIMIT_FOR_PUT_POSITION_CONFIGURATION"
    TPS_LIMIT_FOR_GET_DEVICE_PROFILE = "TPS_LIMIT_FOR_GET_DEVICE_PROFILE"
    TPS_LIMIT_FOR_UNTAG_RESOURCE = "TPS_LIMIT_FOR_UNTAG_RESOURCE"
    TPS_LIMIT_FOR_DELETE_QUEUED_MESSAGES = "TPS_LIMIT_FOR_DELETE_QUEUED_MESSAGES"
    TPS_LIMIT_FOR_GET_MULTICAST_GROUP_SESSION = "TPS_LIMIT_FOR_GET_MULTICAST_GROUP_SESSION"
    TPS_LIMIT_FOR_START_NETWORK_ANALYZER_STREAM = "TPS_LIMIT_FOR_START_NETWORK_ANALYZER_STREAM"
    TPS_LIMIT_FOR_UPDATE_PARTNER_ACCOUNT = "TPS_LIMIT_FOR_UPDATE_PARTNER_ACCOUNT"
    TPS_LIMIT_FOR_ASSOCIATE_WIRELESS_GATEWAY_WITH_THING = "TPS_LIMIT_FOR_ASSOCIATE_WIRELESS_GATEWAY_WITH_THING"
    TPS_LIMIT_FOR_CREATE_FUOTA_TASK = "TPS_LIMIT_FOR_CREATE_FUOTA_TASK"
    TPS_LIMIT_FOR_GET_POSITION = "TPS_LIMIT_FOR_GET_POSITION"
    TPS_LIMIT_FOR_GET_WIRELESS_DEVICE_IMPORT_TASK = "TPS_LIMIT_FOR_GET_WIRELESS_DEVICE_IMPORT_TASK"
    TPS_LIMIT_FOR_UPDATE_WIRELESS_DEVICE_IMPORT_TASK = "TPS_LIMIT_FOR_UPDATE_WIRELESS_DEVICE_IMPORT_TASK"
    TPS_LIMIT_FOR_CREATE_DESTINATION = "TPS_LIMIT_FOR_CREATE_DESTINATION"
    TPS_LIMIT_FOR_DELETE_WIRELESS_GATEWAY_TASK = "TPS_LIMIT_FOR_DELETE_WIRELESS_GATEWAY_TASK"
    TPS_LIMIT_FOR_DELETE_FUOTA_TASK = "TPS_LIMIT_FOR_DELETE_FUOTA_TASK"
    TPS_LIMIT_FOR_LIST_SERVICE_PROFILES = "TPS_LIMIT_FOR_LIST_SERVICE_PROFILES"
    TPS_LIMIT_FOR_UPDATE_NETWORK_ANALYZER_CONFIGURATION = "TPS_LIMIT_FOR_UPDATE_NETWORK_ANALYZER_CONFIGURATION"
    TPS_LIMIT_FOR_START_FUOTA_TASK = "TPS_LIMIT_FOR_START_FUOTA_TASK"
    TPS_LIMIT_FOR_CREATE_SERVICE_PROFILE = "TPS_LIMIT_FOR_CREATE_SERVICE_PROFILE"
    TPS_LIMIT_FOR_UPDATE_LOG_LEVELS_BY_RESOURCE_TYPES = "TPS_LIMIT_FOR_UPDATE_LOG_LEVELS_BY_RESOURCE_TYPES"
    TPS_LIMIT_FOR_UPDATE_POSITION = "TPS_LIMIT_FOR_UPDATE_POSITION"
    TPS_LIMIT_FOR_DELETE_MULTICAST_GROUP = "TPS_LIMIT_FOR_DELETE_MULTICAST_GROUP"
    TPS_LIMIT_FOR_UPDATE_WIRELESS_GATEWAY = "TPS_LIMIT_FOR_UPDATE_WIRELESS_GATEWAY"
    TPS_LIMIT_FOR_DELETE_WIRELESS_DEVICE = "TPS_LIMIT_FOR_DELETE_WIRELESS_DEVICE"
    TPS_LIMIT_FOR_LIST_TAGS_FOR_RESOURCE = "TPS_LIMIT_FOR_LIST_TAGS_FOR_RESOURCE"
    TPS_LIMIT_FOR_ASSOCIATE_WIRELESS_DEVICE_WITH_THING = "TPS_LIMIT_FOR_ASSOCIATE_WIRELESS_DEVICE_WITH_THING"
    TPS_LIMIT_FOR_GET_POSITION_CONFIGURATION = "TPS_LIMIT_FOR_GET_POSITION_CONFIGURATION"
    TPS_LIMIT_FOR_GET_WIRELESS_GATEWAY_TASK = "TPS_LIMIT_FOR_GET_WIRELESS_GATEWAY_TASK"
    TPS_LIMIT_FOR_GET_WIRELESS_GATEWAY_FIRMWARE_INFORMATION = "TPS_LIMIT_FOR_GET_WIRELESS_GATEWAY_FIRMWARE_INFORMATION"
    TPS_LIMIT_FOR_START_BULK_ASSOCIATE_WIRELESS_DEVICE_WITH_MULTICAST_GROUP = "TPS_LIMIT_FOR_START_BULK_ASSOCIATE_WIRELESS_DEVICE_WITH_MULTICAST_GROUP"
    TPS_LIMIT_FOR_GET_LOG_LEVELS_BY_RESOURCE_TYPES = "TPS_LIMIT_FOR_GET_LOG_LEVELS_BY_RESOURCE_TYPES"
    TPS_LIMIT_FOR_LIST_FUOTA_TASKS = "TPS_LIMIT_FOR_LIST_FUOTA_TASKS"
    TPS_LIMIT_FOR_GET_WIRELESS_GATEWAY = "TPS_LIMIT_FOR_GET_WIRELESS_GATEWAY"
    TPS_LIMIT_FOR_GET_WIRELESS_GATEWAY_CERTIFICATE = "TPS_LIMIT_FOR_GET_WIRELESS_GATEWAY_CERTIFICATE"
    TPS_LIMIT_FOR_DELETE_DESTINATION = "TPS_LIMIT_FOR_DELETE_DESTINATION"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsKeyManagementServiceAwsKmsQuota")
class AwsKeyManagementServiceAwsKmsQuota(enum.Enum):
    GENERATE_DATA_KEY_PAIR_ECC_NIST_P256_REQUEST_RATE = "GENERATE_DATA_KEY_PAIR_ECC_NIST_P256_REQUEST_RATE"
    SCHEDULE_KEY_DELETION_REQUEST_RATE = "SCHEDULE_KEY_DELETION_REQUEST_RATE"
    UPDATE_CUSTOM_KEY_STORE_REQUEST_RATE = "UPDATE_CUSTOM_KEY_STORE_REQUEST_RATE"
    LIST_GRANTS_REQUEST_RATE = "LIST_GRANTS_REQUEST_RATE"
    DELETE_ALIAS_REQUEST_RATE = "DELETE_ALIAS_REQUEST_RATE"
    CONNECT_CUSTOM_KEY_STORE_REQUEST_RATE = "CONNECT_CUSTOM_KEY_STORE_REQUEST_RATE"
    GRANTS_PER_CMK = "GRANTS_PER_CMK"
    REVOKE_GRANT_REQUEST_RATE = "REVOKE_GRANT_REQUEST_RATE"
    GENERATE_DATA_KEY_PAIR_ECC_NIST_P384_REQUEST_RATE = "GENERATE_DATA_KEY_PAIR_ECC_NIST_P384_REQUEST_RATE"
    KEY_POLICY_DOCUMENT_SIZE = "KEY_POLICY_DOCUMENT_SIZE"
    CREATE_GRANT_REQUEST_RATE = "CREATE_GRANT_REQUEST_RATE"
    GET_PARAMETERS_FOR_IMPORT_REQUEST_RATE = "GET_PARAMETERS_FOR_IMPORT_REQUEST_RATE"
    GENERATE_DATA_KEY_PAIR_RSA_2048_REQUEST_RATE = "GENERATE_DATA_KEY_PAIR_RSA_2048_REQUEST_RATE"
    GET_KEY_ROTATION_STATUS_REQUEST_RATE = "GET_KEY_ROTATION_STATUS_REQUEST_RATE"
    TAG_RESOURCE_REQUEST_RATE = "TAG_RESOURCE_REQUEST_RATE"
    GENERATE_DATA_KEY_PAIR_RSA_4096_REQUEST_RATE = "GENERATE_DATA_KEY_PAIR_RSA_4096_REQUEST_RATE"
    ENABLE_KEY_ROTATION_REQUEST_RATE = "ENABLE_KEY_ROTATION_REQUEST_RATE"
    CREATE_CUSTOM_KEY_STORE_REQUEST_RATE = "CREATE_CUSTOM_KEY_STORE_REQUEST_RATE"
    CANCEL_KEY_DELETION_REQUEST_RATE = "CANCEL_KEY_DELETION_REQUEST_RATE"
    GET_PUBLIC_KEY_REQUEST_RATE = "GET_PUBLIC_KEY_REQUEST_RATE"
    ALIASES_PER_CMK = "ALIASES_PER_CMK"
    DELETE_IMPORTED_KEY_MATERIAL_REQUEST_RATE = "DELETE_IMPORTED_KEY_MATERIAL_REQUEST_RATE"
    GENERATE_DATA_KEY_PAIR_RSA_3072_REQUEST_RATE = "GENERATE_DATA_KEY_PAIR_RSA_3072_REQUEST_RATE"
    CRYPTOGRAPHIC_OPERATIONS_SYMMETRIC_REQUEST_RATE = "CRYPTOGRAPHIC_OPERATIONS_SYMMETRIC_REQUEST_RATE"
    UPDATE_ALIAS_REQUEST_RATE = "UPDATE_ALIAS_REQUEST_RATE"
    UNTAG_RESOURCE_REQUEST_RATE = "UNTAG_RESOURCE_REQUEST_RATE"
    PUT_KEY_POLICY_REQUEST_RATE = "PUT_KEY_POLICY_REQUEST_RATE"
    UPDATE_PRIMARY_REGION_REQUEST_RATE = "UPDATE_PRIMARY_REGION_REQUEST_RATE"
    DESCRIBE_KEY_REQUEST_RATE = "DESCRIBE_KEY_REQUEST_RATE"
    CREATE_KEY_REQUEST_RATE = "CREATE_KEY_REQUEST_RATE"
    DISCONNECT_CUSTOM_KEY_STORE_REQUEST_RATE = "DISCONNECT_CUSTOM_KEY_STORE_REQUEST_RATE"
    DELETE_CUSTOM_KEY_STORE_REQUEST_RATE = "DELETE_CUSTOM_KEY_STORE_REQUEST_RATE"
    DESCRIBE_CUSTOM_KEY_STORES_REQUEST_RATE = "DESCRIBE_CUSTOM_KEY_STORES_REQUEST_RATE"
    ENABLE_KEY_REQUEST_RATE = "ENABLE_KEY_REQUEST_RATE"
    LIST_KEYS_REQUEST_RATE = "LIST_KEYS_REQUEST_RATE"
    REPLICATE_KEY_REQUEST_RATE = "REPLICATE_KEY_REQUEST_RATE"
    LIST_ALIASES_REQUEST_RATE = "LIST_ALIASES_REQUEST_RATE"
    UPDATE_KEY_DESCRIPTION_REQUEST_RATE = "UPDATE_KEY_DESCRIPTION_REQUEST_RATE"
    CRYPTOGRAPHIC_OPERATIONS_RSA_REQUEST_RATE = "CRYPTOGRAPHIC_OPERATIONS_RSA_REQUEST_RATE"
    LIST_RESOURCE_TAGS_REQUEST_RATE = "LIST_RESOURCE_TAGS_REQUEST_RATE"
    CUSTOM_KEY_STORES = "CUSTOM_KEY_STORES"
    GENERATE_DATA_KEY_PAIR_ECC_SECG_P256_K1_REQUEST_RATE = "GENERATE_DATA_KEY_PAIR_ECC_SECG_P256_K1_REQUEST_RATE"
    CREATE_ALIAS_REQUEST_RATE = "CREATE_ALIAS_REQUEST_RATE"
    GENERATE_DATA_KEY_PAIR_ECC_NIST_P521_REQUEST_RATE = "GENERATE_DATA_KEY_PAIR_ECC_NIST_P521_REQUEST_RATE"
    LIST_RETIRABLE_GRANTS_REQUEST_RATE = "LIST_RETIRABLE_GRANTS_REQUEST_RATE"
    LIST_KEY_POLICIES_REQUEST_RATE = "LIST_KEY_POLICIES_REQUEST_RATE"
    CRYPTOGRAPHIC_OPERATIONS_ECC_REQUEST_RATE = "CRYPTOGRAPHIC_OPERATIONS_ECC_REQUEST_RATE"
    DISABLE_KEY_REQUEST_RATE = "DISABLE_KEY_REQUEST_RATE"
    IMPORT_KEY_MATERIAL_REQUEST_RATE = "IMPORT_KEY_MATERIAL_REQUEST_RATE"
    CUSTOMER_MASTER_KEYS_CM_KS = "CUSTOMER_MASTER_KEYS_CM_KS"
    GET_KEY_POLICY_REQUEST_RATE = "GET_KEY_POLICY_REQUEST_RATE"
    RETIRE_GRANT_REQUEST_RATE = "RETIRE_GRANT_REQUEST_RATE"
    DISABLE_KEY_ROTATION_REQUEST_RATE = "DISABLE_KEY_ROTATION_REQUEST_RATE"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsLakeFormationQuota")
class AwsLakeFormationQuota(enum.Enum):
    LENGTH_OF_A_PATH_THAT_CAN_BE_REGISTERED = "LENGTH_OF_A_PATH_THAT_CAN_BE_REGISTERED"
    NUMBER_OF_DATA_LAKE_ADMINISTRATORS = "NUMBER_OF_DATA_LAKE_ADMINISTRATORS"
    NUMBER_OF_LF_TAG_POLICY_PER_PRINCIPAL_PER_RESOURCE_TYPE = "NUMBER_OF_LF_TAG_POLICY_PER_PRINCIPAL_PER_RESOURCE_TYPE"
    NUMBER_OF_REGISTERED_PATHS = "NUMBER_OF_REGISTERED_PATHS"
    NUMBER_OF_SUBFOLDERS_IN_AN_AMAZON_S3_PATH = "NUMBER_OF_SUBFOLDERS_IN_AN_AMAZON_S3_PATH"
    NUMBER_OF_TAG_VALUES_PER_LF_TAG = "NUMBER_OF_TAG_VALUES_PER_LF_TAG"
    NUMBER_OF_LF_TAG_PER_ACCOUNT = "NUMBER_OF_LF_TAG_PER_ACCOUNT"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsLambdaQuota")
class AwsLambdaQuota(enum.Enum):
    FUNCTION_AND_LAYER_STORAGE = "FUNCTION_AND_LAYER_STORAGE"
    CONCURRENT_EXECUTIONS = "CONCURRENT_EXECUTIONS"
    FUNCTION_TIMEOUT = "FUNCTION_TIMEOUT"
    SYNCHRONOUS_PAYLOAD = "SYNCHRONOUS_PAYLOAD"
    RATE_OF_CONTROL_PLANE_API_REQUESTS_EXCLUDES_INVOCATION_GET_FUNCTION_AND_GET_POLICY_REQUESTS = "RATE_OF_CONTROL_PLANE_API_REQUESTS_EXCLUDES_INVOCATION_GET_FUNCTION_AND_GET_POLICY_REQUESTS"
    DEPLOYMENT_PACKAGE_SIZE_UNZIPPED = "DEPLOYMENT_PACKAGE_SIZE_UNZIPPED"
    DEPLOYMENT_PACKAGE_SIZE_DIRECT_UPLOAD = "DEPLOYMENT_PACKAGE_SIZE_DIRECT_UPLOAD"
    ENVIRONMENT_VARIABLE_SIZE = "ENVIRONMENT_VARIABLE_SIZE"
    RATE_OF_GET_FUNCTION_API_REQUESTS = "RATE_OF_GET_FUNCTION_API_REQUESTS"
    TEMPORARY_STORAGE = "TEMPORARY_STORAGE"
    BURST_CONCURRENCY = "BURST_CONCURRENCY"
    PROCESSES_AND_THREADS = "PROCESSES_AND_THREADS"
    ELASTIC_NETWORK_INTERFACES_PER_VPC = "ELASTIC_NETWORK_INTERFACES_PER_VPC"
    FILE_DESCRIPTORS = "FILE_DESCRIPTORS"
    RATE_OF_GET_POLICY_API_REQUESTS = "RATE_OF_GET_POLICY_API_REQUESTS"
    FUNCTION_LAYERS = "FUNCTION_LAYERS"
    ASYNCHRONOUS_PAYLOAD = "ASYNCHRONOUS_PAYLOAD"
    FUNCTION_RESOURCE_BASED_POLICY = "FUNCTION_RESOURCE_BASED_POLICY"
    DEPLOYMENT_PACKAGE_SIZE_CONSOLE_EDITOR = "DEPLOYMENT_PACKAGE_SIZE_CONSOLE_EDITOR"
    TEST_EVENTS_CONSOLE_EDITOR = "TEST_EVENTS_CONSOLE_EDITOR"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsLaunchWizardQuota")
class AwsLaunchWizardQuota(enum.Enum):
    APPLICATION_NAME_LENGTH = "APPLICATION_NAME_LENGTH"
    APPLICATIONS = "APPLICATIONS"
    ACTIVE_APPLICATIONS = "ACTIVE_APPLICATIONS"
    PARALLEL_DEPLOYMENTS = "PARALLEL_DEPLOYMENTS"


@jsii.enum(
    jsii_type="@reapit-cdk/service-quotas.AwsLicenseManagerLinuxSubscriptionsQuota"
)
class AwsLicenseManagerLinuxSubscriptionsQuota(enum.Enum):
    NUMBER_OF_DISCOVERED_RESOURCES = "NUMBER_OF_DISCOVERED_RESOURCES"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsLicenseManagerQuota")
class AwsLicenseManagerQuota(enum.Enum):
    LICENSE_CONFIGURATIONS = "LICENSE_CONFIGURATIONS"
    LICENSE_CONFIGURATION_ASSOCIATIONS_PER_RESOURCE = "LICENSE_CONFIGURATION_ASSOCIATIONS_PER_RESOURCE"
    GET_ACCESS_TOKENS_CALLS = "GET_ACCESS_TOKENS_CALLS"
    NUMBER_OF_UPDATES_FOR_A_REPORT_GENERATOR_PER_DAY = "NUMBER_OF_UPDATES_FOR_A_REPORT_GENERATOR_PER_DAY"
    NUMBER_OF_ACCOUNTS_PER_ORGANIZATION_FOR_LICENSE_MANAGER = "NUMBER_OF_ACCOUNTS_PER_ORGANIZATION_FOR_LICENSE_MANAGER"
    NUMBER_OF_LICENSES_YOU_CAN_CREATE = "NUMBER_OF_LICENSES_YOU_CAN_CREATE"
    NUMBER_OF_ACCOUNT_DISCOVERY_MODE_UPDATES_PER_DAY = "NUMBER_OF_ACCOUNT_DISCOVERY_MODE_UPDATES_PER_DAY"
    TOTAL_NUMBER_COUNTED_ENTITLEMENTS_PER_CHECKOUT = "TOTAL_NUMBER_COUNTED_ENTITLEMENTS_PER_CHECKOUT"
    NUMBER_OF_REPORT_GENERATORS = "NUMBER_OF_REPORT_GENERATORS"
    NUMBER_OF_RECEIVED_LICENSES_PER_PRODUCT = "NUMBER_OF_RECEIVED_LICENSES_PER_PRODUCT"
    TOTAL_NUMBER_UNCOUNTED_ENTITLEMENTS_PER_LICENSE = "TOTAL_NUMBER_UNCOUNTED_ENTITLEMENTS_PER_LICENSE"
    TOTAL_NUMBER_COUNTED_ENTITLEMENTS_PER_LICENSE = "TOTAL_NUMBER_COUNTED_ENTITLEMENTS_PER_LICENSE"
    LICENSE_CONVERSION_TASKS_PER_RESOURCE_PER_DAY = "LICENSE_CONVERSION_TASKS_PER_RESOURCE_PER_DAY"
    NUMBER_OF_TOKENS_PER_ACCOUNT_AND_LICENSE = "NUMBER_OF_TOKENS_PER_ACCOUNT_AND_LICENSE"
    MAXIMUM_NUMBER_OF_CONCURRENT_ORGANIZATION_GRANT_ACTIVITIES = "MAXIMUM_NUMBER_OF_CONCURRENT_ORGANIZATION_GRANT_ACTIVITIES"
    EXTEND_LICENSE_CONSUMPTION_PER_CONSUMPTION_TOKEN = "EXTEND_LICENSE_CONSUMPTION_PER_CONSUMPTION_TOKEN"
    NUMBER_OF_GRANTS_PER_LICENSE = "NUMBER_OF_GRANTS_PER_LICENSE"


@jsii.enum(
    jsii_type="@reapit-cdk/service-quotas.AwsLicenseManagerUserSubscriptionsQuota"
)
class AwsLicenseManagerUserSubscriptionsQuota(enum.Enum):
    USER_BASED_SUBSCRIPTIONS_FOR_VISUAL_STUDIO_ENTERPRISE = "USER_BASED_SUBSCRIPTIONS_FOR_VISUAL_STUDIO_ENTERPRISE"
    INSTANCE_ASSOCIATIONS_PER_USER = "INSTANCE_ASSOCIATIONS_PER_USER"
    USER_BASED_SUBSCRIPTIONS_FOR_VISUAL_STUDIO_PROFESSIONAL = "USER_BASED_SUBSCRIPTIONS_FOR_VISUAL_STUDIO_PROFESSIONAL"
    USER_BASED_SUBSCRIPTIONS_FOR_OFFICE_PROFESSIONAL_PLUS = "USER_BASED_SUBSCRIPTIONS_FOR_OFFICE_PROFESSIONAL_PLUS"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsMainframeModernizationQuota")
class AwsMainframeModernizationQuota(enum.Enum):
    MAX_APPLICATIONS_PER_AWS_ACCOUNT = "MAX_APPLICATIONS_PER_AWS_ACCOUNT"
    MAX_ENVIRONMENTS_PER_AWS_ACCOUNT = "MAX_ENVIRONMENTS_PER_AWS_ACCOUNT"
    MAX_DATA_TRANSFER_ENDPOINTS_PER_AWS_ACCOUNT = "MAX_DATA_TRANSFER_ENDPOINTS_PER_AWS_ACCOUNT"
    MAX_NUMBER_OF_FSX_FILESYSTEMS_PER_ENVIRONMENT = "MAX_NUMBER_OF_FSX_FILESYSTEMS_PER_ENVIRONMENT"
    MAX_NUMBER_OF_EFS_FILESYSTEMS_PER_ENVIRONMENT = "MAX_NUMBER_OF_EFS_FILESYSTEMS_PER_ENVIRONMENT"
    MAX_INSTANCES_PER_HIGH_AVAILABILITY_ENVIRONMENT = "MAX_INSTANCES_PER_HIGH_AVAILABILITY_ENVIRONMENT"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsMarketplaceDeploymentServiceQuota")
class AwsMarketplaceDeploymentServiceQuota(enum.Enum):
    UNTAG_RESOURCE_THROTTLE_QUOTA = "UNTAG_RESOURCE_THROTTLE_QUOTA"
    AWS_SECRETS_MANAGER_UPDATE_QUOTA = "AWS_SECRETS_MANAGER_UPDATE_QUOTA"
    LIST_TAGS_FOR_RESOURCE_THROTTLE_QUOTA = "LIST_TAGS_FOR_RESOURCE_THROTTLE_QUOTA"
    DEPLOYMENT_PARAMETER_QUOTA = "DEPLOYMENT_PARAMETER_QUOTA"
    PUT_DEPLOYMENT_PARAMETER_THROTTLE_QUOTA = "PUT_DEPLOYMENT_PARAMETER_THROTTLE_QUOTA"
    SECRET_STRING_NAME_LENGTH = "SECRET_STRING_NAME_LENGTH"
    DEPLOYMENT_PARAMETER_NAME_LENGTH = "DEPLOYMENT_PARAMETER_NAME_LENGTH"
    CLIENT_TOKEN_QUOTA = "CLIENT_TOKEN_QUOTA"
    TAG_LIST_QUOTA = "TAG_LIST_QUOTA"
    TAG_RESOURCE_THROTTLE_QUOTA = "TAG_RESOURCE_THROTTLE_QUOTA"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsMarketplaceVendorInsightsQuota")
class AwsMarketplaceVendorInsightsQuota(enum.Enum):
    SECURITY_PROFILES_PER_ACCOUNT = "SECURITY_PROFILES_PER_ACCOUNT"
    DATA_SOURCES_PER_SECURITY_PROFILE = "DATA_SOURCES_PER_SECURITY_PROFILE"
    RATE_OF_API_REQUESTS = "RATE_OF_API_REQUESTS"
    DAILY_SNAPSHOTS_PER_SECURITY_PROFILE = "DAILY_SNAPSHOTS_PER_SECURITY_PROFILE"
    DATA_SOURCES_PER_ACCOUNT = "DATA_SOURCES_PER_ACCOUNT"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsMigrationHubRefactorSpacesQuota")
class AwsMigrationHubRefactorSpacesQuota(enum.Enum):
    APPLICATIONS = "APPLICATIONS"
    SERVICES = "SERVICES"
    ENVIRONMENTS = "ENVIRONMENTS"
    ROUTES = "ROUTES"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsNetworkFirewallQuota")
class AwsNetworkFirewallQuota(enum.Enum):
    STATEFUL_RULEGROUPS = "STATEFUL_RULEGROUPS"
    STATELESS_RULEGROUPS = "STATELESS_RULEGROUPS"
    FIREWALL_POLICIES = "FIREWALL_POLICIES"
    FIREWALLS = "FIREWALLS"
    TLS_CONFIGURATIONS = "TLS_CONFIGURATIONS"


@jsii.enum(
    jsii_type="@reapit-cdk/service-quotas.AwsOpsWorksForChefAutomateAndAwsOpsWorksForPuppetEnterpriseQuota"
)
class AwsOpsWorksForChefAutomateAndAwsOpsWorksForPuppetEnterpriseQuota(enum.Enum):
    CHEF_AUTOMATE_OR_PUPPET_ENTERPRISE_SERVERS = "CHEF_AUTOMATE_OR_PUPPET_ENTERPRISE_SERVERS"
    AUTOMATED_SCHEDULED_BACKUP_GENERATIONS_PER_SERVER = "AUTOMATED_SCHEDULED_BACKUP_GENERATIONS_PER_SERVER"
    MANUAL_BACKUPS_PER_SERVER = "MANUAL_BACKUPS_PER_SERVER"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsOpsWorksStacksQuota")
class AwsOpsWorksStacksQuota(enum.Enum):
    STACKS = "STACKS"
    APPS_PER_STACK = "APPS_PER_STACK"
    INSTANCES_PER_STACK = "INSTANCES_PER_STACK"
    LAYERS_PER_STACK = "LAYERS_PER_STACK"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsOrganizationsQuota")
class AwsOrganizationsQuota(enum.Enum):
    NUMBER_OF_ACCOUNTS_YOU_CAN_CLOSE_WITHIN_A_30_DAY_PERIOD_THE_ACTUAL_NUMBER_OF_ACCOUNTS_YOU_CAN_CLOSE_IS_EITHER_10_OR_10_OF_YOUR_TOTAL_MEMBER_ACCOUNTS_UP_TO_1000 = "NUMBER_OF_ACCOUNTS_YOU_CAN_CLOSE_WITHIN_A_30_DAY_PERIOD_THE_ACTUAL_NUMBER_OF_ACCOUNTS_YOU_CAN_CLOSE_IS_EITHER_10_OR_10_OF_YOUR_TOTAL_MEMBER_ACCOUNTS_UP_TO_1000"
    ENABLE_ALL_FEATURES_REQUEST_EXPIRATION = "ENABLE_ALL_FEATURES_REQUEST_EXPIRATION"
    SERVICE_CONTROL_POLICY_SCP_DOCUMENT_SIZE = "SERVICE_CONTROL_POLICY_SCP_DOCUMENT_SIZE"
    ROOTS_IN_AN_ORGANIZATION = "ROOTS_IN_AN_ORGANIZATION"
    INVITATION_ACCEPTANCE_EXPIRATION = "INVITATION_ACCEPTANCE_EXPIRATION"
    HANDSHAKE_EXPIRATION = "HANDSHAKE_EXPIRATION"
    MEMBER_ACCOUNTS_YOU_CAN_CONCURRENTLY_CREATE = "MEMBER_ACCOUNTS_YOU_CAN_CONCURRENTLY_CREATE"
    NUMBER_OF_INVITATION_ATTEMPTS_YOU_CAN_PERFORM_IN_A_24_HOUR_PERIOD = "NUMBER_OF_INVITATION_ATTEMPTS_YOU_CAN_PERFORM_IN_A_24_HOUR_PERIOD"
    SERVICE_CONTROL_POLICIES_PER_ACCOUNT = "SERVICE_CONTROL_POLICIES_PER_ACCOUNT"
    OU_MAXIMUM_NESTING_IN_A_ROOT = "OU_MAXIMUM_NESTING_IN_A_ROOT"
    MINIMUM_AGE_FOR_REMOVAL_OF_CREATED_ACCOUNTS = "MINIMUM_AGE_FOR_REMOVAL_OF_CREATED_ACCOUNTS"
    MEMBER_ACCOUNTS_YOU_CAN_CONCURRENTLY_CLOSE = "MEMBER_ACCOUNTS_YOU_CAN_CONCURRENTLY_CLOSE"
    SERVICE_CONTROL_POLICIES_PER_OU = "SERVICE_CONTROL_POLICIES_PER_OU"
    SERVICE_CONTROL_POLICIES_PER_ROOT = "SERVICE_CONTROL_POLICIES_PER_ROOT"
    DEFAULT_MAXIMUM_NUMBER_OF_ACCOUNTS = "DEFAULT_MAXIMUM_NUMBER_OF_ACCOUNTS"
    O_US_IN_AN_ORGANIZATION = "O_US_IN_AN_ORGANIZATION"
    POLICIES_IN_AN_ORGANIZATION = "POLICIES_IN_AN_ORGANIZATION"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsOutpostsQuota")
class AwsOutpostsQuota(enum.Enum):
    OUTPOST_SITES = "OUTPOST_SITES"
    OUTPOSTS_PER_SITE = "OUTPOSTS_PER_SITE"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsPanoramaQuota")
class AwsPanoramaQuota(enum.Enum):
    NODE_PACKAGES = "NODE_PACKAGES"
    VERSIONS_PER_PACKAGE = "VERSIONS_PER_PACKAGE"
    RATE_OF_DELETE_PACKAGE_API_REQUESTS = "RATE_OF_DELETE_PACKAGE_API_REQUESTS"
    RATE_OF_CREATE_JOB_FOR_DEVICES_API_REQUESTS = "RATE_OF_CREATE_JOB_FOR_DEVICES_API_REQUESTS"
    APPLICATIONS_PER_DEVICE = "APPLICATIONS_PER_DEVICE"
    RATE_OF_DEREGISTER_PACKAGE_VERSION_API_REQUESTS = "RATE_OF_DEREGISTER_PACKAGE_VERSION_API_REQUESTS"
    RATE_OF_CREATE_APPLICATION_INSTANCE_API_REQUESTS = "RATE_OF_CREATE_APPLICATION_INSTANCE_API_REQUESTS"
    RATE_OF_REMOVE_APPLICATION_INSTANCE_API_REQUESTS = "RATE_OF_REMOVE_APPLICATION_INSTANCE_API_REQUESTS"
    CAMERA_NODES_PER_APPLICATION = "CAMERA_NODES_PER_APPLICATION"
    ASSETS_PER_PACKAGE = "ASSETS_PER_PACKAGE"
    RATE_OF_TOTAL_API_REQUESTS = "RATE_OF_TOTAL_API_REQUESTS"
    RATE_OF_CREATE_PACKAGE_IMPORT_JOB_API_REQUESTS = "RATE_OF_CREATE_PACKAGE_IMPORT_JOB_API_REQUESTS"
    RATE_OF_DEPLOYMENTS = "RATE_OF_DEPLOYMENTS"
    PACKAGE_ARTIFACT_SIZE = "PACKAGE_ARTIFACT_SIZE"
    RATE_OF_CREATE_NODE_FROM_TEMPLATE_JOB_API_REQUESTS = "RATE_OF_CREATE_NODE_FROM_TEMPLATE_JOB_API_REQUESTS"
    RATE_OF_DESCRIBE_PACKAGE_API_REQUESTS = "RATE_OF_DESCRIBE_PACKAGE_API_REQUESTS"
    DEVICES = "DEVICES"
    RATE_OF_REGISTER_PACKAGE_VERSION_API_REQUESTS = "RATE_OF_REGISTER_PACKAGE_VERSION_API_REQUESTS"
    RATE_OF_PROVISION_DEVICE_API_REQUESTS = "RATE_OF_PROVISION_DEVICE_API_REQUESTS"
    RATE_OF_DELETE_DEVICE_API_REQUESTS = "RATE_OF_DELETE_DEVICE_API_REQUESTS"
    RATE_OF_CREATE_PACKAGE_API_REQUESTS = "RATE_OF_CREATE_PACKAGE_API_REQUESTS"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsPaymentCryptographyQuota")
class AwsPaymentCryptographyQuota(enum.Enum):
    COMBINED_RATE_OF_DATA_PLANE_REQUESTS_SYMMETRIC = "COMBINED_RATE_OF_DATA_PLANE_REQUESTS_SYMMETRIC"
    KEYS = "KEYS"
    ALIASES = "ALIASES"
    COMBINED_RATE_OF_DATA_PLANE_REQUESTS_ASYMMETRIC = "COMBINED_RATE_OF_DATA_PLANE_REQUESTS_ASYMMETRIC"
    COMBINED_RATE_OF_CONTROL_PLANE_REQUESTS = "COMBINED_RATE_OF_CONTROL_PLANE_REQUESTS"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsPrivate5GQuota")
class AwsPrivate5GQuota(enum.Enum):
    ACTIVE_NETWORKS = "ACTIVE_NETWORKS"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsPrivateCertificateAuthorityQuota")
class AwsPrivateCertificateAuthorityQuota(enum.Enum):
    RATE_OF_IMPORT_CERTIFICATE_AUTHORITY_CERTIFICATE_REQUESTS = "RATE_OF_IMPORT_CERTIFICATE_AUTHORITY_CERTIFICATE_REQUESTS"
    RATE_OF_DESCRIBE_CERTIFICATE_AUTHORITY_REQUESTS = "RATE_OF_DESCRIBE_CERTIFICATE_AUTHORITY_REQUESTS"
    RATE_OF_DELETE_CERTIFICATE_AUTHORITY_REQUESTS = "RATE_OF_DELETE_CERTIFICATE_AUTHORITY_REQUESTS"
    RATE_OF_CREATE_PERMISSION_REQUESTS = "RATE_OF_CREATE_PERMISSION_REQUESTS"
    NUMBER_OF_PRIVATE_CERTIFICATES_PER_CA = "NUMBER_OF_PRIVATE_CERTIFICATES_PER_CA"
    RATE_OF_CREATE_CERTIFICATE_AUTHORITY_AUDIT_REPORT_REQUESTS = "RATE_OF_CREATE_CERTIFICATE_AUTHORITY_AUDIT_REPORT_REQUESTS"
    RATE_OF_LIST_CERTIFICATE_AUTHORITIES_REQUESTS = "RATE_OF_LIST_CERTIFICATE_AUTHORITIES_REQUESTS"
    RATE_OF_ISSUE_CERTIFICATE_REQUESTS = "RATE_OF_ISSUE_CERTIFICATE_REQUESTS"
    RATE_OF_GET_POLICY_REQUESTS = "RATE_OF_GET_POLICY_REQUESTS"
    RATE_OF_DELETE_POLICY_REQUESTS = "RATE_OF_DELETE_POLICY_REQUESTS"
    RATE_OF_REVOKE_CERTIFICATE_REQUESTS = "RATE_OF_REVOKE_CERTIFICATE_REQUESTS"
    RATE_OF_TAG_CERTIFICATE_AUTHORITY_REQUESTS = "RATE_OF_TAG_CERTIFICATE_AUTHORITY_REQUESTS"
    NUMBER_OF_PRIVATE_CERTIFICATE_AUTHORITIES_C_AS = "NUMBER_OF_PRIVATE_CERTIFICATE_AUTHORITIES_C_AS"
    RATE_OF_GET_CERTIFICATE_AUTHORITY_CSR_REQUESTS = "RATE_OF_GET_CERTIFICATE_AUTHORITY_CSR_REQUESTS"
    RATE_OF_DESCRIBE_CERTIFICATE_AUTHORITY_AUDIT_REPORT_REQUESTS = "RATE_OF_DESCRIBE_CERTIFICATE_AUTHORITY_AUDIT_REPORT_REQUESTS"
    RATE_OF_UNTAG_CERTIFICATE_AUTHORITY_REQUESTS = "RATE_OF_UNTAG_CERTIFICATE_AUTHORITY_REQUESTS"
    RATE_OF_LIST_TAGS_REQUESTS = "RATE_OF_LIST_TAGS_REQUESTS"
    RATE_OF_UPDATE_CERTIFICATE_AUTHORITY_REQUESTS = "RATE_OF_UPDATE_CERTIFICATE_AUTHORITY_REQUESTS"
    RATE_OF_RESTORE_CERTIFICATE_AUTHORITY_REQUESTS = "RATE_OF_RESTORE_CERTIFICATE_AUTHORITY_REQUESTS"
    NUMBER_OF_REVOKED_PRIVATE_CERTIFICATES_PER_CA = "NUMBER_OF_REVOKED_PRIVATE_CERTIFICATES_PER_CA"
    RATE_OF_PUT_POLICY_REQUESTS = "RATE_OF_PUT_POLICY_REQUESTS"
    RATE_OF_GET_CERTIFICATE_REQUESTS = "RATE_OF_GET_CERTIFICATE_REQUESTS"
    RATE_OF_DELETE_PERMISSION_REQUESTS = "RATE_OF_DELETE_PERMISSION_REQUESTS"
    RATE_OF_LIST_PERMISSIONS_REQUESTS = "RATE_OF_LIST_PERMISSIONS_REQUESTS"
    RATE_OF_GET_CERTIFICATE_AUTHORITY_CERTIFICATE_REQUESTS = "RATE_OF_GET_CERTIFICATE_AUTHORITY_CERTIFICATE_REQUESTS"
    RATE_OF_CREATE_CERTIFICATE_AUTHORITY_REQUESTS = "RATE_OF_CREATE_CERTIFICATE_AUTHORITY_REQUESTS"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsProtonQuota")
class AwsProtonQuota(enum.Enum):
    ENVIRONMENTS_PER_ACCOUNT = "ENVIRONMENTS_PER_ACCOUNT"
    ENVIRONMENT_ACCOUNT_CONNECTIONS_PER_ENVIRONMENT_ACCOUNT = "ENVIRONMENT_ACCOUNT_CONNECTIONS_PER_ENVIRONMENT_ACCOUNT"
    COMPONENTS_PER_ACCOUNT = "COMPONENTS_PER_ACCOUNT"
    TEMPLATES_PER_ACCOUNT = "TEMPLATES_PER_ACCOUNT"
    TEMPLATE_VERSIONS_PER_TEMPLATE = "TEMPLATE_VERSIONS_PER_TEMPLATE"
    SERVICE_INSTANCES_PER_SERVICE = "SERVICE_INSTANCES_PER_SERVICE"
    SERVICES_PER_ACCOUNT = "SERVICES_PER_ACCOUNT"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsResilienceHubQuota")
class AwsResilienceHubQuota(enum.Enum):
    NUMBER_OF_RESILIENCY_POLICIES = "NUMBER_OF_RESILIENCY_POLICIES"
    NUMBER_OF_APPLICATIONS = "NUMBER_OF_APPLICATIONS"
    NUMBER_OF_RESOURCES_PER_APPLICATION = "NUMBER_OF_RESOURCES_PER_APPLICATION"
    NUMBER_OF_RECOMMENDATION_TEMPLATES_PER_APPLICATION_PER_MONTH = "NUMBER_OF_RECOMMENDATION_TEMPLATES_PER_APPLICATION_PER_MONTH"
    NUMBER_OF_TERRAFORM_STATE_FILES_TO_IMPORT = "NUMBER_OF_TERRAFORM_STATE_FILES_TO_IMPORT"
    TERRAFORM_STATE_FILE_MAXIMUM_SIZE = "TERRAFORM_STATE_FILE_MAXIMUM_SIZE"
    NUMBER_OF_NAMESPACES_TO_IMPORT_FOR_AN_EKS_CLUSTER = "NUMBER_OF_NAMESPACES_TO_IMPORT_FOR_AN_EKS_CLUSTER"
    NUMBER_OF_APPLICATION_COMPONENTS_PER_APPLICATION = "NUMBER_OF_APPLICATION_COMPONENTS_PER_APPLICATION"
    NUMBER_OF_AWS_CLOUD_FORMATION_STACKS_TO_IMPORT = "NUMBER_OF_AWS_CLOUD_FORMATION_STACKS_TO_IMPORT"
    NUMBER_OF_ASSESSMENTS_PER_APPLICATION_PER_MONTH = "NUMBER_OF_ASSESSMENTS_PER_APPLICATION_PER_MONTH"
    NUMBER_OF_EKS_CLUSTERS_TO_IMPORT = "NUMBER_OF_EKS_CLUSTERS_TO_IMPORT"
    NUMBER_OF_CONCURRENT_ASSESSMENTS_PER_APPLICATION = "NUMBER_OF_CONCURRENT_ASSESSMENTS_PER_APPLICATION"
    TEMPLATE_SIZE_IN_BYTES = "TEMPLATE_SIZE_IN_BYTES"
    NUMBER_OF_CONCURRENT_RECOMMENDATION_TEMPLATES_PER_ACCOUNT = "NUMBER_OF_CONCURRENT_RECOMMENDATION_TEMPLATES_PER_ACCOUNT"
    RETENTION_PERIOD_OF_PAST_RECOMMENDATION_TEMPLATES_IN_DAYS = "RETENTION_PERIOD_OF_PAST_RECOMMENDATION_TEMPLATES_IN_DAYS"
    RETENTION_PERIOD_OF_PAST_ASSESSMENTS_RECOMMENDATIONS_IN_DAYS = "RETENTION_PERIOD_OF_PAST_ASSESSMENTS_RECOMMENDATIONS_IN_DAYS"
    NUMBER_OF_CONCURRENT_RECOMMENDATION_TEMPLATES_PER_APPLICATION = "NUMBER_OF_CONCURRENT_RECOMMENDATION_TEMPLATES_PER_APPLICATION"
    NUMBER_OF_APPLICATION_COMPONENTS_PER_RESOURCE = "NUMBER_OF_APPLICATION_COMPONENTS_PER_RESOURCE"
    NUMBER_OF_CONCURRENT_ASSESSMENTS_PER_ACCOUNT = "NUMBER_OF_CONCURRENT_ASSESSMENTS_PER_ACCOUNT"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsResourceAccessManagerQuota")
class AwsResourceAccessManagerQuota(enum.Enum):
    NUMBER_OF_RESOURCE_SHARES = "NUMBER_OF_RESOURCE_SHARES"
    NUMBER_OF_RESOURCE_ASSOCIATIONS = "NUMBER_OF_RESOURCE_ASSOCIATIONS"
    NUMBER_OF_CUSTOM_PERMISSIONS_PER_RESOURCE_TYPE = "NUMBER_OF_CUSTOM_PERMISSIONS_PER_RESOURCE_TYPE"
    NUMBER_OF_PENDING_INVITATIONS = "NUMBER_OF_PENDING_INVITATIONS"
    NUMBER_OF_PRINCIPAL_ASSOCIATIONS = "NUMBER_OF_PRINCIPAL_ASSOCIATIONS"
    NUMBER_OF_RESOURCE_ASSOCIATIONS_PER_RESOURCE_SHARE = "NUMBER_OF_RESOURCE_ASSOCIATIONS_PER_RESOURCE_SHARE"
    NUMBER_OF_PRINCIPAL_ASSOCIATIONS_PER_RESOURCE_SHARE = "NUMBER_OF_PRINCIPAL_ASSOCIATIONS_PER_RESOURCE_SHARE"
    NUMBER_OF_CUSTOM_PERMISSIONS = "NUMBER_OF_CUSTOM_PERMISSIONS"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsResourceExplorerQuota")
class AwsResourceExplorerQuota(enum.Enum):
    NON_AGGREGATOR_REGION_SEARCH_MONTHLY_QUOTA = "NON_AGGREGATOR_REGION_SEARCH_MONTHLY_QUOTA"
    AGGREGATOR_REGION_SEARCH_MONTHLY_QUOTA = "AGGREGATOR_REGION_SEARCH_MONTHLY_QUOTA"
    SEARCH_TPS_QUOTA = "SEARCH_TPS_QUOTA"
    VIEWS = "VIEWS"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsResourceGroupsQuota")
class AwsResourceGroupsQuota(enum.Enum):
    RESOURCE_GROUPS_PER_ACCOUNT = "RESOURCE_GROUPS_PER_ACCOUNT"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsRoboMakerQuota")
class AwsRoboMakerQuota(enum.Enum):
    CONCURRENT_SIMULATION_JOBS = "CONCURRENT_SIMULATION_JOBS"
    WORLD_TEMPLATES_PER_ACCOUNT = "WORLD_TEMPLATES_PER_ACCOUNT"
    ROBOTS = "ROBOTS"
    CONCURRENT_DEPLOYMENT_JOBS = "CONCURRENT_DEPLOYMENT_JOBS"
    SIMULATION_APPLICATIONS = "SIMULATION_APPLICATIONS"
    ROBOT_APPLICATIONS = "ROBOT_APPLICATIONS"
    SIMULATION_JOB_CREATION_RATE_PER_MINUTE = "SIMULATION_JOB_CREATION_RATE_PER_MINUTE"
    VERSIONS_PER_ROBOT_APPLICATION = "VERSIONS_PER_ROBOT_APPLICATION"
    BATCH_TIMEOUT = "BATCH_TIMEOUT"
    FLEETS = "FLEETS"
    SIMULATION_JOB_REQUESTS_PER_BATCH = "SIMULATION_JOB_REQUESTS_PER_BATCH"
    WORLDS_PER_GENERATION_JOB = "WORLDS_PER_GENERATION_JOB"
    CONCURRENT_WORLD_GENERATION_JOBS = "CONCURRENT_WORLD_GENERATION_JOBS"
    MINIMUM_SIMULATION_DURATION = "MINIMUM_SIMULATION_DURATION"
    SOURCE_SIZE = "SOURCE_SIZE"
    SIMULATION_DURATION = "SIMULATION_DURATION"
    CONCURRENT_SIMULATION_JOB_BATCHES = "CONCURRENT_SIMULATION_JOB_BATCHES"
    GPU_SIMULATION_JOB_CREATION_RATE_PER_MINUTE = "GPU_SIMULATION_JOB_CREATION_RATE_PER_MINUTE"
    WORLDS_PER_EXPORT_JOB = "WORLDS_PER_EXPORT_JOB"
    VERSIONS_PER_SIMULATION_APPLICATION = "VERSIONS_PER_SIMULATION_APPLICATION"
    CONCURRENT_GPU_SIMULATION_JOBS = "CONCURRENT_GPU_SIMULATION_JOBS"
    MINIMUM_BATCH_TIMEOUT = "MINIMUM_BATCH_TIMEOUT"
    CONCURRENT_WORLD_EXPORT_JOBS = "CONCURRENT_WORLD_EXPORT_JOBS"
    ROBOTS_PER_FLEET = "ROBOTS_PER_FLEET"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsS3OutpostsQuota")
class AwsS3OutpostsQuota(enum.Enum):
    BUCKETS = "BUCKETS"
    ACCESS_POINTS = "ACCESS_POINTS"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsSecretsManagerQuota")
class AwsSecretsManagerQuota(enum.Enum):
    COMBINED_RATE_OF_PUT_SECRET_VALUE_REMOVE_REGIONS_FROM_REPLICATION_REPLICATE_SECRET_TO_REGION_STOP_REPLICATION_TO_REPLICA_UPDATE_SECRET_AND_UPDATE_SECRET_VERSION_STAGE_API_REQUESTS = "COMBINED_RATE_OF_PUT_SECRET_VALUE_REMOVE_REGIONS_FROM_REPLICATION_REPLICATE_SECRET_TO_REGION_STOP_REPLICATION_TO_REPLICA_UPDATE_SECRET_AND_UPDATE_SECRET_VERSION_STAGE_API_REQUESTS"
    RATE_OF_BATCH_GET_SECRET_VALUE_API_REQUESTS = "RATE_OF_BATCH_GET_SECRET_VALUE_API_REQUESTS"
    VERSIONS_PER_SECRET = "VERSIONS_PER_SECRET"
    COMBINED_RATE_OF_RESTORE_SECRET_API_REQUESTS = "COMBINED_RATE_OF_RESTORE_SECRET_API_REQUESTS"
    COMBINED_RATE_OF_ROTATE_SECRET_AND_CANCEL_ROTATE_SECRET_API_REQUESTS = "COMBINED_RATE_OF_ROTATE_SECRET_AND_CANCEL_ROTATE_SECRET_API_REQUESTS"
    COMBINED_RATE_OF_DELETE_RESOURCE_POLICY_GET_RESOURCE_POLICY_PUT_RESOURCE_POLICY_AND_VALIDATE_RESOURCE_POLICY_API_REQUESTS = "COMBINED_RATE_OF_DELETE_RESOURCE_POLICY_GET_RESOURCE_POLICY_PUT_RESOURCE_POLICY_AND_VALIDATE_RESOURCE_POLICY_API_REQUESTS"
    RATE_OF_GET_RANDOM_PASSWORD_API_REQUESTS = "RATE_OF_GET_RANDOM_PASSWORD_API_REQUESTS"
    RESOURCE_BASED_POLICY_LENGTH = "RESOURCE_BASED_POLICY_LENGTH"
    RATE_OF_CREATE_SECRET_API_REQUESTS = "RATE_OF_CREATE_SECRET_API_REQUESTS"
    COMBINED_RATE_OF_DESCRIBE_SECRET_AND_GET_SECRET_VALUE_API_REQUESTS = "COMBINED_RATE_OF_DESCRIBE_SECRET_AND_GET_SECRET_VALUE_API_REQUESTS"
    COMBINED_RATE_OF_TAG_RESOURCE_AND_UNTAG_RESOURCE_API_REQUESTS = "COMBINED_RATE_OF_TAG_RESOURCE_AND_UNTAG_RESOURCE_API_REQUESTS"
    RATE_OF_LIST_SECRETS_API_REQUESTS = "RATE_OF_LIST_SECRETS_API_REQUESTS"
    SECRET_VALUE_SIZE = "SECRET_VALUE_SIZE"
    STAGING_LABELS_ATTACHED_ACROSS_ALL_VERSIONS_OF_A_SECRET = "STAGING_LABELS_ATTACHED_ACROSS_ALL_VERSIONS_OF_A_SECRET"
    RATE_OF_LIST_SECRET_VERSION_IDS_API_REQUESTS = "RATE_OF_LIST_SECRET_VERSION_IDS_API_REQUESTS"
    RATE_OF_DELETE_SECRET_API_REQUESTS = "RATE_OF_DELETE_SECRET_API_REQUESTS"
    SECRETS = "SECRETS"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsSecurityHubQuota")
class AwsSecurityHubQuota(enum.Enum):
    NUMBER_OF_AUTOMATION_RULES = "NUMBER_OF_AUTOMATION_RULES"
    NUMBER_OF_CUSTOM_ACTIONS = "NUMBER_OF_CUSTOM_ACTIONS"
    SECURITY_HUB_FINDING_RETENTION_TIME = "SECURITY_HUB_FINDING_RETENTION_TIME"
    NUMBER_OF_SECURITY_HUB_MEMBER_ACCOUNTS = "NUMBER_OF_SECURITY_HUB_MEMBER_ACCOUNTS"
    NUMBER_OF_CUSTOM_INSIGHTS = "NUMBER_OF_CUSTOM_INSIGHTS"
    NUMBER_OF_INSIGHT_RESULTS = "NUMBER_OF_INSIGHT_RESULTS"
    NUMBER_OF_SECURITY_HUB_OUTSTANDING_INVITATIONS = "NUMBER_OF_SECURITY_HUB_OUTSTANDING_INVITATIONS"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsServerMigrationServiceQuota")
class AwsServerMigrationServiceQuota(enum.Enum):
    CONCURRENT_VM_MIGRATIONS = "CONCURRENT_VM_MIGRATIONS"
    DURATION_OF_SERVICE_USAGE_PER_VM_IN_DAYS = "DURATION_OF_SERVICE_USAGE_PER_VM_IN_DAYS"


@jsii.enum(
    jsii_type="@reapit-cdk/service-quotas.AwsServerlessApplicationRepositoryQuota"
)
class AwsServerlessApplicationRepositoryQuota(enum.Enum):
    PUBLIC_APPLICATIONS = "PUBLIC_APPLICATIONS"
    APPLICATION_POLICY_LENGTH = "APPLICATION_POLICY_LENGTH"
    FREE_AMAZON_S3_STORAGE_FOR_CODE_PACKAGES = "FREE_AMAZON_S3_STORAGE_FOR_CODE_PACKAGES"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsServiceCatalogQuota")
class AwsServiceCatalogQuota(enum.Enum):
    PRODUCTS_PER_REGION = "PRODUCTS_PER_REGION"
    APPLICATIONS_PER_ATTRIBUTE_GROUP = "APPLICATIONS_PER_ATTRIBUTE_GROUP"
    SERVICE_ACTION_ASSOCIATIONS_PER_PROVISIONING_ARTIFACT = "SERVICE_ACTION_ASSOCIATIONS_PER_PROVISIONING_ARTIFACT"
    USERS_GROUPS_AND_ROLES_PER_PORTFOLIO = "USERS_GROUPS_AND_ROLES_PER_PORTFOLIO"
    USERS_GROUPS_AND_ROLES_PER_PRODUCT = "USERS_GROUPS_AND_ROLES_PER_PRODUCT"
    PRODUCT_VERSIONS_PER_PRODUCT = "PRODUCT_VERSIONS_PER_PRODUCT"
    RESOURCES_PER_APPLICATION = "RESOURCES_PER_APPLICATION"
    TAGS_PER_PRODUCT = "TAGS_PER_PRODUCT"
    PORTFOLIOS_PER_REGION = "PORTFOLIOS_PER_REGION"
    TAGS_PER_PROVISIONED_PRODUCT = "TAGS_PER_PROVISIONED_PRODUCT"
    SERVICE_ACTIONS_PER_REGION = "SERVICE_ACTIONS_PER_REGION"
    PRODUCTS_PER_PORTFOLIO = "PRODUCTS_PER_PORTFOLIO"
    SHARED_ACCOUNTS_PER_PORTFOLIO = "SHARED_ACCOUNTS_PER_PORTFOLIO"
    APPLICATIONS_PER_REGION = "APPLICATIONS_PER_REGION"
    ATTRIBUTE_GROUPS_PER_REGION = "ATTRIBUTE_GROUPS_PER_REGION"
    ATTRIBUTE_GROUPS_PER_APPLICATION = "ATTRIBUTE_GROUPS_PER_APPLICATION"
    TAGS_PER_PORTFOLIO = "TAGS_PER_PORTFOLIO"
    DELEGATED_ADMINISTRATORS_PER_ORGANIZATION = "DELEGATED_ADMINISTRATORS_PER_ORGANIZATION"
    TAG_OPTIONS_PER_RESOURCE = "TAG_OPTIONS_PER_RESOURCE"
    VALUES_PER_TAG_OPTION = "VALUES_PER_TAG_OPTION"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsShieldAdvancedQuota")
class AwsShieldAdvancedQuota(enum.Enum):
    AMAZON_ROUTE_53_HOSTED_ZONE_PROTECTIONS = "AMAZON_ROUTE_53_HOSTED_ZONE_PROTECTIONS"
    AWS_GLOBAL_ACCELERATOR_ACCELERATOR_PROTECTIONS = "AWS_GLOBAL_ACCELERATOR_ACCELERATOR_PROTECTIONS"
    ELASTIC_LOAD_BALANCING_LOAD_BALANCER_PROTECTIONS = "ELASTIC_LOAD_BALANCING_LOAD_BALANCER_PROTECTIONS"
    ELASTIC_IP_ADDRESS_PROTECTIONS = "ELASTIC_IP_ADDRESS_PROTECTIONS"
    CLOUD_FRONT_DISTRIBUTION_PROTECTIONS = "CLOUD_FRONT_DISTRIBUTION_PROTECTIONS"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsSignerQuota")
class AwsSignerQuota(enum.Enum):
    RATE_OF_REMOVE_PROFILE_PERMISSION_REQUESTS = "RATE_OF_REMOVE_PROFILE_PERMISSION_REQUESTS"
    RATE_OF_TAG_RESOURCE_REQUESTS = "RATE_OF_TAG_RESOURCE_REQUESTS"
    RATE_OF_LIST_TAGS_FOR_RESOURCE_REQUESTS = "RATE_OF_LIST_TAGS_FOR_RESOURCE_REQUESTS"
    RATE_OF_LIST_SIGNING_PROFILES_REQUESTS = "RATE_OF_LIST_SIGNING_PROFILES_REQUESTS"
    RATE_OF_LIST_PROFILE_PERMISSIONS_REQUESTS = "RATE_OF_LIST_PROFILE_PERMISSIONS_REQUESTS"
    RATE_OF_GET_REVOCATION_STATUS_REQUESTS = "RATE_OF_GET_REVOCATION_STATUS_REQUESTS"
    RATE_OF_REVOKE_SIGNING_PROFILE_REQUESTS = "RATE_OF_REVOKE_SIGNING_PROFILE_REQUESTS"
    RATE_OF_REVOKE_SIGNATURE_REQUESTS = "RATE_OF_REVOKE_SIGNATURE_REQUESTS"
    RATE_OF_PUT_SIGNING_PROFILE_REQUESTS = "RATE_OF_PUT_SIGNING_PROFILE_REQUESTS"
    RATE_OF_DESCRIBE_SIGNING_JOB_REQUESTS = "RATE_OF_DESCRIBE_SIGNING_JOB_REQUESTS"
    RATE_OF_GET_SIGNING_PROFILE_REQUESTS = "RATE_OF_GET_SIGNING_PROFILE_REQUESTS"
    RATE_OF_ADD_PROFILE_PERMISSION_REQUESTS = "RATE_OF_ADD_PROFILE_PERMISSION_REQUESTS"
    RATE_OF_LIST_SIGNING_JOBS_REQUESTS = "RATE_OF_LIST_SIGNING_JOBS_REQUESTS"
    RATE_OF_START_SIGNING_JOB_REQUESTS = "RATE_OF_START_SIGNING_JOB_REQUESTS"
    RATE_OF_UNTAG_RESOURCE_REQUESTS = "RATE_OF_UNTAG_RESOURCE_REQUESTS"
    RATE_OF_LIST_SIGNING_PLATFORMS_REQUESTS = "RATE_OF_LIST_SIGNING_PLATFORMS_REQUESTS"
    RATE_OF_SIGN_PAYLOAD_REQUESTS = "RATE_OF_SIGN_PAYLOAD_REQUESTS"
    RATE_OF_GET_SIGNING_PLATFORM_REQUESTS = "RATE_OF_GET_SIGNING_PLATFORM_REQUESTS"
    RATE_OF_CANCEL_SIGNING_PROFILE_REQUESTS = "RATE_OF_CANCEL_SIGNING_PROFILE_REQUESTS"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsSimSpaceWeaverQuota")
class AwsSimSpaceWeaverQuota(enum.Enum):
    INDEX_FIELDS_FOR_EACH_ENTITY = "INDEX_FIELDS_FOR_EACH_ENTITY"
    ENTITY_TRANSFERS_ON_THE_SAME_WORKER = "ENTITY_TRANSFERS_ON_THE_SAME_WORKER"
    DATA_FIELDS_FOR_EACH_ENTITY = "DATA_FIELDS_FOR_EACH_ENTITY"
    WORKERS_FOR_A_SIMULATION = "WORKERS_FOR_A_SIMULATION"
    REMOTE_SUBSCRIPTIONS_FOR_EACH_WORKER = "REMOTE_SUBSCRIPTIONS_FOR_EACH_WORKER"
    MEMORY_FOR_EACH_COMPUTE_RESOURCE_UNIT = "MEMORY_FOR_EACH_COMPUTE_RESOURCE_UNIT"
    COMPUTE_RESOURCE_UNITS_FOR_EACH_APP = "COMPUTE_RESOURCE_UNITS_FOR_EACH_APP"
    ENTITY_DATA_FIELD_SIZE = "ENTITY_DATA_FIELD_SIZE"
    SIMULATION_COUNT = "SIMULATION_COUNT"
    LARGEST_MAXIMUM_DURATION_IN_DAYS_FOR_A_SIMULATION = "LARGEST_MAXIMUM_DURATION_IN_DAYS_FOR_A_SIMULATION"
    ENTITIES_IN_A_PARTITION = "ENTITIES_IN_A_PARTITION"
    ENTITY_TRANSFERS_BETWEEN_WORKERS = "ENTITY_TRANSFERS_BETWEEN_WORKERS"
    COMPUTE_RESOURCE_UNITS_FOR_EACH_WORKER = "COMPUTE_RESOURCE_UNITS_FOR_EACH_WORKER"
    V_CP_US_FOR_EACH_COMPUTE_RESOURCE_UNIT = "V_CP_US_FOR_EACH_COMPUTE_RESOURCE_UNIT"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsSnowDeviceManagementQuota")
class AwsSnowDeviceManagementQuota(enum.Enum):
    DESCRIBE_DEVICE_EC2_INSTANCES_THROTTLE_LIMIT = "DESCRIBE_DEVICE_EC2_INSTANCES_THROTTLE_LIMIT"
    LIST_DEVICE_RESOURCES_THROTTLE_LIMIT = "LIST_DEVICE_RESOURCES_THROTTLE_LIMIT"
    DESCRIBE_TASK_THROTTLE_LIMIT = "DESCRIBE_TASK_THROTTLE_LIMIT"
    DESCRIBE_DEVICE_THROTTLE_LIMIT = "DESCRIBE_DEVICE_THROTTLE_LIMIT"
    CANCEL_TASK_THROTTLE_LIMIT = "CANCEL_TASK_THROTTLE_LIMIT"
    LIST_EXECUTIONS_THROTTLE_LIMIT = "LIST_EXECUTIONS_THROTTLE_LIMIT"
    LIST_DEVICES_THROTTLE_LIMIT = "LIST_DEVICES_THROTTLE_LIMIT"
    LIST_TASKS_THROTTLE_LIMIT = "LIST_TASKS_THROTTLE_LIMIT"
    SNOW_DEVICE_MANAGEMENT_MAXIMUM_TASKS = "SNOW_DEVICE_MANAGEMENT_MAXIMUM_TASKS"
    SNOW_DEVICE_MANAGEMENT_ACTIVE_TASKS = "SNOW_DEVICE_MANAGEMENT_ACTIVE_TASKS"
    CREATE_TASK_THROTTLE_LIMIT = "CREATE_TASK_THROTTLE_LIMIT"
    DESCRIBE_EXECUTION_THROTTLE_LIMIT = "DESCRIBE_EXECUTION_THROTTLE_LIMIT"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsSnowFamilyQuota")
class AwsSnowFamilyQuota(enum.Enum):
    SNOWBALL_EDGE_DEVICES = "SNOWBALL_EDGE_DEVICES"
    SNOWCONE_DEVICES = "SNOWCONE_DEVICES"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsStepFunctionsQuota")
class AwsStepFunctionsQuota(enum.Enum):
    STATE_TRANSITION_THROTTLE_TOKEN_REFILL_RATE_PER_SECOND = "STATE_TRANSITION_THROTTLE_TOKEN_REFILL_RATE_PER_SECOND"
    UPDATE_STATE_MACHINE_THROTTLE_TOKEN_REFILL_RATE_PER_SECOND = "UPDATE_STATE_MACHINE_THROTTLE_TOKEN_REFILL_RATE_PER_SECOND"
    SEND_TASK_SUCCESS_THROTTLE_TOKEN_REFILL_RATE_PER_SECOND = "SEND_TASK_SUCCESS_THROTTLE_TOKEN_REFILL_RATE_PER_SECOND"
    LIST_ACTIVITIES_THROTTLE_TOKEN_BUCKET_SIZE = "LIST_ACTIVITIES_THROTTLE_TOKEN_BUCKET_SIZE"
    SYNCHRONOUS_EXPRESS_WORKFLOWS_CONCURRENT_EXECUTIONS = "SYNCHRONOUS_EXPRESS_WORKFLOWS_CONCURRENT_EXECUTIONS"
    REQUEST_SIZE = "REQUEST_SIZE"
    SEND_TASK_HEARTBEAT_THROTTLE_TOKEN_REFILL_RATE_PER_SECOND = "SEND_TASK_HEARTBEAT_THROTTLE_TOKEN_REFILL_RATE_PER_SECOND"
    REGISTERED_STATE_MACHINES = "REGISTERED_STATE_MACHINES"
    CREATE_ACTIVITY_THROTTLE_TOKEN_REFILL_RATE_PER_SECOND = "CREATE_ACTIVITY_THROTTLE_TOKEN_REFILL_RATE_PER_SECOND"
    LIST_TAGS_FOR_RESOURCE_THROTTLE_TOKEN_BUCKET_SIZE = "LIST_TAGS_FOR_RESOURCE_THROTTLE_TOKEN_BUCKET_SIZE"
    GET_EXECUTION_HISTORY_THROTTLE_TOKEN_REFILL_RATE_PER_SECOND = "GET_EXECUTION_HISTORY_THROTTLE_TOKEN_REFILL_RATE_PER_SECOND"
    TAG_RESOURCE_THROTTLE_TOKEN_BUCKET_SIZE = "TAG_RESOURCE_THROTTLE_TOKEN_BUCKET_SIZE"
    SEND_TASK_FAILURE_THROTTLE_TOKEN_BUCKET_SIZE = "SEND_TASK_FAILURE_THROTTLE_TOKEN_BUCKET_SIZE"
    STOP_EXECUTION_THROTTLE_TOKEN_REFILL_RATE_PER_SECOND = "STOP_EXECUTION_THROTTLE_TOKEN_REFILL_RATE_PER_SECOND"
    DELETE_STATE_MACHINE_THROTTLE_TOKEN_BUCKET_SIZE = "DELETE_STATE_MACHINE_THROTTLE_TOKEN_BUCKET_SIZE"
    DELETE_ACTIVITY_THROTTLE_TOKEN_REFILL_RATE_PER_SECOND = "DELETE_ACTIVITY_THROTTLE_TOKEN_REFILL_RATE_PER_SECOND"
    CREATE_STATE_MACHINE_THROTTLE_TOKEN_REFILL_RATE_PER_SECOND = "CREATE_STATE_MACHINE_THROTTLE_TOKEN_REFILL_RATE_PER_SECOND"
    RESOURCE_NAME_LENGTH = "RESOURCE_NAME_LENGTH"
    UNTAG_RESOURCE_THROTTLE_TOKEN_BUCKET_SIZE = "UNTAG_RESOURCE_THROTTLE_TOKEN_BUCKET_SIZE"
    REGISTERED_ACTIVITIES = "REGISTERED_ACTIVITIES"
    OPEN_MAP_RUNS = "OPEN_MAP_RUNS"
    START_EXPRESS_EXECUTION_THROTTLE_TOKEN_BUCKET_SIZE = "START_EXPRESS_EXECUTION_THROTTLE_TOKEN_BUCKET_SIZE"
    LIST_ACTIVITIES_THROTTLE_TOKEN_REFILL_RATE_PER_SECOND = "LIST_ACTIVITIES_THROTTLE_TOKEN_REFILL_RATE_PER_SECOND"
    START_EXECUTION_THROTTLE_TOKEN_BUCKET_SIZE = "START_EXECUTION_THROTTLE_TOKEN_BUCKET_SIZE"
    CREATE_ACTIVITY_THROTTLE_TOKEN_BUCKET_SIZE = "CREATE_ACTIVITY_THROTTLE_TOKEN_BUCKET_SIZE"
    CREATE_STATE_MACHINE_THROTTLE_TOKEN_BUCKET_SIZE = "CREATE_STATE_MACHINE_THROTTLE_TOKEN_BUCKET_SIZE"
    UNTAG_RESOURCE_THROTTLE_TOKEN_REFILL_RATE_PER_SECOND = "UNTAG_RESOURCE_THROTTLE_TOKEN_REFILL_RATE_PER_SECOND"
    DESCRIBE_STATE_MACHINE_THROTTLE_TOKEN_REFILL_RATE_PER_SECOND = "DESCRIBE_STATE_MACHINE_THROTTLE_TOKEN_REFILL_RATE_PER_SECOND"
    DELETE_ACTIVITY_THROTTLE_TOKEN_BUCKET_SIZE = "DELETE_ACTIVITY_THROTTLE_TOKEN_BUCKET_SIZE"
    GET_ACTIVITY_TASK_THROTTLE_TOKEN_BUCKET_SIZE = "GET_ACTIVITY_TASK_THROTTLE_TOKEN_BUCKET_SIZE"
    DESCRIBE_ACTIVITY_THROTTLE_TOKEN_BUCKET_SIZE = "DESCRIBE_ACTIVITY_THROTTLE_TOKEN_BUCKET_SIZE"
    STOP_EXECUTION_THROTTLE_TOKEN_BUCKET_SIZE = "STOP_EXECUTION_THROTTLE_TOKEN_BUCKET_SIZE"
    EXECUTION_HISTORY_SIZE = "EXECUTION_HISTORY_SIZE"
    START_EXECUTION_THROTTLE_TOKEN_REFILL_RATE_PER_SECOND = "START_EXECUTION_THROTTLE_TOKEN_REFILL_RATE_PER_SECOND"
    DELETE_STATE_MACHINE_THROTTLE_TOKEN_REFILL_RATE_PER_SECOND = "DELETE_STATE_MACHINE_THROTTLE_TOKEN_REFILL_RATE_PER_SECOND"
    DESCRIBE_STATE_MACHINE_THROTTLE_TOKEN_BUCKET_SIZE = "DESCRIBE_STATE_MACHINE_THROTTLE_TOKEN_BUCKET_SIZE"
    TAG_RESOURCE_THROTTLE_TOKEN_REFILL_RATE_PER_SECOND = "TAG_RESOURCE_THROTTLE_TOKEN_REFILL_RATE_PER_SECOND"
    EXECUTION_HISTORY_RETENTION_TIME = "EXECUTION_HISTORY_RETENTION_TIME"
    ACTIVITY_POLLERS_PER_ARN = "ACTIVITY_POLLERS_PER_ARN"
    GET_ACTIVITY_TASK_THROTTLE_TOKEN_REFILL_RATE_PER_SECOND = "GET_ACTIVITY_TASK_THROTTLE_TOKEN_REFILL_RATE_PER_SECOND"
    EXECUTION_IDLE_TIME = "EXECUTION_IDLE_TIME"
    DESCRIBE_EXECUTION_THROTTLE_TOKEN_BUCKET_SIZE = "DESCRIBE_EXECUTION_THROTTLE_TOKEN_BUCKET_SIZE"
    START_EXPRESS_EXECUTION_THROTTLE_TOKEN_REFILL_RATE_PER_SECOND = "START_EXPRESS_EXECUTION_THROTTLE_TOKEN_REFILL_RATE_PER_SECOND"
    DESCRIBE_STATE_MACHINE_FOR_EXECUTION_THROTTLE_TOKEN_REFILL_RATE_PER_SECOND = "DESCRIBE_STATE_MACHINE_FOR_EXECUTION_THROTTLE_TOKEN_REFILL_RATE_PER_SECOND"
    DESCRIBE_ACTIVITY_THROTTLE_TOKEN_REFILL_RATE_PER_SECOND = "DESCRIBE_ACTIVITY_THROTTLE_TOKEN_REFILL_RATE_PER_SECOND"
    INPUT_OR_RESULT_DATA_SIZE_IN_TASK_STATE_OR_EXECUTION = "INPUT_OR_RESULT_DATA_SIZE_IN_TASK_STATE_OR_EXECUTION"
    SEND_TASK_SUCCESS_THROTTLE_TOKEN_BUCKET_SIZE = "SEND_TASK_SUCCESS_THROTTLE_TOKEN_BUCKET_SIZE"
    LIST_STATE_MACHINES_THROTTLE_TOKEN_BUCKET_SIZE = "LIST_STATE_MACHINES_THROTTLE_TOKEN_BUCKET_SIZE"
    LIST_TAGS_FOR_RESOURCE_THROTTLE_TOKEN_REFILL_RATE_PER_SECOND = "LIST_TAGS_FOR_RESOURCE_THROTTLE_TOKEN_REFILL_RATE_PER_SECOND"
    TASK_RETENTION_TIME_IN_QUEUE = "TASK_RETENTION_TIME_IN_QUEUE"
    DESCRIBE_STATE_MACHINE_FOR_EXECUTION_THROTTLE_TOKEN_BUCKET_SIZE = "DESCRIBE_STATE_MACHINE_FOR_EXECUTION_THROTTLE_TOKEN_BUCKET_SIZE"
    GET_EXECUTION_HISTORY_THROTTLE_TOKEN_BUCKET_SIZE = "GET_EXECUTION_HISTORY_THROTTLE_TOKEN_BUCKET_SIZE"
    STATE_TRANSITION_THROTTLE_TOKEN_BUCKET_SIZE = "STATE_TRANSITION_THROTTLE_TOKEN_BUCKET_SIZE"
    OPEN_EXECUTIONS = "OPEN_EXECUTIONS"
    LIST_STATE_MACHINES_THROTTLE_TOKEN_REFILL_RATE_PER_SECOND = "LIST_STATE_MACHINES_THROTTLE_TOKEN_REFILL_RATE_PER_SECOND"
    LIST_EXECUTIONS_THROTTLE_TOKEN_REFILL_RATE_PER_SECOND = "LIST_EXECUTIONS_THROTTLE_TOKEN_REFILL_RATE_PER_SECOND"
    TASK_EXECUTION_TIME = "TASK_EXECUTION_TIME"
    SEND_TASK_HEARTBEAT_THROTTLE_TOKEN_BUCKET_SIZE = "SEND_TASK_HEARTBEAT_THROTTLE_TOKEN_BUCKET_SIZE"
    DESCRIBE_EXECUTION_THROTTLE_TOKEN_REFILL_RATE_PER_SECOND = "DESCRIBE_EXECUTION_THROTTLE_TOKEN_REFILL_RATE_PER_SECOND"
    UPDATE_STATE_MACHINE_THROTTLE_TOKEN_BUCKET_SIZE = "UPDATE_STATE_MACHINE_THROTTLE_TOKEN_BUCKET_SIZE"
    EXECUTION_TIME = "EXECUTION_TIME"
    SEND_TASK_FAILURE_THROTTLE_TOKEN_REFILL_RATE_PER_SECOND = "SEND_TASK_FAILURE_THROTTLE_TOKEN_REFILL_RATE_PER_SECOND"
    LIST_EXECUTIONS_THROTTLE_TOKEN_BUCKET_SIZE = "LIST_EXECUTIONS_THROTTLE_TOKEN_BUCKET_SIZE"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsStorageGatewayQuota")
class AwsStorageGatewayQuota(enum.Enum):
    CACHED_VOLUME_GATEWAY_UPLOAD_BUFFER_MAXIMUM_IN_TI_B = "CACHED_VOLUME_GATEWAY_UPLOAD_BUFFER_MAXIMUM_IN_TI_B"
    CACHED_VOLUMES_PER_GATEWAY = "CACHED_VOLUMES_PER_GATEWAY"
    CACHED_VOLUME_GATEWAY_CACHE_MINIMUM_IN_GI_B = "CACHED_VOLUME_GATEWAY_CACHE_MINIMUM_IN_GI_B"
    TAPE_GATEWAY_UPLOAD_BUFFER_MINIMUM_IN_GI_B = "TAPE_GATEWAY_UPLOAD_BUFFER_MINIMUM_IN_GI_B"
    STORED_VOLUME_SIZE_IN_TI_B = "STORED_VOLUME_SIZE_IN_TI_B"
    FILE_SIZE = "FILE_SIZE"
    TAPE_GATEWAY_CACHE_MAXIMUM_IN_TI_B = "TAPE_GATEWAY_CACHE_MAXIMUM_IN_TI_B"
    FILE_GATEWAY_CACHE_MINIMUM_IN_GI_B = "FILE_GATEWAY_CACHE_MINIMUM_IN_GI_B"
    STORED_VOLUME_GATEWAY_UPLOAD_BUFFER_MINIMUM_IN_GI_B = "STORED_VOLUME_GATEWAY_UPLOAD_BUFFER_MINIMUM_IN_GI_B"
    FILE_SHARES_PER_GATEWAY = "FILE_SHARES_PER_GATEWAY"
    STORED_VOLUMES_PER_GATEWAY = "STORED_VOLUMES_PER_GATEWAY"
    CACHED_VOLUME_GATEWAY_UPLOAD_BUFFER_MINIMUM_IN_GI_B = "CACHED_VOLUME_GATEWAY_UPLOAD_BUFFER_MINIMUM_IN_GI_B"
    FILE_SHARES_PER_S3_BUCKET = "FILE_SHARES_PER_S3_BUCKET"
    SIZE_OF_ALL_CACHED_VOLUMES_PER_GATEWAY_IN_TI_B = "SIZE_OF_ALL_CACHED_VOLUMES_PER_GATEWAY_IN_TI_B"
    MINIMUM_SIZE_OF_A_VIRTUAL_TAPE_IN_GI_B = "MINIMUM_SIZE_OF_A_VIRTUAL_TAPE_IN_GI_B"
    SIZE_OF_ALL_STORED_VOLUMES_PER_GATEWAY_IN_TI_B = "SIZE_OF_ALL_STORED_VOLUMES_PER_GATEWAY_IN_TI_B"
    TOTAL_SIZE_OF_TAPES_IN_A_VIRTUAL_TAPE_LIBRARY_IN_PI_B = "TOTAL_SIZE_OF_TAPES_IN_A_VIRTUAL_TAPE_LIBRARY_IN_PI_B"
    MAX_SIZE_OF_A_VIRTUAL_TAPE_IN_TI_B = "MAX_SIZE_OF_A_VIRTUAL_TAPE_IN_TI_B"
    CACHED_VOLUME_SIZE_IN_TI_B = "CACHED_VOLUME_SIZE_IN_TI_B"
    CACHED_VOLUME_GATEWAY_CACHE_MAXIMUM_IN_TI_B = "CACHED_VOLUME_GATEWAY_CACHE_MAXIMUM_IN_TI_B"
    STORED_VOLUME_GATEWAY_UPLOAD_BUFFER_MAXIMUM_IN_TI_B = "STORED_VOLUME_GATEWAY_UPLOAD_BUFFER_MAXIMUM_IN_TI_B"
    MAX_VIRTUAL_TAPES_IN_A_VTL = "MAX_VIRTUAL_TAPES_IN_A_VTL"
    TAPE_GATEWAY_CACHE_MINIMUM_IN_GI_B = "TAPE_GATEWAY_CACHE_MINIMUM_IN_GI_B"
    PATH_LENGTH = "PATH_LENGTH"
    TAPE_GATEWAY_UPLOAD_BUFFER_MAXIMUM_IN_TI_B = "TAPE_GATEWAY_UPLOAD_BUFFER_MAXIMUM_IN_TI_B"
    FILE_GATEWAY_CACHE_MAXIMUM_IN_TI_B = "FILE_GATEWAY_CACHE_MAXIMUM_IN_TI_B"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsSupplyChainQuota")
class AwsSupplyChainQuota(enum.Enum):
    ACTIVE_AND_PENDING_INVITATIONS = "ACTIVE_AND_PENDING_INVITATIONS"
    INSIGHTS_WATCHLISTS_PER_INSTANCE = "INSIGHTS_WATCHLISTS_PER_INSTANCE"
    INSIGHTS_WATCHLISTS_PER_USER = "INSIGHTS_WATCHLISTS_PER_USER"
    INSIGHTS_LINE_ITEMS_PER_WATCHLIST = "INSIGHTS_LINE_ITEMS_PER_WATCHLIST"
    ACTIVE_AWS_SUPPLY_CHAIN_CONNECTIONS_PER_INSTANCE = "ACTIVE_AWS_SUPPLY_CHAIN_CONNECTIONS_PER_INSTANCE"
    AWS_SUPPLY_CHAIN_DATA_INTEGRATION_FLOWS_PER_INSTANCE = "AWS_SUPPLY_CHAIN_DATA_INTEGRATION_FLOWS_PER_INSTANCE"
    ACTIVE_OR_INITIALIZING_AWS_SUPPLY_CHAIN_INSTANCES_PER_ACCOUNT = "ACTIVE_OR_INITIALIZING_AWS_SUPPLY_CHAIN_INSTANCES_PER_ACCOUNT"
    DATA_REQUESTS = "DATA_REQUESTS"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsSupportAppQuota")
class AwsSupportAppQuota(enum.Enum):
    AWS_ACCOUNTS_PER_SLACK_CHANNEL = "AWS_ACCOUNTS_PER_SLACK_CHANNEL"
    SLACK_WORKSPACE_CONFIGURATIONS_PER_AWS_ACCOUNT = "SLACK_WORKSPACE_CONFIGURATIONS_PER_AWS_ACCOUNT"
    SLACK_CHANNEL_CONFIGURATIONS_PER_AWS_ACCOUNT = "SLACK_CHANNEL_CONFIGURATIONS_PER_AWS_ACCOUNT"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsSupportQuota")
class AwsSupportQuota(enum.Enum):
    AWS_SUPPORT_API_OPERATIONS = "AWS_SUPPORT_API_OPERATIONS"
    AWS_TRUSTED_ADVISOR_API_OPERATIONS = "AWS_TRUSTED_ADVISOR_API_OPERATIONS"
    NUMBER_OF_AWS_SUPPORT_CASES_THAT_YOU_CAN_CREATE = "NUMBER_OF_AWS_SUPPORT_CASES_THAT_YOU_CAN_CREATE"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsSystemsManagerForSapQuota")
class AwsSystemsManagerForSapQuota(enum.Enum):
    DATABASES_PER_COMPONENT = "DATABASES_PER_COMPONENT"
    SAP_APPLICATIONS_PER_REGION_IN_ACCOUNT = "SAP_APPLICATIONS_PER_REGION_IN_ACCOUNT"
    COMPONENTS_PER_SAP_APPLICATION = "COMPONENTS_PER_SAP_APPLICATION"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsSystemsManagerGuiConnectQuota")
class AwsSystemsManagerGuiConnectQuota(enum.Enum):
    CONCURRENT_REMOTE_DESKTOP_CONNECTIONS = "CONCURRENT_REMOTE_DESKTOP_CONNECTIONS"


@jsii.enum(
    jsii_type="@reapit-cdk/service-quotas.AwsSystemsManagerIncidentManagerContactsQuota"
)
class AwsSystemsManagerIncidentManagerContactsQuota(enum.Enum):
    DESCRIBE_PAGE_API_THROTTLE_QUOTA = "DESCRIBE_PAGE_API_THROTTLE_QUOTA"
    START_ENGAGEMENT_API_THROTTLE_QUOTA = "START_ENGAGEMENT_API_THROTTLE_QUOTA"
    ROTATIONS_PER_SCHEDULE = "ROTATIONS_PER_SCHEDULE"
    LIST_PAGES_BY_ENGAGEMENT_API_THROTTLE_QUOTA = "LIST_PAGES_BY_ENGAGEMENT_API_THROTTLE_QUOTA"
    EMAIL_ENGAGEMENT_THROTTLE_QUOTA = "EMAIL_ENGAGEMENT_THROTTLE_QUOTA"
    LIST_PAGES_BY_CONTACT_API_THROTTLE_QUOTA = "LIST_PAGES_BY_CONTACT_API_THROTTLE_QUOTA"
    SMS_ENGAGEMENT_THROTTLE_QUOTA = "SMS_ENGAGEMENT_THROTTLE_QUOTA"
    LIST_ENGAGEMENTS_API_THROTTLE_QUOTA = "LIST_ENGAGEMENTS_API_THROTTLE_QUOTA"
    DESCRIBE_ENGAGEMENT_API_THROTTLE_QUOTA = "DESCRIBE_ENGAGEMENT_API_THROTTLE_QUOTA"
    CONTACT_CHANNELS_PER_STAGE = "CONTACT_CHANNELS_PER_STAGE"
    CONTACTS_PER_ACCOUNT = "CONTACTS_PER_ACCOUNT"
    STAGES_PER_PLAN = "STAGES_PER_PLAN"
    GET_CONTACT_API_THROTTLE_QUOTA = "GET_CONTACT_API_THROTTLE_QUOTA"
    NON_MUTATING_ROTATION_RELATED_API_THROTTLE_QUOTA = "NON_MUTATING_ROTATION_RELATED_API_THROTTLE_QUOTA"
    ALL_OTHER_OPERATIONS_API_THROTTLE_QUOTA = "ALL_OTHER_OPERATIONS_API_THROTTLE_QUOTA"
    VOICE_ENGAGEMENT_THROTTLE_QUOTA = "VOICE_ENGAGEMENT_THROTTLE_QUOTA"
    CONTACTS_PER_ROTATION = "CONTACTS_PER_ROTATION"
    LIST_PAGE_RECEIPTS_API_THROTTLE_QUOTA = "LIST_PAGE_RECEIPTS_API_THROTTLE_QUOTA"
    ACCEPT_PAGE_API_THROTTLE_QUOTA = "ACCEPT_PAGE_API_THROTTLE_QUOTA"
    STOP_ENGAGEMENT_API_THROTTLE_QUOTA = "STOP_ENGAGEMENT_API_THROTTLE_QUOTA"
    NON_MUTATING_SSM_CONTACTS_RELATED_API_THROTTLE_QUOTA = "NON_MUTATING_SSM_CONTACTS_RELATED_API_THROTTLE_QUOTA"
    ROTATIONS_PER_ACCOUNT = "ROTATIONS_PER_ACCOUNT"


@jsii.enum(
    jsii_type="@reapit-cdk/service-quotas.AwsSystemsManagerIncidentManagerQuota"
)
class AwsSystemsManagerIncidentManagerQuota(enum.Enum):
    ALL_OTHER_OPERATIONS_REQUESTS_PER_SECOND = "ALL_OTHER_OPERATIONS_REQUESTS_PER_SECOND"
    TIMELINE_EVENTS_PER_INCIDENT = "TIMELINE_EVENTS_PER_INCIDENT"
    UPDATE_DELETE_PROTECTION_REQUESTS_PER_SECOND = "UPDATE_DELETE_PROTECTION_REQUESTS_PER_SECOND"
    UPDATE_INCIDENT_RECORD_REQUESTS_PER_SECOND = "UPDATE_INCIDENT_RECORD_REQUESTS_PER_SECOND"
    LIST_TIMELINE_EVENT_REQUESTS_PER_SECOND = "LIST_TIMELINE_EVENT_REQUESTS_PER_SECOND"
    DELETE_RESOURCE_POLICY_REQUESTS_PER_SECOND = "DELETE_RESOURCE_POLICY_REQUESTS_PER_SECOND"
    UPDATE_RELATED_ITEMS_REQUESTS_PER_SECOND = "UPDATE_RELATED_ITEMS_REQUESTS_PER_SECOND"
    START_INCIDENT_REQUESTS_PER_SECOND = "START_INCIDENT_REQUESTS_PER_SECOND"
    PUT_RESOURCE_POLICY_REQUESTS_PER_SECOND = "PUT_RESOURCE_POLICY_REQUESTS_PER_SECOND"
    UPDATE_TIMELINE_EVENT_REQUESTS_PER_SECOND = "UPDATE_TIMELINE_EVENT_REQUESTS_PER_SECOND"
    UPDATE_RESPONSE_PLAN_REQUESTS_PER_SECOND = "UPDATE_RESPONSE_PLAN_REQUESTS_PER_SECOND"
    CREATE_REPLICATION_SET_REQUESTS_PER_SECOND = "CREATE_REPLICATION_SET_REQUESTS_PER_SECOND"
    UNTAG_RESOURCE_REQUESTS_PER_SECOND = "UNTAG_RESOURCE_REQUESTS_PER_SECOND"
    DELETE_TIMELINE_EVENT_REQUESTS_PER_SECOND = "DELETE_TIMELINE_EVENT_REQUESTS_PER_SECOND"
    DELETE_RESPONSE_PLAN_REQUESTS_PER_SECOND = "DELETE_RESPONSE_PLAN_REQUESTS_PER_SECOND"
    UPDATE_REPLICATION_SET_REQUESTS_PER_SECOND = "UPDATE_REPLICATION_SET_REQUESTS_PER_SECOND"
    GET_TIMELINE_EVENT_REQUESTS_PER_SECOND = "GET_TIMELINE_EVENT_REQUESTS_PER_SECOND"
    RELATED_ITEMS_PER_INCIDENT = "RELATED_ITEMS_PER_INCIDENT"
    REPLICATION_SETS_PER_ACCOUNT = "REPLICATION_SETS_PER_ACCOUNT"
    INCIDENTS_PER_RESPONSE_PLAN_PER_MONTH = "INCIDENTS_PER_RESPONSE_PLAN_PER_MONTH"
    CREATE_TIMELINE_EVENT_REQUESTS_PER_SECOND = "CREATE_TIMELINE_EVENT_REQUESTS_PER_SECOND"
    CREATE_RESPONSE_PLAN_REQUESTS_PER_SECOND = "CREATE_RESPONSE_PLAN_REQUESTS_PER_SECOND"
    DELETE_INCIDENT_RECORD_REQUESTS_PER_SECOND = "DELETE_INCIDENT_RECORD_REQUESTS_PER_SECOND"
    TAG_RESOURCE_REQUESTS_PER_SECOND = "TAG_RESOURCE_REQUESTS_PER_SECOND"
    DELETE_REPLICATION_SET_REQUESTS_PER_SECOND = "DELETE_REPLICATION_SET_REQUESTS_PER_SECOND"
    REGIONS_PER_REPLICATION_SET = "REGIONS_PER_REPLICATION_SET"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsSystemsManagerQuota")
class AwsSystemsManagerQuota(enum.Enum):
    MAINTENANCE_WINDOWS = "MAINTENANCE_WINDOWS"
    TARGETS_PER_MAINTENANCE_WINDOW = "TARGETS_PER_MAINTENANCE_WINDOW"
    CONCURRENTLY_RUNNING_AUTOMATIONS_WITH_BLOCKING_ACTIONS = "CONCURRENTLY_RUNNING_AUTOMATIONS_WITH_BLOCKING_ACTIONS"
    MAINTENANCE_WINDOW_EXECUTION_HISTORY_RETENTION = "MAINTENANCE_WINDOW_EXECUTION_HISTORY_RETENTION"
    SINGLE_MAINTENANCE_WINDOW_CONCURRENT_EXECUTIONS = "SINGLE_MAINTENANCE_WINDOW_CONCURRENT_EXECUTIONS"
    CONCURRENTLY_EXECUTING_RATE_CONTROL_AUTOMATION = "CONCURRENTLY_EXECUTING_RATE_CONTROL_AUTOMATION"
    NUMBER_OF_LEVELS_OF_NESTED_AUTOMATION = "NUMBER_OF_LEVELS_OF_NESTED_AUTOMATION"
    TARGET_GROUPS_PER_MAINTENANCE_WINDOW_TARGET_OR_TASK = "TARGET_GROUPS_PER_MAINTENANCE_WINDOW_TARGET_OR_TASK"
    ADDITIONAL_RATE_CONTROL_AUTOMATION_EXECUTIONS_THAT_CAN_BE_QUEUED = "ADDITIONAL_RATE_CONTROL_AUTOMATION_EXECUTIONS_THAT_CAN_BE_QUEUED"
    PATCH_BASELINES = "PATCH_BASELINES"
    TASKS_PER_MAINTENANCE_WINDOW = "TASKS_PER_MAINTENANCE_WINDOW"
    MAINTENANCE_WINDOW_CONCURRENT_EXECUTIONS = "MAINTENANCE_WINDOW_CONCURRENT_EXECUTIONS"
    CONCURRENTLY_EXECUTING_AUTOMATIONS = "CONCURRENTLY_EXECUTING_AUTOMATIONS"
    PATCH_GROUPS_PER_PATCH_BASELINE = "PATCH_GROUPS_PER_PATCH_BASELINE"
    TRANSACTIONS_PER_SECOND_TPS_FOR_THE_START_AUTOMATION_EXECUTION_API = "TRANSACTIONS_PER_SECOND_TPS_FOR_THE_START_AUTOMATION_EXECUTION_API"
    INSTANCES_PER_TARGET = "INSTANCES_PER_TARGET"
    ADDITIONAL_AUTOMATION_EXECUTIONS_THAT_CAN_BE_QUEUED = "ADDITIONAL_AUTOMATION_EXECUTIONS_THAT_CAN_BE_QUEUED"
    TOTAL_OPS_ITEMS = "TOTAL_OPS_ITEMS"
    INVENTORY_DATA_RETENTION_PERIOD = "INVENTORY_DATA_RETENTION_PERIOD"
    CUSTOM_INVENTORY_TYPES = "CUSTOM_INVENTORY_TYPES"
    INVENTORY_ITEM_DATA_SIZE_PER_DAY = "INVENTORY_ITEM_DATA_SIZE_PER_DAY"
    CUSTOM_INVENTORY_TYPE_ATTRIBUTES = "CUSTOM_INVENTORY_TYPE_ATTRIBUTES"
    CONCURRENT_STATE_MANAGER_ASSOCIATIONS_PER_REGION = "CONCURRENT_STATE_MANAGER_ASSOCIATIONS_PER_REGION"
    OPS_ITEMS_PER_MONTH = "OPS_ITEMS_PER_MONTH"
    RUN_COMMAND_EXECUTION_HISTORY_RETENTION_IN_SECONDS = "RUN_COMMAND_EXECUTION_HISTORY_RETENTION_IN_SECONDS"
    INVENTORY_DATA_SIZE_PER_REQUEST = "INVENTORY_DATA_SIZE_PER_REQUEST"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsTelcoNetworkBuilderQuota")
class AwsTelcoNetworkBuilderQuota(enum.Enum):
    FUNCTION_PACKAGES = "FUNCTION_PACKAGES"
    NETWORK_SERVICE_INSTANCES = "NETWORK_SERVICE_INSTANCES"
    CONCURRENT_ONGOING_NETWORK_SERVICE_OPERATIONS = "CONCURRENT_ONGOING_NETWORK_SERVICE_OPERATIONS"
    NETWORK_PACKAGES = "NETWORK_PACKAGES"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsTransferFamilyQuota")
class AwsTransferFamilyQuota(enum.Enum):
    NEW_EXECUTIONS_REFILL_RATE_PER_WORKFLOW_PER_SECOND = "NEW_EXECUTIONS_REFILL_RATE_PER_WORKFLOW_PER_SECOND"
    CONCURRENT_SESSIONS_PER_SERVER = "CONCURRENT_SESSIONS_PER_SERVER"
    NUMBER_OF_AUTHENTICATION_REQUESTS_PER_USER_PER_SECOND = "NUMBER_OF_AUTHENTICATION_REQUESTS_PER_USER_PER_SECOND"
    PROFILES_PER_ACCOUNT = "PROFILES_PER_ACCOUNT"
    FILE_SIZE = "FILE_SIZE"
    IDLE_CONNECTION_TIMEOUT = "IDLE_CONNECTION_TIMEOUT"
    NUMBER_OF_FILES_PER_START_FILE_TRANSFER_REQUEST = "NUMBER_OF_FILES_PER_START_FILE_TRANSFER_REQUEST"
    AGREEMENTS_PER_SERVER = "AGREEMENTS_PER_SERVER"
    NUMBER_OF_SERVICE_MANAGED_USERS_PER_SERVER = "NUMBER_OF_SERVICE_MANAGED_USERS_PER_SERVER"
    RATE_OF_START_FILE_TRANSFER_REQUESTS_PER_CONNECTOR = "RATE_OF_START_FILE_TRANSFER_REQUESTS_PER_CONNECTOR"
    VPC_ENDPOINT_SERVERS_PER_ACCOUNT = "VPC_ENDPOINT_SERVERS_PER_ACCOUNT"
    MAXIMUM_OUTBOUND_AS2_MESSAGE_SIZE = "MAXIMUM_OUTBOUND_AS2_MESSAGE_SIZE"
    CERTIFICATES_PER_ACCOUNT = "CERTIFICATES_PER_ACCOUNT"
    CONNECTORS_PER_ACCOUNT = "CONNECTORS_PER_ACCOUNT"
    RATE_OF_AS2_MESSAGES_PER_SERVER = "RATE_OF_AS2_MESSAGES_PER_SERVER"
    SERVERS_PER_ACCOUNT = "SERVERS_PER_ACCOUNT"
    CONCURRENT_MULTIPLEXED_SFTP_SESSIONS_PER_CONNECTION = "CONCURRENT_MULTIPLEXED_SFTP_SESSIONS_PER_CONNECTION"
    WORKFLOWS_PER_ACCOUNT = "WORKFLOWS_PER_ACCOUNT"
    MAXIMUM_INBOUND_AS2_MESSAGE_SIZE = "MAXIMUM_INBOUND_AS2_MESSAGE_SIZE"
    SSH_KEYS_PER_SERVICE_MANAGED_USER = "SSH_KEYS_PER_SERVICE_MANAGED_USER"
    MAXIMUM_NUMBER_OF_AD_GROUPS_FOR_ACCESS = "MAXIMUM_NUMBER_OF_AD_GROUPS_FOR_ACCESS"
    CERTIFICATES_PER_PROFILE = "CERTIFICATES_PER_PROFILE"
    MAXIMUM_NUMBER_OF_NEW_EXECUTIONS_PER_WORKFLOW = "MAXIMUM_NUMBER_OF_NEW_EXECUTIONS_PER_WORKFLOW"
    CONCURRENT_AS2_MESSAGES_PER_CONNECTOR = "CONCURRENT_AS2_MESSAGES_PER_CONNECTOR"
    CONCURRENT_AS2_MESSAGES_PER_SERVER = "CONCURRENT_AS2_MESSAGES_PER_SERVER"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsTrustedAdvisorQuota")
class AwsTrustedAdvisorQuota(enum.Enum):
    RATE_OF_LIST_ORGANIZATION_RECOMMENDATIONS_API_REQUESTS = "RATE_OF_LIST_ORGANIZATION_RECOMMENDATIONS_API_REQUESTS"
    RATE_OF_LIST_ORGANIZATION_RECOMMENDATION_RESOURCES_API_REQUESTS = "RATE_OF_LIST_ORGANIZATION_RECOMMENDATION_RESOURCES_API_REQUESTS"
    RATE_OF_UPDATE_ORGANIZATION_RECOMMENDATION_LIFECYCLE_API_REQUESTS = "RATE_OF_UPDATE_ORGANIZATION_RECOMMENDATION_LIFECYCLE_API_REQUESTS"
    RATE_OF_GET_RECOMMENDATION_API_REQUESTS = "RATE_OF_GET_RECOMMENDATION_API_REQUESTS"
    RATE_OF_LIST_CHECKS_API_REQUESTS = "RATE_OF_LIST_CHECKS_API_REQUESTS"
    RATE_OF_LIST_ORGANIZATION_RECOMMENDATION_ACCOUNTS_API_REQUESTS = "RATE_OF_LIST_ORGANIZATION_RECOMMENDATION_ACCOUNTS_API_REQUESTS"
    RATE_OF_LIST_RECOMMENDATION_RESOURCES_API_REQUESTS = "RATE_OF_LIST_RECOMMENDATION_RESOURCES_API_REQUESTS"
    RATE_OF_GET_ORGANIZATION_RECOMMENDATION_API_REQUESTS = "RATE_OF_GET_ORGANIZATION_RECOMMENDATION_API_REQUESTS"
    RATE_OF_LIST_RECOMMENDATIONS_API_REQUESTS = "RATE_OF_LIST_RECOMMENDATIONS_API_REQUESTS"
    RATE_OF_UPDATE_RECOMMENDATION_LIFECYCLE_API_REQUESTS = "RATE_OF_UPDATE_RECOMMENDATION_LIFECYCLE_API_REQUESTS"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsUserNotificationsQuota")
class AwsUserNotificationsQuota(enum.Enum):
    CHANNELS_FOR_A_GIVEN_NOTIFICATION_CONFIGURATION = "CHANNELS_FOR_A_GIVEN_NOTIFICATION_CONFIGURATION"
    EMAIL_CONTACTS = "EMAIL_CONTACTS"
    NOTIFICATION_HUBS = "NOTIFICATION_HUBS"
    RATE_OF_SOURCE_EVENTS_FOR_A_GIVEN_AWS_ACCOUNT = "RATE_OF_SOURCE_EVENTS_FOR_A_GIVEN_AWS_ACCOUNT"
    EVENT_RULES_FOR_A_GIVEN_NOTIFICATION_CONFIGURATION = "EVENT_RULES_FOR_A_GIVEN_NOTIFICATION_CONFIGURATION"
    NOTIFICATION_CONFIGURATIONS_PER_SERVICE_AND_EVENT_TYPE = "NOTIFICATION_CONFIGURATIONS_PER_SERVICE_AND_EVENT_TYPE"
    NOTIFICATION_CONFIGURATIONS_FOR_A_SINGLE_SERVICE = "NOTIFICATION_CONFIGURATIONS_FOR_A_SINGLE_SERVICE"
    NOTIFICATION_CONFIGURATIONS_TOTAL_FOR_AN_AWS_ACCOUNT = "NOTIFICATION_CONFIGURATIONS_TOTAL_FOR_AN_AWS_ACCOUNT"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsWafClassicGlobalQuota")
class AwsWafClassicGlobalQuota(enum.Enum):
    HTTP_HEADER_NAME_LENGTH = "HTTP_HEADER_NAME_LENGTH"
    GEO_MATCH_SETS = "GEO_MATCH_SETS"
    RULES_PER_WEB_ACL = "RULES_PER_WEB_ACL"
    RULES = "RULES"
    WEB_AC_LS = "WEB_AC_LS"
    PATTERN_SETS_PER_REGEX_MATCH_CONDITION = "PATTERN_SETS_PER_REGEX_MATCH_CONDITION"
    IP_ADDRESSES_BLOCKED_PER_RATE_BASED_RULE = "IP_ADDRESSES_BLOCKED_PER_RATE_BASED_RULE"
    REGEX_PATTERN_LENGTH = "REGEX_PATTERN_LENGTH"
    LOGGING_DESTINATION_CONFIGURATIONS_PER_WEB_ACL = "LOGGING_DESTINATION_CONFIGURATIONS_PER_WEB_ACL"
    FILTERS_PER_SQL_INJECTION_MATCH_CONDITION = "FILTERS_PER_SQL_INJECTION_MATCH_CONDITION"
    CONDITIONS_PER_RULE = "CONDITIONS_PER_RULE"
    REQUESTS_PER_SECOND_PER_DISTRIBUTION_BY_WEB_ACL = "REQUESTS_PER_SECOND_PER_DISTRIBUTION_BY_WEB_ACL"
    IP_ADDRESS_RANGES_PER_IP_SET_MATCH_CONDITION = "IP_ADDRESS_RANGES_PER_IP_SET_MATCH_CONDITION"
    RATE_BASED_RULES = "RATE_BASED_RULES"
    FILTERS_PER_SIZE_CONSTRAINT_CONDITION = "FILTERS_PER_SIZE_CONSTRAINT_CONDITION"
    RATE_BASED_RULE_RATE = "RATE_BASED_RULE_RATE"
    FILTERS_PER_STRING_MATCH_CONDITION = "FILTERS_PER_STRING_MATCH_CONDITION"
    FILTERS_PER_CROSS_SITE_SCRIPTING_MATCH_CONDITION = "FILTERS_PER_CROSS_SITE_SCRIPTING_MATCH_CONDITION"
    LOCATIONS_PER_GEO_MATCH_SET = "LOCATIONS_PER_GEO_MATCH_SET"
    SEARCH_LENGTH = "SEARCH_LENGTH"
    REGEX_PATTERN_SETS = "REGEX_PATTERN_SETS"
    PATTERNS_PER_PATTERN_SET = "PATTERNS_PER_PATTERN_SET"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsWafClassicRegionalQuota")
class AwsWafClassicRegionalQuota(enum.Enum):
    REGEX_PATTERN_LENGTH = "REGEX_PATTERN_LENGTH"
    SEARCH_LENGTH = "SEARCH_LENGTH"
    GEO_MATCH_SETS = "GEO_MATCH_SETS"
    FILTERS_PER_SQL_INJECTION_MATCH_CONDITION = "FILTERS_PER_SQL_INJECTION_MATCH_CONDITION"
    RULES_PER_WEB_ACL = "RULES_PER_WEB_ACL"
    FILTERS_PER_CROSS_SITE_SCRIPTING_MATCH_CONDITION = "FILTERS_PER_CROSS_SITE_SCRIPTING_MATCH_CONDITION"
    FILTERS_PER_SIZE_CONSTRAINT_CONDITION = "FILTERS_PER_SIZE_CONSTRAINT_CONDITION"
    PATTERNS_PER_PATTERN_SET = "PATTERNS_PER_PATTERN_SET"
    RATE_OF_REQUESTS = "RATE_OF_REQUESTS"
    CONDITIONS_PER_RULE = "CONDITIONS_PER_RULE"
    RULES = "RULES"
    LOGGING_DESTINATION_CONFIGURATIONS_PER_WEB_ACL = "LOGGING_DESTINATION_CONFIGURATIONS_PER_WEB_ACL"
    RATE_BASED_RULE_RATE = "RATE_BASED_RULE_RATE"
    REGEX_PATTERN_SETS = "REGEX_PATTERN_SETS"
    FILTERS_PER_STRING_MATCH_CONDITION = "FILTERS_PER_STRING_MATCH_CONDITION"
    IP_ADDRESSES_BLOCKED_PER_RATE_BASED_RULE = "IP_ADDRESSES_BLOCKED_PER_RATE_BASED_RULE"
    RATE_BASED_RULES = "RATE_BASED_RULES"
    LOCATIONS_PER_GEO_MATCH_SET = "LOCATIONS_PER_GEO_MATCH_SET"
    IP_ADDRESS_RANGES_PER_IP_SET_MATCH_CONDITION = "IP_ADDRESS_RANGES_PER_IP_SET_MATCH_CONDITION"
    PATTERN_SETS_PER_REGEX_MATCH_CONDITION = "PATTERN_SETS_PER_REGEX_MATCH_CONDITION"
    WEB_AC_LS = "WEB_AC_LS"
    HTTP_HEADER_NAME_LENGTH = "HTTP_HEADER_NAME_LENGTH"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsWafQuota")
class AwsWafQuota(enum.Enum):
    MAXIMUM_COMBINED_SIZE_IN_KILOBYTES_OF_ALL_RESPONSE_BODY_CONTENT_FOR_A_SINGLE_RULE_GROUP_OR_A_SINGLE_WEB_ACL_FOR_CLOUD_FRONT = "MAXIMUM_COMBINED_SIZE_IN_KILOBYTES_OF_ALL_RESPONSE_BODY_CONTENT_FOR_A_SINGLE_RULE_GROUP_OR_A_SINGLE_WEB_ACL_FOR_CLOUD_FRONT"
    MAXIMUM_NUMBER_OF_WEB_ACL_CAPACITY_UNITS_IN_A_RULE_GROUP_IN_WAF_FOR_CLOUD_FRONT = "MAXIMUM_NUMBER_OF_WEB_ACL_CAPACITY_UNITS_IN_A_RULE_GROUP_IN_WAF_FOR_CLOUD_FRONT"
    MAXIMUM_NUMBER_OF_LOG_DESTINATION_CONFIGS_PER_WEB_ACL_IN_WAF_FOR_CLOUDFRONT = "MAXIMUM_NUMBER_OF_LOG_DESTINATION_CONFIGS_PER_WEB_ACL_IN_WAF_FOR_CLOUDFRONT"
    MAXIMUM_REGEX_PATTERN_SETS_PER_ACCOUNT_IN_WAF_FOR_CLOUD_FRONT = "MAXIMUM_REGEX_PATTERN_SETS_PER_ACCOUNT_IN_WAF_FOR_CLOUD_FRONT"
    MAXIMUM_SIZE_IN_KILOBYTES_OF_THE_CUSTOM_RESPONSE_BODY_CONTENT_FOR_A_SINGLE_CUSTOM_RESPONSE_DEFINITION_FOR_CLOUD_FRONT = "MAXIMUM_SIZE_IN_KILOBYTES_OF_THE_CUSTOM_RESPONSE_BODY_CONTENT_FOR_A_SINGLE_CUSTOM_RESPONSE_DEFINITION_FOR_CLOUD_FRONT"
    MAXIMUM_RULE_GROUPS_PER_ACCOUNT_IN_WAF_FOR_REGIONAL = "MAXIMUM_RULE_GROUPS_PER_ACCOUNT_IN_WAF_FOR_REGIONAL"
    MAXIMUM_NUMBER_OF_CUSTOM_RESPONSE_HEADERS_PER_WEB_ACL_OR_RULE_GROUP_FOR_CLOUD_FRONT = "MAXIMUM_NUMBER_OF_CUSTOM_RESPONSE_HEADERS_PER_WEB_ACL_OR_RULE_GROUP_FOR_CLOUD_FRONT"
    MAXIMUM_NUMBER_OF_PATTERNS_IN_A_REGEX_PATTERN_SET_PER_ACCOUNT_IN_WAF_FOR_CLOUDFRONT = "MAXIMUM_NUMBER_OF_PATTERNS_IN_A_REGEX_PATTERN_SET_PER_ACCOUNT_IN_WAF_FOR_CLOUDFRONT"
    MAXIMUM_NUMBER_OF_WEB_ACL_CAPACITY_UNITS_IN_A_WEB_ACL_IN_WAF_FOR_REGIONAL = "MAXIMUM_NUMBER_OF_WEB_ACL_CAPACITY_UNITS_IN_A_WEB_ACL_IN_WAF_FOR_REGIONAL"
    MAXIMUM_IP_SETS_PER_ACCOUNT_IN_WAF_FOR_CLOUD_FRONT = "MAXIMUM_IP_SETS_PER_ACCOUNT_IN_WAF_FOR_CLOUD_FRONT"
    MAXIMUM_NUMBER_OF_CUSTOM_HEADERS_FOR_A_SINGLE_CUSTOM_REQUEST_DEFINITION_FOR_REGIONAL = "MAXIMUM_NUMBER_OF_CUSTOM_HEADERS_FOR_A_SINGLE_CUSTOM_REQUEST_DEFINITION_FOR_REGIONAL"
    MAXIMUM_NUMBER_OF_CUSTOM_HEADERS_FOR_A_SINGLE_CUSTOM_RESPONSE_DEFINITION_FOR_CLOUD_FRONT = "MAXIMUM_NUMBER_OF_CUSTOM_HEADERS_FOR_A_SINGLE_CUSTOM_RESPONSE_DEFINITION_FOR_CLOUD_FRONT"
    MAXIMUM_COMBINED_SIZE_IN_KILOBYTES_OF_ALL_RESPONSE_BODY_CONTENT_FOR_A_SINGLE_RULE_GROUP_OR_A_SINGLE_WEB_ACL_FOR_REGIONAL = "MAXIMUM_COMBINED_SIZE_IN_KILOBYTES_OF_ALL_RESPONSE_BODY_CONTENT_FOR_A_SINGLE_RULE_GROUP_OR_A_SINGLE_WEB_ACL_FOR_REGIONAL"
    MAXIMUM_NUMBER_OF_PATTERNS_IN_A_REGEX_PATTERN_SET_PER_ACCOUNT_IN_WAF_FOR_REGIONAL = "MAXIMUM_NUMBER_OF_PATTERNS_IN_A_REGEX_PATTERN_SET_PER_ACCOUNT_IN_WAF_FOR_REGIONAL"
    NUMBER_OF_TOKEN_DOMAINS_PER_WEB_ACL_FOR_CLOUD_FRONT = "NUMBER_OF_TOKEN_DOMAINS_PER_WEB_ACL_FOR_CLOUD_FRONT"
    MAXIMUM_NUMBER_OF_CUSTOM_HEADERS_FOR_A_SINGLE_CUSTOM_REQUEST_DEFINITION_FOR_CLOUD_FRONT = "MAXIMUM_NUMBER_OF_CUSTOM_HEADERS_FOR_A_SINGLE_CUSTOM_REQUEST_DEFINITION_FOR_CLOUD_FRONT"
    MAXIMUM_NUMBER_OF_RATE_BASED_STATEMENTS_PER_WEB_ACL_IN_WAF_FOR_CLOUDFRONT = "MAXIMUM_NUMBER_OF_RATE_BASED_STATEMENTS_PER_WEB_ACL_IN_WAF_FOR_CLOUDFRONT"
    MAXIMUM_NUMBER_OF_LOG_DESTINATION_CONFIGS_PER_WEB_ACL_IN_WAF_FOR_REGIONAL = "MAXIMUM_NUMBER_OF_LOG_DESTINATION_CONFIGS_PER_WEB_ACL_IN_WAF_FOR_REGIONAL"
    MAXIMUM_NUMBER_OF_UNIQUE_IP_ADDRESSES_THAT_CAN_BE_BLOCKED_PER_RATE_BASED_RULE_FOR_CLOUD_FRONT = "MAXIMUM_NUMBER_OF_UNIQUE_IP_ADDRESSES_THAT_CAN_BE_BLOCKED_PER_RATE_BASED_RULE_FOR_CLOUD_FRONT"
    MAXIMUM_NUMBER_OF_IP_ADDRESSES_IN_AN_IP_SET_IN_WAF_FOR_REGIONAL = "MAXIMUM_NUMBER_OF_IP_ADDRESSES_IN_AN_IP_SET_IN_WAF_FOR_REGIONAL"
    MAXIMUM_NUMBER_OF_CUSTOM_REQUEST_HEADERS_PER_WEB_ACL_OR_RULE_GROUP_FOR_CLOUD_FRONT = "MAXIMUM_NUMBER_OF_CUSTOM_REQUEST_HEADERS_PER_WEB_ACL_OR_RULE_GROUP_FOR_CLOUD_FRONT"
    MAXIMUM_NUMBER_OF_WEB_ACL_CAPACITY_UNITS_IN_A_RULE_GROUP_IN_WAF_FOR_REGIONAL = "MAXIMUM_NUMBER_OF_WEB_ACL_CAPACITY_UNITS_IN_A_RULE_GROUP_IN_WAF_FOR_REGIONAL"
    MAXIMUM_NUMBER_OF_TEXT_TRANSFORMATIONS_PER_RULE_STATEMENT_FOR_REGIONAL = "MAXIMUM_NUMBER_OF_TEXT_TRANSFORMATIONS_PER_RULE_STATEMENT_FOR_REGIONAL"
    MAXIMUM_NUMBER_OF_REQUESTS_PER_SECOND_PER_WEB_ACL_FOR_CLOUD_FRONT = "MAXIMUM_NUMBER_OF_REQUESTS_PER_SECOND_PER_WEB_ACL_FOR_CLOUD_FRONT"
    MAXIMUM_NUMBER_OF_CUSTOM_RESPONSE_BODIES_PER_WEB_ACL_OR_RULE_GROUP_FOR_REGIONAL = "MAXIMUM_NUMBER_OF_CUSTOM_RESPONSE_BODIES_PER_WEB_ACL_OR_RULE_GROUP_FOR_REGIONAL"
    NUMBER_OF_CLOUD_WATCH_LOGS_LOG_STREAMS_PER_WEB_ACL_FOR_REGIONAL = "NUMBER_OF_CLOUD_WATCH_LOGS_LOG_STREAMS_PER_WEB_ACL_FOR_REGIONAL"
    MAXIMUM_IP_SETS_PER_ACCOUNT_IN_WAF_FOR_REGIONAL = "MAXIMUM_IP_SETS_PER_ACCOUNT_IN_WAF_FOR_REGIONAL"
    MAXIMUM_NUMBER_OF_BYTES_IN_A_STRING_MATCH_BYTE_MATCH_STRING_IN_WAF_FOR_CLOUD_FRONT = "MAXIMUM_NUMBER_OF_BYTES_IN_A_STRING_MATCH_BYTE_MATCH_STRING_IN_WAF_FOR_CLOUD_FRONT"
    MAXIMUM_SIZE_IN_KILOBYTES_OF_THE_CUSTOM_RESPONSE_BODY_CONTENT_FOR_A_SINGLE_CUSTOM_RESPONSE_DEFINITION_FOR_REGIONAL = "MAXIMUM_SIZE_IN_KILOBYTES_OF_THE_CUSTOM_RESPONSE_BODY_CONTENT_FOR_A_SINGLE_CUSTOM_RESPONSE_DEFINITION_FOR_REGIONAL"
    MAXIMUM_NUMBER_OF_CHARACTERS_ALLOWED_IN_A_REGEX_PATTERN_PER_ACCOUNT_IN_WAF_FOR_REGIONAL = "MAXIMUM_NUMBER_OF_CHARACTERS_ALLOWED_IN_A_REGEX_PATTERN_PER_ACCOUNT_IN_WAF_FOR_REGIONAL"
    MAXIMUM_NUMBER_OF_CUSTOM_REQUEST_HEADERS_PER_WEB_ACL_OR_RULE_GROUP_FOR_REGIONAL = "MAXIMUM_NUMBER_OF_CUSTOM_REQUEST_HEADERS_PER_WEB_ACL_OR_RULE_GROUP_FOR_REGIONAL"
    MAXIMUM_NUMBER_OF_CUSTOM_RESPONSE_BODIES_PER_WEB_ACL_OR_RULE_GROUP_FOR_CLOUD_FRONT = "MAXIMUM_NUMBER_OF_CUSTOM_RESPONSE_BODIES_PER_WEB_ACL_OR_RULE_GROUP_FOR_CLOUD_FRONT"
    MINIMUM_REQUEST_RATE_THAT_CAN_BE_DEFINED_FOR_A_RATE_BASED_RULE_FOR_REGIONAL = "MINIMUM_REQUEST_RATE_THAT_CAN_BE_DEFINED_FOR_A_RATE_BASED_RULE_FOR_REGIONAL"
    MAXIMUM_NUMBER_OF_WEB_ACL_CAPACITY_UNITS_IN_A_WEB_ACL_IN_WAF_FOR_CLOUD_FRONT = "MAXIMUM_NUMBER_OF_WEB_ACL_CAPACITY_UNITS_IN_A_WEB_ACL_IN_WAF_FOR_CLOUD_FRONT"
    MAXIMUM_NUMBER_OF_REFERENCED_STATEMENTS_PER_RULE_GROUP_OR_WEB_ACL_IN_WAF_FOR_REGIONAL = "MAXIMUM_NUMBER_OF_REFERENCED_STATEMENTS_PER_RULE_GROUP_OR_WEB_ACL_IN_WAF_FOR_REGIONAL"
    MAXIMUM_NUMBER_OF_RATE_BASED_STATEMENTS_PER_WEB_ACL_IN_WAF_FOR_REGIONAL = "MAXIMUM_NUMBER_OF_RATE_BASED_STATEMENTS_PER_WEB_ACL_IN_WAF_FOR_REGIONAL"
    MAXIMUM_NUMBER_OF_REQUESTS_PER_SECOND_PER_WEB_ACL_FOR_REGIONAL = "MAXIMUM_NUMBER_OF_REQUESTS_PER_SECOND_PER_WEB_ACL_FOR_REGIONAL"
    MAXIMUM_SIZE_IN_KILOBYTES_OF_A_WEB_REQUEST_BODY_THAT_CAN_BE_INSPECTED_FOR_CLOUD_FRONT = "MAXIMUM_SIZE_IN_KILOBYTES_OF_A_WEB_REQUEST_BODY_THAT_CAN_BE_INSPECTED_FOR_CLOUD_FRONT"
    NUMBER_OF_CLOUD_WATCH_LOGS_LOG_STREAMS_PER_WEB_ACL_FOR_CLOUD_FRONT = "NUMBER_OF_CLOUD_WATCH_LOGS_LOG_STREAMS_PER_WEB_ACL_FOR_CLOUD_FRONT"
    MAXIMUM_REGEX_PATTERN_SETS_PER_ACCOUNT_IN_WAF_FOR_REGIONAL = "MAXIMUM_REGEX_PATTERN_SETS_PER_ACCOUNT_IN_WAF_FOR_REGIONAL"
    NUMBER_OF_TOKEN_DOMAINS_PER_WEB_ACL_FOR_REGIONAL = "NUMBER_OF_TOKEN_DOMAINS_PER_WEB_ACL_FOR_REGIONAL"
    MAXIMUM_SIZE_IN_KILOBYTES_OF_A_WEB_REQUEST_BODY_THAT_CAN_BE_INSPECTED_FOR_REGIONAL = "MAXIMUM_SIZE_IN_KILOBYTES_OF_A_WEB_REQUEST_BODY_THAT_CAN_BE_INSPECTED_FOR_REGIONAL"
    MAXIMUM_NUMBER_OF_BYTES_IN_A_STRING_MATCH_BYTE_MATCH_STRING_IN_WAF_FOR_REGIONAL = "MAXIMUM_NUMBER_OF_BYTES_IN_A_STRING_MATCH_BYTE_MATCH_STRING_IN_WAF_FOR_REGIONAL"
    MAXIMUM_NUMBER_OF_CHARACTERS_ALLOWED_IN_A_REGEX_PATTERN_PER_ACCOUNT_IN_WAF_FOR_CLOUDFRONT = "MAXIMUM_NUMBER_OF_CHARACTERS_ALLOWED_IN_A_REGEX_PATTERN_PER_ACCOUNT_IN_WAF_FOR_CLOUDFRONT"
    MAXIMUM_WEB_AC_LS_PER_ACCOUNT_IN_WAF_FOR_REGIONAL = "MAXIMUM_WEB_AC_LS_PER_ACCOUNT_IN_WAF_FOR_REGIONAL"
    MAXIMUM_NUMBER_OF_CUSTOM_HEADERS_FOR_A_SINGLE_CUSTOM_RESPONSE_DEFINITION_FOR_REGIONAL = "MAXIMUM_NUMBER_OF_CUSTOM_HEADERS_FOR_A_SINGLE_CUSTOM_RESPONSE_DEFINITION_FOR_REGIONAL"
    MAXIMUM_NUMBER_OF_REFERENCED_STATEMENTS_PER_RULE_GROUP_OR_WEB_ACL_IN_WAF_FOR_CLOUDFRONT = "MAXIMUM_NUMBER_OF_REFERENCED_STATEMENTS_PER_RULE_GROUP_OR_WEB_ACL_IN_WAF_FOR_CLOUDFRONT"
    MAXIMUM_NUMBER_OF_UNIQUE_IP_ADDRESSES_THAT_CAN_BE_BLOCKED_PER_RATE_BASED_RULE_FOR_REGIONAL = "MAXIMUM_NUMBER_OF_UNIQUE_IP_ADDRESSES_THAT_CAN_BE_BLOCKED_PER_RATE_BASED_RULE_FOR_REGIONAL"
    MINIMUM_REQUEST_RATE_THAT_CAN_BE_DEFINED_FOR_A_RATE_BASED_RULE_FOR_CLOUD_FRONT = "MINIMUM_REQUEST_RATE_THAT_CAN_BE_DEFINED_FOR_A_RATE_BASED_RULE_FOR_CLOUD_FRONT"
    MAXIMUM_RULE_GROUPS_PER_ACCOUNT_IN_WAF_FOR_CLOUD_FRONT = "MAXIMUM_RULE_GROUPS_PER_ACCOUNT_IN_WAF_FOR_CLOUD_FRONT"
    MAXIMUM_NUMBER_OF_TEXT_TRANSFORMATIONS_PER_RULE_STATEMENT_FOR_CLOUD_FRONT = "MAXIMUM_NUMBER_OF_TEXT_TRANSFORMATIONS_PER_RULE_STATEMENT_FOR_CLOUD_FRONT"
    MAXIMUM_NUMBER_OF_IP_ADDRESSES_IN_AN_IP_SET_IN_WAF_FOR_CLOUD_FRONT = "MAXIMUM_NUMBER_OF_IP_ADDRESSES_IN_AN_IP_SET_IN_WAF_FOR_CLOUD_FRONT"
    MAXIMUM_NUMBER_OF_CUSTOM_RESPONSE_HEADERS_PER_WEB_ACL_OR_RULE_GROUP_FOR_REGIONAL = "MAXIMUM_NUMBER_OF_CUSTOM_RESPONSE_HEADERS_PER_WEB_ACL_OR_RULE_GROUP_FOR_REGIONAL"
    MAXIMUM_WEB_AC_LS_PER_ACCOUNT_IN_WAF_FOR_CLOUD_FRONT = "MAXIMUM_WEB_AC_LS_PER_ACCOUNT_IN_WAF_FOR_CLOUD_FRONT"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsWellArchitectedToolQuota")
class AwsWellArchitectedToolQuota(enum.Enum):
    SHARES_PER_REVIEW_TEMPLATE = "SHARES_PER_REVIEW_TEMPLATE"
    LENSES_PER_REVIEW_TEMPLATE = "LENSES_PER_REVIEW_TEMPLATE"
    REVIEW_TEMPLATES_PER_ACCOUNT_PER_REGION = "REVIEW_TEMPLATES_PER_ACCOUNT_PER_REGION"
    CHOICES_PER_QUESTION = "CHOICES_PER_QUESTION"
    LENSES_PER_WORKLOAD = "LENSES_PER_WORKLOAD"
    PILLARS_PER_LENS = "PILLARS_PER_LENS"
    LENS_SIZE = "LENS_SIZE"
    VERSIONS_PER_LENS = "VERSIONS_PER_LENS"
    WORKLOADS_PER_ACCOUNT_PER_REGION = "WORKLOADS_PER_ACCOUNT_PER_REGION"
    SHARES_PER_LENS = "SHARES_PER_LENS"
    SHARES_PER_WORKLOAD = "SHARES_PER_WORKLOAD"
    LENSES_PER_ACCOUNT_PER_REGION = "LENSES_PER_ACCOUNT_PER_REGION"
    MILESTONES_PER_WORKLOAD = "MILESTONES_PER_WORKLOAD"
    QUESTIONS_PER_PILLAR = "QUESTIONS_PER_PILLAR"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.AwsXRayQuota")
class AwsXRayQuota(enum.Enum):
    SEGMENT_DOCUMENT_SIZE = "SEGMENT_DOCUMENT_SIZE"
    TRACE_DOCUMENT_SIZE_DYNAMIC_UPPER_LIMIT = "TRACE_DOCUMENT_SIZE_DYNAMIC_UPPER_LIMIT"
    TAGS_PER_GROUP = "TAGS_PER_GROUP"
    TRACE_AND_SERVICE_GRAPH_RETENTION_IN_DAYS = "TRACE_AND_SERVICE_GRAPH_RETENTION_IN_DAYS"
    TAGS_PER_CUSTOM_SAMPLING_RULE = "TAGS_PER_CUSTOM_SAMPLING_RULE"
    SEGMENTS_PER_SECOND = "SEGMENTS_PER_SECOND"
    CUSTOM_SAMPLING_RULES_PER_REGION = "CUSTOM_SAMPLING_RULES_PER_REGION"
    TRACE_DATA_MODIFICATION_PERIOD_IN_DAYS = "TRACE_DATA_MODIFICATION_PERIOD_IN_DAYS"
    GROUPS_IN_AN_ACCOUNT = "GROUPS_IN_AN_ACCOUNT"
    INDEXED_ANNOTATIONS_PER_TRACE = "INDEXED_ANNOTATIONS_PER_TRACE"
    TRACE_DOCUMENT_SIZE_LOWER_LIMIT = "TRACE_DOCUMENT_SIZE_LOWER_LIMIT"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.B2BDataInterchangeQuota")
class B2BDataInterchangeQuota(enum.Enum):
    TRANSFORMERS = "TRANSFORMERS"
    PARTNERSHIPS = "PARTNERSHIPS"
    CAPABILITIES = "CAPABILITIES"
    PROFILES = "PROFILES"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.CloudWatchInternetMonitorQuota")
class CloudWatchInternetMonitorQuota(enum.Enum):
    MONITORS_PER_ACCOUNT_PER_AWS_REGION = "MONITORS_PER_ACCOUNT_PER_AWS_REGION"
    DAYS_THAT_HEALTH_EVENTS_ARE_RETAINED = "DAYS_THAT_HEALTH_EVENTS_ARE_RETAINED"
    RESOURCES_PER_MONITOR = "RESOURCES_PER_MONITOR"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.Ec2FastLaunchQuota")
class Ec2FastLaunchQuota(enum.Enum):
    PARALLEL_INSTANCE_LAUNCHES = "PARALLEL_INSTANCE_LAUNCHES"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.Ec2ImageBuilderQuota")
class Ec2ImageBuilderQuota(enum.Enum):
    COMPONENT_SIZE = "COMPONENT_SIZE"
    IMAGE_RECIPES = "IMAGE_RECIPES"
    DOCKER_TEMPLATE_SIZE = "DOCKER_TEMPLATE_SIZE"
    CONCURRENT_AMI_COPIES_PER_DISTRIBUTION_CONFIGURATION = "CONCURRENT_AMI_COPIES_PER_DISTRIBUTION_CONFIGURATION"
    PARAMETERS_PER_IMAGE_WORKFLOW = "PARAMETERS_PER_IMAGE_WORKFLOW"
    IMAGE_WORKFLOW_SIZE = "IMAGE_WORKFLOW_SIZE"
    CONCURRENT_RESOURCE_STATE_UPDATE = "CONCURRENT_RESOURCE_STATE_UPDATE"
    LAUNCH_TEMPLATES_MODIFIED_PER_DISTRIBUTION_CONFIGURATION = "LAUNCH_TEMPLATES_MODIFIED_PER_DISTRIBUTION_CONFIGURATION"
    LIFECYCLE_POLICIES = "LIFECYCLE_POLICIES"
    DISTRIBUTION_CONFIGURATIONS = "DISTRIBUTION_CONFIGURATIONS"
    PARAMETERS_PER_COMPONENT = "PARAMETERS_PER_COMPONENT"
    COMPONENT_PARAMETER_LENGTH = "COMPONENT_PARAMETER_LENGTH"
    COMPONENTS_PER_IMAGE_RECIPE = "COMPONENTS_PER_IMAGE_RECIPE"
    IMAGE_WORKFLOWS = "IMAGE_WORKFLOWS"
    IMAGE_WORKFLOW_PARAMETER = "IMAGE_WORKFLOW_PARAMETER"
    INFRASTRUCTURE_CONFIGURATIONS = "INFRASTRUCTURE_CONFIGURATIONS"
    COMPONENTS = "COMPONENTS"
    STEPS_PER_IMAGE_WORKFLOW = "STEPS_PER_IMAGE_WORKFLOW"
    IMAGE_WORKFLOWS_PER_IMAGE = "IMAGE_WORKFLOWS_PER_IMAGE"
    IMAGE_PIPELINES = "IMAGE_PIPELINES"
    CONTAINER_RECIPES = "CONTAINER_RECIPES"
    CONCURRENT_BUILDS = "CONCURRENT_BUILDS"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.Ec2VmImportExportQuota")
class Ec2VmImportExportQuota(enum.Enum):
    CONCURRENT_TASK_LIMIT_FOR_IMPORT_INSTANCE_IMPORT_VOLUME_AND_CREATE_INSTANCE_EXPORT_TASK = "CONCURRENT_TASK_LIMIT_FOR_IMPORT_INSTANCE_IMPORT_VOLUME_AND_CREATE_INSTANCE_EXPORT_TASK"
    CONCURRENT_TASK_LIMIT_FOR_IMPORT_IMAGE_IMPORT_SNAPSHOT_AND_EXPORT_IMAGE = "CONCURRENT_TASK_LIMIT_FOR_IMPORT_IMAGE_IMPORT_SNAPSHOT_AND_EXPORT_IMAGE"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.ElasticDisasterRecoveryQuota")
class ElasticDisasterRecoveryQuota(enum.Enum):
    MAX_SOURCE_SERVERS_IN_ALL_JOBS = "MAX_SOURCE_SERVERS_IN_ALL_JOBS"
    MAX_TOTAL_REPLICATING_SOURCE_SERVERS_PER_AWS_ACCOUNT = "MAX_TOTAL_REPLICATING_SOURCE_SERVERS_PER_AWS_ACCOUNT"
    CONCURRENT_JOBS_IN_PROGRESS = "CONCURRENT_JOBS_IN_PROGRESS"
    MAX_NUMBER_OF_SOURCE_NETWORKS_PER_AWS_ACCOUNT = "MAX_NUMBER_OF_SOURCE_NETWORKS_PER_AWS_ACCOUNT"
    MAX_NUMBER_OF_LAUNCH_CONFIGURATION_TEMPLATES_PER_AWS_ACCOUNT = "MAX_NUMBER_OF_LAUNCH_CONFIGURATION_TEMPLATES_PER_AWS_ACCOUNT"
    MAX_SOURCE_SERVERS_IN_A_SINGLE_JOB = "MAX_SOURCE_SERVERS_IN_A_SINGLE_JOB"
    MAX_CONCURRENT_JOBS_PER_SOURCE_SERVER = "MAX_CONCURRENT_JOBS_PER_SOURCE_SERVER"
    MAX_TOTAL_SOURCE_SERVERS_PER_AWS_ACCOUNT = "MAX_TOTAL_SOURCE_SERVERS_PER_AWS_ACCOUNT"
    MAX_NUMBER_OF_LAUNCH_ACTIONS_PER_RESOURCE = "MAX_NUMBER_OF_LAUNCH_ACTIONS_PER_RESOURCE"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.ElasticLoadBalancingElbQuota")
class ElasticLoadBalancingElbQuota(enum.Enum):
    TARGET_GROUPS_PER_APPLICATION_LOAD_BALANCER = "TARGET_GROUPS_PER_APPLICATION_LOAD_BALANCER"
    LISTENERS_PER_CLASSIC_LOAD_BALANCER = "LISTENERS_PER_CLASSIC_LOAD_BALANCER"
    CONDITION_VALUES_PER_RULE = "CONDITION_VALUES_PER_RULE"
    REGISTERED_INSTANCES_PER_CLASSIC_LOAD_BALANCER = "REGISTERED_INSTANCES_PER_CLASSIC_LOAD_BALANCER"
    CONDITION_WILDCARDS_PER_RULE = "CONDITION_WILDCARDS_PER_RULE"
    CERTIFICATES_PER_NETWORK_LOAD_BALANCER = "CERTIFICATES_PER_NETWORK_LOAD_BALANCER"
    NETWORK_LOAD_BALANCERS_PER_REGION = "NETWORK_LOAD_BALANCERS_PER_REGION"
    LISTENERS_PER_APPLICATION_LOAD_BALANCER = "LISTENERS_PER_APPLICATION_LOAD_BALANCER"
    TARGET_GROUPS_PER_ACTION_PER_APPLICATION_LOAD_BALANCER = "TARGET_GROUPS_PER_ACTION_PER_APPLICATION_LOAD_BALANCER"
    TARGET_GROUPS_PER_REGION = "TARGET_GROUPS_PER_REGION"
    APPLICATION_LOAD_BALANCERS_PER_REGION = "APPLICATION_LOAD_BALANCERS_PER_REGION"
    TARGETS_PER_TARGET_GROUP_PER_REGION = "TARGETS_PER_TARGET_GROUP_PER_REGION"
    TARGETS_PER_APPLICATION_LOAD_BALANCER = "TARGETS_PER_APPLICATION_LOAD_BALANCER"
    CERTIFICATES_PER_APPLICATION_LOAD_BALANCER = "CERTIFICATES_PER_APPLICATION_LOAD_BALANCER"
    TARGETS_PER_AVAILABILITY_ZONE_PER_NETWORK_LOAD_BALANCER = "TARGETS_PER_AVAILABILITY_ZONE_PER_NETWORK_LOAD_BALANCER"
    TARGETS_PER_NETWORK_LOAD_BALANCER = "TARGETS_PER_NETWORK_LOAD_BALANCER"
    LISTENERS_PER_NETWORK_LOAD_BALANCER = "LISTENERS_PER_NETWORK_LOAD_BALANCER"
    RULES_PER_APPLICATION_LOAD_BALANCER = "RULES_PER_APPLICATION_LOAD_BALANCER"
    TARGET_GROUPS_PER_ACTION_PER_NETWORK_LOAD_BALANCER = "TARGET_GROUPS_PER_ACTION_PER_NETWORK_LOAD_BALANCER"
    CLASSIC_LOAD_BALANCERS_PER_REGION = "CLASSIC_LOAD_BALANCERS_PER_REGION"
    NETWORK_LOAD_BALANCER_EN_IS_PER_VPC = "NETWORK_LOAD_BALANCER_EN_IS_PER_VPC"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.IamRolesAnywhereQuota")
class IamRolesAnywhereQuota(enum.Enum):
    TRUST_ANCHORS = "TRUST_ANCHORS"
    COMBINED_RATE_OF_SUBJECT_REQUESTS = "COMBINED_RATE_OF_SUBJECT_REQUESTS"
    COMBINED_RATE_OF_CRL_REQUESTS = "COMBINED_RATE_OF_CRL_REQUESTS"
    COMBINED_RATE_OF_TAGGING_REQUESTS = "COMBINED_RATE_OF_TAGGING_REQUESTS"
    RATE_OF_CREATE_SESSION_REQUESTS = "RATE_OF_CREATE_SESSION_REQUESTS"
    CR_LS_PER_TRUST_ANCHOR = "CR_LS_PER_TRUST_ANCHOR"
    COMBINED_RATE_OF_TRUST_ANCHOR_REQUESTS = "COMBINED_RATE_OF_TRUST_ANCHOR_REQUESTS"
    PROFILES = "PROFILES"
    CERTIFICATES_PER_TRUST_ANCHOR = "CERTIFICATES_PER_TRUST_ANCHOR"
    COMBINED_RATE_OF_PROFILE_REQUESTS = "COMBINED_RATE_OF_PROFILE_REQUESTS"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.IpamQuota")
class IpamQuota(enum.Enum):
    CID_RS_PER_IPAM_POOL = "CID_RS_PER_IPAM_POOL"
    IPAM_POOL_DEPTH = "IPAM_POOL_DEPTH"
    IPA_MS_PER_REGION = "IPA_MS_PER_REGION"
    RESOURCE_DISCOVERY_ASSOCIATIONS_PER_IPAM = "RESOURCE_DISCOVERY_ASSOCIATIONS_PER_IPAM"
    POOLS_PER_IPAM_SCOPE = "POOLS_PER_IPAM_SCOPE"
    SCOPES_PER_IPAM = "SCOPES_PER_IPAM"
    RESOURCE_DISCOVERIES_PER_REGION = "RESOURCE_DISCOVERIES_PER_REGION"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.ManagedStreamingForKafkaConnectQuota")
class ManagedStreamingForKafkaConnectQuota(enum.Enum):
    MAXIMUM_CUSTOM_PLUGINS = "MAXIMUM_CUSTOM_PLUGINS"
    MAXIMUM_WORKER_CONFIGURATIONS = "MAXIMUM_WORKER_CONFIGURATIONS"
    MAXIMUM_CONNECT_WORKERS = "MAXIMUM_CONNECT_WORKERS"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.MechanicalTurkQuota")
class MechanicalTurkQuota(enum.Enum):
    MONTHLY_USAGE = "MONTHLY_USAGE"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.MigrationHubOrchestratorQuota")
class MigrationHubOrchestratorQuota(enum.Enum):
    MAXIMUM_STEPS_PER_STEP_GROUP = "MAXIMUM_STEPS_PER_STEP_GROUP"
    MAXIMUM_STEP_GROUPS_PER_WORKFLOW = "MAXIMUM_STEP_GROUPS_PER_WORKFLOW"
    MAXIMUM_WORKFLOWS = "MAXIMUM_WORKFLOWS"


@jsii.enum(
    jsii_type="@reapit-cdk/service-quotas.MigrationHubStrategyRecommendationsQuota"
)
class MigrationHubStrategyRecommendationsQuota(enum.Enum):
    MAXIMUM_SERVER_PER_ASSESSMENT = "MAXIMUM_SERVER_PER_ASSESSMENT"
    ACTIVE_IMPORT_MAXIMUM = "ACTIVE_IMPORT_MAXIMUM"
    ACTIVE_ASSESSMENT_MAXIMUM = "ACTIVE_ASSESSMENT_MAXIMUM"
    ASSESSMENT_MAXIMUM = "ASSESSMENT_MAXIMUM"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.NetworkInsightsQuota")
class NetworkInsightsQuota(enum.Enum):
    REACHABILITY_ANALYZER_PATHS = "REACHABILITY_ANALYZER_PATHS"
    REACHABILITY_ANALYZER_CONCURRENT_ANALYSES = "REACHABILITY_ANALYZER_CONCURRENT_ANALYSES"
    REACHABILITY_ANALYZER_ANALYSES = "REACHABILITY_ANALYZER_ANALYSES"
    NETWORK_ACCESS_ANALYZER_ACCESS_SCOPE_ANALYSES = "NETWORK_ACCESS_ANALYZER_ACCESS_SCOPE_ANALYSES"
    NETWORK_ACCESS_ANALYZER_ACCESS_SCOPES = "NETWORK_ACCESS_ANALYZER_ACCESS_SCOPES"
    NETWORK_ACCESS_ANALYZER_CONCURRENT_ACCESS_SCOPE_ANALYSES = "NETWORK_ACCESS_ANALYZER_CONCURRENT_ACCESS_SCOPE_ANALYSES"


@jsii.enum(
    jsii_type="@reapit-cdk/service-quotas.PrivateCaConnectorForActiveDirectoryQuota"
)
class PrivateCaConnectorForActiveDirectoryQuota(enum.Enum):
    RATE_OF_LIST_TAGS_FOR_RESOURCE_REQUESTS = "RATE_OF_LIST_TAGS_FOR_RESOURCE_REQUESTS"
    RATE_OF_UNTAG_RESOURCE_REQUESTS = "RATE_OF_UNTAG_RESOURCE_REQUESTS"
    RATE_OF_GET_TEMPLATE_REQUESTS = "RATE_OF_GET_TEMPLATE_REQUESTS"
    RATE_OF_GET_CONNECTOR_REQUESTS = "RATE_OF_GET_CONNECTOR_REQUESTS"
    RATE_OF_DELETE_DIRECTORY_REGISTRATION_REQUESTS = "RATE_OF_DELETE_DIRECTORY_REGISTRATION_REQUESTS"
    RATE_OF_DELETE_CONNECTOR_REQUESTS = "RATE_OF_DELETE_CONNECTOR_REQUESTS"
    RATE_OF_REQUEST_SECURITY_TOKEN_REQUESTS = "RATE_OF_REQUEST_SECURITY_TOKEN_REQUESTS"
    RATE_OF_CREATE_CONNECTOR_REQUESTS = "RATE_OF_CREATE_CONNECTOR_REQUESTS"
    RATE_OF_GET_POLICIES_REQUESTS = "RATE_OF_GET_POLICIES_REQUESTS"
    RATE_OF_DELETE_SERVICE_PRINCIPAL_NAME_REQUESTS = "RATE_OF_DELETE_SERVICE_PRINCIPAL_NAME_REQUESTS"
    RATE_OF_GET_TEMPLATE_GROUP_ACCESS_CONTROL_ENTRY_REQUESTS = "RATE_OF_GET_TEMPLATE_GROUP_ACCESS_CONTROL_ENTRY_REQUESTS"
    RATE_OF_DELETE_TEMPLATE_REQUESTS = "RATE_OF_DELETE_TEMPLATE_REQUESTS"
    NUMBER_OF_CONNECTORS = "NUMBER_OF_CONNECTORS"
    RATE_OF_CREATE_DIRECTORY_REGISTRATION_REQUESTS = "RATE_OF_CREATE_DIRECTORY_REGISTRATION_REQUESTS"
    RATE_OF_CREATE_TEMPLATE_GROUP_ACCESS_CONTROL_ENTRY_REQUESTS = "RATE_OF_CREATE_TEMPLATE_GROUP_ACCESS_CONTROL_ENTRY_REQUESTS"
    RATE_OF_CREATE_SERVICE_PRINCIPAL_NAME_REQUESTS = "RATE_OF_CREATE_SERVICE_PRINCIPAL_NAME_REQUESTS"
    NUMBER_OF_TEMPLATES_PER_CONNECTOR = "NUMBER_OF_TEMPLATES_PER_CONNECTOR"
    RATE_OF_UPDATE_TEMPLATE_GROUP_ACCESS_CONTROL_ENTRY_REQUESTS = "RATE_OF_UPDATE_TEMPLATE_GROUP_ACCESS_CONTROL_ENTRY_REQUESTS"
    RATE_OF_LIST_DIRECTORY_REGISTRATIONS_REQUESTS = "RATE_OF_LIST_DIRECTORY_REGISTRATIONS_REQUESTS"
    RATE_OF_UPDATE_TEMPLATE_REQUESTS = "RATE_OF_UPDATE_TEMPLATE_REQUESTS"
    RATE_OF_GET_SERVICE_PRINCIPAL_NAME_REQUESTS = "RATE_OF_GET_SERVICE_PRINCIPAL_NAME_REQUESTS"
    RATE_OF_LIST_TEMPLATE_GROUP_ACCESS_CONTROL_ENTRIES_REQUESTS = "RATE_OF_LIST_TEMPLATE_GROUP_ACCESS_CONTROL_ENTRIES_REQUESTS"
    RATE_OF_CREATE_TEMPLATE_REQUESTS = "RATE_OF_CREATE_TEMPLATE_REQUESTS"
    RATE_OF_DELETE_TEMPLATE_GROUP_ACCESS_CONTROL_ENTRY_REQUESTS = "RATE_OF_DELETE_TEMPLATE_GROUP_ACCESS_CONTROL_ENTRY_REQUESTS"
    RATE_OF_TAG_RESOURCE_REQUESTS = "RATE_OF_TAG_RESOURCE_REQUESTS"
    RATE_OF_GET_DIRECTORY_REGISTRATION_REQUESTS = "RATE_OF_GET_DIRECTORY_REGISTRATION_REQUESTS"
    RATE_OF_LIST_SERVICE_PRINCIPAL_NAMES_REQUESTS = "RATE_OF_LIST_SERVICE_PRINCIPAL_NAMES_REQUESTS"
    RATE_OF_LIST_TEMPLATES_REQUESTS = "RATE_OF_LIST_TEMPLATES_REQUESTS"
    NUMBER_OF_GROUP_ACCESS_CONTROL_ENTRIES_PER_TEMPLATE = "NUMBER_OF_GROUP_ACCESS_CONTROL_ENTRIES_PER_TEMPLATE"
    RATE_OF_LIST_CONNECTORS_REQUESTS = "RATE_OF_LIST_CONNECTORS_REQUESTS"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.Route53ResolverQuota")
class Route53ResolverQuota(enum.Enum):
    MAXIMUM_NUMBER_OF_RESOLVER_ENDPOINTS_PER_AWS_REGION = "MAXIMUM_NUMBER_OF_RESOLVER_ENDPOINTS_PER_AWS_REGION"
    ASSOCIATIONS_BETWEEN_RESOLVER_RULES_AND_VP_CS_PER_AWS_REGION = "ASSOCIATIONS_BETWEEN_RESOLVER_RULES_AND_VP_CS_PER_AWS_REGION"
    RULES_IN_A_DNS_FIREWALL_RULE_GROUP = "RULES_IN_A_DNS_FIREWALL_RULE_GROUP"
    DOMAINS_PER_ACCOUNT = "DOMAINS_PER_ACCOUNT"
    IP_ADDRESSES_PER_RESOLVER_ENDPOINT = "IP_ADDRESSES_PER_RESOLVER_ENDPOINT"
    DNS_FIREWALL_RULES_GROUPS_PER_REGION = "DNS_FIREWALL_RULES_GROUPS_PER_REGION"
    TARGET_IP_ADDRESSES_PER_RESOLVER_RULE = "TARGET_IP_ADDRESSES_PER_RESOLVER_RULE"
    DOMAINS_IN_A_FILE_IMPORTED_FROM_S3 = "DOMAINS_IN_A_FILE_IMPORTED_FROM_S3"
    RESOLVER_RULES_PER_AWS_REGION = "RESOLVER_RULES_PER_AWS_REGION"
    DOMAIN_LISTS_PER_ACCOUNT = "DOMAIN_LISTS_PER_ACCOUNT"
    DNS_FIREWALL_RULE_GROUP_ASSOCIATIONS_PER_VPC = "DNS_FIREWALL_RULE_GROUP_ASSOCIATIONS_PER_VPC"


class ServiceQuotas(
    _constructs_77d1e7e8.Construct,
    metaclass=jsii.JSIIMeta,
    jsii_type="@reapit-cdk/service-quotas.ServiceQuotas",
):
    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        fail_if_not_granted: builtins.bool,
        rerequest_when_denied: builtins.bool,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param fail_if_not_granted: 
        :param rerequest_when_denied: 
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__28f8136add36ea4654c76facc49c78a43dfab50a472199f4160a3c0869bfc9c3)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = ServiceQuotasProps(
            fail_if_not_granted=fail_if_not_granted,
            rerequest_when_denied=rerequest_when_denied,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="requestQuota")
    def request_quota(
        self,
        region: builtins.str,
        service: AWSService,
        quota: typing.Union[AwsCloudMapQuota, AccessAnalyzerQuota, AwsAccountManagementQuota, AwsCertificateManagerAcmQuota, AwsPrivateCertificateAuthorityQuota, AmazonManagedWorkflowsForApacheAirflowQuota, AwsAmplifyQuota, AmplifyUiBuilderQuota, AmazonOpenSearchServerlessQuota, AmazonApiGatewayQuota, AmazonConnectApplicationIntegrationsQuota, AwsAppConfigQuota, AwsAppFabricQuota, AmazonAppFlowQuota, ApplicationAutoScalingQuota, AwsApplicationCostProfilerQuota, AwsAppMeshQuota, AwsAppRunnerQuota, AmazonAppStream20Quota, AwsAppSyncQuota, AmazonManagedPrometheusQuota, AmazonAthenaQuota, AwsAuditManagerQuota, AmazonEc2AutoScalingQuota, AwsAutoScalingPlansQuota, AwsMarketplaceDeploymentServiceQuota, B2BDataInterchangeQuota, AwsBackupQuota, AwsBatchQuota, AwsBillingAndCostManagementDataExportsQuota, AmazonBedrockQuota, AmazonBedrockAgentQuota, AwsBillingConductorQuota, AmazonBraketQuota, AwsBugbustQuota, AmazonConnectCasesQuota, AmazonKeyspacesForApacheCassandraQuota, AwsCostExplorerQuota, AwsChatbotQuota, AmazonChimeQuota, AwsCleanRoomsQuota, AwsCloud9Quota, AwsCloudFormationQuota, AmazonCloudFrontQuota, AwsCloudHsmQuota, AwsCloudShellQuota, AwsCloudTrailQuota, AwsCodeArtifactQuota, AwsCodeBuildQuota, AwsCodeCommitQuota, AwsCodeDeployQuota, AmazonCodeGuruProfilerQuota, AmazonCodeGuruReviewerQuota, AwsCodePipelineQuota, AmazonCognitoFederatedIdentitiesQuota, AmazonCognitoUserPoolsQuota, AmazonCognitoSyncQuota, AmazonComprehendQuota, AmazonComprehendMedicalQuota, AwsComputeOptimizerQuota, AwsConfigQuota, AmazonConnectQuota, AmazonConnectOutboundCampaignsQuota, MechanicalTurkQuota, AwsGlueDataBrewQuota, AwsDataExchangeQuota, AwsDataPipelineQuota, AwsDataSyncQuota, AmazonDataZoneQuota, AmazonDynamoDbAcceleratorDaxQuota, AwsDeepRacerQuota, AwsDirectConnectQuota, AwsApplicationDiscoveryServiceQuota, AmazonDataLifecycleManagerQuota, AwsDatabaseMigrationServiceAwsDmsQuota, AmazonDocumentDbWithMongoDbCompatibilityQuota, AmazonDocumentDbElasticClustersQuota, ElasticDisasterRecoveryQuota, AwsDirectoryServiceQuota, AmazonDynamoDbQuota, AmazonElasticBlockStoreAmazonEbsQuota, AmazonElasticComputeCloudAmazonEc2Quota, IpamQuota, Ec2FastLaunchQuota, AmazonElasticContainerRegistryAmazonEcrQuota, AmazonElasticContainerRegistryPublicAmazonEcrPublicQuota, AmazonElasticContainerServiceAmazonEcsQuota, AmazonElasticKubernetesServiceAmazonEksQuota, AmazonElasticInferenceQuota, AmazonElastiCacheQuota, AwsElasticBeanstalkQuota, AmazonElasticFileSystemEfsQuota, ElasticLoadBalancingElbQuota, AmazonEmrQuota, AmazonElasticTranscoderQuota, AmazonEmrServerlessQuota, AwsEntityResolutionQuota, AmazonOpenSearchServiceQuota, AmazonEventBridgeCloudWatchEventsQuota, AmazonCloudWatchEvidentlyQuota, AwsFargateQuota, AmazonFinSpaceQuota, AmazonKinesisDataFirehoseQuota, AwsFaultInjectionServiceFisQuota, AwsFirewallManagerQuota, AmazonForecastQuota, AmazonFraudDetectorQuota, AmazonFSxQuota, AmazonGameLiftQuota, AmazonLocationServiceAmazonLocationQuota, AmazonGlacierQuota, AwsGlobalAcceleratorQuota, AwsGlueQuota, AmazonManagedGrafanaQuota, AwsIoTGreengrassQuota, AwsGroundStationQuota, AmazonGuardDutyQuota, AwsHealthLakeQuota, AwsIdentityAndAccessManagementIamQuota, Ec2ImageBuilderQuota, AmazonInspectorClassicQuota, AmazonInspectorQuota, CloudWatchInternetMonitorQuota, AwsIoTQuota, AwsIoT1ClickQuota, AwsIoTAnalyticsQuota, AwsIoTCoreQuota, AwsIoTCoreDeviceAdvisorQuota, AwsIoTEventsQuota, AwsIoTFleetHubQuota, AwsIoTFleetWiseQuota, AwsIoTRoboRunnerQuota, AwsIoTSiteWiseQuota, AwsIoTThingsGraphQuota, AwsIoTTwinMakerQuota, AwsIoTWirelessQuota, AmazonInteractiveVideoServiceQuota, AmazonInteractiveVideoServiceChatQuota, AmazonManagedStreamingForKafkaMskQuota, ManagedStreamingForKafkaConnectQuota, AmazonKendraQuota, AmazonKendraIntelligentRankingQuota, AmazonKinesisDataStreamsQuota, AmazonManagedServiceForApacheFlinkQuota, AmazonKinesisVideoStreamsQuota, AwsKeyManagementServiceAwsKmsQuota, AwsLakeFormationQuota, AwsLambdaQuota, AwsLaunchWizardQuota, AmazonLexQuota, AwsLicenseManagerQuota, AwsLicenseManagerLinuxSubscriptionsQuota, AwsLicenseManagerUserSubscriptionsQuota, AmazonLightsailQuota, AmazonCloudWatchLogsQuota, AmazonLookoutForEquipmentQuota, AmazonLookoutForMetricsQuota, AmazonLookoutForVisionQuota, AwsMainframeModernizationQuota, AmazonMachineLearningQuota, AmazonMacieQuota, AmazonManagedBlockchainQuota, AmazonManagedBlockchainQueryQuota, AwsElementalMediaConnectQuota, AwsElementalMediaConvertQuota, AwsElementalMediaLiveQuota, AwsElementalMediaPackageQuota, AwsElementalMediaPackageV2Quota, AwsElementalMediaStoreQuota, AwsElementalMediaTailorQuota, AwsHealthImagingQuota, ApplicationMigrationQuota, MigrationHubOrchestratorQuota, MigrationHubStrategyRecommendationsQuota, AmazonCloudWatchQuota, AmazonMonitronQuota, AmazonMqQuota, AmazonNeptuneQuota, AmazonNeptuneAnalyticsQuota, AwsNetworkFirewallQuota, NetworkInsightsQuota, AwsCloudWanQuota, AmazonCloudWatchNetworkMonitorQuota, AmazonNimbleStudioQuota, AwsUserNotificationsQuota, AmazonCloudWatchObservabilityAccessManagerQuota, AwsHealthOmicsQuota, AwsOpsWorksStacksQuota, AwsOpsWorksForChefAutomateAndAwsOpsWorksForPuppetEnterpriseQuota, AwsOrganizationsQuota, AwsOutpostsQuota, AwsPanoramaQuota, AwsPaymentCryptographyQuota, PrivateCaConnectorForActiveDirectoryQuota, AmazonPersonalizeQuota, AmazonPinpointQuota, AmazonPollyQuota, AwsPrivate5GQuota, AmazonConnectCustomerProfilesQuota, AwsProtonQuota, AmazonQQuota, AmazonQldbQuota, AmazonQuickSightQuota, AwsResourceAccessManagerQuota, AmazonRecycleBinQuota, AmazonRelationalDatabaseServiceAmazonRdsQuota, AmazonRedshiftQuota, AwsMigrationHubRefactorSpacesQuota, AmazonRekognitionQuota, AwsResilienceHubQuota, AwsResourceExplorerQuota, AwsResourceGroupsQuota, AwsRoboMakerQuota, IamRolesAnywhereQuota, AmazonRoute53Quota, Route53ResolverQuota, AmazonCloudWatchRumQuota, AmazonSimpleStorageServiceAmazonS3Quota, AwsS3OutpostsQuota, AmazonSageMakerQuota, AmazonEventBridgeSchedulerQuota, AmazonEventBridgeSchemaRegistryQuota, AwsSupplyChainQuota, AmazonSimpleDbQuota, AwsSecretsManagerQuota, AwsSecurityHubQuota, AwsServerlessApplicationRepositoryQuota, AwsServiceCatalogQuota, "ServiceQuotasQuota", AmazonSimpleEmailServiceAmazonSesQuota, AwsShieldAdvancedQuota, AwsSignerQuota, AwsSimSpaceWeaverQuota, AwsServerMigrationServiceQuota, AwsSnowDeviceManagementQuota, AwsSnowFamilyQuota, AmazonSimpleNotificationServiceAmazonSnsQuota, AmazonSimpleQueueServiceAmazonSqsQuota, AwsSystemsManagerQuota, AwsSystemsManagerIncidentManagerContactsQuota, AwsSystemsManagerGuiConnectQuota, AwsSystemsManagerIncidentManagerQuota, AwsSystemsManagerForSapQuota, AwsIamIdentityCenterSuccessorToAwsSingleSignOnQuota, AwsStepFunctionsQuota, AwsStorageGatewayQuota, AwsSupportQuota, AwsSupportAppQuota, AmazonSimpleWorkflowServiceQuota, AmazonTextractQuota, AmazonTimestreamQuota, AwsTelcoNetworkBuilderQuota, AmazonTranscribeQuota, AwsTransferFamilyQuota, AmazonTranslateQuota, AwsTrustedAdvisorQuota, AwsMarketplaceVendorInsightsQuota, AmazonVerifiedPermissionsQuota, Ec2VmImportExportQuota, AmazonConnectVoiceIdQuota, AmazonVirtualPrivateCloudAmazonVpcQuota, "VpcLatticeQuota", AwsWafClassicGlobalQuota, AwsWafClassicRegionalQuota, AwsWafQuota, AmazonWorkSpacesApplicationManagerQuota, AwsWellArchitectedToolQuota, AmazonQInConnectQuota, AmazonWorkSpacesQuota, AmazonWorkSpacesWebQuota, AwsXRayQuota],
        desired_value: jsii.Number,
    ) -> None:
        '''
        :param region: -
        :param service: -
        :param quota: -
        :param desired_value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__74f1aab92d286ea56dbba933907b154ceefb3787e9d1923a548af91ea0982613)
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument service", value=service, expected_type=type_hints["service"])
            check_type(argname="argument quota", value=quota, expected_type=type_hints["quota"])
            check_type(argname="argument desired_value", value=desired_value, expected_type=type_hints["desired_value"])
        return typing.cast(None, jsii.invoke(self, "requestQuota", [region, service, quota, desired_value]))


@jsii.data_type(
    jsii_type="@reapit-cdk/service-quotas.ServiceQuotasProps",
    jsii_struct_bases=[],
    name_mapping={
        "fail_if_not_granted": "failIfNotGranted",
        "rerequest_when_denied": "rerequestWhenDenied",
    },
)
class ServiceQuotasProps:
    def __init__(
        self,
        *,
        fail_if_not_granted: builtins.bool,
        rerequest_when_denied: builtins.bool,
    ) -> None:
        '''
        :param fail_if_not_granted: 
        :param rerequest_when_denied: 
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b604b42b49fea32f82ec8c26109696ef1ff215180e4c1ada3eb0a87998034409)
            check_type(argname="argument fail_if_not_granted", value=fail_if_not_granted, expected_type=type_hints["fail_if_not_granted"])
            check_type(argname="argument rerequest_when_denied", value=rerequest_when_denied, expected_type=type_hints["rerequest_when_denied"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "fail_if_not_granted": fail_if_not_granted,
            "rerequest_when_denied": rerequest_when_denied,
        }

    @builtins.property
    def fail_if_not_granted(self) -> builtins.bool:
        result = self._values.get("fail_if_not_granted")
        assert result is not None, "Required property 'fail_if_not_granted' is missing"
        return typing.cast(builtins.bool, result)

    @builtins.property
    def rerequest_when_denied(self) -> builtins.bool:
        result = self._values.get("rerequest_when_denied")
        assert result is not None, "Required property 'rerequest_when_denied' is missing"
        return typing.cast(builtins.bool, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ServiceQuotasProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.ServiceQuotasQuota")
class ServiceQuotasQuota(enum.Enum):
    ACTIVE_REQUESTS_PER_ACCOUNT_PER_REGION = "ACTIVE_REQUESTS_PER_ACCOUNT_PER_REGION"
    THROTTLE_RATE_FOR_GET_AWS_DEFAULT_SERVICE_QUOTA = "THROTTLE_RATE_FOR_GET_AWS_DEFAULT_SERVICE_QUOTA"
    THROTTLE_RATE_FOR_LIST_SERVICE_QUOTAS = "THROTTLE_RATE_FOR_LIST_SERVICE_QUOTAS"
    THROTTLE_RATE_FOR_LIST_SERVICE_QUOTA_INCREASE_REQUESTS_IN_TEMPLATE = "THROTTLE_RATE_FOR_LIST_SERVICE_QUOTA_INCREASE_REQUESTS_IN_TEMPLATE"
    THROTTLE_RATE_FOR_LIST_AWS_DEFAULT_SERVICE_QUOTAS = "THROTTLE_RATE_FOR_LIST_AWS_DEFAULT_SERVICE_QUOTAS"
    ACTIVE_REQUESTS_PER_QUOTA = "ACTIVE_REQUESTS_PER_QUOTA"
    THROTTLE_RATE_FOR_GET_SERVICE_QUOTA_INCREASE_REQUEST_FROM_TEMPLATE = "THROTTLE_RATE_FOR_GET_SERVICE_QUOTA_INCREASE_REQUEST_FROM_TEMPLATE"
    THROTTLE_RATE_FOR_LIST_TAGS_FOR_RESOURCE = "THROTTLE_RATE_FOR_LIST_TAGS_FOR_RESOURCE"
    MAX_REQUESTS_PER_TEMPLATE = "MAX_REQUESTS_PER_TEMPLATE"
    THROTTLE_RATE_FOR_GET_ASSOCIATION_FOR_SERVICE_QUOTA_TEMPLATE = "THROTTLE_RATE_FOR_GET_ASSOCIATION_FOR_SERVICE_QUOTA_TEMPLATE"
    THROTTLE_RATE_FOR_TAG_RESOURCE = "THROTTLE_RATE_FOR_TAG_RESOURCE"
    ACTIVE_REQUESTS_PER_ACCOUNT = "ACTIVE_REQUESTS_PER_ACCOUNT"
    THROTTLE_RATE_FOR_UNTAG_RESOURCE = "THROTTLE_RATE_FOR_UNTAG_RESOURCE"
    THROTTLE_RATE_FOR_GET_SERVICE_QUOTA = "THROTTLE_RATE_FOR_GET_SERVICE_QUOTA"
    THROTTLE_RATE_FOR_LIST_REQUESTED_SERVICE_QUOTA_CHANGE_HISTORY = "THROTTLE_RATE_FOR_LIST_REQUESTED_SERVICE_QUOTA_CHANGE_HISTORY"
    THROTTLE_RATE_FOR_LIST_REQUESTED_SERVICE_QUOTA_CHANGE_HISTORY_BY_QUOTA = "THROTTLE_RATE_FOR_LIST_REQUESTED_SERVICE_QUOTA_CHANGE_HISTORY_BY_QUOTA"
    THROTTLE_RATE_FOR_LIST_SERVICES = "THROTTLE_RATE_FOR_LIST_SERVICES"
    THROTTLE_RATE_FOR_PUT_SERVICE_QUOTA_INCREASE_REQUEST_INTO_TEMPLATE = "THROTTLE_RATE_FOR_PUT_SERVICE_QUOTA_INCREASE_REQUEST_INTO_TEMPLATE"
    THROTTLE_RATE_FOR_GET_REQUESTED_SERVICE_QUOTA_CHANGE = "THROTTLE_RATE_FOR_GET_REQUESTED_SERVICE_QUOTA_CHANGE"
    THROTTLE_RATE_FOR_DELETE_SERVICE_QUOTA_INCREASE_REQUEST_FROM_TEMPLATE = "THROTTLE_RATE_FOR_DELETE_SERVICE_QUOTA_INCREASE_REQUEST_FROM_TEMPLATE"
    THROTTLE_RATE_FOR_DISASSOCIATE_SERVICE_QUOTA_TEMPLATE = "THROTTLE_RATE_FOR_DISASSOCIATE_SERVICE_QUOTA_TEMPLATE"
    THROTTLE_RATE_FOR_ASSOCIATE_SERVICE_QUOTA_TEMPLATE = "THROTTLE_RATE_FOR_ASSOCIATE_SERVICE_QUOTA_TEMPLATE"
    THROTTLE_RATE_FOR_REQUEST_SERVICE_QUOTA_INCREASE = "THROTTLE_RATE_FOR_REQUEST_SERVICE_QUOTA_INCREASE"


@jsii.enum(jsii_type="@reapit-cdk/service-quotas.VpcLatticeQuota")
class VpcLatticeQuota(enum.Enum):
    AUTH_POLICY_SIZE = "AUTH_POLICY_SIZE"
    SECURITY_GROUPS_PER_ASSOCIATION = "SECURITY_GROUPS_PER_ASSOCIATION"
    SERVICE_ASSOCIATIONS_PER_SERVICE_NETWORK = "SERVICE_ASSOCIATIONS_PER_SERVICE_NETWORK"
    SERVICE_NETWORKS_PER_REGION = "SERVICE_NETWORKS_PER_REGION"
    RULES_PER_LISTENER = "RULES_PER_LISTENER"
    SERVICES_PER_REGION = "SERVICES_PER_REGION"
    TARGET_GROUPS_PER_SERVICE = "TARGET_GROUPS_PER_SERVICE"
    LISTENERS_PER_SERVICE = "LISTENERS_PER_SERVICE"
    TARGETS_PER_TARGET_GROUP = "TARGETS_PER_TARGET_GROUP"
    VPC_ASSOCIATIONS_PER_SERVICE_NETWORK = "VPC_ASSOCIATIONS_PER_SERVICE_NETWORK"
    TARGET_GROUPS_PER_REGION = "TARGET_GROUPS_PER_REGION"


__all__ = [
    "AWSService",
    "AccessAnalyzerQuota",
    "AmazonApiGatewayQuota",
    "AmazonAppFlowQuota",
    "AmazonAppStream20Quota",
    "AmazonAthenaQuota",
    "AmazonBedrockAgentQuota",
    "AmazonBedrockQuota",
    "AmazonBraketQuota",
    "AmazonChimeQuota",
    "AmazonCloudFrontQuota",
    "AmazonCloudWatchEvidentlyQuota",
    "AmazonCloudWatchLogsQuota",
    "AmazonCloudWatchNetworkMonitorQuota",
    "AmazonCloudWatchObservabilityAccessManagerQuota",
    "AmazonCloudWatchQuota",
    "AmazonCloudWatchRumQuota",
    "AmazonCodeGuruProfilerQuota",
    "AmazonCodeGuruReviewerQuota",
    "AmazonCognitoFederatedIdentitiesQuota",
    "AmazonCognitoSyncQuota",
    "AmazonCognitoUserPoolsQuota",
    "AmazonComprehendMedicalQuota",
    "AmazonComprehendQuota",
    "AmazonConnectApplicationIntegrationsQuota",
    "AmazonConnectCasesQuota",
    "AmazonConnectCustomerProfilesQuota",
    "AmazonConnectOutboundCampaignsQuota",
    "AmazonConnectQuota",
    "AmazonConnectVoiceIdQuota",
    "AmazonDataLifecycleManagerQuota",
    "AmazonDataZoneQuota",
    "AmazonDocumentDbElasticClustersQuota",
    "AmazonDocumentDbWithMongoDbCompatibilityQuota",
    "AmazonDynamoDbAcceleratorDaxQuota",
    "AmazonDynamoDbQuota",
    "AmazonEc2AutoScalingQuota",
    "AmazonElastiCacheQuota",
    "AmazonElasticBlockStoreAmazonEbsQuota",
    "AmazonElasticComputeCloudAmazonEc2Quota",
    "AmazonElasticContainerRegistryAmazonEcrQuota",
    "AmazonElasticContainerRegistryPublicAmazonEcrPublicQuota",
    "AmazonElasticContainerServiceAmazonEcsQuota",
    "AmazonElasticFileSystemEfsQuota",
    "AmazonElasticInferenceQuota",
    "AmazonElasticKubernetesServiceAmazonEksQuota",
    "AmazonElasticTranscoderQuota",
    "AmazonEmrQuota",
    "AmazonEmrServerlessQuota",
    "AmazonEventBridgeCloudWatchEventsQuota",
    "AmazonEventBridgeSchedulerQuota",
    "AmazonEventBridgeSchemaRegistryQuota",
    "AmazonFSxQuota",
    "AmazonFinSpaceQuota",
    "AmazonForecastQuota",
    "AmazonFraudDetectorQuota",
    "AmazonGameLiftQuota",
    "AmazonGlacierQuota",
    "AmazonGuardDutyQuota",
    "AmazonInspectorClassicQuota",
    "AmazonInspectorQuota",
    "AmazonInteractiveVideoServiceChatQuota",
    "AmazonInteractiveVideoServiceQuota",
    "AmazonKendraIntelligentRankingQuota",
    "AmazonKendraQuota",
    "AmazonKeyspacesForApacheCassandraQuota",
    "AmazonKinesisDataFirehoseQuota",
    "AmazonKinesisDataStreamsQuota",
    "AmazonKinesisVideoStreamsQuota",
    "AmazonLexQuota",
    "AmazonLightsailQuota",
    "AmazonLocationServiceAmazonLocationQuota",
    "AmazonLookoutForEquipmentQuota",
    "AmazonLookoutForMetricsQuota",
    "AmazonLookoutForVisionQuota",
    "AmazonMachineLearningQuota",
    "AmazonMacieQuota",
    "AmazonManagedBlockchainQueryQuota",
    "AmazonManagedBlockchainQuota",
    "AmazonManagedGrafanaQuota",
    "AmazonManagedPrometheusQuota",
    "AmazonManagedServiceForApacheFlinkQuota",
    "AmazonManagedStreamingForKafkaMskQuota",
    "AmazonManagedWorkflowsForApacheAirflowQuota",
    "AmazonMonitronQuota",
    "AmazonMqQuota",
    "AmazonNeptuneAnalyticsQuota",
    "AmazonNeptuneQuota",
    "AmazonNimbleStudioQuota",
    "AmazonOpenSearchServerlessQuota",
    "AmazonOpenSearchServiceQuota",
    "AmazonPersonalizeQuota",
    "AmazonPinpointQuota",
    "AmazonPollyQuota",
    "AmazonQInConnectQuota",
    "AmazonQQuota",
    "AmazonQldbQuota",
    "AmazonQuickSightQuota",
    "AmazonRecycleBinQuota",
    "AmazonRedshiftQuota",
    "AmazonRekognitionQuota",
    "AmazonRelationalDatabaseServiceAmazonRdsQuota",
    "AmazonRoute53Quota",
    "AmazonSageMakerQuota",
    "AmazonSimpleDbQuota",
    "AmazonSimpleEmailServiceAmazonSesQuota",
    "AmazonSimpleNotificationServiceAmazonSnsQuota",
    "AmazonSimpleQueueServiceAmazonSqsQuota",
    "AmazonSimpleStorageServiceAmazonS3Quota",
    "AmazonSimpleWorkflowServiceQuota",
    "AmazonTextractQuota",
    "AmazonTimestreamQuota",
    "AmazonTranscribeQuota",
    "AmazonTranslateQuota",
    "AmazonVerifiedPermissionsQuota",
    "AmazonVirtualPrivateCloudAmazonVpcQuota",
    "AmazonWorkSpacesApplicationManagerQuota",
    "AmazonWorkSpacesQuota",
    "AmazonWorkSpacesWebQuota",
    "AmplifyUiBuilderQuota",
    "ApplicationAutoScalingQuota",
    "ApplicationMigrationQuota",
    "AwsAccountManagementQuota",
    "AwsAmplifyQuota",
    "AwsAppConfigQuota",
    "AwsAppFabricQuota",
    "AwsAppMeshQuota",
    "AwsAppRunnerQuota",
    "AwsAppSyncQuota",
    "AwsApplicationCostProfilerQuota",
    "AwsApplicationDiscoveryServiceQuota",
    "AwsAuditManagerQuota",
    "AwsAutoScalingPlansQuota",
    "AwsBackupQuota",
    "AwsBatchQuota",
    "AwsBillingAndCostManagementDataExportsQuota",
    "AwsBillingConductorQuota",
    "AwsBugbustQuota",
    "AwsCertificateManagerAcmQuota",
    "AwsChatbotQuota",
    "AwsCleanRoomsQuota",
    "AwsCloud9Quota",
    "AwsCloudFormationQuota",
    "AwsCloudHsmQuota",
    "AwsCloudMapQuota",
    "AwsCloudShellQuota",
    "AwsCloudTrailQuota",
    "AwsCloudWanQuota",
    "AwsCodeArtifactQuota",
    "AwsCodeBuildQuota",
    "AwsCodeCommitQuota",
    "AwsCodeDeployQuota",
    "AwsCodePipelineQuota",
    "AwsComputeOptimizerQuota",
    "AwsConfigQuota",
    "AwsCostExplorerQuota",
    "AwsDataExchangeQuota",
    "AwsDataPipelineQuota",
    "AwsDataSyncQuota",
    "AwsDatabaseMigrationServiceAwsDmsQuota",
    "AwsDeepRacerQuota",
    "AwsDirectConnectQuota",
    "AwsDirectoryServiceQuota",
    "AwsElasticBeanstalkQuota",
    "AwsElementalMediaConnectQuota",
    "AwsElementalMediaConvertQuota",
    "AwsElementalMediaLiveQuota",
    "AwsElementalMediaPackageQuota",
    "AwsElementalMediaPackageV2Quota",
    "AwsElementalMediaStoreQuota",
    "AwsElementalMediaTailorQuota",
    "AwsEntityResolutionQuota",
    "AwsFargateQuota",
    "AwsFaultInjectionServiceFisQuota",
    "AwsFirewallManagerQuota",
    "AwsGlobalAcceleratorQuota",
    "AwsGlueDataBrewQuota",
    "AwsGlueQuota",
    "AwsGroundStationQuota",
    "AwsHealthImagingQuota",
    "AwsHealthLakeQuota",
    "AwsHealthOmicsQuota",
    "AwsIamIdentityCenterSuccessorToAwsSingleSignOnQuota",
    "AwsIdentityAndAccessManagementIamQuota",
    "AwsIoT1ClickQuota",
    "AwsIoTAnalyticsQuota",
    "AwsIoTCoreDeviceAdvisorQuota",
    "AwsIoTCoreQuota",
    "AwsIoTEventsQuota",
    "AwsIoTFleetHubQuota",
    "AwsIoTFleetWiseQuota",
    "AwsIoTGreengrassQuota",
    "AwsIoTQuota",
    "AwsIoTRoboRunnerQuota",
    "AwsIoTSiteWiseQuota",
    "AwsIoTThingsGraphQuota",
    "AwsIoTTwinMakerQuota",
    "AwsIoTWirelessQuota",
    "AwsKeyManagementServiceAwsKmsQuota",
    "AwsLakeFormationQuota",
    "AwsLambdaQuota",
    "AwsLaunchWizardQuota",
    "AwsLicenseManagerLinuxSubscriptionsQuota",
    "AwsLicenseManagerQuota",
    "AwsLicenseManagerUserSubscriptionsQuota",
    "AwsMainframeModernizationQuota",
    "AwsMarketplaceDeploymentServiceQuota",
    "AwsMarketplaceVendorInsightsQuota",
    "AwsMigrationHubRefactorSpacesQuota",
    "AwsNetworkFirewallQuota",
    "AwsOpsWorksForChefAutomateAndAwsOpsWorksForPuppetEnterpriseQuota",
    "AwsOpsWorksStacksQuota",
    "AwsOrganizationsQuota",
    "AwsOutpostsQuota",
    "AwsPanoramaQuota",
    "AwsPaymentCryptographyQuota",
    "AwsPrivate5GQuota",
    "AwsPrivateCertificateAuthorityQuota",
    "AwsProtonQuota",
    "AwsResilienceHubQuota",
    "AwsResourceAccessManagerQuota",
    "AwsResourceExplorerQuota",
    "AwsResourceGroupsQuota",
    "AwsRoboMakerQuota",
    "AwsS3OutpostsQuota",
    "AwsSecretsManagerQuota",
    "AwsSecurityHubQuota",
    "AwsServerMigrationServiceQuota",
    "AwsServerlessApplicationRepositoryQuota",
    "AwsServiceCatalogQuota",
    "AwsShieldAdvancedQuota",
    "AwsSignerQuota",
    "AwsSimSpaceWeaverQuota",
    "AwsSnowDeviceManagementQuota",
    "AwsSnowFamilyQuota",
    "AwsStepFunctionsQuota",
    "AwsStorageGatewayQuota",
    "AwsSupplyChainQuota",
    "AwsSupportAppQuota",
    "AwsSupportQuota",
    "AwsSystemsManagerForSapQuota",
    "AwsSystemsManagerGuiConnectQuota",
    "AwsSystemsManagerIncidentManagerContactsQuota",
    "AwsSystemsManagerIncidentManagerQuota",
    "AwsSystemsManagerQuota",
    "AwsTelcoNetworkBuilderQuota",
    "AwsTransferFamilyQuota",
    "AwsTrustedAdvisorQuota",
    "AwsUserNotificationsQuota",
    "AwsWafClassicGlobalQuota",
    "AwsWafClassicRegionalQuota",
    "AwsWafQuota",
    "AwsWellArchitectedToolQuota",
    "AwsXRayQuota",
    "B2BDataInterchangeQuota",
    "CloudWatchInternetMonitorQuota",
    "Ec2FastLaunchQuota",
    "Ec2ImageBuilderQuota",
    "Ec2VmImportExportQuota",
    "ElasticDisasterRecoveryQuota",
    "ElasticLoadBalancingElbQuota",
    "IamRolesAnywhereQuota",
    "IpamQuota",
    "ManagedStreamingForKafkaConnectQuota",
    "MechanicalTurkQuota",
    "MigrationHubOrchestratorQuota",
    "MigrationHubStrategyRecommendationsQuota",
    "NetworkInsightsQuota",
    "PrivateCaConnectorForActiveDirectoryQuota",
    "Route53ResolverQuota",
    "ServiceQuotas",
    "ServiceQuotasProps",
    "ServiceQuotasQuota",
    "VpcLatticeQuota",
]

publication.publish()

def _typecheckingstub__28f8136add36ea4654c76facc49c78a43dfab50a472199f4160a3c0869bfc9c3(
    scope: _constructs_77d1e7e8.Construct,
    id: builtins.str,
    *,
    fail_if_not_granted: builtins.bool,
    rerequest_when_denied: builtins.bool,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__74f1aab92d286ea56dbba933907b154ceefb3787e9d1923a548af91ea0982613(
    region: builtins.str,
    service: AWSService,
    quota: typing.Union[AwsCloudMapQuota, AccessAnalyzerQuota, AwsAccountManagementQuota, AwsCertificateManagerAcmQuota, AwsPrivateCertificateAuthorityQuota, AmazonManagedWorkflowsForApacheAirflowQuota, AwsAmplifyQuota, AmplifyUiBuilderQuota, AmazonOpenSearchServerlessQuota, AmazonApiGatewayQuota, AmazonConnectApplicationIntegrationsQuota, AwsAppConfigQuota, AwsAppFabricQuota, AmazonAppFlowQuota, ApplicationAutoScalingQuota, AwsApplicationCostProfilerQuota, AwsAppMeshQuota, AwsAppRunnerQuota, AmazonAppStream20Quota, AwsAppSyncQuota, AmazonManagedPrometheusQuota, AmazonAthenaQuota, AwsAuditManagerQuota, AmazonEc2AutoScalingQuota, AwsAutoScalingPlansQuota, AwsMarketplaceDeploymentServiceQuota, B2BDataInterchangeQuota, AwsBackupQuota, AwsBatchQuota, AwsBillingAndCostManagementDataExportsQuota, AmazonBedrockQuota, AmazonBedrockAgentQuota, AwsBillingConductorQuota, AmazonBraketQuota, AwsBugbustQuota, AmazonConnectCasesQuota, AmazonKeyspacesForApacheCassandraQuota, AwsCostExplorerQuota, AwsChatbotQuota, AmazonChimeQuota, AwsCleanRoomsQuota, AwsCloud9Quota, AwsCloudFormationQuota, AmazonCloudFrontQuota, AwsCloudHsmQuota, AwsCloudShellQuota, AwsCloudTrailQuota, AwsCodeArtifactQuota, AwsCodeBuildQuota, AwsCodeCommitQuota, AwsCodeDeployQuota, AmazonCodeGuruProfilerQuota, AmazonCodeGuruReviewerQuota, AwsCodePipelineQuota, AmazonCognitoFederatedIdentitiesQuota, AmazonCognitoUserPoolsQuota, AmazonCognitoSyncQuota, AmazonComprehendQuota, AmazonComprehendMedicalQuota, AwsComputeOptimizerQuota, AwsConfigQuota, AmazonConnectQuota, AmazonConnectOutboundCampaignsQuota, MechanicalTurkQuota, AwsGlueDataBrewQuota, AwsDataExchangeQuota, AwsDataPipelineQuota, AwsDataSyncQuota, AmazonDataZoneQuota, AmazonDynamoDbAcceleratorDaxQuota, AwsDeepRacerQuota, AwsDirectConnectQuota, AwsApplicationDiscoveryServiceQuota, AmazonDataLifecycleManagerQuota, AwsDatabaseMigrationServiceAwsDmsQuota, AmazonDocumentDbWithMongoDbCompatibilityQuota, AmazonDocumentDbElasticClustersQuota, ElasticDisasterRecoveryQuota, AwsDirectoryServiceQuota, AmazonDynamoDbQuota, AmazonElasticBlockStoreAmazonEbsQuota, AmazonElasticComputeCloudAmazonEc2Quota, IpamQuota, Ec2FastLaunchQuota, AmazonElasticContainerRegistryAmazonEcrQuota, AmazonElasticContainerRegistryPublicAmazonEcrPublicQuota, AmazonElasticContainerServiceAmazonEcsQuota, AmazonElasticKubernetesServiceAmazonEksQuota, AmazonElasticInferenceQuota, AmazonElastiCacheQuota, AwsElasticBeanstalkQuota, AmazonElasticFileSystemEfsQuota, ElasticLoadBalancingElbQuota, AmazonEmrQuota, AmazonElasticTranscoderQuota, AmazonEmrServerlessQuota, AwsEntityResolutionQuota, AmazonOpenSearchServiceQuota, AmazonEventBridgeCloudWatchEventsQuota, AmazonCloudWatchEvidentlyQuota, AwsFargateQuota, AmazonFinSpaceQuota, AmazonKinesisDataFirehoseQuota, AwsFaultInjectionServiceFisQuota, AwsFirewallManagerQuota, AmazonForecastQuota, AmazonFraudDetectorQuota, AmazonFSxQuota, AmazonGameLiftQuota, AmazonLocationServiceAmazonLocationQuota, AmazonGlacierQuota, AwsGlobalAcceleratorQuota, AwsGlueQuota, AmazonManagedGrafanaQuota, AwsIoTGreengrassQuota, AwsGroundStationQuota, AmazonGuardDutyQuota, AwsHealthLakeQuota, AwsIdentityAndAccessManagementIamQuota, Ec2ImageBuilderQuota, AmazonInspectorClassicQuota, AmazonInspectorQuota, CloudWatchInternetMonitorQuota, AwsIoTQuota, AwsIoT1ClickQuota, AwsIoTAnalyticsQuota, AwsIoTCoreQuota, AwsIoTCoreDeviceAdvisorQuota, AwsIoTEventsQuota, AwsIoTFleetHubQuota, AwsIoTFleetWiseQuota, AwsIoTRoboRunnerQuota, AwsIoTSiteWiseQuota, AwsIoTThingsGraphQuota, AwsIoTTwinMakerQuota, AwsIoTWirelessQuota, AmazonInteractiveVideoServiceQuota, AmazonInteractiveVideoServiceChatQuota, AmazonManagedStreamingForKafkaMskQuota, ManagedStreamingForKafkaConnectQuota, AmazonKendraQuota, AmazonKendraIntelligentRankingQuota, AmazonKinesisDataStreamsQuota, AmazonManagedServiceForApacheFlinkQuota, AmazonKinesisVideoStreamsQuota, AwsKeyManagementServiceAwsKmsQuota, AwsLakeFormationQuota, AwsLambdaQuota, AwsLaunchWizardQuota, AmazonLexQuota, AwsLicenseManagerQuota, AwsLicenseManagerLinuxSubscriptionsQuota, AwsLicenseManagerUserSubscriptionsQuota, AmazonLightsailQuota, AmazonCloudWatchLogsQuota, AmazonLookoutForEquipmentQuota, AmazonLookoutForMetricsQuota, AmazonLookoutForVisionQuota, AwsMainframeModernizationQuota, AmazonMachineLearningQuota, AmazonMacieQuota, AmazonManagedBlockchainQuota, AmazonManagedBlockchainQueryQuota, AwsElementalMediaConnectQuota, AwsElementalMediaConvertQuota, AwsElementalMediaLiveQuota, AwsElementalMediaPackageQuota, AwsElementalMediaPackageV2Quota, AwsElementalMediaStoreQuota, AwsElementalMediaTailorQuota, AwsHealthImagingQuota, ApplicationMigrationQuota, MigrationHubOrchestratorQuota, MigrationHubStrategyRecommendationsQuota, AmazonCloudWatchQuota, AmazonMonitronQuota, AmazonMqQuota, AmazonNeptuneQuota, AmazonNeptuneAnalyticsQuota, AwsNetworkFirewallQuota, NetworkInsightsQuota, AwsCloudWanQuota, AmazonCloudWatchNetworkMonitorQuota, AmazonNimbleStudioQuota, AwsUserNotificationsQuota, AmazonCloudWatchObservabilityAccessManagerQuota, AwsHealthOmicsQuota, AwsOpsWorksStacksQuota, AwsOpsWorksForChefAutomateAndAwsOpsWorksForPuppetEnterpriseQuota, AwsOrganizationsQuota, AwsOutpostsQuota, AwsPanoramaQuota, AwsPaymentCryptographyQuota, PrivateCaConnectorForActiveDirectoryQuota, AmazonPersonalizeQuota, AmazonPinpointQuota, AmazonPollyQuota, AwsPrivate5GQuota, AmazonConnectCustomerProfilesQuota, AwsProtonQuota, AmazonQQuota, AmazonQldbQuota, AmazonQuickSightQuota, AwsResourceAccessManagerQuota, AmazonRecycleBinQuota, AmazonRelationalDatabaseServiceAmazonRdsQuota, AmazonRedshiftQuota, AwsMigrationHubRefactorSpacesQuota, AmazonRekognitionQuota, AwsResilienceHubQuota, AwsResourceExplorerQuota, AwsResourceGroupsQuota, AwsRoboMakerQuota, IamRolesAnywhereQuota, AmazonRoute53Quota, Route53ResolverQuota, AmazonCloudWatchRumQuota, AmazonSimpleStorageServiceAmazonS3Quota, AwsS3OutpostsQuota, AmazonSageMakerQuota, AmazonEventBridgeSchedulerQuota, AmazonEventBridgeSchemaRegistryQuota, AwsSupplyChainQuota, AmazonSimpleDbQuota, AwsSecretsManagerQuota, AwsSecurityHubQuota, AwsServerlessApplicationRepositoryQuota, AwsServiceCatalogQuota, ServiceQuotasQuota, AmazonSimpleEmailServiceAmazonSesQuota, AwsShieldAdvancedQuota, AwsSignerQuota, AwsSimSpaceWeaverQuota, AwsServerMigrationServiceQuota, AwsSnowDeviceManagementQuota, AwsSnowFamilyQuota, AmazonSimpleNotificationServiceAmazonSnsQuota, AmazonSimpleQueueServiceAmazonSqsQuota, AwsSystemsManagerQuota, AwsSystemsManagerIncidentManagerContactsQuota, AwsSystemsManagerGuiConnectQuota, AwsSystemsManagerIncidentManagerQuota, AwsSystemsManagerForSapQuota, AwsIamIdentityCenterSuccessorToAwsSingleSignOnQuota, AwsStepFunctionsQuota, AwsStorageGatewayQuota, AwsSupportQuota, AwsSupportAppQuota, AmazonSimpleWorkflowServiceQuota, AmazonTextractQuota, AmazonTimestreamQuota, AwsTelcoNetworkBuilderQuota, AmazonTranscribeQuota, AwsTransferFamilyQuota, AmazonTranslateQuota, AwsTrustedAdvisorQuota, AwsMarketplaceVendorInsightsQuota, AmazonVerifiedPermissionsQuota, Ec2VmImportExportQuota, AmazonConnectVoiceIdQuota, AmazonVirtualPrivateCloudAmazonVpcQuota, VpcLatticeQuota, AwsWafClassicGlobalQuota, AwsWafClassicRegionalQuota, AwsWafQuota, AmazonWorkSpacesApplicationManagerQuota, AwsWellArchitectedToolQuota, AmazonQInConnectQuota, AmazonWorkSpacesQuota, AmazonWorkSpacesWebQuota, AwsXRayQuota],
    desired_value: jsii.Number,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__b604b42b49fea32f82ec8c26109696ef1ff215180e4c1ada3eb0a87998034409(
    *,
    fail_if_not_granted: builtins.bool,
    rerequest_when_denied: builtins.bool,
) -> None:
    """Type checking stubs"""
    pass
