"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .amount import Amount, AmountTypedDict
from .entity_method import EntityMethod, EntityMethodTypedDict
from .line_categories import LineCategories
from .locale import Locale
from .method_include_wallets_parameter import MethodIncludeWalletsParameter
from .method_resource_parameter import MethodResourceParameter
from .sequence_type import SequenceType
from .url import URL, URLTypedDict
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import FieldMetadata, HeaderMetadata, QueryParamMetadata
import pydantic
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class ListMethodsRequestTypedDict(TypedDict):
    sequence_type: NotRequired[SequenceType]
    r"""Set this parameter to `first` to only return the enabled methods that
    can be used for the first payment of a recurring sequence.

    Set it to `recurring` to only return enabled methods that can be used for recurring payments or subscriptions.
    """
    locale: NotRequired[Nullable[Locale]]
    r"""Response language"""
    amount: NotRequired[AmountTypedDict]
    r"""If supplied, only payment methods that support the amount and currency
    are returned.

    Example: `/v2/methods?amount[value]=100.00&amount[currency]=USD`
    """
    resource: NotRequired[MethodResourceParameter]
    r"""**⚠️ We no longer recommend using the Orders API. Please refer to the [Payments API](payments-api) instead.**

    Indicate if you will use the result for the [Create order](create-order)
    or the [Create payment](create-payment) endpoint.

    When passing the value `orders`, the result will include payment methods
    that are only available for payments created via the Orders API.
    """
    billing_country: NotRequired[str]
    r"""The country taken from your customer's billing address in ISO 3166-1 alpha-2 format. This parameter can be used
    to check whether your customer is eligible for certain payment methods, for example for Klarna.

    Example: `/v2/methods?resource=orders&billingCountry=DE`
    """
    include_wallets: NotRequired[MethodIncludeWalletsParameter]
    r"""A comma-separated list of the wallets you support in your checkout. Wallets often require wallet specific code
    to check if they are available on the shoppers device, hence the need to indicate your support.
    """
    order_line_categories: NotRequired[LineCategories]
    r"""A comma-separated list of the line categories you support in your checkout.

    Example: `/v2/methods?orderLineCategories=eco,meal`
    """
    profile_id: NotRequired[str]
    r"""The identifier referring to the [profile](get-profile) you wish to
    retrieve the resources for.

    Most API credentials are linked to a single profile. In these cases the `profileId` can be omitted. For
    organization-level credentials such as OAuth access tokens however, the `profileId` parameter is required.
    """
    include: NotRequired[Nullable[str]]
    r"""This endpoint allows you to include additional information via the `include` query string parameter."""
    testmode: NotRequired[Nullable[bool]]
    r"""Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query
    parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by
    setting the `testmode` query parameter to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """
    idempotency_key: NotRequired[str]
    r"""A unique key to ensure idempotent requests. This key should be a UUID v4 string."""


class ListMethodsRequest(BaseModel):
    sequence_type: Annotated[
        Optional[SequenceType],
        pydantic.Field(alias="sequenceType"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Set this parameter to `first` to only return the enabled methods that
    can be used for the first payment of a recurring sequence.

    Set it to `recurring` to only return enabled methods that can be used for recurring payments or subscriptions.
    """

    locale: Annotated[
        OptionalNullable[Locale],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Response language"""

    amount: Annotated[
        Optional[Amount],
        FieldMetadata(query=QueryParamMetadata(style="deepObject", explode=True)),
    ] = None
    r"""If supplied, only payment methods that support the amount and currency
    are returned.

    Example: `/v2/methods?amount[value]=100.00&amount[currency]=USD`
    """

    resource: Annotated[
        Optional[MethodResourceParameter],
        pydantic.Field(
            deprecated="warning: ** DEPRECATED ** - This will be removed in a future release, please migrate away from it as soon as possible."
        ),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""**⚠️ We no longer recommend using the Orders API. Please refer to the [Payments API](payments-api) instead.**

    Indicate if you will use the result for the [Create order](create-order)
    or the [Create payment](create-payment) endpoint.

    When passing the value `orders`, the result will include payment methods
    that are only available for payments created via the Orders API.
    """

    billing_country: Annotated[
        Optional[str],
        pydantic.Field(alias="billingCountry"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The country taken from your customer's billing address in ISO 3166-1 alpha-2 format. This parameter can be used
    to check whether your customer is eligible for certain payment methods, for example for Klarna.

    Example: `/v2/methods?resource=orders&billingCountry=DE`
    """

    include_wallets: Annotated[
        Optional[MethodIncludeWalletsParameter],
        pydantic.Field(alias="includeWallets"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""A comma-separated list of the wallets you support in your checkout. Wallets often require wallet specific code
    to check if they are available on the shoppers device, hence the need to indicate your support.
    """

    order_line_categories: Annotated[
        Optional[LineCategories],
        pydantic.Field(alias="orderLineCategories"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""A comma-separated list of the line categories you support in your checkout.

    Example: `/v2/methods?orderLineCategories=eco,meal`
    """

    profile_id: Annotated[
        Optional[str],
        pydantic.Field(alias="profileId"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The identifier referring to the [profile](get-profile) you wish to
    retrieve the resources for.

    Most API credentials are linked to a single profile. In these cases the `profileId` can be omitted. For
    organization-level credentials such as OAuth access tokens however, the `profileId` parameter is required.
    """

    include: Annotated[
        OptionalNullable[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""This endpoint allows you to include additional information via the `include` query string parameter."""

    testmode: Annotated[
        OptionalNullable[bool],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query
    parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by
    setting the `testmode` query parameter to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """

    idempotency_key: Annotated[
        Optional[str],
        pydantic.Field(alias="idempotency-key"),
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ] = None
    r"""A unique key to ensure idempotent requests. This key should be a UUID v4 string."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "sequenceType",
            "locale",
            "amount",
            "resource",
            "billingCountry",
            "includeWallets",
            "orderLineCategories",
            "profileId",
            "include",
            "testmode",
            "idempotency-key",
        ]
        nullable_fields = ["locale", "include", "testmode"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListMethodsEmbeddedTypedDict(TypedDict):
    methods: List[EntityMethodTypedDict]
    r"""An array of payment method objects. For a complete
    reference of the payment method object, refer
    to the [Get payment method endpoint](get-method)
    documentation.
    """


class ListMethodsEmbedded(BaseModel):
    methods: List[EntityMethod]
    r"""An array of payment method objects. For a complete
    reference of the payment method object, refer
    to the [Get payment method endpoint](get-method)
    documentation.
    """


class ListMethodsLinksTypedDict(TypedDict):
    self_: URLTypedDict
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    documentation: URLTypedDict
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class ListMethodsLinks(BaseModel):
    self_: Annotated[URL, pydantic.Field(alias="self")]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    documentation: URL
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class ListMethodsResponseTypedDict(TypedDict):
    r"""A list of payment method objects. For a complete reference of the
    payment method object, refer to the [Get payment method endpoint](get-method) documentation.
    """

    count: int
    r"""The number of payment method objects in this result set.
    Results are **not** paginated.
    """
    embedded: ListMethodsEmbeddedTypedDict
    links: ListMethodsLinksTypedDict


class ListMethodsResponse(BaseModel):
    r"""A list of payment method objects. For a complete reference of the
    payment method object, refer to the [Get payment method endpoint](get-method) documentation.
    """

    count: int
    r"""The number of payment method objects in this result set.
    Results are **not** paginated.
    """

    embedded: Annotated[ListMethodsEmbedded, pydantic.Field(alias="_embedded")]

    links: Annotated[ListMethodsLinks, pydantic.Field(alias="_links")]
