# Copyright (c) 2022, DjaoDjin inc.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# 1. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
# "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
# TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
# PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
# CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
# EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
# PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
# OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
# WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
# OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
# ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

from distutils.core import setup
import survey

setup(
    name='djaodjin-survey',
    version=survey.__version__,
    author='The DjaoDjin Team',
    author_email='support@djaodjin.com',
    packages=['survey',
              'survey.api',
              'survey.templatetags',
              'survey.urls',
              'survey.urls.api',
              'survey.urls.api.sample',
              'survey.urls.views',
              'survey.views'],
    package_data={'survey': [
        'static/css/*',
        'static/js/*',
        'templates/survey/*',
        'templates/survey/campaigns/*',
        'templates/survey/matrix/*']},
    url='https://github.com/djaodjin/djaodjin-survey/',
    download_url='https://github.com/djaodjin/djaodjin-survey/tarball/%s' \
        % survey.__version__,
    license='BSD',
    description='Survey Django app',
    long_description=open('README.md').read(),
)
