# generated by datamodel-codegen:
#   filename:  openapi.json
#   timestamp: 2025-03-21T21:21:27+00:00

from __future__ import annotations

from datetime import datetime
from enum import Enum
from typing import Any, Dict, List, Optional

from pydantic import AnyUrl, BaseModel, ConfigDict, EmailStr, Field, constr

from ... import (
    GlobalObjectReference,
    TypedEnvScopedObjectReference,
    TypedGlobalObjectReference,
)
from ...ListMeta import ListMeta
from ...ObjectMeta import ObjectMeta


class ApiVersion(Enum):
    iam_v2 = 'iam/v2'


class Kind(Enum):
    api_key = 'ApiKey'


class KindModel(Enum):
    api_key_list = 'ApiKeyList'


class KindModel1(Enum):
    user = 'User'


class Metadata(ObjectMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    self: Optional[Any] = Field(
        None, examples=['https://api.confluent.cloud/iam/v2/users/u-12345']
    )
    resource_name: Optional[Any] = Field(
        None, examples=['crn://confluent.cloud/user=u-12345']
    )


class User(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: Optional[ApiVersion] = Field(
        None,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Optional[KindModel1] = Field(
        None, description='Kind defines the object this REST resource represents.'
    )
    id: Optional[constr(max_length=255)] = Field(
        None,
        description='ID is the "natural identifier" for an object within its scope/namespace; it is normally unique across time but not space. That is, you can assume that the ID will not be reclaimed and reused after an object is deleted ("time"); however, it may collide with IDs for other object `kinds` or objects of the same `kind` within a different scope/namespace ("space").',
        examples=['dlz-f3a90de'],
    )
    metadata: Optional[Metadata] = None
    email: Optional[EmailStr] = Field(
        None,
        description="The user's email address",
        examples=['marty.mcfly@example.com'],
    )
    full_name: Optional[str] = Field(
        None, description="The user's full name", examples=['Marty McFly']
    )
    auth_type: Optional[str] = Field(
        None, description="The user's authentication method", examples=['AUTH_TYPE_SSO']
    )


class KindModel2(Enum):
    service_account = 'ServiceAccount'


class MetadataModel(ObjectMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    self: Optional[Any] = Field(
        None, examples=['https://api.confluent.cloud/iam/v2/service-accounts/sa-12345']
    )
    resource_name: Optional[Any] = Field(
        None, examples=['crn://confluent.cloud/service-account=sa-12345']
    )


class ServiceAccount(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: Optional[ApiVersion] = Field(
        None,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Optional[KindModel2] = Field(
        None, description='Kind defines the object this REST resource represents.'
    )
    id: Optional[constr(max_length=255)] = Field(
        None,
        description='ID is the "natural identifier" for an object within its scope/namespace; it is normally unique across time but not space. That is, you can assume that the ID will not be reclaimed and reused after an object is deleted ("time"); however, it may collide with IDs for other object `kinds` or objects of the same `kind` within a different scope/namespace ("space").',
        examples=['dlz-f3a90de'],
    )
    metadata: Optional[MetadataModel] = None
    display_name: Optional[str] = Field(
        None,
        description='A human-readable name for the Service Account',
        examples=['DeLorean_auto_repair'],
    )
    description: Optional[str] = Field(
        None,
        description='A free-form description of the Service Account',
        examples=["Doc's repair bot for the DeLorean"],
    )


class KindModel3(Enum):
    invitation = 'Invitation'


class MetadataModel1(ObjectMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    self: Optional[Any] = Field(
        None, examples=['https://api.confluent.cloud/iam/v2/invitations/i-12345']
    )
    resource_name: Optional[Any] = Field(
        None,
        examples=[
            'crn://confluent.cloud/organization=9bb441c4-edef-46ac-8a41-c49e44a3fd9a/invitation=i-12345'
        ],
    )


class KindModel4(Enum):
    user_list = 'UserList'


class MetadataModel2(ListMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    first: Optional[Any] = Field(
        None, examples=['https://api.confluent.cloud/iam/v2/users']
    )
    last: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/iam/v2/users?page_token=bcAOehAY8F16YD84Z1wT'
        ],
    )
    prev: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/iam/v2/users?page_token=YIXRY97wWYmwzrax4dld'
        ],
    )
    next: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/iam/v2/users?page_token=UvmDWOB1iwfAIBPj6EYb'
        ],
    )


class UserList(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: ApiVersion = Field(
        ...,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: KindModel4 = Field(
        ..., description='Kind defines the object this REST resource represents.'
    )
    metadata: MetadataModel2
    data: List[User] = Field(
        ...,
        description='A data property that contains an array of resource items. Each entry in the array is a separate resource.',
    )


class KindModel5(Enum):
    service_account_list = 'ServiceAccountList'


class MetadataModel3(ListMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    first: Optional[Any] = Field(
        None, examples=['https://api.confluent.cloud/iam/v2/service-accounts']
    )
    last: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/iam/v2/service-accounts?page_token=bcAOehAY8F16YD84Z1wT'
        ],
    )
    prev: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/iam/v2/service-accounts?page_token=YIXRY97wWYmwzrax4dld'
        ],
    )
    next: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/iam/v2/service-accounts?page_token=UvmDWOB1iwfAIBPj6EYb'
        ],
    )


class ServiceAccountList(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: ApiVersion = Field(
        ...,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: KindModel5 = Field(
        ..., description='Kind defines the object this REST resource represents.'
    )
    metadata: MetadataModel3
    data: List[ServiceAccount] = Field(
        ...,
        description='A data property that contains an array of resource items. Each entry in the array is a separate resource.',
    )


class KindModel6(Enum):
    invitation_list = 'InvitationList'


class MetadataModel4(ListMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    first: Optional[Any] = Field(
        None, examples=['https://api.confluent.cloud/iam/v2/invitations']
    )
    last: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/iam/v2/invitations?page_token=bcAOehAY8F16YD84Z1wT'
        ],
    )
    prev: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/iam/v2/invitations?page_token=YIXRY97wWYmwzrax4dld'
        ],
    )
    next: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/iam/v2/invitations?page_token=UvmDWOB1iwfAIBPj6EYb'
        ],
    )


class KindModel7(Enum):
    ip_group = 'IpGroup'


class MetadataModel5(ObjectMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    self: Optional[Any] = Field(
        None, examples=['https://api.confluent.cloud/iam/v2/ip-groups/ipg-12345']
    )
    resource_name: Optional[Any] = Field(
        None,
        examples=[
            'crn://confluent.cloud/organization=9bb441c4-edef-46ac-8a41-c49e44a3fd9a/ip-group=ipg-12345'
        ],
    )


class IpGroup(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: Optional[ApiVersion] = Field(
        None,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Optional[KindModel7] = Field(
        None, description='Kind defines the object this REST resource represents.'
    )
    id: Optional[constr(max_length=255)] = Field(
        None,
        description='ID is the "natural identifier" for an object within its scope/namespace; it is normally unique across time but not space. That is, you can assume that the ID will not be reclaimed and reused after an object is deleted ("time"); however, it may collide with IDs for other object `kinds` or objects of the same `kind` within a different scope/namespace ("space").',
        examples=['dlz-f3a90de'],
    )
    metadata: Optional[MetadataModel5] = None
    group_name: Optional[constr(min_length=1, max_length=64)] = Field(
        None,
        description='A human readable name for an IP Group. Can contain any unicode letter or number, the ASCII space character, or\nany of the following special characters: `[`, `]`, `|`, `&`, `+`, `-`, `_`, `/`, `.`, `,`.\n',
        examples=['CorpNet'],
    )
    cidr_blocks: Optional[List[str]] = Field(
        None,
        description='A list of CIDRs.',
        examples=[['192.168.0.0/24', '192.168.7.0/24']],
        max_length=25,
        min_length=1,
    )


class KindModel8(Enum):
    ip_filter = 'IpFilter'


class MetadataModel6(ObjectMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    self: Optional[Any] = Field(
        None, examples=['https://api.confluent.cloud/iam/v2/ip-filters/ipf-12345']
    )
    resource_name: Optional[Any] = Field(
        None,
        examples=[
            'crn://confluent.cloud/organization=9bb441c4-edef-46ac-8a41-c49e44a3fd9a/ip-filter=ipf-12345'
        ],
    )


class IpFilter(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: Optional[ApiVersion] = Field(
        None,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Optional[KindModel8] = Field(
        None, description='Kind defines the object this REST resource represents.'
    )
    id: Optional[constr(max_length=255)] = Field(
        None,
        description='ID is the "natural identifier" for an object within its scope/namespace; it is normally unique across time but not space. That is, you can assume that the ID will not be reclaimed and reused after an object is deleted ("time"); however, it may collide with IDs for other object `kinds` or objects of the same `kind` within a different scope/namespace ("space").',
        examples=['dlz-f3a90de'],
    )
    metadata: Optional[MetadataModel6] = None
    filter_name: Optional[constr(min_length=1, max_length=64)] = Field(
        None,
        description='A human readable name for an IP Filter. Can contain any unicode letter or number, the ASCII space character,\nor any of the following special characters: `[`, `]`, `|`, `&`, `+`, `-`, `_`, `/`, `.`, `,`.\n',
        examples=['Management API Rules'],
    )
    resource_group: Optional[str] = Field(
        None,
        description='Scope of resources covered by this IP filter. Available resource groups include "management" and "multiple".\n',
        examples=['management'],
    )
    resource_scope: Optional[AnyUrl] = Field(
        None,
        description='A CRN that specifies the scope of the ip filter, specifically the organization\nor environment. Without specifying this property, the ip filter\nwould apply to the whole organization.\n',
        examples=['crn://confluent.cloud/organization=org-123/environment=env-abc'],
    )
    operation_groups: Optional[List[str]] = Field(
        None,
        description="Scope of resources covered by this IP filter. Resource group must be set to 'multiple'\nin order to use this property.During update operations, note that the operation\ngroups passed in will replace the list of existing operation groups\n(passing in an empty list will remove all operation groups) from the filter\n(in line with the behavior for ip_groups).\n",
        examples=[['MANAGEMENT', 'SCHEMA']],
    )
    ip_groups: Optional[List[GlobalObjectReference]] = Field(
        None, description='A list of IP Groups.', max_length=25, min_length=1
    )


class KindModel9(Enum):
    ip_filter_summary = 'IpFilterSummary'


class OperationGroup(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    name: Optional[str] = Field(None, description='Name of the operation group.')
    status: Optional[str] = Field(None, description='Open, limited, or no access.')


class Category(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    name: Optional[str] = Field(None, description='Name of the category.')
    status: Optional[str] = Field(None, description='Open, limited, or mixed.')
    operation_groups: Optional[List[OperationGroup]] = Field(
        None, description='Operation groups part of this category.'
    )


class IpFilterSummary(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: Optional[ApiVersion] = Field(
        None,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Optional[KindModel9] = Field(
        None, description='Kind defines the object this REST resource represents.'
    )
    scope: Optional[str] = Field(
        None, description='The scope associated with this object.'
    )
    categories: Optional[List[Category]] = Field(
        None,
        description='Summary of the operation groups and IP filters created in those operation groups.\n',
        examples=[
            [
                {
                    'name': 'management',
                    'status': 'MIXED',
                    'operation_groups': [{'name': 'MANAGEMENT', 'status': 'LIMITED'}],
                }
            ]
        ],
    )


class KindModel10(Enum):
    ip_group_list = 'IpGroupList'


class MetadataModel7(ListMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    first: Optional[Any] = Field(
        None, examples=['https://api.confluent.cloud/iam/v2/ip-groups']
    )
    last: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/iam/v2/ip-groups?page_token=bcAOehAY8F16YD84Z1wT'
        ],
    )
    prev: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/iam/v2/ip-groups?page_token=YIXRY97wWYmwzrax4dld'
        ],
    )
    next: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/iam/v2/ip-groups?page_token=UvmDWOB1iwfAIBPj6EYb'
        ],
    )


class IpGroupList(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: ApiVersion = Field(
        ...,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: KindModel10 = Field(
        ..., description='Kind defines the object this REST resource represents.'
    )
    metadata: MetadataModel7
    data: List[IpGroup] = Field(
        ...,
        description='A data property that contains an array of resource items. Each entry in the array is a separate resource.',
    )


class KindModel11(Enum):
    ip_filter_list = 'IpFilterList'


class MetadataModel8(ListMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    first: Optional[Any] = Field(
        None, examples=['https://api.confluent.cloud/iam/v2/ip-filters']
    )
    last: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/iam/v2/ip-filters?page_token=bcAOehAY8F16YD84Z1wT'
        ],
    )
    prev: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/iam/v2/ip-filters?page_token=YIXRY97wWYmwzrax4dld'
        ],
    )
    next: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/iam/v2/ip-filters?page_token=UvmDWOB1iwfAIBPj6EYb'
        ],
    )


class IpFilterList(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: ApiVersion = Field(
        ...,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: KindModel11 = Field(
        ..., description='Kind defines the object this REST resource represents.'
    )
    metadata: MetadataModel8
    data: List[IpFilter] = Field(
        ...,
        description='A data property that contains an array of resource items. Each entry in the array is a separate resource.',
    )


class KindModel12(Enum):
    role_binding = 'RoleBinding'


class MetadataModel9(ObjectMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    self: Optional[Any] = Field(
        None, examples=['https://api.confluent.cloud/iam/v2/role-bindings/rb-12345']
    )
    resource_name: Optional[Any] = Field(
        None,
        examples=[
            'crn://confluent.cloud/organization=9bb441c4-edef-46ac-8a41-c49e44a3fd9a/role-binding=rb-12345'
        ],
    )


class RoleBinding(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: Optional[ApiVersion] = Field(
        None,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Optional[KindModel12] = Field(
        None, description='Kind defines the object this REST resource represents.'
    )
    id: Optional[constr(max_length=255)] = Field(
        None,
        description='ID is the "natural identifier" for an object within its scope/namespace; it is normally unique across time but not space. That is, you can assume that the ID will not be reclaimed and reused after an object is deleted ("time"); however, it may collide with IDs for other object `kinds` or objects of the same `kind` within a different scope/namespace ("space").',
        examples=['dlz-f3a90de'],
    )
    metadata: Optional[MetadataModel9] = None
    principal: Optional[constr(pattern=r'(^User:.+$)')] = Field(
        None,
        description='The principal User to bind the role to',
        examples=['User:u-111aaa'],
    )
    role_name: Optional[str] = Field(
        None,
        description='The name of the role to bind to the principal',
        examples=['CloudClusterAdmin'],
    )
    crn_pattern: Optional[AnyUrl] = Field(
        None,
        description='A CRN that specifies the scope and resource patterns necessary for the role to bind',
        examples=[
            'crn://confluent.cloud/organization=1111aaaa-11aa-11aa-11aa-111111aaaaaa/environment=env-aaa1111/cloud-cluster=lkc-1111aaa'
        ],
    )


class KindModel13(Enum):
    role_binding_list = 'RoleBindingList'


class MetadataModel10(ListMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    first: Optional[Any] = Field(
        None, examples=['https://api.confluent.cloud/iam/v2/role-bindings']
    )
    last: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/iam/v2/role-bindings?page_token=bcAOehAY8F16YD84Z1wT'
        ],
    )
    prev: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/iam/v2/role-bindings?page_token=YIXRY97wWYmwzrax4dld'
        ],
    )
    next: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/iam/v2/role-bindings?page_token=UvmDWOB1iwfAIBPj6EYb'
        ],
    )


class RoleBindingList(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: ApiVersion = Field(
        ...,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: KindModel13 = Field(
        ..., description='Kind defines the object this REST resource represents.'
    )
    metadata: MetadataModel10
    data: List[RoleBinding] = Field(
        ...,
        description='A data property that contains an array of resource items. Each entry in the array is a separate resource.',
    )


class Kind1(Enum):
    identity_provider = 'IdentityProvider'


class Metadata1(ObjectMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    self: Optional[Any] = Field(
        None,
        examples=['https://api.confluent.cloud/iam/v2/identity-providers/ip-12345'],
    )
    resource_name: Optional[Any] = Field(
        None,
        examples=[
            'crn://confluent.cloud/organization=9bb441c4-edef-46ac-8a41-c49e44a3fd9a/identity-provider=ip-12345'
        ],
    )


class Kind1Model(Enum):
    jwks = 'Jwks'


class JwksStatus(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    jwks_status: Optional[str] = Field(
        None,
        description='The actual state of the public key data',
        examples=['REFRESHED'],
    )
    jwks_last_refresh_at: Optional[datetime] = Field(
        None,
        description='The last successful refresh time for the public key data',
        examples=['2006-01-02T15:04:05-07:00'],
    )


class Kind1Model1(Enum):
    identity_pool = 'IdentityPool'


class Metadata1Model(ObjectMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    self: Optional[Any] = Field(
        None, examples=['https://api.confluent.cloud/iam/v2/identity-pools/ip-12345']
    )
    resource_name: Optional[Any] = Field(
        None,
        examples=[
            'crn://confluent.cloud/organization=9bb441c4-edef-46ac-8a41-c49e44a3fd9a/identity-pool=ip-12345'
        ],
    )


class IdentityPool(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: Optional[ApiVersion] = Field(
        None,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Optional[Kind1Model1] = Field(
        None, description='Kind defines the object this REST resource represents.'
    )
    id: Optional[constr(max_length=255)] = Field(
        None,
        description='ID is the "natural identifier" for an object within its scope/namespace; it is normally unique across time but not space. That is, you can assume that the ID will not be reclaimed and reused after an object is deleted ("time"); however, it may collide with IDs for other object `kinds` or objects of the same `kind` within a different scope/namespace ("space").',
        examples=['dlz-f3a90de'],
    )
    metadata: Optional[Metadata1Model] = None
    display_name: Optional[str] = Field(
        None,
        description='The name of the `IdentityPool`.',
        examples=['My Identity Pool'],
    )
    description: Optional[str] = Field(
        None,
        description='A description of how this `IdentityPool` is used',
        examples=['Prod Access to Kafka clusters to Release Engineering'],
    )
    identity_claim: Optional[str] = Field(
        None,
        description='The JSON Web Token (JWT) claim to extract the authenticating identity to Confluent resources from\n(see [Registered Claim Names](https://datatracker.ietf.org/doc/html/rfc7519#section-4.1) for more details).\nThis appears in the audit log records, showing, for example, that "identity Z used identity pool X to access\ntopic A".',
        examples=['claims.sub'],
    )
    filter: Optional[constr(max_length=300)] = Field(
        None,
        description='A filter expression in [Supported Common Expression Language (CEL)](https://docs.confluent.io/cloud/current/access-management/authenticate/oauth/identity-pools.html#supported-common-expression-language-cel-filters) that specifies which identities can authenticate using your identity pool (see [Set identity pool filters](https://docs.confluent.io/cloud/current/access-management/authenticate/oauth/identity-pools.html#set-identity-pool-filters) for more details).',
        examples=['claims.aud=="confluent" && claims.group!="invalid_group"'],
    )
    principal: Optional[str] = Field(
        None,
        description='Represents the federated identity associated with this pool.',
        examples=['pool-abc'],
    )
    state: Optional[str] = Field(
        None, description='The current state of the identity pool', examples=['ENABLED']
    )


class JwksObject(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    kty: str = Field(
        ...,
        description='Specifies the cryptographic algorithm family used with the key',
        examples=['RSA'],
    )
    kid: str = Field(
        ...,
        description='Specifies the key-id issued by the OpenIDProvider for the particular tenant',
        examples=['nOo3ZDrODXEK1jKWhXslHR_KXEg'],
    )
    alg: str = Field(
        ...,
        description='Specifies the algorithm to be used to generate the public key',
        examples=['RS256'],
    )
    use: Optional[str] = Field(
        None, description='Specifies the intended usage of the key', examples=['sig']
    )
    n: Optional[str] = Field(
        None,
        description='Specifies the modulus of the RSA public key. Represented as a Base64urlUInt-encoded value',
    )
    e: Optional[str] = Field(
        None,
        description='Specifies the exponent of the RSA public key.',
        examples=['AQAB'],
    )


class Kind1Model2(Enum):
    identity_provider_list = 'IdentityProviderList'


class Metadata1Model1(ListMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    first: Optional[Any] = Field(
        None, examples=['https://api.confluent.cloud/iam/v2/identity-providers']
    )
    last: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/iam/v2/identity-providers?page_token=bcAOehAY8F16YD84Z1wT'
        ],
    )
    prev: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/iam/v2/identity-providers?page_token=YIXRY97wWYmwzrax4dld'
        ],
    )
    next: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/iam/v2/identity-providers?page_token=UvmDWOB1iwfAIBPj6EYb'
        ],
    )


class JwksSpec(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    jwks_status: Optional[str] = Field(
        None,
        description='The desired state of the public key data',
        examples=['REFRESHED'],
    )


class Kind1Model3(Enum):
    identity_pool_list = 'IdentityPoolList'


class Metadata1Model2(ListMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    first: Optional[Any] = Field(
        None, examples=['https://api.confluent.cloud/iam/v2/identity-pools']
    )
    last: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/iam/v2/identity-pools?page_token=bcAOehAY8F16YD84Z1wT'
        ],
    )
    prev: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/iam/v2/identity-pools?page_token=YIXRY97wWYmwzrax4dld'
        ],
    )
    next: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/iam/v2/identity-pools?page_token=UvmDWOB1iwfAIBPj6EYb'
        ],
    )


class IdentityPoolList(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: ApiVersion = Field(
        ...,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Kind1Model3 = Field(
        ..., description='Kind defines the object this REST resource represents.'
    )
    metadata: Metadata1Model2
    data: List[IdentityPool] = Field(
        ...,
        description='A data property that contains an array of resource items. Each entry in the array is a separate resource.',
    )


class Kind1Model4(Enum):
    certificate_authority = 'CertificateAuthority'


class Metadata1Model3(ObjectMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    self: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/iam/v2/certificate-authorities/op-12345'
        ],
    )
    resource_name: Optional[Any] = Field(
        None,
        examples=[
            'crn://confluent.cloud/organization=9bb441c4-edef-46ac-8a41-c49e44a3fd9a/certificate-authority=op-12345'
        ],
    )


class CertificateAuthority(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: Optional[ApiVersion] = Field(
        None,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Optional[Kind1Model4] = Field(
        None, description='Kind defines the object this REST resource represents.'
    )
    id: Optional[constr(max_length=255)] = Field(
        None,
        description='ID is the "natural identifier" for an object within its scope/namespace; it is normally unique across time but not space. That is, you can assume that the ID will not be reclaimed and reused after an object is deleted ("time"); however, it may collide with IDs for other object `kinds` or objects of the same `kind` within a different scope/namespace ("space").',
        examples=['dlz-f3a90de'],
    )
    metadata: Optional[Metadata1Model3] = None
    display_name: Optional[str] = Field(
        None,
        description='The human-readable name of the certificate authority.',
        examples=['My Certificate Authority'],
    )
    description: Optional[str] = Field(
        None,
        description='A description of the certificate authority.',
        examples=['Sample description text'],
    )
    fingerprints: Optional[List[str]] = Field(
        None,
        description='The fingerprints for each certificate in the certificate chain. These are SHA-1 encoded\nstrings that act as unique identifiers for the certificates in the chain.',
        examples=[['B1BC968BD4f49D622AA89A81F2150152A41D829C']],
    )
    expiration_dates: Optional[List[datetime]] = Field(
        None,
        description='The expiration dates of certificates in the chain.',
        examples=[['2017-07-21T17:32:28Z']],
    )
    serial_numbers: Optional[List[str]] = Field(
        None,
        description='The serial numbers for each certificate in the certificate chain.',
        examples=[['219C542DE8f6EC7177FA4EE8C3705797']],
    )
    certificate_chain_filename: Optional[str] = Field(
        None,
        description='The file name of the uploaded pem file for this certificate authority.',
        examples=['certificate.pem'],
    )
    crl_source: Optional[str] = Field(
        None,
        description='The source specifies whether the Certificate Revocation List (CRL) is updated from\neither local file uploaded (LOCAL) or from url of CRL (URL).',
        examples=['LOCAL'],
    )
    crl_url: Optional[AnyUrl] = Field(
        None,
        description='The url from which to fetch the CRL for the certificate authority if crl_source is URL.',
    )
    crl_updated_at: Optional[datetime] = Field(
        None,
        description='The timestamp for when CRL was last updated.',
        examples=['2017-07-21T17:32:28Z'],
    )
    state: Optional[str] = Field(
        None,
        description='The current state of the certificate authority.',
        examples=['ENABLED'],
    )


class Kind1Model5(Enum):
    certificate_identity_pool = 'CertificateIdentityPool'


class Metadata1Model4(ObjectMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    self: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/iam/v2/certificate-identity-pools/pool-12345'
        ],
    )
    resource_name: Optional[Any] = Field(
        None,
        examples=[
            'crn://confluent.cloud/organization=9bb441c4-edef-46ac-8a41-c49e44a3fd9a/certificate-identity-pool=pool-12345'
        ],
    )


class CertificateIdentityPool(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: Optional[ApiVersion] = Field(
        None,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Optional[Kind1Model5] = Field(
        None, description='Kind defines the object this REST resource represents.'
    )
    id: Optional[constr(max_length=255)] = Field(
        None,
        description='ID is the "natural identifier" for an object within its scope/namespace; it is normally unique across time but not space. That is, you can assume that the ID will not be reclaimed and reused after an object is deleted ("time"); however, it may collide with IDs for other object `kinds` or objects of the same `kind` within a different scope/namespace ("space").',
        examples=['dlz-f3a90de'],
    )
    metadata: Optional[Metadata1Model4] = None
    display_name: Optional[str] = Field(
        None,
        description='The name of the `IdentityPool`.',
        examples=['My Identity Pool'],
    )
    description: Optional[str] = Field(
        None,
        description='A description of how this `IdentityPool` is used',
        examples=['Prod Access to Kafka clusters to Release Engineering'],
    )
    external_identifier: Optional[str] = Field(
        None,
        description="The certificate field that will be used to represent the\npool's external identifier for audit logging.",
        examples=['UID'],
    )
    filter: Optional[constr(max_length=300)] = Field(
        None,
        description='A filter expression in [Supported Common Expression Language (CEL)](https://docs.confluent.io/cloud/current/access-management/authenticate/mtls/cel-filters.html) that specifies which identities can authenticate using your certificate identity pool (see [CEL filter for mTLS](https://docs.confluent.io/cloud/current/access-management/authenticate/mtls/cel-filters.html) for more details).',
        examples=["C=='Canada' && O=='Confluent'"],
    )
    principal: Optional[str] = Field(
        None,
        description='Represents the federated identity associated with this pool.',
        examples=['pool-abc'],
    )
    state: Optional[str] = Field(
        None, description='The current state of the identity pool', examples=['ENABLED']
    )


class Kind1Model6(Enum):
    create_cert_request = 'CreateCertRequest'


class Metadata1Model5(ObjectMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    self: Optional[Any] = Field(
        None,
        examples=['https://api.confluent.cloud/iam/v2/create-cert-requests/ccr-12345'],
    )
    resource_name: Optional[Any] = Field(
        None,
        examples=[
            'crn://confluent.cloud/organization=9bb441c4-edef-46ac-8a41-c49e44a3fd9a/create-cert-request=ccr-12345'
        ],
    )


class CreateCertRequest(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: Optional[ApiVersion] = Field(
        None,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Optional[Kind1Model6] = Field(
        None, description='Kind defines the object this REST resource represents.'
    )
    id: Optional[constr(max_length=255)] = Field(
        None,
        description='ID is the "natural identifier" for an object within its scope/namespace; it is normally unique across time but not space. That is, you can assume that the ID will not be reclaimed and reused after an object is deleted ("time"); however, it may collide with IDs for other object `kinds` or objects of the same `kind` within a different scope/namespace ("space").',
        examples=['dlz-f3a90de'],
    )
    metadata: Optional[Metadata1Model5] = None
    display_name: Optional[str] = Field(
        None,
        description='The human-readable name of the certificate authority.',
        examples=['My Certificate Authority'],
    )
    description: Optional[str] = Field(
        None,
        description='A description of the certificate authority.',
        examples=['Sample description text'],
    )
    certificate_chain: Optional[str] = Field(
        None,
        description='The PEM encoded string containing the signing certificate chain\nused to validate client certs.',
        examples=[
            '-----BEGIN CERTIFICATE-----\nMIIDdTCCAl2gAwIBAgILBAAAAAABFUtaw5QwDQYJKoZIhvcNAQEFBQAwVzELMAkGA1UEBhMCQkUx\nGTAXBgNVBAoTEEdsb2JhbFNpZ24gbnYtc2ExEDAOBgNVBAsTB1Jvb3QgQ0ExGzAZBgNVBAMTEkds\nb2JhbFNpZ24gUm9vdCBDQTAeFw05ODA5MDExMjAwMDBaFw0yODAxMjgxMjAwMDBaMFcxCzAJBgNV\nBAYTAkJFMRkwFwYDVQQKExBHbG9iYWxTaWduIG52LXNhMRAwDgYDVQQLEwdSb290IENBMRswGQYD\nVQQDExJHbG9iYWxTaWduIFJvb3QgQ0EwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDa\nDuaZjc6j40+Kfvvxi4Mla+pIH/EqsLmVEQS98GPR4mdmzxzdzxtIK+6NiY6arymAZavpxy0Sy6sc\nTHAHoT0KMM0VjU/43dSMUBUc71DuxC73/OlS8pF94G3VNTCOXkNz8kHp1Wrjsok6Vjk4bwY8iGlb\nKk3Fp1S4bInMm/k8yuX9ifUSPJJ4ltbcdG6TRGHRjcdGsnUOhugZitVtbNV4FpWi6cgKOOvyJBNP\nc1STE4U6G7weNLWLBYy5d4ux2x8gkasJU26Qzns3dLlwR5EiUWMWea6xrkEmCMgZK9FGqkjWZCrX\ngzT/LCrBbBlDSgeF59N89iFo7+ryUp9/k5DPAgMBAAGjQjBAMA4GA1UdDwEB/wQEAwIBBjAPBgNV\nHRMBAf8EBTADAQH/MB0GA1UdDgQWBBRge2YaRQ2XyolQL30EzTSo//z9SzANBgkqhkiG9w0BAQUF\nAAOCAQEA1nPnfE920I2/7LqivjTFKDK1fPxsnCwrvQmeU79rXqoRSLblCKOzyj1hTdNGCbM+w6Dj\nY1Ub8rrvrTnhQ7k4o+YviiY776BQVvnGCv04zcQLcFGUl5gE38NflNUVyRRBnMRddWQVDf9VMOyG\nj/8N7yy5Y0b2qvzfvGn9LhJIZJrglfCm7ymPAbEVtQwdpf5pLGkkeB6zpxxxYu7KyJesF12KwvhH\nhm4qxFYxldBniYUr+WymXUadDKqC5JlR3XC321Y9YeRq4VzW9v493kHMB65jUr9TU/Qr6cf9tveC\nX4XSQRjbgbMEHMUfpIBvFSDJ3gyICh3WZlXi/EjJKSZp4A==\n-----END CERTIFICATE-----'
        ],
    )
    certificate_chain_filename: Optional[str] = Field(
        None,
        description='The name of the certificate file.',
        examples=['certificate.pem'],
    )
    crl_url: Optional[AnyUrl] = Field(
        None,
        description='The url from which to fetch the CRL for the certificate authority if crl_source is URL.',
    )
    crl_chain: Optional[str] = Field(
        None,
        description='The PEM encoded string containing the CRL for this certificate authority.\nDefaults to this over `crl_url` if available.',
        examples=[
            '-----BEGIN X509 CRL-----\nMIICNTCCAR0CAQEwDQYJKoZIhvcNAQELBQAwgbExCzAJBgNVBAYTAlVTMQswCQYD\nVQQIDAJDQTEWMBQGA1UEBwwNTW91bnRhaW4gVmlldzESMBAGA1UECgwJQ29uZmx1\nZW50MRMwEQYDVQQLDApzZWN1cml0eS0xMSYwJAYDVQQDDB1tdGxzMS5zZWN1cml0\neS0xLmNvbmZsdWVudC5pbzEsMCoGCSqGSIb3DQEJARYdbXRsczFAc2VjdXJpdHkt\nMS5jb25mbHVlbnQuaW8XDTI0MDgyNTE3NTYyNloXDTI0MTEyMzE3NTYyNlowJzAl\nAhQERu3UxH2q3eUglbdeQY8y0vT7rRcNMjQwODI1MTc1NTE2WqAOMAwwCgYDVR0U\nBAMCAQEwDQYJKoZIhvcNAQELBQADggEBAGvmflwxVAnqZbRx8njb2t6yXqeIOBaX\nCKhMq5CUWrWhMX/JrV5NhVfzeB2tgCCfM4J7gbKSArOKqjYpQBFL+r5eCjPBBcG4\nxqh1J60l5DDsiUcXQM5FtlWTBBZFxvvvWsLP4qA/0meYRY69YQNqgEQgQ65l0Ehl\ngIUx8WkEo82A8MDY/t91PaFHufnffPKu4CxFtcpGwuvA2n9mpxB2TsSTiV8THsfE\njatuFwYgumI6t5wIWb71j/1oqQDYtbgpgUvX9gD+g7HlCC4u6Dynd0q8lsimrbf6\ncGf5Vs3JfMcr1kYNruT7kg4f4hc3p4CcuWtxYmHOcWNyZbi+W9Fdakg=\n-----END X509 CRL-----'
        ],
    )


class Kind1Model7(Enum):
    update_cert_request = 'UpdateCertRequest'


class Metadata1Model6(ObjectMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    self: Optional[Any] = Field(
        None,
        examples=['https://api.confluent.cloud/iam/v2/update-cert-requests/ucr-12345'],
    )
    resource_name: Optional[Any] = Field(
        None,
        examples=[
            'crn://confluent.cloud/organization=9bb441c4-edef-46ac-8a41-c49e44a3fd9a/update-cert-request=ucr-12345'
        ],
    )


class UpdateCertRequest(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: Optional[ApiVersion] = Field(
        None,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Optional[Kind1Model7] = Field(
        None, description='Kind defines the object this REST resource represents.'
    )
    id: Optional[constr(max_length=255)] = Field(
        None,
        description='ID is the "natural identifier" for an object within its scope/namespace; it is normally unique across time but not space. That is, you can assume that the ID will not be reclaimed and reused after an object is deleted ("time"); however, it may collide with IDs for other object `kinds` or objects of the same `kind` within a different scope/namespace ("space").',
        examples=['dlz-f3a90de'],
    )
    metadata: Optional[Metadata1Model6] = None
    display_name: Optional[str] = Field(
        None,
        description='The human-readable name of the certificate authority.',
        examples=['My Certificate Authority'],
    )
    description: Optional[str] = Field(
        None,
        description='A description of the certificate authority.',
        examples=['Sample description text'],
    )
    certificate_chain: Optional[str] = Field(
        None,
        description='The PEM encoded string containing the signing certificate chain\nused to validate client certs.',
        examples=[
            '-----BEGIN CERTIFICATE-----\nMIIDdTCCAl2gAwIBAgILBAAAAAABFUtaw5QwDQYJKoZIhvcNAQEFBQAwVzELMAkGA1UEBhMCQkUx\nGTAXBgNVBAoTEEdsb2JhbFNpZ24gbnYtc2ExEDAOBgNVBAsTB1Jvb3QgQ0ExGzAZBgNVBAMTEkds\nb2JhbFNpZ24gUm9vdCBDQTAeFw05ODA5MDExMjAwMDBaFw0yODAxMjgxMjAwMDBaMFcxCzAJBgNV\nBAYTAkJFMRkwFwYDVQQKExBHbG9iYWxTaWduIG52LXNhMRAwDgYDVQQLEwdSb290IENBMRswGQYD\nVQQDExJHbG9iYWxTaWduIFJvb3QgQ0EwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDa\nDuaZjc6j40+Kfvvxi4Mla+pIH/EqsLmVEQS98GPR4mdmzxzdzxtIK+6NiY6arymAZavpxy0Sy6sc\nTHAHoT0KMM0VjU/43dSMUBUc71DuxC73/OlS8pF94G3VNTCOXkNz8kHp1Wrjsok6Vjk4bwY8iGlb\nKk3Fp1S4bInMm/k8yuX9ifUSPJJ4ltbcdG6TRGHRjcdGsnUOhugZitVtbNV4FpWi6cgKOOvyJBNP\nc1STE4U6G7weNLWLBYy5d4ux2x8gkasJU26Qzns3dLlwR5EiUWMWea6xrkEmCMgZK9FGqkjWZCrX\ngzT/LCrBbBlDSgeF59N89iFo7+ryUp9/k5DPAgMBAAGjQjBAMA4GA1UdDwEB/wQEAwIBBjAPBgNV\nHRMBAf8EBTADAQH/MB0GA1UdDgQWBBRge2YaRQ2XyolQL30EzTSo//z9SzANBgkqhkiG9w0BAQUF\nAAOCAQEA1nPnfE920I2/7LqivjTFKDK1fPxsnCwrvQmeU79rXqoRSLblCKOzyj1hTdNGCbM+w6Dj\nY1Ub8rrvrTnhQ7k4o+YviiY776BQVvnGCv04zcQLcFGUl5gE38NflNUVyRRBnMRddWQVDf9VMOyG\nj/8N7yy5Y0b2qvzfvGn9LhJIZJrglfCm7ymPAbEVtQwdpf5pLGkkeB6zpxxxYu7KyJesF12KwvhH\nhm4qxFYxldBniYUr+WymXUadDKqC5JlR3XC321Y9YeRq4VzW9v493kHMB65jUr9TU/Qr6cf9tveC\nX4XSQRjbgbMEHMUfpIBvFSDJ3gyICh3WZlXi/EjJKSZp4A==\n-----END CERTIFICATE-----'
        ],
    )
    certificate_chain_filename: Optional[str] = Field(
        None,
        description='The name of the certificate file. Must be set if certificate is updated.',
        examples=['certificate.pem'],
    )
    crl_url: Optional[AnyUrl] = Field(
        None,
        description='The url from which to fetch the CRL for the certificate authority if crl_source is URL.',
    )
    crl_chain: Optional[str] = Field(
        None,
        description='The PEM encoded string containing the CRL for this certificate authority.\nDefaults to this over `crl_url` if available.',
        examples=[
            '-----BEGIN X509 CRL-----\nMIICNTCCAR0CAQEwDQYJKoZIhvcNAQELBQAwgbExCzAJBgNVBAYTAlVTMQswCQYD\nVQQIDAJDQTEWMBQGA1UEBwwNTW91bnRhaW4gVmlldzESMBAGA1UECgwJQ29uZmx1\nZW50MRMwEQYDVQQLDApzZWN1cml0eS0xMSYwJAYDVQQDDB1tdGxzMS5zZWN1cml0\neS0xLmNvbmZsdWVudC5pbzEsMCoGCSqGSIb3DQEJARYdbXRsczFAc2VjdXJpdHkt\nMS5jb25mbHVlbnQuaW8XDTI0MDgyNTE3NTYyNloXDTI0MTEyMzE3NTYyNlowJzAl\nAhQERu3UxH2q3eUglbdeQY8y0vT7rRcNMjQwODI1MTc1NTE2WqAOMAwwCgYDVR0U\nBAMCAQEwDQYJKoZIhvcNAQELBQADggEBAGvmflwxVAnqZbRx8njb2t6yXqeIOBaX\nCKhMq5CUWrWhMX/JrV5NhVfzeB2tgCCfM4J7gbKSArOKqjYpQBFL+r5eCjPBBcG4\nxqh1J60l5DDsiUcXQM5FtlWTBBZFxvvvWsLP4qA/0meYRY69YQNqgEQgQ65l0Ehl\ngIUx8WkEo82A8MDY/t91PaFHufnffPKu4CxFtcpGwuvA2n9mpxB2TsSTiV8THsfE\njatuFwYgumI6t5wIWb71j/1oqQDYtbgpgUvX9gD+g7HlCC4u6Dynd0q8lsimrbf6\ncGf5Vs3JfMcr1kYNruT7kg4f4hc3p4CcuWtxYmHOcWNyZbi+W9Fdakg=\n-----END X509 CRL-----'
        ],
    )


class Kind1Model8(Enum):
    certificate_authority_list = 'CertificateAuthorityList'


class Metadata1Model7(ListMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    first: Optional[Any] = Field(
        None, examples=['https://api.confluent.cloud/iam/v2/certificate-authorities']
    )
    last: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/iam/v2/certificate-authorities?page_token=bcAOehAY8F16YD84Z1wT'
        ],
    )
    prev: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/iam/v2/certificate-authorities?page_token=YIXRY97wWYmwzrax4dld'
        ],
    )
    next: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/iam/v2/certificate-authorities?page_token=UvmDWOB1iwfAIBPj6EYb'
        ],
    )


class CertificateAuthorityList(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: ApiVersion = Field(
        ...,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Kind1Model8 = Field(
        ..., description='Kind defines the object this REST resource represents.'
    )
    metadata: Metadata1Model7
    data: List[CertificateAuthority] = Field(
        ...,
        description='A data property that contains an array of resource items. Each entry in the array is a separate resource.',
    )


class Kind1Model9(Enum):
    certificate_identity_pool_list = 'CertificateIdentityPoolList'


class Metadata1Model8(ListMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    first: Optional[Any] = Field(
        None, examples=['https://api.confluent.cloud/iam/v2/certificate-identity-pools']
    )
    last: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/iam/v2/certificate-identity-pools?page_token=bcAOehAY8F16YD84Z1wT'
        ],
    )
    prev: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/iam/v2/certificate-identity-pools?page_token=YIXRY97wWYmwzrax4dld'
        ],
    )
    next: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/iam/v2/certificate-identity-pools?page_token=UvmDWOB1iwfAIBPj6EYb'
        ],
    )


class CertificateIdentityPoolList(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: ApiVersion = Field(
        ...,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Kind1Model9 = Field(
        ..., description='Kind defines the object this REST resource represents.'
    )
    metadata: Metadata1Model8
    data: List[CertificateIdentityPool] = Field(
        ...,
        description='A data property that contains an array of resource items. Each entry in the array is a separate resource.',
    )


class ApiKeySpecUpdate(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    display_name: Optional[str] = Field(
        None,
        description='A human readable name for the API key',
        examples=['CI kafka access key'],
    )
    description: Optional[str] = Field(
        None,
        description='A human readable description for the API key',
        examples=['This API key provides kafka access to cluster x'],
    )


class Kind1Model10(Enum):
    api_key = 'ApiKey'


class Metadata1Model9(ObjectMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    self: Optional[Any] = Field(
        None, examples=['https://api.confluent.cloud/iam/v2/api-keys/ak-12345']
    )
    resource_name: Optional[Any] = Field(
        None,
        examples=[
            'crn://confluent.cloud/organization=9bb441c4-edef-46ac-8a41-c49e44a3fd9a/api-key=ak-12345'
        ],
    )


class ApiKeyUpdate(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: Optional[ApiVersion] = Field(
        None,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Optional[Kind1Model10] = Field(
        None, description='Kind defines the object this REST resource represents.'
    )
    id: Optional[constr(max_length=255)] = Field(
        None,
        description='ID is the "natural identifier" for an object within its scope/namespace; it is normally unique across time but not space. That is, you can assume that the ID will not be reclaimed and reused after an object is deleted ("time"); however, it may collide with IDs for other object `kinds` or objects of the same `kind` within a different scope/namespace ("space").',
        examples=['dlz-f3a90de'],
    )
    metadata: Optional[Metadata1Model9] = None
    spec: Optional[ApiKeySpecUpdate] = None


class Kind1Model11(Enum):
    user = 'User'


class Metadata1Model10(ObjectMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    self: Optional[Any] = Field(
        None, examples=['https://api.confluent.cloud/iam/v2/users/u-12345']
    )
    resource_name: Optional[Any] = Field(
        None, examples=['crn://confluent.cloud/user=u-12345']
    )


class UserUpdate(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: Optional[ApiVersion] = Field(
        None,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Optional[Kind1Model11] = Field(
        None, description='Kind defines the object this REST resource represents.'
    )
    id: Optional[constr(max_length=255)] = Field(
        None,
        description='ID is the "natural identifier" for an object within its scope/namespace; it is normally unique across time but not space. That is, you can assume that the ID will not be reclaimed and reused after an object is deleted ("time"); however, it may collide with IDs for other object `kinds` or objects of the same `kind` within a different scope/namespace ("space").',
        examples=['dlz-f3a90de'],
    )
    metadata: Optional[Metadata1Model10] = None
    full_name: Optional[str] = Field(
        None, description="The user's full name", examples=['Marty McFly']
    )
    auth_type: Optional[str] = Field(
        None, description="The user's authentication method", examples=['AUTH_TYPE_SSO']
    )


class MetadataModel11(ObjectMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    self: Optional[Any] = Field(
        None, examples=['https://api.confluent.cloud/iam/v2/api-keys/ak-12345']
    )
    resource_name: Optional[Any] = Field(
        None,
        examples=[
            'crn://confluent.cloud/organization=9bb441c4-edef-46ac-8a41-c49e44a3fd9a/api-key=ak-12345'
        ],
    )


class MetadataModel12(ListMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    first: Optional[Any] = Field(
        None, examples=['https://api.confluent.cloud/iam/v2/api-keys']
    )
    last: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/iam/v2/api-keys?page_token=bcAOehAY8F16YD84Z1wT'
        ],
    )
    prev: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/iam/v2/api-keys?page_token=YIXRY97wWYmwzrax4dld'
        ],
    )
    next: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/iam/v2/api-keys?page_token=UvmDWOB1iwfAIBPj6EYb'
        ],
    )


class ApiKeySpec(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    secret: Optional[str] = Field(
        None,
        description='The API key secret. Only provided in `create` responses, not in `get` or `list`.',
        examples=['R15hoiDIq8Nxu/lY4mPO3DwAVIfU5W7OI+efsB607mLgHTnVW5XJGVqX2ysDx987'],
    )
    display_name: Optional[str] = Field(
        None,
        description='A human readable name for the API key',
        examples=['CI kafka access key'],
    )
    description: Optional[str] = Field(
        None,
        description='A human readable description for the API key',
        examples=['This API key provides kafka access to cluster x'],
    )
    owner: Optional[TypedGlobalObjectReference] = Field(
        None,
        description='The owner to which this belongs. The owner can be one of iam.v2.User, iam.v2.ServiceAccount.',
    )
    resource: Optional[TypedEnvScopedObjectReference] = Field(
        None,
        description='The resource associated with this object. The resource can be one of Kafka Cluster ID (example: lkc-12345),\nSchema Registry Cluster ID (example: lsrc-12345), ksqlDB Cluster ID (example: lksqlc-12345), or Flink\n(Environment + Region pair, example: env-abc123.aws.us-east-2).\nMay be null or omitted if not associated with a resource. For creating Cloud API key, resource should be `CLOUD`,\nfor creating Tableflow API key, resource should be `TABLEFLOW`. The resource id is case-insensitive.\n[Learn more in Authentication](https://docs.confluent.io/cloud/current/api.html#section/Authentication).\n\nNote - Flink is in the [Preview lifecycle stage](https://docs.confluent.io/cloud/current/api.html#section/Versioning/API-Lifecycle-Policy)\n',
    )


class Invitation(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: Optional[ApiVersion] = Field(
        None,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Optional[KindModel3] = Field(
        None, description='Kind defines the object this REST resource represents.'
    )
    id: Optional[constr(max_length=255)] = Field(
        None,
        description='ID is the "natural identifier" for an object within its scope/namespace; it is normally unique across time but not space. That is, you can assume that the ID will not be reclaimed and reused after an object is deleted ("time"); however, it may collide with IDs for other object `kinds` or objects of the same `kind` within a different scope/namespace ("space").',
        examples=['dlz-f3a90de'],
    )
    metadata: Optional[MetadataModel1] = None
    email: Optional[EmailStr] = Field(
        None,
        description="The user/invitee's email address",
        examples=['johndoe@confluent.io'],
    )
    auth_type: Optional[str] = Field(
        None,
        description="The user/invitee's authentication type. Note that only the [OrganizationAdmin role](https://docs.confluent.io/cloud/current/access-management/access-control/cloud-rbac.html#organizationadmin)\ncan invite AUTH_TYPE_LOCAL users to SSO organizations.\nThe user's auth_type is set as AUTH_TYPE_SSO by default if the organization has SSO enabled.\nOtherwise, the user's auth_type is AUTH_TYPE_LOCAL by default.\n",
        examples=['AUTH_TYPE_SSO'],
    )
    status: Optional[str] = Field(
        None, description='The status of invitations', examples=['INVITE_STATUS_SENT']
    )
    accepted_at: Optional[datetime] = Field(
        None,
        description='The timestamp that the invitation was accepted',
        examples=['2022-07-06T17:21:33Z'],
    )
    expires_at: Optional[datetime] = Field(
        None,
        description='The timestamp that the invitation will expire',
        examples=['2022-07-07T17:22:39Z'],
    )
    user: Optional[GlobalObjectReference] = Field(None, description='The user/invitee')
    creator: Optional[GlobalObjectReference] = Field(
        None, description='The invitation creator'
    )


class InvitationList(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: ApiVersion = Field(
        ...,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: KindModel6 = Field(
        ..., description='Kind defines the object this REST resource represents.'
    )
    metadata: MetadataModel4
    data: List[Invitation] = Field(
        ...,
        description='A data property that contains an array of resource items. Each entry in the array is a separate resource.',
    )


class IdentityProvider(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: Optional[ApiVersion] = Field(
        None,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Optional[Kind1] = Field(
        None, description='Kind defines the object this REST resource represents.'
    )
    id: Optional[constr(max_length=255)] = Field(
        None,
        description='ID is the "natural identifier" for an object within its scope/namespace; it is normally unique across time but not space. That is, you can assume that the ID will not be reclaimed and reused after an object is deleted ("time"); however, it may collide with IDs for other object `kinds` or objects of the same `kind` within a different scope/namespace ("space").',
        examples=['dlz-f3a90de'],
    )
    metadata: Optional[Metadata1] = None
    display_name: Optional[str] = Field(
        None,
        description='The human-readable name of the OAuth identity provider.',
        examples=['My OIDC Provider'],
    )
    description: Optional[str] = Field(
        None, description='A description of the identity provider.'
    )
    identity_claim: Optional[str] = Field(
        None,
        description='The JSON Web Token (JWT) claim to extract the authenticating identity to Confluent resources from\n[Registered Claim Names](https://datatracker.ietf.org/doc/html/rfc7519#section-4.1). This appears\nin audit log records. Note: if the client specifies mapping to one identity pool ID, the identity\nclaim configured with that pool will be used instead.\nNote - The attribute is in an [Early Access lifecycle stage]\n(https://docs.confluent.io/cloud/current/api.html#section/Versioning/API-Lifecycle-Policy)',
        examples=['claims.sub'],
    )
    state: Optional[str] = Field(
        None,
        description='The current state of the identity provider.',
        examples=['ENABLED'],
    )
    issuer: Optional[AnyUrl] = Field(
        None,
        description='A publicly accessible URL uniquely identifying the OAuth\nidentity provider authorized to issue access tokens.',
        examples=['https://login.microsoftonline.com/{tenantid}/v2.0'],
    )
    jwks_uri: Optional[AnyUrl] = Field(
        None,
        description='A publicly accessible JSON Web Key Set (JWKS) URI for the OAuth\nidentity provider. JWKS provides a set of crypotgraphic keys\nused to verify the authenticity and integrity of JSON Web\nTokens (JWTs) issued by the OAuth identity provider.',
        examples=['https://login.microsoftonline.com/common/discovery/v2.0/keys'],
    )
    keys: Optional[List[JwksObject]] = Field(
        None,
        description='The JWKS issued by the OAuth identity provider. Only `kid` (key ID)\nand `alg` (algorithm) properties for each key set are included.',
    )


class Jwks(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: Optional[ApiVersion] = Field(
        None,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Optional[Kind1Model] = Field(
        None, description='Kind defines the object this REST resource represents.'
    )
    spec: Optional[JwksSpec] = None
    status: Optional[JwksStatus] = None


class IdentityProviderList(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: ApiVersion = Field(
        ...,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Kind1Model2 = Field(
        ..., description='Kind defines the object this REST resource represents.'
    )
    metadata: Metadata1Model1
    data: List[IdentityProvider] = Field(
        ...,
        description='A data property that contains an array of resource items. Each entry in the array is a separate resource.',
    )


class ApiKey(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: Optional[ApiVersion] = Field(
        None,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Optional[Kind] = Field(
        None, description='Kind defines the object this REST resource represents.'
    )
    id: Optional[constr(max_length=255)] = Field(
        None,
        description='ID is the "natural identifier" for an object within its scope/namespace; it is normally unique across time but not space. That is, you can assume that the ID will not be reclaimed and reused after an object is deleted ("time"); however, it may collide with IDs for other object `kinds` or objects of the same `kind` within a different scope/namespace ("space").',
        examples=['dlz-f3a90de'],
    )
    metadata: Optional[MetadataModel11] = None
    spec: Optional[ApiKeySpec] = None


class Datum(ApiKey):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    spec: Dict[str, Any]


class ApiKeyList(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: ApiVersion = Field(
        ...,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: KindModel = Field(
        ..., description='Kind defines the object this REST resource represents.'
    )
    metadata: MetadataModel12
    data: List[Datum] = Field(
        ...,
        description='A data property that contains an array of resource items. Each entry in the array is a separate resource.',
    )
