# generated by datamodel-codegen:
#   filename:  openapi.json
#   timestamp: 2025-03-21T21:21:27+00:00

from __future__ import annotations

from datetime import datetime
from enum import Enum
from typing import Any, Dict, List, Literal, Optional
from uuid import UUID

from pydantic import BaseModel, ConfigDict, Field, constr

from .. import ColumnDetails, ExceptionListMeta, ResultListMeta
from .. import ListMeta
from .. import ObjectMeta
from .. import StatementObjectMeta


class ApiVersion(Enum):
    sql_v1 = 'sql/v1'


class Kind(Enum):
    connection = 'Connection'


class Metadata(ObjectMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    self: Optional[Any] = Field(
        None,
        examples=[
            'https://flink.us-west1.aws.confluent.cloud/sql/v1/organizations/org-abc/environments/env-123/connections/my-openai-connection'
        ],
    )
    uid: Optional[Any] = Field(None, examples=['12345678-1234-1234-1234-123456789012'])
    resource_version: Optional[Any] = Field(None, examples=['a23av'])
    resource_name: Optional[Any] = Field(None, examples=[''])


class Kind1Model(Enum):
    connection_list = 'ConnectionList'


class Metadata1Model(ListMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    self: Optional[Any] = Field(
        None,
        examples=[
            'https://flink.us-west1.aws.confluent.cloud/sql/v1/environments/env-123/connections'
        ],
    )
    first: Optional[Any] = Field(
        None,
        examples=[
            'https://flink.us-west1.aws.confluent.cloud/sql/v1/environments/env-abc123/connections'
        ],
    )
    last: Optional[Any] = Field(None, examples=[''])
    prev: Optional[Any] = Field(None, examples=[''])
    next: Optional[Any] = Field(
        None,
        examples=[
            'https://flink.us-west1.aws.confluent.cloud/sql/v1/environments/env-abc123/connections?page_token=UvmDWOB1iwfAIBPj6EYb'
        ],
    )


class ConnectionStatus(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    phase: str = Field(
        ...,
        description='Describes the status of the connection:\n\nREADY: The Connection is usable;\n\nUNREACHABLE: The Connection endpoint is unreachable;\n\nINVALID_AUTH: The Connection auth token is invalid;\n',
        examples=['READY'],
    )
    detail: Optional[str] = Field(
        None,
        description='Details about why connection transitioned into a given status.',
        examples=['Lookup failed: ai.openai.com'],
    )


class Kind1Model1(Enum):
    plaintext_provider = 'PlaintextProvider'


class PlaintextProvider(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    kind: Literal['PlaintextProvider'] = Field(
        ..., description='Plaintext Provider Kind Type\n'
    )
    data: Optional[str] = Field(
        None,
        description='Base64 encoded opaque piece of sensitive information.\n\nScoped to an endpoint of a `Connection` resource.\n',
    )


class ConnectionSpec(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    connection_type: Optional[str] = Field(
        None, description='The type of this connection.', examples=['OPENAI']
    )
    endpoint: Optional[constr(max_length=16384)] = Field(
        None,
        description='The endpoint that is used to run model inferencing.',
        examples=['https://api.openai.com/v1/chat/completions'],
    )
    auth_data: Optional[PlaintextProvider] = Field(
        None,
        description='The vendor specific authentication token details\n\nThe contents are stored as opaque bytes given in plaintext by an EnvAdmin. \nIn future, we would support more secure methods for distributing authentication tokens.\n',
        discriminator='kind',
    )


class Kind1Model2(Enum):
    statement = 'Statement'


class Kind1Model3(Enum):
    statement_list = 'StatementList'


class Metadata1Model1(ListMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    self: Optional[Any] = Field(
        None,
        examples=[
            'https://flink.us-west1.aws.confluent.cloud/sql/v1/environments/env-123/statements'
        ],
    )
    first: Optional[Any] = Field(
        None,
        examples=[
            'https://flink.us-west1.aws.confluent.cloud/sql/v1/environments/env-abc123/statements'
        ],
    )
    last: Optional[Any] = Field(None, examples=[''])
    prev: Optional[Any] = Field(None, examples=[''])
    next: Optional[Any] = Field(
        None,
        examples=[
            'https://flink.us-west1.aws.confluent.cloud/sql/v1/environments/env-abc123/statements?page_token=UvmDWOB1iwfAIBPj6EYb'
        ],
    )


class Kind1Model4(Enum):
    statement_result = 'StatementResult'


class StatementResultResults(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    data: Optional[List] = Field(
        None,
        description='A data property that contains an array of results. Each entry in the array is a separate result.\n\nThe value of `op` attribute (if present) represents the kind of change that a row can describe in a changelog:\n\n`0`: represents `INSERT` (`+I`), i.e. insertion operation;\n\n`1`: represents `UPDATE_BEFORE` (`-U`), i.e. update operation with the previous content of the updated row.\nThis kind should occur together with `UPDATE_AFTER` for modelling an update that needs to retract\nthe previous row first. It is useful in cases of a non-idempotent update, i.e., an update of a row that is not \nuniquely identifiable by a key;\n\n`2`: represents `UPDATE_AFTER` (`+U`), i.e. update operation with new content of the updated row;\nThis kind CAN occur together with `UPDATE_BEFORE` for modelling an update that\nneeds to retract the previous row first or it describes an idempotent update, i.e., an\nupdate of a row that is uniquely identifiable by a key;\n\n`3`: represents `DELETE` (`-D`), i.e. deletion operation;\n\nDefaults to `0`.\n',
        examples=[
            [
                {
                    'op': 0,
                    'row': [
                        '101',
                        'Jay',
                        [None, 'abc'],
                        [None, '456'],
                        '1990-01-12 12:00.12',
                        [[None, 'Alice'], ['42', 'Bob']],
                    ],
                }
            ]
        ],
    )


class StatementSpec(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    statement: Optional[constr(max_length=131072)] = Field(
        None,
        description='The raw SQL text statement.',
        examples=['SELECT * FROM TABLE WHERE VALUE1 = VALUE2;'],
    )
    properties: Optional[Dict[str, str]] = Field(
        None,
        description='A map (key-value pairs) of statement properties.',
        examples=[
            {
                'sql.current-catalog': 'my_environment',
                'sql.current-database': 'my_kafka_cluster',
            }
        ],
    )
    compute_pool_id: Optional[constr(max_length=255)] = Field(
        None,
        description='The id associated with the compute pool in context.',
        examples=['fcp-00000'],
    )
    principal: Optional[constr(max_length=255)] = Field(
        None,
        description='The id of a principal this statement runs as.',
        examples=['sa-abc123'],
    )
    stopped: Optional[bool] = Field(
        None,
        description='Indicates whether the statement should be stopped.',
        examples=[False],
    )


class ScalingStatus(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    scaling_state: Optional[str] = Field(
        None,
        description='OK: The statement runs at the right scale.\n\nPENDING_SCALE_DOWN: The statement requires less resources, and will be scaled down in the near future.\n\nPENDING_SCALE_UP: The statement requires more resources, and will be scaled up in the near future.\n\nPOOL_EXHAUSTED: The statement requires more resources, but not enough resources are available.\n',
        examples=['OK'],
    )
    last_updated: Optional[datetime] = Field(
        None,
        description='The last time the scaling status was updated.',
        examples=['1996-03-19T01:02:03-04:05'],
    )


class Kind1Model5(Enum):
    statement_exception_list = 'StatementExceptionList'


class Kind1Model6(Enum):
    statement_exception = 'StatementException'


class StatementException(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    kind: Optional[Kind1Model6] = Field(
        None, description='Kind defines the object this REST resource represents.'
    )
    name: Optional[str] = Field(
        None,
        description='Name of the SQL statement exception.',
        examples=['java.lang.RuntimeException'],
    )
    message: Optional[str] = Field(
        None,
        description='Error message of the statement exception.',
        examples=['java.lang.RuntimeException: An error occurred'],
    )
    timestamp: Optional[datetime] = Field(
        None,
        description='The date and time at which the exception occurred. It is represented in RFC3339 format and is in UTC.',
        examples=['2023-03-31T00:00:00-00:00'],
    )


class Connection(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: Optional[ApiVersion] = Field(
        None,
        description='APIVersion defines the schema version of this representation of a resource.',
        examples=['sql/v1'],
    )
    kind: Optional[Kind] = Field(
        None, description='Kind defines the object this REST resource represents.'
    )
    metadata: Optional[Metadata] = None
    name: Optional[
        constr(
            pattern=r'[a-z0-9]([-a-z0-9]*[a-z0-9])?(\.[a-z0-9]([-a-z0-9]*[a-z0-9])?)*',
            max_length=100,
        )
    ] = Field(
        None,
        description='The user provided name of the resource, unique within this environment.',
        examples=['my-openai-connection'],
    )
    spec: Optional[ConnectionSpec] = None
    status: Optional[ConnectionStatus] = None


class Datum(Connection):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    spec: Dict[str, Any]


class ConnectionList(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: ApiVersion = Field(
        ...,
        description='APIVersion defines the schema version of this representation of a resource.',
        examples=['sql/v1'],
    )
    kind: Kind1Model = Field(
        ..., description='Kind defines the object this REST resource represents.'
    )
    metadata: Metadata1Model
    data: List[Datum] = Field(
        ...,
        description='A data property that contains an array of resource items. Each entry in the array is a separate resource.',
    )


class Metadata1Model2(StatementObjectMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    self: Optional[Any] = Field(
        None,
        examples=[
            'https://flink.us-west1.aws.confluent.cloud/sql/v1/environments/env-123/statements/my-statement'
        ],
    )
    uid: Optional[Any] = Field(None, examples=['12345678-1234-1234-1234-123456789012'])
    resource_version: Optional[Any] = Field(None, examples=['a23av'])
    resource_name: Optional[Any] = Field(None, examples=[''])
    labels: Optional[Dict[str, str]] = None


class StatementResult(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: ApiVersion = Field(
        ...,
        description='APIVersion defines the schema version of this representation of a resource.',
        examples=['sql/v1'],
    )
    kind: Kind1Model4 = Field(
        ..., description='Kind defines the object this REST resource represents.'
    )
    metadata: ResultListMeta
    results: Optional[StatementResultResults] = None


class StatementExceptionList(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: ApiVersion = Field(
        ...,
        description='APIVersion defines the schema version of this representation of a resource.',
        examples=['sql/v1'],
    )
    kind: Kind1Model5 = Field(
        ..., description='Kind defines the object this REST resource represents.'
    )
    metadata: ExceptionListMeta
    data: List[StatementException] = Field(
        ...,
        description='A data property that contains an array of resource items. Each entry in the array is a separate resource.',
    )


class Statement(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: Optional[ApiVersion] = Field(
        None,
        description='APIVersion defines the schema version of this representation of a resource.',
        examples=['sql/v1'],
    )
    kind: Optional[Kind1Model2] = Field(
        None, description='Kind defines the object this REST resource represents.'
    )
    metadata: Optional[Metadata1Model2] = None
    name: Optional[
        constr(
            pattern=r'[a-z0-9]([-a-z0-9]*[a-z0-9])?(\.[a-z0-9]([-a-z0-9]*[a-z0-9])?)*',
            max_length=100,
        )
    ] = Field(
        None,
        description='The user provided name of the resource, unique within this environment.',
        examples=['sql123'],
    )
    organization_id: Optional[UUID] = Field(
        None, description='The unique identifier for the organization.'
    )
    environment_id: Optional[str] = Field(
        None, description='The unique identifier for the environment.'
    )
    spec: Optional[StatementSpec] = None
    status: Optional[StatementStatus] = None
    result: Optional[StatementResult] = None


class StatementStatus(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    phase: str = Field(
        ...,
        description='The lifecycle phase of the submitted SQL statement:\n\nPENDING: SQL statement is pending execution;\n\nRUNNING: SQL statement execution is in progress;\n\nCOMPLETED: SQL statement is completed;\n\nDELETING: SQL statement deletion is in progress;\n\nFAILING: SQL statement is failing;\n\nFAILED: SQL statement execution has failed;\n\nSTOPPED: SQL statement execution has successfully been stopped;\n',
        examples=['RUNNING'],
    )
    scaling_status: Optional[ScalingStatus] = None
    detail: Optional[str] = Field(
        None,
        description='Details about the execution status of this statement.',
        examples=['Statement is running successfully'],
    )
    traits: Optional[StatementTraits] = None
    network_kind: Optional[str] = Field(
        None,
        description='The networking type used by the submitted SQL statement:\n\nPUBLIC: SQL statement is using public networking;\n\nPRIVATE: SQL statement is using private networking;\n',
        examples=['PUBLIC'],
    )
    latest_offsets: Optional[Dict[str, str]] = Field(
        None,
        description='The last Kafka offsets that a statement has processed. Represented by a mapping from Kafka topic to a\nstring representation of partitions mapped to offsets.\n',
        examples=[
            {
                'topic-1': 'partition:0,offset:100;partition:1,offset:200',
                'topic-2': 'partition:0,offset:50',
            }
        ],
    )
    latest_offsets_timestamp: Optional[datetime] = Field(
        None,
        description='The date and time at which the Kafka topic offsets were added to the statement status. It is represented in RFC3339 format and is in UTC.',
        examples=['2023-03-31T00:00:00-00:00'],
    )


class StatementTraits(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    sql_kind: Optional[str] = Field(
        None,
        description='Categorizes the SQL statement. The result is Confluent-specific but inspired by SQL. It uses underscores for separating concepts e.g. "CREATE_TABLE".',
        examples=['SELECT'],
    )
    is_bounded: Optional[bool] = Field(
        None,
        description='Indicates the special case where results of a statement are bounded.',
    )
    is_append_only: Optional[bool] = Field(
        None,
        description='Indicates the special case where results of a statement are insert/append only.',
    )
    upsert_columns: Optional[List[int]] = Field(
        None, description='Defines the column indices clients can use as upsert keys.'
    )
    schema_: Optional[ResultSchema] = Field(None, alias='schema')


class StatementList(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: ApiVersion = Field(
        ...,
        description='APIVersion defines the schema version of this representation of a resource.',
        examples=['sql/v1'],
    )
    kind: Kind1Model3 = Field(
        ..., description='Kind defines the object this REST resource represents.'
    )
    metadata: Metadata1Model1
    data: List[Datum1Model] = Field(
        ...,
        description='A data property that contains an array of resource items. Each entry in the array is a separate resource.',
    )


class ResultSchema(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    columns: Optional[List[ColumnDetails]] = Field(
        None, description='The properties of each SQL column in the schema.'
    )


class Datum1Model(Statement):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    spec: Dict[str, Any]


Statement.model_rebuild()
StatementStatus.model_rebuild()
StatementTraits.model_rebuild()
StatementList.model_rebuild()
ResultSchema.model_rebuild()
Datum1Model.model_rebuild()
