"""
    Cosmo Tech Platform API

    Cosmo Tech Platform API  # noqa: E501

    The version of the OpenAPI document: 3.1.9
    Contact: platform@cosmotech.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from cosmotech_api.api_client import ApiClient, Endpoint as _Endpoint
from cosmotech_api.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from cosmotech_api.model.scenario_run_result import ScenarioRunResult


class ScenariorunresultApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.get_scenario_run_result_endpoint = _Endpoint(
            settings={
                'response_type': (ScenarioRunResult,),
                'auth': [
                    'oAuth2AuthCode'
                ],
                'endpoint_path': '/organizations/{organization_id}/workspaces/{workspace_id}/scenarios/{scenario_id}/scenarioruns/{scenariorun_id}/probes/{probe_id}',
                'operation_id': 'get_scenario_run_result',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'organization_id',
                    'workspace_id',
                    'scenario_id',
                    'scenariorun_id',
                    'probe_id',
                ],
                'required': [
                    'organization_id',
                    'workspace_id',
                    'scenario_id',
                    'scenariorun_id',
                    'probe_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'organization_id':
                        (str,),
                    'workspace_id':
                        (str,),
                    'scenario_id':
                        (str,),
                    'scenariorun_id':
                        (str,),
                    'probe_id':
                        (str,),
                },
                'attribute_map': {
                    'organization_id': 'organization_id',
                    'workspace_id': 'workspace_id',
                    'scenario_id': 'scenario_id',
                    'scenariorun_id': 'scenariorun_id',
                    'probe_id': 'probe_id',
                },
                'location_map': {
                    'organization_id': 'path',
                    'workspace_id': 'path',
                    'scenario_id': 'path',
                    'scenariorun_id': 'path',
                    'probe_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.send_scenario_run_result_endpoint = _Endpoint(
            settings={
                'response_type': (ScenarioRunResult,),
                'auth': [
                    'oAuth2AuthCode'
                ],
                'endpoint_path': '/organizations/{organization_id}/workspaces/{workspace_id}/scenarios/{scenario_id}/scenarioruns/{scenariorun_id}/probes/{probe_id}',
                'operation_id': 'send_scenario_run_result',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'organization_id',
                    'workspace_id',
                    'scenario_id',
                    'scenariorun_id',
                    'probe_id',
                    'request_body',
                ],
                'required': [
                    'organization_id',
                    'workspace_id',
                    'scenario_id',
                    'scenariorun_id',
                    'probe_id',
                    'request_body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'organization_id':
                        (str,),
                    'workspace_id':
                        (str,),
                    'scenario_id':
                        (str,),
                    'scenariorun_id':
                        (str,),
                    'probe_id':
                        (str,),
                    'request_body':
                        ({str: (str,)},),
                },
                'attribute_map': {
                    'organization_id': 'organization_id',
                    'workspace_id': 'workspace_id',
                    'scenario_id': 'scenario_id',
                    'scenariorun_id': 'scenariorun_id',
                    'probe_id': 'probe_id',
                },
                'location_map': {
                    'organization_id': 'path',
                    'workspace_id': 'path',
                    'scenario_id': 'path',
                    'scenariorun_id': 'path',
                    'probe_id': 'path',
                    'request_body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )

    def get_scenario_run_result(
        self,
        organization_id,
        workspace_id,
        scenario_id,
        scenariorun_id,
        probe_id,
        **kwargs
    ):
        """Get a ScenarioRunResult in the Organization  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_scenario_run_result(organization_id, workspace_id, scenario_id, scenariorun_id, probe_id, async_req=True)
        >>> result = thread.get()

        Args:
            organization_id (str): the Organization identifier
            workspace_id (str): the Workspace identifier
            scenario_id (str): the Scenario identifier
            scenariorun_id (str): the ScenarioRun identifier
            probe_id (str): the Probe identifier

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ScenarioRunResult
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['organization_id'] = \
            organization_id
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['scenario_id'] = \
            scenario_id
        kwargs['scenariorun_id'] = \
            scenariorun_id
        kwargs['probe_id'] = \
            probe_id
        return self.get_scenario_run_result_endpoint.call_with_http_info(**kwargs)

    def send_scenario_run_result(
        self,
        organization_id,
        workspace_id,
        scenario_id,
        scenariorun_id,
        probe_id,
        request_body,
        **kwargs
    ):
        """Create a new ScenarioRunResult in the Organization  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.send_scenario_run_result(organization_id, workspace_id, scenario_id, scenariorun_id, probe_id, request_body, async_req=True)
        >>> result = thread.get()

        Args:
            organization_id (str): the Organization identifier
            workspace_id (str): the Workspace identifier
            scenario_id (str): the Scenario identifier
            scenariorun_id (str): the ScenarioRun identifier
            probe_id (str): the Probe identifier
            request_body ({str: (str,)}): the ScenarioRunResult to register

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ScenarioRunResult
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['organization_id'] = \
            organization_id
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['scenario_id'] = \
            scenario_id
        kwargs['scenariorun_id'] = \
            scenariorun_id
        kwargs['probe_id'] = \
            probe_id
        kwargs['request_body'] = \
            request_body
        return self.send_scenario_run_result_endpoint.call_with_http_info(**kwargs)

