# coding: utf-8

"""
    Cosmo Tech Platform API

    Cosmo Tech Platform API

    The version of the OpenAPI document: 3.2.6
    Contact: platform@cosmotech.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from cosmotech_api.models.connector_parameter_group import ConnectorParameterGroup
from cosmotech_api.models.io_types_enum import IoTypesEnum
from typing import Optional, Set
from typing_extensions import Self

class Connector(BaseModel):
    """
    a version of a Connector
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, description="the Connector version unique identifier")
    key: Optional[StrictStr] = Field(default=None, description="the Connector key which group Connector versions")
    name: Optional[StrictStr] = Field(default=None, description="the Connector name")
    description: Optional[StrictStr] = Field(default=None, description="the Connector description")
    repository: Optional[StrictStr] = Field(default=None, description="the registry repository containing the image")
    version: Optional[StrictStr] = Field(default=None, description="the Connector version MAJOR.MINOR.PATCH. Must be aligned with an existing repository tag")
    tags: Optional[List[StrictStr]] = Field(default=None, description="the list of tags")
    owner_id: Optional[StrictStr] = Field(default=None, description="the user id which own this connector version", alias="ownerId")
    url: Optional[StrictStr] = Field(default=None, description="an optional URL link to connector page")
    azure_managed_identity: Optional[StrictBool] = Field(default=None, description="whether or not the connector uses Azure Managed Identity", alias="azureManagedIdentity")
    azure_authentication_with_customer_app_registration: Optional[StrictBool] = Field(default=None, description="whether to authenticate against Azure using the app registration credentials provided by the customer", alias="azureAuthenticationWithCustomerAppRegistration")
    io_types: Optional[List[IoTypesEnum]] = Field(default=None, alias="ioTypes")
    parameter_groups: Optional[List[ConnectorParameterGroup]] = Field(default=None, description="the list of connector parameters groups", alias="parameterGroups")
    __properties: ClassVar[List[str]] = ["id", "key", "name", "description", "repository", "version", "tags", "ownerId", "url", "azureManagedIdentity", "azureAuthenticationWithCustomerAppRegistration", "ioTypes", "parameterGroups"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Connector from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "id",
            "owner_id",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in parameter_groups (list)
        _items = []
        if self.parameter_groups:
            for _item in self.parameter_groups:
                if _item:
                    _items.append(_item.to_dict())
            _dict['parameterGroups'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Connector from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "key": obj.get("key"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "repository": obj.get("repository"),
            "version": obj.get("version"),
            "tags": obj.get("tags"),
            "ownerId": obj.get("ownerId"),
            "url": obj.get("url"),
            "azureManagedIdentity": obj.get("azureManagedIdentity"),
            "azureAuthenticationWithCustomerAppRegistration": obj.get("azureAuthenticationWithCustomerAppRegistration"),
            "ioTypes": obj.get("ioTypes"),
            "parameterGroups": [ConnectorParameterGroup.from_dict(_item) for _item in obj["parameterGroups"]] if obj.get("parameterGroups") is not None else None
        })
        return _obj


