# coding: utf-8

"""
    Cosmo Tech Platform API

    Cosmo Tech Platform API

    The version of the OpenAPI document: 3.2.6
    Contact: platform@cosmotech.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from cosmotech_api.models.dataset_compatibility import DatasetCompatibility
from cosmotech_api.models.dataset_connector import DatasetConnector
from cosmotech_api.models.dataset_security import DatasetSecurity
from cosmotech_api.models.dataset_source_type import DatasetSourceType
from cosmotech_api.models.ingestion_status_enum import IngestionStatusEnum
from cosmotech_api.models.source_info import SourceInfo
from cosmotech_api.models.twincache_status_enum import TwincacheStatusEnum
from typing import Optional, Set
from typing_extensions import Self

class Dataset(BaseModel):
    """
    a Dataset
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, description="the Dataset unique identifier")
    name: Optional[StrictStr] = Field(default=None, description="the Dataset name")
    description: Optional[StrictStr] = Field(default=None, description="the Dataset description")
    owner_id: Optional[StrictStr] = Field(default=None, description="the User id which own this Dataset", alias="ownerId")
    owner_name: Optional[StrictStr] = Field(default=None, description="the name of the owner", alias="ownerName")
    organization_id: Optional[StrictStr] = Field(default=None, description="the Organization Id related to this Dataset", alias="organizationId")
    parent_id: Optional[StrictStr] = Field(default=None, description="the Dataset id which is the parent of this Dataset", alias="parentId")
    linked_workspace_id_list: Optional[List[StrictStr]] = Field(default=None, description="list of workspace linked to this dataset", alias="linkedWorkspaceIdList")
    twingraph_id: Optional[StrictStr] = Field(default=None, description="the twin graph id", alias="twingraphId")
    main: Optional[StrictBool] = Field(default=None, description="is this the main dataset")
    creation_date: Optional[StrictInt] = Field(default=None, description="the Dataset creation date", alias="creationDate")
    refresh_date: Optional[StrictInt] = Field(default=None, description="the last time a refresh was done", alias="refreshDate")
    source_type: Optional[DatasetSourceType] = Field(default=None, alias="sourceType")
    source: Optional[SourceInfo] = None
    ingestion_status: Optional[IngestionStatusEnum] = Field(default=None, alias="ingestionStatus")
    twincache_status: Optional[TwincacheStatusEnum] = Field(default=None, alias="twincacheStatus")
    queries: Optional[List[StrictStr]] = Field(default=None, description="the list of queries")
    tags: Optional[List[StrictStr]] = Field(default=None, description="the list of tags")
    connector: Optional[DatasetConnector] = None
    fragments_ids: Optional[List[StrictStr]] = Field(default=None, description="the list of other Datasets ids to compose as fragments", alias="fragmentsIds")
    validator_id: Optional[StrictStr] = Field(default=None, description="the validator id", alias="validatorId")
    compatibility: Optional[List[DatasetCompatibility]] = Field(default=None, description="the list of compatible Solutions versions")
    security: Optional[DatasetSecurity] = None
    __properties: ClassVar[List[str]] = ["id", "name", "description", "ownerId", "ownerName", "organizationId", "parentId", "linkedWorkspaceIdList", "twingraphId", "main", "creationDate", "refreshDate", "sourceType", "source", "ingestionStatus", "twincacheStatus", "queries", "tags", "connector", "fragmentsIds", "validatorId", "compatibility", "security"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Dataset from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "id",
            "owner_id",
            "owner_name",
            "organization_id",
            "creation_date",
            "refresh_date",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of source
        if self.source:
            _dict['source'] = self.source.to_dict()
        # override the default output from pydantic by calling `to_dict()` of connector
        if self.connector:
            _dict['connector'] = self.connector.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in compatibility (list)
        _items = []
        if self.compatibility:
            for _item in self.compatibility:
                if _item:
                    _items.append(_item.to_dict())
            _dict['compatibility'] = _items
        # override the default output from pydantic by calling `to_dict()` of security
        if self.security:
            _dict['security'] = self.security.to_dict()
        # set to None if ingestion_status (nullable) is None
        # and model_fields_set contains the field
        if self.ingestion_status is None and "ingestion_status" in self.model_fields_set:
            _dict['ingestionStatus'] = None

        # set to None if twincache_status (nullable) is None
        # and model_fields_set contains the field
        if self.twincache_status is None and "twincache_status" in self.model_fields_set:
            _dict['twincacheStatus'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Dataset from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "ownerId": obj.get("ownerId"),
            "ownerName": obj.get("ownerName"),
            "organizationId": obj.get("organizationId"),
            "parentId": obj.get("parentId"),
            "linkedWorkspaceIdList": obj.get("linkedWorkspaceIdList"),
            "twingraphId": obj.get("twingraphId"),
            "main": obj.get("main"),
            "creationDate": obj.get("creationDate"),
            "refreshDate": obj.get("refreshDate"),
            "sourceType": obj.get("sourceType"),
            "source": SourceInfo.from_dict(obj["source"]) if obj.get("source") is not None else None,
            "ingestionStatus": obj.get("ingestionStatus"),
            "twincacheStatus": obj.get("twincacheStatus"),
            "queries": obj.get("queries"),
            "tags": obj.get("tags"),
            "connector": DatasetConnector.from_dict(obj["connector"]) if obj.get("connector") is not None else None,
            "fragmentsIds": obj.get("fragmentsIds"),
            "validatorId": obj.get("validatorId"),
            "compatibility": [DatasetCompatibility.from_dict(_item) for _item in obj["compatibility"]] if obj.get("compatibility") is not None else None,
            "security": DatasetSecurity.from_dict(obj["security"]) if obj.get("security") is not None else None
        })
        return _obj


