# coding: utf-8

"""
    Cosmo Tech Platform API

    Cosmo Tech Platform API

    The version of the OpenAPI document: 3.2.6
    Contact: platform@cosmotech.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, Field
from typing import Any, ClassVar, Dict, List, Optional
from cosmotech_api.models.organization_service import OrganizationService
from typing import Optional, Set
from typing_extensions import Self

class OrganizationServices(BaseModel):
    """
    the cloud service resources of the Organization
    """ # noqa: E501
    tenant_credentials: Optional[Dict[str, Any]] = Field(default=None, description="a freeform credentials object for the Organization tenant. Structure depends on cloud provider", alias="tenantCredentials")
    storage: Optional[OrganizationService] = None
    solutions_container_registry: Optional[OrganizationService] = Field(default=None, alias="solutionsContainerRegistry")
    __properties: ClassVar[List[str]] = ["tenantCredentials", "storage", "solutionsContainerRegistry"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of OrganizationServices from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of storage
        if self.storage:
            _dict['storage'] = self.storage.to_dict()
        # override the default output from pydantic by calling `to_dict()` of solutions_container_registry
        if self.solutions_container_registry:
            _dict['solutionsContainerRegistry'] = self.solutions_container_registry.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of OrganizationServices from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "tenantCredentials": obj.get("tenantCredentials"),
            "storage": OrganizationService.from_dict(obj["storage"]) if obj.get("storage") is not None else None,
            "solutionsContainerRegistry": OrganizationService.from_dict(obj["solutionsContainerRegistry"]) if obj.get("solutionsContainerRegistry") is not None else None
        })
        return _obj


