# coding: utf-8

"""
    Cosmo Tech Platform API

    Cosmo Tech Platform API

    The version of the OpenAPI document: 3.2.6
    Contact: platform@cosmotech.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from cosmotech_api.models.run_container_logs import RunContainerLogs
from typing import Optional, Set
from typing_extensions import Self

class RunLogs(BaseModel):
    """
    the run logs returned by all containers
    """ # noqa: E501
    run_id: Optional[StrictStr] = Field(default=None, description="the Run Id", alias="runId")
    containers: Optional[Dict[str, RunContainerLogs]] = Field(default=None, description="the container map of logs")
    __properties: ClassVar[List[str]] = ["runId", "containers"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RunLogs from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "run_id",
            "containers",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each value in containers (dict)
        _field_dict = {}
        if self.containers:
            for _key in self.containers:
                if self.containers[_key]:
                    _field_dict[_key] = self.containers[_key].to_dict()
            _dict['containers'] = _field_dict
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RunLogs from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "runId": obj.get("runId"),
            "containers": dict(
                (_k, RunContainerLogs.from_dict(_v))
                for _k, _v in obj["containers"].items()
            )
            if obj.get("containers") is not None
            else None
        })
        return _obj


