# coding: utf-8

"""
    Cosmo Tech Platform API

    Cosmo Tech Platform API

    The version of the OpenAPI document: 3.2.6
    Contact: platform@cosmotech.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from cosmotech_api.models.scenario_job_state import ScenarioJobState
from cosmotech_api.models.scenario_last_run import ScenarioLastRun
from cosmotech_api.models.scenario_resource_sizing import ScenarioResourceSizing
from cosmotech_api.models.scenario_run_template_parameter_value import ScenarioRunTemplateParameterValue
from cosmotech_api.models.scenario_security import ScenarioSecurity
from cosmotech_api.models.scenario_validation_status import ScenarioValidationStatus
from typing import Optional, Set
from typing_extensions import Self

class Scenario(BaseModel):
    """
    a Scenario with base information
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, description="the Scenario unique identifier")
    name: Optional[StrictStr] = Field(default=None, description="the Scenario name")
    description: Optional[StrictStr] = Field(default=None, description="the Scenario description")
    tags: Optional[List[StrictStr]] = Field(default=None, description="the list of tags")
    parent_id: Optional[StrictStr] = Field(default=None, description="the Scenario parent id", alias="parentId")
    owner_id: Optional[StrictStr] = Field(default=None, description="the user id which own this Scenario", alias="ownerId")
    root_id: Optional[StrictStr] = Field(default=None, description="the scenario root id", alias="rootId")
    solution_id: Optional[StrictStr] = Field(default=None, description="the Solution Id associated with this Scenario", alias="solutionId")
    run_template_id: Optional[StrictStr] = Field(default=None, description="the Solution Run Template Id associated with this Scenario", alias="runTemplateId")
    organization_id: Optional[StrictStr] = Field(default=None, description="the associated Organization Id", alias="organizationId")
    workspace_id: Optional[StrictStr] = Field(default=None, description="the associated Workspace Id", alias="workspaceId")
    state: Optional[ScenarioJobState] = None
    creation_date: Optional[StrictInt] = Field(default=None, description="the Scenario creation date", alias="creationDate")
    last_update: Optional[StrictInt] = Field(default=None, description="the last time a Scenario was updated", alias="lastUpdate")
    owner_name: Optional[StrictStr] = Field(default=None, description="the name of the owner", alias="ownerName")
    solution_name: Optional[StrictStr] = Field(default=None, description="the Solution name", alias="solutionName")
    run_template_name: Optional[StrictStr] = Field(default=None, description="the Solution Run Template name associated with this Scenario", alias="runTemplateName")
    dataset_list: Optional[List[StrictStr]] = Field(default=None, description="the list of Dataset Id associated to this Scenario Run Template", alias="datasetList")
    run_sizing: Optional[ScenarioResourceSizing] = Field(default=None, alias="runSizing")
    parameters_values: Optional[List[ScenarioRunTemplateParameterValue]] = Field(default=None, description="the list of Solution Run Template parameters values", alias="parametersValues")
    last_run: Optional[ScenarioLastRun] = Field(default=None, alias="lastRun")
    parent_last_run: Optional[ScenarioLastRun] = Field(default=None, alias="parentLastRun")
    root_last_run: Optional[ScenarioLastRun] = Field(default=None, alias="rootLastRun")
    validation_status: Optional[ScenarioValidationStatus] = Field(default=None, alias="validationStatus")
    security: Optional[ScenarioSecurity] = None
    __properties: ClassVar[List[str]] = ["id", "name", "description", "tags", "parentId", "ownerId", "rootId", "solutionId", "runTemplateId", "organizationId", "workspaceId", "state", "creationDate", "lastUpdate", "ownerName", "solutionName", "runTemplateName", "datasetList", "runSizing", "parametersValues", "lastRun", "parentLastRun", "rootLastRun", "validationStatus", "security"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Scenario from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "id",
            "owner_id",
            "root_id",
            "solution_id",
            "organization_id",
            "workspace_id",
            "creation_date",
            "last_update",
            "owner_name",
            "solution_name",
            "run_template_name",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of run_sizing
        if self.run_sizing:
            _dict['runSizing'] = self.run_sizing.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in parameters_values (list)
        _items = []
        if self.parameters_values:
            for _item in self.parameters_values:
                if _item:
                    _items.append(_item.to_dict())
            _items[-1]['varType'] = _item.var_type
        # override the default output from pydantic by calling `to_dict()` of last_run
        if self.last_run:
            _dict['lastRun'] = self.last_run.to_dict()
        # override the default output from pydantic by calling `to_dict()` of parent_last_run
        if self.parent_last_run:
            _dict['parentLastRun'] = self.parent_last_run.to_dict()
        # override the default output from pydantic by calling `to_dict()` of root_last_run
        if self.root_last_run:
            _dict['rootLastRun'] = self.root_last_run.to_dict()
        # override the default output from pydantic by calling `to_dict()` of security
        if self.security:
            _dict['security'] = self.security.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Scenario from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "tags": obj.get("tags"),
            "parentId": obj.get("parentId"),
            "ownerId": obj.get("ownerId"),
            "rootId": obj.get("rootId"),
            "solutionId": obj.get("solutionId"),
            "runTemplateId": obj.get("runTemplateId"),
            "organizationId": obj.get("organizationId"),
            "workspaceId": obj.get("workspaceId"),
            "state": obj.get("state"),
            "creationDate": obj.get("creationDate"),
            "lastUpdate": obj.get("lastUpdate"),
            "ownerName": obj.get("ownerName"),
            "solutionName": obj.get("solutionName"),
            "runTemplateName": obj.get("runTemplateName"),
            "datasetList": obj.get("datasetList"),
            "runSizing": ScenarioResourceSizing.from_dict(obj["runSizing"]) if obj.get("runSizing") is not None else None,
            "parametersValues": [ScenarioRunTemplateParameterValue.from_dict(_item) for _item in obj["parametersValues"]] if obj.get("parametersValues") is not None else None,
            "lastRun": ScenarioLastRun.from_dict(obj["lastRun"]) if obj.get("lastRun") is not None else None,
            "parentLastRun": ScenarioLastRun.from_dict(obj["parentLastRun"]) if obj.get("parentLastRun") is not None else None,
            "rootLastRun": ScenarioLastRun.from_dict(obj["rootLastRun"]) if obj.get("rootLastRun") is not None else None,
            "validationStatus": obj.get("validationStatus"),
            "security": ScenarioSecurity.from_dict(obj["security"]) if obj.get("security") is not None else None
        })
        return _obj


