# coding: utf-8

"""
    Cosmo Tech Platform API

    Cosmo Tech Platform API

    The version of the OpenAPI document: 3.2.6
    Contact: platform@cosmotech.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from cosmotech_api.models.run_template_parameter_value import RunTemplateParameterValue
from cosmotech_api.models.scenario_run_container import ScenarioRunContainer
from cosmotech_api.models.scenario_run_state import ScenarioRunState
from typing import Optional, Set
from typing_extensions import Self

class ScenarioRun(BaseModel):
    """
    a ScenarioRun with only base properties
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, description="the ScenarioRun")
    state: Optional[ScenarioRunState] = None
    organization_id: Optional[StrictStr] = Field(default=None, description="the Organization id", alias="organizationId")
    workflow_id: Optional[StrictStr] = Field(default=None, description="the Cosmo Tech compute cluster Argo Workflow Id to search", alias="workflowId")
    csm_simulation_run: Optional[StrictStr] = Field(default=None, description="the Cosmo Tech Simulation Run Id", alias="csmSimulationRun")
    generate_name: Optional[StrictStr] = Field(default=None, description="the base name for workflow name generation", alias="generateName")
    workflow_name: Optional[StrictStr] = Field(default=None, description="the Cosmo Tech compute cluster Argo Workflow Name", alias="workflowName")
    owner_id: Optional[StrictStr] = Field(default=None, description="the user id which own this scenariorun", alias="ownerId")
    workspace_id: Optional[StrictStr] = Field(default=None, description="the Workspace Id", alias="workspaceId")
    workspace_key: Optional[StrictStr] = Field(default=None, description="technical key for resource name convention and version grouping. Must be unique", alias="workspaceKey")
    scenario_id: Optional[StrictStr] = Field(default=None, description="the Scenario Id", alias="scenarioId")
    solution_id: Optional[StrictStr] = Field(default=None, description="the Solution Id", alias="solutionId")
    run_template_id: Optional[StrictStr] = Field(default=None, description="the Solution Run Template id", alias="runTemplateId")
    compute_size: Optional[StrictStr] = Field(default=None, description="the compute size needed for this Analysis. Standard sizes are basic and highcpu. Default is basic", alias="computeSize")
    sdk_version: Optional[StrictStr] = Field(default=None, description="the MAJOR.MINOR version used to build the solution solution", alias="sdkVersion")
    created_at: Optional[StrictStr] = Field(default=None, description="the ScenarioRun creation date", alias="createdAt")
    no_data_ingestion_state: Optional[StrictBool] = Field(default=None, description="set to true if the run template does not use any Datawarehouse consumers (AMQP consumers for Azure)", alias="noDataIngestionState")
    dataset_list: Optional[List[StrictStr]] = Field(default=None, description="the list of Dataset Id associated to this Analysis", alias="datasetList")
    parameters_values: Optional[List[RunTemplateParameterValue]] = Field(default=None, description="the list of Run Template parameters values", alias="parametersValues")
    send_datasets_to_data_warehouse: Optional[StrictBool] = Field(default=None, description="whether or not the Datasets values are send to the DataWarehouse prior to Simulation Run. If not set follow the Workspace setting", alias="sendDatasetsToDataWarehouse")
    send_input_parameters_to_data_warehouse: Optional[StrictBool] = Field(default=None, description="whether or not the input parameters values are send to the DataWarehouse prior to Simulation Run. If not set follow the Workspace setting", alias="sendInputParametersToDataWarehouse")
    node_label: Optional[StrictStr] = Field(default=None, description="the node label request", alias="nodeLabel")
    containers: Optional[List[ScenarioRunContainer]] = Field(default=None, description="the containers list. This information is not returned by the API.")
    __properties: ClassVar[List[str]] = ["id", "state", "organizationId", "workflowId", "csmSimulationRun", "generateName", "workflowName", "ownerId", "workspaceId", "workspaceKey", "scenarioId", "solutionId", "runTemplateId", "computeSize", "sdkVersion", "createdAt", "noDataIngestionState", "datasetList", "parametersValues", "sendDatasetsToDataWarehouse", "sendInputParametersToDataWarehouse", "nodeLabel", "containers"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ScenarioRun from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "id",
            "csm_simulation_run",
            "owner_id",
            "workspace_id",
            "workspace_key",
            "scenario_id",
            "solution_id",
            "run_template_id",
            "compute_size",
            "created_at",
            "dataset_list",
            "parameters_values",
            "send_datasets_to_data_warehouse",
            "send_input_parameters_to_data_warehouse",
            "node_label",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in parameters_values (list)
        _items = []
        if self.parameters_values:
            for _item in self.parameters_values:
                if _item:
                    _items.append(_item.to_dict())
            _dict['parametersValues'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in containers (list)
        _items = []
        if self.containers:
            for _item in self.containers:
                if _item:
                    _items.append(_item.to_dict())
            _dict['containers'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ScenarioRun from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "state": obj.get("state"),
            "organizationId": obj.get("organizationId"),
            "workflowId": obj.get("workflowId"),
            "csmSimulationRun": obj.get("csmSimulationRun"),
            "generateName": obj.get("generateName"),
            "workflowName": obj.get("workflowName"),
            "ownerId": obj.get("ownerId"),
            "workspaceId": obj.get("workspaceId"),
            "workspaceKey": obj.get("workspaceKey"),
            "scenarioId": obj.get("scenarioId"),
            "solutionId": obj.get("solutionId"),
            "runTemplateId": obj.get("runTemplateId"),
            "computeSize": obj.get("computeSize"),
            "sdkVersion": obj.get("sdkVersion"),
            "createdAt": obj.get("createdAt"),
            "noDataIngestionState": obj.get("noDataIngestionState"),
            "datasetList": obj.get("datasetList"),
            "parametersValues": [RunTemplateParameterValue.from_dict(_item) for _item in obj["parametersValues"]] if obj.get("parametersValues") is not None else None,
            "sendDatasetsToDataWarehouse": obj.get("sendDatasetsToDataWarehouse"),
            "sendInputParametersToDataWarehouse": obj.get("sendInputParametersToDataWarehouse"),
            "nodeLabel": obj.get("nodeLabel"),
            "containers": [ScenarioRunContainer.from_dict(_item) for _item in obj["containers"]] if obj.get("containers") is not None else None
        })
        return _obj


