# coding: utf-8

"""
    Cosmo Tech Platform API

    Cosmo Tech Platform API

    The version of the OpenAPI document: 3.2.6
    Contact: platform@cosmotech.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from cosmotech_api.models.scenario_run_container import ScenarioRunContainer
from typing import Optional, Set
from typing_extensions import Self

class ScenarioRunStartContainers(BaseModel):
    """
    the parameters to run directly containers
    """ # noqa: E501
    generate_name: Optional[StrictStr] = Field(default=None, description="the base name for workflow name generation", alias="generateName")
    csm_simulation_id: StrictStr = Field(description="Cosmo Tech Simulation Run Id", alias="csmSimulationId")
    node_label: Optional[StrictStr] = Field(default=None, description="the node label request", alias="nodeLabel")
    labels: Optional[Dict[str, StrictStr]] = Field(default=None, description="the workflow labels")
    containers: List[ScenarioRunContainer] = Field(description="the containerslist")
    __properties: ClassVar[List[str]] = ["generateName", "csmSimulationId", "nodeLabel", "labels", "containers"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ScenarioRunStartContainers from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in containers (list)
        _items = []
        if self.containers:
            for _item in self.containers:
                if _item:
                    _items.append(_item.to_dict())
            _dict['containers'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ScenarioRunStartContainers from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "generateName": obj.get("generateName"),
            "csmSimulationId": obj.get("csmSimulationId"),
            "nodeLabel": obj.get("nodeLabel"),
            "labels": obj.get("labels"),
            "containers": [ScenarioRunContainer.from_dict(_item) for _item in obj["containers"]] if obj.get("containers") is not None else None
        })
        return _obj


