# coding: utf-8

"""
    Cosmo Tech Platform API

    Cosmo Tech Platform API

    The version of the OpenAPI document: 3.2.6
    Contact: platform@cosmotech.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from cosmotech_api.models.run_template import RunTemplate
from cosmotech_api.models.run_template_parameter import RunTemplateParameter
from cosmotech_api.models.run_template_parameter_group import RunTemplateParameterGroup
from cosmotech_api.models.solution_security import SolutionSecurity
from typing import Optional, Set
from typing_extensions import Self

class Solution(BaseModel):
    """
    a version of a Solution
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, description="the Solution version unique identifier")
    organization_id: Optional[StrictStr] = Field(default=None, description="the Organization unique identifier", alias="organizationId")
    key: Optional[StrictStr] = Field(default=None, description="the Solution key which group Solution versions")
    name: Optional[StrictStr] = Field(default=None, description="the Solution name")
    description: Optional[StrictStr] = Field(default=None, description="the Solution description")
    repository: Optional[StrictStr] = Field(default=None, description="the registry repository containing the image")
    always_pull: Optional[StrictBool] = Field(default=False, description="set to true if the runtemplate wants to always pull the image", alias="alwaysPull")
    csm_simulator: Optional[StrictStr] = Field(default=None, description="the main Cosmo Tech simulator name used in standard Run Template", alias="csmSimulator")
    version: Optional[StrictStr] = Field(default=None, description="the Solution version MAJOR.MINOR.PATCH. Must be aligned with an existing repository tag")
    owner_id: Optional[StrictStr] = Field(default=None, description="the User id which own this Solution", alias="ownerId")
    sdk_version: Optional[StrictStr] = Field(default=None, description="the MAJOR.MINOR version used to build this solution", alias="sdkVersion")
    url: Optional[StrictStr] = Field(default=None, description="an optional URL link to solution page")
    tags: Optional[List[StrictStr]] = Field(default=None, description="the list of tags")
    parameters: Optional[List[RunTemplateParameter]] = Field(default=None, description="the list of Run Template Parameters")
    parameter_groups: Optional[List[RunTemplateParameterGroup]] = Field(default=None, description="the list of parameters groups for the Run Templates", alias="parameterGroups")
    run_templates: Optional[List[RunTemplate]] = Field(default=None, description="list of Run Template", alias="runTemplates")
    security: Optional[SolutionSecurity] = None
    __properties: ClassVar[List[str]] = ["id", "organizationId", "key", "name", "description", "repository", "alwaysPull", "csmSimulator", "version", "ownerId", "sdkVersion", "url", "tags", "parameters", "parameterGroups", "runTemplates", "security"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Solution from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "id",
            "organization_id",
            "owner_id",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in parameters (list)
        _items = []
        if self.parameters:
            for _item in self.parameters:
                if _item:
                    _items.append(_item.to_dict())
            _dict['parameters'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in parameter_groups (list)
        _items = []
        if self.parameter_groups:
            for _item in self.parameter_groups:
                if _item:
                    _items.append(_item.to_dict())
            _dict['parameterGroups'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in run_templates (list)
        _items = []
        if self.run_templates:
            for _item in self.run_templates:
                if _item:
                    _items.append(_item.to_dict())
            _dict['runTemplates'] = _items
        # override the default output from pydantic by calling `to_dict()` of security
        if self.security:
            _dict['security'] = self.security.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Solution from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "organizationId": obj.get("organizationId"),
            "key": obj.get("key"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "repository": obj.get("repository"),
            "alwaysPull": obj.get("alwaysPull") if obj.get("alwaysPull") is not None else False,
            "csmSimulator": obj.get("csmSimulator"),
            "version": obj.get("version"),
            "ownerId": obj.get("ownerId"),
            "sdkVersion": obj.get("sdkVersion"),
            "url": obj.get("url"),
            "tags": obj.get("tags"),
            "parameters": [RunTemplateParameter.from_dict(_item) for _item in obj["parameters"]] if obj.get("parameters") is not None else None,
            "parameterGroups": [RunTemplateParameterGroup.from_dict(_item) for _item in obj["parameterGroups"]] if obj.get("parameterGroups") is not None else None,
            "runTemplates": [RunTemplate.from_dict(_item) for _item in obj["runTemplates"]] if obj.get("runTemplates") is not None else None,
            "security": SolutionSecurity.from_dict(obj["security"]) if obj.get("security") is not None else None
        })
        return _obj


