# coding: utf-8

"""
    Cosmo Tech Platform API

    Cosmo Tech Platform API

    The version of the OpenAPI document: 3.2.0
    Contact: platform@cosmotech.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class ValidatorRun(BaseModel):
    """
    a Validator Run
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, description="the Validator Run id")
    validator_id: Optional[StrictStr] = Field(default=None, description="the Validator id", alias="validatorId")
    validator_name: Optional[StrictStr] = Field(default=None, description="the validator name", alias="validatorName")
    dataset_id: StrictStr = Field(description="the Dataset id to run the validator on", alias="datasetId")
    dataset_name: Optional[StrictStr] = Field(default=None, description="the Dataset name", alias="datasetName")
    state: Optional[StrictStr] = Field(default=None, description="the Validator Run state")
    container_id: Optional[StrictStr] = Field(default=None, description="the Validator Run container id", alias="containerId")
    logs: Optional[StrictStr] = Field(default=None, description="the Validator Run logs")
    __properties: ClassVar[List[str]] = ["id", "validatorId", "validatorName", "datasetId", "datasetName", "state", "containerId", "logs"]

    @field_validator('state')
    def state_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['Running', 'Finished', 'OnError']):
            raise ValueError("must be one of enum values ('Running', 'Finished', 'OnError')")
        return value

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ValidatorRun from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "id",
            "validator_id",
            "validator_name",
            "dataset_name",
            "state",
            "container_id",
            "logs",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ValidatorRun from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "validatorId": obj.get("validatorId"),
            "validatorName": obj.get("validatorName"),
            "datasetId": obj.get("datasetId"),
            "datasetName": obj.get("datasetName"),
            "state": obj.get("state"),
            "containerId": obj.get("containerId"),
            "logs": obj.get("logs")
        })
        return _obj


