# coding: utf-8

"""
    Cosmo Tech Platform API

    Cosmo Tech Platform API

    The version of the OpenAPI document: 3.2.6
    Contact: platform@cosmotech.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from cosmotech_api.models.workspace_security import WorkspaceSecurity
from cosmotech_api.models.workspace_solution import WorkspaceSolution
from cosmotech_api.models.workspace_web_app import WorkspaceWebApp
from typing import Optional, Set
from typing_extensions import Self

class Workspace(BaseModel):
    """
    a Workspace
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, description="Workspace unique identifier generated by the API")
    organization_id: Optional[StrictStr] = Field(default=None, description="Organization unique identifier under which the workspace resides", alias="organizationId")
    key: StrictStr = Field(description="technical key for resource name convention and version grouping. Must be unique")
    name: StrictStr = Field(description="Workspace name. This name is display in the sample webApp")
    description: Optional[StrictStr] = Field(default=None, description="the Workspace description")
    linked_dataset_id_list: Optional[List[StrictStr]] = Field(default=None, description="list of dataset linked to this dataset", alias="linkedDatasetIdList")
    version: Optional[StrictStr] = Field(default=None, description="the Workspace version MAJOR.MINOR.PATCH.")
    tags: Optional[List[StrictStr]] = Field(default=None, description="the list of tags")
    owner_id: Optional[StrictStr] = Field(default=None, description="the user id which own this workspace. set by the API from Authentification service receved id", alias="ownerId")
    solution: WorkspaceSolution
    web_app: Optional[WorkspaceWebApp] = Field(default=None, alias="webApp")
    send_input_to_data_warehouse: Optional[StrictBool] = Field(default=None, description="default setting for all Scenarios and Run Templates to set whether or not the Dataset values and the input parameters values are send to the DataWarehouse prior to the ScenarioRun", alias="sendInputToDataWarehouse")
    use_dedicated_event_hub_namespace: Optional[StrictBool] = Field(default=False, description="Set this property to true to use a dedicated Azure Event Hub Namespace for this Workspace. The Event Hub Namespace must be named \\'<organization_id\\>-<workspace_id\\>\\' (in lower case). This Namespace must also contain two Event Hubs named \\'probesmeasures\\' and \\'scenariorun\\'.", alias="useDedicatedEventHubNamespace")
    dedicated_event_hub_sas_key_name: Optional[StrictStr] = Field(default=None, description="the Dedicated Event Hub SAS key name, default to RootManageSharedAccessKey. Use the /secret endpoint to set the key value", alias="dedicatedEventHubSasKeyName")
    dedicated_event_hub_authentication_strategy: Optional[StrictStr] = Field(default=None, description="the Event Hub authentication strategy, SHARED_ACCESS_POLICY or TENANT_CLIENT_CREDENTIALS. Default to the one defined for the tenant.", alias="dedicatedEventHubAuthenticationStrategy")
    send_scenario_run_to_event_hub: Optional[StrictBool] = Field(default=True, description="default setting for all Scenarios and Run Templates to set whether or not the ScenarioRun is send to the Event Hub", alias="sendScenarioRunToEventHub")
    send_scenario_metadata_to_event_hub: Optional[StrictBool] = Field(default=False, description="Set this property to false to not send scenario metada to Azure Event Hub Namespace for this Workspace. The Event Hub Namespace must be named \\'<organization_id\\>-<workspace_id\\>\\' (in lower case). This Namespace must also contain two Event Hubs named \\'scenariometadata\\' and \\'scenariorunmetadata\\'.", alias="sendScenarioMetadataToEventHub")
    dataset_copy: Optional[StrictBool] = Field(default=True, description="Activate the copy of dataset on scenario creation, meaning that each scenario created in this workspace will make this copy. when false, scenario use directly the dataset specified.", alias="datasetCopy")
    security: Optional[WorkspaceSecurity] = None
    __properties: ClassVar[List[str]] = ["id", "organizationId", "key", "name", "description", "linkedDatasetIdList", "version", "tags", "ownerId", "solution", "webApp", "sendInputToDataWarehouse", "useDedicatedEventHubNamespace", "dedicatedEventHubSasKeyName", "dedicatedEventHubAuthenticationStrategy", "sendScenarioRunToEventHub", "sendScenarioMetadataToEventHub", "datasetCopy", "security"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Workspace from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "id",
            "organization_id",
            "owner_id",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of solution
        if self.solution:
            _dict['solution'] = self.solution.to_dict()
        # override the default output from pydantic by calling `to_dict()` of web_app
        if self.web_app:
            _dict['webApp'] = self.web_app.to_dict()
        # override the default output from pydantic by calling `to_dict()` of security
        if self.security:
            _dict['security'] = self.security.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Workspace from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "organizationId": obj.get("organizationId"),
            "key": obj.get("key"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "linkedDatasetIdList": obj.get("linkedDatasetIdList"),
            "version": obj.get("version"),
            "tags": obj.get("tags"),
            "ownerId": obj.get("ownerId"),
            "solution": WorkspaceSolution.from_dict(obj["solution"]) if obj.get("solution") is not None else None,
            "webApp": WorkspaceWebApp.from_dict(obj["webApp"]) if obj.get("webApp") is not None else None,
            "sendInputToDataWarehouse": obj.get("sendInputToDataWarehouse"),
            "useDedicatedEventHubNamespace": obj.get("useDedicatedEventHubNamespace") if obj.get("useDedicatedEventHubNamespace") is not None else False,
            "dedicatedEventHubSasKeyName": obj.get("dedicatedEventHubSasKeyName"),
            "dedicatedEventHubAuthenticationStrategy": obj.get("dedicatedEventHubAuthenticationStrategy"),
            "sendScenarioRunToEventHub": obj.get("sendScenarioRunToEventHub") if obj.get("sendScenarioRunToEventHub") is not None else True,
            "sendScenarioMetadataToEventHub": obj.get("sendScenarioMetadataToEventHub") if obj.get("sendScenarioMetadataToEventHub") is not None else False,
            "datasetCopy": obj.get("datasetCopy") if obj.get("datasetCopy") is not None else True,
            "security": WorkspaceSecurity.from_dict(obj["security"]) if obj.get("security") is not None else None
        })
        return _obj


