# Copyright (c) 2023 PYCAD
# This file is part of the PYCAD library and is released under the MIT License:
# https://github.com/amine0110/pycad/blob/main/LICENSE

from .liver_datasets import LiverDataset
from .adrenal_gland_right_dataset import AdrenalGlandRightDataset
from .adrenal_gland_left_dataset import AdrenalGlandLeftDataset
from .aorta_dataset import AortaDataset
from .atrial_appendage_left_dataset import AtrialAppendageLeftDataset
from .autochthon_left_dataset import AutochthonLeftDataset
from .autochthon_right_dataset import AutochthonRightDataset
from .brachiocephalic_trunk_dataset import BrachiocephalicTrunkDataset
from .brachiocephalic_vein_left_dataset import BrachiocephalicVeinLeftDataset
from .brachiocephalic_vein_right_dataset import BrachiocephalicVeinRightDataset
from .brain_dataset import BrainDataset
from .clavicula_left_dataset import ClaviculaLeftDataset
from .colon_dataset import ColonDataset
from .common_carotid_artery_left_dataset import CommonCarotidArteryLeftDataset
from .common_carotid_artery_right_dataset import CommonCarotidArteryRightDataset
from .costal_cartilages_dataset import CostalCartilagesDataset
from .duodenum_dataset import DuodenumDataset
from .esophagus_dataset import EsophagusDataset
from .femur_left_dataset import FemurLeftDataset
from .gallbladder_dataset import GallbladderDataset
from .gluteus_maximus_left_dataset import GluteusMaximusLeftDataset
from .gluteus_maximus_right_dataset import GluteusMaximusRightDataset
from .gluteus_medius_left_dataset import GluteusMediusLeftDataset
from .gluteus_medius_right_dataset import GluteusMediusRightDataset
from .gluteus_minimus_left_dataset import GluteusMinimusLeftDataset
from .gluteus_minimus_right_dataset import GluteusMinimusRightDataset
from .heart_dataset import HeartDataset
from .hip_left_dataset import HipLeftDataset
from .hip_right_dataset import HipRightDataset
from .humerus_left_dataset import HumerusLeftDataset
from .humerus_right_dataset import HumerusRightDataset
from .iliac_artery_left_dataset import IliacArteryLeftDataset
from .iliac_artery_right_dataset import IliacArteryRightDatasetDataset
from .iliac_vena_left_dataset import IliacVenaLeftDataset
from .iliac_vena_right_dataset import IliacVenaRightDatasetDataset
from .iliopsoas_left_dataset import IliopsoasLeftDataset
from .iliopsoas_right_dataset import IliopsoasRightDataset
from .inferior_vena_cava_dataset import InferiorVenaCavaDataset
from .kidney_cyst_left_dataset import KidneyCystLeftDataset
from .kidney_cyst_right_dataset import KidneyCystRightDataset
from .kidney_left_dataset import KidneyLeftDataset
from .kidney_right_dataset import KidneyRightDataset
from .lung_lower_lobe_left_dataset import LungLowerLobeLeftDataset
from .lung_lower_lobe_right_dataset import LungLowerLobeRightDataset
from .lung_middle_lobe_right_dataset import LungMiddleLobeRightDataset
from .lung_upper_lobe_left_dataset import LungUpperLobeLeftDataset
from .lung_upper_lobe_right_dataset import LungUpperLobeRightDataset
from .pancreas_dataset import PancreasDataset
from .portal_vein_and_splenic_vein_dataset import PortalVeinSplenicVeinDataset
from .prostate_dataset import ProstateDataset
from .pulmonary_vein_dataset import PulmonaryVeinDataset
from .rib_left_1_dataset import RibLeft1Dataset
from .rib_left_2_dataset import RibLeft2Dataset
from .rib_left_3_dataset import RibLeft3Dataset
from .rib_left_4_dataset import RibLeft4Dataset
from .rib_left_5_dataset import RibLeft5Dataset
from .rib_left_6_dataset import RibLeft6Dataset
from .rib_left_7_dataset import RibLeft7Dataset
from .rib_left_8_dataset import RibLeft8Dataset
from .rib_left_9_dataset import RibLeft9Dataset
from .rib_left_10_dataset import RibLeft10Dataset
from .rib_left_11_dataset import RibLeft11Dataset
from .rib_left_12_dataset import RibLeft12Dataset
from .rib_right_1_dataset import RibRight1Dataset
from .rib_right_2_dataset import RibRight2Dataset
from .rib_right_3_dataset import RibRight3Dataset
from .rib_right_4_dataset import RibRight4Dataset
from .rib_right_5_dataset import RibRight5Dataset
from .rib_right_6_dataset import RibRight6Dataset
from .rib_right_7_dataset import RibRight7Dataset
from .rib_right_8_dataset import RibRight8Dataset
from .rib_right_9_dataset import RibRight9Dataset
from .rib_right_10_dataset import RibRight10Dataset
from .rib_right_11_dataset import RibRight11Dataset
from .rib_right_12_dataset import RibRight12Dataset
from .sacrum_dataset import SacrumDataset
from .scapula_left_dataset import ScapulaLeftDataset
from .scapula_right_dataset import ScapulaRightDataset
from .skull_dataset import SkullDataset
from .small_bowel_dataset import SmallBowelDataset
from .spinal_cord_dataset import SpinalCordDataset
from .spleen_dataset import SpleenDataset
from .sternum_dataset import SternumDataset
from .stomach_dataset import StomachDataset
from .subclavian_artery_left_dataset import SubclavianArteryLeftDataset
from .subclavian_artery_right_dataset import SubclavianArteryRightDataset
from .superior_vena_cava_dataset import SuperiorVenaCavaDataset
from .thyroid_gland_dataset import ThyroidGlandDataset
from .trachea_dataset import TracheaDataset
from .urinary_bladder_dataset import UrinaryBladderDataset
from .vertebrae_C1_dataset import VertebraeC1Dataset
from .vertebrae_C2_dataset import VertebraeC2Dataset
from .vertebrae_C3_dataset import VertebraeC3Dataset
from .vertebrae_C4_dataset import VertebraeC4Dataset
from .vertebrae_C5_dataset import VertebraeC5Dataset
from .vertebrae_C6_dataset import VertebraeC6Dataset
from .vertebrae_C7_dataset import VertebraeC7Dataset
from .vertebrae_L1_dataset import VertebraeL1Dataset
from .vertebrae_L2_dataset import VertebraeL2Dataset
from .vertebrae_L3_dataset import VertebraeL3Dataset
from .vertebrae_L4_dataset import VertebraeL4Dataset
from .vertebrae_L5_dataset import VertebraeL5Dataset
from .vertebrae_S1_dataset import VertebraeS1Dataset
from .vertebrae_T1_dataset import VertebraeT1Dataset
from .vertebrae_T2_dataset import VertebraeT2Dataset
from .vertebrae_T3_dataset import VertebraeT3Dataset
from .vertebrae_T4_dataset import VertebraeT4Dataset
from .vertebrae_T5_dataset import VertebraeT5Dataset
from .vertebrae_T6_dataset import VertebraeT6Dataset
from .vertebrae_T7_dataset import VertebraeT7Dataset
from .vertebrae_T8_dataset import VertebraeT8Dataset
from .vertebrae_T9_dataset import VertebraeT9Dataset
from .vertebrae_T10_dataset import VertebraeT10Dataset
from .vertebrae_T11_dataset import VertebraeT11Dataset
from .vertebrae_T12_dataset import VertebraeT12Dataset


def info():
    print(f"""
This dataset is the same dataset that Total Segmentator was trained on. But here is structured to be used separately instead of having all the cases
together. You can download the whole dataset and you can downlaod just a batch (if you have hardware limitations). For all the organs, you will find sub-groups
of 100, 200, 400 and all (1225) cases.
    
The classes are not in the same nifti file, but you will find for each class or organ a separate folder and you can download only what you need (for example liver).
The examples of how to download each dataset are defined in each organ class.
    
Here is an example:

from pycad.dataset.segmentation.TotalSegmentator import AdrenalGlandLeftDataset

adrenal_gland_left_dataset = AdrenalGlandLeftDataset()
adrenal_gland_left_dataset.info()  # Print dataset information
adrenal_gland_left_dataset.download('100')  # Download and extract subgroup 100
        """)