# Generated by Django 4.2.1 on 2023-06-13 15:45

from django.db import migrations, models
import django.db.models.deletion
import django_basin3d.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='DataSource',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=20, unique=True)),
                ('id_prefix', models.CharField(max_length=5, unique=True)),
                ('location', models.TextField(blank=True)),
                ('plugin_module', models.TextField(blank=True)),
                ('plugin_class', models.TextField(blank=True)),
            ],
            options={
                'ordering': ['id_prefix'],
            },
        ),
        migrations.CreateModel(
            name='ObservedProperty',
            fields=[
                ('basin3d_vocab', models.CharField(max_length=50, primary_key=True, serialize=False, unique=True)),
                ('full_name', models.CharField(max_length=255)),
                ('categories', django_basin3d.models.StringListField(blank=True, null=True)),
                ('units', models.CharField(max_length=50)),
            ],
            options={
                'ordering': ('basin3d_vocab',),
            },
        ),
        migrations.CreateModel(
            name='AttributeMapping',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('attr_type', models.CharField(max_length=50)),
                ('basin3d_vocab', models.CharField(max_length=50)),
                ('basin3d_desc', models.JSONField()),
                ('datasource_vocab', models.CharField(max_length=50)),
                ('datasource_desc', models.TextField(blank=True, null=True)),
                ('datasource', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, to='django_basin3d.datasource')),
            ],
            options={
                'ordering': ('datasource', 'attr_type', 'basin3d_vocab'),
                'unique_together': {('datasource', 'attr_type', 'datasource_vocab')},
            },
        ),
    ]
