"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.validateFlinkApplicationProps = void 0;
const core = require("aws-cdk-lib");
/**
 * Early validation for the props used to create FlinkApplications.
 */
function validateFlinkApplicationProps(props) {
    validateApplicationName(props.applicationName);
    validateParallelism(props.parallelism);
    validateParallelismPerKpu(props.parallelismPerKpu);
}
exports.validateFlinkApplicationProps = validateFlinkApplicationProps;
function validateApplicationName(applicationName) {
    if (applicationName === undefined || core.Token.isUnresolved(applicationName)) {
        return;
    }
    if (applicationName.length === 0) {
        throw new Error('applicationName cannot be empty. It must contain at least 1 character.');
    }
    if (!/^[a-zA-Z0-9_.-]+$/.test(applicationName)) {
        throw new Error(`applicationName may only contain letters, numbers, underscores, hyphens, and periods. Name: ${applicationName}`);
    }
    if (applicationName.length > 128) {
        throw new Error(`applicationName max length is 128. Name: ${applicationName} is ${applicationName.length} characters.`);
    }
}
function validateParallelism(parallelism) {
    if (parallelism === undefined || core.Token.isUnresolved(parallelism)) {
        return;
    }
    if (parallelism < 1) {
        throw new Error('parallelism must be at least 1');
    }
}
function validateParallelismPerKpu(parallelismPerKpu) {
    if (parallelismPerKpu === undefined || core.Token.isUnresolved(parallelismPerKpu)) {
        return;
    }
    if (parallelismPerKpu < 1) {
        throw new Error('parallelismPerKpu must be at least 1');
    }
}
//# sourceMappingURL=data:application/json;base64,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