/*
 * Decompiled with CFR 0.152.
 */
package io.minio;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.concurrent.atomic.AtomicReference;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;

enum MinioProperties {
    INSTANCE;

    private static final Logger LOGGER;
    private final AtomicReference<String> version = new AtomicReference<Object>(null);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getVersion() {
        String result = this.version.get();
        if (result == null) {
            MinioProperties minioProperties = INSTANCE;
            synchronized (minioProperties) {
                if (this.version.get() == null) {
                    try {
                        ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
                        this.setMinioClientJavaVersion(classLoader);
                        this.setDevelopmentVersion();
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.SEVERE, "IOException occured", e);
                        this.version.set("unknown");
                    }
                    result = this.version.get();
                }
            }
        }
        return result;
    }

    private void setDevelopmentVersion() {
        if (this.version.get() == null) {
            this.version.set("dev");
        }
    }

    private void setMinioClientJavaVersion(ClassLoader classLoader) throws IOException {
        if (classLoader != null) {
            Enumeration<URL> resources = classLoader.getResources("META-INF/MANIFEST.MF");
            while (resources.hasMoreElements()) {
                Manifest manifest = new Manifest(resources.nextElement().openStream());
                for (Object k : manifest.getMainAttributes().keySet()) {
                    String versionString = "Minio-Client-Java-Version";
                    if (!k.toString().equals(versionString)) continue;
                    this.version.set(manifest.getMainAttributes().getValue((Attributes.Name)k));
                }
            }
        }
    }

    static {
        LOGGER = Logger.getLogger(MinioProperties.class.getName());
    }
}

