/*
 * Decompiled with CFR 0.152.
 */
package loci.formats;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.MetadataTools;
import loci.formats.Modulo;
import loci.formats.ReaderWrapper;
import loci.formats.SwappableMetadata;
import loci.formats.meta.MetadataStore;

public class DimensionSwapper
extends ReaderWrapper {
    private List<CoreMetadata> core;

    public static DimensionSwapper makeDimensionSwapper(IFormatReader r) {
        if (r instanceof DimensionSwapper) {
            return (DimensionSwapper)r;
        }
        return new DimensionSwapper(r);
    }

    public DimensionSwapper() {
    }

    public DimensionSwapper(IFormatReader r) {
        super(r);
    }

    public void swapDimensions(String order) {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        if (order == null) {
            throw new IllegalArgumentException("order is null");
        }
        String oldOrder = this.getInputOrder();
        if (order.equals(oldOrder)) {
            return;
        }
        if (order.length() != 5) {
            throw new IllegalArgumentException("order is unexpected length (" + order.length() + ")");
        }
        int newX = order.indexOf(88);
        int newY = order.indexOf(89);
        int newZ = order.indexOf(90);
        int newC = order.indexOf(67);
        int newT = order.indexOf(84);
        if (newX < 0) {
            throw new IllegalArgumentException("X does not appear");
        }
        if (newY < 0) {
            throw new IllegalArgumentException("Y does not appear");
        }
        if (newZ < 0) {
            throw new IllegalArgumentException("Z does not appear");
        }
        if (newC < 0) {
            throw new IllegalArgumentException("C does not appear");
        }
        if (newT < 0) {
            throw new IllegalArgumentException("T does not appear");
        }
        if (newX > 1) {
            throw new IllegalArgumentException("X in unexpected position (" + newX + ")");
        }
        if (newY > 1) {
            throw new IllegalArgumentException("Y in unexpected position (" + newY + ")");
        }
        int[] dims = new int[5];
        int oldX = oldOrder.indexOf(88);
        int oldY = oldOrder.indexOf(89);
        int oldZ = oldOrder.indexOf(90);
        int oldC = oldOrder.indexOf(67);
        int oldT = oldOrder.indexOf(84);
        if (oldC != newC && this.reader.getRGBChannelCount() > 1) {
            throw new IllegalArgumentException("Cannot swap C dimension when RGB channel count > 1");
        }
        dims[oldX] = this.getSizeX();
        dims[oldY] = this.getSizeY();
        dims[oldZ] = this.getSizeZ();
        dims[oldC] = this.getSizeC();
        dims[oldT] = this.getSizeT();
        Modulo[] moduli = new Modulo[3];
        moduli[oldZ - 2] = this.getModuloZ();
        moduli[oldC - 2] = this.getModuloC();
        moduli[oldT - 2] = this.getModuloT();
        SwappableMetadata ms = (SwappableMetadata)this.core.get(this.getCoreIndex());
        ms.sizeX = dims[newX];
        ms.sizeY = dims[newY];
        ms.sizeZ = dims[newZ];
        ms.sizeC = dims[newC];
        ms.sizeT = dims[newT];
        ms.moduloZ = moduli[newZ - 2];
        ms.moduloC = moduli[newC - 2];
        ms.moduloT = moduli[newT - 2];
        ms.inputOrder = order;
        MetadataStore store = this.getMetadataStore();
        MetadataTools.populatePixels(store, this);
    }

    public void setOutputOrder(String outputOrder) {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        this.core.get((int)this.getCoreIndex()).dimensionOrder = outputOrder;
    }

    public String getInputOrder() {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        return ((SwappableMetadata)this.core.get((int)this.getCoreIndex())).inputOrder;
    }

    @Override
    public int getSizeX() {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        return this.core.get((int)this.getCoreIndex()).sizeX;
    }

    @Override
    public int getSizeY() {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        return this.core.get((int)this.getCoreIndex()).sizeY;
    }

    @Override
    public int getSizeZ() {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        return this.core.get((int)this.getCoreIndex()).sizeZ;
    }

    @Override
    public int getSizeC() {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        return this.core.get((int)this.getCoreIndex()).sizeC;
    }

    @Override
    public int getSizeT() {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        return this.core.get((int)this.getCoreIndex()).sizeT;
    }

    @Override
    public String getDimensionOrder() {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        return this.core.get((int)this.getCoreIndex()).dimensionOrder;
    }

    @Override
    public byte[] openBytes(int no) throws FormatException, IOException {
        return super.openBytes(this.reorder(no));
    }

    @Override
    public byte[] openBytes(int no, int x, int y, int w, int h2) throws FormatException, IOException {
        return super.openBytes(this.reorder(no), x, y, w, h2);
    }

    @Override
    public byte[] openBytes(int no, byte[] buf) throws FormatException, IOException {
        return super.openBytes(this.reorder(no), buf);
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h2) throws FormatException, IOException {
        return super.openBytes(this.reorder(no), buf, x, y, w, h2);
    }

    @Override
    public byte[] openThumbBytes(int no) throws FormatException, IOException {
        return super.openThumbBytes(this.reorder(no));
    }

    @Override
    public int[] getZCTCoords(int no) {
        return FormatTools.getZCTCoords(this, no);
    }

    @Override
    public int[] getZCTModuloCoords(int index) {
        return FormatTools.getZCTModuloCoords(this, index);
    }

    @Override
    public int getIndex(int z, int c, int t) {
        return FormatTools.getIndex(this, z, c, t);
    }

    @Override
    public int getIndex(int z, int c, int t, int moduloZ, int moduloC, int moduloT) {
        return FormatTools.getIndex(this, z, c, t, moduloZ, moduloC, moduloT);
    }

    @Override
    public List<CoreMetadata> getCoreMetadataList() {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        return this.core;
    }

    @Override
    public void setId(String id) throws FormatException, IOException {
        String oldFile = this.getCurrentFile();
        super.setId(id);
        if (!id.equals(oldFile) || this.core == null || this.core.size() != this.reader.getCoreMetadataList().size()) {
            List<CoreMetadata> oldcore = this.reader.getCoreMetadataList();
            this.core = new ArrayList<CoreMetadata>();
            for (int s2 = 0; s2 < oldcore.size(); ++s2) {
                SwappableMetadata swappable = new SwappableMetadata(this.reader, s2);
                swappable.resolutionCount = oldcore.get((int)s2).resolutionCount;
                this.core.add(swappable);
            }
        }
    }

    protected int reorder(int no) {
        if (this.getInputOrder() == null) {
            return no;
        }
        return FormatTools.getReorderedIndex(this.getInputOrder(), this.getDimensionOrder(), this.getSizeZ(), this.getEffectiveSizeC(), this.getSizeT(), this.getImageCount(), no);
    }
}

