/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Vector;
import loci.common.DataTools;
import loci.common.services.DependencyException;
import loci.common.services.ServiceException;
import loci.common.services.ServiceFactory;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.MissingLibraryException;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import loci.formats.services.NetCDFService;
import ome.units.quantity.Length;

public class MINCReader
extends FormatReader {
    private NetCDFService netcdf;
    private byte[][][] pixelData;
    private boolean isMINC2 = false;

    public MINCReader() {
        super("MINC MRI", "mnc");
        this.domains = new String[]{"Medical Imaging"};
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h2) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h2);
        int bpp = FormatTools.getBytesPerPixel(this.getPixelType());
        if (no < this.pixelData.length) {
            for (int row = 0; row < h2; ++row) {
                int srcRow = this.getSizeY() - (row + y) - 1;
                if (srcRow >= this.pixelData[no].length || x + w > this.pixelData[no][srcRow].length) continue;
                System.arraycopy(this.pixelData[no][srcRow], x * bpp, buf, row * w * bpp, w * bpp);
            }
        }
        return buf;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            if (this.netcdf != null) {
                this.netcdf.close();
            }
            this.pixelData = null;
            this.isMINC2 = false;
        }
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        Hashtable<String, Object> attrs;
        super.initFile(id);
        try {
            ServiceFactory factory = new ServiceFactory();
            this.netcdf = factory.getInstance(NetCDFService.class);
            this.netcdf.setFile(id);
        }
        catch (DependencyException e) {
            throw new MissingLibraryException(e);
        }
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            Vector<String> variableList = this.netcdf.getVariableList();
            for (String variable : variableList) {
                Hashtable<String, Object> attributes = this.netcdf.getVariableAttributes(variable);
                Object[] keys = attributes.keySet().toArray(new String[0]);
                Arrays.sort(keys);
                for (Object key : keys) {
                    if (attributes.get(key) instanceof Object[]) {
                        Object[] o;
                        StringBuilder sb = new StringBuilder();
                        for (Object q : o = (Object[])attributes.get(key)) {
                            sb.append(q.toString());
                        }
                        this.addGlobalMeta(variable + " " + (String)key, sb.toString());
                        continue;
                    }
                    this.addGlobalMeta(variable + " " + (String)key, attributes.get(key));
                }
            }
        }
        CoreMetadata m3 = (CoreMetadata)this.core.get(0);
        try {
            Object s2;
            Hashtable<String, Object> attrs2;
            Object pixels = this.netcdf.getVariableValue("/image");
            if (pixels == null) {
                pixels = this.netcdf.getVariableValue("/minc-2.0/image/0/image");
                this.isMINC2 = true;
            }
            m3.littleEndian = this.isMINC2;
            boolean signed = false;
            if (this.isMINC2) {
                String unsigned;
                attrs2 = this.netcdf.getVariableAttributes("/minc-2.0/image/0/image");
                if (attrs2.get("_Unsigned") != null && !(unsigned = attrs2.get("_Unsigned").toString()).startsWith("true")) {
                    signed = true;
                }
            } else {
                attrs2 = this.netcdf.getVariableAttributes("/image");
                String signtype = attrs2.get("signtype").toString();
                if (signtype.startsWith("signed")) {
                    signed = true;
                }
            }
            if (pixels instanceof byte[][][]) {
                m3.pixelType = signed ? 0 : 1;
                this.pixelData = (byte[][][])pixels;
            } else if (pixels instanceof byte[][][][]) {
                byte[][][][] actualPixels = (byte[][][][])pixels;
                m3.pixelType = signed ? 0 : 1;
                this.pixelData = new byte[actualPixels.length * actualPixels[0].length][][];
                int nextPlane = 0;
                for (int t = 0; t < actualPixels.length; ++t) {
                    for (int z = 0; z < actualPixels[t].length; ++z) {
                        this.pixelData[nextPlane++] = actualPixels[t][z];
                    }
                }
            } else if (pixels instanceof short[][][]) {
                m3.pixelType = signed ? 2 : 3;
                s2 = (short[][][])pixels;
                this.pixelData = new byte[((short[][][])s2).length][][];
                for (int i = 0; i < ((short[][][])s2).length; ++i) {
                    this.pixelData[i] = new byte[s2[i].length][];
                    for (int j = 0; j < s2[i].length; ++j) {
                        this.pixelData[i][j] = DataTools.shortsToBytes(s2[i][j], this.isLittleEndian());
                    }
                }
            } else if (pixels instanceof int[][][]) {
                m3.pixelType = signed ? 4 : 5;
                s2 = (int[][][])pixels;
                this.pixelData = new byte[((short[][][])s2).length][][];
                for (int i = 0; i < ((short[][][])s2).length; ++i) {
                    this.pixelData[i] = new byte[s2[i].length][];
                    for (int j = 0; j < s2[i].length; ++j) {
                        this.pixelData[i][j] = DataTools.intsToBytes(s2[i][j], this.isLittleEndian());
                    }
                }
            } else if (pixels instanceof float[][][]) {
                m3.pixelType = 6;
                s2 = (float[][][])pixels;
                this.pixelData = new byte[((short[][][])s2).length][][];
                for (int i = 0; i < ((short[][][])s2).length; ++i) {
                    this.pixelData[i] = new byte[s2[i].length][];
                    for (int j = 0; j < s2[i].length; ++j) {
                        this.pixelData[i][j] = DataTools.floatsToBytes(s2[i][j], this.isLittleEndian());
                    }
                }
            } else if (pixels instanceof double[][][]) {
                m3.pixelType = 7;
                s2 = (double[][][])pixels;
                this.pixelData = new byte[((short[][][])s2).length][][];
                for (int i = 0; i < ((short[][][])s2).length; ++i) {
                    this.pixelData[i] = new byte[s2[i].length][];
                    for (int j = 0; j < s2[i].length; ++j) {
                        this.pixelData[i][j] = DataTools.doublesToBytes(s2[i][j], this.isLittleEndian());
                    }
                }
            }
        }
        catch (ServiceException e) {
            throw new FormatException(e);
        }
        Length physicalX = null;
        Length physicalY = null;
        Length physicalZ = null;
        Length xPosition = null;
        Length yPosition = null;
        Length zPosition = null;
        if (this.isMINC2) {
            attrs = this.netcdf.getVariableAttributes("/minc-2.0/dimensions/xspace");
            m3.sizeX = Integer.parseInt(attrs.get("length").toString());
            physicalX = this.getStepSize(attrs);
            xPosition = this.getStart(attrs);
            attrs = this.netcdf.getVariableAttributes("/minc-2.0/dimensions/yspace");
            m3.sizeY = Integer.parseInt(attrs.get("length").toString());
            physicalY = this.getStepSize(attrs);
            yPosition = this.getStart(attrs);
            attrs = this.netcdf.getVariableAttributes("/minc-2.0/dimensions/zspace");
            m3.sizeZ = Integer.parseInt(attrs.get("length").toString());
            physicalZ = this.getStepSize(attrs);
            zPosition = this.getStart(attrs);
        } else {
            m3.sizeX = this.netcdf.getDimension("/xspace");
            m3.sizeY = this.netcdf.getDimension("/yspace");
            m3.sizeZ = this.netcdf.getDimension("/zspace");
            attrs = this.netcdf.getVariableAttributes("/xspace");
            physicalX = this.getStepSize(attrs);
            xPosition = this.getStart(attrs);
            attrs = this.netcdf.getVariableAttributes("/yspace");
            physicalY = this.getStepSize(attrs);
            yPosition = this.getStart(attrs);
            attrs = this.netcdf.getVariableAttributes("/zspace");
            physicalZ = this.getStepSize(attrs);
            zPosition = this.getStart(attrs);
        }
        try {
            m3.sizeT = this.netcdf.getDimension("/time");
        }
        catch (NullPointerException e) {
            m3.sizeT = 1;
        }
        m3.sizeC = 1;
        m3.imageCount = this.getSizeZ() * this.getSizeT() * this.getSizeC();
        m3.rgb = false;
        m3.indexed = false;
        m3.dimensionOrder = "XYZCT";
        String history = null;
        history = this.isMINC2 ? this.netcdf.getAttributeValue("/minc-2.0/ident") : this.netcdf.getAttributeValue("/history");
        this.addGlobalMeta("Comment", history);
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this, xPosition != null || yPosition != null || zPosition != null);
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            store.setImageDescription(history, 0);
            if (physicalX != null) {
                store.setPixelsPhysicalSizeX(physicalX, 0);
            }
            if (physicalY != null) {
                store.setPixelsPhysicalSizeY(physicalY, 0);
            }
            if (physicalZ != null) {
                store.setPixelsPhysicalSizeZ(physicalZ, 0);
            }
            for (int i = 0; i < this.getImageCount(); ++i) {
                if (xPosition != null) {
                    store.setPlanePositionX(xPosition, 0, i);
                }
                if (yPosition != null) {
                    store.setPlanePositionY(yPosition, 0, i);
                }
                if (zPosition == null) continue;
                int z = this.getZCTCoords(i)[0];
                Double pos = zPosition.value().doubleValue();
                if (physicalZ != null && z > 0) {
                    pos = pos + (double)z * physicalZ.value().doubleValue();
                }
                store.setPlanePositionZ(FormatTools.createLength(pos, zPosition.unit()), 0, i);
            }
        }
    }

    private Length getStepSize(Hashtable<String, Object> attrs) {
        Double stepSize = Double.parseDouble(attrs.get("step").toString());
        String units = attrs.get("units").toString();
        return FormatTools.getPhysicalSize(stepSize, units);
    }

    private Length getStart(Hashtable<String, Object> attrs) {
        Double start = Double.parseDouble(attrs.get("start").toString());
        String units = attrs.get("units").toString();
        return FormatTools.getStagePosition(start, units);
    }
}

