/*
 * Decompiled with CFR 0.152.
 */
package ome.codecs.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.color.ColorSpace;
import java.awt.image.BandedSampleModel;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import loci.common.DataTools;
import ome.codecs.gui.SignedByteBuffer;
import ome.codecs.gui.SignedShortBuffer;
import ome.codecs.gui.TwoChannelColorSpace;
import ome.codecs.gui.UnsignedIntBuffer;
import ome.codecs.gui.UnsignedIntColorModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AWTImageTools {
    protected static final Component OBS = new Container();
    private static final Logger LOGGER = LoggerFactory.getLogger(AWTImageTools.class);

    private AWTImageTools() {
    }

    public static BufferedImage makeImage(byte[] data, int w, int h2, boolean signed) {
        return AWTImageTools.makeImage(new byte[][]{data}, w, h2, signed);
    }

    public static BufferedImage makeImage(short[] data, int w, int h2, boolean signed) {
        return AWTImageTools.makeImage(new short[][]{data}, w, h2, signed);
    }

    public static BufferedImage makeImage(int[] data, int w, int h2, boolean signed) {
        return AWTImageTools.makeImage(new int[][]{data}, w, h2, signed);
    }

    public static BufferedImage makeImage(float[] data, int w, int h2) {
        return AWTImageTools.makeImage(new float[][]{data}, w, h2);
    }

    public static BufferedImage makeImage(double[] data, int w, int h2) {
        return AWTImageTools.makeImage(new double[][]{data}, w, h2);
    }

    public static BufferedImage makeImage(byte[] data, int w, int h2, int c, boolean interleaved, boolean signed) {
        if (c == 1) {
            return AWTImageTools.makeImage(data, w, h2, signed);
        }
        if (c > 2) {
            return AWTImageTools.makeRGBImage(data, c, w, h2, interleaved);
        }
        int dataType = 0;
        DataBuffer buffer = signed ? new SignedByteBuffer(data, c * w * h2) : new DataBufferByte(data, c * w * h2);
        return AWTImageTools.constructImage(c, dataType, w, h2, interleaved, false, buffer);
    }

    public static BufferedImage makeImage(short[] data, int w, int h2, int c, boolean interleaved, boolean signed) {
        DataBuffer buffer;
        int dataType;
        if (c == 1) {
            return AWTImageTools.makeImage(data, w, h2, signed);
        }
        if (signed) {
            dataType = 2;
            buffer = new SignedShortBuffer(data, c * w * h2);
        } else {
            dataType = 1;
            buffer = new DataBufferUShort(data, c * w * h2);
        }
        return AWTImageTools.constructImage(c, dataType, w, h2, interleaved, false, buffer);
    }

    public static BufferedImage makeImage(int[] data, int w, int h2, int c, boolean interleaved, boolean signed) {
        if (c == 1) {
            return AWTImageTools.makeImage(data, w, h2, signed);
        }
        int dataType = 3;
        DataBuffer buffer = signed ? new DataBufferInt(data, c * w * h2) : new UnsignedIntBuffer(data, c * w * h2);
        return AWTImageTools.constructImage(c, dataType, w, h2, interleaved, false, buffer);
    }

    public static BufferedImage makeImage(float[] data, int w, int h2, int c, boolean interleaved) {
        if (c == 1) {
            return AWTImageTools.makeImage(data, w, h2);
        }
        int dataType = 4;
        DataBufferFloat buffer = new DataBufferFloat(data, c * w * h2);
        return AWTImageTools.constructImage(c, dataType, w, h2, interleaved, false, buffer);
    }

    public static BufferedImage makeImage(double[] data, int w, int h2, int c, boolean interleaved) {
        if (c == 1) {
            return AWTImageTools.makeImage(data, w, h2);
        }
        int dataType = 5;
        DataBufferDouble buffer = new DataBufferDouble(data, c * w * h2);
        return AWTImageTools.constructImage(c, dataType, w, h2, interleaved, false, buffer);
    }

    public static BufferedImage makeImage(byte[][] data, int w, int h2, boolean signed) {
        if (data.length > 2) {
            return AWTImageTools.makeRGBImage(data, w, h2);
        }
        int dataType = 0;
        DataBuffer buffer = signed ? new SignedByteBuffer(data, data[0].length) : new DataBufferByte(data, data[0].length);
        return AWTImageTools.constructImage(data.length, dataType, w, h2, false, true, buffer);
    }

    public static BufferedImage makeImage(short[][] data, int w, int h2, boolean signed) {
        DataBuffer buffer;
        int dataType;
        if (signed) {
            dataType = 2;
            buffer = new SignedShortBuffer(data, data[0].length);
        } else {
            dataType = 1;
            buffer = new DataBufferUShort(data, data[0].length);
        }
        return AWTImageTools.constructImage(data.length, dataType, w, h2, false, true, buffer);
    }

    public static BufferedImage makeImage(int[][] data, int w, int h2, boolean signed) {
        int dataType = 3;
        DataBuffer buffer = signed ? new DataBufferInt(data, data[0].length) : new UnsignedIntBuffer(data, data[0].length);
        return AWTImageTools.constructImage(data.length, dataType, w, h2, false, true, buffer);
    }

    public static BufferedImage makeImage(float[][] data, int w, int h2) {
        int dataType = 4;
        DataBufferFloat buffer = new DataBufferFloat(data, data[0].length);
        return AWTImageTools.constructImage(data.length, dataType, w, h2, false, true, buffer);
    }

    public static BufferedImage makeImage(double[][] data, int w, int h2) {
        int dataType = 5;
        DataBufferDouble buffer = new DataBufferDouble(data, data[0].length);
        return AWTImageTools.constructImage(data.length, dataType, w, h2, false, true, buffer);
    }

    public static BufferedImage makeImage(byte[] data, int w, int h2, int c, boolean interleaved, int bpp, boolean fp, boolean little, boolean signed) {
        Object pixels = DataTools.makeDataArray(data, bpp % 3 == 0 ? bpp / 3 : bpp, fp, little);
        if (pixels instanceof byte[]) {
            return AWTImageTools.makeImage((byte[])pixels, w, h2, c, interleaved, signed);
        }
        if (pixels instanceof short[]) {
            return AWTImageTools.makeImage((short[])pixels, w, h2, c, interleaved, signed);
        }
        if (pixels instanceof int[]) {
            return AWTImageTools.makeImage((int[])pixels, w, h2, c, interleaved, signed);
        }
        if (pixels instanceof float[]) {
            return AWTImageTools.makeImage((float[])pixels, w, h2, c, interleaved);
        }
        if (pixels instanceof double[]) {
            return AWTImageTools.makeImage((double[])pixels, w, h2, c, interleaved);
        }
        return null;
    }

    public static BufferedImage makeImage(byte[][] data, int w, int h2, int bpp, boolean fp, boolean little, boolean signed) {
        int c = data.length;
        Object v = null;
        for (int i = 0; i < c; ++i) {
            Object pixels = DataTools.makeDataArray(data[i], bpp % 3 == 0 ? bpp / 3 : bpp, fp, little);
            if (pixels instanceof byte[]) {
                if (v == null) {
                    v = new byte[c][];
                }
                ((byte[][])v)[i] = (byte[])pixels;
                continue;
            }
            if (pixels instanceof short[]) {
                if (v == null) {
                    v = new short[c][];
                }
                ((short[][])v)[i] = (short[])pixels;
                continue;
            }
            if (pixels instanceof int[]) {
                if (v == null) {
                    v = new int[c][];
                }
                ((int[][])v)[i] = (int[])pixels;
                continue;
            }
            if (pixels instanceof float[]) {
                if (v == null) {
                    v = new float[c][];
                }
                ((float[][])v)[i] = (float[])pixels;
                continue;
            }
            if (!(pixels instanceof double[])) continue;
            if (v == null) {
                v = new double[c][];
            }
            ((double[][])v)[i] = (double[])pixels;
        }
        if (v instanceof byte[][]) {
            return AWTImageTools.makeImage(v, w, h2, signed);
        }
        if (v instanceof short[][]) {
            return AWTImageTools.makeImage((short[][])v, w, h2, signed);
        }
        if (v instanceof int[][]) {
            return AWTImageTools.makeImage((int[][])v, w, h2, signed);
        }
        if (v instanceof float[][]) {
            return AWTImageTools.makeImage(v, w, h2);
        }
        if (v instanceof double[][]) {
            return AWTImageTools.makeImage((double[][])v, w, h2);
        }
        return null;
    }

    public static BufferedImage makeRGBImage(byte[] data, int c, int w, int h2, boolean interleaved) {
        int cc = Math.min(c, 4);
        int[] buf = new int[data.length / c];
        int nBits = (cc - 1) * 8;
        for (int i = 0; i < buf.length; ++i) {
            for (int q = 0; q < cc; ++q) {
                if (interleaved) {
                    int n = i;
                    buf[n] = buf[n] | (data[i * c + q] & 0xFF) << nBits - q * 8;
                    continue;
                }
                int n = i;
                buf[n] = buf[n] | (data[q * buf.length + i] & 0xFF) << nBits - q * 8;
            }
        }
        DataBufferInt buffer = new DataBufferInt(buf, buf.length);
        return AWTImageTools.constructImage(cc, 3, w, h2, false, false, buffer);
    }

    public static BufferedImage makeRGBImage(byte[][] data, int w, int h2) {
        int[] buf = new int[data[0].length];
        int nBits = (data.length - 1) * 8;
        for (int i = 0; i < buf.length; ++i) {
            for (int q = 0; q < data.length; ++q) {
                int n = i;
                buf[n] = buf[n] | (data[q][i] & 0xFF) << nBits - q * 8;
            }
        }
        DataBufferInt buffer = new DataBufferInt(buf, buf.length);
        return AWTImageTools.constructImage(data.length, 3, w, h2, false, false, buffer);
    }

    public static BufferedImage constructImage(int c, int type, int w, int h2, boolean interleaved, boolean banded, DataBuffer buffer) {
        return AWTImageTools.constructImage(c, type, w, h2, interleaved, banded, buffer, null);
    }

    public static BufferedImage constructImage(int c, int type, int w, int h2, boolean interleaved, boolean banded, DataBuffer buffer, ColorModel colorModel) {
        int[] bandOffsets;
        SampleModel model;
        int i;
        if (c > 4) {
            throw new IllegalArgumentException("Cannot construct image with " + c + " channels");
        }
        if (colorModel == null || colorModel instanceof DirectColorModel) {
            colorModel = AWTImageTools.makeColorModel(c, type);
            if (colorModel == null) {
                return null;
            }
            if (buffer instanceof UnsignedIntBuffer) {
                try {
                    colorModel = new UnsignedIntColorModel(32, type, c);
                }
                catch (IOException e) {
                    return null;
                }
            }
        }
        if (c > 2 && type == 3 && buffer.getNumBanks() == 1 && !(buffer instanceof UnsignedIntBuffer)) {
            int[] bitMasks = new int[c];
            for (i = 0; i < c; ++i) {
                bitMasks[i] = 255 << (c - i - 1) * 8;
            }
            model = new SinglePixelPackedSampleModel(3, w, h2, bitMasks);
        } else if (banded) {
            model = new BandedSampleModel(type, w, h2, c);
        } else if (interleaved) {
            bandOffsets = new int[c];
            for (i = 0; i < c; ++i) {
                bandOffsets[i] = i;
            }
            model = new PixelInterleavedSampleModel(type, w, h2, c, c * w, bandOffsets);
        } else {
            bandOffsets = new int[c];
            for (i = 0; i < c; ++i) {
                bandOffsets[i] = i * w * h2;
            }
            model = new ComponentSampleModel(type, w, h2, 1, w, bandOffsets);
        }
        WritableRaster raster = Raster.createWritableRaster(model, buffer, null);
        BufferedImage b = null;
        if (c == 1 && type == 0 && !(buffer instanceof SignedByteBuffer)) {
            b = colorModel instanceof IndexColorModel ? new BufferedImage(w, h2, 13) : new BufferedImage(w, h2, 10);
            b.setData(raster);
        } else if (c == 1 && type == 1) {
            if (!(colorModel instanceof IndexColorModel)) {
                b = new BufferedImage(w, h2, 11);
                b.setData(raster);
            }
        } else if (c > 2 && type == 3 && buffer.getNumBanks() == 1 && !(buffer instanceof UnsignedIntBuffer)) {
            if (c == 3) {
                b = new BufferedImage(w, h2, 1);
            } else if (c == 4) {
                b = new BufferedImage(w, h2, 2);
            }
            if (b != null) {
                b.setData(raster);
            }
        }
        if (b == null) {
            b = new BufferedImage(colorModel, raster, false, null);
        }
        return b;
    }

    public static Object getPixels(BufferedImage image) {
        return AWTImageTools.getPixels(image, 0, 0, image.getWidth(), image.getHeight());
    }

    public static Object getPixels(BufferedImage image, int x, int y, int w, int h2) {
        WritableRaster raster = image.getRaster();
        return AWTImageTools.getPixels(raster, x, y, w, h2);
    }

    public static Object getPixels(WritableRaster raster) {
        return AWTImageTools.getPixels(raster, 0, 0, raster.getWidth(), raster.getHeight());
    }

    public static Object getPixels(WritableRaster raster, int x, int y, int w, int h2) {
        int tt = raster.getTransferType();
        if (tt == 0) {
            return AWTImageTools.getBytes(raster, x, y, w, h2);
        }
        if (tt == 1 || tt == 2) {
            return AWTImageTools.getShorts(raster, x, y, w, h2);
        }
        if (tt == 3) {
            return AWTImageTools.getInts(raster, x, y, w, h2);
        }
        if (tt == 4) {
            return AWTImageTools.getFloats(raster, x, y, w, h2);
        }
        if (tt == 5) {
            return AWTImageTools.getDoubles(raster, x, y, w, h2);
        }
        return null;
    }

    public static byte[][] getBytes(BufferedImage image) {
        WritableRaster r = image.getRaster();
        return AWTImageTools.getBytes(r);
    }

    public static byte[][] getBytes(WritableRaster r) {
        return AWTImageTools.getBytes(r, 0, 0, r.getWidth(), r.getHeight());
    }

    public static byte[][] getBytes(WritableRaster r, int x, int y, int w, int h2) {
        if (AWTImageTools.canUseBankDataDirectly(r, 0, DataBufferByte.class) && x == 0 && y == 0 && w == r.getWidth() && h2 == r.getHeight()) {
            return ((DataBufferByte)r.getDataBuffer()).getBankData();
        }
        int c = r.getNumBands();
        byte[][] samples = new byte[c][w * h2];
        int[] buf = new int[w * h2];
        for (int i = 0; i < c; ++i) {
            r.getSamples(x, y, w, h2, i, buf);
            for (int j = 0; j < buf.length; ++j) {
                samples[i][j] = (byte)buf[j];
            }
        }
        return samples;
    }

    public static short[][] getShorts(BufferedImage image) {
        WritableRaster r = image.getRaster();
        return AWTImageTools.getShorts(r);
    }

    public static short[][] getShorts(WritableRaster r) {
        return AWTImageTools.getShorts(r, 0, 0, r.getWidth(), r.getHeight());
    }

    public static short[][] getShorts(WritableRaster r, int x, int y, int w, int h2) {
        if (AWTImageTools.canUseBankDataDirectly(r, 1, DataBufferUShort.class) && x == 0 && y == 0 && w == r.getWidth() && h2 == r.getHeight()) {
            return ((DataBufferUShort)r.getDataBuffer()).getBankData();
        }
        int c = r.getNumBands();
        short[][] samples = new short[c][w * h2];
        int[] buf = new int[w * h2];
        for (int i = 0; i < c; ++i) {
            r.getSamples(x, y, w, h2, i, buf);
            for (int j = 0; j < buf.length; ++j) {
                samples[i][j] = (short)buf[j];
            }
        }
        return samples;
    }

    public static int[][] getInts(BufferedImage image) {
        WritableRaster r = image.getRaster();
        return AWTImageTools.getInts(r);
    }

    public static int[][] getInts(WritableRaster r) {
        return AWTImageTools.getInts(r, 0, 0, r.getWidth(), r.getHeight());
    }

    public static int[][] getInts(WritableRaster r, int x, int y, int w, int h2) {
        if (AWTImageTools.canUseBankDataDirectly(r, 3, DataBufferInt.class) && x == 0 && y == 0 && w == r.getWidth() && h2 == r.getHeight()) {
            return ((DataBufferInt)r.getDataBuffer()).getBankData();
        }
        int c = r.getNumBands();
        int[][] samples = new int[c][w * h2];
        for (int i = 0; i < c; ++i) {
            r.getSamples(x, y, w, h2, i, samples[i]);
        }
        return samples;
    }

    public static float[][] getFloats(BufferedImage image) {
        WritableRaster r = image.getRaster();
        return AWTImageTools.getFloats(r);
    }

    public static float[][] getFloats(WritableRaster r) {
        return AWTImageTools.getFloats(r, 0, 0, r.getWidth(), r.getHeight());
    }

    public static float[][] getFloats(WritableRaster r, int x, int y, int w, int h2) {
        if (AWTImageTools.canUseBankDataDirectly(r, 4, DataBufferFloat.class) && x == 0 && y == 0 && w == r.getWidth() && h2 == r.getHeight()) {
            return ((DataBufferFloat)r.getDataBuffer()).getBankData();
        }
        int c = r.getNumBands();
        float[][] samples = new float[c][w * h2];
        for (int i = 0; i < c; ++i) {
            r.getSamples(x, y, w, h2, i, samples[i]);
        }
        return samples;
    }

    public static double[][] getDoubles(BufferedImage image) {
        WritableRaster r = image.getRaster();
        return AWTImageTools.getDoubles(r);
    }

    public static double[][] getDoubles(WritableRaster r) {
        return AWTImageTools.getDoubles(r, 0, 0, r.getWidth(), r.getHeight());
    }

    public static double[][] getDoubles(WritableRaster r, int x, int y, int w, int h2) {
        if (AWTImageTools.canUseBankDataDirectly(r, 5, DataBufferDouble.class) && x == 0 && y == 0 && w == r.getWidth() && h2 == r.getHeight()) {
            return ((DataBufferDouble)r.getDataBuffer()).getBankData();
        }
        int c = r.getNumBands();
        double[][] samples = new double[c][w * h2];
        for (int i = 0; i < c; ++i) {
            r.getSamples(x, y, w, h2, i, samples[i]);
        }
        return samples;
    }

    private static boolean canUseBankDataDirectly(WritableRaster r, int transferType, Class<? extends DataBuffer> dataBufferClass) {
        int i;
        int tt = r.getTransferType();
        if (tt != transferType) {
            return false;
        }
        DataBuffer buffer = r.getDataBuffer();
        if (!dataBufferClass.isInstance(buffer)) {
            return false;
        }
        SampleModel model = r.getSampleModel();
        if (!(model instanceof ComponentSampleModel)) {
            return false;
        }
        ComponentSampleModel csm = (ComponentSampleModel)model;
        int pixelStride = csm.getPixelStride();
        if (pixelStride != 1) {
            return false;
        }
        int w = r.getWidth();
        int scanlineStride = csm.getScanlineStride();
        if (scanlineStride != w) {
            return false;
        }
        int c = r.getNumBands();
        int[] bandOffsets = csm.getBandOffsets();
        if (bandOffsets.length != c) {
            return false;
        }
        for (i = 0; i < bandOffsets.length; ++i) {
            if (bandOffsets[i] == 0) continue;
            return false;
        }
        for (i = 0; i < bandOffsets.length; ++i) {
            if (bandOffsets[i] == i) continue;
            return false;
        }
        return true;
    }

    public static byte[][] getPixelBytes(BufferedImage img, boolean little) {
        return AWTImageTools.getPixelBytes(img, little, 0, 0, img.getWidth(), img.getHeight());
    }

    public static byte[][] getPixelBytes(WritableRaster r, boolean little) {
        return AWTImageTools.getPixelBytes(r, little, 0, 0, r.getWidth(), r.getHeight());
    }

    public static byte[][] getPixelBytes(BufferedImage img, boolean little, int x, int y, int w, int h2) {
        byte[][] pixelBytes;
        block14: {
            Object pixels;
            block17: {
                block16: {
                    int imageType;
                    block15: {
                        block13: {
                            pixels = AWTImageTools.getPixels(img, x, y, w, h2);
                            imageType = img.getType();
                            pixelBytes = null;
                            if (!(pixels instanceof byte[][])) break block13;
                            pixelBytes = (byte[][])pixels;
                            break block14;
                        }
                        if (!(pixels instanceof short[][])) break block15;
                        short[][] s2 = (short[][])pixels;
                        pixelBytes = new byte[s2.length][s2[0].length * 2];
                        for (int i = 0; i < pixelBytes.length; ++i) {
                            for (int j = 0; j < s2[0].length; ++j) {
                                DataTools.unpackBytes(s2[i][j], pixelBytes[i], j * 2, 2, little);
                            }
                        }
                        break block14;
                    }
                    if (!(pixels instanceof int[][])) break block16;
                    int[][] in = (int[][])pixels;
                    if (imageType == 1 || imageType == 4 || imageType == 2) {
                        pixelBytes = new byte[in.length][in[0].length];
                        for (int c = 0; c < in.length; ++c) {
                            for (int i = 0; i < in[0].length; ++i) {
                                if (imageType != 4) {
                                    pixelBytes[c][i] = (byte)(in[c][i] & 0xFF);
                                    continue;
                                }
                                pixelBytes[in.length - c - 1][i] = (byte)(in[c][i] & 0xFF);
                            }
                        }
                    } else {
                        pixelBytes = new byte[in.length][in[0].length * 4];
                        for (int i = 0; i < pixelBytes.length; ++i) {
                            for (int j = 0; j < in[0].length; ++j) {
                                DataTools.unpackBytes(in[i][j], pixelBytes[i], j * 4, 4, little);
                            }
                        }
                    }
                    break block14;
                }
                if (!(pixels instanceof float[][])) break block17;
                float[][] in = (float[][])pixels;
                pixelBytes = new byte[in.length][in[0].length * 4];
                for (int i = 0; i < pixelBytes.length; ++i) {
                    for (int j = 0; j < in[0].length; ++j) {
                        int v = Float.floatToIntBits(in[i][j]);
                        DataTools.unpackBytes(v, pixelBytes[i], j * 4, 4, little);
                    }
                }
                break block14;
            }
            if (!(pixels instanceof double[][])) break block14;
            double[][] in = (double[][])pixels;
            pixelBytes = new byte[in.length][in[0].length * 8];
            for (int i = 0; i < pixelBytes.length; ++i) {
                for (int j = 0; j < in[0].length; ++j) {
                    long v = Double.doubleToLongBits(in[i][j]);
                    DataTools.unpackBytes(v, pixelBytes[i], j * 8, 8, little);
                }
            }
        }
        return pixelBytes;
    }

    public static byte[][] getPixelBytes(WritableRaster r, boolean little, int x, int y, int w, int h2) {
        Object in;
        int j;
        int i;
        Object pixels = AWTImageTools.getPixels(r);
        byte[][] pixelBytes = null;
        int bpp = 0;
        if (pixels instanceof byte[][]) {
            pixelBytes = (byte[][])pixels;
            bpp = 1;
        } else if (pixels instanceof short[][]) {
            bpp = 2;
            short[][] s2 = (short[][])pixels;
            pixelBytes = new byte[s2.length][s2[0].length * bpp];
            for (i = 0; i < pixelBytes.length; ++i) {
                for (j = 0; j < s2[0].length; ++j) {
                    DataTools.unpackBytes(s2[i][j], pixelBytes[i], j * bpp, bpp, little);
                }
            }
        } else if (pixels instanceof int[][]) {
            bpp = 4;
            in = (int[][])pixels;
            pixelBytes = new byte[((int[][])in).length][in[0].length * bpp];
            for (i = 0; i < pixelBytes.length; ++i) {
                for (j = 0; j < in[0].length; ++j) {
                    DataTools.unpackBytes(in[i][j], pixelBytes[i], j * bpp, bpp, little);
                }
            }
        } else if (pixels instanceof float[][]) {
            bpp = 4;
            in = (float[][])pixels;
            pixelBytes = new byte[((int[][])in).length][in[0].length * bpp];
            for (i = 0; i < pixelBytes.length; ++i) {
                for (j = 0; j < in[0].length; ++j) {
                    int v = Float.floatToIntBits(in[i][j]);
                    DataTools.unpackBytes(v, pixelBytes[i], j * bpp, bpp, little);
                }
            }
        } else if (pixels instanceof double[][]) {
            bpp = 8;
            in = (double[][])pixels;
            pixelBytes = new byte[((int[][])in).length][in[0].length * bpp];
            for (i = 0; i < pixelBytes.length; ++i) {
                for (j = 0; j < in[0].length; ++j) {
                    long v = Double.doubleToLongBits(in[i][j]);
                    DataTools.unpackBytes(v, pixelBytes[i], j * bpp, bpp, little);
                }
            }
        }
        if (x == 0 && y == 0 && w == r.getWidth() && h2 == r.getHeight()) {
            return pixelBytes;
        }
        byte[][] croppedBytes = new byte[pixelBytes.length][w * h2 * bpp];
        for (int c = 0; c < croppedBytes.length; ++c) {
            for (int row = 0; row < h2; ++row) {
                int src = (row + y) * r.getWidth() * bpp + x * bpp;
                int dest = row * w * bpp;
                System.arraycopy(pixelBytes[c], src, croppedBytes[c], dest, w * bpp);
            }
        }
        return croppedBytes;
    }

    public static byte[] getBytes(BufferedImage img, boolean separated) {
        byte[][] p = AWTImageTools.getBytes(img);
        if (separated || p.length == 1) {
            return p[0];
        }
        byte[] rtn = new byte[p.length * p[0].length];
        for (int i = 0; i < p.length; ++i) {
            System.arraycopy(p[i], 0, rtn, i * p[0].length, p[i].length);
        }
        return rtn;
    }

    public static ColorSpace makeColorSpace(int c) {
        int type;
        switch (c) {
            case 1: {
                type = 1003;
                break;
            }
            case 2: {
                type = -1;
                break;
            }
            case 3: {
                type = 1000;
                break;
            }
            case 4: {
                type = 1000;
                break;
            }
            default: {
                return null;
            }
        }
        return TwoChannelColorSpace.getInstance(type);
    }

    public static ColorModel makeColorModel(int c, int dataType) {
        ColorSpace cs = AWTImageTools.makeColorSpace(c);
        return cs == null ? null : new ComponentColorModel(cs, c == 4, false, 3, dataType);
    }
}

