/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Reference;
import ome.xml.model.Shape;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.enums.Marker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Polyline
extends Shape {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/OME/2016-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(Polyline.class);
    private String points;
    private Marker markerStart;
    private Marker markerEnd;

    public Polyline() {
    }

    public Polyline(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    public Polyline(Polyline orig) {
        super(orig);
        this.points = orig.points;
        this.markerStart = orig.markerStart;
        this.markerEnd = orig.markerEnd;
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        super.update(element, model);
        String tagName = element.getTagName();
        if (element.hasAttribute("Points")) {
            this.setPoints(String.valueOf(element.getAttribute("Points")));
        }
        if (element.hasAttribute("MarkerStart")) {
            this.setMarkerStart(Marker.fromString(element.getAttribute("MarkerStart")));
        }
        if (element.hasAttribute("MarkerEnd")) {
            this.setMarkerEnd(Marker.fromString(element.getAttribute("MarkerEnd")));
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        boolean wasHandledBySuperClass = super.link(reference, o);
        if (wasHandledBySuperClass) {
            return true;
        }
        LOGGER.debug("Unable to handle reference of type: {}", (Object)reference.getClass());
        return false;
    }

    public String getPoints() {
        return this.points;
    }

    public void setPoints(String points) {
        this.points = points;
    }

    public Marker getMarkerStart() {
        return this.markerStart;
    }

    public void setMarkerStart(Marker markerStart) {
        this.markerStart = markerStart;
    }

    public Marker getMarkerEnd() {
        return this.markerEnd;
    }

    public void setMarkerEnd(Marker markerEnd) {
        this.markerEnd = markerEnd;
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    @Override
    public Element asXMLElement(Document document, Element Polyline_element) {
        if (Polyline_element == null) {
            Polyline_element = document.createElementNS(NAMESPACE, "Polyline");
        }
        super.asXMLElement(document, Polyline_element);
        if (this.points != null) {
            Polyline_element.setAttribute("Points", this.points.toString());
        }
        if (this.markerStart != null) {
            Polyline_element.setAttribute("MarkerStart", this.markerStart.toString());
        }
        if (this.markerEnd != null) {
            Polyline_element.setAttribute("MarkerEnd", this.markerEnd.toString());
        }
        return Polyline_element;
    }
}

