/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset;

import java.io.IOException;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.ArrayDouble;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.MAMath;
import ucar.ma2.Range;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxisTimeHelper;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.util.Misc;

public class CoordinateAxis2D
extends CoordinateAxis {
    private static Logger log = LoggerFactory.getLogger(CoordinateAxis2D.class);
    private static final boolean debug = false;
    private static final double MAX_JUMP = 100.0;
    private ArrayDouble.D2 coords;
    private boolean isInterval;
    private boolean intervalWasComputed;

    @Deprecated
    public CoordinateAxis2D(NetcdfDataset ncd, VariableDS vds) {
        super(ncd, vds);
        this.isContiguous = false;
    }

    @Override
    protected CoordinateAxis2D copy() {
        return new CoordinateAxis2D(this.ncd, this);
    }

    public double getCoordValue(int j, int i) {
        if (this.coords == null) {
            this.doRead();
        }
        return this.coords.get(j, i);
    }

    private void doRead() {
        Array data;
        try {
            data = this.read();
        }
        catch (IOException ioe) {
            log.error("Error reading coordinate values " + ioe);
            throw new IllegalStateException(ioe);
        }
        if (data.getRank() != 2) {
            throw new IllegalArgumentException("must be 2D");
        }
        this.coords = (ArrayDouble.D2)Array.factory(DataType.DOUBLE, data.getShape(), data.get1DJavaArray(DataType.DOUBLE));
        if (this.axisType == AxisType.Lon) {
            this.makeConnectedLon(this.coords);
        }
    }

    @Override
    public boolean isInterval() {
        if (!this.intervalWasComputed) {
            this.isInterval = this.computeIsInterval();
        }
        return this.isInterval;
    }

    private void makeConnectedLon(ArrayDouble.D2 mid) {
        int[] shape = mid.getShape();
        int ny = shape[0];
        int nx = shape[1];
        double connect = mid.get(0, 0);
        for (int i = 1; i < nx; ++i) {
            connect = CoordinateAxis2D.connectLon(connect, mid.get(0, i));
            mid.set(0, i, connect);
        }
        for (int j = 1; j < ny; ++j) {
            connect = mid.get(j - 1, 0);
            for (int i = 0; i < nx; ++i) {
                connect = CoordinateAxis2D.connectLon(connect, mid.get(j, i));
                mid.set(j, i, connect);
            }
        }
    }

    private static double connectLon(double connect, double val) {
        if (Double.isNaN(connect)) {
            return val;
        }
        if (Double.isNaN(val)) {
            return val;
        }
        double diff = val - connect;
        if (Math.abs(diff) < 100.0) {
            return val;
        }
        double result = diff > 0.0 ? val - 360.0 : val + 360.0;
        double diff2 = connect - result;
        if (Math.abs(diff2) < Math.abs(diff)) {
            val = result;
        }
        return val;
    }

    public double[] getCoordValues() {
        if (this.coords == null) {
            this.doRead();
        }
        if (!this.isNumeric()) {
            throw new UnsupportedOperationException("CoordinateAxis2D.getCoordValues() on non-numeric");
        }
        return (double[])this.coords.get1DJavaArray(DataType.DOUBLE);
    }

    public CoordinateAxis2D section(Range r1, Range r2) throws InvalidRangeException {
        ArrayList<Range> section = new ArrayList<Range>();
        section.add(r1);
        section.add(r2);
        return (CoordinateAxis2D)this.section(section);
    }

    public ArrayDouble.D2 getCoordValuesArray() {
        if (this.coords == null) {
            this.doRead();
        }
        return this.coords;
    }

    public ArrayDouble.D3 getCoordBoundsArray() {
        if (this.coords == null) {
            this.doRead();
        }
        return this.makeBoundsFromAux();
    }

    public ArrayDouble.D2 getEdges() {
        ArrayDouble.D2 mids = this.getCoordValuesArray();
        return CoordinateAxis2D.makeEdges(mids);
    }

    public ArrayDouble.D2 getXEdges() {
        ArrayDouble.D2 mids = this.getCoordValuesArray();
        return CoordinateAxis2D.makeEdges(mids);
    }

    public ArrayDouble.D2 getYEdges() {
        ArrayDouble.D2 mids = this.getCoordValuesArray();
        return CoordinateAxis2D.makeEdges(mids);
    }

    public static ArrayDouble.D2 makeEdges(ArrayDouble.D2 midpoints) {
        int[] shape = midpoints.getShape();
        int ny = shape[0];
        int nx = shape[1];
        ArrayDouble.D2 edge = new ArrayDouble.D2(ny + 1, nx + 1);
        for (int y = 0; y < ny - 1; ++y) {
            for (int x = 0; x < nx - 1; ++x) {
                double xval = (midpoints.get(y, x) + midpoints.get(y, x + 1) + midpoints.get(y + 1, x) + midpoints.get(y + 1, x + 1)) / 4.0;
                edge.set(y + 1, x + 1, xval);
            }
            edge.set(y + 1, 0, edge.get(y + 1, 1) - (edge.get(y + 1, 2) - edge.get(y + 1, 1)));
            edge.set(y + 1, nx, edge.get(y + 1, nx - 1) + (edge.get(y + 1, nx - 1) - edge.get(y + 1, nx - 2)));
        }
        for (int x = 0; x < nx + 1; ++x) {
            edge.set(0, x, edge.get(1, x) - (edge.get(2, x) - edge.get(1, x)));
            edge.set(ny, x, edge.get(ny - 1, x) + (edge.get(ny - 1, x) - edge.get(ny - 2, x)));
        }
        return edge;
    }

    public static ArrayDouble.D2 makeXEdgesRotated(ArrayDouble.D2 midx) {
        int x;
        int[] shape = midx.getShape();
        int ny = shape[0];
        int nx = shape[1];
        ArrayDouble.D2 edgex = new ArrayDouble.D2(ny + 2, nx + 1);
        for (int y = 0; y < ny; ++y) {
            for (int x2 = 1; x2 < nx; ++x2) {
                double xval = (midx.get(y, x2 - 1) + midx.get(y, x2)) / 2.0;
                edgex.set(y + 1, x2, xval);
            }
            edgex.set(y + 1, 0, midx.get(y, 0) - (edgex.get(y + 1, 1) - midx.get(y, 0)));
            edgex.set(y + 1, nx, midx.get(y, nx - 1) - (edgex.get(y + 1, nx - 1) - midx.get(y, nx - 1)));
        }
        for (x = 0; x < nx; ++x) {
            edgex.set(0, x, midx.get(0, x));
        }
        for (x = 0; x < nx - 1; ++x) {
            edgex.set(ny + 1, x, midx.get(ny - 1, x));
        }
        return edgex;
    }

    public static ArrayDouble.D2 makeYEdgesRotated(ArrayDouble.D2 midy) {
        double diff;
        double pt;
        int x;
        int[] shape = midy.getShape();
        int ny = shape[0];
        int nx = shape[1];
        ArrayDouble.D2 edgey = new ArrayDouble.D2(ny + 2, nx + 1);
        for (int y = 0; y < ny; ++y) {
            for (int x2 = 1; x2 < nx; ++x2) {
                double yval = (midy.get(y, x2 - 1) + midy.get(y, x2)) / 2.0;
                edgey.set(y + 1, x2, yval);
            }
            edgey.set(y + 1, 0, midy.get(y, 0) - (edgey.get(y + 1, 1) - midy.get(y, 0)));
            edgey.set(y + 1, nx, midy.get(y, nx - 1) - (edgey.get(y + 1, nx - 1) - midy.get(y, nx - 1)));
        }
        for (x = 0; x < nx; ++x) {
            double pt0 = midy.get(0, x);
            pt = edgey.get(2, x);
            diff = pt0 - pt;
            edgey.set(0, x, pt0 + diff);
        }
        for (x = 0; x < nx - 1; ++x) {
            double pt0 = midy.get(ny - 1, x);
            pt = edgey.get(ny - 1, x);
            diff = pt0 - pt;
            edgey.set(ny + 1, x, pt0 + diff);
        }
        return edgey;
    }

    private ArrayDouble.D3 makeBoundsFromAux() {
        ArrayDouble.D3 bounds;
        Array data;
        if (!this.computeIsInterval()) {
            return null;
        }
        String boundsVarName = this.attributes().findAttValueIgnoreCase("bounds", null);
        if (boundsVarName == null) {
            return null;
        }
        VariableDS boundsVar = (VariableDS)this.ncd.findVariable(this.getParentGroup(), boundsVarName);
        try {
            data = boundsVar.read();
        }
        catch (IOException e) {
            log.warn("CoordinateAxis2D.makeBoundsFromAux read failed ", e);
            return null;
        }
        assert (data.getRank() == 3 && data.getShape()[2] == 2) : "incorrect shape data for variable " + boundsVar;
        if (data instanceof ArrayDouble.D3) {
            bounds = (ArrayDouble.D3)data;
        } else {
            bounds = (ArrayDouble.D3)Array.factory(DataType.DOUBLE, data.getShape());
            MAMath.copy(data, bounds);
        }
        return bounds;
    }

    private boolean computeIsInterval() {
        this.intervalWasComputed = true;
        String boundsVarName = this.attributes().findAttValueIgnoreCase("bounds", null);
        if (boundsVarName == null) {
            return false;
        }
        VariableDS boundsVar = (VariableDS)this.ncd.findVariable(this.getParentGroup(), boundsVarName);
        if (null == boundsVar) {
            return false;
        }
        if (3 != boundsVar.getRank()) {
            return false;
        }
        if (this.getDimension(0) != boundsVar.getDimension(0)) {
            return false;
        }
        if (this.getDimension(1) != boundsVar.getDimension(1)) {
            return false;
        }
        return 2 == boundsVar.getDimension(2).getLength();
    }

    public CoordinateAxisTimeHelper getCoordinateAxisTimeHelper() {
        return new CoordinateAxisTimeHelper(this.getCalendarFromAttribute(), this.getUnitsString());
    }

    public int findTimeIndexFromCalendarDate(int run_idx, CalendarDate want) {
        CoordinateAxisTimeHelper helper = this.getCoordinateAxisTimeHelper();
        double wantOffset = helper.offsetFromRefDate(want);
        if (this.isInterval()) {
            ArrayDouble.D3 bounds = this.getCoordBoundsArray();
            if (bounds == null) {
                throw new IllegalStateException("getCoordBoundsArray returned null for coordinate " + this.getFullName());
            }
            ArrayDouble.D2 boundsForRun = (ArrayDouble.D2)bounds.slice(0, run_idx);
            int idx = this.findSingleHit(boundsForRun, wantOffset);
            if (idx >= 0) {
                return idx;
            }
            if (idx == -1) {
                return -1;
            }
            return this.findClosest(boundsForRun, wantOffset);
        }
        ArrayDouble.D2 values = this.getCoordValuesArray();
        ArrayDouble.D1 valuesForRun = (ArrayDouble.D1)values.slice(0, run_idx);
        int i = 0;
        while ((long)i < valuesForRun.getSize()) {
            if (Misc.nearlyEquals(valuesForRun.get(i), wantOffset)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private int findSingleHit(ArrayDouble.D2 boundsForRun, double target) {
        int hits = 0;
        int idxFound = -1;
        int n = boundsForRun.getShape()[0];
        for (int i = 0; i < n; ++i) {
            if (!this.contains(target, boundsForRun.get(i, 0), boundsForRun.get(i, 1))) continue;
            ++hits;
            idxFound = i;
        }
        if (hits == 1) {
            return idxFound;
        }
        if (hits == 0) {
            return -1;
        }
        return -hits;
    }

    private int findClosest(ArrayDouble.D2 boundsForRun, double target) {
        double minDiff = Double.MAX_VALUE;
        int idxFound = -1;
        int n = boundsForRun.getShape()[0];
        for (int i = 0; i < n; ++i) {
            double midpoint = (boundsForRun.get(i, 0) + boundsForRun.get(i, 1)) / 2.0;
            double diff = Math.abs(midpoint - target);
            if (!(diff < minDiff)) continue;
            minDiff = diff;
            idxFound = i;
        }
        return idxFound;
    }

    private boolean contains(double target, double b1, double b2) {
        if (b1 <= target && target <= b2) {
            return true;
        }
        return b1 >= target && target >= b2;
    }

    protected CoordinateAxis2D(Builder<?> builder) {
        super((CoordinateAxis.Builder<?>)builder);
    }

    @Override
    public Builder<?> toBuilder() {
        return this.addLocalFieldsToBuilder(CoordinateAxis2D.builder());
    }

    protected Builder<?> addLocalFieldsToBuilder(Builder<? extends Builder<?>> b) {
        return (Builder)super.addLocalFieldsToBuilder((CoordinateAxis.Builder<? extends CoordinateAxis.Builder<?>>)b);
    }

    public static Builder<?> builder() {
        return new Builder2();
    }

    public static abstract class Builder<T extends Builder<T>>
    extends CoordinateAxis.Builder<T> {
        private boolean built;

        @Override
        protected abstract T self();

        @Override
        public CoordinateAxis2D build() {
            if (this.built) {
                throw new IllegalStateException("already built");
            }
            this.built = true;
            return new CoordinateAxis2D(this);
        }
    }

    private static class Builder2
    extends Builder<Builder2> {
        private Builder2() {
        }

        @Override
        protected Builder2 self() {
            return this;
        }
    }
}

