"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnMapping = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const annotations_1 = require("./annotations");
const cfn_element_1 = require("./cfn-element");
const cfn_fn_1 = require("./cfn-fn");
const token_1 = require("./token");
/**
 * Represents a CloudFormation mapping.
 */
class CfnMapping extends cfn_element_1.CfnRefElement {
    constructor(scope, id, props = {}) {
        super(scope, id);
        this.lazyRender = false;
        this.lazyInformed = false;
        try {
            jsiiDeprecationWarnings._aws_cdk_core_CfnMappingProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnMapping);
            }
            throw error;
        }
        this.mapping = props.mapping ? this.validateMapping(props.mapping) : {};
        this.lazy = props.lazy;
    }
    /**
     * Sets a value in the map based on the two keys.
     */
    setValue(key1, key2, value) {
        this.validateAlphanumeric(key2);
        if (!(key1 in this.mapping)) {
            this.mapping[key1] = {};
        }
        this.mapping[key1][key2] = value;
    }
    /**
     * @returns A reference to a value in the map based on the two keys.
     */
    findInMap(key1, key2) {
        let fullyResolved = false;
        if (!token_1.Token.isUnresolved(key1)) {
            if (!(key1 in this.mapping)) {
                throw new Error(`Mapping doesn't contain top-level key '${key1}'`);
            }
            if (!token_1.Token.isUnresolved(key2)) {
                if (!(key2 in this.mapping[key1])) {
                    throw new Error(`Mapping doesn't contain second-level key '${key2}'`);
                }
                fullyResolved = true;
            }
        }
        if (fullyResolved) {
            if (this.lazy) {
                return this.mapping[key1][key2];
            }
        }
        else {
            this.lazyRender = true;
        }
        return cfn_fn_1.Fn.findInMap(this.logicalId, key1, key2);
    }
    /**
     * @internal
     */
    _toCloudFormation() {
        if (this.lazy === undefined && !this.lazyRender) {
            this.informLazyUse();
        }
        if (!this.lazy || (this.lazy && this.lazyRender)) {
            return {
                Mappings: {
                    [this.logicalId]: this.mapping,
                },
            };
        }
        else {
            return {};
        }
    }
    informLazyUse() {
        if (!this.lazyInformed) {
            annotations_1.Annotations.of(this).addInfo('Consider making this CfnMapping a lazy mapping by providing `lazy: true`: either no findInMap was called or every findInMap could be immediately resolved without using Fn::FindInMap');
        }
        this.lazyInformed = true;
    }
    validateMapping(mapping) {
        Object.keys(mapping).forEach((m) => Object.keys(mapping[m]).forEach(this.validateAlphanumeric));
        return mapping;
    }
    validateAlphanumeric(value) {
        // https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/mappings-section-structure.html
        if (value.match(/[^a-zA-Z0-9]/g)) {
            throw new Error(`Attribute name '${value}' must contain only alphanumeric characters.`);
        }
    }
}
exports.CfnMapping = CfnMapping;
_a = JSII_RTTI_SYMBOL_1;
CfnMapping[_a] = { fqn: "@aws-cdk/core.CfnMapping", version: "1.179.0" };
//# sourceMappingURL=data:application/json;base64,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