"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ResourcePermissions = exports.Resource = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const constructs_1 = require("constructs");
/**
 * Base class for all Kubernetes objects in stdk8s. Represents a single
 * resource.
 */
class Resource extends constructs_1.Construct {
    constructor(scope, id) {
        super(scope, id);
        this.permissions = new ResourcePermissions(this);
    }
    get metadata() {
        return this.apiObject.metadata;
    }
    /**
     * The name of this API object.
     */
    get name() {
        return this.apiObject.name;
    }
    /**
     * The object's API version (e.g. "authorization.k8s.io/v1")
     */
    get apiVersion() {
        return this.apiObject.apiVersion;
    }
    /**
     * The group portion of the API version (e.g. "authorization.k8s.io").
     */
    get apiGroup() {
        return this.apiObject.apiGroup;
    }
    /**
     * The object kind (e.g. "Deployment").
     */
    get kind() {
        return this.apiObject.kind;
    }
    get resourceName() {
        return this.name;
    }
    asApiResource() {
        return this;
    }
    asNonApiResource() {
        return undefined;
    }
}
exports.Resource = Resource;
_a = JSII_RTTI_SYMBOL_1;
Resource[_a] = { fqn: "cdk8s-plus-23.Resource", version: "2.0.0-rc.165" };
/**
 * Controls permissions for operations on resources.
 */
class ResourcePermissions {
    constructor(instance) {
        this.instance = instance;
    }
    /**
     * Grants the list of subjects permissions to read this resource.
     */
    grantRead(...subjects) {
        const subjectsAddress = utils_1.address(...subjects);
        const role = new r.Role(this.instance, `Role${subjectsAddress}`, {
            metadata: { namespace: this.instance.metadata.namespace },
        });
        role.allowRead(this.instance);
        return role.bind(...subjects);
    }
    /**
     * Grants the list of subjects permissions to read and write this resource.
     */
    grantReadWrite(...subjects) {
        const subjectsAddress = utils_1.address(...subjects);
        const role = new r.Role(this.instance, `Role${subjectsAddress}`, {
            metadata: { namespace: this.instance.metadata.namespace },
        });
        role.allowReadWrite(this.instance);
        return role.bind(...subjects);
    }
}
exports.ResourcePermissions = ResourcePermissions;
_b = JSII_RTTI_SYMBOL_1;
ResourcePermissions[_b] = { fqn: "cdk8s-plus-23.ResourcePermissions", version: "2.0.0-rc.165" };
// meh, avoiding errors due to circular imports...
const r = require("./role");
const utils_1 = require("./utils");
//# sourceMappingURL=data:application/json;base64,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