# coding: utf-8

"""
    Yagna Market API

     ## Yagna Market The Yagna Market is a core component of the Yagna Network, which enables computational Offers and Demands circulation. The Market is open for all entities willing to buy computations (Demands) or monetize computational resources (Offers). ## Yagna Market API The Yagna Market API is the entry to the Yagna Market through which Requestors and Providers can publish their Demands and Offers respectively, find matching counterparty, conduct negotiations and make an agreement.  This version of Market API conforms with capability level 1 of the <a href=\"https://docs.google.com/document/d/1Zny_vfgWV-hcsKS7P-Kdr3Fb0dwfl-6T_cYKVQ9mkNg\"> Market API specification</a>.  Market API contains two roles: Requestors and Providers which are symmetrical most of the time (excluding agreement phase).   # noqa: E501

    The version of the OpenAPI document: 1.6.1
    Generated by: https://openapi-generator.tech
"""

import re  # noqa: F401

from ya_market.api_client import ApiClient
from ya_market.exceptions import ApiTypeError, ApiValueError  # noqa: F401


class RequestorApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def cancel_agreement(self, agreement_id, **kwargs):  # noqa: E501
        """CancelAgreement - Cancels Agreement.  # noqa: E501

        It is only possible before Provider approved or rejected the Agreement, and before its Expiration.  Causes:   - the awaiting `approveAgreement` on Provider side to return with `Cancelled` response.   - the awaiting `waitForApproval` local call to return with `Cancelled` response.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cancel_agreement(agreement_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str agreement_id: (required)
        :param dict(str, object) request_body:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.cancel_agreement_with_http_info(
            agreement_id, **kwargs
        )  # noqa: E501

    def cancel_agreement_with_http_info(self, agreement_id, **kwargs):  # noqa: E501
        """CancelAgreement - Cancels Agreement.  # noqa: E501

        It is only possible before Provider approved or rejected the Agreement, and before its Expiration.  Causes:   - the awaiting `approveAgreement` on Provider side to return with `Cancelled` response.   - the awaiting `waitForApproval` local call to return with `Cancelled` response.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cancel_agreement_with_http_info(agreement_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str agreement_id: (required)
        :param dict(str, object) request_body:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'agreement_id',
            'request_body'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in local_var_params['kwargs'].items():
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cancel_agreement" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'agreement_id' is set
        if self.api_client.client_side_validation and ('agreement_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['agreement_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `agreement_id` when calling `cancel_agreement`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'agreement_id' in local_var_params:
            path_params['agreementId'] = local_var_params['agreement_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'request_body' in local_var_params:
            body_params = local_var_params['request_body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['app_key']  # noqa: E501

        return self.api_client.call_api(
            '/agreements/{agreementId}/cancel', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def collect_agreement_events(self, **kwargs):  # noqa: E501
        """CollectAgreementEvents - Collects events related to an Agreement.  # noqa: E501

        This is a blocking operation. It will not return until there is at least one new event. All events are appearing on both sides equally.  Returns Agreement related events: * `AgreementApprovedEvent` - Indicates that the Agreement has been approved   by the Provider.   - The Provider is now ready to accept a request to start an Activity     as described in the negotiated agreement.   - The Providers’s corresponding `approveAgreement` call returns `Approved`     after this event is emitted.  * `AgreementRejectedEvent` - Indicates that the Provider has called   `rejectAgreement`, which effectively stops the Agreement handshake.   The Requestor may attempt to return to the Negotiation phase by sending   a new Proposal.  * `AgreementCancelledEvent` - Indicates that the Requestor has called   `cancelAgreement`, which effectively stops the Agreement handshake.  * `AgreementTerminatedEvent` - Indicates that the Agreement has been   terminated by specified party (contains signature).   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.collect_agreement_events(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param float timeout: Timeout used in long-polling calls (in seconds). How many seconds server should wait for response containing new events (`0.0` means it should return immediately if there are no events) 
        :param datetime after_timestamp: Apply only to records created later than the specified timestamp
        :param int max_events: Maximum number of events that server should return at once. 
        :param str app_session_id: A correlation/session identifier used for querying events related to an action where this appSessionId has been specified
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[AgreementEvent]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.collect_agreement_events_with_http_info(**kwargs)  # noqa: E501

    def collect_agreement_events_with_http_info(self, **kwargs):  # noqa: E501
        """CollectAgreementEvents - Collects events related to an Agreement.  # noqa: E501

        This is a blocking operation. It will not return until there is at least one new event. All events are appearing on both sides equally.  Returns Agreement related events: * `AgreementApprovedEvent` - Indicates that the Agreement has been approved   by the Provider.   - The Provider is now ready to accept a request to start an Activity     as described in the negotiated agreement.   - The Providers’s corresponding `approveAgreement` call returns `Approved`     after this event is emitted.  * `AgreementRejectedEvent` - Indicates that the Provider has called   `rejectAgreement`, which effectively stops the Agreement handshake.   The Requestor may attempt to return to the Negotiation phase by sending   a new Proposal.  * `AgreementCancelledEvent` - Indicates that the Requestor has called   `cancelAgreement`, which effectively stops the Agreement handshake.  * `AgreementTerminatedEvent` - Indicates that the Agreement has been   terminated by specified party (contains signature).   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.collect_agreement_events_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param float timeout: Timeout used in long-polling calls (in seconds). How many seconds server should wait for response containing new events (`0.0` means it should return immediately if there are no events) 
        :param datetime after_timestamp: Apply only to records created later than the specified timestamp
        :param int max_events: Maximum number of events that server should return at once. 
        :param str app_session_id: A correlation/session identifier used for querying events related to an action where this appSessionId has been specified
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[AgreementEvent], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'timeout',
            'after_timestamp',
            'max_events',
            'app_session_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in local_var_params['kwargs'].items():
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method collect_agreement_events" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        if self.api_client.client_side_validation and 'timeout' in local_var_params and local_var_params['timeout'] < 0.0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `timeout` when calling `collect_agreement_events`, must be a value greater than or equal to `0.0`")  # noqa: E501
        if self.api_client.client_side_validation and 'max_events' in local_var_params and local_var_params['max_events'] > 100:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `max_events` when calling `collect_agreement_events`, must be a value less than or equal to `100`")  # noqa: E501
        if self.api_client.client_side_validation and 'max_events' in local_var_params and local_var_params['max_events'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `max_events` when calling `collect_agreement_events`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'timeout' in local_var_params and local_var_params['timeout'] is not None:  # noqa: E501
            query_params.append(('timeout', local_var_params['timeout']))  # noqa: E501
        if 'after_timestamp' in local_var_params and local_var_params['after_timestamp'] is not None:  # noqa: E501
            query_params.append(('afterTimestamp', local_var_params['after_timestamp']))  # noqa: E501
        if 'max_events' in local_var_params and local_var_params['max_events'] is not None:  # noqa: E501
            query_params.append(('maxEvents', local_var_params['max_events']))  # noqa: E501
        if 'app_session_id' in local_var_params and local_var_params['app_session_id'] is not None:  # noqa: E501
            query_params.append(('appSessionId', local_var_params['app_session_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['app_key']  # noqa: E501

        return self.api_client.call_api(
            '/agreementEvents', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[AgreementEvent]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def collect_offers(self, subscription_id, **kwargs):  # noqa: E501
        """CollectOffers - Reads Market responses to published Demand.  # noqa: E501

        This is a blocking operation. It will not return until there is at least one new event. Returns Proposal related events: * `ProposalEvent` - Indicates that there is new Offer Proposal for this Demand. * `ProposalRejectedEvent` - Indicates that the Provider has rejected   our previous Proposal related to this Demand. This effectively ends a   Negotiation chain - it explicitly indicates that the sender will not   create another counter-Proposal.  * `PropertyQueryEvent` - not supported yet.  **Note**: When `collectOffers` is waiting, simultaneous call to `unsubscribeDemand` on the same `subscriptionId` should result in \"Subscription does not exist\" error returned from `collectOffers`.  **Note**: Specification requires this endpoint to support list of specific Proposal Ids to listen for messages related only to specific Proposals. This is not covered yet.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.collect_offers(subscription_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str subscription_id: (required)
        :param float timeout: Timeout used in long-polling calls (in seconds). How many seconds server should wait for response containing new events (`0.0` means it should return immediately if there are no events) 
        :param int max_events: Maximum number of events that server should return at once. 
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[Event]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.collect_offers_with_http_info(
            subscription_id, **kwargs
        )  # noqa: E501

    def collect_offers_with_http_info(self, subscription_id, **kwargs):  # noqa: E501
        """CollectOffers - Reads Market responses to published Demand.  # noqa: E501

        This is a blocking operation. It will not return until there is at least one new event. Returns Proposal related events: * `ProposalEvent` - Indicates that there is new Offer Proposal for this Demand. * `ProposalRejectedEvent` - Indicates that the Provider has rejected   our previous Proposal related to this Demand. This effectively ends a   Negotiation chain - it explicitly indicates that the sender will not   create another counter-Proposal.  * `PropertyQueryEvent` - not supported yet.  **Note**: When `collectOffers` is waiting, simultaneous call to `unsubscribeDemand` on the same `subscriptionId` should result in \"Subscription does not exist\" error returned from `collectOffers`.  **Note**: Specification requires this endpoint to support list of specific Proposal Ids to listen for messages related only to specific Proposals. This is not covered yet.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.collect_offers_with_http_info(subscription_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str subscription_id: (required)
        :param float timeout: Timeout used in long-polling calls (in seconds). How many seconds server should wait for response containing new events (`0.0` means it should return immediately if there are no events) 
        :param int max_events: Maximum number of events that server should return at once. 
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[Event], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'subscription_id',
            'timeout',
            'max_events'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in local_var_params['kwargs'].items():
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method collect_offers" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'subscription_id' is set
        if self.api_client.client_side_validation and ('subscription_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['subscription_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `subscription_id` when calling `collect_offers`")  # noqa: E501

        if self.api_client.client_side_validation and 'timeout' in local_var_params and local_var_params['timeout'] < 0.0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `timeout` when calling `collect_offers`, must be a value greater than or equal to `0.0`")  # noqa: E501
        if self.api_client.client_side_validation and 'max_events' in local_var_params and local_var_params['max_events'] > 100:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `max_events` when calling `collect_offers`, must be a value less than or equal to `100`")  # noqa: E501
        if self.api_client.client_side_validation and 'max_events' in local_var_params and local_var_params['max_events'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `max_events` when calling `collect_offers`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'subscription_id' in local_var_params:
            path_params['subscriptionId'] = local_var_params['subscription_id']  # noqa: E501

        query_params = []
        if 'timeout' in local_var_params and local_var_params['timeout'] is not None:  # noqa: E501
            query_params.append(('timeout', local_var_params['timeout']))  # noqa: E501
        if 'max_events' in local_var_params and local_var_params['max_events'] is not None:  # noqa: E501
            query_params.append(('maxEvents', local_var_params['max_events']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['app_key']  # noqa: E501

        return self.api_client.call_api(
            '/demands/{subscriptionId}/events', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Event]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def confirm_agreement(self, agreement_id, **kwargs):  # noqa: E501
        """ConfirmAgreement - Sends Agreement proposal to the Provider.  # noqa: E501

        Signs self-created Agreement and sends it to the Provider.  This call should immediately follow `createAgreement`.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.confirm_agreement(agreement_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str agreement_id: (required)
        :param str app_session_id: A correlation/session identifier used for querying events related to an action where this appSessionId has been specified
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.confirm_agreement_with_http_info(
            agreement_id, **kwargs
        )  # noqa: E501

    def confirm_agreement_with_http_info(self, agreement_id, **kwargs):  # noqa: E501
        """ConfirmAgreement - Sends Agreement proposal to the Provider.  # noqa: E501

        Signs self-created Agreement and sends it to the Provider.  This call should immediately follow `createAgreement`.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.confirm_agreement_with_http_info(agreement_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str agreement_id: (required)
        :param str app_session_id: A correlation/session identifier used for querying events related to an action where this appSessionId has been specified
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'agreement_id',
            'app_session_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in local_var_params['kwargs'].items():
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method confirm_agreement" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'agreement_id' is set
        if self.api_client.client_side_validation and ('agreement_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['agreement_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `agreement_id` when calling `confirm_agreement`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'agreement_id' in local_var_params:
            path_params['agreementId'] = local_var_params['agreement_id']  # noqa: E501

        query_params = []
        if 'app_session_id' in local_var_params and local_var_params['app_session_id'] is not None:  # noqa: E501
            query_params.append(('appSessionId', local_var_params['app_session_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["app_key"]  # noqa: E501

        return self.api_client.call_api(
            "/agreements/{agreementId}/confirm",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def counter_proposal_demand(self, subscription_id, proposal_id, demand_offer_base, **kwargs):  # noqa: E501
        """CounterProposalDemand - Responds with a bespoke Demand to received Offer.  # noqa: E501

        Creates and sends a modified version of original Demand (a counter-proposal) adjusted to previously received Proposal (ie. Offer). Changes Proposal state to `Draft`. Returns created Proposal id.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.counter_proposal_demand(subscription_id, proposal_id, demand_offer_base, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str subscription_id: (required)
        :param str proposal_id: (required)
        :param DemandOfferBase demand_offer_base: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.counter_proposal_demand_with_http_info(subscription_id, proposal_id, demand_offer_base, **kwargs)  # noqa: E501

    def counter_proposal_demand_with_http_info(self, subscription_id, proposal_id, demand_offer_base, **kwargs):  # noqa: E501
        """CounterProposalDemand - Responds with a bespoke Demand to received Offer.  # noqa: E501

        Creates and sends a modified version of original Demand (a counter-proposal) adjusted to previously received Proposal (ie. Offer). Changes Proposal state to `Draft`. Returns created Proposal id.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.counter_proposal_demand_with_http_info(subscription_id, proposal_id, demand_offer_base, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str subscription_id: (required)
        :param str proposal_id: (required)
        :param DemandOfferBase demand_offer_base: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(str, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'subscription_id',
            'proposal_id',
            'demand_offer_base'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in local_var_params['kwargs'].items():
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method counter_proposal_demand" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'subscription_id' is set
        if self.api_client.client_side_validation and ('subscription_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['subscription_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `subscription_id` when calling `counter_proposal_demand`")  # noqa: E501
        # verify the required parameter 'proposal_id' is set
        if self.api_client.client_side_validation and ('proposal_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['proposal_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `proposal_id` when calling `counter_proposal_demand`")  # noqa: E501
        # verify the required parameter 'demand_offer_base' is set
        if self.api_client.client_side_validation and ('demand_offer_base' not in local_var_params or  # noqa: E501
                                                        local_var_params['demand_offer_base'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `demand_offer_base` when calling `counter_proposal_demand`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'subscription_id' in local_var_params:
            path_params['subscriptionId'] = local_var_params['subscription_id']  # noqa: E501
        if 'proposal_id' in local_var_params:
            path_params['proposalId'] = local_var_params['proposal_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'demand_offer_base' in local_var_params:
            body_params = local_var_params['demand_offer_base']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['app_key']  # noqa: E501

        return self.api_client.call_api(
            '/demands/{subscriptionId}/proposals/{proposalId}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_agreement(self, agreement_proposal, **kwargs):  # noqa: E501
        """CreateAgreement - Creates Agreement from selected Proposal.  # noqa: E501

        Initiates the Agreement handshake phase.  Formulates an Agreement artifact from the Proposal indicated by the received Proposal Id. Created Agreement is in `Proposal` state.  The Approval Expiry Date is added to Agreement artifact and implies the effective timeout on the whole Agreement Confirmation sequence.  A successful call to `createAgreement` shall immediately be followed by a `confirmAgreement` and `waitForApproval` call in order to listen for responses from the Provider.  **Note**: Moves given Proposal to `Approved` state.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_agreement(agreement_proposal, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param AgreementProposal agreement_proposal: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_agreement_with_http_info(agreement_proposal, **kwargs)  # noqa: E501

    def create_agreement_with_http_info(self, agreement_proposal, **kwargs):  # noqa: E501
        """CreateAgreement - Creates Agreement from selected Proposal.  # noqa: E501

        Initiates the Agreement handshake phase.  Formulates an Agreement artifact from the Proposal indicated by the received Proposal Id. Created Agreement is in `Proposal` state.  The Approval Expiry Date is added to Agreement artifact and implies the effective timeout on the whole Agreement Confirmation sequence.  A successful call to `createAgreement` shall immediately be followed by a `confirmAgreement` and `waitForApproval` call in order to listen for responses from the Provider.  **Note**: Moves given Proposal to `Approved` state.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_agreement_with_http_info(agreement_proposal, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param AgreementProposal agreement_proposal: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(str, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["agreement_proposal"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in local_var_params["kwargs"].items():
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_agreement" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'agreement_proposal' is set
        if self.api_client.client_side_validation and (
            "agreement_proposal" not in local_var_params
            or local_var_params["agreement_proposal"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `agreement_proposal` when calling `create_agreement`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "agreement_proposal" in local_var_params:
            body_params = local_var_params["agreement_proposal"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["app_key"]  # noqa: E501

        return self.api_client.call_api(
            "/agreements",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="str",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_agreement(self, agreement_id, **kwargs):  # noqa: E501
        """GetAgreement - Fetches agreement with given agreement id.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_agreement(agreement_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str agreement_id: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Agreement
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.get_agreement_with_http_info(agreement_id, **kwargs)  # noqa: E501

    def get_agreement_with_http_info(self, agreement_id, **kwargs):  # noqa: E501
        """GetAgreement - Fetches agreement with given agreement id.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_agreement_with_http_info(agreement_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str agreement_id: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Agreement, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["agreement_id"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in local_var_params["kwargs"].items():
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_agreement" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'agreement_id' is set
        if self.api_client.client_side_validation and (
            "agreement_id" not in local_var_params
            or local_var_params["agreement_id"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `agreement_id` when calling `get_agreement`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "agreement_id" in local_var_params:
            path_params["agreementId"] = local_var_params["agreement_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["app_key"]  # noqa: E501

        return self.api_client.call_api(
            "/agreements/{agreementId}",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="Agreement",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_demands(self, **kwargs):  # noqa: E501
        """GetDemands - Fetches all active Demands which have been published by the Requestor.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_demands(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[Demand]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.get_demands_with_http_info(**kwargs)  # noqa: E501

    def get_demands_with_http_info(self, **kwargs):  # noqa: E501
        """GetDemands - Fetches all active Demands which have been published by the Requestor.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_demands_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[Demand], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = []
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in local_var_params["kwargs"].items():
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_demands" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["app_key"]  # noqa: E501

        return self.api_client.call_api(
            "/demands",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="list[Demand]",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_proposal_offer(self, subscription_id, proposal_id, **kwargs):  # noqa: E501
        """GetProposalOffer - Fetches Proposal (Offer) with given id.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_proposal_offer(subscription_id, proposal_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str subscription_id: (required)
        :param str proposal_id: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Proposal
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_proposal_offer_with_http_info(subscription_id, proposal_id, **kwargs)  # noqa: E501

    def get_proposal_offer_with_http_info(self, subscription_id, proposal_id, **kwargs):  # noqa: E501
        """GetProposalOffer - Fetches Proposal (Offer) with given id.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_proposal_offer_with_http_info(subscription_id, proposal_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str subscription_id: (required)
        :param str proposal_id: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Proposal, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["subscription_id", "proposal_id"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in local_var_params["kwargs"].items():
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_proposal_offer" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'subscription_id' is set
        if self.api_client.client_side_validation and (
            "subscription_id" not in local_var_params
            or local_var_params["subscription_id"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `subscription_id` when calling `get_proposal_offer`"
            )  # noqa: E501
        # verify the required parameter 'proposal_id' is set
        if self.api_client.client_side_validation and (
            "proposal_id" not in local_var_params
            or local_var_params["proposal_id"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `proposal_id` when calling `get_proposal_offer`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "subscription_id" in local_var_params:
            path_params["subscriptionId"] = local_var_params[
                "subscription_id"
            ]  # noqa: E501
        if "proposal_id" in local_var_params:
            path_params["proposalId"] = local_var_params["proposal_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['app_key']  # noqa: E501

        return self.api_client.call_api(
            '/demands/{subscriptionId}/proposals/{proposalId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Proposal',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def query_reply_demands(self, subscription_id, query_id, body, **kwargs):  # noqa: E501
        """QueryReplyDemands - Handles dynamic property query.  # noqa: E501

        Sends a response to a received property value query.  The Market Matching Mechanism, when resolving the match relation for the specific Demand-Offer pair, is to detect the “dynamic” properties required (via constraints) by the other side. At this point, it is able to query the issuing node for those properties and submit the other side’s requested properties as the context of the query.  **Note**: The property query responses may be submitted in “chunks”, ie. the responder may choose to resolve ‘quick’/lightweight’ properties faster and provide response sooner, while still working on more time-consuming properties in the background. Therefore the response contains both the resolved properties, as well as list of properties which responder knows still require resolution.  **Note**: This method must be implemented for Market API Capability Level 2.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.query_reply_demands(subscription_id, query_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str subscription_id: (required)
        :param str query_id: (required)
        :param object body: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.query_reply_demands_with_http_info(subscription_id, query_id, body, **kwargs)  # noqa: E501

    def query_reply_demands_with_http_info(self, subscription_id, query_id, body, **kwargs):  # noqa: E501
        """QueryReplyDemands - Handles dynamic property query.  # noqa: E501

        Sends a response to a received property value query.  The Market Matching Mechanism, when resolving the match relation for the specific Demand-Offer pair, is to detect the “dynamic” properties required (via constraints) by the other side. At this point, it is able to query the issuing node for those properties and submit the other side’s requested properties as the context of the query.  **Note**: The property query responses may be submitted in “chunks”, ie. the responder may choose to resolve ‘quick’/lightweight’ properties faster and provide response sooner, while still working on more time-consuming properties in the background. Therefore the response contains both the resolved properties, as well as list of properties which responder knows still require resolution.  **Note**: This method must be implemented for Market API Capability Level 2.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.query_reply_demands_with_http_info(subscription_id, query_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str subscription_id: (required)
        :param str query_id: (required)
        :param object body: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'subscription_id',
            'query_id',
            'body'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in local_var_params['kwargs'].items():
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method query_reply_demands" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'subscription_id' is set
        if self.api_client.client_side_validation and ('subscription_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['subscription_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `subscription_id` when calling `query_reply_demands`")  # noqa: E501
        # verify the required parameter 'query_id' is set
        if self.api_client.client_side_validation and ('query_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['query_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `query_id` when calling `query_reply_demands`")  # noqa: E501
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in local_var_params or  # noqa: E501
                                                        local_var_params['body'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `body` when calling `query_reply_demands`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'subscription_id' in local_var_params:
            path_params['subscriptionId'] = local_var_params['subscription_id']  # noqa: E501
        if 'query_id' in local_var_params:
            path_params['queryId'] = local_var_params['query_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "body" in local_var_params:
            body_params = local_var_params["body"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["app_key"]  # noqa: E501

        return self.api_client.call_api(
            "/demands/{subscriptionId}/propertyQuery/{queryId}",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def reject_proposal_offer(self, subscription_id, proposal_id, **kwargs):  # noqa: E501
        """RejectProposalOffer - Rejects Proposal (Offer).  # noqa: E501

        Effectively ends a Negotiation chain - it explicitly indicates that the sender will not create another counter-Proposal.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.reject_proposal_offer(subscription_id, proposal_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str subscription_id: (required)
        :param str proposal_id: (required)
        :param dict(str, object) request_body:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.reject_proposal_offer_with_http_info(subscription_id, proposal_id, **kwargs)  # noqa: E501

    def reject_proposal_offer_with_http_info(self, subscription_id, proposal_id, **kwargs):  # noqa: E501
        """RejectProposalOffer - Rejects Proposal (Offer).  # noqa: E501

        Effectively ends a Negotiation chain - it explicitly indicates that the sender will not create another counter-Proposal.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.reject_proposal_offer_with_http_info(subscription_id, proposal_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str subscription_id: (required)
        :param str proposal_id: (required)
        :param dict(str, object) request_body:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'subscription_id',
            'proposal_id',
            'request_body'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in local_var_params['kwargs'].items():
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method reject_proposal_offer" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'subscription_id' is set
        if self.api_client.client_side_validation and ('subscription_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['subscription_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `subscription_id` when calling `reject_proposal_offer`")  # noqa: E501
        # verify the required parameter 'proposal_id' is set
        if self.api_client.client_side_validation and ('proposal_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['proposal_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `proposal_id` when calling `reject_proposal_offer`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'subscription_id' in local_var_params:
            path_params['subscriptionId'] = local_var_params['subscription_id']  # noqa: E501
        if 'proposal_id' in local_var_params:
            path_params['proposalId'] = local_var_params['proposal_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'request_body' in local_var_params:
            body_params = local_var_params['request_body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['app_key']  # noqa: E501

        return self.api_client.call_api(
            '/demands/{subscriptionId}/proposals/{proposalId}/reject', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def subscribe_demand(self, demand_offer_base, **kwargs):  # noqa: E501
        """SubscribeDemand - Publishes Requestor capabilities via Demand.  # noqa: E501

        Demand object can be considered an \"open\" or public Demand, as it is not directed at a specific Provider, but rather is sent to the market so that the matching mechanism implementation can associate relevant Offers.  **Note**: it is an \"atomic\" operation, ie. as soon as Subscription is placed, the Demand is published on the market.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.subscribe_demand(demand_offer_base, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param DemandOfferBase demand_offer_base: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.subscribe_demand_with_http_info(demand_offer_base, **kwargs)  # noqa: E501

    def subscribe_demand_with_http_info(self, demand_offer_base, **kwargs):  # noqa: E501
        """SubscribeDemand - Publishes Requestor capabilities via Demand.  # noqa: E501

        Demand object can be considered an \"open\" or public Demand, as it is not directed at a specific Provider, but rather is sent to the market so that the matching mechanism implementation can associate relevant Offers.  **Note**: it is an \"atomic\" operation, ie. as soon as Subscription is placed, the Demand is published on the market.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.subscribe_demand_with_http_info(demand_offer_base, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param DemandOfferBase demand_offer_base: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(str, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'demand_offer_base'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in local_var_params['kwargs'].items():
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method subscribe_demand" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'demand_offer_base' is set
        if self.api_client.client_side_validation and ('demand_offer_base' not in local_var_params or  # noqa: E501
                                                        local_var_params['demand_offer_base'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `demand_offer_base` when calling `subscribe_demand`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'demand_offer_base' in local_var_params:
            body_params = local_var_params['demand_offer_base']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['app_key']  # noqa: E501

        return self.api_client.call_api(
            '/demands', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def terminate_agreement(self, agreement_id, **kwargs):  # noqa: E501
        """TerminateAgreement - Terminates approved Agreement.  # noqa: E501

        Method to finish/close the Agreement while in `Approved` state.  The other party gets notified about calling party decision to terminate a \"running\" agreement.  **Note**: Can be invoked at any time after Agreement was approved by both sides.  **Note**: Financial and reputational consequences are not defined by this specification.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.terminate_agreement(agreement_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str agreement_id: (required)
        :param dict(str, object) request_body:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.terminate_agreement_with_http_info(
            agreement_id, **kwargs
        )  # noqa: E501

    def terminate_agreement_with_http_info(self, agreement_id, **kwargs):  # noqa: E501
        """TerminateAgreement - Terminates approved Agreement.  # noqa: E501

        Method to finish/close the Agreement while in `Approved` state.  The other party gets notified about calling party decision to terminate a \"running\" agreement.  **Note**: Can be invoked at any time after Agreement was approved by both sides.  **Note**: Financial and reputational consequences are not defined by this specification.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.terminate_agreement_with_http_info(agreement_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str agreement_id: (required)
        :param dict(str, object) request_body:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'agreement_id',
            'request_body'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in local_var_params['kwargs'].items():
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method terminate_agreement" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'agreement_id' is set
        if self.api_client.client_side_validation and ('agreement_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['agreement_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `agreement_id` when calling `terminate_agreement`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'agreement_id' in local_var_params:
            path_params['agreementId'] = local_var_params['agreement_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'request_body' in local_var_params:
            body_params = local_var_params['request_body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['app_key']  # noqa: E501

        return self.api_client.call_api(
            '/agreements/{agreementId}/terminate', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def unsubscribe_demand(self, subscription_id, **kwargs):  # noqa: E501
        """UnsubscribeDemand - Stop subscription for previously published Demand.  # noqa: E501

        Stop receiving Proposals.  **Note**: this will terminate all pending `collectOffers` calls on this subscription. This implies, that client code should not `unsubscribeDemand` before it has received all expected/useful inputs from `collectOffers`.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.unsubscribe_demand(subscription_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str subscription_id: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.unsubscribe_demand_with_http_info(subscription_id, **kwargs)  # noqa: E501

    def unsubscribe_demand_with_http_info(self, subscription_id, **kwargs):  # noqa: E501
        """UnsubscribeDemand - Stop subscription for previously published Demand.  # noqa: E501

        Stop receiving Proposals.  **Note**: this will terminate all pending `collectOffers` calls on this subscription. This implies, that client code should not `unsubscribeDemand` before it has received all expected/useful inputs from `collectOffers`.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.unsubscribe_demand_with_http_info(subscription_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str subscription_id: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["subscription_id"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in local_var_params["kwargs"].items():
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method unsubscribe_demand" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'subscription_id' is set
        if self.api_client.client_side_validation and (
            "subscription_id" not in local_var_params
            or local_var_params["subscription_id"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `subscription_id` when calling `unsubscribe_demand`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "subscription_id" in local_var_params:
            path_params["subscriptionId"] = local_var_params[
                "subscription_id"
            ]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["app_key"]  # noqa: E501

        return self.api_client.call_api(
            "/demands/{subscriptionId}",
            "DELETE",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def wait_for_approval(self, agreement_id, **kwargs):  # noqa: E501
        """WaitForApproval - Waits for Agreement approval by the Provider.  # noqa: E501

        This is a blocking operation. The call may be aborted by Requestor caller code. After the call is aborted or timed out, another `waitForApproval` call can be raised on the same Agreement Id.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.wait_for_approval(agreement_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str agreement_id: (required)
        :param float timeout: Timeout used in blocking calls waiting for eg. acknowledgement. How many seconds server should wait for response/acknowledgement of an action (0.0 means it should wait for other party's response indefinitely) 
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.wait_for_approval_with_http_info(
            agreement_id, **kwargs
        )  # noqa: E501

    def wait_for_approval_with_http_info(self, agreement_id, **kwargs):  # noqa: E501
        """WaitForApproval - Waits for Agreement approval by the Provider.  # noqa: E501

        This is a blocking operation. The call may be aborted by Requestor caller code. After the call is aborted or timed out, another `waitForApproval` call can be raised on the same Agreement Id.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.wait_for_approval_with_http_info(agreement_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str agreement_id: (required)
        :param float timeout: Timeout used in blocking calls waiting for eg. acknowledgement. How many seconds server should wait for response/acknowledgement of an action (0.0 means it should wait for other party's response indefinitely) 
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["agreement_id", "timeout"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in local_var_params["kwargs"].items():
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method wait_for_approval" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'agreement_id' is set
        if self.api_client.client_side_validation and (
            "agreement_id" not in local_var_params
            or local_var_params["agreement_id"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `agreement_id` when calling `wait_for_approval`"
            )  # noqa: E501

        if (
            self.api_client.client_side_validation
            and "timeout" in local_var_params
            and local_var_params["timeout"] < 0.0
        ):  # noqa: E501
            raise ApiValueError(
                "Invalid value for parameter `timeout` when calling `wait_for_approval`, must be a value greater than or equal to `0.0`"
            )  # noqa: E501
        collection_formats = {}

        path_params = {}
        if "agreement_id" in local_var_params:
            path_params["agreementId"] = local_var_params["agreement_id"]  # noqa: E501

        query_params = []
        if (
            "timeout" in local_var_params and local_var_params["timeout"] is not None
        ):  # noqa: E501
            query_params.append(("timeout", local_var_params["timeout"]))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['app_key']  # noqa: E501

        return self.api_client.call_api(
            '/agreements/{agreementId}/wait', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
