# coding: utf-8

"""
    Yagna Market API

     ## Yagna Market The Yagna Market is a core component of the Yagna Network, which enables computational Offers and Demands circulation. The Market is open for all entities willing to buy computations (Demands) or monetize computational resources (Offers). ## Yagna Market API The Yagna Market API is the entry to the Yagna Market through which Requestors and Providers can publish their Demands and Offers respectively, find matching counterparty, conduct negotiations and make an agreement.  This version of Market API conforms with capability level 1 of the <a href=\"https://docs.google.com/document/d/1Zny_vfgWV-hcsKS7P-Kdr3Fb0dwfl-6T_cYKVQ9mkNg\"> Market API specification</a>.  Market API contains two roles: Requestors and Providers which are symmetrical most of the time (excluding agreement phase).   # noqa: E501

    The version of the OpenAPI document: 1.6.1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401


from ya_market.configuration import Configuration


class Offer(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'properties': 'object',
        'constraints': 'str',
        'offer_id': 'str',
        'provider_id': 'str',
        'timestamp': 'datetime'
    }

    attribute_map = {
        'properties': 'properties',
        'constraints': 'constraints',
        'offer_id': 'offerId',
        'provider_id': 'providerId',
        'timestamp': 'timestamp'
    }

    def __init__(self, properties=None, constraints=None, offer_id=None, provider_id=None, timestamp=None, local_vars_configuration=None):  # noqa: E501
        """Offer - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._properties = None
        self._constraints = None
        self._offer_id = None
        self._provider_id = None
        self._timestamp = None
        self.discriminator = None

        self.properties = properties
        self.constraints = constraints
        self.offer_id = offer_id
        self.provider_id = provider_id
        self.timestamp = timestamp

    @property
    def properties(self):
        """Gets the properties of this Offer.  # noqa: E501

        The object which includes all the Demand/Offer/Proposal properties. This is a JSON object in \"flat convention\" - where keys are full property names and their values indicate properties.  The value's Javascript type shall conform with the type of the property (as indicated in Golem Standards). ### Example property object: ``` {   \"golem.com.pricing.model\":\"linear\",   \"golem.com.pricing.model.linear.coeffs\":[0.001, 0.002, 0.0],   \"golem.com.scheme\":\"payu\",   \"golem.com.scheme.payu.interval_sec\":6.0,   \"golem.com.usage.vector\":[\"golem.usage.duration_sec\",\"golem.usage.cpu_sec\"],   \"golem.inf.cpu.architecture\":\"x86_64\",   \"golem.inf.cpu.cores\":4,   \"golem.inf.cpu.threads\":7,   \"golem.inf.mem.gib\":10.612468048930168,   \"golem.inf.storage.gib\":81.7227783203125,   \"golem.node.debug.subnet\":\"market-devnet\",   \"golem.node.id.name\":\"tworec@mf-market-devnet\",   \"golem.runtime.name\":\"vm\",   \"golem.runtime.version@v\":\"0.1.0\" } ```   # noqa: E501

        :return: The properties of this Offer.  # noqa: E501
        :rtype: object
        """
        return self._properties

    @properties.setter
    def properties(self, properties):
        """Sets the properties of this Offer.

        The object which includes all the Demand/Offer/Proposal properties. This is a JSON object in \"flat convention\" - where keys are full property names and their values indicate properties.  The value's Javascript type shall conform with the type of the property (as indicated in Golem Standards). ### Example property object: ``` {   \"golem.com.pricing.model\":\"linear\",   \"golem.com.pricing.model.linear.coeffs\":[0.001, 0.002, 0.0],   \"golem.com.scheme\":\"payu\",   \"golem.com.scheme.payu.interval_sec\":6.0,   \"golem.com.usage.vector\":[\"golem.usage.duration_sec\",\"golem.usage.cpu_sec\"],   \"golem.inf.cpu.architecture\":\"x86_64\",   \"golem.inf.cpu.cores\":4,   \"golem.inf.cpu.threads\":7,   \"golem.inf.mem.gib\":10.612468048930168,   \"golem.inf.storage.gib\":81.7227783203125,   \"golem.node.debug.subnet\":\"market-devnet\",   \"golem.node.id.name\":\"tworec@mf-market-devnet\",   \"golem.runtime.name\":\"vm\",   \"golem.runtime.version@v\":\"0.1.0\" } ```   # noqa: E501

        :param properties: The properties of this Offer.  # noqa: E501
        :type: object
        """
        if (
            self.local_vars_configuration.client_side_validation and properties is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `properties`, must not be `None`"
            )  # noqa: E501

        self._properties = properties

    @property
    def constraints(self):
        """Gets the constraints of this Offer.  # noqa: E501


        :return: The constraints of this Offer.  # noqa: E501
        :rtype: str
        """
        return self._constraints

    @constraints.setter
    def constraints(self, constraints):
        """Sets the constraints of this Offer.


        :param constraints: The constraints of this Offer.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation and constraints is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `constraints`, must not be `None`"
            )  # noqa: E501

        self._constraints = constraints

    @property
    def offer_id(self):
        """Gets the offer_id of this Offer.  # noqa: E501


        :return: The offer_id of this Offer.  # noqa: E501
        :rtype: str
        """
        return self._offer_id

    @offer_id.setter
    def offer_id(self, offer_id):
        """Sets the offer_id of this Offer.


        :param offer_id: The offer_id of this Offer.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and offer_id is None:  # noqa: E501
            raise ValueError("Invalid value for `offer_id`, must not be `None`")  # noqa: E501

        self._offer_id = offer_id

    @property
    def provider_id(self):
        """Gets the provider_id of this Offer.  # noqa: E501


        :return: The provider_id of this Offer.  # noqa: E501
        :rtype: str
        """
        return self._provider_id

    @provider_id.setter
    def provider_id(self, provider_id):
        """Sets the provider_id of this Offer.


        :param provider_id: The provider_id of this Offer.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and provider_id is None:  # noqa: E501
            raise ValueError("Invalid value for `provider_id`, must not be `None`")  # noqa: E501

        self._provider_id = provider_id

    @property
    def timestamp(self):
        """Gets the timestamp of this Offer.  # noqa: E501


        :return: The timestamp of this Offer.  # noqa: E501
        :rtype: datetime
        """
        return self._timestamp

    @timestamp.setter
    def timestamp(self, timestamp):
        """Sets the timestamp of this Offer.


        :param timestamp: The timestamp of this Offer.  # noqa: E501
        :type: datetime
        """
        if self.local_vars_configuration.client_side_validation and timestamp is None:  # noqa: E501
            raise ValueError("Invalid value for `timestamp`, must not be `None`")  # noqa: E501

        self._timestamp = timestamp

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in self.openapi_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(
                    map(lambda x: x.to_dict() if hasattr(x, "to_dict") else x, value)
                )
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(
                    map(
                        lambda item: (item[0], item[1].to_dict())
                        if hasattr(item[1], "to_dict")
                        else item,
                        value.items(),
                    )
                )
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Offer):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Offer):
            return True

        return self.to_dict() != other.to_dict()
