// node_modules/vexflow/build/esm/src/util.js
var RuntimeError = class extends Error {
  constructor(code, message = "") {
    super("[RuntimeError] " + code + ": " + message);
    this.code = code;
  }
};
function globalObject() {
  if (typeof globalThis !== "undefined") {
    return globalThis;
  }
  if (typeof self !== "undefined") {
    return self;
  }
  if (typeof window !== "undefined") {
    return window;
  }
  if (typeof global !== "undefined") {
    return global;
  }
  return Function("return this")();
}
function defined(x, code = "undefined", message = "") {
  if (x === void 0) {
    throw new RuntimeError(code, message);
  }
  return x;
}
function log(block, ...args) {
  if (!args)
    return;
  const line = Array.prototype.slice.call(args).join(" ");
  globalObject().console.log(block + ": " + line);
}
function warn(...args) {
  const line = args.join(" ");
  const err = new Error();
  globalObject().console.log("Warning: ", line, err.stack);
}
function roundN(x, n) {
  return x % n >= n / 2 ? parseInt(`${x / n}`, 10) * n + n : parseInt(`${x / n}`, 10) * n;
}
function midLine(a, b) {
  let mid_line = b + (a - b) / 2;
  if (mid_line % 2 > 0) {
    mid_line = roundN(mid_line * 10, 5) / 10;
  }
  return mid_line;
}
function prefix(text) {
  return `vf-${text}`;
}
function normalizeAngle(a) {
  a = a % (2 * Math.PI);
  if (a < 0) {
    a += 2 * Math.PI;
  }
  return a;
}
function sumArray(arr) {
  return arr.reduce((a, b) => a + b, 0);
}

// node_modules/vexflow/build/esm/src/fraction.js
var Fraction = class _Fraction {
  static get CATEGORY() {
    return "Fraction";
  }
  static GCD(a, b) {
    if (typeof a !== "number" || Number.isNaN(a) || typeof b !== "number" || Number.isNaN(b)) {
      throw new RuntimeError("BadArgument", `Invalid numbers: ${a}, ${b}`);
    }
    let t;
    while (b !== 0) {
      t = b;
      b = a % b;
      a = t;
    }
    return a;
  }
  static LCM(a, b) {
    return a * b / _Fraction.GCD(a, b);
  }
  static LCMM(args) {
    if (args.length === 0) {
      return 0;
    } else if (args.length === 1) {
      return args[0];
    } else if (args.length === 2) {
      return _Fraction.LCM(args[0], args[1]);
    } else {
      return _Fraction.LCM(args.shift(), _Fraction.LCMM(args));
    }
  }
  constructor(numerator, denominator) {
    this.numerator = 1;
    this.denominator = 1;
    this.set(numerator, denominator);
  }
  set(numerator = 1, denominator = 1) {
    this.numerator = numerator;
    this.denominator = denominator;
    return this;
  }
  value() {
    return this.numerator / this.denominator;
  }
  simplify() {
    let u = this.numerator;
    let d = this.denominator;
    const gcd = _Fraction.GCD(u, d);
    u /= gcd;
    d /= gcd;
    if (d < 0) {
      d = -d;
      u = -u;
    }
    return this.set(u, d);
  }
  add(param1 = 0, param2 = 1) {
    const [otherNumerator, otherDenominator] = getNumeratorAndDenominator(param1, param2);
    const lcm = _Fraction.LCM(this.denominator, otherDenominator);
    const a = lcm / this.denominator;
    const b = lcm / otherDenominator;
    const u = this.numerator * a + otherNumerator * b;
    return this.set(u, lcm);
  }
  subtract(param1 = 0, param2 = 1) {
    const [otherNumerator, otherDenominator] = getNumeratorAndDenominator(param1, param2);
    const lcm = _Fraction.LCM(this.denominator, otherDenominator);
    const a = lcm / this.denominator;
    const b = lcm / otherDenominator;
    const u = this.numerator * a - otherNumerator * b;
    return this.set(u, lcm);
  }
  multiply(param1 = 1, param2 = 1) {
    const [otherNumerator, otherDenominator] = getNumeratorAndDenominator(param1, param2);
    return this.set(this.numerator * otherNumerator, this.denominator * otherDenominator);
  }
  divide(param1 = 1, param2 = 1) {
    const [otherNumerator, otherDenominator] = getNumeratorAndDenominator(param1, param2);
    return this.set(this.numerator * otherDenominator, this.denominator * otherNumerator);
  }
  equals(compare) {
    const a = _Fraction.__staticFractionA.copy(compare).simplify();
    const b = _Fraction.__staticFractionB.copy(this).simplify();
    return a.numerator === b.numerator && a.denominator === b.denominator;
  }
  greaterThan(compare) {
    const a = _Fraction.__staticFractionB.copy(this);
    a.subtract(compare);
    return a.numerator > 0;
  }
  greaterThanEquals(compare) {
    const a = _Fraction.__staticFractionB.copy(this);
    a.subtract(compare);
    return a.numerator >= 0;
  }
  lessThan(compare) {
    return !this.greaterThanEquals(compare);
  }
  lessThanEquals(compare) {
    return !this.greaterThan(compare);
  }
  clone() {
    return new _Fraction(this.numerator, this.denominator);
  }
  copy(other) {
    if (typeof other === "number") {
      return this.set(other, 1);
    } else {
      return this.set(other.numerator, other.denominator);
    }
  }
  quotient() {
    return Math.floor(this.numerator / this.denominator);
  }
  remainder() {
    return this.numerator % this.denominator;
  }
  makeAbs() {
    this.denominator = Math.abs(this.denominator);
    this.numerator = Math.abs(this.numerator);
    return this;
  }
  toString() {
    return `${this.numerator}/${this.denominator}`;
  }
  toSimplifiedString() {
    return _Fraction.__staticFractionTmp.copy(this).simplify().toString();
  }
  toMixedString() {
    let s = "";
    const q = this.quotient();
    const f = _Fraction.__staticFractionTmp.copy(this);
    if (q < 0) {
      f.makeAbs();
    }
    if (q !== 0) {
      s += q;
      if (f.numerator !== 0) {
        s += ` ${f.toSimplifiedString()}`;
      }
    } else if (f.numerator === 0) {
      s = "0";
    } else {
      s = f.toSimplifiedString();
    }
    return s;
  }
  parse(str) {
    const i = str.split("/");
    const n = parseInt(i[0], 10);
    const d = i[1] ? parseInt(i[1], 10) : 1;
    return this.set(n, d);
  }
};
Fraction.__staticFractionA = new Fraction();
Fraction.__staticFractionB = new Fraction();
Fraction.__staticFractionTmp = new Fraction();
function getNumeratorAndDenominator(n, d = 1) {
  if (typeof n === "number") {
    return [n, d];
  } else {
    return [n.numerator, n.denominator];
  }
}

// node_modules/vexflow/build/esm/src/boundingbox.js
var BoundingBox = class _BoundingBox {
  static copy(that) {
    return new _BoundingBox(that.x, that.y, that.w, that.h);
  }
  constructor(x, y, w, h) {
    this.x = x;
    this.y = y;
    this.w = w;
    this.h = h;
  }
  getX() {
    return this.x;
  }
  getY() {
    return this.y;
  }
  getW() {
    return this.w;
  }
  getH() {
    return this.h;
  }
  setX(x) {
    this.x = x;
    return this;
  }
  setY(y) {
    this.y = y;
    return this;
  }
  setW(w) {
    this.w = w;
    return this;
  }
  setH(h) {
    this.h = h;
    return this;
  }
  move(x, y) {
    this.x += x;
    this.y += y;
    return this;
  }
  clone() {
    return _BoundingBox.copy(this);
  }
  mergeWith(boundingBox) {
    const that = boundingBox;
    const new_x = this.x < that.x ? this.x : that.x;
    const new_y = this.y < that.y ? this.y : that.y;
    const new_w = Math.max(this.x + this.w, that.x + that.w) - new_x;
    const new_h = Math.max(this.y + this.h, that.y + that.h) - new_y;
    this.x = new_x;
    this.y = new_y;
    this.w = new_w;
    this.h = new_h;
    return this;
  }
};

// node_modules/vexflow/build/esm/src/boundingboxcomputation.js
var BoundingBoxComputation = class {
  constructor() {
    this.x1 = Number.NaN;
    this.y1 = Number.NaN;
    this.x2 = Number.NaN;
    this.y2 = Number.NaN;
  }
  getX1() {
    return this.x1;
  }
  getY1() {
    return this.y1;
  }
  width() {
    return this.x2 - this.x1;
  }
  height() {
    return this.y2 - this.y1;
  }
  addPoint(x, y) {
    if (isNaN(this.x1) || x < this.x1)
      this.x1 = x;
    if (isNaN(this.x2) || x > this.x2)
      this.x2 = x;
    if (isNaN(this.y1) || y < this.y1)
      this.y1 = y;
    if (isNaN(this.y2) || y > this.y2)
      this.y2 = y;
  }
  addX(x) {
    this.addPoint(x, this.y1);
  }
  addY(y) {
    this.addPoint(this.x1, y);
  }
  addQuadraticCurve(p0x, p0y, p1x, p1y, p2x, p2y) {
    this.addPoint(p0x, p0y);
    this.addPoint(p2x, p2y);
    const p01x = p1x - p0x;
    const p12x = p2x - p1x;
    let denom = p01x - p12x;
    if (denom != 0) {
      const t = p01x / denom;
      if (t > 0 && t < 1) {
        const it = 1 - t;
        this.addX(it * it * p0x + 2 * it * t * p1x + t * t * p2x);
      }
    }
    const p01y = p1y - p0y;
    const p12y = p2y - p1y;
    denom = p01y - p12y;
    if (denom != 0) {
      const t = p01y / denom;
      if (t > 0 && t < 1) {
        const it = 1 - t;
        this.addY(it * it * p0y + 2 * it * t * p1y + t * t * p2y);
      }
    }
  }
  addBezierCurve(p0x, p0y, p1x, p1y, p2x, p2y, p3x, p3y) {
    const p0 = [p0x, p0y];
    const p1 = [p1x, p1y];
    const p2 = [p2x, p2y];
    const p3 = [p3x, p3y];
    let i;
    this.addPoint(p0[0], p0[1]);
    this.addPoint(p3[0], p3[1]);
    const f = (t, i2) => Math.pow(1 - t, 3) * p0[i2] + 3 * Math.pow(1 - t, 2) * t * p1[i2] + 3 * (1 - t) * Math.pow(t, 2) * p2[i2] + Math.pow(t, 3) * p3[i2];
    for (i = 0; i <= 1; i++) {
      const b = 6 * p0[i] - 12 * p1[i] + 6 * p2[i];
      const a = -3 * p0[i] + 9 * p1[i] - 9 * p2[i] + 3 * p3[i];
      const c = 3 * p1[i] - 3 * p0[i];
      if (a === 0) {
        if (b === 0)
          continue;
        const t = -c / b;
        if (0 < t && t < 1) {
          if (i === 0)
            this.addX(f(t, i));
          if (i === 1)
            this.addY(f(t, i));
        }
        continue;
      }
      const b2ac = Math.pow(b, 2) - 4 * c * a;
      if (b2ac < 0)
        continue;
      const t1 = (-b + Math.sqrt(b2ac)) / (2 * a);
      if (0 < t1 && t1 < 1) {
        if (i === 0)
          this.addX(f(t1, i));
        if (i === 1)
          this.addY(f(t1, i));
      }
      const t2 = (-b - Math.sqrt(b2ac)) / (2 * a);
      if (0 < t2 && t2 < 1) {
        if (i === 0)
          this.addX(f(t2, i));
        if (i === 1)
          this.addY(f(t2, i));
      }
    }
  }
};

// node_modules/vexflow/build/esm/src/font.js
var __awaiter = function(thisArg, _arguments, P, generator) {
  function adopt(value) {
    return value instanceof P ? value : new P(function(resolve) {
      resolve(value);
    });
  }
  return new (P || (P = Promise))(function(resolve, reject) {
    function fulfilled(value) {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    }
    function rejected(value) {
      try {
        step(generator["throw"](value));
      } catch (e) {
        reject(e);
      }
    }
    function step(result) {
      result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
    }
    step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
};
var FontWeight;
(function(FontWeight2) {
  FontWeight2["NORMAL"] = "normal";
  FontWeight2["BOLD"] = "bold";
})(FontWeight || (FontWeight = {}));
var FontStyle;
(function(FontStyle2) {
  FontStyle2["NORMAL"] = "normal";
  FontStyle2["ITALIC"] = "italic";
})(FontStyle || (FontStyle = {}));
var fontParser;
var Fonts = {};
var Font = class _Font {
  static convertSizeToPixelValue(fontSize = _Font.SIZE) {
    var _a;
    if (typeof fontSize === "number") {
      return fontSize * _Font.scaleToPxFrom.pt;
    } else {
      const value = parseFloat(fontSize);
      if (isNaN(value)) {
        return 0;
      }
      const unit = fontSize.replace(/[\d.\s]/g, "").toLowerCase();
      const conversionFactor = (_a = _Font.scaleToPxFrom[unit]) !== null && _a !== void 0 ? _a : 1;
      return value * conversionFactor;
    }
  }
  static convertSizeToPointValue(fontSize = _Font.SIZE) {
    var _a;
    if (typeof fontSize === "number") {
      return fontSize;
    } else {
      const value = parseFloat(fontSize);
      if (isNaN(value)) {
        return 0;
      }
      const unit = fontSize.replace(/[\d.\s]/g, "").toLowerCase();
      const conversionFactor = ((_a = _Font.scaleToPxFrom[unit]) !== null && _a !== void 0 ? _a : 1) / _Font.scaleToPxFrom.pt;
      return value * conversionFactor;
    }
  }
  static validate(f, size, weight, style) {
    if (typeof f === "string" && size === void 0 && weight === void 0 && style === void 0) {
      return _Font.fromCSSString(f);
    }
    let family;
    if (typeof f === "object") {
      family = f.family;
      size = f.size;
      weight = f.weight;
      style = f.style;
    } else {
      family = f;
    }
    family = family !== null && family !== void 0 ? family : _Font.SANS_SERIF;
    size = size !== null && size !== void 0 ? size : _Font.SIZE + "pt";
    weight = weight !== null && weight !== void 0 ? weight : FontWeight.NORMAL;
    style = style !== null && style !== void 0 ? style : FontStyle.NORMAL;
    if (weight === "") {
      weight = FontWeight.NORMAL;
    }
    if (style === "") {
      style = FontStyle.NORMAL;
    }
    if (typeof size === "number") {
      size = `${size}pt`;
    }
    if (typeof weight === "number") {
      weight = weight.toString();
    }
    return { family, size, weight, style };
  }
  static fromCSSString(cssFontShorthand) {
    if (!fontParser) {
      fontParser = document.createElement("span");
    }
    fontParser.style.font = cssFontShorthand;
    const { fontFamily, fontSize, fontWeight, fontStyle } = fontParser.style;
    return { family: fontFamily, size: fontSize, weight: fontWeight, style: fontStyle };
  }
  static toCSSString(fontInfo) {
    var _a;
    if (!fontInfo) {
      return "";
    }
    let style;
    const st = fontInfo.style;
    if (st === FontStyle.NORMAL || st === "" || st === void 0) {
      style = "";
    } else {
      style = st.trim() + " ";
    }
    let weight;
    const wt = fontInfo.weight;
    if (wt === FontWeight.NORMAL || wt === "" || wt === void 0) {
      weight = "";
    } else if (typeof wt === "number") {
      weight = wt + " ";
    } else {
      weight = wt.trim() + " ";
    }
    let size;
    const sz = fontInfo.size;
    if (sz === void 0) {
      size = _Font.SIZE + "pt ";
    } else if (typeof sz === "number") {
      size = sz + "pt ";
    } else {
      size = sz.trim() + " ";
    }
    const family = (_a = fontInfo.family) !== null && _a !== void 0 ? _a : _Font.SANS_SERIF;
    return `${style}${weight}${size}${family}`;
  }
  static scaleSize(fontSize, scaleFactor) {
    if (typeof fontSize === "number") {
      return fontSize * scaleFactor;
    } else {
      const value = parseFloat(fontSize);
      const unit = fontSize.replace(/[\d.\s]/g, "");
      return `${value * scaleFactor}${unit}`;
    }
  }
  static isBold(weight) {
    if (!weight) {
      return false;
    } else if (typeof weight === "number") {
      return weight >= 600;
    } else {
      const parsedWeight = parseInt(weight, 10);
      if (isNaN(parsedWeight)) {
        return weight.toLowerCase() === "bold";
      } else {
        return parsedWeight >= 600;
      }
    }
  }
  static isItalic(style) {
    if (!style) {
      return false;
    } else {
      return style.toLowerCase() === FontStyle.ITALIC;
    }
  }
  static loadWebFont(fontName, woffURL, includeWoff2 = true) {
    return __awaiter(this, void 0, void 0, function* () {
      const woff2URL = includeWoff2 ? `url(${woffURL}2) format('woff2'), ` : "";
      const woff1URL = `url(${woffURL}) format('woff')`;
      const woffURLs = woff2URL + woff1URL;
      const fontFace = new FontFace(fontName, woffURLs);
      yield fontFace.load();
      document.fonts.add(fontFace);
      return fontFace;
    });
  }
  static loadWebFonts() {
    return __awaiter(this, void 0, void 0, function* () {
      const host = _Font.WEB_FONT_HOST;
      const files = _Font.WEB_FONT_FILES;
      for (const fontName in files) {
        const fontPath = files[fontName];
        _Font.loadWebFont(fontName, host + fontPath);
      }
    });
  }
  static load(fontName, data, metrics) {
    let font = Fonts[fontName];
    if (!font) {
      font = new _Font(fontName);
      Fonts[fontName] = font;
    }
    if (data) {
      font.setData(data);
    }
    if (metrics) {
      font.setMetrics(metrics);
    }
    return font;
  }
  constructor(fontName) {
    this.name = fontName;
  }
  getName() {
    return this.name;
  }
  getData() {
    return defined(this.data, "FontError", "Missing font data");
  }
  getMetrics() {
    return defined(this.metrics, "FontError", "Missing metrics");
  }
  setData(data) {
    this.data = data;
  }
  setMetrics(metrics) {
    this.metrics = metrics;
  }
  hasData() {
    return this.data !== void 0;
  }
  getResolution() {
    return this.getData().resolution;
  }
  getGlyphs() {
    return this.getData().glyphs;
  }
  lookupMetric(key, defaultValue) {
    const keyParts = key.split(".");
    let currObj = this.getMetrics();
    for (let i = 0; i < keyParts.length; i++) {
      const keyPart = keyParts[i];
      const value = currObj[keyPart];
      if (value === void 0) {
        return defaultValue;
      }
      currObj = value;
    }
    return currObj;
  }
  toString() {
    return "[" + this.name + " Font]";
  }
};
Font.SANS_SERIF = "Arial, sans-serif";
Font.SERIF = "Times New Roman, serif";
Font.SIZE = 10;
Font.scaleToPxFrom = {
  pt: 4 / 3,
  px: 1,
  em: 16,
  "%": 4 / 25,
  in: 96,
  mm: 96 / 25.4,
  cm: 96 / 2.54
};
Font.WEB_FONT_HOST = "https://unpkg.com/vexflow-fonts@1.0.3/";
Font.WEB_FONT_FILES = {
  "Roboto Slab": "robotoslab/RobotoSlab-Medium_2.001.woff",
  PetalumaScript: "petaluma/PetalumaScript_1.10_FS.woff"
};

// node_modules/vexflow/build/esm/src/registry.js
var Index = class {
  constructor() {
    this.id = {};
    this.type = {};
    this.class = {};
  }
};
var Registry = class _Registry {
  static getDefaultRegistry() {
    return _Registry.defaultRegistry;
  }
  static enableDefaultRegistry(registry2) {
    _Registry.defaultRegistry = registry2;
  }
  static disableDefaultRegistry() {
    _Registry.defaultRegistry = void 0;
  }
  constructor() {
    this.index = new Index();
  }
  clear() {
    this.index = new Index();
    return this;
  }
  setIndexValue(name, value, id, elem) {
    const index = this.index;
    if (!index[name][value]) {
      index[name][value] = {};
    }
    index[name][value][id] = elem;
  }
  updateIndex({ id, name, value, oldValue }) {
    const elem = this.getElementById(id);
    if (oldValue !== void 0 && this.index[name][oldValue]) {
      delete this.index[name][oldValue][id];
    }
    if (value && elem) {
      this.setIndexValue(name, value, elem.getAttribute("id"), elem);
    }
  }
  register(elem, id) {
    id = id || elem.getAttribute("id");
    if (!id) {
      throw new RuntimeError("Can't add element without `id` attribute to registry");
    }
    elem.setAttribute("id", id);
    this.setIndexValue("id", id, id, elem);
    this.updateIndex({ id, name: "type", value: elem.getAttribute("type"), oldValue: void 0 });
    elem.onRegister(this);
    return this;
  }
  getElementById(id) {
    var _a, _b;
    return (_b = (_a = this.index.id) === null || _a === void 0 ? void 0 : _a[id]) === null || _b === void 0 ? void 0 : _b[id];
  }
  getElementsByAttribute(attribute, value) {
    const index_attr = this.index[attribute];
    if (index_attr) {
      const index_attr_val = index_attr[value];
      if (index_attr_val) {
        const keys = Object.keys(index_attr_val);
        return keys.map((k) => index_attr_val[k]);
      }
    }
    return [];
  }
  getElementsByType(type) {
    return this.getElementsByAttribute("type", type);
  }
  getElementsByClass(className) {
    return this.getElementsByAttribute("class", className);
  }
  onUpdate(info) {
    const allowedNames = ["id", "type", "class"];
    if (allowedNames.includes(info.name)) {
      this.updateIndex(info);
    }
    return this;
  }
};

// node_modules/vexflow/build/esm/src/element.js
var Element = class _Element {
  static get CATEGORY() {
    return "Element";
  }
  static newID() {
    return `auto${_Element.ID++}`;
  }
  constructor() {
    var _a;
    this.children = [];
    this.attrs = {
      id: _Element.newID(),
      type: this.getCategory(),
      class: ""
    };
    this.rendered = false;
    (_a = Registry.getDefaultRegistry()) === null || _a === void 0 ? void 0 : _a.register(this);
  }
  addChildElement(child) {
    this.children.push(child);
    return this;
  }
  getCategory() {
    return this.constructor.CATEGORY;
  }
  setStyle(style) {
    this.style = style;
    return this;
  }
  setGroupStyle(style) {
    this.style = style;
    this.children.forEach((child) => child.setGroupStyle(style));
    return this;
  }
  getStyle() {
    return this.style;
  }
  applyStyle(context = this.context, style = this.getStyle()) {
    if (!style)
      return this;
    if (!context)
      return this;
    context.save();
    if (style.shadowColor)
      context.setShadowColor(style.shadowColor);
    if (style.shadowBlur)
      context.setShadowBlur(style.shadowBlur);
    if (style.fillStyle)
      context.setFillStyle(style.fillStyle);
    if (style.strokeStyle)
      context.setStrokeStyle(style.strokeStyle);
    if (style.lineWidth)
      context.setLineWidth(style.lineWidth);
    return this;
  }
  restoreStyle(context = this.context, style = this.getStyle()) {
    if (!style)
      return this;
    if (!context)
      return this;
    context.restore();
    return this;
  }
  drawWithStyle() {
    this.checkContext();
    this.applyStyle();
    this.draw();
    this.restoreStyle();
  }
  hasClass(className) {
    var _a;
    if (!this.attrs.class)
      return false;
    return ((_a = this.attrs.class) === null || _a === void 0 ? void 0 : _a.split(" ").indexOf(className)) != -1;
  }
  addClass(className) {
    var _a;
    if (this.hasClass(className))
      return this;
    if (!this.attrs.class)
      this.attrs.class = `${className}`;
    else
      this.attrs.class = `${this.attrs.class} ${className}`;
    (_a = this.registry) === null || _a === void 0 ? void 0 : _a.onUpdate({
      id: this.attrs.id,
      name: "class",
      value: className,
      oldValue: void 0
    });
    return this;
  }
  removeClass(className) {
    var _a, _b;
    if (!this.hasClass(className))
      return this;
    const arr = (_a = this.attrs.class) === null || _a === void 0 ? void 0 : _a.split(" ");
    if (arr) {
      arr.splice(arr.indexOf(className));
      this.attrs.class = arr.join(" ");
    }
    (_b = this.registry) === null || _b === void 0 ? void 0 : _b.onUpdate({
      id: this.attrs.id,
      name: "class",
      value: void 0,
      oldValue: className
    });
    return this;
  }
  onRegister(registry2) {
    this.registry = registry2;
    return this;
  }
  isRendered() {
    return this.rendered;
  }
  setRendered(rendered = true) {
    this.rendered = rendered;
    return this;
  }
  getAttributes() {
    return this.attrs;
  }
  getAttribute(name) {
    return this.attrs[name];
  }
  getSVGElement(suffix = "") {
    const id = prefix(this.attrs.id + suffix);
    const element = document.getElementById(id);
    if (element)
      return element;
  }
  setAttribute(name, value) {
    var _a;
    const oldID = this.attrs.id;
    const oldValue = this.attrs[name];
    this.attrs[name] = value;
    (_a = this.registry) === null || _a === void 0 ? void 0 : _a.onUpdate({ id: oldID, name, value, oldValue });
    return this;
  }
  getBoundingBox() {
    return this.boundingBox;
  }
  getContext() {
    return this.context;
  }
  setContext(context) {
    this.context = context;
    return this;
  }
  checkContext() {
    return defined(this.context, "NoContext", "No rendering context attached to instance.");
  }
  set font(f) {
    this.setFont(f);
  }
  get font() {
    return Font.toCSSString(this.textFont);
  }
  setFont(font, size, weight, style) {
    const defaultTextFont = this.constructor.TEXT_FONT;
    const fontIsObject = typeof font === "object";
    const fontIsString = typeof font === "string";
    const fontIsUndefined = font === void 0;
    const sizeWeightStyleAreUndefined = size === void 0 && weight === void 0 && style === void 0;
    if (fontIsObject) {
      this.textFont = Object.assign(Object.assign({}, defaultTextFont), font);
    } else if (fontIsString && sizeWeightStyleAreUndefined) {
      this.textFont = Font.fromCSSString(font);
    } else if (fontIsUndefined && sizeWeightStyleAreUndefined) {
      this.textFont = Object.assign({}, defaultTextFont);
    } else {
      this.textFont = Font.validate(font !== null && font !== void 0 ? font : defaultTextFont.family, size !== null && size !== void 0 ? size : defaultTextFont.size, weight !== null && weight !== void 0 ? weight : defaultTextFont.weight, style !== null && style !== void 0 ? style : defaultTextFont.style);
    }
    return this;
  }
  getFont() {
    if (!this.textFont) {
      this.resetFont();
    }
    return Font.toCSSString(this.textFont);
  }
  resetFont() {
    this.setFont();
  }
  get fontInfo() {
    if (!this.textFont) {
      this.resetFont();
    }
    return Object.assign({}, this.textFont);
  }
  set fontInfo(fontInfo) {
    this.setFont(fontInfo);
  }
  setFontSize(size) {
    const fontInfo = this.fontInfo;
    this.setFont(fontInfo.family, size, fontInfo.weight, fontInfo.style);
    return this;
  }
  getFontSize() {
    return this.fontSize;
  }
  set fontSize(size) {
    this.setFontSize(size);
  }
  get fontSize() {
    let size = this.fontInfo.size;
    if (typeof size === "number") {
      size = `${size}pt`;
    }
    return size;
  }
  get fontSizeInPoints() {
    return Font.convertSizeToPointValue(this.fontSize);
  }
  get fontSizeInPixels() {
    return Font.convertSizeToPixelValue(this.fontSize);
  }
  get fontStyle() {
    return this.fontInfo.style;
  }
  set fontStyle(style) {
    const fontInfo = this.fontInfo;
    this.setFont(fontInfo.family, fontInfo.size, fontInfo.weight, style);
  }
  get fontWeight() {
    return this.fontInfo.weight + "";
  }
  set fontWeight(weight) {
    const fontInfo = this.fontInfo;
    this.setFont(fontInfo.family, fontInfo.size, weight, fontInfo.style);
  }
};
Element.ID = 1e3;
Element.TEXT_FONT = {
  family: Font.SANS_SERIF,
  size: Font.SIZE,
  weight: FontWeight.NORMAL,
  style: FontStyle.NORMAL
};

// node_modules/vexflow/build/esm/src/tables.js
var RESOLUTION = 16384;
var durations = {
  "1/2": RESOLUTION * 2,
  1: RESOLUTION / 1,
  2: RESOLUTION / 2,
  4: RESOLUTION / 4,
  8: RESOLUTION / 8,
  16: RESOLUTION / 16,
  32: RESOLUTION / 32,
  64: RESOLUTION / 64,
  128: RESOLUTION / 128,
  256: RESOLUTION / 256
};
var durationAliases = {
  w: "1",
  h: "2",
  q: "4",
  b: "256"
};
var keySignatures = {
  C: { num: 0 },
  Am: { num: 0 },
  F: { acc: "b", num: 1 },
  Dm: { acc: "b", num: 1 },
  Bb: { acc: "b", num: 2 },
  Gm: { acc: "b", num: 2 },
  Eb: { acc: "b", num: 3 },
  Cm: { acc: "b", num: 3 },
  Ab: { acc: "b", num: 4 },
  Fm: { acc: "b", num: 4 },
  Db: { acc: "b", num: 5 },
  Bbm: { acc: "b", num: 5 },
  Gb: { acc: "b", num: 6 },
  Ebm: { acc: "b", num: 6 },
  Cb: { acc: "b", num: 7 },
  Abm: { acc: "b", num: 7 },
  G: { acc: "#", num: 1 },
  Em: { acc: "#", num: 1 },
  D: { acc: "#", num: 2 },
  Bm: { acc: "#", num: 2 },
  A: { acc: "#", num: 3 },
  "F#m": { acc: "#", num: 3 },
  E: { acc: "#", num: 4 },
  "C#m": { acc: "#", num: 4 },
  B: { acc: "#", num: 5 },
  "G#m": { acc: "#", num: 5 },
  "F#": { acc: "#", num: 6 },
  "D#m": { acc: "#", num: 6 },
  "C#": { acc: "#", num: 7 },
  "A#m": { acc: "#", num: 7 }
};
var clefs = {
  treble: { line_shift: 0 },
  bass: { line_shift: 6 },
  tenor: { line_shift: 4 },
  alto: { line_shift: 3 },
  soprano: { line_shift: 1 },
  percussion: { line_shift: 0 },
  "mezzo-soprano": { line_shift: 2 },
  "baritone-c": { line_shift: 5 },
  "baritone-f": { line_shift: 5 },
  subbass: { line_shift: 7 },
  french: { line_shift: -1 }
};
var notesInfo = {
  C: { index: 0, int_val: 0 },
  CN: { index: 0, int_val: 0, accidental: "n" },
  "C#": { index: 0, int_val: 1, accidental: "#" },
  "C##": { index: 0, int_val: 2, accidental: "##" },
  CB: { index: 0, int_val: 11, accidental: "b" },
  CBB: { index: 0, int_val: 10, accidental: "bb" },
  D: { index: 1, int_val: 2 },
  DN: { index: 1, int_val: 2, accidental: "n" },
  "D#": { index: 1, int_val: 3, accidental: "#" },
  "D##": { index: 1, int_val: 4, accidental: "##" },
  DB: { index: 1, int_val: 1, accidental: "b" },
  DBB: { index: 1, int_val: 0, accidental: "bb" },
  E: { index: 2, int_val: 4 },
  EN: { index: 2, int_val: 4, accidental: "n" },
  "E#": { index: 2, int_val: 5, accidental: "#" },
  "E##": { index: 2, int_val: 6, accidental: "##" },
  EB: { index: 2, int_val: 3, accidental: "b" },
  EBB: { index: 2, int_val: 2, accidental: "bb" },
  F: { index: 3, int_val: 5 },
  FN: { index: 3, int_val: 5, accidental: "n" },
  "F#": { index: 3, int_val: 6, accidental: "#" },
  "F##": { index: 3, int_val: 7, accidental: "##" },
  FB: { index: 3, int_val: 4, accidental: "b" },
  FBB: { index: 3, int_val: 3, accidental: "bb" },
  G: { index: 4, int_val: 7 },
  GN: { index: 4, int_val: 7, accidental: "n" },
  "G#": { index: 4, int_val: 8, accidental: "#" },
  "G##": { index: 4, int_val: 9, accidental: "##" },
  GB: { index: 4, int_val: 6, accidental: "b" },
  GBB: { index: 4, int_val: 5, accidental: "bb" },
  A: { index: 5, int_val: 9 },
  AN: { index: 5, int_val: 9, accidental: "n" },
  "A#": { index: 5, int_val: 10, accidental: "#" },
  "A##": { index: 5, int_val: 11, accidental: "##" },
  AB: { index: 5, int_val: 8, accidental: "b" },
  ABB: { index: 5, int_val: 7, accidental: "bb" },
  B: { index: 6, int_val: 11 },
  BN: { index: 6, int_val: 11, accidental: "n" },
  "B#": { index: 6, int_val: 12, accidental: "#" },
  "B##": { index: 6, int_val: 13, accidental: "##" },
  BB: { index: 6, int_val: 10, accidental: "b" },
  BBB: { index: 6, int_val: 9, accidental: "bb" },
  R: { index: 6, rest: true },
  X: {
    index: 6,
    accidental: "",
    octave: 4,
    code: "noteheadXBlack",
    shift_right: 5.5
  }
};
var validNoteTypes = {
  n: { name: "note" },
  r: { name: "rest" },
  h: { name: "harmonic" },
  m: { name: "muted" },
  s: { name: "slash" },
  g: { name: "ghost" },
  d: { name: "diamond" },
  x: { name: "x" },
  ci: { name: "circled" },
  cx: { name: "circle x" },
  sf: { name: "slashed" },
  sb: { name: "slashed backward" },
  sq: { name: "square" },
  tu: { name: "triangle up" },
  td: { name: "triangle down" }
};
var accidentals = {
  "#": { code: "accidentalSharp", parenRightPaddingAdjustment: -1 },
  "##": { code: "accidentalDoubleSharp", parenRightPaddingAdjustment: -1 },
  b: { code: "accidentalFlat", parenRightPaddingAdjustment: -2 },
  bb: { code: "accidentalDoubleFlat", parenRightPaddingAdjustment: -2 },
  n: { code: "accidentalNatural", parenRightPaddingAdjustment: -1 },
  "{": { code: "accidentalParensLeft", parenRightPaddingAdjustment: -1 },
  "}": { code: "accidentalParensRight", parenRightPaddingAdjustment: -1 },
  db: { code: "accidentalThreeQuarterTonesFlatZimmermann", parenRightPaddingAdjustment: -1 },
  d: { code: "accidentalQuarterToneFlatStein", parenRightPaddingAdjustment: 0 },
  "++": { code: "accidentalThreeQuarterTonesSharpStein", parenRightPaddingAdjustment: -1 },
  "+": { code: "accidentalQuarterToneSharpStein", parenRightPaddingAdjustment: -1 },
  "+-": { code: "accidentalKucukMucennebSharp", parenRightPaddingAdjustment: -1 },
  bs: { code: "accidentalBakiyeFlat", parenRightPaddingAdjustment: -1 },
  bss: { code: "accidentalBuyukMucennebFlat", parenRightPaddingAdjustment: -1 },
  o: { code: "accidentalSori", parenRightPaddingAdjustment: -1 },
  k: { code: "accidentalKoron", parenRightPaddingAdjustment: -1 },
  bbs: { code: "vexAccidentalMicrotonal1", parenRightPaddingAdjustment: -1 },
  "++-": { code: "accidentalBuyukMucennebSharp", parenRightPaddingAdjustment: -1 },
  ashs: { code: "vexAccidentalMicrotonal3", parenRightPaddingAdjustment: -1 },
  afhf: { code: "vexAccidentalMicrotonal4", parenRightPaddingAdjustment: -1 },
  accSagittal5v7KleismaUp: { code: "accSagittal5v7KleismaUp", parenRightPaddingAdjustment: -1 },
  accSagittal5v7KleismaDown: { code: "accSagittal5v7KleismaDown", parenRightPaddingAdjustment: -1 },
  accSagittal5CommaUp: { code: "accSagittal5CommaUp", parenRightPaddingAdjustment: -1 },
  accSagittal5CommaDown: { code: "accSagittal5CommaDown", parenRightPaddingAdjustment: -1 },
  accSagittal7CommaUp: { code: "accSagittal7CommaUp", parenRightPaddingAdjustment: -1 },
  accSagittal7CommaDown: { code: "accSagittal7CommaDown", parenRightPaddingAdjustment: -1 },
  accSagittal25SmallDiesisUp: { code: "accSagittal25SmallDiesisUp", parenRightPaddingAdjustment: -1 },
  accSagittal25SmallDiesisDown: { code: "accSagittal25SmallDiesisDown", parenRightPaddingAdjustment: -1 },
  accSagittal35MediumDiesisUp: { code: "accSagittal35MediumDiesisUp", parenRightPaddingAdjustment: -1 },
  accSagittal35MediumDiesisDown: { code: "accSagittal35MediumDiesisDown", parenRightPaddingAdjustment: -1 },
  accSagittal11MediumDiesisUp: { code: "accSagittal11MediumDiesisUp", parenRightPaddingAdjustment: -1 },
  accSagittal11MediumDiesisDown: { code: "accSagittal11MediumDiesisDown", parenRightPaddingAdjustment: -1 },
  accSagittal11LargeDiesisUp: { code: "accSagittal11LargeDiesisUp", parenRightPaddingAdjustment: -1 },
  accSagittal11LargeDiesisDown: { code: "accSagittal11LargeDiesisDown", parenRightPaddingAdjustment: -1 },
  accSagittal35LargeDiesisUp: { code: "accSagittal35LargeDiesisUp", parenRightPaddingAdjustment: -1 },
  accSagittal35LargeDiesisDown: { code: "accSagittal35LargeDiesisDown", parenRightPaddingAdjustment: -1 },
  accSagittalSharp25SDown: { code: "accSagittalSharp25SDown", parenRightPaddingAdjustment: -1 },
  accSagittalFlat25SUp: { code: "accSagittalFlat25SUp", parenRightPaddingAdjustment: -1 },
  accSagittalSharp7CDown: { code: "accSagittalSharp7CDown", parenRightPaddingAdjustment: -1 },
  accSagittalFlat7CUp: { code: "accSagittalFlat7CUp", parenRightPaddingAdjustment: -1 },
  accSagittalSharp5CDown: { code: "accSagittalSharp5CDown", parenRightPaddingAdjustment: -1 },
  accSagittalFlat5CUp: { code: "accSagittalFlat5CUp", parenRightPaddingAdjustment: -1 },
  accSagittalSharp5v7kDown: { code: "accSagittalSharp5v7kDown", parenRightPaddingAdjustment: -1 },
  accSagittalFlat5v7kUp: { code: "accSagittalFlat5v7kUp", parenRightPaddingAdjustment: -1 },
  accSagittalSharp: { code: "accSagittalSharp", parenRightPaddingAdjustment: -1 },
  accSagittalFlat: { code: "accSagittalFlat", parenRightPaddingAdjustment: -1 },
  accSagittalSharp5v7kUp: { code: "accSagittalSharp5v7kUp", parenRightPaddingAdjustment: -1 },
  accSagittalFlat5v7kDown: { code: "accSagittalFlat5v7kDown", parenRightPaddingAdjustment: -1 },
  accSagittalSharp5CUp: { code: "accSagittalSharp5CUp", parenRightPaddingAdjustment: -1 },
  accSagittalFlat5CDown: { code: "accSagittalFlat5CDown", parenRightPaddingAdjustment: -1 },
  accSagittalSharp7CUp: { code: "accSagittalSharp7CUp", parenRightPaddingAdjustment: -1 },
  accSagittalFlat7CDown: { code: "accSagittalFlat7CDown", parenRightPaddingAdjustment: -1 },
  accSagittalSharp25SUp: { code: "accSagittalSharp25SUp", parenRightPaddingAdjustment: -1 },
  accSagittalFlat25SDown: { code: "accSagittalFlat25SDown", parenRightPaddingAdjustment: -1 },
  accSagittalSharp35MUp: { code: "accSagittalSharp35MUp", parenRightPaddingAdjustment: -1 },
  accSagittalFlat35MDown: { code: "accSagittalFlat35MDown", parenRightPaddingAdjustment: -1 },
  accSagittalSharp11MUp: { code: "accSagittalSharp11MUp", parenRightPaddingAdjustment: -1 },
  accSagittalFlat11MDown: { code: "accSagittalFlat11MDown", parenRightPaddingAdjustment: -1 },
  accSagittalSharp11LUp: { code: "accSagittalSharp11LUp", parenRightPaddingAdjustment: -1 },
  accSagittalFlat11LDown: { code: "accSagittalFlat11LDown", parenRightPaddingAdjustment: -1 },
  accSagittalSharp35LUp: { code: "accSagittalSharp35LUp", parenRightPaddingAdjustment: -1 },
  accSagittalFlat35LDown: { code: "accSagittalFlat35LDown", parenRightPaddingAdjustment: -1 },
  accSagittalDoubleSharp25SDown: { code: "accSagittalDoubleSharp25SDown", parenRightPaddingAdjustment: -1 },
  accSagittalDoubleFlat25SUp: { code: "accSagittalDoubleFlat25SUp", parenRightPaddingAdjustment: -1 },
  accSagittalDoubleSharp7CDown: { code: "accSagittalDoubleSharp7CDown", parenRightPaddingAdjustment: -1 },
  accSagittalDoubleFlat7CUp: { code: "accSagittalDoubleFlat7CUp", parenRightPaddingAdjustment: -1 },
  accSagittalDoubleSharp5CDown: { code: "accSagittalDoubleSharp5CDown", parenRightPaddingAdjustment: -1 },
  accSagittalDoubleFlat5CUp: { code: "accSagittalDoubleFlat5CUp", parenRightPaddingAdjustment: -1 },
  accSagittalDoubleSharp5v7kDown: { code: "accSagittalDoubleSharp5v7kDown", parenRightPaddingAdjustment: -1 },
  accSagittalDoubleFlat5v7kUp: { code: "accSagittalDoubleFlat5v7kUp", parenRightPaddingAdjustment: -1 },
  accSagittalDoubleSharp: { code: "accSagittalDoubleSharp", parenRightPaddingAdjustment: -1 },
  accSagittalDoubleFlat: { code: "accSagittalDoubleFlat", parenRightPaddingAdjustment: -1 },
  accSagittal7v11KleismaUp: { code: "accSagittal7v11KleismaUp", parenRightPaddingAdjustment: -1 },
  accSagittal7v11KleismaDown: { code: "accSagittal7v11KleismaDown", parenRightPaddingAdjustment: -1 },
  accSagittal17CommaUp: { code: "accSagittal17CommaUp", parenRightPaddingAdjustment: -1 },
  accSagittal17CommaDown: { code: "accSagittal17CommaDown", parenRightPaddingAdjustment: -1 },
  accSagittal55CommaUp: { code: "accSagittal55CommaUp", parenRightPaddingAdjustment: -1 },
  accSagittal55CommaDown: { code: "accSagittal55CommaDown", parenRightPaddingAdjustment: -1 },
  accSagittal7v11CommaUp: { code: "accSagittal7v11CommaUp", parenRightPaddingAdjustment: -1 },
  accSagittal7v11CommaDown: { code: "accSagittal7v11CommaDown", parenRightPaddingAdjustment: -1 },
  accSagittal5v11SmallDiesisUp: { code: "accSagittal5v11SmallDiesisUp", parenRightPaddingAdjustment: -1 },
  accSagittal5v11SmallDiesisDown: { code: "accSagittal5v11SmallDiesisDown", parenRightPaddingAdjustment: -1 },
  accSagittalSharp5v11SDown: { code: "accSagittalSharp5v11SDown", parenRightPaddingAdjustment: -1 },
  accSagittalFlat5v11SUp: { code: "accSagittalFlat5v11SUp", parenRightPaddingAdjustment: -1 },
  accSagittalSharp7v11CDown: { code: "accSagittalSharp7v11CDown", parenRightPaddingAdjustment: -1 },
  accSagittalFlat7v11CUp: { code: "accSagittalFlat7v11CUp", parenRightPaddingAdjustment: -1 },
  accSagittalSharp55CDown: { code: "accSagittalSharp55CDown", parenRightPaddingAdjustment: -1 },
  accSagittalFlat55CUp: { code: "accSagittalFlat55CUp", parenRightPaddingAdjustment: -1 },
  accSagittalSharp17CDown: { code: "accSagittalSharp17CDown", parenRightPaddingAdjustment: -1 },
  accSagittalFlat17CUp: { code: "accSagittalFlat17CUp", parenRightPaddingAdjustment: -1 },
  accSagittalSharp7v11kDown: { code: "accSagittalSharp7v11kDown", parenRightPaddingAdjustment: -1 },
  accSagittalFlat7v11kUp: { code: "accSagittalFlat7v11kUp", parenRightPaddingAdjustment: -1 },
  accSagittalSharp7v11kUp: { code: "accSagittalSharp7v11kUp", parenRightPaddingAdjustment: -1 },
  accSagittalFlat7v11kDown: { code: "accSagittalFlat7v11kDown", parenRightPaddingAdjustment: -1 },
  accSagittalSharp17CUp: { code: "accSagittalSharp17CUp", parenRightPaddingAdjustment: -1 },
  accSagittalFlat17CDown: { code: "accSagittalFlat17CDown", parenRightPaddingAdjustment: -1 },
  accSagittalSharp55CUp: { code: "accSagittalSharp55CUp", parenRightPaddingAdjustment: -1 },
  accSagittalFlat55CDown: { code: "accSagittalFlat55CDown", parenRightPaddingAdjustment: -1 },
  accSagittalSharp7v11CUp: { code: "accSagittalSharp7v11CUp", parenRightPaddingAdjustment: -1 },
  accSagittalFlat7v11CDown: { code: "accSagittalFlat7v11CDown", parenRightPaddingAdjustment: -1 },
  accSagittalSharp5v11SUp: { code: "accSagittalSharp5v11SUp", parenRightPaddingAdjustment: -1 },
  accSagittalFlat5v11SDown: { code: "accSagittalFlat5v11SDown", parenRightPaddingAdjustment: -1 },
  accSagittalDoubleSharp5v11SDown: { code: "accSagittalDoubleSharp5v11SDown", parenRightPaddingAdjustment: -1 },
  accSagittalDoubleFlat5v11SUp: { code: "accSagittalDoubleFlat5v11SUp", parenRightPaddingAdjustment: -1 },
  accSagittalDoubleSharp7v11CDown: { code: "accSagittalDoubleSharp7v11CDown", parenRightPaddingAdjustment: -1 },
  accSagittalDoubleFlat7v11CUp: { code: "accSagittalDoubleFlat7v11CUp", parenRightPaddingAdjustment: -1 },
  accSagittalDoubleSharp55CDown: { code: "accSagittalDoubleSharp55CDown", parenRightPaddingAdjustment: -1 },
  accSagittalDoubleFlat55CUp: { code: "accSagittalDoubleFlat55CUp", parenRightPaddingAdjustment: -1 },
  accSagittalDoubleSharp17CDown: { code: "accSagittalDoubleSharp17CDown", parenRightPaddingAdjustment: -1 },
  accSagittalDoubleFlat17CUp: { code: "accSagittalDoubleFlat17CUp", parenRightPaddingAdjustment: -1 },
  accSagittalDoubleSharp7v11kDown: { code: "accSagittalDoubleSharp7v11kDown", parenRightPaddingAdjustment: -1 },
  accSagittalDoubleFlat7v11kUp: { code: "accSagittalDoubleFlat7v11kUp", parenRightPaddingAdjustment: -1 },
  accSagittal23CommaUp: { code: "accSagittal23CommaUp", parenRightPaddingAdjustment: -1 },
  accSagittal23CommaDown: { code: "accSagittal23CommaDown", parenRightPaddingAdjustment: -1 },
  accSagittal5v19CommaUp: { code: "accSagittal5v19CommaUp", parenRightPaddingAdjustment: -1 },
  accSagittal5v19CommaDown: { code: "accSagittal5v19CommaDown", parenRightPaddingAdjustment: -1 },
  accSagittal5v23SmallDiesisUp: { code: "accSagittal5v23SmallDiesisUp", parenRightPaddingAdjustment: -1 },
  accSagittal5v23SmallDiesisDown: { code: "accSagittal5v23SmallDiesisDown", parenRightPaddingAdjustment: -1 },
  accSagittalSharp5v23SDown: { code: "accSagittalSharp5v23SDown", parenRightPaddingAdjustment: -1 },
  accSagittalFlat5v23SUp: { code: "accSagittalFlat5v23SUp", parenRightPaddingAdjustment: -1 },
  accSagittalSharp5v19CDown: { code: "accSagittalSharp5v19CDown", parenRightPaddingAdjustment: -1 },
  accSagittalFlat5v19CUp: { code: "accSagittalFlat5v19CUp", parenRightPaddingAdjustment: -1 },
  accSagittalSharp23CDown: { code: "accSagittalSharp23CDown", parenRightPaddingAdjustment: -1 },
  accSagittalFlat23CUp: { code: "accSagittalFlat23CUp", parenRightPaddingAdjustment: -1 },
  accSagittalSharp23CUp: { code: "accSagittalSharp23CUp", parenRightPaddingAdjustment: -1 },
  accSagittalFlat23CDown: { code: "accSagittalFlat23CDown", parenRightPaddingAdjustment: -1 },
  accSagittalSharp5v19CUp: { code: "accSagittalSharp5v19CUp", parenRightPaddingAdjustment: -1 },
  accSagittalFlat5v19CDown: { code: "accSagittalFlat5v19CDown", parenRightPaddingAdjustment: -1 },
  accSagittalSharp5v23SUp: { code: "accSagittalSharp5v23SUp", parenRightPaddingAdjustment: -1 },
  accSagittalFlat5v23SDown: { code: "accSagittalFlat5v23SDown", parenRightPaddingAdjustment: -1 },
  accSagittalDoubleSharp5v23SDown: { code: "accSagittalDoubleSharp5v23SDown", parenRightPaddingAdjustment: -1 },
  accSagittalDoubleFlat5v23SUp: { code: "accSagittalDoubleFlat5v23SUp", parenRightPaddingAdjustment: -1 },
  accSagittalDoubleSharp5v19CDown: { code: "accSagittalDoubleSharp5v19CDown", parenRightPaddingAdjustment: -1 },
  accSagittalDoubleFlat5v19CUp: { code: "accSagittalDoubleFlat5v19CUp", parenRightPaddingAdjustment: -1 },
  accSagittalDoubleSharp23CDown: { code: "accSagittalDoubleSharp23CDown", parenRightPaddingAdjustment: -1 },
  accSagittalDoubleFlat23CUp: { code: "accSagittalDoubleFlat23CUp", parenRightPaddingAdjustment: -1 },
  accSagittal19SchismaUp: { code: "accSagittal19SchismaUp", parenRightPaddingAdjustment: -1 },
  accSagittal19SchismaDown: { code: "accSagittal19SchismaDown", parenRightPaddingAdjustment: -1 },
  accSagittal17KleismaUp: { code: "accSagittal17KleismaUp", parenRightPaddingAdjustment: -1 },
  accSagittal17KleismaDown: { code: "accSagittal17KleismaDown", parenRightPaddingAdjustment: -1 },
  accSagittal143CommaUp: { code: "accSagittal143CommaUp", parenRightPaddingAdjustment: -1 },
  accSagittal143CommaDown: { code: "accSagittal143CommaDown", parenRightPaddingAdjustment: -1 },
  accSagittal11v49CommaUp: { code: "accSagittal11v49CommaUp", parenRightPaddingAdjustment: -1 },
  accSagittal11v49CommaDown: { code: "accSagittal11v49CommaDown", parenRightPaddingAdjustment: -1 },
  accSagittal19CommaUp: { code: "accSagittal19CommaUp", parenRightPaddingAdjustment: -1 },
  accSagittal19CommaDown: { code: "accSagittal19CommaDown", parenRightPaddingAdjustment: -1 },
  accSagittal7v19CommaUp: { code: "accSagittal7v19CommaUp", parenRightPaddingAdjustment: -1 },
  accSagittal7v19CommaDown: { code: "accSagittal7v19CommaDown", parenRightPaddingAdjustment: -1 },
  accSagittal49SmallDiesisUp: { code: "accSagittal49SmallDiesisUp", parenRightPaddingAdjustment: -1 },
  accSagittal49SmallDiesisDown: { code: "accSagittal49SmallDiesisDown", parenRightPaddingAdjustment: -1 },
  accSagittal23SmallDiesisUp: { code: "accSagittal23SmallDiesisUp", parenRightPaddingAdjustment: -1 },
  accSagittal23SmallDiesisDown: { code: "accSagittal23SmallDiesisDown", parenRightPaddingAdjustment: -1 },
  accSagittal5v13MediumDiesisUp: { code: "accSagittal5v13MediumDiesisUp", parenRightPaddingAdjustment: -1 },
  accSagittal5v13MediumDiesisDown: { code: "accSagittal5v13MediumDiesisDown", parenRightPaddingAdjustment: -1 },
  accSagittal11v19MediumDiesisUp: { code: "accSagittal11v19MediumDiesisUp", parenRightPaddingAdjustment: -1 },
  accSagittal11v19MediumDiesisDown: { code: "accSagittal11v19MediumDiesisDown", parenRightPaddingAdjustment: -1 },
  accSagittal49MediumDiesisUp: { code: "accSagittal49MediumDiesisUp", parenRightPaddingAdjustment: -1 },
  accSagittal49MediumDiesisDown: { code: "accSagittal49MediumDiesisDown", parenRightPaddingAdjustment: -1 },
  accSagittal5v49MediumDiesisUp: { code: "accSagittal5v49MediumDiesisUp", parenRightPaddingAdjustment: -1 },
  accSagittal5v49MediumDiesisDown: { code: "accSagittal5v49MediumDiesisDown", parenRightPaddingAdjustment: -1 },
  accSagittal49LargeDiesisUp: { code: "accSagittal49LargeDiesisUp", parenRightPaddingAdjustment: -1 },
  accSagittal49LargeDiesisDown: { code: "accSagittal49LargeDiesisDown", parenRightPaddingAdjustment: -1 },
  accSagittal11v19LargeDiesisUp: { code: "accSagittal11v19LargeDiesisUp", parenRightPaddingAdjustment: -1 },
  accSagittal11v19LargeDiesisDown: { code: "accSagittal11v19LargeDiesisDown", parenRightPaddingAdjustment: -1 },
  accSagittal5v13LargeDiesisUp: { code: "accSagittal5v13LargeDiesisUp", parenRightPaddingAdjustment: -1 },
  accSagittal5v13LargeDiesisDown: { code: "accSagittal5v13LargeDiesisDown", parenRightPaddingAdjustment: -1 },
  accSagittalSharp23SDown: { code: "accSagittalSharp23SDown", parenRightPaddingAdjustment: -1 },
  accSagittalFlat23SUp: { code: "accSagittalFlat23SUp", parenRightPaddingAdjustment: -1 },
  accSagittalSharp49SDown: { code: "accSagittalSharp49SDown", parenRightPaddingAdjustment: -1 },
  accSagittalFlat49SUp: { code: "accSagittalFlat49SUp", parenRightPaddingAdjustment: -1 },
  accSagittalSharp7v19CDown: { code: "accSagittalSharp7v19CDown", parenRightPaddingAdjustment: -1 },
  accSagittalFlat7v19CUp: { code: "accSagittalFlat7v19CUp", parenRightPaddingAdjustment: -1 },
  accSagittalSharp19CDown: { code: "accSagittalSharp19CDown", parenRightPaddingAdjustment: -1 },
  accSagittalFlat19CUp: { code: "accSagittalFlat19CUp", parenRightPaddingAdjustment: -1 },
  accSagittalSharp11v49CDown: { code: "accSagittalSharp11v49CDown", parenRightPaddingAdjustment: -1 },
  accSagittalFlat11v49CUp: { code: "accSagittalFlat11v49CUp", parenRightPaddingAdjustment: -1 },
  accSagittalSharp143CDown: { code: "accSagittalSharp143CDown", parenRightPaddingAdjustment: -1 },
  accSagittalFlat143CUp: { code: "accSagittalFlat143CUp", parenRightPaddingAdjustment: -1 },
  accSagittalSharp17kDown: { code: "accSagittalSharp17kDown", parenRightPaddingAdjustment: -1 },
  accSagittalFlat17kUp: { code: "accSagittalFlat17kUp", parenRightPaddingAdjustment: -1 },
  accSagittalSharp19sDown: { code: "accSagittalSharp19sDown", parenRightPaddingAdjustment: -1 },
  accSagittalFlat19sUp: { code: "accSagittalFlat19sUp", parenRightPaddingAdjustment: -1 },
  accSagittalSharp19sUp: { code: "accSagittalSharp19sUp", parenRightPaddingAdjustment: -1 },
  accSagittalFlat19sDown: { code: "accSagittalFlat19sDown", parenRightPaddingAdjustment: -1 },
  accSagittalSharp17kUp: { code: "accSagittalSharp17kUp", parenRightPaddingAdjustment: -1 },
  accSagittalFlat17kDown: { code: "accSagittalFlat17kDown", parenRightPaddingAdjustment: -1 },
  accSagittalSharp143CUp: { code: "accSagittalSharp143CUp", parenRightPaddingAdjustment: -1 },
  accSagittalFlat143CDown: { code: "accSagittalFlat143CDown", parenRightPaddingAdjustment: -1 },
  accSagittalSharp11v49CUp: { code: "accSagittalSharp11v49CUp", parenRightPaddingAdjustment: -1 },
  accSagittalFlat11v49CDown: { code: "accSagittalFlat11v49CDown", parenRightPaddingAdjustment: -1 },
  accSagittalSharp19CUp: { code: "accSagittalSharp19CUp", parenRightPaddingAdjustment: -1 },
  accSagittalFlat19CDown: { code: "accSagittalFlat19CDown", parenRightPaddingAdjustment: -1 },
  accSagittalSharp7v19CUp: { code: "accSagittalSharp7v19CUp", parenRightPaddingAdjustment: -1 },
  accSagittalFlat7v19CDown: { code: "accSagittalFlat7v19CDown", parenRightPaddingAdjustment: -1 },
  accSagittalSharp49SUp: { code: "accSagittalSharp49SUp", parenRightPaddingAdjustment: -1 },
  accSagittalFlat49SDown: { code: "accSagittalFlat49SDown", parenRightPaddingAdjustment: -1 },
  accSagittalSharp23SUp: { code: "accSagittalSharp23SUp", parenRightPaddingAdjustment: -1 },
  accSagittalFlat23SDown: { code: "accSagittalFlat23SDown", parenRightPaddingAdjustment: -1 },
  accSagittalSharp5v13MUp: { code: "accSagittalSharp5v13MUp", parenRightPaddingAdjustment: -1 },
  accSagittalFlat5v13MDown: { code: "accSagittalFlat5v13MDown", parenRightPaddingAdjustment: -1 },
  accSagittalSharp11v19MUp: { code: "accSagittalSharp11v19MUp", parenRightPaddingAdjustment: -1 },
  accSagittalFlat11v19MDown: { code: "accSagittalFlat11v19MDown", parenRightPaddingAdjustment: -1 },
  accSagittalSharp49MUp: { code: "accSagittalSharp49MUp", parenRightPaddingAdjustment: -1 },
  accSagittalFlat49MDown: { code: "accSagittalFlat49MDown", parenRightPaddingAdjustment: -1 },
  accSagittalSharp5v49MUp: { code: "accSagittalSharp5v49MUp", parenRightPaddingAdjustment: -1 },
  accSagittalFlat5v49MDown: { code: "accSagittalFlat5v49MDown", parenRightPaddingAdjustment: -1 },
  accSagittalSharp49LUp: { code: "accSagittalSharp49LUp", parenRightPaddingAdjustment: -1 },
  accSagittalFlat49LDown: { code: "accSagittalFlat49LDown", parenRightPaddingAdjustment: -1 },
  accSagittalSharp11v19LUp: { code: "accSagittalSharp11v19LUp", parenRightPaddingAdjustment: -1 },
  accSagittalFlat11v19LDown: { code: "accSagittalFlat11v19LDown", parenRightPaddingAdjustment: -1 },
  accSagittalSharp5v13LUp: { code: "accSagittalSharp5v13LUp", parenRightPaddingAdjustment: -1 },
  accSagittalFlat5v13LDown: { code: "accSagittalFlat5v13LDown", parenRightPaddingAdjustment: -1 },
  accSagittalDoubleSharp23SDown: { code: "accSagittalDoubleSharp23SDown", parenRightPaddingAdjustment: -1 },
  accSagittalDoubleFlat23SUp: { code: "accSagittalDoubleFlat23SUp", parenRightPaddingAdjustment: -1 },
  accSagittalDoubleSharp49SDown: { code: "accSagittalDoubleSharp49SDown", parenRightPaddingAdjustment: -1 },
  accSagittalDoubleFlat49SUp: { code: "accSagittalDoubleFlat49SUp", parenRightPaddingAdjustment: -1 },
  accSagittalDoubleSharp7v19CDown: { code: "accSagittalDoubleSharp7v19CDown", parenRightPaddingAdjustment: -1 },
  accSagittalDoubleFlat7v19CUp: { code: "accSagittalDoubleFlat7v19CUp", parenRightPaddingAdjustment: -1 },
  accSagittalDoubleSharp19CDown: { code: "accSagittalDoubleSharp19CDown", parenRightPaddingAdjustment: -1 },
  accSagittalDoubleFlat19CUp: { code: "accSagittalDoubleFlat19CUp", parenRightPaddingAdjustment: -1 },
  accSagittalDoubleSharp11v49CDown: { code: "accSagittalDoubleSharp11v49CDown", parenRightPaddingAdjustment: -1 },
  accSagittalDoubleFlat11v49CUp: { code: "accSagittalDoubleFlat11v49CUp", parenRightPaddingAdjustment: -1 },
  accSagittalDoubleSharp143CDown: { code: "accSagittalDoubleSharp143CDown", parenRightPaddingAdjustment: -1 },
  accSagittalDoubleFlat143CUp: { code: "accSagittalDoubleFlat143CUp", parenRightPaddingAdjustment: -1 },
  accSagittalDoubleSharp17kDown: { code: "accSagittalDoubleSharp17kDown", parenRightPaddingAdjustment: -1 },
  accSagittalDoubleFlat17kUp: { code: "accSagittalDoubleFlat17kUp", parenRightPaddingAdjustment: -1 },
  accSagittalDoubleSharp19sDown: { code: "accSagittalDoubleSharp19sDown", parenRightPaddingAdjustment: -1 },
  accSagittalDoubleFlat19sUp: { code: "accSagittalDoubleFlat19sUp", parenRightPaddingAdjustment: -1 },
  accSagittalShaftUp: { code: "accSagittalShaftUp", parenRightPaddingAdjustment: -1 },
  accSagittalShaftDown: { code: "accSagittalShaftDown", parenRightPaddingAdjustment: -1 },
  accSagittalAcute: { code: "accSagittalAcute", parenRightPaddingAdjustment: -1 },
  accSagittalGrave: { code: "accSagittalGrave", parenRightPaddingAdjustment: -1 },
  accSagittal1MinaUp: { code: "accSagittal1MinaUp", parenRightPaddingAdjustment: -1 },
  accSagittal1MinaDown: { code: "accSagittal1MinaDown", parenRightPaddingAdjustment: -1 },
  accSagittal2MinasUp: { code: "accSagittal2MinasUp", parenRightPaddingAdjustment: -1 },
  accSagittal2MinasDown: { code: "accSagittal2MinasDown", parenRightPaddingAdjustment: -1 },
  accSagittal1TinaUp: { code: "accSagittal1TinaUp", parenRightPaddingAdjustment: -1 },
  accSagittal1TinaDown: { code: "accSagittal1TinaDown", parenRightPaddingAdjustment: -1 },
  accSagittal2TinasUp: { code: "accSagittal2TinasUp", parenRightPaddingAdjustment: -1 },
  accSagittal2TinasDown: { code: "accSagittal2TinasDown", parenRightPaddingAdjustment: -1 },
  accSagittal3TinasUp: { code: "accSagittal3TinasUp", parenRightPaddingAdjustment: -1 },
  accSagittal3TinasDown: { code: "accSagittal3TinasDown", parenRightPaddingAdjustment: -1 },
  accSagittal4TinasUp: { code: "accSagittal4TinasUp", parenRightPaddingAdjustment: -1 },
  accSagittal4TinasDown: { code: "accSagittal4TinasDown", parenRightPaddingAdjustment: -1 },
  accSagittal5TinasUp: { code: "accSagittal5TinasUp", parenRightPaddingAdjustment: -1 },
  accSagittal5TinasDown: { code: "accSagittal5TinasDown", parenRightPaddingAdjustment: -1 },
  accSagittal6TinasUp: { code: "accSagittal6TinasUp", parenRightPaddingAdjustment: -1 },
  accSagittal6TinasDown: { code: "accSagittal6TinasDown", parenRightPaddingAdjustment: -1 },
  accSagittal7TinasUp: { code: "accSagittal7TinasUp", parenRightPaddingAdjustment: -1 },
  accSagittal7TinasDown: { code: "accSagittal7TinasDown", parenRightPaddingAdjustment: -1 },
  accSagittal8TinasUp: { code: "accSagittal8TinasUp", parenRightPaddingAdjustment: -1 },
  accSagittal8TinasDown: { code: "accSagittal8TinasDown", parenRightPaddingAdjustment: -1 },
  accSagittal9TinasUp: { code: "accSagittal9TinasUp", parenRightPaddingAdjustment: -1 },
  accSagittal9TinasDown: { code: "accSagittal9TinasDown", parenRightPaddingAdjustment: -1 },
  accSagittalFractionalTinaUp: { code: "accSagittalFractionalTinaUp", parenRightPaddingAdjustment: -1 },
  accSagittalFractionalTinaDown: { code: "accSagittalFractionalTinaDown", parenRightPaddingAdjustment: -1 },
  accidentalNarrowReversedFlat: { code: "accidentalNarrowReversedFlat", parenRightPaddingAdjustment: -1 },
  accidentalNarrowReversedFlatAndFlat: {
    code: "accidentalNarrowReversedFlatAndFlat",
    parenRightPaddingAdjustment: -1
  },
  accidentalWilsonPlus: { code: "accidentalWilsonPlus", parenRightPaddingAdjustment: -1 },
  accidentalWilsonMinus: { code: "accidentalWilsonMinus", parenRightPaddingAdjustment: -1 }
};
var accidentalColumns = {
  1: {
    a: [1],
    b: [1]
  },
  2: {
    a: [1, 2]
  },
  3: {
    a: [1, 3, 2],
    b: [1, 2, 1],
    second_on_bottom: [1, 2, 3]
  },
  4: {
    a: [1, 3, 4, 2],
    b: [1, 2, 3, 1],
    spaced_out_tetrachord: [1, 2, 1, 2]
  },
  5: {
    a: [1, 3, 5, 4, 2],
    b: [1, 2, 4, 3, 1],
    spaced_out_pentachord: [1, 2, 3, 2, 1],
    very_spaced_out_pentachord: [1, 2, 1, 2, 1]
  },
  6: {
    a: [1, 3, 5, 6, 4, 2],
    b: [1, 2, 4, 5, 3, 1],
    spaced_out_hexachord: [1, 3, 2, 1, 3, 2],
    very_spaced_out_hexachord: [1, 2, 1, 2, 1, 2]
  }
};
var articulations = {
  "a.": { code: "augmentationDot", between_lines: true },
  av: {
    aboveCode: "articStaccatissimoAbove",
    belowCode: "articStaccatissimoBelow",
    between_lines: true
  },
  "a>": {
    aboveCode: "articAccentAbove",
    belowCode: "articAccentBelow",
    between_lines: true
  },
  "a-": {
    aboveCode: "articTenutoAbove",
    belowCode: "articTenutoBelow",
    between_lines: true
  },
  "a^": {
    aboveCode: "articMarcatoAbove",
    belowCode: "articMarcatoBelow",
    between_lines: false
  },
  "a+": { code: "pluckedLeftHandPizzicato", between_lines: false },
  ao: {
    aboveCode: "pluckedSnapPizzicatoAbove",
    belowCode: "pluckedSnapPizzicatoBelow",
    between_lines: false
  },
  ah: { code: "stringsHarmonic", between_lines: false },
  "a@": { aboveCode: "fermataAbove", belowCode: "fermataBelow", between_lines: false },
  "a@a": { code: "fermataAbove", between_lines: false },
  "a@u": { code: "fermataBelow", between_lines: false },
  "a@s": { aboveCode: "fermataShortAbove", belowCode: "fermataShortBelow", between_lines: false },
  "a@as": { code: "fermataShortAbove", between_lines: false },
  "a@us": { code: "fermataShortBelow", between_lines: false },
  "a@l": { aboveCode: "fermataLongAbove", belowCode: "fermataLongBelow", between_lines: false },
  "a@al": { code: "fermataLongAbove", between_lines: false },
  "a@ul": { code: "fermataLongBelow", between_lines: false },
  "a@vl": { aboveCode: "fermataVeryLongAbove", belowCode: "fermataVeryLongBelow", between_lines: false },
  "a@avl": { code: "fermataVeryLongAbove", between_lines: false },
  "a@uvl": { code: "fermataVeryLongBelow", between_lines: false },
  "a|": { code: "stringsUpBow", between_lines: false },
  am: { code: "stringsDownBow", between_lines: false },
  "a,": { code: "pictChokeCymbal", between_lines: false }
};
var ornaments = {
  mordent: { code: "ornamentShortTrill" },
  mordent_inverted: { code: "ornamentMordent" },
  turn: { code: "ornamentTurn" },
  turn_inverted: { code: "ornamentTurnSlash" },
  tr: { code: "ornamentTrill" },
  upprall: { code: "ornamentPrecompSlideTrillDAnglebert" },
  downprall: { code: "ornamentPrecompDoubleCadenceUpperPrefix" },
  prallup: { code: "ornamentPrecompTrillSuffixDandrieu" },
  pralldown: { code: "ornamentPrecompTrillLowerSuffix" },
  upmordent: { code: "ornamentPrecompSlideTrillBach" },
  downmordent: { code: "ornamentPrecompDoubleCadenceUpperPrefixTurn" },
  lineprall: { code: "ornamentPrecompAppoggTrill" },
  prallprall: { code: "ornamentTremblement" },
  scoop: { code: "brassScoop" },
  doit: { code: "brassDoitMedium" },
  fall: { code: "brassFallLipShort" },
  doitLong: { code: "brassLiftMedium" },
  fallLong: { code: "brassFallRoughMedium" },
  bend: { code: "brassBend" },
  plungerClosed: { code: "brassMuteClosed" },
  plungerOpen: { code: "brassMuteOpen" },
  flip: { code: "brassFlip" },
  jazzTurn: { code: "brassJazzTurn" },
  smear: { code: "brassSmear" }
};
var Tables = class _Tables {
  static currentMusicFont() {
    if (_Tables.MUSIC_FONT_STACK.length === 0) {
      throw new RuntimeError("NoFonts", "The font stack is empty. See: await Flow.fetchMusicFont(...); Flow.setMusicFont(...).");
    } else {
      return _Tables.MUSIC_FONT_STACK[0];
    }
  }
  static clefProperties(clef) {
    if (!clef || !(clef in clefs))
      throw new RuntimeError("BadArgument", "Invalid clef: " + clef);
    return clefs[clef];
  }
  static keyProperties(keyOctaveGlyph, clef = "treble", params) {
    let options = { octave_shift: 0, duration: "4" };
    if (typeof params === "object") {
      options = Object.assign(Object.assign({}, options), params);
    }
    const duration = _Tables.sanitizeDuration(options.duration);
    const pieces = keyOctaveGlyph.split("/");
    if (pieces.length < 2) {
      throw new RuntimeError("BadArguments", `First argument must be note/octave or note/octave/glyph-code: ${keyOctaveGlyph}`);
    }
    const key = pieces[0].toUpperCase();
    const value = notesInfo[key];
    if (!value)
      throw new RuntimeError("BadArguments", "Invalid key name: " + key);
    if (value.octave)
      pieces[1] = value.octave.toString();
    let octave = parseInt(pieces[1], 10);
    octave += -1 * options.octave_shift;
    const baseIndex = octave * 7 - 4 * 7;
    let line = (baseIndex + value.index) / 2;
    line += _Tables.clefProperties(clef).line_shift;
    let stroke = 0;
    if (line <= 0 && line * 2 % 2 === 0)
      stroke = 1;
    if (line >= 6 && line * 2 % 2 === 0)
      stroke = -1;
    const int_value = typeof value.int_val !== "undefined" ? octave * 12 + value.int_val : void 0;
    const code = value.code;
    const shift_right = value.shift_right;
    let customNoteHeadProps = {};
    if (pieces.length > 2 && pieces[2]) {
      const glyphName = pieces[2].toUpperCase();
      customNoteHeadProps = { code: this.codeNoteHead(glyphName, duration) };
    }
    return Object.assign({
      key,
      octave,
      line,
      int_value,
      accidental: value.accidental,
      code,
      stroke,
      shift_right,
      displaced: false
    }, customNoteHeadProps);
  }
  static integerToNote(integer) {
    if (typeof integer === "undefined" || integer < 0 || integer > 11) {
      throw new RuntimeError("BadArguments", `integerToNote() requires an integer in the range [0, 11]: ${integer}`);
    }
    const table = {
      0: "C",
      1: "C#",
      2: "D",
      3: "D#",
      4: "E",
      5: "F",
      6: "F#",
      7: "G",
      8: "G#",
      9: "A",
      10: "A#",
      11: "B"
    };
    const noteValue = table[integer];
    if (!noteValue) {
      throw new RuntimeError("BadArguments", `Unknown note value for integer: ${integer}`);
    }
    return noteValue;
  }
  static tabToGlyphProps(fret, scale = 1) {
    let glyph = void 0;
    let width = 0;
    let shift_y = 0;
    if (fret.toUpperCase() === "X") {
      const glyphMetrics = new Glyph("accidentalDoubleSharp", _Tables.TABLATURE_FONT_SCALE).getMetrics();
      glyph = "accidentalDoubleSharp";
      if (glyphMetrics.width == void 0 || glyphMetrics.height == void 0)
        throw new RuntimeError("InvalidMetrics", "Width and height required");
      width = glyphMetrics.width;
      shift_y = -glyphMetrics.height / 2;
    } else {
      width = _Tables.textWidth(fret);
    }
    return {
      text: fret,
      code: glyph,
      getWidth: () => width * scale,
      shift_y
    };
  }
  static textWidth(text) {
    return 7 * text.toString().length;
  }
  static articulationCodes(artic) {
    return articulations[artic];
  }
  static accidentalCodes(acc) {
    return accidentals[acc];
  }
  static ornamentCodes(acc) {
    return ornaments[acc];
  }
  static keySignature(spec) {
    const keySpec = keySignatures[spec];
    if (!keySpec) {
      throw new RuntimeError("BadKeySignature", `Bad key signature spec: '${spec}'`);
    }
    if (!keySpec.acc) {
      return [];
    }
    const accidentalList = {
      b: [2, 0.5, 2.5, 1, 3, 1.5, 3.5],
      "#": [0, 1.5, -0.5, 1, 2.5, 0.5, 2]
    };
    const notes = accidentalList[keySpec.acc];
    const acc_list = [];
    for (let i = 0; i < keySpec.num; ++i) {
      const line = notes[i];
      acc_list.push({ type: keySpec.acc, line });
    }
    return acc_list;
  }
  static getKeySignatures() {
    return keySignatures;
  }
  static hasKeySignature(spec) {
    return spec in keySignatures;
  }
  static sanitizeDuration(duration) {
    const durationNumber = durationAliases[duration];
    if (durationNumber !== void 0) {
      duration = durationNumber;
    }
    if (durations[duration] === void 0) {
      throw new RuntimeError("BadArguments", `The provided duration is not valid: ${duration}`);
    }
    return duration;
  }
  static durationToFraction(duration) {
    return new Fraction().parse(_Tables.sanitizeDuration(duration));
  }
  static durationToNumber(duration) {
    return _Tables.durationToFraction(duration).value();
  }
  static durationToTicks(duration) {
    duration = _Tables.sanitizeDuration(duration);
    const ticks = durations[duration];
    if (ticks === void 0) {
      throw new RuntimeError("InvalidDuration");
    }
    return ticks;
  }
  static codeNoteHead(type, duration) {
    let code = "";
    switch (type) {
      case "D0":
        code = "noteheadDiamondWhole";
        break;
      case "D1":
        code = "noteheadDiamondHalf";
        break;
      case "D2":
        code = "noteheadDiamondBlack";
        break;
      case "D3":
        code = "noteheadDiamondBlack";
        break;
      case "T0":
        code = "noteheadTriangleUpWhole";
        break;
      case "T1":
        code = "noteheadTriangleUpHalf";
        break;
      case "T2":
        code = "noteheadTriangleUpBlack";
        break;
      case "T3":
        code = "noteheadTriangleUpBlack";
        break;
      case "X0":
        code = "noteheadXWhole";
        break;
      case "X1":
        code = "noteheadXHalf";
        break;
      case "X2":
        code = "noteheadXBlack";
        break;
      case "X3":
        code = "noteheadCircleX";
        break;
      case "S1":
        code = "noteheadSquareWhite";
        break;
      case "S2":
        code = "noteheadSquareBlack";
        break;
      case "R1":
        code = "vexNoteHeadRectWhite";
        break;
      case "R2":
        code = "vexNoteHeadRectBlack";
        break;
      case "DO":
        code = "noteheadTriangleUpBlack";
        break;
      case "RE":
        code = "noteheadMoonBlack";
        break;
      case "MI":
        code = "noteheadDiamondBlack";
        break;
      case "FA":
        code = "noteheadTriangleLeftBlack";
        break;
      case "FAUP":
        code = "noteheadTriangleRightBlack";
        break;
      case "SO":
        code = "noteheadBlack";
        break;
      case "LA":
        code = "noteheadSquareBlack";
        break;
      case "TI":
        code = "noteheadTriangleRoundDownBlack";
        break;
      case "D":
      case "H":
        switch (duration) {
          case "1/2":
            code = "noteheadDiamondDoubleWhole";
            break;
          case "1":
            code = "noteheadDiamondWhole";
            break;
          case "2":
            code = "noteheadDiamondHalf";
            break;
          default:
            code = "noteheadDiamondBlack";
            break;
        }
        break;
      case "N":
      case "G":
        switch (duration) {
          case "1/2":
            code = "noteheadDoubleWhole";
            break;
          case "1":
            code = "noteheadWhole";
            break;
          case "2":
            code = "noteheadHalf";
            break;
          default:
            code = "noteheadBlack";
            break;
        }
        break;
      case "M":
      case "X":
        switch (duration) {
          case "1/2":
            code = "noteheadXDoubleWhole";
            break;
          case "1":
            code = "noteheadXWhole";
            break;
          case "2":
            code = "noteheadXHalf";
            break;
          default:
            code = "noteheadXBlack";
            break;
        }
        break;
      case "CX":
        switch (duration) {
          case "1/2":
            code = "noteheadCircleXDoubleWhole";
            break;
          case "1":
            code = "noteheadCircleXWhole";
            break;
          case "2":
            code = "noteheadCircleXHalf";
            break;
          default:
            code = "noteheadCircleX";
            break;
        }
        break;
      case "CI":
        switch (duration) {
          case "1/2":
            code = "noteheadCircledDoubleWhole";
            break;
          case "1":
            code = "noteheadCircledWhole";
            break;
          case "2":
            code = "noteheadCircledHalf";
            break;
          default:
            code = "noteheadCircledBlack";
            break;
        }
        break;
      case "SQ":
        switch (duration) {
          case "1/2":
            code = "noteheadDoubleWholeSquare";
            break;
          case "1":
            code = "noteheadSquareWhite";
            break;
          case "2":
            code = "noteheadSquareWhite";
            break;
          default:
            code = "noteheadSquareBlack";
            break;
        }
        break;
      case "TU":
        switch (duration) {
          case "1/2":
            code = "noteheadTriangleUpDoubleWhole";
            break;
          case "1":
            code = "noteheadTriangleUpWhole";
            break;
          case "2":
            code = "noteheadTriangleUpHalf";
            break;
          default:
            code = "noteheadTriangleUpBlack";
            break;
        }
        break;
      case "TD":
        switch (duration) {
          case "1/2":
            code = "noteheadTriangleDownDoubleWhole";
            break;
          case "1":
            code = "noteheadTriangleDownWhole";
            break;
          case "2":
            code = "noteheadTriangleDownHalf";
            break;
          default:
            code = "noteheadTriangleDownBlack";
            break;
        }
        break;
      case "SF":
        switch (duration) {
          case "1/2":
            code = "noteheadSlashedDoubleWhole1";
            break;
          case "1":
            code = "noteheadSlashedWhole1";
            break;
          case "2":
            code = "noteheadSlashedHalf1";
            break;
          default:
            code = "noteheadSlashedBlack1";
        }
        break;
      case "SB":
        switch (duration) {
          case "1/2":
            code = "noteheadSlashedDoubleWhole2";
            break;
          case "1":
            code = "noteheadSlashedWhole2";
            break;
          case "2":
            code = "noteheadSlashedHalf2";
            break;
          default:
            code = "noteheadSlashedBlack2";
        }
        break;
    }
    return code;
  }
  static getGlyphProps(duration, type = "n") {
    duration = _Tables.sanitizeDuration(duration);
    let code = durationCodes[duration];
    if (code === void 0) {
      code = durationCodes["4"];
    }
    let glyphTypeProperties = code[type];
    const codeNoteHead = _Tables.codeNoteHead(type.toUpperCase(), duration);
    if (codeNoteHead != "")
      glyphTypeProperties = Object.assign(Object.assign({}, glyphTypeProperties), { code_head: codeNoteHead, code: codeNoteHead });
    const code_head = glyphTypeProperties.code_head;
    const getWidth = (scale = _Tables.NOTATION_FONT_SCALE) => Glyph.getWidth(code_head, scale);
    return Object.assign(Object.assign(Object.assign({}, code.common), { getWidth }), glyphTypeProperties);
  }
};
Tables.UNISON = true;
Tables.SOFTMAX_FACTOR = 10;
Tables.STEM_WIDTH = 1.5;
Tables.STEM_HEIGHT = 35;
Tables.STAVE_LINE_THICKNESS = 1;
Tables.RENDER_PRECISION_PLACES = 3;
Tables.RESOLUTION = RESOLUTION;
Tables.MUSIC_FONT_STACK = [];
Tables.NOTATION_FONT_SCALE = 39;
Tables.TABLATURE_FONT_SCALE = 39;
Tables.SLASH_NOTEHEAD_WIDTH = 15;
Tables.STAVE_LINE_DISTANCE = 10;
Tables.TEXT_HEIGHT_OFFSET_HACK = 1;
Tables.accidentalMap = accidentals;
Tables.accidentalColumnsTable = accidentalColumns;
Tables.unicode = {
  sharp: String.fromCharCode(9839),
  flat: String.fromCharCode(9837),
  natural: String.fromCharCode(9838),
  triangle: String.fromCharCode(9651),
  "o-with-slash": String.fromCharCode(248),
  degrees: String.fromCharCode(176),
  circle: String.fromCharCode(9675)
};
Tables.validTypes = validNoteTypes;
Tables.TIME4_4 = {
  num_beats: 4,
  beat_value: 4,
  resolution: RESOLUTION
};
var durationCodes = {
  "1/2": {
    common: {
      code_head: "",
      stem: false,
      flag: false,
      stem_up_extension: -Tables.STEM_HEIGHT,
      stem_down_extension: -Tables.STEM_HEIGHT,
      tabnote_stem_up_extension: -Tables.STEM_HEIGHT,
      tabnote_stem_down_extension: -Tables.STEM_HEIGHT,
      dot_shiftY: 0,
      line_above: 0,
      line_below: 0
    },
    r: {
      code_head: "restDoubleWhole",
      rest: true,
      position: "B/5",
      dot_shiftY: 0.5
    },
    s: {
      getWidth: () => Tables.SLASH_NOTEHEAD_WIDTH,
      position: "B/4"
    }
  },
  1: {
    common: {
      code_head: "",
      stem: false,
      flag: false,
      stem_up_extension: -Tables.STEM_HEIGHT,
      stem_down_extension: -Tables.STEM_HEIGHT,
      tabnote_stem_up_extension: -Tables.STEM_HEIGHT,
      tabnote_stem_down_extension: -Tables.STEM_HEIGHT,
      dot_shiftY: 0,
      line_above: 0,
      line_below: 0
    },
    r: {
      code_head: "restWhole",
      ledger_code_head: "restWholeLegerLine",
      rest: true,
      position: "D/5",
      dot_shiftY: 0.5
    },
    s: {
      getWidth: () => Tables.SLASH_NOTEHEAD_WIDTH,
      position: "B/4"
    }
  },
  2: {
    common: {
      code_head: "",
      stem: true,
      flag: false,
      stem_up_extension: 0,
      stem_down_extension: 0,
      tabnote_stem_up_extension: 0,
      tabnote_stem_down_extension: 0,
      dot_shiftY: 0,
      line_above: 0,
      line_below: 0
    },
    r: {
      code_head: "restHalf",
      ledger_code_head: "restHalfLegerLine",
      stem: false,
      rest: true,
      position: "B/4",
      dot_shiftY: -0.5
    },
    s: {
      getWidth: () => Tables.SLASH_NOTEHEAD_WIDTH,
      position: "B/4"
    }
  },
  4: {
    common: {
      code_head: "",
      stem: true,
      flag: false,
      stem_up_extension: 0,
      stem_down_extension: 0,
      tabnote_stem_up_extension: 0,
      tabnote_stem_down_extension: 0,
      dot_shiftY: 0,
      line_above: 0,
      line_below: 0
    },
    r: {
      code_head: "restQuarter",
      stem: false,
      rest: true,
      position: "B/4",
      dot_shiftY: -0.5,
      line_above: 1.5,
      line_below: 1.5
    },
    s: {
      getWidth: () => Tables.SLASH_NOTEHEAD_WIDTH,
      position: "B/4"
    }
  },
  8: {
    common: {
      code_head: "",
      stem: true,
      flag: true,
      beam_count: 1,
      stem_beam_extension: 0,
      code_flag_upstem: "flag8thUp",
      code_flag_downstem: "flag8thDown",
      stem_up_extension: 0,
      stem_down_extension: 0,
      tabnote_stem_up_extension: 0,
      tabnote_stem_down_extension: 0,
      dot_shiftY: 0,
      line_above: 0,
      line_below: 0
    },
    r: {
      code_head: "rest8th",
      stem: false,
      flag: false,
      rest: true,
      position: "B/4",
      dot_shiftY: -0.5,
      line_above: 1,
      line_below: 1
    },
    s: {
      getWidth: () => Tables.SLASH_NOTEHEAD_WIDTH,
      position: "B/4"
    }
  },
  16: {
    common: {
      code_head: "",
      beam_count: 2,
      stem_beam_extension: 0,
      stem: true,
      flag: true,
      code_flag_upstem: "flag16thUp",
      code_flag_downstem: "flag16thDown",
      stem_up_extension: 0,
      stem_down_extension: 0,
      tabnote_stem_up_extension: 0,
      tabnote_stem_down_extension: 0,
      dot_shiftY: 0,
      line_above: 0,
      line_below: 0
    },
    r: {
      code_head: "rest16th",
      stem: false,
      flag: false,
      rest: true,
      position: "B/4",
      dot_shiftY: -0.5,
      line_above: 1,
      line_below: 2
    },
    s: {
      getWidth: () => Tables.SLASH_NOTEHEAD_WIDTH,
      position: "B/4"
    }
  },
  32: {
    common: {
      code_head: "",
      beam_count: 3,
      stem_beam_extension: 7.5,
      stem: true,
      flag: true,
      code_flag_upstem: "flag32ndUp",
      code_flag_downstem: "flag32ndDown",
      stem_up_extension: 9,
      stem_down_extension: 9,
      tabnote_stem_up_extension: 9,
      tabnote_stem_down_extension: 9,
      dot_shiftY: 0,
      line_above: 0,
      line_below: 0
    },
    r: {
      code_head: "rest32nd",
      stem: false,
      flag: false,
      rest: true,
      position: "B/4",
      dot_shiftY: -1.5,
      line_above: 2,
      line_below: 2
    },
    s: {
      getWidth: () => Tables.SLASH_NOTEHEAD_WIDTH,
      position: "B/4"
    }
  },
  64: {
    common: {
      code_head: "",
      beam_count: 4,
      stem_beam_extension: 15,
      stem: true,
      flag: true,
      code_flag_upstem: "flag64thUp",
      code_flag_downstem: "flag64thDown",
      stem_up_extension: 13,
      stem_down_extension: 13,
      tabnote_stem_up_extension: 13,
      tabnote_stem_down_extension: 13,
      dot_shiftY: 0,
      line_above: 0,
      line_below: 0
    },
    r: {
      code_head: "rest64th",
      stem: false,
      flag: false,
      rest: true,
      position: "B/4",
      dot_shiftY: -1.5,
      line_above: 2,
      line_below: 3
    },
    s: {
      getWidth: () => Tables.SLASH_NOTEHEAD_WIDTH,
      position: "B/4"
    }
  },
  128: {
    common: {
      code_head: "",
      beam_count: 5,
      stem_beam_extension: 22.5,
      stem: true,
      flag: true,
      code_flag_upstem: "flag128thUp",
      code_flag_downstem: "flag128thDown",
      stem_up_extension: 22,
      stem_down_extension: 22,
      tabnote_stem_up_extension: 22,
      tabnote_stem_down_extension: 22,
      dot_shiftY: 0,
      line_above: 0,
      line_below: 0
    },
    r: {
      code_head: "rest128th",
      stem: false,
      flag: false,
      rest: true,
      position: "B/4",
      dot_shiftY: -2.5,
      line_above: 3,
      line_below: 3
    },
    s: {
      getWidth: () => Tables.SLASH_NOTEHEAD_WIDTH,
      position: "B/4"
    }
  }
};

// node_modules/vexflow/build/esm/src/glyph.js
var GlyphCacheEntry = class {
  constructor(fontStack, code, category) {
    this.point = -1;
    this.metrics = Glyph.loadMetrics(fontStack, code, category);
    this.bbox = Glyph.getOutlineBoundingBox(this.metrics.outline, this.metrics.scale, this.metrics.x_shift, this.metrics.y_shift);
    if (category) {
      this.point = Glyph.lookupFontMetric(this.metrics.font, category, code, "point", -1);
    }
  }
};
var GlyphCache = class {
  constructor() {
    this.cache = /* @__PURE__ */ new Map();
  }
  lookup(code, category) {
    let entries = this.cache.get(Glyph.CURRENT_CACHE_KEY);
    if (entries === void 0) {
      entries = {};
      this.cache.set(Glyph.CURRENT_CACHE_KEY, entries);
    }
    const key = category ? `${code}%${category}` : code;
    let entry = entries[key];
    if (entry === void 0) {
      entry = new GlyphCacheEntry(Glyph.MUSIC_FONT_STACK, code, category);
      entries[key] = entry;
    }
    return entry;
  }
};
var GlyphOutline = class {
  constructor(outline, originX, originY, scale) {
    this.outline = outline;
    this.originX = originX;
    this.originY = originY;
    this.scale = scale;
    this.i = 0;
    this.precision = 1;
    this.precision = Math.pow(10, Tables.RENDER_PRECISION_PLACES);
  }
  done() {
    return this.i >= this.outline.length;
  }
  next() {
    return Math.round(this.outline[this.i++] * this.precision / this.precision);
  }
  nextX() {
    return Math.round((this.originX + this.outline[this.i++] * this.scale) * this.precision) / this.precision;
  }
  nextY() {
    return Math.round((this.originY - this.outline[this.i++] * this.scale) * this.precision) / this.precision;
  }
  static parse(str) {
    const result = [];
    const parts = str.split(" ");
    let i = 0;
    while (i < parts.length) {
      switch (parts[i++]) {
        case "m":
          result.push(0, parseInt(parts[i++]), parseInt(parts[i++]));
          break;
        case "l":
          result.push(1, parseInt(parts[i++]), parseInt(parts[i++]));
          break;
        case "q":
          result.push(2, parseInt(parts[i++]), parseInt(parts[i++]), parseInt(parts[i++]), parseInt(parts[i++]));
          break;
        case "b":
          result.push(3, parseInt(parts[i++]), parseInt(parts[i++]), parseInt(parts[i++]), parseInt(parts[i++]), parseInt(parts[i++]), parseInt(parts[i++]));
          break;
      }
    }
    return result;
  }
};
var Glyph = class _Glyph extends Element {
  static get CATEGORY() {
    return "Glyph";
  }
  static lookupFontMetric(font, category, code, key, defaultValue) {
    let value = font.lookupMetric(`glyphs.${category}.${code}.${key}`, void 0);
    if (value === void 0) {
      value = font.lookupMetric(`glyphs.${category}.${key}`, defaultValue);
    }
    return value;
  }
  static lookupGlyph(fontStack, code) {
    defined(fontStack, "BadFontStack", "Font stack is misconfigured");
    let glyph;
    let font;
    for (let i = 0; i < fontStack.length; i++) {
      font = fontStack[i];
      glyph = font.getGlyphs()[code];
      if (glyph)
        return { glyph, font };
    }
    throw new RuntimeError("BadGlyph", `Glyph ${code} does not exist in font.`);
  }
  static loadMetrics(fontStack, code, category) {
    const { glyph, font } = _Glyph.lookupGlyph(fontStack, code);
    if (!glyph.o)
      throw new RuntimeError("BadGlyph", `Glyph ${code} has no outline defined.`);
    let x_shift = 0;
    let y_shift = 0;
    let scale = 1;
    if (category && font) {
      x_shift = _Glyph.lookupFontMetric(font, category, code, "shiftX", 0);
      y_shift = _Glyph.lookupFontMetric(font, category, code, "shiftY", 0);
      scale = _Glyph.lookupFontMetric(font, category, code, "scale", 1);
    }
    const x_min = glyph.x_min;
    const x_max = glyph.x_max;
    const ha = glyph.ha;
    if (!glyph.cached_outline) {
      glyph.cached_outline = GlyphOutline.parse(glyph.o);
    }
    return {
      x_min,
      x_max,
      x_shift,
      y_shift,
      scale,
      ha,
      outline: glyph.cached_outline,
      font,
      width: x_max - x_min,
      height: ha
    };
  }
  static renderGlyph(ctx, x_pos, y_pos, point, code, options) {
    var _a;
    const data = _Glyph.cache.lookup(code, options === null || options === void 0 ? void 0 : options.category);
    const metrics = data.metrics;
    if (data.point != -1) {
      point = data.point;
    }
    const customScale = (_a = options === null || options === void 0 ? void 0 : options.scale) !== null && _a !== void 0 ? _a : 1;
    const scale = point * 72 / (metrics.font.getResolution() * 100) * metrics.scale * customScale;
    _Glyph.renderOutline(ctx, metrics.outline, scale, x_pos + metrics.x_shift * customScale, y_pos + metrics.y_shift * customScale);
    return metrics;
  }
  static renderOutline(ctx, outline, scale, x_pos, y_pos) {
    const go = new GlyphOutline(outline, x_pos, y_pos, scale);
    ctx.beginPath();
    let x, y;
    while (!go.done()) {
      switch (go.next()) {
        case 0:
          ctx.moveTo(go.nextX(), go.nextY());
          break;
        case 1:
          ctx.lineTo(go.nextX(), go.nextY());
          break;
        case 2:
          x = go.nextX();
          y = go.nextY();
          ctx.quadraticCurveTo(go.nextX(), go.nextY(), x, y);
          break;
        case 3:
          x = go.nextX();
          y = go.nextY();
          ctx.bezierCurveTo(go.nextX(), go.nextY(), go.nextX(), go.nextY(), x, y);
          break;
      }
    }
    ctx.fill();
  }
  static getOutlineBoundingBox(outline, scale, x_pos, y_pos) {
    const go = new GlyphOutline(outline, x_pos, y_pos, scale);
    const bboxComp = new BoundingBoxComputation();
    let penX = x_pos;
    let penY = y_pos;
    let x, y;
    while (!go.done()) {
      switch (go.next()) {
        case 0:
          penX = go.nextX();
          penY = go.nextY();
          break;
        case 1:
          bboxComp.addPoint(penX, penY);
          penX = go.nextX();
          penY = go.nextY();
          bboxComp.addPoint(penX, penY);
          break;
        case 2:
          x = go.nextX();
          y = go.nextY();
          bboxComp.addQuadraticCurve(penX, penY, go.nextX(), go.nextY(), x, y);
          penX = x;
          penY = y;
          break;
        case 3:
          x = go.nextX();
          y = go.nextY();
          bboxComp.addBezierCurve(penX, penY, go.nextX(), go.nextY(), go.nextX(), go.nextY(), x, y);
          penX = x;
          penY = y;
          break;
      }
    }
    return new BoundingBox(bboxComp.getX1(), bboxComp.getY1(), bboxComp.width(), bboxComp.height());
  }
  static getWidth(code, point, category) {
    const data = _Glyph.cache.lookup(code, category);
    if (data.point != -1) {
      point = data.point;
    }
    const scale = point * 72 / (data.metrics.font.getResolution() * 100);
    return data.bbox.getW() * scale;
  }
  constructor(code, point, options) {
    super();
    this.bbox = new BoundingBox(0, 0, 0, 0);
    this.topGlyphs = [];
    this.botGlyphs = [];
    this.options = {};
    this.scale = 1;
    this.code = code;
    this.point = point;
    this.originShift = { x: 0, y: 0 };
    this.x_shift = 0;
    this.y_shift = 0;
    if (options) {
      this.setOptions(options);
    } else {
      this.reset();
    }
  }
  draw(...args) {
  }
  getCode() {
    return this.code;
  }
  setOptions(options) {
    this.options = Object.assign(Object.assign({}, this.options), options);
    this.reset();
  }
  setPoint(point) {
    this.point = point;
    return this;
  }
  setStave(stave) {
    this.stave = stave;
    return this;
  }
  getXShift() {
    return this.x_shift;
  }
  setXShift(x_shift) {
    this.x_shift = x_shift;
    return this;
  }
  getYshift() {
    return this.y_shift;
  }
  setYShift(y_shift) {
    this.y_shift = y_shift;
    return this;
  }
  reset() {
    const data = _Glyph.cache.lookup(this.code, this.options.category);
    this.metrics = data.metrics;
    if (data.point != -1) {
      this.point = data.point;
    }
    this.scale = this.point * 72 / (this.metrics.font.getResolution() * 100);
    this.bbox = new BoundingBox(data.bbox.getX() * this.scale, data.bbox.getY() * this.scale, data.bbox.getW() * this.scale, data.bbox.getH() * this.scale);
  }
  checkMetrics() {
    return defined(this.metrics, "BadGlyph", `Glyph ${this.code} is not initialized.`);
  }
  getMetrics() {
    const metrics = this.checkMetrics();
    const metricsScale = metrics.scale;
    return {
      x_min: metrics.x_min * this.scale * metricsScale,
      x_max: metrics.x_max * this.scale * metricsScale,
      width: this.bbox.getW(),
      height: this.bbox.getH(),
      scale: this.scale * metricsScale,
      x_shift: metrics.x_shift,
      y_shift: metrics.y_shift,
      outline: metrics.outline,
      font: metrics.font,
      ha: metrics.ha
    };
  }
  setOriginX(x) {
    const { bbox } = this;
    const originX = Math.abs(bbox.getX() / bbox.getW());
    const xShift = (x - originX) * bbox.getW();
    this.originShift.x = -xShift;
  }
  setOriginY(y) {
    const { bbox } = this;
    const originY = Math.abs(bbox.getY() / bbox.getH());
    const yShift = (y - originY) * bbox.getH();
    this.originShift.y = -yShift;
  }
  setOrigin(x, y) {
    this.setOriginX(x);
    this.setOriginY(y);
  }
  render(ctx, x, y) {
    const metrics = this.checkMetrics();
    const outline = metrics.outline;
    const scale = this.scale * metrics.scale;
    this.setRendered();
    this.applyStyle(ctx);
    const xPos = x + this.originShift.x + metrics.x_shift;
    const yPos = y + this.originShift.y + metrics.y_shift;
    _Glyph.renderOutline(ctx, outline, scale, xPos, yPos);
    this.restoreStyle(ctx);
  }
  checkStave() {
    return defined(this.stave, "NoStave", "No stave attached to instance.");
  }
  renderToStave(x) {
    const context = this.checkContext();
    const metrics = this.checkMetrics();
    const stave = this.checkStave();
    const outline = metrics.outline;
    const scale = this.scale * metrics.scale;
    this.setRendered();
    this.applyStyle();
    const xPos = x + this.x_shift + metrics.x_shift;
    const yPos = stave.getYForGlyphs() + this.y_shift + metrics.y_shift;
    _Glyph.renderOutline(context, outline, scale, xPos, yPos);
    this.restoreStyle();
  }
};
Glyph.cache = new GlyphCache();
Glyph.CURRENT_CACHE_KEY = "";
Glyph.MUSIC_FONT_STACK = [];

// node_modules/vexflow/build/esm/src/modifier.js
var ModifierPosition;
(function(ModifierPosition2) {
  ModifierPosition2[ModifierPosition2["CENTER"] = 0] = "CENTER";
  ModifierPosition2[ModifierPosition2["LEFT"] = 1] = "LEFT";
  ModifierPosition2[ModifierPosition2["RIGHT"] = 2] = "RIGHT";
  ModifierPosition2[ModifierPosition2["ABOVE"] = 3] = "ABOVE";
  ModifierPosition2[ModifierPosition2["BELOW"] = 4] = "BELOW";
})(ModifierPosition || (ModifierPosition = {}));
var Modifier = class _Modifier extends Element {
  static get CATEGORY() {
    return "Modifier";
  }
  static get Position() {
    return ModifierPosition;
  }
  static get PositionString() {
    return {
      center: ModifierPosition.CENTER,
      above: ModifierPosition.ABOVE,
      below: ModifierPosition.BELOW,
      left: ModifierPosition.LEFT,
      right: ModifierPosition.RIGHT
    };
  }
  constructor() {
    super();
    this.width = 0;
    this.text_line = 0;
    this.position = _Modifier.Position.LEFT;
    this.x_shift = 0;
    this.y_shift = 0;
    this.spacingFromNextModifier = 0;
  }
  reset() {
  }
  getWidth() {
    return this.width;
  }
  setWidth(width) {
    this.width = width;
    return this;
  }
  getNote() {
    return defined(this.note, "NoNote", "Modifier has no note.");
  }
  checkAttachedNote() {
    const category = this.getCategory();
    defined(this.index, "NoIndex", `Can't draw ${category} without an index.`);
    return defined(this.note, "NoNote", `Can't draw ${category} without a note.`);
  }
  setNote(note) {
    this.note = note;
    return this;
  }
  getIndex() {
    return this.index;
  }
  checkIndex() {
    return defined(this.index, "NoIndex", "Modifier has an invalid index.");
  }
  setIndex(index) {
    this.index = index;
    return this;
  }
  getModifierContext() {
    return this.modifierContext;
  }
  checkModifierContext() {
    return defined(this.modifierContext, "NoModifierContext", "Modifier Context Required");
  }
  setModifierContext(c) {
    this.modifierContext = c;
    return this;
  }
  getPosition() {
    return this.position;
  }
  setPosition(position) {
    this.position = typeof position === "string" ? _Modifier.PositionString[position] : position;
    this.reset();
    return this;
  }
  setTextLine(line) {
    this.text_line = line;
    return this;
  }
  setYShift(y) {
    this.y_shift = y;
    return this;
  }
  setSpacingFromNextModifier(x) {
    this.spacingFromNextModifier = x;
  }
  getSpacingFromNextModifier() {
    return this.spacingFromNextModifier;
  }
  setXShift(x) {
    this.x_shift = 0;
    if (this.position === _Modifier.Position.LEFT) {
      this.x_shift -= x;
    } else {
      this.x_shift += x;
    }
    return this;
  }
  getXShift() {
    return this.x_shift;
  }
  draw() {
    this.checkContext();
    throw new RuntimeError("NotImplemented", "draw() not implemented for this modifier.");
  }
  alignSubNotesWithNote(subNotes, note) {
    const tickContext = note.getTickContext();
    const metrics = tickContext.getMetrics();
    const stave = note.getStave();
    const subNoteXOffset = tickContext.getX() - metrics.modLeftPx - metrics.modRightPx + this.getSpacingFromNextModifier();
    subNotes.forEach((subNote) => {
      const subTickContext = subNote.getTickContext();
      if (stave)
        subNote.setStave(stave);
      subTickContext.setXOffset(subNoteXOffset);
    });
  }
};

// node_modules/vexflow/build/esm/src/music.js
var Music = class _Music {
  static get NUM_TONES() {
    return this.canonical_notes.length;
  }
  static get roots() {
    return ["c", "d", "e", "f", "g", "a", "b"];
  }
  static get root_values() {
    return [0, 2, 4, 5, 7, 9, 11];
  }
  static get root_indices() {
    return {
      c: 0,
      d: 1,
      e: 2,
      f: 3,
      g: 4,
      a: 5,
      b: 6
    };
  }
  static get canonical_notes() {
    return ["c", "c#", "d", "d#", "e", "f", "f#", "g", "g#", "a", "a#", "b"];
  }
  static get diatonic_intervals() {
    return ["unison", "m2", "M2", "m3", "M3", "p4", "dim5", "p5", "m6", "M6", "b7", "M7", "octave"];
  }
  static get diatonic_accidentals() {
    return {
      unison: { note: 0, accidental: 0 },
      m2: { note: 1, accidental: -1 },
      M2: { note: 1, accidental: 0 },
      m3: { note: 2, accidental: -1 },
      M3: { note: 2, accidental: 0 },
      p4: { note: 3, accidental: 0 },
      dim5: { note: 4, accidental: -1 },
      p5: { note: 4, accidental: 0 },
      m6: { note: 5, accidental: -1 },
      M6: { note: 5, accidental: 0 },
      b7: { note: 6, accidental: -1 },
      M7: { note: 6, accidental: 0 },
      octave: { note: 7, accidental: 0 }
    };
  }
  static get intervals() {
    return {
      u: 0,
      unison: 0,
      m2: 1,
      b2: 1,
      min2: 1,
      S: 1,
      H: 1,
      2: 2,
      M2: 2,
      maj2: 2,
      T: 2,
      W: 2,
      m3: 3,
      b3: 3,
      min3: 3,
      M3: 4,
      3: 4,
      maj3: 4,
      4: 5,
      p4: 5,
      "#4": 6,
      b5: 6,
      aug4: 6,
      dim5: 6,
      5: 7,
      p5: 7,
      "#5": 8,
      b6: 8,
      aug5: 8,
      6: 9,
      M6: 9,
      maj6: 9,
      b7: 10,
      m7: 10,
      min7: 10,
      dom7: 10,
      M7: 11,
      maj7: 11,
      8: 12,
      octave: 12
    };
  }
  static get scales() {
    return {
      major: [2, 2, 1, 2, 2, 2, 1],
      minor: [2, 1, 2, 2, 1, 2, 2],
      ionian: [2, 2, 1, 2, 2, 2, 1],
      dorian: [2, 1, 2, 2, 2, 1, 2],
      phyrgian: [1, 2, 2, 2, 1, 2, 2],
      lydian: [2, 2, 2, 1, 2, 2, 1],
      mixolydian: [2, 2, 1, 2, 2, 1, 2],
      aeolian: [2, 1, 2, 2, 1, 2, 2],
      locrian: [1, 2, 2, 1, 2, 2, 2]
    };
  }
  static get scaleTypes() {
    return {
      M: _Music.scales.major,
      m: _Music.scales.minor
    };
  }
  static get accidentals() {
    return ["bb", "b", "n", "#", "##"];
  }
  static get noteValues() {
    return {
      c: { root_index: 0, int_val: 0 },
      cn: { root_index: 0, int_val: 0 },
      "c#": { root_index: 0, int_val: 1 },
      "c##": { root_index: 0, int_val: 2 },
      cb: { root_index: 0, int_val: 11 },
      cbb: { root_index: 0, int_val: 10 },
      d: { root_index: 1, int_val: 2 },
      dn: { root_index: 1, int_val: 2 },
      "d#": { root_index: 1, int_val: 3 },
      "d##": { root_index: 1, int_val: 4 },
      db: { root_index: 1, int_val: 1 },
      dbb: { root_index: 1, int_val: 0 },
      e: { root_index: 2, int_val: 4 },
      en: { root_index: 2, int_val: 4 },
      "e#": { root_index: 2, int_val: 5 },
      "e##": { root_index: 2, int_val: 6 },
      eb: { root_index: 2, int_val: 3 },
      ebb: { root_index: 2, int_val: 2 },
      f: { root_index: 3, int_val: 5 },
      fn: { root_index: 3, int_val: 5 },
      "f#": { root_index: 3, int_val: 6 },
      "f##": { root_index: 3, int_val: 7 },
      fb: { root_index: 3, int_val: 4 },
      fbb: { root_index: 3, int_val: 3 },
      g: { root_index: 4, int_val: 7 },
      gn: { root_index: 4, int_val: 7 },
      "g#": { root_index: 4, int_val: 8 },
      "g##": { root_index: 4, int_val: 9 },
      gb: { root_index: 4, int_val: 6 },
      gbb: { root_index: 4, int_val: 5 },
      a: { root_index: 5, int_val: 9 },
      an: { root_index: 5, int_val: 9 },
      "a#": { root_index: 5, int_val: 10 },
      "a##": { root_index: 5, int_val: 11 },
      ab: { root_index: 5, int_val: 8 },
      abb: { root_index: 5, int_val: 7 },
      b: { root_index: 6, int_val: 11 },
      bn: { root_index: 6, int_val: 11 },
      "b#": { root_index: 6, int_val: 0 },
      "b##": { root_index: 6, int_val: 1 },
      bb: { root_index: 6, int_val: 10 },
      bbb: { root_index: 6, int_val: 9 }
    };
  }
  isValidNoteValue(note) {
    return note >= 0 && note < _Music.canonical_notes.length;
  }
  isValidIntervalValue(interval) {
    return interval >= 0 && interval < _Music.diatonic_intervals.length;
  }
  getNoteParts(noteString) {
    if (!noteString || noteString.length < 1) {
      throw new RuntimeError("BadArguments", "Invalid note name: " + noteString);
    }
    if (noteString.length > 3) {
      throw new RuntimeError("BadArguments", "Invalid note name: " + noteString);
    }
    const note = noteString.toLowerCase();
    const regex = /^([cdefgab])(b|bb|n|#|##)?$/;
    const match = regex.exec(note);
    if (match !== null) {
      const root = match[1];
      const accidental = match[2];
      return {
        root,
        accidental
      };
    } else {
      throw new RuntimeError("BadArguments", "Invalid note name: " + noteString);
    }
  }
  getKeyParts(keyString) {
    if (!keyString || keyString.length < 1) {
      throw new RuntimeError("BadArguments", "Invalid key: " + keyString);
    }
    const key = keyString.toLowerCase();
    const regex = /^([cdefgab])(b|#)?(mel|harm|m|M)?$/;
    const match = regex.exec(key);
    if (match !== null) {
      const root = match[1];
      const accidental = match[2];
      let type = match[3];
      if (!type)
        type = "M";
      return {
        root,
        accidental,
        type
      };
    } else {
      throw new RuntimeError("BadArguments", `Invalid key: ${keyString}`);
    }
  }
  getNoteValue(noteString) {
    const value = _Music.noteValues[noteString];
    if (value === void 0) {
      throw new RuntimeError("BadArguments", `Invalid note name: ${noteString}`);
    }
    return value.int_val;
  }
  getIntervalValue(intervalString) {
    const value = _Music.intervals[intervalString];
    if (value === void 0) {
      throw new RuntimeError("BadArguments", `Invalid interval name: ${intervalString}`);
    }
    return value;
  }
  getCanonicalNoteName(noteValue) {
    if (!this.isValidNoteValue(noteValue)) {
      throw new RuntimeError("BadArguments", `Invalid note value: ${noteValue}`);
    }
    return _Music.canonical_notes[noteValue];
  }
  getCanonicalIntervalName(intervalValue) {
    if (!this.isValidIntervalValue(intervalValue)) {
      throw new RuntimeError("BadArguments", `Invalid interval value: ${intervalValue}`);
    }
    return _Music.diatonic_intervals[intervalValue];
  }
  getRelativeNoteValue(noteValue, intervalValue, direction = 1) {
    if (direction !== 1 && direction !== -1) {
      throw new RuntimeError("BadArguments", `Invalid direction: ${direction}`);
    }
    let sum = (noteValue + direction * intervalValue) % _Music.NUM_TONES;
    if (sum < 0)
      sum += _Music.NUM_TONES;
    return sum;
  }
  getRelativeNoteName(root, noteValue) {
    const parts = this.getNoteParts(root);
    const rootValue = this.getNoteValue(parts.root);
    let interval = noteValue - rootValue;
    if (Math.abs(interval) > _Music.NUM_TONES - 3) {
      let multiplier = 1;
      if (interval > 0)
        multiplier = -1;
      const reverse_interval = (noteValue + 1 + (rootValue + 1)) % _Music.NUM_TONES * multiplier;
      if (Math.abs(reverse_interval) > 2) {
        throw new RuntimeError("BadArguments", `Notes not related: ${root}, ${noteValue})`);
      } else {
        interval = reverse_interval;
      }
    }
    if (Math.abs(interval) > 2) {
      throw new RuntimeError("BadArguments", `Notes not related: ${root}, ${noteValue})`);
    }
    let relativeNoteName = parts.root;
    if (interval > 0) {
      for (let i = 1; i <= interval; ++i) {
        relativeNoteName += "#";
      }
    } else if (interval < 0) {
      for (let i = -1; i >= interval; --i) {
        relativeNoteName += "b";
      }
    }
    return relativeNoteName;
  }
  getScaleTones(key, intervals) {
    const tones = [key];
    let nextNote = key;
    for (let i = 0; i < intervals.length; i++) {
      nextNote = this.getRelativeNoteValue(nextNote, intervals[i]);
      if (nextNote !== key)
        tones.push(nextNote);
    }
    return tones;
  }
  getIntervalBetween(note1, note2, direction = 1) {
    if (direction !== 1 && direction !== -1) {
      throw new RuntimeError("BadArguments", `Invalid direction: ${direction}`);
    }
    if (!this.isValidNoteValue(note1) || !this.isValidNoteValue(note2)) {
      throw new RuntimeError("BadArguments", `Invalid notes: ${note1}, ${note2}`);
    }
    let difference = direction === 1 ? note2 - note1 : note1 - note2;
    if (difference < 0)
      difference += _Music.NUM_TONES;
    return difference;
  }
  createScaleMap(keySignature) {
    const keySigParts = this.getKeyParts(keySignature);
    if (!keySigParts.type)
      throw new RuntimeError("BadArguments", "Unsupported key type: undefined");
    const scaleName = _Music.scaleTypes[keySigParts.type];
    let keySigString = keySigParts.root;
    if (keySigParts.accidental)
      keySigString += keySigParts.accidental;
    if (!scaleName)
      throw new RuntimeError("BadArguments", "Unsupported key type: " + keySignature);
    const scale = this.getScaleTones(this.getNoteValue(keySigString), scaleName);
    const noteLocation = _Music.root_indices[keySigParts.root];
    const scaleMap = {};
    for (let i = 0; i < _Music.roots.length; ++i) {
      const index = (noteLocation + i) % _Music.roots.length;
      const rootName = _Music.roots[index];
      let noteName = this.getRelativeNoteName(rootName, scale[i]);
      if (noteName.length === 1) {
        noteName += "n";
      }
      scaleMap[rootName] = noteName;
    }
    return scaleMap;
  }
};

// node_modules/vexflow/build/esm/src/typeguard.js
function isCategory(obj, category, checkAncestors = true) {
  if (typeof obj !== "object" || obj === null) {
    return false;
  }
  let constructorFcn = obj.constructor;
  if (checkAncestors) {
    while (obj !== null) {
      constructorFcn = obj.constructor;
      if ("CATEGORY" in constructorFcn && constructorFcn.CATEGORY === category) {
        return true;
      }
      obj = Object.getPrototypeOf(obj);
    }
    return false;
  } else {
    return "CATEGORY" in constructorFcn && constructorFcn.CATEGORY === category;
  }
}
var isAccidental = (obj) => isCategory(obj, "Accidental");
var isAnnotation = (obj) => isCategory(obj, "Annotation");
var isBarline = (obj) => isCategory(obj, "Barline");
var isDot = (obj) => isCategory(obj, "Dot");
var isGraceNote = (obj) => isCategory(obj, "GraceNote");
var isGraceNoteGroup = (obj) => isCategory(obj, "GraceNoteGroup");
var isNote = (obj) => isCategory(obj, "Note");
var isRenderContext = (obj) => isCategory(obj, "RenderContext");
var isStaveNote = (obj) => isCategory(obj, "StaveNote");
var isStemmableNote = (obj) => isCategory(obj, "StemmableNote");
var isTabNote = (obj) => isCategory(obj, "TabNote");

// node_modules/vexflow/build/esm/src/accidental.js
function L(...args) {
  if (Accidental.DEBUG)
    log("Vex.Flow.Accidental", args);
}
var Accidental = class _Accidental extends Modifier {
  static get CATEGORY() {
    return "Accidental";
  }
  static format(accidentals2, state) {
    if (!accidentals2 || accidentals2.length === 0)
      return;
    const musicFont = Tables.currentMusicFont();
    const noteheadAccidentalPadding = musicFont.lookupMetric("accidental.noteheadAccidentalPadding");
    const leftShift = state.left_shift + noteheadAccidentalPadding;
    const accidentalSpacing = musicFont.lookupMetric("accidental.accidentalSpacing");
    const additionalPadding = musicFont.lookupMetric("accidental.leftPadding");
    const accidentalLinePositionsAndSpaceNeeds = [];
    let prevNote = void 0;
    let extraXSpaceNeededForLeftDisplacedNotehead = 0;
    for (let i = 0; i < accidentals2.length; ++i) {
      const acc = accidentals2[i];
      const note = acc.getNote();
      const stave = note.getStave();
      const index = acc.checkIndex();
      const props = note.getKeyProps()[index];
      if (note !== prevNote) {
        for (let n = 0; n < note.keys.length; ++n) {
          extraXSpaceNeededForLeftDisplacedNotehead = Math.max(note.getLeftDisplacedHeadPx() - note.getXShift(), extraXSpaceNeededForLeftDisplacedNotehead);
        }
        prevNote = note;
      }
      if (stave) {
        const lineSpace = stave.getSpacingBetweenLines();
        const y = stave.getYForLine(props.line);
        const accLine = Math.round(y / lineSpace * 2) / 2;
        accidentalLinePositionsAndSpaceNeeds.push({
          y,
          line: accLine,
          extraXSpaceNeeded: extraXSpaceNeededForLeftDisplacedNotehead,
          acc,
          spacingBetweenStaveLines: lineSpace
        });
      } else {
        accidentalLinePositionsAndSpaceNeeds.push({
          line: props.line,
          extraXSpaceNeeded: extraXSpaceNeededForLeftDisplacedNotehead,
          acc
        });
      }
    }
    accidentalLinePositionsAndSpaceNeeds.sort((a, b) => b.line - a.line);
    const staveLineAccidentalLayoutMetrics = [];
    let maxExtraXSpaceNeeded = 0;
    for (let i = 0; i < accidentalLinePositionsAndSpaceNeeds.length; i++) {
      const accidentalLinePositionAndSpaceNeeds = accidentalLinePositionsAndSpaceNeeds[i];
      const priorLineMetric = staveLineAccidentalLayoutMetrics[staveLineAccidentalLayoutMetrics.length - 1];
      let currentLineMetric;
      if (!priorLineMetric || (priorLineMetric === null || priorLineMetric === void 0 ? void 0 : priorLineMetric.line) !== accidentalLinePositionAndSpaceNeeds.line) {
        currentLineMetric = {
          line: accidentalLinePositionAndSpaceNeeds.line,
          flatLine: true,
          dblSharpLine: true,
          numAcc: 0,
          width: 0,
          column: 0
        };
        staveLineAccidentalLayoutMetrics.push(currentLineMetric);
      } else {
        currentLineMetric = priorLineMetric;
      }
      if (accidentalLinePositionAndSpaceNeeds.acc.type !== "b" && accidentalLinePositionAndSpaceNeeds.acc.type !== "bb") {
        currentLineMetric.flatLine = false;
      }
      if (accidentalLinePositionAndSpaceNeeds.acc.type !== "##") {
        currentLineMetric.dblSharpLine = false;
      }
      currentLineMetric.numAcc++;
      currentLineMetric.width += accidentalLinePositionAndSpaceNeeds.acc.getWidth() + accidentalSpacing;
      maxExtraXSpaceNeeded = Math.max(accidentalLinePositionAndSpaceNeeds.extraXSpaceNeeded, maxExtraXSpaceNeeded);
    }
    let totalColumns = 0;
    for (let i = 0; i < staveLineAccidentalLayoutMetrics.length; i++) {
      let noFurtherConflicts = false;
      const groupStart = i;
      let groupEnd = i;
      while (groupEnd + 1 < staveLineAccidentalLayoutMetrics.length && !noFurtherConflicts) {
        if (this.checkCollision(staveLineAccidentalLayoutMetrics[groupEnd], staveLineAccidentalLayoutMetrics[groupEnd + 1])) {
          groupEnd++;
        } else {
          noFurtherConflicts = true;
        }
      }
      const getGroupLine = (index) => staveLineAccidentalLayoutMetrics[groupStart + index];
      const getGroupLines = (indexes) => indexes.map(getGroupLine);
      const lineDifference = (indexA, indexB) => {
        const [a, b] = getGroupLines([indexA, indexB]).map((item) => item.line);
        return a - b;
      };
      const notColliding = (...indexPairs) => indexPairs.map(getGroupLines).every(([line1, line2]) => !this.checkCollision(line1, line2));
      const groupLength = groupEnd - groupStart + 1;
      let endCase = this.checkCollision(staveLineAccidentalLayoutMetrics[groupStart], staveLineAccidentalLayoutMetrics[groupEnd]) ? "a" : "b";
      switch (groupLength) {
        case 3:
          if (endCase === "a" && lineDifference(1, 2) === 0.5 && lineDifference(0, 1) !== 0.5) {
            endCase = "second_on_bottom";
          }
          break;
        case 4:
          if (notColliding([0, 2], [1, 3])) {
            endCase = "spaced_out_tetrachord";
          }
          break;
        case 5:
          if (endCase === "b" && notColliding([1, 3])) {
            endCase = "spaced_out_pentachord";
            if (notColliding([0, 2], [2, 4])) {
              endCase = "very_spaced_out_pentachord";
            }
          }
          break;
        case 6:
          if (notColliding([0, 3], [1, 4], [2, 5])) {
            endCase = "spaced_out_hexachord";
          }
          if (notColliding([0, 2], [2, 4], [1, 3], [3, 5])) {
            endCase = "very_spaced_out_hexachord";
          }
          break;
        default:
          break;
      }
      let groupMember;
      let column;
      if (groupLength >= 7) {
        let patternLength = 2;
        let collisionDetected = true;
        while (collisionDetected === true) {
          collisionDetected = false;
          for (let line = 0; line + patternLength < staveLineAccidentalLayoutMetrics.length; line++) {
            if (this.checkCollision(staveLineAccidentalLayoutMetrics[line], staveLineAccidentalLayoutMetrics[line + patternLength])) {
              collisionDetected = true;
              patternLength++;
              break;
            }
          }
        }
        for (groupMember = i; groupMember <= groupEnd; groupMember++) {
          column = (groupMember - i) % patternLength + 1;
          staveLineAccidentalLayoutMetrics[groupMember].column = column;
          totalColumns = totalColumns > column ? totalColumns : column;
        }
      } else {
        for (groupMember = i; groupMember <= groupEnd; groupMember++) {
          column = Tables.accidentalColumnsTable[groupLength][endCase][groupMember - i];
          staveLineAccidentalLayoutMetrics[groupMember].column = column;
          totalColumns = totalColumns > column ? totalColumns : column;
        }
      }
      i = groupEnd;
    }
    const columnWidths = [];
    const columnXOffsets = [];
    for (let i = 0; i <= totalColumns; i++) {
      columnWidths[i] = 0;
      columnXOffsets[i] = 0;
    }
    columnWidths[0] = leftShift + maxExtraXSpaceNeeded;
    columnXOffsets[0] = leftShift;
    staveLineAccidentalLayoutMetrics.forEach((line) => {
      if (line.width > columnWidths[line.column])
        columnWidths[line.column] = line.width;
    });
    for (let i = 1; i < columnWidths.length; i++) {
      columnXOffsets[i] = columnWidths[i] + columnXOffsets[i - 1];
    }
    const totalShift = columnXOffsets[columnXOffsets.length - 1];
    let accCount = 0;
    staveLineAccidentalLayoutMetrics.forEach((line) => {
      let lineWidth = 0;
      const lastAccOnLine = accCount + line.numAcc;
      for (accCount; accCount < lastAccOnLine; accCount++) {
        const xShift = columnXOffsets[line.column - 1] + lineWidth + maxExtraXSpaceNeeded;
        accidentalLinePositionsAndSpaceNeeds[accCount].acc.setXShift(xShift);
        lineWidth += accidentalLinePositionsAndSpaceNeeds[accCount].acc.getWidth() + accidentalSpacing;
        L("Line, accCount, shift: ", line.line, accCount, xShift);
      }
    });
    state.left_shift = totalShift + additionalPadding;
  }
  static checkCollision(line1, line2) {
    let clearance = line2.line - line1.line;
    let clearanceRequired = 3;
    if (clearance > 0) {
      clearanceRequired = line2.flatLine || line2.dblSharpLine ? 2.5 : 3;
      if (line1.dblSharpLine)
        clearance -= 0.5;
    } else {
      clearanceRequired = line1.flatLine || line1.dblSharpLine ? 2.5 : 3;
      if (line2.dblSharpLine)
        clearance -= 0.5;
    }
    const collision = Math.abs(clearance) < clearanceRequired;
    L("Line_1, Line_2, Collision: ", line1.line, line2.line, collision);
    return collision;
  }
  static applyAccidentals(voices, keySignature) {
    const tickPositions = [];
    const tickNoteMap = {};
    voices.forEach((voice) => {
      const tickPosition = new Fraction(0, 1);
      const tickable = voice.getTickables();
      tickable.forEach((t) => {
        if (t.shouldIgnoreTicks())
          return;
        const notesAtPosition = tickNoteMap[tickPosition.value()];
        if (!notesAtPosition) {
          tickPositions.push(tickPosition.value());
          tickNoteMap[tickPosition.value()] = [t];
        } else {
          notesAtPosition.push(t);
        }
        tickPosition.add(t.getTicks());
      });
    });
    const music = new Music();
    if (!keySignature)
      keySignature = "C";
    const scaleMapKey = music.createScaleMap(keySignature);
    const scaleMap = {};
    tickPositions.forEach((tickPos) => {
      const tickables = tickNoteMap[tickPos];
      const modifiedPitches = [];
      const processNote = (t) => {
        if (!isStaveNote(t) || t.isRest() || t.shouldIgnoreTicks()) {
          return;
        }
        const staveNote = t;
        staveNote.keys.forEach((keyString, keyIndex) => {
          const key = music.getNoteParts(keyString.split("/")[0]);
          const octave = keyString.split("/")[1];
          const accidentalString = key.accidental || "n";
          const pitch = key.root + accidentalString;
          if (!scaleMap[key.root + octave])
            scaleMap[key.root + octave] = scaleMapKey[key.root];
          const sameAccidental = scaleMap[key.root + octave] === pitch;
          const previouslyModified = modifiedPitches.indexOf(keyString) > -1;
          staveNote.getModifiers().forEach((modifier, index) => {
            if (isAccidental(modifier) && modifier.type == accidentalString && modifier.getIndex() == keyIndex) {
              staveNote.getModifiers().splice(index, 1);
            }
          });
          if (!sameAccidental || sameAccidental && previouslyModified) {
            scaleMap[key.root + octave] = pitch;
            const accidental = new _Accidental(accidentalString);
            staveNote.addModifier(accidental, keyIndex);
            modifiedPitches.push(keyString);
          }
        });
        staveNote.getModifiers().forEach((modifier) => {
          if (isGraceNoteGroup(modifier)) {
            modifier.getGraceNotes().forEach(processNote);
          }
        });
      };
      tickables.forEach(processNote);
    });
  }
  constructor(type) {
    super();
    L("New accidental: ", type);
    this.type = type;
    this.position = Modifier.Position.LEFT;
    this.render_options = {
      font_scale: Tables.NOTATION_FONT_SCALE,
      parenLeftPadding: 2,
      parenRightPadding: 2
    };
    this.accidental = Tables.accidentalCodes(this.type);
    defined(this.accidental, "ArgumentError", `Unknown accidental type: ${type}`);
    this.cautionary = false;
    this.reset();
  }
  reset() {
    const fontScale = this.render_options.font_scale;
    this.glyph = new Glyph(this.accidental.code, fontScale);
    this.glyph.setOriginX(1);
    if (this.cautionary) {
      this.parenLeft = new Glyph(Tables.accidentalCodes("{").code, fontScale);
      this.parenRight = new Glyph(Tables.accidentalCodes("}").code, fontScale);
      this.parenLeft.setOriginX(1);
      this.parenRight.setOriginX(1);
    }
  }
  getWidth() {
    if (this.cautionary) {
      const parenLeft = defined(this.parenLeft);
      const parenRight = defined(this.parenRight);
      const parenWidth = parenLeft.getMetrics().width + parenRight.getMetrics().width + this.render_options.parenLeftPadding + this.render_options.parenRightPadding;
      return this.glyph.getMetrics().width + parenWidth;
    } else {
      return this.glyph.getMetrics().width;
    }
  }
  setNote(note) {
    defined(note, "ArgumentError", `Bad note value: ${note}`);
    this.note = note;
    if (isGraceNote(note)) {
      this.render_options.font_scale = 25;
      this.reset();
    }
    return this;
  }
  setAsCautionary() {
    this.cautionary = true;
    this.render_options.font_scale = 28;
    this.reset();
    return this;
  }
  draw() {
    const { type, position, index, cautionary, x_shift, y_shift, glyph, render_options: { parenLeftPadding, parenRightPadding } } = this;
    const ctx = this.checkContext();
    const note = this.checkAttachedNote();
    this.setRendered();
    const start = note.getModifierStartXY(position, index);
    let accX = start.x + x_shift;
    const accY = start.y + y_shift;
    L("Rendering: ", type, accX, accY);
    if (!cautionary) {
      glyph.render(ctx, accX, accY);
    } else {
      const parenLeft = defined(this.parenLeft);
      const parenRight = defined(this.parenRight);
      parenRight.render(ctx, accX, accY);
      accX -= parenRight.getMetrics().width;
      accX -= parenRightPadding;
      accX -= this.accidental.parenRightPaddingAdjustment;
      glyph.render(ctx, accX, accY);
      accX -= glyph.getMetrics().width;
      accX -= parenLeftPadding;
      parenLeft.render(ctx, accX, accY);
    }
  }
};
Accidental.DEBUG = false;

// node_modules/vexflow/build/esm/src/stem.js
function L2(...args) {
  if (Stem.DEBUG)
    log("Vex.Flow.Stem", args);
}
var Stem = class _Stem extends Element {
  static get CATEGORY() {
    return "Stem";
  }
  static get UP() {
    return 1;
  }
  static get DOWN() {
    return -1;
  }
  static get WIDTH() {
    return Tables.STEM_WIDTH;
  }
  static get HEIGHT() {
    return Tables.STEM_HEIGHT;
  }
  constructor(options) {
    super();
    this.stem_up_y_offset = 0;
    this.stem_down_y_offset = 0;
    this.stem_up_y_base_offset = 0;
    this.stem_down_y_base_offset = 0;
    this.x_begin = (options === null || options === void 0 ? void 0 : options.x_begin) || 0;
    this.x_end = (options === null || options === void 0 ? void 0 : options.x_end) || 0;
    this.y_top = (options === null || options === void 0 ? void 0 : options.y_top) || 0;
    this.y_bottom = (options === null || options === void 0 ? void 0 : options.y_bottom) || 0;
    this.stem_extension = (options === null || options === void 0 ? void 0 : options.stem_extension) || 0;
    this.stem_direction = (options === null || options === void 0 ? void 0 : options.stem_direction) || 0;
    this.hide = (options === null || options === void 0 ? void 0 : options.hide) || false;
    this.isStemlet = (options === null || options === void 0 ? void 0 : options.isStemlet) || false;
    this.stemletHeight = (options === null || options === void 0 ? void 0 : options.stemletHeight) || 0;
    this.renderHeightAdjustment = 0;
    this.setOptions(options);
  }
  setOptions(options) {
    this.stem_up_y_offset = (options === null || options === void 0 ? void 0 : options.stem_up_y_offset) || 0;
    this.stem_down_y_offset = (options === null || options === void 0 ? void 0 : options.stem_down_y_offset) || 0;
    this.stem_up_y_base_offset = (options === null || options === void 0 ? void 0 : options.stem_up_y_base_offset) || 0;
    this.stem_down_y_base_offset = (options === null || options === void 0 ? void 0 : options.stem_down_y_base_offset) || 0;
  }
  setNoteHeadXBounds(x_begin, x_end) {
    this.x_begin = x_begin;
    this.x_end = x_end;
    return this;
  }
  setDirection(direction) {
    this.stem_direction = direction;
  }
  setExtension(ext) {
    this.stem_extension = ext;
  }
  getExtension() {
    return this.stem_extension;
  }
  setYBounds(y_top, y_bottom) {
    this.y_top = y_top;
    this.y_bottom = y_bottom;
  }
  getHeight() {
    const y_offset = this.stem_direction === _Stem.UP ? this.stem_up_y_offset : this.stem_down_y_offset;
    const unsigned_height = this.y_bottom - this.y_top + (_Stem.HEIGHT - y_offset + this.stem_extension);
    return unsigned_height * this.stem_direction;
  }
  getBoundingBox() {
    throw new RuntimeError("NotImplemented", "getBoundingBox() not implemented.");
  }
  getExtents() {
    const isStemUp = this.stem_direction === _Stem.UP;
    const ys = [this.y_top, this.y_bottom];
    const stemHeight = _Stem.HEIGHT + this.stem_extension;
    const innerMostNoteheadY = (isStemUp ? Math.min : Math.max)(...ys);
    const outerMostNoteheadY = (isStemUp ? Math.max : Math.min)(...ys);
    const stemTipY = innerMostNoteheadY + stemHeight * -this.stem_direction;
    return { topY: stemTipY, baseY: outerMostNoteheadY };
  }
  setVisibility(isVisible) {
    this.hide = !isVisible;
    return this;
  }
  setStemlet(isStemlet, stemletHeight) {
    this.isStemlet = isStemlet;
    this.stemletHeight = stemletHeight;
    return this;
  }
  adjustHeightForFlag() {
    this.renderHeightAdjustment = Tables.currentMusicFont().lookupMetric("stem.heightAdjustmentForFlag", -3);
  }
  adjustHeightForBeam() {
    this.renderHeightAdjustment = -_Stem.WIDTH / 2;
  }
  draw() {
    this.setRendered();
    if (this.hide)
      return;
    const ctx = this.checkContext();
    let stem_x;
    let stem_y;
    const stem_direction = this.stem_direction;
    let y_base_offset = 0;
    if (stem_direction === _Stem.DOWN) {
      stem_x = this.x_begin;
      stem_y = this.y_top + this.stem_down_y_offset;
      y_base_offset = this.stem_down_y_base_offset;
    } else {
      stem_x = this.x_end;
      stem_y = this.y_bottom - this.stem_up_y_offset;
      y_base_offset = this.stem_up_y_base_offset;
    }
    const stemHeight = this.getHeight();
    L2("Rendering stem - ", "Top Y: ", this.y_top, "Bottom Y: ", this.y_bottom);
    const stemletYOffset = this.isStemlet ? stemHeight - this.stemletHeight * this.stem_direction : 0;
    ctx.save();
    this.applyStyle();
    ctx.openGroup("stem", this.getAttribute("id"), { pointerBBox: true });
    ctx.beginPath();
    ctx.setLineWidth(_Stem.WIDTH);
    ctx.moveTo(stem_x, stem_y - stemletYOffset + y_base_offset);
    ctx.lineTo(stem_x, stem_y - stemHeight - this.renderHeightAdjustment * stem_direction);
    ctx.stroke();
    ctx.closeGroup();
    this.restoreStyle();
    ctx.restore();
  }
};
Stem.DEBUG = false;

// node_modules/vexflow/build/esm/src/textformatter.js
function L3(...args) {
  if (TextFormatter.DEBUG)
    log("Vex.Flow.TextFormatter", args);
}
var textWidthCache = {};
var textHeightCache = {};
var registry = {};
var TextFormatter = class _TextFormatter {
  static getFontFamilies() {
    const registeredFonts = [];
    for (const fontFamily in registry) {
      const formatterInfo = registry[fontFamily];
      registeredFonts.push(Object.assign({}, formatterInfo));
    }
    return registeredFonts;
  }
  static create(requestedFont = {}) {
    L3("create: ", requestedFont);
    if (!requestedFont.family) {
      requestedFont.family = Font.SANS_SERIF;
    }
    const candidates = [];
    const requestedFamilies = requestedFont.family.split(/\s*,\s*/);
    for (const requestedFamily of requestedFamilies) {
      for (const fontFamily in registry) {
        if (fontFamily.startsWith(requestedFamily)) {
          candidates.push(registry[fontFamily]);
        }
      }
      if (candidates.length > 0) {
        break;
      }
    }
    let formatter;
    if (candidates.length === 0) {
      formatter = new _TextFormatter(Object.values(registry)[0]);
    } else if (candidates.length === 1) {
      formatter = new _TextFormatter(candidates[0]);
    } else {
      const bold = Font.isBold(requestedFont.weight);
      const italic = Font.isItalic(requestedFont.style);
      const perfectMatch = candidates.find((f) => f.bold === bold && f.italic === italic);
      if (perfectMatch) {
        formatter = new _TextFormatter(perfectMatch);
      } else {
        const partialMatch = candidates.find((f) => f.italic === italic || f.bold === bold);
        if (partialMatch) {
          formatter = new _TextFormatter(partialMatch);
        } else {
          formatter = new _TextFormatter(candidates[0]);
        }
      }
    }
    const fontSize = requestedFont.size;
    if (typeof fontSize !== "undefined") {
      const fontSizeInPt = Font.convertSizeToPointValue(fontSize);
      formatter.setFontSize(fontSizeInPt);
    }
    return formatter;
  }
  static getInfo(fontFamily) {
    return registry[fontFamily];
  }
  static registerInfo(info, overwrite = false) {
    L3("registerInfo: ", info, overwrite);
    const fontFamily = info.family;
    const currFontInfo = registry[fontFamily];
    if (currFontInfo === void 0 || overwrite) {
      registry[fontFamily] = info;
    }
  }
  constructor(formatterInfo) {
    this.family = "";
    this.size = 14;
    this.resolution = 1e3;
    this.glyphs = {};
    this.serifs = false;
    this.monospaced = false;
    this.italic = false;
    this.bold = false;
    this.superscriptOffset = 0;
    this.subscriptOffset = 0;
    this.maxSizeGlyph = "@";
    this.cacheKey = "";
    this.updateParams(formatterInfo);
  }
  get localHeightCache() {
    var _a;
    if (textHeightCache[this.cacheKey] === void 0) {
      textHeightCache[this.cacheKey] = {};
    }
    return (_a = textHeightCache[this.cacheKey]) !== null && _a !== void 0 ? _a : {};
  }
  updateParams(params) {
    if (params.family)
      this.family = params.family;
    if (params.resolution)
      this.resolution = params.resolution;
    if (params.glyphs)
      this.glyphs = params.glyphs;
    if (params.serifs)
      this.serifs = params.serifs;
    if (params.monospaced)
      this.monospaced = params.monospaced;
    if (params.italic)
      this.italic = params.italic;
    if (params.bold)
      this.bold = params.bold;
    if (params.maxSizeGlyph)
      this.maxSizeGlyph = params.maxSizeGlyph;
    if (params.superscriptOffset)
      this.superscriptOffset = params.superscriptOffset;
    if (params.subscriptOffset)
      this.subscriptOffset = params.subscriptOffset;
    this.updateCacheKey();
  }
  updateCacheKey() {
    const family = this.family.replace(/\s+/g, "_");
    const size = this.size;
    const weight = this.bold ? FontWeight.BOLD : FontWeight.NORMAL;
    const style = this.italic ? FontStyle.ITALIC : FontStyle.NORMAL;
    this.cacheKey = `${family}%${size}%${weight}%${style}`;
  }
  getGlyphMetrics(character) {
    if (this.glyphs[character]) {
      return this.glyphs[character];
    } else {
      return this.glyphs[this.maxSizeGlyph];
    }
  }
  get maxHeight() {
    const metrics = this.getGlyphMetrics(this.maxSizeGlyph);
    return metrics.ha / this.resolution * this.fontSizeInPixels;
  }
  getWidthForCharacterInEm(c) {
    var _a;
    const metrics = this.getGlyphMetrics(c);
    if (!metrics) {
      return 0.65;
    } else {
      const advanceWidth = (_a = metrics.advanceWidth) !== null && _a !== void 0 ? _a : 0;
      return advanceWidth / this.resolution;
    }
  }
  getYForCharacterInPx(c) {
    const metrics = this.getGlyphMetrics(c);
    const rv = { yMin: 0, yMax: this.maxHeight, height: this.maxHeight };
    if (!metrics) {
      return rv;
    } else {
      if (typeof metrics.y_min === "number") {
        rv.yMin = metrics.y_min / this.resolution * this.fontSizeInPixels;
      }
      if (typeof metrics.y_max === "number") {
        rv.yMax = metrics.y_max / this.resolution * this.fontSizeInPixels;
      }
      rv.height = rv.yMax - rv.yMin;
      return rv;
    }
  }
  getYForStringInPx(str) {
    const entry = this.localHeightCache;
    const extent = { yMin: 0, yMax: this.maxHeight, height: this.maxHeight };
    const cache = entry[str];
    if (cache !== void 0) {
      return cache;
    }
    for (let i = 0; i < str.length; ++i) {
      const curY = this.getYForCharacterInPx(str[i]);
      extent.yMin = Math.min(extent.yMin, curY.yMin);
      extent.yMax = Math.max(extent.yMax, curY.yMax);
      extent.height = extent.yMax - extent.yMin;
    }
    entry[str] = extent;
    return extent;
  }
  getWidthForTextInEm(text) {
    const key = this.cacheKey;
    let cachedWidths = textWidthCache[key];
    if (cachedWidths === void 0) {
      cachedWidths = {};
      textWidthCache[key] = cachedWidths;
    }
    let width = cachedWidths[text];
    if (width === void 0) {
      width = 0;
      for (let i = 0; i < text.length; ++i) {
        width += this.getWidthForCharacterInEm(text[i]);
      }
      cachedWidths[text] = width;
    }
    return width;
  }
  getWidthForTextInPx(text) {
    return this.getWidthForTextInEm(text) * this.fontSizeInPixels;
  }
  setFontSize(size) {
    this.size = size;
    this.updateCacheKey();
    return this;
  }
  get fontSizeInPixels() {
    return this.size * Font.scaleToPxFrom.pt;
  }
  getResolution() {
    return this.resolution;
  }
};
TextFormatter.DEBUG = false;

// node_modules/vexflow/build/esm/src/annotation.js
function L4(...args) {
  if (Annotation.DEBUG)
    log("Vex.Flow.Annotation", args);
}
var AnnotationHorizontalJustify;
(function(AnnotationHorizontalJustify2) {
  AnnotationHorizontalJustify2[AnnotationHorizontalJustify2["LEFT"] = 1] = "LEFT";
  AnnotationHorizontalJustify2[AnnotationHorizontalJustify2["CENTER"] = 2] = "CENTER";
  AnnotationHorizontalJustify2[AnnotationHorizontalJustify2["RIGHT"] = 3] = "RIGHT";
  AnnotationHorizontalJustify2[AnnotationHorizontalJustify2["CENTER_STEM"] = 4] = "CENTER_STEM";
})(AnnotationHorizontalJustify || (AnnotationHorizontalJustify = {}));
var AnnotationVerticalJustify;
(function(AnnotationVerticalJustify2) {
  AnnotationVerticalJustify2[AnnotationVerticalJustify2["TOP"] = 1] = "TOP";
  AnnotationVerticalJustify2[AnnotationVerticalJustify2["CENTER"] = 2] = "CENTER";
  AnnotationVerticalJustify2[AnnotationVerticalJustify2["BOTTOM"] = 3] = "BOTTOM";
  AnnotationVerticalJustify2[AnnotationVerticalJustify2["CENTER_STEM"] = 4] = "CENTER_STEM";
})(AnnotationVerticalJustify || (AnnotationVerticalJustify = {}));
var Annotation = class _Annotation extends Modifier {
  static get CATEGORY() {
    return "Annotation";
  }
  static get minAnnotationPadding() {
    const musicFont = Tables.currentMusicFont();
    return musicFont.lookupMetric("noteHead.minPadding");
  }
  static format(annotations, state) {
    if (!annotations || annotations.length === 0)
      return false;
    let leftWidth = 0;
    let rightWidth = 0;
    let maxLeftGlyphWidth = 0;
    let maxRightGlyphWidth = 0;
    for (let i = 0; i < annotations.length; ++i) {
      const annotation = annotations[i];
      const textFormatter = TextFormatter.create(annotation.textFont);
      const textLines = (2 + textFormatter.getYForStringInPx(annotation.text).height) / Tables.STAVE_LINE_DISTANCE;
      let verticalSpaceNeeded = textLines;
      const note = annotation.checkAttachedNote();
      const glyphWidth = note.getGlyphProps().getWidth();
      const textWidth = textFormatter.getWidthForTextInPx(annotation.text);
      if (annotation.horizontalJustification === AnnotationHorizontalJustify.LEFT) {
        maxLeftGlyphWidth = Math.max(glyphWidth, maxLeftGlyphWidth);
        leftWidth = Math.max(leftWidth, textWidth) + _Annotation.minAnnotationPadding;
      } else if (annotation.horizontalJustification === AnnotationHorizontalJustify.RIGHT) {
        maxRightGlyphWidth = Math.max(glyphWidth, maxRightGlyphWidth);
        rightWidth = Math.max(rightWidth, textWidth);
      } else {
        leftWidth = Math.max(leftWidth, textWidth / 2) + _Annotation.minAnnotationPadding;
        rightWidth = Math.max(rightWidth, textWidth / 2);
        maxLeftGlyphWidth = Math.max(glyphWidth / 2, maxLeftGlyphWidth);
        maxRightGlyphWidth = Math.max(glyphWidth / 2, maxRightGlyphWidth);
      }
      const stave = note.getStave();
      const stemDirection = note.hasStem() ? note.getStemDirection() : Stem.UP;
      let stemHeight = 0;
      let lines = 5;
      if (isTabNote(note)) {
        if (note.render_options.draw_stem) {
          const stem = note.getStem();
          if (stem) {
            stemHeight = Math.abs(stem.getHeight()) / Tables.STAVE_LINE_DISTANCE;
          }
        } else {
          stemHeight = 0;
        }
      } else if (isStemmableNote(note)) {
        const stem = note.getStem();
        if (stem && note.getNoteType() === "n") {
          stemHeight = Math.abs(stem.getHeight()) / Tables.STAVE_LINE_DISTANCE;
        }
      }
      if (stave) {
        lines = stave.getNumLines();
      }
      if (annotation.verticalJustification === this.VerticalJustify.TOP) {
        let noteLine = note.getLineNumber(true);
        if (isTabNote(note)) {
          noteLine = lines - (note.leastString() - 0.5);
        }
        if (stemDirection === Stem.UP) {
          noteLine += stemHeight;
        }
        const curTop = noteLine + state.top_text_line + 0.5;
        if (curTop < lines) {
          annotation.setTextLine(lines - noteLine);
          verticalSpaceNeeded += lines - noteLine;
          state.top_text_line = verticalSpaceNeeded;
        } else {
          annotation.setTextLine(state.top_text_line);
          state.top_text_line += verticalSpaceNeeded;
        }
      } else if (annotation.verticalJustification === this.VerticalJustify.BOTTOM) {
        let noteLine = lines - note.getLineNumber();
        if (isTabNote(note)) {
          noteLine = note.greatestString() - 1;
        }
        if (stemDirection === Stem.DOWN) {
          noteLine += stemHeight;
        }
        const curBottom = noteLine + state.text_line + 1;
        if (curBottom < lines) {
          annotation.setTextLine(lines - curBottom);
          verticalSpaceNeeded += lines - curBottom;
          state.text_line = verticalSpaceNeeded;
        } else {
          annotation.setTextLine(state.text_line);
          state.text_line += verticalSpaceNeeded;
        }
      } else {
        annotation.setTextLine(state.text_line);
      }
    }
    const rightOverlap = Math.min(Math.max(rightWidth - maxRightGlyphWidth, 0), Math.max(rightWidth - state.right_shift, 0));
    const leftOverlap = Math.min(Math.max(leftWidth - maxLeftGlyphWidth, 0), Math.max(leftWidth - state.left_shift, 0));
    state.left_shift += leftOverlap;
    state.right_shift += rightOverlap;
    return true;
  }
  constructor(text) {
    super();
    this.text = text;
    this.horizontalJustification = AnnotationHorizontalJustify.CENTER;
    this.verticalJustification = AnnotationVerticalJustify.TOP;
    this.resetFont();
    this.setWidth(Tables.textWidth(text));
  }
  setVerticalJustification(just) {
    this.verticalJustification = typeof just === "string" ? _Annotation.VerticalJustifyString[just] : just;
    return this;
  }
  getJustification() {
    return this.horizontalJustification;
  }
  setJustification(just) {
    this.horizontalJustification = typeof just === "string" ? _Annotation.HorizontalJustifyString[just] : just;
    return this;
  }
  draw() {
    const ctx = this.checkContext();
    const note = this.checkAttachedNote();
    const stemDirection = note.hasStem() ? note.getStemDirection() : Stem.UP;
    const textFormatter = TextFormatter.create(this.textFont);
    const start = note.getModifierStartXY(ModifierPosition.ABOVE, this.index);
    this.setRendered();
    ctx.save();
    this.applyStyle();
    ctx.openGroup("annotation", this.getAttribute("id"));
    ctx.setFont(this.textFont);
    const text_width = textFormatter.getWidthForTextInPx(this.text);
    const text_height = textFormatter.getYForStringInPx(this.text).height;
    let x;
    let y;
    if (this.horizontalJustification === AnnotationHorizontalJustify.LEFT) {
      x = start.x;
    } else if (this.horizontalJustification === AnnotationHorizontalJustify.RIGHT) {
      x = start.x - text_width;
    } else if (this.horizontalJustification === AnnotationHorizontalJustify.CENTER) {
      x = start.x - text_width / 2;
    } else {
      x = note.getStemX() - text_width / 2;
    }
    let stem_ext = {};
    let spacing = 0;
    const has_stem = note.hasStem();
    const stave = note.checkStave();
    if (has_stem) {
      stem_ext = note.checkStem().getExtents();
      spacing = stave.getSpacingBetweenLines();
    }
    if (this.verticalJustification === AnnotationVerticalJustify.BOTTOM) {
      const ys = note.getYs();
      y = ys.reduce((a, b) => a > b ? a : b);
      y += (this.text_line + 1) * Tables.STAVE_LINE_DISTANCE + text_height;
      if (has_stem && stemDirection === Stem.DOWN) {
        y = Math.max(y, stem_ext.topY + text_height + spacing * this.text_line);
      }
    } else if (this.verticalJustification === AnnotationVerticalJustify.CENTER) {
      const yt = note.getYForTopText(this.text_line) - 1;
      const yb = stave.getYForBottomText(this.text_line);
      y = yt + (yb - yt) / 2 + text_height / 2;
    } else if (this.verticalJustification === AnnotationVerticalJustify.TOP) {
      const topY = Math.min(...note.getYs());
      y = topY - (this.text_line + 1) * Tables.STAVE_LINE_DISTANCE;
      if (has_stem && stemDirection === Stem.UP) {
        spacing = stem_ext.topY < stave.getTopLineTopY() ? Tables.STAVE_LINE_DISTANCE : spacing;
        y = Math.min(y, stem_ext.topY - spacing * (this.text_line + 1));
      }
    } else {
      const extents = note.getStemExtents();
      y = extents.topY + (extents.baseY - extents.topY) / 2 + text_height / 2;
    }
    L4("Rendering annotation: ", this.text, x, y);
    ctx.fillText(this.text, x, y);
    ctx.closeGroup();
    this.restoreStyle();
    ctx.restore();
  }
};
Annotation.DEBUG = false;
Annotation.TEXT_FONT = Object.assign({}, Element.TEXT_FONT);
Annotation.HorizontalJustify = AnnotationHorizontalJustify;
Annotation.HorizontalJustifyString = {
  left: AnnotationHorizontalJustify.LEFT,
  right: AnnotationHorizontalJustify.RIGHT,
  center: AnnotationHorizontalJustify.CENTER,
  centerStem: AnnotationHorizontalJustify.CENTER_STEM
};
Annotation.VerticalJustify = AnnotationVerticalJustify;
Annotation.VerticalJustifyString = {
  above: AnnotationVerticalJustify.TOP,
  top: AnnotationVerticalJustify.TOP,
  below: AnnotationVerticalJustify.BOTTOM,
  bottom: AnnotationVerticalJustify.BOTTOM,
  center: AnnotationVerticalJustify.CENTER,
  centerStem: AnnotationVerticalJustify.CENTER_STEM
};

// node_modules/vexflow/build/esm/src/articulation.js
function L5(...args) {
  if (Articulation.DEBUG)
    log("Vex.Flow.Articulation", args);
}
var { ABOVE, BELOW } = Modifier.Position;
function roundToNearestHalf(mathFn, value) {
  return mathFn(value / 0.5) * 0.5;
}
function isWithinLines(line, position) {
  return position === ABOVE ? line <= 5 : line >= 1;
}
function getRoundingFunction(line, position) {
  if (isWithinLines(line, position)) {
    if (position === ABOVE) {
      return Math.ceil;
    } else {
      return Math.floor;
    }
  } else {
    return Math.round;
  }
}
function snapLineToStaff(canSitBetweenLines, line, position, offsetDirection) {
  const snappedLine = roundToNearestHalf(getRoundingFunction(line, position), line);
  const canSnapToStaffSpace = canSitBetweenLines && isWithinLines(snappedLine, position);
  const onStaffLine = snappedLine % 1 === 0;
  if (canSnapToStaffSpace && onStaffLine) {
    const HALF_STAFF_SPACE = 0.5;
    return snappedLine + HALF_STAFF_SPACE * -offsetDirection;
  } else {
    return snappedLine;
  }
}
var isStaveOrGraceNote = (note) => isStaveNote(note) || isGraceNote(note);
function getTopY(note, textLine) {
  const stemDirection = note.getStemDirection();
  const { topY: stemTipY, baseY: stemBaseY } = note.getStemExtents();
  if (isStaveOrGraceNote(note)) {
    if (note.hasStem()) {
      if (stemDirection === Stem.UP) {
        return stemTipY;
      } else {
        return stemBaseY;
      }
    } else {
      return Math.min(...note.getYs());
    }
  } else if (isTabNote(note)) {
    if (note.hasStem()) {
      if (stemDirection === Stem.UP) {
        return stemTipY;
      } else {
        return note.checkStave().getYForTopText(textLine);
      }
    } else {
      return note.checkStave().getYForTopText(textLine);
    }
  } else {
    throw new RuntimeError("UnknownCategory", "Only can get the top and bottom ys of stavenotes and tabnotes");
  }
}
function getBottomY(note, textLine) {
  const stemDirection = note.getStemDirection();
  const { topY: stemTipY, baseY: stemBaseY } = note.getStemExtents();
  if (isStaveOrGraceNote(note)) {
    if (note.hasStem()) {
      if (stemDirection === Stem.UP) {
        return stemBaseY;
      } else {
        return stemTipY;
      }
    } else {
      return Math.max(...note.getYs());
    }
  } else if (isTabNote(note)) {
    if (note.hasStem()) {
      if (stemDirection === Stem.UP) {
        return note.checkStave().getYForBottomText(textLine);
      } else {
        return stemTipY;
      }
    } else {
      return note.checkStave().getYForBottomText(textLine);
    }
  } else {
    throw new RuntimeError("UnknownCategory", "Only can get the top and bottom ys of stavenotes and tabnotes");
  }
}
function getInitialOffset(note, position) {
  const isOnStemTip = position === ABOVE && note.getStemDirection() === Stem.UP || position === BELOW && note.getStemDirection() === Stem.DOWN;
  if (isStaveOrGraceNote(note)) {
    if (note.hasStem() && isOnStemTip) {
      return 0.5;
    } else {
      return 1;
    }
  } else {
    if (note.hasStem() && isOnStemTip) {
      return 1;
    } else {
      return 0;
    }
  }
}
var Articulation = class _Articulation extends Modifier {
  static get CATEGORY() {
    return "Articulation";
  }
  static format(articulations2, state) {
    if (!articulations2 || articulations2.length === 0)
      return false;
    const margin = 0.5;
    let maxGlyphWidth = 0;
    const getIncrement = (articulation, line, position) => roundToNearestHalf(getRoundingFunction(line, position), defined(articulation.glyph.getMetrics().height) / 10 + margin);
    articulations2.forEach((articulation) => {
      const note = articulation.checkAttachedNote();
      maxGlyphWidth = Math.max(note.getGlyphProps().getWidth(), maxGlyphWidth);
      let lines = 5;
      const stemDirection = note.hasStem() ? note.getStemDirection() : Stem.UP;
      let stemHeight = 0;
      if (isStemmableNote(note)) {
        const stem = note.getStem();
        if (stem) {
          stemHeight = Math.abs(stem.getHeight()) / Tables.STAVE_LINE_DISTANCE;
        }
      }
      const stave = note.getStave();
      if (stave) {
        lines = stave.getNumLines();
      }
      if (articulation.getPosition() === ABOVE) {
        let noteLine = note.getLineNumber(true);
        if (stemDirection === Stem.UP) {
          noteLine += stemHeight;
        }
        let increment = getIncrement(articulation, state.top_text_line, ABOVE);
        const curTop = noteLine + state.top_text_line + 0.5;
        if (!articulation.articulation.between_lines && curTop < lines) {
          increment += lines - curTop;
        }
        articulation.setTextLine(state.top_text_line);
        state.top_text_line += increment;
      } else if (articulation.getPosition() === BELOW) {
        let noteLine = Math.max(lines - note.getLineNumber(), 0);
        if (stemDirection === Stem.DOWN) {
          noteLine += stemHeight;
        }
        let increment = getIncrement(articulation, state.text_line, BELOW);
        const curBottom = noteLine + state.text_line + 0.5;
        if (!articulation.articulation.between_lines && curBottom < lines) {
          increment += lines - curBottom;
        }
        articulation.setTextLine(state.text_line);
        state.text_line += increment;
      }
    });
    const width = articulations2.map((articulation) => articulation.getWidth()).reduce((maxWidth, articWidth) => Math.max(articWidth, maxWidth));
    const overlap = Math.min(Math.max(width - maxGlyphWidth, 0), Math.max(width - (state.left_shift + state.right_shift), 0));
    state.left_shift += overlap / 2;
    state.right_shift += overlap / 2;
    return true;
  }
  static easyScoreHook({ articulations: articulations2 }, note, builder) {
    if (!articulations2)
      return;
    const articNameToCode = {
      staccato: "a.",
      tenuto: "a-",
      accent: "a>"
    };
    articulations2.split(",").map((articString) => articString.trim().split(".")).map(([name, position]) => {
      const artic = { type: articNameToCode[name] };
      if (position)
        artic.position = Modifier.PositionString[position];
      return builder.getFactory().Articulation(artic);
    }).map((artic) => note.addModifier(artic, 0));
  }
  constructor(type) {
    super();
    this.type = type;
    this.position = ABOVE;
    this.render_options = {
      font_scale: Tables.NOTATION_FONT_SCALE
    };
    this.reset();
  }
  reset() {
    this.articulation = Tables.articulationCodes(this.type);
    if (!this.articulation) {
      this.articulation = { code: this.type, between_lines: false };
      if (this.type.endsWith("Above"))
        this.position = ABOVE;
      if (this.type.endsWith("Below"))
        this.position = BELOW;
    }
    const code = (this.position === ABOVE ? this.articulation.aboveCode : this.articulation.belowCode) || this.articulation.code;
    this.glyph = new Glyph(code !== null && code !== void 0 ? code : "", this.render_options.font_scale);
    defined(this.glyph, "ArgumentError", `Articulation not found: ${this.type}`);
    this.setWidth(defined(this.glyph.getMetrics().width));
  }
  setBetweenLines(betweenLines = true) {
    this.articulation.between_lines = betweenLines;
    return this;
  }
  draw() {
    const ctx = this.checkContext();
    const note = this.checkAttachedNote();
    this.setRendered();
    const index = this.checkIndex();
    const { position, glyph, text_line: textLine } = this;
    const canSitBetweenLines = this.articulation.between_lines;
    const stave = note.checkStave();
    const staffSpace = stave.getSpacingBetweenLines();
    const isTab = isTabNote(note);
    const { x } = note.getModifierStartXY(position, index);
    const shouldSitOutsideStaff = !canSitBetweenLines || isTab;
    const initialOffset = getInitialOffset(note, position);
    const padding = Tables.currentMusicFont().lookupMetric(`articulation.${glyph.getCode()}.padding`, 0);
    let y = {
      [ABOVE]: () => {
        glyph.setOrigin(0.5, 1);
        const y2 = getTopY(note, textLine) - (textLine + initialOffset) * staffSpace;
        return shouldSitOutsideStaff ? Math.min(stave.getYForTopText(_Articulation.INITIAL_OFFSET), y2) : y2;
      },
      [BELOW]: () => {
        glyph.setOrigin(0.5, 0);
        const y2 = getBottomY(note, textLine) + (textLine + initialOffset) * staffSpace;
        return shouldSitOutsideStaff ? Math.max(stave.getYForBottomText(_Articulation.INITIAL_OFFSET), y2) : y2;
      }
    }[position]();
    if (!isTab) {
      const offsetDirection = position === ABOVE ? -1 : 1;
      const noteLine = note.getKeyProps()[index].line;
      const distanceFromNote = (note.getYs()[index] - y) / staffSpace;
      const articLine = distanceFromNote + Number(noteLine);
      const snappedLine = snapLineToStaff(canSitBetweenLines, articLine, position, offsetDirection);
      if (isWithinLines(snappedLine, position))
        glyph.setOrigin(0.5, 0.5);
      y += Math.abs(snappedLine - articLine) * staffSpace * offsetDirection + padding * offsetDirection;
    }
    L5(`Rendering articulation at (x: ${x}, y: ${y})`);
    glyph.render(ctx, x, y);
  }
};
Articulation.DEBUG = false;
Articulation.INITIAL_OFFSET = -0.5;

// node_modules/vexflow/build/esm/src/rendercontext.js
var RenderContext = class {
  static get CATEGORY() {
    return "RenderContext";
  }
  set font(f) {
    this.setFont(f);
  }
  get font() {
    return this.getFont();
  }
  setRawFont(f) {
    this.setFont(f);
    return this;
  }
};
function drawDot(ctx, x, y, color = "#F55") {
  ctx.save();
  ctx.setFillStyle(color);
  ctx.beginPath();
  ctx.arc(x, y, 3, 0, Math.PI * 2, false);
  ctx.closePath();
  ctx.fill();
  ctx.restore();
}

// node_modules/vexflow/build/esm/src/tickable.js
var Tickable = class extends Element {
  static get CATEGORY() {
    return "Tickable";
  }
  constructor() {
    super();
    this._preFormatted = false;
    this._postFormatted = false;
    this.ticks = new Fraction(0, 1);
    this.intrinsicTicks = 0;
    this.tickMultiplier = new Fraction(1, 1);
    this.width = 0;
    this.x_shift = 0;
    this.modifiers = [];
    this.tupletStack = [];
    this.align_center = false;
    this.center_x_shift = 0;
    this.ignore_ticks = false;
    this.formatterMetrics = {
      freedom: { left: 0, right: 0 },
      duration: "",
      iterations: 0,
      space: {
        used: 0,
        mean: 0,
        deviation: 0
      }
    };
  }
  reset() {
    return this;
  }
  getTicks() {
    return this.ticks;
  }
  shouldIgnoreTicks() {
    return this.ignore_ticks;
  }
  setIgnoreTicks(flag) {
    this.ignore_ticks = flag;
    return this;
  }
  setWidth(width) {
    this.width = width;
  }
  getWidth() {
    if (!this._preFormatted) {
      throw new RuntimeError("UnformattedNote", "Can't call GetWidth on an unformatted note.");
    }
    return this.width + (this.modifierContext ? this.modifierContext.getWidth() : 0);
  }
  setXShift(x) {
    this.x_shift = x;
    return this;
  }
  getXShift() {
    return this.x_shift;
  }
  getX() {
    const tickContext = this.checkTickContext(`Can't getX() without a TickContext.`);
    return tickContext.getX() + this.x_shift;
  }
  getFormatterMetrics() {
    return this.formatterMetrics;
  }
  getCenterXShift() {
    if (this.isCenterAligned()) {
      return this.center_x_shift;
    }
    return 0;
  }
  setCenterXShift(centerXShift) {
    this.center_x_shift = centerXShift;
    return this;
  }
  isCenterAligned() {
    return this.align_center;
  }
  setCenterAlignment(align_center) {
    this.align_center = align_center;
    return this;
  }
  getVoice() {
    return defined(this.voice, "NoVoice", "Tickable has no voice.");
  }
  setVoice(voice) {
    this.voice = voice;
  }
  getTuplet() {
    return this.tuplet;
  }
  getTupletStack() {
    return this.tupletStack;
  }
  resetTuplet(tuplet) {
    let noteCount;
    let notesOccupied;
    if (tuplet) {
      const i = this.tupletStack.indexOf(tuplet);
      if (i !== -1) {
        this.tupletStack.splice(i, 1);
        noteCount = tuplet.getNoteCount();
        notesOccupied = tuplet.getNotesOccupied();
        this.applyTickMultiplier(noteCount, notesOccupied);
      }
      return this;
    }
    while (this.tupletStack.length) {
      tuplet = this.tupletStack.pop();
      noteCount = tuplet.getNoteCount();
      notesOccupied = tuplet.getNotesOccupied();
      this.applyTickMultiplier(noteCount, notesOccupied);
    }
    return this;
  }
  setTuplet(tuplet) {
    if (tuplet) {
      this.tupletStack.push(tuplet);
      const noteCount = tuplet.getNoteCount();
      const notesOccupied = tuplet.getNotesOccupied();
      this.applyTickMultiplier(notesOccupied, noteCount);
    }
    this.tuplet = tuplet;
    return this;
  }
  addToModifierContext(mc) {
    this.modifierContext = mc;
    for (let i = 0; i < this.modifiers.length; ++i) {
      this.modifierContext.addMember(this.modifiers[i]);
    }
    this.modifierContext.addMember(this);
    this._preFormatted = false;
    return this;
  }
  addModifier(modifier, index = 0) {
    this.modifiers.push(modifier);
    this._preFormatted = false;
    return this;
  }
  getModifiers() {
    return this.modifiers;
  }
  setTickContext(tc) {
    this.tickContext = tc;
    this._preFormatted = false;
  }
  checkTickContext(message = "Tickable has no tick context.") {
    return defined(this.tickContext, "NoTickContext", message);
  }
  preFormat() {
    if (this._preFormatted)
      return;
    this.width = 0;
    if (this.modifierContext) {
      this.modifierContext.preFormat();
      this.width += this.modifierContext.getWidth();
    }
  }
  set preFormatted(value) {
    this._preFormatted = value;
  }
  get preFormatted() {
    return this._preFormatted;
  }
  postFormat() {
    if (this._postFormatted)
      return this;
    this._postFormatted = true;
    return this;
  }
  set postFormatted(value) {
    this._postFormatted = value;
  }
  get postFormatted() {
    return this._postFormatted;
  }
  getIntrinsicTicks() {
    return this.intrinsicTicks;
  }
  setIntrinsicTicks(intrinsicTicks) {
    this.intrinsicTicks = intrinsicTicks;
    this.ticks = this.tickMultiplier.clone().multiply(this.intrinsicTicks);
  }
  getTickMultiplier() {
    return this.tickMultiplier;
  }
  applyTickMultiplier(numerator, denominator) {
    this.tickMultiplier.multiply(numerator, denominator);
    this.ticks = this.tickMultiplier.clone().multiply(this.intrinsicTicks);
  }
  setDuration(duration) {
    const ticks = duration.numerator * (Tables.RESOLUTION / duration.denominator);
    this.ticks = this.tickMultiplier.clone().multiply(ticks);
    this.intrinsicTicks = this.ticks.value();
  }
  getAbsoluteX() {
    const tickContext = this.checkTickContext(`Can't getAbsoluteX() without a TickContext.`);
    return tickContext.getX();
  }
  setModifierContext(mc) {
    this.modifierContext = mc;
    return this;
  }
  getModifierContext() {
    return this.modifierContext;
  }
  checkModifierContext() {
    return defined(this.modifierContext, "NoModifierContext", "No modifier context attached to this tickable.");
  }
};

// node_modules/vexflow/build/esm/src/note.js
var Note = class _Note extends Tickable {
  static get CATEGORY() {
    return "Note";
  }
  static plotMetrics(ctx, note, yPos) {
    const metrics = note.getMetrics();
    const xStart = note.getAbsoluteX() - metrics.modLeftPx - metrics.leftDisplacedHeadPx;
    const xPre1 = note.getAbsoluteX() - metrics.leftDisplacedHeadPx;
    const xAbs = note.getAbsoluteX();
    const xPost1 = note.getAbsoluteX() + metrics.notePx;
    const xPost2 = note.getAbsoluteX() + metrics.notePx + metrics.rightDisplacedHeadPx;
    const xEnd = note.getAbsoluteX() + metrics.notePx + metrics.rightDisplacedHeadPx + metrics.modRightPx;
    const xFreedomRight = xEnd + (note.getFormatterMetrics().freedom.right || 0);
    const xWidth = xEnd - xStart;
    ctx.save();
    ctx.setFont(Font.SANS_SERIF, 8);
    ctx.fillText(Math.round(xWidth) + "px", xStart + note.getXShift(), yPos);
    const y = yPos + 7;
    function stroke(x1, x2, color, yy = y) {
      ctx.beginPath();
      ctx.setStrokeStyle(color);
      ctx.setFillStyle(color);
      ctx.setLineWidth(3);
      ctx.moveTo(x1 + note.getXShift(), yy);
      ctx.lineTo(x2 + note.getXShift(), yy);
      ctx.stroke();
    }
    stroke(xStart, xPre1, "red");
    stroke(xPre1, xAbs, "#999");
    stroke(xAbs, xPost1, "green");
    stroke(xPost1, xPost2, "#999");
    stroke(xPost2, xEnd, "red");
    stroke(xEnd, xFreedomRight, "#DD0");
    stroke(xStart - note.getXShift(), xStart, "#BBB");
    drawDot(ctx, xAbs + note.getXShift(), y, "blue");
    const formatterMetrics = note.getFormatterMetrics();
    if (formatterMetrics.iterations > 0) {
      const spaceDeviation = formatterMetrics.space.deviation;
      const prefix2 = spaceDeviation >= 0 ? "+" : "";
      ctx.setFillStyle("red");
      ctx.fillText(prefix2 + Math.round(spaceDeviation), xAbs + note.getXShift(), yPos - 10);
    }
    ctx.restore();
  }
  static parseDuration(durationString) {
    if (!durationString) {
      return void 0;
    }
    const regexp = /(\d*\/?\d+|[a-z])(d*)([nrhms]|$)/;
    const result = regexp.exec(durationString);
    if (!result) {
      return void 0;
    }
    const duration = result[1];
    const dots = result[2].length;
    const type = result[3] || "n";
    return { duration, dots, type };
  }
  static parseNoteStruct(noteStruct) {
    const durationProps = _Note.parseDuration(noteStruct.duration);
    if (!durationProps) {
      return void 0;
    }
    let type = noteStruct.type;
    if (type && !Tables.validTypes[type]) {
      return void 0;
    }
    const customTypes = [];
    if (!type) {
      type = durationProps.type || "n";
      if (noteStruct.keys !== void 0) {
        noteStruct.keys.forEach((k, i) => {
          const result = k.split("/");
          customTypes[i] = result && result.length === 3 ? result[2] : type;
        });
      }
    }
    let ticks = Tables.durationToTicks(durationProps.duration);
    if (!ticks) {
      return void 0;
    }
    const dots = noteStruct.dots ? noteStruct.dots : durationProps.dots;
    if (typeof dots !== "number") {
      return void 0;
    }
    let currentTicks = ticks;
    for (let i = 0; i < dots; i++) {
      if (currentTicks <= 1)
        return void 0;
      currentTicks = currentTicks / 2;
      ticks += currentTicks;
    }
    return {
      duration: durationProps.duration,
      type,
      customTypes,
      dots,
      ticks
    };
  }
  constructor(noteStruct) {
    super();
    if (!noteStruct) {
      throw new RuntimeError("BadArguments", "Note must have valid initialization data to identify duration and type.");
    }
    const parsedNoteStruct = _Note.parseNoteStruct(noteStruct);
    if (!parsedNoteStruct) {
      throw new RuntimeError("BadArguments", `Invalid note initialization object: ${JSON.stringify(noteStruct)}`);
    }
    this.keys = noteStruct.keys || [];
    this.keyProps = [];
    this.duration = parsedNoteStruct.duration;
    this.noteType = parsedNoteStruct.type;
    this.customTypes = parsedNoteStruct.customTypes;
    if (noteStruct.duration_override) {
      this.setDuration(noteStruct.duration_override);
    } else {
      this.setIntrinsicTicks(parsedNoteStruct.ticks);
    }
    this.modifiers = [];
    this.glyphProps = Tables.getGlyphProps(this.duration, this.noteType);
    this.customGlyphs = this.customTypes.map((t) => Tables.getGlyphProps(this.duration, t));
    this.playNote = void 0;
    this.ignore_ticks = false;
    this.width = 0;
    this.leftDisplacedHeadPx = 0;
    this.rightDisplacedHeadPx = 0;
    this.x_shift = 0;
    this.ys = [];
    if (noteStruct.align_center) {
      this.setCenterAlignment(noteStruct.align_center);
    }
    this.render_options = {
      annotation_spacing: 5,
      glyph_font_scale: 1,
      stroke_px: 1,
      scale: 1,
      font: "",
      y_shift: 0
    };
  }
  getPlayNote() {
    return this.playNote;
  }
  setPlayNote(note) {
    this.playNote = note;
    return this;
  }
  isRest() {
    return false;
  }
  addStroke(index, stroke) {
    stroke.setNote(this);
    stroke.setIndex(index);
    this.modifiers.push(stroke);
    this.preFormatted = false;
    return this;
  }
  getStave() {
    return this.stave;
  }
  checkStave() {
    return defined(this.stave, "NoStave", "No stave attached to instance.");
  }
  setStave(stave) {
    this.stave = stave;
    this.setYs([stave.getYForLine(0)]);
    this.setContext(this.stave.getContext());
    return this;
  }
  getLeftDisplacedHeadPx() {
    return this.leftDisplacedHeadPx;
  }
  getRightDisplacedHeadPx() {
    return this.rightDisplacedHeadPx;
  }
  setLeftDisplacedHeadPx(x) {
    this.leftDisplacedHeadPx = x;
    return this;
  }
  setRightDisplacedHeadPx(x) {
    this.rightDisplacedHeadPx = x;
    return this;
  }
  shouldIgnoreTicks() {
    return this.ignore_ticks;
  }
  getLineNumber(isTopNote) {
    return 0;
  }
  getLineForRest() {
    return 0;
  }
  getGlyph() {
    return this.glyphProps;
  }
  getGlyphProps() {
    return this.glyphProps;
  }
  getGlyphWidth() {
    return this.glyphProps.getWidth(this.render_options.glyph_font_scale);
  }
  setYs(ys) {
    this.ys = ys;
    return this;
  }
  getYs() {
    if (this.ys.length === 0) {
      throw new RuntimeError("NoYValues", "No Y-values calculated for this note.");
    }
    return this.ys;
  }
  getYForTopText(text_line) {
    return this.checkStave().getYForTopText(text_line);
  }
  getVoice() {
    if (!this.voice)
      throw new RuntimeError("NoVoice", "Note has no voice.");
    return this.voice;
  }
  setVoice(voice) {
    this.voice = voice;
    this.preFormatted = false;
    return this;
  }
  getTickContext() {
    return this.checkTickContext();
  }
  setTickContext(tc) {
    this.tickContext = tc;
    this.preFormatted = false;
    return this;
  }
  getDuration() {
    return this.duration;
  }
  isDotted() {
    return this.getModifiersByType("Dot").length > 0;
  }
  hasStem() {
    return false;
  }
  getNoteType() {
    return this.noteType;
  }
  getBeam() {
    return this.beam;
  }
  checkBeam() {
    return defined(this.beam, "NoBeam", "No beam attached to instance");
  }
  hasBeam() {
    return this.beam != void 0;
  }
  setBeam(beam) {
    this.beam = beam;
    return this;
  }
  addModifier(modifier, index = 0) {
    const signature = "Note.addModifier(modifier: Modifier, index: number=0)";
    if (typeof index === "string") {
      index = parseInt(index);
      console.warn(signature + " expected a number for `index`, but received a string.");
    }
    if (typeof modifier !== "object" || typeof index !== "number") {
      throw new RuntimeError("WrongParams", "Incorrect call signature. Use " + signature + " instead.");
    }
    modifier.setNote(this);
    modifier.setIndex(index);
    super.addModifier(modifier);
    return this;
  }
  getModifiersByType(type) {
    return this.modifiers.filter((modifier) => modifier.getCategory() === type);
  }
  getModifierStartXY(position, index, options) {
    if (!this.preFormatted) {
      throw new RuntimeError("UnformattedNote", "Can't call GetModifierStartXY on an unformatted note");
    }
    return {
      x: this.getAbsoluteX(),
      y: this.ys[0]
    };
  }
  getRightParenthesisPx(index) {
    const props = this.getKeyProps()[index];
    return props.displaced ? this.getRightDisplacedHeadPx() : 0;
  }
  getLeftParenthesisPx(index) {
    const props = this.getKeyProps()[index];
    return props.displaced ? this.getLeftDisplacedHeadPx() - this.x_shift : -this.x_shift;
  }
  getFirstDotPx() {
    let px = this.getRightDisplacedHeadPx();
    if (this.checkModifierContext().getMembers("Parenthesis").length !== 0)
      px += Tables.currentMusicFont().lookupMetric("parenthesis.default.width");
    return px;
  }
  getMetrics() {
    if (!this.preFormatted) {
      throw new RuntimeError("UnformattedNote", "Can't call getMetrics on an unformatted note.");
    }
    const modLeftPx = this.modifierContext ? this.modifierContext.getState().left_shift : 0;
    const modRightPx = this.modifierContext ? this.modifierContext.getState().right_shift : 0;
    const width = this.getWidth();
    const glyphWidth = this.getGlyphWidth();
    const notePx = width - modLeftPx - modRightPx - this.leftDisplacedHeadPx - this.rightDisplacedHeadPx;
    return {
      width,
      glyphWidth,
      notePx,
      modLeftPx,
      modRightPx,
      leftDisplacedHeadPx: this.leftDisplacedHeadPx,
      rightDisplacedHeadPx: this.rightDisplacedHeadPx,
      glyphPx: 0
    };
  }
  getAbsoluteX() {
    const tickContext = this.checkTickContext(`Can't getAbsoluteX() without a TickContext.`);
    let x = tickContext.getX();
    if (this.stave) {
      x += this.stave.getNoteStartX() + Tables.currentMusicFont().lookupMetric("stave.padding");
    }
    if (this.isCenterAligned()) {
      x += this.getCenterXShift();
    }
    return x;
  }
  static getPoint(size) {
    return size == "default" ? Tables.NOTATION_FONT_SCALE : Tables.NOTATION_FONT_SCALE / 5 * 3;
  }
  getStemDirection() {
    throw new RuntimeError("NoStem", "No stem attached to this note.");
  }
  getStemExtents() {
    throw new RuntimeError("NoStem", "No stem attached to this note.");
  }
  getTieRightX() {
    let tieStartX = this.getAbsoluteX();
    const note_glyph_width = this.glyphProps.getWidth();
    tieStartX += note_glyph_width / 2;
    tieStartX += -this.width / 2 + this.width + 2;
    return tieStartX;
  }
  getTieLeftX() {
    let tieEndX = this.getAbsoluteX();
    const note_glyph_width = this.glyphProps.getWidth();
    tieEndX += note_glyph_width / 2;
    tieEndX -= this.width / 2 + 2;
    return tieEndX;
  }
  getKeys() {
    return this.keys;
  }
  getKeyProps() {
    return this.keyProps;
  }
};

// node_modules/vexflow/build/esm/src/stavemodifier.js
var StaveModifierPosition;
(function(StaveModifierPosition2) {
  StaveModifierPosition2[StaveModifierPosition2["CENTER"] = 0] = "CENTER";
  StaveModifierPosition2[StaveModifierPosition2["LEFT"] = 1] = "LEFT";
  StaveModifierPosition2[StaveModifierPosition2["RIGHT"] = 2] = "RIGHT";
  StaveModifierPosition2[StaveModifierPosition2["ABOVE"] = 3] = "ABOVE";
  StaveModifierPosition2[StaveModifierPosition2["BELOW"] = 4] = "BELOW";
  StaveModifierPosition2[StaveModifierPosition2["BEGIN"] = 5] = "BEGIN";
  StaveModifierPosition2[StaveModifierPosition2["END"] = 6] = "END";
})(StaveModifierPosition || (StaveModifierPosition = {}));
var StaveModifier = class extends Element {
  static get CATEGORY() {
    return "StaveModifier";
  }
  static get Position() {
    return StaveModifierPosition;
  }
  constructor() {
    super();
    this.width = 0;
    this.x = 0;
    this.padding = 10;
    this.position = StaveModifierPosition.ABOVE;
  }
  getPosition() {
    return this.position;
  }
  setPosition(position) {
    this.position = position;
    return this;
  }
  getStave() {
    return this.stave;
  }
  checkStave() {
    return defined(this.stave, "NoStave", "No stave attached to instance.");
  }
  setStave(stave) {
    this.stave = stave;
    return this;
  }
  getWidth() {
    return this.width;
  }
  setWidth(width) {
    this.width = width;
    return this;
  }
  getX() {
    return this.x;
  }
  setX(x) {
    this.x = x;
    return this;
  }
  placeGlyphOnLine(glyph, stave, line, customShift = 0) {
    glyph.setYShift(stave.getYForLine(line !== null && line !== void 0 ? line : 0) - stave.getYForGlyphs() + customShift);
  }
  getPadding(index) {
    return index !== void 0 && index < 2 ? 0 : this.padding;
  }
  setPadding(padding) {
    this.padding = padding;
    return this;
  }
  setLayoutMetrics(layoutMetrics) {
    this.layoutMetrics = layoutMetrics;
    return this;
  }
  getLayoutMetrics() {
    return this.layoutMetrics;
  }
  draw(...args) {
  }
};

// node_modules/vexflow/build/esm/src/stavebarline.js
var BarlineType;
(function(BarlineType2) {
  BarlineType2[BarlineType2["SINGLE"] = 1] = "SINGLE";
  BarlineType2[BarlineType2["DOUBLE"] = 2] = "DOUBLE";
  BarlineType2[BarlineType2["END"] = 3] = "END";
  BarlineType2[BarlineType2["REPEAT_BEGIN"] = 4] = "REPEAT_BEGIN";
  BarlineType2[BarlineType2["REPEAT_END"] = 5] = "REPEAT_END";
  BarlineType2[BarlineType2["REPEAT_BOTH"] = 6] = "REPEAT_BOTH";
  BarlineType2[BarlineType2["NONE"] = 7] = "NONE";
})(BarlineType || (BarlineType = {}));
var Barline = class _Barline extends StaveModifier {
  static get CATEGORY() {
    return "Barline";
  }
  static get type() {
    return BarlineType;
  }
  static get typeString() {
    return {
      single: BarlineType.SINGLE,
      double: BarlineType.DOUBLE,
      end: BarlineType.END,
      repeatBegin: BarlineType.REPEAT_BEGIN,
      repeatEnd: BarlineType.REPEAT_END,
      repeatBoth: BarlineType.REPEAT_BOTH,
      none: BarlineType.NONE
    };
  }
  constructor(type) {
    super();
    this.thickness = Tables.STAVE_LINE_THICKNESS;
    const TYPE = BarlineType;
    this.widths = {};
    this.widths[TYPE.SINGLE] = 5;
    this.widths[TYPE.DOUBLE] = 5;
    this.widths[TYPE.END] = 5;
    this.widths[TYPE.REPEAT_BEGIN] = 5;
    this.widths[TYPE.REPEAT_END] = 5;
    this.widths[TYPE.REPEAT_BOTH] = 5;
    this.widths[TYPE.NONE] = 5;
    this.paddings = {};
    this.paddings[TYPE.SINGLE] = 0;
    this.paddings[TYPE.DOUBLE] = 0;
    this.paddings[TYPE.END] = 0;
    this.paddings[TYPE.REPEAT_BEGIN] = 15;
    this.paddings[TYPE.REPEAT_END] = 15;
    this.paddings[TYPE.REPEAT_BOTH] = 15;
    this.paddings[TYPE.NONE] = 0;
    this.layoutMetricsMap = {};
    this.layoutMetricsMap[TYPE.SINGLE] = {
      xMin: 0,
      xMax: 1,
      paddingLeft: 5,
      paddingRight: 5
    };
    this.layoutMetricsMap[TYPE.DOUBLE] = {
      xMin: -3,
      xMax: 1,
      paddingLeft: 5,
      paddingRight: 5
    };
    this.layoutMetricsMap[TYPE.END] = {
      xMin: -5,
      xMax: 1,
      paddingLeft: 5,
      paddingRight: 5
    };
    this.layoutMetricsMap[TYPE.REPEAT_END] = {
      xMin: -10,
      xMax: 1,
      paddingLeft: 5,
      paddingRight: 5
    };
    this.layoutMetricsMap[TYPE.REPEAT_BEGIN] = {
      xMin: -2,
      xMax: 10,
      paddingLeft: 5,
      paddingRight: 5
    };
    this.layoutMetricsMap[TYPE.REPEAT_BOTH] = {
      xMin: -10,
      xMax: 10,
      paddingLeft: 5,
      paddingRight: 5
    };
    this.layoutMetricsMap[TYPE.NONE] = {
      xMin: 0,
      xMax: 0,
      paddingLeft: 5,
      paddingRight: 5
    };
    this.setPosition(StaveModifierPosition.BEGIN);
    this.setType(type);
  }
  getType() {
    return this.type;
  }
  setType(type) {
    this.type = typeof type === "string" ? _Barline.typeString[type] : type;
    this.setWidth(this.widths[this.type]);
    this.setPadding(this.paddings[this.type]);
    this.setLayoutMetrics(this.layoutMetricsMap[this.type]);
    return this;
  }
  draw(stave) {
    const ctx = stave.checkContext();
    this.setRendered();
    this.applyStyle(ctx);
    ctx.openGroup("stavebarline", this.getAttribute("id"));
    switch (this.type) {
      case BarlineType.SINGLE:
        this.drawVerticalBar(stave, this.x, false);
        break;
      case BarlineType.DOUBLE:
        this.drawVerticalBar(stave, this.x, true);
        break;
      case BarlineType.END:
        this.drawVerticalEndBar(stave, this.x);
        break;
      case BarlineType.REPEAT_BEGIN:
        this.drawRepeatBar(stave, this.x, true);
        if (stave.getX() !== this.x) {
          this.drawVerticalBar(stave, stave.getX());
        }
        break;
      case BarlineType.REPEAT_END:
        this.drawRepeatBar(stave, this.x, false);
        break;
      case BarlineType.REPEAT_BOTH:
        this.drawRepeatBar(stave, this.x, false);
        this.drawRepeatBar(stave, this.x, true);
        break;
      default:
        break;
    }
    ctx.closeGroup();
    this.restoreStyle(ctx);
  }
  drawVerticalBar(stave, x, double_bar) {
    const staveCtx = stave.checkContext();
    const topY = stave.getTopLineTopY();
    const botY = stave.getBottomLineBottomY();
    if (double_bar) {
      staveCtx.fillRect(x - 3, topY, 1, botY - topY);
    }
    staveCtx.fillRect(x, topY, 1, botY - topY);
  }
  drawVerticalEndBar(stave, x) {
    const staveCtx = stave.checkContext();
    const topY = stave.getTopLineTopY();
    const botY = stave.getBottomLineBottomY();
    staveCtx.fillRect(x - 5, topY, 1, botY - topY);
    staveCtx.fillRect(x - 2, topY, 3, botY - topY);
  }
  drawRepeatBar(stave, x, begin) {
    const staveCtx = stave.checkContext();
    const topY = stave.getTopLineTopY();
    const botY = stave.getBottomLineBottomY();
    let x_shift = 3;
    if (!begin) {
      x_shift = -5;
    }
    staveCtx.fillRect(x + x_shift, topY, 1, botY - topY);
    staveCtx.fillRect(x - 2, topY, 3, botY - topY);
    const dot_radius = 2;
    if (begin) {
      x_shift += 4;
    } else {
      x_shift -= 4;
    }
    const dot_x = x + x_shift + dot_radius / 2;
    let y_offset = (stave.getNumLines() - 1) * stave.getSpacingBetweenLines();
    y_offset = y_offset / 2 - stave.getSpacingBetweenLines() / 2;
    let dot_y = topY + y_offset + dot_radius / 2;
    staveCtx.beginPath();
    staveCtx.arc(dot_x, dot_y, dot_radius, 0, Math.PI * 2, false);
    staveCtx.fill();
    dot_y += stave.getSpacingBetweenLines();
    staveCtx.beginPath();
    staveCtx.arc(dot_x, dot_y, dot_radius, 0, Math.PI * 2, false);
    staveCtx.fill();
  }
};

// node_modules/vexflow/build/esm/src/barnote.js
function L6(...args) {
  if (BarNote.DEBUG)
    log("Vex.Flow.BarNote", args);
}
var BarNote = class extends Note {
  static get CATEGORY() {
    return "BarNote";
  }
  constructor(type = BarlineType.SINGLE) {
    super({ duration: "b" });
    this.metrics = {
      widths: {}
    };
    const TYPE = BarlineType;
    this.metrics.widths = {
      [TYPE.SINGLE]: 8,
      [TYPE.DOUBLE]: 12,
      [TYPE.END]: 15,
      [TYPE.REPEAT_BEGIN]: 14,
      [TYPE.REPEAT_END]: 14,
      [TYPE.REPEAT_BOTH]: 18,
      [TYPE.NONE]: 0
    };
    this.ignore_ticks = true;
    this.setType(type);
  }
  getType() {
    return this.type;
  }
  setType(type) {
    this.type = typeof type === "string" ? Barline.typeString[type] : type;
    this.setWidth(this.metrics.widths[this.type]);
    return this;
  }
  addToModifierContext(mc) {
    return this;
  }
  preFormat() {
    this.preFormatted = true;
    return this;
  }
  draw() {
    const ctx = this.checkContext();
    L6("Rendering bar line at: ", this.getAbsoluteX());
    this.applyStyle(ctx);
    const barline = new Barline(this.type);
    barline.setX(this.getAbsoluteX());
    barline.draw(this.checkStave());
    this.restoreStyle(ctx);
    this.setRendered();
  }
};
BarNote.DEBUG = false;

// node_modules/vexflow/build/esm/src/beam.js
function calculateStemDirection(notes) {
  let lineSum = 0;
  notes.forEach((note) => {
    if (note.keyProps) {
      note.keyProps.forEach((keyProp) => {
        lineSum += keyProp.line - 3;
      });
    }
  });
  if (lineSum >= 0) {
    return Stem.DOWN;
  }
  return Stem.UP;
}
function getStemSlope(firstNote, lastNote) {
  const firstStemTipY = firstNote.getStemExtents().topY;
  const firstStemX = firstNote.getStemX();
  const lastStemTipY = lastNote.getStemExtents().topY;
  const lastStemX = lastNote.getStemX();
  return (lastStemTipY - firstStemTipY) / (lastStemX - firstStemX);
}
var BEAM_LEFT = "L";
var BEAM_RIGHT = "R";
var BEAM_BOTH = "B";
var Beam = class _Beam extends Element {
  static get CATEGORY() {
    return "Beam";
  }
  getStemDirection() {
    return this.stem_direction;
  }
  static getDefaultBeamGroups(time_sig) {
    if (!time_sig || time_sig === "c") {
      time_sig = "4/4";
    }
    const defaults = {
      "1/2": ["1/2"],
      "2/2": ["1/2"],
      "3/2": ["1/2"],
      "4/2": ["1/2"],
      "1/4": ["1/4"],
      "2/4": ["1/4"],
      "3/4": ["1/4"],
      "4/4": ["1/4"],
      "1/8": ["1/8"],
      "2/8": ["2/8"],
      "3/8": ["3/8"],
      "4/8": ["2/8"],
      "1/16": ["1/16"],
      "2/16": ["2/16"],
      "3/16": ["3/16"],
      "4/16": ["2/16"]
    };
    const groups = defaults[time_sig];
    if (groups === void 0) {
      const beatTotal = parseInt(time_sig.split("/")[0], 10);
      const beatValue = parseInt(time_sig.split("/")[1], 10);
      const tripleMeter = beatTotal % 3 === 0;
      if (tripleMeter) {
        return [new Fraction(3, beatValue)];
      } else if (beatValue > 4) {
        return [new Fraction(2, beatValue)];
      } else if (beatValue <= 4) {
        return [new Fraction(1, beatValue)];
      }
    } else {
      return groups.map((group) => new Fraction().parse(group));
    }
    return [new Fraction(1, 4)];
  }
  static applyAndGetBeams(voice, stem_direction, groups) {
    return _Beam.generateBeams(voice.getTickables(), { groups, stem_direction });
  }
  static generateBeams(notes, config = {}) {
    if (!config.groups || !config.groups.length) {
      config.groups = [new Fraction(2, 8)];
    }
    const tickGroups = config.groups.map((group) => {
      if (!group.multiply) {
        throw new RuntimeError("InvalidBeamGroups", "The beam groups must be an array of Vex.Flow.Fractions");
      }
      return group.clone().multiply(Tables.RESOLUTION, 1);
    });
    const unprocessedNotes = notes;
    let currentTickGroup = 0;
    let noteGroups = [];
    let currentGroup = [];
    function getTotalTicks(vf_notes) {
      return vf_notes.reduce((memo, note) => note.getTicks().clone().add(memo), new Fraction(0, 1));
    }
    function nextTickGroup() {
      if (tickGroups.length - 1 > currentTickGroup) {
        currentTickGroup += 1;
      } else {
        currentTickGroup = 0;
      }
    }
    function createGroups() {
      let nextGroup = [];
      let currentGroupTotalTicks = new Fraction(0, 1);
      unprocessedNotes.forEach((unprocessedNote) => {
        nextGroup = [];
        if (unprocessedNote.shouldIgnoreTicks()) {
          noteGroups.push(currentGroup);
          currentGroup = nextGroup;
          return;
        }
        currentGroup.push(unprocessedNote);
        const ticksPerGroup = tickGroups[currentTickGroup].clone();
        const totalTicks = getTotalTicks(currentGroup).add(currentGroupTotalTicks);
        const unbeamable = Tables.durationToNumber(unprocessedNote.getDuration()) < 8;
        if (unbeamable && unprocessedNote.getTuplet()) {
          ticksPerGroup.numerator *= 2;
        }
        if (totalTicks.greaterThan(ticksPerGroup)) {
          if (!unbeamable) {
            const note = currentGroup.pop();
            if (note)
              nextGroup.push(note);
          }
          noteGroups.push(currentGroup);
          do {
            currentGroupTotalTicks = totalTicks.subtract(tickGroups[currentTickGroup]);
            nextTickGroup();
          } while (currentGroupTotalTicks.greaterThanEquals(tickGroups[currentTickGroup]));
          currentGroup = nextGroup;
        } else if (totalTicks.equals(ticksPerGroup)) {
          noteGroups.push(currentGroup);
          currentGroupTotalTicks = new Fraction(0, 1);
          currentGroup = nextGroup;
          nextTickGroup();
        }
      });
      if (currentGroup.length > 0) {
        noteGroups.push(currentGroup);
      }
    }
    function getBeamGroups() {
      return noteGroups.filter((group) => {
        if (group.length > 1) {
          let beamable = true;
          group.forEach((note) => {
            if (note.getIntrinsicTicks() >= Tables.durationToTicks("4")) {
              beamable = false;
            }
          });
          return beamable;
        }
        return false;
      });
    }
    function sanitizeGroups() {
      const sanitizedGroups = [];
      noteGroups.forEach((group) => {
        let tempGroup = [];
        group.forEach((note, index, group2) => {
          const isFirstOrLast = index === 0 || index === group2.length - 1;
          const prevNote = group2[index - 1];
          const breaksOnEachRest = !config.beam_rests && note.isRest();
          const breaksOnFirstOrLastRest = config.beam_rests && config.beam_middle_only && note.isRest() && isFirstOrLast;
          let breakOnStemChange = false;
          if (config.maintain_stem_directions && prevNote && !note.isRest() && !prevNote.isRest()) {
            const prevDirection = prevNote.getStemDirection();
            const currentDirection = note.getStemDirection();
            breakOnStemChange = currentDirection !== prevDirection;
          }
          const isUnbeamableDuration = parseInt(note.getDuration(), 10) < 8;
          const shouldBreak = breaksOnEachRest || breaksOnFirstOrLastRest || breakOnStemChange || isUnbeamableDuration;
          if (shouldBreak) {
            if (tempGroup.length > 0) {
              sanitizedGroups.push(tempGroup);
            }
            tempGroup = breakOnStemChange ? [note] : [];
          } else {
            tempGroup.push(note);
          }
        });
        if (tempGroup.length > 0) {
          sanitizedGroups.push(tempGroup);
        }
      });
      noteGroups = sanitizedGroups;
    }
    function formatStems() {
      noteGroups.forEach((group) => {
        let stemDirection;
        if (config.maintain_stem_directions) {
          const note = findFirstNote(group);
          stemDirection = note ? note.getStemDirection() : Stem.UP;
        } else {
          if (config.stem_direction) {
            stemDirection = config.stem_direction;
          } else {
            stemDirection = calculateStemDirection(group);
          }
        }
        applyStemDirection(group, stemDirection);
      });
    }
    function findFirstNote(group) {
      for (let i = 0; i < group.length; i++) {
        const note = group[i];
        if (!note.isRest()) {
          return note;
        }
      }
      return false;
    }
    function applyStemDirection(group, direction) {
      group.forEach((note) => {
        note.setStemDirection(direction);
      });
    }
    function getTuplets() {
      const uniqueTuplets = [];
      noteGroups.forEach((group) => {
        let tuplet;
        group.forEach((note) => {
          const noteTuplet = note.getTuplet();
          if (noteTuplet && tuplet !== noteTuplet) {
            tuplet = noteTuplet;
            uniqueTuplets.push(tuplet);
          }
        });
      });
      return uniqueTuplets;
    }
    createGroups();
    sanitizeGroups();
    formatStems();
    const beamedNoteGroups = getBeamGroups();
    const allTuplets = getTuplets();
    const beams = [];
    beamedNoteGroups.forEach((group) => {
      const beam = new _Beam(group);
      if (config.show_stemlets) {
        beam.render_options.show_stemlets = true;
      }
      if (config.secondary_breaks) {
        beam.render_options.secondary_break_ticks = Tables.durationToTicks(config.secondary_breaks);
      }
      if (config.flat_beams === true) {
        beam.render_options.flat_beams = true;
        beam.render_options.flat_beam_offset = config.flat_beam_offset;
      }
      beams.push(beam);
    });
    allTuplets.forEach((tuplet) => {
      const direction = tuplet.notes[0].stem_direction === Stem.DOWN ? -1 : 1;
      tuplet.setTupletLocation(direction);
      let bracketed = false;
      for (let i = 0; i < tuplet.notes.length; i++) {
        const note = tuplet.notes[i];
        if (!note.hasBeam()) {
          bracketed = true;
          break;
        }
      }
      tuplet.setBracketed(bracketed);
    });
    return beams;
  }
  constructor(notes, auto_stem = false) {
    super();
    this.slope = 0;
    this.y_shift = 0;
    this.forcedPartialDirections = {};
    if (!notes || notes.length === 0) {
      throw new RuntimeError("BadArguments", "No notes provided for beam.");
    }
    if (notes.length === 1) {
      throw new RuntimeError("BadArguments", "Too few notes for beam.");
    }
    this.ticks = notes[0].getIntrinsicTicks();
    if (this.ticks >= Tables.durationToTicks("4")) {
      throw new RuntimeError("BadArguments", "Beams can only be applied to notes shorter than a quarter note.");
    }
    let i;
    let note;
    this.stem_direction = notes[0].getStemDirection();
    let stem_direction = this.stem_direction;
    if (auto_stem && isStaveNote(notes[0])) {
      stem_direction = calculateStemDirection(notes);
    } else if (auto_stem && isTabNote(notes[0])) {
      const stem_weight = notes.reduce((memo, note2) => memo + note2.getStemDirection(), 0);
      stem_direction = stem_weight > -1 ? Stem.UP : Stem.DOWN;
    }
    for (i = 0; i < notes.length; ++i) {
      note = notes[i];
      if (auto_stem) {
        note.setStemDirection(stem_direction);
        this.stem_direction = stem_direction;
      }
      note.setBeam(this);
    }
    this.postFormatted = false;
    this.notes = notes;
    this.beam_count = this.getBeamCount();
    this.break_on_indices = [];
    this.render_options = {
      beam_width: 5,
      max_slope: 0.25,
      min_slope: -0.25,
      slope_iterations: 20,
      slope_cost: 100,
      show_stemlets: false,
      stemlet_extension: 7,
      partial_beam_length: 10,
      flat_beams: false,
      min_flat_beam_offset: 15
    };
  }
  getNotes() {
    return this.notes;
  }
  getBeamCount() {
    const beamCounts = this.notes.map((note) => note.getGlyphProps().beam_count);
    const maxBeamCount = beamCounts.reduce((max, beamCount) => beamCount > max ? beamCount : max);
    return maxBeamCount;
  }
  breakSecondaryAt(indices) {
    this.break_on_indices = indices;
    return this;
  }
  setPartialBeamSideAt(noteIndex, side) {
    this.forcedPartialDirections[noteIndex] = side;
    return this;
  }
  unsetPartialBeamSideAt(noteIndex) {
    delete this.forcedPartialDirections[noteIndex];
    return this;
  }
  getSlopeY(x, first_x_px, first_y_px, slope) {
    return first_y_px + (x - first_x_px) * slope;
  }
  calculateSlope() {
    const { notes, stem_direction: stemDirection, render_options: { max_slope, min_slope, slope_iterations, slope_cost } } = this;
    const firstNote = notes[0];
    const initialSlope = getStemSlope(firstNote, notes[notes.length - 1]);
    const increment = (max_slope - min_slope) / slope_iterations;
    let minCost = Number.MAX_VALUE;
    let bestSlope = 0;
    let yShift = 0;
    for (let slope = min_slope; slope <= max_slope; slope += increment) {
      let totalStemExtension = 0;
      let yShiftTemp = 0;
      for (let i = 1; i < notes.length; ++i) {
        const note = notes[i];
        if (note.hasStem() || note.isRest()) {
          const adjustedStemTipY = this.getSlopeY(note.getStemX(), firstNote.getStemX(), firstNote.getStemExtents().topY, slope) + yShiftTemp;
          const stemTipY = note.getStemExtents().topY;
          if (stemTipY * stemDirection < adjustedStemTipY * stemDirection) {
            const diff = Math.abs(stemTipY - adjustedStemTipY);
            yShiftTemp += diff * -stemDirection;
            totalStemExtension += diff * i;
          } else {
            totalStemExtension += (stemTipY - adjustedStemTipY) * stemDirection;
          }
        }
      }
      const idealSlope = initialSlope / 2;
      const distanceFromIdeal = Math.abs(idealSlope - slope);
      const cost = slope_cost * distanceFromIdeal + Math.abs(totalStemExtension);
      if (cost < minCost) {
        minCost = cost;
        bestSlope = slope;
        yShift = yShiftTemp;
      }
    }
    this.slope = bestSlope;
    this.y_shift = yShift;
  }
  calculateFlatSlope() {
    const { notes, stem_direction, render_options: { beam_width, min_flat_beam_offset, flat_beam_offset } } = this;
    let total = 0;
    let extremeY = 0;
    let extremeBeamCount = 0;
    let currentExtreme = 0;
    for (let i = 0; i < notes.length; i++) {
      const note = notes[i];
      const stemTipY = note.getStemExtents().topY;
      total += stemTipY;
      if (stem_direction === Stem.DOWN && currentExtreme < stemTipY) {
        currentExtreme = stemTipY;
        extremeY = Math.max(...note.getYs());
        extremeBeamCount = note.getBeamCount();
      } else if (stem_direction === Stem.UP && (currentExtreme === 0 || currentExtreme > stemTipY)) {
        currentExtreme = stemTipY;
        extremeY = Math.min(...note.getYs());
        extremeBeamCount = note.getBeamCount();
      }
    }
    let offset = total / notes.length;
    const beamWidth = beam_width * 1.5;
    const extremeTest = min_flat_beam_offset + extremeBeamCount * beamWidth;
    const newOffset = extremeY + extremeTest * -stem_direction;
    if (stem_direction === Stem.DOWN && offset < newOffset) {
      offset = extremeY + extremeTest;
    } else if (stem_direction === Stem.UP && offset > newOffset) {
      offset = extremeY - extremeTest;
    }
    if (!flat_beam_offset) {
      this.render_options.flat_beam_offset = offset;
    } else if (stem_direction === Stem.DOWN && offset > flat_beam_offset) {
      this.render_options.flat_beam_offset = offset;
    } else if (stem_direction === Stem.UP && offset < flat_beam_offset) {
      this.render_options.flat_beam_offset = offset;
    }
    this.slope = 0;
    this.y_shift = 0;
  }
  getBeamYToDraw() {
    const firstNote = this.notes[0];
    const firstStemTipY = firstNote.getStemExtents().topY;
    let beamY = firstStemTipY;
    if (this.render_options.flat_beams && this.render_options.flat_beam_offset) {
      beamY = this.render_options.flat_beam_offset;
    }
    return beamY;
  }
  applyStemExtensions() {
    const { notes, slope, y_shift, beam_count, render_options: { show_stemlets, stemlet_extension, beam_width } } = this;
    const firstNote = notes[0];
    const firstStemTipY = this.getBeamYToDraw();
    const firstStemX = firstNote.getStemX();
    for (let i = 0; i < notes.length; ++i) {
      const note = notes[i];
      const stem = note.getStem();
      if (stem) {
        const stemX = note.getStemX();
        const { topY: stemTipY } = note.getStemExtents();
        const beamedStemTipY = this.getSlopeY(stemX, firstStemX, firstStemTipY, slope) + y_shift;
        const preBeamExtension = stem.getExtension();
        const beamExtension = note.getStemDirection() === Stem.UP ? stemTipY - beamedStemTipY : beamedStemTipY - stemTipY;
        let crossStemExtension = 0;
        if (note.getStemDirection() !== this.stem_direction) {
          const beamCount = note.getGlyphProps().beam_count;
          crossStemExtension = (1 + (beamCount - 1) * 1.5) * this.render_options.beam_width;
        }
        stem.setExtension(preBeamExtension + beamExtension + crossStemExtension);
        stem.adjustHeightForBeam();
        if (note.isRest() && show_stemlets) {
          const beamWidth = beam_width;
          const totalBeamWidth = (beam_count - 1) * beamWidth * 1.5 + beamWidth;
          stem.setVisibility(true).setStemlet(true, totalBeamWidth + stemlet_extension);
        }
      }
    }
  }
  lookupBeamDirection(duration, prev_tick, tick, next_tick, noteIndex) {
    if (duration === "4") {
      return BEAM_LEFT;
    }
    const forcedBeamDirection = this.forcedPartialDirections[noteIndex];
    if (forcedBeamDirection)
      return forcedBeamDirection;
    const lookup_duration = `${Tables.durationToNumber(duration) / 2}`;
    const prev_note_gets_beam = prev_tick < Tables.durationToTicks(lookup_duration);
    const next_note_gets_beam = next_tick < Tables.durationToTicks(lookup_duration);
    const note_gets_beam = tick < Tables.durationToTicks(lookup_duration);
    if (prev_note_gets_beam && next_note_gets_beam && note_gets_beam) {
      return BEAM_BOTH;
    } else if (prev_note_gets_beam && !next_note_gets_beam && note_gets_beam) {
      return BEAM_LEFT;
    } else if (!prev_note_gets_beam && next_note_gets_beam && note_gets_beam) {
      return BEAM_RIGHT;
    }
    return this.lookupBeamDirection(lookup_duration, prev_tick, tick, next_tick, noteIndex);
  }
  getBeamLines(duration) {
    const tick_of_duration = Tables.durationToTicks(duration);
    let beam_started = false;
    const beam_lines = [];
    let current_beam = void 0;
    const partial_beam_length = this.render_options.partial_beam_length;
    let previous_should_break = false;
    let tick_tally = 0;
    for (let i = 0; i < this.notes.length; ++i) {
      const note = this.notes[i];
      const ticks = note.getTicks().value();
      tick_tally += ticks;
      let should_break = false;
      if (parseInt(duration, 10) >= 8) {
        should_break = this.break_on_indices.indexOf(i) !== -1;
        if (this.render_options.secondary_break_ticks && tick_tally >= this.render_options.secondary_break_ticks) {
          tick_tally = 0;
          should_break = true;
        }
      }
      const note_gets_beam = note.getIntrinsicTicks() < tick_of_duration;
      const stem_x = note.getStemX() - Stem.WIDTH / 2;
      const prev_note = this.notes[i - 1];
      const next_note = this.notes[i + 1];
      const next_note_gets_beam = next_note && next_note.getIntrinsicTicks() < tick_of_duration;
      const prev_note_gets_beam = prev_note && prev_note.getIntrinsicTicks() < tick_of_duration;
      const beam_alone = prev_note && next_note && note_gets_beam && !prev_note_gets_beam && !next_note_gets_beam;
      if (note_gets_beam) {
        if (beam_started) {
          current_beam = beam_lines[beam_lines.length - 1];
          current_beam.end = stem_x;
          if (should_break) {
            beam_started = false;
            if (next_note && !next_note_gets_beam && current_beam.end === void 0) {
              current_beam.end = current_beam.start - partial_beam_length;
            }
          }
        } else {
          current_beam = { start: stem_x, end: void 0 };
          beam_started = true;
          if (beam_alone) {
            const prev_tick = prev_note.getIntrinsicTicks();
            const next_tick = next_note.getIntrinsicTicks();
            const tick = note.getIntrinsicTicks();
            const beam_direction = this.lookupBeamDirection(duration, prev_tick, tick, next_tick, i);
            if ([BEAM_LEFT, BEAM_BOTH].includes(beam_direction)) {
              current_beam.end = current_beam.start - partial_beam_length;
            } else {
              current_beam.end = current_beam.start + partial_beam_length;
            }
          } else if (!next_note_gets_beam) {
            if ((previous_should_break || i === 0) && next_note) {
              current_beam.end = current_beam.start + partial_beam_length;
            } else {
              current_beam.end = current_beam.start - partial_beam_length;
            }
          } else if (should_break) {
            current_beam.end = current_beam.start - partial_beam_length;
            beam_started = false;
          }
          beam_lines.push(current_beam);
        }
      } else {
        beam_started = false;
      }
      previous_should_break = should_break;
    }
    const last_beam = beam_lines[beam_lines.length - 1];
    if (last_beam && last_beam.end === void 0) {
      last_beam.end = last_beam.start - partial_beam_length;
    }
    return beam_lines;
  }
  drawStems(ctx) {
    this.notes.forEach((note) => {
      const stem = note.getStem();
      if (stem) {
        const stem_x = note.getStemX();
        stem.setNoteHeadXBounds(stem_x, stem_x);
        stem.setContext(ctx).draw();
      }
    }, this);
  }
  drawBeamLines(ctx) {
    const valid_beam_durations = ["4", "8", "16", "32", "64"];
    const firstNote = this.notes[0];
    let beamY = this.getBeamYToDraw();
    const firstStemX = firstNote.getStemX();
    const beamThickness = this.render_options.beam_width * this.stem_direction;
    for (let i = 0; i < valid_beam_durations.length; ++i) {
      const duration = valid_beam_durations[i];
      const beamLines = this.getBeamLines(duration);
      for (let j = 0; j < beamLines.length; ++j) {
        const beam_line = beamLines[j];
        const startBeamX = beam_line.start;
        const startBeamY = this.getSlopeY(startBeamX, firstStemX, beamY, this.slope);
        const lastBeamX = beam_line.end;
        if (lastBeamX) {
          const lastBeamY = this.getSlopeY(lastBeamX, firstStemX, beamY, this.slope);
          ctx.beginPath();
          ctx.moveTo(startBeamX, startBeamY);
          ctx.lineTo(startBeamX, startBeamY + beamThickness);
          ctx.lineTo(lastBeamX + 1, lastBeamY + beamThickness);
          ctx.lineTo(lastBeamX + 1, lastBeamY);
          ctx.closePath();
          ctx.fill();
        } else {
          throw new RuntimeError("NoLastBeamX", "lastBeamX undefined.");
        }
      }
      beamY += beamThickness * 1.5;
    }
  }
  preFormat() {
    return this;
  }
  postFormat() {
    if (this.postFormatted)
      return;
    if (isTabNote(this.notes[0]) || this.render_options.flat_beams) {
      this.calculateFlatSlope();
    } else {
      this.calculateSlope();
    }
    this.applyStemExtensions();
    this.postFormatted = true;
  }
  draw() {
    const ctx = this.checkContext();
    this.setRendered();
    if (this.unbeamable)
      return;
    if (!this.postFormatted) {
      this.postFormat();
    }
    this.drawStems(ctx);
    this.applyStyle();
    ctx.openGroup("beam", this.getAttribute("id"));
    this.drawBeamLines(ctx);
    ctx.closeGroup();
    this.restoreStyle();
  }
};

// node_modules/vexflow/build/esm/src/bend.js
var Bend = class _Bend extends Modifier {
  static get CATEGORY() {
    return "Bend";
  }
  static get UP() {
    return 0;
  }
  static get DOWN() {
    return 1;
  }
  static format(bends, state) {
    if (!bends || bends.length === 0)
      return false;
    let last_width = 0;
    for (let i = 0; i < bends.length; ++i) {
      const bend = bends[i];
      const note = bend.checkAttachedNote();
      if (isTabNote(note)) {
        const stringPos = note.leastString() - 1;
        if (state.top_text_line < stringPos) {
          state.top_text_line = stringPos;
        }
      }
      bend.setXShift(last_width);
      last_width = bend.getWidth();
      bend.setTextLine(state.top_text_line);
    }
    state.right_shift += last_width;
    state.top_text_line += 1;
    return true;
  }
  constructor(text, release = false, phrase) {
    super();
    this.text = text;
    this.x_shift = 0;
    this.release = release;
    this.tap = "";
    this.resetFont();
    this.render_options = {
      line_width: 1.5,
      line_style: "#777777",
      bend_width: 8,
      release_width: 8
    };
    if (phrase) {
      this.phrase = phrase;
    } else {
      this.phrase = [{ type: _Bend.UP, text: this.text }];
      if (this.release)
        this.phrase.push({ type: _Bend.DOWN, text: "" });
    }
    this.updateWidth();
  }
  setXShift(value) {
    this.x_shift = value;
    this.updateWidth();
    return this;
  }
  setTap(value) {
    this.tap = value;
    return this;
  }
  getText() {
    return this.text;
  }
  getTextHeight() {
    const textFormatter = TextFormatter.create(this.textFont);
    return textFormatter.maxHeight;
  }
  updateWidth() {
    const textFormatter = TextFormatter.create(this.textFont);
    const measureText = (text) => {
      return textFormatter.getWidthForTextInPx(text);
    };
    let totalWidth = 0;
    for (let i = 0; i < this.phrase.length; ++i) {
      const bend = this.phrase[i];
      if (bend.width !== void 0) {
        totalWidth += bend.width;
      } else {
        const additional_width = bend.type === _Bend.UP ? this.render_options.bend_width : this.render_options.release_width;
        bend.width = Math.max(additional_width, measureText(bend.text)) + 3;
        bend.draw_width = bend.width / 2;
        totalWidth += bend.width;
      }
    }
    this.setWidth(totalWidth + this.x_shift);
    return this;
  }
  draw() {
    var _a;
    const ctx = this.checkContext();
    const note = this.checkAttachedNote();
    this.setRendered();
    const start = note.getModifierStartXY(Modifier.Position.RIGHT, this.index);
    start.x += 3;
    start.y += 0.5;
    const x_shift = this.x_shift;
    const stave = note.checkStave();
    const spacing = stave.getSpacingBetweenLines();
    const lowestY = note.getYs().reduce((a, b) => a < b ? a : b);
    const bend_height = start.y - ((this.text_line + 1) * spacing + start.y - lowestY) + 3;
    const annotation_y = start.y - ((this.text_line + 1) * spacing + start.y - lowestY) - 1;
    const renderBend = (x, y, width, height) => {
      const cp_x = x + width;
      const cp_y = y;
      ctx.save();
      ctx.beginPath();
      ctx.setLineWidth(this.render_options.line_width);
      ctx.setStrokeStyle(this.render_options.line_style);
      ctx.setFillStyle(this.render_options.line_style);
      ctx.moveTo(x, y);
      ctx.quadraticCurveTo(cp_x, cp_y, x + width, height);
      ctx.stroke();
      ctx.restore();
    };
    const renderRelease = (x, y, width, height) => {
      ctx.save();
      ctx.beginPath();
      ctx.setLineWidth(this.render_options.line_width);
      ctx.setStrokeStyle(this.render_options.line_style);
      ctx.setFillStyle(this.render_options.line_style);
      ctx.moveTo(x, height);
      ctx.quadraticCurveTo(x + width, height, x + width, y);
      ctx.stroke();
      ctx.restore();
    };
    const renderArrowHead = (x, y, direction) => {
      const width = 4;
      const yBase = y + width * direction;
      ctx.beginPath();
      ctx.moveTo(x, y);
      ctx.lineTo(x - width, yBase);
      ctx.lineTo(x + width, yBase);
      ctx.closePath();
      ctx.fill();
    };
    const renderText = (x, text) => {
      ctx.save();
      ctx.setFont(this.textFont);
      const render_x = x - ctx.measureText(text).width / 2;
      ctx.fillText(text, render_x, annotation_y);
      ctx.restore();
    };
    let last_bend = void 0;
    let last_bend_draw_width = 0;
    let last_drawn_width = 0;
    if ((_a = this.tap) === null || _a === void 0 ? void 0 : _a.length) {
      const tapStart = note.getModifierStartXY(Modifier.Position.CENTER, this.index);
      renderText(tapStart.x, this.tap);
    }
    for (let i = 0; i < this.phrase.length; ++i) {
      const bend = this.phrase[i];
      if (!bend.draw_width)
        bend.draw_width = 0;
      if (i === 0)
        bend.draw_width += x_shift;
      last_drawn_width = bend.draw_width + last_bend_draw_width - (i === 1 ? x_shift : 0);
      if (bend.type === _Bend.UP) {
        if (last_bend && last_bend.type === _Bend.UP) {
          renderArrowHead(start.x, bend_height, 1);
        }
        renderBend(start.x, start.y, last_drawn_width, bend_height);
      }
      if (bend.type === _Bend.DOWN) {
        if (last_bend && last_bend.type === _Bend.UP) {
          renderRelease(start.x, start.y, last_drawn_width, bend_height);
        }
        if (last_bend && last_bend.type === _Bend.DOWN) {
          renderArrowHead(start.x, start.y, -1);
          renderRelease(start.x, start.y, last_drawn_width, bend_height);
        }
        if (!last_bend) {
          last_drawn_width = bend.draw_width;
          renderRelease(start.x, start.y, last_drawn_width, bend_height);
        }
      }
      renderText(start.x + last_drawn_width, bend.text);
      last_bend = bend;
      last_bend_draw_width = bend.draw_width;
      last_bend.x = start.x;
      start.x += last_drawn_width;
    }
    if (!last_bend || last_bend.x == void 0) {
      throw new RuntimeError("NoLastBendForBend", "Internal error.");
    }
    if (last_bend.type === _Bend.UP) {
      renderArrowHead(last_bend.x + last_drawn_width, bend_height, 1);
    } else if (last_bend.type === _Bend.DOWN) {
      renderArrowHead(last_bend.x + last_drawn_width, start.y, -1);
    }
  }
};
Bend.TEXT_FONT = Object.assign({}, Element.TEXT_FONT);

// node_modules/vexflow/build/esm/src/web.js
function isHTMLCanvas(element) {
  if (!element)
    return false;
  const global2 = globalObject();
  return typeof global2.HTMLCanvasElement === "function" && element instanceof global2.HTMLCanvasElement || typeof element.getContext === "function" && typeof element.toDataURL === "function";
}
function isHTMLDiv(element) {
  if (!element)
    return false;
  const global2 = globalObject();
  return typeof global2.HTMLDivElement === "function" && element instanceof global2.HTMLDivElement || typeof element.appendChild === "function" && typeof element.style === "object";
}

// node_modules/vexflow/build/esm/src/canvascontext.js
var CanvasContext = class _CanvasContext extends RenderContext {
  static get WIDTH() {
    return 600;
  }
  static get HEIGHT() {
    return 400;
  }
  static get CANVAS_BROWSER_SIZE_LIMIT() {
    return 32767;
  }
  static sanitizeCanvasDims(width, height) {
    const limit = this.CANVAS_BROWSER_SIZE_LIMIT;
    if (Math.max(width, height) > limit) {
      warn("Canvas dimensions exceed browser limit. Cropping to " + limit);
      if (width > limit) {
        width = limit;
      }
      if (height > limit) {
        height = limit;
      }
    }
    return [width, height];
  }
  constructor(context) {
    super();
    this.textHeight = 0;
    this.context2D = context;
    if (!context.canvas) {
      this.canvas = {
        width: _CanvasContext.WIDTH,
        height: _CanvasContext.HEIGHT
      };
    } else {
      this.canvas = context.canvas;
    }
  }
  clear() {
    this.context2D.clearRect(0, 0, this.canvas.width, this.canvas.height);
  }
  openGroup(cls, id, attrs) {
  }
  closeGroup() {
  }
  add(child) {
  }
  setFillStyle(style) {
    this.context2D.fillStyle = style;
    return this;
  }
  setBackgroundFillStyle(style) {
    return this;
  }
  setStrokeStyle(style) {
    this.context2D.strokeStyle = style;
    return this;
  }
  setShadowColor(color) {
    this.context2D.shadowColor = color;
    return this;
  }
  setShadowBlur(blur) {
    const t = this.context2D.getTransform();
    const scale = Math.sqrt(t.a * t.a + t.b * t.b + t.c * t.c + t.d * t.d);
    this.context2D.shadowBlur = scale * blur;
    return this;
  }
  setLineWidth(width) {
    this.context2D.lineWidth = width;
    return this;
  }
  setLineCap(capType) {
    this.context2D.lineCap = capType;
    return this;
  }
  setLineDash(dash) {
    this.context2D.setLineDash(dash);
    return this;
  }
  scale(x, y) {
    this.context2D.scale(x, y);
    return this;
  }
  resize(width, height, devicePixelRatio) {
    var _a;
    const canvas = this.context2D.canvas;
    const dpr = (_a = devicePixelRatio !== null && devicePixelRatio !== void 0 ? devicePixelRatio : globalObject().devicePixelRatio) !== null && _a !== void 0 ? _a : 1;
    [width, height] = _CanvasContext.sanitizeCanvasDims(width * dpr, height * dpr);
    width = width / dpr | 0;
    height = height / dpr | 0;
    canvas.width = width * dpr;
    canvas.height = height * dpr;
    if (isHTMLCanvas(canvas)) {
      canvas.style.width = width + "px";
      canvas.style.height = height + "px";
    }
    return this.scale(dpr, dpr);
  }
  rect(x, y, width, height) {
    this.context2D.rect(x, y, width, height);
    return this;
  }
  fillRect(x, y, width, height) {
    this.context2D.fillRect(x, y, width, height);
    return this;
  }
  clearRect(x, y, width, height) {
    this.context2D.clearRect(x, y, width, height);
    return this;
  }
  beginPath() {
    this.context2D.beginPath();
    return this;
  }
  moveTo(x, y) {
    this.context2D.moveTo(x, y);
    return this;
  }
  lineTo(x, y) {
    this.context2D.lineTo(x, y);
    return this;
  }
  bezierCurveTo(cp1x, cp1y, cp2x, cp2y, x, y) {
    this.context2D.bezierCurveTo(cp1x, cp1y, cp2x, cp2y, x, y);
    return this;
  }
  quadraticCurveTo(cpx, cpy, x, y) {
    this.context2D.quadraticCurveTo(cpx, cpy, x, y);
    return this;
  }
  arc(x, y, radius, startAngle, endAngle, counterclockwise) {
    this.context2D.arc(x, y, radius, startAngle, endAngle, counterclockwise);
    return this;
  }
  fill() {
    this.context2D.fill();
    return this;
  }
  stroke() {
    this.context2D.stroke();
    return this;
  }
  closePath() {
    this.context2D.closePath();
    return this;
  }
  measureText(text) {
    const metrics = this.context2D.measureText(text);
    let y = 0;
    let height = 0;
    if (metrics.fontBoundingBoxAscent) {
      y = -metrics.fontBoundingBoxAscent;
      height = metrics.fontBoundingBoxDescent + metrics.fontBoundingBoxAscent;
    } else {
      y = -metrics.actualBoundingBoxAscent;
      height = metrics.actualBoundingBoxDescent + metrics.actualBoundingBoxAscent;
    }
    return {
      x: 0,
      y,
      width: metrics.width,
      height
    };
  }
  fillText(text, x, y) {
    this.context2D.fillText(text, x, y);
    return this;
  }
  save() {
    this.context2D.save();
    return this;
  }
  restore() {
    this.context2D.restore();
    return this;
  }
  set fillStyle(style) {
    this.context2D.fillStyle = style;
  }
  get fillStyle() {
    return this.context2D.fillStyle;
  }
  set strokeStyle(style) {
    this.context2D.strokeStyle = style;
  }
  get strokeStyle() {
    return this.context2D.strokeStyle;
  }
  setFont(f, size, weight, style) {
    const fontInfo = Font.validate(f, size, weight, style);
    this.context2D.font = Font.toCSSString(fontInfo);
    this.textHeight = Font.convertSizeToPixelValue(fontInfo.size);
    return this;
  }
  getFont() {
    return this.context2D.font;
  }
};

// node_modules/vexflow/build/esm/src/chordsymbol.js
function L7(...args) {
  if (ChordSymbol.DEBUG)
    log("Vex.Flow.ChordSymbol", args);
}
var ChordSymbolHorizontalJustify;
(function(ChordSymbolHorizontalJustify2) {
  ChordSymbolHorizontalJustify2[ChordSymbolHorizontalJustify2["LEFT"] = 1] = "LEFT";
  ChordSymbolHorizontalJustify2[ChordSymbolHorizontalJustify2["CENTER"] = 2] = "CENTER";
  ChordSymbolHorizontalJustify2[ChordSymbolHorizontalJustify2["RIGHT"] = 3] = "RIGHT";
  ChordSymbolHorizontalJustify2[ChordSymbolHorizontalJustify2["CENTER_STEM"] = 4] = "CENTER_STEM";
})(ChordSymbolHorizontalJustify || (ChordSymbolHorizontalJustify = {}));
var ChordSymbolVerticalJustify;
(function(ChordSymbolVerticalJustify2) {
  ChordSymbolVerticalJustify2[ChordSymbolVerticalJustify2["TOP"] = 1] = "TOP";
  ChordSymbolVerticalJustify2[ChordSymbolVerticalJustify2["BOTTOM"] = 2] = "BOTTOM";
})(ChordSymbolVerticalJustify || (ChordSymbolVerticalJustify = {}));
var SymbolTypes;
(function(SymbolTypes2) {
  SymbolTypes2[SymbolTypes2["GLYPH"] = 1] = "GLYPH";
  SymbolTypes2[SymbolTypes2["TEXT"] = 2] = "TEXT";
  SymbolTypes2[SymbolTypes2["LINE"] = 3] = "LINE";
})(SymbolTypes || (SymbolTypes = {}));
var SymbolModifiers;
(function(SymbolModifiers2) {
  SymbolModifiers2[SymbolModifiers2["NONE"] = 1] = "NONE";
  SymbolModifiers2[SymbolModifiers2["SUBSCRIPT"] = 2] = "SUBSCRIPT";
  SymbolModifiers2[SymbolModifiers2["SUPERSCRIPT"] = 3] = "SUPERSCRIPT";
})(SymbolModifiers || (SymbolModifiers = {}));
var ChordSymbol = class _ChordSymbol extends Modifier {
  static get CATEGORY() {
    return "ChordSymbol";
  }
  static get superSubRatio() {
    return _ChordSymbol.metrics.global.superSubRatio;
  }
  static set NO_TEXT_FORMAT(val) {
    _ChordSymbol.noFormat = val;
  }
  static get NO_TEXT_FORMAT() {
    return _ChordSymbol.noFormat;
  }
  static getMetricForGlyph(glyphCode) {
    if (_ChordSymbol.metrics.glyphs[glyphCode]) {
      return _ChordSymbol.metrics.glyphs[glyphCode];
    }
    return void 0;
  }
  static get engravingFontResolution() {
    return Tables.currentMusicFont().getResolution();
  }
  static get spacingBetweenBlocks() {
    return _ChordSymbol.metrics.global.spacing / _ChordSymbol.engravingFontResolution;
  }
  static getWidthForGlyph(glyph) {
    const metric = _ChordSymbol.getMetricForGlyph(glyph.code);
    if (!metric) {
      return 0.65;
    }
    return metric.advanceWidth / _ChordSymbol.engravingFontResolution;
  }
  static getYShiftForGlyph(glyph) {
    const metric = _ChordSymbol.getMetricForGlyph(glyph.code);
    if (!metric) {
      return 0;
    }
    return metric.yOffset / _ChordSymbol.engravingFontResolution;
  }
  static getXShiftForGlyph(glyph) {
    const metric = _ChordSymbol.getMetricForGlyph(glyph.code);
    if (!metric) {
      return 0;
    }
    return -1 * metric.leftSideBearing / _ChordSymbol.engravingFontResolution;
  }
  static get superscriptOffset() {
    return _ChordSymbol.metrics.global.superscriptOffset / _ChordSymbol.engravingFontResolution;
  }
  static get subscriptOffset() {
    return _ChordSymbol.metrics.global.subscriptOffset / _ChordSymbol.engravingFontResolution;
  }
  static get kerningOffset() {
    return _ChordSymbol.metrics.global.kerningOffset / _ChordSymbol.engravingFontResolution;
  }
  static get metrics() {
    const chordSymbol = Tables.currentMusicFont().getMetrics().chordSymbol;
    if (!chordSymbol)
      throw new RuntimeError("BadMetrics", `chordSymbol missing`);
    return chordSymbol;
  }
  static get lowerKerningText() {
    return _ChordSymbol.metrics.global.lowerKerningText;
  }
  static get upperKerningText() {
    return _ChordSymbol.metrics.global.upperKerningText;
  }
  static isSuperscript(block) {
    return block.symbolModifier !== void 0 && block.symbolModifier === SymbolModifiers.SUPERSCRIPT;
  }
  static isSubscript(block) {
    return block.symbolModifier !== void 0 && block.symbolModifier === SymbolModifiers.SUBSCRIPT;
  }
  static get minPadding() {
    const musicFont = Tables.currentMusicFont();
    return musicFont.lookupMetric("noteHead.minPadding");
  }
  static format(symbols, state) {
    var _a;
    if (!symbols || symbols.length === 0)
      return false;
    let width = 0;
    let nonSuperWidth = 0;
    let leftWidth = 0;
    let rightWidth = 0;
    let maxLeftGlyphWidth = 0;
    let maxRightGlyphWidth = 0;
    for (const symbol of symbols) {
      const fontSize = Font.convertSizeToPointValue((_a = symbol.textFont) === null || _a === void 0 ? void 0 : _a.size);
      const fontAdj = Font.scaleSize(fontSize, 0.05);
      const glyphAdj = fontAdj * 2;
      const note = symbol.checkAttachedNote();
      let symbolWidth = 0;
      let lineSpaces = 1;
      let vAlign = false;
      for (let j = 0; j < symbol.symbolBlocks.length; ++j) {
        const block = symbol.symbolBlocks[j];
        const sup = _ChordSymbol.isSuperscript(block);
        const sub = _ChordSymbol.isSubscript(block);
        const superSubScale = sup || sub ? _ChordSymbol.superSubRatio : 1;
        const adj = block.symbolType === SymbolTypes.GLYPH ? glyphAdj * superSubScale : fontAdj * superSubScale;
        if (sup || sub) {
          lineSpaces = 2;
        }
        const fontSize2 = symbol.textFormatter.fontSizeInPixels;
        const superSubFontSize = fontSize2 * superSubScale;
        if (block.symbolType === SymbolTypes.GLYPH && block.glyph !== void 0) {
          block.width = _ChordSymbol.getWidthForGlyph(block.glyph) * superSubFontSize;
          block.yShift += _ChordSymbol.getYShiftForGlyph(block.glyph) * superSubFontSize;
          block.xShift += _ChordSymbol.getXShiftForGlyph(block.glyph) * superSubFontSize;
          block.glyph.scale = block.glyph.scale * adj;
        } else if (block.symbolType === SymbolTypes.TEXT) {
          block.width = block.width * superSubFontSize;
          block.yShift += symbol.getYOffsetForText(block.text) * adj;
        }
        if (block.symbolType === SymbolTypes.GLYPH && block.glyph !== void 0 && block.glyph.code === _ChordSymbol.glyphs.over.code) {
          lineSpaces = 2;
        }
        block.width += _ChordSymbol.spacingBetweenBlocks * fontSize2 * superSubScale;
        if (sup && j > 0) {
          const prev = symbol.symbolBlocks[j - 1];
          if (!_ChordSymbol.isSuperscript(prev)) {
            nonSuperWidth = width;
          }
        }
        if (sub && nonSuperWidth > 0) {
          vAlign = true;
          block.xShift = block.xShift + (nonSuperWidth - width);
          width = nonSuperWidth;
          nonSuperWidth = 0;
          symbol.setEnableKerning(false);
        }
        if (!sup && !sub) {
          nonSuperWidth = 0;
        }
        block.vAlign = vAlign;
        width += block.width;
        symbolWidth = width;
      }
      symbol.updateKerningAdjustments();
      symbol.updateOverBarAdjustments();
      if (symbol.getVertical() === ChordSymbolVerticalJustify.TOP) {
        symbol.setTextLine(state.top_text_line);
        state.top_text_line += lineSpaces;
      } else {
        symbol.setTextLine(state.text_line + 1);
        state.text_line += lineSpaces + 1;
      }
      if (symbol.getReportWidth() && isStemmableNote(note)) {
        const glyphWidth = note.getGlyphProps().getWidth();
        if (symbol.getHorizontal() === ChordSymbolHorizontalJustify.LEFT) {
          maxLeftGlyphWidth = Math.max(glyphWidth, maxLeftGlyphWidth);
          leftWidth = Math.max(leftWidth, symbolWidth) + _ChordSymbol.minPadding;
        } else if (symbol.getHorizontal() === ChordSymbolHorizontalJustify.RIGHT) {
          maxRightGlyphWidth = Math.max(glyphWidth, maxRightGlyphWidth);
          rightWidth = Math.max(rightWidth, symbolWidth);
        } else {
          leftWidth = Math.max(leftWidth, symbolWidth / 2) + _ChordSymbol.minPadding;
          rightWidth = Math.max(rightWidth, symbolWidth / 2);
          maxLeftGlyphWidth = Math.max(glyphWidth / 2, maxLeftGlyphWidth);
          maxRightGlyphWidth = Math.max(glyphWidth / 2, maxRightGlyphWidth);
        }
      }
      width = 0;
    }
    const rightOverlap = Math.min(Math.max(rightWidth - maxRightGlyphWidth, 0), Math.max(rightWidth - state.right_shift, 0));
    const leftOverlap = Math.min(Math.max(leftWidth - maxLeftGlyphWidth, 0), Math.max(leftWidth - state.left_shift, 0));
    state.left_shift += leftOverlap;
    state.right_shift += rightOverlap;
    return true;
  }
  constructor() {
    super();
    this.symbolBlocks = [];
    this.horizontal = ChordSymbolHorizontalJustify.LEFT;
    this.vertical = ChordSymbolVerticalJustify.TOP;
    this.useKerning = true;
    this.reportWidth = true;
    this.resetFont();
  }
  static get TEXT_FONT() {
    let family = "Roboto Slab, Times, serif";
    if (Tables.currentMusicFont().getName() === "Petaluma") {
      family = "PetalumaScript, Arial, sans-serif";
    }
    return {
      family,
      size: 12,
      weight: FontWeight.NORMAL,
      style: FontStyle.NORMAL
    };
  }
  get superscriptOffset() {
    return _ChordSymbol.superscriptOffset * this.textFormatter.fontSizeInPixels;
  }
  get subscriptOffset() {
    return _ChordSymbol.subscriptOffset * this.textFormatter.fontSizeInPixels;
  }
  setReportWidth(value) {
    this.reportWidth = value;
    return this;
  }
  getReportWidth() {
    return this.reportWidth;
  }
  updateOverBarAdjustments() {
    const barIndex = this.symbolBlocks.findIndex(({ symbolType, glyph }) => symbolType === SymbolTypes.GLYPH && glyph !== void 0 && glyph.code === "csymDiagonalArrangementSlash");
    if (barIndex < 0) {
      return;
    }
    const bar = this.symbolBlocks[barIndex];
    const xoff = bar.width / 4;
    const yoff = 0.25 * this.textFormatter.fontSizeInPixels;
    let symIndex = 0;
    for (symIndex === 0; symIndex < barIndex; ++symIndex) {
      const symbol = this.symbolBlocks[symIndex];
      symbol.xShift = symbol.xShift + xoff;
      symbol.yShift = symbol.yShift - yoff;
    }
    for (symIndex = barIndex + 1; symIndex < this.symbolBlocks.length; ++symIndex) {
      const symbol = this.symbolBlocks[symIndex];
      symbol.xShift = symbol.xShift - xoff;
      symbol.yShift = symbol.yShift + yoff;
    }
  }
  updateKerningAdjustments() {
    let accum = 0;
    for (let j = 0; j < this.symbolBlocks.length; ++j) {
      const symbol = this.symbolBlocks[j];
      accum += this.getKerningAdjustment(j);
      symbol.xShift += accum;
    }
  }
  getKerningAdjustment(j) {
    if (!this.useKerning) {
      return 0;
    }
    const currSymbol = this.symbolBlocks[j];
    const prevSymbol = j > 0 ? this.symbolBlocks[j - 1] : void 0;
    let adjustment = 0;
    if (currSymbol.symbolType === SymbolTypes.GLYPH && currSymbol.glyph !== void 0 && currSymbol.glyph.code === _ChordSymbol.glyphs.over.code) {
      adjustment += currSymbol.glyph.metrics.x_shift;
    }
    if (prevSymbol !== void 0 && prevSymbol.symbolType === SymbolTypes.GLYPH && prevSymbol.glyph !== void 0 && prevSymbol.glyph.code === _ChordSymbol.glyphs.over.code) {
      adjustment += prevSymbol.glyph.metrics.x_shift;
    }
    let preKernUpper = false;
    let preKernLower = false;
    if (prevSymbol !== void 0 && prevSymbol.symbolType === SymbolTypes.TEXT) {
      preKernUpper = _ChordSymbol.upperKerningText.some((xx) => xx === prevSymbol.text[prevSymbol.text.length - 1]);
      preKernLower = _ChordSymbol.lowerKerningText.some((xx) => xx === prevSymbol.text[prevSymbol.text.length - 1]);
    }
    const kerningOffsetPixels = _ChordSymbol.kerningOffset * this.textFormatter.fontSizeInPixels;
    if (preKernUpper && currSymbol.symbolModifier === SymbolModifiers.SUPERSCRIPT) {
      adjustment += kerningOffsetPixels;
    }
    if (preKernLower && currSymbol.symbolType === SymbolTypes.TEXT) {
      if (currSymbol.text[0] >= "a" && currSymbol.text[0] <= "z") {
        adjustment += kerningOffsetPixels / 2;
      }
      if (_ChordSymbol.upperKerningText.some((xx) => xx === (prevSymbol === null || prevSymbol === void 0 ? void 0 : prevSymbol.text[prevSymbol.text.length - 1]))) {
        adjustment += kerningOffsetPixels / 2;
      }
    }
    return adjustment;
  }
  getSymbolBlock(params = {}) {
    var _a, _b, _c;
    const symbolType = (_a = params.symbolType) !== null && _a !== void 0 ? _a : SymbolTypes.TEXT;
    const symbolBlock = {
      text: (_b = params.text) !== null && _b !== void 0 ? _b : "",
      symbolType,
      symbolModifier: (_c = params.symbolModifier) !== null && _c !== void 0 ? _c : SymbolModifiers.NONE,
      xShift: 0,
      yShift: 0,
      vAlign: false,
      width: 0
    };
    if (symbolType === SymbolTypes.GLYPH && typeof params.glyph === "string") {
      const glyphArgs = _ChordSymbol.glyphs[params.glyph];
      const glyphPoints = 20;
      symbolBlock.glyph = new Glyph(glyphArgs.code, glyphPoints, { category: "chordSymbol" });
    } else if (symbolType === SymbolTypes.TEXT) {
      symbolBlock.width = this.textFormatter.getWidthForTextInEm(symbolBlock.text);
    } else if (symbolType === SymbolTypes.LINE) {
      symbolBlock.width = params.width;
    }
    return symbolBlock;
  }
  addSymbolBlock(parameters) {
    this.symbolBlocks.push(this.getSymbolBlock(parameters));
    return this;
  }
  addText(text, parameters = {}) {
    const symbolType = SymbolTypes.TEXT;
    return this.addSymbolBlock(Object.assign(Object.assign({}, parameters), { text, symbolType }));
  }
  addTextSuperscript(text) {
    const symbolType = SymbolTypes.TEXT;
    const symbolModifier = SymbolModifiers.SUPERSCRIPT;
    return this.addSymbolBlock({ text, symbolType, symbolModifier });
  }
  addTextSubscript(text) {
    const symbolType = SymbolTypes.TEXT;
    const symbolModifier = SymbolModifiers.SUBSCRIPT;
    return this.addSymbolBlock({ text, symbolType, symbolModifier });
  }
  addGlyphSuperscript(glyph) {
    const symbolType = SymbolTypes.GLYPH;
    const symbolModifier = SymbolModifiers.SUPERSCRIPT;
    return this.addSymbolBlock({ glyph, symbolType, symbolModifier });
  }
  addGlyph(glyph, params = {}) {
    const symbolType = SymbolTypes.GLYPH;
    return this.addSymbolBlock(Object.assign(Object.assign({}, params), { glyph, symbolType }));
  }
  addGlyphOrText(text, params = {}) {
    let str = "";
    for (let i = 0; i < text.length; ++i) {
      const char = text[i];
      if (_ChordSymbol.glyphs[char]) {
        if (str.length > 0) {
          this.addText(str, params);
          str = "";
        }
        this.addGlyph(char, params);
      } else {
        str += char;
      }
    }
    if (str.length > 0) {
      this.addText(str, params);
    }
    return this;
  }
  addLine(width, params = {}) {
    const symbolType = SymbolTypes.LINE;
    return this.addSymbolBlock(Object.assign(Object.assign({}, params), { symbolType, width }));
  }
  setFont(f, size, weight, style) {
    super.setFont(f, size, weight, style);
    this.textFormatter = TextFormatter.create(this.textFont);
    return this;
  }
  setEnableKerning(val) {
    this.useKerning = val;
    return this;
  }
  setVertical(vj) {
    this.vertical = typeof vj === "string" ? _ChordSymbol.VerticalJustifyString[vj] : vj;
    return this;
  }
  getVertical() {
    return this.vertical;
  }
  setHorizontal(hj) {
    this.horizontal = typeof hj === "string" ? _ChordSymbol.HorizontalJustifyString[hj] : hj;
    return this;
  }
  getHorizontal() {
    return this.horizontal;
  }
  getWidth() {
    let width = 0;
    this.symbolBlocks.forEach((symbol) => {
      width += symbol.vAlign ? 0 : symbol.width;
    });
    return width;
  }
  getYOffsetForText(text) {
    var _a;
    let acc = 0;
    let i = 0;
    for (i = 0; i < text.length; ++i) {
      const metrics = this.textFormatter.getGlyphMetrics(text[i]);
      if (metrics) {
        const yMax = (_a = metrics.y_max) !== null && _a !== void 0 ? _a : 0;
        acc = yMax < acc ? yMax : acc;
      }
    }
    const resolution = this.textFormatter.getResolution();
    return i > 0 ? -1 * (acc / resolution) : 0;
  }
  draw() {
    const ctx = this.checkContext();
    const note = this.checkAttachedNote();
    this.setRendered();
    ctx.save();
    this.applyStyle();
    ctx.openGroup("chordsymbol", this.getAttribute("id"));
    const start = note.getModifierStartXY(Modifier.Position.ABOVE, this.index);
    ctx.setFont(this.textFont);
    let y;
    const hasStem = note.hasStem();
    const stave = note.checkStave();
    if (this.vertical === ChordSymbolVerticalJustify.BOTTOM) {
      y = stave.getYForBottomText(this.text_line + Tables.TEXT_HEIGHT_OFFSET_HACK);
      if (hasStem) {
        const stem_ext = note.checkStem().getExtents();
        const spacing = stave.getSpacingBetweenLines();
        const stem_base = note.getStemDirection() === 1 ? stem_ext.baseY : stem_ext.topY;
        y = Math.max(y, stem_base + spacing * (this.text_line + 2));
      }
    } else {
      const topY = Math.min(...note.getYs());
      y = Math.min(stave.getYForTopText(this.text_line), topY - 10);
      if (hasStem) {
        const stem_ext = note.checkStem().getExtents();
        const spacing = stave.getSpacingBetweenLines();
        y = Math.min(y, stem_ext.topY - 5 - spacing * this.text_line);
      }
    }
    let x = start.x;
    if (this.horizontal === ChordSymbolHorizontalJustify.LEFT) {
      x = start.x;
    } else if (this.horizontal === ChordSymbolHorizontalJustify.RIGHT) {
      x = start.x + this.getWidth();
    } else if (this.horizontal === ChordSymbolHorizontalJustify.CENTER) {
      x = start.x - this.getWidth() / 2;
    } else {
      x = note.getStemX() - this.getWidth() / 2;
    }
    L7("Rendering ChordSymbol: ", this.textFormatter, x, y);
    this.symbolBlocks.forEach((symbol) => {
      const isSuper = _ChordSymbol.isSuperscript(symbol);
      const isSub = _ChordSymbol.isSubscript(symbol);
      let curY = y;
      L7("shift was ", symbol.xShift, symbol.yShift);
      L7("curY pre sub ", curY);
      if (isSuper) {
        curY += this.superscriptOffset;
      }
      if (isSub) {
        curY += this.subscriptOffset;
      }
      L7("curY sup/sub ", curY);
      if (symbol.symbolType === SymbolTypes.TEXT) {
        if (isSuper || isSub) {
          ctx.save();
          if (this.textFont) {
            const { family, size, weight, style } = this.textFont;
            const smallerFontSize = Font.scaleSize(size, _ChordSymbol.superSubRatio);
            ctx.setFont(family, smallerFontSize, weight, style);
          }
        }
        L7("Rendering Text: ", symbol.text, x + symbol.xShift, curY + symbol.yShift);
        ctx.fillText(symbol.text, x + symbol.xShift, curY + symbol.yShift);
        if (isSuper || isSub) {
          ctx.restore();
        }
      } else if (symbol.symbolType === SymbolTypes.GLYPH && symbol.glyph) {
        curY += symbol.yShift;
        L7("Rendering Glyph: ", symbol.glyph.code, x + symbol.xShift, curY);
        symbol.glyph.render(ctx, x + symbol.xShift, curY);
      } else if (symbol.symbolType === SymbolTypes.LINE) {
        L7("Rendering Line : ", symbol.width, x, curY);
        ctx.beginPath();
        ctx.setLineWidth(1);
        ctx.moveTo(x, y);
        ctx.lineTo(x + symbol.width, curY);
        ctx.stroke();
      }
      x += symbol.width;
      if (symbol.vAlign) {
        x += symbol.xShift;
      }
    });
    ctx.closeGroup();
    this.restoreStyle();
    ctx.restore();
  }
};
ChordSymbol.DEBUG = false;
ChordSymbol.HorizontalJustify = ChordSymbolHorizontalJustify;
ChordSymbol.HorizontalJustifyString = {
  left: ChordSymbolHorizontalJustify.LEFT,
  right: ChordSymbolHorizontalJustify.RIGHT,
  center: ChordSymbolHorizontalJustify.CENTER,
  centerStem: ChordSymbolHorizontalJustify.CENTER_STEM
};
ChordSymbol.VerticalJustify = ChordSymbolVerticalJustify;
ChordSymbol.VerticalJustifyString = {
  top: ChordSymbolVerticalJustify.TOP,
  above: ChordSymbolVerticalJustify.TOP,
  below: ChordSymbolVerticalJustify.BOTTOM,
  bottom: ChordSymbolVerticalJustify.BOTTOM
};
ChordSymbol.glyphs = {
  diminished: {
    code: "csymDiminished"
  },
  dim: {
    code: "csymDiminished"
  },
  halfDiminished: {
    code: "csymHalfDiminished"
  },
  "+": {
    code: "csymAugmented"
  },
  augmented: {
    code: "csymAugmented"
  },
  majorSeventh: {
    code: "csymMajorSeventh"
  },
  minor: {
    code: "csymMinor"
  },
  "-": {
    code: "csymMinor"
  },
  "(": {
    code: "csymParensLeftTall"
  },
  leftParen: {
    code: "csymParensLeftTall"
  },
  ")": {
    code: "csymParensRightTall"
  },
  rightParen: {
    code: "csymParensRightTall"
  },
  leftBracket: {
    code: "csymBracketLeftTall"
  },
  rightBracket: {
    code: "csymBracketRightTall"
  },
  leftParenTall: {
    code: "csymParensLeftVeryTall"
  },
  rightParenTall: {
    code: "csymParensRightVeryTall"
  },
  "/": {
    code: "csymDiagonalArrangementSlash"
  },
  over: {
    code: "csymDiagonalArrangementSlash"
  },
  "#": {
    code: "accidentalSharp"
  },
  b: {
    code: "accidentalFlat"
  }
};
ChordSymbol.symbolTypes = SymbolTypes;
ChordSymbol.symbolModifiers = SymbolModifiers;
ChordSymbol.noFormat = false;

// node_modules/vexflow/build/esm/src/clef.js
function L8(...args) {
  if (Clef.DEBUG)
    log("Vex.Flow.Clef", args);
}
var Clef = class _Clef extends StaveModifier {
  static get CATEGORY() {
    return "Clef";
  }
  static get types() {
    return {
      treble: {
        code: "gClef",
        line: 3
      },
      bass: {
        code: "fClef",
        line: 1
      },
      alto: {
        code: "cClef",
        line: 2
      },
      tenor: {
        code: "cClef",
        line: 1
      },
      percussion: {
        code: "unpitchedPercussionClef1",
        line: 2
      },
      soprano: {
        code: "cClef",
        line: 4
      },
      "mezzo-soprano": {
        code: "cClef",
        line: 3
      },
      "baritone-c": {
        code: "cClef",
        line: 0
      },
      "baritone-f": {
        code: "fClef",
        line: 2
      },
      subbass: {
        code: "fClef",
        line: 0
      },
      french: {
        code: "gClef",
        line: 4
      },
      tab: {
        code: "6stringTabClef",
        line: 2.5
      }
    };
  }
  static get annotationSmufl() {
    return {
      "8va": "timeSig8",
      "8vb": "timeSig8"
    };
  }
  constructor(type, size, annotation) {
    super();
    this.clef = _Clef.types["treble"];
    this.setPosition(StaveModifierPosition.BEGIN);
    this.setType(type, size, annotation);
    this.setWidth(Glyph.getWidth(this.clef.code, _Clef.getPoint(this.size), `clef_${this.size}`));
    L8("Creating clef:", type);
  }
  setType(type, size, annotation) {
    this.type = type;
    this.clef = _Clef.types[type];
    if (size === void 0) {
      this.size = "default";
    } else {
      this.size = size;
    }
    const musicFont = Tables.currentMusicFont();
    if (annotation !== void 0) {
      const code = _Clef.annotationSmufl[annotation];
      const point = _Clef.getPoint(this.size) / 5 * 3;
      const line = musicFont.lookupMetric(`clef_${this.size}.annotations.${annotation}.${this.type}.line`);
      const x_shift = musicFont.lookupMetric(`clef_${this.size}.annotations.${annotation}.${this.type}.shiftX`);
      this.annotation = { code, point, line, x_shift };
      this.attachment = new Glyph(this.annotation.code, this.annotation.point);
      this.attachment.metrics.x_max = 0;
      this.attachment.setXShift(this.annotation.x_shift);
    } else {
      this.annotation = void 0;
    }
    return this;
  }
  getWidth() {
    if (this.type === "tab") {
      defined(this.stave, "ClefError", "Can't get width without stave.");
    }
    return this.width;
  }
  static getPoint(size) {
    return size == "default" ? Tables.NOTATION_FONT_SCALE : Tables.NOTATION_FONT_SCALE / 3 * 2;
  }
  setStave(stave) {
    this.stave = stave;
    return this;
  }
  draw() {
    const stave = this.checkStave();
    const ctx = stave.checkContext();
    this.setRendered();
    this.applyStyle(ctx);
    ctx.openGroup("clef", this.getAttribute("id"));
    Glyph.renderGlyph(ctx, this.x, stave.getYForLine(this.clef.line), _Clef.getPoint(this.size), this.clef.code, {
      category: `clef_${this.size}`
    });
    if (this.annotation !== void 0 && this.attachment !== void 0) {
      this.placeGlyphOnLine(this.attachment, stave, this.annotation.line);
      this.attachment.setStave(stave);
      this.attachment.setContext(ctx);
      this.attachment.renderToStave(this.x);
    }
    ctx.closeGroup();
    this.restoreStyle(ctx);
  }
};
Clef.DEBUG = false;

// node_modules/vexflow/build/esm/src/clefnote.js
var ClefNote = class extends Note {
  static get CATEGORY() {
    return "ClefNote";
  }
  constructor(type, size, annotation) {
    super({ duration: "b" });
    this.type = type;
    const clef = new Clef(type, size, annotation);
    this.clef = clef.clef;
    this.annotation = clef.annotation;
    this.size = size === void 0 ? "default" : size;
    this.setWidth(Glyph.getWidth(this.clef.code, Clef.getPoint(this.size), `clefNote_${this.size}`));
    this.ignore_ticks = true;
  }
  setType(type, size, annotation) {
    this.type = type;
    this.size = size;
    const clef = new Clef(type, size, annotation);
    this.clef = clef.clef;
    this.annotation = clef.annotation;
    this.setWidth(Glyph.getWidth(this.clef.code, Clef.getPoint(this.size), `clefNote_${this.size}`));
    return this;
  }
  getClef() {
    return this.clef;
  }
  preFormat() {
    this.preFormatted = true;
    return this;
  }
  draw() {
    const stave = this.checkStave();
    const ctx = this.checkContext();
    this.setRendered();
    const abs_x = this.getAbsoluteX();
    Glyph.renderGlyph(ctx, abs_x, stave.getYForLine(this.clef.line), Clef.getPoint(this.size), this.clef.code, {
      category: `clefNote_${this.size}`
    });
    if (this.annotation !== void 0) {
      const attachment = new Glyph(this.annotation.code, this.annotation.point);
      attachment.setContext(ctx);
      attachment.setStave(stave);
      attachment.setYShift(stave.getYForLine(this.annotation.line) - stave.getYForGlyphs());
      attachment.setXShift(this.annotation.x_shift);
      attachment.renderToStave(abs_x);
    }
  }
};

// node_modules/vexflow/build/esm/src/tickcontext.js
var TickContext = class {
  static getNextContext(tContext) {
    const contexts = tContext.tContexts;
    const index = contexts.indexOf(tContext);
    if (index + 1 < contexts.length)
      return contexts[index + 1];
  }
  constructor(options) {
    this.preFormatted = false;
    this.postFormatted = false;
    this.tickID = options && options.tickID ? options.tickID : 0;
    this.currentTick = new Fraction(0, 1);
    this.maxTicks = new Fraction(0, 1);
    this.maxTickable = void 0;
    this.minTicks = void 0;
    this.minTickable = void 0;
    this.padding = 1;
    this.x = 0;
    this.xBase = 0;
    this.xOffset = 0;
    this.tickables = [];
    this.tickablesByVoice = {};
    this.notePx = 0;
    this.glyphPx = 0;
    this.leftDisplacedHeadPx = 0;
    this.rightDisplacedHeadPx = 0;
    this.modLeftPx = 0;
    this.modRightPx = 0;
    this.totalLeftPx = 0;
    this.totalRightPx = 0;
    this.tContexts = [];
    this.width = 0;
    this.formatterMetrics = {
      freedom: { left: 0, right: 0 }
    };
  }
  getTickID() {
    return this.tickID;
  }
  getX() {
    return this.x;
  }
  setX(x) {
    this.x = x;
    this.xBase = x;
    this.xOffset = 0;
    return this;
  }
  getXBase() {
    return this.xBase;
  }
  setXBase(xBase) {
    this.xBase = xBase;
    this.x = xBase + this.xOffset;
  }
  getXOffset() {
    return this.xOffset;
  }
  setXOffset(xOffset) {
    this.xOffset = xOffset;
    this.x = this.xBase + xOffset;
  }
  getWidth() {
    return this.width + this.padding * 2;
  }
  setPadding(padding) {
    this.padding = padding;
    return this;
  }
  getMaxTicks() {
    return this.maxTicks;
  }
  getMinTicks() {
    return this.minTicks;
  }
  getMaxTickable() {
    return this.maxTickable;
  }
  getMinTickable() {
    return this.minTickable;
  }
  getTickables() {
    return this.tickables;
  }
  getTickableForVoice(voiceIndex) {
    return this.tickablesByVoice[voiceIndex];
  }
  getTickablesByVoice() {
    return this.tickablesByVoice;
  }
  getCenterAlignedTickables() {
    return this.tickables.filter((tickable) => tickable.isCenterAligned());
  }
  getMetrics() {
    const { width, glyphPx, notePx, leftDisplacedHeadPx, rightDisplacedHeadPx, modLeftPx, modRightPx, totalLeftPx, totalRightPx } = this;
    return {
      width,
      glyphPx,
      notePx,
      leftDisplacedHeadPx,
      rightDisplacedHeadPx,
      modLeftPx,
      modRightPx,
      totalLeftPx,
      totalRightPx
    };
  }
  getCurrentTick() {
    return this.currentTick;
  }
  setCurrentTick(tick) {
    this.currentTick = tick;
    this.preFormatted = false;
  }
  addTickable(tickable, voiceIndex) {
    if (!tickable) {
      throw new RuntimeError("BadArgument", "Invalid tickable added.");
    }
    if (!tickable.shouldIgnoreTicks()) {
      const ticks = tickable.getTicks();
      if (ticks.greaterThan(this.maxTicks)) {
        this.maxTicks = ticks.clone();
        this.maxTickable = tickable;
      }
      if (this.minTicks == null) {
        this.minTicks = ticks.clone();
        this.minTickable = tickable;
      } else if (ticks.lessThan(this.minTicks)) {
        this.minTicks = ticks.clone();
        this.minTickable = tickable;
      }
    }
    tickable.setTickContext(this);
    this.tickables.push(tickable);
    this.tickablesByVoice[voiceIndex || 0] = tickable;
    this.preFormatted = false;
    return this;
  }
  preFormat() {
    if (this.preFormatted)
      return this;
    for (let i = 0; i < this.tickables.length; ++i) {
      const tickable = this.tickables[i];
      tickable.preFormat();
      const metrics = tickable.getMetrics();
      this.leftDisplacedHeadPx = Math.max(this.leftDisplacedHeadPx, metrics.leftDisplacedHeadPx);
      this.rightDisplacedHeadPx = Math.max(this.rightDisplacedHeadPx, metrics.rightDisplacedHeadPx);
      this.notePx = Math.max(this.notePx, metrics.notePx);
      this.glyphPx = Math.max(this.glyphPx, metrics.glyphWidth || 0);
      this.modLeftPx = Math.max(this.modLeftPx, metrics.modLeftPx);
      this.modRightPx = Math.max(this.modRightPx, metrics.modRightPx);
      this.totalLeftPx = Math.max(this.totalLeftPx, metrics.modLeftPx + metrics.leftDisplacedHeadPx);
      this.totalRightPx = Math.max(this.totalRightPx, metrics.modRightPx + metrics.rightDisplacedHeadPx);
      this.width = this.notePx + this.totalLeftPx + this.totalRightPx;
    }
    return this;
  }
  postFormat() {
    if (this.postFormatted)
      return this;
    this.postFormatted = true;
    return this;
  }
  getFormatterMetrics() {
    return this.formatterMetrics;
  }
};

// node_modules/vexflow/build/esm/src/crescendo.js
function L9(...args) {
  if (Crescendo.DEBUG)
    log("Vex.Flow.Crescendo", args);
}
function renderHairpin(ctx, params) {
  const begin_x = params.begin_x;
  const end_x = params.end_x;
  const y = params.y;
  const half_height = params.height / 2;
  ctx.beginPath();
  if (params.reverse) {
    ctx.moveTo(begin_x, y - half_height);
    ctx.lineTo(end_x, y);
    ctx.lineTo(begin_x, y + half_height);
  } else {
    ctx.moveTo(end_x, y - half_height);
    ctx.lineTo(begin_x, y);
    ctx.lineTo(end_x, y + half_height);
  }
  ctx.stroke();
  ctx.closePath();
}
var Crescendo = class extends Note {
  static get CATEGORY() {
    return "Crescendo";
  }
  constructor(noteStruct) {
    super(noteStruct);
    this.options = {
      extend_left: 0,
      extend_right: 0,
      y_shift: 0
    };
    this.decrescendo = false;
    this.line = noteStruct.line || 0;
    this.height = 15;
  }
  setLine(line) {
    this.line = line;
    return this;
  }
  setHeight(height) {
    this.height = height;
    return this;
  }
  setDecrescendo(decresc) {
    this.decrescendo = decresc;
    return this;
  }
  preFormat() {
    this.preFormatted = true;
    return this;
  }
  draw() {
    const ctx = this.checkContext();
    const stave = this.checkStave();
    this.setRendered();
    const tick_context = this.getTickContext();
    const next_context = TickContext.getNextContext(tick_context);
    const begin_x = this.getAbsoluteX();
    const end_x = next_context ? next_context.getX() : stave.getX() + stave.getWidth();
    const y = stave.getYForLine(this.line + -3) + 1;
    L9("Drawing ", this.decrescendo ? "decrescendo " : "crescendo ", this.height, "x", begin_x - end_x);
    renderHairpin(ctx, {
      begin_x: begin_x - this.options.extend_left,
      end_x: end_x + this.options.extend_right,
      y: y + this.options.y_shift,
      height: this.height,
      reverse: this.decrescendo
    });
  }
};
Crescendo.DEBUG = false;

// node_modules/vexflow/build/esm/src/curve.js
var CurvePosition;
(function(CurvePosition2) {
  CurvePosition2[CurvePosition2["NEAR_HEAD"] = 1] = "NEAR_HEAD";
  CurvePosition2[CurvePosition2["NEAR_TOP"] = 2] = "NEAR_TOP";
})(CurvePosition || (CurvePosition = {}));
var Curve = class _Curve extends Element {
  static get CATEGORY() {
    return "Curve";
  }
  static get Position() {
    return CurvePosition;
  }
  static get PositionString() {
    return {
      nearHead: CurvePosition.NEAR_HEAD,
      nearTop: CurvePosition.NEAR_TOP
    };
  }
  constructor(from, to, options) {
    super();
    this.render_options = Object.assign({ thickness: 2, x_shift: 0, y_shift: 10, position: CurvePosition.NEAR_HEAD, position_end: CurvePosition.NEAR_HEAD, invert: false, cps: [
      { x: 0, y: 10 },
      { x: 0, y: 10 }
    ] }, options);
    this.from = from;
    this.to = to;
  }
  setNotes(from, to) {
    if (!from && !to) {
      throw new RuntimeError("BadArguments", "Curve needs to have either `from` or `to` set.");
    }
    this.from = from;
    this.to = to;
    return this;
  }
  isPartial() {
    return !this.from || !this.to;
  }
  renderCurve(params) {
    const ctx = this.checkContext();
    const x_shift = this.render_options.x_shift;
    const y_shift = this.render_options.y_shift * params.direction;
    const first_x = params.first_x + x_shift;
    const first_y = params.first_y + y_shift;
    const last_x = params.last_x - x_shift;
    const last_y = params.last_y + y_shift;
    const thickness = this.render_options.thickness;
    const cps = this.render_options.cps;
    const { x: cp0x, y: cp0y } = cps[0];
    const { x: cp1x, y: cp1y } = cps[1];
    const cp_spacing = (last_x - first_x) / (cps.length + 2);
    ctx.beginPath();
    ctx.moveTo(first_x, first_y);
    ctx.bezierCurveTo(first_x + cp_spacing + cp0x, first_y + cp0y * params.direction, last_x - cp_spacing + cp1x, last_y + cp1y * params.direction, last_x, last_y);
    ctx.bezierCurveTo(last_x - cp_spacing + cp1x, last_y + (cp1y + thickness) * params.direction, first_x + cp_spacing + cp0x, first_y + (cp0y + thickness) * params.direction, first_x, first_y);
    ctx.stroke();
    ctx.closePath();
    ctx.fill();
  }
  draw() {
    this.checkContext();
    this.setRendered();
    const first_note = this.from;
    const last_note = this.to;
    let first_x;
    let last_x;
    let first_y;
    let last_y;
    let stem_direction = 0;
    let metric = "baseY";
    let end_metric = "baseY";
    function getPosition(position2) {
      return typeof position2 === "string" ? _Curve.PositionString[position2] : position2;
    }
    const position = getPosition(this.render_options.position);
    const position_end = getPosition(this.render_options.position_end);
    if (position === CurvePosition.NEAR_TOP) {
      metric = "topY";
      end_metric = "topY";
    }
    if (position_end === CurvePosition.NEAR_HEAD) {
      end_metric = "baseY";
    } else if (position_end === CurvePosition.NEAR_TOP) {
      end_metric = "topY";
    }
    if (first_note) {
      first_x = first_note.getTieRightX();
      stem_direction = first_note.getStemDirection();
      first_y = first_note.getStemExtents()[metric];
    } else {
      const stave = last_note.checkStave();
      first_x = stave.getTieStartX();
      first_y = last_note.getStemExtents()[metric];
    }
    if (last_note) {
      last_x = last_note.getTieLeftX();
      stem_direction = last_note.getStemDirection();
      last_y = last_note.getStemExtents()[end_metric];
    } else {
      const stave = first_note.checkStave();
      last_x = stave.getTieEndX();
      last_y = first_note.getStemExtents()[end_metric];
    }
    this.renderCurve({
      first_x,
      last_x,
      first_y,
      last_y,
      direction: stem_direction * (this.render_options.invert === true ? -1 : 1)
    });
    return true;
  }
};

// node_modules/vexflow/build/esm/src/dot.js
var Dot = class _Dot extends Modifier {
  static get CATEGORY() {
    return "Dot";
  }
  static getDots(note) {
    return note.getModifiersByType(_Dot.CATEGORY);
  }
  static buildAndAttach(notes, options) {
    for (const note of notes) {
      if (options === null || options === void 0 ? void 0 : options.all) {
        for (let i = 0; i < note.keys.length; i++) {
          const dot = new _Dot();
          dot.setDotShiftY(note.glyphProps.dot_shiftY);
          note.addModifier(dot, i);
        }
      } else if ((options === null || options === void 0 ? void 0 : options.index) != void 0) {
        const dot = new _Dot();
        dot.setDotShiftY(note.glyphProps.dot_shiftY);
        note.addModifier(dot, options === null || options === void 0 ? void 0 : options.index);
      } else {
        const dot = new _Dot();
        dot.setDotShiftY(note.glyphProps.dot_shiftY);
        note.addModifier(dot, 0);
      }
    }
  }
  static format(dots, state) {
    const right_shift = state.right_shift;
    const dot_spacing = 1;
    if (!dots || dots.length === 0)
      return false;
    const dot_list = [];
    const max_shift_map = {};
    for (let i = 0; i < dots.length; ++i) {
      const dot = dots[i];
      const note = dot.getNote();
      let props;
      let shift;
      if (isStaveNote(note)) {
        const index = dot.checkIndex();
        props = note.getKeyProps()[index];
        shift = note.getFirstDotPx();
      } else if (isTabNote(note)) {
        props = { line: 0.5 };
        shift = right_shift;
      } else {
        throw new RuntimeError("Internal", "Unexpected instance.");
      }
      const note_id = note.getAttribute("id");
      dot_list.push({ line: props.line, note, note_id, dot });
      max_shift_map[note_id] = Math.max(max_shift_map[note_id] || shift, shift);
    }
    dot_list.sort((a, b) => b.line - a.line);
    let dot_shift = right_shift;
    let x_width = 0;
    let last_line = null;
    let last_note = null;
    let prev_dotted_space = null;
    let half_shiftY = 0;
    for (let i = 0; i < dot_list.length; ++i) {
      const { dot, note, note_id, line } = dot_list[i];
      if (line !== last_line || note !== last_note) {
        dot_shift = max_shift_map[note_id];
      }
      if (!note.isRest() && line !== last_line) {
        if (Math.abs(line % 1) === 0.5) {
          half_shiftY = 0;
        } else {
          half_shiftY = 0.5;
          if (last_note != null && !last_note.isRest() && last_line != null && last_line - line === 0.5) {
            half_shiftY = -0.5;
          } else if (line + half_shiftY === prev_dotted_space) {
            half_shiftY = -0.5;
          }
        }
      }
      if (note.isRest()) {
        dot.dot_shiftY += -half_shiftY;
      } else {
        dot.dot_shiftY = -half_shiftY;
      }
      prev_dotted_space = line + half_shiftY;
      dot.setXShift(dot_shift);
      dot_shift += dot.getWidth() + dot_spacing;
      x_width = dot_shift > x_width ? dot_shift : x_width;
      last_line = line;
      last_note = note;
    }
    state.right_shift += x_width;
    return true;
  }
  constructor() {
    super();
    this.position = Modifier.Position.RIGHT;
    this.radius = 2;
    this.setWidth(5);
    this.dot_shiftY = 0;
  }
  setNote(note) {
    this.note = note;
    if (isGraceNote(note)) {
      this.radius *= 0.5;
      this.setWidth(3);
    }
    return this;
  }
  setDotShiftY(y) {
    this.dot_shiftY = y;
    return this;
  }
  draw() {
    const ctx = this.checkContext();
    const note = this.checkAttachedNote();
    this.setRendered();
    const stave = note.checkStave();
    const lineSpace = stave.getSpacingBetweenLines();
    const start = note.getModifierStartXY(this.position, this.index, { forceFlagRight: true });
    if (isTabNote(note)) {
      start.y = note.getStemExtents().baseY;
    }
    const x = start.x + this.x_shift + this.width - this.radius;
    const y = start.y + this.y_shift + this.dot_shiftY * lineSpace;
    ctx.beginPath();
    ctx.arc(x, y, this.radius, 0, Math.PI * 2, false);
    ctx.fill();
  }
};

// node_modules/vexflow/build/esm/src/frethandfinger.js
var FretHandFinger = class extends Modifier {
  static get CATEGORY() {
    return "FretHandFinger";
  }
  static format(nums, state) {
    const { left_shift, right_shift } = state;
    const num_spacing = 1;
    if (!nums || nums.length === 0)
      return false;
    const nums_list = [];
    let prev_note = null;
    let shiftLeft = 0;
    let shiftRight = 0;
    for (let i = 0; i < nums.length; ++i) {
      const num = nums[i];
      const note = num.getNote();
      const pos = num.getPosition();
      const index = num.checkIndex();
      const props = note.getKeyProps()[index];
      const textFormatter = TextFormatter.create(num.textFont);
      const textHeight = textFormatter.maxHeight;
      if (num.position === ModifierPosition.ABOVE) {
        state.top_text_line += textHeight / Tables.STAVE_LINE_DISTANCE + 0.5;
      }
      if (num.position === ModifierPosition.BELOW) {
        state.text_line += textHeight / Tables.STAVE_LINE_DISTANCE + 0.5;
      }
      if (note !== prev_note) {
        for (let n = 0; n < note.keys.length; ++n) {
          if (left_shift === 0) {
            shiftLeft = Math.max(note.getLeftDisplacedHeadPx(), shiftLeft);
          }
          if (right_shift === 0) {
            shiftRight = Math.max(note.getRightDisplacedHeadPx(), shiftRight);
          }
        }
        prev_note = note;
      }
      nums_list.push({
        note,
        num,
        pos,
        line: props.line,
        shiftL: shiftLeft,
        shiftR: shiftRight
      });
    }
    nums_list.sort((a, b) => b.line - a.line);
    let numShiftL = 0;
    let numShiftR = 0;
    let xWidthL = 0;
    let xWidthR = 0;
    let lastLine = null;
    let lastNote = null;
    for (let i = 0; i < nums_list.length; ++i) {
      let num_shift = 0;
      const { note, pos, num, line, shiftL, shiftR } = nums_list[i];
      if (line !== lastLine || note !== lastNote) {
        numShiftL = left_shift + shiftL;
        numShiftR = right_shift + shiftR;
      }
      const numWidth = num.getWidth() + num_spacing;
      if (pos === Modifier.Position.LEFT) {
        num.setXShift(left_shift + numShiftL);
        num_shift = left_shift + numWidth;
        xWidthL = num_shift > xWidthL ? num_shift : xWidthL;
      } else if (pos === Modifier.Position.RIGHT) {
        num.setXShift(numShiftR);
        num_shift = shiftRight + numWidth;
        xWidthR = num_shift > xWidthR ? num_shift : xWidthR;
      }
      lastLine = line;
      lastNote = note;
    }
    state.left_shift += xWidthL;
    state.right_shift += xWidthR;
    return true;
  }
  static easyScoreHook({ fingerings } = {}, note, builder) {
    fingerings === null || fingerings === void 0 ? void 0 : fingerings.split(",").map((fingeringString) => {
      const split = fingeringString.trim().split(".");
      const params = { number: split[0] };
      if (split[1])
        params.position = split[1];
      return builder.getFactory().Fingering(params);
    }).map((fingering, index) => note.addModifier(fingering, index));
  }
  constructor(finger) {
    super();
    this.finger = finger;
    this.width = 7;
    this.position = Modifier.Position.LEFT;
    this.x_shift = 0;
    this.y_shift = 0;
    this.x_offset = 0;
    this.y_offset = 0;
    this.resetFont();
  }
  setFretHandFinger(finger) {
    this.finger = finger;
    return this;
  }
  getFretHandFinger() {
    return this.finger;
  }
  setOffsetX(x) {
    this.x_offset = x;
    return this;
  }
  setOffsetY(y) {
    this.y_offset = y;
    return this;
  }
  draw() {
    const ctx = this.checkContext();
    const note = this.checkAttachedNote();
    this.setRendered();
    const start = note.getModifierStartXY(this.position, this.index);
    let dot_x = start.x + this.x_shift + this.x_offset;
    let dot_y = start.y + this.y_shift + this.y_offset + 5;
    switch (this.position) {
      case Modifier.Position.ABOVE:
        dot_x -= 4;
        dot_y -= 12;
        break;
      case Modifier.Position.BELOW:
        dot_x -= 2;
        dot_y += 10;
        break;
      case Modifier.Position.LEFT:
        dot_x -= this.width;
        break;
      case Modifier.Position.RIGHT:
        dot_x += 1;
        break;
      default:
        throw new RuntimeError("InvalidPosition", `The position ${this.position} does not exist`);
    }
    ctx.save();
    ctx.setFont(this.textFont);
    ctx.fillText("" + this.finger, dot_x, dot_y);
    ctx.restore();
  }
};
FretHandFinger.TEXT_FONT = {
  family: Font.SANS_SERIF,
  size: 9,
  weight: FontWeight.BOLD,
  style: FontStyle.NORMAL
};

// node_modules/vexflow/build/esm/src/parser.js
function L10(...args) {
  if (Parser.DEBUG)
    log("Vex.Flow.Parser", args);
}
var NO_ERROR_POS = -1;
function flattenMatches(r) {
  if ("matchedString" in r)
    return r.matchedString;
  if ("results" in r)
    return flattenMatches(r.results);
  const results = r;
  if (results.length === 1)
    return flattenMatches(results[0]);
  if (results.length === 0)
    return null;
  return results.map(flattenMatches);
}
var Parser = class {
  constructor(grammar) {
    this.grammar = grammar;
    this.line = "";
    this.pos = 0;
    this.errorPos = NO_ERROR_POS;
  }
  parse(line) {
    this.line = line;
    this.pos = 0;
    this.errorPos = NO_ERROR_POS;
    const result = this.expect(this.grammar.begin());
    result.errorPos = this.errorPos;
    return result;
  }
  matchFail(returnPos) {
    if (this.errorPos === NO_ERROR_POS)
      this.errorPos = this.pos;
    this.pos = returnPos;
  }
  matchSuccess() {
    this.errorPos = NO_ERROR_POS;
  }
  matchToken(token, noSpace = false) {
    const regexp = noSpace ? new RegExp("^((" + token + "))") : new RegExp("^((" + token + ")\\s*)");
    const workingLine = this.line.slice(this.pos);
    const result = workingLine.match(regexp);
    if (result !== null) {
      return {
        success: true,
        matchedString: result[2],
        incrementPos: result[1].length,
        pos: this.pos
      };
    } else {
      return { success: false, pos: this.pos };
    }
  }
  expectOne(rule, maybe = false) {
    const results = [];
    const pos = this.pos;
    let allMatches = true;
    let oneMatch = false;
    maybe = maybe === true || rule.maybe === true;
    if (rule.expect) {
      for (const next of rule.expect) {
        const localPos = this.pos;
        const result = this.expect(next);
        if (result.success) {
          results.push(result);
          oneMatch = true;
          if (rule.or)
            break;
        } else {
          allMatches = false;
          if (!rule.or) {
            this.pos = localPos;
            break;
          }
        }
      }
    }
    const gotOne = rule.or && oneMatch || allMatches;
    const success = gotOne || maybe === true;
    const numMatches = gotOne ? 1 : 0;
    if (maybe && !gotOne)
      this.pos = pos;
    if (success) {
      this.matchSuccess();
    } else {
      this.matchFail(pos);
    }
    return { success, results, numMatches };
  }
  expectOneOrMore(rule, maybe = false) {
    const results = [];
    const pos = this.pos;
    let numMatches = 0;
    let more = true;
    do {
      const result = this.expectOne(rule);
      if (result.success && result.results) {
        numMatches++;
        results.push(result.results);
      } else {
        more = false;
      }
    } while (more);
    const success = numMatches > 0 || maybe === true;
    if (maybe && !(numMatches > 0))
      this.pos = pos;
    if (success) {
      this.matchSuccess();
    } else {
      this.matchFail(pos);
    }
    return { success, results, numMatches };
  }
  expectZeroOrMore(rule) {
    return this.expectOneOrMore(rule, true);
  }
  expect(ruleFunc) {
    L10("Evaluating rule function:", ruleFunc);
    if (!ruleFunc) {
      throw new RuntimeError("Invalid rule function");
    }
    let result;
    const rule = ruleFunc.bind(this.grammar)();
    if (rule.token) {
      result = this.matchToken(rule.token, rule.noSpace === true);
      if (result.success) {
        this.pos += result.incrementPos;
      }
    } else if (rule.expect) {
      if (rule.oneOrMore) {
        result = this.expectOneOrMore(rule);
      } else if (rule.zeroOrMore) {
        result = this.expectZeroOrMore(rule);
      } else {
        result = this.expectOne(rule);
      }
    } else {
      L10(rule);
      throw new RuntimeError("Bad grammar! No `token` or `expect` property " + rule);
    }
    const matches = [];
    result.matches = matches;
    if (result.results) {
      result.results.forEach((r) => matches.push(flattenMatches(r)));
    }
    if (rule.run && result.success) {
      rule.run({ matches });
    }
    return result;
  }
};
Parser.DEBUG = false;

// node_modules/vexflow/build/esm/src/easyscore.js
function L11(...args) {
  if (EasyScore.DEBUG)
    log("Vex.Flow.EasyScore", args);
}
var EasyScoreGrammar = class {
  constructor(builder) {
    this.builder = builder;
  }
  begin() {
    return this.LINE;
  }
  LINE() {
    return {
      expect: [this.PIECE, this.PIECES, this.EOL]
    };
  }
  PIECE() {
    return {
      expect: [this.CHORDORNOTE, this.PARAMS],
      run: () => this.builder.commitPiece()
    };
  }
  PIECES() {
    return {
      expect: [this.COMMA, this.PIECE],
      zeroOrMore: true
    };
  }
  PARAMS() {
    return {
      expect: [this.DURATION, this.TYPE, this.DOTS, this.OPTS]
    };
  }
  CHORDORNOTE() {
    return {
      expect: [this.CHORD, this.SINGLENOTE],
      or: true
    };
  }
  CHORD() {
    return {
      expect: [this.LPAREN, this.NOTES, this.RPAREN],
      run: (state) => this.builder.addChord(state.matches[1])
    };
  }
  NOTES() {
    return {
      expect: [this.NOTE],
      oneOrMore: true
    };
  }
  NOTE() {
    return {
      expect: [this.NOTENAME, this.ACCIDENTAL, this.OCTAVE]
    };
  }
  SINGLENOTE() {
    return {
      expect: [this.NOTENAME, this.ACCIDENTAL, this.OCTAVE],
      run: (state) => {
        const s = state;
        this.builder.addSingleNote(s.matches[0], s.matches[1], s.matches[2]);
      }
    };
  }
  ACCIDENTAL() {
    return {
      expect: [this.MICROTONES, this.ACCIDENTALS],
      maybe: true,
      or: true
    };
  }
  DOTS() {
    return {
      expect: [this.DOT],
      zeroOrMore: true,
      run: (state) => this.builder.setNoteDots(state.matches)
    };
  }
  TYPE() {
    return {
      expect: [this.SLASH, this.MAYBESLASH, this.TYPES],
      maybe: true,
      run: (state) => this.builder.setNoteType(state.matches[2])
    };
  }
  DURATION() {
    return {
      expect: [this.SLASH, this.DURATIONS],
      maybe: true,
      run: (state) => this.builder.setNoteDuration(state.matches[1])
    };
  }
  OPTS() {
    return {
      expect: [this.LBRACKET, this.KEYVAL, this.KEYVALS, this.RBRACKET],
      maybe: true
    };
  }
  KEYVALS() {
    return {
      expect: [this.COMMA, this.KEYVAL],
      zeroOrMore: true
    };
  }
  KEYVAL() {
    const unquote = (str) => str.slice(1, -1);
    return {
      expect: [this.KEY, this.EQUALS, this.VAL],
      run: (state) => this.builder.addNoteOption(state.matches[0], unquote(state.matches[2]))
    };
  }
  VAL() {
    return {
      expect: [this.SVAL, this.DVAL],
      or: true
    };
  }
  KEY() {
    return { token: "[a-zA-Z][a-zA-Z0-9]*" };
  }
  DVAL() {
    return { token: '["][^"]*["]' };
  }
  SVAL() {
    return { token: "['][^']*[']" };
  }
  NOTENAME() {
    return { token: "[a-gA-G]" };
  }
  OCTAVE() {
    return { token: "[0-9]+" };
  }
  ACCIDENTALS() {
    return { token: "bb|b|##|#|n" };
  }
  MICROTONES() {
    return { token: "bbs|bss|bs|db|d|\\+\\+-|\\+-|\\+\\+|\\+|k|o" };
  }
  DURATIONS() {
    return { token: "[0-9whq]+" };
  }
  TYPES() {
    return { token: "[rRsSmMhHgG]" };
  }
  LPAREN() {
    return { token: "[(]" };
  }
  RPAREN() {
    return { token: "[)]" };
  }
  COMMA() {
    return { token: "[,]" };
  }
  DOT() {
    return { token: "[.]" };
  }
  SLASH() {
    return { token: "[/]" };
  }
  MAYBESLASH() {
    return { token: "[/]?" };
  }
  EQUALS() {
    return { token: "[=]" };
  }
  LBRACKET() {
    return { token: "\\[" };
  }
  RBRACKET() {
    return { token: "\\]" };
  }
  EOL() {
    return { token: "$" };
  }
};
var Piece = class {
  constructor(duration) {
    this.chord = [];
    this.dots = 0;
    this.options = {};
    this.duration = duration;
  }
};
var Builder = class {
  constructor(factory) {
    this.commitHooks = [];
    this.factory = factory;
    this.reset();
  }
  reset(options) {
    this.options = Object.assign({ stem: "auto", clef: "treble" }, options);
    this.elements = { notes: [], accidentals: [] };
    this.rollingDuration = "8";
    this.resetPiece();
  }
  getFactory() {
    return this.factory;
  }
  getElements() {
    return this.elements;
  }
  addCommitHook(commitHook) {
    this.commitHooks.push(commitHook);
  }
  resetPiece() {
    L11("resetPiece");
    this.piece = new Piece(this.rollingDuration);
  }
  setNoteDots(dots) {
    L11("setNoteDots:", dots);
    if (dots)
      this.piece.dots = dots.length;
  }
  setNoteDuration(duration) {
    L11("setNoteDuration:", duration);
    this.rollingDuration = this.piece.duration = duration || this.rollingDuration;
  }
  setNoteType(type) {
    L11("setNoteType:", type);
    if (type)
      this.piece.type = type;
  }
  addNoteOption(key, value) {
    L11("addNoteOption: key:", key, "value:", value);
    this.piece.options[key] = value;
  }
  addNote(key, accid, octave) {
    L11("addNote:", key, accid, octave);
    this.piece.chord.push({
      key,
      accid,
      octave
    });
  }
  addSingleNote(key, accid, octave) {
    L11("addSingleNote:", key, accid, octave);
    this.addNote(key, accid, octave);
  }
  addChord(notes) {
    L11("startChord");
    if (typeof notes[0] !== "object") {
      this.addSingleNote(notes[0]);
    } else {
      notes.forEach((n) => {
        if (n)
          this.addNote(...n);
      });
    }
    L11("endChord");
  }
  commitPiece() {
    L11("commitPiece");
    const { factory } = this;
    if (!factory)
      return;
    const options = Object.assign(Object.assign({}, this.options), this.piece.options);
    const stem = defined(options.stem, "BadArguments", "options.stem is not defined").toLowerCase();
    const clef = defined(options.clef, "BadArguments", "options.clef is not defined").toLowerCase();
    const { chord, duration, dots, type } = this.piece;
    const standardAccidentals = Music.accidentals;
    const keys = chord.map((notePiece) => {
      var _a;
      return notePiece.key + (standardAccidentals.includes((_a = notePiece.accid) !== null && _a !== void 0 ? _a : "") ? notePiece.accid : "") + "/" + notePiece.octave;
    });
    const auto_stem = stem === "auto";
    const note = (type === null || type === void 0 ? void 0 : type.toLowerCase()) == "g" ? factory.GhostNote({ duration, dots }) : factory.StaveNote({ keys, duration, dots, type, clef, auto_stem });
    if (!auto_stem)
      note.setStemDirection(stem === "up" ? Stem.UP : Stem.DOWN);
    const accidentals2 = [];
    chord.forEach((notePiece, index) => {
      const accid = notePiece.accid;
      if (typeof accid === "string") {
        const accidental = factory.Accidental({ type: accid });
        note.addModifier(accidental, index);
        accidentals2.push(accidental);
      } else {
        accidentals2.push(void 0);
      }
    });
    for (let i = 0; i < dots; i++)
      Dot.buildAndAttach([note], { all: true });
    this.commitHooks.forEach((commitHook) => commitHook(options, note, this));
    this.elements.notes.push(note);
    this.elements.accidentals.push(accidentals2);
    this.resetPiece();
  }
};
function setId(options, note) {
  if (options.id === void 0)
    return;
  note.setAttribute("id", options.id);
}
var commaSeparatedRegex = /\s*,\s*/;
function setClass(options, note) {
  if (options.class === void 0)
    return;
  options.class.split(commaSeparatedRegex).forEach((className) => note.addClass(className));
}
var EasyScore = class {
  constructor(options = {}) {
    this.defaults = {
      clef: "treble",
      time: "4/4",
      stem: "auto"
    };
    this.setOptions(options);
  }
  set(defaults) {
    this.defaults = Object.assign(Object.assign({}, this.defaults), defaults);
    return this;
  }
  setOptions(options) {
    var _a, _b;
    const factory = options.factory;
    const builder = (_a = options.builder) !== null && _a !== void 0 ? _a : new Builder(factory);
    this.options = Object.assign(Object.assign({ commitHooks: [setId, setClass, Articulation.easyScoreHook, FretHandFinger.easyScoreHook], throwOnError: false }, options), {
      factory,
      builder
    });
    this.factory = factory;
    this.builder = builder;
    this.grammar = new EasyScoreGrammar(this.builder);
    this.parser = new Parser(this.grammar);
    (_b = this.options.commitHooks) === null || _b === void 0 ? void 0 : _b.forEach((commitHook) => this.addCommitHook(commitHook));
    return this;
  }
  setContext(context) {
    this.factory.setContext(context);
    return this;
  }
  parse(line, options = {}) {
    this.builder.reset(options);
    const result = this.parser.parse(line);
    if (!result.success && this.options.throwOnError) {
      L11(result);
      throw new RuntimeError("Error parsing line: " + line);
    }
    return result;
  }
  beam(notes, options) {
    this.factory.Beam({ notes, options });
    return notes;
  }
  tuplet(notes, options) {
    this.factory.Tuplet({ notes, options });
    return notes;
  }
  notes(line, options = {}) {
    options = Object.assign({ clef: this.defaults.clef, stem: this.defaults.stem }, options);
    this.parse(line, options);
    return this.builder.getElements().notes;
  }
  voice(notes, options = {}) {
    options = Object.assign({ time: this.defaults.time }, options);
    return this.factory.Voice(options).addTickables(notes);
  }
  addCommitHook(commitHook) {
    this.builder.addCommitHook(commitHook);
  }
};
EasyScore.DEBUG = false;

// node_modules/vexflow/build/esm/src/notehead.js
function L12(...args) {
  if (NoteHead.DEBUG)
    log("Vex.Flow.NoteHead", args);
}
function drawSlashNoteHead(ctx, duration, x, y, stem_direction, staveSpace) {
  const width = Tables.SLASH_NOTEHEAD_WIDTH;
  ctx.save();
  ctx.setLineWidth(Tables.STEM_WIDTH);
  let fill = false;
  if (Tables.durationToNumber(duration) > 2) {
    fill = true;
  }
  if (!fill)
    x -= Tables.STEM_WIDTH / 2 * stem_direction;
  ctx.beginPath();
  ctx.moveTo(x, y + staveSpace);
  ctx.lineTo(x, y + 1);
  ctx.lineTo(x + width, y - staveSpace);
  ctx.lineTo(x + width, y);
  ctx.lineTo(x, y + staveSpace);
  ctx.closePath();
  if (fill) {
    ctx.fill();
  } else {
    ctx.stroke();
  }
  if (Tables.durationToFraction(duration).equals(0.5)) {
    const breve_lines = [-3, -1, width + 1, width + 3];
    for (let i = 0; i < breve_lines.length; i++) {
      ctx.beginPath();
      ctx.moveTo(x + breve_lines[i], y - 10);
      ctx.lineTo(x + breve_lines[i], y + 11);
      ctx.stroke();
    }
  }
  ctx.restore();
}
var NoteHead = class extends Note {
  static get CATEGORY() {
    return "NoteHead";
  }
  constructor(noteStruct) {
    super(noteStruct);
    this.custom_glyph = false;
    this.stem_up_x_offset = 0;
    this.stem_down_x_offset = 0;
    this.index = noteStruct.index;
    this.x = noteStruct.x || 0;
    this.y = noteStruct.y || 0;
    if (noteStruct.note_type)
      this.noteType = noteStruct.note_type;
    this.displaced = noteStruct.displaced || false;
    this.stem_direction = noteStruct.stem_direction || Stem.UP;
    this.line = noteStruct.line || 0;
    this.glyphProps = Tables.getGlyphProps(this.duration, this.noteType);
    defined(this.glyphProps, "BadArguments", `No glyph found for duration '${this.duration}' and type '${this.noteType}'`);
    if ((this.line > 5 || this.line < 0) && this.glyphProps.ledger_code_head) {
      this.glyphProps.code_head = this.glyphProps.ledger_code_head;
    }
    this.glyph_code = this.glyphProps.code_head;
    this.x_shift = noteStruct.x_shift || 0;
    if (noteStruct.custom_glyph_code) {
      this.custom_glyph = true;
      this.glyph_code = noteStruct.custom_glyph_code;
      this.stem_up_x_offset = noteStruct.stem_up_x_offset || 0;
      this.stem_down_x_offset = noteStruct.stem_down_x_offset || 0;
    }
    this.setStyle(noteStruct.style);
    this.slashed = noteStruct.slashed || false;
    this.render_options = Object.assign(Object.assign({}, this.render_options), { glyph_font_scale: noteStruct.glyph_font_scale || Tables.NOTATION_FONT_SCALE });
    this.setWidth(this.custom_glyph && !this.glyph_code.startsWith("noteheadSlashed") && !this.glyph_code.startsWith("noteheadCircled") ? Glyph.getWidth(this.glyph_code, this.render_options.glyph_font_scale) : this.glyphProps.getWidth(this.render_options.glyph_font_scale));
  }
  getWidth() {
    return this.width;
  }
  isDisplaced() {
    return this.displaced === true;
  }
  setX(x) {
    this.x = x;
    return this;
  }
  getY() {
    return this.y;
  }
  setY(y) {
    this.y = y;
    return this;
  }
  getLine() {
    return this.line;
  }
  setLine(line) {
    this.line = line;
    return this;
  }
  getAbsoluteX() {
    const x = !this.preFormatted ? this.x : super.getAbsoluteX();
    const displacementStemAdjustment = Stem.WIDTH / 2;
    const musicFont = Tables.currentMusicFont();
    const fontShift = musicFont.lookupMetric("notehead.shiftX", 0) * this.stem_direction;
    const displacedFontShift = musicFont.lookupMetric("noteHead.displacedShiftX", 0) * this.stem_direction;
    return x + fontShift + (this.displaced ? (this.width - displacementStemAdjustment) * this.stem_direction + displacedFontShift : 0);
  }
  getBoundingBox() {
    const spacing = this.checkStave().getSpacingBetweenLines();
    const half_spacing = spacing / 2;
    const min_y = this.y - half_spacing;
    return new BoundingBox(this.getAbsoluteX(), min_y, this.width, spacing);
  }
  setStave(stave) {
    const line = this.getLine();
    this.stave = stave;
    if (this.stave) {
      this.setY(this.stave.getYForNote(line));
      this.setContext(this.stave.getContext());
    }
    return this;
  }
  preFormat() {
    if (this.preFormatted)
      return this;
    const width = this.getWidth() + this.leftDisplacedHeadPx + this.rightDisplacedHeadPx;
    this.setWidth(width);
    this.preFormatted = true;
    return this;
  }
  draw() {
    const ctx = this.checkContext();
    this.setRendered();
    let head_x = this.getAbsoluteX();
    if (this.custom_glyph) {
      head_x += this.stem_direction === Stem.UP ? this.stem_up_x_offset + (this.glyphProps.stem ? this.glyphProps.getWidth(this.render_options.glyph_font_scale) - this.width : 0) : this.stem_down_x_offset;
    }
    const y = this.y;
    L12("Drawing note head '", this.noteType, this.duration, "' at", head_x, y);
    const stem_direction = this.stem_direction;
    const glyph_font_scale = this.render_options.glyph_font_scale;
    const categorySuffix = `${this.glyph_code}Stem${stem_direction === Stem.UP ? "Up" : "Down"}`;
    if (this.noteType === "s") {
      const staveSpace = this.checkStave().getSpacingBetweenLines();
      drawSlashNoteHead(ctx, this.duration, head_x, y, stem_direction, staveSpace);
    } else {
      Glyph.renderGlyph(ctx, head_x, y, glyph_font_scale, this.glyph_code, {
        category: `noteHead.${categorySuffix}`
      });
    }
  }
};
NoteHead.DEBUG = false;

// node_modules/vexflow/build/esm/src/stemmablenote.js
var StemmableNote = class extends Note {
  static get CATEGORY() {
    return "StemmableNote";
  }
  constructor(noteStruct) {
    super(noteStruct);
  }
  getStem() {
    return this.stem;
  }
  checkStem() {
    if (!this.stem) {
      throw new RuntimeError("NoStem", "No stem attached to instance");
    }
    return this.stem;
  }
  setStem(stem) {
    this.stem = stem;
    this.addChildElement(stem);
    return this;
  }
  buildStem() {
    const stem = new Stem();
    this.setStem(stem);
    return this;
  }
  buildFlag(category = "flag") {
    const { glyphProps } = this;
    if (this.hasFlag()) {
      const flagCode = this.getStemDirection() === Stem.DOWN ? glyphProps.code_flag_downstem : glyphProps.code_flag_upstem;
      if (flagCode)
        this.flag = new Glyph(flagCode, this.render_options.glyph_font_scale, { category });
    }
  }
  getBaseCustomNoteHeadGlyphProps() {
    if (this.getStemDirection() === Stem.DOWN) {
      return this.customGlyphs[this.customGlyphs.length - 1];
    } else {
      return this.customGlyphs[0];
    }
  }
  getStemLength() {
    return Stem.HEIGHT + this.getStemExtension();
  }
  getBeamCount() {
    const glyphProps = this.getGlyphProps();
    if (glyphProps) {
      return glyphProps.beam_count;
    } else {
      return 0;
    }
  }
  getStemMinimumLength() {
    const frac = Tables.durationToFraction(this.duration);
    let length = frac.value() <= 1 ? 0 : 20;
    switch (this.duration) {
      case "8":
        if (this.beam == void 0)
          length = 35;
        break;
      case "16":
        length = this.beam == void 0 ? 35 : 25;
        break;
      case "32":
        length = this.beam == void 0 ? 45 : 35;
        break;
      case "64":
        length = this.beam == void 0 ? 50 : 40;
        break;
      case "128":
        length = this.beam == void 0 ? 55 : 45;
        break;
      default:
        break;
    }
    return length;
  }
  getStemDirection() {
    if (!this.stem_direction)
      throw new RuntimeError("NoStem", "No stem attached to this note.");
    return this.stem_direction;
  }
  setStemDirection(direction) {
    if (!direction)
      direction = Stem.UP;
    if (direction !== Stem.UP && direction !== Stem.DOWN) {
      throw new RuntimeError("BadArgument", `Invalid stem direction: ${direction}`);
    }
    this.stem_direction = direction;
    this.reset();
    if (this.hasFlag()) {
      this.buildFlag();
    }
    this.beam = void 0;
    if (this.stem) {
      this.stem.setDirection(direction);
      this.stem.setExtension(this.getStemExtension());
      const glyphProps = this.getBaseCustomNoteHeadGlyphProps() || this.getGlyphProps();
      const offsets = Tables.currentMusicFont().lookupMetric(`stem.noteHead.${glyphProps.code_head}`, {
        offsetYBaseStemUp: 0,
        offsetYTopStemUp: 0,
        offsetYBaseStemDown: 0,
        offsetYTopStemDown: 0
      });
      this.stem.setOptions({
        stem_up_y_offset: offsets.offsetYTopStemUp,
        stem_down_y_offset: offsets.offsetYTopStemDown,
        stem_up_y_base_offset: offsets.offsetYBaseStemUp,
        stem_down_y_base_offset: offsets.offsetYBaseStemDown
      });
    }
    if (this.preFormatted) {
      this.preFormat();
    }
    return this;
  }
  getStemX() {
    const x_begin = this.getAbsoluteX() + this.x_shift;
    const x_end = this.getAbsoluteX() + this.x_shift + this.getGlyphWidth();
    const stem_x = this.stem_direction === Stem.DOWN ? x_begin : x_end;
    return stem_x;
  }
  getCenterGlyphX() {
    return this.getAbsoluteX() + this.x_shift + this.getGlyphWidth() / 2;
  }
  getStemExtension() {
    const glyphProps = this.getGlyphProps();
    if (this.stem_extension_override != void 0) {
      return this.stem_extension_override;
    }
    if (this.beam) {
      return glyphProps.stem_beam_extension;
    }
    if (glyphProps) {
      return this.getStemDirection() === Stem.UP ? glyphProps.stem_up_extension : glyphProps.stem_down_extension;
    }
    return 0;
  }
  setStemLength(height) {
    this.stem_extension_override = height - Stem.HEIGHT;
    return this;
  }
  getStemExtents() {
    if (!this.stem)
      throw new RuntimeError("NoStem", "No stem attached to this note.");
    return this.stem.getExtents();
  }
  getYForTopText(textLine) {
    const stave = this.checkStave();
    if (this.hasStem()) {
      const extents = this.getStemExtents();
      if (!extents)
        throw new RuntimeError("InvalidState", "Stem does not have extents.");
      return Math.min(stave.getYForTopText(textLine), extents.topY - this.render_options.annotation_spacing * (textLine + 1));
    } else {
      return stave.getYForTopText(textLine);
    }
  }
  getYForBottomText(textLine) {
    const stave = this.checkStave();
    if (this.hasStem()) {
      const extents = this.getStemExtents();
      if (!extents)
        throw new RuntimeError("InvalidState", "Stem does not have extents.");
      return Math.max(stave.getYForTopText(textLine), extents.baseY + this.render_options.annotation_spacing * textLine);
    } else {
      return stave.getYForBottomText(textLine);
    }
  }
  hasFlag() {
    return Tables.getGlyphProps(this.duration).flag == true && !this.beam;
  }
  postFormat() {
    var _a;
    (_a = this.beam) === null || _a === void 0 ? void 0 : _a.postFormat();
    this.postFormatted = true;
    return this;
  }
  drawStem(stemOptions) {
    var _a;
    this.checkContext();
    this.setRendered();
    this.setStem(new Stem(stemOptions));
    (_a = this.stem) === null || _a === void 0 ? void 0 : _a.setContext(this.getContext()).draw();
  }
};

// node_modules/vexflow/build/esm/src/stavenote.js
function showDeprecationWarningForNoteHeads() {
  console.warn("StaveNote.note_heads is deprecated. Use StaveNote.noteHeads instead.", "This accessor will be removed in VexFlow 5.0.");
}
function L13(...args) {
  if (StaveNote.DEBUG)
    log("Vex.Flow.StaveNote", args);
}
var isInnerNoteIndex = (note, index) => index === (note.getStemDirection() === Stem.UP ? note.keyProps.length - 1 : 0);
function shiftRestVertical(rest, note, dir) {
  const delta = dir;
  rest.line += delta;
  rest.maxLine += delta;
  rest.minLine += delta;
  rest.note.setKeyLine(0, rest.note.getKeyLine(0) + delta);
}
function centerRest(rest, noteU, noteL) {
  const delta = rest.line - midLine(noteU.minLine, noteL.maxLine);
  rest.note.setKeyLine(0, rest.note.getKeyLine(0) - delta);
  rest.line -= delta;
  rest.maxLine -= delta;
  rest.minLine -= delta;
}
var StaveNote = class _StaveNote extends StemmableNote {
  static get CATEGORY() {
    return "StaveNote";
  }
  static get STEM_UP() {
    return Stem.UP;
  }
  static get STEM_DOWN() {
    return Stem.DOWN;
  }
  static get LEDGER_LINE_OFFSET() {
    return 3;
  }
  static get minNoteheadPadding() {
    const musicFont = Tables.currentMusicFont();
    return musicFont.lookupMetric("noteHead.minPadding");
  }
  static format(notes, state) {
    var _a, _b;
    if (!notes || notes.length < 2)
      return false;
    const notesList = [];
    for (let i = 0; i < notes.length; i++) {
      const props = notes[i].sortedKeyProps;
      const line = props[0].keyProps.line;
      let minL = props[props.length - 1].keyProps.line;
      const stemDirection = notes[i].getStemDirection();
      const stemMax = notes[i].getStemLength() / 10;
      const stemMin = notes[i].getStemMinimumLength() / 10;
      let maxL;
      if (notes[i].isRest()) {
        maxL = line + notes[i].glyphProps.line_above;
        minL = line - notes[i].glyphProps.line_below;
      } else {
        maxL = stemDirection === 1 ? props[props.length - 1].keyProps.line + stemMax : props[props.length - 1].keyProps.line;
        minL = stemDirection === 1 ? props[0].keyProps.line : props[0].keyProps.line - stemMax;
      }
      notesList.push({
        line: props[0].keyProps.line,
        maxLine: maxL,
        minLine: minL,
        isrest: notes[i].isRest(),
        stemDirection,
        stemMax,
        stemMin,
        voice_shift: notes[i].getVoiceShiftWidth(),
        is_displaced: notes[i].isDisplaced(),
        note: notes[i]
      });
    }
    let voices = 0;
    let noteU = void 0;
    let noteM = void 0;
    let noteL = void 0;
    const draw = [false, false, false];
    for (let i = 0; i < notesList.length; i++) {
      draw[i] = notesList[i].note.render_options.draw == false ? false : true;
    }
    if (draw[0] && draw[1] && draw[2]) {
      voices = 3;
      noteU = notesList[0];
      noteM = notesList[1];
      noteL = notesList[2];
    } else if (draw[0] && draw[1]) {
      voices = 2;
      noteU = notesList[0];
      noteL = notesList[1];
    } else if (draw[0] && draw[2]) {
      voices = 2;
      noteU = notesList[0];
      noteL = notesList[2];
    } else if (draw[1] && draw[2]) {
      voices = 2;
      noteU = notesList[1];
      noteL = notesList[2];
    } else {
      return true;
    }
    if (voices === 2 && noteU.stemDirection === -1 && noteL.stemDirection === 1) {
      noteU = notesList[1];
      noteL = notesList[0];
    }
    const voiceXShift = Math.max(noteU.voice_shift, noteL.voice_shift);
    let xShift = 0;
    if (voices === 2) {
      const lineSpacing = noteU.note.hasStem() && noteL.note.hasStem() && noteU.stemDirection === noteL.stemDirection ? 0 : 0.5;
      if (noteL.isrest && noteU.isrest && noteU.note.duration === noteL.note.duration) {
        noteL.note.render_options.draw = false;
      } else if (noteU.minLine <= noteL.maxLine + lineSpacing) {
        if (noteU.isrest) {
          shiftRestVertical(noteU, noteL, 1);
        } else if (noteL.isrest) {
          shiftRestVertical(noteL, noteU, -1);
        } else {
          const lineDiff = Math.abs(noteU.line - noteL.line);
          if (noteU.note.hasStem() && noteL.note.hasStem()) {
            const noteUHead = Tables.codeNoteHead((_a = noteU.note.sortedKeyProps[0].keyProps.code) !== null && _a !== void 0 ? _a : "N", noteU.note.duration);
            const noteLHead = Tables.codeNoteHead((_b = noteL.note.sortedKeyProps[noteL.note.sortedKeyProps.length - 1].keyProps.code) !== null && _b !== void 0 ? _b : "N", noteL.note.duration);
            if (!Tables.UNISON || noteUHead !== noteLHead || noteU.note.getModifiers().filter((item) => item.getCategory() === "Dot" && item.getIndex() === 0).length !== noteL.note.getModifiers().filter((item) => item.getCategory() === "Dot" && item.getIndex() === 0).length || lineDiff < 1 && lineDiff > 0 || JSON.stringify(noteU.note.getStyle()) !== JSON.stringify(noteL.note.getStyle())) {
              xShift = voiceXShift + 2;
              if (noteU.stemDirection === noteL.stemDirection) {
                noteU.note.setXShift(xShift);
              } else {
                noteL.note.setXShift(xShift);
              }
            } else if (noteU.note.voice !== noteL.note.voice) {
              if (noteU.stemDirection === noteL.stemDirection) {
                if (noteU.line != noteL.line) {
                  xShift = voiceXShift + 2;
                  noteU.note.setXShift(xShift);
                } else {
                  if (noteL.stemDirection === 1) {
                    noteL.stemDirection = -1;
                    noteL.note.setStemDirection(-1);
                  }
                }
              }
            }
          } else if (lineDiff < 1) {
            xShift = voiceXShift + 2;
            if (noteU.note.duration < noteL.note.duration) {
              noteU.note.setXShift(xShift);
            } else {
              noteL.note.setXShift(xShift);
            }
          } else if (noteU.note.hasStem()) {
            noteU.stemDirection = -noteU.note.getStemDirection();
            noteU.note.setStemDirection(noteU.stemDirection);
          } else if (noteL.note.hasStem()) {
            noteL.stemDirection = -noteL.note.getStemDirection();
            noteL.note.setStemDirection(noteL.stemDirection);
          }
        }
      }
      state.right_shift += xShift;
      return true;
    }
    if (!noteM)
      throw new RuntimeError("InvalidState", "noteM not defined.");
    if (noteM.isrest && !noteU.isrest && !noteL.isrest) {
      if (noteU.minLine <= noteM.maxLine || noteM.minLine <= noteL.maxLine) {
        const restHeight = noteM.maxLine - noteM.minLine;
        const space = noteU.minLine - noteL.maxLine;
        if (restHeight < space) {
          centerRest(noteM, noteU, noteL);
        } else {
          xShift = voiceXShift + 2;
          noteM.note.setXShift(xShift);
          if (noteL.note.hasBeam() === false) {
            noteL.stemDirection = -1;
            noteL.note.setStemDirection(-1);
          }
          if (noteU.minLine <= noteL.maxLine && noteU.note.hasBeam() === false) {
            noteU.stemDirection = 1;
            noteU.note.setStemDirection(1);
          }
        }
        state.right_shift += xShift;
        return true;
      }
    }
    if (noteU.isrest && noteM.isrest && noteL.isrest) {
      noteU.note.render_options.draw = false;
      noteL.note.render_options.draw = false;
      state.right_shift += xShift;
      return true;
    }
    if (noteM.isrest && noteU.isrest && noteM.minLine <= noteL.maxLine) {
      noteM.note.render_options.draw = false;
    }
    if (noteM.isrest && noteL.isrest && noteU.minLine <= noteM.maxLine) {
      noteM.note.render_options.draw = false;
    }
    if (noteU.isrest && noteU.minLine <= noteM.maxLine) {
      shiftRestVertical(noteU, noteM, 1);
    }
    if (noteL.isrest && noteM.minLine <= noteL.maxLine) {
      shiftRestVertical(noteL, noteM, -1);
    }
    if (noteU.minLine <= noteM.maxLine + 0.5 || noteM.minLine <= noteL.maxLine) {
      xShift = voiceXShift + 2;
      noteM.note.setXShift(xShift);
      if (noteL.note.hasBeam() === false) {
        noteL.stemDirection = -1;
        noteL.note.setStemDirection(-1);
      }
      if (noteU.minLine <= noteL.maxLine && noteU.note.hasBeam() === false) {
        noteU.stemDirection = 1;
        noteU.note.setStemDirection(1);
      }
    }
    state.right_shift += xShift;
    return true;
  }
  static postFormat(notes) {
    if (!notes)
      return false;
    notes.forEach((note) => note.postFormat());
    return true;
  }
  constructor(noteStruct) {
    var _a, _b, _c;
    super(noteStruct);
    this.minLine = 0;
    this.maxLine = 0;
    this.sortedKeyProps = [];
    this.ledgerLineStyle = {};
    this.clef = (_a = noteStruct.clef) !== null && _a !== void 0 ? _a : "treble";
    this.octave_shift = (_b = noteStruct.octave_shift) !== null && _b !== void 0 ? _b : 0;
    this.glyphProps = Tables.getGlyphProps(this.duration, this.noteType);
    defined(this.glyphProps, "BadArguments", `No glyph found for duration '${this.duration}' and type '${this.noteType}'`);
    this.displaced = false;
    this.dot_shiftY = 0;
    this.use_default_head_x = false;
    this._noteHeads = [];
    this.modifiers = [];
    this.render_options = Object.assign(Object.assign({}, this.render_options), { glyph_font_scale: noteStruct.glyph_font_scale || Tables.NOTATION_FONT_SCALE, stroke_px: noteStruct.stroke_px || _StaveNote.LEDGER_LINE_OFFSET });
    this.calculateKeyProps();
    this.buildStem();
    if (noteStruct.auto_stem) {
      this.autoStem();
    } else {
      this.setStemDirection((_c = noteStruct.stem_direction) !== null && _c !== void 0 ? _c : Stem.UP);
    }
    this.reset();
    this.buildFlag();
  }
  reset() {
    super.reset();
    const noteHeadStyles = this._noteHeads.map((noteHead) => noteHead.getStyle());
    this.buildNoteHeads();
    this._noteHeads.forEach((noteHead, index) => {
      const noteHeadStyle = noteHeadStyles[index];
      if (noteHeadStyle)
        noteHead.setStyle(noteHeadStyle);
    });
    const stave = this.stave;
    if (stave) {
      this.setStave(stave);
    }
    this.calcNoteDisplacements();
    return this;
  }
  setBeam(beam) {
    this.beam = beam;
    this.calcNoteDisplacements();
    if (this.stem) {
      this.stem.setExtension(this.getStemExtension());
    }
    return this;
  }
  buildStem() {
    this.setStem(new Stem({ hide: !!this.isRest() }));
    return this;
  }
  buildNoteHeads() {
    this._noteHeads = [];
    const stemDirection = this.getStemDirection();
    const keys = this.getKeys();
    let lastLine = void 0;
    let lineDiff = void 0;
    let displaced = false;
    let start;
    let end;
    let step;
    if (stemDirection === Stem.UP) {
      start = 0;
      end = keys.length;
      step = 1;
    } else {
      start = keys.length - 1;
      end = -1;
      step = -1;
    }
    for (let i = start; i !== end; i += step) {
      const noteProps = this.sortedKeyProps[i].keyProps;
      const line = noteProps.line;
      if (lastLine === void 0) {
        lastLine = line;
      } else {
        lineDiff = Math.abs(lastLine - line);
        if (lineDiff === 0 || lineDiff === 0.5) {
          displaced = !displaced;
        } else {
          displaced = false;
          this.use_default_head_x = true;
        }
      }
      lastLine = line;
      const notehead = new NoteHead({
        duration: this.duration,
        note_type: this.noteType,
        displaced,
        stem_direction: stemDirection,
        custom_glyph_code: noteProps.code,
        glyph_font_scale: this.render_options.glyph_font_scale,
        x_shift: noteProps.shift_right,
        stem_up_x_offset: noteProps.stem_up_x_offset,
        stem_down_x_offset: noteProps.stem_down_x_offset,
        line: noteProps.line
      });
      this.addChildElement(notehead);
      this._noteHeads[this.sortedKeyProps[i].index] = notehead;
    }
  }
  autoStem() {
    this.setStemDirection(this.calculateOptimalStemDirection());
  }
  calculateOptimalStemDirection() {
    this.minLine = this.sortedKeyProps[0].keyProps.line;
    this.maxLine = this.sortedKeyProps[this.keyProps.length - 1].keyProps.line;
    const MIDDLE_LINE = 3;
    const decider = (this.minLine + this.maxLine) / 2;
    const stemDirection = decider < MIDDLE_LINE ? Stem.UP : Stem.DOWN;
    return stemDirection;
  }
  calculateKeyProps() {
    let lastLine;
    for (let i = 0; i < this.keys.length; ++i) {
      const key = this.keys[i];
      if (this.glyphProps.rest)
        this.glyphProps.position = key;
      const options = { octave_shift: this.octave_shift || 0, duration: this.duration };
      const props = Tables.keyProperties(key, this.clef, options);
      if (!props) {
        throw new RuntimeError("BadArguments", `Invalid key for note properties: ${key}`);
      }
      if (props.key === "R") {
        if (this.duration === "1" || this.duration === "w") {
          props.line = 4;
        } else {
          props.line = 3;
        }
      }
      const line = props.line;
      if (lastLine == void 0) {
        lastLine = line;
      } else {
        if (Math.abs(lastLine - line) === 0.5) {
          this.displaced = true;
          props.displaced = true;
          if (this.keyProps.length > 0) {
            this.keyProps[i - 1].displaced = true;
          }
        }
      }
      lastLine = line;
      this.keyProps.push(props);
    }
    this.keyProps.forEach((keyProps, index) => {
      this.sortedKeyProps.push({ keyProps, index });
    });
    this.sortedKeyProps.sort((a, b) => a.keyProps.line - b.keyProps.line);
  }
  getBoundingBox() {
    var _a, _b;
    if (!this.preFormatted) {
      throw new RuntimeError("UnformattedNote", "Can't call getBoundingBox on an unformatted note.");
    }
    const { width: w, modLeftPx, leftDisplacedHeadPx } = this.getMetrics();
    const x = this.getAbsoluteX() - modLeftPx - leftDisplacedHeadPx;
    let minY = 0;
    let maxY = 0;
    const halfLineSpacing = ((_b = (_a = this.getStave()) === null || _a === void 0 ? void 0 : _a.getSpacingBetweenLines()) !== null && _b !== void 0 ? _b : 0) / 2;
    const lineSpacing = halfLineSpacing * 2;
    if (this.isRest()) {
      const y = this.ys[0];
      const frac = Tables.durationToFraction(this.duration);
      if (frac.equals(1) || frac.equals(2)) {
        minY = y - halfLineSpacing;
        maxY = y + halfLineSpacing;
      } else {
        minY = y - this.glyphProps.line_above * lineSpacing;
        maxY = y + this.glyphProps.line_below * lineSpacing;
      }
    } else if (this.glyphProps.stem) {
      const ys = this.getStemExtents();
      ys.baseY += halfLineSpacing * this.getStemDirection();
      minY = Math.min(ys.topY, ys.baseY);
      maxY = Math.max(ys.topY, ys.baseY);
    } else {
      minY = 0;
      maxY = 0;
      for (let i = 0; i < this.ys.length; ++i) {
        const yy = this.ys[i];
        if (i === 0) {
          minY = yy;
          maxY = yy;
        } else {
          minY = Math.min(yy, minY);
          maxY = Math.max(yy, maxY);
        }
      }
      minY -= halfLineSpacing;
      maxY += halfLineSpacing;
    }
    return new BoundingBox(x, minY, w, maxY - minY);
  }
  getLineNumber(isTopNote) {
    if (!this.keyProps.length) {
      throw new RuntimeError("NoKeyProps", "Can't get bottom note line, because note is not initialized properly.");
    }
    let resultLine = this.keyProps[0].line;
    for (let i = 0; i < this.keyProps.length; i++) {
      const thisLine = this.keyProps[i].line;
      if (isTopNote) {
        if (thisLine > resultLine)
          resultLine = thisLine;
      } else {
        if (thisLine < resultLine)
          resultLine = thisLine;
      }
    }
    return resultLine;
  }
  isRest() {
    return this.glyphProps.rest;
  }
  isChord() {
    return !this.isRest() && this.keys.length > 1;
  }
  hasStem() {
    return this.glyphProps.stem;
  }
  hasFlag() {
    return super.hasFlag() && !this.isRest();
  }
  getStemX() {
    if (this.noteType === "r") {
      return this.getCenterGlyphX();
    } else {
      return super.getStemX() + (this.stem_direction ? Stem.WIDTH / (2 * -this.stem_direction) : 0);
    }
  }
  getYForTopText(textLine) {
    const extents = this.getStemExtents();
    return Math.min(this.checkStave().getYForTopText(textLine), extents.topY - this.render_options.annotation_spacing * (textLine + 1));
  }
  getYForBottomText(textLine) {
    const extents = this.getStemExtents();
    return Math.max(this.checkStave().getYForTopText(textLine), extents.baseY + this.render_options.annotation_spacing * textLine);
  }
  setStave(stave) {
    super.setStave(stave);
    const ys = this._noteHeads.map((notehead) => {
      notehead.setStave(stave);
      return notehead.getY();
    });
    this.setYs(ys);
    if (this.stem) {
      const { y_top, y_bottom } = this.getNoteHeadBounds();
      this.stem.setYBounds(y_top, y_bottom);
    }
    return this;
  }
  isDisplaced() {
    return this.displaced;
  }
  setNoteDisplaced(displaced) {
    this.displaced = displaced;
    return this;
  }
  getTieRightX() {
    let tieStartX = this.getAbsoluteX();
    tieStartX += this.getGlyphWidth() + this.x_shift + this.rightDisplacedHeadPx;
    if (this.modifierContext)
      tieStartX += this.modifierContext.getRightShift();
    return tieStartX;
  }
  getTieLeftX() {
    let tieEndX = this.getAbsoluteX();
    tieEndX += this.x_shift - this.leftDisplacedHeadPx;
    return tieEndX;
  }
  getLineForRest() {
    let restLine = this.keyProps[0].line;
    if (this.keyProps.length > 1) {
      const lastLine = this.keyProps[this.keyProps.length - 1].line;
      const top = Math.max(restLine, lastLine);
      const bot = Math.min(restLine, lastLine);
      restLine = midLine(top, bot);
    }
    return restLine;
  }
  getModifierStartXY(position, index, options = {}) {
    var _a, _b;
    if (!this.preFormatted) {
      throw new RuntimeError("UnformattedNote", "Can't call GetModifierStartXY on an unformatted note");
    }
    if (this.ys.length === 0) {
      throw new RuntimeError("NoYValues", "No Y-Values calculated for this note.");
    }
    const { ABOVE: ABOVE2, BELOW: BELOW2, LEFT, RIGHT } = Modifier.Position;
    let x = 0;
    if (position === LEFT) {
      x = -1 * 2;
    } else if (position === RIGHT) {
      x = this.getGlyphWidth() + this.x_shift + 2;
      if (this.stem_direction === Stem.UP && this.hasFlag() && (options.forceFlagRight || isInnerNoteIndex(this, index))) {
        x += (_b = (_a = this === null || this === void 0 ? void 0 : this.flag) === null || _a === void 0 ? void 0 : _a.getMetrics().width) !== null && _b !== void 0 ? _b : 0;
      }
    } else if (position === BELOW2 || position === ABOVE2) {
      x = this.getGlyphWidth() / 2;
    }
    return {
      x: this.getAbsoluteX() + x,
      y: this.ys[index]
    };
  }
  setStyle(style) {
    return super.setGroupStyle(style);
  }
  setStemStyle(style) {
    const stem = this.getStem();
    if (stem)
      stem.setStyle(style);
    return this;
  }
  getStemStyle() {
    var _a;
    return (_a = this.stem) === null || _a === void 0 ? void 0 : _a.getStyle();
  }
  setLedgerLineStyle(style) {
    this.ledgerLineStyle = style;
  }
  getLedgerLineStyle() {
    return this.ledgerLineStyle;
  }
  setFlagStyle(style) {
    var _a;
    (_a = this.flag) === null || _a === void 0 ? void 0 : _a.setStyle(style);
  }
  getFlagStyle() {
    var _a;
    return (_a = this.flag) === null || _a === void 0 ? void 0 : _a.getStyle();
  }
  setKeyStyle(index, style) {
    this._noteHeads[index].setStyle(style);
    return this;
  }
  setKeyLine(index, line) {
    this.keyProps[index].line = line;
    this.reset();
    return this;
  }
  getKeyLine(index) {
    return this.keyProps[index].line;
  }
  getVoiceShiftWidth() {
    return this.getGlyphWidth() * (this.displaced ? 2 : 1);
  }
  calcNoteDisplacements() {
    this.setLeftDisplacedHeadPx(this.displaced && this.stem_direction === Stem.DOWN ? this.getGlyphWidth() : 0);
    this.setRightDisplacedHeadPx(!this.hasFlag() && this.displaced && this.stem_direction === Stem.UP ? this.getGlyphWidth() : 0);
  }
  preFormat() {
    if (this.preFormatted)
      return;
    let noteHeadPadding = 0;
    if (this.modifierContext) {
      this.modifierContext.preFormat();
      if (this.modifierContext.getWidth() === 0) {
        noteHeadPadding = _StaveNote.minNoteheadPadding;
      }
    }
    let width = this.getGlyphWidth() + this.leftDisplacedHeadPx + this.rightDisplacedHeadPx + noteHeadPadding;
    if (this.shouldDrawFlag() && this.stem_direction === Stem.UP) {
      width += this.getGlyphWidth();
    }
    this.setWidth(width);
    this.preFormatted = true;
  }
  getNoteHeadBounds() {
    let yTop = Infinity;
    let yBottom = -Infinity;
    let nonDisplacedX;
    let displacedX;
    let highestLine = this.checkStave().getNumLines();
    let lowestLine = 1;
    let highestDisplacedLine;
    let lowestDisplacedLine;
    let highestNonDisplacedLine = highestLine;
    let lowestNonDisplacedLine = lowestLine;
    this._noteHeads.forEach((notehead) => {
      const line = notehead.getLine();
      const y = notehead.getY();
      yTop = Math.min(y, yTop);
      yBottom = Math.max(y, yBottom);
      if (displacedX === void 0 && notehead.isDisplaced()) {
        displacedX = notehead.getAbsoluteX();
      }
      if (nonDisplacedX === void 0 && !notehead.isDisplaced()) {
        nonDisplacedX = notehead.getAbsoluteX();
      }
      highestLine = Math.max(line, highestLine);
      lowestLine = Math.min(line, lowestLine);
      if (notehead.isDisplaced()) {
        highestDisplacedLine = highestDisplacedLine === void 0 ? line : Math.max(line, highestDisplacedLine);
        lowestDisplacedLine = lowestDisplacedLine === void 0 ? line : Math.min(line, lowestDisplacedLine);
      } else {
        highestNonDisplacedLine = Math.max(line, highestNonDisplacedLine);
        lowestNonDisplacedLine = Math.min(line, lowestNonDisplacedLine);
      }
    }, this);
    return {
      y_top: yTop,
      y_bottom: yBottom,
      displaced_x: displacedX,
      non_displaced_x: nonDisplacedX,
      highest_line: highestLine,
      lowest_line: lowestLine,
      highest_displaced_line: highestDisplacedLine,
      lowest_displaced_line: lowestDisplacedLine,
      highest_non_displaced_line: highestNonDisplacedLine,
      lowest_non_displaced_line: lowestNonDisplacedLine
    };
  }
  getNoteHeadBeginX() {
    return this.getAbsoluteX() + this.x_shift;
  }
  getNoteHeadEndX() {
    const xBegin = this.getNoteHeadBeginX();
    return xBegin + this.getGlyphWidth();
  }
  get noteHeads() {
    return this._noteHeads.slice();
  }
  get note_heads() {
    showDeprecationWarningForNoteHeads();
    return this.noteHeads;
  }
  drawLedgerLines() {
    const stave = this.checkStave();
    const { glyphProps, render_options: { stroke_px } } = this;
    const ctx = this.checkContext();
    const width = glyphProps.getWidth() + stroke_px * 2;
    const doubleWidth = 2 * (glyphProps.getWidth() + stroke_px) - Stem.WIDTH / 2;
    if (this.isRest())
      return;
    if (!ctx) {
      throw new RuntimeError("NoCanvasContext", "Can't draw without a canvas context.");
    }
    const { highest_line, lowest_line, highest_displaced_line, highest_non_displaced_line, lowest_displaced_line, lowest_non_displaced_line, displaced_x, non_displaced_x } = this.getNoteHeadBounds();
    if (highest_line < 6 && lowest_line > 0)
      return;
    const min_x = Math.min(displaced_x !== null && displaced_x !== void 0 ? displaced_x : 0, non_displaced_x !== null && non_displaced_x !== void 0 ? non_displaced_x : 0);
    const drawLedgerLine = (y, normal, displaced) => {
      let x;
      if (displaced && normal)
        x = min_x - stroke_px;
      else if (normal)
        x = (non_displaced_x !== null && non_displaced_x !== void 0 ? non_displaced_x : 0) - stroke_px;
      else
        x = (displaced_x !== null && displaced_x !== void 0 ? displaced_x : 0) - stroke_px;
      const ledgerWidth = normal && displaced ? doubleWidth : width;
      ctx.beginPath();
      ctx.moveTo(x, y);
      ctx.lineTo(x + ledgerWidth, y);
      ctx.stroke();
    };
    const style = Object.assign(Object.assign({}, stave.getDefaultLedgerLineStyle()), this.getLedgerLineStyle());
    this.applyStyle(ctx, style);
    for (let line = 6; line <= highest_line; ++line) {
      const normal = non_displaced_x !== void 0 && line <= highest_non_displaced_line;
      const displaced = highest_displaced_line !== void 0 && line <= highest_displaced_line;
      drawLedgerLine(stave.getYForNote(line), normal, displaced);
    }
    for (let line = 0; line >= lowest_line; --line) {
      const normal = non_displaced_x !== void 0 && line >= lowest_non_displaced_line;
      const displaced = lowest_displaced_line !== void 0 && line >= lowest_displaced_line;
      drawLedgerLine(stave.getYForNote(line), normal, displaced);
    }
    this.restoreStyle(ctx, style);
  }
  drawModifiers(noteheadParam) {
    const ctx = this.checkContext();
    for (let i = 0; i < this.modifiers.length; i++) {
      const modifier = this.modifiers[i];
      const index = modifier.checkIndex();
      const notehead = this._noteHeads[index];
      if (notehead == noteheadParam) {
        const noteheadStyle = notehead.getStyle();
        notehead.applyStyle(ctx, noteheadStyle);
        modifier.setContext(ctx);
        modifier.drawWithStyle();
        notehead.restoreStyle(ctx, noteheadStyle);
      }
    }
  }
  shouldDrawFlag() {
    const hasStem = this.stem !== void 0;
    const hasFlag = this.glyphProps.flag == true;
    const hasNoBeam = this.beam === void 0;
    return hasStem && hasFlag && hasNoBeam;
  }
  drawFlag() {
    var _a, _b, _c, _d, _e;
    const ctx = this.checkContext();
    if (!ctx) {
      throw new RuntimeError("NoCanvasContext", "Can't draw without a canvas context.");
    }
    if (this.shouldDrawFlag()) {
      const { y_top, y_bottom } = this.getNoteHeadBounds();
      const noteStemHeight = this.stem.getHeight();
      const flagX = this.getStemX();
      const flagY = this.getStemDirection() === Stem.DOWN ? y_top - noteStemHeight + 2 - (this.glyphProps ? this.glyphProps.stem_down_extension : 0) * this.getStaveNoteScale() - ((_b = (_a = this.flag) === null || _a === void 0 ? void 0 : _a.getMetrics().y_shift) !== null && _b !== void 0 ? _b : 0) * (1 - this.getStaveNoteScale()) : y_bottom - noteStemHeight - 2 + (this.glyphProps ? this.glyphProps.stem_up_extension : 0) * this.getStaveNoteScale() - ((_d = (_c = this.flag) === null || _c === void 0 ? void 0 : _c.getMetrics().y_shift) !== null && _d !== void 0 ? _d : 0) * (1 - this.getStaveNoteScale());
      (_e = this.flag) === null || _e === void 0 ? void 0 : _e.render(ctx, flagX, flagY);
    }
  }
  drawNoteHeads() {
    const ctx = this.checkContext();
    this._noteHeads.forEach((notehead) => {
      notehead.applyStyle(ctx);
      ctx.openGroup("notehead", notehead.getAttribute("id"), { pointerBBox: true });
      notehead.setContext(ctx).draw();
      this.drawModifiers(notehead);
      ctx.closeGroup();
      notehead.restoreStyle(ctx);
    });
  }
  drawStem(stemOptions) {
    const ctx = this.checkContext();
    if (stemOptions) {
      this.setStem(new Stem(stemOptions));
    }
    if (this.shouldDrawFlag() && this.stem) {
      this.stem.adjustHeightForFlag();
    }
    if (this.stem) {
      this.stem.setContext(ctx).draw();
    }
  }
  getStaveNoteScale() {
    return 1;
  }
  getStemExtension() {
    const super_stem_extension = super.getStemExtension();
    if (!this.glyphProps.stem) {
      return super_stem_extension;
    }
    const stem_direction = this.getStemDirection();
    if (stem_direction !== this.calculateOptimalStemDirection()) {
      return super_stem_extension;
    }
    let mid_line_distance;
    const MIDDLE_LINE = 3;
    if (stem_direction === Stem.UP) {
      mid_line_distance = MIDDLE_LINE - this.maxLine;
    } else {
      mid_line_distance = this.minLine - MIDDLE_LINE;
    }
    const lines_over_octave_from_mid_line = mid_line_distance - 3.5;
    if (lines_over_octave_from_mid_line <= 0) {
      return super_stem_extension;
    }
    const stave = this.getStave();
    let spacing_between_lines = 10;
    if (stave != void 0) {
      spacing_between_lines = stave.getSpacingBetweenLines();
    }
    return super_stem_extension + lines_over_octave_from_mid_line * spacing_between_lines;
  }
  draw() {
    if (this.render_options.draw === false)
      return;
    if (this.ys.length === 0) {
      throw new RuntimeError("NoYValues", "Can't draw note without Y values.");
    }
    const ctx = this.checkContext();
    const xBegin = this.getNoteHeadBeginX();
    const shouldRenderStem = this.hasStem() && !this.beam;
    this._noteHeads.forEach((notehead) => notehead.setX(xBegin));
    if (this.stem) {
      const stemX = this.getStemX();
      this.stem.setNoteHeadXBounds(stemX, stemX);
    }
    L13("Rendering ", this.isChord() ? "chord :" : "note :", this.keys);
    this.applyStyle();
    ctx.openGroup("stavenote", this.getAttribute("id"));
    this.drawLedgerLines();
    if (shouldRenderStem)
      this.drawStem();
    this.drawNoteHeads();
    this.drawFlag();
    ctx.closeGroup();
    this.restoreStyle();
    this.setRendered();
  }
};
StaveNote.DEBUG = false;

// node_modules/vexflow/build/esm/src/stavetie.js
var StaveTie = class extends Element {
  static get CATEGORY() {
    return "StaveTie";
  }
  constructor(notes, text) {
    super();
    this.setNotes(notes);
    this.text = text;
    this.render_options = {
      cp1: 8,
      cp2: 12,
      text_shift_x: 0,
      first_x_shift: 0,
      last_x_shift: 0,
      y_shift: 7,
      tie_spacing: 0
    };
    this.resetFont();
  }
  setDirection(direction) {
    this.direction = direction;
    return this;
  }
  setNotes(notes) {
    if (!notes.first_note && !notes.last_note) {
      throw new RuntimeError("BadArguments", "Tie needs to have either first_note or last_note set.");
    }
    if (!notes.first_indices) {
      notes.first_indices = [0];
    }
    if (!notes.last_indices) {
      notes.last_indices = [0];
    }
    if (notes.first_indices.length !== notes.last_indices.length) {
      throw new RuntimeError("BadArguments", "Tied notes must have same number of indices.");
    }
    this.notes = notes;
    return this;
  }
  isPartial() {
    return !this.notes.first_note || !this.notes.last_note;
  }
  renderTie(params) {
    if (params.first_ys.length === 0 || params.last_ys.length === 0) {
      throw new RuntimeError("BadArguments", "No Y-values to render");
    }
    const ctx = this.checkContext();
    let cp1 = this.render_options.cp1;
    let cp2 = this.render_options.cp2;
    if (Math.abs(params.last_x_px - params.first_x_px) < 10) {
      cp1 = 2;
      cp2 = 8;
    }
    const first_x_shift = this.render_options.first_x_shift;
    const last_x_shift = this.render_options.last_x_shift;
    const y_shift = this.render_options.y_shift * params.direction;
    const first_indices = this.notes.first_indices;
    const last_indices = this.notes.last_indices;
    this.applyStyle();
    ctx.openGroup("stavetie", this.getAttribute("id"));
    for (let i = 0; i < first_indices.length; ++i) {
      const cp_x = (params.last_x_px + last_x_shift + (params.first_x_px + first_x_shift)) / 2;
      const first_y_px = params.first_ys[first_indices[i]] + y_shift;
      const last_y_px = params.last_ys[last_indices[i]] + y_shift;
      if (isNaN(first_y_px) || isNaN(last_y_px)) {
        throw new RuntimeError("BadArguments", "Bad indices for tie rendering.");
      }
      const top_cp_y = (first_y_px + last_y_px) / 2 + cp1 * params.direction;
      const bottom_cp_y = (first_y_px + last_y_px) / 2 + cp2 * params.direction;
      ctx.beginPath();
      ctx.moveTo(params.first_x_px + first_x_shift, first_y_px);
      ctx.quadraticCurveTo(cp_x, top_cp_y, params.last_x_px + last_x_shift, last_y_px);
      ctx.quadraticCurveTo(cp_x, bottom_cp_y, params.first_x_px + first_x_shift, first_y_px);
      ctx.closePath();
      ctx.fill();
    }
    ctx.closeGroup();
    this.restoreStyle();
  }
  renderText(first_x_px, last_x_px) {
    var _a, _b, _c;
    if (!this.text)
      return;
    const ctx = this.checkContext();
    let center_x = (first_x_px + last_x_px) / 2;
    center_x -= ctx.measureText(this.text).width / 2;
    const stave = (_b = (_a = this.notes.first_note) === null || _a === void 0 ? void 0 : _a.checkStave()) !== null && _b !== void 0 ? _b : (_c = this.notes.last_note) === null || _c === void 0 ? void 0 : _c.checkStave();
    if (stave) {
      ctx.save();
      ctx.setFont(this.textFont);
      ctx.fillText(this.text, center_x + this.render_options.text_shift_x, stave.getYForTopText() - 1);
      ctx.restore();
    }
  }
  getNotes() {
    return this.notes;
  }
  draw() {
    this.checkContext();
    this.setRendered();
    const first_note = this.notes.first_note;
    const last_note = this.notes.last_note;
    let first_x_px = 0;
    let last_x_px = 0;
    let first_ys = [0];
    let last_ys = [0];
    let stem_direction = 0;
    if (first_note) {
      first_x_px = first_note.getTieRightX() + this.render_options.tie_spacing;
      stem_direction = first_note.getStemDirection();
      first_ys = first_note.getYs();
    } else if (last_note) {
      const stave = last_note.checkStave();
      first_x_px = stave.getTieStartX();
      first_ys = last_note.getYs();
      this.notes.first_indices = this.notes.last_indices;
    }
    if (last_note) {
      last_x_px = last_note.getTieLeftX() + this.render_options.tie_spacing;
      stem_direction = last_note.getStemDirection();
      last_ys = last_note.getYs();
    } else if (first_note) {
      const stave = first_note.checkStave();
      last_x_px = stave.getTieEndX();
      last_ys = first_note.getYs();
      this.notes.last_indices = this.notes.first_indices;
    }
    if (this.direction) {
      stem_direction = this.direction;
    }
    this.renderTie({
      first_x_px,
      last_x_px,
      first_ys,
      last_ys,
      direction: stem_direction
    });
    this.renderText(first_x_px, last_x_px);
    return true;
  }
};
StaveTie.TEXT_FONT = Object.assign({}, Element.TEXT_FONT);

// node_modules/vexflow/build/esm/src/tabtie.js
var TabTie = class _TabTie extends StaveTie {
  static get CATEGORY() {
    return "TabTie";
  }
  static createHammeron(notes) {
    return new _TabTie(notes, "H");
  }
  static createPulloff(notes) {
    return new _TabTie(notes, "P");
  }
  constructor(notes, text) {
    super(notes, text);
    this.render_options.cp1 = 9;
    this.render_options.cp2 = 11;
    this.render_options.y_shift = 3;
    this.direction = -1;
  }
};

// node_modules/vexflow/build/esm/src/voice.js
var VoiceMode;
(function(VoiceMode2) {
  VoiceMode2[VoiceMode2["STRICT"] = 1] = "STRICT";
  VoiceMode2[VoiceMode2["SOFT"] = 2] = "SOFT";
  VoiceMode2[VoiceMode2["FULL"] = 3] = "FULL";
})(VoiceMode || (VoiceMode = {}));
var Voice = class extends Element {
  static get CATEGORY() {
    return "Voice";
  }
  static get Mode() {
    return VoiceMode;
  }
  constructor(time) {
    super();
    this.resolutionMultiplier = 1;
    this.mode = VoiceMode.STRICT;
    this.preFormatted = false;
    this.ticksUsed = new Fraction(0, 1);
    this.largestTickWidth = 0;
    this.tickables = [];
    this.options = {
      softmaxFactor: Tables.SOFTMAX_FACTOR
    };
    let voiceTime;
    if (typeof time === "string") {
      const match = time.match(/(\d+)\/(\d+)/);
      if (match) {
        voiceTime = {
          num_beats: parseInt(match[1]),
          beat_value: parseInt(match[2])
        };
      }
    } else {
      voiceTime = time;
    }
    this.time = Object.assign({ num_beats: 4, beat_value: 4, resolution: Tables.RESOLUTION }, voiceTime);
    this.totalTicks = new Fraction(this.time.num_beats * (this.time.resolution / this.time.beat_value), 1);
    this.smallestTickCount = this.totalTicks.clone();
  }
  getTotalTicks() {
    return this.totalTicks;
  }
  getTicksUsed() {
    return this.ticksUsed;
  }
  getLargestTickWidth() {
    return this.largestTickWidth;
  }
  getSmallestTickCount() {
    return this.smallestTickCount;
  }
  getTickables() {
    return this.tickables;
  }
  getMode() {
    return this.mode;
  }
  setMode(mode) {
    this.mode = mode;
    return this;
  }
  getResolutionMultiplier() {
    return this.resolutionMultiplier;
  }
  getActualResolution() {
    return this.resolutionMultiplier * this.time.resolution;
  }
  setStave(stave) {
    this.stave = stave;
    this.boundingBox = void 0;
    return this;
  }
  getStave() {
    return this.stave;
  }
  getBoundingBox() {
    if (!this.boundingBox) {
      const stave = this.checkStave();
      let boundingBox = void 0;
      for (let i = 0; i < this.tickables.length; ++i) {
        const tickable = this.tickables[i];
        if (!tickable.getStave())
          tickable.setStave(stave);
        const bb = tickable.getBoundingBox();
        if (bb) {
          boundingBox = boundingBox ? boundingBox.mergeWith(bb) : bb;
        }
      }
      this.boundingBox = boundingBox;
    }
    return this.boundingBox;
  }
  setStrict(strict) {
    this.mode = strict ? VoiceMode.STRICT : VoiceMode.SOFT;
    return this;
  }
  isComplete() {
    if (this.mode === VoiceMode.STRICT || this.mode === VoiceMode.FULL) {
      return this.ticksUsed.equals(this.totalTicks);
    } else {
      return true;
    }
  }
  setSoftmaxFactor(factor) {
    this.options.softmaxFactor = factor;
    this.expTicksUsed = 0;
    return this;
  }
  reCalculateExpTicksUsed() {
    const totalTicks = this.ticksUsed.value();
    const exp = (tickable) => Math.pow(this.options.softmaxFactor, tickable.getTicks().value() / totalTicks);
    this.expTicksUsed = sumArray(this.tickables.map(exp));
    return this.expTicksUsed;
  }
  softmax(tickValue) {
    if (!this.expTicksUsed) {
      this.expTicksUsed = this.reCalculateExpTicksUsed();
    }
    const totalTicks = this.ticksUsed.value();
    const exp = (v) => Math.pow(this.options.softmaxFactor, v / totalTicks);
    const sm = exp(tickValue) / this.expTicksUsed;
    return sm;
  }
  addTickable(tickable) {
    if (!tickable.shouldIgnoreTicks()) {
      const ticks = tickable.getTicks();
      this.ticksUsed.add(ticks);
      this.expTicksUsed = 0;
      if ((this.mode === VoiceMode.STRICT || this.mode === VoiceMode.FULL) && this.ticksUsed.greaterThan(this.totalTicks)) {
        this.ticksUsed.subtract(ticks);
        throw new RuntimeError("BadArgument", "Too many ticks.");
      }
      if (ticks.lessThan(this.smallestTickCount)) {
        this.smallestTickCount = ticks.clone();
      }
      this.resolutionMultiplier = this.ticksUsed.denominator;
      this.totalTicks.add(0, this.ticksUsed.denominator);
    }
    this.tickables.push(tickable);
    tickable.setVoice(this);
    return this;
  }
  addTickables(tickables) {
    for (let i = 0; i < tickables.length; ++i) {
      this.addTickable(tickables[i]);
    }
    return this;
  }
  preFormat() {
    if (this.preFormatted)
      return this;
    const stave = this.checkStave();
    this.tickables.forEach((tickable) => {
      if (!tickable.getStave()) {
        tickable.setStave(stave);
      }
    });
    this.preFormatted = true;
    return this;
  }
  checkStave() {
    return defined(this.stave, "NoStave", "No stave attached to instance.");
  }
  draw(context = this.checkContext(), stave) {
    stave = stave !== null && stave !== void 0 ? stave : this.stave;
    this.setRendered();
    let boundingBox = void 0;
    for (let i = 0; i < this.tickables.length; ++i) {
      const tickable = this.tickables[i];
      if (stave) {
        tickable.setStave(stave);
      }
      defined(tickable.getStave(), "MissingStave", "The voice cannot draw tickables without staves.");
      const bb = tickable.getBoundingBox();
      if (bb) {
        boundingBox = boundingBox ? boundingBox.mergeWith(bb) : bb;
      }
      tickable.setContext(context);
      tickable.drawWithStyle();
    }
    this.boundingBox = boundingBox;
  }
};

// node_modules/vexflow/build/esm/src/gracenotegroup.js
function L14(...args) {
  if (GraceNoteGroup.DEBUG)
    log("Vex.Flow.GraceNoteGroup", args);
}
var GraceNoteGroup = class extends Modifier {
  static get CATEGORY() {
    return "GraceNoteGroup";
  }
  static format(gracenote_groups, state) {
    const group_spacing_stave = 4;
    const group_spacing_tab = 0;
    if (!gracenote_groups || gracenote_groups.length === 0)
      return false;
    const group_list = [];
    let prev_note = null;
    let shiftL = 0;
    for (let i = 0; i < gracenote_groups.length; ++i) {
      const gracenote_group = gracenote_groups[i];
      const note = gracenote_group.getNote();
      const is_stavenote = isStaveNote(note);
      const spacing = is_stavenote ? group_spacing_stave : group_spacing_tab;
      if (is_stavenote && note !== prev_note) {
        for (let n = 0; n < note.keys.length; ++n) {
          shiftL = Math.max(note.getLeftDisplacedHeadPx(), shiftL);
        }
        prev_note = note;
      }
      group_list.push({ shift: shiftL, gracenote_group, spacing });
    }
    let group_shift = group_list[0].shift;
    let formatWidth;
    for (let i = 0; i < group_list.length; ++i) {
      const gracenote_group = group_list[i].gracenote_group;
      gracenote_group.preFormat();
      formatWidth = gracenote_group.getWidth() + group_list[i].spacing;
      group_shift = Math.max(formatWidth, group_shift);
    }
    for (let i = 0; i < group_list.length; ++i) {
      const gracenote_group = group_list[i].gracenote_group;
      formatWidth = gracenote_group.getWidth() + group_list[i].spacing;
      gracenote_group.setSpacingFromNextModifier(group_shift - Math.min(formatWidth, group_shift) + StaveNote.minNoteheadPadding);
    }
    state.left_shift += group_shift;
    return true;
  }
  constructor(grace_notes, show_slur) {
    super();
    this.preFormatted = false;
    this.position = Modifier.Position.LEFT;
    this.grace_notes = grace_notes;
    this.width = 0;
    this.show_slur = show_slur;
    this.slur = void 0;
    this.voice = new Voice({
      num_beats: 4,
      beat_value: 4,
      resolution: Tables.RESOLUTION
    }).setStrict(false);
    this.render_options = {
      slur_y_shift: 0
    };
    this.beams = [];
    this.voice.addTickables(this.grace_notes);
    return this;
  }
  preFormat() {
    if (this.preFormatted)
      return;
    if (!this.formatter) {
      this.formatter = new Formatter();
    }
    this.formatter.joinVoices([this.voice]).format([this.voice], 0, {});
    this.setWidth(this.formatter.getMinTotalWidth());
    this.preFormatted = true;
  }
  beamNotes(grace_notes) {
    grace_notes = grace_notes || this.grace_notes;
    if (grace_notes.length > 1) {
      const beam = new Beam(grace_notes);
      beam.render_options.beam_width = 3;
      beam.render_options.partial_beam_length = 4;
      this.beams.push(beam);
    }
    return this;
  }
  setWidth(width) {
    this.width = width;
    return this;
  }
  getWidth() {
    return this.width + StaveNote.minNoteheadPadding;
  }
  getGraceNotes() {
    return this.grace_notes;
  }
  draw() {
    const ctx = this.checkContext();
    const note = this.checkAttachedNote();
    this.setRendered();
    L14("Drawing grace note group for:", note);
    this.alignSubNotesWithNote(this.getGraceNotes(), note);
    this.grace_notes.forEach((graceNote) => graceNote.setContext(ctx).draw());
    this.beams.forEach((beam) => beam.setContext(ctx).draw());
    if (this.show_slur) {
      const is_stavenote = isStaveNote(note);
      const TieClass = is_stavenote ? StaveTie : TabTie;
      this.slur = new TieClass({
        last_note: this.grace_notes[0],
        first_note: note,
        first_indices: [0],
        last_indices: [0]
      });
      this.slur.render_options.cp2 = 12;
      this.slur.render_options.y_shift = (is_stavenote ? 7 : 5) + this.render_options.slur_y_shift;
      this.slur.setContext(ctx).draw();
    }
  }
};
GraceNoteGroup.DEBUG = false;

// node_modules/vexflow/build/esm/src/notesubgroup.js
var NoteSubGroup = class extends Modifier {
  static get CATEGORY() {
    return "NoteSubGroup";
  }
  static format(groups, state) {
    if (!groups || groups.length === 0)
      return false;
    let width = 0;
    for (let i = 0; i < groups.length; ++i) {
      const group = groups[i];
      group.preFormat();
      width += group.getWidth();
    }
    state.left_shift += width;
    return true;
  }
  constructor(subNotes) {
    super();
    this.preFormatted = false;
    this.position = Modifier.Position.LEFT;
    this.subNotes = subNotes;
    this.subNotes.forEach((subNote) => {
      subNote.setIgnoreTicks(false);
    });
    this.width = 0;
    this.formatter = new Formatter();
    this.voice = new Voice({
      num_beats: 4,
      beat_value: 4,
      resolution: Tables.RESOLUTION
    }).setStrict(false);
    this.voice.addTickables(this.subNotes);
  }
  preFormat() {
    if (this.preFormatted)
      return;
    this.formatter.joinVoices([this.voice]).format([this.voice], 0);
    this.setWidth(this.formatter.getMinTotalWidth());
    this.preFormatted = true;
  }
  setWidth(width) {
    this.width = width;
    return this;
  }
  getWidth() {
    return this.width;
  }
  draw() {
    const ctx = this.checkContext();
    const note = this.checkAttachedNote();
    this.setRendered();
    this.alignSubNotesWithNote(this.subNotes, note);
    this.subNotes.forEach((subNote) => subNote.setContext(ctx).drawWithStyle());
  }
};

// node_modules/vexflow/build/esm/src/ornament.js
function L15(...args) {
  if (Ornament.DEBUG)
    log("Vex.Flow.Ornament", args);
}
var Ornament = class _Ornament extends Modifier {
  static get CATEGORY() {
    return "Ornament";
  }
  static get minPadding() {
    const musicFont = Tables.currentMusicFont();
    return musicFont.lookupMetric("noteHead.minPadding");
  }
  static format(ornaments2, state) {
    if (!ornaments2 || ornaments2.length === 0)
      return false;
    let width = 0;
    let right_shift = state.right_shift;
    let left_shift = state.left_shift;
    let yOffset = 0;
    for (let i = 0; i < ornaments2.length; ++i) {
      const ornament = ornaments2[i];
      const increment = 2;
      if (_Ornament.ornamentRelease.indexOf(ornament.type) >= 0) {
        ornament.x_shift += right_shift + 2;
      }
      if (_Ornament.ornamentAttack.indexOf(ornament.type) >= 0) {
        ornament.x_shift -= left_shift + 2;
      }
      if (ornament.reportedWidth && ornament.x_shift < 0) {
        left_shift += ornament.reportedWidth;
      } else if (ornament.reportedWidth && ornament.x_shift >= 0) {
        right_shift += ornament.reportedWidth + _Ornament.minPadding;
      } else {
        width = Math.max(ornament.getWidth(), width);
      }
      if (_Ornament.ornamentArticulation.indexOf(ornament.type) >= 0) {
        const ornamentNote = defined(ornament.note, "NoAttachedNote");
        if (ornamentNote.getLineNumber() >= 3 || ornament.getPosition() === Modifier.Position.ABOVE) {
          state.top_text_line += increment;
          ornament.y_shift += yOffset;
          yOffset -= ornament.glyph.bbox.getH();
        } else {
          state.text_line += increment;
          ornament.y_shift += yOffset;
          yOffset += ornament.glyph.bbox.getH();
        }
      } else {
        if (ornament.getPosition() === Modifier.Position.ABOVE) {
          ornament.setTextLine(state.top_text_line);
          state.top_text_line += increment;
        } else {
          ornament.setTextLine(state.text_line);
          state.text_line += increment;
        }
      }
    }
    state.left_shift = left_shift + width / 2;
    state.right_shift = right_shift + width / 2;
    return true;
  }
  static get ornamentNoteTransition() {
    return ["flip", "jazzTurn", "smear"];
  }
  static get ornamentAttack() {
    return ["scoop"];
  }
  static get ornamentAlignWithNoteHead() {
    return ["doit", "fall", "fallLong", "doitLong", "bend", "plungerClosed", "plungerOpen", "scoop"];
  }
  static get ornamentRelease() {
    return ["doit", "fall", "fallLong", "doitLong", "jazzTurn", "smear", "flip"];
  }
  static get ornamentArticulation() {
    return ["bend", "plungerClosed", "plungerOpen"];
  }
  getMetrics() {
    const ornamentMetrics = Tables.currentMusicFont().getMetrics().ornament;
    if (!ornamentMetrics)
      throw new RuntimeError("BadMetrics", `ornament missing`);
    return ornamentMetrics[this.ornament.code];
  }
  constructor(type) {
    super();
    this.type = type;
    this.delayed = false;
    this.render_options = {
      font_scale: Tables.NOTATION_FONT_SCALE,
      accidentalLowerPadding: 3,
      accidentalUpperPadding: 3
    };
    this.ornament = Tables.ornamentCodes(this.type);
    const metrics = this.getMetrics();
    this.adjustForStemDirection = false;
    this.reportedWidth = metrics && metrics.reportedWidth ? metrics.reportedWidth : 0;
    this.stemUpYOffset = metrics && metrics.stemUpYOffset ? metrics.stemUpYOffset : 0;
    this.ornamentAlignWithNoteHead = _Ornament.ornamentAlignWithNoteHead.indexOf(this.type) >= 0;
    if (!this.ornament) {
      throw new RuntimeError("ArgumentError", `Ornament not found: '${this.type}'`);
    }
    this.x_shift = metrics ? metrics.xOffset : 0;
    this.y_shift = metrics ? metrics.yOffset : 0;
    this.glyph = new Glyph(this.ornament.code, this.render_options.font_scale, {
      category: `ornament.${this.ornament.code}`
    });
    if (_Ornament.ornamentNoteTransition.indexOf(this.type) >= 0) {
      this.delayed = true;
    }
    if (!metrics) {
      this.glyph.setOrigin(0.5, 1);
    }
  }
  setDelayed(delayed) {
    this.delayed = delayed;
    return this;
  }
  setUpperAccidental(accid) {
    const scale = this.render_options.font_scale / 1.3;
    this.accidentalUpper = new Glyph(Tables.accidentalCodes(accid).code, scale);
    this.accidentalUpper.setOrigin(0.5, 1);
    return this;
  }
  setLowerAccidental(accid) {
    const scale = this.render_options.font_scale / 1.3;
    this.accidentalLower = new Glyph(Tables.accidentalCodes(accid).code, scale);
    this.accidentalLower.setOrigin(0.5, 1);
    return this;
  }
  draw() {
    const ctx = this.checkContext();
    const note = this.checkAttachedNote();
    this.setRendered();
    const stemDir = note.getStemDirection();
    const stave = note.checkStave();
    this.applyStyle();
    ctx.openGroup("ornament", this.getAttribute("id"));
    const stemExtents = note.checkStem().getExtents();
    let y = stemDir === Stem.DOWN ? stemExtents.baseY : stemExtents.topY;
    if (isTabNote(note)) {
      if (note.hasStem()) {
        if (stemDir === Stem.DOWN) {
          y = stave.getYForTopText(this.text_line);
        }
      } else {
        y = stave.getYForTopText(this.text_line);
      }
    }
    const isPlacedOnNoteheadSide = stemDir === Stem.DOWN;
    const spacing = stave.getSpacingBetweenLines();
    let lineSpacing = 1;
    if (!isPlacedOnNoteheadSide && note.hasBeam()) {
      lineSpacing += 0.5;
    }
    const totalSpacing = spacing * (this.text_line + lineSpacing);
    const glyphYBetweenLines = y - totalSpacing;
    const start = note.getModifierStartXY(this.position, this.index);
    let glyphX = start.x;
    let glyphY = this.ornamentAlignWithNoteHead ? start.y : Math.min(stave.getYForTopText(this.text_line), glyphYBetweenLines);
    glyphY += this.y_shift;
    if (this.delayed) {
      let delayXShift = 0;
      const startX = glyphX - (stave.getX() - 10);
      if (this.delayXShift !== void 0) {
        delayXShift = this.delayXShift;
      } else {
        delayXShift += this.glyph.getMetrics().width / 2;
        const nextContext = TickContext.getNextContext(note.getTickContext());
        if (nextContext) {
          delayXShift += (nextContext.getX() - startX) * 0.5;
        } else {
          delayXShift += (stave.getX() + stave.getWidth() - startX) * 0.5;
        }
        this.delayXShift = delayXShift;
      }
      glyphX += delayXShift;
    }
    L15("Rendering ornament: ", this.ornament, glyphX, glyphY);
    if (this.accidentalLower) {
      this.accidentalLower.render(ctx, glyphX, glyphY);
      glyphY -= this.accidentalLower.getMetrics().height;
      glyphY -= this.render_options.accidentalLowerPadding;
    }
    if (this.stemUpYOffset && note.hasStem() && note.getStemDirection() === 1) {
      glyphY += this.stemUpYOffset;
    }
    if (note.getLineNumber() < 5 && _Ornament.ornamentNoteTransition.indexOf(this.type) >= 0) {
      glyphY = note.checkStave().getBoundingBox().getY() + 40;
    }
    this.glyph.render(ctx, glyphX + this.x_shift, glyphY);
    if (this.accidentalUpper) {
      glyphY -= this.glyph.getMetrics().height + this.render_options.accidentalUpperPadding;
      this.accidentalUpper.render(ctx, glyphX, glyphY);
    }
    ctx.closeGroup();
    this.restoreStyle();
  }
};
Ornament.DEBUG = false;

// node_modules/vexflow/build/esm/src/parenthesis.js
var Parenthesis = class _Parenthesis extends Modifier {
  static get CATEGORY() {
    return "Parenthesis";
  }
  static buildAndAttach(notes) {
    for (const note of notes) {
      for (let i = 0; i < note.keys.length; i++) {
        note.addModifier(new _Parenthesis(ModifierPosition.LEFT), i);
        note.addModifier(new _Parenthesis(ModifierPosition.RIGHT), i);
      }
    }
  }
  static format(parentheses, state) {
    if (!parentheses || parentheses.length === 0)
      return false;
    let x_widthL = 0;
    let x_widthR = 0;
    for (let i = 0; i < parentheses.length; ++i) {
      const parenthesis = parentheses[i];
      const note = parenthesis.getNote();
      const pos = parenthesis.getPosition();
      const index = parenthesis.checkIndex();
      let shift = 0;
      if (pos === ModifierPosition.RIGHT) {
        shift = note.getRightParenthesisPx(index);
        x_widthR = x_widthR > shift + parenthesis.width ? x_widthR : shift + parenthesis.width;
      }
      if (pos === ModifierPosition.LEFT) {
        shift = note.getLeftParenthesisPx(index);
        x_widthL = x_widthL > shift + parenthesis.width ? x_widthL : shift + parenthesis.width;
      }
      parenthesis.setXShift(shift);
    }
    state.left_shift += x_widthL;
    state.right_shift += x_widthR;
    return true;
  }
  constructor(position) {
    var _a;
    super();
    this.position = position !== null && position !== void 0 ? position : Modifier.Position.LEFT;
    this.point = (_a = Tables.currentMusicFont().lookupMetric("parenthesis.default.point")) !== null && _a !== void 0 ? _a : Note.getPoint("default");
    this.setWidth(Tables.currentMusicFont().lookupMetric("parenthesis.default.width"));
  }
  setNote(note) {
    var _a, _b;
    this.note = note;
    this.point = (_a = Tables.currentMusicFont().lookupMetric("parenthesis.default.point")) !== null && _a !== void 0 ? _a : Note.getPoint("default");
    this.setWidth(Tables.currentMusicFont().lookupMetric("parenthesis.default.width"));
    if (isGraceNote(note)) {
      this.point = (_b = Tables.currentMusicFont().lookupMetric("parenthesis.gracenote.point")) !== null && _b !== void 0 ? _b : Note.getPoint("gracenote");
      this.setWidth(Tables.currentMusicFont().lookupMetric("parenthesis.gracenote.width"));
    }
    return this;
  }
  draw() {
    const ctx = this.checkContext();
    const note = this.checkAttachedNote();
    this.setRendered();
    const start = note.getModifierStartXY(this.position, this.index, { forceFlagRight: true });
    const x = start.x + this.x_shift;
    const y = start.y + this.y_shift;
    if (this.position == Modifier.Position.RIGHT) {
      Glyph.renderGlyph(ctx, x + 1, y, this.point, "noteheadParenthesisRight", {
        category: `noteHead.standard.noteheadParenthesisRight`
      });
    } else if (this.position == Modifier.Position.LEFT) {
      Glyph.renderGlyph(ctx, x - 2, y, this.point, "noteheadParenthesisLeft", {
        category: `noteHead.standard.noteheadParenthesisLeft`
      });
    }
  }
};

// node_modules/vexflow/build/esm/src/svgcontext.js
var ATTRIBUTES_TO_IGNORE = {
  path: {
    x: true,
    y: true,
    width: true,
    height: true,
    "font-family": true,
    "font-weight": true,
    "font-style": true,
    "font-size": true
  },
  rect: {
    "font-family": true,
    "font-weight": true,
    "font-style": true,
    "font-size": true
  },
  text: {
    width: true,
    height: true
  }
};
var SVG_NS = "http://www.w3.org/2000/svg";
var TWO_PI = 2 * Math.PI;
var MeasureTextCache = class {
  constructor() {
    this.cache = {};
  }
  lookup(text, svg, attributes) {
    let entries = this.cache[text];
    if (entries === void 0) {
      entries = {};
      this.cache[text] = entries;
    }
    const family = attributes["font-family"];
    const size = attributes["font-size"];
    const weight = attributes["font-weight"];
    const style = attributes["font-style"];
    const key = `${family}%${size}%${weight}%${style}`;
    let entry = entries[key];
    if (entry === void 0) {
      entry = this.measureImpl(text, svg, attributes);
      entries[key] = entry;
    }
    return entry;
  }
  measureImpl(text, svg, attributes) {
    let txt = this.txt;
    if (!txt) {
      txt = document.createElementNS(SVG_NS, "text");
      this.txt = txt;
    }
    txt.textContent = text;
    if (attributes["font-family"])
      txt.setAttributeNS(null, "font-family", attributes["font-family"]);
    if (attributes["font-size"])
      txt.setAttributeNS(null, "font-size", `${attributes["font-size"]}`);
    if (attributes["font-style"])
      txt.setAttributeNS(null, "font-style", attributes["font-style"]);
    if (attributes["font-weight"])
      txt.setAttributeNS(null, "font-weight", `${attributes["font-weight"]}`);
    svg.appendChild(txt);
    const bbox = txt.getBBox();
    svg.removeChild(txt);
    return { x: bbox.x, y: bbox.y, width: bbox.width, height: bbox.height };
  }
};
var SVGContext = class _SVGContext extends RenderContext {
  constructor(element) {
    super();
    this.width = 0;
    this.height = 0;
    this.precision = 1;
    this.backgroundFillStyle = "white";
    this.fontCSSString = "";
    this.element = element;
    this.precision = Math.pow(10, Tables.RENDER_PRECISION_PLACES);
    const svg = this.create("svg");
    this.element.appendChild(svg);
    this.svg = svg;
    this.parent = this.svg;
    this.groups = [this.svg];
    this.path = "";
    this.pen = { x: NaN, y: NaN };
    this.lineWidth = 1;
    const defaultFontAttributes = {
      "font-family": Font.SANS_SERIF,
      "font-size": Font.SIZE + "pt",
      "font-weight": FontWeight.NORMAL,
      "font-style": FontStyle.NORMAL
    };
    this.state = Object.assign({ scaleX: 1, scaleY: 1 }, defaultFontAttributes);
    this.attributes = Object.assign({ "stroke-width": 0.3, "stroke-dasharray": "none", fill: "black", stroke: "black" }, defaultFontAttributes);
    this.groupAttributes = [];
    this.applyAttributes(svg, this.attributes);
    this.groupAttributes.push(Object.assign({}, this.attributes));
    this.shadow_attributes = {
      width: 0,
      color: "black"
    };
    this.state_stack = [];
  }
  round(n) {
    return Math.round(n * this.precision) / this.precision;
  }
  create(svgElementType) {
    return document.createElementNS(SVG_NS, svgElementType);
  }
  openGroup(cls, id, attrs) {
    const group = this.create("g");
    this.groups.push(group);
    this.parent.appendChild(group);
    this.parent = group;
    if (cls)
      group.setAttribute("class", prefix(cls));
    if (id)
      group.setAttribute("id", prefix(id));
    if (attrs && attrs.pointerBBox) {
      group.setAttribute("pointer-events", "bounding-box");
    }
    this.applyAttributes(group, this.attributes);
    this.groupAttributes.push(Object.assign(Object.assign({}, this.groupAttributes[this.groupAttributes.length - 1]), this.attributes));
    return group;
  }
  closeGroup() {
    this.groups.pop();
    this.groupAttributes.pop();
    this.parent = this.groups[this.groups.length - 1];
  }
  add(elem) {
    this.parent.appendChild(elem);
  }
  setFillStyle(style) {
    this.attributes.fill = style;
    return this;
  }
  setBackgroundFillStyle(style) {
    this.backgroundFillStyle = style;
    return this;
  }
  setStrokeStyle(style) {
    this.attributes.stroke = style;
    return this;
  }
  setShadowColor(color) {
    this.shadow_attributes.color = color;
    return this;
  }
  setShadowBlur(blur) {
    this.shadow_attributes.width = blur;
    return this;
  }
  setLineWidth(width) {
    this.attributes["stroke-width"] = width;
    this.lineWidth = width;
    return this;
  }
  setLineDash(lineDash) {
    if (Object.prototype.toString.call(lineDash) === "[object Array]") {
      this.attributes["stroke-dasharray"] = lineDash.join(",");
      return this;
    } else {
      throw new RuntimeError("ArgumentError", "lineDash must be an array of integers.");
    }
  }
  setLineCap(capType) {
    this.attributes["stroke-linecap"] = capType;
    return this;
  }
  resize(width, height) {
    this.width = width;
    this.height = height;
    this.element.style.width = width.toString();
    this.svg.style.width = width.toString();
    this.svg.style.height = height.toString();
    const attributes = {
      width,
      height
    };
    this.applyAttributes(this.svg, attributes);
    this.scale(this.state.scaleX, this.state.scaleY);
    return this;
  }
  scale(x, y) {
    this.state.scaleX = this.state.scaleX ? this.state.scaleX * x : x;
    this.state.scaleY = this.state.scaleY ? this.state.scaleY * y : y;
    const visibleWidth = this.width / this.state.scaleX;
    const visibleHeight = this.height / this.state.scaleY;
    this.setViewBox(0, 0, visibleWidth, visibleHeight);
    return this;
  }
  setViewBox(viewBox_or_minX, minY, width, height) {
    if (typeof viewBox_or_minX === "string") {
      this.svg.setAttribute("viewBox", viewBox_or_minX);
    } else {
      const viewBoxString = viewBox_or_minX + " " + minY + " " + width + " " + height;
      this.svg.setAttribute("viewBox", viewBoxString);
    }
  }
  applyAttributes(element, attributes) {
    const attrNamesToIgnore = ATTRIBUTES_TO_IGNORE[element.nodeName];
    for (const attrName in attributes) {
      if (attrNamesToIgnore && attrNamesToIgnore[attrName]) {
        continue;
      }
      if (attributes[attrName] && (this.groupAttributes.length == 0 || attributes[attrName] != this.groupAttributes[this.groupAttributes.length - 1][attrName]))
        element.setAttributeNS(null, attrName, attributes[attrName]);
    }
    return element;
  }
  clear() {
    while (this.svg.lastChild) {
      this.svg.removeChild(this.svg.lastChild);
    }
    this.scale(this.state.scaleX, this.state.scaleY);
  }
  rect(x, y, width, height, attributes) {
    if (height < 0) {
      y += height;
      height *= -1;
    }
    const rectangle = this.create("rect");
    attributes = attributes !== null && attributes !== void 0 ? attributes : { fill: "none", "stroke-width": this.lineWidth, stroke: "black" };
    x = this.round(x);
    y = this.round(y);
    width = this.round(width);
    height = this.round(height);
    this.applyAttributes(rectangle, Object.assign({ x, y, width, height }, attributes));
    this.add(rectangle);
    return this;
  }
  fillRect(x, y, width, height) {
    const attributes = { fill: this.attributes.fill, stroke: "none" };
    this.rect(x, y, width, height, attributes);
    return this;
  }
  clearRect(x, y, width, height) {
    this.rect(x, y, width, height, { fill: this.backgroundFillStyle, stroke: "none" });
    return this;
  }
  beginPath() {
    this.path = "";
    this.pen.x = NaN;
    this.pen.y = NaN;
    return this;
  }
  moveTo(x, y) {
    x = this.round(x);
    y = this.round(y);
    this.path += "M" + x + " " + y;
    this.pen.x = x;
    this.pen.y = y;
    return this;
  }
  lineTo(x, y) {
    x = this.round(x);
    y = this.round(y);
    this.path += "L" + x + " " + y;
    this.pen.x = x;
    this.pen.y = y;
    return this;
  }
  bezierCurveTo(x1, y1, x2, y2, x, y) {
    x = this.round(x);
    y = this.round(y);
    x1 = this.round(x1);
    y1 = this.round(y1);
    x2 = this.round(x2);
    y2 = this.round(y2);
    this.path += "C" + x1 + " " + y1 + "," + x2 + " " + y2 + "," + x + " " + y;
    this.pen.x = x;
    this.pen.y = y;
    return this;
  }
  quadraticCurveTo(x1, y1, x, y) {
    x = this.round(x);
    y = this.round(y);
    x1 = this.round(x1);
    y1 = this.round(y1);
    this.path += "Q" + x1 + " " + y1 + "," + x + " " + y;
    this.pen.x = x;
    this.pen.y = y;
    return this;
  }
  arc(x, y, radius, startAngle, endAngle, counterclockwise) {
    let x0 = x + radius * Math.cos(startAngle);
    let y0 = y + radius * Math.sin(startAngle);
    x0 = this.round(x0);
    y0 = this.round(y0);
    const tmpStartTest = normalizeAngle(startAngle);
    const tmpEndTest = normalizeAngle(endAngle);
    if (!counterclockwise && endAngle - startAngle >= TWO_PI || counterclockwise && startAngle - endAngle >= TWO_PI || tmpStartTest === tmpEndTest) {
      let x1 = x + radius * Math.cos(startAngle + Math.PI);
      let y1 = y + radius * Math.sin(startAngle + Math.PI);
      x1 = this.round(x1);
      y1 = this.round(y1);
      radius = this.round(radius);
      this.path += `M${x0} ${y0} A${radius} ${radius} 0 0 0 ${x1} ${y1} `;
      this.path += `A${radius} ${radius} 0 0 0 ${x0} ${y0}`;
      this.pen.x = x0;
      this.pen.y = y0;
    } else {
      let x1 = x + radius * Math.cos(endAngle);
      let y1 = y + radius * Math.sin(endAngle);
      startAngle = tmpStartTest;
      endAngle = tmpEndTest;
      let large;
      if (Math.abs(endAngle - startAngle) < Math.PI) {
        large = counterclockwise;
      } else {
        large = !counterclockwise;
      }
      if (startAngle > endAngle) {
        large = !large;
      }
      const sweep = !counterclockwise;
      x1 = this.round(x1);
      y1 = this.round(y1);
      radius = this.round(radius);
      this.path += `M${x0} ${y0} A${radius} ${radius} 0 ${+large} ${+sweep} ${x1} ${y1}`;
      this.pen.x = x1;
      this.pen.y = y1;
    }
    return this;
  }
  closePath() {
    this.path += "Z";
    return this;
  }
  getShadowStyle() {
    const sa = this.shadow_attributes;
    return `filter: drop-shadow(0 0 ${sa.width / 1.5}px ${sa.color})`;
  }
  fill(attributes) {
    const path = this.create("path");
    if (typeof attributes === "undefined") {
      attributes = Object.assign(Object.assign({}, this.attributes), { stroke: "none" });
    }
    attributes.d = this.path;
    if (this.shadow_attributes.width > 0) {
      attributes.style = this.getShadowStyle();
    }
    this.applyAttributes(path, attributes);
    this.add(path);
    return this;
  }
  stroke() {
    const path = this.create("path");
    const attributes = Object.assign(Object.assign({}, this.attributes), { fill: "none", "stroke-width": this.lineWidth, d: this.path });
    if (this.shadow_attributes.width > 0) {
      attributes.style = this.getShadowStyle();
    }
    this.applyAttributes(path, attributes);
    this.add(path);
    return this;
  }
  measureText(text) {
    return _SVGContext.measureTextCache.lookup(text, this.svg, this.attributes);
  }
  fillText(text, x, y) {
    if (!text || text.length <= 0) {
      return this;
    }
    x = this.round(x);
    y = this.round(y);
    const attributes = Object.assign(Object.assign({}, this.attributes), {
      stroke: "none",
      x,
      y
    });
    const txt = this.create("text");
    txt.textContent = text;
    this.applyAttributes(txt, attributes);
    this.add(txt);
    return this;
  }
  save() {
    this.state_stack.push({
      state: {
        "font-family": this.state["font-family"],
        "font-weight": this.state["font-weight"],
        "font-style": this.state["font-style"],
        "font-size": this.state["font-size"],
        scale: this.state.scale
      },
      attributes: {
        "font-family": this.attributes["font-family"],
        "font-weight": this.attributes["font-weight"],
        "font-style": this.attributes["font-style"],
        "font-size": this.attributes["font-size"],
        fill: this.attributes.fill,
        stroke: this.attributes.stroke,
        "stroke-width": this.attributes["stroke-width"],
        "stroke-dasharray": this.attributes["stroke-dasharray"]
      },
      shadow_attributes: {
        width: this.shadow_attributes.width,
        color: this.shadow_attributes.color
      },
      lineWidth: this.lineWidth
    });
    return this;
  }
  restore() {
    const savedState = this.state_stack.pop();
    if (savedState) {
      const state = savedState;
      this.state["font-family"] = state.state["font-family"];
      this.state["font-weight"] = state.state["font-weight"];
      this.state["font-style"] = state.state["font-style"];
      this.state["font-size"] = state.state["font-size"];
      this.state.scale = state.state.scale;
      this.attributes["font-family"] = state.attributes["font-family"];
      this.attributes["font-weight"] = state.attributes["font-weight"];
      this.attributes["font-style"] = state.attributes["font-style"];
      this.attributes["font-size"] = state.attributes["font-size"];
      this.attributes.fill = state.attributes.fill;
      this.attributes.stroke = state.attributes.stroke;
      this.attributes["stroke-width"] = state.attributes["stroke-width"];
      this.attributes["stroke-dasharray"] = state.attributes["stroke-dasharray"];
      this.shadow_attributes.width = state.shadow_attributes.width;
      this.shadow_attributes.color = state.shadow_attributes.color;
      this.lineWidth = state.lineWidth;
    }
    return this;
  }
  set fillStyle(style) {
    this.setFillStyle(style);
  }
  get fillStyle() {
    return this.attributes.fill;
  }
  set strokeStyle(style) {
    this.setStrokeStyle(style);
  }
  get strokeStyle() {
    return this.attributes.stroke;
  }
  setFont(f, size, weight, style) {
    const fontInfo = Font.validate(f, size, weight, style);
    this.fontCSSString = Font.toCSSString(fontInfo);
    const fontAttributes = {
      "font-family": fontInfo.family,
      "font-size": fontInfo.size,
      "font-weight": fontInfo.weight,
      "font-style": fontInfo.style
    };
    this.attributes = Object.assign(Object.assign({}, this.attributes), fontAttributes);
    this.state = Object.assign(Object.assign({}, this.state), fontAttributes);
    return this;
  }
  getFont() {
    return this.fontCSSString;
  }
};
SVGContext.measureTextCache = new MeasureTextCache();

// node_modules/vexflow/build/esm/src/renderer.js
var RendererBackends;
(function(RendererBackends2) {
  RendererBackends2[RendererBackends2["CANVAS"] = 1] = "CANVAS";
  RendererBackends2[RendererBackends2["SVG"] = 2] = "SVG";
})(RendererBackends || (RendererBackends = {}));
var RendererLineEndType;
(function(RendererLineEndType2) {
  RendererLineEndType2[RendererLineEndType2["NONE"] = 1] = "NONE";
  RendererLineEndType2[RendererLineEndType2["UP"] = 2] = "UP";
  RendererLineEndType2[RendererLineEndType2["DOWN"] = 3] = "DOWN";
})(RendererLineEndType || (RendererLineEndType = {}));
var Renderer = class _Renderer {
  static buildContext(elementId, backend, width, height, background = "#FFF") {
    const renderer = new _Renderer(elementId, backend);
    if (width && height) {
      renderer.resize(width, height);
    }
    const ctx = renderer.getContext();
    ctx.setBackgroundFillStyle(background);
    _Renderer.lastContext = ctx;
    return ctx;
  }
  static getCanvasContext(elementId, width, height, background) {
    return _Renderer.buildContext(elementId, _Renderer.Backends.CANVAS, width, height, background);
  }
  static getSVGContext(elementId, width, height, background) {
    return _Renderer.buildContext(elementId, _Renderer.Backends.SVG, width, height, background);
  }
  static drawDashedLine(context, fromX, fromY, toX, toY, dashPattern) {
    context.beginPath();
    const dx = toX - fromX;
    const dy = toY - fromY;
    const angle = Math.atan2(dy, dx);
    let x = fromX;
    let y = fromY;
    context.moveTo(fromX, fromY);
    let idx = 0;
    let draw = true;
    while (!((dx < 0 ? x <= toX : x >= toX) && (dy < 0 ? y <= toY : y >= toY))) {
      const dashLength = dashPattern[idx++ % dashPattern.length];
      const nx = x + Math.cos(angle) * dashLength;
      x = dx < 0 ? Math.max(toX, nx) : Math.min(toX, nx);
      const ny = y + Math.sin(angle) * dashLength;
      y = dy < 0 ? Math.max(toY, ny) : Math.min(toY, ny);
      if (draw) {
        context.lineTo(x, y);
      } else {
        context.moveTo(x, y);
      }
      draw = !draw;
    }
    context.closePath();
    context.stroke();
  }
  constructor(arg0, arg1) {
    if (isRenderContext(arg0)) {
      this.ctx = arg0;
    } else {
      if (arg1 === void 0) {
        throw new RuntimeError("InvalidArgument", "Missing backend argument");
      }
      const backend = arg1;
      let element;
      if (typeof arg0 == "string") {
        const maybeElement = document.getElementById(arg0);
        if (!maybeElement) {
          throw new RuntimeError("BadElementId", `Can't find element with ID "${maybeElement}"`);
        }
        element = maybeElement;
      } else {
        element = arg0;
      }
      if (backend === _Renderer.Backends.CANVAS) {
        if (!isHTMLCanvas(element)) {
          throw new RuntimeError("BadElement", "CANVAS context requires an HTMLCanvasElement.");
        }
        const context = element.getContext("2d", { willReadFrequently: true });
        if (!context) {
          throw new RuntimeError("BadElement", "Can't get canvas context");
        }
        this.ctx = new CanvasContext(context);
      } else if (backend === _Renderer.Backends.SVG) {
        if (!isHTMLDiv(element)) {
          throw new RuntimeError("BadElement", "SVG context requires an HTMLDivElement.");
        }
        this.ctx = new SVGContext(element);
      } else {
        throw new RuntimeError("InvalidBackend", `No support for backend: ${backend}`);
      }
    }
  }
  resize(width, height) {
    this.ctx.resize(width, height);
    return this;
  }
  getContext() {
    return this.ctx;
  }
};
Renderer.Backends = RendererBackends;
Renderer.LineEndType = RendererLineEndType;
Renderer.lastContext = void 0;

// node_modules/vexflow/build/esm/src/stringnumber.js
var StringNumber = class _StringNumber extends Modifier {
  static get CATEGORY() {
    return "StringNumber";
  }
  static get metrics() {
    var _a;
    return (_a = Tables.currentMusicFont().getMetrics().stringNumber) !== null && _a !== void 0 ? _a : {
      verticalPadding: 0,
      stemPadding: 0,
      leftPadding: 0,
      rightPadding: 0
    };
  }
  static format(nums, state) {
    const left_shift = state.left_shift;
    const right_shift = state.right_shift;
    const num_spacing = 1;
    if (!nums || nums.length === 0)
      return false;
    const nums_list = [];
    let prev_note = null;
    let extraXSpaceForDisplacedNotehead = 0;
    let shift_right = 0;
    const modLines = 0;
    for (let i = 0; i < nums.length; ++i) {
      const num = nums[i];
      const note = num.getNote();
      const pos = num.getPosition();
      if (!isStaveNote(note)) {
        throw new RuntimeError("NoStaveNote");
      }
      const index = num.checkIndex();
      const props = note.getKeyProps()[index];
      const mc = note.getModifierContext();
      const verticalSpaceNeeded = num.radius * 2 / Tables.STAVE_LINE_DISTANCE + 0.5;
      if (mc) {
        if (pos === ModifierPosition.ABOVE) {
          num.text_line = mc.getState().top_text_line;
          state.top_text_line += verticalSpaceNeeded;
        } else if (pos === ModifierPosition.BELOW) {
          num.text_line = mc.getState().text_line;
          state.text_line += verticalSpaceNeeded;
        }
      }
      if (note !== prev_note) {
        for (let n = 0; n < note.keys.length; ++n) {
          if (pos === Modifier.Position.LEFT) {
            extraXSpaceForDisplacedNotehead = Math.max(note.getLeftDisplacedHeadPx(), extraXSpaceForDisplacedNotehead);
          }
          if (right_shift === 0) {
            shift_right = Math.max(note.getRightDisplacedHeadPx(), shift_right);
          }
        }
        prev_note = note;
      }
      const glyphLine = modLines === 0 ? props.line : modLines;
      nums_list.push({
        pos,
        note,
        num,
        line: glyphLine,
        shiftL: extraXSpaceForDisplacedNotehead,
        shiftR: shift_right
      });
    }
    nums_list.sort((a, b) => b.line - a.line);
    let num_shiftR = 0;
    let x_widthL = 0;
    let x_widthR = 0;
    let last_line = null;
    let last_note = null;
    for (let i = 0; i < nums_list.length; ++i) {
      const note = nums_list[i].note;
      const pos = nums_list[i].pos;
      const num = nums_list[i].num;
      const line = nums_list[i].line;
      const shiftR = nums_list[i].shiftR;
      if (line !== last_line || note !== last_note) {
        num_shiftR = right_shift + shiftR;
      }
      const num_width = num.getWidth() + num_spacing;
      let num_x_shift = 0;
      if (pos === Modifier.Position.LEFT) {
        num.setXShift(left_shift + extraXSpaceForDisplacedNotehead);
        num_x_shift = num_width;
        x_widthL = Math.max(num_x_shift, x_widthL);
      } else if (pos === Modifier.Position.RIGHT) {
        num.setXShift(num_shiftR);
        num_x_shift += num_width;
        x_widthR = num_x_shift > x_widthR ? num_x_shift : x_widthR;
      }
      last_line = line;
      last_note = note;
    }
    state.left_shift += x_widthL;
    state.right_shift += x_widthR;
    return true;
  }
  constructor(number) {
    super();
    this.string_number = number;
    this.position = Modifier.Position.ABOVE;
    this.x_shift = 0;
    this.y_shift = 0;
    this.text_line = 0;
    this.stem_offset = 0;
    this.x_offset = 0;
    this.y_offset = 0;
    this.dashed = true;
    this.leg = Renderer.LineEndType.NONE;
    this.radius = 8;
    this.drawCircle = true;
    this.setWidth(this.radius * 2 + 4);
    this.resetFont();
  }
  setLineEndType(leg) {
    if (leg >= Renderer.LineEndType.NONE && leg <= Renderer.LineEndType.DOWN) {
      this.leg = leg;
    }
    return this;
  }
  setStringNumber(number) {
    this.string_number = number;
    return this;
  }
  setOffsetX(x) {
    this.x_offset = x;
    return this;
  }
  setOffsetY(y) {
    this.y_offset = y;
    return this;
  }
  setLastNote(note) {
    this.last_note = note;
    return this;
  }
  setDashed(dashed) {
    this.dashed = dashed;
    return this;
  }
  setDrawCircle(drawCircle) {
    this.drawCircle = drawCircle;
    return this;
  }
  draw() {
    const ctx = this.checkContext();
    const note = this.checkAttachedNote();
    this.setRendered();
    const start = note.getModifierStartXY(this.position, this.index);
    const stemDirection = note.hasStem() ? note.getStemDirection() : Stem.UP;
    let dot_x = start.x + this.x_shift + this.x_offset;
    let stem_ext = {};
    if (note.hasStem()) {
      stem_ext = note.checkStem().getExtents();
    }
    let dot_y = start.y + this.y_shift + this.y_offset;
    switch (this.position) {
      case Modifier.Position.ABOVE:
        {
          const ys = note.getYs();
          dot_y = ys.reduce((a, b) => a < b ? a : b);
          if (note.hasStem() && stemDirection == Stem.UP) {
            dot_y = stem_ext.topY + _StringNumber.metrics.stemPadding;
          }
          dot_y -= this.radius + _StringNumber.metrics.verticalPadding + this.text_line * Tables.STAVE_LINE_DISTANCE;
        }
        break;
      case Modifier.Position.BELOW:
        {
          const ys = note.getYs();
          dot_y = ys.reduce((a, b) => a > b ? a : b);
          if (note.hasStem() && stemDirection == Stem.DOWN) {
            dot_y = stem_ext.topY - _StringNumber.metrics.stemPadding;
          }
          dot_y += this.radius + _StringNumber.metrics.verticalPadding + this.text_line * Tables.STAVE_LINE_DISTANCE;
        }
        break;
      case Modifier.Position.LEFT:
        dot_x -= this.radius / 2 + _StringNumber.metrics.leftPadding;
        break;
      case Modifier.Position.RIGHT:
        dot_x += this.radius / 2 + _StringNumber.metrics.rightPadding;
        break;
      default:
        throw new RuntimeError("InvalidPosition", `The position ${this.position} is invalid`);
    }
    ctx.save();
    if (this.drawCircle) {
      ctx.beginPath();
      ctx.arc(dot_x, dot_y, this.radius, 0, Math.PI * 2, false);
      ctx.setLineWidth(1.5);
      ctx.stroke();
    }
    ctx.setFont(this.textFont);
    const x = dot_x - ctx.measureText(this.string_number).width / 2;
    ctx.fillText("" + this.string_number, x, dot_y + 4.5);
    const lastNote = this.last_note;
    if (isStemmableNote(lastNote)) {
      const end = lastNote.getStemX() - note.getX() + 5;
      ctx.setStrokeStyle("#000000");
      ctx.setLineCap("round");
      ctx.setLineWidth(0.6);
      if (this.dashed) {
        Renderer.drawDashedLine(ctx, dot_x + 10, dot_y, dot_x + end, dot_y, [3, 3]);
      } else {
        Renderer.drawDashedLine(ctx, dot_x + 10, dot_y, dot_x + end, dot_y, [3, 0]);
      }
      let len;
      let pattern;
      switch (this.leg) {
        case Renderer.LineEndType.UP:
          len = -10;
          pattern = this.dashed ? [3, 3] : [3, 0];
          Renderer.drawDashedLine(ctx, dot_x + end, dot_y, dot_x + end, dot_y + len, pattern);
          break;
        case Renderer.LineEndType.DOWN:
          len = 10;
          pattern = this.dashed ? [3, 3] : [3, 0];
          Renderer.drawDashedLine(ctx, dot_x + end, dot_y, dot_x + end, dot_y + len, pattern);
          break;
        default:
          break;
      }
    }
    ctx.restore();
  }
};
StringNumber.TEXT_FONT = {
  family: Font.SANS_SERIF,
  size: Font.SIZE,
  weight: FontWeight.BOLD,
  style: FontStyle.NORMAL
};

// node_modules/vexflow/build/esm/src/strokes.js
var Stroke = class _Stroke extends Modifier {
  static get CATEGORY() {
    return "Stroke";
  }
  static format(strokes, state) {
    const left_shift = state.left_shift;
    const stroke_spacing = 0;
    if (!strokes || strokes.length === 0)
      return false;
    const strokeList = strokes.map((stroke) => {
      const note = stroke.getNote();
      const index = stroke.checkIndex();
      if (isStaveNote(note)) {
        const { line } = note.getKeyProps()[index];
        const shift = note.getLeftDisplacedHeadPx();
        return { line, shift, stroke };
      } else if (isTabNote(note)) {
        const { str: string } = note.getPositions()[index];
        return { line: string, shift: 0, stroke };
      } else {
        throw new RuntimeError("Internal", "Unexpected instance.");
      }
    });
    const strokeShift = left_shift;
    const xShift = strokeList.reduce((xShift2, { stroke, shift }) => {
      stroke.setXShift(strokeShift + shift);
      return Math.max(stroke.getWidth() + stroke_spacing, xShift2);
    }, 0);
    state.left_shift += xShift;
    return true;
  }
  constructor(type, options) {
    super();
    this.options = Object.assign({ all_voices: true }, options);
    this.all_voices = this.options.all_voices;
    this.type = type;
    this.position = Modifier.Position.LEFT;
    this.render_options = {
      font_scale: Tables.NOTATION_FONT_SCALE
    };
    this.resetFont();
    this.setXShift(0);
    this.setWidth(10);
  }
  getPosition() {
    return this.position;
  }
  addEndNote(note) {
    this.note_end = note;
    return this;
  }
  draw() {
    const ctx = this.checkContext();
    const note = this.checkAttachedNote();
    this.setRendered();
    const start = note.getModifierStartXY(this.position, this.index);
    let ys = note.getYs();
    let topY = start.y;
    let botY = start.y;
    const x = start.x - 5;
    const line_space = note.checkStave().getSpacingBetweenLines();
    const notes = this.checkModifierContext().getMembers(note.getCategory());
    for (let i = 0; i < notes.length; i++) {
      const note2 = notes[i];
      if (isNote(note2)) {
        ys = note2.getYs();
        for (let n = 0; n < ys.length; n++) {
          if (this.note === notes[i] || this.all_voices) {
            topY = Math.min(topY, ys[n]);
            botY = Math.max(botY, ys[n]);
          }
        }
      }
    }
    let arrow = "";
    let arrow_shift_x = 0;
    let arrow_y = 0;
    let text_shift_x = 0;
    let text_y = 0;
    switch (this.type) {
      case _Stroke.Type.BRUSH_DOWN:
        arrow = "arrowheadBlackUp";
        arrow_shift_x = -3;
        arrow_y = topY - line_space / 2 + 10;
        botY += line_space / 2;
        break;
      case _Stroke.Type.BRUSH_UP:
        arrow = "arrowheadBlackDown";
        arrow_shift_x = 0.5;
        arrow_y = botY + line_space / 2;
        topY -= line_space / 2;
        break;
      case _Stroke.Type.ROLL_DOWN:
      case _Stroke.Type.RASQUEDO_DOWN:
        arrow = "arrowheadBlackUp";
        arrow_shift_x = -3;
        text_shift_x = this.x_shift + arrow_shift_x - 2;
        if (isStaveNote(note)) {
          topY += 1.5 * line_space;
          if ((botY - topY) % 2 !== 0) {
            botY += 0.5 * line_space;
          } else {
            botY += line_space;
          }
          arrow_y = topY - line_space;
          text_y = botY + line_space + 2;
        } else {
          topY += 1.5 * line_space;
          botY += line_space;
          arrow_y = topY - 0.75 * line_space;
          text_y = botY + 0.25 * line_space;
        }
        break;
      case _Stroke.Type.ROLL_UP:
      case _Stroke.Type.RASQUEDO_UP:
        arrow = "arrowheadBlackDown";
        arrow_shift_x = -4;
        text_shift_x = this.x_shift + arrow_shift_x - 1;
        if (isStaveNote(note)) {
          arrow_y = line_space / 2;
          topY += 0.5 * line_space;
          if ((botY - topY) % 2 === 0) {
            botY += line_space / 2;
          }
          arrow_y = botY + 0.5 * line_space;
          text_y = topY - 1.25 * line_space;
        } else {
          topY += 0.25 * line_space;
          botY += 0.5 * line_space;
          arrow_y = botY + 0.25 * line_space;
          text_y = topY - line_space;
        }
        break;
      case _Stroke.Type.ARPEGGIO_DIRECTIONLESS:
        topY += 0.5 * line_space;
        botY += line_space;
        break;
      default:
        throw new RuntimeError("InvalidType", `The stroke type ${this.type} does not exist`);
    }
    let strokeLine = "straight";
    if (this.type === _Stroke.Type.BRUSH_DOWN || this.type === _Stroke.Type.BRUSH_UP) {
      ctx.fillRect(x + this.x_shift, topY, 1, botY - topY);
    } else {
      strokeLine = "wiggly";
      if (isStaveNote(note)) {
        for (let i = topY; i <= botY; i += line_space) {
          Glyph.renderGlyph(ctx, x + this.x_shift - 4, i, this.render_options.font_scale, "vexWiggleArpeggioUp");
        }
      } else {
        let i;
        for (i = topY; i <= botY; i += 10) {
          Glyph.renderGlyph(ctx, x + this.x_shift - 4, i, this.render_options.font_scale, "vexWiggleArpeggioUp");
        }
        if (this.type === _Stroke.Type.RASQUEDO_DOWN) {
          text_y = i + 0.25 * line_space;
        }
      }
    }
    if (this.type === _Stroke.Type.ARPEGGIO_DIRECTIONLESS) {
      return;
    }
    Glyph.renderGlyph(ctx, x + this.x_shift + arrow_shift_x, arrow_y, this.render_options.font_scale, arrow, {
      category: `stroke_${strokeLine}.${arrow}`
    });
    if (this.type === _Stroke.Type.RASQUEDO_DOWN || this.type === _Stroke.Type.RASQUEDO_UP) {
      ctx.save();
      ctx.setFont(this.textFont);
      ctx.fillText("R", x + text_shift_x, text_y);
      ctx.restore();
    }
  }
};
Stroke.Type = {
  BRUSH_DOWN: 1,
  BRUSH_UP: 2,
  ROLL_DOWN: 3,
  ROLL_UP: 4,
  RASQUEDO_DOWN: 5,
  RASQUEDO_UP: 6,
  ARPEGGIO_DIRECTIONLESS: 7
};
Stroke.TEXT_FONT = {
  family: Font.SERIF,
  size: Font.SIZE,
  weight: FontWeight.BOLD,
  style: FontStyle.ITALIC
};

// node_modules/vexflow/build/esm/src/vibrato.js
var Vibrato = class _Vibrato extends Modifier {
  static get CATEGORY() {
    return "Vibrato";
  }
  static format(vibratos, state, context) {
    if (!vibratos || vibratos.length === 0)
      return false;
    let text_line = state.top_text_line;
    let width = 0;
    let shift = state.right_shift - 7;
    const bends = context.getMembers(Bend.CATEGORY);
    if (bends && bends.length > 0) {
      const bendHeight = bends.map((bb) => bb.getTextHeight()).reduce((a, b) => a > b ? a : b) / Tables.STAVE_LINE_DISTANCE;
      text_line = text_line - (bendHeight + 1);
    } else {
      state.top_text_line += 1;
    }
    for (let i = 0; i < vibratos.length; ++i) {
      const vibrato = vibratos[i];
      vibrato.setXShift(shift);
      vibrato.setTextLine(text_line);
      width += vibrato.getWidth();
      shift += width;
    }
    state.right_shift += width;
    return true;
  }
  constructor() {
    super();
    this.position = Modifier.Position.RIGHT;
    this.render_options = {
      harsh: false,
      vibrato_width: 20,
      wave_height: 6,
      wave_width: 4,
      wave_girth: 2
    };
    this.setVibratoWidth(this.render_options.vibrato_width);
  }
  setHarsh(harsh) {
    this.render_options.harsh = harsh;
    return this;
  }
  setVibratoWidth(width) {
    this.render_options.vibrato_width = width;
    this.setWidth(width);
    return this;
  }
  draw() {
    const ctx = this.checkContext();
    const note = this.checkAttachedNote();
    this.setRendered();
    const start = note.getModifierStartXY(Modifier.Position.RIGHT, this.index);
    const vx = start.x + this.x_shift;
    const vy = note.getYForTopText(this.text_line) + 2;
    _Vibrato.renderVibrato(ctx, vx, vy, this.render_options);
  }
  static renderVibrato(ctx, x, y, opts) {
    const { harsh, vibrato_width, wave_width, wave_girth, wave_height } = opts;
    const num_waves = vibrato_width / wave_width;
    ctx.beginPath();
    let i;
    if (harsh) {
      ctx.moveTo(x, y + wave_girth + 1);
      for (i = 0; i < num_waves / 2; ++i) {
        ctx.lineTo(x + wave_width, y - wave_height / 2);
        x += wave_width;
        ctx.lineTo(x + wave_width, y + wave_height / 2);
        x += wave_width;
      }
      for (i = 0; i < num_waves / 2; ++i) {
        ctx.lineTo(x - wave_width, y - wave_height / 2 + wave_girth + 1);
        x -= wave_width;
        ctx.lineTo(x - wave_width, y + wave_height / 2 + wave_girth + 1);
        x -= wave_width;
      }
      ctx.fill();
    } else {
      ctx.moveTo(x, y + wave_girth);
      for (i = 0; i < num_waves / 2; ++i) {
        ctx.quadraticCurveTo(x + wave_width / 2, y - wave_height / 2, x + wave_width, y);
        x += wave_width;
        ctx.quadraticCurveTo(x + wave_width / 2, y + wave_height / 2, x + wave_width, y);
        x += wave_width;
      }
      for (i = 0; i < num_waves / 2; ++i) {
        ctx.quadraticCurveTo(x - wave_width / 2, y + wave_height / 2 + wave_girth, x - wave_width, y + wave_girth);
        x -= wave_width;
        ctx.quadraticCurveTo(x - wave_width / 2, y - wave_height / 2 + wave_girth, x - wave_width, y + wave_girth);
        x -= wave_width;
      }
      ctx.fill();
    }
  }
};

// node_modules/vexflow/build/esm/src/modifiercontext.js
function L16(...args) {
  if (ModifierContext.DEBUG)
    log("Vex.Flow.ModifierContext", args);
}
var ModifierContext = class {
  constructor() {
    this.state = {
      left_shift: 0,
      right_shift: 0,
      text_line: 0,
      top_text_line: 0
    };
    this.members = {};
    this.preFormatted = false;
    this.postFormatted = false;
    this.formatted = false;
    this.width = 0;
    this.spacing = 0;
  }
  addModifier(member) {
    L16("addModifier is deprecated, use addMember instead.");
    return this.addMember(member);
  }
  addMember(member) {
    const category = member.getCategory();
    if (!this.members[category]) {
      this.members[category] = [];
    }
    this.members[category].push(member);
    member.setModifierContext(this);
    this.preFormatted = false;
    return this;
  }
  getModifiers(category) {
    L16("getModifiers is deprecated, use getMembers instead.");
    return this.getMembers(category);
  }
  getMembers(category) {
    var _a;
    return (_a = this.members[category]) !== null && _a !== void 0 ? _a : [];
  }
  getWidth() {
    return this.width;
  }
  getLeftShift() {
    return this.state.left_shift;
  }
  getRightShift() {
    return this.state.right_shift;
  }
  getState() {
    return this.state;
  }
  getMetrics() {
    if (!this.formatted) {
      throw new RuntimeError("UnformattedMember", "Unformatted member has no metrics.");
    }
    return {
      width: this.state.left_shift + this.state.right_shift + this.spacing,
      spacing: this.spacing
    };
  }
  preFormat() {
    if (this.preFormatted)
      return;
    L16("Preformatting ModifierContext");
    const state = this.state;
    const members = this.members;
    StaveNote.format(members["StaveNote"], state);
    Parenthesis.format(members["Parenthesis"], state);
    Dot.format(members["Dot"], state);
    FretHandFinger.format(members["FretHandFinger"], state);
    Accidental.format(members["Accidental"], state);
    Stroke.format(members["Stroke"], state);
    GraceNoteGroup.format(members["GraceNoteGroup"], state);
    NoteSubGroup.format(members["NoteSubGroup"], state);
    StringNumber.format(members["StringNumber"], state);
    Articulation.format(members["Articulation"], state);
    Ornament.format(members["Ornament"], state);
    Annotation.format(members["Annotation"], state);
    ChordSymbol.format(members["ChordSymbol"], state);
    Bend.format(members["Bend"], state);
    Vibrato.format(members["Vibrato"], state, this);
    this.width = state.left_shift + state.right_shift;
    this.preFormatted = true;
  }
  postFormat() {
    if (this.postFormatted)
      return;
    L16("Postformatting ModifierContext");
    StaveNote.postFormat(this.getMembers("StaveNote"));
  }
};
ModifierContext.DEBUG = false;

// node_modules/vexflow/build/esm/src/keysignature.js
var KeySignature = class _KeySignature extends StaveModifier {
  static get CATEGORY() {
    return "KeySignature";
  }
  constructor(keySpec, cancelKeySpec, alterKeySpec) {
    super();
    this.accList = [];
    this.setKeySig(keySpec, cancelKeySpec, alterKeySpec);
    this.setPosition(StaveModifierPosition.BEGIN);
    this.glyphFontScale = Tables.NOTATION_FONT_SCALE;
    this.glyphs = [];
    this.xPositions = [];
    this.paddingForced = false;
  }
  convertToGlyph(acc, nextAcc) {
    const accGlyphData = Tables.accidentalCodes(acc.type);
    const glyph = new Glyph(accGlyphData.code, this.glyphFontScale);
    let extraWidth = 1;
    if (acc.type === "n" && nextAcc) {
      const spacing = _KeySignature.accidentalSpacing[nextAcc.type];
      if (spacing) {
        const isAbove = nextAcc.line >= acc.line;
        extraWidth = isAbove ? spacing.above : spacing.below;
      }
    }
    this.placeGlyphOnLine(glyph, this.checkStave(), acc.line);
    this.glyphs.push(glyph);
    const xPosition = this.xPositions[this.xPositions.length - 1];
    const glyphWidth = glyph.getMetrics().width + extraWidth;
    this.xPositions.push(xPosition + glyphWidth);
    this.width += glyphWidth;
  }
  cancelKey(spec) {
    this.formatted = false;
    this.cancelKeySpec = spec;
    return this;
  }
  convertToCancelAccList(spec) {
    const cancel_accList = Tables.keySignature(spec);
    const different_types = this.accList.length > 0 && cancel_accList.length > 0 && cancel_accList[0].type !== this.accList[0].type;
    const naturals = different_types ? cancel_accList.length : cancel_accList.length - this.accList.length;
    if (naturals < 1)
      return void 0;
    const cancelled = [];
    for (let i = 0; i < naturals; i++) {
      let index = i;
      if (!different_types) {
        index = cancel_accList.length - naturals + i;
      }
      const acc = cancel_accList[index];
      cancelled.push({ type: "n", line: acc.line });
    }
    this.accList = cancelled.concat(this.accList);
    return {
      accList: cancelled,
      type: cancel_accList[0].type
    };
  }
  addToStave(stave) {
    this.paddingForced = true;
    stave.addModifier(this);
    return this;
  }
  convertAccLines(clef, type, accList = this.accList) {
    let offset = 0;
    let customLines;
    switch (clef) {
      case "soprano":
        if (type === "#")
          customLines = [2.5, 0.5, 2, 0, 1.5, -0.5, 1];
        else
          offset = -1;
        break;
      case "mezzo-soprano":
        if (type === "b")
          customLines = [0, 2, 0.5, 2.5, 1, 3, 1.5];
        else
          offset = 1.5;
        break;
      case "alto":
        offset = 0.5;
        break;
      case "tenor":
        if (type === "#")
          customLines = [3, 1, 2.5, 0.5, 2, 0, 1.5];
        else
          offset = -0.5;
        break;
      case "baritone-f":
      case "baritone-c":
        if (type === "b")
          customLines = [0.5, 2.5, 1, 3, 1.5, 3.5, 2];
        else
          offset = 2;
        break;
      case "bass":
      case "french":
        offset = 1;
        break;
      default:
        break;
    }
    let i;
    if (typeof customLines !== "undefined") {
      for (i = 0; i < accList.length; ++i) {
        accList[i].line = customLines[i];
      }
    } else if (offset !== 0) {
      for (i = 0; i < accList.length; ++i) {
        accList[i].line += offset;
      }
    }
  }
  getPadding(index) {
    if (!this.formatted)
      this.format();
    return this.glyphs.length === 0 || !this.paddingForced && index < 2 ? 0 : this.padding;
  }
  getWidth() {
    if (!this.formatted)
      this.format();
    return this.width;
  }
  setKeySig(keySpec, cancelKeySpec, alterKeySpec) {
    this.formatted = false;
    this.keySpec = keySpec;
    this.cancelKeySpec = cancelKeySpec;
    this.alterKeySpec = alterKeySpec;
    return this;
  }
  alterKey(alterKeySpec) {
    this.formatted = false;
    this.alterKeySpec = alterKeySpec;
    return this;
  }
  convertToAlterAccList(alterKeySpec) {
    const max = Math.min(alterKeySpec.length, this.accList.length);
    for (let i = 0; i < max; ++i) {
      if (alterKeySpec[i]) {
        this.accList[i].type = alterKeySpec[i];
      }
    }
  }
  format() {
    const stave = this.checkStave();
    this.width = 0;
    this.glyphs = [];
    this.xPositions = [0];
    this.accList = Tables.keySignature(defined(this.keySpec));
    const accList = this.accList;
    const firstAccidentalType = accList.length > 0 ? accList[0].type : void 0;
    let cancelAccList;
    if (this.cancelKeySpec) {
      cancelAccList = this.convertToCancelAccList(this.cancelKeySpec);
    }
    if (this.alterKeySpec) {
      this.convertToAlterAccList(this.alterKeySpec);
    }
    if (this.accList.length > 0) {
      const clef = (this.position === StaveModifierPosition.END ? stave.getEndClef() : stave.getClef()) || stave.getClef();
      if (cancelAccList) {
        this.convertAccLines(clef, cancelAccList.type, cancelAccList.accList);
      }
      this.convertAccLines(clef, firstAccidentalType, accList);
      for (let i = 0; i < this.accList.length; ++i) {
        this.convertToGlyph(this.accList[i], this.accList[i + 1]);
      }
    }
    this.formatted = true;
  }
  getGlyphs() {
    if (!this.formatted)
      this.format();
    return this.glyphs;
  }
  draw() {
    const stave = this.checkStave();
    const ctx = stave.checkContext();
    if (!this.formatted)
      this.format();
    this.setRendered();
    this.applyStyle(ctx);
    ctx.openGroup("keysignature", this.getAttribute("id"));
    for (let i = 0; i < this.glyphs.length; i++) {
      const glyph = this.glyphs[i];
      const x = this.x + this.xPositions[i];
      glyph.setStave(stave);
      glyph.setContext(ctx);
      glyph.renderToStave(x);
    }
    ctx.closeGroup();
    this.restoreStyle(ctx);
  }
};
KeySignature.accidentalSpacing = {
  "#": {
    above: 6,
    below: 4
  },
  b: {
    above: 4,
    below: 7
  },
  n: {
    above: 4,
    below: 1
  },
  "##": {
    above: 6,
    below: 4
  },
  bb: {
    above: 4,
    below: 7
  },
  db: {
    above: 4,
    below: 7
  },
  d: {
    above: 4,
    below: 7
  },
  bbs: {
    above: 4,
    below: 7
  },
  "++": {
    above: 6,
    below: 4
  },
  "+": {
    above: 6,
    below: 4
  },
  "+-": {
    above: 6,
    below: 4
  },
  "++-": {
    above: 6,
    below: 4
  },
  bs: {
    above: 4,
    below: 10
  },
  bss: {
    above: 4,
    below: 10
  }
};

// node_modules/vexflow/build/esm/src/staverepetition.js
var Repetition = class _Repetition extends StaveModifier {
  static get CATEGORY() {
    return "Repetition";
  }
  constructor(type, x, y_shift) {
    super();
    this.symbol_type = type;
    this.x = x;
    this.x_shift = 0;
    this.y_shift = y_shift;
    this.resetFont();
  }
  setShiftX(x) {
    this.x_shift = x;
    return this;
  }
  setShiftY(y) {
    this.y_shift = y;
    return this;
  }
  draw(stave, x) {
    this.setRendered();
    switch (this.symbol_type) {
      case _Repetition.type.CODA_RIGHT:
        this.drawCodaFixed(stave, x + stave.getWidth());
        break;
      case _Repetition.type.CODA_LEFT:
        this.drawSymbolText(stave, x, "Coda", true);
        break;
      case _Repetition.type.SEGNO_LEFT:
        this.drawSignoFixed(stave, x);
        break;
      case _Repetition.type.SEGNO_RIGHT:
        this.drawSignoFixed(stave, x + stave.getWidth());
        break;
      case _Repetition.type.DC:
        this.drawSymbolText(stave, x, "D.C.", false);
        break;
      case _Repetition.type.DC_AL_CODA:
        this.drawSymbolText(stave, x, "D.C. al", true);
        break;
      case _Repetition.type.DC_AL_FINE:
        this.drawSymbolText(stave, x, "D.C. al Fine", false);
        break;
      case _Repetition.type.DS:
        this.drawSymbolText(stave, x, "D.S.", false);
        break;
      case _Repetition.type.DS_AL_CODA:
        this.drawSymbolText(stave, x, "D.S. al", true);
        break;
      case _Repetition.type.DS_AL_FINE:
        this.drawSymbolText(stave, x, "D.S. al Fine", false);
        break;
      case _Repetition.type.FINE:
        this.drawSymbolText(stave, x, "Fine", false);
        break;
      case _Repetition.type.TO_CODA:
        this.drawSymbolText(stave, x, "To", true);
        break;
      default:
        break;
    }
    return this;
  }
  drawCodaFixed(stave, x) {
    const y = stave.getYForTopText(stave.getNumLines()) + this.y_shift;
    Glyph.renderGlyph(stave.checkContext(), this.x + x + this.x_shift, y + Tables.currentMusicFont().lookupMetric("staveRepetition.coda.offsetY"), 40, "coda", { category: "coda" });
    return this;
  }
  drawSignoFixed(stave, x) {
    const y = stave.getYForTopText(stave.getNumLines()) + this.y_shift;
    Glyph.renderGlyph(stave.checkContext(), this.x + x + this.x_shift, y + Tables.currentMusicFont().lookupMetric("staveRepetition.segno.offsetY"), 30, "segno", { category: "segno" });
    return this;
  }
  drawSymbolText(stave, x, text, draw_coda) {
    var _a;
    const ctx = stave.checkContext();
    ctx.save();
    ctx.setFont(this.textFont);
    let text_x = 0;
    let symbol_x = 0;
    const modifierWidth = stave.getNoteStartX() - this.x;
    switch (this.symbol_type) {
      case _Repetition.type.CODA_LEFT:
        text_x = this.x + stave.getVerticalBarWidth();
        symbol_x = text_x + ctx.measureText(text).width + Tables.currentMusicFont().lookupMetric("staveRepetition.symbolText.offsetX");
        break;
      case _Repetition.type.DC:
      case _Repetition.type.DC_AL_FINE:
      case _Repetition.type.DS:
      case _Repetition.type.DS_AL_FINE:
      case _Repetition.type.FINE:
        text_x = this.x + x + this.x_shift + stave.getWidth() - Tables.currentMusicFont().lookupMetric("staveRepetition.symbolText.spacing") - modifierWidth - ctx.measureText(text).width;
        break;
      default:
        text_x = this.x + x + this.x_shift + stave.getWidth() - Tables.currentMusicFont().lookupMetric("staveRepetition.symbolText.spacing") - modifierWidth - ctx.measureText(text).width - Tables.currentMusicFont().lookupMetric("staveRepetition.symbolText.offsetX");
        symbol_x = text_x + ctx.measureText(text).width + Tables.currentMusicFont().lookupMetric("staveRepetition.symbolText.offsetX");
        break;
    }
    const y = stave.getYForTopText(stave.getNumLines()) + this.y_shift + Tables.currentMusicFont().lookupMetric("staveRepetition.symbolText.offsetY");
    if (draw_coda) {
      Glyph.renderGlyph(ctx, symbol_x, y, Font.convertSizeToPointValue((_a = this.textFont) === null || _a === void 0 ? void 0 : _a.size) * 2, "coda", {
        category: "coda"
      });
    }
    ctx.fillText(text, text_x, y + 5);
    ctx.restore();
    return this;
  }
};
Repetition.TEXT_FONT = {
  family: Font.SERIF,
  size: Tables.NOTATION_FONT_SCALE / 3,
  weight: FontWeight.BOLD,
  style: FontStyle.NORMAL
};
Repetition.type = {
  NONE: 1,
  CODA_LEFT: 2,
  CODA_RIGHT: 3,
  SEGNO_LEFT: 4,
  SEGNO_RIGHT: 5,
  DC: 6,
  DC_AL_CODA: 7,
  DC_AL_FINE: 8,
  DS: 9,
  DS_AL_CODA: 10,
  DS_AL_FINE: 11,
  FINE: 12,
  TO_CODA: 13
};

// node_modules/vexflow/build/esm/src/stavesection.js
var StaveSection = class extends StaveModifier {
  static get CATEGORY() {
    return "StaveSection";
  }
  constructor(section, x, shift_y, drawRect = true) {
    super();
    this.setWidth(16);
    this.section = section;
    this.x = x;
    this.shift_x = 0;
    this.shift_y = shift_y;
    this.drawRect = drawRect;
    this.resetFont();
  }
  setStaveSection(section) {
    this.section = section;
    return this;
  }
  setShiftX(x) {
    this.shift_x = x;
    return this;
  }
  setShiftY(y) {
    this.shift_y = y;
    return this;
  }
  draw(stave, shift_x) {
    const borderWidth = 2;
    const padding = 2;
    const ctx = stave.checkContext();
    this.setRendered();
    ctx.save();
    ctx.setLineWidth(borderWidth);
    ctx.setFont(this.textFont);
    const textFormatter = TextFormatter.create(this.textFont);
    const textWidth = textFormatter.getWidthForTextInPx(this.section);
    const textY = textFormatter.getYForStringInPx(this.section);
    const textHeight = textY.height;
    const headroom = -1 * textY.yMin;
    const width = textWidth + 2 * padding;
    const height = textHeight + 2 * padding;
    const y = stave.getYForTopText(1.5) + this.shift_y;
    const x = this.x + shift_x;
    if (this.drawRect) {
      ctx.beginPath();
      ctx.rect(x, y - height + headroom, width, height);
      ctx.stroke();
    }
    ctx.fillText(this.section, x + padding, y - padding);
    ctx.restore();
    return this;
  }
};
StaveSection.TEXT_FONT = {
  family: Font.SANS_SERIF,
  size: 10,
  weight: FontWeight.BOLD,
  style: FontStyle.NORMAL
};

// node_modules/vexflow/build/esm/src/stavetempo.js
var StaveTempo = class extends StaveModifier {
  static get CATEGORY() {
    return "StaveTempo";
  }
  constructor(tempo, x, shift_y) {
    super();
    this.render_options = { glyph_font_scale: 30 };
    this.tempo = tempo;
    this.position = StaveModifierPosition.ABOVE;
    this.x = x;
    this.shift_x = 10;
    this.shift_y = shift_y;
    this.resetFont();
  }
  setTempo(tempo) {
    this.tempo = tempo;
    return this;
  }
  setShiftX(x) {
    this.shift_x = x;
    return this;
  }
  setShiftY(y) {
    this.shift_y = y;
    return this;
  }
  draw(stave, shift_x) {
    const ctx = stave.checkContext();
    this.setRendered();
    const options = this.render_options;
    const scale = options.glyph_font_scale / Tables.NOTATION_FONT_SCALE;
    const name = this.tempo.name;
    const duration = this.tempo.duration;
    const dots = this.tempo.dots || 0;
    const bpm = this.tempo.bpm;
    let x = this.x + this.shift_x + shift_x;
    const y = stave.getYForTopText(1) + this.shift_y;
    ctx.save();
    const textFormatter = TextFormatter.create(this.textFont);
    if (name) {
      ctx.setFont(this.textFont);
      ctx.fillText(name, x, y);
      x += textFormatter.getWidthForTextInPx(name);
    }
    if (duration && bpm) {
      const noteTextFont = Object.assign(Object.assign({}, this.textFont), { weight: "normal", style: "normal" });
      ctx.setFont(noteTextFont);
      const noteTextFormatter = TextFormatter.create(noteTextFont);
      if (name) {
        x += noteTextFormatter.getWidthForTextInPx("|");
        ctx.fillText("(", x, y);
        x += noteTextFormatter.getWidthForTextInPx("(");
      }
      const glyphProps = Tables.getGlyphProps(duration);
      x += 3 * scale;
      Glyph.renderGlyph(ctx, x, y, options.glyph_font_scale, glyphProps.code_head);
      x += Glyph.getWidth(glyphProps.code_head, options.glyph_font_scale);
      if (glyphProps.stem) {
        let stem_height = 30;
        if (glyphProps.beam_count)
          stem_height += 3 * (glyphProps.beam_count - 1);
        stem_height *= scale;
        const y_top = y - stem_height;
        ctx.fillRect(x - scale, y_top, scale, stem_height);
        if (glyphProps.code && glyphProps.code_flag_upstem) {
          const flagMetrics = Glyph.renderGlyph(ctx, x, y_top, options.glyph_font_scale, glyphProps.code_flag_upstem, {
            category: "flag.staveTempo"
          });
          x += flagMetrics.width * Tables.NOTATION_FONT_SCALE / flagMetrics.font.getData().resolution;
        }
      }
      for (let i = 0; i < dots; i++) {
        x += 6 * scale;
        ctx.beginPath();
        ctx.arc(x, y + 2 * scale, 2 * scale, 0, Math.PI * 2, false);
        ctx.fill();
      }
      ctx.fillText(" = " + bpm + (name ? ")" : ""), x + 3 * scale, y);
    }
    ctx.restore();
    return this;
  }
};
StaveTempo.TEXT_FONT = {
  family: Font.SERIF,
  size: 14,
  weight: FontWeight.BOLD,
  style: FontStyle.NORMAL
};

// node_modules/vexflow/build/esm/src/textnote.js
var TextJustification;
(function(TextJustification2) {
  TextJustification2[TextJustification2["LEFT"] = 1] = "LEFT";
  TextJustification2[TextJustification2["CENTER"] = 2] = "CENTER";
  TextJustification2[TextJustification2["RIGHT"] = 3] = "RIGHT";
})(TextJustification || (TextJustification = {}));
var TextNote = class _TextNote extends Note {
  static get CATEGORY() {
    return "TextNote";
  }
  static get GLYPHS() {
    return {
      segno: {
        code: "segno"
      },
      tr: {
        code: "ornamentTrill"
      },
      mordent: {
        code: "ornamentMordent"
      },
      mordent_upper: {
        code: "ornamentShortTrill"
      },
      mordent_lower: {
        code: "ornamentMordent"
      },
      f: {
        code: "dynamicForte"
      },
      p: {
        code: "dynamicPiano"
      },
      m: {
        code: "dynamicMezzo"
      },
      s: {
        code: "dynamicSforzando"
      },
      z: {
        code: "dynamicZ"
      },
      coda: {
        code: "coda"
      },
      pedal_open: {
        code: "keyboardPedalPed"
      },
      pedal_close: {
        code: "keyboardPedalUp"
      },
      caesura_straight: {
        code: "caesura"
      },
      caesura_curved: {
        code: "caesuraCurved"
      },
      breath: {
        code: "breathMarkComma"
      },
      tick: {
        code: "breathMarkTick"
      },
      turn: {
        code: "ornamentTurn"
      },
      turn_inverted: {
        code: "ornamentTurnSlash"
      }
    };
  }
  constructor(noteStruct) {
    super(noteStruct);
    this.text = noteStruct.text || "";
    this.superscript = noteStruct.superscript;
    this.subscript = noteStruct.subscript;
    this.setFont(noteStruct.font);
    this.line = noteStruct.line || 0;
    this.smooth = noteStruct.smooth || false;
    this.ignore_ticks = noteStruct.ignore_ticks || false;
    this.justification = TextJustification.LEFT;
    if (noteStruct.glyph) {
      const struct = _TextNote.GLYPHS[noteStruct.glyph];
      if (!struct)
        throw new RuntimeError("Invalid glyph type: " + noteStruct.glyph);
      this.glyph = new Glyph(struct.code, Tables.NOTATION_FONT_SCALE, { category: "textNote" });
      this.setWidth(this.glyph.getMetrics().width);
    } else {
      this.glyph = void 0;
    }
  }
  setJustification(just) {
    this.justification = just;
    return this;
  }
  setLine(line) {
    this.line = line;
    return this;
  }
  getLine() {
    return this.line;
  }
  getText() {
    return this.text;
  }
  preFormat() {
    if (this.preFormatted)
      return;
    const tickContext = this.checkTickContext(`Can't preformat without a TickContext.`);
    if (this.smooth) {
      this.setWidth(0);
    } else {
      if (this.glyph) {
      } else {
        const ctx = this.checkContext();
        ctx.setFont(this.textFont);
        this.setWidth(ctx.measureText(this.text).width);
      }
    }
    if (this.justification === TextJustification.CENTER) {
      this.leftDisplacedHeadPx = this.width / 2;
    } else if (this.justification === TextJustification.RIGHT) {
      this.leftDisplacedHeadPx = this.width;
    }
    this.rightDisplacedHeadPx = tickContext.getMetrics().glyphPx / 2;
    this.preFormatted = true;
  }
  draw() {
    const ctx = this.checkContext();
    const stave = this.checkStave();
    const tickContext = this.checkTickContext(`Can't draw without a TickContext.`);
    this.setRendered();
    let x = this.getAbsoluteX() + tickContext.getMetrics().glyphPx / 2;
    const width = this.getWidth();
    if (this.justification === TextJustification.CENTER) {
      x -= width / 2;
    } else if (this.justification === TextJustification.RIGHT) {
      x -= width;
    }
    let y;
    if (this.glyph) {
      y = stave.getYForLine(this.line + -3);
      this.glyph.render(ctx, x, y);
    } else {
      y = stave.getYForLine(this.line + -3);
      this.applyStyle(ctx);
      ctx.setFont(this.textFont);
      ctx.fillText(this.text, x, y);
      const height = ctx.measureText(this.text).height;
      const { family, size, weight, style } = this.textFont;
      const smallerFontSize = Font.scaleSize(size, 0.769231);
      if (this.superscript) {
        ctx.setFont(family, smallerFontSize, weight, style);
        ctx.fillText(this.superscript, x + this.width + 2, y - height / 2.2);
      }
      if (this.subscript) {
        ctx.setFont(family, smallerFontSize, weight, style);
        ctx.fillText(this.subscript, x + this.width + 2, y + height / 2.2 - 1);
      }
      this.restoreStyle(ctx);
    }
  }
};
TextNote.TEXT_FONT = {
  family: Font.SANS_SERIF,
  size: 12,
  weight: FontWeight.NORMAL,
  style: FontStyle.NORMAL
};
TextNote.Justification = TextJustification;

// node_modules/vexflow/build/esm/src/stavetext.js
var StaveText = class extends StaveModifier {
  static get CATEGORY() {
    return "StaveText";
  }
  constructor(text, position, options = {}) {
    super();
    this.setWidth(16);
    this.text = text;
    this.position = position;
    this.options = Object.assign({ shift_x: 0, shift_y: 0, justification: TextNote.Justification.CENTER }, options);
    this.resetFont();
  }
  setStaveText(text) {
    this.text = text;
    return this;
  }
  setShiftX(x) {
    this.shift_x = x;
    return this;
  }
  setShiftY(y) {
    this.shift_y = y;
    return this;
  }
  setText(text) {
    this.text = text;
    return this;
  }
  draw(stave) {
    const ctx = stave.checkContext();
    this.setRendered();
    ctx.save();
    ctx.setLineWidth(2);
    ctx.setFont(this.textFont);
    const text_width = ctx.measureText("" + this.text).width;
    let x;
    let y;
    switch (this.position) {
      case StaveModifierPosition.LEFT:
      case StaveModifierPosition.RIGHT:
        y = (stave.getYForLine(0) + stave.getBottomLineY()) / 2 + this.options.shift_y;
        if (this.position === StaveModifierPosition.LEFT) {
          x = stave.getX() - text_width - 24 + this.options.shift_x;
        } else {
          x = stave.getX() + stave.getWidth() + 24 + this.options.shift_x;
        }
        break;
      case StaveModifierPosition.ABOVE:
      case StaveModifierPosition.BELOW:
        x = stave.getX() + this.options.shift_x;
        if (this.options.justification === TextJustification.CENTER) {
          x += stave.getWidth() / 2 - text_width / 2;
        } else if (this.options.justification === TextJustification.RIGHT) {
          x += stave.getWidth() - text_width;
        }
        if (this.position === StaveModifierPosition.ABOVE) {
          y = stave.getYForTopText(2) + this.options.shift_y;
        } else {
          y = stave.getYForBottomText(2) + this.options.shift_y;
        }
        break;
      default:
        throw new RuntimeError("InvalidPosition", "Value Must be in Modifier.Position.");
    }
    ctx.fillText("" + this.text, x, y + 4);
    ctx.restore();
    return this;
  }
};
StaveText.TEXT_FONT = {
  family: Font.SERIF,
  size: 16,
  weight: FontWeight.NORMAL,
  style: FontStyle.NORMAL
};

// node_modules/vexflow/build/esm/src/stavevolta.js
var VoltaType;
(function(VoltaType2) {
  VoltaType2[VoltaType2["NONE"] = 1] = "NONE";
  VoltaType2[VoltaType2["BEGIN"] = 2] = "BEGIN";
  VoltaType2[VoltaType2["MID"] = 3] = "MID";
  VoltaType2[VoltaType2["END"] = 4] = "END";
  VoltaType2[VoltaType2["BEGIN_END"] = 5] = "BEGIN_END";
})(VoltaType || (VoltaType = {}));
var Volta = class extends StaveModifier {
  static get CATEGORY() {
    return "Volta";
  }
  static get type() {
    return VoltaType;
  }
  constructor(type, number, x, y_shift) {
    super();
    this.volta = type;
    this.x = x;
    this.y_shift = y_shift;
    this.number = number;
    this.resetFont();
  }
  setShiftY(y) {
    this.y_shift = y;
    return this;
  }
  draw(stave, x) {
    const ctx = stave.checkContext();
    this.setRendered();
    let width = stave.getWidth() - x;
    const top_y = stave.getYForTopText(stave.getNumLines()) + this.y_shift;
    const vert_height = 1.5 * stave.getSpacingBetweenLines();
    switch (this.volta) {
      case VoltaType.BEGIN:
        ctx.fillRect(this.x + x, top_y, 1, vert_height);
        break;
      case VoltaType.END:
        width -= 5;
        ctx.fillRect(this.x + x + width, top_y, 1, vert_height);
        break;
      case VoltaType.BEGIN_END:
        width -= 3;
        ctx.fillRect(this.x + x, top_y, 1, vert_height);
        ctx.fillRect(this.x + x + width, top_y, 1, vert_height);
        break;
      default:
        break;
    }
    if (this.volta === VoltaType.BEGIN || this.volta === VoltaType.BEGIN_END) {
      ctx.save();
      ctx.setFont(this.textFont);
      ctx.fillText(this.number, this.x + x + 5, top_y + 15);
      ctx.restore();
    }
    ctx.fillRect(this.x + x, top_y, width, 1);
    return this;
  }
};
Volta.TEXT_FONT = {
  family: Font.SANS_SERIF,
  size: 9,
  weight: FontWeight.BOLD,
  style: FontStyle.NORMAL
};

// node_modules/vexflow/build/esm/src/timesigglyph.js
var TimeSignatureGlyph = class extends Glyph {
  constructor(timeSignature, topDigits, botDigits, code, point, options) {
    var _a;
    super(code, point, options);
    this.timeSignature = timeSignature;
    this.topGlyphs = [];
    this.botGlyphs = [];
    let topWidth = 0;
    let height = 0;
    for (let i = 0; i < topDigits.length; ++i) {
      let timeSigType = topDigits[i];
      switch (topDigits[i]) {
        case "-":
          timeSigType = "Minus";
          break;
        case "+":
          timeSigType = botDigits.length > 0 ? "PlusSmall" : "Plus";
          break;
        case "(":
          timeSigType = botDigits.length > 0 ? "ParensLeftSmall" : "ParensLeft";
          break;
        case ")":
          timeSigType = botDigits.length > 0 ? "ParensRightSmall" : "ParensRight";
          break;
      }
      const topGlyph = new Glyph("timeSig" + timeSigType, this.timeSignature.point);
      this.topGlyphs.push(topGlyph);
      topWidth += (_a = topGlyph.getMetrics().width) !== null && _a !== void 0 ? _a : 0;
      height = Math.max(height, topGlyph.getMetrics().height);
    }
    let botWidth = 0;
    for (let i = 0; i < botDigits.length; ++i) {
      let timeSigType = botDigits[i];
      switch (botDigits[i]) {
        case "+":
          timeSigType = "PlusSmall";
          break;
        case "(":
          timeSigType = "ParensLeftSmall";
          break;
        case ")":
          timeSigType = "ParensRightSmall";
          break;
      }
      const botGlyph = new Glyph("timeSig" + timeSigType, this.timeSignature.point);
      this.botGlyphs.push(botGlyph);
      botWidth += defined(botGlyph.getMetrics().width);
      height = Math.max(height, botGlyph.getMetrics().height);
    }
    this.lineShift = height > 22 ? 1 : 0;
    this.width = Math.max(topWidth, botWidth);
    this.xMin = this.getMetrics().x_min;
    this.topStartX = (this.width - topWidth) / 2;
    this.botStartX = (this.width - botWidth) / 2;
    this.reset();
  }
  getMetrics() {
    return {
      x_min: this.xMin,
      x_max: this.xMin + this.width,
      width: this.width
    };
  }
  renderToStave(x) {
    const stave = this.checkStave();
    const ctx = this.checkContext();
    let start_x = x + this.topStartX;
    let y = 0;
    if (this.botGlyphs.length > 0)
      y = stave.getYForLine(this.timeSignature.topLine - this.lineShift);
    else
      y = (stave.getYForLine(this.timeSignature.topLine) + stave.getYForLine(this.timeSignature.bottomLine)) / 2;
    for (let i = 0; i < this.topGlyphs.length; ++i) {
      const glyph = this.topGlyphs[i];
      Glyph.renderOutline(ctx, glyph.getMetrics().outline, this.scale, start_x + this.x_shift, y);
      start_x += defined(glyph.getMetrics().width);
    }
    start_x = x + this.botStartX;
    y = stave.getYForLine(this.timeSignature.bottomLine + this.lineShift);
    for (let i = 0; i < this.botGlyphs.length; ++i) {
      const glyph = this.botGlyphs[i];
      this.timeSignature.placeGlyphOnLine(glyph, stave, this.timeSignature.getLine());
      Glyph.renderOutline(ctx, glyph.getMetrics().outline, this.scale, start_x + glyph.getMetrics().x_shift, y);
      start_x += defined(glyph.getMetrics().width);
    }
  }
};

// node_modules/vexflow/build/esm/src/timesignature.js
var assertIsValidTimeSig = (timeSpec) => {
  const numbers = timeSpec.split("/");
  if (numbers.length !== 2 && numbers[0] !== "+" && numbers[0] !== "-") {
    throw new RuntimeError("BadTimeSignature", `Invalid time spec: ${timeSpec}. Must be in the form "<numerator>/<denominator>"`);
  }
  numbers.forEach((number) => {
    if (/^[0-9+\-()]+$/.test(number) == false) {
      throw new RuntimeError("BadTimeSignature", `Invalid time spec: ${timeSpec}. Must contain valid signatures.`);
    }
  });
};
var TimeSignature = class _TimeSignature extends StaveModifier {
  static get CATEGORY() {
    return "TimeSignature";
  }
  static get glyphs() {
    return {
      C: {
        code: "timeSigCommon",
        line: 2
      },
      "C|": {
        code: "timeSigCutCommon",
        line: 2
      }
    };
  }
  constructor(timeSpec = "4/4", customPadding = 15, validate_args = true) {
    super();
    this.timeSpec = "4/4";
    this.line = 0;
    this.is_numeric = true;
    this.validate_args = validate_args;
    const padding = customPadding;
    const musicFont = Tables.currentMusicFont();
    this.point = musicFont.lookupMetric("digits.point") || Tables.NOTATION_FONT_SCALE;
    const fontLineShift = musicFont.lookupMetric("digits.shiftLine", 0);
    this.topLine = 2 + fontLineShift;
    this.bottomLine = 4 + fontLineShift;
    this.setPosition(StaveModifierPosition.BEGIN);
    this.setTimeSig(timeSpec);
    this.setPadding(padding);
  }
  parseTimeSpec(timeSpec) {
    var _a, _b;
    if (timeSpec === "C" || timeSpec === "C|") {
      const { line, code } = _TimeSignature.glyphs[timeSpec];
      return {
        line,
        num: false,
        glyph: new Glyph(code, Tables.NOTATION_FONT_SCALE)
      };
    }
    if (this.validate_args) {
      assertIsValidTimeSig(timeSpec);
    }
    const parts = timeSpec.split("/");
    return {
      line: 0,
      num: true,
      glyph: this.makeTimeSignatureGlyph((_a = parts[0]) !== null && _a !== void 0 ? _a : "", (_b = parts[1]) !== null && _b !== void 0 ? _b : "")
    };
  }
  makeTimeSignatureGlyph(topDigits, botDigits) {
    return new TimeSignatureGlyph(this, topDigits, botDigits, "timeSig0", this.point);
  }
  getInfo() {
    const { line, is_numeric, glyph } = this;
    return { line, num: is_numeric, glyph };
  }
  setTimeSig(timeSpec) {
    this.timeSpec = timeSpec;
    const info = this.parseTimeSpec(timeSpec);
    this.setGlyph(info.glyph);
    this.is_numeric = info.num;
    this.line = info.line;
    return this;
  }
  getTimeSpec() {
    return this.timeSpec;
  }
  getLine() {
    return this.line;
  }
  setLine(line) {
    this.line = line;
  }
  getGlyph() {
    return this.glyph;
  }
  setGlyph(glyph) {
    this.glyph = glyph;
    this.setWidth(defined(this.glyph.getMetrics().width));
  }
  getIsNumeric() {
    return this.is_numeric;
  }
  setIsNumeric(isNumeric) {
    this.is_numeric = isNumeric;
  }
  draw() {
    const stave = this.checkStave();
    const ctx = stave.checkContext();
    this.setRendered();
    this.applyStyle(ctx);
    ctx.openGroup("timesignature", this.getAttribute("id"));
    this.glyph.setStave(stave);
    this.glyph.setContext(ctx);
    this.placeGlyphOnLine(this.glyph, stave, this.line);
    this.glyph.renderToStave(this.x);
    ctx.closeGroup();
    this.restoreStyle(ctx);
  }
};

// node_modules/vexflow/build/esm/src/stave.js
var SORT_ORDER_BEG_MODIFIERS = {
  [Barline.CATEGORY]: 0,
  [Clef.CATEGORY]: 1,
  [KeySignature.CATEGORY]: 2,
  [TimeSignature.CATEGORY]: 3
};
var SORT_ORDER_END_MODIFIERS = {
  [TimeSignature.CATEGORY]: 0,
  [KeySignature.CATEGORY]: 1,
  [Barline.CATEGORY]: 2,
  [Clef.CATEGORY]: 3
};
var Stave = class extends Element {
  static get CATEGORY() {
    return "Stave";
  }
  static get defaultPadding() {
    const musicFont = Tables.currentMusicFont();
    return musicFont.lookupMetric("stave.padding") + musicFont.lookupMetric("stave.endPaddingMax");
  }
  static get rightPadding() {
    const musicFont = Tables.currentMusicFont();
    return musicFont.lookupMetric("stave.endPaddingMax");
  }
  constructor(x, y, width, options) {
    super();
    this.height = 0;
    this.x = x;
    this.y = y;
    this.width = width;
    this.formatted = false;
    this.start_x = x + 5;
    this.end_x = x + width;
    this.modifiers = [];
    this.measure = 0;
    this.clef = "treble";
    this.endClef = void 0;
    this.resetFont();
    this.options = Object.assign({ vertical_bar_width: 10, num_lines: 5, fill_style: "#999999", left_bar: true, right_bar: true, spacing_between_lines_px: Tables.STAVE_LINE_DISTANCE, space_above_staff_ln: 4, space_below_staff_ln: 4, top_text_position: 1, bottom_text_position: 4, line_config: [] }, options);
    this.bounds = { x: this.x, y: this.y, w: this.width, h: 0 };
    this.defaultLedgerLineStyle = { strokeStyle: "#444", lineWidth: 1.4 };
    this.resetLines();
    this.addModifier(new Barline(this.options.left_bar ? BarlineType.SINGLE : BarlineType.NONE));
    this.addEndModifier(new Barline(this.options.right_bar ? BarlineType.SINGLE : BarlineType.NONE));
  }
  setDefaultLedgerLineStyle(style) {
    this.defaultLedgerLineStyle = style;
  }
  getDefaultLedgerLineStyle() {
    return Object.assign(Object.assign({}, this.getStyle()), this.defaultLedgerLineStyle);
  }
  space(spacing) {
    return this.options.spacing_between_lines_px * spacing;
  }
  resetLines() {
    this.options.line_config = [];
    for (let i = 0; i < this.options.num_lines; i++) {
      this.options.line_config.push({ visible: true });
    }
    this.height = (this.options.num_lines + this.options.space_above_staff_ln) * this.options.spacing_between_lines_px;
    this.options.bottom_text_position = this.options.num_lines;
  }
  setNoteStartX(x) {
    if (!this.formatted)
      this.format();
    this.start_x = x;
    return this;
  }
  getNoteStartX() {
    if (!this.formatted)
      this.format();
    return this.start_x;
  }
  getNoteEndX() {
    if (!this.formatted)
      this.format();
    return this.end_x;
  }
  getTieStartX() {
    return this.start_x;
  }
  getTieEndX() {
    return this.end_x;
  }
  getX() {
    return this.x;
  }
  getNumLines() {
    return this.options.num_lines;
  }
  setNumLines(n) {
    this.options.num_lines = n;
    this.resetLines();
    return this;
  }
  setY(y) {
    this.y = y;
    return this;
  }
  getY() {
    return this.y;
  }
  getTopLineTopY() {
    return this.getYForLine(0) - Tables.STAVE_LINE_THICKNESS / 2;
  }
  getBottomLineBottomY() {
    return this.getYForLine(this.getNumLines() - 1) + Tables.STAVE_LINE_THICKNESS / 2;
  }
  setX(x) {
    const shift = x - this.x;
    this.formatted = false;
    this.x = x;
    this.start_x += shift;
    this.end_x += shift;
    for (let i = 0; i < this.modifiers.length; i++) {
      const mod = this.modifiers[i];
      mod.setX(mod.getX() + shift);
    }
    return this;
  }
  setWidth(width) {
    this.formatted = false;
    this.width = width;
    this.end_x = this.x + width;
    return this;
  }
  getWidth() {
    return this.width;
  }
  getStyle() {
    return Object.assign({ fillStyle: this.options.fill_style, strokeStyle: this.options.fill_style, lineWidth: Tables.STAVE_LINE_THICKNESS }, super.getStyle());
  }
  setMeasure(measure) {
    this.measure = measure;
    return this;
  }
  getMeasure() {
    return this.measure;
  }
  getModifierXShift(index = 0) {
    if (typeof index !== "number") {
      throw new RuntimeError("InvalidIndex", "Must be of number type");
    }
    if (!this.formatted)
      this.format();
    if (this.getModifiers(StaveModifierPosition.BEGIN).length === 1) {
      return 0;
    }
    if (this.modifiers[index].getPosition() === StaveModifierPosition.RIGHT) {
      return 0;
    }
    let start_x = this.start_x - this.x;
    const begBarline = this.modifiers[0];
    if (begBarline.getType() === BarlineType.REPEAT_BEGIN && start_x > begBarline.getWidth()) {
      start_x -= begBarline.getWidth();
    }
    return start_x;
  }
  setRepetitionType(type, yShift = 0) {
    this.modifiers.push(new Repetition(type, this.x, yShift));
    return this;
  }
  setVoltaType(type, number_t, y) {
    this.modifiers.push(new Volta(type, number_t, this.x, y));
    return this;
  }
  setSection(section, y, xOffset = 0, fontSize, drawRect = true) {
    const staveSection = new StaveSection(section, this.x + xOffset, y, drawRect);
    if (fontSize)
      staveSection.setFontSize(fontSize);
    this.modifiers.push(staveSection);
    return this;
  }
  setTempo(tempo, y) {
    this.modifiers.push(new StaveTempo(tempo, this.x, y));
    return this;
  }
  setText(text, position, options = {}) {
    this.modifiers.push(new StaveText(text, position, options));
    return this;
  }
  getHeight() {
    return this.height;
  }
  getSpacingBetweenLines() {
    return this.options.spacing_between_lines_px;
  }
  getBoundingBox() {
    return new BoundingBox(this.x, this.y, this.width, this.getBottomY() - this.y);
  }
  getBottomY() {
    const options = this.options;
    const spacing = options.spacing_between_lines_px;
    const score_bottom = this.getYForLine(options.num_lines) + options.space_below_staff_ln * spacing;
    return score_bottom;
  }
  getBottomLineY() {
    return this.getYForLine(this.options.num_lines);
  }
  getYForLine(line) {
    const options = this.options;
    const spacing = options.spacing_between_lines_px;
    const headroom = options.space_above_staff_ln;
    const y = this.y + line * spacing + headroom * spacing;
    return y;
  }
  getLineForY(y) {
    const options = this.options;
    const spacing = options.spacing_between_lines_px;
    const headroom = options.space_above_staff_ln;
    return (y - this.y) / spacing - headroom;
  }
  getYForTopText(line = 0) {
    return this.getYForLine(-line - this.options.top_text_position);
  }
  getYForBottomText(line = 0) {
    return this.getYForLine(this.options.bottom_text_position + line);
  }
  getYForNote(line) {
    const options = this.options;
    const spacing = options.spacing_between_lines_px;
    const headroom = options.space_above_staff_ln;
    return this.y + headroom * spacing + 5 * spacing - line * spacing;
  }
  getYForGlyphs() {
    return this.getYForLine(3);
  }
  addModifier(modifier, position) {
    if (position !== void 0) {
      modifier.setPosition(position);
    }
    modifier.setStave(this);
    this.formatted = false;
    this.modifiers.push(modifier);
    return this;
  }
  addEndModifier(modifier) {
    this.addModifier(modifier, StaveModifierPosition.END);
    return this;
  }
  setBegBarType(type) {
    const { SINGLE, REPEAT_BEGIN, NONE } = BarlineType;
    if (type === SINGLE || type === REPEAT_BEGIN || type === NONE) {
      this.modifiers[0].setType(type);
      this.formatted = false;
    }
    return this;
  }
  setEndBarType(type) {
    if (type !== BarlineType.REPEAT_BEGIN) {
      this.modifiers[1].setType(type);
      this.formatted = false;
    }
    return this;
  }
  setClef(clefSpec, size, annotation, position) {
    if (position === void 0) {
      position = StaveModifierPosition.BEGIN;
    }
    if (position === StaveModifierPosition.END) {
      this.endClef = clefSpec;
    } else {
      this.clef = clefSpec;
    }
    const clefs2 = this.getModifiers(position, Clef.CATEGORY);
    if (clefs2.length === 0) {
      this.addClef(clefSpec, size, annotation, position);
    } else {
      clefs2[0].setType(clefSpec, size, annotation);
    }
    return this;
  }
  getClef() {
    return this.clef;
  }
  setEndClef(clefSpec, size, annotation) {
    this.setClef(clefSpec, size, annotation, StaveModifierPosition.END);
    return this;
  }
  getEndClef() {
    return this.endClef;
  }
  setKeySignature(keySpec, cancelKeySpec, position) {
    if (position === void 0) {
      position = StaveModifierPosition.BEGIN;
    }
    const keySignatures2 = this.getModifiers(position, KeySignature.CATEGORY);
    if (keySignatures2.length === 0) {
      this.addKeySignature(keySpec, cancelKeySpec, position);
    } else {
      keySignatures2[0].setKeySig(keySpec, cancelKeySpec);
    }
    return this;
  }
  setEndKeySignature(keySpec, cancelKeySpec) {
    this.setKeySignature(keySpec, cancelKeySpec, StaveModifierPosition.END);
    return this;
  }
  setTimeSignature(timeSpec, customPadding, position) {
    if (position === void 0) {
      position = StaveModifierPosition.BEGIN;
    }
    const timeSignatures = this.getModifiers(position, TimeSignature.CATEGORY);
    if (timeSignatures.length === 0) {
      this.addTimeSignature(timeSpec, customPadding, position);
    } else {
      timeSignatures[0].setTimeSig(timeSpec);
    }
    return this;
  }
  setEndTimeSignature(timeSpec, customPadding) {
    this.setTimeSignature(timeSpec, customPadding, StaveModifierPosition.END);
    return this;
  }
  addKeySignature(keySpec, cancelKeySpec, position) {
    if (position === void 0) {
      position = StaveModifierPosition.BEGIN;
    }
    this.addModifier(new KeySignature(keySpec, cancelKeySpec).setPosition(position), position);
    return this;
  }
  addClef(clef, size, annotation, position) {
    if (position === void 0 || position === StaveModifierPosition.BEGIN) {
      this.clef = clef;
    } else if (position === StaveModifierPosition.END) {
      this.endClef = clef;
    }
    this.addModifier(new Clef(clef, size, annotation), position);
    return this;
  }
  addEndClef(clef, size, annotation) {
    this.addClef(clef, size, annotation, StaveModifierPosition.END);
    return this;
  }
  addTimeSignature(timeSpec, customPadding, position) {
    this.addModifier(new TimeSignature(timeSpec, customPadding), position);
    return this;
  }
  addEndTimeSignature(timeSpec, customPadding) {
    this.addTimeSignature(timeSpec, customPadding, StaveModifierPosition.END);
    return this;
  }
  addTrebleGlyph() {
    this.addClef("treble");
    return this;
  }
  getModifiers(position, category) {
    const noPosition = position === void 0;
    const noCategory = category === void 0;
    if (noPosition && noCategory) {
      return this.modifiers;
    } else if (noPosition) {
      return this.modifiers.filter((m) => category === m.getCategory());
    } else if (noCategory) {
      return this.modifiers.filter((m) => position === m.getPosition());
    } else {
      return this.modifiers.filter((m) => position === m.getPosition() && category === m.getCategory());
    }
  }
  sortByCategory(items, order) {
    for (let i = items.length - 1; i >= 0; i--) {
      for (let j = 0; j < i; j++) {
        if (order[items[j].getCategory()] > order[items[j + 1].getCategory()]) {
          const temp = items[j];
          items[j] = items[j + 1];
          items[j + 1] = temp;
        }
      }
    }
  }
  format() {
    const begBarline = this.modifiers[0];
    const endBarline = this.modifiers[1];
    const begModifiers = this.getModifiers(StaveModifierPosition.BEGIN);
    const endModifiers = this.getModifiers(StaveModifierPosition.END);
    this.sortByCategory(begModifiers, SORT_ORDER_BEG_MODIFIERS);
    this.sortByCategory(endModifiers, SORT_ORDER_END_MODIFIERS);
    if (begModifiers.length > 1 && begBarline.getType() === BarlineType.REPEAT_BEGIN) {
      begModifiers.push(begModifiers.splice(0, 1)[0]);
      begModifiers.splice(0, 0, new Barline(BarlineType.SINGLE));
    }
    if (endModifiers.indexOf(endBarline) > 0) {
      endModifiers.splice(0, 0, new Barline(BarlineType.NONE));
    }
    let width;
    let padding;
    let modifier;
    let offset = 0;
    let x = this.x;
    for (let i = 0; i < begModifiers.length; i++) {
      modifier = begModifiers[i];
      padding = modifier.getPadding(i + offset);
      width = modifier.getWidth();
      x += padding;
      modifier.setX(x);
      x += width;
      if (padding + width === 0)
        offset--;
    }
    this.start_x = x;
    x = this.x + this.width;
    const widths = {
      left: 0,
      right: 0,
      paddingRight: 0,
      paddingLeft: 0
    };
    let lastBarlineIdx = 0;
    for (let i = 0; i < endModifiers.length; i++) {
      modifier = endModifiers[i];
      lastBarlineIdx = isBarline(modifier) ? i : lastBarlineIdx;
      widths.right = 0;
      widths.left = 0;
      widths.paddingRight = 0;
      widths.paddingLeft = 0;
      const layoutMetrics = modifier.getLayoutMetrics();
      if (layoutMetrics) {
        if (i !== 0) {
          widths.right = layoutMetrics.xMax || 0;
          widths.paddingRight = layoutMetrics.paddingRight || 0;
        }
        widths.left = -layoutMetrics.xMin || 0;
        widths.paddingLeft = layoutMetrics.paddingLeft || 0;
        if (i === endModifiers.length - 1) {
          widths.paddingLeft = 0;
        }
      } else {
        widths.paddingRight = modifier.getPadding(i - lastBarlineIdx);
        if (i !== 0) {
          widths.right = modifier.getWidth();
        }
        if (i === 0) {
          widths.left = modifier.getWidth();
        }
      }
      x -= widths.paddingRight;
      x -= widths.right;
      modifier.setX(x);
      x -= widths.left;
      x -= widths.paddingLeft;
    }
    this.end_x = endModifiers.length === 1 ? this.x + this.width : x;
    this.formatted = true;
  }
  draw() {
    const ctx = this.checkContext();
    this.setRendered();
    this.applyStyle();
    ctx.openGroup("stave", this.getAttribute("id"));
    if (!this.formatted)
      this.format();
    const num_lines = this.options.num_lines;
    const width = this.width;
    const x = this.x;
    let y;
    for (let line = 0; line < num_lines; line++) {
      y = this.getYForLine(line);
      if (this.options.line_config[line].visible) {
        ctx.beginPath();
        ctx.moveTo(x, y);
        ctx.lineTo(x + width, y);
        ctx.stroke();
      }
    }
    ctx.closeGroup();
    this.restoreStyle();
    for (let i = 0; i < this.modifiers.length; i++) {
      const modifier = this.modifiers[i];
      if (typeof modifier.draw === "function") {
        modifier.applyStyle(ctx);
        modifier.draw(this, this.getModifierXShift(i));
        modifier.restoreStyle(ctx);
      }
    }
    if (this.measure > 0) {
      ctx.save();
      ctx.setFont(this.textFont);
      const textWidth = ctx.measureText("" + this.measure).width;
      y = this.getYForTopText(0) + 3;
      ctx.fillText("" + this.measure, this.x - textWidth / 2, y);
      ctx.restore();
    }
    return this;
  }
  getVerticalBarWidth() {
    return this.options.vertical_bar_width;
  }
  getConfigForLines() {
    return this.options.line_config;
  }
  setConfigForLine(line_number, line_config) {
    if (line_number >= this.options.num_lines || line_number < 0) {
      throw new RuntimeError("StaveConfigError", "The line number must be within the range of the number of lines in the Stave.");
    }
    if (line_config.visible === void 0) {
      throw new RuntimeError("StaveConfigError", "The line configuration object is missing the 'visible' property.");
    }
    if (typeof line_config.visible !== "boolean") {
      throw new RuntimeError("StaveConfigError", "The line configuration objects 'visible' property must be true or false.");
    }
    this.options.line_config[line_number] = line_config;
    return this;
  }
  setConfigForLines(lines_configuration) {
    if (lines_configuration.length !== this.options.num_lines) {
      throw new RuntimeError("StaveConfigError", "The length of the lines configuration array must match the number of lines in the Stave");
    }
    for (const line_config in lines_configuration) {
      if (lines_configuration[line_config].visible == void 0) {
        lines_configuration[line_config] = this.options.line_config[line_config];
      }
      this.options.line_config[line_config] = Object.assign(Object.assign({}, this.options.line_config[line_config]), lines_configuration[line_config]);
    }
    this.options.line_config = lines_configuration;
    return this;
  }
  static formatBegModifiers(staves) {
    const adjustCategoryStartX = (category) => {
      let minStartX = 0;
      staves.forEach((stave) => {
        const modifiers = stave.getModifiers(StaveModifierPosition.BEGIN, category);
        if (modifiers.length > 0 && modifiers[0].getX() > minStartX)
          minStartX = modifiers[0].getX();
      });
      let adjustX = 0;
      staves.forEach((stave) => {
        adjustX = 0;
        const modifiers = stave.getModifiers(StaveModifierPosition.BEGIN, category);
        modifiers.forEach((modifier) => {
          if (minStartX - modifier.getX() > adjustX)
            adjustX = minStartX - modifier.getX();
        });
        const allModifiers = stave.getModifiers(StaveModifierPosition.BEGIN);
        let bAdjust = false;
        allModifiers.forEach((modifier) => {
          if (modifier.getCategory() === category)
            bAdjust = true;
          if (bAdjust && adjustX > 0)
            modifier.setX(modifier.getX() + adjustX);
        });
        stave.setNoteStartX(stave.getNoteStartX() + adjustX);
      });
    };
    staves.forEach((stave) => {
      if (!stave.formatted)
        stave.format();
    });
    adjustCategoryStartX("Clef");
    adjustCategoryStartX("KeySignature");
    adjustCategoryStartX("TimeSignature");
    let maxX = 0;
    staves.forEach((stave) => {
      if (stave.getNoteStartX() > maxX)
        maxX = stave.getNoteStartX();
    });
    staves.forEach((stave) => {
      stave.setNoteStartX(maxX);
    });
    maxX = 0;
    staves.forEach((stave) => {
      const modifiers = stave.getModifiers(StaveModifierPosition.BEGIN, "Barline");
      modifiers.forEach((modifier) => {
        if (modifier.getType() == BarlineType.REPEAT_BEGIN) {
          if (modifier.getX() > maxX)
            maxX = modifier.getX();
        }
      });
    });
    staves.forEach((stave) => {
      const modifiers = stave.getModifiers(StaveModifierPosition.BEGIN, "Barline");
      modifiers.forEach((modifier) => {
        if (modifier.getType() == BarlineType.REPEAT_BEGIN)
          modifier.setX(maxX);
      });
    });
  }
};
Stave.TEXT_FONT = {
  family: Font.SANS_SERIF,
  size: 8,
  weight: FontWeight.NORMAL,
  style: FontStyle.NORMAL
};

// node_modules/vexflow/build/esm/src/staveconnector.js
function drawBoldDoubleLine(ctx, type, topX, topY, botY) {
  if (type !== StaveConnector.type.BOLD_DOUBLE_LEFT && type !== StaveConnector.type.BOLD_DOUBLE_RIGHT) {
    throw new RuntimeError("InvalidConnector", "A REPEAT_BEGIN or REPEAT_END type must be provided.");
  }
  let x_shift = 3;
  let variableWidth = 3.5;
  const thickLineOffset = 2;
  if (type === StaveConnector.type.BOLD_DOUBLE_RIGHT) {
    x_shift = -5;
    variableWidth = 3;
  }
  ctx.fillRect(topX + x_shift, topY, 1, botY - topY);
  ctx.fillRect(topX - thickLineOffset, topY, variableWidth, botY - topY);
}
var StaveConnector = class _StaveConnector extends Element {
  static get CATEGORY() {
    return "StaveConnector";
  }
  constructor(top_stave, bottom_stave) {
    super();
    this.thickness = Tables.STAVE_LINE_THICKNESS;
    this.width = 3;
    this.top_stave = top_stave;
    this.bottom_stave = bottom_stave;
    this.type = _StaveConnector.type.DOUBLE;
    this.resetFont();
    this.x_shift = 0;
    this.texts = [];
  }
  setType(type) {
    const newType = typeof type === "string" ? _StaveConnector.typeString[type] : type;
    if (Object.values(_StaveConnector.type).includes(newType)) {
      this.type = newType;
    }
    return this;
  }
  getType() {
    return this.type;
  }
  setText(text, options = {}) {
    this.texts.push({
      content: text,
      options: Object.assign({ shift_x: 0, shift_y: 0 }, options)
    });
    return this;
  }
  setXShift(x_shift) {
    if (typeof x_shift !== "number") {
      throw new RuntimeError("InvalidType", "x_shift must be a Number");
    }
    this.x_shift = x_shift;
    return this;
  }
  getXShift() {
    return this.x_shift;
  }
  draw() {
    const ctx = this.checkContext();
    this.setRendered();
    let topY = this.top_stave.getYForLine(0);
    let botY = this.bottom_stave.getYForLine(this.bottom_stave.getNumLines() - 1) + this.thickness;
    let width = this.width;
    let topX = this.top_stave.getX();
    const isRightSidedConnector = this.type === _StaveConnector.type.SINGLE_RIGHT || this.type === _StaveConnector.type.BOLD_DOUBLE_RIGHT || this.type === _StaveConnector.type.THIN_DOUBLE;
    if (isRightSidedConnector) {
      topX = this.top_stave.getX() + this.top_stave.getWidth();
    }
    let attachment_height = botY - topY;
    switch (this.type) {
      case _StaveConnector.type.SINGLE:
        width = 1;
        break;
      case _StaveConnector.type.SINGLE_LEFT:
        width = 1;
        break;
      case _StaveConnector.type.SINGLE_RIGHT:
        width = 1;
        break;
      case _StaveConnector.type.DOUBLE:
        topX -= this.width + 2;
        topY -= this.thickness;
        attachment_height += 0.5;
        break;
      case _StaveConnector.type.BRACE: {
        width = 12;
        const x1 = this.top_stave.getX() - 2 + this.x_shift;
        const y1 = topY;
        const x3 = x1;
        const y3 = botY;
        const x2 = x1 - width;
        const y2 = y1 + attachment_height / 2;
        const cpx1 = x2 - 0.9 * width;
        const cpy1 = y1 + 0.2 * attachment_height;
        const cpx2 = x1 + 1.1 * width;
        const cpy2 = y2 - 0.135 * attachment_height;
        const cpx3 = cpx2;
        const cpy3 = y2 + 0.135 * attachment_height;
        const cpx4 = cpx1;
        const cpy4 = y3 - 0.2 * attachment_height;
        const cpx5 = x2 - width;
        const cpy5 = cpy4;
        const cpx6 = x1 + 0.4 * width;
        const cpy6 = y2 + 0.135 * attachment_height;
        const cpx7 = cpx6;
        const cpy7 = y2 - 0.135 * attachment_height;
        const cpx8 = cpx5;
        const cpy8 = cpy1;
        ctx.beginPath();
        ctx.moveTo(x1, y1);
        ctx.bezierCurveTo(cpx1, cpy1, cpx2, cpy2, x2, y2);
        ctx.bezierCurveTo(cpx3, cpy3, cpx4, cpy4, x3, y3);
        ctx.bezierCurveTo(cpx5, cpy5, cpx6, cpy6, x2, y2);
        ctx.bezierCurveTo(cpx7, cpy7, cpx8, cpy8, x1, y1);
        ctx.fill();
        ctx.stroke();
        break;
      }
      case _StaveConnector.type.BRACKET:
        topY -= 6;
        botY += 6;
        attachment_height = botY - topY;
        Glyph.renderGlyph(ctx, topX - 5, topY, 40, "bracketTop");
        Glyph.renderGlyph(ctx, topX - 5, botY, 40, "bracketBottom");
        topX -= this.width + 2;
        break;
      case _StaveConnector.type.BOLD_DOUBLE_LEFT:
        drawBoldDoubleLine(ctx, this.type, topX + this.x_shift, topY, botY - this.thickness);
        break;
      case _StaveConnector.type.BOLD_DOUBLE_RIGHT:
        drawBoldDoubleLine(ctx, this.type, topX, topY, botY - this.thickness);
        break;
      case _StaveConnector.type.THIN_DOUBLE:
        width = 1;
        attachment_height -= this.thickness;
        break;
      case _StaveConnector.type.NONE:
        break;
      default:
        throw new RuntimeError("InvalidType", `The provided StaveConnector.type (${this.type}) is invalid.`);
    }
    if (this.type !== _StaveConnector.type.BRACE && this.type !== _StaveConnector.type.BOLD_DOUBLE_LEFT && this.type !== _StaveConnector.type.BOLD_DOUBLE_RIGHT && this.type !== _StaveConnector.type.NONE) {
      ctx.fillRect(topX, topY, width, attachment_height);
    }
    if (this.type === _StaveConnector.type.THIN_DOUBLE) {
      ctx.fillRect(topX - 3, topY, width, attachment_height);
    }
    ctx.save();
    ctx.setLineWidth(2);
    ctx.setFont(this.textFont);
    for (let i = 0; i < this.texts.length; i++) {
      const text = this.texts[i];
      const text_width = ctx.measureText("" + text.content).width;
      const x = this.top_stave.getX() - text_width - 24 + text.options.shift_x;
      const y = (this.top_stave.getYForLine(0) + this.bottom_stave.getBottomLineY()) / 2 + text.options.shift_y;
      ctx.fillText("" + text.content, x, y + 4);
    }
    ctx.restore();
  }
};
StaveConnector.TEXT_FONT = {
  family: Font.SERIF,
  size: 16,
  weight: FontWeight.NORMAL,
  style: FontStyle.NORMAL
};
StaveConnector.type = {
  SINGLE_RIGHT: 0,
  SINGLE_LEFT: 1,
  SINGLE: 1,
  DOUBLE: 2,
  BRACE: 3,
  BRACKET: 4,
  BOLD_DOUBLE_LEFT: 5,
  BOLD_DOUBLE_RIGHT: 6,
  THIN_DOUBLE: 7,
  NONE: 8
};
StaveConnector.typeString = {
  singleRight: StaveConnector.type.SINGLE_RIGHT,
  singleLeft: StaveConnector.type.SINGLE_LEFT,
  single: StaveConnector.type.SINGLE,
  double: StaveConnector.type.DOUBLE,
  brace: StaveConnector.type.BRACE,
  bracket: StaveConnector.type.BRACKET,
  boldDoubleLeft: StaveConnector.type.BOLD_DOUBLE_LEFT,
  boldDoubleRight: StaveConnector.type.BOLD_DOUBLE_RIGHT,
  thinDouble: StaveConnector.type.THIN_DOUBLE,
  none: StaveConnector.type.NONE
};

// node_modules/vexflow/build/esm/src/formatter.js
function createContexts(voices, makeContext, addToContext) {
  if (voices.length == 0)
    return {
      map: {},
      array: [],
      list: [],
      resolutionMultiplier: 0
    };
  const tickToContextMap = {};
  const tickList = [];
  const contexts = [];
  const resolutionMultiplier = Formatter.getResolutionMultiplier(voices);
  voices.forEach((voice, voiceIndex) => {
    const ticksUsed = new Fraction(0, resolutionMultiplier);
    voice.getTickables().forEach((tickable) => {
      const integerTicks = ticksUsed.numerator;
      if (!tickToContextMap[integerTicks]) {
        const newContext = makeContext({ tickID: integerTicks });
        contexts.push(newContext);
        tickToContextMap[integerTicks] = newContext;
        tickList.push(integerTicks);
      }
      addToContext(tickable, tickToContextMap[integerTicks], voiceIndex);
      ticksUsed.add(tickable.getTicks());
    });
  });
  return {
    map: tickToContextMap,
    array: contexts,
    list: tickList.sort((a, b) => a - b),
    resolutionMultiplier
  };
}
function L17(...args) {
  if (Formatter.DEBUG)
    log("Vex.Flow.Formatter", args);
}
function getRestLineForNextNoteGroup(notes, currRestLine, currNoteIndex, compare) {
  let nextRestLine = currRestLine;
  for (let noteIndex = currNoteIndex + 1; noteIndex < notes.length; noteIndex++) {
    const note = notes[noteIndex];
    if (isNote(note) && !note.isRest() && !note.shouldIgnoreTicks()) {
      nextRestLine = note.getLineForRest();
      break;
    }
  }
  if (compare && currRestLine !== nextRestLine) {
    const top = Math.max(currRestLine, nextRestLine);
    const bot = Math.min(currRestLine, nextRestLine);
    nextRestLine = midLine(top, bot);
  }
  return nextRestLine;
}
var Formatter = class _Formatter {
  static SimpleFormat(notes, x = 0, { paddingBetween = 10 } = {}) {
    notes.reduce((accumulator, note) => {
      note.addToModifierContext(new ModifierContext());
      const tick = new TickContext().addTickable(note).preFormat();
      const metrics = tick.getMetrics();
      tick.setX(accumulator + metrics.totalLeftPx);
      return accumulator + tick.getWidth() + metrics.totalRightPx + paddingBetween;
    }, x);
  }
  static plotDebugging(ctx, formatter, xPos, y1, y2, options) {
    options = Object.assign({ stavePadding: Tables.currentMusicFont().lookupMetric("stave.padding") }, options);
    const x = xPos + options.stavePadding;
    const contextGaps = formatter.contextGaps;
    function stroke(x1, x2, color) {
      ctx.beginPath();
      ctx.setStrokeStyle(color);
      ctx.setFillStyle(color);
      ctx.setLineWidth(1);
      ctx.fillRect(x1, y1, Math.max(x2 - x1, 0), y2 - y1);
    }
    ctx.save();
    ctx.setFont(Font.SANS_SERIF, 8);
    contextGaps.gaps.forEach((gap) => {
      stroke(x + gap.x1, x + gap.x2, "rgba(100,200,100,0.4)");
      ctx.setFillStyle("green");
      ctx.fillText(Math.round(gap.x2 - gap.x1).toString(), x + gap.x1, y2 + 12);
    });
    ctx.setFillStyle("red");
    ctx.fillText(`Loss: ${(formatter.totalCost || 0).toFixed(2)} Shift: ${(formatter.totalShift || 0).toFixed(2)} Gap: ${contextGaps.total.toFixed(2)}`, x - 20, y2 + 27);
    ctx.restore();
  }
  static FormatAndDraw(ctx, stave, notes, params) {
    let options = {
      auto_beam: false,
      align_rests: false
    };
    if (typeof params === "object") {
      options = Object.assign(Object.assign({}, options), params);
    } else if (typeof params === "boolean") {
      options.auto_beam = params;
    }
    const voice = new Voice(Tables.TIME4_4).setMode(Voice.Mode.SOFT).addTickables(notes);
    const beams = options.auto_beam ? Beam.applyAndGetBeams(voice) : [];
    new _Formatter().joinVoices([voice]).formatToStave([voice], stave, { align_rests: options.align_rests, stave });
    voice.setStave(stave).draw(ctx, stave);
    beams.forEach((beam) => beam.setContext(ctx).draw());
    return voice.getBoundingBox();
  }
  static FormatAndDrawTab(ctx, tabstave, stave, tabnotes, notes, autobeam, params) {
    let opts = {
      auto_beam: autobeam,
      align_rests: false
    };
    if (typeof params === "object") {
      opts = Object.assign(Object.assign({}, opts), params);
    } else if (typeof params === "boolean") {
      opts.auto_beam = params;
    }
    const notevoice = new Voice(Tables.TIME4_4).setMode(Voice.Mode.SOFT).addTickables(notes);
    const tabvoice = new Voice(Tables.TIME4_4).setMode(Voice.Mode.SOFT).addTickables(tabnotes);
    const beams = opts.auto_beam ? Beam.applyAndGetBeams(notevoice) : [];
    new _Formatter().joinVoices([notevoice]).joinVoices([tabvoice]).formatToStave([notevoice, tabvoice], stave, { align_rests: opts.align_rests });
    notevoice.draw(ctx, stave);
    tabvoice.draw(ctx, tabstave);
    beams.forEach((beam) => beam.setContext(ctx).draw());
    new StaveConnector(stave, tabstave).setContext(ctx).draw();
  }
  static AlignRestsToNotes(tickables, alignAllNotes, alignTuplets) {
    tickables.forEach((currTickable, index) => {
      if (isStaveNote(currTickable) && currTickable.isRest()) {
        if (currTickable.getTuplet() && !alignTuplets) {
          return;
        }
        const position = currTickable.getGlyphProps().position.toUpperCase();
        if (position !== "R/4" && position !== "B/4") {
          return;
        }
        if (alignAllNotes || currTickable.getBeam()) {
          const props = currTickable.getKeyProps()[0];
          if (index === 0) {
            props.line = getRestLineForNextNoteGroup(tickables, props.line, index, false);
          } else if (index > 0 && index < tickables.length) {
            const prevTickable = tickables[index - 1];
            if (isStaveNote(prevTickable)) {
              if (prevTickable.isRest()) {
                props.line = prevTickable.getKeyProps()[0].line;
              } else {
                const restLine = prevTickable.getLineForRest();
                props.line = getRestLineForNextNoteGroup(tickables, restLine, index, true);
              }
            }
          }
          currTickable.setKeyLine(0, props.line);
        }
      }
    });
  }
  constructor(options) {
    this.formatterOptions = Object.assign({ globalSoftmax: false, softmaxFactor: Tables.SOFTMAX_FACTOR, maxIterations: 5 }, options);
    this.justifyWidth = 0;
    this.totalCost = 0;
    this.totalShift = 0;
    this.durationStats = {};
    this.minTotalWidth = 0;
    this.hasMinTotalWidth = false;
    this.tickContexts = {
      map: {},
      array: [],
      list: [],
      resolutionMultiplier: 0
    };
    this.modifierContexts = [];
    this.contextGaps = {
      total: 0,
      gaps: []
    };
    this.voices = [];
    this.lossHistory = [];
  }
  alignRests(voices, alignAllNotes) {
    if (!voices || !voices.length) {
      throw new RuntimeError("BadArgument", "No voices to format rests");
    }
    voices.forEach((voice) => _Formatter.AlignRestsToNotes(voice.getTickables(), alignAllNotes));
  }
  preCalculateMinTotalWidth(voices) {
    const unalignedPadding = Tables.currentMusicFont().lookupMetric("stave.unalignedNotePadding");
    let unalignedCtxCount = 0;
    let wsum = 0;
    let dsum = 0;
    const widths = [];
    const durations2 = [];
    if (this.hasMinTotalWidth)
      return this.minTotalWidth;
    if (!voices) {
      throw new RuntimeError("BadArgument", "'voices' required to run preCalculateMinTotalWidth");
    }
    this.createTickContexts(voices);
    const { list: contextList, map: contextMap } = this.tickContexts;
    this.minTotalWidth = 0;
    contextList.forEach((tick) => {
      const context = contextMap[tick];
      context.preFormat();
      if (context.getTickables().length < voices.length) {
        unalignedCtxCount += 1;
      }
      context.getTickables().forEach((t) => {
        wsum += t.getMetrics().width;
        dsum += t.getTicks().value();
        widths.push(t.getMetrics().width);
        durations2.push(t.getTicks().value());
      });
      const width = context.getWidth();
      this.minTotalWidth += width;
    });
    this.hasMinTotalWidth = true;
    const wavg = wsum > 0 ? wsum / widths.length : 1 / widths.length;
    const wvar = sumArray(widths.map((ll) => Math.pow(ll - wavg, 2)));
    const wpads = Math.pow(wvar / widths.length, 0.5) / wavg;
    const davg = dsum / durations2.length;
    const dvar = sumArray(durations2.map((ll) => Math.pow(ll - davg, 2)));
    const dpads = Math.pow(dvar / durations2.length, 0.5) / davg;
    const padmax = Math.max(dpads, wpads) * contextList.length * unalignedPadding;
    const unalignedPad = unalignedPadding * unalignedCtxCount;
    return this.minTotalWidth + Math.max(unalignedPad, padmax);
  }
  getMinTotalWidth() {
    if (!this.hasMinTotalWidth) {
      throw new RuntimeError("NoMinTotalWidth", "Call 'preCalculateMinTotalWidth' or 'preFormat' before calling 'getMinTotalWidth'");
    }
    return this.minTotalWidth;
  }
  static getResolutionMultiplier(voices) {
    if (!voices || !voices.length) {
      throw new RuntimeError("BadArgument", "No voices to format");
    }
    const totalTicks = voices[0].getTotalTicks();
    const resolutionMultiplier = voices.reduce((accumulator, voice) => {
      if (!voice.getTotalTicks().equals(totalTicks)) {
        throw new RuntimeError("TickMismatch", "Voices should have same total note duration in ticks.");
      }
      if (voice.getMode() === Voice.Mode.STRICT && !voice.isComplete()) {
        throw new RuntimeError("IncompleteVoice", "Voice does not have enough notes.");
      }
      return Math.max(accumulator, Fraction.LCM(accumulator, voice.getResolutionMultiplier()));
    }, 1);
    return resolutionMultiplier;
  }
  createModifierContexts(voices) {
    if (voices.length == 0)
      return;
    const resolutionMultiplier = _Formatter.getResolutionMultiplier(voices);
    const tickToContextMap = /* @__PURE__ */ new Map();
    const contexts = [];
    voices.forEach((voice) => {
      const ticksUsed = new Fraction(0, resolutionMultiplier);
      voice.getTickables().forEach((tickable) => {
        const integerTicks = ticksUsed.numerator;
        let staveTickToContextMap = tickToContextMap.get(tickable.getStave());
        if (!staveTickToContextMap) {
          tickToContextMap.set(tickable.getStave(), {});
          staveTickToContextMap = tickToContextMap.get(tickable.getStave());
        }
        if (!(staveTickToContextMap ? staveTickToContextMap[integerTicks] : void 0)) {
          const newContext = new ModifierContext();
          contexts.push(newContext);
          staveTickToContextMap[integerTicks] = newContext;
        }
        tickable.addToModifierContext(staveTickToContextMap[integerTicks]);
        ticksUsed.add(tickable.getTicks());
      });
    });
    this.modifierContexts.push({
      map: tickToContextMap,
      array: contexts,
      resolutionMultiplier
    });
  }
  createTickContexts(voices) {
    const fn = (tickable, context, voiceIndex) => context.addTickable(tickable, voiceIndex);
    const contexts = createContexts(voices, (tick) => new TickContext(tick), fn);
    this.tickContexts = contexts;
    const contextArray = this.tickContexts.array;
    contextArray.forEach((context) => {
      context.tContexts = contextArray;
    });
    return contexts;
  }
  getTickContexts() {
    return this.tickContexts;
  }
  preFormat(justifyWidth = 0, renderingContext, voicesParam, stave) {
    const contexts = this.tickContexts;
    if (!contexts) {
      throw new RuntimeError("NoTickContexts", "preFormat requires TickContexts");
    }
    const { list: contextList, map: contextMap } = contexts;
    this.lossHistory = [];
    if (voicesParam && stave) {
      voicesParam.forEach((voice) => voice.setStave(stave).preFormat());
    }
    let x = 0;
    let shift = 0;
    this.minTotalWidth = 0;
    let totalTicks = 0;
    contextList.forEach((tick) => {
      const context = contextMap[tick];
      context.preFormat();
      const width = context.getWidth();
      this.minTotalWidth += width;
      const maxTicks = context.getMaxTicks().value();
      totalTicks += maxTicks;
      const metrics = context.getMetrics();
      x = x + shift + metrics.totalLeftPx;
      context.setX(x);
      shift = width - metrics.totalLeftPx;
    });
    const { globalSoftmax, softmaxFactor, maxIterations } = this.formatterOptions;
    const exp = (tick) => Math.pow(softmaxFactor, contextMap[tick].getMaxTicks().value() / totalTicks);
    const expTicksUsed = sumArray(contextList.map(exp));
    this.minTotalWidth = x + shift;
    this.hasMinTotalWidth = true;
    if (justifyWidth <= 0)
      return this.evaluate();
    const firstContext = contextMap[contextList[0]];
    const lastContext = contextMap[contextList[contextList.length - 1]];
    function calculateIdealDistances(adjustedJustifyWidth2) {
      const distances2 = contextList.map((tick, i) => {
        const context = contextMap[tick];
        const voices = context.getTickablesByVoice();
        let backTickable;
        if (i > 0) {
          const prevContext = contextMap[contextList[i - 1]];
          for (let j = i - 1; j >= 0; j--) {
            const backTick = contextMap[contextList[j]];
            const backVoices = backTick.getTickablesByVoice();
            const matchingVoices = [];
            Object.keys(voices).forEach((v) => {
              if (backVoices[v]) {
                matchingVoices.push(v);
              }
            });
            if (matchingVoices.length > 0) {
              let maxTicks = 0;
              let maxNegativeShiftPx = Infinity;
              let expectedDistance = 0;
              matchingVoices.forEach((v) => {
                const ticks = backVoices[v].getTicks().value();
                if (ticks > maxTicks) {
                  backTickable = backVoices[v];
                  maxTicks = ticks;
                }
                const thisTickable = voices[v];
                const insideLeftEdge = thisTickable.getX() - (thisTickable.getMetrics().modLeftPx + thisTickable.getMetrics().leftDisplacedHeadPx);
                const backMetrics = backVoices[v].getMetrics();
                const insideRightEdge = backVoices[v].getX() + backMetrics.notePx + backMetrics.modRightPx + backMetrics.rightDisplacedHeadPx;
                maxNegativeShiftPx = Math.min(maxNegativeShiftPx, insideLeftEdge - insideRightEdge);
              });
              maxNegativeShiftPx = Math.min(maxNegativeShiftPx, context.getX() - (prevContext.getX() + adjustedJustifyWidth2 * 0.05));
              if (globalSoftmax) {
                const t = totalTicks;
                expectedDistance = Math.pow(softmaxFactor, maxTicks / t) / expTicksUsed * adjustedJustifyWidth2;
              } else if (typeof backTickable !== "undefined") {
                expectedDistance = backTickable.getVoice().softmax(maxTicks) * adjustedJustifyWidth2;
              }
              return {
                expectedDistance,
                maxNegativeShiftPx,
                fromTickable: backTickable
              };
            }
          }
        }
        return { expectedDistance: 0, fromTickablePx: 0, maxNegativeShiftPx: 0 };
      });
      return distances2;
    }
    function shiftToIdealDistances(idealDistances) {
      const centerX = adjustedJustifyWidth / 2;
      let spaceAccum = 0;
      contextList.forEach((tick, index) => {
        const context = contextMap[tick];
        if (index > 0) {
          const contextX = context.getX();
          const ideal = idealDistances[index];
          const errorPx = defined(ideal.fromTickable).getX() + ideal.expectedDistance - (contextX + spaceAccum);
          let negativeShiftPx = 0;
          if (errorPx > 0) {
            spaceAccum += errorPx;
          } else if (errorPx < 0) {
            negativeShiftPx = Math.min(ideal.maxNegativeShiftPx, Math.abs(errorPx));
            spaceAccum += -negativeShiftPx;
          }
          context.setX(contextX + spaceAccum);
        }
        context.getCenterAlignedTickables().forEach((tickable) => {
          tickable.setCenterXShift(centerX - context.getX());
        });
      });
      return lastContext.getX() - firstContext.getX();
    }
    const adjustedJustifyWidth = justifyWidth - lastContext.getMetrics().notePx - lastContext.getMetrics().totalRightPx - firstContext.getMetrics().totalLeftPx;
    const musicFont = Tables.currentMusicFont();
    const configMinPadding = musicFont.lookupMetric("stave.endPaddingMin");
    const configMaxPadding = musicFont.lookupMetric("stave.endPaddingMax");
    const leftPadding = musicFont.lookupMetric("stave.padding");
    let targetWidth = adjustedJustifyWidth;
    const distances = calculateIdealDistances(targetWidth);
    let actualWidth = shiftToIdealDistances(distances);
    if (contextList.length === 1)
      return 0;
    const calcMinDistance = (targetWidth2, distances2) => {
      let mdCalc = targetWidth2 / 2;
      if (distances2.length > 1) {
        for (let di = 1; di < distances2.length; ++di) {
          mdCalc = Math.min(distances2[di].expectedDistance / 2, mdCalc);
        }
      }
      return mdCalc;
    };
    const minDistance = calcMinDistance(targetWidth, distances);
    const paddingMaxCalc = (curTargetWidth) => {
      let lastTickablePadding = 0;
      const lastTickable = lastContext && lastContext.getMaxTickable();
      if (lastTickable) {
        const voice = lastTickable.getVoice();
        if (voice.getTicksUsed().value() > voice.getTotalTicks().value()) {
          return configMaxPadding * 2 < minDistance ? minDistance : configMaxPadding;
        }
        const tickWidth = lastTickable.getWidth();
        lastTickablePadding = voice.softmax(lastContext.getMaxTicks().value()) * curTargetWidth - (tickWidth + leftPadding);
      }
      return configMaxPadding * 2 < lastTickablePadding ? lastTickablePadding : configMaxPadding;
    };
    let paddingMax = paddingMaxCalc(targetWidth);
    let paddingMin = paddingMax - (configMaxPadding - configMinPadding);
    const maxX = adjustedJustifyWidth - paddingMin;
    let iterations = maxIterations;
    while (actualWidth > maxX && iterations > 0 || actualWidth + paddingMax < maxX && iterations > 1) {
      targetWidth -= actualWidth - maxX;
      paddingMax = paddingMaxCalc(targetWidth);
      paddingMin = paddingMax - (configMaxPadding - configMinPadding);
      actualWidth = shiftToIdealDistances(calculateIdealDistances(targetWidth));
      iterations--;
    }
    this.justifyWidth = justifyWidth;
    return this.evaluate();
  }
  evaluate() {
    const contexts = this.tickContexts;
    const justifyWidth = this.justifyWidth;
    this.contextGaps = { total: 0, gaps: [] };
    contexts.list.forEach((tick, index) => {
      if (index === 0)
        return;
      const prevTick = contexts.list[index - 1];
      const prevContext = contexts.map[prevTick];
      const context = contexts.map[tick];
      const prevMetrics = prevContext.getMetrics();
      const currMetrics = context.getMetrics();
      const insideRightEdge = prevContext.getX() + prevMetrics.notePx + prevMetrics.totalRightPx;
      const insideLeftEdge = context.getX() - currMetrics.totalLeftPx;
      const gap = insideLeftEdge - insideRightEdge;
      this.contextGaps.total += gap;
      this.contextGaps.gaps.push({ x1: insideRightEdge, x2: insideLeftEdge });
      context.getFormatterMetrics().freedom.left = gap;
      prevContext.getFormatterMetrics().freedom.right = gap;
    });
    this.durationStats = {};
    const durationStats = this.durationStats;
    function updateStats(duration, space) {
      const stats = durationStats[duration];
      if (stats === void 0) {
        durationStats[duration] = { mean: space, count: 1 };
      } else {
        stats.count += 1;
        stats.mean = (stats.mean + space) / 2;
      }
    }
    this.voices.forEach((voice) => {
      voice.getTickables().forEach((note, i, notes) => {
        const duration = note.getTicks().clone().simplify().toString();
        const metrics = note.getMetrics();
        const formatterMetrics = note.getFormatterMetrics();
        const leftNoteEdge = note.getX() + metrics.notePx + metrics.modRightPx + metrics.rightDisplacedHeadPx;
        let space = 0;
        if (i < notes.length - 1) {
          const rightNote = notes[i + 1];
          const rightMetrics = rightNote.getMetrics();
          const rightNoteEdge = rightNote.getX() - rightMetrics.modLeftPx - rightMetrics.leftDisplacedHeadPx;
          space = rightNoteEdge - leftNoteEdge;
          formatterMetrics.space.used = rightNote.getX() - note.getX();
          rightNote.getFormatterMetrics().freedom.left = space;
        } else {
          space = justifyWidth - leftNoteEdge;
          formatterMetrics.space.used = justifyWidth - note.getX();
        }
        formatterMetrics.freedom.right = space;
        updateStats(duration, formatterMetrics.space.used);
      });
    });
    let totalDeviation = 0;
    this.voices.forEach((voice) => {
      voice.getTickables().forEach((note) => {
        const duration = note.getTicks().clone().simplify().toString();
        const metrics = note.getFormatterMetrics();
        metrics.space.mean = durationStats[duration].mean;
        metrics.duration = duration;
        metrics.iterations += 1;
        metrics.space.deviation = metrics.space.used - metrics.space.mean;
        totalDeviation += Math.pow(metrics.space.deviation, 2);
      });
    });
    this.totalCost = Math.sqrt(totalDeviation);
    this.lossHistory.push(this.totalCost);
    return this.totalCost;
  }
  tune(options) {
    var _a;
    const contexts = this.tickContexts;
    if (!contexts) {
      return 0;
    }
    const alpha = (_a = options === null || options === void 0 ? void 0 : options.alpha) !== null && _a !== void 0 ? _a : 0.5;
    function move(current, shift2, prev, next) {
      current.setX(current.getX() + shift2);
      current.getFormatterMetrics().freedom.left += shift2;
      current.getFormatterMetrics().freedom.right -= shift2;
      if (prev)
        prev.getFormatterMetrics().freedom.right += shift2;
      if (next)
        next.getFormatterMetrics().freedom.left -= shift2;
    }
    let shift = 0;
    this.totalShift = 0;
    contexts.list.forEach((tick, index, list) => {
      const context = contexts.map[tick];
      const prevContext = index > 0 ? contexts.map[list[index - 1]] : void 0;
      const nextContext = index < list.length - 1 ? contexts.map[list[index + 1]] : void 0;
      move(context, shift, prevContext, nextContext);
      const cost = -sumArray(context.getTickables().map((t) => t.getFormatterMetrics().space.deviation));
      if (cost > 0) {
        shift = -Math.min(context.getFormatterMetrics().freedom.right, Math.abs(cost));
      } else if (cost < 0) {
        if (nextContext) {
          shift = Math.min(nextContext.getFormatterMetrics().freedom.right, Math.abs(cost));
        } else {
          shift = 0;
        }
      }
      shift *= alpha;
      this.totalShift += shift;
    });
    return this.evaluate();
  }
  postFormat() {
    this.modifierContexts.forEach((modifierContexts) => {
      modifierContexts.array.forEach((mc) => mc.postFormat());
    });
    this.tickContexts.list.forEach((tick) => {
      this.tickContexts.map[tick].postFormat();
    });
    return this;
  }
  joinVoices(voices) {
    this.createModifierContexts(voices);
    this.hasMinTotalWidth = false;
    return this;
  }
  format(voices, justifyWidth, options) {
    const opts = Object.assign({ align_rests: false }, options);
    this.voices = voices;
    const softmaxFactor = this.formatterOptions.softmaxFactor;
    if (softmaxFactor) {
      this.voices.forEach((v) => v.setSoftmaxFactor(softmaxFactor));
    }
    this.alignRests(voices, opts.align_rests);
    this.createTickContexts(voices);
    this.preFormat(justifyWidth, opts.context, voices, opts.stave);
    if (opts.stave)
      this.postFormat();
    return this;
  }
  formatToStave(voices, stave, optionsParam) {
    const options = Object.assign({ context: stave.getContext() }, optionsParam);
    const justifyWidth = stave.getNoteEndX() - stave.getNoteStartX() - Stave.defaultPadding;
    L17("Formatting voices to width: ", justifyWidth);
    return this.format(voices, justifyWidth, options);
  }
  getTickContext(tick) {
    var _a;
    return (_a = this.tickContexts) === null || _a === void 0 ? void 0 : _a.map[tick];
  }
};
Formatter.DEBUG = false;

// node_modules/vexflow/build/esm/src/ghostnote.js
var ERROR_MSG = "Ghost note must have valid initialization data to identify duration.";
var GhostNote = class extends StemmableNote {
  static get CATEGORY() {
    return "GhostNote";
  }
  constructor(parameter) {
    if (!parameter) {
      throw new RuntimeError("BadArguments", ERROR_MSG);
    }
    let noteStruct;
    if (typeof parameter === "string") {
      noteStruct = { duration: parameter };
    } else if (typeof parameter === "object") {
      noteStruct = parameter;
    } else {
      throw new RuntimeError("BadArguments", ERROR_MSG);
    }
    super(noteStruct);
    this.setWidth(0);
  }
  isRest() {
    return true;
  }
  setStave(stave) {
    super.setStave(stave);
    return this;
  }
  addToModifierContext(mc) {
    return this;
  }
  preFormat() {
    this.preFormatted = true;
    return this;
  }
  draw() {
    this.setRendered();
    for (let i = 0; i < this.modifiers.length; ++i) {
      const modifier = this.modifiers[i];
      if (isAnnotation(modifier)) {
        modifier.setContext(this.getContext());
        modifier.drawWithStyle();
      }
    }
  }
};

// node_modules/vexflow/build/esm/src/glyphnote.js
var GlyphNote = class extends Note {
  static get CATEGORY() {
    return "GlyphNote";
  }
  constructor(glyph, noteStruct, options) {
    super(noteStruct);
    this.options = Object.assign({ ignoreTicks: false, line: 2 }, options);
    this.ignore_ticks = this.options.ignoreTicks;
    this.setGlyph(glyph);
  }
  setGlyph(glyph) {
    this.glyph = glyph;
    this.setWidth(this.glyph.getMetrics().width);
    return this;
  }
  getBoundingBox() {
    return this.glyph.getBoundingBox();
  }
  preFormat() {
    if (!this.preFormatted && this.modifierContext) {
      this.modifierContext.preFormat();
    }
    this.preFormatted = true;
    return this;
  }
  drawModifiers() {
    const ctx = this.checkContext();
    for (let i = 0; i < this.modifiers.length; i++) {
      const modifier = this.modifiers[i];
      modifier.setContext(ctx);
      modifier.drawWithStyle();
    }
  }
  getGlyphWidth() {
    return this.glyph.getMetrics().width;
  }
  draw() {
    const stave = this.checkStave();
    const ctx = stave.checkContext();
    this.setRendered();
    this.applyStyle(ctx);
    ctx.openGroup("glyphNote", this.getAttribute("id"));
    const glyph = this.glyph;
    if (!glyph.getContext()) {
      glyph.setContext(ctx);
    }
    glyph.setStave(stave);
    glyph.setYShift(stave.getYForLine(this.options.line) - stave.getYForGlyphs());
    const x = this.isCenterAligned() ? this.getAbsoluteX() - this.getWidth() / 2 : this.getAbsoluteX();
    glyph.renderToStave(x);
    this.drawModifiers();
    ctx.closeGroup();
    this.restoreStyle(ctx);
  }
};

// node_modules/vexflow/build/esm/src/gracenote.js
var GraceNote = class _GraceNote extends StaveNote {
  static get CATEGORY() {
    return "GraceNote";
  }
  static get LEDGER_LINE_OFFSET() {
    return 2;
  }
  static get SCALE() {
    return 0.66;
  }
  constructor(noteStruct) {
    super(Object.assign({ glyph_font_scale: Tables.NOTATION_FONT_SCALE * _GraceNote.SCALE, stroke_px: _GraceNote.LEDGER_LINE_OFFSET }, noteStruct));
    this.slash = noteStruct.slash || false;
    this.slur = true;
    this.buildNoteHeads();
    this.width = 3;
  }
  getStemExtension() {
    if (this.stem_extension_override) {
      return this.stem_extension_override;
    }
    const glyphProps = this.getGlyphProps();
    if (glyphProps) {
      let ret = super.getStemExtension();
      if (glyphProps.stem) {
        const staveNoteScale = this.getStaveNoteScale();
        ret = (Stem.HEIGHT + ret) * staveNoteScale - Stem.HEIGHT;
      }
      return ret;
    }
    return 0;
  }
  getStaveNoteScale() {
    return this.render_options.glyph_font_scale / Tables.NOTATION_FONT_SCALE;
  }
  draw() {
    super.draw();
    this.setRendered();
    const stem = this.stem;
    if (this.slash && stem) {
      const staveNoteScale = this.getStaveNoteScale();
      const offsetScale = staveNoteScale / 0.66;
      let slashBBox = void 0;
      const beam = this.beam;
      if (beam) {
        if (!beam.postFormatted) {
          beam.postFormat();
        }
        slashBBox = this.calcBeamedNotesSlashBBox(8 * offsetScale, 8 * offsetScale, {
          stem: 6 * offsetScale,
          beam: 5 * offsetScale
        });
      } else {
        const stem_direction = this.getStemDirection();
        const noteHeadBounds = this.getNoteHeadBounds();
        const noteStemHeight = stem.getHeight();
        let x = this.getAbsoluteX();
        let y = stem_direction === Stem.DOWN ? noteHeadBounds.y_top - noteStemHeight : noteHeadBounds.y_bottom - noteStemHeight;
        const defaultStemExtention = stem_direction === Stem.DOWN ? this.glyphProps.stem_down_extension : this.glyphProps.stem_up_extension;
        let defaultOffsetY = Tables.STEM_HEIGHT;
        defaultOffsetY -= defaultOffsetY / 2.8;
        defaultOffsetY += defaultStemExtention;
        y += defaultOffsetY * staveNoteScale * stem_direction;
        const offsets = stem_direction === Stem.UP ? {
          x1: 1,
          y1: 0,
          x2: 13,
          y2: -9
        } : {
          x1: -4,
          y1: 1,
          x2: 13,
          y2: 9
        };
        x += offsets.x1 * offsetScale;
        y += offsets.y1 * offsetScale;
        slashBBox = {
          x1: x,
          y1: y,
          x2: x + offsets.x2 * offsetScale,
          y2: y + offsets.y2 * offsetScale
        };
      }
      const ctx = this.checkContext();
      ctx.save();
      ctx.setLineWidth(1 * offsetScale);
      ctx.beginPath();
      ctx.moveTo(slashBBox.x1, slashBBox.y1);
      ctx.lineTo(slashBBox.x2, slashBBox.y2);
      ctx.closePath();
      ctx.stroke();
      ctx.restore();
    }
  }
  calcBeamedNotesSlashBBox(slashStemOffset, slashBeamOffset, protrusions) {
    const beam = this.beam;
    if (!beam)
      throw new RuntimeError("NoBeam", "Can't calculate without a beam.");
    const beam_slope = beam.slope;
    const isBeamEndNote = beam.notes[beam.notes.length - 1] === this;
    const scaleX = isBeamEndNote ? -1 : 1;
    const beam_angle = Math.atan(beam_slope * scaleX);
    const iPointOnBeam = {
      dx: Math.cos(beam_angle) * slashBeamOffset,
      dy: Math.sin(beam_angle) * slashBeamOffset
    };
    slashStemOffset *= this.getStemDirection();
    const slash_angle = Math.atan((iPointOnBeam.dy - slashStemOffset) / iPointOnBeam.dx);
    const protrusion_stem_dx = Math.cos(slash_angle) * protrusions.stem * scaleX;
    const protrusion_stem_dy = Math.sin(slash_angle) * protrusions.stem;
    const protrusion_beam_dx = Math.cos(slash_angle) * protrusions.beam * scaleX;
    const protrusion_beam_dy = Math.sin(slash_angle) * protrusions.beam;
    const stemX = this.getStemX();
    const stem0X = beam.notes[0].getStemX();
    const stemY = beam.getBeamYToDraw() + (stemX - stem0X) * beam_slope;
    const ret = {
      x1: stemX - protrusion_stem_dx,
      y1: stemY + slashStemOffset - protrusion_stem_dy,
      x2: stemX + iPointOnBeam.dx * scaleX + protrusion_beam_dx,
      y2: stemY + iPointOnBeam.dy + protrusion_beam_dy
    };
    return ret;
  }
};

// node_modules/vexflow/build/esm/src/keysignote.js
var KeySigNote = class extends Note {
  static get CATEGORY() {
    return "KeySigNote";
  }
  constructor(keySpec, cancelKeySpec, alterKeySpec) {
    super({ duration: "b" });
    this.keySignature = new KeySignature(keySpec, cancelKeySpec, alterKeySpec);
    this.ignore_ticks = true;
  }
  addToModifierContext(mc) {
    return this;
  }
  preFormat() {
    this.preFormatted = true;
    this.keySignature.setStave(this.checkStave());
    this.setWidth(this.keySignature.getWidth());
    return this;
  }
  draw() {
    const ctx = this.checkStave().checkContext();
    this.setRendered();
    this.keySignature.setX(this.getAbsoluteX());
    this.keySignature.setContext(ctx);
    this.keySignature.draw();
  }
};

// node_modules/vexflow/build/esm/src/multimeasurerest.js
var semibreve_rest;
function get_semibreve_rest() {
  if (!semibreve_rest) {
    const noteHead = new NoteHead({ duration: "w", note_type: "r" });
    semibreve_rest = {
      glyph_font_scale: noteHead.render_options.glyph_font_scale,
      glyph_code: noteHead.glyph_code,
      width: noteHead.getWidth()
    };
  }
  return semibreve_rest;
}
var MultiMeasureRest = class extends Element {
  static get CATEGORY() {
    return "MultiMeasureRest";
  }
  constructor(number_of_measures, options) {
    var _a;
    super();
    this.xs = { left: NaN, right: NaN };
    this.hasPaddingLeft = false;
    this.hasPaddingRight = false;
    this.hasLineThickness = false;
    this.hasSymbolSpacing = false;
    this.number_of_measures = number_of_measures;
    this.hasPaddingLeft = typeof options.padding_left === "number";
    this.hasPaddingRight = typeof options.padding_right === "number";
    this.hasLineThickness = typeof options.line_thickness === "number";
    this.hasSymbolSpacing = typeof options.symbol_spacing === "number";
    const musicFont = Tables.currentMusicFont();
    this.render_options = Object.assign({ use_symbols: false, show_number: true, number_line: -0.5, number_glyph_point: (_a = musicFont.lookupMetric("digits.point")) !== null && _a !== void 0 ? _a : Tables.NOTATION_FONT_SCALE, line: 2, spacing_between_lines_px: Tables.STAVE_LINE_DISTANCE, serif_thickness: 2, semibreve_rest_glyph_scale: Tables.NOTATION_FONT_SCALE, padding_left: 0, padding_right: 0, line_thickness: 5, symbol_spacing: 0 }, options);
    const fontLineShift = musicFont.lookupMetric("digits.shiftLine", 0);
    this.render_options.number_line += fontLineShift;
  }
  getXs() {
    return this.xs;
  }
  setStave(stave) {
    this.stave = stave;
    return this;
  }
  getStave() {
    return this.stave;
  }
  checkStave() {
    return defined(this.stave, "NoStave", "No stave attached to instance.");
  }
  drawLine(stave, ctx, left, right, spacingBetweenLines) {
    const options = this.render_options;
    const y = stave.getYForLine(options.line);
    const padding = (right - left) * 0.1;
    left += padding;
    right -= padding;
    let lineThicknessHalf;
    if (this.hasLineThickness) {
      lineThicknessHalf = options.line_thickness * 0.5;
    } else {
      lineThicknessHalf = spacingBetweenLines * 0.25;
    }
    const serifThickness = options.serif_thickness;
    const top = y - spacingBetweenLines;
    const bot = y + spacingBetweenLines;
    const leftIndented = left + serifThickness;
    const rightIndented = right - serifThickness;
    const lineTop = y - lineThicknessHalf;
    const lineBottom = y + lineThicknessHalf;
    ctx.save();
    ctx.beginPath();
    ctx.moveTo(left, top);
    ctx.lineTo(leftIndented, top);
    ctx.lineTo(leftIndented, lineTop);
    ctx.lineTo(rightIndented, lineTop);
    ctx.lineTo(rightIndented, top);
    ctx.lineTo(right, top);
    ctx.lineTo(right, bot);
    ctx.lineTo(rightIndented, bot);
    ctx.lineTo(rightIndented, lineBottom);
    ctx.lineTo(leftIndented, lineBottom);
    ctx.lineTo(leftIndented, bot);
    ctx.lineTo(left, bot);
    ctx.closePath();
    ctx.fill();
  }
  drawSymbols(stave, ctx, left, right, spacingBetweenLines) {
    const n4 = Math.floor(this.number_of_measures / 4);
    const n = this.number_of_measures % 4;
    const n2 = Math.floor(n / 2);
    const n1 = n % 2;
    const options = this.render_options;
    semibreve_rest = void 0;
    const rest = get_semibreve_rest();
    const rest_scale = options.semibreve_rest_glyph_scale;
    const rest_width = rest.width * (rest_scale / rest.glyph_font_scale);
    const glyphs = {
      2: {
        width: rest_width * 0.5,
        height: spacingBetweenLines
      },
      1: {
        width: rest_width
      }
    };
    const spacing = this.hasSymbolSpacing ? options.symbol_spacing : 10;
    const width = n4 * glyphs[2].width + n2 * glyphs[2].width + n1 * glyphs[1].width + (n4 + n2 + n1 - 1) * spacing;
    let x = left + (right - left) * 0.5 - width * 0.5;
    const line = options.line;
    const yTop = stave.getYForLine(line - 1);
    const yMiddle = stave.getYForLine(line);
    const yBottom = stave.getYForLine(line + 1);
    ctx.save();
    ctx.setStrokeStyle("none");
    ctx.setLineWidth(0);
    for (let i = 0; i < n4; ++i) {
      ctx.fillRect(x, yMiddle - glyphs[2].height, glyphs[2].width, glyphs[2].height);
      ctx.fillRect(x, yBottom - glyphs[2].height, glyphs[2].width, glyphs[2].height);
      x += glyphs[2].width + spacing;
    }
    for (let i = 0; i < n2; ++i) {
      ctx.fillRect(x, yMiddle - glyphs[2].height, glyphs[2].width, glyphs[2].height);
      x += glyphs[2].width + spacing;
    }
    for (let i = 0; i < n1; ++i) {
      Glyph.renderGlyph(ctx, x, yTop, rest_scale, rest.glyph_code);
      x += glyphs[1].width + spacing;
    }
    ctx.restore();
  }
  draw() {
    const ctx = this.checkContext();
    this.setRendered();
    const stave = this.checkStave();
    let left = stave.getNoteStartX();
    let right = stave.getNoteEndX();
    const begModifiers = stave.getModifiers(StaveModifierPosition.BEGIN);
    if (begModifiers.length === 1 && isBarline(begModifiers[0])) {
      left -= begModifiers[0].getWidth();
    }
    const options = this.render_options;
    if (this.hasPaddingLeft) {
      left = stave.getX() + options.padding_left;
    }
    if (this.hasPaddingRight) {
      right = stave.getX() + stave.getWidth() - options.padding_right;
    }
    this.xs.left = left;
    this.xs.right = right;
    const spacingBetweenLines = options.spacing_between_lines_px;
    if (options.use_symbols) {
      this.drawSymbols(stave, ctx, left, right, spacingBetweenLines);
    } else {
      this.drawLine(stave, ctx, left, right, spacingBetweenLines);
    }
    if (options.show_number) {
      const timeSpec = "/" + this.number_of_measures;
      const timeSig = new TimeSignature(timeSpec, 0, false);
      timeSig.point = options.number_glyph_point;
      timeSig.setTimeSig(timeSpec);
      timeSig.setStave(stave);
      timeSig.setX(left + (right - left) * 0.5 - timeSig.getInfo().glyph.getMetrics().width * 0.5);
      timeSig.bottomLine = options.number_line;
      timeSig.setContext(ctx).draw();
    }
  }
};

// node_modules/vexflow/build/esm/src/pedalmarking.js
function L18(...args) {
  if (PedalMarking.DEBUG)
    log("Vex.Flow.PedalMarking", args);
}
function drawPedalGlyph(name, context, x, y, point) {
  const glyph_data = PedalMarking.GLYPHS[name];
  const glyph = new Glyph(glyph_data.code, point, { category: "pedalMarking" });
  glyph.render(context, x - (glyph.getMetrics().width - Tables.STAVE_LINE_DISTANCE) / 2, y);
}
var PedalMarking = class _PedalMarking extends Element {
  static get CATEGORY() {
    return "PedalMarking";
  }
  static createSustain(notes) {
    const pedal = new _PedalMarking(notes);
    return pedal;
  }
  static createSostenuto(notes) {
    const pedal = new _PedalMarking(notes);
    pedal.setType(_PedalMarking.type.MIXED);
    pedal.setCustomText("Sost. Ped.");
    return pedal;
  }
  static createUnaCorda(notes) {
    const pedal = new _PedalMarking(notes);
    pedal.setType(_PedalMarking.type.TEXT);
    pedal.setCustomText("una corda", "tre corda");
    return pedal;
  }
  constructor(notes) {
    super();
    this.notes = notes;
    this.type = _PedalMarking.type.TEXT;
    this.line = 0;
    this.custom_depress_text = "";
    this.custom_release_text = "";
    this.resetFont();
    this.render_options = {
      bracket_height: 10,
      text_margin_right: 6,
      bracket_line_width: 1,
      color: "black"
    };
  }
  setType(type) {
    type = typeof type === "string" ? _PedalMarking.typeString[type] : type;
    if (type >= _PedalMarking.type.TEXT && type <= _PedalMarking.type.MIXED) {
      this.type = type;
    }
    return this;
  }
  setCustomText(depress, release) {
    this.custom_depress_text = depress || "";
    this.custom_release_text = release || "";
    return this;
  }
  setLine(line) {
    this.line = line;
    return this;
  }
  drawBracketed() {
    const ctx = this.checkContext();
    let is_pedal_depressed = false;
    let prev_x;
    let prev_y;
    this.notes.forEach((note, index, notes) => {
      var _a;
      is_pedal_depressed = !is_pedal_depressed;
      const x = note.getAbsoluteX();
      const y = note.checkStave().getYForBottomText(this.line + 3);
      if (x < prev_x) {
        throw new RuntimeError("InvalidConfiguration", "The notes provided must be in order of ascending x positions");
      }
      const next_is_same = notes[index + 1] === note;
      const prev_is_same = notes[index - 1] === note;
      let x_shift = 0;
      const point = (_a = Tables.currentMusicFont().lookupMetric(`pedalMarking.${is_pedal_depressed ? "down" : "up"}.point`)) !== null && _a !== void 0 ? _a : Tables.NOTATION_FONT_SCALE;
      if (is_pedal_depressed) {
        x_shift = prev_is_same ? 5 : 0;
        if (this.type === _PedalMarking.type.MIXED && !prev_is_same) {
          if (this.custom_depress_text) {
            const text_width = ctx.measureText(this.custom_depress_text).width;
            ctx.fillText(this.custom_depress_text, x - text_width / 2, y);
            x_shift = text_width / 2 + this.render_options.text_margin_right;
          } else {
            drawPedalGlyph("pedal_depress", ctx, x, y, point);
            x_shift = 20 + this.render_options.text_margin_right;
          }
        } else {
          ctx.beginPath();
          ctx.moveTo(x, y - this.render_options.bracket_height);
          ctx.lineTo(x + x_shift, y);
          ctx.stroke();
          ctx.closePath();
        }
      } else {
        x_shift = next_is_same ? -5 : 0;
        ctx.beginPath();
        ctx.moveTo(prev_x, prev_y);
        ctx.lineTo(x + x_shift, y);
        ctx.lineTo(x, y - this.render_options.bracket_height);
        ctx.stroke();
        ctx.closePath();
      }
      prev_x = x + x_shift;
      prev_y = y;
    });
  }
  drawText() {
    const ctx = this.checkContext();
    let is_pedal_depressed = false;
    this.notes.forEach((note) => {
      var _a;
      is_pedal_depressed = !is_pedal_depressed;
      const stave = note.checkStave();
      const x = note.getAbsoluteX();
      const y = stave.getYForBottomText(this.line + 3);
      const point = (_a = Tables.currentMusicFont().lookupMetric(`pedalMarking.${is_pedal_depressed ? "down" : "up"}.point`)) !== null && _a !== void 0 ? _a : Tables.NOTATION_FONT_SCALE;
      let text_width = 0;
      if (is_pedal_depressed) {
        if (this.custom_depress_text) {
          text_width = ctx.measureText(this.custom_depress_text).width;
          ctx.fillText(this.custom_depress_text, x - text_width / 2, y);
        } else {
          drawPedalGlyph("pedal_depress", ctx, x, y, point);
        }
      } else {
        if (this.custom_release_text) {
          text_width = ctx.measureText(this.custom_release_text).width;
          ctx.fillText(this.custom_release_text, x - text_width / 2, y);
        } else {
          drawPedalGlyph("pedal_release", ctx, x, y, point);
        }
      }
    });
  }
  draw() {
    const ctx = this.checkContext();
    this.setRendered();
    ctx.save();
    ctx.setStrokeStyle(this.render_options.color);
    ctx.setFillStyle(this.render_options.color);
    ctx.setFont(this.textFont);
    L18("Rendering Pedal Marking");
    if (this.type === _PedalMarking.type.BRACKET || this.type === _PedalMarking.type.MIXED) {
      ctx.setLineWidth(this.render_options.bracket_line_width);
      this.drawBracketed();
    } else if (this.type === _PedalMarking.type.TEXT) {
      this.drawText();
    }
    ctx.restore();
  }
};
PedalMarking.DEBUG = false;
PedalMarking.TEXT_FONT = {
  family: Font.SERIF,
  size: 12,
  weight: FontWeight.BOLD,
  style: FontStyle.ITALIC
};
PedalMarking.GLYPHS = {
  pedal_depress: {
    code: "keyboardPedalPed"
  },
  pedal_release: {
    code: "keyboardPedalUp"
  }
};
PedalMarking.type = {
  TEXT: 1,
  BRACKET: 2,
  MIXED: 3
};
PedalMarking.typeString = {
  text: PedalMarking.type.TEXT,
  bracket: PedalMarking.type.BRACKET,
  mixed: PedalMarking.type.MIXED
};

// node_modules/vexflow/build/esm/src/repeatnote.js
var CODES = {
  "1": "repeat1Bar",
  "2": "repeat2Bars",
  "4": "repeat4Bars",
  slash: "repeatBarSlash"
};
var RepeatNote = class extends GlyphNote {
  static get CATEGORY() {
    return "RepeatNote";
  }
  constructor(type, noteStruct, options) {
    const glyphCode = CODES[type] || "repeat1Bar";
    const glyph = new Glyph(glyphCode, Tables.currentMusicFont().lookupMetric("repeatNote.point", 40), {
      category: "repeatNote"
    });
    super(glyph, Object.assign({ duration: "q", align_center: type !== "slash" }, noteStruct), options);
  }
};

// node_modules/vexflow/build/esm/src/staveline.js
function drawArrowHead(ctx, x0, y0, x1, y1, x2, y2) {
  ctx.beginPath();
  ctx.moveTo(x0, y0);
  ctx.lineTo(x1, y1);
  ctx.lineTo(x2, y2);
  ctx.lineTo(x0, y0);
  ctx.closePath();
  ctx.fill();
}
var StaveLine = class _StaveLine extends Element {
  static get CATEGORY() {
    return "StaveLine";
  }
  constructor(notes) {
    super();
    this.setNotes(notes);
    this.text = "";
    this.resetFont();
    this.render_options = {
      padding_left: 4,
      padding_right: 3,
      line_width: 1,
      line_dash: void 0,
      rounded_end: true,
      color: void 0,
      draw_start_arrow: false,
      draw_end_arrow: false,
      arrowhead_length: 10,
      arrowhead_angle: Math.PI / 8,
      text_position_vertical: _StaveLine.TextVerticalPosition.TOP,
      text_justification: _StaveLine.TextJustification.CENTER
    };
  }
  setText(text) {
    this.text = text;
    return this;
  }
  setNotes(notes) {
    if (!notes.first_note && !notes.last_note) {
      throw new RuntimeError("BadArguments", "Notes needs to have either first_note or last_note set.");
    }
    if (!notes.first_indices)
      notes.first_indices = [0];
    if (!notes.last_indices)
      notes.last_indices = [0];
    if (notes.first_indices.length !== notes.last_indices.length) {
      throw new RuntimeError("BadArguments", "Connected notes must have same number of indices.");
    }
    this.notes = notes;
    this.first_note = notes.first_note;
    this.first_indices = notes.first_indices;
    this.last_note = notes.last_note;
    this.last_indices = notes.last_indices;
    return this;
  }
  applyLineStyle() {
    const ctx = this.checkContext();
    const render_options = this.render_options;
    if (render_options.line_dash) {
      ctx.setLineDash(render_options.line_dash);
    }
    if (render_options.line_width) {
      ctx.setLineWidth(render_options.line_width);
    }
    if (render_options.rounded_end) {
      ctx.setLineCap("round");
    } else {
      ctx.setLineCap("square");
    }
  }
  applyFontStyle() {
    const ctx = this.checkContext();
    ctx.setFont(this.textFont);
    const render_options = this.render_options;
    const color = render_options.color;
    if (color) {
      ctx.setStrokeStyle(color);
      ctx.setFillStyle(color);
    }
  }
  drawArrowLine(ctx, pt1, pt2) {
    const both_arrows = this.render_options.draw_start_arrow && this.render_options.draw_end_arrow;
    const x1 = pt1.x;
    const y1 = pt1.y;
    const x2 = pt2.x;
    const y2 = pt2.y;
    const distance = Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
    const ratio = (distance - this.render_options.arrowhead_length / 3) / distance;
    let end_x;
    let end_y;
    let start_x;
    let start_y;
    if (this.render_options.draw_end_arrow || both_arrows) {
      end_x = Math.round(x1 + (x2 - x1) * ratio);
      end_y = Math.round(y1 + (y2 - y1) * ratio);
    } else {
      end_x = x2;
      end_y = y2;
    }
    if (this.render_options.draw_start_arrow || both_arrows) {
      start_x = x1 + (x2 - x1) * (1 - ratio);
      start_y = y1 + (y2 - y1) * (1 - ratio);
    } else {
      start_x = x1;
      start_y = y1;
    }
    if (this.render_options.color) {
      ctx.setStrokeStyle(this.render_options.color);
      ctx.setFillStyle(this.render_options.color);
    }
    ctx.beginPath();
    ctx.moveTo(start_x, start_y);
    ctx.lineTo(end_x, end_y);
    ctx.stroke();
    ctx.closePath();
    const line_angle = Math.atan2(y2 - y1, x2 - x1);
    const h = Math.abs(this.render_options.arrowhead_length / Math.cos(this.render_options.arrowhead_angle));
    let angle1;
    let angle2;
    let top_x;
    let top_y;
    let bottom_x;
    let bottom_y;
    if (this.render_options.draw_end_arrow || both_arrows) {
      angle1 = line_angle + Math.PI + this.render_options.arrowhead_angle;
      top_x = x2 + Math.cos(angle1) * h;
      top_y = y2 + Math.sin(angle1) * h;
      angle2 = line_angle + Math.PI - this.render_options.arrowhead_angle;
      bottom_x = x2 + Math.cos(angle2) * h;
      bottom_y = y2 + Math.sin(angle2) * h;
      drawArrowHead(ctx, top_x, top_y, x2, y2, bottom_x, bottom_y);
    }
    if (this.render_options.draw_start_arrow || both_arrows) {
      angle1 = line_angle + this.render_options.arrowhead_angle;
      top_x = x1 + Math.cos(angle1) * h;
      top_y = y1 + Math.sin(angle1) * h;
      angle2 = line_angle - this.render_options.arrowhead_angle;
      bottom_x = x1 + Math.cos(angle2) * h;
      bottom_y = y1 + Math.sin(angle2) * h;
      drawArrowHead(ctx, top_x, top_y, x1, y1, bottom_x, bottom_y);
    }
  }
  draw() {
    const ctx = this.checkContext();
    this.setRendered();
    const first_note = this.first_note;
    const last_note = this.last_note;
    const render_options = this.render_options;
    ctx.save();
    this.applyLineStyle();
    let start_position = { x: 0, y: 0 };
    let end_position = { x: 0, y: 0 };
    this.first_indices.forEach((first_index, i) => {
      const last_index = this.last_indices[i];
      start_position = first_note.getModifierStartXY(2, first_index);
      end_position = last_note.getModifierStartXY(1, last_index);
      const upwards_slope = start_position.y > end_position.y;
      start_position.x += first_note.getMetrics().modRightPx + render_options.padding_left;
      end_position.x -= last_note.getMetrics().modLeftPx + render_options.padding_right;
      const notehead_width = first_note.getGlyphProps().getWidth();
      const first_displaced = first_note.getKeyProps()[first_index].displaced;
      if (first_displaced && first_note.getStemDirection() === 1) {
        start_position.x += notehead_width + render_options.padding_left;
      }
      const last_displaced = last_note.getKeyProps()[last_index].displaced;
      if (last_displaced && last_note.getStemDirection() === -1) {
        end_position.x -= notehead_width + render_options.padding_right;
      }
      start_position.y += upwards_slope ? -3 : 1;
      end_position.y += upwards_slope ? 2 : 0;
      this.drawArrowLine(ctx, start_position, end_position);
    });
    ctx.restore();
    const text_width = ctx.measureText(this.text).width;
    const justification = render_options.text_justification;
    let x = 0;
    if (justification === _StaveLine.TextJustification.LEFT) {
      x = start_position.x;
    } else if (justification === _StaveLine.TextJustification.CENTER) {
      const delta_x = end_position.x - start_position.x;
      const center_x = delta_x / 2 + start_position.x;
      x = center_x - text_width / 2;
    } else if (justification === _StaveLine.TextJustification.RIGHT) {
      x = end_position.x - text_width;
    }
    let y = 0;
    const vertical_position = render_options.text_position_vertical;
    if (vertical_position === _StaveLine.TextVerticalPosition.TOP) {
      y = first_note.checkStave().getYForTopText();
    } else if (vertical_position === _StaveLine.TextVerticalPosition.BOTTOM) {
      y = first_note.checkStave().getYForBottomText(Tables.TEXT_HEIGHT_OFFSET_HACK);
    }
    ctx.save();
    this.applyFontStyle();
    ctx.fillText(this.text, x, y);
    ctx.restore();
    return this;
  }
};
StaveLine.TEXT_FONT = Object.assign({}, Element.TEXT_FONT);
StaveLine.TextVerticalPosition = {
  TOP: 1,
  BOTTOM: 2
};
StaveLine.TextJustification = TextJustification;

// node_modules/vexflow/build/esm/src/system.js
var System = class extends Element {
  static get CATEGORY() {
    return "System";
  }
  constructor(params = {}) {
    super();
    this.setOptions(params);
    this.partStaves = [];
    this.partStaveInfos = [];
    this.partVoices = [];
  }
  setOptions(options = {}) {
    if (!options.factory) {
      throw new RuntimeError("NoFactory", "System.setOptions(options) requires a factory.");
    }
    this.factory = options.factory;
    this.options = Object.assign(Object.assign({ factory: this.factory, x: 10, y: 10, width: 500, spaceBetweenStaves: 12, autoWidth: false, noJustification: false, debugFormatter: false, formatIterations: 0, noPadding: false }, options), { details: Object.assign({ alpha: 0.5 }, options.details), formatOptions: Object.assign({}, options.formatOptions) });
    if (this.options.noJustification === false && typeof options.width === "undefined") {
      this.options.autoWidth = true;
    }
  }
  getX() {
    return this.options.x;
  }
  setX(x) {
    this.options.x = x;
    this.partStaves.forEach((s) => {
      s.setX(x);
    });
  }
  getY() {
    return this.options.y;
  }
  setY(y) {
    this.options.y = y;
    this.partStaves.forEach((s) => {
      s.setY(y);
    });
  }
  getStaves() {
    return this.partStaves;
  }
  getVoices() {
    return this.partVoices;
  }
  setContext(context) {
    super.setContext(context);
    this.factory.setContext(context);
    return this;
  }
  addConnector(type = "double") {
    this.connector = this.factory.StaveConnector({
      top_stave: this.partStaves[0],
      bottom_stave: this.partStaves[this.partStaves.length - 1],
      type
    });
    return this.connector;
  }
  addStave(params) {
    var _a;
    const staveOptions = Object.assign({ left_bar: false }, params.options);
    const stave = (_a = params.stave) !== null && _a !== void 0 ? _a : this.factory.Stave({ x: this.options.x, y: this.options.y, width: this.options.width, options: staveOptions });
    const p = Object.assign(Object.assign({ spaceAbove: 0, spaceBelow: 0, debugNoteMetrics: false, noJustification: false }, params), { options: staveOptions });
    const ctx = this.getContext();
    p.voices.forEach((voice) => {
      voice.setContext(ctx).setStave(stave).getTickables().forEach((tickable) => tickable.setStave(stave));
      this.partVoices.push(voice);
    });
    this.partStaves.push(stave);
    this.partStaveInfos.push(p);
    return stave;
  }
  addVoices(voices) {
    const ctx = this.getContext();
    voices.forEach((voice) => {
      voice.setContext(ctx);
      this.partVoices.push(voice);
    });
  }
  format() {
    const options_details = this.options.details;
    let justifyWidth = 0;
    const formatter = new Formatter(options_details);
    this.formatter = formatter;
    let y = this.options.y;
    let startX = 0;
    const debugNoteMetricsYs = [];
    this.partStaves.forEach((part, index) => {
      y = y + part.space(this.partStaveInfos[index].spaceAbove);
      part.setY(y);
      y = y + part.space(this.partStaveInfos[index].spaceBelow);
      y = y + part.space(this.options.spaceBetweenStaves);
      if (this.partStaveInfos[index].debugNoteMetrics) {
        debugNoteMetricsYs.push({ y, stave: part });
        y += 15;
      }
      startX = Math.max(startX, part.getNoteStartX());
    });
    this.partVoices.forEach((voice) => {
      voice.getTickables().forEach((tickable) => {
        const stave = tickable.getStave();
        if (stave)
          tickable.setStave(stave);
      });
    });
    formatter.joinVoices(this.partVoices);
    this.partStaves.forEach((part) => part.setNoteStartX(startX));
    if (this.options.autoWidth && this.partVoices.length > 0) {
      justifyWidth = formatter.preCalculateMinTotalWidth(this.partVoices);
      this.options.width = justifyWidth + Stave.rightPadding + (startX - this.options.x);
      this.partStaves.forEach((part) => {
        part.setWidth(this.options.width);
      });
    } else {
      justifyWidth = this.options.noPadding ? this.options.width - (startX - this.options.x) : this.options.width - (startX - this.options.x) - Stave.defaultPadding;
    }
    if (this.partVoices.length > 0) {
      formatter.format(this.partVoices, this.options.noJustification ? 0 : justifyWidth, this.options.formatOptions);
    }
    formatter.postFormat();
    for (let i = 0; i < this.options.formatIterations; i++) {
      formatter.tune(options_details);
    }
    this.startX = startX;
    this.debugNoteMetricsYs = debugNoteMetricsYs;
    this.lastY = y;
    this.boundingBox = new BoundingBox(this.options.x, this.options.y, this.options.width, this.lastY - this.options.y);
    Stave.formatBegModifiers(this.partStaves);
  }
  draw() {
    const ctx = this.checkContext();
    if (!this.formatter || !this.startX || !this.lastY || !this.debugNoteMetricsYs) {
      throw new RuntimeError("NoFormatter", "format() must be called before draw()");
    }
    this.setRendered();
    if (this.options.debugFormatter) {
      Formatter.plotDebugging(ctx, this.formatter, this.startX, this.options.y, this.lastY);
    }
    this.debugNoteMetricsYs.forEach((d) => {
      this.partVoices.forEach((voice) => {
        voice.getTickables().forEach((tickable) => {
          if (tickable.getStave() === d.stave)
            Note.plotMetrics(ctx, tickable, d.y);
        });
      });
    });
  }
};

// node_modules/vexflow/build/esm/src/tabnote.js
function getUnusedStringGroups(num_lines, strings_used) {
  const stem_through = [];
  let group = [];
  for (let string = 1; string <= num_lines; string++) {
    const is_used = strings_used.indexOf(string) > -1;
    if (!is_used) {
      group.push(string);
    } else {
      stem_through.push(group);
      group = [];
    }
  }
  if (group.length > 0)
    stem_through.push(group);
  return stem_through;
}
function getPartialStemLines(stem_y, unused_strings, stave, stem_direction) {
  const up_stem = stem_direction !== 1;
  const down_stem = stem_direction !== -1;
  const line_spacing = stave.getSpacingBetweenLines();
  const total_lines = stave.getNumLines();
  const stem_lines = [];
  unused_strings.forEach((strings) => {
    const containsLastString = strings.indexOf(total_lines) > -1;
    const containsFirstString = strings.indexOf(1) > -1;
    if (up_stem && containsFirstString || down_stem && containsLastString) {
      return;
    }
    if (strings.length === 1) {
      strings.push(strings[0]);
    }
    const line_ys = [];
    strings.forEach((string, index, strings2) => {
      const isTopBound = string === 1;
      const isBottomBound = string === total_lines;
      let y = stave.getYForLine(string - 1);
      if (index === 0 && !isTopBound) {
        y -= line_spacing / 2 - 1;
      } else if (index === strings2.length - 1 && !isBottomBound) {
        y += line_spacing / 2 - 1;
      }
      line_ys.push(y);
      if (stem_direction === 1 && isTopBound) {
        line_ys.push(stem_y - 2);
      } else if (stem_direction === -1 && isBottomBound) {
        line_ys.push(stem_y + 2);
      }
    });
    stem_lines.push(line_ys.sort((a, b) => a - b));
  });
  return stem_lines;
}
var TabNote = class extends StemmableNote {
  static get CATEGORY() {
    return "TabNote";
  }
  constructor(noteStruct, draw_stem = false) {
    super(noteStruct);
    this.glyphPropsArr = [];
    this.greatestString = () => {
      return this.positions.map((x) => x.str).reduce((a, b) => a > b ? a : b);
    };
    this.leastString = () => {
      return this.positions.map((x) => x.str).reduce((a, b) => a < b ? a : b);
    };
    this.ghost = false;
    this.positions = noteStruct.positions || [];
    this.render_options = Object.assign(Object.assign({}, this.render_options), { glyph_font_scale: Tables.TABLATURE_FONT_SCALE, draw_stem, draw_dots: draw_stem, draw_stem_through_stave: false, y_shift: 0, scale: 1, font: `${Font.SIZE}pt ${Font.SANS_SERIF}` });
    this.glyphProps = Tables.getGlyphProps(this.duration, this.noteType);
    defined(this.glyphProps, "BadArguments", `No glyph found for duration '${this.duration}' and type '${this.noteType}'`);
    this.buildStem();
    if (noteStruct.stem_direction) {
      this.setStemDirection(noteStruct.stem_direction);
    } else {
      this.setStemDirection(Stem.UP);
    }
    this.ghost = false;
    this.updateWidth();
  }
  reset() {
    super.reset();
    if (this.stave)
      this.setStave(this.stave);
    return this;
  }
  setGhost(ghost) {
    this.ghost = ghost;
    this.updateWidth();
    return this;
  }
  hasStem() {
    if (this.render_options.draw_stem)
      return true;
    return false;
  }
  getStemExtension() {
    const glyphProps = this.getGlyphProps();
    if (this.stem_extension_override != null) {
      return this.stem_extension_override;
    }
    if (glyphProps) {
      return this.getStemDirection() === Stem.UP ? glyphProps.tabnote_stem_up_extension : glyphProps.tabnote_stem_down_extension;
    }
    return 0;
  }
  updateWidth() {
    this.glyphPropsArr = [];
    this.width = 0;
    for (let i = 0; i < this.positions.length; ++i) {
      let fret = this.positions[i].fret;
      if (this.ghost)
        fret = "(" + fret + ")";
      const glyphProps = Tables.tabToGlyphProps(fret.toString(), this.render_options.scale);
      this.glyphPropsArr.push(glyphProps);
      this.width = Math.max(glyphProps.getWidth(), this.width);
    }
    this.glyphProps.getWidth = () => this.width;
  }
  setStave(stave) {
    super.setStave(stave);
    const ctx = stave.getContext();
    this.setContext(ctx);
    if (ctx) {
      this.width = 0;
      for (let i = 0; i < this.glyphPropsArr.length; ++i) {
        const glyphProps = this.glyphPropsArr[i];
        const text = "" + glyphProps.text;
        if (text.toUpperCase() !== "X") {
          ctx.save();
          ctx.setFont(this.render_options.font);
          glyphProps.width = ctx.measureText(text).width;
          ctx.restore();
          glyphProps.getWidth = () => glyphProps.width;
        }
        this.width = Math.max(glyphProps.getWidth(), this.width);
      }
      this.glyphProps.getWidth = () => this.width;
    }
    const ys = this.positions.map(({ str: line }) => stave.getYForLine(Number(line) - 1));
    this.setYs(ys);
    if (this.stem) {
      this.stem.setYBounds(this.getStemY(), this.getStemY());
    }
    return this;
  }
  getPositions() {
    return this.positions;
  }
  getModifierStartXY(position, index) {
    if (!this.preFormatted) {
      throw new RuntimeError("UnformattedNote", "Can't call GetModifierStartXY on an unformatted note");
    }
    if (this.ys.length === 0) {
      throw new RuntimeError("NoYValues", "No Y-Values calculated for this note.");
    }
    let x = 0;
    if (position === Modifier.Position.LEFT) {
      x = -1 * 2;
    } else if (position === Modifier.Position.RIGHT) {
      x = this.width + 2;
    } else if (position === Modifier.Position.BELOW || position === Modifier.Position.ABOVE) {
      const note_glyph_width = this.glyphProps.getWidth();
      x = note_glyph_width / 2;
    }
    return {
      x: this.getAbsoluteX() + x,
      y: this.ys[index]
    };
  }
  getLineForRest() {
    return Number(this.positions[0].str);
  }
  preFormat() {
    if (this.preFormatted)
      return;
    if (this.modifierContext)
      this.modifierContext.preFormat();
    this.preFormatted = true;
  }
  getStemX() {
    return this.getCenterGlyphX();
  }
  getStemY() {
    const num_lines = this.checkStave().getNumLines();
    const stemUpLine = -0.5;
    const stemDownLine = num_lines - 0.5;
    const stemStartLine = Stem.UP === this.stem_direction ? stemUpLine : stemDownLine;
    return this.checkStave().getYForLine(stemStartLine);
  }
  getStemExtents() {
    return this.checkStem().getExtents();
  }
  drawFlag() {
    var _a;
    const { beam, glyphProps, render_options: { draw_stem } } = this;
    const context = this.checkContext();
    const shouldDrawFlag = beam == void 0 && draw_stem;
    if (glyphProps.flag && shouldDrawFlag) {
      const flag_x = this.getStemX();
      const flag_y = this.getStemDirection() === Stem.DOWN ? this.getStemY() - this.checkStem().getHeight() - (this.glyphProps ? this.glyphProps.stem_down_extension : 0) : this.getStemY() - this.checkStem().getHeight() + (this.glyphProps ? this.glyphProps.stem_up_extension : 0);
      (_a = this.flag) === null || _a === void 0 ? void 0 : _a.render(context, flag_x, flag_y);
    }
  }
  drawModifiers() {
    this.modifiers.forEach((modifier) => {
      if (isDot(modifier) && !this.render_options.draw_dots) {
        return;
      }
      modifier.setContext(this.getContext());
      modifier.drawWithStyle();
    });
  }
  drawStemThrough() {
    const stemX = this.getStemX();
    const stemY = this.getStemY();
    const ctx = this.checkContext();
    const drawStem = this.render_options.draw_stem;
    const stemThrough = this.render_options.draw_stem_through_stave;
    if (drawStem && stemThrough) {
      const numLines = this.checkStave().getNumLines();
      const stringsUsed = this.positions.map((position) => Number(position.str));
      const unusedStrings = getUnusedStringGroups(numLines, stringsUsed);
      const stemLines = getPartialStemLines(stemY, unusedStrings, this.checkStave(), this.getStemDirection());
      ctx.save();
      ctx.setLineWidth(Stem.WIDTH);
      stemLines.forEach((bounds) => {
        if (bounds.length === 0)
          return;
        ctx.beginPath();
        ctx.moveTo(stemX, bounds[0]);
        ctx.lineTo(stemX, bounds[bounds.length - 1]);
        ctx.stroke();
        ctx.closePath();
      });
      ctx.restore();
    }
  }
  drawPositions() {
    var _a;
    const ctx = this.checkContext();
    const x = this.getAbsoluteX();
    const ys = this.ys;
    for (let i = 0; i < this.positions.length; ++i) {
      const y = ys[i] + this.render_options.y_shift;
      const glyphProps = this.glyphPropsArr[i];
      const note_glyph_width = this.glyphProps.getWidth();
      const tab_x = x + note_glyph_width / 2 - glyphProps.getWidth() / 2;
      ctx.clearRect(tab_x - 2, y - 3, glyphProps.getWidth() + 4, 6);
      if (glyphProps.code) {
        Glyph.renderGlyph(ctx, tab_x, y, this.render_options.glyph_font_scale * this.render_options.scale, glyphProps.code);
      } else {
        ctx.save();
        ctx.setFont(this.render_options.font);
        const text = (_a = glyphProps.text) !== null && _a !== void 0 ? _a : "";
        ctx.fillText(text, tab_x, y + 5 * this.render_options.scale);
        ctx.restore();
      }
    }
  }
  draw() {
    const ctx = this.checkContext();
    if (this.ys.length === 0) {
      throw new RuntimeError("NoYValues", "Can't draw note without Y values.");
    }
    this.setRendered();
    const render_stem = this.beam == void 0 && this.render_options.draw_stem;
    this.applyStyle();
    ctx.openGroup("tabnote", this.getAttribute("id"), { pointerBBox: true });
    this.drawPositions();
    this.drawStemThrough();
    if (this.stem && render_stem) {
      const stem_x = this.getStemX();
      this.stem.setNoteHeadXBounds(stem_x, stem_x);
      this.stem.setContext(ctx).draw();
    }
    this.drawFlag();
    this.drawModifiers();
    ctx.closeGroup();
    this.restoreStyle();
  }
};

// node_modules/vexflow/build/esm/src/tabstave.js
var TabStave = class extends Stave {
  static get CATEGORY() {
    return "TabStave";
  }
  constructor(x, y, width, options) {
    const tab_options = Object.assign({ spacing_between_lines_px: 13, num_lines: 6, top_text_position: 1 }, options);
    super(x, y, width, tab_options);
  }
  getYForGlyphs() {
    return this.getYForLine(2.5);
  }
  addTabGlyph() {
    this.addClef("tab");
    return this;
  }
};

// node_modules/vexflow/build/esm/src/textbracket.js
function L19(...args) {
  if (TextBracket.DEBUG)
    log("Vex.Flow.TextBracket", args);
}
var TextBracketPosition;
(function(TextBracketPosition2) {
  TextBracketPosition2[TextBracketPosition2["TOP"] = 1] = "TOP";
  TextBracketPosition2[TextBracketPosition2["BOTTOM"] = -1] = "BOTTOM";
})(TextBracketPosition || (TextBracketPosition = {}));
var TextBracket = class _TextBracket extends Element {
  static get CATEGORY() {
    return "TextBracket";
  }
  static get Position() {
    return TextBracketPosition;
  }
  static get PositionString() {
    return {
      top: TextBracketPosition.TOP,
      bottom: TextBracketPosition.BOTTOM
    };
  }
  static get Positions() {
    L19("Positions is deprecated, use TextBracketPosition instead.");
    return TextBracketPosition;
  }
  static get PositionsString() {
    L19("PositionsString is deprecated, use PositionString instead.");
    return _TextBracket.PositionString;
  }
  constructor({ start, stop, text = "", superscript = "", position = TextBracketPosition.TOP }) {
    super();
    this.start = start;
    this.stop = stop;
    this.text = text;
    this.superscript = superscript;
    this.position = typeof position === "string" ? _TextBracket.PositionString[position] : position;
    this.line = 1;
    this.resetFont();
    this.render_options = {
      dashed: true,
      dash: [5],
      color: "black",
      line_width: 1,
      show_bracket: true,
      bracket_height: 8,
      underline_superscript: true
    };
  }
  applyStyle(ctx) {
    ctx.setFont(this.font);
    const options = this.render_options;
    ctx.setStrokeStyle(options.color);
    ctx.setFillStyle(options.color);
    ctx.setLineWidth(options.line_width);
    return this;
  }
  setDashed(dashed, dash) {
    this.render_options.dashed = dashed;
    if (dash)
      this.render_options.dash = dash;
    return this;
  }
  setLine(line) {
    this.line = line;
    return this;
  }
  draw() {
    const ctx = this.checkContext();
    this.setRendered();
    let y = 0;
    switch (this.position) {
      case TextBracketPosition.TOP:
        y = this.start.checkStave().getYForTopText(this.line);
        break;
      case TextBracketPosition.BOTTOM:
        y = this.start.checkStave().getYForBottomText(this.line + Tables.TEXT_HEIGHT_OFFSET_HACK);
        break;
      default:
        throw new RuntimeError("InvalidPosition", `The position ${this.position} is invalid.`);
    }
    const start = { x: this.start.getAbsoluteX(), y };
    const stop = { x: this.stop.getAbsoluteX(), y };
    L19("Rendering TextBracket: start:", start, "stop:", stop, "y:", y);
    const bracket_height = this.render_options.bracket_height * this.position;
    ctx.save();
    this.applyStyle(ctx);
    ctx.fillText(this.text, start.x, start.y);
    const main_measure = ctx.measureText(this.text);
    const main_width = main_measure.width;
    const main_height = main_measure.height;
    const super_y = start.y - main_height / 2.5;
    const { family, size, weight, style } = this.textFont;
    const smallerFontSize = Font.scaleSize(size, 0.714286);
    ctx.setFont(family, smallerFontSize, weight, style);
    ctx.fillText(this.superscript, start.x + main_width + 1, super_y);
    const super_measure = ctx.measureText(this.superscript);
    const super_width = super_measure.width;
    const super_height = super_measure.height;
    let start_x = start.x;
    let line_y = super_y;
    const end_x = stop.x + this.stop.getGlyphProps().getWidth();
    if (this.position === TextBracketPosition.TOP) {
      start_x += main_width + super_width + 5;
      line_y -= super_height / 2.7;
    } else if (this.position === TextBracketPosition.BOTTOM) {
      line_y += super_height / 2.7;
      start_x += main_width + 2;
      if (!this.render_options.underline_superscript) {
        start_x += super_width;
      }
    }
    if (this.render_options.dashed) {
      Renderer.drawDashedLine(ctx, start_x, line_y, end_x, line_y, this.render_options.dash);
      if (this.render_options.show_bracket) {
        Renderer.drawDashedLine(ctx, end_x, line_y + 1 * this.position, end_x, line_y + bracket_height, this.render_options.dash);
      }
    } else {
      ctx.beginPath();
      ctx.moveTo(start_x, line_y);
      ctx.lineTo(end_x, line_y);
      if (this.render_options.show_bracket) {
        ctx.lineTo(end_x, line_y + bracket_height);
      }
      ctx.stroke();
      ctx.closePath();
    }
    ctx.restore();
  }
};
TextBracket.DEBUG = false;
TextBracket.TEXT_FONT = {
  family: Font.SERIF,
  size: 15,
  weight: FontWeight.NORMAL,
  style: FontStyle.ITALIC
};

// node_modules/vexflow/build/esm/src/textdynamics.js
function L20(...args) {
  if (TextDynamics.DEBUG)
    log("Vex.Flow.TextDynamics", args);
}
var TextDynamics = class _TextDynamics extends Note {
  static get CATEGORY() {
    return "TextDynamics";
  }
  static get GLYPHS() {
    return {
      f: {
        code: "dynamicForte",
        width: 12
      },
      p: {
        code: "dynamicPiano",
        width: 14
      },
      m: {
        code: "dynamicMezzo",
        width: 17
      },
      s: {
        code: "dynamicSforzando",
        width: 10
      },
      z: {
        code: "dynamicZ",
        width: 12
      },
      r: {
        code: "dynamicRinforzando",
        width: 12
      }
    };
  }
  constructor(noteStruct) {
    super(noteStruct);
    this.sequence = (noteStruct.text || "").toLowerCase();
    this.line = noteStruct.line || 0;
    this.glyphs = [];
    this.render_options = Object.assign(Object.assign({}, this.render_options), { glyph_font_size: Tables.NOTATION_FONT_SCALE });
    L20("New Dynamics Text: ", this.sequence);
  }
  setLine(line) {
    this.line = line;
    return this;
  }
  preFormat() {
    let total_width = 0;
    this.glyphs = [];
    this.sequence.split("").forEach((letter) => {
      const glyph_data = _TextDynamics.GLYPHS[letter];
      if (!glyph_data)
        throw new RuntimeError("Invalid dynamics character: " + letter);
      const size = defined(this.render_options.glyph_font_size);
      const glyph = new Glyph(glyph_data.code, size, { category: "textNote" });
      this.glyphs.push(glyph);
      total_width += glyph_data.width;
    });
    this.setWidth(total_width);
    this.preFormatted = true;
    return this;
  }
  draw() {
    this.setRendered();
    const x = this.getAbsoluteX();
    const y = this.checkStave().getYForLine(this.line + -3);
    L20("Rendering Dynamics: ", this.sequence);
    let letter_x = x;
    this.glyphs.forEach((glyph, index) => {
      const current_letter = this.sequence[index];
      glyph.render(this.checkContext(), letter_x, y);
      letter_x += _TextDynamics.GLYPHS[current_letter].width;
    });
  }
};
TextDynamics.DEBUG = false;

// node_modules/vexflow/build/esm/src/timesignote.js
var TimeSigNote = class extends Note {
  static get CATEGORY() {
    return "TimeSigNote";
  }
  constructor(timeSpec, customPadding) {
    super({ duration: "b" });
    this.timeSig = new TimeSignature(timeSpec, customPadding);
    this.setWidth(this.timeSig.getGlyph().getMetrics().width);
    this.ignore_ticks = true;
  }
  addToModifierContext(mc) {
    return this;
  }
  preFormat() {
    this.preFormatted = true;
    return this;
  }
  draw() {
    const stave = this.checkStave();
    const ctx = this.checkContext();
    this.setRendered();
    const tsGlyph = this.timeSig.getGlyph();
    if (!tsGlyph.getContext()) {
      tsGlyph.setContext(ctx);
    }
    tsGlyph.setStave(stave);
    tsGlyph.setYShift(stave.getYForLine(2) - stave.getYForGlyphs());
    tsGlyph.renderToStave(this.getAbsoluteX());
  }
};

// node_modules/vexflow/build/esm/src/tuplet.js
var Tuplet = class _Tuplet extends Element {
  static get CATEGORY() {
    return "Tuplet";
  }
  static get LOCATION_TOP() {
    return 1;
  }
  static get LOCATION_BOTTOM() {
    return -1;
  }
  static get NESTING_OFFSET() {
    return 15;
  }
  static get metrics() {
    const tupletMetrics = Tables.currentMusicFont().getMetrics().tuplet;
    if (!tupletMetrics)
      throw new RuntimeError("BadMetrics", `tuplet missing`);
    return tupletMetrics;
  }
  constructor(notes, options = {}) {
    super();
    this.numerator_glyphs = [];
    this.denom_glyphs = [];
    if (!notes || !notes.length) {
      throw new RuntimeError("BadArguments", "No notes provided for tuplet.");
    }
    this.options = options;
    this.notes = notes;
    this.num_notes = this.options.num_notes != void 0 ? this.options.num_notes : notes.length;
    if (this.options.beats_occupied) {
      this.beatsOccupiedDeprecationWarning();
    }
    this.notes_occupied = this.options.notes_occupied || this.options.beats_occupied || 2;
    if (this.options.bracketed != void 0) {
      this.bracketed = this.options.bracketed;
    } else {
      this.bracketed = notes.some((note) => !note.hasBeam());
    }
    this.ratioed = this.options.ratioed != void 0 ? this.options.ratioed : Math.abs(this.notes_occupied - this.num_notes) > 1;
    this.point = Tables.NOTATION_FONT_SCALE * 3 / 5;
    this.y_pos = 16;
    this.x_pos = 100;
    this.width = 200;
    this.setTupletLocation(this.options.location || _Tuplet.LOCATION_TOP);
    Formatter.AlignRestsToNotes(notes, true, true);
    this.resolveGlyphs();
    this.attach();
  }
  attach() {
    for (let i = 0; i < this.notes.length; i++) {
      const note = this.notes[i];
      note.setTuplet(this);
    }
  }
  detach() {
    for (let i = 0; i < this.notes.length; i++) {
      const note = this.notes[i];
      note.resetTuplet(this);
    }
  }
  setBracketed(bracketed) {
    this.bracketed = !!bracketed;
    return this;
  }
  setRatioed(ratioed) {
    this.ratioed = !!ratioed;
    return this;
  }
  setTupletLocation(location) {
    if (location !== _Tuplet.LOCATION_TOP && location !== _Tuplet.LOCATION_BOTTOM) {
      console.warn(`Invalid tuplet location [${location}]. Using Tuplet.LOCATION_TOP.`);
      location = _Tuplet.LOCATION_TOP;
    }
    this.location = location;
    return this;
  }
  getNotes() {
    return this.notes;
  }
  getNoteCount() {
    return this.num_notes;
  }
  beatsOccupiedDeprecationWarning() {
    console.warn("beats_occupied has been deprecated as an option for tuplets. Please use notes_occupied instead.", "Calls to getBeatsOccupied / setBeatsOccupied should now be routed to getNotesOccupied / setNotesOccupied.", "The old methods will be removed in VexFlow 5.0.");
  }
  getBeatsOccupied() {
    this.beatsOccupiedDeprecationWarning();
    return this.getNotesOccupied();
  }
  setBeatsOccupied(beats) {
    this.beatsOccupiedDeprecationWarning();
    return this.setNotesOccupied(beats);
  }
  getNotesOccupied() {
    return this.notes_occupied;
  }
  setNotesOccupied(notes) {
    this.detach();
    this.notes_occupied = notes;
    this.resolveGlyphs();
    this.attach();
  }
  resolveGlyphs() {
    this.numerator_glyphs = [];
    let n = this.num_notes;
    while (n >= 1) {
      this.numerator_glyphs.unshift(new Glyph("timeSig" + n % 10, this.point));
      n = parseInt((n / 10).toString(), 10);
    }
    this.denom_glyphs = [];
    n = this.notes_occupied;
    while (n >= 1) {
      this.denom_glyphs.unshift(new Glyph("timeSig" + n % 10, this.point));
      n = parseInt((n / 10).toString(), 10);
    }
  }
  getNestedTupletCount() {
    const location = this.location;
    const first_note = this.notes[0];
    let maxTupletCount = countTuplets(first_note, location);
    let minTupletCount = countTuplets(first_note, location);
    function countTuplets(note, location2) {
      return note.getTupletStack().filter((tuplet) => tuplet.location === location2).length;
    }
    this.notes.forEach((note) => {
      const tupletCount = countTuplets(note, location);
      maxTupletCount = tupletCount > maxTupletCount ? tupletCount : maxTupletCount;
      minTupletCount = tupletCount < minTupletCount ? tupletCount : minTupletCount;
    });
    return maxTupletCount - minTupletCount;
  }
  getYPosition() {
    const nested_tuplet_y_offset = this.getNestedTupletCount() * _Tuplet.NESTING_OFFSET * -this.location;
    const y_offset = this.options.y_offset || 0;
    const first_note = this.notes[0];
    let y_pos;
    if (this.location === _Tuplet.LOCATION_TOP) {
      y_pos = first_note.checkStave().getYForLine(0) - _Tuplet.metrics.topModifierOffset;
      for (let i = 0; i < this.notes.length; ++i) {
        const note = this.notes[i];
        let modLines = 0;
        const mc = note.getModifierContext();
        if (mc) {
          modLines = Math.max(modLines, mc.getState().top_text_line);
        }
        const modY = note.getYForTopText(modLines) - _Tuplet.metrics.noteHeadOffset;
        if (note.hasStem() || note.isRest()) {
          const top_y = note.getStemDirection() === Stem.UP ? note.getStemExtents().topY - _Tuplet.metrics.stemOffset : note.getStemExtents().baseY - _Tuplet.metrics.noteHeadOffset;
          y_pos = Math.min(top_y, y_pos);
          if (modLines > 0) {
            y_pos = Math.min(modY, y_pos);
          }
        }
      }
    } else {
      let lineCheck = _Tuplet.metrics.bottomLine;
      this.notes.forEach((nn) => {
        const mc = nn.getModifierContext();
        if (mc) {
          lineCheck = Math.max(lineCheck, mc.getState().text_line + 1);
        }
      });
      y_pos = first_note.checkStave().getYForLine(lineCheck) + _Tuplet.metrics.noteHeadOffset;
      for (let i = 0; i < this.notes.length; ++i) {
        if (this.notes[i].hasStem() || this.notes[i].isRest()) {
          const bottom_y = this.notes[i].getStemDirection() === Stem.UP ? this.notes[i].getStemExtents().baseY + _Tuplet.metrics.noteHeadOffset : this.notes[i].getStemExtents().topY + _Tuplet.metrics.stemOffset;
          if (bottom_y > y_pos) {
            y_pos = bottom_y;
          }
        }
      }
    }
    return y_pos + nested_tuplet_y_offset + y_offset;
  }
  draw() {
    const ctx = this.checkContext();
    this.setRendered();
    const first_note = this.notes[0];
    const last_note = this.notes[this.notes.length - 1];
    if (!this.bracketed) {
      this.x_pos = first_note.getStemX();
      this.width = last_note.getStemX() - this.x_pos;
    } else {
      this.x_pos = first_note.getTieLeftX() - 5;
      this.width = last_note.getTieRightX() - this.x_pos + 5;
    }
    this.y_pos = this.getYPosition();
    const addGlyphWidth = (width2, glyph) => width2 + defined(glyph.getMetrics().width);
    let width = this.numerator_glyphs.reduce(addGlyphWidth, 0);
    if (this.ratioed) {
      width = this.denom_glyphs.reduce(addGlyphWidth, width);
      width += this.point * 0.32;
    }
    const notation_center_x = this.x_pos + this.width / 2;
    const notation_start_x = notation_center_x - width / 2;
    if (this.bracketed) {
      const line_width = this.width / 2 - width / 2 - 5;
      if (line_width > 0) {
        ctx.fillRect(this.x_pos, this.y_pos, line_width, 1);
        ctx.fillRect(this.x_pos + this.width / 2 + width / 2 + 5, this.y_pos, line_width, 1);
        ctx.fillRect(this.x_pos, this.y_pos + (this.location === _Tuplet.LOCATION_BOTTOM ? 1 : 0), 1, this.location * 10);
        ctx.fillRect(this.x_pos + this.width, this.y_pos + (this.location === _Tuplet.LOCATION_BOTTOM ? 1 : 0), 1, this.location * 10);
      }
    }
    const shiftY = Tables.currentMusicFont().lookupMetric("digits.shiftY", 0);
    let x_offset = 0;
    this.numerator_glyphs.forEach((glyph) => {
      glyph.render(ctx, notation_start_x + x_offset, this.y_pos + this.point / 3 - 2 + shiftY);
      x_offset += defined(glyph.getMetrics().width);
    });
    if (this.ratioed) {
      const colon_x = notation_start_x + x_offset + this.point * 0.16;
      const colon_radius = this.point * 0.06;
      ctx.beginPath();
      ctx.arc(colon_x, this.y_pos - this.point * 0.08, colon_radius, 0, Math.PI * 2, false);
      ctx.closePath();
      ctx.fill();
      ctx.beginPath();
      ctx.arc(colon_x, this.y_pos + this.point * 0.12, colon_radius, 0, Math.PI * 2, false);
      ctx.closePath();
      ctx.fill();
      x_offset += this.point * 0.32;
      this.denom_glyphs.forEach((glyph) => {
        glyph.render(ctx, notation_start_x + x_offset, this.y_pos + this.point / 3 - 2 + shiftY);
        x_offset += defined(glyph.getMetrics().width);
      });
    }
  }
};

// node_modules/vexflow/build/esm/src/vibratobracket.js
function L21(...args) {
  if (VibratoBracket.DEBUG)
    log("Vex.Flow.VibratoBracket", args);
}
var VibratoBracket = class extends Element {
  static get CATEGORY() {
    return "VibratoBracket";
  }
  constructor(bracket_data) {
    super();
    if (bracket_data.start)
      this.start = bracket_data.start;
    if (bracket_data.stop)
      this.stop = bracket_data.stop;
    this.line = 1;
    this.render_options = {
      harsh: false,
      wave_height: 6,
      wave_width: 4,
      wave_girth: 2,
      vibrato_width: 0
    };
  }
  setLine(line) {
    this.line = line;
    return this;
  }
  setHarsh(harsh) {
    this.render_options.harsh = harsh;
    return this;
  }
  draw() {
    const ctx = this.checkContext();
    this.setRendered();
    const y = this.start && this.start.checkStave().getYForTopText(this.line) || this.stop && this.stop.checkStave().getYForTopText(this.line) || 0;
    const start_x = this.start && this.start.getAbsoluteX() || this.stop && this.stop.checkStave().getTieStartX() || 0;
    const stop_x = this.stop && this.stop.getAbsoluteX() - this.stop.getWidth() - 5 || this.start && this.start.checkStave().getTieEndX() - 10 || 0;
    this.render_options.vibrato_width = stop_x - start_x;
    L21("Rendering VibratoBracket: start_x:", start_x, "stop_x:", stop_x, "y:", y);
    Vibrato.renderVibrato(ctx, start_x, y, this.render_options);
  }
};
VibratoBracket.DEBUG = false;

// node_modules/vexflow/build/esm/src/factory.js
function L22(...args) {
  if (Factory.DEBUG)
    log("Vex.Flow.Factory", args);
}
var Factory = class _Factory {
  static newFromElementId(elementId, width = 500, height = 200) {
    return new _Factory({ renderer: { elementId, width, height } });
  }
  constructor(options = {}) {
    L22("New factory: ", options);
    this.options = {
      stave: {
        space: 10
      },
      renderer: {
        elementId: "",
        width: 500,
        height: 200,
        background: "#FFF"
      },
      font: _Factory.TEXT_FONT
    };
    this.setOptions(options);
  }
  reset() {
    this.renderQ = [];
    this.systems = [];
    this.staves = [];
    this.voices = [];
    this.stave = void 0;
  }
  setOptions(options) {
    this.options = Object.assign(Object.assign({}, this.options), options);
    this.initRenderer();
    this.reset();
  }
  initRenderer() {
    const { elementId, width, height, background } = this.options.renderer;
    if (elementId == null) {
      return;
    }
    if (elementId == "") {
      L22(this);
      throw new RuntimeError("renderer.elementId not set in FactoryOptions");
    }
    let backend = this.options.renderer.backend;
    if (backend === void 0) {
      const elem = document.getElementById(elementId);
      if (isHTMLCanvas(elem)) {
        backend = Renderer.Backends.CANVAS;
      } else {
        backend = Renderer.Backends.SVG;
      }
    }
    this.context = Renderer.buildContext(elementId, backend, width, height, background);
  }
  getContext() {
    return this.context;
  }
  setContext(context) {
    this.context = context;
    return this;
  }
  getStave() {
    return this.stave;
  }
  getVoices() {
    return this.voices;
  }
  Stave(params) {
    const staveSpace = this.options.stave.space;
    const p = Object.assign({ x: 0, y: 0, width: this.options.renderer.width - staveSpace * 1, options: { spacing_between_lines_px: staveSpace * 1 } }, params);
    const stave = new Stave(p.x, p.y, p.width, p.options);
    this.staves.push(stave);
    stave.setContext(this.context);
    this.stave = stave;
    return stave;
  }
  TabStave(params) {
    const staveSpace = this.options.stave.space;
    const p = Object.assign({ x: 0, y: 0, width: this.options.renderer.width - staveSpace * 1, options: { spacing_between_lines_px: staveSpace * 1.3 } }, params);
    const stave = new TabStave(p.x, p.y, p.width, p.options);
    this.staves.push(stave);
    stave.setContext(this.context);
    this.stave = stave;
    return stave;
  }
  StaveNote(noteStruct) {
    const note = new StaveNote(noteStruct);
    if (this.stave)
      note.setStave(this.stave);
    note.setContext(this.context);
    this.renderQ.push(note);
    return note;
  }
  GlyphNote(glyph, noteStruct, options) {
    const note = new GlyphNote(glyph, noteStruct, options);
    if (this.stave)
      note.setStave(this.stave);
    note.setContext(this.context);
    this.renderQ.push(note);
    return note;
  }
  RepeatNote(type, noteStruct, options) {
    const note = new RepeatNote(type, noteStruct, options);
    if (this.stave)
      note.setStave(this.stave);
    note.setContext(this.context);
    this.renderQ.push(note);
    return note;
  }
  GhostNote(noteStruct) {
    const ghostNote = new GhostNote(noteStruct);
    if (this.stave)
      ghostNote.setStave(this.stave);
    ghostNote.setContext(this.context);
    this.renderQ.push(ghostNote);
    return ghostNote;
  }
  TextNote(noteStruct) {
    const textNote = new TextNote(noteStruct);
    if (this.stave)
      textNote.setStave(this.stave);
    textNote.setContext(this.context);
    this.renderQ.push(textNote);
    return textNote;
  }
  BarNote(params = {}) {
    const barNote = new BarNote(params.type);
    if (this.stave)
      barNote.setStave(this.stave);
    barNote.setContext(this.context);
    this.renderQ.push(barNote);
    return barNote;
  }
  ClefNote(params) {
    const p = Object.assign({ type: "treble", options: {
      size: "default",
      annotation: void 0
    } }, params);
    const clefNote = new ClefNote(p.type, p.options.size, p.options.annotation);
    if (this.stave)
      clefNote.setStave(this.stave);
    clefNote.setContext(this.context);
    this.renderQ.push(clefNote);
    return clefNote;
  }
  TimeSigNote(params) {
    const p = Object.assign({ time: "4/4" }, params);
    const timeSigNote = new TimeSigNote(p.time);
    if (this.stave)
      timeSigNote.setStave(this.stave);
    timeSigNote.setContext(this.context);
    this.renderQ.push(timeSigNote);
    return timeSigNote;
  }
  KeySigNote(params) {
    const keySigNote = new KeySigNote(params.key, params.cancelKey, params.alterKey);
    if (this.stave)
      keySigNote.setStave(this.stave);
    keySigNote.setContext(this.context);
    this.renderQ.push(keySigNote);
    return keySigNote;
  }
  TabNote(noteStruct) {
    const note = new TabNote(noteStruct);
    if (this.stave)
      note.setStave(this.stave);
    note.setContext(this.context);
    this.renderQ.push(note);
    return note;
  }
  GraceNote(noteStruct) {
    const note = new GraceNote(noteStruct);
    if (this.stave)
      note.setStave(this.stave);
    note.setContext(this.context);
    return note;
  }
  GraceNoteGroup(params) {
    const group = new GraceNoteGroup(params.notes, params.slur);
    group.setContext(this.context);
    return group;
  }
  Accidental(params) {
    const accid = new Accidental(params.type);
    accid.setContext(this.context);
    return accid;
  }
  Annotation(params) {
    const p = Object.assign({ text: "p", hJustify: AnnotationHorizontalJustify.CENTER, vJustify: AnnotationVerticalJustify.BOTTOM }, params);
    const annotation = new Annotation(p.text);
    annotation.setJustification(p.hJustify);
    annotation.setVerticalJustification(p.vJustify);
    annotation.setFont(p.font);
    annotation.setContext(this.context);
    return annotation;
  }
  ChordSymbol(params) {
    const p = Object.assign({ vJustify: "top", hJustify: "center", kerning: true, reportWidth: true }, params);
    const chordSymbol = new ChordSymbol();
    chordSymbol.setHorizontal(p.hJustify);
    chordSymbol.setVertical(p.vJustify);
    chordSymbol.setEnableKerning(p.kerning);
    chordSymbol.setReportWidth(p.reportWidth);
    if (typeof p.fontFamily === "string" && typeof p.fontSize === "number") {
      if (typeof p.fontWeight === "string")
        chordSymbol.setFont(p.fontFamily, p.fontSize, p.fontWeight);
      else
        chordSymbol.setFont(p.fontFamily, p.fontSize, "");
    } else if (typeof p.fontSize === "number") {
      chordSymbol.setFontSize(p.fontSize);
    }
    chordSymbol.setContext(this.context);
    return chordSymbol;
  }
  Articulation(params) {
    var _a;
    const articulation = new Articulation((_a = params === null || params === void 0 ? void 0 : params.type) !== null && _a !== void 0 ? _a : "a.");
    if ((params === null || params === void 0 ? void 0 : params.position) != void 0)
      articulation.setPosition(params.position);
    if ((params === null || params === void 0 ? void 0 : params.betweenLines) != void 0)
      articulation.setBetweenLines(params.betweenLines);
    articulation.setContext(this.context);
    return articulation;
  }
  Ornament(type, params) {
    const options = Object.assign({ type, position: 0, accidental: "" }, params);
    const ornament = new Ornament(type);
    ornament.setPosition(options.position);
    if (options.upperAccidental) {
      ornament.setUpperAccidental(options.upperAccidental);
    }
    if (options.lowerAccidental) {
      ornament.setLowerAccidental(options.lowerAccidental);
    }
    if (typeof options.delayed !== "undefined") {
      ornament.setDelayed(options.delayed);
    }
    ornament.setContext(this.context);
    return ornament;
  }
  TextDynamics(params) {
    const p = Object.assign({ text: "p", duration: "q", dots: 0, line: 0 }, params);
    const text = new TextDynamics({
      text: p.text,
      line: p.line,
      duration: p.duration,
      dots: p.dots
    });
    if (this.stave)
      text.setStave(this.stave);
    text.setContext(this.context);
    this.renderQ.push(text);
    return text;
  }
  Fingering(params) {
    const p = Object.assign({ number: "0", position: "left" }, params);
    const fingering = new FretHandFinger(p.number);
    fingering.setPosition(p.position);
    fingering.setContext(this.context);
    return fingering;
  }
  StringNumber(params, drawCircle = true) {
    const stringNumber = new StringNumber(params.number);
    stringNumber.setPosition(params.position);
    stringNumber.setContext(this.context);
    stringNumber.setDrawCircle(drawCircle);
    return stringNumber;
  }
  TickContext() {
    return new TickContext();
  }
  ModifierContext() {
    return new ModifierContext();
  }
  MultiMeasureRest(params) {
    const numMeasures = defined(params.number_of_measures, "NoNumberOfMeasures");
    const multiMeasureRest = new MultiMeasureRest(numMeasures, params);
    multiMeasureRest.setContext(this.context);
    this.renderQ.push(multiMeasureRest);
    return multiMeasureRest;
  }
  Voice(params) {
    const p = Object.assign({ time: "4/4" }, params);
    const voice = new Voice(p.time);
    this.voices.push(voice);
    return voice;
  }
  StaveConnector(params) {
    const connector = new StaveConnector(params.top_stave, params.bottom_stave);
    connector.setType(params.type).setContext(this.context);
    this.renderQ.push(connector);
    return connector;
  }
  Formatter(options) {
    return new Formatter(options);
  }
  Tuplet(params) {
    const p = Object.assign({ notes: [], options: {} }, params);
    const tuplet = new Tuplet(p.notes, p.options).setContext(this.context);
    this.renderQ.push(tuplet);
    return tuplet;
  }
  Beam(params) {
    var _a, _b, _c, _d, _e;
    const beam = new Beam(params.notes, (_a = params.options) === null || _a === void 0 ? void 0 : _a.autoStem).setContext(this.context);
    beam.breakSecondaryAt((_c = (_b = params.options) === null || _b === void 0 ? void 0 : _b.secondaryBeamBreaks) !== null && _c !== void 0 ? _c : []);
    if ((_d = params.options) === null || _d === void 0 ? void 0 : _d.partialBeamDirections) {
      Object.entries((_e = params.options) === null || _e === void 0 ? void 0 : _e.partialBeamDirections).forEach(([noteIndex, direction]) => {
        beam.setPartialBeamSideAt(Number(noteIndex), direction);
      });
    }
    this.renderQ.push(beam);
    return beam;
  }
  Curve(params) {
    const curve = new Curve(params.from, params.to, params.options).setContext(this.context);
    this.renderQ.push(curve);
    return curve;
  }
  StaveTie(params) {
    var _a;
    const tie = new StaveTie({
      first_note: params.from,
      last_note: params.to,
      first_indices: params.first_indices,
      last_indices: params.last_indices
    }, params.text);
    if ((_a = params.options) === null || _a === void 0 ? void 0 : _a.direction)
      tie.setDirection(params.options.direction);
    tie.setContext(this.context);
    this.renderQ.push(tie);
    return tie;
  }
  StaveLine(params) {
    var _a, _b;
    const line = new StaveLine({
      first_note: params.from,
      last_note: params.to,
      first_indices: params.first_indices,
      last_indices: params.last_indices
    });
    if ((_a = params.options) === null || _a === void 0 ? void 0 : _a.text)
      line.setText(params.options.text);
    if ((_b = params.options) === null || _b === void 0 ? void 0 : _b.font)
      line.setFont(params.options.font);
    line.setContext(this.context);
    this.renderQ.push(line);
    return line;
  }
  VibratoBracket(params) {
    const vibratoBracket = new VibratoBracket({
      start: params.from,
      stop: params.to
    });
    if (params.options.line)
      vibratoBracket.setLine(params.options.line);
    if (params.options.harsh)
      vibratoBracket.setHarsh(params.options.harsh);
    vibratoBracket.setContext(this.context);
    this.renderQ.push(vibratoBracket);
    return vibratoBracket;
  }
  TextBracket(params) {
    const textBracket = new TextBracket({
      start: params.from,
      stop: params.to,
      text: params.text,
      superscript: params.options.superscript,
      position: params.options.position
    });
    if (params.options.line)
      textBracket.setLine(params.options.line);
    if (params.options.font)
      textBracket.setFont(params.options.font);
    textBracket.setContext(this.context);
    this.renderQ.push(textBracket);
    return textBracket;
  }
  System(params = {}) {
    params.factory = this;
    const system = new System(params).setContext(this.context);
    this.systems.push(system);
    return system;
  }
  EasyScore(options = {}) {
    options.factory = this;
    return new EasyScore(options);
  }
  PedalMarking(params) {
    const p = Object.assign({ notes: [], options: {
      style: "mixed"
    } }, params);
    const pedal = new PedalMarking(p.notes);
    pedal.setType(PedalMarking.typeString[p.options.style]);
    pedal.setContext(this.context);
    this.renderQ.push(pedal);
    return pedal;
  }
  NoteSubGroup(params) {
    const p = Object.assign({ notes: [] }, params);
    const group = new NoteSubGroup(p.notes);
    group.setContext(this.context);
    return group;
  }
  draw() {
    const ctx = this.context;
    this.systems.forEach((s) => s.setContext(ctx).format());
    this.staves.forEach((s) => s.setContext(ctx).draw());
    this.voices.forEach((v) => v.setContext(ctx).draw());
    this.renderQ.forEach((e) => {
      if (!e.isRendered())
        e.setContext(ctx).draw();
    });
    this.systems.forEach((s) => s.setContext(ctx).draw());
    this.reset();
  }
};
Factory.DEBUG = false;
Factory.TEXT_FONT = Object.assign({}, Element.TEXT_FONT);

// node_modules/vexflow/build/esm/src/gracetabnote.js
var GraceTabNote = class extends TabNote {
  static get CATEGORY() {
    return "GraceTabNote";
  }
  constructor(noteStruct) {
    super(noteStruct, false);
    this.render_options = Object.assign(Object.assign({}, this.render_options), { y_shift: 0.3, scale: 0.6, font: `7.5pt ${Font.SANS_SERIF}` });
    this.updateWidth();
  }
};

// node_modules/vexflow/build/esm/src/keymanager.js
var KeyManager = class {
  constructor(key) {
    this.music = new Music();
    this.setKey(key);
  }
  setKey(key) {
    this.key = key;
    this.reset();
    return this;
  }
  getKey() {
    return this.key;
  }
  reset() {
    this.keyParts = this.music.getKeyParts(this.key);
    this.keyString = this.keyParts.root;
    if (this.keyParts.accidental)
      this.keyString += this.keyParts.accidental;
    const is_supported_type = Music.scaleTypes[this.keyParts.type];
    if (!is_supported_type) {
      throw new RuntimeError("BadArguments", `Unsupported key type: ${this.key}`);
    }
    this.scale = this.music.getScaleTones(this.music.getNoteValue(this.keyString), Music.scaleTypes[this.keyParts.type]);
    this.scaleMap = {};
    this.scaleMapByValue = {};
    this.originalScaleMapByValue = {};
    const noteLocation = Music.root_indices[this.keyParts.root];
    for (let i = 0; i < Music.roots.length; ++i) {
      const index = (noteLocation + i) % Music.roots.length;
      const rootName = Music.roots[index];
      const noteName = this.music.getRelativeNoteName(rootName, this.scale[i]);
      this.scaleMap[rootName] = noteName;
      this.scaleMapByValue[this.scale[i]] = noteName;
      this.originalScaleMapByValue[this.scale[i]] = noteName;
    }
    return this;
  }
  getAccidental(key) {
    const root = this.music.getKeyParts(key).root;
    const parts = this.music.getNoteParts(this.scaleMap[root]);
    return {
      note: this.scaleMap[root],
      accidental: parts.accidental
    };
  }
  selectNote(note) {
    note = note.toLowerCase();
    const parts = this.music.getNoteParts(note);
    const scaleNote = this.scaleMap[parts.root];
    const modparts = this.music.getNoteParts(scaleNote);
    if (scaleNote === note) {
      return {
        note: scaleNote,
        accidental: parts.accidental,
        change: false
      };
    }
    const valueNote = this.scaleMapByValue[this.music.getNoteValue(note)];
    if (valueNote != null) {
      return {
        note: valueNote,
        accidental: this.music.getNoteParts(valueNote).accidental,
        change: false
      };
    }
    const originalValueNote = this.originalScaleMapByValue[this.music.getNoteValue(note)];
    if (originalValueNote != null) {
      this.scaleMap[modparts.root] = originalValueNote;
      delete this.scaleMapByValue[this.music.getNoteValue(scaleNote)];
      this.scaleMapByValue[this.music.getNoteValue(note)] = originalValueNote;
      return {
        note: originalValueNote,
        accidental: this.music.getNoteParts(originalValueNote).accidental,
        change: true
      };
    }
    if (modparts.root === note) {
      delete this.scaleMapByValue[this.music.getNoteValue(this.scaleMap[parts.root])];
      this.scaleMapByValue[this.music.getNoteValue(modparts.root)] = modparts.root;
      this.scaleMap[modparts.root] = modparts.root;
      return {
        note: modparts.root,
        accidental: void 0,
        change: true
      };
    }
    delete this.scaleMapByValue[this.music.getNoteValue(this.scaleMap[parts.root])];
    this.scaleMapByValue[this.music.getNoteValue(note)] = note;
    delete this.scaleMap[modparts.root];
    this.scaleMap[modparts.root] = note;
    return {
      note,
      accidental: parts.accidental,
      change: true
    };
  }
};

// node_modules/vexflow/build/esm/src/stavehairpin.js
var StaveHairpin = class _StaveHairpin extends Element {
  static get CATEGORY() {
    return "StaveHairpin";
  }
  static FormatByTicksAndDraw(ctx, formatter, notes, type, position, options) {
    var _a, _b;
    const ppt = formatter.pixelsPerTick;
    if (ppt == null) {
      throw new RuntimeError("BadArguments", "A valid Formatter must be provide to draw offsets by ticks.");
    }
    const l_shift_px = ppt * ((_a = options.left_shift_ticks) !== null && _a !== void 0 ? _a : 0);
    const r_shift_px = ppt * ((_b = options.right_shift_ticks) !== null && _b !== void 0 ? _b : 0);
    const hairpin_options = {
      height: options.height,
      y_shift: options.y_shift,
      left_shift_px: l_shift_px,
      right_shift_px: r_shift_px,
      right_shift_ticks: 0,
      left_shift_ticks: 0
    };
    new _StaveHairpin({
      first_note: notes.first_note,
      last_note: notes.last_note
    }, type).setContext(ctx).setRenderOptions(hairpin_options).setPosition(position).draw();
  }
  constructor(notes, type) {
    super();
    this.setNotes(notes);
    this.hairpin = type;
    this.position = Modifier.Position.BELOW;
    this.render_options = {
      height: 10,
      y_shift: 0,
      left_shift_px: 0,
      right_shift_px: 0,
      right_shift_ticks: 0,
      left_shift_ticks: 0
    };
  }
  setPosition(position) {
    if (position === Modifier.Position.ABOVE || position === Modifier.Position.BELOW) {
      this.position = position;
    }
    return this;
  }
  setRenderOptions(options) {
    if (options.height != null && options.y_shift != null && options.left_shift_px != null && options.right_shift_px != null) {
      this.render_options = options;
    }
    return this;
  }
  setNotes(notes) {
    if (!notes.first_note && !notes.last_note) {
      throw new RuntimeError("BadArguments", "Hairpin needs to have either first_note or last_note set.");
    }
    this.notes = notes;
    this.first_note = notes.first_note;
    this.last_note = notes.last_note;
    return this;
  }
  renderHairpin(params) {
    const ctx = this.checkContext();
    let dis = this.render_options.y_shift + 20;
    let y_shift = params.first_y;
    if (this.position === Modifier.Position.ABOVE) {
      dis = -dis + 30;
      y_shift = params.first_y - params.staff_height;
    }
    const l_shift = this.render_options.left_shift_px;
    const r_shift = this.render_options.right_shift_px;
    ctx.beginPath();
    switch (this.hairpin) {
      case _StaveHairpin.type.CRESC:
        ctx.moveTo(params.last_x + r_shift, y_shift + dis);
        ctx.lineTo(params.first_x + l_shift, y_shift + this.render_options.height / 2 + dis);
        ctx.lineTo(params.last_x + r_shift, y_shift + this.render_options.height + dis);
        break;
      case _StaveHairpin.type.DECRESC:
        ctx.moveTo(params.first_x + l_shift, y_shift + dis);
        ctx.lineTo(params.last_x + r_shift, y_shift + this.render_options.height / 2 + dis);
        ctx.lineTo(params.first_x + l_shift, y_shift + this.render_options.height + dis);
        break;
      default:
        break;
    }
    ctx.stroke();
    ctx.closePath();
  }
  draw() {
    this.checkContext();
    this.setRendered();
    const firstNote = this.first_note;
    const lastNote = this.last_note;
    if (!firstNote || !lastNote)
      throw new RuntimeError("NoNote", "Notes required to draw");
    const start = firstNote.getModifierStartXY(this.position, 0);
    const end = lastNote.getModifierStartXY(this.position, 0);
    this.renderHairpin({
      first_x: start.x,
      last_x: end.x,
      first_y: firstNote.checkStave().getY() + firstNote.checkStave().getHeight(),
      last_y: lastNote.checkStave().getY() + lastNote.checkStave().getHeight(),
      staff_height: firstNote.checkStave().getHeight()
    });
  }
};
StaveHairpin.type = {
  CRESC: 1,
  DECRESC: 2
};

// node_modules/vexflow/build/esm/src/tabslide.js
var TabSlide = class _TabSlide extends TabTie {
  static get CATEGORY() {
    return "TabSlide";
  }
  static get SLIDE_UP() {
    return 1;
  }
  static get SLIDE_DOWN() {
    return -1;
  }
  static createSlideUp(notes) {
    return new _TabSlide(notes, _TabSlide.SLIDE_UP);
  }
  static createSlideDown(notes) {
    return new _TabSlide(notes, _TabSlide.SLIDE_DOWN);
  }
  constructor(notes, direction) {
    super(notes, "sl.");
    if (!direction) {
      let first_fret = notes.first_note.getPositions()[0].fret;
      if (typeof first_fret === "string") {
        first_fret = parseInt(first_fret, 10);
      }
      let last_fret = notes.last_note.getPositions()[0].fret;
      if (typeof last_fret === "string") {
        last_fret = parseInt(last_fret, 10);
      }
      if (isNaN(first_fret) || isNaN(last_fret)) {
        direction = _TabSlide.SLIDE_UP;
      } else {
        direction = first_fret > last_fret ? _TabSlide.SLIDE_DOWN : _TabSlide.SLIDE_UP;
      }
    }
    this.direction = direction;
    this.render_options.cp1 = 11;
    this.render_options.cp2 = 14;
    this.render_options.y_shift = 0.5;
    this.resetFont();
  }
  renderTie(params) {
    if (params.first_ys.length === 0 || params.last_ys.length === 0) {
      throw new RuntimeError("BadArguments", "No Y-values to render");
    }
    const ctx = this.checkContext();
    const first_x_px = params.first_x_px;
    const first_ys = params.first_ys;
    const last_x_px = params.last_x_px;
    const direction = params.direction;
    if (direction !== _TabSlide.SLIDE_UP && direction !== _TabSlide.SLIDE_DOWN) {
      throw new RuntimeError("BadSlide", "Invalid slide direction");
    }
    const first_indices = this.notes.first_indices;
    for (let i = 0; i < first_indices.length; ++i) {
      const slide_y = first_ys[first_indices[i]] + this.render_options.y_shift;
      if (isNaN(slide_y)) {
        throw new RuntimeError("BadArguments", "Bad indices for slide rendering.");
      }
      ctx.beginPath();
      ctx.moveTo(first_x_px, slide_y + 3 * direction);
      ctx.lineTo(last_x_px, slide_y - 3 * direction);
      ctx.closePath();
      ctx.stroke();
    }
    this.setRendered();
  }
};
TabSlide.TEXT_FONT = {
  family: Font.SERIF,
  size: 10,
  weight: FontWeight.BOLD,
  style: FontStyle.ITALIC
};

// node_modules/vexflow/build/esm/src/tremolo.js
var Tremolo = class extends Modifier {
  static get CATEGORY() {
    return "Tremolo";
  }
  constructor(num) {
    super();
    this.num = num;
    this.position = Modifier.Position.CENTER;
    this.code = "tremolo1";
    this.y_spacing_scale = 1;
    this.extra_stroke_scale = 1;
  }
  draw() {
    var _a;
    const ctx = this.checkContext();
    const note = this.checkAttachedNote();
    this.setRendered();
    const stemDirection = note.getStemDirection();
    const start = note.getModifierStartXY(this.position, this.index);
    let x = start.x;
    const gn = isGraceNote(note);
    const scale = gn ? GraceNote.SCALE : 1;
    const category = `tremolo.${gn ? "grace" : "default"}`;
    const musicFont = Tables.currentMusicFont();
    let y_spacing = musicFont.lookupMetric(`${category}.spacing`) * stemDirection;
    y_spacing *= this.y_spacing_scale;
    const height = this.num * y_spacing;
    let y = note.getStemExtents().baseY - height;
    if (stemDirection < 0) {
      y += musicFont.lookupMetric(`${category}.offsetYStemDown`) * scale;
    } else {
      y += musicFont.lookupMetric(`${category}.offsetYStemUp`) * scale;
    }
    const fontScale = (_a = musicFont.lookupMetric(`${category}.point`)) !== null && _a !== void 0 ? _a : Note.getPoint(gn ? "grace" : "default");
    x += musicFont.lookupMetric(`${category}.offsetXStem${stemDirection === Stem.UP ? "Up" : "Down"}`);
    for (let i = 0; i < this.num; ++i) {
      Glyph.renderGlyph(ctx, x, y, fontScale, this.code, { category, scale: this.extra_stroke_scale });
      y += y_spacing;
    }
  }
};

// node_modules/vexflow/build/esm/src/tuning.js
var Tuning = class _Tuning {
  static get names() {
    return {
      standard: "E/5,B/4,G/4,D/4,A/3,E/3",
      dagdad: "D/5,A/4,G/4,D/4,A/3,D/3",
      dropd: "E/5,B/4,G/4,D/4,A/3,D/3",
      eb: "Eb/5,Bb/4,Gb/4,Db/4,Ab/3,Db/3",
      standardBanjo: "D/5,B/4,G/4,D/4,G/5"
    };
  }
  constructor(tuningString = "E/5,B/4,G/4,D/4,A/3,E/3,B/2,E/2") {
    this.tuningValues = [];
    this.setTuning(tuningString);
  }
  noteToInteger(noteString) {
    var _a;
    return (_a = Tables.keyProperties(noteString).int_value) !== null && _a !== void 0 ? _a : -1;
  }
  setTuning(tuningString) {
    if (_Tuning.names[tuningString]) {
      tuningString = _Tuning.names[tuningString];
    }
    this.tuningValues = [];
    const keys = tuningString.split(/\s*,\s*/);
    if (keys.length === 0) {
      throw new RuntimeError("BadArguments", `Invalid tuning string: ${tuningString}`);
    }
    for (let i = 0; i < keys.length; ++i) {
      this.tuningValues[i] = this.noteToInteger(keys[i]);
    }
  }
  getValueForString(stringNum) {
    const s = Number(stringNum);
    if (s < 1 || s > this.tuningValues.length) {
      throw new RuntimeError("BadArguments", `String number must be between 1 and ${this.tuningValues.length}:${stringNum}`);
    }
    return this.tuningValues[s - 1];
  }
  getValueForFret(fretNum, stringNum) {
    const stringValue = this.getValueForString(stringNum);
    const f = Number(fretNum);
    if (f < 0) {
      throw new RuntimeError("BadArguments", `Fret number must be 0 or higher: ${fretNum}`);
    }
    return stringValue + f;
  }
  getNoteForFret(fretNum, stringNum) {
    const noteValue = this.getValueForFret(fretNum, stringNum);
    const octave = Math.floor(noteValue / 12);
    const value = noteValue % 12;
    return `${Tables.integerToNote(value)}/${octave}`;
  }
};

// node_modules/vexflow/build/esm/src/version.js
var VERSION = "4.2.2";
var ID = "7ad933bdf12b4137ce04d3f332a838887d08a595";
var DATE = "2023-07-03T19:56:22.952Z";

// node_modules/vexflow/build/esm/src/flow.js
var __awaiter2 = function(thisArg, _arguments, P, generator) {
  function adopt(value) {
    return value instanceof P ? value : new P(function(resolve) {
      resolve(value);
    });
  }
  return new (P || (P = Promise))(function(resolve, reject) {
    function fulfilled(value) {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    }
    function rejected(value) {
      try {
        step(generator["throw"](value));
      } catch (e) {
        reject(e);
      }
    }
    function step(result) {
      result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
    }
    step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
};
var Flow = class {
  static get BUILD() {
    return {
      VERSION,
      ID,
      DATE
    };
  }
  static setMusicFont(...fontNames) {
    const fonts = fontNames.map((fontName) => Font.load(fontName));
    Tables.MUSIC_FONT_STACK = fonts;
    Glyph.MUSIC_FONT_STACK = fonts.slice();
    Glyph.CURRENT_CACHE_KEY = fontNames.join(",");
    return fonts;
  }
  static fetchMusicFont(fontName, fontModuleOrPath) {
    return __awaiter2(this, void 0, void 0, function* () {
    });
  }
  static getMusicFont() {
    const fonts = Tables.MUSIC_FONT_STACK;
    return fonts.map((font) => font.getName());
  }
  static getMusicFontStack() {
    return Tables.MUSIC_FONT_STACK;
  }
  static get RENDER_PRECISION_PLACES() {
    return Tables.RENDER_PRECISION_PLACES;
  }
  static set RENDER_PRECISION_PLACES(precision) {
    Tables.RENDER_PRECISION_PLACES = precision;
  }
  static get SOFTMAX_FACTOR() {
    return Tables.SOFTMAX_FACTOR;
  }
  static set SOFTMAX_FACTOR(factor) {
    Tables.SOFTMAX_FACTOR = factor;
  }
  static get NOTATION_FONT_SCALE() {
    return Tables.NOTATION_FONT_SCALE;
  }
  static set NOTATION_FONT_SCALE(value) {
    Tables.NOTATION_FONT_SCALE = value;
  }
  static get TABLATURE_FONT_SCALE() {
    return Tables.TABLATURE_FONT_SCALE;
  }
  static set TABLATURE_FONT_SCALE(value) {
    Tables.TABLATURE_FONT_SCALE = value;
  }
  static get RESOLUTION() {
    return Tables.RESOLUTION;
  }
  static set RESOLUTION(value) {
    Tables.RESOLUTION = value;
  }
  static get SLASH_NOTEHEAD_WIDTH() {
    return Tables.SLASH_NOTEHEAD_WIDTH;
  }
  static set SLASH_NOTEHEAD_WIDTH(value) {
    Tables.SLASH_NOTEHEAD_WIDTH = value;
  }
  static get STAVE_LINE_DISTANCE() {
    return Tables.STAVE_LINE_DISTANCE;
  }
  static set STAVE_LINE_DISTANCE(value) {
    Tables.STAVE_LINE_DISTANCE = value;
  }
  static get STAVE_LINE_THICKNESS() {
    return Tables.STAVE_LINE_THICKNESS;
  }
  static set STAVE_LINE_THICKNESS(value) {
    Tables.STAVE_LINE_THICKNESS = value;
  }
  static get STEM_HEIGHT() {
    return Tables.STEM_HEIGHT;
  }
  static set STEM_HEIGHT(value) {
    Tables.STEM_HEIGHT = value;
  }
  static get STEM_WIDTH() {
    return Tables.STEM_WIDTH;
  }
  static set STEM_WIDTH(value) {
    Tables.STEM_WIDTH = value;
  }
  static get TIME4_4() {
    return Tables.TIME4_4;
  }
  static get accidentalMap() {
    return Tables.accidentalMap;
  }
  static get unicode() {
    return Tables.unicode;
  }
  static keySignature(spec) {
    return Tables.keySignature(spec);
  }
  static hasKeySignature(spec) {
    return Tables.hasKeySignature(spec);
  }
  static getKeySignatures() {
    return Tables.getKeySignatures();
  }
  static clefProperties(clef) {
    return Tables.clefProperties(clef);
  }
  static keyProperties(key, clef, params) {
    return Tables.keyProperties(key, clef, params);
  }
  static durationToTicks(duration) {
    return Tables.durationToTicks(duration);
  }
};
Flow.Accidental = Accidental;
Flow.Annotation = Annotation;
Flow.Articulation = Articulation;
Flow.Barline = Barline;
Flow.BarNote = BarNote;
Flow.Beam = Beam;
Flow.Bend = Bend;
Flow.BoundingBox = BoundingBox;
Flow.BoundingBoxComputation = BoundingBoxComputation;
Flow.CanvasContext = CanvasContext;
Flow.ChordSymbol = ChordSymbol;
Flow.Clef = Clef;
Flow.ClefNote = ClefNote;
Flow.Crescendo = Crescendo;
Flow.Curve = Curve;
Flow.Dot = Dot;
Flow.EasyScore = EasyScore;
Flow.Element = Element;
Flow.Factory = Factory;
Flow.Font = Font;
Flow.Formatter = Formatter;
Flow.Fraction = Fraction;
Flow.FretHandFinger = FretHandFinger;
Flow.GhostNote = GhostNote;
Flow.Glyph = Glyph;
Flow.GlyphNote = GlyphNote;
Flow.GraceNote = GraceNote;
Flow.GraceNoteGroup = GraceNoteGroup;
Flow.GraceTabNote = GraceTabNote;
Flow.KeyManager = KeyManager;
Flow.KeySignature = KeySignature;
Flow.KeySigNote = KeySigNote;
Flow.Modifier = Modifier;
Flow.ModifierContext = ModifierContext;
Flow.MultiMeasureRest = MultiMeasureRest;
Flow.Music = Music;
Flow.Note = Note;
Flow.NoteHead = NoteHead;
Flow.NoteSubGroup = NoteSubGroup;
Flow.Ornament = Ornament;
Flow.Parenthesis = Parenthesis;
Flow.Parser = Parser;
Flow.PedalMarking = PedalMarking;
Flow.Registry = Registry;
Flow.RenderContext = RenderContext;
Flow.Renderer = Renderer;
Flow.RepeatNote = RepeatNote;
Flow.Repetition = Repetition;
Flow.Stave = Stave;
Flow.StaveConnector = StaveConnector;
Flow.StaveHairpin = StaveHairpin;
Flow.StaveLine = StaveLine;
Flow.StaveModifier = StaveModifier;
Flow.StaveNote = StaveNote;
Flow.StaveTempo = StaveTempo;
Flow.StaveText = StaveText;
Flow.StaveTie = StaveTie;
Flow.Stem = Stem;
Flow.StringNumber = StringNumber;
Flow.Stroke = Stroke;
Flow.SVGContext = SVGContext;
Flow.System = System;
Flow.TabNote = TabNote;
Flow.TabSlide = TabSlide;
Flow.TabStave = TabStave;
Flow.TabTie = TabTie;
Flow.TextBracket = TextBracket;
Flow.TextDynamics = TextDynamics;
Flow.TextFormatter = TextFormatter;
Flow.TextNote = TextNote;
Flow.TickContext = TickContext;
Flow.TimeSignature = TimeSignature;
Flow.TimeSigNote = TimeSigNote;
Flow.Tremolo = Tremolo;
Flow.Tuning = Tuning;
Flow.Tuplet = Tuplet;
Flow.Vibrato = Vibrato;
Flow.VibratoBracket = VibratoBracket;
Flow.Voice = Voice;
Flow.Volta = Volta;
Flow.AnnotationHorizontalJustify = AnnotationHorizontalJustify;
Flow.AnnotationVerticalJustify = AnnotationVerticalJustify;
Flow.ChordSymbolHorizontalJustify = ChordSymbolHorizontalJustify;
Flow.ChordSymbolVerticalJustify = ChordSymbolVerticalJustify;
Flow.SymbolTypes = SymbolTypes;
Flow.SymbolModifiers = SymbolModifiers;
Flow.CurvePosition = CurvePosition;
Flow.FontWeight = FontWeight;
Flow.FontStyle = FontStyle;
Flow.ModifierPosition = ModifierPosition;
Flow.RendererBackends = RendererBackends;
Flow.RendererLineEndType = RendererLineEndType;
Flow.BarlineType = BarlineType;
Flow.StaveModifierPosition = StaveModifierPosition;
Flow.VoltaType = VoltaType;
Flow.TextBracketPosition = TextBracketPosition;
Flow.TextJustification = TextJustification;
Flow.VoiceMode = VoiceMode;

// node_modules/vexflow/build/esm/src/fonts/bravura_glyphs.js
var BravuraFont = {
  glyphs: {
    bracketTop: {
      x_min: 0,
      x_max: 469,
      y_min: 0,
      y_max: 295,
      ha: 295,
      o: "m 0 0 l 180 0 b 674 390 410 43 616 150 b 675 405 675 396 675 400 b 664 425 675 416 671 422 b 628 405 651 425 635 415 b 157 179 613 389 432 199 l 12 179 b 0 168 3 179 0 177 z"
    },
    bracketBottom: {
      x_min: 0,
      x_max: 469,
      y_min: -295,
      y_max: 0,
      ha: 295,
      o: "m 0 -168 b 12 -179 0 -177 3 -179 l 157 -179 b 628 -405 432 -199 613 -389 b 664 -425 635 -415 651 -425 b 675 -405 671 -422 675 -416 b 674 -390 675 -400 675 -396 b 180 0 616 -150 410 -43 l 0 0 z"
    },
    barlineTick: {
      x_min: 0,
      x_max: 36,
      y_min: 868,
      y_max: 1120,
      ha: 252,
      o: "m 52 1250 l 52 1613 l 0 1613 l 0 1250 z"
    },
    breathMarkTick: {
      x_min: 0,
      x_max: 500,
      y_min: 0,
      y_max: 502,
      ha: 502,
      o: "m 9 367 b 0 374 6 372 3 374 b 9 334 0 367 0 343 b 179 19 40 312 164 121 b 192 0 179 3 186 0 b 210 19 197 0 207 6 b 698 701 245 197 507 658 b 720 714 714 704 720 711 b 698 723 720 720 711 723 b 197 186 455 714 210 202 b 186 176 194 179 189 176 b 176 186 179 176 176 186 b 9 367 143 266 27 359 z"
    },
    segno: {
      x_min: 4,
      x_max: 550,
      y_min: -27,
      y_max: 759,
      ha: 786,
      o: "m 194 958 b 217 939 203 958 213 955 l 220 929 b 325 805 230 890 252 805 b 425 901 384 805 425 840 b 413 969 425 923 420 946 b 220 1060 390 1035 294 1060 b 6 793 120 1060 6 936 b 29 687 6 759 13 723 b 295 449 75 582 284 454 b 304 438 301 446 304 444 b 295 415 304 432 301 425 b 78 22 285 395 78 22 b 73 3 75 16 73 9 b 114 -39 73 -20 91 -39 b 150 -17 128 -39 143 -30 b 377 395 150 -17 373 386 b 395 402 377 393 389 402 b 704 176 416 397 704 312 b 621 75 704 120 670 82 l 616 73 b 562 138 586 73 562 94 l 562 154 b 485 249 562 209 526 249 b 468 246 480 249 474 248 b 366 153 415 233 366 210 b 540 -12 366 65 455 -12 b 600 -1 559 -12 579 -9 b 792 251 716 37 792 131 b 789 292 792 264 791 278 b 523 588 768 451 540 579 b 498 611 505 598 498 603 b 501 619 498 613 500 616 b 732 1032 508 631 732 1032 b 737 1053 736 1040 737 1045 b 697 1093 737 1076 719 1093 b 661 1073 683 1093 668 1086 b 423 647 661 1073 432 660 b 410 635 419 639 416 635 b 396 639 406 635 402 636 b 128 792 383 644 166 727 b 108 868 120 808 108 838 b 186 958 108 907 125 948 z m 598 671 b 680 589 598 626 635 589 b 762 671 726 589 762 626 b 680 753 762 717 726 753 b 598 671 635 753 598 717 z m 202 380 b 120 462 202 425 166 462 b 37 380 75 462 37 425 b 120 298 37 334 75 298 b 202 380 166 298 202 334 z"
    },
    coda: {
      x_min: -4,
      x_max: 955,
      y_min: -158,
      y_max: 898,
      ha: 1056,
      o: "m 1349 576 l 1178 576 b 729 1083 1164 847 962 1064 l 729 1269 b 694 1293 729 1287 713 1293 b 660 1269 675 1293 660 1287 l 660 1083 b 210 576 426 1064 226 848 l 20 576 b -6 541 0 576 -6 560 b 20 507 -6 523 0 507 l 210 507 b 660 0 226 238 426 19 l 660 -202 b 694 -228 660 -222 675 -228 b 729 -202 713 -228 729 -222 l 729 0 b 1178 507 962 19 1164 238 l 1349 507 b 1375 541 1369 507 1375 523 b 1349 576 1375 560 1369 576 z m 940 576 l 729 576 l 729 1002 b 940 576 930 985 940 809 z m 660 1002 l 660 576 l 455 576 b 660 1002 455 809 455 985 z m 455 507 l 660 507 l 660 69 b 455 507 474 91 456 285 z m 729 69 l 729 507 l 940 507 b 729 69 936 287 909 91 z"
    },
    gClef: {
      x_min: 0,
      x_max: 671,
      y_min: -658,
      y_max: 1098,
      ha: 1756,
      o: "m 541 598 b 550 625 539 615 541 616 b 824 1174 706 770 824 953 b 730 1509 824 1299 789 1423 b 655 1581 708 1541 671 1581 b 562 1512 635 1581 590 1544 b 420 1064 455 1394 420 1214 b 441 828 420 981 431 887 b 428 793 444 811 445 808 b 0 125 220 622 0 416 b 524 -363 0 -125 171 -363 b 624 -354 557 -363 595 -360 b 645 -367 639 -351 642 -350 b 684 -657 662 -464 684 -589 b 455 -896 684 -870 540 -896 b 340 -854 377 -896 340 -873 b 386 -829 340 -844 353 -840 b 482 -694 431 -816 482 -778 b 344 -547 482 -615 432 -547 b 190 -713 248 -547 190 -624 b 464 -948 190 -806 246 -948 b 747 -660 560 -948 747 -904 b 706 -351 747 -577 721 -441 b 724 -327 703 -334 704 -336 b 966 16 870 -269 966 -147 b 619 363 966 200 831 363 b 577 389 582 363 582 363 z m 677 1358 b 763 1240 724 1358 763 1319 b 513 851 763 1080 626 950 b 494 863 503 842 497 844 b 485 995 488 900 485 949 b 677 1358 485 1220 589 1358 z m 520 377 b 498 343 524 350 524 351 b 289 63 372 300 289 186 b 455 -192 289 -66 357 -158 b 494 -200 467 -196 484 -200 b 511 -184 505 -200 511 -193 b 490 -166 511 -174 500 -170 b 386 -12 429 -140 386 -78 b 530 157 386 71 442 132 b 559 145 553 163 556 161 l 631 -284 b 611 -304 634 -300 632 -300 b 530 -311 588 -308 559 -311 b 115 29 278 -311 115 -171 b 249 363 115 114 130 228 b 469 567 336 459 402 513 b 490 562 484 579 487 577 z m 619 148 b 635 168 616 166 618 170 b 848 -66 752 158 848 60 b 713 -271 848 -157 793 -230 b 690 -262 696 -279 693 -279 z"
    },
    cClef: {
      x_min: 0,
      x_max: 699,
      y_min: -506,
      y_max: 506,
      ha: 1012,
      o: "m 331 694 b 301 724 331 714 321 724 l 300 724 b 269 694 279 724 269 714 l 269 -694 b 300 -724 269 -714 279 -724 l 301 -724 b 331 -694 321 -724 331 -714 l 331 -63 b 344 -55 331 -52 338 -53 b 472 -265 382 -65 442 -102 b 500 -301 477 -288 485 -301 b 530 -262 516 -301 523 -287 b 684 -128 549 -199 582 -128 b 804 -409 778 -128 804 -220 b 651 -683 804 -598 770 -683 b 528 -644 631 -683 528 -674 b 567 -622 528 -636 552 -628 b 625 -528 596 -612 625 -583 b 527 -429 625 -465 583 -429 b 416 -547 465 -429 416 -471 b 667 -729 416 -638 495 -729 b 1007 -413 903 -729 1007 -563 b 706 -76 1007 -215 897 -76 b 618 -89 664 -76 636 -84 b 576 -88 603 -94 589 -96 b 524 0 556 -75 524 -29 b 576 88 524 29 556 75 b 618 89 589 96 603 94 b 706 76 636 84 664 76 b 1007 413 897 76 1007 215 b 667 729 1007 563 903 729 b 416 547 495 729 416 638 b 527 429 416 471 465 429 b 625 528 583 429 625 465 b 567 622 625 583 596 612 b 528 644 552 628 528 636 b 651 683 528 674 631 683 b 804 409 770 683 804 598 b 684 128 804 220 778 128 b 530 262 582 128 549 199 b 500 301 523 287 516 301 b 472 265 485 301 477 288 b 344 55 442 102 382 65 b 331 63 338 53 331 52 z m 30 724 b 0 694 10 724 0 714 l 0 -694 b 30 -724 0 -714 10 -724 l 154 -724 b 184 -694 174 -724 184 -714 l 184 694 b 154 724 184 714 174 724 z"
    },
    fClef: {
      x_min: -5,
      x_max: 684,
      y_min: -635,
      y_max: 262,
      ha: 897,
      o: "m 363 377 b 0 56 112 377 0 194 b 177 -158 0 -59 60 -158 b 330 -6 268 -158 330 -95 b 192 144 330 86 262 144 b 120 134 153 144 138 134 b 96 160 101 134 96 145 b 330 323 96 217 183 323 b 549 -53 482 323 549 173 b 14 -871 549 -455 350 -680 b -7 -897 1 -878 -7 -886 b 12 -914 -7 -906 -1 -914 b 36 -907 19 -914 27 -912 b 765 -40 390 -734 765 -478 b 363 377 765 210 612 377 z m 906 259 b 827 180 861 259 827 225 b 906 101 827 135 861 101 b 985 180 950 101 985 135 b 906 259 985 225 950 259 z m 907 -102 b 829 -180 863 -102 829 -135 b 907 -258 829 -225 863 -258 b 985 -180 952 -258 985 -225 b 907 -102 985 -135 952 -102 z"
    },
    unpitchedPercussionClef1: {
      x_min: 0,
      x_max: 382,
      y_min: -250,
      y_max: 250,
      ha: 500,
      o: "m 230 -338 l 230 338 b 210 360 230 350 222 360 l 20 360 b 0 338 9 360 0 350 l 0 -338 b 20 -360 0 -350 9 -360 l 210 -360 b 230 -338 222 -360 230 -350 z m 550 338 b 530 360 550 350 541 360 l 340 360 b 320 338 328 360 320 350 l 320 -338 b 340 -360 320 -350 328 -360 l 530 -360 b 550 -338 541 -360 550 -350 z"
    },
    "6stringTabClef": {
      x_min: -3,
      x_max: 408,
      y_min: -748,
      y_max: 764,
      ha: 1512,
      o: "m 557 1024 l 557 1100 l 26 1100 l 26 1024 l 249 1024 l 249 422 l 336 422 l 336 1024 z m 588 -328 l 350 348 l 238 348 l -4 -328 l 88 -328 l 160 -125 l 420 -125 l 491 -328 z m 397 -52 l 181 -52 l 292 256 z m 544 -883 b 420 -719 544 -802 507 -752 b 514 -572 482 -690 514 -639 b 314 -399 514 -472 442 -399 l 39 -399 l 39 -1077 l 344 -1077 b 544 -883 467 -1077 544 -995 z m 428 -583 b 292 -691 428 -652 389 -691 l 125 -691 l 125 -475 l 292 -475 b 428 -583 389 -475 428 -514 z m 458 -884 b 337 -1001 458 -949 418 -1001 l 125 -1001 l 125 -768 l 337 -768 b 458 -884 418 -768 458 -818 z"
    },
    timeSig0: {
      x_min: 20,
      x_max: 450,
      y_min: -250,
      y_max: 251,
      ha: 501,
      o: "m 648 0 b 338 361 648 200 510 361 b 29 0 167 361 29 200 b 338 -360 29 -199 167 -360 b 648 0 510 -360 648 -199 z m 338 317 b 446 10 397 317 446 180 b 338 -295 446 -158 397 -295 b 230 10 278 -295 230 -158 b 338 317 230 180 278 317 z"
    },
    timeSig1: {
      x_min: 20,
      x_max: 314,
      y_min: -250,
      y_max: 251,
      ha: 501,
      o: "m 35 19 b 29 0 35 19 29 10 b 45 -20 29 -7 33 -16 b 58 -23 50 -22 56 -23 b 78 -10 72 -23 78 -10 b 156 117 78 -10 140 89 b 170 131 161 127 167 131 b 179 111 176 131 179 120 l 179 -261 b 115 -315 179 -294 145 -315 b 91 -337 105 -315 91 -320 b 122 -360 91 -353 104 -360 l 429 -360 b 452 -337 452 -360 452 -337 b 431 -315 452 -337 452 -315 b 384 -265 410 -315 384 -289 l 384 328 b 356 361 384 351 376 360 b 281 356 336 361 300 356 b 206 360 253 356 228 357 b 199 361 203 360 200 361 b 173 334 184 361 179 347 z"
    },
    timeSig2: {
      x_min: 20,
      x_max: 426,
      y_min: -257,
      y_max: 254,
      ha: 511,
      o: "m 606 -131 b 589 -111 606 -114 599 -111 b 570 -127 577 -111 573 -117 l 569 -128 b 513 -192 554 -164 543 -192 b 488 -187 505 -192 498 -190 b 445 -171 469 -180 459 -179 b 289 -137 416 -160 348 -137 b 236 -145 271 -137 252 -140 b 422 -42 268 -94 390 -50 b 613 147 523 -14 613 27 b 330 366 613 300 464 366 b 69 275 229 366 140 357 b 29 170 45 245 29 209 b 42 108 29 150 33 130 b 160 29 63 63 108 29 b 261 156 248 29 261 120 b 161 275 261 242 161 246 b 275 330 164 295 190 330 b 405 192 403 330 405 233 b 193 -102 405 60 297 -39 b 33 -317 114 -153 58 -223 l 32 -321 b 69 -370 32 -340 48 -370 b 203 -282 101 -370 118 -282 b 410 -360 261 -282 282 -360 b 606 -131 472 -360 583 -354 z"
    },
    timeSig3: {
      x_min: 20,
      x_max: 401,
      y_min: -251,
      y_max: 249,
      ha: 500,
      o: "m 307 357 b 301 357 305 357 304 357 l 291 359 b 285 359 289 359 287 359 b 37 200 161 359 37 276 b 154 84 37 153 65 89 l 161 84 b 256 177 225 84 256 130 l 256 189 b 209 248 252 242 216 245 b 180 268 202 251 180 248 l 180 274 b 240 310 183 298 228 310 b 374 199 363 310 374 233 l 374 189 b 199 36 374 82 289 40 b 164 12 184 35 164 27 b 200 -6 164 -6 189 -6 b 379 -137 366 -6 379 -118 b 269 -307 379 -289 301 -307 b 256 -305 264 -307 258 -305 b 216 -282 245 -304 217 -304 l 216 -275 b 249 -180 216 -243 248 -222 b 145 -76 249 -120 207 -76 b 130 -78 140 -76 135 -76 b 60 -115 105 -82 78 -96 b 29 -203 36 -137 29 -171 b 275 -361 32 -315 134 -359 l 288 -361 b 577 -161 431 -361 577 -288 l 577 -151 b 537 -50 575 -109 564 -82 b 503 -20 528 -39 517 -29 l 472 -3 l 425 10 b 410 17 418 12 413 12 b 409 24 409 20 409 22 b 415 37 409 30 410 36 b 459 50 431 42 446 43 b 547 181 517 78 547 115 b 307 357 547 314 367 353 z"
    },
    timeSig4: {
      x_min: 20,
      x_max: 450,
      y_min: -250,
      y_max: 251,
      ha: 501,
      o: "m 521 -107 l 521 202 b 504 226 521 213 520 226 b 475 213 491 226 484 223 l 338 48 b 325 14 333 40 325 32 l 325 -107 l 131 -107 b 481 336 246 -9 477 318 l 482 340 b 461 361 482 353 472 361 b 363 359 448 361 389 359 b 261 361 337 359 272 361 b 228 334 248 361 228 357 b 43 -105 228 156 86 -45 l 35 -117 b 35 -118 35 -117 35 -118 l 33 -120 b 29 -137 30 -127 29 -132 b 58 -161 29 -151 40 -161 l 325 -161 l 325 -252 b 268 -302 325 -291 294 -302 b 235 -330 245 -302 235 -315 b 262 -360 235 -344 240 -360 l 569 -360 b 598 -330 583 -360 598 -350 b 566 -301 598 -310 580 -301 b 521 -246 552 -301 521 -292 l 521 -161 l 626 -161 b 648 -134 641 -161 648 -151 b 626 -107 648 -117 642 -107 z"
    },
    timeSig5: {
      x_min: 20,
      x_max: 383,
      y_min: -251,
      y_max: 246,
      ha: 497,
      o: "m 109 85 b 117 179 109 85 115 166 b 138 197 118 190 125 197 l 144 197 b 285 184 158 194 226 184 b 492 323 485 184 492 300 b 472 353 492 341 488 353 b 295 340 454 353 341 340 b 101 354 249 340 125 351 b 66 330 75 354 68 341 l 50 10 l 50 7 b 79 -14 50 -12 65 -14 b 111 14 94 -14 95 -1 b 209 62 125 29 160 62 b 357 -125 258 62 357 35 b 235 -304 357 -284 272 -304 b 202 -300 223 -304 212 -304 b 184 -279 194 -295 186 -289 b 202 -259 184 -269 194 -264 b 256 -163 235 -239 256 -203 b 144 -50 256 -99 206 -50 b 30 -157 66 -50 35 -107 b 29 -183 29 -166 29 -174 b 284 -361 29 -302 107 -361 b 552 -125 456 -361 552 -255 b 314 112 552 6 445 112 b 122 71 230 112 168 98 b 115 69 120 69 117 69 b 109 79 109 69 109 75 z"
    },
    timeSig6: {
      x_min: 20,
      x_max: 414,
      y_min: -249,
      y_max: 251,
      ha: 500,
      o: "m 439 120 b 554 229 500 120 554 167 b 553 245 554 235 554 239 b 348 361 539 337 426 361 b 85 209 239 360 137 307 b 29 4 53 148 29 72 l 29 -1 b 73 -200 30 -68 42 -143 b 324 -359 132 -307 203 -359 b 513 -307 389 -359 461 -348 b 596 -137 563 -266 596 -202 b 379 72 596 -24 490 72 b 248 22 333 72 285 55 b 239 19 245 19 242 19 b 226 53 230 19 226 30 b 346 327 230 320 315 327 b 393 305 374 327 393 320 b 357 251 393 285 366 268 b 347 209 350 238 347 223 b 369 150 347 187 354 166 b 439 120 379 131 420 120 z m 320 3 b 405 -158 366 3 405 -69 b 320 -320 405 -248 366 -320 b 236 -158 274 -320 236 -248 b 320 3 236 -69 274 3 z"
    },
    timeSig7: {
      x_min: 20,
      x_max: 421,
      y_min: -250,
      y_max: 249,
      ha: 499,
      o: "m 606 294 b 582 351 606 333 606 351 b 552 336 580 351 557 346 b 485 236 541 318 521 236 b 262 359 449 236 382 359 b 137 307 179 359 157 325 b 98 281 117 288 108 282 b 60 315 86 281 68 301 b 43 325 58 321 50 325 b 29 308 36 325 29 321 l 29 71 b 45 48 29 71 30 48 b 66 76 56 48 60 60 b 164 196 81 112 99 196 b 374 88 222 196 291 88 b 446 118 415 88 435 109 b 459 124 451 121 456 124 b 469 111 465 124 468 120 b 272 -112 469 71 359 -10 b 173 -315 217 -176 173 -259 b 200 -360 173 -346 173 -360 b 294 -347 226 -360 258 -347 b 412 -360 330 -347 397 -360 b 435 -307 426 -360 435 -348 b 606 288 435 -66 606 140 z"
    },
    timeSig8: {
      x_min: 20,
      x_max: 416,
      y_min: -259,
      y_max: 259,
      ha: 518,
      o: "m 481 52 b 567 204 533 85 567 132 b 317 373 567 351 356 373 b 36 176 150 373 36 297 b 161 -16 36 76 92 23 b 29 -190 86 -52 29 -99 b 301 -373 29 -315 158 -373 b 599 -117 445 -373 599 -311 b 481 52 599 -30 549 17 z m 406 85 b 168 240 291 125 168 150 b 314 331 168 301 251 331 b 482 207 360 331 482 308 b 406 85 482 150 454 112 z m 295 -325 b 111 -183 199 -325 111 -276 b 225 -48 111 -125 161 -72 b 436 -219 330 -94 436 -124 b 295 -325 436 -276 392 -325 z"
    },
    timeSig9: {
      x_min: 20,
      x_max: 414,
      y_min: -249,
      y_max: 251,
      ha: 500,
      o: "m 186 -117 b 71 -226 125 -117 71 -164 b 72 -242 71 -232 71 -236 b 276 -359 86 -334 199 -359 b 540 -206 386 -357 488 -304 b 596 -1 572 -145 596 -69 l 596 4 b 552 203 595 71 583 145 b 301 361 492 310 422 361 b 112 310 236 361 164 351 b 29 140 62 269 29 204 b 246 -69 29 27 135 -69 b 377 -19 292 -69 340 -52 b 386 -16 380 -16 383 -16 b 399 -50 395 -16 399 -27 b 279 -324 395 -317 310 -324 b 232 -302 251 -324 232 -317 b 268 -248 232 -282 259 -265 b 278 -206 275 -235 278 -220 b 256 -147 278 -184 271 -163 b 186 -117 246 -128 204 -117 z m 305 0 b 220 161 259 0 220 72 b 305 323 220 251 259 323 b 389 161 351 323 389 251 b 305 0 389 72 351 0 z"
    },
    timeSigCommon: {
      x_min: 5,
      x_max: 424,
      y_min: -249,
      y_max: 251,
      ha: 500,
      o: "m 336 361 b 7 -14 131 361 7 180 b 101 -262 7 -108 42 -190 b 321 -359 156 -328 235 -359 b 611 -88 573 -359 611 -130 b 589 -56 611 -56 595 -56 b 567 -82 577 -56 567 -58 b 363 -311 567 -268 409 -311 b 184 40 246 -311 184 -197 b 372 327 184 278 294 327 b 477 278 446 327 477 292 b 451 246 477 265 472 246 b 360 140 393 246 360 184 b 471 32 360 58 431 32 b 580 156 471 32 580 36 b 336 361 580 344 363 361 z"
    },
    timeSigCutCommon: {
      x_min: 0,
      x_max: 418,
      y_min: -359,
      y_max: 361,
      ha: 720,
      o: "m 573 -58 b 559 -82 567 -58 559 -60 b 354 -310 559 -266 400 -310 b 317 -305 340 -310 328 -308 b 302 -284 311 -304 302 -295 l 302 287 b 338 323 302 297 328 321 b 363 324 347 324 356 324 b 468 275 436 324 468 289 b 442 243 468 264 464 243 b 351 137 384 243 351 181 b 462 30 351 56 422 30 b 572 154 462 30 572 35 b 318 357 572 295 441 357 b 302 390 310 359 302 383 l 302 495 b 276 520 302 507 292 520 b 252 495 265 520 252 507 l 252 369 b 235 346 252 359 238 346 l 196 331 b 0 -14 66 275 0 122 b 225 -346 0 -150 86 -310 b 252 -382 235 -350 252 -369 l 252 -492 b 276 -517 252 -505 265 -517 b 302 -492 292 -517 302 -505 l 302 -379 b 318 -359 302 -370 308 -363 b 602 -85 563 -354 602 -130 b 579 -58 600 -58 586 -58 z m 252 -235 b 243 -252 252 -248 248 -252 b 236 -248 240 -252 238 -251 b 177 37 197 -193 177 -96 b 232 259 177 147 200 215 b 236 262 233 262 235 262 b 252 239 243 262 252 251 z"
    },
    timeSigPlus: {
      x_min: -1,
      x_max: 499,
      y_min: -250,
      y_max: 250,
      ha: 500,
      o: "m 432 53 b 413 79 420 53 413 65 l 413 340 b 392 360 413 350 405 360 l 325 360 b 305 340 312 360 305 350 l 305 79 b 284 53 305 66 292 53 l 19 53 b -1 33 9 53 -1 46 l -1 -33 b 19 -55 -1 -46 9 -55 l 284 -55 b 305 -75 298 -55 305 -68 l 305 -340 b 325 -360 305 -350 312 -360 l 392 -360 b 413 -340 405 -360 413 -350 l 413 -78 b 433 -55 413 -63 423 -55 l 698 -55 b 719 -33 708 -55 719 -46 l 719 33 b 698 53 719 46 708 53 z"
    },
    timeSigPlusSmall: {
      x_min: -1,
      x_max: 255,
      y_min: -133,
      y_max: 123,
      ha: 256,
      o: "m 220 20 b 210 33 215 20 210 26 l 210 166 b 200 177 210 171 206 177 l 166 177 b 156 166 160 177 156 171 l 156 33 b 145 20 156 27 150 20 l 10 20 b -1 10 4 20 -1 16 l -1 -24 b 10 -35 -1 -30 4 -35 l 145 -35 b 156 -46 153 -35 156 -42 l 156 -180 b 166 -192 156 -186 160 -192 l 200 -192 b 210 -180 206 -192 210 -186 l 210 -48 b 222 -35 210 -39 216 -35 l 356 -35 b 367 -24 361 -35 367 -30 l 367 10 b 356 20 367 16 361 20 z"
    },
    timeSigMinus: {
      x_min: 0,
      x_max: 448,
      y_min: -35,
      y_max: 40,
      ha: 75,
      o: "m 645 39 b 619 58 645 49 634 58 l 27 58 b 0 39 12 58 0 49 l 0 -32 b 27 -50 0 -42 12 -50 l 619 -50 b 645 -32 634 -50 645 -42 z"
    },
    timeSigParensRight: {
      x_min: 0,
      x_max: 184,
      y_min: -489,
      y_max: 491,
      ha: 980,
      o: "m 0 -696 b 3 -704 0 -698 1 -704 b 7 -703 4 -704 6 -704 b 265 1 187 -530 265 -282 b 12 701 265 289 187 531 b 4 707 12 701 6 707 b 0 696 1 707 0 703 l 0 665 b 4 644 0 665 0 651 b 167 1 112 503 167 315 b 6 -641 167 -311 109 -497 b 0 -658 3 -644 0 -651 z"
    },
    timeSigParensRightSmall: {
      x_min: 0,
      x_max: 110,
      y_min: -251,
      y_max: 249,
      ha: 500,
      o: "m 0 -356 b 3 -361 0 -357 1 -361 b 158 0 112 -272 158 -145 b 4 359 158 147 109 272 b 0 353 3 359 0 357 l 0 338 b 3 327 0 338 0 330 b 91 0 60 246 91 160 b 4 -328 91 -160 62 -249 b 0 -337 3 -330 0 -333 z"
    },
    timeSigParensLeft: {
      x_min: 0,
      x_max: 184,
      y_min: -489,
      y_max: 491,
      ha: 980,
      o: "m 265 -658 b 259 -641 265 -651 262 -644 b 98 1 156 -497 98 -311 b 261 644 98 315 153 503 b 265 665 265 651 265 665 l 265 696 b 261 707 265 703 264 707 b 253 701 259 707 253 701 b 0 1 78 531 0 289 b 258 -703 0 -282 78 -530 b 262 -704 259 -704 261 -704 b 265 -696 264 -704 265 -698 z"
    },
    timeSigParensLeftSmall: {
      x_min: 0,
      x_max: 110,
      y_min: -251,
      y_max: 249,
      ha: 500,
      o: "m 158 -337 b 154 -328 158 -333 156 -330 b 68 0 96 -249 68 -160 b 156 327 68 160 98 246 b 158 338 158 330 158 338 l 158 353 b 154 359 158 357 156 359 b 0 0 49 272 0 147 b 156 -361 0 -145 46 -272 b 158 -356 157 -361 158 -357 z"
    },
    noteheadDoubleWhole: {
      x_min: 0,
      x_max: 599,
      y_min: -155,
      y_max: 155,
      ha: 310,
      o: "m 13 223 b 0 212 4 223 0 217 l 0 -213 b 13 -223 0 -219 4 -223 l 32 -223 b 45 -213 39 -223 45 -219 l 45 212 b 32 223 45 217 39 223 z m 96 223 b 82 212 88 223 82 217 l 82 -213 b 96 -223 82 -219 88 -223 l 114 -223 b 128 -213 121 -223 128 -219 l 128 212 b 114 223 128 217 121 223 z m 747 223 b 733 212 740 223 733 217 l 733 -213 b 747 -223 733 -219 740 -223 l 766 -223 b 780 -213 773 -223 780 -219 l 780 212 b 766 223 780 217 773 223 z m 829 223 b 815 212 824 223 815 217 l 815 -213 b 829 -223 815 -219 824 -223 l 848 -223 b 863 -213 857 -223 863 -219 l 863 212 b 848 223 863 217 857 223 z m 438 180 b 130 1 248 180 130 101 b 423 -180 130 -92 210 -180 b 733 1 657 -180 733 -98 b 438 180 733 104 572 180 z m 469 -145 b 331 -71 409 -145 369 -112 b 284 58 305 -37 284 12 b 400 147 284 131 333 147 b 577 -45 498 147 577 42 b 469 -145 577 -115 533 -145 z"
    },
    noteheadWhole: {
      x_min: 0,
      x_max: 422,
      y_min: -125,
      y_max: 125,
      ha: 250,
      o: "m 311 180 b 0 3 120 180 0 101 b 297 -180 0 -94 82 -180 b 608 3 533 -180 608 -98 b 311 180 608 105 445 180 z m 160 91 b 274 148 176 141 229 148 b 452 -45 373 148 452 42 b 386 -141 452 -89 433 -130 b 341 -147 372 -145 356 -147 b 206 -72 289 -147 236 -112 b 156 56 177 -39 156 10 b 160 91 156 68 157 79 z"
    },
    noteheadHalf: {
      x_min: 0,
      x_max: 295,
      y_min: -125,
      y_max: 125,
      ha: 250,
      o: "m 140 -180 b 425 60 377 -180 425 13 b 282 180 425 134 366 180 b 0 -60 68 180 0 14 b 140 -180 0 -137 60 -180 z m 108 -125 b 50 -92 78 -125 60 -109 b 42 -63 46 -84 42 -73 b 318 121 42 7 251 121 b 372 91 346 121 361 108 b 380 63 376 82 380 73 b 108 -125 380 1 177 -125 z"
    },
    noteheadBlack: {
      x_min: 0,
      x_max: 295,
      y_min: -125,
      y_max: 125,
      ha: 250,
      o: "m 140 -180 b 425 60 268 -180 425 -62 b 285 180 425 134 367 180 b 0 -60 127 180 0 63 b 140 -180 0 -135 62 -180 z"
    },
    noteheadXDoubleWhole: {
      x_min: 0,
      x_max: 546,
      y_min: -155,
      y_max: 155,
      ha: 310,
      o: "m 43 213 b 30 223 43 217 39 223 l 13 223 b 0 213 6 223 0 217 l 0 -215 b 13 -223 0 -219 6 -223 l 30 -223 b 43 -215 39 -223 43 -219 z m 704 213 b 693 223 704 217 698 223 l 672 223 b 660 213 667 223 660 217 l 660 163 b 634 180 655 173 645 180 l 505 180 b 484 173 498 180 490 177 l 393 95 l 300 173 b 279 180 294 177 287 180 l 151 180 b 125 163 141 180 130 173 l 125 213 b 112 223 125 217 118 223 l 94 223 b 82 213 86 223 82 217 l 82 -215 b 94 -223 82 -219 86 -223 l 112 -223 b 125 -215 118 -223 125 -219 l 125 -163 b 151 -180 130 -173 140 -180 l 279 -180 b 300 -171 287 -180 294 -177 l 393 -95 l 485 -171 b 505 -180 491 -177 498 -180 l 632 -180 b 660 -163 645 -180 655 -173 l 660 -215 b 672 -223 660 -219 667 -223 l 693 -223 b 704 -215 698 -223 704 -219 z m 786 213 b 772 223 786 217 780 223 l 755 223 b 740 213 747 223 740 217 l 740 -215 b 755 -223 740 -219 747 -223 l 772 -223 b 786 -215 780 -223 786 -219 z m 507 -141 l 393 -45 l 276 -141 l 207 -141 l 364 0 l 207 141 l 276 141 l 393 45 l 507 141 l 577 141 l 420 0 l 577 -141 z m 660 -132 l 518 0 l 660 132 z m 125 131 l 266 0 l 125 -131 z"
    },
    noteheadXWhole: {
      x_min: 0,
      x_max: 377,
      y_min: -125,
      y_max: 125,
      ha: 250,
      o: "m 272 -95 l 364 -171 b 384 -180 370 -177 377 -180 l 511 -180 b 543 -148 528 -180 543 -164 b 531 -124 543 -140 539 -131 l 412 0 l 531 124 b 541 148 539 131 541 140 b 513 180 541 164 528 180 l 384 180 b 364 171 377 180 370 177 l 272 94 l 179 171 b 158 180 173 177 166 180 l 30 180 b 0 148 16 180 0 164 b 12 124 0 140 4 131 l 132 0 l 12 -124 b 1 -148 4 -131 1 -140 b 32 -180 1 -164 14 -180 l 158 -180 b 179 -171 166 -180 173 -177 z m 386 -141 l 272 -45 l 157 -141 l 88 -141 l 245 0 l 88 141 l 157 141 l 272 45 l 386 141 l 456 141 l 300 0 l 456 -141 z"
    },
    noteheadXHalf: {
      x_min: 0,
      x_max: 334,
      y_min: -125,
      y_max: 125,
      ha: 250,
      o: "m 295 180 b 271 170 287 180 278 177 l 209 98 l 115 171 b 95 180 109 177 104 180 l 36 180 b 4 148 19 180 4 164 b 14 124 4 140 7 132 l 140 22 l 7 -127 b 0 -148 3 -131 0 -138 b 32 -180 0 -166 14 -180 l 184 -180 b 209 -170 193 -180 203 -177 l 271 -99 l 363 -171 b 384 -180 370 -176 377 -180 l 445 -180 b 478 -147 461 -180 478 -163 b 465 -125 478 -138 474 -131 l 341 -22 l 474 127 b 481 148 480 131 481 138 b 448 180 481 166 468 180 z m 36 148 l 95 148 l 233 33 l 334 148 l 410 148 l 274 -6 l 445 -148 l 384 -148 l 248 -35 l 147 -148 l 71 -148 l 206 4 z"
    },
    noteheadXBlack: {
      x_min: 0,
      x_max: 290,
      y_min: -125,
      y_max: 125,
      ha: 250,
      o: "m 410 -143 l 239 0 l 410 144 b 418 160 415 147 418 154 b 399 180 418 171 408 180 b 389 177 396 180 392 179 l 207 26 l 29 177 b 17 180 26 179 22 180 b 0 161 7 180 0 170 b 7 144 0 156 3 148 l 179 0 l 7 -143 b 0 -158 1 -147 0 -153 b 19 -180 0 -170 7 -180 b 29 -176 23 -180 26 -179 l 207 -24 l 389 -176 b 399 -180 392 -179 396 -180 b 418 -160 410 -180 418 -168 b 410 -143 418 -153 415 -147 z"
    },
    noteheadCircleXDoubleWhole: {
      x_min: 0,
      x_max: 422,
      y_min: -155,
      y_max: 155,
      ha: 310,
      o: "m 576 223 b 563 213 570 223 563 219 l 563 -215 b 576 -223 563 -219 570 -223 l 595 -223 b 608 -215 602 -223 608 -219 l 608 213 b 595 223 608 219 602 223 z m 497 223 b 484 213 491 223 484 219 l 484 -215 b 497 -223 484 -219 491 -223 l 516 -223 b 528 -215 523 -223 528 -219 l 528 213 b 516 223 528 219 523 223 z m 94 223 b 81 213 86 223 81 219 l 81 -215 b 94 -223 81 -219 86 -223 l 111 -223 b 124 -215 118 -223 124 -219 l 124 213 b 111 223 124 219 118 223 z m 13 223 b 0 213 6 223 0 219 l 0 -215 b 13 -223 0 -219 6 -223 l 30 -223 b 45 -215 37 -223 45 -219 l 45 213 b 30 223 45 219 37 223 z m 304 180 b 127 0 206 180 127 101 b 304 -180 127 -99 206 -180 b 482 0 405 -180 482 -99 b 304 180 482 101 405 180 z m 305 32 l 225 112 b 304 140 248 130 275 140 b 387 112 336 140 364 130 z m 278 1 l 193 -82 b 216 0 199 -59 216 -30 b 194 85 216 33 203 50 z m 334 1 l 418 84 b 389 0 402 50 389 23 b 418 -81 389 -30 409 -60 z m 305 -27 l 389 -109 b 304 -138 364 -128 336 -138 b 222 -109 274 -138 246 -128 z"
    },
    noteheadCircleXWhole: {
      x_min: 0,
      x_max: 249,
      y_min: -125,
      y_max: 125,
      ha: 250,
      o: "m 179 180 b 0 0 81 180 0 101 b 179 -180 0 -99 81 -180 b 359 0 278 -180 359 -99 b 179 180 359 101 278 180 z m 180 32 l 99 112 b 179 140 121 130 150 140 b 262 112 210 140 238 130 z m 151 1 l 68 -82 b 86 0 73 -59 86 -30 b 68 85 86 33 78 50 z m 209 1 l 291 84 b 269 0 276 50 269 32 b 291 -79 269 -26 282 -58 z m 180 -27 l 264 -111 b 179 -138 239 -128 210 -138 b 96 -111 148 -138 120 -128 z"
    },
    noteheadCircleXHalf: {
      x_min: 0,
      x_max: 250,
      y_min: -125,
      y_max: 125,
      ha: 250,
      o: "m 179 180 b 0 0 81 180 0 101 b 179 -180 0 -99 81 -180 b 360 0 278 -180 360 -99 b 179 180 360 101 278 180 z m 186 37 l 131 92 b 220 124 153 109 189 124 b 262 112 236 124 249 121 z m 215 7 l 291 84 b 304 42 300 71 304 58 b 271 -49 304 10 288 -26 z m 145 -6 l 68 -82 b 56 -42 59 -71 56 -58 b 89 52 56 -9 72 27 z m 174 -33 l 230 -89 b 140 -124 206 -108 171 -124 b 96 -111 122 -124 109 -121 z"
    },
    noteheadCircleX: {
      x_min: 0,
      x_max: 249,
      y_min: -125,
      y_max: 125,
      ha: 250,
      o: "m 179 180 b 0 0 81 180 0 99 b 179 -180 0 -99 81 -180 b 359 0 278 -180 359 -99 b 179 180 359 99 278 180 z m 261 112 l 180 30 l 98 112 b 179 138 121 128 148 138 b 261 112 210 138 238 128 z m 317 0 b 292 -82 317 -30 308 -59 l 209 1 l 291 84 b 317 0 307 60 317 30 z m 40 0 b 69 84 40 32 50 60 l 151 1 l 68 -84 b 40 0 49 -60 40 -30 z m 95 -111 l 180 -27 l 262 -111 b 179 -138 239 -128 210 -138 b 95 -111 148 -138 120 -128 z"
    },
    noteheadCircledDoubleWhole: {
      x_min: 0,
      x_max: 603,
      y_min: -218,
      y_max: 213,
      ha: 431,
      o: "m 770 223 l 752 223 b 737 213 744 223 737 219 l 737 59 b 435 307 710 203 582 307 b 128 48 281 307 156 197 l 128 213 b 115 223 128 219 122 223 l 96 223 b 84 213 89 223 84 219 l 84 -215 b 96 -223 84 -220 89 -223 l 115 -223 b 128 -215 122 -223 128 -220 l 128 -56 b 435 -314 156 -206 282 -314 b 654 -223 517 -314 595 -282 b 737 -66 697 -180 726 -125 l 737 -215 b 752 -223 737 -220 744 -223 l 770 -223 b 785 -215 778 -223 785 -220 l 785 213 b 770 223 785 219 778 223 z m 435 274 b 698 85 556 274 661 194 b 439 180 641 143 534 180 b 176 99 320 180 228 148 b 435 274 217 203 318 274 z m 32 223 l 13 223 b 0 213 6 223 0 219 l 0 -215 b 13 -223 0 -220 6 -223 l 32 -223 b 45 -215 40 -223 45 -220 l 45 213 b 32 223 45 219 40 223 z m 852 223 l 835 223 b 819 213 828 223 819 219 l 819 -215 b 835 -223 819 -220 828 -223 l 852 -223 b 868 -215 861 -223 868 -220 l 868 213 b 852 223 868 219 861 223 z m 580 -46 b 514 -143 580 -91 562 -131 b 472 -148 501 -147 487 -148 b 364 -105 433 -148 395 -131 l 334 -73 b 285 58 307 -39 285 10 b 289 91 285 69 287 79 b 403 145 305 140 357 145 b 580 -46 501 145 580 42 z m 435 -282 b 176 -108 318 -282 217 -209 b 425 -180 222 -151 301 -180 b 691 -109 563 -180 647 -153 b 435 -282 651 -210 550 -282 z"
    },
    noteheadCircledWhole: {
      x_min: 0,
      x_max: 437,
      y_min: -225,
      y_max: 211,
      ha: 436,
      o: "m 314 304 b 0 -10 140 304 0 164 b 314 -324 0 -183 141 -324 b 629 -10 487 -324 629 -183 b 314 304 629 164 488 304 z m 314 275 b 588 73 441 275 549 193 b 321 180 536 137 420 180 b 48 88 190 180 95 143 b 314 275 85 199 199 275 z m 393 -141 b 350 -147 379 -145 364 -147 b 314 -141 337 -147 325 -145 b 167 55 235 -120 167 -26 b 173 91 167 66 168 79 b 284 145 187 138 239 145 b 459 -48 382 145 459 39 b 393 -141 459 -91 438 -131 z m 314 -294 b 40 -86 187 -294 75 -207 b 305 -180 81 -141 164 -180 b 588 -86 464 -180 550 -143 b 314 -294 554 -209 442 -294 z"
    },
    noteheadCircledHalf: {
      x_min: -18,
      x_max: 311,
      y_min: -162,
      y_max: 167,
      ha: 329,
      o: "m 212 240 b -26 3 81 240 -26 134 b 212 -233 -26 -127 81 -233 b 448 3 341 -233 448 -127 b 212 240 448 134 341 240 z m 212 220 b 363 160 271 220 324 197 b 281 180 341 173 312 180 b 0 -52 76 180 6 26 b -6 3 -4 -35 -6 -16 b 212 220 -6 122 92 220 z m 50 -92 b 42 -63 46 -84 42 -73 b 173 63 42 -33 73 7 b 317 120 243 105 288 120 b 369 89 344 120 359 107 b 377 62 374 81 377 72 b 248 -66 377 33 348 -1 b 108 -125 183 -109 138 -125 b 50 -92 78 -125 60 -109 z m 212 -215 b 84 -171 164 -215 120 -199 b 138 -180 101 -179 120 -180 b 422 56 372 -180 420 7 b 429 3 426 40 429 22 b 212 -215 429 -117 333 -215 z"
    },
    noteheadCircledBlack: {
      x_min: -21,
      x_max: 321,
      y_min: -171,
      y_max: 167,
      ha: 338,
      o: "m 216 240 b -30 -3 82 240 -30 131 b 216 -246 -30 -137 82 -246 b 462 -3 351 -246 462 -137 b 216 240 462 131 351 240 z m 216 220 b 372 160 276 220 331 197 b 284 180 348 174 317 180 b 0 -59 127 180 0 65 l 0 -66 b -10 -3 -6 -45 -10 -24 b 216 220 -10 120 92 220 z m 216 -226 b 56 -158 153 -226 96 -200 b 140 -180 79 -171 107 -180 b 425 60 268 -180 425 -60 b 422 88 425 71 425 79 b 442 -3 435 60 442 29 b 216 -226 442 -125 341 -226 z"
    },
    noteheadDoubleWholeSquare: {
      x_min: 0,
      x_max: 416,
      y_min: -190,
      y_max: 198,
      ha: 388,
      o: "m 563 217 b 528 180 563 192 544 180 l 62 180 b 36 215 52 180 36 192 l 36 268 b 17 285 36 278 27 285 b 0 268 7 285 0 278 l 0 -255 b 17 -274 0 -264 7 -274 b 36 -255 27 -274 36 -264 l 36 -213 b 66 -180 36 -197 53 -180 l 528 -180 b 563 -209 549 -180 563 -196 l 563 -255 b 580 -274 563 -264 570 -274 b 599 -255 590 -274 599 -264 l 599 268 b 580 285 599 278 590 285 b 563 268 570 285 563 278 z m 36 23 b 111 71 36 55 58 71 l 487 71 b 563 30 533 71 563 53 l 563 -22 b 487 -68 563 -53 533 -68 l 117 -68 b 36 -22 66 -68 36 -49 z"
    },
    noteheadSquareWhite: {
      x_min: 0,
      x_max: 313,
      y_min: -125,
      y_max: 125,
      ha: 250,
      o: "m 451 -180 l 451 180 l 0 180 l 0 -180 z m 40 -138 l 40 140 l 410 140 l 410 -138 z"
    },
    noteheadSquareBlack: {
      x_min: 0,
      x_max: 313,
      y_min: -125,
      y_max: 125,
      ha: 250,
      o: "m 451 -180 l 451 180 l 0 180 l 0 -180 z"
    },
    noteheadTriangleDownDoubleWhole: {
      x_min: 0,
      x_max: 483,
      y_min: -155,
      y_max: 155,
      ha: 310,
      o: "m 696 213 b 681 223 696 219 690 223 l 662 223 b 648 213 655 223 648 219 l 648 -213 b 662 -223 648 -217 655 -223 l 681 -223 b 696 -213 690 -223 696 -217 z m 619 213 b 605 223 619 219 613 223 l 588 223 b 573 213 580 223 573 219 l 573 174 b 562 180 570 177 566 180 l 134 180 b 122 174 130 180 125 177 l 122 213 b 108 223 122 219 117 223 l 91 223 b 76 213 84 223 76 219 l 76 -213 b 91 -223 76 -217 84 -223 l 108 -223 b 122 -213 117 -223 122 -217 l 122 154 l 334 -173 b 346 -180 337 -177 341 -180 b 357 -173 351 -180 354 -177 l 573 154 l 573 -213 b 588 -223 573 -217 580 -223 l 605 -223 b 619 -213 613 -223 619 -217 z m 32 -223 b 46 -213 40 -223 46 -217 l 46 213 b 32 223 46 219 40 223 l 14 223 b 0 213 7 223 0 219 l 0 -213 b 14 -223 0 -217 7 -223 z m 428 98 b 346 -107 428 17 377 -53 b 265 96 315 -55 265 17 b 289 137 265 109 275 137 l 406 137 b 428 98 419 137 428 111 z"
    },
    noteheadTriangleDownWhole: {
      x_min: 0,
      x_max: 319,
      y_min: -125,
      y_max: 125,
      ha: 250,
      o: "m 14 180 b 0 166 6 180 0 173 b 1 158 0 163 1 160 l 216 -173 b 228 -180 219 -177 225 -180 b 239 -173 233 -180 238 -177 l 458 158 b 459 166 458 160 459 163 b 445 180 459 173 454 180 z m 288 137 b 310 98 301 137 310 111 b 228 -108 310 17 259 -55 b 145 96 197 -56 145 17 b 170 137 145 109 157 137 z"
    },
    noteheadTriangleDownHalf: {
      x_min: 0,
      x_max: 285,
      y_min: -125,
      y_max: 125,
      ha: 250,
      o: "m 196 -180 b 209 -173 200 -180 206 -177 l 408 157 b 410 166 409 160 410 163 b 396 180 410 173 403 180 l 14 180 b 0 166 4 180 0 173 b 1 158 0 163 0 161 l 183 -173 b 196 -180 184 -174 190 -180 z m 164 138 l 295 138 l 179 -76 l 114 37 z"
    },
    noteheadTriangleDownBlack: {
      x_min: 0,
      x_max: 292,
      y_min: -125,
      y_max: 125,
      ha: 250,
      o: "m 207 -180 l 420 180 l 0 180 z"
    },
    noteheadTriangleUpDoubleWhole: {
      x_min: 0,
      x_max: 483,
      y_min: -155,
      y_max: 155,
      ha: 310,
      o: "m 696 213 b 681 223 696 217 690 223 l 662 223 b 648 213 655 223 648 217 l 648 -213 b 662 -223 648 -219 655 -223 l 681 -223 b 696 -213 690 -223 696 -219 z m 619 213 b 605 223 619 217 613 223 l 588 223 b 573 213 580 223 573 217 l 573 -154 l 357 173 b 346 180 354 177 351 180 b 334 173 341 180 337 177 l 122 -154 l 122 213 b 108 223 122 217 117 223 l 91 223 b 76 213 84 223 76 217 l 76 -213 b 91 -223 76 -219 84 -223 l 108 -223 b 122 -213 117 -223 122 -219 l 122 -174 b 134 -180 125 -177 130 -180 l 562 -180 b 573 -174 566 -180 570 -177 l 573 -213 b 588 -223 573 -219 580 -223 l 605 -223 b 619 -213 613 -223 619 -219 z m 32 223 l 14 223 b 0 213 7 223 0 217 l 0 -213 b 14 -223 0 -219 7 -223 l 32 -223 b 46 -213 40 -223 46 -219 l 46 213 b 32 223 46 217 40 223 z m 428 -98 b 406 -137 428 -111 419 -137 l 289 -137 b 265 -96 275 -137 265 -109 b 346 107 265 -17 315 55 b 428 -98 377 53 428 -17 z"
    },
    noteheadTriangleUpWhole: {
      x_min: 0,
      x_max: 319,
      y_min: -125,
      y_max: 125,
      ha: 250,
      o: "m 445 -180 b 459 -166 454 -180 459 -173 b 458 -158 459 -163 458 -160 l 239 173 b 228 180 238 177 233 180 b 216 173 225 180 219 177 l 1 -158 b 0 -166 1 -160 0 -163 b 14 -180 0 -173 6 -180 z m 170 -137 b 145 -96 157 -137 145 -109 b 228 108 145 -17 197 56 b 310 -98 259 55 310 -17 b 288 -137 310 -111 301 -137 z"
    },
    noteheadTriangleUpHalf: {
      x_min: 0,
      x_max: 285,
      y_min: -125,
      y_max: 125,
      ha: 250,
      o: "m 215 180 b 202 173 210 180 204 177 l 3 -157 b 0 -166 1 -160 0 -163 b 14 -180 0 -173 7 -180 l 396 -180 b 410 -166 406 -180 410 -173 b 409 -158 410 -163 410 -161 l 228 173 b 215 180 226 174 220 180 z m 246 -138 l 115 -138 l 232 76 l 297 -37 z"
    },
    noteheadTriangleUpBlack: {
      x_min: 0,
      x_max: 293,
      y_min: -125,
      y_max: 125,
      ha: 250,
      o: "m 422 -180 l 207 180 l 0 -180 z"
    },
    noteheadSlashedDoubleWhole1: {
      x_min: 0,
      x_max: 596,
      y_min: -179,
      y_max: 168,
      ha: 347,
      o: "m 618 135 l 697 206 b 704 222 703 210 704 216 b 698 236 704 226 703 232 b 683 242 694 239 688 242 b 670 238 677 242 674 240 l 575 153 b 435 180 531 168 481 180 b 128 0 246 180 128 98 b 236 -148 128 -58 160 -114 l 153 -222 b 145 -238 148 -226 145 -232 b 151 -252 145 -242 148 -248 b 167 -258 156 -256 161 -258 b 181 -253 171 -258 177 -256 l 282 -164 b 420 -180 320 -173 366 -180 b 729 0 654 -180 729 -98 b 618 135 729 55 681 104 z m 114 223 l 95 223 b 82 212 88 223 82 217 l 82 -215 b 95 -223 82 -219 88 -223 l 114 -223 b 127 -215 121 -223 127 -219 l 127 212 b 114 223 127 217 121 223 z m 32 223 l 13 223 b 0 212 6 223 0 217 l 0 -215 b 13 -223 0 -219 6 -223 l 32 -223 b 45 -215 39 -223 45 -219 l 45 212 b 32 223 45 217 39 223 z m 844 223 l 825 223 b 811 212 819 223 811 217 l 811 -215 b 825 -223 811 -219 819 -223 l 844 -223 b 858 -215 851 -223 858 -219 l 858 212 b 844 223 858 217 851 223 z m 763 223 l 743 223 b 730 212 736 223 730 217 l 730 -215 b 743 -223 730 -219 736 -223 l 763 -223 b 776 -215 769 -223 776 -219 l 776 212 b 763 223 776 217 769 223 z m 282 56 b 285 89 282 68 284 79 b 399 144 301 137 354 144 b 510 95 441 144 480 124 l 327 -68 b 282 56 301 -35 282 13 z m 572 -72 b 508 -141 564 -108 544 -132 b 467 -147 495 -145 481 -147 b 360 -104 428 -147 389 -128 l 356 -98 l 537 63 b 575 -46 560 30 575 -9 b 572 -72 575 -55 573 -65 z"
    },
    noteheadSlashedWhole1: {
      x_min: -22,
      x_max: 433,
      y_min: -157,
      y_max: 148,
      ha: 305,
      o: "m 484 140 b 308 180 431 166 367 180 b 0 1 118 180 0 99 b 73 -128 0 -48 22 -95 l -22 -190 b -32 -206 -27 -194 -32 -200 b -27 -217 -32 -210 -30 -215 b -12 -226 -23 -223 -17 -226 b 0 -223 -7 -226 -4 -225 l 112 -150 b 294 -180 157 -168 217 -180 b 602 1 526 -180 602 -98 b 523 118 602 48 570 86 l 613 177 b 624 193 619 181 624 187 b 619 204 624 197 622 200 b 603 213 615 209 609 213 b 592 209 599 213 596 212 z m 190 -52 b 154 56 170 -20 154 19 b 160 91 154 68 156 79 b 271 147 174 138 226 147 b 396 82 321 147 364 121 z m 419 50 b 446 -48 436 19 446 -14 b 337 -147 446 -120 402 -147 b 301 -141 327 -147 314 -144 b 235 -104 276 -134 253 -120 b 215 -84 226 -98 220 -91 z"
    },
    noteheadSlashedHalf1: {
      x_min: -67,
      x_max: 386,
      y_min: -142,
      y_max: 160,
      ha: 302,
      o: "m 552 222 b 536 230 549 228 543 230 b 524 228 533 230 528 230 l 389 140 b 281 180 364 164 327 180 b 0 -60 65 180 0 13 b 7 -105 0 -78 3 -92 l -88 -167 b -96 -184 -94 -171 -96 -177 b -94 -194 -96 -187 -95 -192 b -76 -204 -89 -202 -84 -204 b -66 -202 -73 -204 -69 -203 l 29 -140 b 137 -180 55 -167 92 -180 b 420 59 374 -180 420 13 b 412 107 420 76 419 92 l 546 194 b 556 210 552 197 556 204 b 552 222 556 213 554 217 z m 315 120 b 347 112 328 120 338 117 l 46 -82 b 42 -63 43 -76 42 -69 b 315 120 42 6 248 120 z m 108 -124 b 69 -114 91 -124 79 -120 l 372 81 b 376 63 374 75 376 69 b 108 -124 376 0 174 -124 z"
    },
    noteheadSlashedBlack1: {
      x_min: -80,
      x_max: 375,
      y_min: -165,
      y_max: 167,
      ha: 332,
      o: "m 518 240 b 507 236 514 240 510 239 l 384 148 b 284 180 359 168 324 180 b 0 -62 127 180 0 63 b 13 -115 0 -82 4 -99 l -107 -202 b -115 -217 -111 -204 -115 -212 b -111 -229 -115 -222 -114 -225 b -95 -238 -108 -235 -101 -238 b -84 -235 -91 -238 -86 -236 l 39 -148 b 140 -180 63 -170 99 -180 b 425 59 268 -180 425 -62 b 410 117 425 81 420 101 l 530 203 b 540 219 536 207 540 213 b 518 240 540 229 528 240 z"
    },
    noteheadSlashedDoubleWhole2: {
      x_min: 0,
      x_max: 596,
      y_min: -178,
      y_max: 169,
      ha: 347,
      o: "m 729 0 b 435 180 729 102 569 180 b 278 156 374 180 321 170 l 184 239 b 170 243 181 242 176 243 b 154 238 166 243 158 240 b 150 223 151 233 150 228 b 156 207 150 217 153 212 l 233 138 b 128 0 167 107 128 56 b 420 -180 128 -94 210 -180 b 575 -164 482 -180 533 -174 l 672 -252 b 687 -256 677 -255 681 -256 b 703 -251 691 -256 698 -255 b 707 -236 706 -246 707 -240 b 701 -220 707 -230 706 -225 l 619 -150 b 729 0 700 -117 729 -62 z m 114 223 l 95 223 b 82 213 88 223 82 217 l 82 -213 b 95 -223 82 -219 88 -223 l 114 -223 b 127 -213 121 -223 127 -219 l 127 213 b 114 223 127 217 121 223 z m 32 223 l 13 223 b 0 213 6 223 0 217 l 0 -213 b 13 -223 0 -219 6 -223 l 32 -223 b 45 -213 39 -223 45 -219 l 45 213 b 32 223 45 217 39 223 z m 844 223 l 825 223 b 811 213 819 223 811 217 l 811 -213 b 825 -223 811 -219 819 -223 l 844 -223 b 858 -213 851 -223 858 -219 l 858 213 b 844 223 858 217 851 223 z m 763 223 l 743 223 b 730 213 736 223 730 217 l 730 -213 b 743 -223 730 -219 736 -223 l 763 -223 b 776 -213 769 -223 776 -219 l 776 213 b 763 223 776 217 769 223 z m 312 124 b 399 144 336 141 369 144 b 575 -46 495 144 575 40 b 563 -98 575 -65 570 -81 z m 508 -141 b 467 -147 495 -145 481 -147 b 360 -104 428 -147 389 -128 b 330 -72 350 -95 340 -82 b 282 56 304 -37 282 10 b 285 89 282 68 284 79 b 536 -130 287 89 304 75 z"
    },
    noteheadSlashedWhole2: {
      x_min: -18,
      x_max: 436,
      y_min: -154,
      y_max: 151,
      ha: 305,
      o: "m 531 -128 b 602 1 582 -96 602 -49 b 308 180 602 104 441 180 b 114 144 230 180 164 166 l 4 215 b -6 217 1 217 -3 217 b -22 209 -13 217 -19 215 b -26 197 -24 204 -26 200 b -16 181 -26 192 -22 184 l 75 121 b 0 1 27 91 0 49 b 294 -180 0 -94 82 -180 b 491 -150 379 -180 444 -168 l 598 -219 b 608 -222 600 -222 605 -222 b 624 -213 615 -222 621 -219 b 628 -202 626 -209 628 -206 b 618 -186 628 -196 624 -189 z m 168 108 b 271 147 190 141 233 147 b 446 -48 369 147 446 40 b 445 -72 446 -56 446 -63 z m 154 69 l 429 -109 b 382 -141 419 -125 402 -135 b 337 -147 367 -144 351 -147 b 301 -141 327 -147 314 -144 b 235 -104 276 -134 253 -120 b 203 -72 223 -94 213 -82 b 154 58 177 -39 154 12 z"
    },
    noteheadSlashedHalf2: {
      x_min: -73,
      x_max: 380,
      y_min: -134,
      y_max: 168,
      ha: 302,
      o: "m 537 -156 l 383 -58 b 422 60 413 -9 422 39 b 281 180 422 134 364 180 b 101 127 203 180 144 157 l -75 239 b -85 242 -78 242 -82 242 b -102 233 -92 242 -98 239 b -105 222 -104 229 -105 225 b -95 206 -105 216 -102 209 l 69 99 b 0 -59 19 46 0 -20 b 138 -180 0 -135 60 -180 b 359 -88 248 -180 317 -138 l 516 -190 b 527 -193 520 -192 524 -193 b 543 -183 534 -193 540 -190 b 547 -173 546 -180 547 -176 b 537 -156 547 -166 543 -160 z m 367 92 b 377 63 374 82 377 73 b 318 -14 377 43 361 20 l 184 72 b 317 121 248 108 289 121 b 367 92 344 121 357 109 z m 248 -66 b 108 -124 181 -108 138 -124 b 50 -92 78 -124 60 -109 b 42 -63 46 -84 42 -73 b 145 49 42 -35 68 0 l 285 -40 b 248 -66 274 -49 261 -56 z"
    },
    noteheadSlashedBlack2: {
      x_min: -79,
      x_max: 376,
      y_min: -164,
      y_max: 168,
      ha: 332,
      o: "m 531 -200 l 363 -78 b 425 59 402 -37 425 10 b 285 180 425 132 367 180 b 92 114 210 180 144 154 l -81 238 b -94 242 -85 240 -89 242 b -111 232 -99 242 -107 238 b -114 220 -112 229 -114 225 b -105 204 -114 215 -111 207 l 62 85 b 0 -62 23 43 0 -9 b 140 -180 0 -137 62 -180 b 331 -108 204 -180 275 -153 l 507 -233 b 520 -236 511 -236 517 -236 b 537 -228 527 -236 533 -233 b 541 -216 540 -225 541 -220 b 531 -200 541 -210 537 -203 z"
    },
    noteheadDiamondDoubleWhole: {
      x_min: 0,
      x_max: 432,
      y_min: -155,
      y_max: 155,
      ha: 310,
      o: "m 592 223 b 580 215 585 223 580 219 l 580 -215 b 592 -223 580 -219 585 -223 l 608 -223 b 622 -215 615 -223 622 -219 l 622 215 b 608 223 622 219 615 223 z m 517 223 b 504 215 510 223 504 219 l 504 -215 b 517 -223 504 -219 510 -223 l 533 -223 b 544 -215 540 -223 544 -219 l 544 215 b 533 223 544 219 540 223 z m 246 179 b 240 180 243 179 242 180 b 232 176 236 180 233 179 l 118 22 b 117 17 117 20 117 19 l 117 215 b 104 223 117 219 111 223 l 88 223 b 75 215 81 223 75 219 l 75 -215 b 88 -223 75 -219 81 -223 l 104 -223 b 117 -215 111 -223 117 -219 l 117 14 l 118 14 b 122 7 118 12 120 10 l 374 -179 b 382 -180 376 -180 379 -180 b 390 -177 384 -180 387 -180 l 503 -23 l 503 -17 b 500 -9 503 -13 503 -10 z m 12 223 b 0 215 4 223 0 219 l 0 -215 b 12 -223 0 -219 4 -223 l 29 -223 b 40 -215 36 -223 40 -219 l 40 215 b 29 223 40 219 36 223 z m 183 39 b 179 46 181 39 179 43 b 229 112 226 112 228 112 b 236 109 229 112 233 111 l 436 -39 b 439 -46 438 -39 439 -42 b 390 -112 393 -111 392 -112 b 383 -109 389 -112 386 -111 z"
    },
    noteheadDiamondWhole: {
      x_min: 0,
      x_max: 270,
      y_min: -125,
      y_max: 125,
      ha: 250,
      o: "m 386 -23 b 389 -16 387 -20 389 -19 b 383 -7 389 -13 386 -9 l 130 179 b 122 180 128 180 125 180 b 115 177 120 180 117 180 l 3 23 b 0 17 1 20 0 19 b 4 7 0 16 3 10 l 258 -179 b 264 -180 261 -179 262 -180 b 272 -176 268 -180 271 -179 z m 66 40 b 62 48 65 42 62 45 l 109 111 b 112 112 109 112 111 112 b 118 111 115 112 117 111 l 320 -37 b 324 -46 323 -39 324 -42 b 275 -111 278 -111 276 -111 b 268 -108 272 -111 271 -109 z"
    },
    noteheadDiamondHalf: {
      x_min: 0,
      x_max: 251,
      y_min: -125,
      y_max: 125,
      ha: 250,
      o: "m 359 -7 b 361 0 360 -6 361 -3 b 359 7 361 3 360 4 l 189 177 b 180 180 186 179 183 180 b 174 177 179 180 176 179 l 4 7 b 0 0 1 4 0 3 b 4 -7 0 -3 1 -6 l 174 -177 b 180 -180 176 -180 179 -180 b 189 -177 183 -180 186 -180 z m 266 26 b 138 -71 266 -12 176 -71 b 96 -50 121 -71 108 -63 b 88 -24 89 -43 88 -32 b 215 73 88 13 177 73 b 266 26 238 73 266 50 z"
    },
    noteheadDiamondBlack: {
      x_min: 0,
      x_max: 250,
      y_min: -125,
      y_max: 125,
      ha: 250,
      o: "m 357 -6 b 360 1 359 -4 360 -1 b 357 9 360 4 359 7 l 189 177 b 180 180 187 179 184 180 b 171 177 177 180 173 179 l 3 9 b 0 1 0 6 0 4 b 4 -7 0 -1 1 -4 l 173 -177 b 180 -180 176 -180 177 -180 b 187 -177 181 -180 184 -180 z"
    },
    noteheadParenthesis: {
      x_min: -73,
      x_max: 368,
      y_min: -180,
      y_max: 182,
      ha: 362,
      o: "m 52 -249 b -30 -144 3 -212 -14 -190 b -52 4 -45 -102 -52 -56 b 52 252 -52 118 -36 179 l 46 262 b -105 3 -49 197 -105 124 b 45 -259 -105 -109 -48 -200 z m 382 -259 b 530 3 474 -202 530 -108 b 379 262 530 122 474 200 l 373 252 b 478 4 462 180 478 118 b 456 -144 478 -56 471 -102 b 373 -249 439 -190 422 -212 z"
    },
    noteheadParenthesisRight: {
      x_min: -36,
      x_max: 73,
      y_min: -181,
      y_max: 181,
      ha: 362,
      o: "m -43 -261 b 105 1 49 -203 105 -109 b -46 261 105 121 49 199 l -52 251 b 53 3 37 179 53 117 b 32 -145 53 -58 46 -104 b -52 -251 14 -192 -3 -213 z"
    },
    noteheadParenthesisLeft: {
      x_min: 0,
      x_max: 109,
      y_min: -181,
      y_max: 181,
      ha: 362,
      o: "m 157 -251 b 75 -145 108 -213 91 -192 b 53 3 60 -104 53 -58 b 157 251 53 117 69 177 l 151 261 b 0 1 56 196 0 122 b 150 -261 0 -111 58 -202 z"
    },
    noteheadMoonBlack: {
      x_min: 0,
      x_max: 315,
      y_min: -125,
      y_max: 125,
      ha: 250,
      o: "m 228 -180 b 454 0 343 -180 454 -130 l 454 180 l 0 180 l 0 0 b 228 -180 0 -131 112 -180 z"
    },
    noteheadTriangleLeftBlack: {
      x_min: 0,
      x_max: 339,
      y_min: -125,
      y_max: 125,
      ha: 250,
      o: "m 488 -180 l 0 180 l 0 -180 z"
    },
    noteheadTriangleRightBlack: {
      x_min: 0,
      x_max: 339,
      y_min: -125,
      y_max: 125,
      ha: 250,
      o: "m 488 180 l 0 -180 l 488 -180 z"
    },
    noteheadTriangleRoundDownBlack: {
      x_min: 0,
      x_max: 278,
      y_min: -125,
      y_max: 125,
      ha: 250,
      o: "m 200 -180 l 400 112 l 383 124 b 199 180 327 161 264 180 b 16 124 135 180 73 161 l 0 112 z"
    },
    augmentationDot: {
      x_min: 0,
      x_max: 100,
      y_min: -50,
      y_max: 50,
      ha: 100,
      o: "m 144 0 b 72 72 144 40 112 72 b 0 0 32 72 0 40 b 72 -72 0 -40 32 -72 b 144 0 112 -72 144 -40 z"
    },
    tremolo1: {
      x_min: -150,
      x_max: 150,
      y_min: -93,
      y_max: 94,
      ha: 187,
      o: "m 216 -45 l 216 135 l -216 46 l -216 -134 z"
    },
    flag8thUp: {
      x_min: 0,
      x_max: 264,
      y_min: -810,
      y_max: 9,
      ha: 819,
      o: "m 343 -1138 b 380 -888 343 -1138 380 -1001 b 215 -395 380 -708 305 -539 b 58 -19 141 -281 81 -157 b 27 13 53 4 42 13 b 0 -9 12 13 0 9 l 0 -353 b 284 -688 95 -370 232 -566 b 318 -904 305 -737 318 -819 b 284 -1102 318 -969 308 -1037 b 279 -1123 281 -1110 279 -1117 b 302 -1165 279 -1146 294 -1159 b 343 -1138 311 -1171 336 -1162 z"
    },
    flag8thDown: {
      x_min: 0,
      x_max: 306,
      y_min: -14,
      y_max: 808,
      ha: 822,
      o: "m 346 1094 b 376 897 366 1034 376 962 b 318 642 376 812 340 691 b 0 340 265 521 193 405 l 0 1 b 23 -20 0 -13 12 -20 b 58 12 36 -20 55 -12 b 262 387 82 148 189 274 b 441 881 353 530 441 701 b 400 1142 441 994 412 1096 b 377 1164 396 1158 387 1164 b 346 1094 356 1164 331 1136 z"
    },
    flag16thUp: {
      x_min: 0,
      x_max: 279,
      y_min: -813,
      y_max: 2,
      ha: 815,
      o: "m 392 -1146 b 402 -988 397 -1139 402 -1057 l 402 -956 b 360 -783 402 -896 386 -837 b 359 -770 360 -779 359 -776 b 360 -760 359 -768 359 -765 b 396 -577 364 -752 396 -665 b 392 -526 396 -559 395 -543 b 236 -275 377 -428 340 -387 b 53 -16 158 -192 78 -168 b 24 3 50 0 33 3 b 0 -12 16 3 0 -1 l 0 -570 l 7 -570 b 298 -778 96 -573 199 -576 b 344 -992 331 -847 344 -917 b 333 -1120 344 -1034 340 -1077 b 331 -1133 331 -1126 331 -1129 b 363 -1171 331 -1152 343 -1171 b 392 -1146 373 -1171 383 -1165 z m 301 -661 b 223 -562 278 -625 253 -596 b 59 -331 156 -484 89 -449 b 58 -327 58 -330 58 -328 b 78 -312 58 -321 66 -312 l 89 -312 b 302 -464 177 -312 255 -393 b 341 -592 328 -501 341 -546 b 340 -621 341 -602 341 -611 b 330 -658 337 -632 337 -647 b 311 -667 328 -662 318 -667 b 301 -661 307 -667 304 -665 z"
    },
    flag16thDown: {
      x_min: 0,
      x_max: 291,
      y_min: -9,
      y_max: 812,
      ha: 821,
      o: "m 346 1132 b 312 768 367 1011 367 880 b 7 559 213 566 96 562 l 0 559 l 0 1 b 24 -13 0 -6 10 -13 b 53 6 35 -13 50 -10 b 406 516 88 228 372 289 b 410 567 409 531 410 549 b 374 750 410 655 379 742 b 373 760 373 753 373 756 b 374 773 373 766 374 769 b 405 1138 426 881 428 1022 b 370 1169 397 1171 387 1169 b 346 1132 353 1168 341 1156 z m 325 657 b 344 647 333 657 343 652 b 354 611 351 636 351 622 b 356 582 356 600 356 590 b 317 454 356 534 343 491 b 89 302 269 383 177 302 l 78 302 b 58 317 66 302 58 310 b 59 321 58 318 58 320 b 238 552 89 439 170 472 b 315 651 268 585 292 613 b 325 657 318 655 321 657 z"
    },
    flag32ndUp: {
      x_min: 0,
      x_max: 261,
      y_min: -812,
      y_max: 149,
      ha: 961,
      o: "m 374 -969 b 337 -806 372 -913 359 -858 b 336 -796 336 -804 336 -801 b 337 -788 336 -793 336 -791 b 370 -616 340 -778 370 -698 b 340 -482 370 -570 360 -524 b 369 -330 353 -445 369 -386 b 366 -289 369 -315 369 -302 b 220 -58 350 -202 317 -163 b 46 187 148 20 71 43 b 20 215 45 200 35 215 b 0 197 12 215 0 207 l 0 -609 l 7 -609 b 278 -802 91 -612 186 -615 b 323 -999 310 -865 323 -930 b 311 -1122 323 -1040 318 -1080 b 310 -1132 311 -1126 310 -1129 b 328 -1166 310 -1149 318 -1162 b 337 -1169 331 -1168 334 -1169 b 366 -1146 346 -1169 356 -1162 b 376 -1009 370 -1138 376 -1071 b 374 -969 376 -995 374 -982 z m 300 -261 b 321 -330 315 -289 321 -311 b 317 -360 321 -341 318 -350 b 300 -423 314 -374 307 -399 b 220 -334 279 -397 253 -370 b 56 -92 150 -256 79 -232 b 300 -261 135 -92 220 -127 z m 315 -657 b 308 -690 312 -668 312 -680 b 292 -698 307 -694 300 -698 b 282 -693 288 -698 284 -697 b 216 -608 261 -661 240 -636 l 209 -600 b 56 -390 147 -527 88 -495 b 73 -367 53 -380 60 -367 b 318 -622 189 -367 318 -505 b 315 -657 318 -634 317 -645 z"
    },
    flag32ndDown: {
      x_min: 0,
      x_max: 273,
      y_min: -172,
      y_max: 812,
      ha: 984,
      o: "m 393 973 b 333 1169 393 1002 383 1169 b 324 1168 330 1169 327 1169 b 304 1130 314 1164 304 1149 b 305 1120 304 1128 305 1125 b 334 962 317 1056 334 1011 b 289 821 334 922 323 880 b 0 619 180 625 88 622 l 0 -229 b 20 -248 0 -242 9 -248 b 48 -219 35 -248 46 -232 b 229 36 72 -69 154 -46 b 380 278 330 145 364 186 b 383 320 383 291 383 305 b 351 484 383 382 364 445 b 384 629 374 526 384 580 b 356 780 384 704 361 766 b 356 783 356 782 356 783 l 351 791 b 356 804 351 796 353 799 l 361 814 b 393 958 380 850 387 865 z m 56 386 b 217 609 86 501 153 533 b 292 706 246 642 269 670 b 304 711 295 710 300 711 b 321 703 311 711 320 707 b 328 670 325 693 325 681 b 331 634 330 658 331 645 b 82 367 331 516 199 367 l 75 367 b 56 386 62 367 56 379 z m 330 350 b 334 320 331 340 334 331 b 311 248 334 301 328 278 b 59 72 229 109 141 72 b 56 76 56 73 56 75 b 229 331 81 226 154 249 b 310 423 264 369 289 397 b 330 350 318 396 325 366 z"
    },
    flag64thUp: {
      x_min: 0,
      x_max: 261,
      y_min: -812,
      y_max: 347,
      ha: 1159,
      o: "m 374 -969 b 337 -806 372 -913 359 -858 b 336 -796 336 -804 336 -801 b 337 -788 336 -793 336 -791 b 370 -616 340 -778 370 -698 b 340 -482 370 -570 360 -524 b 369 -330 353 -445 369 -386 b 337 -203 369 -287 359 -242 b 369 -43 350 -167 369 -104 b 366 -4 369 -30 367 -17 b 220 228 350 84 317 122 b 46 472 148 305 71 328 b 20 500 45 485 32 500 b 0 482 10 500 0 492 l 0 -609 l 7 -609 b 278 -802 91 -612 186 -615 b 323 -999 310 -865 323 -930 b 311 -1122 323 -1040 318 -1080 b 310 -1132 311 -1126 310 -1129 b 328 -1166 310 -1149 318 -1162 b 337 -1169 331 -1168 334 -1169 b 366 -1146 346 -1169 356 -1162 b 376 -1009 370 -1138 376 -1071 b 374 -969 376 -995 374 -982 z m 300 24 b 321 -45 315 -4 321 -26 b 317 -75 321 -56 318 -65 l 298 -145 b 220 -58 278 -121 253 -94 b 58 187 148 20 82 43 b 56 193 58 189 58 192 b 300 24 138 193 220 157 z m 300 -261 b 321 -330 315 -289 321 -311 b 317 -360 321 -341 318 -350 b 300 -423 314 -374 307 -399 b 220 -334 279 -397 253 -370 b 56 -92 150 -256 79 -232 b 300 -261 135 -92 220 -127 z m 315 -657 b 308 -690 312 -668 312 -680 b 292 -698 307 -694 300 -698 b 282 -693 288 -698 284 -697 b 216 -608 261 -661 240 -636 l 209 -600 b 55 -386 147 -527 84 -497 b 73 -367 52 -376 63 -367 b 318 -622 189 -367 318 -505 b 315 -657 318 -634 317 -645 z"
    },
    flag64thDown: {
      x_min: 0,
      x_max: 273,
      y_min: -376,
      y_max: 812,
      ha: 1188,
      o: "m 393 973 b 333 1169 393 1002 383 1169 b 324 1168 330 1169 327 1169 b 304 1130 314 1164 304 1149 b 305 1120 304 1128 305 1125 b 334 962 317 1056 334 1011 b 289 821 334 922 323 880 b 0 619 180 625 88 622 l 0 -523 b 20 -541 0 -534 9 -541 b 48 -513 35 -541 46 -526 b 229 -258 72 -363 154 -340 b 380 -16 330 -148 364 -108 b 384 27 383 -1 384 13 b 351 189 384 88 366 151 b 380 278 366 216 374 243 b 383 320 383 291 383 305 b 351 484 383 382 364 445 b 384 629 374 526 384 580 b 356 780 384 704 361 766 b 356 783 356 782 356 783 l 351 791 b 356 804 351 796 353 799 l 361 814 b 393 958 380 850 387 865 z m 56 386 b 217 609 86 501 153 533 b 292 706 246 642 269 670 b 304 711 295 710 300 711 b 321 703 311 711 320 707 b 328 670 325 693 325 681 b 331 634 330 658 331 645 b 82 367 331 516 199 367 l 75 367 b 56 386 62 367 56 379 z m 330 350 b 334 320 331 340 334 331 b 311 248 334 301 328 278 b 59 72 229 109 141 72 b 56 76 56 73 56 75 b 229 331 81 226 154 249 b 310 423 264 369 289 397 b 330 350 318 396 325 366 z m 330 56 b 334 26 331 46 334 37 b 311 -46 334 7 328 -16 b 56 -222 229 -184 137 -222 b 229 36 75 -86 145 -55 b 311 128 264 73 289 102 z"
    },
    flag128thUp: {
      x_min: 0,
      x_max: 261,
      y_min: -812,
      y_max: 533,
      ha: 1345,
      o: "m 374 -969 b 337 -806 372 -913 359 -858 b 336 -796 336 -804 336 -801 b 337 -788 336 -793 336 -791 b 370 -616 340 -778 370 -698 b 340 -482 370 -570 360 -524 b 369 -330 353 -445 369 -386 b 337 -203 369 -287 359 -242 b 369 -43 350 -167 369 -104 b 366 -4 369 -30 367 -17 b 341 75 360 26 353 50 b 369 222 354 111 369 167 b 366 264 369 236 369 251 b 220 495 350 351 317 390 b 46 740 148 573 71 596 b 22 768 45 753 35 768 b 0 750 10 768 0 760 l 0 -609 l 7 -609 b 278 -802 91 -612 186 -615 b 323 -999 310 -865 323 -930 b 311 -1122 323 -1040 318 -1080 b 310 -1132 311 -1126 310 -1129 b 328 -1166 310 -1149 318 -1162 b 337 -1169 331 -1168 334 -1169 b 366 -1146 346 -1169 356 -1162 b 376 -1009 370 -1138 376 -1071 b 374 -969 376 -995 374 -982 z m 300 292 b 321 223 315 264 321 242 b 317 193 321 212 318 203 b 301 135 314 180 308 158 b 220 228 281 161 255 190 b 55 461 151 304 79 327 b 300 292 134 461 220 426 z m 300 24 b 321 -45 315 -4 321 -26 b 317 -75 321 -56 318 -65 l 298 -145 b 220 -58 278 -121 253 -94 b 56 187 148 20 81 43 b 55 193 56 189 56 192 b 300 24 137 193 220 157 z m 300 -261 b 321 -330 315 -289 321 -311 b 317 -360 321 -341 318 -350 b 300 -423 314 -374 307 -399 b 220 -334 279 -397 253 -370 b 56 -92 150 -256 79 -232 b 300 -261 135 -92 220 -127 z m 315 -657 b 308 -690 312 -668 312 -680 b 292 -698 307 -694 300 -698 b 282 -693 288 -698 284 -697 b 216 -608 261 -661 240 -636 l 209 -600 b 55 -386 147 -527 84 -497 b 73 -367 53 -376 62 -367 b 318 -622 189 -367 318 -505 b 315 -657 318 -634 317 -645 z"
    },
    flag128thDown: {
      x_min: 0,
      x_max: 273,
      y_min: -580,
      y_max: 812,
      ha: 1392,
      o: "m 393 973 b 333 1169 393 1002 383 1169 b 324 1168 330 1169 327 1169 b 304 1130 314 1164 304 1149 b 305 1120 304 1128 305 1125 b 334 962 317 1056 334 1011 b 289 821 334 922 323 880 b 0 619 180 625 88 622 l 0 -816 b 20 -835 0 -828 7 -835 b 48 -806 33 -835 46 -819 b 229 -552 72 -657 154 -634 b 380 -310 330 -442 364 -402 b 384 -266 383 -295 384 -281 b 351 -105 384 -206 366 -143 b 384 27 372 -66 384 -16 b 351 189 384 88 366 151 b 380 278 366 216 374 243 b 383 320 383 291 383 305 b 351 484 383 382 364 445 b 384 629 374 526 384 580 b 356 780 384 704 361 766 b 356 783 356 782 356 783 l 351 791 b 356 804 351 796 353 799 l 361 814 b 393 958 380 850 387 865 z m 56 386 b 217 609 86 501 153 533 b 292 706 246 642 269 670 b 304 711 295 710 300 711 b 321 703 311 711 320 707 b 328 670 325 693 325 681 b 331 634 330 658 331 645 b 82 367 331 516 199 367 l 75 367 b 56 386 62 367 56 379 z m 330 350 b 334 320 331 340 334 331 b 311 248 334 301 328 278 b 59 72 229 109 141 72 b 56 76 56 73 56 75 b 229 331 81 226 154 249 b 310 423 264 369 289 397 b 330 350 318 396 325 366 z m 330 56 b 334 26 331 46 334 37 b 311 -46 334 7 328 -16 b 56 -222 229 -184 137 -222 b 229 36 75 -86 145 -55 b 311 128 264 73 289 102 z m 330 -238 b 334 -268 331 -248 334 -256 b 311 -340 334 -287 328 -310 b 56 -516 229 -478 137 -516 b 229 -258 75 -380 145 -348 b 311 -166 264 -220 289 -192 z"
    },
    accidentalFlat: {
      x_min: 0,
      x_max: 226,
      y_min: -175,
      y_max: 439,
      ha: 614,
      o: "m 17 -245 b 30 -252 22 -251 26 -252 b 39 -249 35 -252 39 -249 b 153 -161 82 -225 117 -186 b 325 82 281 -72 325 16 b 196 220 325 164 262 216 b 117 196 171 220 137 209 b 85 176 108 189 92 176 b 78 177 82 176 81 176 b 62 202 68 181 62 192 b 72 608 63 233 72 579 b 45 632 72 624 59 632 b 0 592 24 632 1 618 b 17 -245 0 592 6 -230 z m 68 -117 b 63 27 68 -117 63 -30 b 66 73 63 50 65 68 b 167 144 76 102 134 144 b 226 60 209 144 226 96 b 98 -134 226 -17 160 -95 b 84 -138 92 -137 88 -138 b 68 -117 71 -138 68 -124 z"
    },
    accidentalNatural: {
      x_min: 0,
      x_max: 168,
      y_min: -335,
      y_max: 341,
      ha: 676,
      o: "m 203 261 b 197 259 200 261 199 259 b 68 226 197 259 105 226 b 53 233 59 226 53 228 l 53 474 b 36 491 53 484 45 491 l 17 491 b 0 474 7 491 0 484 l 0 -268 b 13 -281 0 -276 4 -281 l 16 -279 b 22 -278 17 -279 20 -279 b 164 -235 42 -269 122 -235 b 189 -251 179 -235 189 -239 l 189 -465 b 206 -482 189 -475 196 -482 l 225 -482 b 242 -465 233 -482 242 -475 l 242 258 b 230 269 242 265 236 269 b 225 268 229 269 226 269 z m 53 56 b 176 114 53 76 141 114 b 189 107 184 114 189 112 l 189 -42 b 71 -101 189 -68 107 -101 b 53 -92 60 -101 53 -98 z"
    },
    accidentalSharp: {
      x_min: 0,
      x_max: 249,
      y_min: -348,
      y_max: 350,
      ha: 698,
      o: "m 341 170 b 359 194 351 174 359 186 l 359 297 b 348 308 359 304 354 308 b 341 307 346 308 344 308 b 305 294 341 307 312 295 b 285 312 295 294 285 301 l 285 488 b 265 504 285 497 276 504 b 242 488 251 504 242 497 l 242 301 b 223 259 240 287 236 268 b 132 223 206 249 157 229 b 115 252 120 223 115 240 l 115 425 b 95 441 115 433 105 441 b 72 425 81 441 72 433 l 72 230 b 55 192 72 210 63 196 b 17 176 46 187 17 176 b 0 153 7 173 0 161 l 0 50 b 13 37 0 42 4 37 l 16 39 b 50 53 17 39 39 48 l 52 55 b 72 29 63 55 72 40 l 72 -114 b 56 -147 72 -130 65 -143 b 17 -163 48 -150 17 -163 b 0 -186 7 -166 0 -177 l 0 -288 b 13 -301 0 -297 4 -301 l 16 -300 b 50 -287 17 -300 37 -291 b 55 -285 52 -285 53 -285 b 72 -308 65 -285 72 -301 l 72 -485 b 91 -501 72 -494 81 -501 b 115 -485 105 -501 115 -494 l 115 -285 b 130 -253 115 -266 122 -256 l 217 -217 b 219 -217 217 -217 219 -217 l 222 -216 b 242 -242 235 -216 242 -233 l 242 -422 b 261 -438 242 -431 251 -438 b 285 -422 276 -438 285 -431 l 285 -217 b 301 -184 285 -206 291 -189 b 341 -168 311 -180 341 -168 b 359 -144 351 -164 359 -153 l 359 -42 b 348 -30 359 -35 354 -30 b 341 -32 346 -30 344 -30 l 304 -46 b 285 -20 295 -46 285 -37 l 285 114 b 304 156 285 124 292 151 z m 242 -65 b 132 -122 233 -94 166 -122 b 115 -115 124 -122 117 -120 b 111 -43 112 -109 111 -78 b 115 63 111 1 112 52 b 220 118 118 88 184 118 b 242 109 230 118 239 115 b 248 27 245 102 248 66 b 242 -65 248 -12 245 -52 z"
    },
    accidentalDoubleSharp: {
      x_min: 0,
      x_max: 247,
      y_min: -125,
      y_max: 127,
      ha: 252,
      o: "m 274 -46 b 206 1 258 -37 206 -9 b 274 50 206 22 253 43 b 278 50 275 50 276 50 l 287 49 b 346 63 304 49 331 52 b 356 115 353 71 356 92 b 292 183 356 174 351 183 b 233 173 266 183 240 180 b 226 117 228 168 226 143 b 179 49 219 101 196 49 b 130 117 158 49 135 96 b 118 173 130 141 125 167 b 66 183 112 180 89 183 b 7 173 42 183 16 180 b 0 120 3 170 0 145 b 7 63 0 94 3 68 b 68 49 17 55 43 49 b 82 50 73 49 78 50 b 150 3 98 42 150 13 b 84 -46 150 -16 104 -39 l 69 -46 b 7 -56 43 -46 16 -49 b 0 -111 3 -60 0 -85 b 7 -166 0 -137 3 -163 b 65 -180 17 -174 40 -180 b 118 -166 86 -180 109 -176 b 130 -111 127 -158 130 -134 b 132 -105 130 -109 131 -107 b 177 -45 141 -85 158 -45 b 226 -111 196 -45 220 -91 b 233 -166 226 -137 228 -161 b 291 -180 243 -174 266 -180 b 356 -114 346 -180 356 -166 b 346 -56 356 -89 351 -63 b 288 -46 338 -49 312 -46 z"
    },
    accidentalDoubleFlat: {
      x_min: 0,
      x_max: 411,
      y_min: -175,
      y_max: 437,
      ha: 612,
      o: "m 452 217 b 384 194 426 217 408 207 b 350 176 374 189 363 176 b 343 177 347 176 344 176 b 328 202 333 180 328 190 b 337 606 328 232 337 579 b 310 629 337 622 324 629 b 265 592 291 629 268 616 b 269 194 265 592 266 395 b 196 217 248 209 223 217 l 187 217 b 120 194 160 217 143 207 b 85 176 108 189 98 176 b 78 177 82 176 81 176 b 62 202 68 180 62 190 b 72 606 62 232 72 579 b 45 629 72 622 59 629 b 0 592 24 629 1 616 b 17 -245 0 592 7 -232 b 30 -252 22 -251 26 -252 b 39 -249 35 -252 39 -249 b 153 -161 84 -226 120 -186 b 274 -50 206 -124 246 -85 b 284 -245 276 -158 279 -240 b 295 -252 288 -251 292 -252 b 304 -249 300 -252 304 -249 b 416 -163 348 -226 383 -186 b 592 82 546 -72 592 16 b 461 217 592 163 528 216 z m 96 -134 b 84 -138 92 -137 86 -138 b 68 -115 72 -138 68 -124 b 63 26 68 -115 63 -30 b 66 72 63 49 65 66 b 168 144 75 101 134 144 b 226 59 212 144 226 95 b 96 -134 226 -22 161 -94 z m 361 -134 b 348 -138 356 -137 351 -138 b 333 -115 337 -138 333 -124 b 328 39 333 -115 328 -16 b 330 72 328 55 328 68 b 433 144 338 101 399 144 b 468 130 448 144 459 140 b 490 59 481 112 490 88 b 361 -134 490 -22 426 -94 z"
    },
    accidentalParensLeft: {
      x_min: 0,
      x_max: 141,
      y_min: -248,
      y_max: 247,
      ha: 495,
      o: "m 203 331 l 203 351 b 202 356 203 354 203 356 b 0 0 60 281 0 140 b 199 -357 0 -144 60 -269 b 203 -354 200 -357 203 -356 l 203 -333 b 200 -327 203 -330 202 -328 b 86 0 118 -253 86 -160 b 200 324 86 158 120 251 b 203 331 202 325 203 327 z"
    },
    accidentalParensRight: {
      x_min: 0,
      x_max: 141,
      y_min: -248,
      y_max: 247,
      ha: 495,
      o: "m 0 331 b 3 324 0 327 1 325 b 117 0 84 251 117 158 b 3 -327 117 -160 85 -253 b 0 -333 1 -328 0 -330 l 0 -354 b 4 -357 0 -356 3 -357 b 203 0 143 -269 203 -144 b 1 356 203 140 143 281 b 0 351 0 356 0 354 z"
    },
    accidentalQuarterToneFlatStein: {
      x_min: 1,
      x_max: 227,
      y_min: -175,
      y_max: 439,
      ha: 614,
      o: "m 310 -245 b 327 592 321 -230 327 592 b 282 632 325 618 302 632 b 255 608 268 632 255 624 b 265 202 255 579 264 233 b 249 177 265 192 259 181 b 242 176 246 176 245 176 b 210 196 235 176 219 189 b 131 220 190 209 156 220 b 1 85 65 216 1 164 b 174 -161 1 16 46 -72 b 288 -249 210 -186 245 -225 b 297 -252 288 -249 292 -252 b 310 -245 301 -252 305 -251 z m 259 -117 b 243 -138 259 -124 256 -138 b 229 -134 239 -138 235 -137 b 101 60 167 -95 101 -17 b 160 144 101 96 118 144 b 261 73 193 144 251 102 b 264 27 262 68 264 50 b 259 -117 264 -30 259 -117 z"
    },
    accidentalThreeQuarterTonesFlatZimmermann: {
      x_min: 1,
      x_max: 466,
      y_min: -175,
      y_max: 439,
      ha: 614,
      o: "m 363 -245 b 376 -252 367 -251 372 -252 b 384 -249 380 -252 384 -249 b 497 -161 428 -226 464 -186 b 671 84 625 -72 671 16 b 541 220 671 164 606 217 b 513 217 531 220 523 219 b 464 196 495 212 480 206 b 431 176 452 189 442 176 b 423 177 428 176 426 176 b 408 202 413 180 408 190 l 419 608 b 392 632 419 625 406 632 b 346 592 372 632 347 618 b 363 -245 346 592 351 -230 z m 289 -249 b 297 -252 289 -249 292 -252 b 310 -245 300 -252 305 -251 b 328 592 321 -230 328 592 b 282 631 327 618 302 631 b 255 608 268 631 255 624 l 266 202 b 251 177 266 190 261 180 b 243 176 248 176 246 176 b 210 196 232 176 222 189 b 164 216 196 204 180 210 l 163 217 b 132 220 151 219 143 220 b 1 84 65 217 1 163 b 177 -163 1 16 48 -72 b 289 -249 210 -186 245 -226 z m 262 72 b 265 26 264 66 265 49 b 261 -115 265 -30 261 -115 b 245 -138 261 -124 258 -138 b 230 -134 240 -138 236 -137 b 102 60 166 -92 102 -20 b 124 128 102 88 111 112 b 161 144 134 138 147 144 b 199 134 173 144 184 141 b 262 72 219 122 256 92 z m 413 -115 b 409 26 413 -115 409 -30 b 412 72 409 49 410 66 b 514 144 420 102 480 144 b 570 60 557 144 570 96 b 442 -134 570 -23 508 -91 b 429 -138 436 -137 433 -138 b 413 -115 418 -138 413 -124 z"
    },
    accidentalQuarterToneSharpStein: {
      x_min: 0,
      x_max: 179,
      y_min: -353,
      y_max: 307,
      ha: 660,
      o: "m 258 240 b 246 252 258 248 252 252 b 240 251 245 252 242 252 b 168 225 240 251 171 225 b 150 253 156 225 150 240 l 150 426 b 130 442 150 435 141 442 b 105 418 108 442 105 429 l 105 230 b 91 193 105 219 101 202 b 17 161 65 183 42 171 b 0 138 9 158 0 147 l 0 36 b 13 23 0 27 4 23 l 16 24 b 86 53 17 24 73 49 l 88 55 b 107 30 98 55 107 42 l 107 -114 b 92 -145 107 -130 101 -143 l 17 -177 b 0 -200 9 -180 0 -192 l 0 -302 b 13 -315 0 -311 4 -315 l 16 -314 b 85 -285 17 -314 72 -291 b 105 -312 92 -282 105 -301 l 105 -492 b 125 -508 105 -501 114 -508 b 150 -484 147 -508 150 -498 l 150 -285 b 151 -274 150 -281 150 -278 b 164 -253 153 -265 158 -256 b 240 -225 176 -251 240 -225 b 258 -202 249 -222 258 -210 l 258 -99 b 245 -86 258 -91 253 -86 l 242 -88 b 240 -88 242 -88 240 -88 l 240 -86 b 168 -115 240 -86 174 -114 b 148 -91 158 -115 148 -107 l 148 43 b 167 85 148 55 156 81 b 240 114 180 91 240 114 b 258 138 249 118 258 128 z"
    },
    accidentalThreeQuarterTonesSharpStein: {
      x_min: 3,
      x_max: 317,
      y_min: -347,
      y_max: 369,
      ha: 716,
      o: "m 456 324 b 448 336 456 330 454 336 b 393 317 445 336 400 320 b 389 315 392 315 390 315 b 383 325 386 315 383 318 l 383 508 b 360 531 383 528 379 531 b 337 508 341 531 337 527 l 337 318 b 325 291 337 300 334 294 b 268 268 320 288 287 276 b 253 281 256 268 253 274 l 253 464 b 230 487 253 484 249 487 b 207 464 212 487 207 482 l 207 264 b 194 240 207 253 204 245 l 132 217 b 131 217 132 217 132 217 l 130 216 b 118 229 122 216 118 220 l 118 420 b 95 444 118 439 114 444 b 72 420 76 444 72 439 l 72 212 b 60 190 72 197 68 193 l 16 173 b 4 161 9 170 4 167 l 4 50 b 13 39 4 45 9 39 b 58 55 16 39 46 49 b 63 56 60 56 62 56 b 72 42 71 56 72 50 l 72 -125 b 58 -150 72 -137 65 -147 l 16 -166 b 4 -177 9 -168 4 -171 l 4 -289 b 14 -301 4 -295 9 -301 b 53 -287 16 -301 40 -291 b 62 -285 56 -285 59 -285 b 72 -298 69 -285 72 -289 l 72 -477 b 95 -500 72 -495 76 -500 b 118 -477 114 -500 118 -495 l 118 -278 b 127 -259 118 -269 121 -261 l 196 -232 b 207 -243 204 -232 207 -235 l 207 -432 b 230 -455 207 -452 212 -455 b 253 -432 249 -455 253 -451 l 253 -228 b 268 -204 253 -216 259 -207 l 320 -186 b 328 -183 323 -184 325 -183 b 337 -194 334 -183 337 -187 l 337 -387 b 360 -410 337 -408 341 -410 b 383 -387 379 -410 383 -406 l 383 -174 b 395 -157 383 -166 390 -158 l 445 -138 b 456 -127 452 -135 456 -132 l 456 -14 b 448 -3 456 -10 454 -3 b 397 -22 445 -3 408 -17 l 396 -23 b 383 -6 387 -23 383 -16 l 383 163 b 392 181 383 173 384 179 b 445 202 397 183 445 202 b 456 213 452 203 456 207 z m 337 -45 b 266 -78 333 -56 287 -78 b 258 -75 262 -78 259 -76 b 253 19 255 -71 253 -27 b 258 130 253 69 255 122 b 333 163 264 141 315 163 b 337 161 334 163 337 161 b 341 78 340 157 341 120 b 337 -45 341 24 340 -37 z m 118 -127 b 114 -48 114 -121 114 -86 b 118 78 114 6 115 68 b 200 114 122 91 180 114 b 207 111 204 114 206 112 b 212 22 210 107 212 66 b 207 -94 212 -29 210 -85 b 127 -130 203 -108 148 -130 b 118 -127 122 -130 120 -128 z"
    },
    accidentalBuyukMucennebFlat: {
      x_min: 1,
      x_max: 287,
      y_min: -174,
      y_max: 438,
      ha: 612,
      o: "m 379 452 b 370 464 379 458 377 464 b 164 389 366 464 170 392 b 156 396 163 389 156 393 b 157 436 157 409 157 428 b 167 452 157 445 161 449 b 366 526 173 455 366 526 b 379 540 374 528 379 534 l 379 611 b 370 622 379 616 377 622 b 170 550 366 622 174 552 b 160 557 163 550 160 554 b 161 608 160 585 161 602 b 134 631 161 624 148 631 b 89 590 114 631 91 616 l 89 528 b 81 517 89 526 88 518 b 16 491 76 514 16 491 b 1 480 6 490 1 485 l 1 406 b 13 395 1 400 4 395 l 14 396 b 79 419 16 396 72 415 b 89 412 86 419 89 415 b 91 376 89 399 89 386 b 82 359 91 364 89 361 b 16 331 76 356 16 331 b 1 321 6 331 1 328 l 1 248 b 13 236 1 242 4 236 b 79 262 16 236 71 258 b 92 251 89 262 92 256 b 107 -242 95 23 101 -236 b 120 -251 111 -249 115 -251 b 128 -248 124 -251 128 -248 b 240 -160 171 -225 207 -184 b 413 84 367 -71 413 16 b 284 220 413 166 350 216 b 207 196 259 220 229 209 b 170 176 196 190 184 176 l 168 177 b 151 203 157 181 151 192 b 153 269 151 210 151 236 b 163 292 153 275 153 289 b 366 367 173 297 366 367 b 379 383 374 370 379 376 z m 186 -132 b 173 -137 180 -135 176 -137 b 157 -114 161 -137 157 -122 b 153 35 157 -114 153 -22 b 154 73 153 53 153 68 b 219 135 160 92 197 124 b 255 144 232 141 243 144 b 292 130 269 144 282 140 b 314 62 305 114 314 91 b 186 -132 314 -17 251 -94 z"
    },
    accidentalBuyukMucennebSharp: {
      x_min: 0,
      x_max: 341,
      y_min: -350,
      y_max: 348,
      ha: 698,
      o: "m 403 167 b 420 192 413 171 420 183 l 420 294 b 410 305 420 301 416 305 b 403 304 408 305 406 305 b 367 291 403 304 374 292 b 347 310 357 291 347 298 l 347 485 b 327 501 347 494 338 501 b 304 485 312 501 304 494 l 304 298 b 285 256 302 284 298 265 b 194 220 268 246 219 226 b 177 249 181 220 177 238 l 177 422 b 157 438 177 431 167 438 b 134 422 143 438 134 431 l 134 228 b 117 189 134 207 125 193 b 79 173 108 184 79 173 b 62 150 69 170 62 158 l 62 48 b 75 35 62 39 66 35 l 78 36 b 111 50 79 36 101 45 b 127 55 117 52 122 55 b 132 50 130 55 132 53 l 132 29 b 128 22 132 26 132 23 b 17 -20 125 20 17 -20 b 0 -35 7 -23 0 -26 l 0 -130 b 13 -144 0 -137 4 -144 b 127 -104 17 -144 120 -107 l 128 -102 b 134 -109 134 -102 134 -107 l 134 -127 b 122 -147 134 -138 132 -143 b 79 -166 114 -151 79 -166 b 62 -189 69 -168 62 -180 l 62 -291 b 75 -304 62 -300 66 -304 l 78 -302 b 112 -289 79 -302 99 -294 b 117 -288 114 -288 115 -288 b 134 -311 127 -288 134 -304 l 134 -488 b 153 -504 134 -497 143 -504 b 177 -488 167 -504 177 -497 l 177 -288 b 192 -256 177 -269 184 -259 l 279 -220 b 281 -220 279 -220 281 -220 l 284 -219 b 304 -245 297 -219 304 -236 l 304 -425 b 323 -441 304 -433 312 -441 b 347 -425 338 -441 347 -433 l 347 -220 b 363 -187 347 -209 353 -192 b 403 -171 373 -183 403 -171 b 420 -147 413 -167 420 -156 l 420 -45 b 410 -33 420 -37 416 -33 b 403 -35 408 -33 406 -33 l 366 -49 b 353 -53 360 -52 356 -53 b 347 -40 348 -53 347 -49 l 347 -26 b 351 -19 347 -23 347 -20 l 474 27 b 491 46 485 30 491 37 l 491 137 b 478 153 491 143 488 153 l 475 150 b 474 150 475 150 474 150 l 474 151 b 351 105 474 151 354 107 b 347 109 348 105 347 107 b 346 128 347 117 346 127 b 366 153 346 143 348 145 z m 177 72 b 301 122 196 89 262 122 b 305 111 305 122 305 117 b 307 94 305 105 305 96 b 304 88 307 92 307 89 b 179 40 284 81 180 42 b 174 43 177 40 174 42 b 177 72 176 50 174 69 z m 305 -65 b 184 -121 301 -85 210 -121 b 177 -118 180 -121 179 -120 b 173 -92 174 -115 174 -105 b 179 -84 173 -86 174 -85 b 302 -37 180 -84 279 -46 b 307 -42 304 -37 307 -40 b 305 -65 307 -52 307 -59 z"
    },
    accidentalBakiyeFlat: {
      x_min: -1,
      x_max: 286,
      y_min: -175,
      y_max: 439,
      ha: 614,
      o: "m 377 454 b 369 467 377 458 376 467 b 363 465 367 467 364 467 b 161 390 363 465 167 393 b 153 399 154 390 153 395 b 157 608 154 494 157 593 b 130 632 157 624 144 632 b 86 592 111 632 88 618 b 88 377 86 592 86 501 b 76 356 88 373 88 360 l 12 331 b -1 320 3 330 -1 327 l -1 248 b 9 236 -1 242 1 236 b 81 264 12 236 78 261 b 89 258 86 264 89 261 b 104 -245 92 30 96 -236 b 115 -252 108 -251 112 -252 b 124 -249 120 -252 124 -249 b 239 -161 167 -226 203 -186 b 412 84 367 -72 412 17 b 282 220 412 166 348 216 b 255 216 274 220 264 219 b 203 196 238 212 222 206 b 171 177 193 189 177 177 b 163 179 168 177 166 177 b 147 202 153 181 147 192 b 147 216 147 204 147 209 l 150 262 b 150 276 150 269 150 275 b 158 291 150 287 154 289 b 363 370 163 292 363 370 b 377 384 373 373 377 379 z m 181 -134 b 167 -138 176 -137 171 -138 b 153 -117 156 -138 153 -125 b 148 27 153 -117 148 -30 b 151 73 148 50 150 68 b 255 144 161 105 219 144 b 312 62 298 144 312 99 b 181 -134 312 -19 249 -96 z"
    },
    accidentalKomaSharp: {
      x_min: 0,
      x_max: 229,
      y_min: -337,
      y_max: 322,
      ha: 659,
      o: "m 312 151 b 330 176 323 156 330 166 l 330 278 b 320 289 330 285 327 289 b 312 288 318 289 315 289 b 200 246 312 288 203 248 b 181 275 187 246 181 264 l 181 448 b 163 464 181 456 173 464 b 138 441 140 464 138 452 l 138 253 b 122 215 137 240 132 225 b 17 177 92 203 45 177 b 0 153 7 173 0 163 l 0 50 b 10 39 0 43 4 39 b 17 40 13 39 14 39 l 128 81 b 138 52 138 81 138 63 l 138 -91 b 124 -124 138 -107 132 -120 b 17 -167 115 -127 17 -167 b 0 -192 7 -171 0 -181 l 0 -294 b 10 -305 0 -301 4 -305 b 17 -304 13 -305 14 -305 b 128 -261 17 -304 117 -264 l 130 -259 b 138 -276 137 -259 138 -268 l 138 -469 b 157 -485 138 -478 147 -485 b 181 -462 179 -485 181 -475 l 181 -262 b 183 -252 181 -258 181 -255 b 197 -232 186 -243 190 -235 b 312 -187 207 -228 312 -187 b 330 -163 323 -183 330 -173 l 330 -60 b 320 -49 330 -53 327 -49 b 312 -50 318 -49 315 -49 l 200 -94 b 193 -95 197 -95 194 -95 b 181 -68 183 -95 181 -85 l 181 66 b 200 108 181 92 189 104 z"
    },
    accidentalKucukMucennebSharp: {
      x_min: -1,
      x_max: 339,
      y_min: -338,
      y_max: 321,
      ha: 659,
      o: "m 264 92 b 271 102 264 98 265 99 l 395 150 b 412 174 405 154 412 164 l 412 276 b 402 288 412 284 409 288 b 395 287 400 288 397 288 b 282 245 395 287 285 246 b 264 274 269 245 264 262 l 264 446 b 245 462 264 455 255 462 b 220 439 222 462 220 451 l 220 252 b 204 213 219 239 215 223 b 99 176 174 202 127 176 b 82 151 89 171 82 161 l 82 49 b 92 37 82 42 86 37 b 99 39 95 37 96 37 l 210 79 b 216 81 212 81 215 81 b 220 78 219 81 220 79 l 220 56 b 216 46 220 52 220 48 b 16 -29 210 45 16 -29 b -1 -45 4 -32 -1 -36 l -1 -138 b 12 -154 -1 -145 3 -154 l 215 -79 b 220 -84 219 -79 220 -81 l 220 -105 b 210 -122 220 -115 219 -120 b 99 -168 202 -127 99 -168 b 82 -193 89 -173 82 -183 l 82 -295 b 92 -307 82 -302 86 -307 b 99 -305 95 -307 96 -307 b 210 -262 99 -305 199 -265 l 212 -261 b 220 -278 219 -261 220 -269 l 220 -471 b 239 -487 220 -480 229 -487 b 264 -464 261 -487 264 -477 l 264 -264 b 265 -253 264 -259 264 -256 b 279 -233 268 -245 272 -236 b 395 -189 289 -229 395 -189 b 412 -164 405 -184 412 -174 l 412 -62 b 402 -50 412 -55 409 -50 b 395 -52 400 -50 397 -50 l 278 -96 b 264 -86 268 -96 264 -94 l 264 -68 b 269 -59 264 -62 265 -60 b 471 17 274 -58 471 17 b 488 36 484 22 488 27 l 488 127 b 475 144 488 134 487 144 l 472 141 b 471 141 472 141 471 141 l 471 143 b 272 68 471 143 282 71 l 269 66 b 264 71 264 66 264 69 z"
    },
    accidentalKoron: {
      x_min: 0,
      x_max: 300,
      y_min: -472,
      y_max: 157,
      ha: 629,
      o: "m 432 -4 b 415 10 432 1 418 9 l 4 226 b 0 223 1 226 0 225 l 0 -672 b 7 -680 0 -677 3 -680 l 45 -680 b 52 -672 49 -680 52 -677 l 52 -193 l 415 -22 b 432 -4 418 -20 432 -13 z m 52 -137 l 52 144 l 327 -7 z"
    },
    accidentalSori: {
      x_min: 0,
      x_max: 421,
      y_min: -318,
      y_max: 328,
      ha: 646,
      o: "m 606 10 b 589 23 606 16 592 22 l 382 109 l 382 465 b 374 472 382 469 379 472 l 337 472 b 330 465 333 472 330 469 l 330 132 l 183 194 l 183 425 b 176 432 183 429 180 432 l 138 432 b 131 425 134 432 131 429 l 131 216 l 3 269 b 0 265 0 269 0 266 l 0 223 b 3 213 0 216 0 215 l 131 160 l 131 -150 l 3 -203 b 0 -212 0 -204 0 -206 l 0 -255 b 3 -259 0 -258 1 -259 l 131 -204 l 131 -451 b 138 -458 131 -455 134 -458 l 176 -458 b 183 -451 180 -458 183 -455 l 183 -183 l 330 -120 l 330 -410 b 337 -418 330 -415 333 -418 l 374 -418 b 382 -410 379 -418 382 -415 l 382 -98 l 589 -9 b 606 10 592 -9 606 0 z m 183 -128 l 183 138 l 330 76 l 330 -66 z m 382 -45 l 382 55 l 501 6 z"
    },
    articAccentAbove: {
      x_min: 0,
      x_max: 339,
      y_min: 1,
      y_max: 245,
      ha: 244,
      o: "m 469 151 b 488 177 488 156 488 166 b 469 203 488 189 488 197 l 37 350 b 24 353 32 351 26 353 b 3 333 12 353 7 344 b 0 318 1 327 0 323 b 20 298 0 311 4 304 b 346 187 20 298 331 193 b 356 177 353 186 356 181 b 344 167 356 173 353 170 b 20 58 328 163 20 58 b 0 36 4 50 0 43 b 3 23 0 32 1 27 b 23 1 7 13 13 1 b 29 3 24 1 27 1 z"
    },
    articAccentBelow: {
      x_min: 0,
      x_max: 339,
      y_min: -244,
      y_max: 0,
      ha: 244,
      o: "m 469 -202 b 488 -176 488 -197 488 -187 b 469 -150 488 -164 488 -156 l 37 -3 b 24 0 32 -1 26 0 b 3 -20 12 0 7 -9 b 0 -35 1 -26 0 -30 b 20 -55 0 -42 4 -49 b 346 -166 20 -55 331 -160 b 356 -176 353 -167 356 -171 b 344 -186 356 -180 353 -183 b 20 -295 328 -190 20 -295 b 0 -317 4 -302 0 -310 b 3 -330 0 -321 1 -325 b 23 -351 7 -340 13 -351 b 29 -350 24 -351 27 -351 z"
    },
    articTenutoAbove: {
      x_min: -1,
      x_max: 338,
      y_min: 0,
      y_max: 48,
      ha: 48,
      o: "m 452 0 b 487 35 485 0 487 16 b 452 69 487 53 487 69 l 33 69 b -1 35 -1 69 -1 53 b 33 0 -1 16 -1 0 z"
    },
    articTenutoBelow: {
      x_min: -1,
      x_max: 338,
      y_min: -48,
      y_max: 0,
      ha: 48,
      o: "m 452 -69 b 487 -35 485 -69 487 -53 b 452 0 487 -16 487 0 l 33 0 b -1 -35 -1 0 -1 -16 b 33 -69 -1 -53 -1 -69 z"
    },
    articStaccatoAbove: {
      x_min: 0,
      x_max: 84,
      y_min: 0,
      y_max: 84,
      ha: 84,
      o: "m 121 60 b 60 121 121 94 94 121 b 0 60 27 121 0 94 b 60 0 0 27 27 0 b 121 60 94 0 121 27 z"
    },
    articStaccatoBelow: {
      x_min: 0,
      x_max: 84,
      y_min: -84,
      y_max: 0,
      ha: 84,
      o: "m 121 -60 b 60 0 121 -27 94 0 b 0 -60 27 0 0 -27 b 60 -121 0 -94 27 -121 b 121 -60 94 -121 121 -94 z"
    },
    articStaccatissimoAbove: {
      x_min: 1,
      x_max: 100,
      y_min: -2,
      y_max: 293,
      ha: 295,
      o: "m 72 422 b 1 390 35 422 3 409 b 72 -3 1 369 39 -3 b 144 389 108 -3 144 356 b 72 422 144 410 111 422 z"
    },
    articStaccatissimoBelow: {
      x_min: 1,
      x_max: 100,
      y_min: -295,
      y_max: 0,
      ha: 295,
      o: "m 72 -425 b 144 -392 111 -425 144 -413 b 72 0 144 -359 108 0 b 1 -393 39 0 1 -372 b 72 -425 3 -412 35 -425 z"
    },
    articMarcatoAbove: {
      x_min: -1,
      x_max: 235,
      y_min: -1,
      y_max: 253,
      ha: 254,
      o: "m 181 356 b 167 364 177 361 173 364 b 153 356 157 364 153 356 l 0 23 b -1 16 -1 20 -1 19 b 9 0 -1 9 1 1 b 16 -1 10 -1 14 -1 b 32 9 22 -1 29 1 b 112 186 32 9 109 180 b 118 190 114 189 115 190 b 127 186 121 190 124 189 b 209 9 128 180 209 9 b 225 0 213 3 219 0 l 323 0 b 338 16 333 1 338 7 b 337 23 338 19 338 22 z"
    },
    articMarcatoBelow: {
      x_min: -1,
      x_max: 235,
      y_min: -254,
      y_max: 0,
      ha: 254,
      o: "m 156 -357 b 170 -366 160 -363 164 -366 b 184 -357 180 -366 184 -357 l 337 -24 b 338 -17 338 -22 338 -20 b 328 -1 338 -10 336 -3 b 321 0 327 0 323 0 b 305 -10 315 0 308 -3 b 225 -187 305 -10 228 -181 b 219 -192 223 -190 222 -192 b 210 -187 216 -192 213 -190 b 128 -10 209 -181 128 -10 b 112 -1 124 -4 118 -1 l 14 -1 b -1 -17 4 -3 -1 -9 b 0 -24 -1 -20 -1 -23 z"
    },
    fermataAbove: {
      x_min: 3,
      x_max: 605,
      y_min: -3,
      y_max: 329,
      ha: 332,
      o: "m 435 318 b 818 36 742 318 804 91 b 821 26 819 32 819 27 b 851 -4 831 6 837 -4 b 871 16 864 -4 871 1 b 870 30 871 20 871 24 b 438 474 780 471 480 474 b 6 30 392 474 94 471 b 4 14 4 24 4 19 b 23 -4 4 0 12 -4 b 52 26 36 -4 43 6 b 56 39 53 27 55 33 b 435 318 73 98 138 318 z m 516 75 b 436 153 516 117 480 153 b 359 75 395 153 359 117 b 436 -4 359 32 395 -4 b 516 75 480 -4 516 32 z"
    },
    fermataBelow: {
      x_min: 3,
      x_max: 605,
      y_min: -332,
      y_max: 0,
      ha: 332,
      o: "m 435 -323 b 56 -43 138 -323 73 -102 b 52 -30 55 -37 53 -32 b 23 0 43 -10 36 0 b 4 -19 12 0 4 -4 b 6 -35 4 -23 4 -29 b 438 -478 94 -475 392 -478 b 870 -35 480 -478 780 -475 b 871 -20 871 -29 871 -24 b 851 0 871 -6 864 0 b 821 -30 837 0 831 -10 b 818 -40 819 -32 819 -36 b 435 -323 804 -95 742 -323 z m 516 -79 b 436 0 516 -36 480 0 b 359 -79 395 0 359 -36 b 436 -157 359 -121 395 -157 b 516 -79 480 -157 516 -121 z"
    },
    fermataLongAbove: {
      x_min: 0,
      x_max: 603,
      y_min: -1,
      y_max: 333,
      ha: 334,
      o: "m 72 480 b 0 441 32 480 0 462 l 0 19 b 35 0 0 9 16 0 b 71 19 55 0 71 9 l 71 289 b 433 315 71 307 252 315 b 798 289 615 315 798 307 l 798 19 b 832 0 798 9 814 0 b 868 19 852 0 868 9 l 868 441 b 796 480 868 462 837 480 z m 513 78 b 433 156 513 121 478 156 b 356 78 390 156 356 121 b 433 -1 356 35 390 -1 b 513 78 478 -1 513 35 z"
    },
    fermataLongBelow: {
      x_min: 0,
      x_max: 603,
      y_min: -333,
      y_max: 1,
      ha: 334,
      o: "m 513 -78 b 433 1 513 -35 478 1 b 356 -78 390 1 356 -35 b 433 -156 356 -121 390 -156 b 513 -78 478 -156 513 -121 z m 796 -480 b 868 -441 837 -480 868 -462 l 868 -19 b 832 0 868 -9 852 0 b 798 -19 814 0 798 -9 l 798 -289 b 433 -315 798 -307 615 -315 b 71 -289 252 -315 71 -307 l 71 -19 b 35 0 71 -9 55 0 b 0 -19 16 0 0 -9 l 0 -441 b 72 -480 0 -462 32 -480 z"
    },
    fermataVeryLongAbove: {
      x_min: 0,
      x_max: 715,
      y_min: 0,
      y_max: 408,
      ha: 408,
      o: "m 76 588 b 0 546 35 588 0 569 l 0 22 b 37 1 0 10 17 1 b 75 22 59 1 75 10 l 75 431 b 514 458 75 449 294 458 b 955 431 734 458 955 449 l 955 22 b 991 1 955 10 971 1 b 1030 22 1012 1 1030 10 l 1030 546 b 953 588 1030 569 995 588 z m 215 389 b 138 347 171 389 138 370 l 138 22 b 174 1 138 10 154 1 b 213 22 196 1 213 10 l 213 217 b 514 245 213 235 363 245 b 816 217 665 245 816 235 l 816 22 b 854 1 816 10 834 1 b 891 22 876 1 891 10 l 891 347 b 815 389 891 370 858 389 z m 606 84 b 521 167 606 130 569 167 b 439 84 475 167 439 130 b 521 0 439 39 475 0 b 606 84 569 0 606 39 z"
    },
    fermataVeryLongBelow: {
      x_min: 0,
      x_max: 715,
      y_min: -408,
      y_max: 0,
      ha: 408,
      o: "m 606 -84 b 521 0 606 -39 569 0 b 439 -84 475 0 439 -39 b 521 -167 439 -130 475 -167 b 606 -84 569 -167 606 -130 z m 815 -389 b 891 -347 858 -389 891 -370 l 891 -22 b 854 -1 891 -10 876 -1 b 816 -22 834 -1 816 -10 l 816 -217 b 514 -245 816 -235 665 -245 b 213 -217 363 -245 213 -235 l 213 -22 b 174 -1 213 -10 196 -1 b 138 -22 154 -1 138 -10 l 138 -347 b 215 -389 138 -370 171 -389 z m 953 -588 b 1030 -546 995 -588 1030 -569 l 1030 -22 b 991 -1 1030 -10 1012 -1 b 955 -22 971 -1 955 -10 l 955 -431 b 514 -458 955 -449 734 -458 b 75 -431 294 -458 75 -449 l 75 -22 b 37 -1 75 -10 59 -1 b 0 -22 17 -1 0 -10 l 0 -546 b 76 -588 0 -569 35 -588 z"
    },
    fermataVeryShortAbove: {
      x_min: 0,
      x_max: 726,
      y_min: 0,
      y_max: 449,
      ha: 449,
      o: "m 46 0 b 59 7 50 0 52 4 b 516 517 120 59 507 517 b 975 4 527 517 920 52 b 988 0 979 1 988 0 l 1041 0 b 1045 6 1041 0 1045 1 b 1043 13 1045 7 1045 10 b 516 647 962 91 536 647 b 3 13 504 647 91 98 b 0 7 0 10 0 9 b 6 0 0 3 6 0 z m 238 0 b 248 6 240 0 242 3 b 516 236 292 43 494 236 b 786 3 539 236 746 37 b 796 0 789 1 796 0 l 865 0 b 870 4 865 0 870 1 b 867 10 870 6 868 9 b 516 409 806 68 531 409 b 166 10 497 409 229 73 b 163 4 164 9 163 6 b 167 0 163 1 167 0 z m 592 91 b 516 167 592 132 557 167 b 438 91 472 167 438 132 b 516 13 438 48 472 13 b 592 91 557 13 592 48 z"
    },
    fermataVeryShortBelow: {
      x_min: 0,
      x_max: 726,
      y_min: -449,
      y_max: 0,
      ha: 449,
      o: "m 167 0 b 163 -4 167 0 163 -1 b 166 -10 163 -6 164 -9 b 516 -409 229 -73 497 -409 b 867 -10 531 -409 806 -68 b 870 -4 868 -9 870 -6 b 865 0 870 -1 865 0 l 796 0 b 786 -3 796 0 789 -1 b 516 -236 746 -37 539 -236 b 248 -6 494 -236 292 -43 b 238 0 242 -3 240 0 z m 6 0 b 0 -7 6 0 0 -3 b 3 -13 0 -9 0 -10 b 516 -647 91 -98 504 -647 b 1043 -13 536 -647 962 -91 b 1045 -6 1045 -10 1045 -7 b 1041 0 1045 -1 1041 0 l 988 0 b 975 -4 988 0 979 -1 b 516 -517 920 -52 527 -517 b 59 -7 507 -517 120 -59 b 46 0 52 -4 50 0 z m 592 -91 b 516 -13 592 -48 557 -13 b 438 -91 472 -13 438 -48 b 516 -167 438 -132 472 -167 b 592 -91 557 -167 592 -132 z"
    },
    fermataShortAbove: {
      x_min: 0,
      x_max: 604,
      y_min: 0,
      y_max: 341,
      ha: 341,
      o: "m 78 0 b 88 6 81 0 82 3 b 435 328 134 45 412 328 b 783 3 458 328 742 39 b 793 0 786 1 793 0 l 865 0 b 870 4 865 0 870 1 b 867 10 870 6 868 9 b 435 491 805 69 474 491 b 3 10 397 491 69 75 b 0 4 1 9 0 6 b 4 0 0 1 4 0 z m 513 94 b 433 171 513 135 477 171 b 354 94 390 171 354 135 b 433 13 354 49 390 13 b 513 94 477 13 513 49 z"
    },
    fermataShortBelow: {
      x_min: 0,
      x_max: 604,
      y_min: -341,
      y_max: 0,
      ha: 341,
      o: "m 4 0 b 0 -4 4 0 0 -1 b 3 -10 0 -6 1 -9 b 435 -491 69 -75 397 -491 b 867 -10 474 -491 805 -69 b 870 -4 868 -9 870 -6 b 865 0 870 -1 865 0 l 793 0 b 783 -3 793 0 786 -1 b 435 -328 742 -39 458 -328 b 88 -6 412 -328 134 -45 b 78 0 82 -3 81 0 z m 513 -94 b 433 -13 513 -49 477 -13 b 354 -94 390 -13 354 -49 b 433 -171 354 -135 390 -171 b 513 -94 477 -171 513 -135 z"
    },
    breathMarkComma: {
      x_min: 1,
      x_max: 152,
      y_min: 2,
      y_max: 251,
      ha: 249,
      o: "m 104 361 b 1 271 42 361 1 321 b 82 190 1 222 35 190 b 122 160 118 190 122 160 b 125 144 124 154 125 150 b 102 88 125 124 115 105 b 37 32 78 56 40 35 b 26 17 32 29 26 26 l 27 16 b 37 3 29 6 33 3 b 181 102 85 3 158 66 b 219 239 210 147 219 197 l 219 249 b 104 361 219 317 170 361 z"
    },
    breathMarkUpbow: {
      x_min: 1,
      x_max: 249,
      y_min: 1,
      y_max: 495,
      ha: 494,
      o: "m 181 1 b 206 22 193 1 203 10 l 359 683 l 359 688 b 338 713 359 700 351 710 l 333 713 b 308 694 321 713 311 706 l 180 140 l 53 694 b 27 713 49 706 39 713 l 22 713 b 1 690 10 710 1 700 b 3 683 1 687 1 685 l 154 22 b 181 1 157 10 167 1 z"
    },
    caesura: {
      x_min: 0,
      x_max: 384,
      y_min: -1,
      y_max: 532,
      ha: 533,
      o: "m 40 -1 b 78 26 58 -1 72 9 l 321 713 b 323 726 323 717 323 721 b 282 766 323 747 304 766 b 245 739 265 766 251 756 l 3 52 b 0 37 1 48 0 42 b 27 1 0 22 10 7 b 40 -1 32 -1 36 -1 z m 308 26 l 552 713 b 553 726 553 717 553 721 b 513 766 553 747 534 766 b 475 739 495 766 481 756 l 232 52 b 230 39 230 48 230 43 b 258 1 230 23 240 7 b 271 -1 262 -1 266 -1 b 308 26 287 -1 302 9 z"
    },
    caesuraCurved: {
      x_min: 0,
      x_max: 373,
      y_min: 0,
      y_max: 530,
      ha: 530,
      o: "m 491 763 b 445 719 468 763 446 744 b 252 98 432 507 340 295 l 226 39 b 223 27 225 35 223 32 b 252 0 223 13 233 0 b 276 16 262 0 272 6 b 537 716 386 230 537 478 b 491 763 537 742 518 763 z m 29 0 b 53 16 39 0 48 6 l 82 69 b 314 716 187 264 314 498 b 268 763 314 742 295 763 b 222 719 245 763 223 744 b 29 98 209 507 117 295 l 3 39 b 0 29 1 36 0 33 b 29 0 0 14 12 0 z"
    },
    restMaxima: {
      x_min: 0,
      x_max: 381,
      y_min: -249,
      y_max: 250,
      ha: 499,
      o: "m 180 -330 l 180 331 b 156 360 180 356 170 360 l 23 360 b 0 331 10 360 0 356 l 0 -330 b 23 -359 0 -354 10 -359 l 156 -359 b 180 -330 170 -359 180 -354 z m 549 -330 l 549 331 b 524 360 549 356 539 360 l 392 360 b 369 331 379 360 369 356 l 369 -330 b 392 -359 369 -354 379 -359 l 524 -359 b 549 -330 539 -359 549 -354 z"
    },
    restDoubleWhole: {
      x_min: 0,
      x_max: 125,
      y_min: 0,
      y_max: 250,
      ha: 250,
      o: "m 180 22 l 180 338 b 156 360 180 350 170 360 l 23 360 b 0 338 10 360 0 350 l 0 22 b 23 0 0 10 10 0 l 156 0 b 180 22 170 0 180 10 z"
    },
    restWhole: {
      x_min: 0,
      x_max: 282,
      y_min: -135,
      y_max: 9,
      ha: 144,
      o: "m 406 -157 l 406 -24 b 369 13 406 -3 389 13 l 37 13 b 0 -24 16 13 0 -3 l 0 -157 b 37 -194 0 -177 16 -194 l 369 -194 b 406 -157 389 -194 406 -177 z"
    },
    restWholeLegerLine: {
      x_min: -117,
      x_max: 399,
      y_min: -135,
      y_max: 20,
      ha: 155,
      o: "m -143 29 b -168 3 -157 29 -168 17 b -143 -23 -168 -12 -157 -23 l 0 -23 l 0 -157 b 37 -194 0 -177 16 -194 l 369 -194 b 406 -157 389 -194 406 -177 l 406 -24 b 549 -23 406 -23 406 -23 b 575 3 563 -23 575 -12 b 549 29 575 17 563 29 z"
    },
    restHalf: {
      x_min: 0,
      x_max: 282,
      y_min: -2,
      y_max: 142,
      ha: 144,
      o: "m 406 35 l 406 167 b 369 204 406 189 389 204 l 37 204 b 0 167 16 204 0 189 l 0 35 b 37 -3 0 14 16 -3 l 369 -3 b 406 35 389 -3 406 14 z"
    },
    restHalfLegerLine: {
      x_min: -117,
      x_max: 399,
      y_min: -13,
      y_max: 142,
      ha: 155,
      o: "m 549 -19 b 575 7 563 -19 575 -7 b 549 33 575 22 563 33 b 406 35 406 33 406 33 l 406 167 b 369 204 406 187 389 204 l 37 204 b 0 167 16 204 0 187 l 0 33 l -143 33 b -168 7 -157 33 -168 22 b -143 -19 -168 -7 -157 -19 z"
    },
    restQuarter: {
      x_min: 1,
      x_max: 270,
      y_min: -375,
      y_max: 373,
      ha: 748,
      o: "m 112 -55 b 174 -141 135 -84 156 -111 b 183 -161 177 -147 183 -158 b 181 -167 183 -163 183 -166 b 166 -174 179 -173 173 -174 b 143 -170 160 -174 148 -171 b 137 -170 141 -170 138 -170 l 125 -166 b 1 -304 50 -166 1 -233 b 168 -527 1 -376 63 -446 b 206 -540 180 -536 194 -540 b 228 -531 216 -540 226 -537 b 230 -521 229 -527 230 -524 b 207 -487 230 -508 219 -497 b 170 -435 189 -487 173 -448 b 164 -397 166 -423 164 -410 b 255 -292 164 -338 194 -292 b 369 -317 297 -292 344 -308 l 370 -318 b 382 -320 376 -320 379 -320 b 389 -314 386 -320 389 -318 b 336 -232 389 -297 351 -249 b 236 -32 281 -166 236 -112 b 236 -27 236 -30 236 -29 l 238 -17 b 238 -13 238 -16 238 -14 b 333 199 243 71 295 140 b 338 220 337 206 338 213 b 333 248 338 235 333 248 b 95 526 333 248 120 501 b 69 537 88 533 78 537 b 40 507 55 537 40 527 b 46 484 40 500 42 492 b 134 291 52 468 134 395 b 48 108 134 238 112 176 b 27 66 33 94 27 78 b 42 32 27 46 42 32 z"
    },
    rest8th: {
      x_min: 0,
      x_max: 247,
      y_min: -251,
      y_max: 174,
      ha: 425,
      o: "m 193 154 b 96 251 193 207 150 251 b 0 154 43 251 0 207 b 39 81 0 124 17 98 b 117 56 62 65 89 56 b 173 66 137 56 157 60 b 225 88 193 72 206 78 b 232 89 228 89 230 89 b 239 76 238 89 239 84 b 238 60 239 72 239 66 b 104 -343 233 39 130 -248 b 145 -361 104 -360 137 -361 b 196 -347 161 -361 181 -359 b 341 161 200 -344 341 161 b 356 217 347 187 354 210 b 338 240 356 232 341 239 b 323 235 336 240 331 240 b 193 140 312 226 240 140 z"
    },
    rest16th: {
      x_min: 0,
      x_max: 320,
      y_min: -500,
      y_max: 179,
      ha: 679,
      o: "m 300 160 b 202 258 300 215 256 258 b 104 160 148 258 104 215 b 219 62 104 101 164 62 b 331 94 258 62 298 75 b 341 96 336 95 338 96 b 348 86 346 96 348 94 b 265 -173 348 63 275 -151 b 194 -217 253 -200 215 -217 b 196 -203 196 -212 196 -207 b 98 -105 196 -148 151 -105 b 0 -203 43 -105 0 -148 b 115 -301 0 -262 60 -301 b 223 -271 153 -301 190 -288 b 229 -279 226 -271 229 -274 l 228 -281 b 228 -282 228 -282 228 -282 l 91 -690 b 91 -691 91 -690 91 -691 l 89 -693 b 134 -720 89 -706 102 -720 b 189 -687 176 -720 183 -703 l 356 -138 b 420 81 393 -16 420 81 b 459 226 420 81 456 207 b 461 232 459 229 461 230 b 446 248 461 240 449 246 b 431 242 439 248 435 245 b 300 145 420 233 348 147 z"
    },
    rest32nd: {
      x_min: 0,
      x_max: 363,
      y_min: -500,
      y_max: 426,
      ha: 926,
      o: "m 508 603 b 492 598 501 603 497 600 b 361 503 482 590 410 503 l 361 516 b 264 613 361 570 318 613 b 166 516 210 613 166 570 b 206 444 166 487 183 461 b 246 423 217 433 232 428 b 284 418 258 420 269 418 b 393 449 321 418 360 432 b 399 451 395 451 397 451 b 415 426 409 451 415 436 l 413 423 b 413 422 413 423 413 422 l 357 192 b 279 140 350 168 302 140 b 281 153 281 144 281 148 b 183 251 281 207 236 251 b 85 153 128 251 85 207 b 125 81 85 124 102 98 b 164 60 137 71 150 65 b 203 55 176 58 189 55 b 311 86 240 55 278 69 b 315 88 312 88 314 88 b 325 69 323 88 325 76 l 268 -167 b 194 -217 261 -197 216 -216 b 196 -203 196 -212 196 -207 b 98 -105 196 -148 153 -105 b 0 -203 45 -105 0 -148 b 115 -301 0 -262 60 -301 b 228 -269 154 -301 194 -288 b 232 -268 229 -268 230 -268 b 240 -276 236 -268 240 -272 b 138 -688 240 -282 141 -678 b 137 -697 137 -691 137 -694 b 176 -720 137 -708 145 -720 b 232 -690 222 -720 226 -706 b 484 436 236 -672 484 436 b 521 582 484 436 518 564 b 523 588 521 585 523 586 b 508 603 523 600 511 603 z"
    },
    rest64th: {
      x_min: 0,
      x_max: 423,
      y_min: -753,
      y_max: 430,
      ha: 1183,
      o: "m 596 609 b 580 603 589 609 585 606 b 448 507 569 595 497 507 b 449 521 449 511 449 516 b 351 619 449 575 405 619 b 253 521 297 619 253 575 b 372 422 253 461 317 422 b 481 454 410 422 446 438 b 491 456 484 455 488 456 b 504 441 498 456 504 451 b 501 426 504 436 503 432 b 445 202 500 422 451 217 b 359 144 435 174 383 144 l 359 158 b 261 256 359 212 315 256 b 163 158 207 256 163 212 b 243 65 163 112 202 78 b 279 60 255 62 266 60 b 397 91 320 60 360 73 b 403 92 400 92 402 92 b 412 79 409 92 412 86 b 410 72 412 76 412 75 b 351 -161 408 59 356 -150 b 281 -212 340 -199 301 -212 l 281 -197 b 183 -99 281 -144 238 -99 b 85 -197 130 -99 85 -144 b 125 -271 85 -228 102 -253 b 166 -291 138 -279 151 -287 b 204 -297 177 -294 192 -297 b 262 -287 225 -297 245 -292 b 305 -265 282 -279 287 -274 b 310 -264 307 -264 308 -264 b 318 -284 317 -264 318 -275 b 317 -295 318 -288 317 -294 b 259 -524 315 -302 265 -508 b 194 -567 251 -554 213 -567 b 196 -554 196 -563 196 -559 b 98 -456 196 -500 153 -456 b 0 -554 45 -456 0 -500 b 40 -626 0 -583 17 -609 b 118 -652 60 -644 92 -652 b 210 -629 145 -652 186 -642 b 216 -628 213 -628 215 -628 b 228 -647 226 -628 228 -639 l 226 -651 b 226 -652 226 -651 226 -652 l 122 -1054 b 121 -1064 121 -1058 121 -1061 b 167 -1084 121 -1077 134 -1084 b 215 -1060 202 -1084 209 -1076 b 402 -278 217 -1047 229 -1021 b 436 -135 403 -278 431 -161 l 570 441 b 609 588 570 441 605 569 b 596 609 609 603 602 608 z"
    },
    rest128th: {
      x_min: 0,
      x_max: 485,
      y_min: -750,
      y_max: 689,
      ha: 1439,
      o: "m 537 894 b 439 992 537 949 494 992 b 341 894 386 992 341 949 b 382 822 341 865 359 840 b 459 796 402 805 433 796 b 518 806 480 796 501 801 l 520 808 b 569 828 539 814 552 819 b 580 831 572 829 577 831 b 598 812 589 831 598 825 b 596 801 598 809 598 805 b 540 575 590 773 546 595 b 448 510 534 553 475 510 l 448 524 b 350 622 448 577 405 622 b 252 524 297 622 252 577 b 292 451 252 494 269 468 b 369 426 318 433 337 426 b 429 435 389 426 412 429 b 494 464 449 442 475 455 b 498 465 495 465 497 465 b 505 446 504 465 505 456 b 503 426 505 439 504 432 l 446 202 b 366 144 439 173 389 144 l 366 158 b 268 256 366 212 323 256 b 170 158 215 256 170 212 b 289 59 170 98 235 59 b 347 69 310 59 330 63 b 397 91 367 76 379 82 b 406 94 400 92 403 94 b 415 79 412 94 415 88 b 412 63 415 75 413 69 b 357 -157 408 42 364 -134 b 281 -212 346 -196 302 -212 b 282 -197 281 -207 282 -203 b 184 -99 282 -144 238 -99 b 86 -197 130 -99 86 -144 b 204 -297 86 -258 150 -297 b 262 -287 225 -297 245 -292 b 312 -265 282 -279 294 -274 b 318 -264 314 -264 317 -264 b 327 -275 324 -264 327 -269 b 266 -517 324 -287 278 -490 b 200 -569 248 -566 220 -567 l 196 -554 b 98 -456 196 -500 153 -456 b 0 -554 45 -456 0 -500 b 118 -652 0 -615 63 -652 b 177 -642 138 -652 160 -648 l 179 -641 b 229 -621 197 -635 210 -629 l 230 -619 b 239 -626 236 -619 239 -622 b 238 -632 239 -628 239 -631 b 131 -1057 235 -642 134 -1050 b 173 -1080 131 -1071 140 -1080 b 230 -1057 219 -1080 225 -1074 l 658 815 b 697 960 658 815 694 942 b 698 966 697 963 698 965 b 684 982 698 975 687 981 b 668 976 677 982 672 979 b 537 880 658 969 586 881 z"
    },
    dynamicPiano: {
      x_min: -89,
      x_max: 366,
      y_min: -142,
      y_max: 274,
      ha: 416,
      o: "m 395 395 b 292 357 350 395 318 380 b 262 328 272 340 268 328 b 246 363 255 328 259 338 b 177 393 236 380 215 393 b 1 251 92 393 46 333 b -9 223 -6 238 -9 230 b 7 207 -9 213 -1 207 b 30 229 17 207 23 216 b 127 338 72 301 101 338 b 143 321 138 338 143 331 b 134 285 143 310 138 295 l -43 -154 b -65 -168 -48 -166 -50 -168 l -109 -168 b -128 -187 -122 -168 -128 -174 b -111 -204 -128 -199 -122 -204 l 167 -204 b 186 -186 180 -204 186 -199 b 168 -168 186 -174 180 -168 l 111 -168 b 98 -164 102 -168 98 -168 b 101 -154 98 -163 99 -158 l 166 7 b 179 24 168 14 171 24 b 213 -1 186 24 190 10 b 276 -14 233 -12 252 -14 b 527 266 415 -14 527 130 b 395 395 527 350 475 395 z m 356 341 b 389 288 380 341 389 320 b 243 35 389 217 312 35 b 207 81 219 35 207 50 b 235 180 207 111 219 140 l 264 251 b 356 341 284 300 321 341 z"
    },
    dynamicMezzo: {
      x_min: -20,
      x_max: 446,
      y_min: -10,
      y_max: 274,
      ha: 284,
      o: "m 528 395 b 431 350 487 395 454 374 b 409 330 416 336 415 330 b 397 360 402 330 406 341 b 334 395 389 379 370 395 b 236 350 292 395 259 374 b 215 330 222 336 220 330 b 203 360 207 330 212 340 b 147 393 194 379 174 393 b -19 251 71 393 26 331 b -29 223 -26 238 -29 230 b -13 207 -29 213 -22 207 b 9 226 -3 207 1 215 b 107 338 52 300 81 338 b 122 321 118 338 122 331 b 114 285 122 310 118 295 l 9 24 b 4 9 6 17 4 13 b 20 0 4 3 9 0 l 91 0 b 114 17 104 0 108 3 l 207 251 b 287 323 225 292 255 323 b 308 302 304 323 308 314 b 294 249 308 285 302 269 b 203 24 294 248 292 248 b 199 9 200 17 199 13 b 215 0 199 3 203 0 l 285 0 b 308 17 298 0 302 3 l 402 251 b 481 323 419 292 449 323 b 503 302 498 323 503 314 b 413 43 503 252 413 104 b 478 -14 413 6 436 -14 b 629 102 533 -14 583 26 b 642 132 638 117 642 125 b 629 145 642 141 636 145 b 608 127 619 145 615 138 b 534 49 580 84 553 49 b 523 62 526 49 523 53 b 606 317 523 112 606 238 b 528 395 606 353 588 395 z"
    },
    dynamicForte: {
      x_min: -141,
      x_max: 364,
      y_min: -152,
      y_max: 444,
      ha: 596,
      o: "m 23 380 b 0 357 7 380 0 373 b 22 336 0 343 7 336 l 105 336 b 117 330 114 336 117 336 b 114 315 117 327 115 323 l 23 0 b -101 -187 -17 -141 -43 -187 b -127 -174 -120 -187 -127 -181 b -92 -156 -127 -163 -114 -170 b -63 -102 -75 -144 -63 -125 b -128 -43 -63 -65 -89 -43 b -203 -122 -171 -43 -203 -78 b -95 -219 -203 -186 -156 -219 b 161 17 14 -219 82 -145 b 269 317 203 105 235 194 l 271 318 b 289 336 271 323 282 336 l 383 336 b 406 359 399 336 406 343 b 384 380 406 373 399 380 l 298 380 b 284 387 288 380 284 380 b 287 405 284 392 285 396 b 419 606 315 530 347 606 b 442 595 431 606 442 603 b 419 580 442 586 435 588 b 389 526 400 572 389 552 b 454 465 389 485 418 465 b 524 543 491 465 524 490 b 400 639 524 596 491 639 b 135 402 261 639 183 540 b 107 380 128 380 127 380 z"
    },
    dynamicRinforzando: {
      x_min: -20,
      x_max: 277,
      y_min: 0,
      y_max: 274,
      ha: 274,
      o: "m 324 395 b 235 350 287 395 256 374 b 215 330 222 336 220 330 b 203 360 207 330 213 337 b 145 393 194 379 174 393 b -19 251 75 393 27 337 b -29 223 -26 238 -29 230 b -13 207 -29 213 -22 207 b 9 226 -3 207 3 215 b 107 338 52 301 81 338 b 122 321 118 338 122 331 b 114 285 122 310 118 295 l 9 24 b 4 9 6 17 4 13 b 20 0 4 3 9 0 l 91 0 b 114 17 104 0 108 3 l 207 251 b 304 351 226 298 272 351 b 318 343 312 351 318 348 b 287 285 318 330 287 325 b 338 239 287 256 308 239 b 399 318 373 239 399 268 b 324 395 399 360 377 395 z"
    },
    dynamicSforzando: {
      x_min: 0,
      x_max: 229,
      y_min: -10,
      y_max: 273,
      ha: 283,
      o: "m 212 393 b 68 274 127 393 68 350 b 145 161 68 223 95 196 b 200 85 187 132 200 114 b 127 20 200 53 173 20 b 66 42 91 20 66 32 b 91 56 66 49 75 46 b 111 98 104 65 111 79 b 59 145 111 127 86 145 b 0 78 24 145 0 117 b 125 -14 0 30 49 -14 b 291 120 219 -14 291 36 b 220 232 291 160 276 190 b 151 314 168 271 151 287 b 213 361 151 337 168 361 b 258 346 238 361 258 356 b 240 333 258 340 251 340 b 226 298 232 325 226 314 b 276 252 226 269 248 252 b 330 307 311 252 330 279 b 212 393 330 360 285 393 z"
    },
    dynamicZ: {
      x_min: -30,
      x_max: 244,
      y_min: -10,
      y_max: 268,
      ha: 278,
      o: "m 333 386 b 298 377 321 386 314 382 b 239 370 282 373 259 370 b 94 383 153 370 111 383 b 68 364 79 383 72 377 l 33 264 b 29 242 30 255 29 248 b 45 228 29 232 36 228 b 66 249 55 228 60 236 l 81 279 b 96 297 85 288 88 297 b 168 292 102 297 127 292 b 223 302 194 292 215 302 b 196 269 229 302 197 271 l -26 45 b -43 16 -37 33 -43 27 b -24 -1 -43 6 -36 -1 b 4 16 -12 -1 -3 10 b 39 30 16 24 27 30 b 179 -14 79 30 108 -14 b 297 102 259 -14 297 43 b 245 166 297 147 271 166 b 197 115 219 166 197 145 b 236 72 197 88 216 72 b 259 79 251 72 255 79 b 264 75 262 79 264 78 b 258 60 264 72 261 66 b 229 45 252 50 242 45 b 117 95 186 45 173 95 b 85 86 98 95 89 86 b 102 111 85 86 95 104 l 333 338 b 351 370 344 350 351 359 b 333 386 351 380 343 386 z"
    },
    ornamentTrill: {
      x_min: 0,
      x_max: 521,
      y_min: -10,
      y_max: 390,
      ha: 400,
      o: "m 383 562 b 364 557 377 562 369 559 l 294 534 b 269 511 281 530 275 526 l 217 384 b 206 367 212 370 210 367 b 179 380 200 367 192 374 b 118 393 158 389 140 393 b 0 292 50 393 0 353 b 95 210 0 248 30 210 b 140 213 112 210 131 213 b 144 209 143 213 144 212 b 140 194 144 206 143 202 l 124 156 b 96 58 108 117 96 88 b 179 -14 96 17 124 -14 b 325 153 253 -14 325 46 b 307 251 325 187 320 219 b 302 265 304 258 302 261 b 334 294 302 274 311 281 l 343 298 b 455 348 393 328 428 348 b 474 327 468 348 474 344 b 465 285 474 312 469 295 l 360 24 b 356 9 357 17 356 13 b 372 0 356 3 360 0 l 442 0 b 465 17 455 0 459 3 l 559 251 b 655 351 577 298 624 351 b 670 343 664 351 670 348 b 638 285 670 330 638 325 b 690 239 638 256 660 239 b 750 318 724 239 750 268 b 675 395 750 360 729 395 b 586 350 638 395 608 374 b 566 330 573 336 572 330 b 553 361 559 330 564 340 b 490 393 543 380 521 393 b 347 348 432 393 377 364 b 312 333 328 338 320 333 b 308 337 310 333 308 334 b 315 359 308 343 312 351 l 387 537 b 392 553 390 544 392 549 b 383 562 392 559 389 562 z m 118 360 b 192 325 134 360 192 347 b 186 307 192 321 189 314 l 180 292 b 148 265 173 274 167 269 b 98 258 130 261 112 258 b 39 301 50 258 39 281 b 118 360 39 327 60 360 z m 272 240 b 292 151 285 240 292 164 b 212 30 292 88 253 30 b 196 48 200 30 196 37 b 207 92 196 59 202 78 b 264 230 207 94 209 94 b 272 240 266 238 268 240 z"
    },
    ornamentTurn: {
      x_min: 0,
      x_max: 460,
      y_min: 0,
      y_max: 218,
      ha: 218,
      o: "m 534 314 b 454 251 490 314 454 294 b 505 199 454 219 475 199 b 579 232 547 199 549 232 b 626 164 603 232 626 202 b 533 72 626 102 583 72 b 377 180 487 72 439 111 b 150 312 307 258 243 312 b 0 148 55 312 0 240 b 128 0 0 45 66 0 b 209 63 173 0 209 20 b 157 115 209 95 187 115 b 84 82 115 115 114 82 b 36 150 59 82 36 112 b 130 242 36 212 79 242 b 285 134 176 242 223 203 b 513 1 356 56 419 1 b 662 166 608 1 662 73 b 534 314 662 269 596 314 z"
    },
    ornamentTurnSlash: {
      x_min: 0,
      x_max: 460,
      y_min: -90,
      y_max: 306,
      ha: 396,
      o: "m 333 441 b 310 418 315 441 310 433 l 310 274 b 302 252 310 258 308 252 b 261 278 294 252 287 262 b 150 311 228 298 192 311 b 0 147 55 311 0 239 b 128 -1 0 43 66 -1 b 209 62 173 -1 209 19 b 157 114 209 94 187 114 b 84 81 115 114 114 81 b 36 148 59 81 36 111 b 130 240 36 210 79 240 b 285 128 176 240 222 197 b 307 79 304 108 307 105 l 307 -107 b 330 -130 307 -122 312 -130 b 353 -107 347 -130 353 -122 l 353 37 b 360 59 353 53 353 59 b 402 33 369 59 376 49 b 513 0 435 13 471 0 b 662 164 608 0 662 72 b 534 312 662 268 596 312 b 454 249 490 312 454 292 b 505 197 454 217 475 197 b 579 230 547 197 549 230 b 626 163 603 230 626 200 b 533 71 626 101 583 71 b 377 183 487 71 441 114 b 356 232 359 203 356 206 l 356 418 b 333 441 356 433 350 441 z"
    },
    ornamentMordent: {
      x_min: 1,
      x_max: 729,
      y_min: -73,
      y_max: 319,
      ha: 392,
      o: "m 546 265 l 546 459 l 501 459 l 501 216 l 459 167 b 439 167 454 160 445 160 b 302 327 387 228 310 317 b 258 353 291 338 282 351 b 226 340 245 353 238 348 l 20 107 b 1 73 12 98 1 84 b 30 59 1 65 9 59 b 88 94 53 59 73 79 b 144 143 107 109 124 127 b 176 161 158 154 168 161 b 197 144 183 161 189 156 l 323 10 b 351 0 328 3 340 0 b 377 9 361 0 372 3 b 498 114 392 17 475 94 l 498 -105 l 544 -105 l 544 153 b 562 160 550 157 556 160 b 585 144 569 160 576 156 b 710 10 590 135 697 24 b 737 0 716 3 727 0 b 765 9 749 0 759 3 b 1030 295 776 17 1011 274 l 1032 300 b 1050 328 1041 308 1050 318 b 1012 353 1050 343 1024 353 b 986 343 1002 353 994 348 b 854 190 971 330 871 206 b 828 176 842 180 835 176 b 802 190 818 176 809 183 b 681 333 791 202 696 320 b 645 353 668 344 657 353 b 613 340 634 353 626 350 b 580 304 600 330 590 315 z"
    },
    ornamentShortTrill: {
      x_min: 0,
      x_max: 725,
      y_min: 0,
      y_max: 245,
      ha: 245,
      o: "m 429 167 l 301 325 b 256 353 291 338 282 350 b 225 340 246 353 238 350 b 16 105 158 268 88 186 b 0 72 9 96 0 86 b 29 58 0 63 7 58 b 71 76 42 58 55 62 l 158 154 b 174 160 163 158 168 160 b 197 143 181 160 187 154 b 321 10 203 135 310 24 b 350 0 327 3 338 0 b 377 7 361 0 372 3 l 533 148 b 554 160 543 158 550 160 b 577 143 562 160 566 156 b 703 10 585 135 690 24 b 732 0 708 3 720 0 b 759 7 743 0 753 3 b 1024 294 769 16 1005 272 b 1044 327 1032 305 1044 321 b 1005 353 1044 341 1018 353 b 979 343 996 353 988 348 b 848 189 963 330 864 204 b 821 174 837 179 828 174 b 796 189 811 174 804 181 b 674 331 783 202 688 318 b 641 351 662 343 651 351 b 606 340 628 351 619 350 b 573 304 593 328 583 315 b 444 167 533 259 491 213 b 429 167 439 161 433 161 z"
    },
    ornamentTremblement: {
      x_min: 1,
      x_max: 985,
      y_min: 0,
      y_max: 244,
      ha: 244,
      o: "m 678 325 b 634 351 667 338 657 350 b 602 338 621 351 613 348 l 448 167 b 439 167 446 164 441 164 l 302 325 b 258 351 291 338 281 350 b 228 338 245 351 238 348 b 193 304 215 328 204 315 l 19 107 b 1 72 13 96 1 76 b 30 58 1 63 9 58 b 89 92 52 58 73 78 l 144 141 b 148 144 145 143 147 143 b 176 160 160 153 170 160 b 199 143 183 160 189 154 b 324 10 204 134 311 23 b 351 0 330 3 340 0 b 379 7 363 0 373 3 l 530 148 b 552 160 536 154 546 160 b 575 143 559 160 564 154 b 698 10 580 134 687 23 b 727 0 704 3 716 0 b 755 7 739 0 749 3 l 907 147 b 930 160 922 158 923 160 b 952 143 937 160 943 154 l 1077 10 b 1107 0 1084 3 1096 0 b 1133 7 1117 0 1128 3 b 1398 294 1143 16 1380 272 b 1418 327 1407 305 1418 321 b 1381 351 1418 343 1394 351 b 1354 341 1371 351 1362 348 b 1223 189 1338 328 1238 204 b 1195 174 1211 179 1202 174 b 1171 189 1185 174 1178 181 b 1048 331 1158 200 1063 318 b 1012 351 1035 343 1024 351 b 981 338 1002 351 994 350 b 948 304 968 328 958 315 b 827 166 907 258 865 212 b 815 166 824 163 818 163 b 678 325 760 226 732 264 z"
    },
    ornamentPrecompAppoggTrill: {
      x_min: 0,
      x_max: 1119,
      y_min: 0,
      y_max: 481,
      ha: 481,
      o: "m 1015 163 b 873 328 963 223 880 318 b 828 354 860 344 847 353 b 796 341 816 354 809 351 b 763 305 783 331 773 317 b 642 168 721 261 681 215 b 636 163 641 167 639 164 b 494 328 585 223 501 318 b 449 354 481 344 468 353 b 418 341 438 354 431 351 b 384 305 405 331 395 317 b 264 168 343 261 302 215 l 242 144 b 144 88 232 124 171 88 b 79 197 81 88 79 189 l 79 648 b 60 693 79 683 71 693 b 52 691 58 693 55 693 b 0 616 3 672 0 625 l 0 207 b 121 0 0 40 68 0 b 249 68 168 0 232 53 b 279 94 262 75 271 86 b 336 144 298 111 315 128 b 367 163 350 156 360 163 b 389 145 374 163 380 157 b 514 12 395 137 501 26 b 543 1 520 4 531 1 b 569 9 553 1 563 4 b 636 73 576 14 605 43 l 658 94 b 714 144 677 111 694 128 b 746 163 729 156 739 163 b 768 145 753 163 759 157 b 893 12 773 137 880 26 b 922 1 899 4 910 1 b 948 9 932 1 942 4 l 1012 71 b 1037 94 1022 78 1030 86 b 1092 144 1054 111 1073 128 b 1123 161 1106 156 1115 161 b 1146 145 1130 161 1136 157 b 1270 12 1152 137 1259 26 b 1299 1 1276 4 1287 1 b 1326 9 1310 1 1320 4 b 1591 297 1336 19 1572 275 b 1611 328 1600 307 1611 320 b 1574 354 1611 343 1585 354 b 1548 344 1565 354 1555 350 b 1416 192 1532 331 1431 206 b 1388 177 1404 181 1395 177 b 1365 190 1380 177 1371 184 b 1243 333 1352 203 1256 321 b 1205 354 1228 346 1217 354 b 1174 341 1195 354 1187 351 b 1140 305 1161 330 1152 317 z"
    },
    ornamentPrecompSlideTrillDAnglebert: {
      x_min: 2,
      x_max: 1150,
      y_min: -367,
      y_max: 245,
      ha: 612,
      o: "m 1058 160 b 916 327 1007 220 923 317 b 871 353 903 343 890 351 b 840 340 860 353 852 350 b 806 304 827 330 816 315 b 685 167 765 259 724 213 l 680 160 l 615 235 b 419 344 582 275 523 344 b 3 -144 258 344 3 26 b 4 -168 3 -153 3 -160 b 246 -482 24 -315 99 -422 b 458 -528 340 -521 410 -528 b 514 -526 485 -528 504 -526 b 552 -508 531 -526 552 -517 b 514 -497 552 -503 541 -498 l 503 -497 b 194 -390 432 -494 298 -488 b 69 -151 194 -390 69 -279 b 184 96 69 -60 128 27 b 328 183 202 118 258 183 b 477 96 413 183 454 118 b 559 10 510 62 552 19 b 588 0 566 3 576 0 b 613 7 598 0 609 3 b 723 112 622 14 681 73 b 789 161 733 122 776 161 b 811 144 796 161 802 156 b 936 10 816 135 923 24 b 965 0 942 3 953 0 b 991 7 975 0 985 3 b 1051 66 996 12 1022 37 b 1081 92 1063 73 1073 84 b 1136 143 1099 109 1117 127 b 1168 160 1151 154 1159 160 b 1191 144 1175 160 1181 156 b 1315 10 1197 135 1303 24 b 1344 0 1320 3 1332 0 b 1371 7 1355 0 1365 3 b 1636 295 1381 17 1617 274 b 1656 327 1644 305 1656 318 b 1619 353 1656 341 1630 353 b 1593 343 1610 353 1600 348 b 1460 190 1577 330 1476 204 b 1433 176 1449 180 1440 176 b 1410 189 1424 176 1416 183 b 1287 331 1397 202 1300 320 b 1250 353 1273 344 1261 353 b 1218 340 1240 353 1231 350 b 1185 304 1205 328 1197 315 z"
    },
    ornamentPrecompSlideTrillBach: {
      x_min: 0,
      x_max: 1048,
      y_min: -367,
      y_max: 331,
      ha: 698,
      o: "m 1038 477 l 979 477 l 979 238 l 912 160 b 769 327 858 220 775 317 b 724 353 756 343 743 351 b 693 340 713 353 706 350 b 660 304 680 330 670 315 b 539 167 618 259 577 213 b 533 161 536 166 534 163 b 390 327 480 220 396 317 b 346 353 377 343 364 351 l 340 353 b 308 340 330 353 321 350 b 275 304 295 330 285 315 b 117 122 220 243 168 186 b 0 -144 68 62 0 -48 b 1 -168 0 -153 0 -160 b 243 -482 22 -315 96 -422 b 455 -528 337 -521 408 -528 b 511 -526 482 -528 501 -526 b 549 -508 528 -526 549 -517 b 511 -497 549 -503 539 -498 l 500 -497 b 192 -390 429 -494 295 -488 b 68 -177 192 -390 84 -298 b 66 -151 66 -168 66 -160 b 189 105 66 -58 127 35 b 232 143 203 118 216 131 b 264 161 246 154 256 161 b 285 144 271 161 276 156 b 410 10 291 135 397 24 b 439 0 416 3 428 0 b 465 7 449 0 459 3 l 531 72 b 554 92 540 78 547 86 b 611 143 573 109 590 127 b 642 161 625 154 635 161 b 664 144 649 161 655 156 b 789 10 670 135 776 24 b 818 0 795 3 806 0 b 844 7 828 0 838 3 b 904 66 850 12 876 37 b 935 92 916 73 924 84 b 979 134 949 107 963 121 l 979 -88 l 1037 -88 l 1037 151 l 1044 144 b 1168 10 1050 135 1156 24 b 1197 0 1174 3 1185 0 b 1224 7 1208 0 1218 3 b 1489 295 1234 17 1470 274 b 1509 327 1498 305 1509 318 b 1472 353 1509 341 1483 353 b 1446 343 1463 353 1453 348 b 1313 190 1430 330 1329 204 b 1286 176 1302 180 1293 176 b 1263 189 1277 176 1269 183 b 1140 331 1250 202 1153 320 b 1103 353 1126 344 1115 353 b 1071 340 1093 353 1084 350 b 1038 304 1058 328 1050 315 z"
    },
    ornamentPrecompTrillSuffixDandrieu: {
      x_min: 0,
      x_max: 949,
      y_min: 0,
      y_max: 381,
      ha: 381,
      o: "m 1367 314 b 1250 521 1367 419 1318 482 b 1107 549 1211 537 1145 549 b 1083 546 1096 549 1087 549 b 1066 528 1071 540 1066 534 b 1079 520 1066 524 1070 520 b 1323 351 1187 517 1323 487 b 1201 171 1323 269 1260 219 b 1194 166 1201 171 1198 168 b 1056 327 1142 226 1063 317 b 1011 353 1043 343 1030 351 b 979 340 999 353 992 350 b 946 304 966 330 956 315 b 825 167 904 259 864 213 l 821 161 b 678 327 768 222 685 317 b 634 353 665 343 652 351 b 602 340 622 353 615 350 b 569 304 589 330 579 315 b 448 167 527 259 487 213 l 444 161 b 301 327 390 222 308 317 b 256 353 288 343 275 351 b 225 340 245 353 238 350 b 192 304 212 330 202 315 b 71 167 150 259 109 213 b 17 105 52 147 36 127 b 0 73 10 98 0 84 b 29 58 0 65 7 58 b 86 92 56 59 72 79 b 143 143 105 109 122 127 b 174 161 157 154 167 161 b 196 144 181 161 187 156 b 321 10 202 135 308 24 b 350 0 327 3 338 0 b 376 7 360 0 370 3 b 485 112 384 14 444 73 b 552 161 495 122 539 161 b 573 144 559 161 564 156 b 698 10 579 135 685 24 b 727 0 704 3 716 0 b 753 7 737 0 747 3 b 863 112 762 14 821 73 b 929 161 873 122 916 161 b 950 144 936 161 942 156 b 1076 10 956 135 1063 24 b 1104 0 1081 3 1093 0 b 1130 7 1115 0 1125 3 b 1236 108 1139 14 1195 69 b 1367 314 1297 160 1367 233 z"
    },
    ornamentPrecompDoubleCadenceUpperPrefix: {
      x_min: 0,
      x_max: 1278,
      y_min: 0,
      y_max: 247,
      ha: 247,
      o: "m 1801 356 b 1776 346 1793 356 1783 351 b 1642 192 1760 333 1659 206 b 1614 177 1630 181 1621 177 b 1591 190 1606 177 1597 184 b 1469 334 1578 203 1482 323 b 1430 356 1453 347 1441 356 b 1398 343 1420 356 1411 353 b 1365 307 1385 331 1377 318 l 1240 164 b 1097 330 1187 226 1104 320 b 1053 356 1084 346 1071 354 b 1021 343 1041 356 1034 353 b 988 307 1008 333 998 318 b 865 168 946 262 904 216 l 861 163 b 717 330 808 223 724 320 b 672 356 704 346 691 354 b 641 343 661 356 654 353 b 608 307 628 333 618 318 b 485 168 566 262 524 216 l 455 134 b 284 46 409 88 351 46 b 16 285 148 46 32 265 b 3 295 9 292 4 295 b 0 291 1 295 0 292 b 1 285 0 288 1 285 b 308 0 42 190 157 0 b 530 120 415 1 482 63 b 559 144 539 128 549 137 b 590 163 573 156 583 163 b 612 145 598 163 603 157 b 739 10 618 137 724 24 b 768 0 744 3 756 0 b 793 7 778 0 788 3 b 903 114 802 14 861 75 l 939 144 b 971 163 953 156 963 163 b 992 145 978 163 984 157 b 1119 10 998 137 1106 24 b 1148 0 1125 3 1136 0 b 1174 7 1158 0 1168 3 b 1284 114 1182 14 1241 75 b 1316 144 1282 115 1312 141 b 1348 161 1331 156 1339 161 b 1371 145 1355 161 1361 157 b 1496 10 1377 137 1485 24 b 1525 0 1502 3 1513 0 b 1552 7 1536 0 1547 3 b 1819 298 1562 17 1800 276 b 1840 330 1829 308 1840 320 b 1832 344 1840 334 1837 340 b 1801 356 1820 351 1810 356 z"
    },
    ornamentPrecompDoubleCadenceUpperPrefixTurn: {
      x_min: 0,
      x_max: 1277,
      y_min: -62,
      y_max: 333,
      ha: 395,
      o: "m 1273 202 l 1273 480 l 1230 480 l 1230 174 l 1097 328 b 1053 354 1084 344 1071 353 b 1021 341 1041 354 1034 351 b 988 305 1008 331 998 317 b 865 167 945 261 904 215 l 861 161 b 717 328 808 222 724 318 b 672 354 704 344 691 353 b 641 341 661 354 654 351 b 608 305 628 331 618 317 b 485 167 564 261 524 215 b 455 132 474 156 465 144 b 284 45 410 88 350 45 b 14 284 148 45 30 264 b 3 294 9 291 4 294 b 0 289 1 294 0 291 b 1 284 0 287 1 284 b 308 -1 42 189 157 -1 b 530 118 415 0 481 62 b 557 143 539 127 547 135 b 590 161 572 154 582 161 b 612 144 598 161 603 156 b 737 9 618 135 724 24 b 768 -1 743 1 755 -1 b 793 6 778 -1 788 1 b 903 112 802 13 861 73 l 937 143 b 971 161 953 154 963 161 b 992 144 978 161 984 156 b 1117 9 998 135 1104 24 b 1148 -1 1123 1 1136 -1 b 1174 6 1158 -1 1168 1 l 1230 60 l 1230 -89 l 1273 -89 l 1273 102 l 1283 112 b 1348 160 1295 125 1332 160 b 1371 144 1355 160 1361 156 b 1496 9 1377 135 1483 24 b 1525 -1 1502 1 1513 -1 b 1552 6 1536 -1 1547 1 b 1819 297 1562 16 1800 275 b 1839 328 1827 307 1839 320 b 1801 354 1839 343 1813 354 b 1776 344 1793 354 1783 350 b 1642 190 1760 331 1657 206 b 1614 176 1630 180 1621 176 b 1591 189 1606 176 1597 183 b 1467 333 1578 203 1480 321 b 1430 354 1453 346 1441 354 b 1398 341 1420 354 1411 351 b 1365 305 1385 330 1377 317 z"
    },
    ornamentPrecompTrillLowerSuffix: {
      x_min: 0,
      x_max: 859,
      y_min: -222,
      y_max: 246,
      ha: 468,
      o: "m 1164 217 b 1031 351 1138 259 1063 351 b 1011 337 1020 351 1024 347 b 828 167 952 291 886 217 l 824 164 b 683 328 772 225 690 318 b 638 354 670 344 657 353 b 606 341 626 354 619 351 b 573 305 593 331 583 317 b 451 167 530 261 490 215 l 446 161 b 302 328 393 222 310 318 b 258 354 289 344 276 353 b 226 341 246 354 239 351 b 193 305 213 331 203 317 b 71 167 150 261 109 215 b 17 105 52 147 36 127 b 0 73 10 98 0 84 b 29 58 0 65 7 58 b 86 92 56 59 72 79 b 143 143 105 109 122 127 b 176 161 157 154 168 161 b 197 144 183 161 189 156 b 323 9 203 135 310 23 b 353 -1 328 1 340 -1 b 379 6 363 -1 373 1 b 488 112 387 13 446 73 l 523 143 b 556 161 539 154 549 161 b 577 144 563 161 569 156 b 703 9 583 135 690 23 b 733 -1 708 1 721 -1 b 759 6 743 -1 753 1 b 868 112 768 13 827 73 b 955 183 878 122 943 183 b 1081 107 965 183 1031 153 b 1156 -89 1128 63 1156 6 l 1156 -102 b 948 -297 1156 -204 1048 -297 b 806 -271 904 -297 850 -282 l 792 -266 b 801 -288 792 -268 795 -282 b 948 -320 809 -297 880 -320 b 1237 -50 1092 -320 1237 -199 b 1164 217 1237 75 1218 122 z"
    },
    brassScoop: {
      x_min: 1,
      x_max: 320,
      y_min: -373,
      y_max: 13,
      ha: 386,
      o: "m 35 -537 b 461 -12 194 -518 461 -289 b 438 19 461 13 451 19 b 410 -9 425 19 413 9 b 35 -425 357 -366 92 -403 b 1 -482 13 -433 1 -438 l 1 -505 b 26 -537 1 -526 3 -537 z"
    },
    brassDoitMedium: {
      x_min: 0,
      x_max: 489,
      y_min: -40,
      y_max: 346,
      ha: 386,
      o: "m 33 -58 b 704 468 255 -58 683 186 b 681 498 704 494 693 498 b 654 471 668 498 658 488 b 33 55 550 118 91 76 b 0 -3 12 46 0 42 l 0 -26 b 24 -58 0 -46 1 -58 z"
    },
    brassFallLipShort: {
      x_min: 1,
      x_max: 293,
      y_min: -345,
      y_max: 42,
      ha: 387,
      o: "m 22 60 b 1 35 4 60 1 52 l 1 6 b 26 -50 3 -40 10 -43 b 32 -52 27 -50 30 -50 b 376 -469 85 -73 327 -111 b 400 -497 379 -487 387 -497 b 422 -467 412 -497 422 -491 b 32 60 422 -187 177 40 z"
    },
    brassLiftMedium: {
      x_min: 0,
      x_max: 811,
      y_min: 0,
      y_max: 852,
      ha: 852,
      o: "m 1138 1220 b 1135 1225 1135 1223 1135 1224 b 1129 1227 1133 1227 1130 1227 b 1117 1207 1122 1227 1117 1212 l 1117 1201 b 1109 1164 1117 1187 1117 1172 b 1100 1156 1107 1161 1104 1158 b 959 1104 1058 1128 995 1140 b 929 1032 936 1081 929 1056 b 932 1007 929 1024 930 1015 b 923 976 932 995 930 985 l 914 971 b 773 919 873 942 809 955 b 743 847 750 896 743 870 b 746 821 743 838 744 829 b 737 791 746 809 744 799 l 729 783 b 588 733 687 756 624 769 b 557 661 564 710 557 684 b 560 635 557 652 559 644 b 552 605 560 624 559 612 l 543 598 b 402 547 501 570 438 583 b 372 475 379 524 372 498 b 374 449 372 467 373 458 b 366 419 374 438 373 426 l 357 412 b 216 361 315 384 252 397 b 186 289 193 338 186 312 b 189 264 186 281 187 272 b 180 233 189 252 187 240 b 171 226 177 232 174 229 b 30 176 130 199 66 212 b 0 104 7 153 0 128 b 33 0 0 88 14 0 b 49 17 40 0 49 10 b 71 63 52 35 56 49 b 212 115 102 95 154 59 b 239 186 230 134 239 160 b 236 210 239 194 238 202 b 256 249 239 225 243 236 b 397 301 288 281 340 245 b 425 372 416 320 425 346 b 422 396 425 380 423 387 b 442 435 425 410 429 422 b 583 487 474 467 526 431 b 611 557 602 505 611 531 b 608 582 611 566 609 573 b 628 621 611 596 615 608 b 769 672 660 652 711 618 b 796 743 788 691 796 717 b 793 768 796 752 795 759 b 814 806 796 782 801 793 b 955 858 845 838 897 804 b 982 929 973 877 982 903 b 979 953 982 937 981 945 b 999 992 982 968 986 979 b 1140 1045 1031 1024 1083 989 b 1168 1116 1161 1066 1168 1090 b 1138 1220 1168 1162 1145 1207 z"
    },
    brassFallRoughMedium: {
      x_min: 0,
      x_max: 811,
      y_min: 0,
      y_max: 852,
      ha: 852,
      o: "m 30 1220 b 0 1116 23 1207 0 1162 b 27 1045 0 1090 7 1066 b 168 992 85 989 137 1024 b 189 953 181 979 186 968 b 186 929 187 945 186 937 b 213 858 186 903 194 877 b 354 806 271 804 323 838 b 374 768 367 793 372 782 b 372 743 373 759 372 752 b 399 672 372 717 380 691 b 540 621 456 618 508 652 b 560 582 553 608 557 596 b 557 557 559 573 557 566 b 585 487 557 531 566 505 b 726 435 642 431 694 467 b 746 396 739 422 743 410 b 743 372 744 387 743 380 b 770 301 743 346 752 320 b 912 249 828 245 880 281 b 932 210 924 236 929 225 b 929 186 930 202 929 194 b 956 115 929 160 937 134 b 1097 63 1014 59 1066 95 b 1119 17 1112 49 1116 35 b 1135 0 1119 10 1128 0 b 1168 104 1153 0 1168 91 b 1138 176 1168 128 1161 153 b 996 226 1102 212 1038 199 b 988 233 994 229 991 232 b 979 264 981 240 979 252 b 982 289 981 272 982 281 b 952 361 982 312 975 338 b 811 412 916 397 852 384 l 802 419 b 793 449 795 426 793 438 b 796 475 795 458 796 467 b 766 547 796 498 789 524 b 625 598 730 583 667 570 l 616 605 b 608 635 609 612 608 624 b 611 661 609 644 611 652 b 580 733 611 684 603 710 b 439 783 544 769 481 756 l 431 791 b 422 821 423 799 422 809 b 425 847 423 829 425 838 b 395 919 425 870 418 896 b 253 971 359 955 295 942 l 245 976 b 236 1007 238 985 236 995 b 239 1032 238 1015 239 1024 b 209 1104 239 1056 232 1081 b 68 1156 173 1140 109 1128 b 59 1164 63 1158 60 1161 b 50 1201 50 1172 50 1187 l 50 1207 b 39 1227 50 1212 46 1227 b 33 1225 37 1227 35 1227 b 30 1220 33 1224 33 1223 z"
    },
    brassBend: {
      x_min: 0,
      x_max: 392,
      y_min: 0,
      y_max: 282,
      ha: 282,
      o: "m 282 0 b 552 72 369 0 456 23 b 564 92 560 75 564 84 l 564 383 b 541 406 564 395 554 406 b 518 383 528 406 518 395 l 518 107 b 282 46 435 65 357 46 b 46 107 207 46 130 65 l 46 383 b 23 406 46 395 36 406 b 0 383 10 406 0 395 l 0 92 b 13 72 0 84 4 75 b 282 0 108 23 196 0 z"
    },
    brassMuteClosed: {
      x_min: 0,
      x_max: 272,
      y_min: 0,
      y_max: 272,
      ha: 272,
      o: "m 392 219 l 219 219 l 219 392 l 173 392 l 173 219 l 0 219 l 0 173 l 173 173 l 173 0 l 219 0 l 219 173 l 392 173 z"
    },
    brassMuteOpen: {
      x_min: 0,
      x_max: 304,
      y_min: 0,
      y_max: 304,
      ha: 304,
      o: "m 219 0 b 438 219 340 0 438 98 b 219 438 438 340 340 438 b 0 219 98 438 0 340 b 219 0 0 98 98 0 z m 219 392 b 392 219 314 392 392 314 b 219 46 392 124 314 46 b 46 219 124 46 46 124 b 219 392 46 314 124 392 z"
    },
    brassFlip: {
      x_min: 0,
      x_max: 379,
      y_min: 0,
      y_max: 282,
      ha: 282,
      o: "m 523 0 b 541 9 530 0 536 3 b 546 22 544 13 546 17 b 536 42 546 29 541 36 l 36 402 b 23 406 33 405 27 406 b 0 383 12 406 0 395 l 0 23 b 23 0 0 10 10 0 b 46 23 36 0 46 10 l 46 337 l 508 4 b 523 0 513 1 517 0 z"
    },
    brassJazzTurn: {
      x_min: 0,
      x_max: 620,
      y_min: 0,
      y_max: 245,
      ha: 245,
      o: "m 792 190 b 765 176 780 179 772 176 b 740 190 755 176 747 183 b 629 325 727 202 644 312 b 593 347 616 338 605 347 b 562 334 583 346 575 344 b 528 298 549 323 539 310 l 406 176 b 389 168 406 176 399 168 b 374 176 384 168 379 170 b 245 325 360 192 245 325 b 200 353 232 343 219 351 b 168 340 190 353 181 350 l 17 156 b 0 121 10 147 0 132 b 16 107 0 114 4 108 b 84 143 26 107 76 137 b 118 160 92 150 108 160 b 141 143 125 160 131 154 b 265 10 147 135 253 24 b 294 0 271 3 282 0 b 321 7 305 0 315 3 b 498 160 321 7 478 158 b 521 143 505 160 513 154 b 647 10 528 135 635 24 b 675 0 652 3 664 0 b 703 7 687 0 697 3 b 874 186 713 16 855 164 b 893 220 881 196 893 212 b 873 245 890 235 883 243 b 796 194 847 245 815 213 z"
    },
    brassSmear: {
      x_min: 1,
      x_max: 306,
      y_min: 0,
      y_max: 170,
      ha: 170,
      o: "m 193 79 b 308 0 219 50 264 0 b 439 117 396 0 438 102 b 439 120 439 118 439 118 l 441 125 b 441 128 441 127 441 127 b 433 141 441 135 439 141 b 416 130 429 141 423 137 b 343 94 390 107 370 94 b 269 153 315 94 294 121 l 265 158 b 144 245 239 190 180 245 b 6 134 62 245 10 143 b 1 114 3 125 1 118 b 7 107 1 108 4 107 b 36 122 13 107 22 112 b 92 151 55 137 65 151 b 183 89 125 151 161 112 b 189 84 184 88 187 86 z"
    },
    stringsDownBow: {
      x_min: 0,
      x_max: 312,
      y_min: 0,
      y_max: 318,
      ha: 318,
      o: "m 37 458 b 0 420 17 458 0 441 l 0 17 b 17 0 0 7 9 0 l 37 0 b 55 17 46 0 55 7 l 55 253 b 225 278 55 269 140 278 b 395 253 310 278 395 269 l 395 17 b 413 0 395 7 403 0 l 432 0 b 449 17 441 0 449 7 l 449 420 b 412 458 449 441 432 458 z"
    },
    stringsUpBow: {
      x_min: 1,
      x_max: 249,
      y_min: 1,
      y_max: 495,
      ha: 494,
      o: "m 181 1 b 206 22 193 1 203 10 l 359 683 l 359 688 b 338 713 359 700 351 710 l 333 713 b 308 694 321 713 311 706 l 180 140 l 53 694 b 27 713 49 706 39 713 l 22 713 b 1 690 10 710 1 700 b 3 683 1 687 1 685 l 154 22 b 181 1 157 10 167 1 z"
    },
    stringsHarmonic: {
      x_min: 0,
      x_max: 200,
      y_min: 0,
      y_max: 200,
      ha: 200,
      o: "m 288 144 b 144 288 288 225 223 288 b 0 144 65 288 0 225 b 144 0 0 65 65 0 b 288 144 223 0 288 65 z m 144 249 b 249 144 203 249 249 203 b 144 39 249 86 203 39 b 39 144 86 39 39 86 b 144 249 39 203 86 249 z"
    },
    pluckedSnapPizzicatoAbove: {
      x_min: 0,
      x_max: 200,
      y_min: 0,
      y_max: 300,
      ha: 300,
      o: "m 0 144 b 144 0 0 63 65 0 b 288 144 223 0 288 63 b 167 285 288 215 235 275 l 167 432 l 121 432 l 121 285 b 0 144 52 275 0 215 z m 121 246 l 121 144 l 167 144 l 167 246 b 249 144 213 236 249 193 b 144 39 249 85 202 39 b 39 144 85 39 39 85 b 121 246 39 193 73 236 z"
    },
    pluckedSnapPizzicatoBelow: {
      x_min: 0,
      x_max: 200,
      y_min: 0,
      y_max: 300,
      ha: 300,
      o: "m 288 288 b 144 432 288 369 223 432 b 0 288 65 432 0 369 b 121 145 0 216 52 157 l 121 0 l 167 0 l 167 145 b 288 288 235 157 288 216 z m 167 186 l 167 288 l 121 288 l 121 186 b 39 288 75 196 39 238 b 144 393 39 347 86 393 b 249 288 203 393 249 347 b 167 186 249 238 215 196 z"
    },
    pluckedLeftHandPizzicato: {
      x_min: 0,
      x_max: 272,
      y_min: 0,
      y_max: 272,
      ha: 272,
      o: "m 392 219 l 219 219 l 219 392 l 173 392 l 173 219 l 0 219 l 0 173 l 173 173 l 173 0 l 219 0 l 219 173 l 392 173 z"
    },
    keyboardPedalPed: {
      x_min: 0,
      x_max: 1019,
      y_min: -8,
      y_max: 555,
      ha: 563,
      o: "m 413 799 b 179 749 327 798 261 789 b 0 517 107 713 0 632 b 122 376 0 454 37 376 b 240 540 189 376 240 452 b 225 586 240 579 233 586 b 204 549 213 586 212 573 b 138 480 199 527 181 480 b 85 549 96 480 85 517 l 85 554 b 353 762 89 690 230 762 b 373 752 364 762 373 760 b 351 708 373 740 360 723 b 274 546 330 675 274 585 b 353 416 274 508 333 444 b 412 304 372 390 412 351 b 382 228 412 275 403 256 b 334 190 363 202 361 200 b 147 29 271 167 147 88 b 196 -12 147 4 171 -12 b 343 108 239 -12 279 33 l 363 132 b 387 150 370 141 376 150 b 543 -4 445 150 467 -4 b 631 42 567 -4 586 0 l 668 78 b 685 89 674 84 680 89 b 696 75 688 89 690 86 b 809 -9 717 29 753 -9 b 946 66 854 -9 894 13 b 988 107 971 92 981 107 b 1002 89 994 107 996 99 b 1152 -4 1030 36 1077 -4 b 1329 248 1238 -4 1329 82 b 792 717 1329 556 1047 665 b 766 720 785 719 775 720 b 747 703 752 720 747 711 b 780 680 747 693 756 685 b 1223 222 1028 621 1223 504 b 1152 39 1223 122 1205 39 b 1073 229 1104 39 1073 132 b 1132 423 1073 314 1086 377 b 1142 442 1140 432 1142 436 b 1126 458 1142 451 1136 458 b 1093 446 1119 458 1109 455 b 975 216 1022 408 975 337 l 975 190 b 943 121 975 160 972 150 b 852 69 899 76 877 69 b 776 148 816 69 786 117 b 773 163 775 154 773 158 b 786 177 773 167 776 170 l 801 187 b 937 366 867 235 937 284 b 844 454 937 422 900 454 b 665 217 711 454 665 331 b 671 153 665 197 667 176 l 671 147 b 662 134 671 143 670 140 b 605 111 639 118 625 111 b 521 160 572 111 546 135 b 451 203 497 184 474 197 b 426 212 435 207 426 206 b 436 230 426 216 429 220 b 510 389 464 269 510 340 b 429 521 510 435 480 462 b 369 629 387 570 369 599 b 402 720 369 648 384 691 b 462 763 425 759 446 763 b 611 624 540 763 611 704 b 564 575 611 592 590 575 b 501 602 540 575 520 582 b 474 622 492 611 487 622 b 459 603 465 622 459 615 b 603 471 459 570 510 471 b 711 588 670 471 711 524 b 422 799 711 742 554 799 z m 815 403 b 848 343 838 403 848 383 b 780 226 848 295 824 261 b 765 217 773 220 768 217 b 759 228 762 217 759 220 b 756 282 757 245 756 262 b 815 403 756 346 772 403 z m 1405 124 b 1344 62 1369 124 1344 98 b 1405 0 1344 26 1369 0 b 1467 62 1441 0 1467 26 b 1405 124 1467 98 1441 124 z"
    },
    keyboardPedalUp: {
      x_min: 0,
      x_max: 450,
      y_min: 0,
      y_max: 450,
      ha: 450,
      o: "m 582 396 b 516 367 554 396 533 384 b 465 340 495 347 487 340 l 458 340 b 412 377 432 340 412 348 b 432 409 412 387 419 396 l 438 415 b 490 429 451 428 464 429 b 575 501 534 429 575 452 b 501 575 575 541 541 575 b 429 490 452 575 429 534 b 415 438 429 464 428 451 l 409 432 b 377 412 396 419 387 412 b 340 458 348 412 340 432 l 340 465 b 367 516 340 487 347 495 b 396 582 384 533 396 554 b 324 648 396 625 363 648 b 252 582 285 648 252 625 b 281 516 252 554 264 533 b 308 465 301 495 308 487 l 308 458 b 271 412 308 432 300 412 b 239 432 261 412 252 419 l 233 438 b 219 490 220 451 219 464 b 147 575 219 534 196 575 b 73 501 107 575 73 541 b 158 429 73 452 114 429 b 210 415 184 429 197 428 l 216 409 b 236 377 229 396 236 387 b 190 340 236 348 216 340 l 183 340 b 132 367 161 340 153 347 b 66 396 115 384 94 396 b 0 324 23 396 0 363 b 66 252 0 285 23 252 b 132 281 94 252 115 264 b 183 308 153 301 161 308 l 190 308 b 236 271 216 308 236 300 b 216 239 236 261 229 252 l 210 233 b 158 219 197 220 184 219 b 73 147 114 219 73 196 b 147 73 73 107 107 73 b 219 158 196 73 219 114 b 233 210 219 184 220 197 l 239 216 b 271 236 252 229 261 236 b 308 190 300 236 308 216 l 308 183 b 281 132 308 161 301 153 b 252 66 264 115 252 94 b 324 0 252 23 285 0 b 396 66 363 0 396 23 b 367 132 396 94 384 115 b 340 183 347 153 340 161 l 340 190 b 377 236 340 216 348 236 b 409 216 387 236 396 229 l 415 210 b 429 158 428 197 429 184 b 501 73 429 114 452 73 b 575 147 541 73 575 107 b 490 219 575 196 534 219 b 438 233 464 219 451 220 l 432 239 b 412 271 419 252 412 261 b 458 308 412 300 432 308 l 465 308 b 516 281 487 308 495 301 b 582 252 533 264 554 252 b 648 324 625 252 648 285 b 582 396 648 363 625 396 z m 324 271 b 271 324 291 271 271 291 b 324 377 271 357 291 377 b 377 324 357 377 377 357 b 324 271 377 291 357 271 z"
    },
    pictChokeCymbal: {
      x_min: 1,
      x_max: 152,
      y_min: 2,
      y_max: 251,
      ha: 249,
      o: "m 104 361 b 1 271 42 361 1 321 b 82 190 1 222 35 190 b 122 160 118 190 122 160 b 125 144 124 154 125 150 b 102 88 125 124 115 105 b 37 32 78 56 40 35 b 26 17 32 29 26 26 l 27 16 b 37 3 29 6 33 3 b 181 102 85 3 158 66 b 219 239 210 147 219 197 l 219 249 b 104 361 219 317 170 361 z"
    },
    wiggleArpeggiatoUp: {
      x_min: -33,
      x_max: 292,
      y_min: 0,
      y_max: 119,
      ha: 119,
      o: "m 130 171 b -39 68 16 171 -14 91 b -48 53 -45 62 -48 58 b -29 42 -48 46 -39 42 b -10 46 -23 42 -16 43 b 56 63 12 56 29 63 b 248 0 121 63 135 0 b 419 127 361 0 410 104 b 420 132 420 130 420 131 b 412 140 420 137 416 140 b 386 130 403 140 392 134 b 334 107 367 117 353 107 b 318 108 330 107 324 107 b 240 138 289 112 265 128 b 130 171 209 153 168 171 z"
    },
    arrowheadBlackUp: {
      x_min: 0,
      x_max: 228,
      y_min: 0,
      y_max: 299,
      ha: 299,
      o: "m 166 431 b 0 20 111 274 0 30 b 16 0 0 12 6 0 l 17 1 b 166 50 43 16 160 50 b 310 1 171 50 289 13 l 311 0 b 328 20 321 0 328 12 b 166 431 328 30 220 274 z"
    },
    arrowheadBlackDown: {
      x_min: 0,
      x_max: 228,
      y_min: 0,
      y_max: 299,
      ha: 299,
      o: "m 166 0 b 328 410 220 157 328 400 b 311 431 328 419 321 431 l 310 429 b 166 380 289 418 171 380 b 17 429 160 380 43 415 l 16 431 b 0 410 6 431 0 419 b 166 0 0 400 111 157 z"
    },
    arpeggiatoUp: {
      x_min: 1,
      x_max: 229,
      y_min: 7,
      y_max: 1511,
      ha: 1504,
      o: "m 219 1848 l 330 1848 l 164 2176 l 1 1848 l 121 1848 b 92 1778 115 1822 101 1800 l 89 1773 b 59 1668 75 1741 59 1702 b 96 1555 59 1614 76 1580 b 99 1551 98 1554 99 1551 l 102 1547 b 124 1496 115 1531 124 1515 b 122 1482 124 1492 124 1488 b 92 1404 118 1453 102 1428 b 59 1293 78 1372 59 1332 b 105 1172 59 1234 81 1198 b 124 1120 118 1155 124 1143 l 122 1113 b 122 1110 122 1113 122 1112 b 92 1032 118 1081 102 1057 b 59 922 78 1001 59 960 b 115 792 59 855 86 816 b 124 760 121 782 124 773 b 122 744 124 756 124 750 b 92 667 118 716 102 693 b 59 556 78 635 59 595 b 108 433 59 495 82 458 b 124 389 117 420 124 408 b 122 374 124 384 124 379 b 92 298 118 346 102 323 l 89 292 b 59 186 75 261 59 222 b 163 19 59 73 140 42 b 177 10 168 13 173 10 b 189 29 184 10 189 19 b 184 48 189 35 187 42 b 167 114 174 69 167 85 b 230 305 167 179 229 193 b 181 423 230 357 209 396 b 167 484 173 442 167 458 b 230 675 167 547 229 563 b 179 796 230 729 206 769 b 167 850 171 812 167 827 b 230 1040 167 913 229 929 b 183 1158 230 1092 209 1130 b 167 1220 173 1178 167 1194 b 230 1411 167 1284 229 1300 b 186 1526 230 1462 210 1499 b 167 1594 176 1529 167 1584 b 230 1786 167 1659 229 1673 b 219 1848 230 1809 226 1829 z"
    },
    arpeggiatoDown: {
      x_min: 1,
      x_max: 229,
      y_min: -4,
      y_max: 1500,
      ha: 1504,
      o: "m 219 323 b 230 384 226 341 230 361 b 167 576 229 497 167 511 b 186 644 167 586 176 641 b 230 759 210 671 230 708 b 167 950 229 870 167 886 b 183 1012 167 976 173 992 b 230 1130 209 1040 230 1079 b 167 1320 229 1241 167 1257 b 179 1374 167 1344 171 1358 b 230 1495 206 1401 230 1441 b 167 1686 229 1607 167 1623 b 181 1747 167 1712 173 1728 b 230 1865 209 1774 230 1813 b 167 2056 229 1977 167 1992 b 184 2123 167 2085 174 2101 b 189 2141 187 2128 189 2136 b 177 2160 189 2151 184 2160 b 163 2151 173 2160 168 2157 b 59 1984 140 2128 59 2097 b 89 1878 59 1948 75 1909 l 92 1872 b 122 1796 102 1848 118 1824 b 124 1781 124 1791 124 1786 b 108 1737 124 1763 117 1750 b 59 1614 82 1712 59 1675 b 92 1503 59 1575 78 1535 b 122 1426 102 1477 118 1454 b 124 1410 124 1420 124 1414 b 115 1378 124 1397 121 1388 b 59 1248 86 1354 59 1315 b 92 1138 59 1210 78 1169 b 122 1060 102 1113 118 1089 b 122 1057 122 1058 122 1058 l 124 1050 b 105 998 124 1027 118 1015 b 59 877 81 972 59 936 b 92 766 59 838 78 798 b 122 688 102 742 118 717 b 124 674 124 683 124 678 b 102 624 124 655 115 639 l 99 619 b 96 615 99 619 98 616 b 59 503 76 590 59 556 b 89 397 59 468 75 429 l 92 392 b 121 323 101 370 115 348 l 1 323 l 164 -6 l 330 323 z"
    },
    repeat1Bar: {
      x_min: 0,
      x_max: 532,
      y_min: -250,
      y_max: 279,
      ha: 529,
      o: "m 759 380 b 766 395 763 386 766 390 b 757 402 766 399 763 402 l 605 402 b 579 380 596 402 589 393 l 4 -340 b 0 -350 1 -343 0 -347 b 12 -360 0 -356 4 -360 l 154 -360 b 184 -340 167 -360 177 -348 z m 89 288 b 0 197 40 288 0 248 b 89 108 0 148 40 108 b 180 197 140 108 180 148 b 89 288 180 248 140 288 z m 675 -71 b 586 -161 626 -71 586 -111 b 675 -251 586 -210 626 -251 b 766 -161 726 -251 766 -210 b 675 -71 766 -111 726 -71 z"
    },
    repeat2Bars: {
      x_min: 0,
      x_max: 762,
      y_min: -250,
      y_max: 279,
      ha: 529,
      o: "m 1090 380 b 1097 395 1094 386 1097 390 b 1089 402 1097 399 1094 402 l 936 402 b 910 380 927 402 920 393 l 336 -340 b 331 -350 333 -343 331 -347 b 343 -360 331 -356 336 -360 l 485 -360 b 516 -340 498 -360 508 -348 z m 759 380 b 766 395 763 386 766 390 b 757 402 766 399 763 402 l 605 402 b 579 380 596 402 589 393 l 4 -340 b 0 -350 1 -343 0 -347 b 12 -360 0 -356 4 -360 l 154 -360 b 184 -340 167 -360 177 -348 z m 89 288 b 0 197 40 288 0 248 b 89 108 0 148 40 108 b 180 197 140 108 180 148 b 89 288 180 248 140 288 z m 1007 -71 b 917 -161 958 -71 917 -111 b 1007 -251 917 -210 958 -251 b 1097 -161 1057 -251 1097 -210 b 1007 -71 1097 -111 1057 -71 z"
    },
    repeat4Bars: {
      x_min: 0,
      x_max: 1232,
      y_min: -250,
      y_max: 279,
      ha: 529,
      o: "m 1767 380 b 1774 395 1771 386 1774 390 b 1765 402 1774 399 1771 402 l 1613 402 b 1587 380 1604 402 1597 393 l 1012 -340 b 1008 -350 1009 -343 1008 -347 b 1020 -360 1008 -356 1012 -360 l 1162 -360 b 1192 -340 1175 -360 1185 -348 z m 1436 380 b 1443 395 1440 386 1443 390 b 1434 402 1443 399 1440 402 l 1282 402 b 1256 380 1273 402 1266 393 l 681 -340 b 677 -350 678 -343 677 -347 b 688 -360 677 -356 681 -360 l 831 -360 b 861 -340 844 -360 854 -348 z m 1090 380 b 1097 395 1094 386 1097 390 b 1089 402 1097 399 1094 402 l 936 402 b 910 380 927 402 920 393 l 336 -340 b 331 -350 333 -343 331 -347 b 343 -360 331 -356 336 -360 l 485 -360 b 516 -340 498 -360 508 -348 z m 759 380 b 766 395 763 386 766 390 b 757 402 766 399 763 402 l 605 402 b 579 380 596 402 589 393 l 4 -340 b 0 -350 1 -343 0 -347 b 12 -360 0 -356 4 -360 l 154 -360 b 184 -340 167 -360 177 -348 z m 89 288 b 0 197 40 288 0 248 b 89 108 0 148 40 108 b 180 197 140 108 180 148 b 89 288 180 248 140 288 z m 1683 -71 b 1594 -161 1634 -71 1594 -111 b 1683 -251 1594 -210 1634 -251 b 1774 -161 1734 -251 1774 -210 b 1683 -71 1774 -111 1734 -71 z"
    },
    repeatBarSlash: {
      x_min: 0,
      x_max: 532,
      y_min: -250,
      y_max: 279,
      ha: 529,
      o: "m 759 380 b 766 395 763 386 766 390 b 757 402 766 399 763 402 l 605 402 b 579 380 596 402 589 393 l 4 -340 b 0 -350 1 -343 0 -347 b 12 -360 0 -356 4 -360 l 154 -360 b 184 -340 167 -360 177 -348 z"
    },
    csymDiminished: {
      x_min: 0,
      x_max: 473,
      y_min: 0,
      y_max: 473,
      ha: 473,
      o: "m 341 681 b 0 341 153 681 0 530 b 341 0 0 153 153 0 b 681 341 530 0 681 153 b 341 681 681 530 530 681 z m 341 618 b 618 341 495 618 618 495 b 341 63 618 189 494 63 b 63 341 187 63 63 187 b 341 618 63 494 189 618 z"
    },
    csymHalfDiminished: {
      x_min: -16,
      x_max: 488,
      y_min: -15,
      y_max: 489,
      ha: 504,
      o: "m 703 660 l 658 704 l 557 603 b 340 681 498 652 422 681 b -1 341 151 681 -1 530 b 78 124 -1 259 29 183 l -23 23 l 22 -22 l 122 79 b 340 0 181 30 258 0 b 680 341 528 0 680 153 b 602 559 680 423 651 500 z m 62 341 b 340 618 62 494 187 618 b 513 559 403 618 464 598 l 122 168 b 62 341 84 217 62 278 z m 616 341 b 340 63 616 189 492 63 b 167 124 276 63 216 85 l 557 514 b 616 341 596 465 616 405 z"
    },
    csymAugmented: {
      x_min: 0,
      x_max: 395,
      y_min: 1,
      y_max: 396,
      ha: 395,
      o: "m 569 318 l 317 318 l 317 570 l 253 570 l 253 318 l 0 318 l 0 255 l 253 255 l 253 1 l 317 1 l 317 255 l 569 255 z"
    },
    csymMajorSeventh: {
      x_min: 0,
      x_max: 558,
      y_min: 1,
      y_max: 477,
      ha: 476,
      o: "m 402 687 l 0 1 l 804 1 z m 402 562 l 693 65 l 111 65 z"
    },
    csymMinor: {
      x_min: 0,
      x_max: 325,
      y_min: 216,
      y_max: 260,
      ha: 44,
      o: "m 468 374 l 0 374 l 0 311 l 468 311 z"
    },
    csymParensLeftTall: {
      x_min: 1,
      x_max: 185,
      y_min: 0,
      y_max: 997,
      ha: 997,
      o: "m 266 48 b 261 65 266 55 264 62 b 92 719 157 212 92 400 b 262 1371 92 1037 154 1228 b 266 1394 266 1378 266 1394 l 266 1424 b 264 1436 266 1431 266 1436 b 259 1434 262 1436 259 1434 b 1 719 84 1261 1 1011 b 259 1 1 429 79 177 b 264 0 261 0 262 0 b 266 9 265 0 266 6 z"
    },
    csymParensRightTall: {
      x_min: -20,
      x_max: 164,
      y_min: 0,
      y_max: 997,
      ha: 997,
      o: "m -29 9 b -26 0 -29 6 -27 0 b -22 1 -24 0 -23 0 b 236 719 158 177 236 429 b -22 1434 236 1011 154 1261 b -26 1436 -22 1434 -24 1436 b -29 1424 -29 1436 -29 1431 l -29 1394 b -24 1371 -29 1394 -29 1378 b 145 719 84 1228 145 1037 b -23 65 145 400 81 212 b -29 48 -26 62 -29 55 z"
    },
    csymBracketLeftTall: {
      x_min: 0,
      x_max: 155,
      y_min: 0,
      y_max: 1e3,
      ha: 1e3,
      o: "m 217 0 b 223 9 220 0 223 4 l 223 37 b 217 46 223 42 220 46 l 92 46 l 92 1394 l 217 1394 b 223 1403 220 1394 223 1398 l 223 1431 b 217 1440 223 1436 220 1440 l 6 1440 b 0 1436 3 1440 0 1439 l 0 4 b 6 0 0 1 3 0 z"
    },
    csymBracketRightTall: {
      x_min: 1,
      x_max: 156,
      y_min: 0,
      y_max: 1e3,
      ha: 1e3,
      o: "m 219 0 b 225 4 222 0 225 1 l 225 1436 b 219 1440 225 1439 222 1440 l 7 1440 b 1 1431 4 1440 1 1436 l 1 1403 b 7 1394 1 1398 4 1394 l 132 1394 l 132 46 l 7 46 b 1 37 4 46 1 42 l 1 9 b 7 0 1 4 4 0 z"
    },
    csymParensLeftVeryTall: {
      x_min: 0,
      x_max: 122,
      y_min: 0,
      y_max: 993,
      ha: 993,
      o: "m 176 32 b 171 49 176 39 174 46 b 60 716 104 194 60 399 b 173 1382 60 1032 101 1241 b 176 1405 176 1390 176 1405 l 176 1427 b 173 1430 176 1428 174 1430 b 0 716 40 1297 0 978 b 170 3 0 428 50 179 b 171 0 170 1 170 0 b 176 6 173 0 176 4 z"
    },
    csymParensRightVeryTall: {
      x_min: -15,
      x_max: 107,
      y_min: 0,
      y_max: 993,
      ha: 993,
      o: "m -22 6 b -17 0 -22 4 -19 0 b -16 3 -16 0 -16 1 b 154 716 104 179 154 428 b -19 1430 154 978 114 1297 b -22 1427 -20 1430 -22 1428 l -22 1405 b -19 1382 -22 1405 -22 1390 b 94 716 53 1241 94 1032 b -17 49 94 399 50 194 b -22 32 -20 46 -22 39 z"
    },
    csymDiagonalArrangementSlash: {
      x_min: 0,
      x_max: 999,
      y_min: 0,
      y_max: 1e3,
      ha: 1e3,
      o: "m 1439 1380 l 1377 1440 l 0 60 l 62 0 z"
    },
    accSagittal5v7KleismaUp: {
      x_min: 0,
      x_max: 156,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 0 -517 l 45 -517 l 45 -35 b 135 -112 68 -86 99 -112 b 225 68 194 -112 225 -53 l 180 68 b 144 -4 180 20 168 -4 b 122 0 138 -4 131 -3 b 23 248 86 14 52 96 l 0 248 z"
    },
    accSagittal5v7KleismaDown: {
      x_min: 0,
      x_max: 156,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 0 -248 l 23 -248 b 122 0 52 -96 86 -14 b 144 4 131 3 138 4 b 180 -68 168 4 180 -20 l 225 -68 b 135 112 225 53 194 112 b 45 35 99 112 68 86 l 45 517 l 0 517 z"
    },
    accSagittal5CommaUp: {
      x_min: 0,
      x_max: 156,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 225 -517 l 225 248 l 203 248 l 0 -112 l 0 -284 l 180 33 l 180 -517 z"
    },
    accSagittal5CommaDown: {
      x_min: 0,
      x_max: 156,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 180 517 l 180 -33 l 0 284 l 0 112 l 203 -248 l 225 -248 l 225 517 z"
    },
    accSagittal7CommaUp: {
      x_min: 0,
      x_max: 156,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 0 248 l 0 -517 l 45 -517 l 45 112 l 89 112 b 180 -68 150 112 180 53 l 180 -248 l 225 -248 l 225 68 b 135 248 225 187 194 248 z"
    },
    accSagittal7CommaDown: {
      x_min: 0,
      x_max: 156,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 135 -248 b 225 -68 194 -248 225 -187 l 225 248 l 180 248 l 180 68 b 89 -112 180 -53 150 -112 l 45 -112 l 45 517 l 0 517 l 0 -248 z"
    },
    accSagittal25SmallDiesisUp: {
      x_min: 0,
      x_max: 250,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 0 -157 l 0 -259 l 315 -89 l 315 -517 l 360 -517 l 360 248 l 337 248 l 0 68 l 0 -33 l 315 135 l 315 10 z"
    },
    accSagittal25SmallDiesisDown: {
      x_min: 0,
      x_max: 250,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 315 -10 l 315 -135 l 0 33 l 0 -68 l 337 -248 l 360 -248 l 360 517 l 315 517 l 315 89 l 0 259 l 0 157 z"
    },
    accSagittal35MediumDiesisUp: {
      x_min: 0,
      x_max: 281,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 0 -284 l 180 33 l 180 -517 l 225 -517 l 225 112 l 271 112 b 360 -68 330 112 360 53 l 360 -248 l 405 -248 l 405 68 b 315 248 405 187 374 248 l 203 248 l 0 -112 z"
    },
    accSagittal35MediumDiesisDown: {
      x_min: 0,
      x_max: 281,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 0 112 l 203 -248 l 315 -248 b 405 -68 374 -248 405 -187 l 405 248 l 360 248 l 360 68 b 271 -112 360 -53 330 -112 l 225 -112 l 225 517 l 180 517 l 180 -33 l 0 284 z"
    },
    accSagittal11MediumDiesisUp: {
      x_min: 0,
      x_max: 344,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 225 53 l 225 -517 l 271 -517 l 271 53 l 495 -248 l 495 -89 l 248 248 l 0 -89 l 0 -248 z"
    },
    accSagittal11MediumDiesisDown: {
      x_min: 0,
      x_max: 344,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 0 248 l 0 89 l 248 -248 l 495 89 l 495 248 l 271 -53 l 271 517 l 225 517 l 225 -53 z"
    },
    accSagittal11LargeDiesisUp: {
      x_min: 0,
      x_max: 344,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 0 68 l 0 -248 l 45 -248 l 45 -68 b 180 112 45 53 89 112 l 225 112 l 225 -517 l 271 -517 l 271 112 l 315 112 b 449 -68 405 112 449 53 l 449 -248 l 495 -248 l 495 68 b 360 248 495 187 449 248 l 135 248 b 0 68 45 248 0 187 z"
    },
    accSagittal11LargeDiesisDown: {
      x_min: 0,
      x_max: 344,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 0 -68 b 135 -248 0 -187 45 -248 l 360 -248 b 495 -68 449 -248 495 -187 l 495 248 l 449 248 l 449 68 b 315 -112 449 -53 405 -112 l 271 -112 l 271 517 l 225 517 l 225 -112 l 180 -112 b 45 68 89 -112 45 -53 l 45 248 l 0 248 z"
    },
    accSagittal35LargeDiesisUp: {
      x_min: 0,
      x_max: 375,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 0 -68 b 135 -248 0 -187 45 -248 l 248 -248 l 540 112 l 540 274 l 271 -58 l 271 517 l 225 517 l 225 -112 l 180 -112 b 45 68 89 -112 45 -53 l 45 248 l 0 248 z"
    },
    accSagittal35LargeDiesisDown: {
      x_min: 0,
      x_max: 375,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 0 -68 b 135 -248 0 -187 45 -248 l 248 -248 l 540 112 l 540 274 l 269 -58 l 269 517 l 225 517 l 225 -112 l 180 -112 b 45 68 89 -112 45 -53 l 45 248 l 0 248 z"
    },
    accSagittalSharp25SDown: {
      x_min: 0,
      x_max: 344,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 0 68 b 112 -112 0 -53 36 -112 l 135 -112 l 135 -517 l 180 -517 l 180 -89 b 248 26 206 -65 229 -27 b 315 -89 264 -27 287 -65 l 315 -517 l 360 -517 l 360 -112 l 383 -112 b 495 68 458 -112 495 -53 l 449 68 b 399 -4 449 20 433 -4 b 248 248 297 -4 261 171 b 122 0 216 96 176 14 b 94 -4 112 -3 102 -4 b 45 68 60 -4 45 20 z"
    },
    accSagittalFlat25SUp: {
      x_min: 0,
      x_max: 344,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 45 -68 b 94 4 45 -20 60 4 b 122 0 102 4 112 3 b 248 -248 176 -14 216 -96 b 399 4 261 -171 297 4 b 449 -68 433 4 449 -20 l 495 -68 b 383 112 495 53 458 112 l 360 112 l 360 517 l 315 517 l 315 89 b 248 -26 287 65 264 27 b 180 89 229 27 206 65 l 180 517 l 135 517 l 135 112 l 112 112 b 0 -68 36 112 0 53 z"
    },
    accSagittalSharp7CDown: {
      x_min: 0,
      x_max: 250,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 0 -517 l 45 -517 l 45 112 l 89 112 b 180 104 124 112 154 109 l 180 -517 l 225 -517 l 225 89 b 315 -68 285 60 315 9 l 315 -248 l 360 -248 l 360 68 b 135 248 360 187 285 248 l 0 248 z"
    },
    accSagittalFlat7CUp: {
      x_min: 0,
      x_max: 250,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 0 -248 l 135 -248 b 360 -68 285 -248 360 -187 l 360 248 l 315 248 l 315 68 b 225 -89 315 -9 285 -60 l 225 517 l 180 517 l 180 -104 b 89 -112 154 -109 124 -112 l 45 -112 l 45 517 l 0 517 z"
    },
    accSagittalSharp5CDown: {
      x_min: 0,
      x_max: 281,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 45 -517 l 45 71 l 180 -56 l 180 -517 l 225 -517 l 225 -98 l 405 -268 l 405 -112 l 23 248 l 0 248 l 0 -517 z"
    },
    accSagittalFlat5CUp: {
      x_min: 0,
      x_max: 281,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 0 517 l 0 -248 l 23 -248 l 405 112 l 405 268 l 225 98 l 225 517 l 180 517 l 180 56 l 45 -71 l 45 517 z"
    },
    accSagittalSharp5v7kDown: {
      x_min: 0,
      x_max: 344,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 0 -112 l 0 -276 l 135 -82 l 135 -517 l 180 -517 l 180 -17 l 271 112 l 315 112 l 315 -517 l 360 -517 l 360 107 b 449 -68 420 89 449 30 l 449 -248 l 495 -248 l 495 68 b 360 248 495 189 449 248 l 248 248 z"
    },
    accSagittalFlat5v7kUp: {
      x_min: 0,
      x_max: 344,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 248 -248 l 360 -248 b 495 -68 449 -248 495 -189 l 495 248 l 449 248 l 449 68 b 360 -107 449 -30 420 -89 l 360 517 l 315 517 l 315 -112 l 271 -112 l 180 17 l 180 517 l 135 517 l 135 82 l 0 276 l 0 112 z"
    },
    accSagittalSharp: {
      x_min: 0,
      x_max: 406,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 180 -53 l 180 -517 l 225 -517 l 225 0 l 292 85 l 360 0 l 360 -517 l 405 -517 l 405 -53 l 585 -274 l 585 -112 l 292 248 l 0 -112 l 0 -274 z"
    },
    accSagittalFlat: {
      x_min: 0,
      x_max: 406,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 0 274 l 0 112 l 292 -248 l 585 112 l 585 274 l 405 53 l 405 517 l 360 517 l 360 0 l 292 -85 l 225 0 l 225 517 l 180 517 l 180 53 z"
    },
    accSagittalSharp5v7kUp: {
      x_min: 0,
      x_max: 312,
      y_min: -361,
      y_max: 172,
      ha: 533,
      o: "m 45 -517 l 45 -10 b 135 -92 68 -48 98 -75 l 135 -520 l 180 -520 l 180 -108 b 248 -115 203 -112 225 -115 b 271 -112 256 -115 264 -115 l 271 -517 l 315 -517 l 315 -107 b 449 68 405 -89 449 -30 l 405 68 b 297 -4 405 19 369 -4 b 23 248 131 -4 56 85 l 0 248 l 0 -517 z"
    },
    accSagittalFlat5v7kDown: {
      x_min: 0,
      x_max: 312,
      y_min: -172,
      y_max: 361,
      ha: 533,
      o: "m 0 517 l 0 -248 l 23 -248 b 297 4 56 -85 131 4 b 405 -68 369 4 405 -19 l 449 -68 b 315 107 449 30 405 89 l 315 517 l 271 517 l 271 112 b 248 115 264 115 256 115 b 180 108 225 115 203 112 l 180 520 l 135 520 l 135 92 b 45 10 98 75 68 48 l 45 517 z"
    },
    accSagittalSharp5CUp: {
      x_min: 0,
      x_max: 312,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 0 -266 l 135 -153 l 135 -517 l 180 -517 l 180 -115 l 271 -39 l 271 -517 l 315 -517 l 315 0 l 405 75 l 405 -517 l 449 -517 l 449 248 l 428 248 l 0 -112 z"
    },
    accSagittalFlat5CDown: {
      x_min: 0,
      x_max: 312,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 0 112 l 428 -248 l 449 -248 l 449 517 l 405 517 l 405 -75 l 315 0 l 315 517 l 271 517 l 271 39 l 180 115 l 180 517 l 135 517 l 135 153 l 0 266 z"
    },
    accSagittalSharp7CUp: {
      x_min: 0,
      x_max: 312,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 0 -517 l 45 -517 l 45 112 l 135 112 l 135 -517 l 180 -517 l 180 108 b 271 89 213 105 243 99 l 271 -517 l 315 -517 l 315 73 b 405 -68 374 45 405 -3 l 405 -248 l 449 -248 l 449 68 b 135 248 449 187 346 248 l 0 248 z"
    },
    accSagittalFlat7CDown: {
      x_min: 0,
      x_max: 312,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 0 -248 l 135 -248 b 449 -68 346 -248 449 -187 l 449 248 l 405 248 l 405 68 b 315 -73 405 3 374 -45 l 315 517 l 271 517 l 271 -89 b 180 -108 243 -99 213 -105 l 180 517 l 135 517 l 135 -112 l 45 -112 l 45 517 l 0 517 z"
    },
    accSagittalSharp25SUp: {
      x_min: 0,
      x_max: 375,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 0 -30 l 495 143 l 495 14 l 0 -157 l 0 -255 l 225 -177 l 225 -517 l 271 -517 l 271 -161 l 360 -130 l 360 -517 l 405 -517 l 405 -115 l 495 -84 l 495 -517 l 540 -517 l 540 248 l 517 248 l 0 68 z"
    },
    accSagittalFlat25SDown: {
      x_min: 0,
      x_max: 375,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 0 -68 l 517 -248 l 540 -248 l 540 517 l 495 517 l 495 84 l 405 115 l 405 517 l 360 517 l 360 130 l 271 161 l 271 517 l 225 517 l 225 177 l 0 255 l 0 157 l 495 -14 l 495 -143 l 0 30 z"
    },
    accSagittalSharp35MUp: {
      x_min: 0,
      x_max: 406,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 0 -112 l 0 -274 l 135 -108 l 135 -517 l 180 -517 l 180 -53 l 271 58 l 271 -517 l 315 -517 l 315 112 l 360 112 b 405 109 376 112 390 112 l 405 -517 l 449 -517 l 449 96 b 540 -68 510 72 540 17 l 540 -248 l 585 -248 l 585 68 b 405 248 585 187 526 248 l 292 248 z"
    },
    accSagittalFlat35MDown: {
      x_min: 0,
      x_max: 406,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 292 -248 l 405 -248 b 585 -68 526 -248 585 -187 l 585 248 l 540 248 l 540 68 b 449 -96 540 -17 510 -72 l 449 517 l 405 517 l 405 -109 b 360 -112 390 -112 376 -112 l 315 -112 l 315 517 l 271 517 l 271 -58 l 180 53 l 180 517 l 135 517 l 135 108 l 0 274 l 0 112 z"
    },
    accSagittalSharp11MUp: {
      x_min: 0,
      x_max: 469,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 0 -112 l 0 -271 l 180 -79 l 180 -517 l 225 -517 l 225 -30 l 315 65 l 315 -517 l 360 -517 l 360 65 l 449 -30 l 449 -517 l 495 -517 l 495 -79 l 675 -271 l 675 -112 l 337 248 z"
    },
    accSagittalFlat11MDown: {
      x_min: 0,
      x_max: 469,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 337 -248 l 675 112 l 675 271 l 495 79 l 495 517 l 449 517 l 449 30 l 360 -65 l 360 517 l 315 517 l 315 -65 l 225 30 l 225 517 l 180 517 l 180 79 l 0 271 l 0 112 z"
    },
    accSagittalSharp11LUp: {
      x_min: 0,
      x_max: 469,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 0 68 l 0 -248 l 45 -248 l 45 -68 b 180 104 45 26 89 82 l 180 -517 l 225 -517 l 225 112 l 315 112 l 315 -517 l 360 -517 l 360 112 l 449 112 l 449 -517 l 495 -517 l 495 104 b 631 -68 585 82 631 26 l 631 -248 l 675 -248 l 675 68 b 449 248 675 187 600 248 l 225 248 b 0 68 75 248 0 187 z"
    },
    accSagittalFlat11LDown: {
      x_min: 0,
      x_max: 469,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 0 -68 b 225 -248 0 -187 75 -248 l 449 -248 b 675 -68 600 -248 675 -187 l 675 248 l 631 248 l 631 68 b 495 -104 631 -26 585 -82 l 495 517 l 449 517 l 449 -112 l 360 -112 l 360 517 l 315 517 l 315 -112 l 225 -112 l 225 517 l 180 517 l 180 -104 b 45 68 89 -82 45 -26 l 45 248 l 0 248 z"
    },
    accSagittalSharp35LUp: {
      x_min: 0,
      x_max: 500,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 0 -248 l 45 -248 l 45 -68 b 180 104 45 26 89 82 l 180 -517 l 225 -517 l 225 112 l 315 112 l 315 -517 l 360 -517 l 360 71 l 452 -17 l 452 -517 l 495 -517 l 495 -56 l 720 -268 l 720 -112 l 337 248 l 225 248 b 0 68 75 248 0 187 z"
    },
    accSagittalFlat35LDown: {
      x_min: 0,
      x_max: 500,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 0 -68 b 225 -248 0 -187 75 -248 l 337 -248 l 720 112 l 720 268 l 495 56 l 495 517 l 452 517 l 452 17 l 360 -71 l 360 517 l 315 517 l 315 -112 l 225 -112 l 225 517 l 180 517 l 180 -104 b 45 68 89 -82 45 -26 l 45 248 l 0 248 z"
    },
    accSagittalDoubleSharp25SDown: {
      x_min: 0,
      x_max: 406,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 0 68 b 135 -112 0 -53 45 -112 b 243 -62 180 -112 215 -95 l 89 -503 l 143 -517 l 292 -82 l 445 -517 l 495 -503 l 343 -62 b 449 -112 372 -95 408 -112 b 585 68 540 -112 585 -53 l 540 68 b 475 -4 540 20 517 -4 b 292 248 350 -4 315 148 b 112 -4 274 148 236 -4 b 45 68 68 -4 45 20 z"
    },
    accSagittalDoubleFlat25SUp: {
      x_min: 0,
      x_max: 406,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 45 -68 b 112 4 45 -20 68 4 b 292 -248 236 4 274 -148 b 475 4 315 -148 350 4 b 540 -68 517 4 540 -20 l 585 -68 b 449 112 585 53 540 112 b 343 62 408 112 372 95 l 495 503 l 445 517 l 292 82 l 143 517 l 89 503 l 243 62 b 135 112 215 95 180 112 b 0 -68 45 112 0 53 z"
    },
    accSagittalDoubleSharp7CDown: {
      x_min: 0,
      x_max: 375,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 0 -503 l 52 -517 l 203 -82 l 354 -517 l 405 -503 l 230 0 l 271 108 b 495 -68 420 92 495 35 l 495 -248 l 540 -248 l 540 68 b 225 248 540 187 435 248 l 89 248 l 89 112 l 135 112 l 174 0 z m 213 112 l 203 82 l 192 112 z"
    },
    accSagittalDoubleFlat7CUp: {
      x_min: 0,
      x_max: 375,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 174 0 l 135 -112 l 89 -112 l 89 -248 l 225 -248 b 540 -68 435 -248 540 -187 l 540 248 l 495 248 l 495 68 b 271 -108 495 -35 420 -92 l 230 0 l 405 503 l 354 517 l 203 82 l 52 517 l 0 503 z m 192 -112 l 203 -82 l 213 -112 z"
    },
    accSagittalDoubleSharp5CDown: {
      x_min: 0,
      x_max: 406,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 405 -503 l 230 0 l 232 4 l 585 -264 l 585 -112 l 112 248 l 89 248 l 89 112 l 151 68 l 174 0 l 0 -503 l 52 -517 l 203 -82 l 354 -517 z"
    },
    accSagittalDoubleFlat5CUp: {
      x_min: 0,
      x_max: 406,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 354 517 l 203 82 l 52 517 l 0 503 l 174 0 l 151 -68 l 89 -112 l 89 -248 l 112 -248 l 585 112 l 585 264 l 232 -4 l 230 0 l 405 503 z"
    },
    accSagittalDoubleSharp5v7kDown: {
      x_min: 0,
      x_max: 406,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 0 -274 l 252 35 l 265 0 l 89 -503 l 141 -517 l 292 -82 l 444 -517 l 495 -503 l 321 0 l 360 112 b 540 -68 480 112 540 53 l 540 -248 l 585 -248 l 585 68 b 405 248 585 187 526 248 l 292 248 l 0 -112 z"
    },
    accSagittalDoubleFlat5v7kUp: {
      x_min: 0,
      x_max: 406,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 0 112 l 292 -248 l 405 -248 b 585 -68 526 -248 585 -187 l 585 248 l 540 248 l 540 68 b 360 -112 540 -53 480 -112 l 321 0 l 495 503 l 444 517 l 292 82 l 141 517 l 89 503 l 265 0 l 252 -35 l 0 274 z"
    },
    accSagittalDoubleSharp: {
      x_min: 0,
      x_max: 469,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 540 -503 l 366 0 l 380 45 l 675 -271 l 675 -112 l 337 248 l 0 -112 l 0 -271 l 295 45 l 310 0 l 135 -503 l 186 -517 l 337 -82 l 488 -517 z"
    },
    accSagittalDoubleFlat: {
      x_min: 0,
      x_max: 469,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 488 517 l 337 82 l 186 517 l 135 503 l 310 0 l 295 -45 l 0 271 l 0 112 l 337 -248 l 675 112 l 675 271 l 380 -45 l 366 0 l 540 503 z"
    },
    accSagittal7v11KleismaUp: {
      x_min: 0,
      x_max: 219,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 68 -112 b 135 -45 89 -112 112 -89 l 135 -517 l 180 -517 l 180 -45 b 248 -112 200 -89 225 -112 b 315 68 292 -112 315 -53 l 271 68 b 248 -4 271 20 264 -4 b 236 0 245 -4 240 -3 b 157 248 213 14 187 96 b 78 0 127 96 101 14 b 65 -4 73 -3 68 -4 b 45 68 50 -4 45 20 l 0 68 b 68 -112 0 -53 23 -112 z"
    },
    accSagittal7v11KleismaDown: {
      x_min: 0,
      x_max: 219,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 68 112 b 0 -68 23 112 0 53 l 45 -68 b 65 4 45 -20 50 4 b 78 0 68 4 73 3 b 157 -248 101 -14 127 -96 b 236 0 187 -96 213 -14 b 248 4 240 3 245 4 b 271 -68 264 4 271 -20 l 315 -68 b 248 112 315 53 292 112 b 180 45 225 112 200 89 l 180 517 l 135 517 l 135 45 b 68 112 112 89 89 112 z"
    },
    accSagittal17CommaUp: {
      x_min: 0,
      x_max: 281,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 45 -203 b 89 -23 45 -82 60 -23 l 157 -23 b 180 -4 164 -23 173 -17 l 180 -517 l 225 -517 l 225 -40 b 315 -118 248 -92 279 -118 b 405 62 374 -118 405 -59 l 360 62 b 324 -10 360 14 348 -10 b 302 -6 318 -10 311 -9 b 206 217 268 9 235 84 l 203 248 b 135 68 177 127 154 68 l 68 68 b 0 -203 23 68 0 -23 z"
    },
    accSagittal17CommaDown: {
      x_min: 0,
      x_max: 281,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 0 203 b 68 -68 0 23 23 -68 l 135 -68 b 203 -248 154 -68 177 -127 l 206 -217 b 302 6 235 -84 268 -9 b 324 10 311 9 318 10 b 360 -62 348 10 360 -14 l 405 -62 b 315 118 405 59 374 118 b 225 40 279 118 248 92 l 225 517 l 180 517 l 180 4 b 157 23 173 17 164 23 l 89 23 b 45 203 60 23 45 82 z"
    },
    accSagittal55CommaUp: {
      x_min: 0,
      x_max: 219,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 0 248 l 0 -517 l 45 -517 l 45 58 l 315 -274 l 315 -112 l 23 248 z"
    },
    accSagittal55CommaDown: {
      x_min: 0,
      x_max: 219,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 23 -248 l 315 112 l 315 274 l 45 -58 l 45 517 l 0 517 l 0 -248 z"
    },
    accSagittal7v11CommaUp: {
      x_min: 0,
      x_max: 188,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 0 -248 l 45 -248 l 45 -68 b 180 112 45 53 89 112 l 225 112 l 225 -517 l 271 -517 l 271 248 l 135 248 b 0 68 45 248 0 187 z"
    },
    accSagittal7v11CommaDown: {
      x_min: 0,
      x_max: 188,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 0 -68 b 135 -248 0 -187 45 -248 l 271 -248 l 271 517 l 225 517 l 225 -112 l 180 -112 b 45 68 89 -112 45 -53 l 45 248 l 0 248 z"
    },
    accSagittal5v11SmallDiesisUp: {
      x_min: 0,
      x_max: 312,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 0 73 l 0 -248 l 45 -248 l 45 -68 b 180 112 45 53 89 112 l 225 112 l 225 -517 l 271 -517 l 271 -40 b 360 -118 295 -92 325 -118 b 449 62 420 -118 449 -59 l 405 62 b 369 -10 405 14 393 -10 b 348 -6 363 -10 356 -9 b 251 217 312 9 279 84 l 248 248 l 135 248 b 0 73 45 248 0 189 z"
    },
    accSagittal5v11SmallDiesisDown: {
      x_min: 0,
      x_max: 312,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 0 -73 b 135 -248 0 -189 45 -248 l 248 -248 l 251 -217 b 348 6 279 -84 312 -9 b 369 10 356 9 363 10 b 405 -62 393 10 405 -14 l 449 -62 b 360 118 449 59 420 118 b 271 40 325 118 295 92 l 271 517 l 225 517 l 225 -112 l 180 -112 b 45 68 89 -112 45 -53 l 45 248 l 0 248 z"
    },
    accSagittalSharp5v11SDown: {
      x_min: 0,
      x_max: 344,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 45 -203 b 112 -23 45 -84 68 -23 l 135 -23 l 135 -517 l 180 -517 l 180 -23 b 242 37 203 -23 225 -3 b 315 -89 262 -23 285 -63 l 315 -517 l 360 -517 l 360 -112 l 383 -112 b 495 68 458 -112 495 -53 l 449 68 b 399 -4 449 20 433 -4 b 248 248 297 -4 261 171 b 157 68 222 127 192 68 l 89 68 b 0 -203 30 68 0 -23 z"
    },
    accSagittalFlat5v11SUp: {
      x_min: 0,
      x_max: 344,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 0 203 b 89 -68 0 23 30 -68 l 157 -68 b 248 -248 192 -68 222 -127 b 399 4 261 -171 297 4 b 449 -68 433 4 449 -20 l 495 -68 b 383 112 495 53 458 112 l 360 112 l 360 517 l 315 517 l 315 89 b 242 -37 285 63 262 23 b 180 23 225 3 203 23 l 180 517 l 135 517 l 135 23 l 112 23 b 45 203 68 23 45 84 z"
    },
    accSagittalSharp7v11CDown: {
      x_min: 0,
      x_max: 344,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 89 -112 l 89 -517 l 135 -517 l 135 -95 b 206 37 163 -73 187 -30 b 271 -23 225 -3 248 -23 l 271 -517 l 315 -517 l 315 -23 l 383 -23 b 449 -203 428 -23 449 -84 l 495 -203 b 405 68 495 -23 465 68 l 292 68 b 203 248 258 68 228 127 b 101 0 173 98 138 16 b 81 -3 94 0 86 -3 b 45 68 56 -3 45 20 l 0 68 b 89 -112 0 -52 30 -112 z"
    },
    accSagittalFlat7v11CUp: {
      x_min: 0,
      x_max: 344,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 89 112 b 0 -68 30 112 0 52 l 45 -68 b 81 3 45 -20 56 3 b 101 0 86 3 94 0 b 203 -248 138 -16 173 -98 b 292 -68 228 -127 258 -68 l 405 -68 b 495 203 465 -68 495 23 l 449 203 b 383 23 449 84 428 23 l 315 23 l 315 517 l 271 517 l 271 23 b 206 -37 248 23 225 3 b 135 95 187 30 163 73 l 135 517 l 89 517 z"
    },
    accSagittalSharp55CDown: {
      x_min: 0,
      x_max: 250,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 0 -271 l 135 -125 l 135 -517 l 180 -517 l 180 -78 l 315 65 l 315 -517 l 360 -517 l 360 248 l 337 248 l 0 -112 z"
    },
    accSagittalFlat55CUp: {
      x_min: 0,
      x_max: 250,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 0 112 l 337 -248 l 360 -248 l 360 517 l 315 517 l 315 -65 l 180 78 l 180 517 l 135 517 l 135 125 l 0 271 z"
    },
    accSagittalSharp17CDown: {
      x_min: 0,
      x_max: 375,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 45 -248 l 45 -68 b 180 109 45 36 89 95 l 180 -517 l 225 -517 l 225 112 l 271 112 b 360 -89 292 13 321 -55 l 360 -517 l 405 -517 l 405 -112 l 428 -112 b 540 68 504 -112 540 -53 l 495 68 b 445 -4 495 20 480 -4 b 292 248 343 -4 307 171 l 180 248 b 0 68 60 248 0 187 l 0 -248 z"
    },
    accSagittalFlat17CUp: {
      x_min: 0,
      x_max: 375,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 0 248 l 0 -68 b 180 -248 0 -187 60 -248 l 292 -248 b 445 4 307 -171 343 4 b 495 -68 480 4 495 -20 l 540 -68 b 428 112 540 53 504 112 l 405 112 l 405 517 l 360 517 l 360 89 b 271 -112 321 55 292 -13 l 225 -112 l 225 517 l 180 517 l 180 -109 b 45 68 89 -95 45 -36 l 45 248 z"
    },
    accSagittalSharp7v11kDown: {
      x_min: 0,
      x_max: 312,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 0 -32 l 405 138 l 405 13 l 0 -157 l 0 -256 l 225 -161 l 225 -517 l 271 -517 l 271 -144 l 405 -86 l 405 -517 l 449 -517 l 449 248 l 428 248 l 0 68 z"
    },
    accSagittalFlat7v11kUp: {
      x_min: 0,
      x_max: 312,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 0 -68 l 428 -248 l 449 -248 l 449 517 l 405 517 l 405 86 l 271 144 l 271 517 l 225 517 l 225 161 l 0 256 l 0 157 l 405 -13 l 405 -138 l 0 32 z"
    },
    accSagittalSharp7v11kUp: {
      x_min: 0,
      x_max: 406,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 135 -112 l 135 -517 l 180 -517 l 180 -105 b 271 -23 217 -94 248 -65 l 271 -517 l 315 -517 l 315 -23 b 405 -105 337 -65 369 -94 l 405 -517 l 449 -517 l 449 -112 b 585 68 540 -112 585 -53 l 540 68 b 475 -4 540 20 517 -4 b 292 248 350 -4 315 148 b 112 -4 274 148 236 -4 b 45 68 68 -4 45 20 l 0 68 b 135 -112 0 -53 45 -112 z"
    },
    accSagittalFlat7v11kDown: {
      x_min: 0,
      x_max: 406,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 135 112 b 0 -68 45 112 0 53 l 45 -68 b 112 4 45 -20 68 4 b 292 -248 236 4 274 -148 b 475 4 315 -148 350 4 b 540 -68 517 4 540 -20 l 585 -68 b 449 112 585 53 540 112 l 449 517 l 405 517 l 405 105 b 315 23 369 94 337 65 l 315 517 l 271 517 l 271 23 b 180 105 248 65 217 94 l 180 517 l 135 517 z"
    },
    accSagittalSharp17CUp: {
      x_min: 0,
      x_max: 406,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 45 -203 b 135 -23 45 -84 75 -23 l 135 -517 l 180 -517 l 180 -23 l 203 -23 b 271 14 229 -23 251 -10 l 271 -517 l 315 -517 l 315 -23 b 405 -105 337 -65 369 -94 l 405 -517 l 449 -517 l 449 -112 b 585 68 540 -112 585 -53 l 540 68 b 475 -4 540 20 517 -4 b 292 248 350 -4 312 150 b 180 68 268 127 230 68 l 112 68 b 0 -203 37 68 0 -23 z"
    },
    accSagittalFlat17CDown: {
      x_min: 0,
      x_max: 406,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 0 203 b 112 -68 0 23 37 -68 l 180 -68 b 292 -248 230 -68 268 -127 b 475 4 312 -150 350 4 b 540 -68 517 4 540 -20 l 585 -68 b 449 112 585 53 540 112 l 449 517 l 405 517 l 405 105 b 315 23 369 94 337 65 l 315 517 l 271 517 l 271 -14 b 203 23 251 10 229 23 l 180 23 l 180 517 l 135 517 l 135 23 b 45 203 75 23 45 84 z"
    },
    accSagittalSharp55CUp: {
      x_min: 0,
      x_max: 344,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 45 -517 l 45 78 l 135 10 l 135 -517 l 180 -517 l 180 -23 l 271 -92 l 271 -517 l 315 -517 l 315 -127 l 495 -264 l 495 -112 l 23 248 l 0 248 l 0 -517 z"
    },
    accSagittalFlat55CDown: {
      x_min: 0,
      x_max: 344,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 0 517 l 0 -248 l 23 -248 l 495 112 l 495 264 l 315 127 l 315 517 l 271 517 l 271 92 l 180 23 l 180 517 l 135 517 l 135 -10 l 45 -78 l 45 517 z"
    },
    accSagittalSharp7v11CUp: {
      x_min: 0,
      x_max: 344,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 0 68 l 0 -248 l 45 -248 l 45 -68 b 180 86 45 6 89 58 l 180 -517 l 225 -517 l 225 98 b 315 109 252 104 282 108 l 315 -517 l 360 -517 l 360 112 l 449 112 l 449 -517 l 495 -517 l 495 248 l 360 248 b 0 68 121 248 0 189 z"
    },
    accSagittalFlat7v11CDown: {
      x_min: 0,
      x_max: 344,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 0 -68 b 360 -248 0 -189 121 -248 l 495 -248 l 495 517 l 449 517 l 449 -112 l 360 -112 l 360 517 l 315 517 l 315 -109 b 225 -98 282 -108 252 -104 l 225 517 l 180 517 l 180 -86 b 45 68 89 -58 45 -6 l 45 248 l 0 248 z"
    },
    accSagittalSharp5v11SUp: {
      x_min: 0,
      x_max: 438,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 0 -248 l 45 -248 l 45 -68 b 180 104 45 26 89 82 l 180 -517 l 225 -517 l 225 112 l 315 112 l 315 -517 l 360 -517 l 360 -23 b 449 -105 383 -65 415 -94 l 449 -517 l 495 -517 l 495 -112 b 631 68 585 -112 631 -53 l 585 68 b 520 -4 585 20 563 -4 b 337 248 396 -4 360 150 l 225 248 b 0 68 76 248 0 187 z"
    },
    accSagittalFlat5v11SDown: {
      x_min: 0,
      x_max: 438,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 0 -68 b 225 -248 0 -187 76 -248 l 337 -248 b 520 4 360 -150 396 4 b 585 -68 563 4 585 -20 l 631 -68 b 495 112 631 53 585 112 l 495 517 l 449 517 l 449 105 b 360 23 415 94 383 65 l 360 517 l 315 517 l 315 -112 l 225 -112 l 225 517 l 180 517 l 180 -104 b 45 68 89 -82 45 -26 l 45 248 l 0 248 z"
    },
    accSagittalDoubleSharp5v11SDown: {
      x_min: 0,
      x_max: 406,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 45 -203 b 135 -23 45 -84 75 -23 l 203 -23 b 262 4 225 -23 245 -13 l 265 0 l 89 -503 l 141 -517 l 292 -82 l 444 -517 l 495 -503 l 341 -60 b 449 -112 370 -95 405 -112 b 585 68 540 -112 585 -53 l 540 68 b 475 -4 540 20 517 -4 b 292 248 350 -4 312 150 b 180 68 268 127 230 68 l 112 68 b 0 -203 37 68 0 -23 z"
    },
    accSagittalDoubleFlat5v11SUp: {
      x_min: 0,
      x_max: 406,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 0 203 b 112 -68 0 23 37 -68 l 180 -68 b 292 -248 230 -68 268 -127 b 475 4 312 -150 350 4 b 540 -68 517 4 540 -20 l 585 -68 b 449 112 585 53 540 112 b 341 60 405 112 370 95 l 495 503 l 444 517 l 292 82 l 141 517 l 89 503 l 265 0 l 262 -4 b 203 23 245 13 225 23 l 135 23 b 45 203 75 23 45 84 z"
    },
    accSagittalDoubleSharp7v11CDown: {
      x_min: 0,
      x_max: 375,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 112 -112 b 193 -73 143 -112 170 -99 l 45 -501 l 95 -517 l 248 -81 l 397 -517 l 449 -503 l 275 0 l 278 4 b 337 -23 295 -13 315 -23 l 405 -23 b 495 -203 465 -23 495 -84 l 540 -203 b 428 68 540 -23 503 68 l 360 68 b 248 248 310 68 271 127 b 122 0 217 98 176 16 b 95 -3 112 0 104 -3 b 45 68 60 -3 45 20 l 0 68 b 112 -112 0 -52 36 -112 z"
    },
    accSagittalDoubleFlat7v11CUp: {
      x_min: 0,
      x_max: 375,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 112 112 b 0 -68 36 112 0 52 l 45 -68 b 95 3 45 -20 60 3 b 122 0 104 3 112 0 b 248 -248 176 -16 217 -98 b 360 -68 271 -127 310 -68 l 428 -68 b 540 203 503 -68 540 23 l 495 203 b 405 23 495 84 465 23 l 337 23 b 278 -4 315 23 295 13 l 275 0 l 449 503 l 397 517 l 248 81 l 95 517 l 45 501 l 193 73 b 112 112 170 99 143 112 z"
    },
    accSagittalDoubleSharp55CDown: {
      x_min: 0,
      x_max: 375,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 428 248 l 0 -112 l 0 -266 l 307 -7 l 135 -503 l 186 -517 l 337 -82 l 488 -517 l 540 -503 l 366 0 l 386 59 l 449 112 l 449 248 z"
    },
    accSagittalDoubleFlat55CUp: {
      x_min: 0,
      x_max: 375,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 449 -248 l 449 -112 l 386 -59 l 366 0 l 540 503 l 488 517 l 337 82 l 186 517 l 135 503 l 307 7 l 0 266 l 0 112 l 428 -248 z"
    },
    accSagittalDoubleSharp17CDown: {
      x_min: 0,
      x_max: 438,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 45 -248 l 45 -68 b 271 112 45 53 120 112 l 310 0 l 135 -503 l 186 -517 l 337 -82 l 488 -517 l 540 -503 l 387 -62 b 495 -112 416 -95 452 -112 b 631 68 585 -112 631 -53 l 585 68 b 520 -4 585 20 563 -4 b 337 248 396 -4 360 150 l 225 248 b 0 68 76 248 0 187 l 0 -248 z"
    },
    accSagittalDoubleFlat17CUp: {
      x_min: 0,
      x_max: 438,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 0 248 l 0 -68 b 225 -248 0 -187 76 -248 l 337 -248 b 520 4 360 -150 396 4 b 585 -68 563 4 585 -20 l 631 -68 b 495 112 631 53 585 112 b 387 62 452 112 416 95 l 540 503 l 488 517 l 337 82 l 186 517 l 135 503 l 310 0 l 271 -112 b 45 68 120 -112 45 -53 l 45 248 z"
    },
    accSagittalDoubleSharp7v11kDown: {
      x_min: 0,
      x_max: 438,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 0 68 l 0 -30 l 366 96 l 399 0 l 392 -23 l 0 -157 l 0 -255 l 353 -135 l 225 -503 l 276 -517 l 428 -82 l 579 -517 l 631 -503 l 455 0 l 507 145 l 540 157 l 540 248 l 517 248 z m 416 115 l 442 124 l 428 82 z"
    },
    accSagittalDoubleFlat7v11kUp: {
      x_min: 0,
      x_max: 438,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 517 -248 l 540 -248 l 540 -157 l 507 -145 l 455 0 l 631 503 l 579 517 l 428 82 l 276 517 l 225 503 l 353 135 l 0 255 l 0 157 l 392 23 l 399 0 l 366 -96 l 0 30 l 0 -68 z m 428 -82 l 442 -124 l 416 -115 z"
    },
    accSagittal23CommaUp: {
      x_min: 0,
      x_max: 188,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 0 -517 l 45 -517 l 45 -4 b 68 -23 53 -17 60 -23 l 180 -23 b 225 -203 210 -23 225 -82 l 271 -203 b 206 68 271 -23 248 68 l 89 68 b 23 248 71 68 48 127 l 0 248 z"
    },
    accSagittal23CommaDown: {
      x_min: 0,
      x_max: 188,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 0 -248 l 23 -248 b 89 -68 48 -127 71 -68 l 206 -68 b 271 203 248 -68 271 23 l 225 203 b 180 23 225 82 210 23 l 68 23 b 45 4 60 23 53 17 l 45 517 l 0 517 z"
    },
    accSagittal5v19CommaUp: {
      x_min: 0,
      x_max: 156,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 0 -284 l 180 33 l 180 -517 l 225 -517 l 225 248 l 203 248 b 86 112 151 157 112 112 b 45 157 59 112 45 127 l 0 157 b 76 23 0 72 26 27 l 0 -112 z"
    },
    accSagittal5v19CommaDown: {
      x_min: 0,
      x_max: 156,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 0 112 l 76 -23 b 0 -157 26 -27 0 -72 l 45 -157 b 86 -112 45 -127 59 -112 b 203 -248 112 -112 151 -157 l 225 -248 l 225 517 l 180 517 l 180 -33 l 0 284 z"
    },
    accSagittal5v23SmallDiesisUp: {
      x_min: 0,
      x_max: 312,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 0 -284 l 180 33 l 180 -517 l 225 -517 l 225 -4 b 248 -23 233 -17 240 -23 l 360 -23 b 405 -203 390 -23 405 -82 l 449 -203 b 386 68 449 -23 428 68 l 271 68 b 203 248 251 68 228 127 l 0 -112 z"
    },
    accSagittal5v23SmallDiesisDown: {
      x_min: 0,
      x_max: 312,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 0 112 l 203 -248 b 271 -68 228 -127 251 -68 l 386 -68 b 449 203 428 -68 449 23 l 405 203 b 360 23 405 82 390 23 l 248 23 b 225 4 240 23 233 17 l 225 517 l 180 517 l 180 -33 l 0 284 z"
    },
    accSagittalSharp5v23SDown: {
      x_min: 0,
      x_max: 281,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 0 -517 l 45 -517 l 45 6 b 89 -23 59 -13 73 -23 l 180 -23 l 180 -517 l 225 -517 l 225 -23 l 292 -23 b 360 -203 337 -23 360 -84 l 405 -203 b 315 68 405 -23 374 68 l 112 68 b 23 248 78 68 48 127 l 0 248 z"
    },
    accSagittalFlat5v23SUp: {
      x_min: 0,
      x_max: 281,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 0 -248 l 23 -248 b 112 -68 48 -127 78 -68 l 315 -68 b 405 203 374 -68 405 23 l 360 203 b 292 23 360 84 337 23 l 225 23 l 225 517 l 180 517 l 180 23 l 89 23 b 45 -6 73 23 59 13 l 45 517 l 0 517 z"
    },
    accSagittalSharp5v19CDown: {
      x_min: 0,
      x_max: 312,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 0 68 b 89 -112 0 -52 30 -112 l 89 -517 l 135 -517 l 135 -95 b 225 112 173 -65 203 4 l 271 112 l 271 -517 l 315 -517 l 315 107 b 405 -68 374 89 405 30 l 405 -248 l 449 -248 l 449 68 b 315 248 449 189 405 248 l 203 248 b 101 0 173 98 138 16 b 81 -3 94 0 86 -3 b 45 68 56 -3 45 23 z"
    },
    accSagittalFlat5v19CUp: {
      x_min: 0,
      x_max: 312,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 45 -68 b 81 3 45 -23 56 3 b 101 0 86 3 94 0 b 203 -248 138 -16 173 -98 l 315 -248 b 449 -68 405 -248 449 -189 l 449 248 l 405 248 l 405 68 b 315 -107 405 -30 374 -89 l 315 517 l 271 517 l 271 -112 l 225 -112 b 135 95 203 -4 173 65 l 135 517 l 89 517 l 89 112 b 0 -68 30 112 0 52 z"
    },
    accSagittalSharp23CDown: {
      x_min: 0,
      x_max: 375,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 135 -82 l 135 -517 l 180 -517 l 180 -17 l 239 68 b 315 -23 261 7 287 -23 l 315 -517 l 360 -517 l 360 -23 l 428 -23 b 495 -203 472 -23 495 -84 l 540 -203 b 449 68 540 -23 510 68 l 337 68 b 248 248 302 68 271 127 l 0 -112 l 0 -276 z"
    },
    accSagittalFlat23CUp: {
      x_min: 0,
      x_max: 375,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 0 276 l 0 112 l 248 -248 b 337 -68 271 -127 302 -68 l 449 -68 b 540 203 510 -68 540 23 l 495 203 b 428 23 495 84 472 23 l 360 23 l 360 517 l 315 517 l 315 23 b 239 -68 287 23 261 -7 l 180 17 l 180 517 l 135 517 l 135 82 z"
    },
    accSagittalSharp23CUp: {
      x_min: 0,
      x_max: 344,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 0 -517 l 45 -517 l 45 14 b 112 -23 63 -10 86 -23 l 135 -23 l 135 -517 l 180 -517 l 180 -23 l 271 -23 l 271 -517 l 315 -517 l 315 -23 l 360 -23 b 449 -203 420 -23 449 -84 l 495 -203 b 383 68 495 -23 458 68 l 135 68 b 23 248 85 68 48 127 l 0 248 z"
    },
    accSagittalFlat23CDown: {
      x_min: 0,
      x_max: 344,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 0 -248 l 23 -248 b 135 -68 48 -127 85 -68 l 383 -68 b 495 203 458 -68 495 23 l 449 203 b 360 23 449 84 420 23 l 315 23 l 315 517 l 271 517 l 271 23 l 180 23 l 180 517 l 135 517 l 135 23 l 112 23 b 45 -14 86 23 63 10 l 45 517 l 0 517 z"
    },
    accSagittalSharp5v19CUp: {
      x_min: 0,
      x_max: 312,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 0 -112 l 0 -266 l 135 -153 l 135 -517 l 180 -517 l 180 -115 l 271 -39 l 271 -517 l 315 -517 l 315 0 l 405 75 l 405 -517 l 449 -517 l 449 248 l 428 248 b 130 68 285 127 186 68 b 45 157 73 68 45 98 l 0 157 b 112 -20 0 53 37 -6 z"
    },
    accSagittalFlat5v19CDown: {
      x_min: 0,
      x_max: 312,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 112 20 b 0 -157 37 6 0 -53 l 45 -157 b 130 -68 45 -98 73 -68 b 428 -248 186 -68 285 -127 l 449 -248 l 449 517 l 405 517 l 405 -75 l 315 0 l 315 517 l 271 517 l 271 39 l 180 115 l 180 517 l 135 517 l 135 153 l 0 266 l 0 112 z"
    },
    accSagittalSharp5v23SUp: {
      x_min: 0,
      x_max: 406,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 135 -108 l 135 -517 l 180 -517 l 180 -53 l 271 58 l 271 -517 l 315 -517 l 315 14 b 383 -23 334 -10 357 -23 l 405 -23 l 405 -517 l 449 -517 l 449 -23 b 540 -203 510 -23 540 -84 l 585 -203 b 472 68 585 -23 547 68 l 405 68 b 292 248 356 68 318 127 l 0 -112 l 0 -274 z"
    },
    accSagittalFlat5v23SDown: {
      x_min: 0,
      x_max: 406,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 0 274 l 0 112 l 292 -248 b 405 -68 318 -127 356 -68 l 472 -68 b 585 203 547 -68 585 23 l 540 203 b 449 23 540 84 510 23 l 449 517 l 405 517 l 405 23 l 383 23 b 315 -14 357 23 334 10 l 315 517 l 271 517 l 271 -58 l 180 53 l 180 517 l 135 517 l 135 108 z"
    },
    accSagittalDoubleSharp5v23SDown: {
      x_min: 0,
      x_max: 406,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 52 -517 l 203 -81 l 354 -517 l 405 -503 l 239 -23 l 449 -23 b 540 -203 510 -23 540 -84 l 585 -203 b 472 68 585 -23 547 68 l 225 68 b 112 248 176 68 138 127 l 89 248 l 89 112 b 170 -14 109 45 135 0 l 0 -501 z"
    },
    accSagittalDoubleFlat5v23SUp: {
      x_min: 0,
      x_max: 406,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 0 501 l 170 14 b 89 -112 135 0 109 -45 l 89 -248 l 112 -248 b 225 -68 138 -127 176 -68 l 472 -68 b 585 203 547 -68 585 23 l 540 203 b 449 23 540 84 510 23 l 239 23 l 405 503 l 354 517 l 203 81 l 52 517 z"
    },
    accSagittalDoubleSharp5v19CDown: {
      x_min: 0,
      x_max: 375,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 0 68 b 112 -112 0 -52 36 -112 b 193 -73 143 -112 170 -99 l 45 -501 l 95 -517 l 248 -81 l 397 -517 l 449 -501 l 275 0 l 315 112 b 495 -68 435 112 495 53 l 495 -248 l 540 -248 l 540 68 b 360 248 540 189 480 248 l 248 248 b 122 0 217 98 176 16 b 95 -3 112 0 104 -3 b 45 68 60 -3 45 20 z"
    },
    accSagittalDoubleFlat5v19CUp: {
      x_min: 0,
      x_max: 375,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 45 -68 b 95 3 45 -20 60 3 b 122 0 104 3 112 0 b 248 -248 176 -16 217 -98 l 360 -248 b 540 -68 480 -248 540 -189 l 540 248 l 495 248 l 495 68 b 315 -112 495 -53 435 -112 l 275 0 l 449 501 l 397 517 l 248 81 l 95 517 l 45 501 l 193 73 b 112 112 170 99 143 112 b 0 -68 36 112 0 52 z"
    },
    accSagittalDoubleSharp23CDown: {
      x_min: 0,
      x_max: 406,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 252 35 l 265 0 l 89 -503 l 141 -517 l 292 -82 l 444 -517 l 495 -503 l 321 0 l 323 4 b 383 -23 340 -13 360 -23 l 449 -23 b 540 -203 510 -23 540 -84 l 585 -203 b 472 68 585 -23 547 68 l 405 68 b 292 248 356 68 318 127 l 0 -112 l 0 -274 z"
    },
    accSagittalDoubleFlat23CUp: {
      x_min: 0,
      x_max: 406,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 0 274 l 0 112 l 292 -248 b 405 -68 318 -127 356 -68 l 472 -68 b 585 203 547 -68 585 23 l 540 203 b 449 23 540 84 510 23 l 383 23 b 323 -4 360 23 340 13 l 321 0 l 495 503 l 444 517 l 292 82 l 141 517 l 89 503 l 265 0 l 252 -35 z"
    },
    accSagittal19SchismaUp: {
      x_min: 0,
      x_max: 125,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 68 -112 b 135 -45 89 -112 112 -89 l 135 -517 l 180 -517 l 180 248 l 157 248 b 79 0 127 98 101 16 b 68 -3 73 0 68 -3 b 45 68 52 -3 45 20 l 0 68 b 68 -112 0 -52 23 -112 z"
    },
    accSagittal19SchismaDown: {
      x_min: 0,
      x_max: 125,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 68 112 b 0 -68 23 112 0 52 l 45 -68 b 68 3 45 -20 52 3 b 79 0 68 3 73 0 b 157 -248 101 -16 127 -98 l 180 -248 l 180 517 l 135 517 l 135 45 b 68 112 112 89 89 112 z"
    },
    accSagittal17KleismaUp: {
      x_min: 0,
      x_max: 156,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 45 -203 b 89 -23 45 -82 60 -23 l 157 -23 b 180 -4 164 -23 173 -17 l 180 -517 l 225 -517 l 225 248 l 203 248 b 135 68 177 127 154 68 l 68 68 b 0 -203 23 68 0 -23 z"
    },
    accSagittal17KleismaDown: {
      x_min: 0,
      x_max: 156,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 0 203 b 68 -68 0 23 23 -68 l 135 -68 b 203 -248 154 -68 177 -127 l 225 -248 l 225 517 l 180 517 l 180 4 b 157 23 173 17 164 23 l 89 23 b 45 203 60 23 45 82 z"
    },
    accSagittal143CommaUp: {
      x_min: 0,
      x_max: 156,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 0 -203 l 45 -203 b 89 -23 45 -82 60 -23 l 157 -23 b 180 -4 164 -23 173 -17 l 180 -517 l 225 -517 l 225 248 l 203 248 b 135 68 177 127 154 68 l 105 68 b 45 157 65 68 45 98 l 0 157 b 23 20 0 95 7 50 b 0 -203 7 -23 0 -98 z"
    },
    accSagittal143CommaDown: {
      x_min: 0,
      x_max: 156,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 0 203 b 23 -20 0 98 7 23 b 0 -157 7 -50 0 -95 l 45 -157 b 105 -68 45 -98 65 -68 l 135 -68 b 203 -248 154 -68 177 -127 l 225 -248 l 225 517 l 180 517 l 180 4 b 157 23 173 17 164 23 l 89 23 b 45 203 60 23 45 82 z"
    },
    accSagittal11v49CommaUp: {
      x_min: 0,
      x_max: 188,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 45 -292 b 89 -157 45 -203 60 -157 l 203 -157 b 225 -143 210 -157 217 -153 l 225 -517 l 271 -517 l 271 248 l 248 248 b 180 157 233 187 210 157 l 68 157 b 0 -68 23 157 0 82 l 45 -68 b 89 68 45 23 60 68 l 203 68 b 225 84 209 68 216 72 l 225 -36 b 180 -68 213 -58 199 -68 l 68 -68 b 0 -292 23 -68 0 -143 z"
    },
    accSagittal11v49CommaDown: {
      x_min: 0,
      x_max: 188,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 0 292 b 68 68 0 143 23 68 l 180 68 b 225 36 199 68 213 58 l 225 -84 b 203 -68 216 -72 209 -68 l 89 -68 b 45 68 60 -68 45 -23 l 0 68 b 68 -157 0 -82 23 -157 l 180 -157 b 248 -248 210 -157 233 -187 l 271 -248 l 271 517 l 225 517 l 225 143 b 203 157 217 153 210 157 l 89 157 b 45 292 60 157 45 203 z"
    },
    accSagittal19CommaUp: {
      x_min: 0,
      x_max: 281,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 0 68 b 68 -112 0 -52 23 -112 b 135 -45 89 -112 112 -89 l 135 -517 l 180 -517 l 180 -4 b 203 -23 187 -17 196 -23 l 315 -23 b 360 -203 346 -23 360 -82 l 405 -203 b 341 68 405 -23 383 68 l 225 68 b 157 248 206 68 183 127 b 79 0 127 98 101 16 b 68 -3 73 0 68 -3 b 45 68 52 -3 45 20 z"
    },
    accSagittal19CommaDown: {
      x_min: 0,
      x_max: 281,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 45 -68 b 68 3 45 -20 52 3 b 79 0 68 3 73 0 b 157 -248 101 -16 127 -98 b 225 -68 183 -127 206 -68 l 341 -68 b 405 203 383 -68 405 23 l 360 203 b 315 23 360 82 346 23 l 203 23 b 180 4 196 23 187 17 l 180 517 l 135 517 l 135 45 b 68 112 112 89 89 112 b 0 -68 23 112 0 52 z"
    },
    accSagittal7v19CommaUp: {
      x_min: 0,
      x_max: 250,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 0 68 b 68 -112 0 -52 23 -112 b 135 -45 89 -112 112 -89 l 135 -517 l 180 -517 l 180 112 l 225 112 b 315 -68 285 112 315 53 l 315 -248 l 360 -248 l 360 68 b 271 248 360 187 330 248 l 157 248 b 79 0 127 98 101 16 b 68 -3 73 0 68 -3 b 45 68 52 -3 45 20 z"
    },
    accSagittal7v19CommaDown: {
      x_min: 0,
      x_max: 250,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 45 -68 b 68 3 45 -20 52 3 b 79 0 68 3 73 0 b 157 -248 101 -16 127 -98 l 271 -248 b 360 -68 330 -248 360 -187 l 360 248 l 315 248 l 315 68 b 225 -112 315 -53 285 -112 l 180 -112 l 180 517 l 135 517 l 135 45 b 68 112 112 89 89 112 b 0 -68 23 112 0 52 z"
    },
    accSagittal49SmallDiesisUp: {
      x_min: 0,
      x_max: 281,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 0 -203 l 45 -203 b 89 -23 45 -82 60 -23 l 157 -23 b 180 -4 164 -23 173 -17 l 180 -517 l 225 -517 l 225 112 l 271 112 b 360 -68 330 112 360 53 l 360 -248 l 405 -248 l 405 68 b 315 248 405 187 374 248 l 203 248 b 135 68 177 127 154 68 l 68 68 b 0 -203 23 68 0 -23 z"
    },
    accSagittal49SmallDiesisDown: {
      x_min: 0,
      x_max: 281,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 0 203 b 68 -68 0 23 23 -68 l 135 -68 b 203 -248 154 -68 177 -127 l 315 -248 b 405 -68 374 -248 405 -187 l 405 248 l 360 248 l 360 68 b 271 -112 360 -53 330 -112 l 225 -112 l 225 517 l 180 517 l 180 4 b 157 23 173 17 164 23 l 89 23 b 45 203 60 23 45 82 z"
    },
    accSagittal23SmallDiesisUp: {
      x_min: 0,
      x_max: 344,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 45 -203 b 89 -23 45 -82 60 -23 l 157 -23 b 180 -4 164 -23 173 -17 l 180 -517 l 225 -517 l 225 58 l 495 -274 l 495 -112 l 203 248 b 135 68 177 127 154 68 l 68 68 b 0 -203 23 68 0 -23 z"
    },
    accSagittal23SmallDiesisDown: {
      x_min: 0,
      x_max: 344,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 0 203 b 68 -68 0 23 23 -68 l 135 -68 b 203 -248 154 -68 177 -127 l 495 112 l 495 274 l 225 -58 l 225 517 l 180 517 l 180 4 b 157 23 173 17 164 23 l 89 23 b 45 203 60 23 45 82 z"
    },
    accSagittal5v13MediumDiesisUp: {
      x_min: 0,
      x_max: 250,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 0 -259 l 315 -89 l 315 -517 l 360 -517 l 360 248 l 337 248 b 128 180 253 203 184 180 b 45 248 73 180 45 203 l 0 248 b 52 95 0 170 17 120 l 0 68 l 0 -33 l 315 135 l 315 10 l 0 -157 z"
    },
    accSagittal5v13MediumDiesisDown: {
      x_min: 0,
      x_max: 250,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 0 157 l 315 -10 l 315 -135 l 0 33 l 0 -68 l 52 -95 b 0 -248 17 -120 0 -170 l 45 -248 b 128 -180 45 -203 73 -180 b 337 -248 184 -180 253 -203 l 360 -248 l 360 517 l 315 517 l 315 89 l 0 259 z"
    },
    accSagittal11v19MediumDiesisUp: {
      x_min: 0,
      x_max: 344,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 45 -248 l 45 -68 b 180 112 45 53 89 112 l 225 112 l 225 -517 l 271 -517 l 271 -4 b 292 -23 278 -17 285 -23 l 405 -23 b 449 -203 435 -23 449 -82 l 495 -203 b 431 68 495 -23 472 68 l 315 68 b 248 248 295 68 271 127 l 135 248 b 0 68 45 248 0 187 l 0 -248 z"
    },
    accSagittal11v19MediumDiesisDown: {
      x_min: 0,
      x_max: 344,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 0 248 l 0 -68 b 135 -248 0 -187 45 -248 l 248 -248 b 315 -68 271 -127 295 -68 l 431 -68 b 495 203 472 -68 495 23 l 449 203 b 405 23 449 82 435 23 l 292 23 b 271 4 285 23 278 17 l 271 517 l 225 517 l 225 -112 l 180 -112 b 45 68 89 -112 45 -53 l 45 248 z"
    },
    accSagittal49MediumDiesisUp: {
      x_min: 0,
      x_max: 250,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 0 -68 l 0 -248 l 45 -248 l 315 -94 l 315 -517 l 360 -517 l 360 248 l 225 248 b 0 -68 75 248 0 143 z m 45 -68 b 225 112 45 53 105 112 l 315 112 l 315 10 l 45 -145 z"
    },
    accSagittal49MediumDiesisDown: {
      x_min: 0,
      x_max: 250,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 0 68 b 225 -248 0 -143 75 -248 l 360 -248 l 360 517 l 315 517 l 315 94 l 45 248 l 0 248 z m 45 145 l 315 -10 l 315 -112 l 225 -112 b 45 68 105 -112 45 -53 z"
    },
    accSagittal5v49MediumDiesisUp: {
      x_min: 0,
      x_max: 344,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 0 -89 l 0 -248 l 225 53 l 225 -517 l 271 -517 l 271 53 l 495 -248 l 495 -89 l 248 248 b 89 89 170 143 118 89 b 45 157 60 89 45 112 l 0 157 b 68 3 0 68 23 16 z"
    },
    accSagittal5v49MediumDiesisDown: {
      x_min: 0,
      x_max: 344,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 68 -3 b 0 -157 23 -16 0 -68 l 45 -157 b 89 -89 45 -112 60 -89 b 248 -248 118 -89 170 -143 l 495 89 l 495 248 l 271 -53 l 271 517 l 225 517 l 225 -53 l 0 248 l 0 89 z"
    },
    accSagittal49LargeDiesisUp: {
      x_min: 0,
      x_max: 281,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 0 -517 l 45 -517 l 45 -89 l 360 -248 l 405 -248 l 405 -68 b 180 248 405 143 330 248 l 0 248 z m 45 12 l 45 112 l 180 112 b 360 -68 300 112 360 53 l 360 -147 z"
    },
    accSagittal49LargeDiesisDown: {
      x_min: 0,
      x_max: 281,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 0 -248 l 180 -248 b 405 68 330 -248 405 -143 l 405 248 l 360 248 l 45 89 l 45 517 l 0 517 z m 360 147 l 360 68 b 180 -112 360 -53 300 -112 l 45 -112 l 45 -12 z"
    },
    accSagittal11v19LargeDiesisUp: {
      x_min: 0,
      x_max: 312,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 0 -517 l 45 -517 l 45 -86 l 449 -256 l 449 -157 l 45 13 l 45 138 l 449 -30 l 449 68 l 23 248 l 0 248 z"
    },
    accSagittal11v19LargeDiesisDown: {
      x_min: 0,
      x_max: 312,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 0 -248 l 23 -248 l 449 -68 l 449 30 l 45 -138 l 45 -13 l 449 157 l 449 256 l 45 86 l 45 517 l 0 517 z"
    },
    accSagittal5v13LargeDiesisUp: {
      x_min: 0,
      x_max: 438,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 0 68 b 89 -112 0 -52 30 -112 b 180 -35 125 -112 157 -86 l 180 -517 l 225 -517 l 225 -86 l 631 -256 l 631 -157 l 225 13 l 225 138 l 631 -30 l 631 68 l 203 248 b 101 0 173 98 138 16 b 81 -3 94 0 86 -3 b 45 68 56 -3 45 20 z"
    },
    accSagittal5v13LargeDiesisDown: {
      x_min: 0,
      x_max: 438,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 45 -68 b 81 3 45 -20 56 3 b 101 0 86 3 94 0 b 203 -248 138 -16 173 -98 l 631 -68 l 631 30 l 225 -138 l 225 -13 l 631 157 l 631 256 l 225 86 l 225 517 l 180 517 l 180 35 b 89 112 157 86 125 112 b 0 -68 30 112 0 52 z"
    },
    accSagittalSharp23SDown: {
      x_min: 0,
      x_max: 250,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 0 -203 l 45 -203 b 112 -23 45 -84 68 -23 l 135 -23 l 135 -517 l 180 -517 l 180 -23 l 271 -23 b 315 6 287 -23 301 -13 l 315 -517 l 360 -517 l 360 248 l 337 248 b 248 68 312 127 282 68 l 194 68 b 89 157 125 68 89 98 l 45 157 b 60 59 45 118 50 85 b 0 -203 20 30 0 -56 z"
    },
    accSagittalFlat23SUp: {
      x_min: 0,
      x_max: 250,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 0 203 b 60 -59 0 56 20 -30 b 45 -157 50 -85 45 -118 l 89 -157 b 194 -68 89 -98 125 -68 l 248 -68 b 337 -248 282 -68 312 -127 l 360 -248 l 360 517 l 315 517 l 315 -6 b 271 23 301 13 287 23 l 180 23 l 180 517 l 135 517 l 135 23 l 112 23 b 45 203 68 23 45 84 z"
    },
    accSagittalSharp49SDown: {
      x_min: 0,
      x_max: 250,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 0 -292 l 45 -292 b 112 -157 45 -203 68 -157 l 135 -157 l 135 -517 l 180 -517 l 180 -157 l 271 -157 b 315 -135 285 -157 300 -150 l 315 -517 l 360 -517 l 360 248 l 337 248 b 248 157 323 187 292 157 l 89 157 b 0 -68 30 157 0 82 l 45 -68 b 112 68 45 23 68 68 l 271 68 b 315 89 284 68 300 75 l 315 -32 b 248 -68 298 -56 275 -68 l 89 -68 b 0 -292 29 -68 0 -143 z"
    },
    accSagittalFlat49SUp: {
      x_min: 0,
      x_max: 250,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 0 292 b 89 68 0 143 29 68 l 248 68 b 315 32 275 68 298 56 l 315 -89 b 271 -68 300 -75 284 -68 l 112 -68 b 45 68 68 -68 45 -23 l 0 68 b 89 -157 0 -82 30 -157 l 248 -157 b 337 -248 292 -157 323 -187 l 360 -248 l 360 517 l 315 517 l 315 135 b 271 157 300 150 285 157 l 180 157 l 180 517 l 135 517 l 135 157 l 112 157 b 45 292 68 157 45 203 z"
    },
    accSagittalSharp7v19CDown: {
      x_min: 0,
      x_max: 250,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 0 -112 l 0 -271 l 135 -125 l 135 -517 l 180 -517 l 180 -78 l 315 65 l 315 -517 l 360 -517 l 360 248 l 337 248 b 118 89 239 143 166 89 b 45 157 68 89 45 112 l 0 157 b 89 -20 0 53 29 -6 z"
    },
    accSagittalFlat7v19CUp: {
      x_min: 0,
      x_max: 250,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 89 20 b 0 -157 29 6 0 -53 l 45 -157 b 118 -89 45 -112 68 -89 b 337 -248 166 -89 239 -143 l 360 -248 l 360 517 l 315 517 l 315 -65 l 180 78 l 180 517 l 135 517 l 135 125 l 0 271 l 0 112 z"
    },
    accSagittalSharp19CDown: {
      x_min: 0,
      x_max: 281,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 0 -248 l 45 -248 l 45 -68 b 180 96 45 17 89 72 l 180 -517 l 225 -517 l 225 107 b 315 112 252 112 282 112 l 360 112 l 360 -517 l 405 -517 l 405 248 l 271 248 b 0 68 89 248 0 187 z"
    },
    accSagittalFlat19CUp: {
      x_min: 0,
      x_max: 281,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 0 -68 b 271 -248 0 -187 89 -248 l 405 -248 l 405 517 l 360 517 l 360 -112 l 315 -112 b 225 -107 282 -112 252 -112 l 225 517 l 180 517 l 180 -96 b 45 68 89 -72 45 -17 l 45 248 l 0 248 z"
    },
    accSagittalSharp11v49CDown: {
      x_min: 0,
      x_max: 344,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 45 -203 b 112 -23 45 -82 68 -23 l 135 -23 l 135 -517 l 180 -517 l 180 -23 b 271 112 215 -23 245 23 l 315 112 l 315 -517 l 360 -517 l 360 107 b 449 -68 420 89 449 30 l 449 -248 l 495 -248 l 495 68 b 360 248 495 189 449 248 l 248 248 b 157 68 222 128 192 68 l 89 68 b 0 -203 30 68 0 -23 z"
    },
    accSagittalFlat11v49CUp: {
      x_min: 0,
      x_max: 344,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 0 203 b 89 -68 0 23 30 -68 l 157 -68 b 248 -248 192 -68 222 -128 l 360 -248 b 495 -68 449 -248 495 -189 l 495 248 l 449 248 l 449 68 b 360 -107 449 -30 420 -89 l 360 517 l 315 517 l 315 -112 l 271 -112 b 180 23 245 -23 215 23 l 180 517 l 135 517 l 135 23 l 112 23 b 45 203 68 23 45 82 z"
    },
    accSagittalSharp143CDown: {
      x_min: 0,
      x_max: 406,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 45 -203 b 112 -23 45 -84 68 -23 l 135 -23 l 135 -517 l 180 -517 l 180 -23 b 259 76 210 -23 236 10 l 315 17 l 315 -517 l 360 -517 l 360 -30 l 585 -271 l 585 -112 l 248 248 b 157 68 222 127 192 68 l 89 68 b 0 -203 30 68 0 -23 z"
    },
    accSagittalFlat143CUp: {
      x_min: 0,
      x_max: 406,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 0 203 b 89 -68 0 23 30 -68 l 157 -68 b 248 -248 192 -68 222 -127 l 585 112 l 585 271 l 360 30 l 360 517 l 315 517 l 315 -17 l 259 -76 b 180 23 236 -10 210 23 l 180 517 l 135 517 l 135 23 l 112 23 b 45 203 68 23 45 84 z"
    },
    accSagittalSharp17kDown: {
      x_min: 0,
      x_max: 312,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 0 -157 l 0 -256 l 225 -161 l 225 -517 l 271 -517 l 271 -144 l 405 -86 l 405 -517 l 449 -517 l 449 248 l 428 248 b 145 171 305 196 210 171 b 45 248 78 171 45 196 l 0 248 b 79 101 0 170 26 121 l 0 68 l 0 -32 l 405 138 l 405 13 z"
    },
    accSagittalFlat17kUp: {
      x_min: 0,
      x_max: 312,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 405 -13 l 405 -138 l 0 32 l 0 -68 l 79 -101 b 0 -248 26 -121 0 -170 l 45 -248 b 145 -171 45 -196 78 -171 b 428 -248 210 -171 305 -196 l 449 -248 l 449 517 l 405 517 l 405 86 l 271 144 l 271 517 l 225 517 l 225 161 l 0 256 l 0 157 z"
    },
    accSagittalSharp19sDown: {
      x_min: 0,
      x_max: 406,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 0 -248 l 45 -248 l 45 -68 b 180 109 45 36 89 95 l 180 -517 l 225 -517 l 225 112 l 271 112 b 360 -23 295 23 325 -23 l 360 -517 l 405 -517 l 405 -23 l 472 -23 b 540 -203 517 -23 540 -84 l 585 -203 b 495 68 585 -23 554 68 l 383 68 b 292 248 348 68 318 127 l 180 248 b 0 68 60 248 0 187 z"
    },
    accSagittalFlat19sUp: {
      x_min: 0,
      x_max: 406,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 0 -68 b 180 -248 0 -187 60 -248 l 292 -248 b 383 -68 318 -127 348 -68 l 495 -68 b 585 203 554 -68 585 23 l 540 203 b 472 23 540 84 517 23 l 405 23 l 405 517 l 360 517 l 360 23 b 271 -112 325 23 295 -23 l 225 -112 l 225 517 l 180 517 l 180 -109 b 45 68 89 -95 45 -36 l 45 248 l 0 248 z"
    },
    accSagittalSharp19sUp: {
      x_min: 0,
      x_max: 281,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 89 -96 l 89 -517 l 135 -517 l 135 -108 b 180 -112 148 -112 163 -112 b 225 -108 196 -112 210 -112 l 225 -517 l 271 -517 l 271 -94 b 360 -12 305 -78 337 -50 l 360 -517 l 405 -517 l 405 248 l 383 248 b 190 0 353 98 288 16 b 138 -3 171 0 153 -3 b 45 68 75 -3 45 20 l 0 68 b 89 -96 0 -17 30 -72 z"
    },
    accSagittalFlat19sDown: {
      x_min: 0,
      x_max: 281,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 89 96 b 0 -68 30 72 0 17 l 45 -68 b 138 3 45 -20 75 3 b 190 0 153 3 171 0 b 383 -248 288 -16 353 -98 l 405 -248 l 405 517 l 360 517 l 360 12 b 271 94 337 50 305 78 l 271 517 l 225 517 l 225 108 b 180 112 210 112 196 112 b 135 108 163 112 148 112 l 135 517 l 89 517 z"
    },
    accSagittalSharp17kUp: {
      x_min: 0,
      x_max: 312,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 45 -203 b 135 -23 45 -84 75 -23 l 135 -517 l 180 -517 l 180 -23 l 271 -23 l 271 -517 l 315 -517 l 315 -23 l 337 -23 b 405 14 363 -23 386 -10 l 405 -517 l 449 -517 l 449 248 l 428 248 b 315 68 402 127 364 68 l 112 68 b 0 -203 37 68 0 -23 z"
    },
    accSagittalFlat17kDown: {
      x_min: 0,
      x_max: 312,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 0 203 b 112 -68 0 23 37 -68 l 315 -68 b 428 -248 364 -68 402 -127 l 449 -248 l 449 517 l 405 517 l 405 -14 b 337 23 386 10 363 23 l 315 23 l 315 517 l 271 517 l 271 23 l 180 23 l 180 517 l 135 517 l 135 23 b 45 203 75 23 45 84 z"
    },
    accSagittalSharp143CUp: {
      x_min: 0,
      x_max: 312,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 45 -203 b 135 -23 45 -84 75 -23 l 135 -517 l 180 -517 l 180 -23 l 271 -23 l 271 -517 l 315 -517 l 315 -23 l 337 -23 b 405 14 363 -23 386 -10 l 405 -517 l 449 -517 l 449 248 l 428 248 b 315 68 402 127 364 68 l 240 68 b 89 157 140 68 89 98 l 45 157 b 68 53 45 115 52 81 b 0 -203 23 23 0 -63 z"
    },
    accSagittalFlat143CDown: {
      x_min: 0,
      x_max: 312,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 0 203 b 68 -53 0 63 23 -23 b 45 -157 52 -81 45 -115 l 89 -157 b 240 -68 89 -98 140 -68 l 315 -68 b 428 -248 364 -68 402 -127 l 449 -248 l 449 517 l 405 517 l 405 -14 b 337 23 386 10 363 23 l 315 23 l 315 517 l 271 517 l 271 23 l 180 23 l 180 517 l 135 517 l 135 23 b 45 203 75 23 45 84 z"
    },
    accSagittalSharp11v49CUp: {
      x_min: 0,
      x_max: 312,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 45 -68 b 135 68 45 23 76 68 l 337 68 b 405 95 363 68 386 76 l 405 -27 b 315 -68 386 -55 356 -68 l 112 -68 b 0 -292 37 -68 0 -143 l 45 -292 b 135 -157 45 -203 75 -157 l 135 -517 l 180 -517 l 180 -157 l 271 -157 l 271 -517 l 315 -517 l 315 -157 l 337 -157 b 405 -130 360 -157 383 -148 l 405 -517 l 449 -517 l 449 248 l 428 248 b 315 157 413 187 376 157 l 112 157 b 0 -68 37 157 0 82 z"
    },
    accSagittalFlat11v49CDown: {
      x_min: 0,
      x_max: 312,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 0 68 b 112 -157 0 -82 37 -157 l 315 -157 b 428 -248 376 -157 413 -187 l 449 -248 l 449 517 l 405 517 l 405 130 b 337 157 383 148 360 157 l 315 157 l 315 517 l 271 517 l 271 157 l 180 157 l 180 517 l 135 517 l 135 157 b 45 292 75 157 45 203 l 0 292 b 112 68 0 143 37 68 l 315 68 b 405 27 356 68 386 55 l 405 -95 b 337 -68 386 -76 363 -68 l 135 -68 b 45 68 76 -68 45 -23 z"
    },
    accSagittalSharp19CUp: {
      x_min: 0,
      x_max: 375,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 89 -109 l 89 -517 l 135 -517 l 135 -109 b 225 -27 170 -102 200 -75 l 225 -517 l 271 -517 l 271 14 b 337 -23 289 -10 311 -23 l 360 -23 l 360 -517 l 405 -517 l 405 -23 b 495 -203 465 -23 495 -82 l 540 -203 b 428 68 540 -23 503 68 l 360 68 b 248 248 310 68 271 128 b 122 0 217 98 176 16 b 95 -3 112 0 104 -3 b 45 68 60 -3 45 20 l 0 68 b 89 -109 0 -39 30 -98 z"
    },
    accSagittalFlat19CDown: {
      x_min: 0,
      x_max: 375,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 89 109 b 0 -68 30 98 0 39 l 45 -68 b 95 3 45 -20 60 3 b 122 0 104 3 112 0 b 248 -248 176 -16 217 -98 b 360 -68 271 -128 310 -68 l 428 -68 b 540 203 503 -68 540 23 l 495 203 b 405 23 495 82 465 23 l 405 517 l 360 517 l 360 23 l 337 23 b 271 -14 311 23 289 10 l 271 517 l 225 517 l 225 27 b 135 109 200 75 170 102 l 135 517 l 89 517 z"
    },
    accSagittalSharp7v19CUp: {
      x_min: 0,
      x_max: 375,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 89 -109 l 89 -517 l 135 -517 l 135 -109 b 225 -27 170 -102 200 -75 l 225 -517 l 271 -517 l 271 112 l 315 112 b 360 109 331 112 346 112 l 360 -517 l 405 -517 l 405 98 b 495 -68 465 73 495 19 l 495 -248 l 540 -248 l 540 68 b 360 248 540 189 480 248 l 248 248 b 122 0 217 98 176 16 b 95 -3 112 0 104 -3 b 45 68 60 -3 45 20 l 0 68 b 89 -109 0 -39 30 -98 z"
    },
    accSagittalFlat7v19CDown: {
      x_min: 0,
      x_max: 375,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 89 109 b 0 -68 30 98 0 39 l 45 -68 b 95 3 45 -20 60 3 b 122 0 104 3 112 0 b 248 -248 176 -16 217 -98 l 360 -248 b 540 -68 480 -248 540 -189 l 540 248 l 495 248 l 495 68 b 405 -98 495 -19 465 -73 l 405 517 l 360 517 l 360 -109 b 315 -112 346 -112 331 -112 l 271 -112 l 271 517 l 225 517 l 225 27 b 135 109 200 75 170 102 l 135 517 l 89 517 z"
    },
    accSagittalSharp49SUp: {
      x_min: 0,
      x_max: 406,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 45 -203 b 135 -23 45 -84 75 -23 l 135 -517 l 180 -517 l 180 -23 l 203 -23 b 271 14 229 -23 251 -10 l 271 -517 l 315 -517 l 315 112 l 360 112 b 405 109 376 112 390 112 l 405 -517 l 449 -517 l 449 96 b 540 -68 510 72 540 17 l 540 -248 l 585 -248 l 585 68 b 405 248 585 187 526 248 l 292 248 b 180 68 268 127 230 68 l 112 68 b 0 -203 37 68 0 -23 z"
    },
    accSagittalFlat49SDown: {
      x_min: 0,
      x_max: 406,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 0 203 b 112 -68 0 23 37 -68 l 180 -68 b 292 -248 230 -68 268 -127 l 405 -248 b 585 -68 526 -248 585 -187 l 585 248 l 540 248 l 540 68 b 449 -96 540 -17 510 -72 l 449 517 l 405 517 l 405 -109 b 360 -112 390 -112 376 -112 l 315 -112 l 315 517 l 271 517 l 271 -14 b 203 23 251 10 229 23 l 180 23 l 180 517 l 135 517 l 135 23 b 45 203 75 23 45 84 z"
    },
    accSagittalSharp23SUp: {
      x_min: 0,
      x_max: 469,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 45 -203 b 135 -23 45 -84 75 -23 l 135 -517 l 180 -517 l 180 -23 l 203 -23 b 271 14 229 -23 251 -10 l 271 -517 l 315 -517 l 315 71 l 405 -14 l 405 -517 l 449 -517 l 449 -56 l 675 -268 l 675 -112 l 292 248 b 180 68 268 127 230 68 l 112 68 b 0 -203 37 68 0 -23 z"
    },
    accSagittalFlat23SDown: {
      x_min: 0,
      x_max: 469,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 0 203 b 112 -68 0 23 37 -68 l 180 -68 b 292 -248 230 -68 268 -127 l 675 112 l 675 268 l 449 56 l 449 517 l 405 517 l 405 14 l 315 -71 l 315 517 l 271 517 l 271 -14 b 203 23 251 10 229 23 l 180 23 l 180 517 l 135 517 l 135 23 b 45 203 75 23 45 84 z"
    },
    accSagittalSharp5v13MUp: {
      x_min: 0,
      x_max: 375,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 495 141 l 495 14 l 0 -157 l 0 -256 l 225 -180 l 225 -517 l 271 -517 l 271 -161 l 360 -130 l 360 -517 l 405 -517 l 405 -115 l 495 -84 l 495 -517 l 540 -517 l 540 248 l 517 248 b 167 168 366 194 248 168 b 45 248 85 168 45 194 l 0 248 b 95 99 0 170 30 120 l 0 68 l 0 -30 z"
    },
    accSagittalFlat5v13MDown: {
      x_min: 0,
      x_max: 375,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 0 30 l 0 -68 l 95 -99 b 0 -248 30 -120 0 -170 l 45 -248 b 167 -168 45 -194 85 -168 b 517 -248 248 -168 366 -194 l 540 -248 l 540 517 l 495 517 l 495 84 l 405 115 l 405 517 l 360 517 l 360 130 l 271 161 l 271 517 l 225 517 l 225 180 l 0 256 l 0 157 l 495 -14 l 495 -141 z"
    },
    accSagittalSharp11v19MUp: {
      x_min: 0,
      x_max: 438,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 0 68 l 0 -248 l 45 -248 l 45 -68 b 180 104 45 26 89 82 l 180 -517 l 225 -517 l 225 112 l 315 112 l 315 -517 l 360 -517 l 360 14 b 428 -23 379 -10 402 -23 l 449 -23 l 449 -517 l 495 -517 l 495 -23 b 585 -203 554 -23 585 -84 l 631 -203 b 517 68 631 -23 593 68 l 449 68 b 337 248 400 68 363 127 l 225 248 b 0 68 75 248 0 187 z"
    },
    accSagittalFlat11v19MDown: {
      x_min: 0,
      x_max: 438,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 0 -68 b 225 -248 0 -187 75 -248 l 337 -248 b 449 -68 363 -127 400 -68 l 517 -68 b 631 203 593 -68 631 23 l 585 203 b 495 23 585 84 554 23 l 495 517 l 449 517 l 449 23 l 428 23 b 360 -14 402 23 379 10 l 360 517 l 315 517 l 315 -112 l 225 -112 l 225 517 l 180 517 l 180 -104 b 45 68 89 -82 45 -26 l 45 248 l 0 248 z"
    },
    accSagittalSharp49MUp: {
      x_min: 0,
      x_max: 375,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 0 -248 l 45 -248 l 225 -180 l 225 -517 l 271 -517 l 271 -166 l 360 -132 l 360 -517 l 405 -517 l 405 -117 l 495 -84 l 495 -517 l 540 -517 l 540 248 l 360 248 b 0 -68 120 248 0 143 z m 45 -145 l 45 -68 b 360 112 45 53 150 112 l 495 112 l 495 14 z"
    },
    accSagittalFlat49MDown: {
      x_min: 0,
      x_max: 375,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 0 68 b 360 -248 0 -143 120 -248 l 540 -248 l 540 517 l 495 517 l 495 84 l 405 117 l 405 517 l 360 517 l 360 132 l 271 166 l 271 517 l 225 517 l 225 180 l 45 248 l 0 248 z m 495 -14 l 495 -112 l 360 -112 b 45 68 150 -112 45 -53 l 45 145 z"
    },
    accSagittalSharp5v49MUp: {
      x_min: 0,
      x_max: 469,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 0 -271 l 180 -79 l 180 -517 l 225 -517 l 225 -30 l 315 65 l 315 -517 l 360 -517 l 360 65 l 449 -30 l 449 -517 l 495 -517 l 495 -79 l 675 -271 l 675 -112 l 337 248 b 118 89 239 143 166 89 b 45 157 68 89 45 112 l 0 157 b 107 0 0 62 36 10 l 0 -112 z"
    },
    accSagittalFlat5v49MDown: {
      x_min: 0,
      x_max: 469,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 0 112 l 107 0 b 0 -157 36 -10 0 -62 l 45 -157 b 118 -89 45 -112 68 -89 b 337 -248 166 -89 239 -143 l 675 112 l 675 271 l 495 79 l 495 517 l 449 517 l 449 30 l 360 -65 l 360 517 l 315 517 l 315 -65 l 225 30 l 225 517 l 180 517 l 180 79 l 0 271 z"
    },
    accSagittalSharp49LUp: {
      x_min: 0,
      x_max: 406,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 0 -517 l 45 -517 l 45 -82 l 135 -112 l 135 -517 l 180 -517 l 180 -127 l 271 -157 l 271 -517 l 315 -517 l 315 -173 l 540 -248 l 585 -248 l 585 -68 b 180 248 585 143 449 248 l 0 248 z m 45 112 l 180 112 b 540 -68 420 112 540 53 l 540 -145 l 45 16 z"
    },
    accSagittalFlat49LDown: {
      x_min: 0,
      x_max: 406,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 0 -248 l 180 -248 b 585 68 449 -248 585 -143 l 585 248 l 540 248 l 315 173 l 315 517 l 271 517 l 271 157 l 180 127 l 180 517 l 135 517 l 135 112 l 45 82 l 45 517 l 0 517 z m 45 -16 l 540 145 l 540 68 b 180 -112 540 -53 420 -112 l 45 -112 z"
    },
    accSagittalSharp11v19LUp: {
      x_min: 0,
      x_max: 438,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 0 -517 l 45 -517 l 45 -81 l 135 -108 l 135 -517 l 180 -517 l 180 -121 l 271 -148 l 271 -517 l 315 -517 l 315 -161 l 631 -255 l 631 -157 l 45 16 l 45 144 l 631 -30 l 631 68 l 23 248 l 0 248 z"
    },
    accSagittalFlat11v19LDown: {
      x_min: 0,
      x_max: 438,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 0 -248 l 23 -248 l 631 -68 l 631 30 l 45 -144 l 45 -16 l 631 157 l 631 255 l 315 161 l 315 517 l 271 517 l 271 148 l 180 121 l 180 517 l 135 517 l 135 108 l 45 81 l 45 517 l 0 517 z"
    },
    accSagittalSharp5v13LUp: {
      x_min: 0,
      x_max: 500,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 89 -109 l 89 -517 l 135 -517 l 135 -109 b 225 -27 170 -102 200 -75 l 225 -517 l 271 -517 l 271 -85 l 360 -120 l 360 -517 l 405 -517 l 405 -135 l 720 -256 l 720 -157 l 271 14 l 271 141 l 720 -30 l 720 68 l 248 248 b 122 0 217 98 176 16 b 95 -3 112 0 104 -3 b 45 68 60 -3 45 20 l 0 68 b 89 -109 0 -39 30 -98 z"
    },
    accSagittalFlat5v13LDown: {
      x_min: 0,
      x_max: 500,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 89 109 b 0 -68 30 98 0 39 l 45 -68 b 95 3 45 -20 60 3 b 122 0 104 3 112 0 b 248 -248 176 -16 217 -98 l 720 -68 l 720 30 l 271 -141 l 271 -14 l 720 157 l 720 256 l 405 135 l 405 517 l 360 517 l 360 120 l 271 85 l 271 517 l 225 517 l 225 27 b 135 109 200 75 170 102 l 135 517 l 89 517 z"
    },
    accSagittalDoubleSharp23SDown: {
      x_min: 0,
      x_max: 375,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 0 -203 l 45 -203 b 135 -23 45 -82 76 -23 l 301 -23 l 135 -503 l 186 -517 l 337 -82 l 488 -517 l 540 -503 l 370 -14 b 449 112 423 10 449 53 l 449 248 l 428 248 b 315 68 402 127 364 68 l 240 68 b 89 157 140 68 89 98 l 45 157 b 68 53 45 115 52 81 b 0 -203 23 23 0 -63 z"
    },
    accSagittalDoubleFlat23SUp: {
      x_min: 0,
      x_max: 375,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 0 203 b 68 -53 0 63 23 -23 b 45 -157 52 -81 45 -115 l 89 -157 b 240 -68 89 -98 140 -68 l 315 -68 b 428 -248 364 -68 402 -127 l 449 -248 l 449 -112 b 370 14 449 -53 423 -10 l 540 503 l 488 517 l 337 82 l 186 517 l 135 503 l 301 23 l 135 23 b 45 203 76 23 45 82 z"
    },
    accSagittalDoubleSharp49SDown: {
      x_min: 0,
      x_max: 375,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 0 -292 l 45 -292 b 112 -157 45 -203 68 -157 l 256 -157 l 135 -503 l 187 -517 l 337 -82 l 490 -517 l 540 -503 l 366 0 l 396 89 b 449 157 416 102 435 125 l 449 248 l 428 248 b 315 157 413 187 376 157 l 112 157 b 0 -68 39 157 0 82 l 45 -68 b 135 68 45 23 76 68 l 287 68 l 311 0 l 288 -68 l 89 -68 b 0 -292 32 -68 0 -144 z"
    },
    accSagittalDoubleFlat49SUp: {
      x_min: 0,
      x_max: 375,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 0 292 b 89 68 0 144 32 68 l 288 68 l 311 0 l 287 -68 l 135 -68 b 45 68 76 -68 45 -23 l 0 68 b 112 -157 0 -82 39 -157 l 315 -157 b 428 -248 376 -157 413 -187 l 449 -248 l 449 -157 b 396 -89 435 -125 416 -102 l 366 0 l 540 503 l 490 517 l 337 82 l 187 517 l 135 503 l 256 157 l 112 157 b 45 292 68 157 45 203 z"
    },
    accSagittalDoubleSharp7v19CDown: {
      x_min: 0,
      x_max: 375,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 0 -112 l 0 -266 l 307 -7 l 135 -503 l 186 -517 l 337 -82 l 488 -517 l 540 -503 l 366 0 l 386 59 l 449 112 l 449 248 l 428 248 b 130 68 285 127 186 68 b 45 157 73 68 45 98 l 0 157 b 112 -20 0 53 37 -6 z"
    },
    accSagittalDoubleFlat7v19CUp: {
      x_min: 0,
      x_max: 375,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 112 20 b 0 -157 37 6 0 -53 l 45 -157 b 130 -68 45 -98 73 -68 b 428 -248 186 -68 285 -127 l 449 -248 l 449 -112 l 386 -59 l 366 0 l 540 503 l 488 517 l 337 82 l 186 517 l 135 503 l 307 7 l 0 266 l 0 112 z"
    },
    accSagittalDoubleSharp19CDown: {
      x_min: 0,
      x_max: 406,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 0 68 l 0 -248 l 45 -248 l 45 -68 b 315 109 45 36 135 95 l 354 0 l 180 -503 l 232 -517 l 383 -82 l 534 -517 l 585 -503 l 410 0 l 449 112 l 495 112 l 495 248 l 360 248 b 0 68 120 248 0 187 z m 372 112 l 393 112 l 383 82 z"
    },
    accSagittalDoubleFlat19CUp: {
      x_min: 0,
      x_max: 406,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 0 -68 b 360 -248 0 -187 120 -248 l 495 -248 l 495 -112 l 449 -112 l 410 0 l 585 503 l 534 517 l 383 82 l 232 517 l 180 503 l 354 0 l 315 -109 b 45 68 135 -95 45 -36 l 45 248 l 0 248 z m 383 -82 l 393 -112 l 372 -112 z"
    },
    accSagittalDoubleSharp11v49CDown: {
      x_min: 0,
      x_max: 406,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 45 -203 b 135 -23 45 -84 75 -23 l 203 -23 b 262 4 225 -23 245 -13 l 265 0 l 89 -503 l 141 -517 l 292 -82 l 444 -517 l 495 -503 l 321 0 l 360 112 b 540 -68 480 112 540 53 l 540 -248 l 585 -248 l 585 68 b 405 248 585 187 526 248 l 292 248 b 180 68 268 127 230 68 l 112 68 b 0 -203 37 68 0 -23 z"
    },
    accSagittalDoubleFlat11v49CUp: {
      x_min: 0,
      x_max: 406,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 0 203 b 112 -68 0 23 37 -68 l 180 -68 b 292 -248 230 -68 268 -127 l 405 -248 b 585 -68 526 -248 585 -187 l 585 248 l 540 248 l 540 68 b 360 -112 540 -53 480 -112 l 321 0 l 495 503 l 444 517 l 292 82 l 141 517 l 89 503 l 265 0 l 262 -4 b 203 23 245 13 225 23 l 135 23 b 45 203 75 23 45 84 z"
    },
    accSagittalDoubleSharp143CDown: {
      x_min: 0,
      x_max: 469,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 45 -203 b 135 -23 45 -84 75 -23 l 203 -23 b 262 4 225 -23 245 -13 l 265 0 l 89 -503 l 141 -517 l 292 -82 l 444 -517 l 495 -503 l 321 0 l 337 49 l 675 -268 l 675 -112 l 292 248 b 180 68 268 127 230 68 l 112 68 b 0 -203 37 68 0 -23 z"
    },
    accSagittalDoubleFlat143CUp: {
      x_min: 0,
      x_max: 469,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 0 203 b 112 -68 0 23 37 -68 l 180 -68 b 292 -248 230 -68 268 -127 l 675 112 l 675 268 l 337 -49 l 321 0 l 495 503 l 444 517 l 292 82 l 141 517 l 89 503 l 265 0 l 262 -4 b 203 23 245 13 225 23 l 135 23 b 45 203 75 23 45 84 z"
    },
    accSagittalDoubleSharp17kDown: {
      x_min: 0,
      x_max: 438,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 0 248 b 95 101 0 170 30 121 l 0 68 l 0 -30 l 364 96 l 399 0 l 390 -23 l 0 -157 l 0 -255 l 353 -135 l 225 -503 l 275 -517 l 428 -82 l 577 -517 l 631 -503 l 455 0 l 507 145 l 540 157 l 540 248 l 517 248 b 167 168 366 194 248 168 b 45 248 85 168 45 194 z m 416 115 l 442 124 l 428 82 z"
    },
    accSagittalDoubleFlat17kUp: {
      x_min: 0,
      x_max: 438,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 45 -248 b 167 -168 45 -194 85 -168 b 517 -248 248 -168 366 -194 l 540 -248 l 540 -157 l 507 -145 l 455 0 l 631 503 l 577 517 l 428 82 l 275 517 l 225 503 l 353 135 l 0 255 l 0 157 l 390 23 l 399 0 l 364 -96 l 0 30 l 0 -68 l 95 -101 b 0 -248 30 -121 0 -170 z m 428 -82 l 442 -124 l 416 -115 z"
    },
    accSagittalDoubleSharp19sDown: {
      x_min: 0,
      x_max: 438,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 0 -248 l 45 -248 l 45 -68 b 271 112 45 53 120 112 l 310 0 l 135 -503 l 186 -517 l 337 -82 l 488 -517 l 540 -503 l 366 0 l 367 4 b 428 -23 386 -13 405 -23 l 495 -23 b 585 -203 554 -23 585 -84 l 631 -203 b 517 68 631 -23 593 68 l 449 68 b 337 248 400 68 363 127 l 225 248 b 0 68 75 248 0 187 z"
    },
    accSagittalDoubleFlat19sUp: {
      x_min: 0,
      x_max: 438,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 0 -68 b 225 -248 0 -187 75 -248 l 337 -248 b 449 -68 363 -127 400 -68 l 517 -68 b 631 203 593 -68 631 23 l 585 203 b 495 23 585 84 554 23 l 428 23 b 367 -4 405 23 386 13 l 366 0 l 540 503 l 488 517 l 337 82 l 186 517 l 135 503 l 310 0 l 271 -112 b 45 68 120 -112 45 -53 l 45 248 l 0 248 z"
    },
    accSagittalShaftUp: {
      x_min: 0,
      x_max: 31,
      y_min: -359,
      y_max: 172,
      ha: 531,
      o: "m 0 112 l 0 -517 l 45 -517 l 45 112 l 23 248 z"
    },
    accSagittalShaftDown: {
      x_min: 0,
      x_max: 31,
      y_min: -172,
      y_max: 359,
      ha: 531,
      o: "m 23 -248 l 45 -112 l 45 517 l 0 517 l 0 -112 z"
    },
    accSagittalAcute: {
      x_min: 0,
      x_max: 125,
      y_min: -62,
      y_max: 125,
      ha: 187,
      o: "m 0 0 l 0 -89 l 180 89 l 180 180 z"
    },
    accSagittalGrave: {
      x_min: 0,
      x_max: 125,
      y_min: -125,
      y_max: 62,
      ha: 187,
      o: "m 180 -180 l 180 -89 l 0 89 l 0 0 z"
    },
    accSagittal1MinaUp: {
      x_min: -7,
      x_max: 124,
      y_min: 16,
      y_max: 106,
      ha: 90,
      o: "m -10 23 l 43 23 b 72 65 43 23 65 55 b 117 107 88 86 105 107 b 135 23 128 107 137 86 l 179 23 b 134 150 179 112 163 135 b 68 130 117 158 85 150 b -10 23 43 101 13 58 z"
    },
    accSagittal1MinaDown: {
      x_min: -7,
      x_max: 124,
      y_min: -106,
      y_max: -16,
      ha: 90,
      o: "m -10 -23 b 68 -130 13 -58 43 -101 b 134 -150 85 -150 117 -158 b 179 -23 163 -135 179 -112 l 135 -23 b 117 -107 137 -86 128 -107 b 72 -65 105 -107 88 -86 b 43 -23 65 -55 43 -23 z"
    },
    accSagittal2MinasUp: {
      x_min: -7,
      x_max: 218,
      y_min: 16,
      y_max: 106,
      ha: 90,
      o: "m -10 23 l 43 23 b 72 65 43 23 65 55 b 117 107 88 86 105 107 b 135 23 128 107 137 86 l 179 23 b 207 65 179 23 200 55 b 252 107 223 86 240 107 b 271 23 264 107 272 86 l 314 23 b 269 150 314 112 298 135 b 203 130 252 158 220 150 b 173 92 190 115 181 104 b 134 150 167 127 154 140 b 68 130 117 158 85 150 b -10 23 43 101 13 58 z"
    },
    accSagittal2MinasDown: {
      x_min: -7,
      x_max: 218,
      y_min: -106,
      y_max: -16,
      ha: 90,
      o: "m -10 -23 b 68 -130 13 -58 43 -101 b 134 -150 85 -150 117 -158 b 173 -92 154 -140 167 -127 b 203 -130 181 -104 190 -115 b 269 -150 220 -150 252 -158 b 314 -23 298 -135 314 -112 l 271 -23 b 252 -107 272 -86 264 -107 b 207 -65 240 -107 223 -86 b 179 -23 200 -55 179 -23 l 135 -23 b 117 -107 137 -86 128 -107 b 72 -65 105 -107 88 -86 b 43 -23 65 -55 43 -23 z"
    },
    accSagittal1TinaUp: {
      x_min: 0,
      x_max: 93,
      y_min: 16,
      y_max: 107,
      ha: 91,
      o: "m 134 154 l 91 154 b 81 76 91 101 91 86 b 0 68 73 69 48 68 l 0 23 b 134 154 122 23 134 36 z"
    },
    accSagittal1TinaDown: {
      x_min: 0,
      x_max: 93,
      y_min: -107,
      y_max: -16,
      ha: 91,
      o: "m 134 -154 b 0 -23 134 -36 122 -23 l 0 -68 b 81 -76 48 -68 73 -69 b 91 -154 91 -86 91 -101 z"
    },
    accSagittal2TinasUp: {
      x_min: 0,
      x_max: 94,
      y_min: 16,
      y_max: 107,
      ha: 91,
      o: "m 135 68 b 89 154 94 68 89 124 l 46 154 b 36 92 45 131 42 105 b 0 68 32 82 23 68 l 0 23 b 68 63 29 23 53 40 b 135 23 84 39 104 23 z"
    },
    accSagittal2TinasDown: {
      x_min: 0,
      x_max: 94,
      y_min: -107,
      y_max: -16,
      ha: 91,
      o: "m 135 -23 b 68 -63 104 -23 84 -39 b 0 -23 53 -40 29 -23 l 0 -68 b 36 -92 23 -68 32 -82 b 46 -154 42 -105 45 -131 l 89 -154 b 135 -68 89 -124 94 -68 z"
    },
    accSagittal3TinasUp: {
      x_min: -7,
      x_max: 124,
      y_min: 16,
      y_max: 106,
      ha: 90,
      o: "m -10 23 l 43 23 b 72 65 43 23 65 55 b 117 107 88 86 105 107 b 135 23 128 107 137 86 l 179 23 b 134 150 179 112 163 135 b 68 130 117 158 85 150 b -10 23 43 101 13 58 z"
    },
    accSagittal3TinasDown: {
      x_min: -7,
      x_max: 124,
      y_min: -106,
      y_max: -16,
      ha: 90,
      o: "m -10 -23 b 68 -130 13 -58 43 -101 b 134 -150 85 -150 117 -158 b 179 -23 163 -135 179 -112 l 135 -23 b 117 -107 137 -86 128 -107 b 72 -65 105 -107 88 -86 b 43 -23 65 -55 43 -23 z"
    },
    accSagittal4TinasUp: {
      x_min: 0,
      x_max: 187,
      y_min: 16,
      y_max: 107,
      ha: 91,
      o: "m 0 68 l 0 23 b 143 45 105 23 124 26 b 203 107 153 55 183 107 b 226 23 216 107 226 86 l 269 23 b 225 150 269 112 253 135 b 160 132 207 158 181 153 b 115 81 138 112 124 88 b 0 68 104 71 94 68 z"
    },
    accSagittal4TinasDown: {
      x_min: 0,
      x_max: 187,
      y_min: -107,
      y_max: -16,
      ha: 91,
      o: "m 0 -68 b 115 -81 94 -68 104 -71 b 160 -132 124 -88 138 -112 b 225 -150 181 -153 207 -158 b 269 -23 253 -135 269 -112 l 226 -23 b 203 -107 226 -86 216 -107 b 143 -45 183 -107 153 -55 b 0 -23 124 -26 105 -23 z"
    },
    accSagittal5TinasUp: {
      x_min: 0,
      x_max: 218,
      y_min: 16,
      y_max: 107,
      ha: 91,
      o: "m 135 23 b 187 45 156 23 168 26 b 249 107 197 55 228 107 b 271 23 262 107 271 86 l 314 23 b 269 150 314 112 298 135 b 204 132 252 158 226 153 b 160 81 183 112 168 88 b 135 68 148 71 147 68 b 89 154 94 68 89 124 l 46 154 b 36 92 45 131 42 105 b 0 68 32 82 23 68 l 0 23 b 68 63 29 23 53 40 b 135 23 84 39 104 23 z"
    },
    accSagittal5TinasDown: {
      x_min: 0,
      x_max: 218,
      y_min: -107,
      y_max: -16,
      ha: 91,
      o: "m 135 -23 b 68 -63 104 -23 84 -39 b 0 -23 53 -40 29 -23 l 0 -68 b 36 -92 23 -68 32 -82 b 46 -154 42 -105 45 -131 l 89 -154 b 135 -68 89 -124 94 -68 b 160 -81 147 -68 148 -71 b 204 -132 168 -88 183 -112 b 269 -150 226 -153 252 -158 b 314 -23 298 -135 314 -112 l 271 -23 b 249 -107 271 -86 262 -107 b 187 -45 228 -107 197 -55 b 135 -23 168 -26 156 -23 z"
    },
    accSagittal6TinasUp: {
      x_min: -7,
      x_max: 218,
      y_min: 16,
      y_max: 106,
      ha: 90,
      o: "m -10 23 l 43 23 b 72 65 43 23 65 55 b 117 107 88 86 105 107 b 135 23 128 107 137 86 l 179 23 b 207 65 179 23 200 55 b 252 107 223 86 240 107 b 271 23 264 107 272 86 l 314 23 b 269 150 314 112 298 135 b 203 130 252 158 220 150 b 173 92 190 115 181 104 b 134 150 167 127 154 140 b 68 130 117 158 85 150 b -10 23 43 101 13 58 z"
    },
    accSagittal6TinasDown: {
      x_min: -7,
      x_max: 218,
      y_min: -106,
      y_max: -16,
      ha: 90,
      o: "m -10 -23 b 68 -130 13 -58 43 -101 b 134 -150 85 -150 117 -158 b 173 -92 154 -140 167 -127 b 203 -130 181 -104 190 -115 b 269 -150 220 -150 252 -158 b 314 -23 298 -135 314 -112 l 271 -23 b 252 -107 272 -86 264 -107 b 207 -65 240 -107 223 -86 b 179 -23 200 -55 179 -23 l 135 -23 b 117 -107 137 -86 128 -107 b 72 -65 105 -107 88 -86 b 43 -23 65 -55 43 -23 z"
    },
    accSagittal7TinasUp: {
      x_min: 0,
      x_max: 281,
      y_min: 16,
      y_max: 107,
      ha: 91,
      o: "m 0 68 l 0 23 b 143 45 105 23 124 26 b 203 107 153 55 183 107 b 226 23 216 107 226 86 l 269 23 b 298 65 269 23 291 55 b 343 107 314 86 331 107 b 361 23 354 107 363 86 l 405 23 b 360 150 405 112 389 135 b 294 130 343 158 311 150 b 264 92 281 115 272 104 b 225 150 258 127 245 140 b 160 132 207 158 181 153 b 115 81 138 112 124 88 b 0 68 104 71 94 68 z"
    },
    accSagittal7TinasDown: {
      x_min: 0,
      x_max: 281,
      y_min: -107,
      y_max: -16,
      ha: 91,
      o: "m 0 -68 b 115 -81 94 -68 104 -71 b 160 -132 124 -88 138 -112 b 225 -150 181 -153 207 -158 b 264 -92 245 -140 258 -127 b 294 -130 272 -104 281 -115 b 360 -150 311 -150 343 -158 b 405 -23 389 -135 405 -112 l 361 -23 b 343 -107 363 -86 354 -107 b 298 -65 331 -107 314 -86 b 269 -23 291 -55 269 -23 l 226 -23 b 203 -107 226 -86 216 -107 b 143 -45 183 -107 153 -55 b 0 -23 124 -26 105 -23 z"
    },
    accSagittal8TinasUp: {
      x_min: 0,
      x_max: 312,
      y_min: 16,
      y_max: 107,
      ha: 91,
      o: "m 135 23 b 187 45 156 23 168 26 b 249 107 197 55 228 107 b 271 23 262 107 271 86 l 314 23 b 343 65 314 23 336 55 b 387 107 359 86 376 107 b 406 23 399 107 408 86 l 449 23 b 405 150 449 112 433 135 b 338 130 387 158 356 150 b 308 92 325 115 317 104 b 269 150 302 127 289 140 b 204 132 252 158 226 153 b 160 81 183 112 168 88 b 135 68 148 71 147 68 b 89 154 94 68 89 124 l 46 154 b 36 92 45 131 42 105 b 0 68 32 82 23 68 l 0 23 b 68 63 29 23 53 40 b 135 23 84 39 104 23 z"
    },
    accSagittal8TinasDown: {
      x_min: 0,
      x_max: 312,
      y_min: -107,
      y_max: -16,
      ha: 91,
      o: "m 135 -23 b 68 -63 104 -23 84 -39 b 0 -23 53 -40 29 -23 l 0 -68 b 36 -92 23 -68 32 -82 b 46 -154 42 -105 45 -131 l 89 -154 b 135 -68 89 -124 94 -68 b 160 -81 147 -68 148 -71 b 204 -132 168 -88 183 -112 b 269 -150 226 -153 252 -158 b 308 -92 289 -140 302 -127 b 338 -130 317 -104 325 -115 b 405 -150 356 -150 387 -158 b 449 -23 433 -135 449 -112 l 406 -23 b 387 -107 408 -86 399 -107 b 343 -65 376 -107 359 -86 b 314 -23 336 -55 314 -23 l 271 -23 b 249 -107 271 -86 262 -107 b 187 -45 228 -107 197 -55 b 135 -23 168 -26 156 -23 z"
    },
    accSagittal9TinasUp: {
      x_min: -7,
      x_max: 312,
      y_min: 16,
      y_max: 106,
      ha: 90,
      o: "m -10 23 l 43 23 b 72 65 43 23 65 55 b 117 107 88 86 105 107 b 135 23 128 107 137 86 l 179 23 b 207 65 179 23 200 55 b 252 107 223 86 240 107 b 271 23 264 107 272 86 l 314 23 b 343 65 314 23 336 55 b 387 107 359 86 376 107 b 406 23 399 107 408 86 l 449 23 b 405 150 449 112 433 135 b 338 130 387 158 356 150 b 308 92 325 115 317 104 b 269 150 302 127 289 140 b 203 130 252 158 220 150 b 173 92 190 115 181 104 b 134 150 167 127 154 140 b 68 130 117 158 85 150 b -10 23 43 101 13 58 z"
    },
    accSagittal9TinasDown: {
      x_min: -7,
      x_max: 312,
      y_min: -106,
      y_max: -16,
      ha: 90,
      o: "m -10 -23 b 68 -130 13 -58 43 -101 b 134 -150 85 -150 117 -158 b 173 -92 154 -140 167 -127 b 203 -130 181 -104 190 -115 b 269 -150 220 -150 252 -158 b 308 -92 289 -140 302 -127 b 338 -130 317 -104 325 -115 b 405 -150 356 -150 387 -158 b 449 -23 433 -135 449 -112 l 406 -23 b 387 -107 408 -86 399 -107 b 343 -65 376 -107 359 -86 b 314 -23 336 -55 314 -23 l 271 -23 b 252 -107 272 -86 264 -107 b 207 -65 240 -107 223 -86 b 179 -23 200 -55 179 -23 l 135 -23 b 117 -107 137 -86 128 -107 b 72 -65 105 -107 88 -86 b 43 -23 65 -55 43 -23 z"
    },
    accSagittalFractionalTinaUp: {
      x_min: -3,
      x_max: 35,
      y_min: 73,
      y_max: 111,
      ha: 38,
      o: "m -4 132 b 23 105 -4 118 9 105 b 50 132 37 105 50 118 b 23 160 50 147 37 160 b -4 132 9 160 -4 147 z"
    },
    accSagittalFractionalTinaDown: {
      x_min: -3,
      x_max: 35,
      y_min: -111,
      y_max: -73,
      ha: 38,
      o: "m -4 -132 b 23 -160 -4 -147 9 -160 b 50 -132 37 -160 50 -147 b 23 -105 50 -118 37 -105 b -4 -132 9 -105 -4 -118 z"
    },
    accidentalNarrowReversedFlat: {
      x_min: 0,
      x_max: 164,
      y_min: -194,
      y_max: 421,
      ha: 615,
      o: "m 236 -279 l 236 606 l 192 606 l 192 179 b 85 243 150 222 114 243 b 0 84 23 243 0 134 b 112 -158 0 3 37 -78 z m 192 112 l 192 -163 l 135 -98 b 82 40 101 -50 82 -3 b 138 144 82 73 96 144 b 192 112 153 144 170 132 z"
    },
    accidentalNarrowReversedFlatAndFlat: {
      x_min: 0,
      x_max: 414,
      y_min: -194,
      y_max: 421,
      ha: 615,
      o: "m 281 606 l 281 -268 l 438 -158 b 596 84 547 -82 596 3 b 475 243 596 154 556 243 b 325 179 435 243 384 222 l 325 606 z m 235 -279 l 235 606 l 190 606 l 190 179 b 85 243 148 222 114 243 b 12 158 52 243 27 215 b 0 84 3 134 0 108 b 112 -158 0 3 37 -78 z m 325 111 b 410 144 359 132 386 144 b 498 36 462 144 498 84 b 413 -107 498 -9 469 -58 l 325 -173 z m 192 112 l 192 -163 l 135 -98 b 81 40 99 -50 81 -3 b 91 94 81 59 84 76 b 137 144 102 127 118 144 b 192 112 153 144 170 132 z"
    },
    accidentalWilsonPlus: {
      x_min: 0,
      x_max: 281,
      y_min: -203,
      y_max: 203,
      ha: 406,
      o: "m 405 268 l 225 98 l 225 292 l 180 292 l 180 56 l 0 -112 l 0 -268 l 180 -98 l 180 -292 l 225 -292 l 225 -56 l 405 112 z"
    },
    accidentalWilsonMinus: {
      x_min: 0,
      x_max: 281,
      y_min: -186,
      y_max: 186,
      ha: 372,
      o: "m 0 112 l 405 -268 l 405 -112 l 0 268 z"
    }
  },
  fontFamily: "Bravura",
  resolution: 1e3,
  generatedOn: "2022-12-18T09:06:51.407Z"
};

// node_modules/vexflow/build/esm/src/fonts/common_metrics.js
var CommonMetrics = {
  smufl: true,
  stave: {
    padding: 12,
    endPaddingMax: 10,
    endPaddingMin: 5,
    unalignedNotePadding: 10
  },
  accidental: {
    noteheadAccidentalPadding: 1,
    leftPadding: 2,
    accidentalSpacing: 3
  },
  chordSymbol: {
    global: {
      superscriptOffset: -400,
      subscriptOffset: 300,
      kerningOffset: -250,
      lowerKerningText: ["D", "F", "P", "T", "V", "Y"],
      upperKerningText: ["A", "L"],
      spacing: 100,
      superSubRatio: 0.66
    },
    glyphs: {
      csymDiminished: {
        leftSideBearing: -32,
        advanceWidth: 506,
        yOffset: 0
      },
      csymHalfDiminished: {
        leftSideBearing: -32,
        advanceWidth: 506,
        yOffset: 0
      },
      csymAugmented: {
        leftSideBearing: 0,
        advanceWidth: 530,
        yOffset: 0
      },
      csymParensLeftTall: {
        leftSideBearing: -20,
        advanceWidth: 184,
        yOffset: 250
      },
      csymParensRightTall: {
        leftSideBearing: 0,
        advanceWidth: 189,
        yOffset: 250
      },
      csymBracketLeftTall: {
        leftSideBearing: 0,
        advanceWidth: 328,
        yOffset: 0
      },
      csymBracketRightTall: {
        leftSideBearing: 1,
        advanceWidth: 600,
        yOffset: 0
      },
      csymParensLeftVeryTall: {
        leftSideBearing: 50,
        advanceWidth: 121,
        yOffset: 350
      },
      csymParensRightVeryTall: {
        leftSideBearing: 0,
        advanceWidth: 111,
        yOffset: 350
      },
      csymDiagonalArrangementSlash: {
        leftSideBearing: 250,
        advanceWidth: 990,
        yOffset: 300
      },
      csymMinor: {
        leftSideBearing: 0,
        advanceWidth: 482,
        yOffset: 0
      },
      csymMajorSeventh: {
        leftSideBearing: 200,
        yOffset: 0,
        advanceWidth: 600
      },
      accidentalSharp: {
        leftSideBearing: 20,
        advanceWidth: 250,
        yOffset: -302
      },
      accidentalFlat: {
        leftSideBearing: -20,
        advanceWidth: 226,
        yOffset: -184
      }
    }
  },
  clef_default: {
    width: 26,
    annotations: {
      "8va": {
        treble: {
          line: -2,
          shiftX: 12
        }
      },
      "8vb": {
        treble: {
          line: 6.5,
          shiftX: 10
        },
        bass: {
          line: 4,
          shiftX: 1
        }
      }
    }
  },
  clef_small: {
    width: 20,
    annotations: {
      "8va": {
        treble: {
          line: -0.2,
          shiftX: 8
        }
      },
      "8vb": {
        treble: {
          line: 5.3,
          shiftX: 6
        },
        bass: {
          line: 3.1,
          shiftX: 0.5
        }
      }
    }
  },
  ornament: {
    brassScoop: {
      xOffset: -12,
      yOffset: 0,
      stemUpYOffset: 0,
      reportedWidth: 20
    },
    brassDoitMedium: {
      xOffset: 16,
      yOffset: 0,
      stemUpYOffset: 0,
      reportedWidth: 22
    },
    brassFallLipShort: {
      xOffset: 16,
      yOffset: 0,
      stemUpYOffset: 0,
      reportedWidth: 15
    },
    brassLiftMedium: {
      xOffset: 16,
      yOffset: 5,
      stemUpYOffset: 0,
      reportedWidth: 5
    },
    brassFallRoughMedium: {
      xOffset: 16,
      yOffset: 28,
      stemUpYOffset: 0,
      reportedWidth: 5
    },
    brassBend: {
      xOffset: 2,
      yOffset: -8,
      stemUpYOffset: 25,
      reportedWidth: 5
    },
    brassMuteClosed: {
      xOffset: 3,
      yOffset: -8,
      stemUpYOffset: 25,
      reportedWidth: 5
    },
    brassMuteOpen: {
      xOffset: 3,
      yOffset: -7,
      stemUpYOffset: 25,
      reportedWidth: 5
    },
    brassFlip: {
      xOffset: 10,
      yOffset: 0,
      stemUpYOffset: 7,
      reportedWidth: 10
    },
    brassJazzTurn: {
      xOffset: 0,
      yOffset: 0,
      stemUpYOffset: 8,
      reportedWidth: 31
    },
    brassSmear: {
      xOffset: 10,
      yOffset: 0,
      stemUpYOffset: 8,
      reportedWidth: 5
    }
  },
  parenthesis: {
    default: {
      width: 7
    },
    gracenote: {
      width: 3
    }
  },
  pedalMarking: {},
  digits: {
    shiftLine: -1,
    shiftY: -6
  },
  articulation: {
    articStaccatissimoAbove: {
      padding: 2
    },
    articStaccatissimoBelow: {
      padding: 2
    }
  },
  tremolo: {
    default: {
      spacing: 7,
      offsetYStemUp: -8,
      offsetYStemDown: 8,
      offsetXStemUp: 11,
      offsetXStemDown: 1
    },
    grace: {
      spacing: 7 * 3 / 5,
      offsetYStemUp: -(8 * 3) / 5,
      offsetYStemDown: 8 * 3 / 5,
      offsetXStemUp: 7,
      offsetXStemDown: 1
    }
  },
  staveRepetition: {
    symbolText: {
      offsetX: 12,
      offsetY: 25,
      spacing: 5
    },
    coda: {
      offsetY: 25
    },
    segno: {
      offsetY: 10
    }
  },
  noteHead: {
    minPadding: 2
  },
  stem: {
    heightAdjustmentForFlag: -3,
    noteHead: {
      noteheadTriangleUpHalf: {
        offsetYBaseStemUp: 5,
        offsetYBaseStemDown: 4
      },
      noteheadTriangleUpBlack: {
        offsetYBaseStemUp: 5,
        offsetYBaseStemDown: 4
      },
      noteheadTriangleUpWhole: {
        offsetYBaseStemUp: 5,
        offsetYBaseStemDown: 4
      },
      noteheadXHalf: {
        offsetYBaseStemUp: -4,
        offsetYBaseStemDown: 4
      },
      noteheadXBlack: {
        offsetYBaseStemUp: -4,
        offsetYBaseStemDown: 4
      },
      noteheadXWhole: {
        offsetYBaseStemUp: -4,
        offsetYBaseStemDown: 4
      },
      noteheadHalf: {
        offsetYBaseStemUp: -2.55,
        offsetYBaseStemDown: 2.65
      },
      noteheadBlack: {
        offsetYBaseStemUp: -2,
        offsetYBaseStemDown: 2
      },
      noteheadSquareWhite: {
        offsetYBaseStemDown: -5,
        offsetYBaseStemUp: 5
      }
    }
  },
  stringNumber: {
    verticalPadding: 8,
    stemPadding: 2,
    leftPadding: 5,
    rightPadding: 6
  },
  tuplet: {
    noteHeadOffset: 20,
    stemOffset: 10,
    bottomLine: 4,
    topModifierOffset: 15
  },
  glyphs: {
    coda: {
      shiftX: -7,
      shiftY: 8
    },
    segno: {
      shiftX: -7
    },
    flag: {
      shiftX: -0.75,
      staveTempo: {
        shiftX: -1
      }
    },
    clef_default: {},
    clef_small: {
      gClef: {
        shiftY: 1.5
      }
    },
    clefNote_default: {},
    clefNote_small: {},
    stroke_straight: {
      arrowheadBlackDown: {
        shiftX: -4.5
      },
      arrowheadBlackUp: {
        shiftX: -0.85
      }
    },
    stroke_wiggly: {
      arrowheadBlackDown: {
        shiftX: -1,
        shiftY: 1
      },
      arrowheadBlackUp: {
        shiftX: -1,
        shiftY: 1
      }
    },
    textNote: {
      breathMarkTick: {
        shiftY: 9
      },
      breathMarkComma: {},
      segno: {
        shiftX: -7,
        shiftY: 8
      },
      coda: {
        shiftX: -7,
        shiftY: 8
      },
      ornamentTrill: {
        shiftX: -8,
        shiftY: 8
      },
      ornamentTurn: {},
      ornamentTurnSlash: {},
      ornamentMordent: {
        shiftX: -8
      },
      ornamentShortTrill: {
        shiftX: -8
      }
    },
    noteHead: {},
    chordSymbol: {
      scale: 0.8
    }
  }
};

// node_modules/vexflow/build/esm/src/fonts/load_bravura.js
function loadBravura() {
  Font.load("Bravura", BravuraFont, CommonMetrics);
}

// node_modules/vexflow/build/esm/src/fonts/custom_glyphs.js
var CustomFont = {
  resolution: 1e3,
  fontFamily: "VexFlowCustom",
  glyphs: {
    vexAccidentalMicrotonal1: {
      x_min: -171.5,
      x_max: 483.1875,
      ha: 493,
      o: "m -8 631 b -1 632 -6 632 -4 632 b 19 620 8 632 16 628 b 20 495 20 616 20 616 b 20 373 20 427 20 373 b 115 410 20 373 63 390 l 210 448 l 210 531 b 212 620 210 614 210 616 b 231 632 215 628 223 632 b 246 627 236 632 242 631 b 251 541 251 620 251 628 l 251 463 l 315 489 b 387 514 368 509 381 514 b 393 513 390 514 392 514 b 406 494 402 510 406 502 b 397 476 406 487 404 480 b 323 446 396 474 363 462 l 251 417 l 251 283 l 251 148 l 254 151 b 370 199 291 183 332 199 b 415 191 385 199 400 197 b 483 84 458 176 483 134 b 461 0 483 58 476 29 b 332 -142 439 -40 411 -72 l 255 -215 b 231 -229 240 -229 239 -229 b 216 -223 224 -229 220 -227 b 210 -158 210 -217 210 -223 b 210 -120 210 -148 210 -136 l 210 -29 l 205 -34 b 100 -142 182 -65 159 -88 l 23 -215 b -1 -229 9 -229 6 -229 b -19 -217 -9 -229 -16 -224 l -20 -215 l -21 48 l -21 310 l -83 287 b -152 262 -133 266 -145 262 b -157 263 -153 262 -155 262 b -171 283 -166 266 -171 274 b -161 301 -171 290 -167 297 b -91 328 -160 302 -129 315 l -21 356 l -21 487 l -20 617 l -19 621 b -8 631 -17 626 -12 630 m 210 288 b 210 401 210 351 210 401 b 114 365 209 401 167 384 l 20 327 l 20 238 l 20 148 l 21 151 b 140 199 59 183 102 199 b 206 180 164 199 187 192 l 209 177 b 209 177 209 177 209 177 b 210 288 210 177 210 199 m 110 131 b 96 133 106 133 100 133 b 89 133 93 133 91 133 b 24 87 63 129 40 113 l 20 80 l 20 -37 l 20 -156 l 23 -152 b 144 81 96 -72 144 20 l 144 83 b 110 131 144 113 134 126 m 341 131 b 328 133 337 133 332 133 b 322 133 326 133 323 133 b 257 87 296 129 273 113 l 251 80 l 251 -37 l 251 -156 l 255 -152 b 375 81 328 -72 375 20 l 375 83 b 341 131 375 113 367 126 "
    },
    vexAccidentalMicrotonal3: {
      x_min: 0,
      x_max: 430.75,
      ha: 360,
      o: "m -146 537 b -138 538 -143 538 -141 538 b -118 525 -129 538 -121 533 b -117 390 -117 522 -117 521 b -115 259 -117 268 -117 259 b -115 259 -115 259 -115 259 b -59 272 -104 263 -62 272 b -39 259 -50 272 -42 267 b -37 209 -38 257 -37 233 b -39 159 -37 185 -38 162 b -85 138 -43 149 -44 149 l -117 131 l -117 21 b -115 -88 -117 -80 -117 -88 b -115 -88 -115 -88 -115 -88 b -59 -75 -104 -84 -62 -75 b -44 -81 -52 -75 -48 -77 b -38 -124 -38 -87 -38 -85 b -38 -138 -38 -124 -38 -138 b -38 -152 -38 -138 -38 -152 b -44 -195 -38 -191 -38 -190 b -85 -209 -48 -200 -48 -200 l -117 -217 l -117 -349 b -118 -486 -117 -481 -117 -482 b -138 -499 -121 -494 -129 -499 b -153 -493 -143 -499 -149 -497 b -159 -415 -158 -487 -159 -496 b -159 -355 -159 -398 -159 -379 b -159 -227 -159 -284 -159 -227 b -205 -238 -159 -227 -180 -232 b -250 -249 -230 -244 -250 -249 b -251 -386 -251 -249 -251 -311 b -252 -525 -251 -521 -251 -522 b -272 -538 -255 -534 -264 -538 b -287 -532 -277 -538 -283 -536 b -293 -452 -292 -527 -293 -536 b -293 -391 -293 -436 -293 -415 b -294 -260 -293 -269 -293 -260 b -294 -260 -294 -260 -294 -260 b -348 -272 -306 -264 -345 -272 b -368 -259 -357 -272 -365 -267 b -369 -209 -369 -257 -369 -233 b -368 -159 -369 -185 -369 -162 b -323 -139 -364 -149 -362 -148 l -293 -131 l -293 -22 b -294 87 -293 80 -293 87 b -294 87 -294 87 -294 87 b -348 75 -306 84 -345 75 b -368 88 -357 75 -365 80 b -369 138 -369 91 -369 114 b -368 188 -369 162 -369 186 b -323 209 -364 198 -362 199 l -293 216 l -293 349 b -292 486 -293 481 -293 482 b -272 499 -288 494 -280 499 b -257 493 -266 499 -261 497 b -251 414 -251 487 -251 496 b -251 354 -251 398 -251 378 b -251 226 -251 284 -251 226 b -205 238 -250 226 -230 231 b -159 249 -180 244 -159 249 b -159 385 -159 249 -159 310 b -157 525 -159 521 -159 522 b -146 537 -156 530 -151 535 z m -159 11 b -159 120 -159 98 -159 120 l -159 120 b -175 116 -160 120 -167 119 b -221 105 -184 114 -204 109 l -251 98 l -251 -12 b -251 -121 -251 -72 -251 -121 b -205 -110 -250 -121 -230 -116 b -159 -99 -180 -104 -159 -99 b -159 11 -159 -99 -159 -49 z m 89 517 b 97 519 92 518 94 519 b 117 505 106 519 114 513 b 119 376 119 502 119 501 l 119 249 l 145 258 b 176 267 169 266 172 267 b 177 267 176 267 177 267 b 196 255 186 267 192 263 l 197 252 l 197 205 b 197 181 197 195 197 187 b 193 149 197 153 197 153 b 152 131 190 144 187 143 l 119 120 l 119 10 b 119 -100 119 -62 119 -100 b 145 -91 120 -100 131 -96 b 173 -82 159 -86 171 -82 b 176 -81 174 -81 175 -81 b 196 -94 185 -81 193 -87 b 198 -151 197 -97 198 -125 b 197 -194 198 -172 197 -192 b 153 -218 193 -203 192 -204 l 119 -230 l 119 -367 l 118 -504 l 117 -507 b 97 -519 113 -514 105 -519 b 82 -512 92 -519 87 -517 b 76 -434 77 -507 76 -516 b 76 -374 76 -418 76 -398 b 76 -245 76 -303 76 -245 b 52 -254 76 -245 65 -249 b 19 -263 34 -260 25 -263 b 6 -257 13 -263 10 -261 b 0 -214 0 -251 0 -253 b 0 -200 0 -210 0 -205 b 0 -188 0 -196 0 -192 b 6 -143 0 -147 0 -149 b 46 -126 10 -139 10 -139 l 76 -115 l 76 -5 b 76 106 76 56 76 106 b 51 98 76 106 64 102 b 18 89 34 92 25 89 b 6 95 13 89 10 91 b 0 139 0 101 0 99 b 0 153 0 143 0 148 b 0 179 0 163 0 172 b 44 225 0 215 3 211 l 76 236 l 76 369 b 78 505 76 501 76 502 b 89 517 80 510 85 515 z "
    },
    vexAccidentalMicrotonal4: {
      x_min: 0,
      x_max: 430.75,
      ha: 360,
      o: "m 283 633 b 291 634 286 634 289 634 b 311 621 300 634 308 629 b 313 505 313 618 313 617 b 313 393 313 443 313 393 b 378 425 313 393 343 407 l 443 458 l 448 458 b 449 458 449 458 449 458 b 471 437 462 458 471 448 b 469 429 471 434 470 432 b 387 382 466 421 469 423 l 313 344 l 313 247 l 313 150 l 315 152 b 433 201 353 184 394 201 b 479 193 448 201 464 198 b 549 86 524 177 549 135 b 526 1 549 59 541 29 b 395 -143 504 -39 475 -71 b 316 -214 351 -182 341 -191 b 292 -229 302 -228 300 -229 b 272 -216 283 -229 275 -224 b 271 55 271 -212 271 -212 b 270 323 271 203 270 323 b 205 291 270 323 241 308 l 140 258 l 135 258 b 134 258 135 258 134 258 b 112 279 121 258 112 267 b 114 287 112 281 113 284 b 196 334 117 295 114 293 l 271 371 l 271 495 b 272 621 271 617 271 618 b 283 633 274 626 279 631 z m 404 133 b 391 134 400 134 395 134 b 384 134 388 134 386 134 b 318 88 358 130 335 114 l 313 81 l 313 -37 l 313 -156 l 316 -152 b 439 83 391 -71 439 22 l 439 84 b 404 133 439 115 430 128 z m -8 633 l -8 633 b 0 634 -6 634 -3 634 b 20 621 8 634 17 629 b 21 384 21 618 21 617 l 21 150 l 24 152 b 141 201 62 184 102 201 b 187 193 157 201 172 198 b 257 86 232 177 257 135 b 234 1 257 59 250 29 b 103 -143 212 -39 183 -71 b 24 -214 60 -182 49 -191 b 0 -229 10 -228 8 -229 b -20 -216 -9 -229 -17 -224 l -21 -212 l -21 203 l -21 618 l -20 621 b -8 633 -18 626 -13 631 z m 113 133 l 113 133 b 99 134 109 134 103 134 b 93 134 97 134 94 134 b 26 88 66 130 43 114 l 21 81 l 21 -37 l 21 -156 l 25 -152 b 148 83 99 -71 148 22 l 148 84 b 113 133 148 115 138 128 z "
    },
    vexNoteHeadRectBlack: {
      x_min: 0,
      x_max: 430.75,
      ha: 360,
      o: "m 0 150 l 0 -150 l 430 -150 l 430 150 l 0 150 "
    },
    vexNoteHeadRectWhite: {
      x_min: 0,
      x_max: 430.75,
      ha: 360,
      o: "m 0 150 l 0 -150 l 430 -150 l 430 150 l 0 150 l 50 100 l 380 100 l 380 -100 l 50 -100 l 50 100"
    },
    vexWiggleArpeggioUp: {
      x_min: 58.53125,
      x_max: 228.671875,
      ha: 294,
      o: "m 138 371 b 142 373 140 371 141 373 b 178 342 149 373 156 366 b 228 251 217 297 228 278 b 228 244 228 248 228 247 b 176 147 227 212 212 184 b 123 73 152 122 132 93 b 121 62 122 70 121 66 b 145 13 121 48 129 31 b 153 -2 151 6 153 1 b 149 -9 153 -5 152 -6 b 144 -11 148 -11 145 -11 b 129 -1 140 -11 136 -8 b 61 87 89 37 68 68 b 58 113 59 95 58 105 b 110 215 58 144 74 177 b 163 287 134 240 155 269 b 166 299 166 291 166 295 b 141 348 166 313 157 330 b 133 360 134 356 133 358 b 133 363 133 362 133 362 b 138 371 133 367 136 370 "
    }
  }
};

// node_modules/vexflow/build/esm/src/fonts/load_custom.js
function loadCustom() {
  Font.load("Custom", CustomFont, CommonMetrics);
}

// node_modules/vexflow/build/esm/src/fonts/gonville_glyphs.js
var GonvilleSmuflFont = {
  glyphs: {
    bracketTop: {
      x_min: 0,
      x_max: 412,
      y_min: -18,
      y_max: 223,
      ha: 241,
      o: "m 569 315 b 583 321 575 319 579 321 b 591 316 586 321 589 319 b 593 310 592 314 593 312 b 579 289 593 306 589 301 b 385 111 517 219 449 156 b 372 101 379 106 373 102 b 244 28 340 78 285 46 b 21 -26 168 -6 88 -26 b 2 -21 6 -26 5 -25 b 0 47 1 -19 0 14 b 2 114 0 79 1 112 b 29 120 5 119 6 119 b 569 315 209 124 395 191 z"
    },
    bracketBottom: {
      x_min: 0,
      x_max: 412,
      y_min: -223,
      y_max: 18,
      ha: 241,
      o: "m 5 24 b 21 26 7 25 12 26 b 63 23 32 26 47 25 b 342 -81 155 13 249 -22 b 388 -113 353 -89 382 -108 b 400 -122 389 -114 395 -118 b 578 -289 459 -166 522 -225 b 593 -310 589 -301 593 -306 b 591 -316 593 -312 592 -314 b 583 -321 588 -319 586 -321 b 568 -315 579 -321 575 -319 b 29 -120 395 -191 209 -124 b 1 -114 5 -119 5 -119 b 0 -47 0 -112 0 -111 b 0 -22 0 -37 0 -29 b 5 24 0 25 0 21 z"
    },
    barlineTick: {
      x_min: -59,
      x_max: 59,
      y_min: -139,
      y_max: 139,
      ha: 279,
      o: "m 24 200 b 34 201 26 200 30 201 b 51 198 40 201 47 200 b 84 152 72 191 84 174 b 84 149 84 151 84 150 b 68 103 84 139 83 137 b -64 -195 3 -44 -63 -194 b -74 -201 -66 -199 -70 -201 b -83 -195 -77 -201 -81 -199 b -84 -191 -84 -194 -84 -193 b -78 -155 -84 -186 -83 -177 b -25 104 -45 8 -35 53 b -11 167 -18 136 -12 164 b 24 200 -6 183 6 195 z"
    },
    breathMarkTick: {
      x_min: -151,
      x_max: 272,
      y_min: 0,
      y_max: 429,
      ha: 429,
      o: "m 367 613 b 382 618 373 616 378 618 b 392 607 388 618 392 614 b 376 592 392 601 390 599 b 309 546 354 580 331 565 b 46 47 185 439 88 256 b 0 0 39 14 26 0 b -44 39 -23 0 -36 12 b -203 270 -68 118 -125 202 b -217 288 -213 279 -217 284 b -215 294 -217 290 -217 292 b -208 299 -213 297 -211 299 b -193 293 -204 299 -199 297 b -19 144 -124 249 -66 199 b -14 138 -16 141 -14 138 b -9 149 -14 138 -11 143 b 367 613 72 359 220 541 z"
    },
    segno: {
      x_min: 7,
      x_max: 493,
      y_min: -50,
      y_max: 650,
      ha: 699,
      o: "m 218 934 b 237 935 224 935 231 935 b 394 820 306 935 371 889 b 398 794 397 811 398 802 b 333 730 398 758 372 730 b 269 777 302 730 280 746 b 183 851 254 823 219 851 b 158 846 175 851 166 849 b 120 786 133 835 120 815 b 122 766 120 780 121 773 b 347 511 138 672 227 570 b 368 500 356 506 366 501 l 371 499 l 372 501 b 485 672 373 502 404 550 b 560 786 506 704 540 755 b 617 873 581 818 607 857 b 645 910 639 906 640 907 b 660 915 650 914 655 915 b 687 888 674 915 687 904 b 687 886 687 887 687 887 b 665 844 687 878 687 878 b 610 761 655 830 631 792 b 462 537 551 672 501 595 b 425 480 443 508 426 482 l 422 476 l 431 472 b 628 269 521 423 591 352 b 658 136 649 225 658 179 b 518 -68 658 36 606 -48 b 484 -71 507 -70 495 -71 b 327 43 415 -71 351 -26 b 322 70 324 52 322 61 b 387 134 322 106 348 134 b 451 86 419 134 440 118 b 537 13 466 41 501 13 b 563 18 545 13 554 15 b 600 78 587 29 600 49 b 598 98 600 84 599 91 b 374 353 582 192 493 293 b 352 363 364 358 354 363 l 349 365 l 348 363 b 235 192 347 361 315 313 b 160 77 214 160 180 109 b 103 -9 139 46 113 7 b 75 -47 81 -42 80 -43 b 60 -51 70 -50 65 -51 b 33 -24 46 -51 33 -40 b 33 -22 33 -23 33 -23 b 55 19 33 -14 33 -14 b 259 329 84 63 162 181 b 297 386 279 360 296 385 l 298 388 l 290 392 b 92 594 200 441 130 512 b 62 728 71 639 62 685 b 218 934 62 834 121 922 z m 630 616 b 643 618 634 617 639 618 b 699 589 665 618 687 607 b 709 552 706 578 709 565 b 699 515 709 539 706 526 b 644 486 686 496 665 486 b 596 507 626 486 609 493 b 578 551 584 520 578 536 b 630 616 578 581 598 609 z m 62 376 b 75 378 67 377 71 378 b 124 357 93 378 112 370 b 142 312 136 344 142 328 b 131 275 142 299 138 286 b 76 246 118 256 97 246 b 28 267 59 246 41 253 b 11 311 16 280 11 296 b 62 376 11 341 30 369 z"
    },
    coda: {
      x_min: 22,
      x_max: 478,
      y_min: -31,
      y_max: 531,
      ha: 563,
      o: "m 350 764 b 359 765 352 765 355 765 b 367 764 362 765 365 765 b 381 753 373 762 378 758 b 386 706 386 746 386 747 b 387 670 386 672 386 670 b 448 647 396 670 430 657 b 597 395 532 601 587 507 l 598 386 l 632 386 b 677 382 670 386 670 386 b 689 359 685 376 689 367 b 677 336 689 350 685 341 b 632 331 670 331 670 331 l 598 331 l 597 322 b 396 50 585 186 504 77 b 387 48 392 49 388 48 b 386 12 386 48 386 46 l 386 8 b 380 -36 386 -29 386 -28 b 359 -45 375 -42 367 -45 b 338 -36 351 -45 342 -42 b 331 8 331 -28 331 -29 l 331 12 b 330 48 331 46 331 48 b 269 70 321 48 288 60 b 120 322 186 117 130 210 l 119 331 l 86 331 b 43 336 50 331 50 331 b 31 359 35 341 31 350 b 50 385 31 370 38 381 b 86 386 53 386 60 386 l 119 386 l 120 395 b 269 647 130 508 186 601 b 330 670 288 657 321 670 b 331 706 331 670 331 672 b 332 746 331 736 332 744 b 350 764 335 754 342 762 z m 331 502 b 331 617 331 565 331 617 b 310 599 329 617 317 607 b 229 393 266 555 235 477 l 229 386 l 280 386 l 331 386 z m 393 613 b 386 617 390 615 387 617 b 386 502 386 617 386 565 l 386 386 l 437 386 l 488 386 l 488 393 b 393 613 482 486 443 575 z m 331 216 l 331 331 l 280 331 l 229 331 l 229 324 b 310 118 235 241 266 162 b 331 100 317 111 329 100 b 331 216 331 100 331 152 z m 488 324 l 488 331 l 437 331 l 386 331 l 386 216 b 386 100 386 152 386 100 b 408 118 388 100 400 111 b 488 324 452 162 482 241 z"
    },
    gClef: {
      x_min: 0,
      x_max: 623,
      y_min: -632,
      y_max: 1082,
      ha: 1713,
      o: "m 521 1558 b 524 1558 522 1558 523 1558 b 579 1515 537 1558 556 1543 b 718 1118 662 1415 718 1254 b 717 1089 718 1108 718 1098 b 505 667 707 930 639 793 b 470 633 493 655 477 640 l 456 620 l 483 495 b 510 369 498 426 510 369 b 510 369 510 369 510 369 b 519 370 511 369 514 370 b 558 372 525 371 542 372 b 590 371 572 372 585 371 b 897 45 760 350 885 217 b 898 22 897 38 898 30 b 666 -316 898 -120 805 -256 b 657 -320 661 -318 657 -320 b 675 -403 657 -320 665 -357 b 695 -500 685 -448 694 -491 b 704 -596 701 -534 704 -566 b 642 -796 704 -677 683 -744 b 407 -909 582 -871 495 -909 b 176 -804 323 -909 238 -874 b 137 -704 150 -774 137 -739 b 168 -612 137 -672 147 -640 b 291 -550 198 -571 245 -550 b 405 -604 333 -550 376 -568 b 437 -694 427 -632 437 -663 b 305 -834 437 -764 384 -831 l 294 -835 l 298 -836 b 405 -861 330 -853 367 -861 b 539 -823 453 -861 501 -848 b 655 -596 617 -774 655 -699 b 644 -490 655 -564 651 -528 b 611 -336 640 -471 611 -336 b 611 -336 611 -336 611 -336 b 598 -339 610 -336 605 -337 b 536 -349 579 -343 558 -347 b 498 -350 529 -350 514 -350 b 449 -349 478 -350 457 -350 b 0 149 189 -320 0 -110 b 102 460 0 264 33 364 b 342 742 175 562 250 650 l 374 774 l 360 839 b 342 922 352 874 344 912 b 321 1024 329 983 323 1013 b 312 1124 315 1057 312 1091 b 477 1523 312 1275 371 1420 b 521 1558 501 1546 513 1556 z m 591 1349 b 574 1351 586 1350 580 1351 b 471 1297 542 1351 506 1332 b 376 1044 410 1236 376 1145 b 383 967 376 1019 378 993 b 415 814 385 956 414 814 b 415 814 415 814 415 814 b 460 860 416 814 450 848 b 644 1242 578 991 644 1132 b 639 1295 644 1261 643 1278 b 591 1349 632 1327 618 1342 z m 418 565 b 415 577 417 571 416 577 b 290 431 412 577 327 479 b 160 220 210 331 182 284 b 135 74 143 172 135 122 b 209 -162 135 -11 160 -94 b 495 -314 278 -259 385 -314 b 550 -310 514 -314 532 -313 b 602 -296 570 -306 602 -298 b 574 -164 602 -295 590 -236 b 522 81 559 -92 535 18 b 497 196 508 144 497 196 b 497 196 497 196 497 196 b 457 179 493 196 469 186 b 358 16 391 144 358 79 b 438 -128 358 -40 384 -95 b 455 -151 449 -135 455 -143 b 448 -165 455 -156 452 -160 b 434 -172 444 -169 440 -172 b 401 -159 427 -172 417 -168 b 256 82 305 -110 256 -15 b 386 322 256 172 299 264 b 462 358 408 337 453 358 b 462 359 462 358 462 358 b 462 360 462 359 462 359 b 418 565 462 362 422 547 z m 581 203 b 558 204 576 204 565 204 l 545 204 l 546 202 b 589 -1 546 201 565 109 b 634 -214 613 -112 633 -208 b 642 -251 636 -220 639 -237 l 648 -277 l 651 -275 b 776 -137 710 -241 752 -195 b 795 -42 789 -106 795 -73 b 581 203 795 78 707 188 z"
    },
    cClef: {
      x_min: 0,
      x_max: 643,
      y_min: -508,
      y_max: 508,
      ha: 1016,
      o: "m 0 0 l 0 731 l 87 731 l 175 731 l 175 0 l 175 -731 l 87 -731 l 0 -731 z m 240 0 l 240 731 l 262 731 l 284 731 l 284 382 l 284 32 l 291 38 b 374 145 318 61 351 104 b 439 314 402 196 423 251 b 458 341 444 338 447 341 b 475 319 470 341 474 335 b 647 120 483 206 560 120 b 665 122 653 120 659 121 b 771 330 741 132 766 181 b 772 404 772 357 772 381 b 707 662 772 557 753 630 b 615 687 684 679 651 687 b 517 666 582 687 548 680 b 504 660 509 663 504 660 b 504 660 504 660 504 660 b 578 578 545 658 578 621 b 578 575 578 577 578 576 b 492 494 576 524 534 494 b 419 534 465 494 437 506 b 403 584 408 550 403 567 b 434 651 403 608 413 632 b 616 721 485 698 550 721 b 884 565 720 721 826 665 b 925 406 912 515 925 460 b 719 99 925 272 846 140 b 648 87 694 91 671 87 b 543 122 610 87 576 99 b 536 126 540 124 536 126 b 535 126 535 126 535 126 b 497 63 535 126 518 98 l 459 0 l 497 -63 b 535 -126 518 -98 535 -126 b 536 -126 535 -126 535 -126 b 543 -122 536 -126 540 -124 b 648 -87 575 -99 610 -87 b 677 -89 657 -87 667 -88 b 924 -382 811 -110 913 -230 b 925 -407 925 -391 925 -399 b 639 -720 925 -570 803 -706 b 615 -721 631 -720 623 -721 b 430 -647 545 -721 478 -694 b 403 -585 412 -629 403 -607 b 492 -494 403 -538 439 -494 b 497 -494 493 -494 495 -494 b 578 -578 545 -496 578 -536 b 564 -625 578 -594 574 -610 b 504 -660 551 -644 525 -659 b 504 -660 504 -660 504 -660 b 517 -666 504 -660 509 -663 b 615 -687 548 -680 582 -687 b 707 -662 651 -687 684 -679 b 772 -404 753 -630 772 -557 b 771 -330 772 -381 772 -357 b 665 -122 766 -181 741 -132 b 647 -120 659 -121 653 -120 b 475 -319 560 -120 483 -206 b 458 -341 474 -335 470 -341 b 439 -314 447 -341 444 -338 b 374 -145 423 -251 402 -196 b 291 -38 351 -104 317 -61 l 284 -32 l 284 -382 l 284 -731 l 262 -731 l 240 -731 z"
    },
    fClef: {
      x_min: 0,
      x_max: 661,
      y_min: -545,
      y_max: 254,
      ha: 798,
      o: "m 326 364 b 356 365 336 365 346 365 b 647 278 464 365 575 332 b 788 -2 740 207 788 112 b 785 -51 788 -18 787 -34 b 161 -747 750 -356 500 -634 b 16 -784 110 -764 31 -784 b 0 -768 7 -784 0 -778 b 24 -747 0 -758 3 -755 b 601 -72 353 -625 575 -364 b 603 -10 602 -51 603 -30 b 469 298 603 133 556 243 b 346 332 432 321 389 332 b 100 185 248 332 146 277 b 89 161 97 178 89 162 b 89 161 89 161 89 161 b 95 164 90 161 92 162 b 169 185 118 179 144 185 b 308 74 232 185 293 142 b 311 42 310 63 311 53 b 167 -101 311 -36 248 -101 b 147 -99 161 -101 154 -100 b 9 79 65 -88 9 -15 l 9 79 b 326 364 9 228 148 353 z m 888 225 b 894 225 889 225 891 225 b 914 223 901 225 910 224 b 952 171 940 214 952 192 b 914 118 952 149 939 127 b 898 116 910 117 904 116 b 881 118 892 116 886 117 b 843 170 856 127 843 149 b 888 225 843 195 859 219 z m 888 -116 b 894 -116 889 -116 891 -116 b 914 -118 901 -116 910 -117 b 952 -170 940 -127 952 -149 b 914 -223 952 -192 939 -214 b 898 -225 910 -224 904 -225 b 881 -223 892 -225 886 -224 b 843 -171 856 -214 843 -193 b 888 -116 843 -146 859 -122 z"
    },
    unpitchedPercussionClef1: {
      x_min: -4,
      x_max: 337,
      y_min: -250,
      y_max: 250,
      ha: 500,
      o: "m -6 0 l -6 360 l 75 360 l 157 360 l 157 0 l 157 -360 l 75 -360 l -6 -360 z m 321 0 l 321 360 l 403 360 l 485 360 l 485 0 l 485 -360 l 403 -360 l 321 -360 z"
    },
    "6stringTabClef": {
      x_min: 0,
      x_max: 501,
      y_min: -735,
      y_max: 753,
      ha: 1487,
      o: "m 633 1083 b 639 1084 635 1084 637 1084 b 669 1072 650 1084 661 1079 b 681 1043 677 1063 681 1053 b 657 1004 681 1028 673 1013 b 467 964 609 980 535 964 l 452 964 l 452 959 b 456 874 455 932 456 903 b 418 611 456 781 443 686 b 245 415 380 495 327 435 b 195 409 228 411 214 409 b 147 412 182 409 167 410 b 110 453 124 414 110 433 b 122 482 110 464 114 474 b 151 494 130 490 141 494 b 184 478 163 494 175 489 b 194 475 186 476 190 475 b 224 486 202 475 213 479 b 283 575 246 500 263 527 b 335 871 317 657 335 760 b 331 967 335 903 334 935 l 330 980 l 321 982 b 260 992 301 989 280 992 b 139 927 206 992 160 968 b 90 895 128 906 109 895 b 42 933 70 895 49 908 b 40 947 40 937 40 942 b 105 1020 40 972 61 996 b 263 1058 150 1045 207 1058 b 350 1047 293 1058 323 1054 b 465 1030 389 1036 429 1030 b 612 1073 526 1030 579 1045 b 633 1083 618 1078 625 1082 z m 441 376 b 448 376 443 376 445 376 b 470 374 456 376 465 375 b 511 321 494 366 509 346 b 534 155 515 283 525 210 b 621 -190 556 21 589 -109 b 668 -253 632 -220 651 -245 l 672 -254 l 676 -253 b 687 -252 680 -252 683 -252 b 721 -287 707 -252 721 -269 b 705 -316 721 -298 716 -309 b 676 -321 699 -320 689 -321 b 650 -319 668 -321 659 -321 b 506 -206 588 -312 533 -269 b 444 0 487 -163 460 -72 b 441 8 443 4 441 8 b 441 8 441 8 441 8 b 436 -3 441 7 438 2 b 381 -99 422 -33 400 -72 b 375 -109 377 -105 375 -107 b 381 -114 375 -111 377 -112 b 435 -133 398 -126 415 -132 b 452 -138 446 -134 448 -134 b 457 -150 455 -141 457 -145 b 446 -166 457 -156 453 -163 b 406 -174 434 -171 420 -174 b 344 -160 385 -174 363 -169 l 337 -156 l 334 -159 b 49 -314 250 -255 145 -311 b 39 -315 45 -315 42 -315 b 10 -305 23 -315 18 -312 b 0 -281 3 -298 0 -290 b 34 -247 0 -264 14 -247 b 40 -248 36 -247 38 -247 b 46 -248 42 -248 44 -248 b 144 -208 69 -248 108 -233 b 390 306 283 -115 381 90 b 394 334 391 320 392 328 b 441 376 401 356 419 372 z m 376 -371 b 408 -371 383 -371 395 -371 b 451 -372 425 -371 444 -371 b 529 -388 482 -376 502 -380 b 689 -546 621 -417 689 -484 b 563 -696 689 -599 639 -658 l 552 -701 l 561 -705 b 700 -882 646 -748 700 -818 b 699 -896 700 -887 700 -892 b 503 -1054 689 -974 608 -1039 b 451 -1058 486 -1057 468 -1058 b 272 -1010 389 -1058 329 -1042 b 248 -972 257 -1001 248 -987 b 249 -963 248 -969 248 -966 l 250 -959 l 249 -960 b 241 -966 248 -961 244 -964 b 124 -1015 208 -992 168 -1009 b 90 -1017 118 -1016 104 -1017 b 48 -1015 72 -1017 52 -1016 b 19 -977 30 -1009 19 -993 b 31 -949 19 -967 23 -957 b 59 -937 39 -941 49 -937 b 85 -947 68 -937 77 -941 l 88 -951 l 94 -951 b 210 -845 134 -951 183 -906 b 220 -821 212 -840 216 -830 b 286 -526 264 -724 286 -623 b 283 -469 286 -507 285 -488 b 282 -459 283 -463 282 -459 b 282 -459 282 -459 282 -459 b 256 -469 281 -459 266 -464 b 141 -563 201 -491 160 -526 b 94 -592 130 -583 112 -592 b 43 -540 68 -592 43 -573 b 88 -476 43 -518 51 -505 b 376 -371 158 -418 261 -381 z m 432 -437 b 411 -437 427 -437 418 -437 l 399 -437 l 400 -440 b 406 -505 402 -448 405 -478 b 407 -527 407 -512 407 -520 b 334 -840 407 -628 382 -737 b 284 -925 315 -881 304 -901 b 280 -930 281 -928 280 -929 b 281 -930 280 -930 280 -930 b 284 -930 281 -930 282 -930 b 291 -929 286 -929 288 -929 b 320 -941 300 -929 310 -933 b 452 -991 362 -975 405 -991 l 452 -991 b 580 -883 531 -991 580 -941 b 538 -791 580 -852 566 -820 b 421 -733 508 -761 470 -742 b 392 -715 405 -730 397 -724 b 388 -698 389 -709 388 -703 b 420 -665 388 -681 401 -667 b 567 -563 490 -658 555 -613 b 569 -546 568 -557 569 -552 b 432 -437 569 -493 510 -444 z"
    },
    timeSig0: {
      x_min: 0,
      x_max: 380,
      y_min: -250,
      y_max: 236,
      ha: 486,
      o: "m 249 313 b 272 314 256 314 264 314 b 428 259 325 314 385 293 b 547 0 505 196 547 105 b 544 -49 547 -16 546 -32 b 273 -314 526 -197 407 -314 b 32 -149 175 -314 81 -250 b 0 0 11 -105 0 -53 b 32 150 0 53 11 106 b 249 313 78 242 158 302 z m 293 279 b 273 281 286 280 280 281 b 203 251 242 281 216 270 b 170 -3 185 224 170 102 b 172 -59 170 -23 171 -42 b 203 -251 178 -163 189 -231 b 273 -281 216 -270 243 -281 b 306 -277 284 -281 295 -280 b 366 -160 344 -267 356 -243 b 376 0 373 -103 376 -51 b 366 160 376 51 373 103 b 293 279 355 250 341 272 z m 273 -360 l 275 -360 l 272 -360 z m 273 340 l 275 340 l 272 340 z"
    },
    timeSig1: {
      x_min: 0,
      x_max: 254,
      y_min: -250,
      y_max: 236,
      ha: 486,
      o: "m 135 302 b 210 303 137 303 141 303 b 235 303 219 303 228 303 b 290 298 290 303 286 303 b 295 70 295 293 295 314 b 300 -219 295 -201 295 -202 b 352 -269 307 -239 324 -255 b 366 -287 361 -274 366 -280 b 361 -298 366 -291 364 -295 b 266 -303 357 -303 367 -303 b 210 -303 250 -303 232 -303 b 154 -303 188 -303 170 -303 b 59 -298 53 -303 63 -303 b 54 -287 55 -295 54 -291 b 68 -269 54 -280 59 -274 b 120 -219 96 -255 113 -239 b 125 -50 124 -205 125 -193 b 125 24 125 -29 125 -4 l 125 189 l 120 181 b 90 136 116 176 103 156 b 48 72 77 116 58 87 b 16 38 26 38 26 38 b 0 54 6 38 0 45 b 0 56 0 55 0 55 l 0 60 l 64 178 b 135 302 128 296 130 299 z m 183 -360 l 184 -360 l 182 -360 z m 183 340 l 184 340 l 182 340 z"
    },
    timeSig2: {
      x_min: 0,
      x_max: 337,
      y_min: -250,
      y_max: 236,
      ha: 486,
      o: "m 210 313 b 232 314 217 314 224 314 b 317 303 261 314 293 310 b 459 147 407 277 459 217 b 441 77 459 124 453 101 b 258 -67 409 10 349 -37 b 76 -181 173 -95 117 -130 l 73 -185 l 77 -182 b 226 -128 121 -146 174 -128 b 322 -152 260 -128 293 -136 b 378 -173 346 -165 359 -170 b 395 -174 383 -174 389 -174 b 454 -149 421 -174 446 -164 b 470 -139 457 -142 464 -139 b 486 -155 478 -139 486 -145 b 462 -217 486 -165 474 -197 b 319 -313 428 -276 373 -313 l 318 -313 b 273 -300 296 -313 290 -311 b 133 -256 226 -271 178 -256 b 93 -260 119 -256 106 -257 b 32 -294 68 -265 41 -280 b 15 -303 28 -300 21 -303 b 1 -292 9 -303 3 -299 b 0 -284 0 -291 0 -288 b 6 -234 0 -271 3 -249 b 180 -36 28 -147 90 -75 b 303 122 246 -7 290 50 b 305 146 305 130 305 138 b 272 225 305 177 294 204 b 185 259 249 248 220 259 b 163 257 178 259 170 258 b 152 256 155 257 152 256 b 155 253 152 255 153 254 b 191 188 180 238 191 213 b 138 112 191 156 173 124 b 112 108 129 109 120 108 b 29 191 67 108 29 146 b 33 214 29 199 30 206 b 210 313 46 263 122 305 z m 243 -360 l 244 -360 l 241 -360 z m 243 340 l 244 340 l 241 340 z"
    },
    timeSig3: {
      x_min: 0,
      x_max: 302,
      y_min: -250,
      y_max: 236,
      ha: 486,
      o: "m 179 313 b 209 314 189 314 199 314 b 429 163 327 314 429 247 b 282 29 429 110 369 56 l 272 26 l 275 25 b 430 -111 354 -1 413 -53 b 435 -147 433 -123 435 -136 b 268 -308 435 -222 369 -288 b 211 -314 249 -312 230 -314 b 24 -241 140 -314 72 -288 b 0 -185 7 -224 0 -204 b 82 -100 0 -142 35 -100 b 97 -101 87 -100 92 -100 b 162 -180 140 -109 162 -145 b 113 -251 162 -209 146 -239 b 110 -253 111 -252 110 -252 b 120 -256 110 -253 113 -254 b 164 -261 136 -260 150 -261 b 248 -228 197 -261 226 -250 b 281 -145 270 -206 281 -178 b 278 -112 281 -135 280 -123 b 157 10 264 -42 215 7 b 135 27 141 11 135 16 b 157 44 135 39 141 43 b 272 137 210 47 257 85 b 276 162 275 145 276 154 b 194 256 276 206 244 245 b 167 258 188 258 178 258 b 124 255 152 258 136 257 l 119 254 l 123 252 b 162 186 149 238 162 212 b 108 110 162 154 144 121 b 83 105 100 107 91 105 b 0 189 37 105 0 144 b 8 224 0 200 3 212 b 179 313 28 266 103 305 z m 217 -360 l 219 -360 l 216 -360 z m 217 340 l 219 340 l 216 340 z"
    },
    timeSig4: {
      x_min: 0,
      x_max: 345,
      y_min: -250,
      y_max: 236,
      ha: 486,
      o: "m 184 302 b 304 303 186 303 247 303 b 403 302 354 303 401 303 b 412 286 409 299 412 294 b 392 256 412 280 411 278 b 260 108 374 236 318 173 b 222 67 243 89 226 71 b 165 3 218 62 193 34 b 90 -82 138 -28 104 -66 b 65 -111 77 -97 65 -110 b 64 -111 64 -111 64 -111 b 160 -112 64 -112 74 -112 l 257 -112 l 257 -43 b 259 27 257 24 257 25 b 307 82 259 28 281 53 b 373 156 332 110 362 144 b 409 188 402 189 401 188 b 425 179 416 188 422 185 b 426 32 426 176 426 171 l 426 -112 l 452 -112 b 481 -113 476 -112 477 -112 b 494 -134 489 -116 494 -125 b 488 -149 494 -139 492 -145 b 452 -156 482 -155 481 -156 l 426 -156 l 426 -162 b 427 -183 427 -165 427 -175 b 484 -269 428 -227 441 -248 b 497 -287 493 -274 497 -280 b 493 -298 497 -291 496 -295 b 397 -303 488 -303 499 -303 b 341 -303 382 -303 363 -303 b 285 -303 320 -303 301 -303 b 190 -298 184 -303 195 -303 b 185 -287 187 -295 185 -291 b 199 -269 185 -280 190 -274 b 256 -183 242 -248 255 -227 b 256 -162 256 -175 256 -165 l 257 -156 l 135 -156 b 90 -156 117 -156 102 -156 b 5 -151 2 -156 9 -155 b 0 -140 2 -148 0 -144 b 9 -122 0 -135 3 -129 b 174 272 110 -9 170 134 b 184 302 175 295 176 298 z m 249 -360 l 250 -360 l 247 -360 z m 249 340 l 250 340 l 247 340 z"
    },
    timeSig5: {
      x_min: 0,
      x_max: 302,
      y_min: -250,
      y_max: 236,
      ha: 486,
      o: "m 51 302 b 57 303 53 302 55 303 b 71 300 61 303 65 302 b 224 275 117 283 170 275 b 391 300 279 275 336 283 b 406 303 398 302 402 303 b 417 298 411 303 414 301 b 421 288 420 295 421 292 b 411 260 421 282 418 274 b 278 157 378 194 340 165 b 226 154 262 155 244 154 b 78 175 177 154 124 161 b 66 179 72 177 66 179 b 56 64 66 178 56 68 b 56 64 56 64 56 64 b 56 64 56 64 56 64 b 63 67 57 64 60 65 b 159 96 89 81 124 92 b 201 98 168 97 185 98 b 227 97 212 98 222 98 b 434 -104 351 80 434 -1 l 434 -105 b 239 -312 434 -208 353 -294 b 212 -314 230 -313 221 -314 b 23 -229 148 -314 76 -282 b 0 -174 7 -213 0 -193 b 82 -89 0 -131 35 -89 b 97 -90 87 -89 92 -89 b 162 -168 140 -98 162 -133 b 108 -242 162 -199 145 -230 l 102 -244 l 109 -247 b 159 -259 127 -255 143 -259 b 215 -241 178 -259 197 -253 b 281 -99 258 -212 281 -161 b 277 -51 281 -84 280 -68 b 211 62 267 6 241 51 l 205 64 l 189 64 b 57 24 142 64 96 50 b 37 14 43 14 42 14 b 20 30 26 14 20 20 b 43 293 20 41 42 290 b 51 302 44 297 48 300 z m 222 -276 b 222 -276 222 -276 222 -276 b 218 -277 221 -276 221 -276 b 216 -279 217 -278 216 -279 b 216 -279 216 -279 216 -279 b 222 -276 217 -279 222 -276 z m 217 -360 l 219 -360 l 216 -360 z m 217 340 l 219 340 l 216 340 z"
    },
    timeSig6: {
      x_min: 0,
      x_max: 349,
      y_min: -250,
      y_max: 236,
      ha: 486,
      o: "m 272 313 b 295 314 278 314 286 314 b 350 308 314 314 336 312 b 473 226 402 295 458 259 b 481 191 479 215 481 203 b 399 108 481 147 444 108 b 373 112 390 108 382 109 b 319 187 337 124 319 156 b 372 260 319 218 337 249 b 378 263 375 262 378 263 b 378 263 378 263 378 263 b 347 275 378 264 358 271 b 305 280 333 278 319 280 b 220 242 270 280 239 267 b 178 110 201 217 187 173 b 170 31 175 88 170 41 b 170 29 170 30 170 29 b 170 29 170 29 170 29 b 180 32 171 29 175 30 b 273 52 213 45 243 52 b 364 33 302 52 332 45 b 487 -64 422 11 466 -24 b 502 -128 497 -83 502 -105 b 479 -208 502 -156 494 -185 b 272 -314 439 -268 345 -314 b 239 -310 260 -314 249 -313 b 9 -77 129 -284 35 -188 b 0 6 3 -53 0 -23 b 5 65 0 26 2 47 b 272 313 27 193 137 296 z m 290 17 b 273 19 284 18 279 19 b 227 2 254 19 236 13 b 198 -122 209 -17 198 -69 b 201 -175 198 -140 199 -158 b 274 -280 214 -258 229 -280 l 274 -280 b 341 -193 315 -280 329 -262 b 349 -123 346 -166 349 -145 b 344 -66 349 -105 347 -87 b 290 17 334 -9 321 12 z m 251 -360 l 253 -360 l 250 -360 z m 251 340 l 253 340 l 250 340 z"
    },
    timeSig7: {
      x_min: 0,
      x_max: 326,
      y_min: -250,
      y_max: 236,
      ha: 486,
      o: "m 162 314 b 179 315 168 315 174 315 b 333 260 232 315 290 294 b 361 249 343 252 350 249 b 370 250 364 249 367 249 b 435 291 395 253 417 267 b 453 303 442 299 447 303 b 460 302 455 303 457 303 b 469 288 466 299 469 296 b 456 233 469 279 465 263 b 369 16 433 146 396 56 b 290 -268 322 -53 293 -159 b 280 -302 289 -295 289 -298 b 192 -303 278 -303 235 -303 b 105 -302 150 -303 107 -303 b 96 -281 98 -298 96 -294 b 96 -280 96 -280 96 -280 b 178 -54 96 -212 128 -124 b 279 57 207 -12 235 18 b 399 198 335 107 368 146 b 404 207 402 204 404 206 b 403 207 404 207 404 207 b 400 205 403 207 402 206 b 258 155 357 172 306 155 b 132 201 212 155 167 171 b 90 222 117 215 103 222 b 58 201 78 222 67 215 b 33 141 49 187 41 168 b 16 128 30 133 23 128 b 1 138 10 128 4 131 b 0 216 0 140 0 178 b 1 293 0 253 0 291 b 15 303 4 300 9 303 b 30 298 20 303 25 301 b 52 289 37 292 43 289 b 96 300 62 289 75 293 b 162 314 124 309 140 312 z m 234 -360 l 236 -360 l 233 -360 z m 234 340 l 236 340 l 233 340 z"
    },
    timeSig8: {
      x_min: 0,
      x_max: 360,
      y_min: -250,
      y_max: 236,
      ha: 486,
      o: "m 246 314 b 260 314 252 314 258 314 b 261 314 261 314 261 314 b 275 313 263 314 269 314 b 399 276 317 312 363 298 b 486 136 456 242 486 189 b 441 29 486 99 471 61 l 435 23 l 441 19 b 518 -119 492 -16 518 -67 b 483 -217 518 -153 507 -187 b 259 -314 435 -279 349 -314 b 138 -291 218 -314 176 -307 b 0 -118 48 -256 0 -187 b 76 18 0 -69 25 -20 l 83 23 l 77 30 b 32 137 48 61 32 99 b 42 189 32 155 36 172 b 246 314 70 260 152 310 z m 282 267 b 260 269 276 269 268 269 b 228 266 249 269 237 268 b 168 214 192 258 168 235 b 171 202 168 210 169 206 b 354 62 190 162 270 101 l 359 60 l 362 65 b 380 136 375 88 380 112 b 282 267 380 196 342 254 z m 148 -20 b 139 -16 144 -18 139 -16 b 139 -16 139 -16 139 -16 b 119 -36 137 -16 124 -29 b 91 -118 100 -62 91 -90 b 188 -255 91 -174 126 -229 b 257 -269 210 -265 234 -269 b 356 -229 298 -269 336 -255 b 368 -196 364 -218 368 -208 b 350 -151 368 -183 362 -168 b 166 -28 317 -101 256 -61 b 148 -20 161 -26 153 -23 z m 259 -360 l 261 -360 l 258 -360 z m 259 340 l 261 340 l 258 340 z"
    },
    timeSig9: {
      x_min: 0,
      x_max: 349,
      y_min: -250,
      y_max: 236,
      ha: 486,
      o: "m 208 313 b 227 314 214 314 220 314 b 332 284 259 314 295 304 b 497 61 420 236 480 155 b 503 -4 501 42 503 19 b 498 -65 503 -26 501 -47 b 279 -303 479 -176 393 -269 b 204 -314 253 -310 228 -314 b 98 -287 166 -314 130 -305 b 25 -216 58 -265 33 -241 b 22 -191 23 -208 22 -199 b 104 -108 22 -146 59 -108 b 130 -112 112 -108 121 -109 b 184 -187 166 -124 184 -156 b 131 -260 184 -218 166 -249 b 125 -263 128 -262 125 -263 b 125 -263 125 -263 125 -263 b 156 -275 125 -264 144 -271 b 197 -280 170 -278 184 -280 b 279 -247 231 -280 260 -269 b 324 -117 300 -223 313 -182 b 333 -31 328 -93 333 -42 b 332 -29 333 -30 333 -29 b 332 -29 332 -29 332 -29 b 323 -32 332 -29 328 -30 b 230 -52 289 -45 260 -52 b 173 -44 211 -52 192 -49 b 23 50 108 -27 51 9 b 0 128 8 74 0 101 b 34 222 0 161 11 194 b 208 313 70 266 142 304 z m 248 278 b 231 281 243 280 237 281 b 195 272 217 281 203 277 b 156 156 176 259 163 221 b 154 124 154 146 154 135 b 183 -2 154 72 166 16 b 230 -19 194 -13 212 -19 b 276 -2 248 -19 266 -13 b 305 122 294 17 305 69 b 301 175 305 140 304 158 b 248 278 290 246 278 270 z m 251 -360 l 253 -360 l 250 -360 z m 251 340 l 253 340 l 250 340 z"
    },
    timeSigCommon: {
      x_min: 0,
      x_max: 409,
      y_min: -233,
      y_max: 233,
      ha: 466,
      o: "m 315 334 b 343 336 324 335 334 336 b 558 227 431 336 512 296 b 575 174 570 210 575 192 b 475 74 575 122 533 74 b 472 74 474 74 473 74 b 380 167 417 76 380 120 b 402 225 380 187 387 207 b 469 256 418 244 444 256 b 484 254 474 256 479 255 b 487 254 485 254 487 254 b 488 254 488 254 488 254 b 479 260 488 254 485 256 b 346 302 439 289 398 302 l 345 302 b 154 -3 205 302 154 220 b 154 -3 154 -3 154 -3 b 316 -302 154 -225 195 -300 b 321 -302 318 -302 320 -302 b 556 -108 438 -302 536 -221 b 573 -87 558 -92 562 -87 b 589 -105 584 -87 589 -93 b 582 -144 589 -114 587 -127 b 393 -327 556 -233 484 -302 b 321 -336 371 -333 346 -336 b 248 -327 296 -336 271 -333 b 7 -69 125 -296 32 -196 b 0 -1 2 -46 0 -24 b 315 334 0 170 131 317 z"
    },
    timeSigCutCommon: {
      x_min: 0,
      x_max: 409,
      y_min: -394,
      y_max: 394,
      ha: 788,
      o: "m 308 566 b 316 568 311 567 314 568 b 337 554 325 568 334 562 b 338 446 338 550 338 549 l 338 341 l 355 341 b 558 232 437 339 514 298 b 575 179 570 216 575 197 b 475 79 575 128 533 79 b 472 79 474 79 473 79 b 380 172 417 81 380 126 b 402 231 380 192 387 213 b 469 261 418 250 444 261 b 484 260 474 261 479 261 b 487 259 485 259 487 259 b 488 259 488 259 488 259 b 479 266 488 260 485 262 b 354 307 442 292 400 306 l 338 308 l 338 6 l 338 -297 l 340 -296 b 347 -296 341 -296 344 -296 b 555 -103 449 -288 538 -205 b 573 -82 558 -87 562 -82 b 589 -100 584 -82 589 -87 b 582 -138 589 -109 587 -121 b 374 -326 554 -234 473 -307 b 342 -330 366 -327 356 -328 l 338 -330 l 338 -440 b 339 -489 338 -460 339 -476 b 332 -561 339 -563 338 -555 b 317 -568 328 -566 322 -568 b 296 -554 308 -568 299 -563 b 295 -440 295 -550 295 -549 l 295 -330 l 293 -329 b 282 -328 291 -329 287 -328 b 7 -63 146 -310 35 -203 b 0 4 2 -41 0 -18 b 259 331 0 156 103 291 b 294 338 269 333 292 338 b 295 444 295 338 295 385 b 296 554 295 549 295 550 b 308 566 298 559 303 564 z m 295 4 b 294 303 295 288 295 303 b 284 301 293 303 288 302 b 154 3 190 276 154 192 l 154 2 b 291 -295 154 -204 190 -283 l 295 -295 z"
    },
    timeSigPlus: {
      x_min: 0,
      x_max: 235,
      y_min: -118,
      y_max: 118,
      ha: 235,
      o: "m 159 168 b 169 169 162 169 166 169 b 198 153 180 169 192 163 b 202 97 202 146 202 147 l 202 87 l 202 33 l 257 33 l 267 33 b 322 29 317 33 315 33 b 339 0 333 22 339 11 b 323 -28 339 -11 333 -22 b 266 -33 315 -33 317 -33 l 257 -33 l 202 -33 l 202 -87 l 202 -97 b 198 -153 202 -148 202 -146 b 169 -169 191 -164 180 -169 b 141 -153 158 -169 147 -164 b 137 -97 137 -146 137 -147 l 137 -87 l 137 -33 l 82 -33 l 72 -33 b 16 -28 22 -33 23 -33 b 0 0 5 -22 0 -11 b 16 28 0 11 5 22 b 72 33 23 33 22 33 l 82 33 l 137 33 l 137 87 l 137 97 b 141 153 137 148 137 146 b 159 168 145 160 151 165 z"
    },
    timeSigPlusSmall: {
      x_min: 0,
      x_max: 235,
      y_min: -118,
      y_max: 118,
      ha: 235,
      o: "m 159 168 b 169 169 162 169 166 169 b 198 153 180 169 192 163 b 202 97 202 146 202 147 l 202 87 l 202 33 l 257 33 l 267 33 b 322 29 317 33 315 33 b 339 0 333 22 339 11 b 323 -28 339 -11 333 -22 b 266 -33 315 -33 317 -33 l 257 -33 l 202 -33 l 202 -87 l 202 -97 b 198 -153 202 -148 202 -146 b 169 -169 191 -164 180 -169 b 141 -153 158 -169 147 -164 b 137 -97 137 -146 137 -147 l 137 -87 l 137 -33 l 82 -33 l 72 -33 b 16 -28 22 -33 23 -33 b 0 0 5 -22 0 -11 b 16 28 0 11 5 22 b 72 33 23 33 22 33 l 82 33 l 137 33 l 137 87 l 137 97 b 141 153 137 148 137 146 b 159 168 145 160 151 165 z"
    },
    timeSigMinus: {
      x_min: 0,
      x_max: 235,
      y_min: -23,
      y_max: 23,
      ha: 46,
      o: "m 23 32 b 177 33 26 32 103 33 b 315 32 246 33 312 32 b 338 0 331 27 338 14 b 315 -32 338 -14 331 -27 b 169 -33 312 -33 241 -33 b 23 -32 98 -33 26 -33 b 0 0 8 -27 0 -14 b 23 32 0 13 8 26 z"
    },
    timeSigParensRight: {
      x_min: 19,
      x_max: 122,
      y_min: -267,
      y_max: 267,
      ha: 535,
      o: "m 36 384 b 44 385 38 385 41 385 b 65 367 52 385 55 383 b 176 0 139 251 176 126 b 65 -367 176 -125 139 -250 b 44 -385 56 -380 51 -385 b 36 -383 42 -385 39 -384 b 27 -370 30 -380 27 -377 b 33 -349 27 -365 29 -359 b 99 0 77 -242 99 -121 b 33 350 99 122 77 243 b 27 371 29 359 27 366 b 36 384 27 377 30 381 z"
    },
    timeSigParensRightSmall: {
      x_min: 19,
      x_max: 122,
      y_min: -267,
      y_max: 267,
      ha: 535,
      o: "m 36 384 b 44 385 38 385 41 385 b 65 367 52 385 55 383 b 176 0 139 251 176 126 b 65 -367 176 -125 139 -250 b 44 -385 56 -380 51 -385 b 36 -383 42 -385 39 -384 b 27 -370 30 -380 27 -377 b 33 -349 27 -365 29 -359 b 99 0 77 -242 99 -121 b 33 350 99 122 77 243 b 27 371 29 359 27 366 b 36 384 27 377 30 381 z"
    },
    timeSigParensLeft: {
      x_min: -122,
      x_max: -19,
      y_min: -267,
      y_max: 267,
      ha: 534,
      o: "m -51 383 b -44 385 -49 384 -46 385 b -29 375 -38 385 -31 381 b -27 369 -28 373 -27 372 b -33 349 -27 365 -29 360 b -98 54 -71 259 -91 167 b -99 0 -98 44 -99 22 b -98 -54 -99 -22 -98 -45 b -33 -349 -91 -167 -71 -259 b -27 -368 -28 -363 -27 -365 b -44 -385 -27 -378 -34 -385 b -65 -367 -52 -385 -55 -383 b -176 0 -139 -251 -176 -125 b -65 367 -176 125 -139 251 b -51 383 -57 379 -55 381 z"
    },
    timeSigParensLeftSmall: {
      x_min: -122,
      x_max: -19,
      y_min: -267,
      y_max: 267,
      ha: 534,
      o: "m -51 383 b -44 385 -49 384 -46 385 b -29 375 -38 385 -31 381 b -27 369 -28 373 -27 372 b -33 349 -27 365 -29 360 b -98 54 -71 259 -91 167 b -99 0 -98 44 -99 22 b -98 -54 -99 -22 -98 -45 b -33 -349 -91 -167 -71 -259 b -27 -368 -28 -363 -27 -365 b -44 -385 -27 -378 -34 -385 b -65 -367 -52 -385 -55 -383 b -176 0 -139 -251 -176 -125 b -65 367 -176 125 -139 251 b -51 383 -57 379 -55 381 z"
    },
    noteheadDoubleWhole: {
      x_min: 0,
      x_max: 663,
      y_min: -174,
      y_max: 174,
      ha: 349,
      o: "m 19 250 b 27 251 21 251 24 251 b 36 250 31 251 34 251 b 50 239 41 248 47 244 b 55 93 54 233 55 247 b 55 0 55 67 55 37 b 55 -93 55 -37 55 -67 b 50 -239 55 -247 54 -233 b 28 -251 45 -247 36 -251 b 1 -232 16 -251 5 -244 b 0 4 0 -230 0 -112 b 1 232 0 117 0 230 b 19 250 4 240 11 247 z m 117 250 b 126 251 119 251 122 251 b 134 250 129 251 132 251 b 152 232 142 247 149 240 b 153 128 153 229 153 214 b 154 31 153 48 153 31 b 154 31 154 31 154 31 b 417 191 176 112 281 176 b 478 194 437 193 458 194 b 801 31 636 194 776 127 b 801 31 801 31 801 31 b 802 128 802 31 802 48 b 805 237 802 235 802 232 b 830 251 811 246 821 251 b 852 239 839 251 847 247 b 857 93 857 233 857 247 b 857 0 857 67 857 37 b 857 -93 857 -37 857 -67 b 852 -239 857 -247 857 -233 b 830 -251 847 -247 838 -251 b 807 -239 821 -251 812 -247 b 802 -128 802 -232 802 -239 b 801 -31 802 -48 802 -31 b 801 -31 801 -31 801 -31 b 539 -191 779 -112 675 -176 b 477 -194 518 -193 498 -194 b 154 -31 319 -194 180 -127 b 154 -31 154 -31 154 -31 b 153 -128 153 -31 153 -48 b 148 -239 153 -239 153 -232 b 126 -251 143 -247 134 -251 b 99 -232 114 -251 103 -244 b 98 4 99 -230 98 -112 b 99 232 98 117 99 230 b 117 250 102 240 109 247 z m 458 168 b 439 169 452 169 445 169 b 332 44 375 169 332 116 b 344 -25 332 22 336 -1 b 517 -169 377 -116 452 -169 b 613 -101 558 -169 595 -148 b 623 -44 620 -83 623 -64 b 458 168 623 50 549 154 z m 919 250 b 928 251 921 251 924 251 b 936 250 931 251 934 251 b 951 239 942 248 947 244 b 955 93 955 233 955 247 b 955 0 955 67 955 36 b 955 -93 955 -37 955 -67 b 951 -239 955 -247 955 -233 b 928 -251 945 -247 937 -251 b 902 -232 917 -251 905 -244 b 900 4 901 -230 900 -112 b 901 232 900 117 901 230 b 919 250 904 240 911 247 z"
    },
    noteheadWhole: {
      x_min: 0,
      x_max: 455,
      y_min: -135,
      y_max: 135,
      ha: 269,
      o: "m 291 193 b 326 194 303 194 315 194 b 649 38 482 194 619 129 b 655 0 653 25 655 12 b 327 -194 655 -106 513 -194 b 0 0 144 -194 0 -109 b 291 193 0 100 124 182 z m 308 168 b 289 169 301 169 295 169 b 181 44 224 169 181 116 b 194 -26 181 22 185 -1 b 366 -169 226 -116 302 -169 b 463 -101 408 -169 445 -148 b 473 -45 470 -83 473 -64 b 308 168 473 50 398 154 z"
    },
    noteheadHalf: {
      x_min: 0,
      x_max: 316,
      y_min: -135,
      y_max: 135,
      ha: 269,
      o: "m 270 193 b 281 194 272 194 276 194 b 322 192 294 194 315 193 b 455 53 411 178 455 120 b 307 -156 455 -20 405 -104 b 166 -194 260 -182 211 -194 b 3 -81 84 -194 17 -153 b 0 -52 1 -72 0 -62 b 270 193 0 62 123 178 z m 388 139 b 372 141 383 140 378 141 b 99 -26 307 141 174 61 b 50 -116 68 -62 50 -96 b 60 -136 50 -125 53 -132 b 83 -141 66 -139 74 -141 b 367 40 152 -141 296 -52 b 405 115 392 72 405 98 b 388 139 405 127 399 135 z"
    },
    noteheadBlack: {
      x_min: 0,
      x_max: 316,
      y_min: -135,
      y_max: 135,
      ha: 269,
      o: "m 270 193 b 281 194 272 194 276 194 b 322 192 294 194 315 193 b 455 53 411 178 455 120 b 307 -156 455 -20 405 -104 b 166 -194 260 -182 211 -194 b 3 -81 84 -194 17 -153 b 0 -52 1 -72 0 -62 b 270 193 0 62 123 178 z"
    },
    noteheadXWhole: {
      x_min: 0,
      x_max: 440,
      y_min: -133,
      y_max: 133,
      ha: 265,
      o: "m 67 190 b 82 191 71 191 76 191 b 97 190 88 191 94 191 b 216 138 108 188 116 184 l 317 91 l 417 138 b 548 191 529 190 532 191 b 551 191 549 191 550 191 b 634 109 601 191 634 151 b 611 52 634 89 627 69 b 549 17 601 41 597 39 b 513 0 529 8 513 0 b 549 -17 513 0 529 -8 b 611 -52 597 -39 601 -41 b 634 -109 627 -69 634 -89 b 551 -191 634 -151 601 -191 b 548 -191 550 -191 549 -191 b 417 -138 532 -191 529 -190 l 317 -91 l 216 -138 b 86 -191 105 -190 102 -191 b 83 -191 85 -191 84 -191 b 0 -109 33 -191 0 -151 b 23 -52 0 -89 7 -69 b 85 -17 33 -41 37 -39 b 121 0 105 -8 121 0 b 85 17 121 0 105 8 b 23 52 37 39 33 41 b 0 109 7 69 0 89 b 67 190 0 146 26 182 z m 91 141 b 82 142 88 142 85 142 b 49 109 63 142 49 126 b 59 86 49 101 52 92 b 159 37 64 81 55 85 b 238 0 202 17 238 0 b 159 -37 238 0 202 -17 b 59 -86 55 -85 64 -81 b 49 -109 52 -92 49 -101 b 82 -142 49 -126 62 -142 l 82 -142 b 206 -88 91 -142 91 -141 b 317 -37 267 -60 317 -37 b 428 -88 317 -37 367 -60 b 551 -142 542 -141 543 -142 l 552 -142 b 584 -109 572 -142 584 -126 b 574 -86 584 -101 581 -92 b 475 -37 569 -81 578 -85 b 396 0 431 -17 396 0 b 475 37 396 0 431 17 b 574 86 578 85 569 81 b 584 109 581 92 584 101 b 552 142 584 126 572 142 l 551 142 b 428 88 543 142 542 141 b 317 37 367 60 317 37 b 206 88 317 37 267 60 b 91 141 145 117 93 140 z"
    },
    noteheadXHalf: {
      x_min: 0,
      x_max: 300,
      y_min: -133,
      y_max: 133,
      ha: 265,
      o: "m 60 189 b 76 191 65 190 71 191 b 118 179 91 191 106 187 b 169 138 121 177 144 159 l 216 100 l 262 138 b 325 185 312 179 314 181 b 355 191 335 189 345 191 b 431 115 397 191 431 156 b 426 86 431 105 430 96 b 372 29 419 69 415 64 b 337 0 353 14 337 0 b 372 -29 337 0 353 -14 b 426 -86 415 -64 419 -69 b 431 -115 430 -96 431 -105 b 355 -191 431 -156 397 -191 b 325 -185 345 -191 335 -189 b 262 -138 314 -181 312 -179 l 216 -100 l 169 -138 b 106 -185 120 -179 117 -181 b 76 -191 96 -189 86 -191 b 0 -115 35 -191 0 -156 b 6 -86 0 -105 2 -96 b 59 -29 12 -69 17 -64 b 94 0 78 -14 94 0 b 59 29 94 0 78 14 b 20 63 40 45 22 61 b 0 114 6 78 0 97 b 60 189 0 148 23 181 z m 88 140 b 77 142 85 141 81 142 b 56 133 69 142 61 139 b 49 115 51 128 49 121 b 55 98 49 109 51 103 b 114 48 56 96 82 74 b 171 0 146 22 171 0 b 114 -48 171 0 146 -22 b 55 -98 82 -74 56 -96 b 49 -114 51 -103 49 -109 b 65 -140 49 -125 55 -135 b 77 -142 68 -141 72 -142 b 88 -140 81 -142 85 -141 b 154 -87 91 -138 114 -120 b 216 -36 188 -59 216 -36 b 278 -87 216 -36 244 -59 b 343 -140 318 -120 341 -138 b 355 -142 346 -141 350 -142 b 367 -140 359 -142 364 -141 b 382 -114 377 -135 382 -125 b 377 -98 382 -109 381 -103 b 317 -48 376 -96 349 -74 b 260 0 286 -22 260 0 b 317 48 260 0 286 22 b 377 98 349 74 376 96 b 382 114 381 103 382 109 b 367 140 382 125 377 135 b 355 142 364 141 359 142 b 343 140 350 142 346 141 b 278 87 341 138 318 120 b 216 36 244 59 216 36 b 154 87 216 36 188 59 b 88 140 112 121 91 138 z"
    },
    noteheadXBlack: {
      x_min: 0,
      x_max: 300,
      y_min: -133,
      y_max: 133,
      ha: 265,
      o: "m 24 190 b 32 191 26 191 29 191 b 46 189 37 191 43 190 b 135 114 52 186 50 187 b 216 44 179 76 216 44 b 296 114 216 44 252 76 b 396 191 392 197 384 190 b 398 191 397 191 398 191 b 432 158 418 191 432 175 b 422 135 432 150 429 142 b 343 66 420 133 384 102 b 267 0 301 30 267 0 b 343 -66 267 0 301 -30 b 422 -135 384 -102 420 -133 b 432 -158 429 -142 432 -150 b 398 -191 432 -175 418 -191 b 396 -191 398 -191 397 -191 b 296 -114 384 -190 392 -197 b 216 -44 252 -76 216 -44 b 135 -114 216 -44 179 -76 b 35 -191 40 -197 48 -190 b 33 -191 35 -191 34 -191 b 0 -158 13 -191 0 -175 b 10 -135 0 -150 3 -142 b 89 -66 12 -133 48 -102 b 164 0 131 -30 164 0 b 89 66 164 0 131 30 b 10 135 48 102 12 133 b 0 158 3 142 0 150 b 24 190 0 172 9 186 z"
    },
    noteheadCircleX: {
      x_min: 0,
      x_max: 357,
      y_min: -178,
      y_max: 178,
      ha: 357,
      o: "m 242 256 b 256 257 249 257 253 257 b 270 256 260 257 263 257 b 514 0 412 248 514 131 b 496 -95 514 -31 508 -63 b 255 -257 454 -200 355 -257 b 61 -166 184 -257 112 -228 b 0 -2 19 -117 0 -58 b 242 256 0 126 96 248 z m 267 190 b 257 191 262 190 259 191 b 245 190 254 191 251 190 b 153 159 212 188 179 177 l 147 156 l 202 101 l 257 46 l 311 101 l 366 156 l 361 159 b 267 190 334 177 302 188 z m 155 -55 l 210 0 l 155 54 l 101 109 l 97 104 b 66 0 77 74 66 37 b 71 -44 66 -15 68 -30 b 97 -105 77 -66 86 -87 l 101 -110 z m 416 104 b 413 109 414 107 413 109 b 358 54 413 109 388 84 l 304 0 l 358 -55 l 413 -110 l 416 -105 b 447 0 437 -74 447 -37 b 416 104 447 36 437 73 z m 312 -102 b 257 -47 282 -72 257 -47 b 202 -102 257 -47 232 -72 l 147 -156 l 153 -160 b 257 -191 183 -180 220 -191 b 361 -160 294 -191 330 -180 l 366 -156 z"
    },
    noteheadTriangleUpWhole: {
      x_min: 0,
      x_max: 462,
      y_min: -149,
      y_max: 149,
      ha: 297,
      o: "m 326 213 b 333 214 327 214 330 214 b 355 194 342 214 344 212 b 647 -174 447 44 562 -101 b 659 -184 652 -178 657 -182 b 666 -198 664 -188 666 -193 b 650 -214 666 -207 660 -214 b 598 -200 645 -214 641 -213 b 333 -161 514 -174 423 -161 b 68 -200 242 -161 152 -174 b 16 -214 25 -213 20 -214 b 0 -198 7 -214 0 -208 b 12 -179 0 -190 1 -189 b 311 194 100 -106 216 40 b 326 213 320 208 322 211 z m 338 141 b 333 153 336 147 333 153 b 327 141 333 153 330 147 b 190 -130 285 41 232 -63 b 185 -138 187 -134 185 -138 b 185 -138 185 -138 185 -138 b 185 -138 185 -138 185 -138 b 195 -137 187 -138 190 -138 b 224 -134 201 -136 214 -135 b 333 -128 260 -130 296 -128 b 410 -131 359 -128 384 -129 b 470 -137 425 -132 454 -135 b 480 -138 475 -138 479 -138 b 481 -138 481 -138 481 -138 b 481 -138 481 -138 481 -138 b 478 -133 481 -138 479 -135 b 338 141 436 -67 381 40 z"
    },
    noteheadTriangleUpHalf: {
      x_min: 0,
      x_max: 323,
      y_min: -149,
      y_max: 149,
      ha: 298,
      o: "m 225 213 b 232 214 227 214 230 214 b 253 191 242 214 245 212 b 447 -169 316 42 385 -85 b 465 -198 461 -187 465 -193 b 463 -204 465 -200 464 -202 b 450 -214 461 -211 457 -214 b 431 -208 446 -214 439 -212 b 233 -162 368 -178 300 -162 b 33 -208 165 -162 97 -178 b 15 -214 25 -212 19 -214 b 5 -209 11 -214 8 -213 b 0 -199 2 -206 0 -203 b 9 -181 0 -194 3 -188 b 213 194 67 -109 149 42 b 225 213 218 208 220 211 z m 280 51 b 264 85 274 62 267 78 l 258 98 l 248 83 b 93 -135 201 9 143 -73 b 87 -143 90 -139 87 -143 b 87 -144 87 -144 87 -144 b 87 -144 87 -144 87 -144 b 94 -141 87 -144 90 -142 b 297 -98 162 -113 233 -98 b 354 -102 317 -98 336 -99 b 363 -104 359 -103 363 -104 b 363 -104 363 -104 363 -104 b 360 -97 363 -103 361 -101 b 280 51 337 -60 304 2 z"
    },
    noteheadTriangleUpBlack: {
      x_min: 0,
      x_max: 322,
      y_min: -149,
      y_max: 149,
      ha: 297,
      o: "m 224 213 b 232 214 226 213 229 214 b 250 197 241 214 244 211 b 277 135 269 152 270 149 b 288 111 280 127 285 117 b 336 12 296 92 330 23 b 344 -3 336 12 340 5 b 376 -60 360 -32 363 -38 b 452 -177 406 -112 430 -148 b 463 -198 463 -191 463 -191 b 447 -214 463 -208 458 -214 l 447 -214 l 441 -214 l 430 -208 b 232 -163 368 -178 300 -163 b 33 -208 163 -163 95 -178 l 22 -214 l 16 -214 l 16 -214 b 0 -198 6 -214 0 -208 b 11 -177 0 -191 0 -191 b 75 -81 29 -154 52 -120 b 119 -3 93 -52 102 -36 b 127 12 123 5 127 12 b 176 111 133 23 167 92 b 186 135 178 117 183 127 b 213 197 193 149 194 152 b 224 213 218 207 220 210 z"
    },
    noteheadDiamondWhole: {
      x_min: 0,
      x_max: 462,
      y_min: -138,
      y_max: 138,
      ha: 277,
      o: "m 326 198 b 333 199 328 199 330 199 b 350 189 340 199 342 198 b 638 20 417 112 517 53 b 654 16 645 19 652 17 b 666 0 662 14 666 7 b 654 -16 666 -7 662 -14 b 638 -20 652 -17 645 -19 b 352 -186 518 -53 419 -110 b 333 -199 342 -198 340 -199 b 316 -189 326 -199 324 -198 b 28 -20 249 -112 149 -53 b 12 -16 21 -19 14 -17 b 0 0 4 -14 0 -7 b 12 16 0 7 4 14 b 28 20 14 17 21 19 b 316 189 149 53 249 112 b 326 198 321 194 324 197 z m 338 143 b 333 149 335 146 333 149 b 328 143 333 149 331 146 b 172 4 290 85 233 35 b 165 0 168 2 165 0 b 172 -4 165 0 168 -2 b 328 -143 233 -35 290 -85 b 333 -149 331 -147 332 -149 b 335 -146 334 -149 334 -148 b 494 -4 370 -91 432 -35 b 501 0 498 -2 501 0 b 494 4 501 0 498 2 b 338 143 433 35 376 85 z"
    },
    noteheadDiamondHalf: {
      x_min: 0,
      x_max: 322,
      y_min: -138,
      y_max: 138,
      ha: 277,
      o: "m 225 198 b 232 199 227 199 229 199 b 251 183 240 199 243 197 b 445 19 295 109 362 52 b 464 0 461 13 464 10 b 447 -18 464 -9 460 -13 b 251 -183 365 -49 294 -109 b 232 -199 243 -197 240 -199 b 213 -183 224 -199 221 -197 b 19 -19 169 -109 102 -52 b 0 0 3 -13 0 -10 b 17 18 0 9 3 13 b 213 183 99 50 169 109 b 225 198 218 193 221 196 z m 255 119 b 251 122 253 121 252 122 b 244 114 250 122 249 120 b 98 -17 208 61 151 10 l 95 -19 l 98 -21 b 211 -120 138 -44 176 -78 b 213 -123 212 -122 212 -123 b 213 -122 213 -123 213 -122 b 366 17 244 -72 311 -11 l 369 19 l 366 21 b 255 119 327 44 283 82 z"
    },
    noteheadDiamondBlack: {
      x_min: 0,
      x_max: 322,
      y_min: -138,
      y_max: 138,
      ha: 277,
      o: "m 225 198 b 232 199 227 199 229 199 b 253 180 241 199 243 197 b 444 19 297 107 363 52 b 464 0 461 13 464 10 b 444 -19 464 -10 461 -13 b 253 -180 363 -52 297 -107 b 232 -199 243 -197 241 -199 b 211 -180 223 -199 221 -197 b 19 -19 167 -107 101 -52 b 0 0 3 -13 0 -10 b 19 19 0 10 3 13 b 211 180 101 52 167 107 b 225 198 219 194 221 196 z"
    },
    augmentationDot: {
      x_min: -63,
      x_max: 63,
      y_min: -63,
      y_max: 63,
      ha: 126,
      o: "m -18 89 b 0 90 -12 90 -6 90 b 90 0 49 90 90 49 b 89 -18 90 -6 90 -12 b -1 -90 79 -64 39 -90 b -70 -57 -26 -90 -52 -80 b -90 -1 -84 -40 -90 -20 b -18 89 -90 40 -63 79 z"
    },
    tremolo1: {
      x_min: -252,
      x_max: 216,
      y_min: -185,
      y_max: 148,
      ha: 333,
      o: "m 265 211 b 275 213 269 212 272 213 b 311 175 295 213 311 194 b 301 151 311 166 308 158 b 243 110 297 147 295 145 b 175 64 224 97 194 77 b 107 18 156 52 126 31 b 40 -27 89 6 58 -15 b -28 -73 21 -40 -9 -60 b -95 -119 -46 -86 -77 -106 b -162 -164 -113 -131 -144 -152 b -230 -210 -181 -177 -211 -197 b -285 -247 -249 -223 -274 -240 b -310 -263 -297 -255 -308 -263 b -326 -267 -315 -266 -321 -267 b -363 -230 -346 -267 -363 -250 b -357 -212 -363 -224 -361 -218 b -309 -174 -353 -205 -350 -202 b -203 -103 -287 -160 -240 -128 b -68 -11 -167 -78 -106 -37 b 67 80 -30 14 31 55 b 194 166 104 105 161 143 b 265 211 255 207 259 210 z"
    },
    flag8thUp: {
      x_min: -17,
      x_max: 234,
      y_min: -745,
      y_max: -4,
      ha: 741,
      o: "m -25 -167 l -25 -5 l -21 -5 b 1 -29 -9 -5 -3 -12 b 183 -326 32 -144 91 -241 b 336 -686 285 -421 336 -551 b 219 -1028 336 -802 298 -923 b 172 -1072 191 -1065 183 -1072 b 150 -1052 158 -1072 150 -1063 b 158 -1032 150 -1046 153 -1039 b 284 -707 241 -935 284 -818 b 185 -446 284 -610 251 -517 b -24 -328 144 -402 72 -361 b -25 -167 -24 -328 -25 -295 z"
    },
    flag8thDown: {
      x_min: -15,
      x_max: 271,
      y_min: 4,
      y_max: 745,
      ha: 741,
      o: "m 242 1071 b 252 1073 246 1072 249 1073 b 277 1051 260 1073 267 1066 b 390 687 352 938 390 810 b 343 464 390 609 374 533 b 248 331 319 413 285 365 b 60 125 166 256 110 194 b 0 21 35 90 10 47 b -19 5 -4 11 -12 5 l -22 5 l -22 167 l -22 328 l -17 328 b 105 350 13 328 69 338 b 334 722 241 396 334 547 b 240 1027 334 826 301 934 b 229 1050 230 1041 229 1044 b 242 1071 229 1060 234 1068 z"
    },
    flag16thUp: {
      x_min: -17,
      x_max: 234,
      y_min: -847,
      y_max: -4,
      ha: 843,
      o: "m -25 -151 l -25 -5 l -21 -5 b 0 -23 -11 -5 -5 -11 b 208 -289 31 -96 103 -189 b 336 -592 292 -369 336 -477 b 311 -740 336 -641 328 -691 l 308 -751 l 312 -762 b 336 -906 328 -808 336 -857 b 241 -1185 336 -1004 304 -1103 b 202 -1220 218 -1215 213 -1220 b 180 -1198 188 -1220 180 -1210 b 187 -1181 180 -1193 182 -1187 b 286 -923 252 -1106 286 -1015 b 283 -873 286 -906 285 -890 b 278 -844 281 -861 279 -849 b 274 -830 277 -842 276 -836 b 152 -651 255 -758 210 -692 b -10 -612 119 -628 51 -612 b -22 -611 -16 -612 -21 -612 l -25 -611 l -25 -465 l -25 -319 l -21 -319 b 0 -336 -11 -319 -5 -325 b 207 -602 31 -410 105 -504 b 275 -685 235 -628 260 -658 b 277 -688 276 -687 277 -688 b 280 -680 278 -688 279 -685 b 286 -609 284 -657 286 -633 b 280 -541 286 -586 284 -563 b 278 -530 280 -537 279 -532 b 274 -516 277 -528 276 -522 b 152 -337 255 -444 210 -378 b -10 -298 119 -315 51 -298 b -22 -298 -16 -298 -21 -298 l -25 -297 z"
    },
    flag16thDown: {
      x_min: -15,
      x_max: 267,
      y_min: 4,
      y_max: 745,
      ha: 741,
      o: "m 319 1071 b 328 1073 322 1072 325 1073 b 350 1054 337 1073 344 1067 b 384 901 373 1008 384 955 b 360 766 384 856 376 810 l 356 756 l 360 745 b 384 615 376 703 384 659 b 273 336 384 516 346 416 b 217 282 258 319 241 302 b -1 19 125 204 42 104 b -19 5 -5 11 -13 5 l -22 5 l -22 146 l -22 287 l -12 288 b 212 369 90 304 162 330 b 339 620 294 433 339 524 b 330 691 339 644 336 668 l 329 699 l 323 690 b 217 569 296 645 265 610 b -1 305 125 491 42 390 b -19 292 -5 297 -13 292 l -22 292 l -22 433 l -22 573 l -12 575 b 194 643 78 589 147 611 b 339 908 286 704 339 806 b 313 1030 339 950 330 991 b 306 1050 306 1045 306 1045 b 319 1071 306 1060 311 1068 z"
    },
    flag32ndUp: {
      x_min: -17,
      x_max: 233,
      y_min: -1005,
      y_max: 96,
      ha: 1101,
      o: "m -25 -6 l -25 139 l -21 139 b 1 121 -11 139 -6 134 b 172 -93 31 61 97 -21 b 201 -121 182 -103 195 -115 b 328 -375 266 -184 311 -274 b 335 -464 333 -404 335 -434 b 317 -612 335 -513 329 -564 l 313 -626 l 315 -632 b 328 -689 320 -647 325 -670 b 335 -778 333 -717 335 -747 b 317 -926 335 -827 329 -878 l 313 -940 l 315 -946 b 328 -1002 320 -961 325 -984 b 335 -1092 333 -1032 335 -1062 b 280 -1346 335 -1177 316 -1264 b 228 -1441 265 -1380 236 -1432 b 213 -1447 224 -1445 218 -1447 b 191 -1425 202 -1447 191 -1438 b 198 -1406 191 -1419 192 -1416 b 284 -1118 254 -1317 284 -1215 b 281 -1072 284 -1103 283 -1087 b 118 -798 269 -948 207 -844 b 6 -778 93 -785 60 -779 l -25 -778 l -25 -634 l -25 -489 l -21 -489 b 1 -507 -11 -489 -6 -494 b 172 -720 31 -567 97 -649 b 275 -848 229 -774 249 -800 l 281 -858 l 282 -849 b 284 -806 283 -834 284 -820 b 118 -484 284 -663 220 -537 b 6 -465 93 -471 60 -465 l -25 -464 l -25 -320 l -25 -175 l -21 -175 b 1 -193 -11 -175 -6 -180 b 172 -406 31 -253 97 -335 b 275 -534 229 -460 249 -486 l 281 -544 l 282 -535 b 284 -492 283 -521 284 -506 b 118 -170 284 -349 220 -223 b 6 -151 93 -157 60 -151 l -25 -151 z"
    },
    flag32ndDown: {
      x_min: -15,
      x_max: 270,
      y_min: -96,
      y_max: 895,
      ha: 991,
      o: "m 292 1287 b 300 1288 294 1288 297 1288 b 309 1287 303 1288 306 1288 b 374 1151 324 1281 359 1209 b 388 1039 383 1115 388 1077 b 368 904 388 993 381 947 l 365 896 l 368 886 b 374 864 370 881 372 871 b 388 752 383 828 388 790 b 368 618 388 706 381 660 l 365 609 l 368 599 b 374 578 370 594 372 584 b 388 467 384 541 388 504 b 236 128 388 339 334 215 b 201 99 226 119 226 119 b 0 -122 110 27 36 -55 b -19 -139 -5 -133 -12 -139 l -22 -139 l -22 0 l -22 138 l -16 138 b 200 215 66 150 144 178 b 340 485 287 273 340 376 b 336 531 340 501 339 516 l 335 540 l 333 537 b 236 415 306 488 275 449 b 201 385 226 406 226 405 b 0 164 110 313 36 231 b -19 148 -5 153 -12 148 l -22 148 l -22 286 l -22 424 l -16 425 b 200 501 66 437 144 464 b 340 772 287 559 340 663 b 336 818 340 787 339 803 l 335 827 l 333 823 b 236 701 306 774 275 735 b 201 672 226 692 226 692 b 0 451 110 600 36 518 b -19 434 -5 440 -12 434 l -22 434 l -22 572 l -22 711 l -16 711 b 219 802 77 725 165 759 b 339 1058 298 865 339 959 b 286 1246 339 1122 322 1187 b 278 1267 279 1258 278 1260 b 292 1287 278 1276 284 1284 z"
    },
    flag64thUp: {
      x_min: -17,
      x_max: 233,
      y_min: -933,
      y_max: 296,
      ha: 1230,
      o: "m -25 282 l -25 427 l -21 427 b 2 404 -9 427 -4 421 b 148 203 25 333 72 268 b 313 -42 230 134 277 64 b 335 -182 328 -86 335 -134 b 309 -332 335 -233 327 -284 l 307 -339 l 312 -354 b 335 -496 328 -399 335 -447 b 309 -646 335 -547 327 -598 l 307 -653 l 312 -668 b 335 -809 328 -713 335 -761 b 309 -960 335 -860 327 -911 l 307 -966 l 312 -981 b 335 -1122 328 -1027 335 -1075 b 288 -1325 335 -1191 320 -1260 b 265 -1344 281 -1340 276 -1344 b 243 -1322 252 -1344 243 -1335 b 251 -1300 243 -1317 243 -1316 b 289 -1125 276 -1244 289 -1184 b 173 -854 289 -1018 248 -915 b 34 -798 127 -816 83 -798 b -9 -802 20 -798 5 -800 b -21 -804 -14 -803 -20 -804 l -25 -804 l -25 -659 l -25 -515 l -21 -515 b 2 -537 -9 -515 -4 -520 b 148 -738 25 -609 72 -673 b 274 -892 204 -785 247 -838 b 279 -900 277 -898 279 -900 b 280 -898 280 -900 280 -899 b 282 -886 280 -897 281 -892 b 289 -811 287 -861 289 -836 b 173 -540 289 -703 246 -600 b 34 -484 127 -502 83 -484 b -9 -489 20 -484 5 -486 b -21 -490 -14 -489 -20 -490 l -25 -490 l -25 -346 l -25 -201 l -21 -201 b 2 -224 -9 -201 -4 -207 b 148 -424 25 -295 72 -360 b 274 -578 204 -471 247 -524 b 279 -586 277 -584 279 -586 b 280 -584 280 -586 280 -585 b 282 -573 280 -583 281 -578 b 289 -497 287 -548 289 -522 b 173 -226 289 -389 246 -286 b 34 -171 127 -188 83 -171 b -9 -175 20 -171 5 -172 b -21 -176 -14 -176 -20 -176 l -25 -176 l -25 -32 l -25 113 l -21 113 b 2 90 -9 113 -4 107 b 148 -110 25 19 72 -46 b 274 -264 204 -158 247 -210 b 279 -272 277 -270 279 -272 b 280 -270 280 -272 280 -272 b 282 -259 280 -269 281 -264 b 289 -184 287 -234 289 -208 b 173 88 289 -75 246 28 b 34 143 127 125 83 143 b -9 139 20 143 5 142 b -21 137 -14 138 -20 137 l -25 137 z"
    },
    flag64thDown: {
      x_min: -15,
      x_max: 271,
      y_min: -296,
      y_max: 820,
      ha: 1116,
      o: "m 272 1179 b 281 1181 275 1180 278 1181 b 297 1174 286 1181 292 1178 b 359 1098 322 1154 344 1127 b 390 972 380 1059 390 1016 b 357 836 390 926 379 879 l 351 825 l 353 823 b 359 812 354 822 357 817 b 390 685 380 773 390 729 b 357 549 390 639 379 593 l 351 539 l 353 536 b 359 526 354 535 357 530 b 390 399 380 486 390 443 b 357 263 390 353 379 306 l 351 252 l 353 250 b 390 113 374 218 390 162 b 390 113 390 113 390 113 b 246 -148 390 9 339 -84 b -1 -411 129 -228 30 -334 b -18 -426 -4 -420 -11 -426 l -22 -427 l -22 -291 l -22 -156 l -13 -155 b 156 -124 51 -152 115 -140 b 338 126 266 -80 338 23 b 326 195 338 150 334 173 b 321 207 324 204 323 207 b 318 203 321 207 319 205 b 246 139 299 180 276 159 b -1 -125 129 59 30 -48 b -18 -140 -4 -134 -11 -139 l -22 -140 l -22 -5 l -22 131 l -13 131 b 156 163 51 134 115 146 b 338 413 266 206 338 310 b 326 482 338 436 334 459 b 321 493 324 490 323 493 b 318 489 321 493 319 492 b 246 425 299 466 276 446 b -1 162 129 345 30 239 b -18 147 -4 153 -11 147 l -22 146 l -22 282 l -22 417 l -13 418 b 156 449 51 421 115 433 b 338 699 266 493 338 596 b 326 768 338 723 334 746 b 321 780 324 777 323 780 b 318 776 320 780 319 778 b 246 712 299 753 276 732 b -1 448 129 632 30 525 b -19 433 -4 439 -11 434 l -22 433 l -22 568 l -22 704 l -13 704 b 156 736 51 707 115 719 b 338 985 264 778 337 879 l 338 985 b 272 1137 338 1045 313 1103 b 259 1159 262 1146 259 1150 b 272 1179 259 1168 265 1176 z"
    },
    flag128thUp: {
      x_min: -17,
      x_max: 231,
      y_min: -987,
      y_max: 496,
      ha: 1484,
      o: "m -25 582 l -25 715 l -21 715 b 3 693 -11 715 -6 710 b 150 501 30 639 82 570 b 237 396 191 459 212 434 b 333 93 300 302 333 195 b 311 -46 333 45 326 -2 b 307 -60 308 -54 307 -57 b 310 -72 307 -63 308 -65 b 332 -220 325 -121 332 -171 b 311 -359 332 -269 325 -316 b 307 -374 308 -368 307 -371 b 310 -386 307 -377 308 -379 b 332 -534 325 -434 332 -485 b 311 -673 332 -583 325 -630 b 307 -688 308 -682 307 -685 b 310 -700 307 -690 308 -693 b 332 -848 325 -748 332 -799 b 311 -987 332 -896 325 -944 b 307 -1001 308 -995 307 -998 b 310 -1013 307 -1004 308 -1007 b 333 -1161 325 -1062 333 -1113 b 268 -1391 333 -1246 311 -1326 b 235 -1422 251 -1417 246 -1422 b 213 -1402 221 -1422 213 -1413 b 220 -1382 213 -1396 215 -1389 b 286 -1176 265 -1322 286 -1250 b 163 -883 286 -1073 244 -966 b -16 -806 122 -841 54 -812 b -23 -805 -19 -806 -22 -806 l -25 -805 l -25 -673 l -25 -541 l -21 -541 b 3 -562 -11 -541 -6 -545 b 150 -754 30 -617 82 -685 b 273 -921 209 -814 242 -860 l 280 -933 l 281 -927 b 287 -861 285 -906 287 -884 b 163 -569 287 -756 243 -650 b -16 -492 122 -527 54 -498 b -23 -492 -19 -492 -22 -492 l -25 -491 l -25 -359 l -25 -227 l -21 -227 b 3 -248 -11 -227 -6 -231 b 150 -441 30 -303 82 -372 b 273 -608 209 -500 242 -546 l 280 -620 l 281 -614 b 287 -548 285 -592 287 -570 b 163 -255 287 -442 243 -336 b -16 -179 122 -213 54 -184 b -23 -178 -19 -178 -22 -178 l -25 -178 l -25 -45 l -25 87 l -21 87 b 3 66 -11 87 -6 83 b 150 -127 30 11 82 -58 b 273 -294 209 -186 242 -232 l 280 -306 l 281 -300 b 287 -234 285 -278 287 -256 b 163 59 287 -129 243 -23 b -16 135 122 100 54 129 b -23 136 -19 135 -22 136 l -25 136 l -25 268 l -25 401 l -21 401 b 3 379 -11 401 -6 397 b 150 187 30 325 82 256 b 273 20 209 127 242 82 l 280 8 l 281 14 b 287 80 285 36 287 58 b 163 372 287 185 243 291 b -16 449 122 414 54 443 b -23 450 -19 449 -22 449 l -25 450 z"
    },
    flag128thDown: {
      x_min: -15,
      x_max: 270,
      y_min: -496,
      y_max: 870,
      ha: 1366,
      o: "m 292 1251 b 301 1253 295 1252 298 1253 b 325 1235 309 1253 316 1247 b 389 1031 368 1174 389 1103 b 364 898 389 986 381 941 l 359 888 l 364 876 b 389 745 381 834 389 789 b 364 612 389 700 381 654 l 359 601 l 364 589 b 389 458 381 547 389 503 b 364 325 389 413 381 368 l 359 315 l 364 303 b 389 172 381 261 389 216 b 364 39 389 127 381 81 l 359 28 l 364 16 b 390 -115 381 -26 390 -71 b 260 -391 390 -219 344 -320 b 0 -698 135 -495 36 -613 b -19 -715 -5 -709 -11 -715 l -22 -715 l -22 -582 l -21 -449 l -14 -447 b 124 -400 25 -439 79 -420 b 213 -349 168 -379 189 -367 b 340 -101 294 -288 340 -196 b 332 -36 340 -79 337 -57 b 330 -27 331 -30 331 -27 b 326 -31 329 -27 328 -29 b 260 -104 309 -57 286 -82 b 0 -412 135 -209 36 -326 b -19 -428 -5 -422 -11 -428 l -22 -428 l -22 -295 l -21 -162 l -14 -161 b 124 -113 25 -153 79 -134 b 213 -63 168 -92 189 -81 b 340 186 294 -2 340 91 b 332 251 340 207 337 229 b 330 259 331 257 331 259 b 326 255 329 259 328 258 b 260 182 309 229 286 204 b 0 -125 135 78 36 -40 b -19 -142 -5 -136 -11 -142 l -22 -142 l -22 -9 l -21 124 l -14 126 b 124 173 25 134 79 152 b 213 224 168 194 189 206 b 340 472 294 285 340 377 b 332 537 340 494 337 516 b 330 546 331 543 331 546 b 326 542 329 546 328 544 b 255 465 307 514 286 491 b 0 161 135 364 35 245 b -19 145 -4 151 -11 145 l -22 145 l -22 278 l -21 411 l -14 412 b 124 460 25 420 79 439 b 213 510 168 481 189 492 b 340 759 294 571 340 664 b 332 824 340 780 337 802 b 330 832 331 830 331 832 b 326 828 329 832 328 831 b 255 751 308 801 286 777 b 0 448 135 650 35 532 b -19 431 -4 437 -11 431 l -22 431 l -22 564 l -21 697 l -14 699 b 124 746 25 707 79 725 b 213 797 168 767 189 779 b 340 1046 295 859 340 953 b 285 1213 340 1105 322 1163 b 278 1232 281 1220 278 1226 b 292 1251 278 1241 283 1248 z"
    },
    accidentalFlat: {
      x_min: -15,
      x_max: 185,
      y_min: -165,
      y_max: 457,
      ha: 622,
      o: "m -9 656 b 0 658 -6 657 -3 658 b 20 644 9 658 17 652 b 22 398 22 640 22 640 l 22 155 l 24 158 b 146 208 64 191 106 208 b 194 200 163 208 179 205 b 267 89 241 183 267 140 b 243 1 267 61 259 30 b 107 -148 220 -41 190 -73 b 25 -222 62 -188 51 -198 b 0 -237 10 -236 9 -237 b -20 -224 -9 -237 -17 -232 l -22 -220 l -22 210 l -22 640 l -20 644 b -9 656 -19 649 -13 654 z m 119 137 b 101 139 115 138 107 139 b 97 139 99 139 98 139 b 27 92 69 135 45 118 l 22 84 l 22 -39 l 22 -161 l 26 -157 b 153 88 104 -73 153 24 b 152 107 153 95 153 101 b 119 137 149 122 136 134 z"
    },
    accidentalNatural: {
      x_min: 0,
      x_max: 176,
      y_min: -334,
      y_max: 334,
      ha: 667,
      o: "m 13 479 b 21 480 16 480 19 480 b 42 467 30 480 39 475 b 44 339 44 463 44 462 b 44 214 44 250 44 214 b 136 237 45 214 86 224 b 234 259 209 255 227 259 b 240 258 237 259 238 259 b 252 246 245 256 251 251 l 254 242 l 254 -111 l 254 -463 l 252 -467 b 232 -480 249 -475 241 -480 b 216 -474 226 -480 221 -478 b 210 -392 211 -468 210 -477 b 210 -336 210 -377 210 -358 b 209 -209 210 -245 210 -209 b 117 -231 209 -209 168 -219 b 19 -254 45 -249 27 -254 b 13 -252 17 -254 15 -253 b 1 -240 8 -251 3 -245 l 0 -237 l 0 113 l 0 463 l 1 467 b 13 479 3 472 8 477 z m 210 23 b 210 74 210 44 210 61 b 209 121 210 118 210 121 l 209 121 b 126 101 208 121 171 112 l 44 81 l 44 -18 b 44 -62 44 -35 44 -50 b 44 -116 44 -104 44 -116 b 128 -96 45 -116 82 -107 l 210 -75 z"
    },
    accidentalSharp: {
      x_min: 0,
      x_max: 239,
      y_min: -388,
      y_max: 388,
      ha: 775,
      o: "m 232 557 b 240 558 234 558 237 558 b 261 545 249 558 258 553 b 262 405 262 541 262 540 b 263 269 262 278 262 269 b 263 269 263 269 263 269 b 322 282 275 273 319 282 b 343 269 331 282 340 277 b 344 217 344 266 344 241 b 343 165 344 192 344 168 b 295 144 339 155 337 154 l 262 136 l 262 22 b 263 -91 262 -83 262 -91 b 263 -91 263 -91 263 -91 b 322 -78 275 -88 319 -78 b 338 -84 329 -78 333 -80 b 344 -129 344 -90 344 -88 b 344 -143 344 -133 344 -138 b 344 -157 344 -148 344 -153 b 338 -203 344 -198 344 -197 b 295 -217 333 -207 333 -207 l 262 -225 l 262 -362 b 261 -504 262 -499 262 -500 b 240 -517 258 -512 249 -517 b 225 -511 235 -517 229 -515 b 218 -430 219 -505 218 -514 b 218 -368 218 -413 218 -393 b 218 -235 218 -295 218 -235 b 171 -247 218 -235 197 -241 b 123 -259 145 -253 123 -259 b 123 -400 123 -259 123 -322 b 122 -545 123 -540 123 -541 b 101 -558 118 -553 110 -558 b 86 -552 95 -558 90 -556 b 79 -469 80 -546 79 -556 b 79 -405 79 -452 79 -431 b 78 -270 79 -279 79 -270 b 78 -270 78 -270 78 -270 b 22 -282 65 -273 25 -282 b 2 -269 13 -282 5 -277 b 0 -217 1 -266 0 -242 b 2 -165 0 -192 1 -168 b 48 -144 5 -155 7 -154 l 79 -136 l 79 -23 b 78 90 79 83 79 90 b 78 90 78 90 78 90 b 22 78 65 87 25 78 b 2 91 13 78 5 83 b 0 143 1 94 0 119 b 2 195 0 168 1 192 b 48 216 5 205 7 206 l 79 224 l 79 362 b 81 504 79 499 79 500 b 101 517 84 512 93 517 b 117 511 107 517 112 515 b 123 430 123 505 123 515 b 123 367 123 413 123 392 b 123 235 123 294 123 235 b 171 246 123 235 145 240 b 218 258 197 253 218 258 b 218 399 218 258 218 322 b 220 545 218 540 218 541 b 232 557 222 549 227 555 z m 218 11 b 218 125 218 102 218 125 l 218 125 b 201 121 217 125 210 123 b 154 109 193 119 171 113 l 123 102 l 123 -12 b 123 -126 123 -74 123 -126 b 171 -114 123 -126 145 -120 b 218 -102 197 -107 218 -102 b 218 11 218 -102 218 -51 z"
    },
    accidentalDoubleSharp: {
      x_min: 0,
      x_max: 271,
      y_min: -135,
      y_max: 135,
      ha: 271,
      o: "m 0 130 l 0 195 l 65 195 l 131 195 l 131 145 l 131 96 l 163 64 l 195 32 l 227 64 l 259 96 l 259 145 l 259 195 l 325 195 l 390 195 l 390 130 l 390 64 l 341 64 l 291 64 l 259 32 l 227 0 l 259 -32 l 291 -64 l 341 -64 l 390 -64 l 390 -130 l 390 -195 l 325 -195 l 259 -195 l 259 -145 l 259 -96 l 227 -64 l 195 -32 l 163 -64 l 131 -96 l 131 -145 l 131 -195 l 65 -195 l 0 -195 l 0 -130 l 0 -64 l 50 -64 l 99 -64 l 131 -32 l 163 0 l 131 32 l 99 64 l 50 64 l 0 64 z"
    },
    accidentalDoubleFlat: {
      x_min: -15,
      x_max: 356,
      y_min: -165,
      y_max: 457,
      ha: 622,
      o: "m -9 656 b 0 658 -6 657 -3 658 b 20 644 9 658 17 652 b 22 398 22 640 22 640 l 22 155 l 24 158 b 149 208 64 191 109 208 b 220 187 175 208 200 201 l 223 184 l 224 413 l 224 642 l 226 645 b 246 657 229 653 237 657 b 266 644 254 657 263 653 b 267 398 267 640 267 640 l 267 155 l 270 158 b 392 208 309 191 351 208 b 440 200 408 208 424 205 b 512 89 486 183 512 140 b 488 1 512 61 505 30 b 352 -148 466 -41 436 -73 b 271 -222 307 -188 297 -198 b 246 -237 256 -236 254 -237 b 230 -231 239 -237 234 -236 b 224 -164 224 -225 224 -232 b 224 -125 224 -153 224 -140 l 224 -29 l 218 -36 b 107 -148 194 -67 170 -91 b 25 -222 62 -188 51 -198 b 0 -237 10 -236 9 -237 b -20 -224 -9 -237 -17 -232 l -22 -220 l -22 210 l -22 640 l -20 644 b -9 656 -19 649 -13 654 z m 119 137 b 101 139 115 138 107 139 b 97 139 99 139 98 139 b 27 92 69 135 45 118 l 22 84 l 22 -39 l 22 -161 l 26 -157 b 153 88 104 -73 153 24 b 152 107 153 95 153 101 b 119 137 149 122 136 134 z m 364 137 b 347 139 360 138 352 139 b 342 139 345 139 343 139 b 272 92 315 135 290 118 l 267 84 l 267 -39 l 267 -161 l 271 -157 b 399 88 349 -73 399 24 b 397 107 399 95 398 101 b 364 137 394 122 382 134 z"
    },
    accidentalParensLeft: {
      x_min: -122,
      x_max: -19,
      y_min: -267,
      y_max: 267,
      ha: 534,
      o: "m -51 383 b -44 385 -49 384 -46 385 b -29 375 -38 385 -31 381 b -27 369 -28 373 -27 372 b -33 349 -27 365 -29 360 b -98 54 -71 259 -91 167 b -99 0 -98 44 -99 22 b -98 -54 -99 -22 -98 -45 b -33 -349 -91 -167 -71 -259 b -27 -368 -28 -363 -27 -365 b -44 -385 -27 -378 -34 -385 b -65 -367 -52 -385 -55 -383 b -176 0 -139 -251 -176 -125 b -65 367 -176 125 -139 251 b -51 383 -57 379 -55 381 z"
    },
    accidentalParensRight: {
      x_min: 19,
      x_max: 122,
      y_min: -267,
      y_max: 267,
      ha: 535,
      o: "m 36 384 b 44 385 38 385 41 385 b 65 367 52 385 55 383 b 176 0 139 251 176 126 b 65 -367 176 -125 139 -250 b 44 -385 56 -380 51 -385 b 36 -383 42 -385 39 -384 b 27 -370 30 -380 27 -377 b 33 -349 27 -365 29 -359 b 99 0 77 -242 99 -121 b 33 350 99 122 77 243 b 27 371 29 359 27 366 b 36 384 27 377 30 381 z"
    },
    accidentalQuarterToneFlatStein: {
      x_min: 0,
      x_max: 200,
      y_min: -165,
      y_max: 457,
      ha: 622,
      o: "m 258 656 b 266 658 261 657 264 658 b 287 644 275 658 284 652 l 289 640 l 289 210 l 289 -220 l 287 -224 b 267 -237 284 -232 276 -237 b 241 -222 258 -237 256 -236 b 163 -151 216 -199 200 -183 b 24 2 78 -75 47 -41 b 0 88 8 31 0 61 b 73 200 0 140 26 183 b 120 208 88 205 104 208 b 242 158 161 208 203 191 l 245 155 l 245 398 b 246 644 245 640 245 640 b 258 656 248 649 253 654 z m 179 137 b 159 139 174 138 165 139 b 155 139 157 139 156 139 b 115 107 131 134 118 124 b 113 88 114 101 113 95 b 241 -157 113 24 163 -73 l 245 -161 l 245 -39 l 245 84 l 240 92 b 179 137 224 116 203 131 z"
    },
    accidentalThreeQuarterTonesFlatZimmermann: {
      x_min: 0,
      x_max: 446,
      y_min: -165,
      y_max: 457,
      ha: 622,
      o: "m 258 656 b 266 658 261 657 264 658 b 287 644 275 658 284 652 l 289 640 l 289 210 l 289 -220 l 287 -224 b 267 -237 284 -232 276 -237 b 241 -222 258 -237 256 -236 b 163 -151 216 -199 200 -183 b 24 2 78 -75 47 -41 b 0 88 8 31 0 61 b 73 200 0 140 26 183 b 120 208 88 205 104 208 b 242 158 161 208 203 191 l 245 155 l 245 398 b 246 644 245 640 245 640 b 258 656 248 649 253 654 z m 179 137 b 159 139 174 138 165 139 b 155 139 157 139 156 139 b 115 107 131 134 118 124 b 113 88 114 101 113 95 b 241 -157 113 24 163 -73 l 245 -161 l 245 -39 l 245 84 l 240 92 b 179 137 224 116 203 131 z m 367 656 b 375 658 370 657 373 658 b 396 644 384 658 393 652 b 398 398 398 640 398 640 l 398 155 l 400 158 b 522 208 440 191 482 208 b 570 200 538 208 554 205 b 643 89 617 183 643 140 b 619 1 643 61 635 30 b 483 -148 596 -41 566 -73 b 401 -222 438 -188 427 -198 b 376 -237 386 -236 384 -237 b 355 -224 366 -237 358 -232 l 354 -220 l 354 210 l 354 640 l 355 644 b 367 656 357 649 362 654 z m 495 137 b 477 139 491 138 482 139 b 472 139 475 139 473 139 b 403 92 445 135 420 118 l 398 84 l 398 -39 l 398 -161 l 401 -157 b 529 88 479 -73 529 24 b 528 107 529 95 529 101 b 495 137 525 122 512 134 z"
    },
    accidentalQuarterToneSharpStein: {
      x_min: 0,
      x_max: 142,
      y_min: -373,
      y_max: 373,
      ha: 747,
      o: "m 92 536 b 101 538 95 537 98 538 b 122 524 110 538 118 532 b 123 390 123 520 123 519 l 123 259 l 151 268 b 182 277 175 276 178 277 b 184 277 183 277 183 277 b 203 265 193 276 199 272 l 204 262 l 205 213 b 205 187 205 202 205 194 b 201 154 205 159 204 159 b 158 136 197 149 194 148 l 123 125 l 123 10 b 124 -104 123 -64 123 -104 b 150 -94 124 -104 136 -100 b 179 -85 164 -89 177 -85 b 183 -84 181 -84 182 -84 b 203 -98 192 -84 200 -90 b 205 -157 204 -101 205 -130 b 204 -201 205 -179 205 -199 b 158 -226 200 -211 199 -212 l 123 -239 l 123 -380 l 123 -522 l 121 -525 b 101 -538 117 -533 109 -538 b 85 -531 95 -538 90 -536 b 79 -450 80 -526 79 -535 b 79 -387 79 -433 79 -413 b 79 -254 79 -314 79 -254 b 54 -263 79 -254 67 -258 b 19 -273 36 -270 26 -273 b 6 -267 14 -273 10 -271 b 0 -222 0 -261 0 -263 b 0 -207 0 -217 0 -213 b 0 -195 0 -203 0 -199 b 6 -148 0 -152 0 -154 b 47 -131 10 -144 10 -144 l 79 -120 l 79 -5 b 79 110 79 58 79 110 b 53 101 79 110 67 106 b 19 93 35 95 25 93 b 6 99 14 93 10 95 b 0 144 0 105 0 103 b 0 158 0 148 0 153 b 0 185 0 169 0 178 b 45 233 0 222 3 219 l 79 244 l 79 382 b 81 524 79 519 79 520 b 92 536 82 529 88 534 z"
    },
    accidentalThreeQuarterTonesSharpStein: {
      x_min: 0,
      x_max: 335,
      y_min: -391,
      y_max: 391,
      ha: 782,
      o: "m 373 562 b 379 563 375 563 377 563 b 399 551 388 563 395 559 l 401 548 l 401 410 l 401 272 l 403 273 b 432 278 403 273 417 275 b 463 282 448 281 457 282 b 477 276 470 282 473 280 b 483 241 482 271 483 271 b 483 216 483 234 483 226 l 483 167 l 481 164 b 471 153 479 160 475 155 b 402 140 469 152 405 140 b 401 25 401 140 401 88 l 401 -91 l 403 -90 b 432 -85 403 -90 417 -88 b 463 -80 448 -82 457 -80 b 477 -87 470 -80 473 -83 b 483 -122 482 -92 483 -91 b 483 -147 483 -128 483 -137 l 483 -196 l 481 -199 b 471 -209 479 -203 475 -207 b 402 -223 469 -210 405 -223 b 401 -359 401 -223 401 -284 l 401 -496 l 399 -500 b 379 -512 395 -507 388 -512 b 359 -500 371 -512 363 -507 l 357 -496 l 357 -363 b 356 -231 357 -240 357 -231 b 356 -231 356 -231 356 -231 b 309 -240 356 -232 334 -235 l 262 -249 l 262 -384 b 262 -448 262 -410 262 -431 b 256 -531 262 -535 261 -526 b 240 -538 251 -536 246 -538 b 220 -525 232 -538 224 -533 l 219 -522 l 218 -389 l 218 -257 l 171 -265 b 123 -274 144 -270 123 -274 b 123 -411 123 -274 123 -336 l 122 -548 l 121 -551 b 101 -563 116 -559 109 -563 b 81 -551 93 -563 85 -559 l 79 -548 l 79 -415 b 79 -282 79 -342 79 -282 b 52 -287 78 -282 66 -285 b 20 -292 36 -290 26 -292 b 6 -286 13 -292 10 -290 b 0 -241 0 -280 0 -282 b 0 -226 0 -236 0 -232 b 0 -212 0 -221 0 -216 b 6 -167 0 -171 0 -173 b 48 -155 11 -162 13 -162 l 79 -150 l 79 -35 b 79 80 79 29 79 80 b 52 76 78 80 66 78 b 20 71 36 73 26 71 b 6 77 13 71 10 73 b 0 122 0 83 0 81 b 0 136 0 126 0 131 b 0 151 0 142 0 146 b 6 196 0 192 0 190 b 48 207 11 201 13 201 l 79 213 l 79 354 l 79 496 l 81 500 b 101 512 85 508 93 512 b 121 500 109 512 116 508 l 122 497 l 123 359 l 123 221 l 171 230 b 218 239 197 235 218 239 b 218 380 218 239 218 302 b 220 524 218 519 218 520 b 240 538 223 533 231 538 b 256 531 246 538 251 536 b 262 448 261 526 262 535 b 262 384 262 431 262 410 b 263 247 262 295 262 247 b 310 255 263 247 284 251 b 357 264 335 260 357 264 b 358 406 357 264 357 328 l 358 548 l 359 551 b 373 562 362 557 367 561 z m 357 16 b 357 132 357 108 357 132 l 357 132 b 309 123 356 132 335 128 l 262 114 l 262 -1 b 263 -116 262 -76 262 -116 b 310 -107 263 -116 284 -112 b 357 -99 335 -103 357 -99 b 357 16 357 -99 357 -48 z m 218 -124 b 218 -56 218 -124 218 -96 b 218 -9 218 -42 218 -26 l 218 106 l 171 97 b 123 88 145 93 123 89 b 123 21 123 88 123 61 b 123 -27 123 6 123 -10 l 123 -142 l 170 -133 b 218 -124 196 -128 218 -124 z"
    },
    accidentalBuyukMucennebFlat: {
      x_min: -125,
      x_max: 185,
      y_min: -165,
      y_max: 457,
      ha: 622,
      o: "m -9 656 b 0 658 -6 657 -3 658 b 20 644 9 658 17 652 b 22 575 22 640 22 639 b 23 510 22 524 22 510 b 23 510 23 510 23 510 b 164 557 49 520 160 557 b 186 534 177 557 186 546 b 176 516 186 527 183 520 b 98 489 175 515 140 503 l 22 463 l 22 405 b 22 378 22 394 22 386 b 23 347 22 354 22 347 b 23 347 23 347 23 347 b 164 393 49 356 160 393 b 186 371 177 393 186 382 b 176 352 186 364 183 357 b 98 325 175 352 140 339 l 22 300 l 22 228 l 22 155 l 24 158 b 146 208 64 191 106 208 b 194 200 163 208 179 205 b 267 89 241 183 267 140 b 243 1 267 61 259 30 b 107 -148 220 -41 190 -73 b 25 -222 62 -188 51 -198 b 0 -237 10 -236 9 -237 b -20 -224 -9 -237 -17 -232 b -22 32 -22 -220 -22 -220 b -22 284 -22 171 -22 284 b -88 262 -23 284 -52 274 b -160 240 -141 245 -154 240 b -167 241 -163 240 -164 241 b -180 262 -175 245 -180 254 b -169 281 -180 270 -176 278 b -30 329 -168 282 -92 308 l -22 332 l -22 390 b -22 448 -22 422 -22 448 b -88 426 -23 448 -52 438 b -160 404 -141 408 -154 404 b -167 405 -163 404 -164 404 b -180 426 -175 408 -180 417 b -169 445 -180 434 -176 441 b -30 493 -168 446 -92 472 l -22 495 l -22 568 b -20 644 -22 639 -22 641 b -9 656 -19 649 -13 654 z m 119 137 b 101 139 115 138 107 139 b 97 139 99 139 98 139 b 27 92 69 135 45 118 l 22 84 l 22 -39 l 22 -161 l 26 -157 b 153 88 104 -73 153 24 b 152 107 153 95 153 101 b 119 137 149 122 136 134 z"
    },
    accidentalBuyukMucennebSharp: {
      x_min: 0,
      x_max: 284,
      y_min: -388,
      y_max: 388,
      ha: 775,
      o: "m 264 557 b 272 558 267 558 269 558 b 293 545 281 558 290 553 b 294 435 294 541 294 540 b 295 329 294 337 294 329 b 296 329 296 329 296 329 b 355 342 308 333 351 342 b 375 329 364 342 372 337 b 376 277 376 326 376 302 b 375 225 376 252 376 228 b 327 204 371 215 369 214 l 294 196 l 294 142 b 295 89 294 94 294 89 b 296 89 295 89 296 89 b 389 110 314 94 384 110 b 389 110 389 110 389 110 b 407 98 397 110 403 105 l 409 95 l 409 45 b 409 25 409 37 409 30 b 404 -13 409 -11 408 -8 b 345 -32 400 -18 398 -19 b 295 -44 317 -39 295 -44 b 294 -98 294 -44 294 -68 b 295 -151 294 -147 294 -151 b 296 -151 295 -151 296 -151 b 355 -138 308 -148 351 -138 b 375 -151 364 -138 372 -143 b 376 -203 376 -154 376 -179 b 375 -255 376 -228 376 -252 b 327 -277 371 -265 369 -266 l 294 -285 l 294 -392 b 293 -504 294 -499 294 -500 b 272 -517 290 -512 281 -517 b 257 -511 267 -517 261 -515 b 251 -443 251 -505 251 -512 b 251 -398 251 -430 251 -416 b 250 -295 251 -341 251 -295 b 203 -307 250 -295 229 -301 b 156 -319 177 -313 156 -319 b 155 -430 155 -319 155 -369 b 154 -545 155 -540 155 -541 b 133 -558 151 -553 142 -558 b 118 -552 128 -558 122 -556 b 112 -482 112 -546 112 -553 b 112 -435 112 -469 112 -454 b 110 -330 112 -337 111 -330 b 110 -330 110 -330 110 -330 b 54 -342 98 -333 58 -342 b 34 -329 45 -342 37 -337 b 32 -277 33 -326 32 -302 b 34 -225 32 -252 33 -228 b 80 -204 38 -215 39 -214 l 112 -196 l 112 -143 b 111 -90 112 -94 111 -90 b 110 -90 110 -90 110 -90 b 20 -110 89 -96 25 -110 b 20 -110 20 -110 20 -110 b 2 -98 12 -110 5 -105 l 0 -95 l 0 -45 b 0 -25 0 -37 0 -30 b 5 13 0 11 0 8 b 62 32 9 18 10 19 b 111 44 89 38 111 44 b 112 97 111 44 112 68 b 111 150 112 146 111 150 b 110 150 110 150 110 150 b 54 138 98 147 58 138 b 34 151 45 138 37 143 b 32 203 33 154 32 179 b 34 255 32 228 33 252 b 80 276 38 265 39 266 l 112 284 l 112 392 b 113 504 112 499 112 500 b 133 517 116 512 125 517 b 149 511 139 517 145 515 b 155 443 155 505 155 512 b 155 397 155 430 155 415 b 155 295 155 341 155 295 b 203 306 156 295 177 300 b 250 318 229 313 250 318 b 251 429 251 318 251 368 b 252 545 251 540 251 541 b 264 557 254 549 259 555 z m 251 131 b 250 185 251 174 250 185 l 250 185 b 233 181 249 185 242 183 b 186 169 225 179 204 173 l 155 162 l 155 108 b 155 55 155 79 155 55 b 203 66 156 55 177 60 b 250 78 229 73 250 78 b 251 131 251 78 251 102 z m 251 -109 b 250 -55 251 -67 250 -55 l 250 -55 b 233 -59 249 -55 242 -57 b 186 -71 225 -62 204 -67 l 155 -79 l 155 -132 b 155 -186 155 -161 155 -186 b 203 -174 156 -186 177 -180 b 250 -162 229 -168 250 -162 b 251 -109 251 -162 251 -138 z"
    },
    accidentalBakiyeFlat: {
      x_min: -129,
      x_max: 185,
      y_min: -165,
      y_max: 457,
      ha: 622,
      o: "m -9 656 b 0 658 -6 657 -3 658 b 20 644 9 658 17 652 b 22 524 22 640 22 639 b 22 407 22 460 22 407 b 90 441 22 407 53 422 l 157 474 l 163 475 b 164 475 163 475 163 475 b 186 453 177 475 186 465 b 184 445 186 450 185 447 b 99 396 181 436 184 438 l 22 357 l 22 256 l 22 155 l 24 158 b 146 208 64 191 106 208 b 194 200 163 208 179 205 b 267 89 241 183 267 140 b 243 1 267 61 259 30 b 107 -148 220 -41 190 -73 b 25 -222 62 -188 51 -198 b 0 -237 10 -236 9 -237 b -20 -224 -9 -237 -17 -232 b -22 57 -22 -220 -22 -220 b -22 335 -22 210 -22 335 b -90 301 -22 335 -53 320 l -157 268 l -163 268 b -164 268 -163 268 -163 268 b -186 289 -177 268 -186 277 b -184 298 -186 292 -185 295 b -99 347 -181 306 -184 304 l -22 385 l -22 513 b -20 644 -22 639 -22 640 b -9 656 -19 649 -13 654 z m 119 137 b 101 139 115 138 107 139 b 97 139 99 139 98 139 b 27 92 69 135 45 118 l 22 84 l 22 -39 l 22 -161 l 26 -157 b 153 88 104 -73 153 24 b 152 107 153 95 153 101 b 119 137 149 122 136 134 z"
    },
    accidentalKomaSharp: {
      x_min: 0,
      x_max: 142,
      y_min: -373,
      y_max: 373,
      ha: 747,
      o: "m 92 536 b 101 538 95 537 98 538 b 122 524 110 538 118 532 b 123 390 123 520 123 519 l 123 259 l 151 268 b 182 277 175 276 178 277 b 184 277 183 277 183 277 b 203 265 193 276 199 272 l 204 262 l 205 213 b 205 187 205 202 205 194 b 201 154 205 159 204 159 b 158 136 197 149 194 148 l 123 125 l 123 10 b 124 -104 123 -64 123 -104 b 150 -94 124 -104 136 -100 b 179 -85 164 -89 177 -85 b 183 -84 181 -84 182 -84 b 203 -98 192 -84 200 -90 b 205 -157 204 -101 205 -130 b 204 -201 205 -179 205 -199 b 158 -226 200 -211 199 -212 l 123 -239 l 123 -380 l 123 -522 l 121 -525 b 101 -538 117 -533 109 -538 b 85 -531 95 -538 90 -536 b 79 -450 80 -526 79 -535 b 79 -387 79 -433 79 -413 b 79 -254 79 -314 79 -254 b 54 -263 79 -254 67 -258 b 19 -273 36 -270 26 -273 b 6 -267 14 -273 10 -271 b 0 -222 0 -261 0 -263 b 0 -207 0 -217 0 -213 b 0 -195 0 -203 0 -199 b 6 -148 0 -152 0 -154 b 47 -131 10 -144 10 -144 l 79 -120 l 79 -5 b 79 110 79 58 79 110 b 53 101 79 110 67 106 b 19 93 35 95 25 93 b 6 99 14 93 10 95 b 0 144 0 105 0 103 b 0 158 0 148 0 153 b 0 185 0 169 0 178 b 45 233 0 222 3 219 l 79 244 l 79 382 b 81 524 79 519 79 520 b 92 536 82 529 88 534 z"
    },
    accidentalKucukMucennebSharp: {
      x_min: 0,
      x_max: 188,
      y_min: -373,
      y_max: 373,
      ha: 747,
      o: "m 127 536 b 135 538 129 537 132 538 b 156 524 144 538 153 532 b 157 420 157 520 157 519 l 157 319 l 185 328 b 216 337 209 336 212 337 b 218 337 217 337 217 337 b 237 325 227 336 233 332 l 239 322 l 239 273 b 239 247 239 262 239 254 b 235 214 239 219 238 219 b 192 196 231 209 229 208 l 157 185 l 157 129 b 158 75 157 86 157 75 b 158 75 158 75 158 75 b 202 89 158 75 178 81 l 245 103 l 250 103 b 268 91 258 102 265 98 l 270 88 l 270 39 b 270 13 270 28 270 20 b 266 -20 270 -15 270 -15 b 208 -43 262 -25 261 -25 l 157 -60 l 157 -112 b 157 -127 157 -117 157 -122 b 158 -164 157 -151 157 -164 b 184 -154 158 -164 170 -160 b 214 -145 198 -149 212 -145 b 217 -144 215 -144 216 -144 b 238 -158 226 -144 235 -150 b 239 -217 239 -161 239 -190 b 238 -261 239 -239 239 -259 b 192 -286 235 -271 233 -272 l 157 -299 l 157 -410 b 155 -525 157 -522 157 -522 b 135 -538 152 -533 143 -538 b 120 -531 130 -538 124 -536 b 113 -463 114 -525 113 -532 b 113 -417 113 -450 113 -435 b 113 -314 113 -361 113 -314 b 88 -323 113 -314 102 -318 b 53 -333 70 -330 60 -333 b 41 -327 48 -333 45 -331 b 34 -282 35 -321 34 -323 b 34 -267 34 -277 34 -273 b 34 -255 34 -263 34 -259 b 40 -208 34 -212 35 -214 b 81 -191 44 -204 44 -204 l 113 -180 l 113 -127 b 113 -75 113 -86 113 -75 b 113 -75 113 -75 113 -75 b 69 -89 112 -75 92 -81 l 26 -103 l 21 -103 b 1 -89 12 -102 4 -97 b 0 -43 0 -86 0 -65 b 2 15 0 -16 1 12 b 63 43 5 24 4 24 l 113 60 l 113 115 b 113 130 113 120 113 125 b 113 170 113 153 113 170 b 87 161 113 170 101 166 b 53 153 69 156 60 153 b 41 159 48 153 45 155 b 34 204 35 165 34 163 b 34 218 34 208 34 213 b 34 245 34 229 34 238 b 79 293 34 282 38 279 l 113 304 l 113 412 b 115 524 113 519 113 520 b 127 536 117 529 122 534 z"
    },
    articAccentAbove: {
      x_min: -256,
      x_max: 19,
      y_min: -114,
      y_max: 114,
      ha: 227,
      o: "m -350 163 b -341 164 -348 163 -344 164 b -333 163 -338 164 -335 163 b -312 151 -330 162 -327 160 b -9 30 -231 99 -122 56 b 13 24 8 27 11 26 b 28 0 23 18 28 9 b 3 -28 28 -12 19 -24 b -19 -33 -1 -29 -11 -31 b -315 -153 -129 -58 -238 -102 b -341 -164 -331 -163 -333 -164 b -369 -136 -357 -164 -369 -151 b -364 -121 -369 -131 -367 -126 b -346 -107 -361 -117 -358 -114 b -135 -8 -285 -67 -213 -34 b -111 0 -122 -4 -111 0 b -135 8 -111 0 -122 4 b -346 107 -213 34 -285 67 b -364 121 -358 114 -361 116 b -368 136 -367 126 -368 131 b -350 163 -368 148 -361 159 z"
    },
    articAccentBelow: {
      x_min: -256,
      x_max: 19,
      y_min: -114,
      y_max: 114,
      ha: 227,
      o: "m -350 163 b -341 164 -348 163 -344 164 b -333 163 -338 164 -335 163 b -312 151 -330 162 -327 160 b -9 30 -231 99 -122 56 b 13 24 8 27 11 26 b 28 0 23 18 28 9 b 3 -28 28 -12 19 -24 b -19 -33 -1 -29 -11 -31 b -315 -153 -129 -58 -238 -102 b -341 -164 -331 -163 -333 -164 b -369 -136 -357 -164 -369 -151 b -364 -121 -369 -131 -367 -126 b -346 -107 -361 -117 -358 -114 b -135 -8 -285 -67 -213 -34 b -111 0 -122 -4 -111 0 b -135 8 -111 0 -122 4 b -346 107 -213 34 -285 67 b -364 121 -358 114 -361 116 b -368 136 -367 126 -368 131 b -350 163 -368 148 -361 159 z"
    },
    articTenutoAbove: {
      x_min: -154,
      x_max: 154,
      y_min: -15,
      y_max: 15,
      ha: 30,
      o: "m -208 20 b 2 22 -205 21 -101 22 b 208 20 104 22 205 21 b 221 0 216 17 221 9 b 215 -16 221 -6 219 -11 b 101 -22 209 -21 225 -22 b 0 -22 75 -22 41 -22 b -101 -22 -41 -22 -75 -22 b -215 -16 -225 -22 -209 -21 b -221 0 -219 -11 -221 -6 b -208 20 -221 8 -216 17 z"
    },
    articTenutoBelow: {
      x_min: -154,
      x_max: 154,
      y_min: -15,
      y_max: 15,
      ha: 30,
      o: "m -208 20 b 2 22 -205 21 -101 22 b 208 20 104 22 205 21 b 221 0 216 17 221 9 b 215 -16 221 -6 219 -11 b 101 -22 209 -21 225 -22 b 0 -22 75 -22 41 -22 b -101 -22 -41 -22 -75 -22 b -215 -16 -225 -22 -209 -21 b -221 0 -219 -11 -221 -6 b -208 20 -221 8 -216 17 z"
    },
    articStaccatoAbove: {
      x_min: -49,
      x_max: 49,
      y_min: -49,
      y_max: 49,
      ha: 99,
      o: "m -13 70 b -1 71 -9 71 -5 71 b 59 40 23 71 46 59 b 71 0 67 28 71 14 b 40 -59 71 -23 60 -46 b 0 -71 28 -67 14 -71 b -59 -40 -23 -71 -46 -60 b -71 0 -67 -28 -71 -14 b -13 70 -71 32 -48 64 z"
    },
    articStaccatoBelow: {
      x_min: -49,
      x_max: 49,
      y_min: -49,
      y_max: 49,
      ha: 99,
      o: "m -13 70 b -1 71 -9 71 -5 71 b 59 40 23 71 46 59 b 71 0 67 28 71 14 b 40 -59 71 -23 60 -46 b 0 -71 28 -67 14 -71 b -59 -40 -23 -71 -46 -60 b -71 0 -67 -28 -71 -14 b -13 70 -71 32 -48 64 z"
    },
    articStaccatissimoAbove: {
      x_min: -53,
      x_max: 53,
      y_min: 0,
      y_max: 184,
      ha: 184,
      o: "m -76 263 l -77 265 l 0 265 l 77 265 l 76 263 b 0 0 75 259 0 0 b -76 263 0 0 -75 259 z"
    },
    articStaccatissimoBelow: {
      x_min: -53,
      x_max: 53,
      y_min: -184,
      y_max: 0,
      ha: 184,
      o: "m -38 -131 b 0 0 -17 -59 0 0 b 76 -263 0 0 75 -259 l 77 -265 l 0 -265 l -77 -265 l -76 -263 b -38 -131 -76 -262 -59 -203 z"
    },
    articMarcatoAbove: {
      x_min: -114,
      x_max: 114,
      y_min: -256,
      y_max: 19,
      ha: 275,
      o: "m -9 26 b 0 28 -6 27 -3 28 b 28 3 13 28 24 18 b 33 -19 29 -1 31 -11 b 153 -315 58 -129 102 -238 b 164 -341 163 -331 164 -333 b 136 -368 164 -357 152 -368 b 107 -346 124 -368 118 -364 b 8 -135 67 -285 34 -213 b 0 -111 4 -122 0 -111 b -8 -135 0 -111 -4 -122 b -107 -346 -34 -213 -67 -285 b -136 -368 -118 -364 -124 -368 b -164 -341 -152 -368 -164 -357 b -151 -312 -164 -333 -163 -332 b -30 -9 -99 -231 -56 -122 b -21 18 -26 11 -26 12 b -9 26 -19 21 -13 25 z"
    },
    articMarcatoBelow: {
      x_min: -114,
      x_max: 114,
      y_min: -19,
      y_max: 256,
      ha: 275,
      o: "m -145 367 b -136 369 -142 368 -139 369 b -107 346 -125 369 -117 362 b -8 135 -67 285 -34 213 b 0 111 -4 122 0 111 b 8 135 0 111 4 122 b 107 346 34 213 67 285 b 121 364 114 358 117 361 b 136 369 126 367 131 369 b 164 341 151 369 164 357 b 153 315 164 333 163 331 b 30 9 101 235 56 124 b 21 -18 26 -11 26 -12 b 0 -27 16 -24 8 -27 b -21 -18 -8 -27 -16 -24 b -30 9 -26 -12 -26 -11 b -151 312 -56 122 -99 231 b -164 341 -163 332 -164 333 b -145 367 -164 353 -156 364 z"
    },
    fermataAbove: {
      x_min: -324,
      x_max: 324,
      y_min: 0,
      y_max: 353,
      ha: 353,
      o: "m -33 507 b 0 508 -22 508 -11 508 b 459 112 228 508 419 345 b 467 31 464 85 467 51 b 465 14 467 22 466 16 b 445 0 462 5 453 0 b 429 7 439 0 433 2 b 422 32 424 12 423 15 b 0 365 414 221 231 365 b -63 362 -33 365 -39 365 b -422 32 -265 338 -415 200 b -429 7 -423 15 -424 12 b -445 0 -433 2 -439 0 b -465 14 -453 0 -462 5 b -467 31 -466 16 -467 22 b -459 112 -467 51 -464 85 b -33 507 -422 332 -249 492 z m -15 196 b 0 197 -10 197 -5 197 b 74 163 27 197 56 184 b 98 99 91 145 98 121 b 55 17 98 67 83 36 b 0 0 38 5 19 0 b -98 99 -51 0 -98 40 b -15 196 -98 148 -65 187 z"
    },
    fermataBelow: {
      x_min: -324,
      x_max: 324,
      y_min: -353,
      y_max: 0,
      ha: 353,
      o: "m -453 -2 b -445 0 -451 -1 -448 0 b -429 -7 -439 0 -433 -3 b -422 -33 -424 -12 -423 -15 b 0 -365 -414 -221 -231 -365 b 63 -362 33 -365 39 -365 b 422 -33 265 -338 415 -201 b 429 -7 423 -15 424 -12 b 445 0 433 -2 439 0 b 465 -14 453 0 462 -5 b 467 -31 466 -17 467 -23 b 463 -87 467 -46 465 -68 b 35 -507 434 -319 259 -490 b -1 -508 23 -508 11 -508 b -459 -112 -228 -508 -419 -345 b -467 -31 -464 -85 -467 -51 b -465 -14 -467 -23 -466 -17 b -453 -2 -463 -9 -458 -4 z m -15 -1 b 0 0 -10 0 -5 0 b 82 -43 31 0 64 -17 b 99 -98 93 -61 99 -80 b 0 -197 99 -150 58 -197 b -99 -98 -58 -197 -99 -150 b -82 -43 -99 -80 -93 -61 b -15 -1 -67 -21 -43 -6 z"
    },
    fermataLongAbove: {
      x_min: -286,
      x_max: 286,
      y_min: 0,
      y_max: 364,
      ha: 364,
      o: "m -399 523 b 0 524 -395 524 -392 524 l 395 524 l 399 523 b 411 511 404 521 409 516 b 412 262 412 507 412 507 b 412 141 412 213 412 173 b 406 7 412 -8 412 12 b 390 0 402 2 396 0 b 382 2 387 0 385 1 b 370 14 377 4 372 9 b 368 183 368 17 368 18 l 368 350 l 0 350 l -368 350 l -368 183 b -370 14 -368 18 -368 17 b -390 0 -373 5 -381 0 b -411 14 -399 0 -407 5 b -412 262 -412 17 -412 139 b -411 511 -412 385 -412 508 b -399 523 -409 516 -403 521 z m -15 196 b 0 197 -10 197 -5 197 b 75 163 27 197 56 184 b 98 99 91 145 98 121 b 56 17 98 67 84 36 b 0 0 38 5 19 0 b -98 99 -51 0 -98 40 b -15 196 -98 148 -64 187 z"
    },
    fermataLongBelow: {
      x_min: -286,
      x_max: 286,
      y_min: -364,
      y_max: 0,
      ha: 364,
      o: "m -399 -2 b -391 0 -396 -1 -393 0 b -370 -14 -382 0 -373 -6 b -368 -184 -368 -18 -368 -18 l -368 -350 l 0 -350 l 368 -350 l 368 -184 b 370 -14 368 -18 368 -18 b 390 0 373 -5 382 0 b 411 -14 399 0 407 -5 b 412 -262 412 -17 412 -140 b 411 -511 412 -385 412 -508 b 399 -523 409 -516 404 -521 l 395 -524 l 0 -524 l -395 -524 l -399 -523 b -411 -511 -404 -521 -409 -516 b -412 -262 -412 -508 -412 -385 b -411 -14 -412 -140 -412 -17 b -399 -2 -409 -9 -404 -4 z m -15 -1 b 0 0 -10 0 -5 0 b 82 -43 31 0 64 -17 b 99 -98 93 -61 99 -80 b 0 -197 99 -150 58 -197 b -99 -98 -58 -197 -99 -150 b -82 -43 -99 -80 -93 -61 b -15 -1 -67 -21 -43 -6 z"
    },
    fermataVeryLongAbove: {
      x_min: -286,
      x_max: 286,
      y_min: 0,
      y_max: 438,
      ha: 438,
      o: "m -399 629 b 0 631 -395 631 -392 631 l 395 631 l 399 629 b 411 617 404 627 409 622 b 412 315 412 614 412 465 b 411 14 412 166 412 17 b 390 0 407 5 399 0 b 370 14 382 0 373 5 b 368 237 368 17 368 18 l 368 456 l 0 456 l -368 456 l -368 237 b -370 14 -368 18 -368 17 b -390 0 -373 5 -382 0 b -411 14 -399 0 -407 5 b -412 315 -412 17 -412 166 b -411 617 -412 465 -412 614 b -399 629 -409 622 -404 627 z m -290 384 b 3 385 -287 385 -141 385 b 289 384 145 385 287 385 b 301 372 294 382 300 377 b 303 193 303 369 303 281 b 301 14 303 105 303 17 b 281 0 298 5 290 0 b 265 7 275 0 270 2 b 259 80 260 12 259 4 b 259 130 259 94 259 111 l 259 243 l 0 243 l -259 243 l -259 130 b -259 80 -259 111 -259 94 b -265 7 -259 4 -260 12 b -281 0 -270 2 -275 0 b -301 14 -290 0 -298 5 b -303 193 -303 17 -303 105 b -301 372 -303 281 -303 369 b -290 384 -300 376 -294 382 z m -15 196 b 0 197 -10 197 -5 197 b 74 163 27 197 56 184 b 98 99 91 145 98 121 b 55 17 98 67 83 36 b 0 0 38 5 19 0 b -98 99 -51 0 -98 40 b -15 196 -98 148 -65 187 z"
    },
    fermataVeryLongBelow: {
      x_min: -286,
      x_max: 286,
      y_min: -438,
      y_max: 0,
      ha: 438,
      o: "m -399 -2 b -391 0 -396 -1 -393 0 b -370 -14 -382 0 -373 -6 b -368 -237 -368 -18 -368 -18 l -368 -456 l 0 -456 l 368 -456 l 368 -237 b 370 -14 368 -18 368 -18 b 390 0 373 -5 382 0 b 411 -14 399 0 407 -5 b 412 -316 412 -17 412 -166 b 411 -617 412 -465 412 -614 b 399 -629 409 -622 404 -628 l 395 -631 l 0 -631 l -395 -631 l -399 -629 b -411 -617 -404 -628 -409 -622 b -412 -316 -412 -614 -412 -465 b -411 -14 -412 -166 -412 -17 b -399 -2 -409 -9 -404 -4 z m -290 -2 b -281 0 -287 -1 -284 0 b -261 -14 -272 0 -264 -6 b -259 -130 -259 -18 -259 -19 l -259 -243 l 0 -243 l 259 -243 l 259 -130 b 259 -81 259 -111 259 -94 b 265 -7 259 -5 260 -13 b 281 0 270 -2 275 0 b 301 -14 290 0 298 -5 b 303 -193 303 -17 303 -105 b 301 -372 303 -281 303 -369 b 289 -384 300 -377 294 -382 b 0 -385 287 -385 143 -385 b -289 -384 -143 -385 -287 -385 b -301 -372 -294 -382 -300 -377 b -303 -193 -303 -369 -303 -281 b -301 -14 -303 -105 -303 -17 b -290 -2 -300 -9 -294 -4 z m -15 -1 b 0 0 -10 0 -5 0 b 82 -43 31 0 64 -17 b 99 -98 93 -61 99 -80 b 0 -197 99 -150 58 -197 b -99 -98 -58 -197 -99 -150 b -82 -43 -99 -80 -93 -61 b -15 -1 -67 -21 -43 -6 z"
    },
    fermataVeryShortAbove: {
      x_min: -351,
      x_max: 351,
      y_min: 0,
      y_max: 571,
      ha: 571,
      o: "m -9 820 b 0 822 -6 821 -3 822 b 8 820 3 822 6 821 b 35 785 15 818 17 815 b 68 733 45 770 59 747 b 98 684 76 720 90 698 b 146 606 107 670 128 635 b 193 532 164 578 185 544 b 227 477 200 519 216 495 b 313 337 277 396 301 358 b 362 260 321 325 343 290 b 406 188 380 230 400 197 b 436 140 412 179 425 157 b 505 25 500 37 505 30 b 505 22 505 24 505 23 b 491 2 505 13 499 5 b 450 0 488 1 469 0 b 409 2 431 0 412 1 b 382 37 403 4 400 7 b 350 89 373 52 358 75 b 319 138 342 102 328 124 b 271 216 311 152 289 187 b 225 290 253 244 232 278 b 191 345 217 302 202 327 b 104 485 142 424 117 464 b 8 639 73 534 24 613 b -21 686 -2 655 -15 676 b -33 704 -27 696 -33 704 b -44 686 -33 704 -38 696 b -73 639 -51 676 -64 655 b -170 485 -89 614 -133 543 b -203 430 -177 472 -192 448 b -290 290 -253 351 -277 311 b -337 216 -298 278 -319 244 b -385 138 -355 187 -376 152 b -415 89 -393 124 -407 102 b -448 37 -424 75 -438 52 b -474 2 -466 7 -468 4 b -483 0 -477 1 -480 0 b -505 22 -495 0 -505 9 b -505 25 -505 23 -505 24 b -436 140 -505 30 -500 37 b -406 188 -425 157 -412 179 b -362 260 -400 197 -380 230 b -313 337 -343 290 -321 325 b -227 477 -301 358 -277 396 b -193 532 -216 495 -200 519 b -146 606 -185 544 -164 578 b -98 684 -128 635 -107 670 b -68 733 -90 697 -76 720 b -35 785 -59 747 -45 770 b -9 820 -17 814 -14 818 z m -36 506 b -28 508 -33 507 -30 508 b -12 502 -22 508 -16 506 b 280 30 -8 498 278 36 b 281 22 281 28 281 25 b 268 2 281 14 276 5 b 226 0 265 1 246 0 b 185 2 207 0 188 1 b 58 199 178 4 182 -1 b -60 389 -7 304 -60 389 b -178 199 -60 389 -114 304 b -305 2 -302 -1 -298 4 b -314 0 -308 1 -311 0 b -336 22 -326 0 -336 10 b -334 30 -336 25 -335 27 b -43 502 -332 36 -46 498 b -36 506 -41 504 -38 506 z m -56 196 b -41 197 -51 197 -46 197 b 33 163 -14 197 15 184 b 57 99 50 145 57 121 b 15 17 57 67 43 36 b -41 0 -3 5 -22 0 b -139 99 -92 0 -139 40 b -56 196 -139 148 -105 187 z"
    },
    fermataVeryShortBelow: {
      x_min: -351,
      x_max: 351,
      y_min: -571,
      y_max: 0,
      ha: 571,
      o: "m 9 -820 b 0 -822 6 -821 3 -822 b -8 -820 -3 -822 -6 -821 b -35 -785 -15 -818 -17 -815 b -68 -733 -45 -770 -59 -747 b -98 -684 -76 -720 -90 -698 b -146 -606 -107 -670 -128 -635 b -193 -532 -164 -578 -185 -544 b -227 -477 -200 -519 -216 -495 b -313 -337 -277 -396 -301 -358 b -362 -260 -321 -325 -343 -290 b -406 -188 -380 -230 -400 -197 b -436 -140 -412 -179 -425 -157 b -505 -25 -500 -37 -505 -30 b -505 -22 -505 -24 -505 -23 b -491 -2 -505 -13 -499 -5 b -450 0 -488 -1 -469 0 b -409 -2 -431 0 -412 -1 b -382 -37 -403 -4 -400 -7 b -350 -89 -373 -52 -358 -75 b -319 -138 -342 -102 -328 -124 b -271 -216 -311 -152 -289 -187 b -225 -290 -253 -244 -232 -278 b -191 -345 -217 -302 -202 -327 b -104 -485 -142 -424 -117 -464 b -8 -639 -73 -534 -24 -613 b 21 -686 2 -655 15 -676 b 33 -704 27 -696 33 -704 b 44 -686 33 -704 38 -696 b 73 -639 51 -676 64 -655 b 170 -485 89 -614 133 -543 b 203 -430 177 -472 192 -448 b 290 -290 253 -351 277 -311 b 337 -216 298 -278 319 -244 b 385 -138 355 -187 376 -152 b 415 -89 393 -124 407 -102 b 448 -37 424 -75 438 -52 b 474 -2 466 -7 468 -4 b 483 0 477 -1 480 0 b 505 -22 495 0 505 -9 b 505 -25 505 -23 505 -24 b 436 -140 505 -30 500 -37 b 406 -188 425 -157 412 -179 b 362 -260 400 -197 380 -230 b 313 -337 343 -290 321 -325 b 227 -477 301 -358 277 -396 b 193 -532 216 -495 200 -519 b 146 -606 185 -544 164 -578 b 98 -684 128 -635 107 -670 b 68 -733 90 -697 76 -720 b 35 -785 59 -747 45 -770 b 9 -820 17 -814 14 -818 z m 36 -506 b 28 -508 33 -507 30 -508 b 12 -502 22 -508 16 -506 b -280 -30 8 -498 -278 -36 b -281 -22 -281 -28 -281 -25 b -268 -2 -281 -14 -276 -5 b -226 0 -265 -1 -246 0 b -185 -2 -207 0 -188 -1 b -58 -199 -178 -4 -182 1 b 60 -389 7 -304 60 -389 b 178 -199 60 -389 114 -304 b 305 -2 302 1 298 -4 b 314 0 308 -1 311 0 b 336 -22 326 0 336 -10 b 334 -30 336 -25 335 -27 b 43 -502 332 -36 46 -498 b 36 -506 41 -504 38 -506 z m 56 -196 b 41 -197 51 -197 46 -197 b -33 -163 14 -197 -15 -184 b -57 -99 -50 -145 -57 -121 b -15 -17 -57 -67 -43 -36 b 41 0 3 -5 22 0 b 139 -99 92 0 139 -40 b 56 -196 139 -148 105 -187 z"
    },
    fermataShortAbove: {
      x_min: -286,
      x_max: 286,
      y_min: 0,
      y_max: 469,
      ha: 469,
      o: "m -9 674 b 0 676 -6 675 -3 676 b 15 670 6 676 11 674 b 74 576 17 667 37 637 b 233 319 105 526 176 410 b 373 92 290 227 353 125 b 411 30 393 59 410 31 b 412 23 412 27 412 25 b 398 2 412 14 407 5 b 357 0 396 1 376 0 b 316 2 338 0 319 1 b 250 100 309 4 309 4 b 91 357 220 150 148 266 b -22 541 35 449 -17 532 b -33 558 -28 550 -33 558 b -42 544 -33 558 -37 551 b -137 389 -47 536 -89 467 b -240 223 -185 312 -231 237 b -382 2 -387 -16 -374 4 b -390 0 -385 1 -387 0 b -412 22 -402 0 -412 9 l -412 22 b -375 90 -412 29 -412 29 b -253 286 -285 236 -269 261 b -182 402 -244 301 -212 354 b -34 641 -127 491 -64 593 b -9 674 -17 668 -15 672 z m -15 196 b -1 197 -10 197 -5 197 b 74 163 27 197 56 184 b 98 99 90 145 98 121 b 55 17 98 67 83 36 b 0 0 38 5 19 0 b -98 99 -51 0 -98 40 b -15 196 -98 148 -65 187 z"
    },
    fermataShortBelow: {
      x_min: -286,
      x_max: 286,
      y_min: -469,
      y_max: 0,
      ha: 469,
      o: "m -399 -2 b -390 0 -396 -1 -393 0 b -375 -6 -385 0 -379 -3 b -316 -100 -373 -9 -353 -39 b -157 -358 -285 -150 -214 -266 b -43 -541 -100 -449 -49 -532 b -33 -558 -38 -550 -33 -558 b -24 -544 -32 -558 -28 -552 b 20 -473 -19 -536 1 -505 b 72 -390 39 -442 62 -405 b 143 -274 81 -375 113 -322 b 291 -35 198 -185 261 -83 b 316 -2 308 -8 310 -4 b 357 0 319 -1 338 0 b 399 -2 377 0 396 -1 b 412 -23 407 -5 412 -14 b 411 -30 412 -25 412 -27 b 392 -62 410 -31 402 -46 b 355 -122 382 -78 365 -105 b 253 -287 345 -138 299 -212 b 152 -451 207 -361 162 -435 b 76 -573 142 -467 108 -522 b 4 -676 16 -671 13 -676 b 0 -676 3 -676 1 -676 b -4 -676 -1 -676 -3 -676 b -74 -576 -13 -676 -16 -671 b -233 -319 -105 -526 -176 -411 b -373 -92 -290 -227 -353 -125 b -411 -30 -393 -59 -410 -31 b -412 -23 -412 -27 -412 -25 b -399 -2 -412 -14 -407 -5 z m -15 -1 b 0 0 -10 0 -5 0 b 82 -43 31 0 64 -17 b 99 -98 93 -61 99 -80 b 0 -197 99 -150 58 -197 b -99 -98 -58 -197 -99 -150 b -82 -43 -99 -80 -93 -61 b -15 -1 -67 -21 -43 -6 z"
    },
    breathMarkComma: {
      x_min: 0,
      x_max: 168,
      y_min: -155,
      y_max: 155,
      ha: 311,
      o: "m 96 223 b 107 224 100 224 103 224 b 236 104 164 224 218 174 b 242 55 240 88 242 71 b 66 -209 242 -42 175 -144 b 33 -224 48 -219 39 -224 b 25 -219 30 -224 28 -222 b 23 -213 24 -216 23 -215 b 36 -199 23 -208 28 -204 b 130 -56 96 -166 130 -110 b 111 8 130 -34 124 -12 l 110 10 l 100 11 b 6 82 58 12 19 42 b 0 117 2 94 0 105 b 96 223 0 170 40 217 z"
    },
    breathMarkUpbow: {
      x_min: -125,
      x_max: 125,
      y_min: 0,
      y_max: 409,
      ha: 409,
      o: "m -171 588 b -130 589 -168 589 -166 589 l -123 589 b -83 585 -87 589 -88 589 b -23 385 -80 581 -84 594 b 34 193 8 280 34 193 b 91 385 34 193 60 280 b 149 580 122 491 148 579 b 164 590 151 586 157 590 b 179 580 170 590 176 586 b 180 577 179 579 180 579 b 99 292 180 569 169 533 b 13 6 18 16 15 6 b 13 6 13 6 13 6 b 12 5 13 6 13 6 b 0 0 9 2 5 0 b -16 11 -7 0 -13 4 b -180 573 -25 41 -180 570 b -171 588 -180 580 -177 586 z"
    },
    caesura: {
      x_min: 0,
      x_max: 457,
      y_min: -202,
      y_max: 303,
      ha: 504,
      o: "m 423 434 b 431 436 426 435 428 436 b 453 414 443 436 453 426 b 452 406 453 411 453 409 b 37 -284 450 401 41 -281 b 23 -290 33 -289 28 -290 b 0 -268 11 -290 0 -281 b 1 -261 0 -266 0 -263 b 416 430 3 -256 413 427 b 423 434 418 431 421 433 z m 627 434 b 636 436 630 435 633 436 b 658 414 648 436 658 426 b 657 406 658 411 658 409 b 242 -284 655 401 245 -281 b 227 -290 238 -289 232 -290 b 205 -268 216 -290 205 -281 b 206 -261 205 -266 205 -263 b 621 430 208 -256 618 427 b 627 434 623 431 625 433 z"
    },
    caesuraCurved: {
      x_min: 0,
      x_max: 370,
      y_min: -207,
      y_max: 310,
      ha: 517,
      o: "m 291 447 b 296 447 293 447 294 447 b 328 410 314 447 328 431 b 328 403 328 408 328 406 b 325 384 328 401 326 392 b 44 -284 299 206 196 -38 b 22 -298 38 -293 30 -298 b 7 -291 16 -298 11 -296 b 0 -278 2 -287 0 -283 b 11 -251 0 -272 3 -264 b 262 409 146 -12 245 246 b 291 447 264 433 273 444 z m 496 447 b 501 447 498 447 499 447 b 533 410 519 447 533 431 b 533 403 533 408 533 406 b 530 384 532 401 531 392 b 248 -284 504 206 401 -38 b 226 -298 242 -293 234 -298 b 211 -291 221 -298 216 -296 b 205 -278 207 -287 205 -283 b 215 -251 205 -272 208 -264 b 466 409 351 -12 449 246 b 496 447 469 433 477 444 z"
    },
    restMaxima: {
      x_min: 0,
      x_max: 853,
      y_min: -250,
      y_max: 250,
      ha: 500,
      o: "m 0 0 l 0 360 l 205 360 l 409 360 l 409 0 l 409 -360 l 205 -360 l 0 -360 z m 819 0 l 819 360 l 1023 360 l 1228 360 l 1228 0 l 1228 -360 l 1023 -360 l 819 -360 z"
    },
    restDoubleWhole: {
      x_min: 0,
      x_max: 284,
      y_min: 0,
      y_max: 250,
      ha: 250,
      o: "m 0 180 l 0 360 l 205 360 l 409 360 l 409 180 l 409 0 l 205 0 l 0 0 z"
    },
    restWhole: {
      x_min: 0,
      x_max: 330,
      y_min: -125,
      y_max: 0,
      ha: 125,
      o: "m 0 -90 l 0 0 l 237 0 l 475 0 l 475 -90 l 475 -180 l 237 -180 l 0 -180 z"
    },
    restWholeLegerLine: {
      x_min: 0,
      x_max: 542,
      y_min: -125,
      y_max: 11,
      ha: 137,
      o: "m 9 15 b 427 17 11 16 226 17 b 771 15 603 17 769 16 b 780 0 777 13 780 6 b 771 -15 780 -6 777 -13 b 698 -16 768 -16 760 -16 l 628 -16 l 628 -98 l 628 -180 l 390 -180 l 153 -180 l 153 -98 l 153 -16 l 83 -16 b 10 -15 21 -16 12 -16 b 0 0 3 -13 0 -6 b 9 15 0 6 3 12 z"
    },
    restHalf: {
      x_min: 0,
      x_max: 330,
      y_min: 0,
      y_max: 125,
      ha: 125,
      o: "m 0 90 l 0 180 l 237 180 l 475 180 l 475 90 l 475 0 l 237 0 l 0 0 z"
    },
    restHalfLegerLine: {
      x_min: 0,
      x_max: 542,
      y_min: -11,
      y_max: 125,
      ha: 137,
      o: "m 153 98 l 153 180 l 390 180 l 628 180 l 628 98 l 628 16 l 698 16 b 771 15 760 16 769 16 b 781 0 777 13 781 6 b 771 -15 781 -6 777 -13 b 427 -17 769 -16 603 -17 b 9 -15 226 -17 11 -16 b 0 0 3 -12 0 -6 b 4 12 0 4 1 8 b 58 16 9 16 5 16 b 83 16 65 16 73 16 l 153 16 z"
    },
    restQuarter: {
      x_min: 0,
      x_max: 221,
      y_min: -365,
      y_max: 365,
      ha: 730,
      o: "m 50 524 b 56 526 52 525 54 526 b 74 516 62 526 67 523 b 96 497 78 513 88 504 b 118 478 105 489 115 481 b 181 423 143 456 154 447 b 311 305 302 317 311 310 b 310 302 311 304 310 303 b 310 299 310 301 310 300 b 298 278 310 295 310 294 b 234 132 268 233 245 181 b 222 39 226 100 222 69 b 306 -177 222 -46 251 -123 b 319 -198 318 -190 319 -191 b 303 -214 319 -208 313 -214 b 291 -212 299 -214 295 -213 b 260 -208 281 -209 270 -208 b 155 -260 221 -208 181 -227 b 122 -353 133 -287 122 -320 b 185 -490 122 -400 143 -450 b 197 -510 193 -498 197 -505 b 191 -521 197 -514 195 -517 b 181 -526 188 -524 185 -526 b 136 -495 173 -526 161 -517 b 0 -270 48 -420 0 -340 l 0 -270 l 0 -253 l 2 -243 b 157 -146 19 -182 78 -146 b 217 -152 176 -146 196 -148 l 228 -155 l 226 -152 b 124 -62 223 -150 168 -101 b 19 37 23 27 19 31 b 19 39 19 38 19 39 l 19 40 b 29 59 19 46 19 47 b 117 312 87 138 117 229 b 53 489 117 382 96 446 b 41 509 42 500 41 503 b 50 524 41 516 44 521 z"
    },
    rest8th: {
      x_min: 0,
      x_max: 258,
      y_min: -197,
      y_max: 219,
      ha: 416,
      o: "m 98 315 b 110 316 102 315 106 316 b 177 293 132 316 159 307 b 218 207 204 271 218 239 b 191 137 218 182 209 157 l 187 132 l 193 134 b 326 260 251 150 302 198 b 331 270 328 264 330 269 b 349 279 336 276 343 279 b 371 257 360 279 371 270 b 213 -273 371 253 216 -267 b 194 -283 209 -280 202 -283 b 173 -270 185 -283 176 -279 b 172 -265 172 -268 172 -268 b 230 -62 172 -257 180 -228 b 289 134 263 46 289 134 b 289 134 289 134 289 134 b 280 128 289 134 285 131 b 149 84 241 98 194 84 b 39 121 108 84 69 96 b 0 204 13 142 0 173 b 31 282 0 232 10 260 b 98 315 48 300 69 311 z"
    },
    rest16th: {
      x_min: 0,
      x_max: 331,
      y_min: -443,
      y_max: 219,
      ha: 662,
      o: "m 205 315 b 216 316 208 315 212 316 b 283 293 239 316 265 307 b 324 207 310 271 324 239 b 298 137 324 182 316 157 l 293 132 l 299 134 b 433 260 358 150 409 198 b 438 270 434 264 437 269 b 455 279 443 276 449 279 b 477 257 467 279 477 270 b 213 -627 477 253 216 -621 b 194 -638 209 -635 202 -638 b 173 -625 185 -638 176 -634 b 172 -620 172 -623 172 -622 b 230 -417 172 -612 180 -583 b 289 -221 263 -309 289 -221 b 289 -221 289 -221 289 -221 b 280 -227 289 -221 285 -223 b 149 -271 241 -256 194 -271 b 39 -234 108 -271 69 -259 b 0 -150 13 -213 0 -182 b 31 -73 0 -123 10 -95 b 110 -39 52 -50 81 -39 b 207 -100 149 -39 188 -60 b 218 -147 214 -114 218 -131 b 191 -218 218 -173 209 -199 l 187 -223 l 193 -221 b 326 -96 251 -205 302 -157 b 395 134 328 -91 395 133 b 395 134 395 134 395 134 b 387 128 395 134 391 131 b 256 84 347 98 301 84 b 145 121 215 84 175 96 b 106 204 119 142 106 173 b 137 282 106 232 116 260 b 205 315 155 300 176 311 z"
    },
    rest32nd: {
      x_min: 0,
      x_max: 405,
      y_min: -443,
      y_max: 466,
      ha: 909,
      o: "m 311 670 b 322 670 315 670 318 670 b 390 647 345 670 371 662 b 431 562 417 626 431 594 b 404 492 431 536 422 511 l 400 487 l 406 488 b 539 614 464 504 515 552 b 544 625 541 619 543 623 b 562 633 549 631 555 633 b 584 612 573 633 584 625 b 213 -627 584 607 216 -621 b 194 -638 209 -635 202 -638 b 173 -625 185 -638 176 -634 b 172 -620 172 -623 172 -622 b 230 -417 172 -612 180 -583 b 289 -221 263 -309 289 -221 b 289 -221 289 -221 289 -221 b 280 -227 289 -221 285 -223 b 149 -271 241 -256 194 -271 b 39 -234 108 -271 69 -259 b 0 -150 13 -213 0 -182 b 31 -73 0 -123 10 -95 b 110 -39 52 -50 81 -39 b 207 -100 149 -39 188 -60 b 218 -147 214 -114 218 -131 b 191 -218 218 -173 209 -199 l 187 -223 l 193 -221 b 326 -96 251 -205 302 -157 b 395 134 328 -91 395 133 b 395 134 395 134 395 134 b 387 128 395 134 391 131 b 256 84 347 98 301 84 b 145 121 215 84 175 96 b 106 204 119 142 106 173 b 137 282 106 232 116 260 b 216 315 159 304 187 315 b 314 255 255 315 295 294 b 324 208 321 240 324 224 b 298 137 324 182 315 156 l 293 132 l 299 134 b 432 258 357 149 409 198 b 502 489 434 264 502 487 b 502 489 502 489 502 489 b 493 483 502 489 498 486 b 362 438 454 453 407 438 b 251 475 321 438 282 451 b 213 559 226 496 213 528 b 243 636 213 587 223 615 b 311 670 261 655 282 665 z"
    },
    rest64th: {
      x_min: 0,
      x_max: 479,
      y_min: -689,
      y_max: 466,
      ha: 1155,
      o: "m 417 670 b 429 670 421 670 425 670 b 496 647 451 670 478 662 b 537 562 523 626 537 594 b 510 492 537 536 529 511 l 506 487 l 512 488 b 646 614 570 504 621 552 b 651 625 647 619 650 623 b 668 633 655 631 662 633 b 690 612 679 633 690 625 b 213 -982 690 607 216 -976 b 194 -993 209 -989 202 -993 b 173 -979 185 -993 176 -988 b 172 -974 172 -978 172 -977 b 230 -771 172 -966 180 -938 b 289 -575 263 -664 289 -575 b 289 -575 289 -575 289 -575 b 280 -582 289 -575 285 -578 b 149 -626 241 -611 194 -626 b 39 -589 108 -626 69 -613 b 0 -505 13 -568 0 -537 b 31 -428 0 -477 10 -449 b 110 -394 52 -405 81 -394 b 207 -454 149 -394 188 -415 b 218 -502 214 -469 218 -485 b 191 -572 218 -528 209 -553 l 187 -577 l 193 -576 b 326 -451 251 -560 302 -512 b 395 -221 328 -446 395 -222 b 395 -221 395 -221 395 -221 b 387 -227 395 -221 391 -223 b 256 -271 347 -256 301 -271 b 145 -234 215 -271 175 -259 b 106 -150 119 -213 106 -182 b 137 -73 106 -123 116 -95 b 216 -39 159 -50 187 -39 b 314 -100 255 -39 295 -60 b 324 -147 321 -114 324 -131 b 298 -218 324 -173 315 -199 l 293 -223 l 299 -221 b 432 -96 357 -205 409 -157 b 502 134 434 -91 502 133 b 502 134 502 134 502 134 b 493 128 502 134 498 131 b 362 84 454 98 407 84 b 251 121 321 84 282 96 b 213 204 226 142 213 173 b 243 282 213 232 223 260 b 322 315 265 304 294 315 b 420 255 362 315 401 294 b 431 208 427 240 431 224 b 404 137 431 182 422 156 l 400 132 l 406 134 b 539 258 463 149 515 198 b 608 489 541 264 608 487 b 608 489 608 489 608 489 b 599 483 608 489 604 486 b 468 438 560 453 513 438 b 358 475 428 438 388 451 b 319 559 332 496 319 528 b 350 636 319 587 329 615 b 417 670 368 655 388 665 z"
    },
    rest128th: {
      x_min: 0,
      x_max: 553,
      y_min: -689,
      y_max: 712,
      ha: 1401,
      o: "m 524 1024 b 535 1025 527 1025 531 1025 b 603 1002 558 1025 584 1016 b 644 916 630 981 644 949 b 617 846 644 891 635 866 l 612 841 l 619 843 b 752 969 677 859 728 907 b 757 979 754 973 756 978 b 775 988 762 985 768 988 b 797 966 786 988 797 980 b 213 -982 797 962 216 -976 b 194 -993 209 -989 202 -993 b 173 -979 185 -993 176 -988 b 172 -974 172 -978 172 -977 b 230 -771 172 -966 180 -938 b 289 -575 263 -664 289 -575 b 289 -575 289 -575 289 -575 b 280 -582 289 -575 285 -578 b 149 -626 241 -611 194 -626 b 39 -589 108 -626 69 -613 b 0 -505 13 -568 0 -537 b 31 -428 0 -477 10 -449 b 110 -394 52 -405 81 -394 b 207 -454 149 -394 188 -415 b 218 -502 214 -469 218 -485 b 191 -572 218 -528 209 -553 l 187 -577 l 193 -576 b 326 -451 251 -560 302 -512 b 395 -221 328 -446 395 -222 b 395 -221 395 -221 395 -221 b 387 -227 395 -221 391 -223 b 256 -271 347 -256 301 -271 b 145 -234 215 -271 175 -259 b 106 -150 119 -213 106 -182 b 137 -73 106 -123 116 -95 b 216 -39 159 -50 187 -39 b 314 -100 255 -39 295 -60 b 324 -147 321 -114 324 -131 b 298 -218 324 -173 315 -199 l 293 -223 l 299 -221 b 432 -96 357 -205 409 -157 b 502 134 434 -91 502 133 b 502 134 502 134 502 134 b 493 128 502 134 498 131 b 362 84 454 98 407 84 b 251 121 321 84 282 96 b 213 204 226 142 213 173 b 243 282 213 232 223 260 b 322 315 265 304 294 315 b 420 255 362 315 401 294 b 431 208 427 240 431 224 b 404 137 431 182 422 156 l 400 132 l 406 134 b 539 258 463 149 515 198 b 608 489 541 264 608 487 b 608 489 608 489 608 489 b 599 483 608 489 604 486 b 468 438 560 453 513 438 b 358 475 428 438 388 451 b 319 559 332 496 319 528 b 350 636 319 587 329 615 b 429 670 372 659 400 670 b 526 610 468 670 507 649 b 537 563 534 595 537 579 b 511 492 537 536 528 511 l 506 487 l 512 488 b 645 613 570 504 621 553 b 715 843 647 618 715 842 b 715 843 715 843 715 843 b 706 837 714 843 711 841 b 575 793 667 808 620 793 b 464 830 534 793 495 805 b 426 914 439 851 426 882 b 456 991 426 941 436 969 b 524 1024 474 1010 495 1020 z"
    },
    dynamicPiano: {
      x_min: -39,
      x_max: 378,
      y_min: -178,
      y_max: 277,
      ha: 455,
      o: "m 197 399 b 208 399 201 399 205 399 b 305 314 255 399 298 362 l 306 308 l 312 315 b 405 382 339 346 376 373 b 430 386 413 385 421 386 b 494 362 451 386 474 378 b 544 249 526 336 544 296 b 377 -30 544 116 475 1 b 334 -37 362 -34 347 -37 b 291 -25 316 -37 300 -33 b 281 -17 289 -23 285 -20 b 240 43 262 -1 248 20 b 237 52 238 47 237 52 b 237 53 237 52 237 53 b 198 -74 236 53 229 30 b 159 -207 166 -181 159 -202 b 160 -209 159 -208 160 -208 b 194 -221 165 -213 179 -218 b 206 -224 198 -222 204 -224 b 217 -240 213 -226 217 -233 b 208 -255 217 -246 214 -252 b 81 -257 206 -256 144 -257 b -46 -255 18 -257 -44 -256 b -56 -240 -52 -252 -56 -246 b -51 -229 -56 -236 -54 -232 b -33 -222 -48 -225 -46 -225 b 29 -191 9 -213 24 -206 b 174 291 34 -177 173 286 b 176 303 174 294 175 299 b 178 317 177 308 178 313 b 163 336 178 329 173 336 b 157 336 161 336 159 336 b 70 239 124 326 90 288 b 56 224 65 225 63 224 b 46 233 49 224 46 227 b 49 248 46 237 47 242 b 149 376 70 302 105 347 b 161 385 154 379 160 383 b 197 399 168 391 184 397 z m 399 318 b 389 320 396 320 393 320 b 318 285 370 320 340 306 b 302 263 306 273 304 270 b 297 253 301 260 299 256 b 273 176 296 250 288 226 l 251 104 l 252 97 b 266 51 253 81 258 64 b 296 29 274 39 288 29 b 298 29 297 29 297 29 b 309 34 299 30 304 32 b 429 230 370 62 420 144 b 431 256 430 240 431 249 b 399 318 431 289 421 307 z"
    },
    dynamicMezzo: {
      x_min: 35,
      x_max: 493,
      y_min: -19,
      y_max: 272,
      ha: 291,
      o: "m 191 390 b 206 392 196 391 201 392 b 282 350 235 392 265 376 b 291 331 285 345 291 333 b 292 330 291 330 292 330 b 297 337 292 330 294 331 b 329 371 306 350 317 362 b 339 380 332 374 336 377 b 376 392 347 388 361 392 b 434 372 395 392 418 385 b 463 331 447 362 461 341 b 464 330 463 330 463 330 b 469 337 464 330 466 331 b 501 371 478 350 489 362 b 511 380 504 374 508 377 b 548 392 519 388 533 392 b 606 372 567 392 589 385 b 641 295 628 354 641 323 b 633 260 641 282 639 270 b 576 69 631 256 576 72 b 574 59 576 68 575 63 b 573 47 573 55 573 51 b 585 25 573 35 577 25 b 586 26 585 25 585 25 b 684 127 621 30 664 74 b 699 145 690 143 692 145 b 709 135 706 145 709 142 b 696 98 709 128 705 116 b 595 -12 672 47 640 12 b 582 -20 590 -15 584 -19 b 552 -27 573 -25 563 -27 b 481 18 524 -27 495 -10 b 470 63 474 31 470 47 b 478 98 470 76 473 88 b 535 289 480 102 535 285 b 537 298 535 290 536 294 b 538 311 538 303 538 307 b 522 339 538 324 533 333 b 516 341 519 340 517 341 b 507 337 514 341 512 340 b 468 282 491 329 470 300 b 462 261 467 276 464 264 b 422 133 461 259 444 203 b 380 2 383 1 384 4 l 378 0 l 333 0 b 321 0 329 0 324 0 b 283 5 284 0 286 0 b 282 8 282 6 282 7 b 322 149 282 15 288 37 b 363 289 344 224 363 287 b 365 299 364 292 364 296 b 367 311 366 303 367 307 b 350 339 367 324 361 333 b 344 341 347 340 346 341 b 336 337 342 341 340 340 b 296 282 319 329 298 300 b 290 261 295 276 292 264 b 251 133 289 259 272 203 b 208 2 211 1 212 4 l 206 0 l 161 0 b 149 0 157 0 152 0 b 111 5 112 0 114 0 b 110 8 110 6 110 7 b 150 149 110 15 116 37 b 191 289 172 224 191 287 b 193 299 192 292 193 296 b 195 311 194 303 195 307 b 179 338 195 323 189 333 b 171 340 176 339 174 340 b 150 333 166 340 160 338 b 75 240 120 318 92 283 b 60 224 69 225 67 224 b 50 233 53 224 50 227 b 53 248 50 237 51 242 b 162 378 75 306 117 355 b 170 383 164 379 168 381 b 191 390 176 386 183 389 z"
    },
    dynamicForte: {
      x_min: -87,
      x_max: 440,
      y_min: -182,
      y_max: 415,
      ha: 597,
      o: "m 486 597 b 491 597 487 597 489 597 b 515 596 499 597 512 597 b 528 595 517 596 523 595 b 631 522 576 591 622 559 b 633 506 632 516 633 511 b 559 433 633 466 598 433 b 532 439 550 433 541 435 b 493 499 506 450 493 475 b 518 548 493 517 501 536 b 519 550 519 549 519 549 b 519 550 519 550 519 550 b 496 537 518 550 504 542 b 371 353 445 503 399 436 b 367 341 369 347 367 341 b 407 341 367 341 385 341 b 414 341 410 341 412 341 b 459 335 452 341 451 341 b 468 314 465 330 468 322 b 459 293 468 306 465 298 b 411 286 451 287 453 286 b 399 286 407 286 404 286 l 353 286 l 351 279 b 174 -146 320 120 253 -41 b -24 -262 120 -218 45 -262 b -28 -262 -25 -262 -26 -262 b -125 -165 -83 -260 -125 -217 b -122 -140 -125 -157 -124 -148 b -53 -89 -113 -106 -83 -89 b 17 -142 -23 -89 8 -107 b 19 -158 18 -147 19 -153 b -13 -214 19 -181 7 -202 b -16 -217 -15 -216 -16 -216 b -16 -217 -16 -217 -16 -217 b -10 -215 -15 -217 -13 -216 b 80 -130 25 -205 58 -173 b 102 -74 88 -115 93 -102 b 186 245 126 -3 146 72 b 196 285 191 267 196 285 b 196 285 196 285 196 285 b 151 286 196 286 192 286 b 98 290 103 286 102 287 b 83 314 88 296 83 305 b 98 338 83 323 88 332 b 157 341 102 341 102 341 l 211 341 l 215 353 b 486 597 264 491 372 588 z"
    },
    dynamicRinforzando: {
      x_min: 58,
      x_max: 357,
      y_min: 0,
      y_max: 275,
      ha: 275,
      o: "m 383 395 b 401 396 389 395 395 396 b 508 352 446 396 495 377 b 515 327 513 344 515 336 b 490 285 515 310 506 293 b 465 278 482 280 474 278 b 423 301 450 278 434 286 b 365 332 408 322 386 332 b 299 281 335 332 307 314 b 296 272 298 277 297 273 b 294 266 295 271 294 269 b 291 260 293 264 292 261 b 252 133 290 259 273 201 b 210 2 213 1 214 4 l 207 0 l 163 0 b 150 0 158 0 154 0 b 112 5 113 0 115 0 b 111 8 112 6 111 7 b 152 149 111 15 118 37 b 193 289 174 225 192 287 b 195 300 193 292 194 296 b 197 315 196 305 197 310 b 175 344 197 331 189 342 b 170 344 173 344 172 344 b 109 316 149 344 127 334 b 95 306 100 306 99 306 b 84 316 88 306 84 310 b 87 325 84 319 85 322 b 149 372 99 341 127 363 b 211 388 168 381 197 388 b 215 388 213 388 214 388 b 283 349 245 385 267 372 b 285 345 284 347 285 345 b 285 345 285 345 285 345 b 291 350 286 345 288 347 b 383 395 316 374 349 390 z"
    },
    dynamicSforzando: {
      x_min: 52,
      x_max: 278,
      y_min: -22,
      y_max: 270,
      ha: 292,
      o: "m 259 388 b 271 388 263 388 267 388 b 370 362 305 388 338 379 b 396 338 385 354 391 348 b 401 315 399 331 401 323 b 359 261 401 290 384 266 b 349 260 356 260 352 260 b 300 306 322 260 300 282 b 305 327 300 313 302 320 b 308 332 307 330 308 332 b 308 332 308 332 308 332 b 287 334 308 334 297 334 b 269 333 279 334 272 334 b 220 300 245 329 226 316 b 219 295 219 299 219 297 b 273 232 219 278 243 249 b 301 215 289 223 295 219 b 373 95 347 181 373 136 b 361 49 373 79 369 63 b 219 -32 332 -4 277 -32 b 101 7 179 -32 138 -19 b 75 51 84 19 75 34 b 85 82 75 61 78 71 b 129 106 94 98 112 106 b 164 92 142 106 154 102 b 178 59 173 83 178 71 b 170 34 178 50 175 42 l 166 29 l 168 28 b 203 22 178 24 190 22 b 226 25 211 22 219 23 b 275 68 253 31 275 52 b 274 75 275 70 274 73 b 217 132 264 98 249 114 b 122 262 161 163 127 210 b 122 270 122 265 122 267 b 259 388 122 329 184 384 z"
    },
    dynamicZ: {
      x_min: 23,
      x_max: 309,
      y_min: 2,
      y_max: 250,
      ha: 248,
      o: "m 124 360 b 222 360 125 360 168 360 b 435 359 312 360 434 360 b 445 344 442 356 445 350 b 440 331 445 339 444 335 b 314 227 438 330 382 283 b 190 124 247 172 191 125 l 188 123 l 201 123 b 205 123 202 123 204 123 b 268 101 231 123 249 117 b 320 79 284 88 305 79 b 326 80 322 79 324 79 b 340 93 330 81 334 84 b 342 97 341 96 342 97 b 342 98 342 98 342 98 b 340 97 342 98 341 97 b 330 96 336 96 333 96 b 294 134 311 96 294 113 b 295 142 294 136 294 139 b 340 176 299 163 320 176 b 371 163 351 176 363 172 b 383 124 380 154 383 139 b 359 60 383 100 375 74 b 322 30 350 51 329 35 b 239 3 295 12 266 3 b 179 21 218 3 197 9 b 117 39 161 33 138 39 b 86 35 106 39 95 38 b 67 23 79 32 76 31 b 49 14 58 15 55 14 b 33 30 39 14 33 21 b 38 42 33 34 34 38 b 73 72 41 46 60 62 b 303 262 80 77 299 258 b 303 262 303 262 303 262 b 246 263 303 262 277 263 b 146 261 203 263 150 262 b 102 239 131 259 117 252 b 88 231 94 232 92 231 b 85 230 87 230 86 230 b 69 246 76 230 69 237 l 69 247 l 69 252 l 92 302 b 116 355 104 330 115 354 b 124 360 118 357 122 359 z"
    },
    ornamentTrill: {
      x_min: -249,
      x_max: 249,
      y_min: 0,
      y_max: 376,
      ha: 376,
      o: "m -92 502 b -29 542 -33 541 -33 542 b -21 534 -25 542 -21 539 b -70 366 -21 532 -65 383 l -71 364 l -47 364 b 125 383 13 366 71 372 b 149 387 136 386 143 387 b 167 382 156 387 160 385 b 181 370 171 380 179 373 b 182 370 181 370 181 370 b 230 380 185 370 195 372 b 304 394 286 393 290 394 b 305 394 305 394 305 394 b 357 353 330 394 349 379 b 359 336 358 349 359 342 b 354 314 359 326 357 316 b 257 291 352 312 263 291 b 257 291 257 291 257 291 b 250 299 252 292 250 294 b 251 305 250 301 250 303 b 251 314 251 308 251 311 b 234 350 251 329 245 343 l 230 353 l 224 349 b 169 287 202 334 183 313 b 127 156 163 276 166 286 b 88 37 92 43 91 39 b -8 15 84 35 -4 15 b -8 15 -8 15 -8 15 b -14 22 -12 16 -14 17 b -8 47 -14 26 -12 33 b -2 69 -5 59 -2 69 b -2 69 -2 69 -2 69 b -45 44 -2 69 -22 58 b -122 4 -102 10 -105 9 b -151 0 -132 1 -142 0 b -256 105 -208 0 -256 46 b -255 119 -256 110 -256 114 b -223 231 -254 129 -256 121 b -195 325 -208 282 -195 325 b -195 325 -195 325 -195 325 b -198 325 -196 325 -196 325 b -274 324 -206 325 -237 325 b -340 324 -310 324 -329 324 b -354 325 -351 324 -353 324 b -359 332 -357 326 -359 329 b -356 338 -359 334 -358 336 b -308 351 -355 340 -353 340 l -261 361 l -222 362 l -182 363 l -168 411 b -152 461 -160 438 -153 460 b -92 502 -152 462 -125 480 z m 62 348 b 57 349 60 349 59 349 b 40 346 55 349 51 348 b -62 330 8 339 -30 333 b -83 321 -84 329 -82 330 b -115 211 -83 318 -93 283 b -148 88 -149 94 -148 99 b -148 87 -148 88 -148 88 b -123 53 -148 67 -137 53 b -113 55 -120 53 -117 54 b 18 133 -111 57 17 132 b 46 227 19 134 46 225 b 53 251 46 231 48 239 b 78 334 57 261 78 331 b 62 348 78 340 71 347 z"
    },
    ornamentTurn: {
      x_min: -310,
      x_max: 310,
      y_min: -143,
      y_max: 143,
      ha: 286,
      o: "m -272 205 b -264 206 -270 206 -267 206 b -202 198 -249 206 -221 202 b 44 48 -119 177 -37 127 b 261 -91 117 -24 191 -71 b 307 -100 285 -97 297 -100 b 318 -99 311 -100 314 -99 b 401 2 362 -92 396 -51 b 402 11 401 5 402 8 b 321 87 402 58 366 87 b 258 70 301 87 279 81 b 221 60 246 63 233 60 b 157 125 186 60 157 86 b 213 194 157 158 175 179 b 277 206 234 202 256 206 b 437 90 348 206 413 162 b 447 24 444 69 447 47 b 365 -163 447 -46 416 -120 b 257 -206 331 -192 297 -206 b 178 -192 233 -206 207 -201 b -47 -48 101 -168 28 -121 b -250 86 -116 20 -180 62 b -312 99 -275 94 -295 99 b -361 83 -331 99 -346 94 b -402 6 -388 65 -402 36 b -349 -77 -402 -28 -384 -62 b -314 -85 -337 -82 -326 -85 b -260 -70 -297 -85 -280 -80 b -224 -60 -247 -63 -235 -60 b -188 -71 -211 -60 -199 -64 b -160 -126 -169 -84 -160 -105 b -189 -181 -160 -147 -169 -168 b -272 -204 -211 -195 -242 -204 b -293 -202 -279 -204 -286 -203 b -447 -6 -385 -189 -447 -103 b -435 68 -447 18 -443 43 b -280 204 -411 141 -349 196 b -272 205 -277 205 -273 205 z"
    },
    ornamentTurnSlash: {
      x_min: -310,
      x_max: 310,
      y_min: -201,
      y_max: 201,
      ha: 402,
      o: "m -10 288 b -2 289 -7 289 -4 289 b 19 276 8 289 16 284 b 21 171 21 272 21 271 l 21 71 l 43 49 b 261 -90 120 -26 191 -71 b 307 -100 285 -97 297 -100 b 318 -99 311 -100 314 -99 b 401 2 362 -91 396 -50 b 402 12 402 5 402 8 b 321 87 402 58 367 87 b 258 70 301 87 280 82 b 221 60 246 63 233 60 b 157 125 187 60 157 86 b 214 194 157 158 175 180 b 277 206 235 202 256 206 b 431 106 342 206 402 169 b 447 24 442 82 447 54 b 443 -24 447 9 446 -7 b 258 -206 423 -127 344 -206 b 257 -206 258 -206 258 -206 b 23 -109 190 -205 102 -169 l 21 -107 l 21 -190 b 21 -223 21 -203 21 -214 b 14 -283 21 -282 20 -277 b -1 -289 10 -287 5 -289 b -22 -276 -10 -289 -18 -284 b -23 -171 -23 -272 -23 -271 l -23 -71 l -46 -49 b -250 86 -119 22 -179 62 b -312 99 -275 95 -295 99 b -360 84 -330 99 -345 94 b -401 7 -388 66 -401 36 b -349 -77 -401 -28 -383 -62 b -314 -85 -337 -82 -326 -85 b -260 -69 -297 -85 -279 -80 b -223 -60 -247 -63 -235 -60 b -177 -81 -206 -60 -190 -67 b -159 -125 -165 -93 -159 -109 b -188 -180 -159 -147 -169 -168 b -268 -203 -212 -196 -240 -203 b -376 -165 -306 -203 -345 -190 b -447 -7 -425 -124 -447 -65 b -293 202 -447 86 -390 180 b -260 206 -283 204 -272 206 b -25 109 -194 206 -105 170 l -23 107 l -23 189 b -22 276 -23 271 -23 272 b -10 288 -20 281 -15 286 z"
    },
    ornamentMordent: {
      x_min: -296,
      x_max: 296,
      y_min: -215,
      y_max: 198,
      ha: 413,
      o: "m -11 284 b -3 285 -9 285 -6 285 b 17 273 5 285 14 280 b 19 164 19 270 19 269 l 19 59 l 68 118 b 118 179 98 155 117 178 b 131 182 122 181 127 182 b 143 179 136 182 140 181 b 307 18 145 177 232 92 l 326 -1 l 356 36 b 404 81 393 81 393 81 l 404 81 b 426 59 417 81 426 71 b 424 50 426 56 426 53 b 236 -179 421 44 241 -176 b 224 -182 233 -181 228 -182 b 211 -178 219 -182 215 -181 b 119 -89 210 -178 169 -137 b 29 0 70 -40 30 0 b 29 0 29 0 29 0 b 24 -6 29 0 27 -3 l 19 -12 l 19 -152 b 19 -218 19 -179 19 -200 b 13 -303 19 -308 19 -298 b -3 -310 9 -308 3 -310 b -23 -297 -11 -310 -19 -305 b -25 -180 -24 -294 -24 -294 l -25 -66 l -70 -121 b -118 -178 -99 -156 -116 -177 b -131 -182 -122 -181 -127 -182 b -144 -178 -135 -182 -140 -181 b -307 -18 -145 -177 -233 -91 l -326 1 l -356 -36 b -404 -81 -393 -81 -393 -81 l -404 -81 b -426 -59 -417 -81 -426 -71 b -424 -50 -426 -56 -426 -53 b -236 179 -421 -44 -241 176 b -224 182 -233 181 -228 182 b -211 179 -219 182 -215 181 b -48 18 -209 177 -116 86 l -29 0 l -27 2 l -25 5 l -25 137 b -23 272 -25 267 -25 268 b -11 284 -21 277 -16 282 z"
    },
    ornamentShortTrill: {
      x_min: -296,
      x_max: 296,
      y_min: -127,
      y_max: 127,
      ha: 253,
      o: "m -231 181 b -225 182 -229 182 -227 182 b -211 179 -220 182 -215 181 b -119 89 -210 178 -169 137 b -29 0 -70 40 -30 0 b 44 88 -29 0 4 40 b 118 179 89 144 117 178 b 131 182 122 181 127 182 b 143 179 136 182 140 181 b 307 18 145 177 232 92 l 326 -1 l 356 36 b 404 81 393 81 393 81 l 404 81 b 426 59 417 81 426 71 b 424 50 426 56 426 53 b 236 -179 421 44 241 -176 b 224 -182 233 -181 228 -182 b 211 -178 219 -182 215 -181 b 119 -89 210 -178 169 -137 b 29 0 70 -40 30 0 b -44 -88 29 0 -4 -40 b -118 -179 -89 -144 -117 -178 b -131 -182 -122 -181 -127 -182 b -144 -178 -135 -182 -140 -181 b -307 -18 -145 -177 -233 -91 l -326 1 l -356 -36 b -404 -81 -393 -81 -393 -81 l -404 -81 b -426 -59 -417 -81 -426 -71 b -424 -50 -426 -56 -426 -53 b -236 179 -421 -44 -241 176 b -231 181 -235 179 -233 181 z"
    },
    ornamentTremblement: {
      x_min: -419,
      x_max: 419,
      y_min: -127,
      y_max: 127,
      ha: 253,
      o: "m -409 181 b -402 182 -407 182 -404 182 b -389 179 -397 182 -392 181 b -297 89 -387 178 -346 137 b -207 0 -248 40 -207 0 l -207 0 b -134 88 -206 0 -174 40 b -59 179 -88 144 -61 178 b -46 182 -55 181 -51 182 b -34 179 -42 182 -37 181 b 58 89 -33 178 9 137 b 148 0 107 40 148 0 l 148 0 b 221 88 148 0 181 40 b 296 179 267 144 294 178 b 308 182 300 181 304 182 b 321 179 313 182 317 181 b 485 18 323 177 409 92 l 503 -1 l 533 36 b 581 81 570 81 570 81 l 582 81 b 604 59 594 81 604 71 b 602 50 604 56 603 53 b 414 -179 599 44 418 -176 b 401 -182 410 -181 406 -182 b 388 -178 397 -182 392 -181 b 297 -89 387 -178 346 -137 b 207 0 248 -40 207 0 l 207 0 b 134 -88 206 0 174 -40 b 59 -179 88 -144 61 -178 b 46 -182 55 -181 51 -182 b 34 -178 42 -182 37 -181 b -58 -89 33 -178 -9 -137 b -148 0 -107 -40 -148 0 l -148 0 b -221 -88 -148 0 -181 -40 b -296 -179 -267 -144 -294 -178 b -308 -182 -300 -181 -304 -182 b -321 -178 -313 -182 -317 -181 b -485 -18 -323 -177 -411 -91 l -503 1 l -533 -36 b -581 -81 -570 -81 -570 -81 l -582 -81 b -604 -59 -594 -81 -604 -71 b -602 -50 -604 -56 -603 -53 b -414 179 -599 -44 -418 176 b -409 181 -412 179 -410 181 z"
    },
    ornamentPrecompAppoggTrill: {
      x_min: -419,
      x_max: 419,
      y_min: -127,
      y_max: 255,
      ha: 381,
      o: "m -591 365 b -582 367 -588 366 -585 367 b -561 352 -573 367 -564 361 b -560 176 -560 351 -560 303 l -559 2 l -527 41 b -456 128 -509 63 -477 102 b -414 177 -435 154 -416 176 b -400 182 -411 181 -405 182 b -388 179 -396 182 -392 181 b -296 89 -387 178 -346 137 b -206 0 -247 40 -207 0 b -133 88 -206 0 -173 40 b -59 179 -88 144 -60 178 b -46 182 -55 181 -50 182 b -33 179 -41 182 -37 181 b 58 89 -32 178 9 137 b 148 0 108 40 148 0 l 148 0 b 221 88 149 0 182 40 b 296 179 267 144 295 178 b 309 182 300 181 304 182 b 321 179 313 182 318 181 b 485 18 323 177 410 92 l 503 -1 l 533 36 b 581 81 570 81 571 81 l 582 81 b 604 59 595 81 604 71 b 602 50 604 56 603 53 b 414 -179 599 44 419 -176 b 402 -182 410 -181 406 -182 b 389 -178 397 -182 393 -181 b 297 -89 388 -178 346 -137 b 207 0 248 -40 207 0 l 207 0 b 134 -88 207 0 174 -40 b 59 -179 89 -144 61 -178 b 47 -182 56 -181 51 -182 b 34 -178 42 -182 38 -181 b -58 -89 33 -178 -8 -137 b -148 0 -107 -40 -147 0 b -220 -88 -148 0 -181 -40 b -295 -179 -266 -144 -294 -178 b -308 -182 -299 -181 -303 -182 b -321 -178 -312 -182 -317 -181 b -484 -18 -322 -177 -426 -76 l -503 1 l -535 -38 b -570 -79 -558 -67 -567 -77 b -582 -83 -573 -81 -578 -83 b -602 -70 -590 -83 -598 -78 l -604 -67 l -604 141 l -604 349 l -603 353 b -591 365 -601 358 -596 363 z"
    },
    ornamentPrecompSlideTrillDAnglebert: {
      x_min: -433,
      x_max: 433,
      y_min: -243,
      y_max: 127,
      ha: 370,
      o: "m -388 181 b -382 182 -386 182 -384 182 b -368 179 -377 182 -372 181 b -277 89 -367 178 -326 137 b -187 0 -227 40 -187 0 l -187 0 b -114 88 -186 0 -153 40 b -39 179 -68 144 -40 178 b -26 182 -35 181 -30 182 b -14 179 -22 182 -17 181 b 78 89 -12 178 29 137 b 168 0 127 40 168 0 b 241 88 169 0 201 40 b 316 179 287 144 314 178 b 329 182 320 181 324 182 b 341 179 333 182 337 181 b 505 18 343 177 430 92 l 523 -1 l 553 36 b 601 81 590 81 590 81 l 602 81 b 624 59 614 81 624 71 b 622 50 624 56 623 53 b 434 -179 619 44 439 -176 b 421 -182 430 -181 426 -182 b 409 -178 417 -182 412 -181 b 317 -89 407 -178 366 -137 b 227 0 268 -40 227 0 b 154 -88 227 0 194 -40 b 79 -179 108 -144 81 -178 b 67 -182 75 -181 71 -182 b 54 -178 62 -182 58 -181 b -38 -89 53 -178 12 -137 b -128 0 -87 -40 -127 0 b -201 -88 -128 0 -161 -40 b -276 -179 -246 -144 -274 -178 b -288 -182 -279 -181 -284 -182 b -301 -178 -293 -182 -297 -181 b -393 -88 -302 -178 -343 -137 b -483 0 -442 -40 -483 0 b -483 0 -483 0 -483 0 b -505 -27 -484 0 -497 -15 b -579 -235 -554 -92 -579 -166 b -567 -315 -579 -263 -575 -290 b -564 -330 -565 -320 -564 -325 b -585 -351 -564 -342 -572 -351 b -610 -326 -598 -351 -604 -345 b -624 -235 -619 -297 -624 -267 b -547 -8 -624 -159 -597 -79 b -492 60 -538 4 -533 10 b -426 140 -472 84 -443 120 b -388 181 -396 176 -394 179 z"
    },
    ornamentPrecompSlideTrillBach: {
      x_min: -433,
      x_max: 433,
      y_min: -243,
      y_max: 198,
      ha: 442,
      o: "m 186 284 b 194 285 189 285 192 285 b 215 273 203 285 211 280 b 217 164 216 270 216 269 l 217 59 l 265 118 b 316 179 295 155 314 178 b 329 182 320 181 324 182 b 341 179 333 182 337 181 b 505 18 343 177 430 92 l 523 -1 l 553 36 b 601 81 590 81 590 81 l 602 81 b 624 59 614 81 624 71 b 622 50 624 56 623 53 b 434 -179 619 44 439 -176 b 421 -182 430 -181 426 -182 b 409 -178 417 -182 412 -181 b 317 -89 407 -178 366 -137 b 227 0 268 -40 227 0 b 227 0 227 0 227 0 b 222 -6 227 0 224 -3 l 217 -12 l 217 -152 b 217 -218 217 -179 217 -200 b 210 -303 217 -308 216 -298 b 195 -310 206 -308 201 -310 b 175 -297 187 -310 178 -305 b 173 -180 173 -294 173 -294 l 173 -66 l 127 -121 b 79 -178 99 -156 81 -177 b 67 -182 76 -181 71 -182 b 54 -178 62 -182 58 -181 b -38 -89 53 -178 12 -137 b -128 0 -87 -40 -127 0 b -201 -88 -128 0 -161 -40 b -276 -179 -246 -144 -274 -178 b -288 -182 -279 -181 -284 -182 b -301 -178 -293 -182 -297 -181 b -393 -88 -302 -178 -343 -137 b -483 0 -442 -40 -483 0 b -483 0 -483 0 -483 0 b -505 -27 -484 0 -497 -15 b -579 -235 -554 -92 -579 -166 b -567 -315 -579 -263 -575 -290 b -564 -330 -565 -320 -564 -325 b -586 -351 -564 -342 -572 -351 b -610 -326 -598 -351 -604 -345 b -624 -235 -619 -297 -624 -267 b -547 -8 -624 -159 -597 -79 b -492 60 -538 4 -533 10 b -426 140 -472 84 -443 120 b -393 179 -408 162 -395 178 b -381 182 -390 181 -385 182 b -368 179 -376 182 -372 181 b -277 89 -367 178 -326 137 b -187 0 -227 40 -187 0 l -187 0 b -114 88 -186 0 -153 40 b -39 179 -68 144 -40 178 b -26 182 -35 181 -30 182 b -14 179 -22 182 -17 181 b 150 18 -12 177 81 86 l 168 0 l 171 2 l 173 5 l 173 137 b 174 272 173 267 173 268 b 186 284 176 277 181 282 z"
    },
    ornamentPrecompTrillSuffixDandrieu: {
      x_min: -433,
      x_max: 433,
      y_min: -127,
      y_max: 244,
      ha: 370,
      o: "m 577 349 b 585 351 580 350 582 351 b 601 345 591 351 597 349 b 624 229 613 332 624 275 b 622 204 624 220 623 211 b 559 27 615 139 595 83 b 492 -60 546 6 541 0 b 426 -140 472 -84 443 -120 b 393 -179 408 -162 395 -178 b 381 -182 390 -181 385 -182 b 368 -178 376 -182 372 -181 b 277 -89 367 -178 326 -137 b 187 0 227 -40 187 0 l 187 0 b 114 -88 186 0 153 -40 b 39 -179 68 -144 40 -178 b 26 -182 35 -181 31 -182 b 13 -178 22 -182 17 -181 b -78 -89 12 -178 -29 -137 b -168 0 -127 -40 -168 0 b -241 -88 -169 0 -201 -40 b -316 -179 -287 -144 -314 -178 b -329 -182 -320 -181 -324 -182 b -341 -178 -333 -182 -337 -181 b -505 -18 -343 -177 -431 -91 l -523 1 l -553 -36 b -601 -81 -590 -81 -590 -81 l -602 -81 b -624 -59 -614 -81 -624 -71 b -622 -50 -624 -56 -623 -53 b -434 179 -619 -44 -439 176 b -421 182 -430 181 -426 182 b -409 179 -417 182 -412 181 b -317 89 -408 178 -366 137 b -227 0 -268 40 -227 0 b -154 88 -227 0 -194 40 b -79 179 -108 144 -81 178 b -66 182 -75 181 -71 182 b -54 179 -62 182 -58 181 b 38 89 -53 178 -12 137 b 128 0 87 40 127 0 b 201 88 128 0 161 40 b 276 179 246 144 274 178 b 288 182 279 181 284 182 b 301 179 293 182 297 181 b 393 88 302 178 343 137 b 483 0 442 40 483 0 b 483 0 483 0 483 0 b 505 27 484 0 497 15 b 579 235 554 92 579 166 b 567 315 579 263 575 290 b 564 330 565 321 564 326 b 577 349 564 339 568 346 z"
    },
    ornamentPrecompDoubleCadenceUpperPrefix: {
      x_min: -439,
      x_max: 439,
      y_min: -127,
      y_max: 236,
      ha: 363,
      o: "m -564 338 b -555 340 -561 339 -558 340 b -534 318 -544 340 -534 331 b -534 317 -534 318 -534 317 b -541 296 -534 311 -534 311 b -588 116 -572 236 -588 175 b -583 62 -588 98 -586 80 b -554 -21 -578 34 -566 -2 l -552 -24 l -511 26 b -430 126 -488 54 -452 99 b -386 177 -407 153 -388 176 b -372 182 -382 181 -377 182 b -360 179 -368 182 -364 181 b -268 89 -359 178 -318 137 b -178 0 -219 40 -179 0 b -105 88 -178 0 -145 40 b -30 179 -60 144 -32 178 b -18 182 -27 181 -22 182 b -5 179 -13 182 -9 181 b 86 89 -4 178 37 137 b 176 0 136 40 176 0 l 176 0 b 249 88 177 0 210 40 b 324 179 295 144 323 178 b 337 182 328 181 333 182 b 349 179 341 182 346 181 b 513 18 351 177 438 92 l 532 -1 l 562 36 b 610 81 599 81 599 81 l 610 81 b 632 59 623 81 632 71 b 630 50 632 56 631 53 b 442 -179 627 44 447 -176 b 430 -182 438 -181 434 -182 b 417 -178 425 -182 421 -181 b 325 -89 416 -178 375 -137 b 235 0 276 -40 236 0 l 235 0 b 162 -88 235 0 202 -40 b 87 -179 117 -144 89 -178 b 75 -182 84 -181 79 -182 b 62 -178 70 -182 66 -181 b -29 -89 61 -178 20 -137 b -119 0 -79 -40 -119 0 b -192 -88 -120 0 -153 -40 b -267 -179 -238 -144 -266 -178 b -280 -182 -271 -181 -275 -182 b -293 -178 -284 -182 -289 -181 b -456 -18 -294 -177 -398 -76 l -475 1 l -507 -38 b -554 -83 -543 -82 -543 -83 l -554 -83 b -576 -68 -562 -83 -568 -79 b -632 115 -613 -19 -632 46 b -593 292 -632 173 -619 233 b -564 338 -579 323 -571 335 z"
    },
    ornamentPrecompDoubleCadenceUpperPrefixTurn: {
      x_min: -439,
      x_max: 439,
      y_min: -215,
      y_max: 236,
      ha: 451,
      o: "m -564 338 b -555 340 -561 339 -558 340 b -534 318 -544 340 -534 331 b -534 317 -534 318 -534 317 b -541 296 -534 311 -534 311 b -588 116 -572 236 -588 175 b -583 62 -588 98 -586 80 b -554 -21 -578 34 -566 -2 l -552 -24 l -511 26 b -430 126 -488 54 -452 99 b -386 177 -407 153 -388 176 b -372 182 -382 181 -377 182 b -360 179 -368 182 -364 181 b -268 89 -359 178 -318 137 b -178 0 -219 40 -179 0 b -105 88 -178 0 -145 40 b -30 179 -60 144 -32 178 b -18 182 -27 181 -22 182 b -5 179 -13 182 -9 181 b 158 18 -4 177 89 86 l 177 0 l 179 2 l 181 5 l 181 137 b 183 272 181 267 181 268 b 203 285 186 280 195 285 b 218 279 209 285 214 283 b 225 164 225 273 225 284 l 225 59 l 274 118 b 324 179 304 155 323 178 b 337 182 328 181 333 182 b 349 179 341 182 346 181 b 513 18 351 177 438 92 l 532 -1 l 562 36 b 610 81 599 81 599 81 l 610 81 b 632 59 623 81 632 71 b 630 50 632 56 631 53 b 442 -179 627 44 447 -176 b 430 -182 438 -181 434 -182 b 417 -178 425 -182 421 -181 b 325 -89 416 -178 375 -137 b 235 0 276 -40 236 0 b 235 0 235 0 235 0 b 230 -6 235 0 232 -3 l 225 -12 l 225 -152 b 225 -218 225 -179 225 -200 b 219 -303 225 -308 224 -298 b 203 -310 214 -308 209 -310 b 183 -297 195 -310 187 -305 b 181 -180 182 -294 182 -294 l 181 -66 l 136 -121 b 88 -178 107 -156 89 -177 b 75 -182 84 -181 79 -182 b 62 -178 70 -182 66 -181 b -29 -89 61 -178 20 -137 b -119 0 -79 -40 -119 0 b -192 -88 -120 0 -153 -40 b -267 -179 -238 -144 -266 -178 b -280 -182 -271 -181 -275 -182 b -293 -178 -284 -182 -289 -181 b -456 -18 -294 -177 -398 -76 l -475 1 l -507 -38 b -554 -83 -543 -82 -543 -83 l -554 -83 b -576 -68 -562 -83 -568 -79 b -632 115 -613 -19 -632 46 b -593 292 -632 173 -619 233 b -564 338 -579 323 -571 335 z"
    },
    ornamentPrecompTrillLowerSuffix: {
      x_min: -439,
      x_max: 439,
      y_min: -236,
      y_max: 127,
      ha: 362,
      o: "m -437 181 b -430 182 -435 182 -433 182 b -417 179 -426 182 -420 181 b -325 89 -416 178 -375 137 b -235 0 -276 40 -235 0 l -235 0 b -162 88 -235 0 -202 40 b -87 179 -117 144 -89 178 b -75 182 -84 181 -79 182 b -62 179 -70 182 -66 181 b 29 89 -61 178 -20 137 b 119 0 79 40 119 0 b 192 88 120 0 153 40 b 267 179 238 144 266 178 b 280 182 271 181 276 182 b 292 179 284 182 289 181 b 456 18 294 177 396 77 l 475 -1 l 507 38 b 554 83 543 82 543 83 l 554 83 b 576 68 563 83 568 79 b 632 -116 613 19 632 -46 b 607 -257 632 -162 624 -210 b 571 -334 596 -287 578 -327 b 556 -340 567 -338 561 -340 b 535 -326 547 -340 538 -335 b 533 -319 534 -323 533 -321 b 541 -296 533 -314 536 -308 b 588 -117 572 -236 588 -175 b 579 -40 588 -91 585 -65 b 554 21 573 -19 563 7 l 552 24 l 511 -26 b 430 -126 488 -54 452 -99 b 386 -177 407 -153 388 -176 b 373 -182 382 -181 377 -182 b 360 -178 368 -182 364 -181 b 268 -89 359 -178 318 -137 b 178 0 219 -40 179 0 l 178 0 b 105 -88 178 0 145 -40 b 30 -179 60 -144 32 -178 b 18 -182 27 -181 22 -182 b 5 -178 13 -182 9 -181 b -86 -89 4 -178 -37 -137 b -176 0 -136 -40 -176 0 l -176 0 b -249 -88 -177 0 -210 -40 b -324 -179 -295 -144 -323 -178 b -337 -182 -328 -181 -332 -182 b -349 -178 -341 -182 -346 -181 b -513 -18 -351 -177 -439 -91 l -532 1 l -562 -36 b -610 -81 -599 -81 -599 -81 l -610 -81 b -632 -59 -623 -81 -632 -71 b -630 -50 -632 -56 -631 -53 b -442 179 -627 -44 -447 176 b -437 181 -441 179 -438 181 z"
    },
    stringsDownBow: {
      x_min: -168,
      x_max: 168,
      y_min: 0,
      y_max: 353,
      ha: 353,
      o: "m -228 506 b 3 508 -225 507 -111 508 b 228 506 114 508 225 507 b 240 494 233 504 238 499 b 242 254 241 491 242 373 b 240 14 242 135 241 16 b 220 0 237 5 228 0 b 204 6 214 0 208 2 b 198 89 198 12 198 3 b 198 145 198 104 198 123 l 198 273 l 0 273 l -198 273 l -198 145 b -198 89 -198 123 -198 104 b -204 6 -198 3 -198 12 b -220 0 -208 2 -214 0 b -240 14 -228 0 -237 5 b -242 254 -241 16 -242 135 b -240 494 -242 373 -241 491 b -228 506 -238 499 -233 504 z"
    },
    stringsUpBow: {
      x_min: -110,
      x_max: 110,
      y_min: 0,
      y_max: 277,
      ha: 277,
      o: "m -144 397 b -137 398 -142 398 -140 398 b -117 387 -129 398 -120 394 b -58 234 -116 385 -90 317 b 0 84 -26 152 0 84 b 58 234 0 84 26 152 b 117 387 90 317 116 385 b 136 398 121 395 128 398 b 158 376 147 398 158 390 l 158 370 l 89 191 b 20 11 51 93 20 12 b 0 0 16 4 8 0 b -19 11 -8 0 -16 4 b -158 375 -25 21 -158 370 b -158 376 -158 375 -158 376 b -144 397 -158 386 -153 394 z"
    },
    stringsHarmonic: {
      x_min: -82,
      x_max: 82,
      y_min: -82,
      y_max: 82,
      ha: 163,
      o: "m -19 116 b 1 118 -12 117 -6 118 b 118 0 65 118 118 63 b 114 -30 118 -10 116 -20 b -1 -118 100 -85 50 -118 b -83 -83 -30 -118 -60 -107 b -118 -1 -107 -60 -118 -30 b -19 116 -118 53 -81 105 z m 14 99 b 0 100 9 100 4 100 b -101 0 -57 100 -101 53 b -90 -45 -101 -15 -97 -30 b 0 -100 -71 -82 -36 -100 b 90 -45 36 -100 71 -82 b 101 -1 97 -30 101 -15 b 14 99 101 47 65 92 z"
    },
    pluckedSnapPizzicatoAbove: {
      x_min: -110,
      x_max: 110,
      y_min: -110,
      y_max: 205,
      ha: 315,
      o: "m -9 293 b 0 295 -6 294 -3 295 b 20 281 9 295 17 290 b 22 217 22 278 22 276 l 22 157 l 25 157 b 153 40 85 148 138 100 b 158 0 157 26 158 13 b 40 -153 158 -71 111 -135 b 0 -158 26 -157 13 -158 b -154 -40 -71 -158 -136 -111 b -158 -1 -157 -27 -158 -14 b -25 157 -158 76 -102 146 l -22 157 l -22 217 b -21 281 -22 276 -22 278 b -9 293 -19 286 -13 291 z m -22 54 b -23 112 -22 108 -22 112 b -23 112 -23 112 -23 112 b -81 80 -37 111 -65 96 b -114 1 -104 57 -114 29 b 0 -114 -114 -58 -69 -114 b 114 1 68 -114 114 -58 b 80 80 114 29 104 57 b 22 112 65 96 35 112 b 22 54 22 112 22 92 b 20 -8 22 -3 22 -5 b 0 -22 17 -17 9 -22 b -16 -16 -6 -22 -11 -20 b -22 34 -22 -10 -22 -12 b -22 54 -22 40 -22 46 z"
    },
    pluckedSnapPizzicatoBelow: {
      x_min: -110,
      x_max: 110,
      y_min: -205,
      y_max: 110,
      ha: 315,
      o: "m 9 -293 b 0 -295 6 -294 3 -295 b -20 -281 -9 -295 -17 -290 b -22 -217 -22 -278 -22 -276 l -22 -157 l -25 -157 b -153 -40 -85 -148 -138 -100 b -158 0 -157 -26 -158 -13 b -40 153 -158 71 -111 135 b 0 158 -26 157 -13 158 b 154 40 71 158 136 111 b 158 1 157 27 158 14 b 25 -157 158 -76 102 -146 l 22 -157 l 22 -217 b 21 -281 22 -276 22 -278 b 9 -293 19 -286 13 -291 z m 22 -54 b 23 -112 22 -108 22 -112 b 23 -112 23 -112 23 -112 b 81 -80 37 -111 65 -96 b 114 -1 104 -57 114 -29 b 0 114 114 58 69 114 b -114 -1 -68 114 -114 58 b -80 -80 -114 -29 -104 -57 b -22 -112 -65 -96 -35 -112 b -22 -54 -22 -112 -22 -92 b -20 8 -22 3 -22 5 b 0 22 -17 17 -9 22 b 16 16 6 22 11 20 b 22 -34 22 10 22 12 b 22 -54 22 -40 22 -46 z"
    },
    pluckedLeftHandPizzicato: {
      x_min: -155,
      x_max: 155,
      y_min: -157,
      y_max: 157,
      ha: 315,
      o: "m -9 225 b 0 227 -6 226 -3 227 b 20 213 9 227 17 221 b 22 116 22 209 22 208 l 22 22 l 114 22 b 152 22 129 22 141 22 b 218 16 218 22 212 21 b 224 0 222 11 224 6 b 210 -20 224 -9 219 -17 b 114 -22 207 -22 205 -22 l 22 -22 l 22 -116 b 22 -154 22 -131 22 -143 b 16 -220 22 -221 21 -214 b 0 -227 11 -225 6 -227 b -20 -213 -9 -227 -17 -222 b -22 -116 -22 -209 -22 -208 l -22 -22 l -114 -22 b -210 -20 -205 -22 -207 -22 b -224 0 -219 -17 -224 -9 b -218 16 -224 6 -222 11 b -152 22 -212 21 -218 22 b -114 22 -141 22 -129 22 l -22 22 l -22 116 b -20 213 -22 208 -22 209 b -9 225 -19 218 -13 223 z"
    },
    keyboardPedalPed: {
      x_min: 0,
      x_max: 782,
      y_min: -1,
      y_max: 500,
      ha: 501,
      o: "m 309 719 b 335 720 318 720 327 720 b 521 650 409 720 473 696 b 582 517 561 610 582 560 b 528 423 582 476 564 441 b 483 411 513 415 498 411 b 392 480 443 411 406 437 b 384 516 386 496 384 508 b 400 535 384 529 389 535 b 417 520 409 535 414 530 b 458 494 421 503 438 494 b 498 507 472 494 486 498 b 520 552 513 517 520 533 b 469 645 520 582 502 619 b 349 687 437 670 389 687 l 344 687 l 335 671 b 286 544 299 609 286 577 b 286 543 286 544 286 543 b 341 449 286 511 298 491 b 371 411 359 430 364 424 b 385 358 380 394 385 377 b 378 317 385 345 383 331 b 302 165 365 271 336 212 b 298 159 300 162 298 159 b 298 159 298 159 298 159 b 305 160 299 159 302 159 b 336 162 315 161 326 162 b 486 106 392 162 445 143 l 492 101 l 512 117 b 533 134 523 126 532 133 b 534 136 534 135 534 135 b 533 144 534 138 534 140 b 530 188 531 159 530 174 b 571 320 530 238 544 283 b 657 390 587 342 634 380 b 686 397 666 395 676 397 b 763 335 721 397 755 372 b 766 315 765 328 766 321 b 740 251 766 291 756 267 b 699 219 736 247 702 221 b 636 172 697 218 662 192 b 614 153 618 158 614 154 b 614 153 614 153 614 153 b 645 91 621 129 636 100 b 694 73 657 78 675 73 b 797 123 728 73 769 91 l 800 127 l 799 134 b 795 176 796 148 795 162 b 947 403 795 266 851 351 b 950 405 949 404 950 405 b 944 414 950 407 948 409 b 659 583 875 496 774 556 b 636 603 641 587 636 591 b 654 620 636 614 642 620 b 666 619 658 620 662 620 b 1113 282 884 577 1062 442 b 1126 198 1122 253 1126 225 b 954 -1 1126 87 1054 -1 b 930 1 946 -1 938 0 b 817 83 883 7 841 37 b 815 87 816 85 815 87 b 808 79 814 87 812 84 b 664 0 772 29 717 0 b 620 7 649 0 634 2 b 546 92 584 19 565 40 l 544 99 l 540 97 b 480 49 539 95 512 74 b 414 1 419 0 420 1 l 414 1 b 396 17 404 1 399 5 b 284 110 381 72 333 110 b 266 108 278 110 272 110 l 258 107 l 247 94 b 164 2 213 53 169 4 b 156 0 161 0 159 0 b 139 17 147 0 139 8 b 140 23 139 19 140 21 b 144 34 141 24 142 29 b 234 137 158 79 189 114 b 260 164 244 143 244 142 b 319 290 300 217 319 259 b 281 349 319 312 313 322 b 223 453 250 376 229 414 b 222 472 223 459 222 466 b 296 673 222 522 246 587 l 303 685 l 300 685 b 290 684 299 685 294 684 b 60 496 171 668 77 591 b 59 477 59 490 59 483 b 76 426 59 453 66 431 b 100 420 84 422 92 420 b 162 487 131 420 160 448 b 179 507 163 502 168 507 b 196 479 192 507 196 501 b 196 478 196 478 196 478 b 88 335 195 397 151 338 b 83 335 86 335 84 335 b 0 443 31 335 0 375 l 0 443 b 309 719 0 583 138 706 z m 981 361 b 976 368 978 366 977 368 b 968 362 974 368 972 366 b 872 175 908 318 872 247 b 877 131 872 160 874 145 b 943 34 887 82 914 43 b 949 34 945 34 947 34 b 1018 127 973 34 1004 75 b 1027 198 1024 151 1027 174 b 981 361 1027 253 1011 309 z m 665 338 b 657 339 662 339 660 339 b 641 336 652 339 647 338 b 614 293 635 333 622 312 b 602 221 607 274 602 246 b 604 198 602 213 603 205 b 606 191 605 193 605 191 b 608 193 606 191 607 192 b 666 238 613 197 642 219 b 695 264 690 256 691 257 b 702 290 700 272 702 281 b 665 338 702 312 688 334 z"
    },
    keyboardPedalUp: {
      x_min: 0,
      x_max: 435,
      y_min: 65,
      y_max: 500,
      ha: 435,
      o: "m 300 719 b 311 720 303 720 307 720 b 332 718 319 720 327 719 b 379 654 361 709 379 685 b 354 601 379 632 374 620 b 331 558 338 585 331 572 b 336 536 331 551 333 544 b 374 512 344 521 358 512 b 389 514 379 512 384 513 b 422 575 414 523 422 538 b 474 646 422 614 441 639 b 489 648 479 647 484 648 b 555 581 527 648 555 615 b 535 535 555 565 549 549 b 479 515 520 520 508 516 b 450 512 462 515 458 514 b 418 468 429 505 418 487 b 438 433 418 455 425 441 b 464 424 447 427 455 424 b 509 449 477 424 491 432 b 557 473 526 466 538 472 b 561 473 558 473 560 473 b 627 407 599 473 627 442 b 620 378 627 397 625 387 b 561 341 609 354 588 341 l 560 341 b 508 365 538 341 527 346 b 465 390 491 383 478 390 b 457 389 462 390 460 390 b 418 347 433 384 418 367 b 424 325 418 340 420 332 b 479 299 433 306 446 300 b 535 279 509 298 520 294 b 555 233 549 266 555 249 b 489 166 555 199 527 166 b 474 167 484 166 480 166 b 422 239 441 175 422 200 b 393 298 422 273 414 289 b 374 302 386 301 380 302 b 332 266 354 302 337 288 b 331 255 331 262 331 258 b 355 213 331 242 338 230 b 379 160 374 193 379 182 l 379 160 b 313 93 379 120 348 93 b 272 108 299 93 285 98 b 247 160 256 121 247 140 b 259 198 247 173 251 187 b 272 213 260 200 266 206 b 296 255 289 230 296 242 b 295 266 296 258 296 262 b 253 302 290 288 273 302 b 234 298 247 302 241 301 b 205 239 213 289 205 273 b 153 167 205 200 186 175 b 138 166 148 166 143 166 b 73 232 101 166 73 197 b 82 267 73 244 76 256 b 148 299 95 289 113 298 b 182 304 168 299 171 300 b 197 315 189 307 192 309 b 209 346 205 325 209 336 b 179 386 209 364 198 379 b 162 390 173 389 167 390 b 119 365 148 390 136 382 b 104 352 113 360 107 354 b 67 341 92 344 79 341 b 2 390 38 341 10 359 b 0 407 1 396 0 401 b 66 473 0 443 30 473 b 83 471 72 473 77 473 b 118 449 96 468 104 463 b 161 424 136 432 149 424 b 163 424 161 424 162 424 b 209 467 191 427 209 445 b 203 489 209 474 207 482 b 148 515 193 509 180 515 b 92 535 119 516 107 520 b 72 581 78 549 72 565 b 138 648 72 615 100 648 b 153 646 143 648 148 647 b 205 575 186 639 205 614 b 238 514 205 538 213 523 b 253 512 243 513 248 512 b 291 536 269 512 283 521 b 296 558 294 544 296 551 b 273 601 296 572 289 584 b 254 624 261 612 258 616 b 247 654 249 634 247 644 b 300 719 247 684 268 712 z m 327 475 b 313 476 322 476 318 476 b 244 407 274 476 244 443 b 252 376 244 396 247 386 b 313 338 265 350 289 338 b 375 376 338 338 362 350 b 383 407 380 386 383 396 b 327 475 383 438 361 468 z"
    },
    pictChokeCymbal: {
      x_min: 0,
      x_max: 168,
      y_min: -155,
      y_max: 155,
      ha: 311,
      o: "m 96 223 b 107 224 100 224 103 224 b 236 104 164 224 218 174 b 242 55 240 88 242 71 b 66 -209 242 -42 175 -144 b 33 -224 48 -219 39 -224 b 25 -219 30 -224 28 -222 b 23 -213 24 -216 23 -215 b 36 -199 23 -208 28 -204 b 130 -56 96 -166 130 -110 b 111 8 130 -34 124 -12 l 110 10 l 100 11 b 6 82 58 12 19 42 b 0 117 2 94 0 105 b 96 223 0 170 40 217 z"
    },
    wiggleArpeggiatoUp: {
      x_min: -8,
      x_max: 269,
      y_min: 0,
      y_max: 126,
      ha: 126,
      o: "m 103 180 b 118 181 108 181 113 181 b 223 126 151 181 184 164 b 299 69 250 100 280 78 b 311 67 303 68 307 67 b 359 90 325 67 342 75 b 376 102 372 101 372 102 l 376 102 b 388 91 383 102 388 96 b 385 84 388 88 387 86 b 322 25 379 76 342 42 b 258 0 301 8 280 0 b 153 56 226 0 192 18 b 78 112 127 81 97 103 b 65 114 74 114 70 114 b 17 91 51 114 35 106 b 1 80 5 80 5 80 l 0 80 b -11 91 -7 80 -11 85 b -9 97 -11 93 -10 95 b 55 156 -3 105 34 140 b 103 180 71 170 88 178 z"
    },
    arrowheadBlackUp: {
      x_min: 11,
      x_max: 239,
      y_min: -6,
      y_max: 269,
      ha: 275,
      o: "m 171 386 b 179 387 174 387 176 387 b 201 378 187 387 196 384 b 212 345 206 372 206 372 b 333 45 237 235 282 123 b 344 19 343 29 344 27 b 317 -8 344 2 332 -8 b 299 -3 312 -8 305 -7 b 180 30 262 19 221 30 b 74 4 144 30 108 21 b 61 -3 70 2 64 -1 b 43 -8 55 -7 48 -8 b 16 19 28 -8 16 2 b 27 45 16 27 17 29 b 148 344 78 123 122 233 b 159 378 155 373 154 372 b 171 386 161 381 167 385 z"
    },
    arrowheadBlackDown: {
      x_min: 11,
      x_max: 239,
      y_min: 6,
      y_max: 281,
      ha: 275,
      o: "m 35 403 b 43 405 37 404 40 405 b 62 398 49 405 55 403 b 79 390 65 396 73 392 b 180 367 111 374 145 367 b 298 398 221 367 262 377 b 318 404 305 402 312 404 b 344 377 332 404 344 394 b 333 351 344 369 343 367 b 212 51 282 273 237 161 b 204 23 207 28 206 26 b 180 8 199 13 189 8 b 156 23 171 8 162 13 b 150 44 154 25 153 28 b 27 351 125 158 80 271 b 16 377 17 367 16 369 b 35 403 16 389 24 400 z"
    }
  },
  fontFamily: "GonvilleSmufl",
  resolution: 1e3,
  generatedOn: "2023-04-20T22:11:26.009Z"
};

// node_modules/vexflow/build/esm/src/fonts/load_gonville.js
function loadGonville() {
  Font.load("Gonville", GonvilleSmuflFont, CommonMetrics);
}

// node_modules/vexflow/build/esm/src/fonts/leland_glyphs.js
var LelandFont = {
  glyphs: {
    bracketTop: {
      x_min: 0,
      x_max: 491,
      y_min: 0,
      y_max: 279,
      ha: 279,
      o: "m 697 399 b 687 402 694 400 690 402 b 671 395 681 402 674 400 b 249 168 668 390 524 168 l 20 168 b 0 150 9 168 0 161 l 0 20 l 0 0 l 176 0 b 706 374 619 0 704 370 b 707 382 706 376 707 379 b 697 399 707 389 703 395 z"
    },
    bracketBottom: {
      x_min: 0,
      x_max: 491,
      y_min: -279,
      y_max: 0,
      ha: 279,
      o: "m 697 -399 b 707 -382 703 -395 707 -389 b 706 -374 707 -379 706 -376 b 176 0 704 -370 619 0 l 0 0 l 0 -20 l 0 -150 b 20 -168 0 -161 9 -168 l 249 -168 b 671 -395 524 -168 668 -390 b 687 -402 674 -400 681 -402 b 697 -399 690 -402 694 -400 z"
    },
    segno: {
      x_min: 0,
      x_max: 654,
      y_min: 0,
      y_max: 869,
      ha: 869,
      o: "m 546 690 l 838 1207 b 841 1215 840 1210 841 1212 b 832 1233 841 1221 837 1230 l 809 1248 b 798 1251 806 1250 801 1251 b 780 1241 792 1251 783 1247 l 487 721 l 217 860 b 99 995 147 897 99 924 b 236 1165 99 1120 179 1165 b 343 1073 288 1165 325 1130 b 454 988 357 1022 405 988 b 477 991 461 988 469 989 b 541 1076 526 1002 541 1045 b 540 1089 541 1080 541 1084 b 294 1225 534 1116 514 1225 b 0 939 72 1225 0 1053 b 125 706 0 825 42 753 l 397 563 l 104 45 b 102 35 102 42 102 37 b 111 19 102 29 107 22 l 132 3 b 144 0 135 1 141 0 b 148 0 145 0 147 0 b 161 10 153 1 158 6 l 456 531 l 704 403 b 842 256 780 361 842 318 b 706 86 842 131 763 86 b 599 177 654 86 616 120 b 488 262 585 228 537 262 b 465 259 481 262 472 261 b 402 177 418 248 402 206 b 403 163 402 171 402 167 b 649 26 409 135 429 26 b 942 312 871 26 942 199 b 821 549 942 426 901 507 z m 52 444 b 118 416 69 426 95 416 b 183 444 141 416 166 426 b 210 508 200 461 210 485 b 183 573 210 531 200 556 b 118 600 166 590 141 600 b 52 573 95 600 69 590 b 24 508 35 556 24 531 b 52 444 24 485 35 461 z m 760 730 b 825 703 778 713 802 703 b 890 730 848 703 873 713 b 917 795 907 747 917 772 b 890 861 917 818 907 844 b 825 888 873 878 848 888 b 760 861 802 888 778 878 b 733 795 743 844 733 818 b 760 730 733 772 743 747 z"
    },
    coda: {
      x_min: 0,
      x_max: 745,
      y_min: -113,
      y_max: 735,
      ha: 848,
      o: "m 924 467 b 560 896 916 697 757 881 l 560 1038 b 540 1058 560 1050 552 1058 l 524 1058 b 505 1038 513 1058 505 1050 l 505 896 b 150 467 311 877 158 693 l 20 467 b 0 446 9 467 0 458 l 0 432 b 20 412 0 420 9 412 l 150 412 b 505 0 166 193 317 17 l 505 -143 b 524 -163 505 -154 513 -163 l 540 -163 b 560 -143 552 -163 560 -154 l 560 0 b 923 412 753 13 907 190 l 1054 412 b 1073 432 1066 412 1073 420 l 1073 446 b 1054 467 1073 458 1066 467 z m 560 467 l 560 852 b 773 467 716 837 773 671 z m 505 467 l 301 467 b 505 851 301 668 357 831 z m 505 412 l 505 45 b 301 412 366 65 301 219 z m 560 412 l 772 412 b 560 45 772 215 706 60 z"
    },
    gClef: {
      x_min: 0,
      x_max: 640,
      y_min: -666,
      y_max: 1112,
      ha: 1778,
      o: "m 809 -30 b 665 -279 809 -132 768 -238 b 586 186 635 -107 596 122 b 809 -30 716 186 809 98 z m 605 -297 b 521 -305 576 -302 549 -305 b 140 56 315 -305 140 -161 b 390 498 140 232 264 389 b 459 562 415 520 438 540 b 492 357 472 484 482 416 b 272 45 361 318 272 180 b 467 -194 272 -56 351 -194 b 491 -176 478 -194 491 -189 b 459 -144 491 -163 477 -156 b 372 -1 403 -109 372 -72 b 521 177 372 86 436 157 z m 478 1184 b 632 1392 491 1241 557 1392 b 688 1223 654 1392 688 1322 b 478 863 688 1073 577 960 b 462 1037 469 920 462 976 b 478 1184 462 1090 467 1139 z m 176 -739 b 444 -959 176 -834 249 -959 b 622 -910 511 -959 570 -942 b 720 -670 700 -855 720 -760 b 697 -467 720 -613 711 -549 b 675 -338 693 -438 684 -395 b 922 3 816 -292 922 -145 b 557 367 922 220 768 367 b 516 619 543 454 528 539 b 773 1188 668 779 773 959 b 710 1477 773 1319 733 1426 b 608 1601 675 1551 634 1601 b 505 1528 598 1601 553 1584 b 387 1113 413 1418 387 1234 b 419 804 387 1035 395 965 b 312 701 418 802 343 726 b 0 117 181 579 0 405 b 503 -364 0 -153 235 -364 b 616 -354 544 -364 583 -360 b 660 -670 644 -492 660 -593 b 438 -899 660 -819 583 -899 b 370 -891 403 -899 373 -891 b 366 -887 369 -890 366 -888 b 373 -881 366 -884 369 -883 b 508 -721 441 -871 508 -814 b 341 -562 508 -644 449 -562 b 176 -739 240 -562 176 -644 z"
    },
    cClef: {
      x_min: 0,
      x_max: 627,
      y_min: -480,
      y_max: 482,
      ha: 962,
      o: "m 19 675 b 0 657 9 675 0 667 l 0 -654 b 19 -672 0 -664 9 -672 l 122 -672 b 141 -654 132 -672 141 -664 l 141 657 b 122 675 141 667 132 675 z m 903 -376 b 619 -58 903 -197 808 -58 b 505 -95 586 -58 562 -60 b 426 1 503 -89 474 -32 b 505 98 474 35 503 92 b 641 60 560 65 579 60 b 903 379 816 60 903 223 b 580 694 903 580 755 694 b 318 517 472 694 318 649 b 438 400 318 446 367 400 b 546 510 501 400 546 446 b 425 615 546 589 494 615 b 547 651 458 638 503 651 b 723 400 698 651 723 530 b 593 128 723 289 720 128 b 438 279 467 128 441 265 b 418 300 438 281 438 300 b 396 279 397 300 396 281 b 264 29 383 200 344 62 l 264 657 b 246 675 264 667 256 675 b 228 657 236 675 228 667 l 228 -654 b 246 -672 228 -664 236 -672 b 264 -654 256 -672 264 -664 l 264 -26 b 396 -278 348 -60 380 -197 b 418 -297 396 -279 397 -297 b 438 -278 438 -297 438 -279 b 593 -125 441 -262 467 -125 b 723 -397 720 -125 723 -287 b 547 -648 723 -527 698 -648 b 425 -612 503 -648 458 -635 b 441 -613 426 -612 432 -613 b 546 -507 504 -613 546 -569 b 438 -397 546 -444 501 -397 b 318 -514 367 -397 318 -444 b 580 -691 318 -647 472 -691 b 903 -376 755 -691 903 -577 z"
    },
    fClef: {
      x_min: 0,
      x_max: 664,
      y_min: -617,
      y_max: 251,
      ha: 868,
      o: "m 366 361 b 167 298 256 361 168 298 b 37 112 84 236 50 163 b 27 36 30 86 27 60 b 46 -58 27 1 33 -30 b 140 -138 63 -96 96 -124 b 194 -147 157 -144 176 -147 b 287 -122 226 -147 259 -138 b 359 10 331 -98 359 -46 b 289 134 359 60 333 107 b 206 160 259 154 230 160 b 160 153 189 160 173 157 b 109 122 145 147 121 132 b 147 215 114 150 131 192 b 219 279 163 238 194 266 b 351 308 255 300 301 308 b 570 -52 498 308 570 190 b 477 -399 570 -186 520 -314 b 310 -635 429 -494 366 -585 b 17 -837 160 -772 19 -837 b 0 -864 17 -837 0 -847 b 1 -871 0 -867 1 -868 b 27 -888 6 -886 19 -888 b 35 -887 29 -888 33 -887 b 331 -717 36 -887 200 -819 b 528 -544 405 -664 471 -606 b 661 -367 580 -488 625 -428 b 760 -50 724 -259 760 -147 b 670 239 760 69 729 168 b 366 361 602 320 500 361 z m 818 179 b 887 107 818 138 850 107 b 956 179 924 107 956 138 b 887 252 956 219 924 252 b 818 179 850 252 818 219 z m 818 -177 b 887 -251 818 -217 850 -251 b 956 -177 924 -251 956 -217 b 887 -104 956 -137 924 -104 b 818 -177 850 -104 818 -137 z"
    },
    unpitchedPercussionClef1: {
      x_min: 0,
      x_max: 352,
      y_min: -252,
      y_max: 252,
      ha: 504,
      o: "m 19 363 b 0 344 9 363 0 354 l 0 -344 b 19 -363 0 -354 9 -363 l 177 -363 b 196 -344 187 -363 196 -354 l 196 344 b 177 363 196 354 187 363 z m 330 363 b 311 344 320 363 311 354 l 311 -344 b 330 -363 311 -354 320 -363 l 488 -363 b 507 -344 498 -363 507 -354 l 507 344 b 488 363 507 354 498 363 z"
    },
    "6stringTabClef": {
      x_min: 0,
      x_max: 439,
      y_min: -743,
      y_max: 746,
      ha: 1489,
      o: "m 52 1074 l 52 958 l 249 958 l 249 419 l 387 419 l 387 958 l 583 958 l 583 1074 z m 0 -333 l 145 -333 l 192 -196 l 436 -196 l 481 -333 l 632 -333 l 396 334 l 238 334 z m 315 181 l 400 -81 l 229 -81 z m 566 -474 b 393 -402 531 -428 475 -403 l 71 -402 l 71 -1070 l 372 -1070 b 374 -1070 373 -1070 373 -1070 b 465 -1061 405 -1070 435 -1067 b 541 -1027 494 -1056 520 -1043 b 588 -975 560 -1012 575 -995 b 618 -868 608 -943 618 -907 b 592 -770 618 -829 609 -798 b 514 -711 575 -743 549 -724 b 566 -674 537 -700 554 -688 b 596 -576 586 -649 596 -616 b 566 -474 596 -536 586 -503 z m 348 -518 b 428 -528 380 -518 408 -521 b 464 -590 452 -539 464 -559 b 436 -649 464 -619 455 -638 b 366 -665 418 -661 395 -665 l 203 -665 l 203 -518 z m 367 -776 b 435 -788 396 -776 419 -780 b 477 -858 464 -801 477 -824 b 433 -942 477 -900 462 -927 b 366 -953 418 -949 395 -953 l 203 -953 l 203 -776 z"
    },
    timeSig0: {
      x_min: 15,
      x_max: 389,
      y_min: -254,
      y_max: 255,
      ha: 509,
      o: "m 291 367 b 22 0 138 367 22 209 b 291 -366 22 -209 138 -366 b 560 0 444 -366 560 -209 b 291 367 560 209 444 367 z m 376 -200 b 291 -308 376 -252 353 -308 b 206 -200 229 -308 206 -252 l 206 200 b 291 308 206 252 229 308 b 376 200 353 308 376 252 z"
    },
    timeSig1: {
      x_min: 15,
      x_max: 336,
      y_min: -243,
      y_max: 245,
      ha: 488,
      o: "m 359 -284 l 359 336 b 341 353 359 346 351 353 l 199 353 b 190 350 196 353 193 351 b 184 344 189 348 186 346 l 23 65 b 22 56 22 62 22 59 b 30 42 22 50 26 45 l 58 26 b 66 23 60 24 63 23 b 81 32 72 23 78 27 l 183 207 l 183 -284 l 73 -284 b 56 -301 63 -284 56 -291 l 56 -333 b 73 -350 56 -343 63 -350 l 468 -350 b 484 -333 478 -350 484 -343 l 484 -301 b 468 -284 484 -291 478 -284 z"
    },
    timeSig2: {
      x_min: 15,
      x_max: 377,
      y_min: -243,
      y_max: 245,
      ha: 488,
      o: "m 492 -56 b 382 -192 481 -88 452 -192 b 190 -134 288 -192 268 -134 b 153 -138 179 -134 167 -135 b 341 -36 153 -138 189 -84 b 533 173 494 12 533 86 b 288 353 533 233 505 353 b 30 156 71 353 30 222 b 138 49 30 96 79 49 b 245 156 197 49 245 96 b 179 255 245 196 216 240 b 168 271 174 256 168 264 b 202 297 168 279 176 289 b 251 304 209 300 229 304 b 311 288 271 304 294 300 b 348 180 338 271 348 245 b 65 -150 348 12 148 -24 b 22 -278 65 -150 22 -210 b 73 -350 22 -346 56 -350 b 121 -305 96 -350 121 -331 b 117 -287 121 -300 120 -294 b 105 -239 108 -266 105 -251 b 107 -226 105 -235 105 -230 b 154 -203 108 -217 120 -203 b 238 -289 196 -203 212 -252 b 350 -350 264 -327 304 -350 b 484 -264 396 -350 458 -317 b 543 -63 510 -210 543 -102 b 518 -36 543 -45 531 -36 b 492 -56 508 -36 498 -42 z"
    },
    timeSig3: {
      x_min: 15,
      x_max: 364,
      y_min: -244,
      y_max: 244,
      ha: 488,
      o: "m 392 23 b 514 168 507 68 514 143 b 514 176 514 171 514 174 b 262 351 514 189 510 351 b 22 176 14 351 22 176 l 23 176 l 22 173 b 115 81 22 121 63 81 b 207 173 167 81 207 121 b 135 264 207 215 176 255 b 140 268 137 265 138 266 b 215 289 160 282 187 289 b 340 176 275 289 340 253 b 255 69 340 85 272 72 b 140 60 238 66 157 60 b 121 40 122 60 121 40 l 121 12 b 140 -6 121 12 124 -4 b 243 -14 164 -7 197 -7 b 340 -167 307 -23 340 -66 b 215 -289 340 -264 275 -289 b 121 -266 174 -289 137 -278 b 207 -174 168 -264 207 -222 b 115 -81 207 -122 167 -81 b 22 -174 63 -81 22 -122 b 22 -180 22 -174 22 -177 b 78 -298 22 -199 26 -251 b 236 -351 134 -350 204 -351 b 524 -147 374 -351 524 -304 b 389 23 524 -42 452 3 z"
    },
    timeSig4: {
      x_min: 14,
      x_max: 442,
      y_min: -248,
      y_max: 249,
      ha: 497,
      o: "m 300 -183 l 300 -289 l 180 -289 b 160 -310 170 -289 160 -298 l 160 -337 b 180 -357 160 -348 170 -357 l 616 -357 b 636 -337 628 -357 636 -348 l 636 -310 b 616 -289 636 -298 628 -289 l 487 -289 l 487 -183 l 616 -183 b 636 -161 628 -183 636 -173 l 636 -134 b 616 -114 636 -124 628 -114 l 487 -114 l 487 115 b 477 134 487 124 482 131 l 459 143 b 452 144 456 144 455 144 b 449 144 451 144 451 144 b 436 140 445 144 439 143 l 305 20 b 300 4 301 16 300 10 l 300 -114 l 132 -114 b 464 287 132 -114 294 59 b 471 307 469 294 471 301 b 467 321 471 314 468 320 l 435 353 b 420 359 431 356 426 359 b 206 359 412 359 217 359 b 187 341 196 359 189 350 b 143 118 187 341 180 235 b 24 -124 105 1 62 -71 b 20 -140 24 -124 20 -131 b 22 -148 20 -143 20 -145 b 36 -174 26 -158 36 -174 b 52 -183 36 -174 39 -183 z"
    },
    timeSig5: {
      x_min: 15,
      x_max: 362,
      y_min: -244,
      y_max: 246,
      ha: 490,
      o: "m 39 314 b 46 170 39 314 46 245 b 46 151 46 164 46 157 b 39 -24 45 71 39 -24 b 39 -29 39 -24 39 -26 b 49 -48 39 -35 40 -46 b 99 -59 62 -50 92 -58 b 107 -59 102 -59 104 -59 b 121 -49 112 -59 118 -58 b 235 45 128 -30 144 45 b 356 -112 337 45 356 -43 b 238 -292 356 -184 333 -288 b 226 -292 233 -292 230 -292 b 166 -282 193 -292 174 -288 b 158 -274 161 -281 158 -276 b 164 -264 158 -269 160 -266 b 222 -168 177 -255 222 -239 b 117 -71 222 -98 173 -71 b 22 -171 60 -71 22 -122 b 111 -318 22 -220 36 -275 b 252 -351 147 -338 199 -351 b 456 -275 325 -351 405 -328 b 521 -109 503 -228 521 -167 b 433 79 521 -32 487 43 b 271 124 397 104 336 124 b 131 84 223 124 173 112 b 125 82 130 82 127 82 b 115 92 120 82 115 86 l 115 183 b 131 199 115 192 122 199 l 132 199 b 252 192 154 197 202 192 b 372 209 295 192 340 196 b 474 320 439 236 462 289 b 477 334 475 324 477 330 b 451 354 477 346 469 354 b 431 351 445 354 439 353 b 252 328 360 334 305 328 b 88 343 200 328 150 334 b 71 344 88 343 81 344 b 39 320 56 344 39 340 b 39 314 39 317 39 315 z"
    },
    timeSig6: {
      x_min: 15,
      x_max: 387,
      y_min: -244,
      y_max: 245,
      ha: 489,
      o: "m 356 69 b 216 22 268 69 236 43 b 209 98 212 52 209 75 b 216 167 209 121 212 141 b 338 287 225 220 261 287 b 410 259 374 287 396 275 b 356 174 380 246 356 207 b 448 82 356 122 396 82 b 541 174 500 82 541 122 l 541 177 b 541 179 541 177 541 177 b 533 225 541 192 539 213 b 310 353 514 276 454 353 b 58 163 180 353 86 229 b 22 -23 43 128 22 58 b 131 -285 22 -111 46 -210 b 318 -351 215 -348 268 -351 b 557 -125 369 -351 557 -292 b 356 69 557 16 446 69 z m 302 -291 b 216 -145 255 -291 216 -226 b 302 1 216 -65 255 1 b 390 -145 350 1 390 -65 b 302 -291 390 -226 350 -291 z"
    },
    timeSig7: {
      x_min: 15,
      x_max: 366,
      y_min: -250,
      y_max: 251,
      ha: 501,
      o: "m 233 -177 b 160 -336 202 -225 160 -282 b 180 -360 160 -351 164 -360 b 264 -351 203 -360 217 -354 b 278 -350 268 -351 274 -350 b 369 -360 320 -350 359 -360 b 405 -331 382 -360 406 -344 b 405 -327 405 -330 405 -328 b 396 -226 405 -324 396 -279 b 408 -130 396 -196 399 -161 b 503 151 425 -62 471 60 b 527 308 518 196 527 275 b 526 341 527 321 527 327 b 510 361 524 356 518 361 b 484 361 503 361 491 361 b 467 341 477 361 467 356 b 406 228 467 327 464 228 b 235 351 346 228 328 351 b 86 252 145 351 91 261 l 86 321 b 71 337 86 330 79 337 l 37 337 b 22 321 29 337 22 330 l 22 55 b 37 39 22 46 29 39 l 71 39 b 86 55 79 39 86 46 l 86 101 b 158 179 86 134 108 179 b 328 124 209 179 213 124 b 425 143 357 124 410 128 b 233 -177 413 120 266 -130 z"
    },
    timeSig8: {
      x_min: 15,
      x_max: 393,
      y_min: -248,
      y_max: 246,
      ha: 494,
      o: "m 467 26 b 547 166 514 62 547 108 b 294 354 547 269 433 354 b 40 166 154 354 40 269 b 122 13 40 108 55 56 b 22 -147 58 -24 22 -78 b 294 -357 22 -264 144 -357 b 566 -147 444 -357 566 -264 b 467 26 566 -78 541 -13 z m 294 -276 b 122 -145 202 -276 122 -226 b 197 -26 122 -49 197 -26 b 435 -187 295 -59 435 -108 b 294 -276 435 -226 384 -276 z m 386 65 b 180 209 288 96 180 144 b 294 288 180 265 232 288 b 444 180 383 288 444 246 b 386 65 444 111 412 78 z"
    },
    timeSig9: {
      x_min: 15,
      x_max: 387,
      y_min: -244,
      y_max: 245,
      ha: 489,
      o: "m 223 -68 b 363 -20 311 -68 343 -42 b 370 -96 367 -50 370 -73 b 363 -166 370 -120 367 -140 b 240 -285 354 -219 318 -285 b 168 -258 204 -285 183 -274 b 223 -173 199 -245 223 -206 b 131 -81 223 -121 183 -81 b 37 -173 79 -81 37 -121 l 37 -176 b 37 -177 37 -176 37 -176 b 46 -223 37 -190 40 -212 b 269 -351 65 -275 125 -351 b 521 -161 399 -351 492 -228 b 557 24 536 -127 557 -56 b 448 287 557 112 533 212 b 261 353 364 350 311 353 b 22 127 210 353 22 294 b 223 -68 22 -14 132 -68 z m 276 294 b 363 147 324 294 363 228 b 276 1 363 66 324 1 b 189 147 229 1 189 66 b 276 294 189 228 229 294 z"
    },
    timeSigCommon: {
      x_min: 0,
      x_max: 463,
      y_min: -256,
      y_max: 258,
      ha: 514,
      o: "m 468 258 b 406 147 432 235 406 193 b 408 130 406 141 406 135 b 521 17 415 71 462 24 b 537 17 526 17 533 17 b 667 147 609 17 667 75 b 667 156 667 147 667 151 b 664 177 667 161 665 171 b 350 372 651 239 595 372 b 0 17 36 372 0 111 b 382 -369 0 -154 22 -369 b 641 -131 524 -369 635 -285 b 629 -120 641 -124 636 -120 l 611 -120 b 599 -131 605 -120 599 -125 b 382 -323 593 -251 508 -323 b 196 -128 256 -323 196 -255 l 196 147 b 356 320 196 228 228 320 b 469 271 423 320 454 295 b 471 264 471 268 471 266 b 468 258 471 262 471 259 z"
    },
    timeSigCutCommon: {
      x_min: 0,
      x_max: 463,
      y_min: -376,
      y_max: 388,
      ha: 764,
      o: "m 611 -120 b 599 -131 605 -120 599 -125 b 382 -323 593 -251 508 -323 b 369 -323 377 -323 373 -323 l 369 320 b 469 269 428 317 455 292 b 471 264 471 266 471 265 b 468 258 471 261 471 259 b 406 147 432 235 406 193 b 408 130 406 141 406 135 b 523 17 415 71 464 24 b 537 17 527 17 533 17 b 667 147 609 17 667 75 b 667 156 667 147 667 151 b 664 177 667 161 665 171 b 369 370 651 236 598 364 l 369 543 b 353 559 369 552 361 559 l 314 559 b 298 543 305 559 298 552 l 298 369 b 0 17 32 341 0 105 b 298 -364 0 -140 17 -334 l 298 -526 b 314 -541 298 -534 305 -541 l 353 -541 b 369 -526 361 -541 369 -534 l 369 -369 b 382 -369 373 -369 377 -369 b 641 -131 524 -369 635 -285 b 629 -120 641 -124 636 -120 z m 196 147 b 298 312 196 215 216 289 l 298 -310 b 196 -128 229 -285 196 -223 z"
    },
    timeSigPlus: {
      x_min: 0,
      x_max: 408,
      y_min: -204,
      y_max: 204,
      ha: 408,
      o: "m 327 33 l 327 275 b 308 294 327 285 318 294 l 279 294 b 261 275 269 294 261 285 l 261 33 l 19 33 b 0 14 9 33 0 24 l 0 -13 b 19 -33 0 -23 9 -33 l 261 -33 l 261 -274 b 279 -294 261 -284 269 -294 l 308 -294 b 327 -274 318 -294 327 -284 l 327 -33 l 567 -33 b 588 -13 577 -33 588 -23 l 588 14 b 567 33 588 24 577 33 z"
    },
    noteheadDoubleWhole: {
      x_min: 0,
      x_max: 538,
      y_min: -178,
      y_max: 179,
      ha: 357,
      o: "m 33 258 b 20 258 27 258 26 258 b 0 238 9 258 0 249 b 0 -236 0 226 0 -226 b 20 -256 0 -246 9 -256 b 33 -256 26 -256 27 -256 b 53 -236 43 -256 53 -245 b 53 238 53 -228 53 226 b 33 258 53 249 45 258 z m 649 258 b 636 258 644 258 642 258 b 616 238 625 258 616 249 b 616 125 616 235 616 187 b 389 196 573 167 500 196 b 160 125 276 196 203 167 b 160 238 160 187 160 235 b 140 258 160 249 151 258 b 127 258 134 258 132 258 b 107 238 115 258 107 249 b 107 -236 107 226 107 -226 b 127 -256 107 -246 115 -256 b 140 -256 132 -256 134 -256 b 160 -236 150 -256 160 -245 b 160 -122 160 -233 160 -186 b 389 -194 203 -166 276 -194 b 616 -122 500 -194 573 -166 b 616 -236 616 -186 616 -233 b 636 -256 616 -246 625 -256 b 649 -256 642 -256 644 -256 b 670 -236 660 -256 670 -245 b 670 238 670 -228 670 226 b 649 258 670 249 661 258 z m 462 -140 b 400 -148 445 -144 422 -148 b 314 -101 360 -148 333 -135 b 268 68 295 -65 269 29 b 268 76 268 71 268 73 b 314 141 268 109 282 130 b 377 150 331 145 354 150 b 462 102 416 150 442 140 b 510 -66 482 63 510 -29 b 462 -140 510 -104 497 -128 z m 755 258 b 742 258 749 258 747 258 b 721 238 730 258 721 249 b 721 -236 721 226 721 -226 b 742 -256 721 -246 730 -256 b 755 -256 747 -256 749 -256 b 775 -236 765 -256 775 -245 b 775 238 775 -228 775 226 b 755 258 775 249 766 258 z"
    },
    noteheadWhole: {
      x_min: 0,
      x_max: 373,
      y_min: -134,
      y_max: 136,
      ha: 270,
      o: "m 269 196 b 0 1 71 196 0 95 b 269 -193 0 -92 71 -193 b 537 1 468 -193 537 -92 b 269 196 537 95 468 196 z m 343 -138 b 281 -147 325 -144 302 -147 b 194 -99 240 -147 213 -135 b 148 68 176 -63 150 29 b 194 141 145 107 160 130 b 256 150 212 147 235 150 b 343 102 297 150 323 141 b 389 -65 363 63 389 -29 b 343 -138 389 -102 377 -128 z"
    },
    noteheadHalf: {
      x_min: 0,
      x_max: 325,
      y_min: -133,
      y_max: 132,
      ha: 265,
      o: "m 307 190 b 0 -60 167 190 0 73 b 161 -192 0 -122 45 -192 b 468 58 311 -192 468 -69 b 307 190 468 143 396 190 z m 268 -63 b 108 -124 264 -66 158 -124 b 50 -72 60 -124 50 -85 b 200 62 50 -12 194 59 b 360 122 206 65 308 122 b 418 71 395 122 418 102 b 268 -63 418 9 272 -60 z"
    },
    noteheadBlack: {
      x_min: 0,
      x_max: 325,
      y_min: -133,
      y_max: 132,
      ha: 265,
      o: "m 0 -60 b 161 -192 0 -122 45 -192 b 468 58 311 -192 468 -69 b 307 190 468 143 396 190 b 0 -60 167 190 0 72 z"
    },
    noteheadXBlack: {
      x_min: 0,
      x_max: 325,
      y_min: -132,
      y_max: 132,
      ha: 264,
      o: "m 461 138 b 468 153 465 141 468 147 l 468 154 b 462 167 468 160 465 164 l 445 184 b 431 190 441 187 436 190 b 418 186 426 190 420 189 l 235 40 l 50 186 b 37 190 48 189 42 190 b 24 184 32 190 29 187 l 6 167 b 0 153 3 164 0 158 b 7 138 0 147 3 141 l 183 0 l 7 -138 b 0 -153 3 -141 0 -147 b 6 -166 0 -157 3 -163 l 23 -184 b 37 -190 26 -189 32 -190 b 50 -186 42 -190 48 -189 l 235 -40 l 418 -186 b 431 -190 420 -189 426 -190 b 445 -184 436 -190 442 -189 l 462 -166 b 468 -153 465 -163 468 -157 b 461 -138 468 -147 465 -141 l 285 0 z"
    },
    noteheadCircleX: {
      x_min: 0,
      x_max: 325,
      y_min: -162,
      y_max: 163,
      ha: 325,
      o: "m 265 0 l 395 105 b 426 0 415 75 426 39 b 387 -115 426 -43 412 -84 z m 233 -27 l 360 -145 b 235 -192 327 -174 282 -192 b 99 -137 183 -192 134 -171 z m 202 1 l 73 -105 b 42 0 53 -75 42 -39 b 81 115 42 43 56 84 z m 235 29 l 108 145 b 233 193 141 174 186 193 b 369 138 285 193 334 173 z m 233 235 b 0 0 104 235 0 130 b 233 -233 0 -130 104 -233 b 468 0 363 -233 468 -130 b 233 235 468 130 363 235 z"
    },
    noteheadDoubleWholeSquare: {
      x_min: 0,
      x_max: 432,
      y_min: -179,
      y_max: 177,
      ha: 356,
      o: "m 590 255 b 570 235 579 255 570 246 l 570 203 l 53 203 l 53 235 b 33 255 53 246 45 255 l 20 255 b 0 235 9 255 0 246 l 0 -230 b 20 -251 0 -242 9 -251 l 33 -251 b 53 -230 45 -251 53 -242 l 53 -200 l 570 -200 l 570 -238 b 590 -258 570 -249 579 -258 l 603 -258 b 622 -238 615 -258 622 -249 l 622 235 b 603 255 622 246 615 255 z m 570 -101 l 53 -101 l 53 105 l 570 105 z"
    },
    noteheadSquareWhite: {
      x_min: 0,
      x_max: 310,
      y_min: -125,
      y_max: 125,
      ha: 250,
      o: "m 395 128 l 395 -128 l 52 -128 l 52 128 z m 446 180 l 0 180 l 0 -180 l 446 -180 z"
    },
    noteheadSquareBlack: {
      x_min: 0,
      x_max: 310,
      y_min: -125,
      y_max: 125,
      ha: 250,
      o: "m 446 180 l 0 180 l 0 -180 l 446 -180 z"
    },
    noteheadTriangleUpBlack: {
      x_min: 0,
      x_max: 310,
      y_min: -136,
      y_max: 122,
      ha: 258,
      o: "m 223 176 l 0 -196 l 446 -196 z"
    },
    noteheadSlashedDoubleWhole1: {
      x_min: -66,
      x_max: 456,
      y_min: -213,
      y_max: 212,
      ha: 425,
      o: "m 652 298 b 638 305 649 304 644 305 b 626 301 634 305 629 304 l 560 248 b 543 256 557 253 550 256 b 530 256 537 256 536 256 b 510 236 518 256 510 248 b 510 204 510 235 510 223 l 455 161 b 281 194 413 181 356 194 b 53 124 168 194 96 166 b 53 236 53 186 53 233 b 29 256 53 253 42 256 b 20 256 26 256 23 256 b 0 236 9 256 0 248 b 0 -204 0 228 0 -98 l -88 -272 b -95 -288 -92 -276 -95 -282 b -91 -300 -95 -291 -94 -295 b -76 -307 -86 -304 -82 -307 b -65 -302 -72 -307 -68 -305 l 3 -248 b 20 -258 6 -253 12 -258 b 53 -238 33 -258 52 -255 b 53 -206 53 -236 53 -225 l 107 -161 b 281 -196 148 -183 206 -196 b 510 -124 393 -196 465 -166 b 510 -238 510 -187 510 -235 b 530 -258 510 -248 518 -258 b 563 -238 543 -258 563 -255 b 563 204 563 -229 563 98 l 649 272 b 657 288 655 276 657 282 b 652 298 657 291 655 295 z m 160 75 b 269 148 160 138 219 148 b 356 101 310 148 334 140 b 363 85 357 96 360 91 l 189 -56 b 160 66 174 -14 161 40 b 160 75 160 69 160 72 z m 53 -163 b 53 -124 53 -151 53 -138 b 76 -144 60 -131 68 -138 z m 402 -68 b 292 -148 402 -138 351 -148 b 207 -101 252 -150 226 -137 b 199 -84 204 -96 202 -91 l 373 56 b 402 -68 389 13 402 -40 z m 510 124 b 485 144 503 131 494 137 l 510 163 b 510 124 510 151 510 137 z"
    },
    noteheadSlashedWhole1: {
      x_min: -75,
      x_max: 448,
      y_min: -211,
      y_max: 214,
      ha: 425,
      o: "m 641 301 b 625 308 636 305 631 308 b 613 304 621 307 618 307 l 439 160 b 269 196 399 181 343 196 b 0 1 71 196 0 95 b 69 -138 0 -49 20 -101 l -101 -271 b -108 -287 -105 -275 -108 -281 b -104 -298 -107 -291 -107 -294 b -88 -304 -99 -302 -94 -304 b -76 -301 -85 -304 -81 -304 l 98 -157 b 269 -193 138 -179 194 -193 b 537 1 468 -193 537 -92 b 468 141 537 52 517 104 l 638 274 b 645 289 642 278 645 284 b 641 301 644 292 644 297 z m 148 68 b 148 78 148 72 148 75 b 194 141 148 111 163 131 b 256 150 212 147 235 150 b 343 102 297 150 323 141 b 350 86 346 98 348 92 l 177 -55 b 148 68 163 -12 150 42 z m 389 -65 b 343 -138 389 -102 377 -128 b 281 -147 325 -144 302 -147 b 194 -99 240 -147 213 -135 b 187 -82 192 -95 190 -89 l 279 -6 l 361 58 b 389 -65 376 16 389 -39 z"
    },
    noteheadSlashedHalf1: {
      x_min: -98,
      x_max: 424,
      y_min: -213,
      y_max: 212,
      ha: 425,
      o: "m 606 298 b 592 305 602 302 598 305 b 580 301 588 305 583 304 l 412 163 b 307 190 383 180 347 190 b 153 148 258 190 204 176 b 0 -60 58 98 0 13 b 14 -120 0 -81 4 -101 b 32 -143 20 -128 26 -135 l -134 -274 b -141 -288 -138 -276 -141 -282 b -137 -300 -141 -292 -140 -297 b -122 -307 -134 -304 -128 -307 b -111 -302 -118 -307 -114 -305 l 56 -164 b 161 -192 85 -181 121 -192 b 315 -151 210 -192 264 -179 b 468 58 410 -101 468 -16 b 454 117 468 78 464 98 b 436 141 449 125 444 134 l 603 272 b 611 287 608 275 611 281 b 606 298 611 291 609 295 z m 56 -98 b 49 -73 52 -91 49 -82 b 75 -23 49 -58 59 -39 b 199 60 99 1 147 32 b 337 118 251 89 302 111 b 359 121 344 120 351 121 b 361 121 360 121 360 121 l 225 9 l 69 -114 b 56 -98 65 -109 60 -104 z m 410 94 b 416 69 415 86 416 78 b 392 19 416 53 408 36 b 266 -65 367 -6 318 -36 b 128 -122 215 -94 163 -115 b 107 -125 121 -124 114 -125 b 104 -125 107 -125 105 -125 l 245 -9 l 396 111 b 410 94 402 107 408 101 z"
    },
    noteheadSlashedBlack1: {
      x_min: -98,
      x_max: 424,
      y_min: -213,
      y_max: 212,
      ha: 425,
      o: "m 606 298 b 592 305 602 302 598 305 b 580 301 588 305 583 304 l 412 161 b 307 190 383 180 347 190 b 0 -60 167 190 0 72 b 32 -144 0 -89 10 -120 l -134 -274 b -141 -288 -138 -278 -141 -284 b -137 -301 -141 -292 -140 -297 b -122 -307 -134 -305 -128 -307 b -111 -304 -118 -307 -114 -307 l 56 -164 b 161 -192 82 -181 117 -192 b 468 58 311 -192 468 -71 b 436 141 468 91 456 120 l 603 271 b 611 285 608 275 611 281 b 606 298 611 289 609 294 z"
    },
    noteheadSlashedDoubleWhole2: {
      x_min: -66,
      x_max: 456,
      y_min: -213,
      y_max: 212,
      ha: 425,
      o: "m 563 -204 b 563 236 563 -98 563 228 b 543 256 563 249 554 256 b 530 256 537 256 536 256 b 510 236 518 256 510 248 b 510 124 510 233 510 187 b 281 194 467 166 393 194 b 107 161 207 194 150 181 l 53 204 b 53 236 53 223 53 235 b 33 256 53 249 45 256 b 20 256 27 256 26 256 b 3 246 12 256 6 253 l -63 301 b -76 305 -68 304 -72 305 b -91 298 -81 305 -86 304 b -95 287 -94 295 -95 291 b -88 272 -95 281 -92 276 l 0 204 b 0 -238 0 98 0 -229 b 20 -258 0 -248 9 -258 b 33 -258 26 -258 27 -258 b 53 -238 43 -258 53 -246 b 53 -124 53 -235 53 -187 b 281 -196 96 -166 170 -196 b 456 -161 356 -196 413 -183 l 510 -206 b 510 -238 510 -225 510 -236 b 530 -258 510 -248 518 -258 b 543 -258 536 -258 537 -258 b 560 -246 549 -258 556 -252 l 626 -302 b 638 -307 631 -305 634 -307 b 654 -300 645 -307 649 -304 b 657 -288 655 -295 657 -292 b 651 -272 657 -282 655 -276 z m 207 140 b 269 148 225 144 248 148 b 356 101 310 148 336 140 b 402 -68 376 62 402 -30 b 402 -78 402 -71 402 -75 l 292 9 l 168 109 b 207 140 176 124 189 134 z m 78 144 b 53 124 69 137 60 131 b 53 163 53 137 53 150 z m 356 -141 b 294 -148 338 -145 315 -148 b 207 -101 253 -148 226 -137 b 161 66 189 -66 163 27 b 160 72 161 69 160 71 b 161 78 160 75 160 76 l 271 -9 l 395 -109 b 356 -141 387 -124 374 -134 z m 485 -144 b 510 -124 494 -138 503 -131 b 510 -163 510 -138 510 -151 z"
    },
    noteheadSlashedWhole2: {
      x_min: -75,
      x_max: 448,
      y_min: -212,
      y_max: 214,
      ha: 426,
      o: "m 468 -138 b 537 1 517 -101 537 -49 b 269 196 537 95 468 196 b 98 160 196 196 140 181 l -76 304 b -88 308 -81 307 -84 307 b -104 301 -94 308 -99 305 b -108 289 -107 297 -107 292 b -101 274 -108 284 -105 278 l 69 141 b 0 1 20 104 0 52 b 269 -193 0 -92 71 -193 b 441 -157 343 -193 399 -179 l 613 -301 b 625 -305 618 -304 622 -305 b 641 -298 631 -305 636 -302 b 645 -287 644 -294 644 -291 b 638 -271 645 -281 642 -275 z m 194 141 b 256 150 212 147 235 150 b 343 102 297 150 323 141 b 389 -65 363 63 389 -29 b 389 -76 389 -69 389 -73 l 279 10 l 156 112 b 194 141 163 125 176 135 z m 343 -138 b 281 -147 325 -144 302 -147 b 194 -99 240 -147 213 -135 b 148 68 176 -63 150 29 b 148 76 148 71 148 73 b 148 81 148 78 148 79 l 258 -6 l 382 -108 b 343 -138 374 -122 361 -132 z"
    },
    noteheadSlashedHalf2: {
      x_min: -98,
      x_max: 424,
      y_min: -213,
      y_max: 212,
      ha: 425,
      o: "m 386 -102 b 468 58 438 -55 468 4 b 454 117 468 78 464 98 b 307 190 428 164 373 190 b 153 148 258 190 204 176 b 108 120 137 140 122 130 l -111 301 b -122 305 -114 304 -118 305 b -137 298 -128 305 -134 302 b -141 287 -140 295 -141 291 b -134 272 -141 281 -138 275 l 85 101 b 0 -60 32 53 0 -7 b 14 -120 0 -81 4 -101 b 161 -192 40 -167 95 -192 b 315 -151 210 -192 264 -179 b 361 -122 333 -143 347 -132 l 580 -302 b 592 -307 583 -305 588 -307 b 606 -300 598 -307 602 -304 b 611 -288 609 -297 611 -292 b 603 -274 611 -282 608 -276 z m 199 60 b 337 118 251 89 302 111 b 359 121 344 120 351 121 b 410 94 382 121 400 112 b 416 69 415 86 416 78 b 392 19 416 53 408 36 b 308 -42 374 0 343 -20 l 245 7 l 189 55 b 199 60 192 56 196 58 z m 266 -65 b 128 -122 215 -94 163 -115 b 107 -125 121 -124 114 -125 b 56 -98 84 -125 66 -117 b 49 -73 52 -91 49 -82 b 75 -23 49 -58 59 -39 b 163 39 94 -4 125 17 l 225 -9 l 282 -56 b 266 -65 276 -59 272 -62 z"
    },
    noteheadSlashedBlack2: {
      x_min: -98,
      x_max: 424,
      y_min: -213,
      y_max: 212,
      ha: 425,
      o: "m 384 -102 b 468 58 435 -58 468 0 b 307 190 468 143 396 190 b 108 121 239 190 167 163 l -111 301 b -124 305 -115 304 -120 305 b -138 298 -128 305 -134 302 b -141 289 -140 295 -141 292 b -141 287 -141 288 -143 288 b -135 272 -141 281 -140 275 l 84 101 b 0 -60 35 56 0 0 b 161 -192 0 -122 45 -192 b 361 -122 232 -192 304 -164 l 579 -302 b 590 -307 583 -305 588 -307 b 606 -300 596 -307 602 -304 b 611 -288 609 -297 611 -292 b 603 -274 609 -282 608 -276 z"
    },
    noteheadDiamondDoubleWhole: {
      x_min: 0,
      x_max: 373,
      y_min: -178,
      y_max: 179,
      ha: 357,
      o: "m 504 258 b 484 238 494 258 484 248 l 484 46 b 282 187 415 95 285 186 b 268 192 279 190 275 192 b 255 187 262 192 258 190 l 52 45 l 52 238 b 33 258 52 248 43 258 l 20 258 b 0 238 9 258 0 248 l 0 -236 b 20 -256 0 -248 9 -256 l 33 -256 b 52 -236 43 -256 52 -248 l 52 -45 l 249 -181 b 268 -190 258 -189 264 -190 b 282 -186 274 -190 279 -189 b 484 -43 285 -184 413 -94 l 484 -236 b 504 -256 484 -248 494 -256 l 517 -256 b 537 -236 528 -256 537 -248 l 537 238 b 517 258 537 248 528 258 z m 220 -115 l 102 -33 l 317 117 l 435 35 z"
    },
    noteheadDiamondWhole: {
      x_min: 0,
      x_max: 373,
      y_min: -133,
      y_max: 132,
      ha: 265,
      o: "m 282 -187 b 530 -13 285 -186 530 -13 b 537 0 534 -10 537 -6 b 530 13 537 4 534 10 b 282 186 530 13 287 183 b 268 190 279 189 275 190 b 255 186 262 190 258 189 l 7 12 b 0 -1 3 9 0 4 b 4 -13 0 -6 1 -10 l 249 -183 b 268 -192 258 -190 264 -192 b 282 -187 274 -192 279 -190 z m 220 -117 l 102 -35 l 317 115 l 435 33 z"
    },
    noteheadDiamondHalf: {
      x_min: 0,
      x_max: 335,
      y_min: -132,
      y_max: 133,
      ha: 265,
      o: "m 475 -13 b 482 0 480 -10 482 -6 b 475 13 482 4 480 10 l 253 187 b 240 192 251 190 246 192 b 229 187 236 192 232 190 l 7 13 b 0 0 3 10 0 6 b 7 -13 0 -4 3 -10 l 229 -186 b 240 -190 232 -189 236 -190 b 253 -186 246 -190 251 -189 z m 284 -115 l 92 33 l 199 117 l 390 -33 z"
    },
    noteheadDiamondBlack: {
      x_min: 0,
      x_max: 335,
      y_min: -132,
      y_max: 133,
      ha: 265,
      o: "m 475 -14 b 482 -1 480 -10 482 -6 b 475 13 482 4 480 10 l 253 187 b 240 192 251 190 246 192 b 229 187 236 192 232 190 l 7 13 b 0 0 3 10 0 4 b 7 -14 0 -6 3 -10 l 229 -186 b 240 -190 232 -189 236 -190 b 253 -186 246 -190 251 -189 z"
    },
    noteheadParenthesisRight: {
      x_min: 0,
      x_max: 75,
      y_min: -209,
      y_max: 212,
      ha: 421,
      o: "m 10 305 b 4 302 7 304 6 304 b 0 295 1 301 0 298 b 1 289 0 294 0 292 b 68 -10 1 288 68 160 b 1 -288 68 -95 50 -192 b 0 -292 0 -289 0 -291 b 4 -300 0 -295 1 -298 b 12 -301 7 -301 9 -302 b 17 -298 14 -301 16 -300 b 108 0 22 -292 108 -174 b 17 301 108 174 22 295 b 10 305 16 304 13 305 z"
    },
    noteheadParenthesisLeft: {
      x_min: 0,
      x_max: 75,
      y_min: -212,
      y_max: 209,
      ha: 421,
      o: "m 98 -305 b 104 -302 101 -304 102 -304 b 108 -295 107 -301 108 -298 b 107 -289 108 -294 108 -292 b 40 10 107 -288 40 -160 b 107 288 40 95 58 192 b 108 292 108 289 108 291 b 104 300 108 295 107 298 b 96 301 101 301 99 302 b 91 298 94 301 92 300 b 0 0 86 292 0 174 b 91 -301 0 -174 86 -295 b 98 -305 92 -304 95 -305 z"
    },
    noteheadMoonBlack: {
      x_min: 0,
      x_max: 310,
      y_min: -125,
      y_max: 125,
      ha: 250,
      o: "m 0 180 l 0 0 b 223 -180 0 -99 99 -180 b 446 0 347 -180 446 -99 l 446 180 z"
    },
    noteheadTriangleLeftBlack: {
      x_min: 0,
      x_max: 339,
      y_min: -136,
      y_max: 122,
      ha: 258,
      o: "m 0 176 l 0 -196 l 488 -196 z"
    },
    noteheadTriangleRightBlack: {
      x_min: 0,
      x_max: 339,
      y_min: -136,
      y_max: 122,
      ha: 258,
      o: "m 488 176 l 0 -196 l 488 -196 z"
    },
    noteheadTriangleRoundDownBlack: {
      x_min: 0,
      x_max: 310,
      y_min: -136,
      y_max: 122,
      ha: 258,
      o: "m 226 -196 l 446 63 b 226 176 446 63 384 176 b 0 63 68 176 0 63 z"
    },
    augmentationDot: {
      x_min: 0,
      x_max: 100,
      y_min: -50,
      y_max: 50,
      ha: 100,
      o: "m 0 0 b 72 -72 0 -40 32 -72 b 144 0 112 -72 144 -40 b 72 72 144 40 112 72 b 0 0 32 72 0 40 z"
    },
    tremolo1: {
      x_min: 0,
      x_max: 290,
      y_min: -93,
      y_max: 96,
      ha: 189,
      o: "m 0 48 l 0 -134 l 418 -43 l 418 138 z"
    },
    flag8thUp: {
      x_min: 0,
      x_max: 289,
      y_min: -817,
      y_max: 12,
      ha: 829,
      o: "m 0 -327 b 12 -343 0 -331 1 -338 b 291 -600 73 -363 197 -441 b 359 -827 317 -645 359 -707 b 294 -1140 359 -930 331 -1037 b 289 -1162 291 -1149 288 -1156 b 297 -1175 289 -1168 291 -1172 b 304 -1176 300 -1176 302 -1176 b 327 -1161 314 -1176 321 -1171 b 416 -798 395 -1041 418 -888 b 416 -780 416 -791 416 -786 b 302 -458 409 -595 302 -458 b 131 -220 307 -458 170 -281 b 50 -50 78 -138 53 -56 b 36 6 49 -46 36 6 b 19 17 35 12 27 17 b 0 -1 9 17 0 9 z"
    },
    flag8thDown: {
      x_min: 0,
      x_max: 309,
      y_min: -12,
      y_max: 817,
      ha: 829,
      o: "m 0 1 b 19 -17 0 -9 9 -17 b 36 -6 26 -17 35 -12 b 50 50 36 -4 49 46 b 117 196 52 56 65 111 b 331 458 173 289 259 357 b 445 780 402 559 445 654 b 338 1161 445 912 415 1021 b 317 1176 334 1171 325 1176 b 310 1175 314 1176 311 1176 b 300 1158 302 1172 300 1166 b 304 1140 300 1153 301 1146 b 384 827 361 1007 384 930 b 317 600 384 707 343 645 b 12 343 223 441 72 363 b 0 327 1 338 0 331 z"
    },
    flag16thUp: {
      x_min: 0,
      x_max: 279,
      y_min: -820,
      y_max: 12,
      ha: 832,
      o: "m 301 -681 b 148 -514 262 -631 219 -585 b 56 -372 92 -458 66 -409 b 52 -343 55 -364 53 -354 b 271 -510 125 -343 219 -442 b 340 -696 327 -583 340 -641 b 337 -739 340 -710 338 -724 b 301 -681 325 -716 312 -697 z m 0 -549 b 22 -563 0 -553 12 -559 b 258 -776 59 -576 171 -648 b 318 -950 307 -850 318 -901 b 317 -975 318 -959 318 -966 b 285 -1140 317 -1009 307 -1083 b 279 -1164 284 -1148 279 -1156 b 289 -1179 279 -1169 282 -1175 b 297 -1181 292 -1181 294 -1181 b 318 -1161 307 -1181 312 -1169 b 382 -962 344 -1120 382 -1043 b 374 -855 382 -920 379 -886 b 402 -678 389 -802 402 -749 b 333 -471 402 -603 382 -536 b 137 -228 265 -382 192 -307 b 42 0 82 -148 42 0 b 22 17 39 10 37 17 b 0 0 4 17 0 10 z"
    },
    flag16thDown: {
      x_min: 0,
      x_max: 309,
      y_min: -26,
      y_max: 803,
      ha: 829,
      o: "m 53 346 b 56 363 55 353 56 359 b 163 517 66 399 78 452 b 384 732 246 582 346 662 b 317 503 382 621 354 552 b 53 346 229 395 122 364 z m 0 -14 b 22 -37 0 -26 10 -37 b 43 -14 33 -37 40 -26 b 167 232 65 134 109 177 b 445 683 243 305 445 416 b 432 837 445 730 441 783 b 441 919 438 855 441 881 b 327 1149 441 1032 374 1112 b 304 1156 321 1153 312 1156 b 287 1152 298 1156 292 1155 b 279 1145 281 1149 279 1148 b 294 1129 279 1140 288 1135 b 382 930 344 1076 382 1027 b 374 876 382 912 380 893 l 373 871 b 373 871 373 871 373 871 b 327 789 366 842 350 815 b 22 598 226 672 86 612 b 0 559 12 593 0 562 z"
    },
    flag32ndUp: {
      x_min: 0,
      x_max: 279,
      y_min: -821,
      y_max: 186,
      ha: 1007,
      o: "m 301 -683 b 148 -516 262 -632 219 -588 b 56 -373 92 -459 66 -410 b 50 -343 55 -366 53 -354 b 271 -500 125 -343 219 -432 b 340 -687 327 -575 340 -632 b 337 -739 340 -704 338 -721 b 301 -683 325 -716 312 -698 z m 271 -259 b 340 -446 327 -333 340 -392 b 338 -469 340 -455 338 -462 b 333 -461 337 -467 334 -464 b 91 -192 265 -372 145 -271 b 50 -92 69 -160 58 -124 b 271 -259 124 -92 219 -192 z m 0 -550 b 22 -564 0 -554 12 -560 b 258 -778 59 -577 171 -649 b 318 -952 307 -851 318 -903 b 317 -976 318 -960 318 -968 b 285 -1142 317 -1011 307 -1084 b 279 -1165 284 -1149 279 -1158 b 289 -1181 279 -1171 282 -1176 b 297 -1182 292 -1182 294 -1182 b 318 -1162 307 -1182 312 -1171 b 382 -963 344 -1122 382 -1044 b 374 -857 382 -922 379 -887 b 402 -668 389 -802 402 -740 b 386 -563 402 -632 396 -596 b 402 -441 395 -526 402 -487 b 402 -428 402 -436 402 -432 b 333 -220 402 -353 382 -285 b 137 23 265 -131 192 -56 b 42 251 82 102 42 251 b 22 268 39 261 37 268 b 0 251 4 268 0 261 z"
    },
    flag32ndDown: {
      x_min: 0,
      x_max: 309,
      y_min: -216,
      y_max: 803,
      ha: 1019,
      o: "m 50 73 b 91 171 58 105 71 141 b 347 402 145 251 272 317 b 384 454 361 418 374 435 b 324 239 384 347 361 287 b 50 73 235 130 122 94 z m 163 517 b 366 693 248 589 327 642 b 382 716 372 700 377 708 b 383 693 383 708 383 700 b 314 505 383 621 359 562 b 53 343 258 436 179 390 b 56 363 55 351 56 359 b 163 517 66 400 81 449 z m 0 -288 b 22 -311 0 -298 10 -311 b 43 -288 33 -311 40 -300 b 167 -40 65 -138 109 -95 b 445 409 243 32 445 143 b 431 577 445 462 439 520 b 441 651 435 602 439 626 b 441 675 441 658 441 667 b 441 687 441 680 441 684 b 425 808 441 730 433 772 b 441 919 435 840 441 876 b 327 1149 441 1032 374 1112 b 305 1156 321 1153 314 1156 b 287 1152 300 1156 292 1155 b 279 1145 281 1149 279 1148 b 294 1129 279 1140 288 1136 b 382 930 344 1076 382 1027 b 327 789 382 877 364 832 b 22 598 226 672 86 612 b 0 559 12 593 0 562 z"
    },
    flag64thUp: {
      x_min: 0,
      x_max: 279,
      y_min: -822,
      y_max: 373,
      ha: 1195,
      o: "m 333 -461 b 91 -192 265 -372 145 -271 b 50 -92 69 -161 58 -125 b 271 -251 125 -92 219 -183 b 340 -438 327 -324 340 -383 b 338 -469 340 -448 338 -459 b 333 -461 337 -467 334 -464 z m 301 -683 b 148 -517 262 -632 219 -588 b 56 -374 92 -461 66 -410 b 50 -343 55 -366 53 -356 b 271 -501 125 -343 219 -433 b 340 -688 327 -575 340 -634 b 337 -739 340 -706 338 -721 b 301 -683 325 -717 312 -698 z m 271 10 b 340 -176 327 -63 340 -121 b 337 -217 340 -190 338 -204 b 333 -212 336 -216 334 -213 b 91 65 265 -122 145 -16 b 48 177 66 101 53 143 l 50 177 b 271 10 124 177 217 78 z m 0 -552 b 22 -564 0 -554 12 -562 b 258 -778 59 -579 171 -649 b 318 -952 307 -851 317 -903 b 317 -976 318 -960 318 -968 b 285 -1142 317 -1012 307 -1084 b 279 -1165 284 -1149 279 -1158 b 289 -1181 279 -1172 282 -1178 b 297 -1184 292 -1182 295 -1184 b 318 -1164 307 -1182 312 -1172 b 382 -963 344 -1122 382 -1044 b 374 -857 382 -923 379 -887 b 402 -668 389 -804 402 -740 b 386 -563 402 -632 396 -596 b 402 -432 395 -523 402 -480 b 402 -418 402 -428 402 -423 b 383 -304 402 -379 396 -341 b 402 -170 393 -264 402 -222 b 402 -158 402 -166 402 -163 b 333 49 402 -84 382 -16 b 137 292 265 138 192 213 b 42 520 82 372 42 520 b 22 537 39 530 37 537 b 0 520 4 537 0 530 z"
    },
    flag64thDown: {
      x_min: 0,
      x_max: 309,
      y_min: -403,
      y_max: 804,
      ha: 1207,
      o: "m 52 -196 b 91 -102 59 -166 71 -131 b 347 128 145 -23 272 45 b 384 180 361 145 374 163 b 324 -30 384 76 361 16 b 52 -196 235 -140 124 -176 z m 163 517 b 366 693 248 589 327 644 b 382 717 372 701 377 708 b 383 693 383 708 383 701 b 314 505 383 621 359 562 b 53 343 258 438 179 390 b 56 363 55 351 56 359 b 163 517 66 400 81 449 z m 314 232 b 50 69 258 163 179 117 b 91 171 56 102 69 140 b 347 402 145 251 272 318 b 382 449 360 416 372 432 b 383 420 383 439 383 429 b 314 232 383 348 359 288 z m 0 -557 b 22 -580 0 -567 10 -580 b 43 -557 33 -580 40 -567 b 167 -310 65 -408 109 -364 b 445 140 243 -238 445 -125 b 431 307 445 192 439 249 b 441 377 436 331 439 354 b 441 406 441 387 441 397 b 441 418 441 410 441 413 b 423 546 441 464 432 507 b 441 651 432 582 438 618 b 441 675 441 660 441 667 b 441 688 441 680 441 684 b 425 808 441 730 433 772 b 441 919 435 840 441 876 b 327 1149 441 1032 374 1112 b 305 1158 321 1153 314 1156 b 287 1152 300 1158 292 1156 b 279 1145 281 1151 279 1148 b 294 1129 279 1140 288 1136 b 382 930 344 1076 382 1027 b 327 789 382 877 364 832 b 22 598 226 672 86 612 b 0 559 12 593 0 563 z"
    },
    flag128thUp: {
      x_min: 0,
      x_max: 279,
      y_min: -821,
      y_max: 573,
      ha: 1394,
      o: "m 0 -550 b 22 -563 0 -553 12 -560 b 258 -776 59 -576 171 -648 b 318 -950 307 -850 318 -901 b 317 -975 318 -959 318 -966 b 285 -1140 317 -1011 307 -1083 b 279 -1164 284 -1148 279 -1156 b 289 -1179 279 -1171 282 -1176 b 297 -1182 292 -1181 294 -1181 b 318 -1162 307 -1182 312 -1169 b 382 -962 344 -1120 382 -1043 b 374 -857 382 -922 379 -887 b 402 -668 389 -802 402 -740 b 383 -554 402 -629 396 -590 b 402 -399 396 -503 402 -452 b 382 -284 402 -359 396 -321 b 402 -125 396 -230 402 -180 b 383 -14 402 -86 396 -49 b 402 130 396 35 402 81 b 333 348 402 204 382 284 b 137 592 265 438 192 513 b 42 808 82 671 46 793 b 22 825 39 818 37 825 b 0 808 4 825 0 818 z m 271 310 b 340 111 328 235 340 170 b 338 73 340 98 338 86 b 333 81 336 76 334 79 b 91 357 265 170 145 276 b 48 469 66 393 53 435 l 50 469 b 271 310 124 469 217 377 z m 301 -681 b 148 -523 262 -631 219 -593 b 56 -383 92 -465 66 -420 b 49 -343 55 -374 52 -359 l 50 -343 b 271 -500 124 -343 217 -432 b 340 -688 327 -575 340 -634 b 337 -737 340 -706 338 -721 b 301 -681 325 -716 312 -697 z m 333 -461 b 91 -192 265 -372 145 -271 b 48 -73 66 -154 53 -111 l 48 -73 l 50 -73 b 271 -232 124 -73 217 -163 b 340 -419 327 -305 340 -364 b 337 -468 340 -435 338 -452 b 333 -461 336 -465 334 -464 z m 333 -192 b 91 84 265 -102 145 4 b 48 200 65 121 53 164 l 48 200 l 50 200 b 271 42 124 200 217 109 b 340 -147 327 -32 340 -92 b 337 -197 340 -164 338 -181 b 333 -192 336 -196 334 -194 z"
    },
    flag128thDown: {
      x_min: 0,
      x_max: 309,
      y_min: -591,
      y_max: 803,
      ha: 1394,
      o: "m 0 -828 b 22 -851 0 -838 10 -851 b 43 -828 33 -851 40 -840 b 167 -580 65 -678 109 -635 b 445 -131 243 -508 445 -397 b 431 36 445 -79 439 -22 b 441 108 436 60 439 85 b 441 137 441 117 441 127 b 441 147 441 140 441 144 b 423 275 441 193 432 236 b 441 377 433 310 438 344 b 441 406 441 387 441 396 b 441 418 441 410 441 413 b 423 546 441 464 432 507 b 441 649 432 582 438 616 b 441 675 441 658 441 667 b 441 687 441 680 441 684 b 425 808 441 730 433 772 b 441 919 435 840 441 876 b 327 1149 441 1032 374 1112 b 304 1156 321 1153 312 1156 b 287 1152 298 1156 292 1155 b 279 1145 281 1149 279 1148 b 294 1129 279 1140 288 1135 b 382 930 344 1076 382 1027 b 327 789 382 877 364 832 b 22 598 226 672 86 612 b 0 559 12 593 0 562 z m 314 -37 b 50 -200 258 -107 179 -153 b 91 -102 58 -168 71 -132 b 347 128 145 -23 272 45 b 382 176 360 143 372 160 b 383 151 383 167 383 160 b 314 -37 383 79 359 19 z m 314 232 b 50 69 258 163 179 117 b 91 171 56 101 69 138 b 347 402 145 251 272 317 b 382 449 360 416 372 432 b 383 420 383 439 383 429 b 314 232 383 347 359 288 z m 163 517 b 366 693 248 589 327 642 b 382 716 372 700 377 708 b 383 693 383 708 383 700 b 314 505 382 621 359 560 b 53 343 258 436 179 390 b 56 363 55 350 56 357 b 163 517 66 399 81 449 z m 52 -467 b 91 -372 59 -435 71 -402 b 347 -141 145 -292 272 -225 b 384 -89 361 -125 374 -108 b 324 -301 382 -194 361 -255 b 52 -467 235 -410 122 -446 z"
    },
    accidentalFlat: {
      x_min: 0,
      x_max: 203,
      y_min: -176,
      y_max: 453,
      ha: 629,
      o: "m 289 114 b 173 223 281 170 246 223 b 52 170 101 223 59 179 l 58 632 b 37 652 58 644 49 652 l 20 652 b 0 632 9 652 0 644 l 7 -233 b 27 -253 7 -245 16 -253 b 39 -251 30 -253 36 -252 b 216 -114 45 -248 138 -202 b 292 78 271 -52 292 19 b 289 114 292 91 291 102 z m 190 58 b 148 -85 190 36 184 -30 b 48 -183 124 -122 75 -161 l 52 98 b 134 153 55 111 76 153 b 190 73 186 153 190 104 b 190 58 190 66 190 62 z"
    },
    accidentalNatural: {
      x_min: 0,
      x_max: 171,
      y_min: -323,
      y_max: 325,
      ha: 648,
      o: "m 239 264 b 228 268 236 266 232 268 b 222 266 226 268 223 266 l 40 216 l 40 468 l 0 468 l 0 -245 b 20 -264 0 -256 9 -264 b 26 -264 22 -264 24 -264 l 207 -213 l 207 -465 l 246 -465 b 246 248 246 -226 246 1 b 239 264 246 253 243 261 z m 40 -140 l 40 96 l 207 144 l 207 -94 z"
    },
    accidentalSharp: {
      x_min: 0,
      x_max: 244,
      y_min: -333,
      y_max: 334,
      ha: 667,
      o: "m 336 151 b 351 171 344 153 351 163 l 351 256 b 331 276 351 268 343 276 b 328 276 330 276 330 276 l 281 266 l 281 481 l 240 481 l 240 258 l 112 232 l 112 435 l 72 435 l 72 223 l 16 212 b 0 192 7 210 0 200 l 0 189 l 0 105 l 0 108 b 20 88 0 96 9 88 b 24 88 22 88 23 88 l 72 98 l 72 -140 l 16 -151 b 0 -171 7 -153 0 -163 l 0 -255 b 20 -275 0 -266 9 -275 b 24 -275 22 -275 23 -275 l 72 -265 l 72 -480 l 112 -480 l 112 -256 l 240 -230 l 240 -433 l 281 -433 l 281 -222 l 336 -212 b 351 -192 344 -210 351 -200 l 351 -107 b 331 -86 351 -95 343 -86 b 328 -86 330 -86 330 -86 l 281 -96 l 281 141 z m 112 107 l 240 132 l 240 -105 l 112 -132 z"
    },
    accidentalDoubleSharp: {
      x_min: 0,
      x_max: 275,
      y_min: -137,
      y_max: 138,
      ha: 275,
      o: "m 360 73 l 376 73 b 396 94 387 73 396 82 l 396 179 b 376 199 396 190 387 199 l 291 199 b 271 179 279 199 271 190 l 271 161 l 271 102 l 200 30 l 196 30 l 124 102 l 124 179 b 105 199 124 190 117 199 l 20 199 b 0 179 9 199 0 190 l 0 94 b 20 73 0 82 9 73 l 35 73 l 36 73 l 96 73 l 167 3 l 167 -1 l 96 -73 l 36 -73 l 35 -73 l 20 -73 b 0 -92 9 -73 0 -81 l 0 -177 b 20 -197 0 -189 9 -197 l 105 -197 b 124 -177 117 -197 124 -189 l 124 -101 l 196 -32 l 200 -32 l 271 -101 l 271 -161 l 271 -163 l 271 -177 b 291 -197 271 -189 279 -197 l 376 -197 b 396 -177 387 -197 396 -189 l 396 -92 b 376 -73 396 -81 387 -73 l 361 -73 l 360 -73 l 300 -73 l 228 -1 l 228 1 l 300 73 z"
    },
    accidentalDoubleFlat: {
      x_min: 0,
      x_max: 371,
      y_min: -176,
      y_max: 453,
      ha: 629,
      o: "m 531 115 b 415 223 523 171 488 223 b 294 171 343 223 301 180 l 300 632 b 279 652 300 644 291 652 l 262 652 b 242 632 251 652 242 644 l 246 199 b 173 223 228 213 204 223 b 52 170 101 223 59 179 l 58 632 b 37 652 58 644 49 652 l 20 652 b 0 632 9 652 0 644 l 7 -233 b 27 -253 7 -245 16 -253 b 39 -249 30 -253 36 -251 b 216 -114 45 -246 138 -202 b 248 -69 226 -102 239 -82 l 249 -233 b 269 -253 249 -245 258 -253 b 281 -249 272 -253 278 -251 b 458 -112 287 -246 380 -200 b 534 79 513 -50 534 20 b 531 115 534 92 533 104 z m 190 58 b 148 -85 190 36 184 -30 b 48 -183 124 -122 75 -161 l 52 98 b 134 153 55 111 76 153 b 190 73 186 153 190 104 b 190 58 190 66 190 62 z m 432 58 b 390 -85 432 36 426 -30 b 289 -183 366 -122 317 -161 l 294 98 b 376 153 297 111 318 153 b 432 73 428 153 432 104 b 432 58 432 66 432 62 z"
    },
    accidentalParensLeft: {
      x_min: 0,
      x_max: 75,
      y_min: -212,
      y_max: 209,
      ha: 421,
      o: "m 98 -305 b 104 -302 101 -304 102 -304 b 108 -295 107 -301 108 -298 b 107 -289 108 -294 108 -292 b 40 10 107 -288 40 -160 b 107 288 40 95 58 192 b 108 292 108 289 108 291 b 104 300 108 295 107 298 b 96 301 101 301 99 302 b 91 298 94 301 92 300 b 0 0 86 292 0 174 b 91 -301 0 -174 86 -295 b 98 -305 92 -304 95 -305 z"
    },
    accidentalParensRight: {
      x_min: 0,
      x_max: 75,
      y_min: -209,
      y_max: 212,
      ha: 421,
      o: "m 10 305 b 4 302 7 304 6 304 b 0 295 1 301 0 298 b 1 289 0 294 0 292 b 68 -10 1 288 68 160 b 1 -288 68 -95 50 -192 b 0 -292 0 -289 0 -291 b 4 -300 0 -295 1 -298 b 12 -301 7 -301 9 -302 b 17 -298 14 -301 16 -300 b 108 0 22 -292 108 -174 b 17 301 108 174 22 295 b 10 305 16 304 13 305 z"
    },
    accidentalQuarterToneFlatStein: {
      x_min: 0,
      x_max: 193,
      y_min: -176,
      y_max: 452,
      ha: 628,
      o: "m 0 84 b 107 -145 0 -26 65 -105 b 245 -249 166 -202 245 -249 b 253 -253 248 -251 249 -253 b 272 -235 264 -253 272 -245 l 278 632 b 259 651 278 642 269 651 l 248 651 b 229 632 238 651 229 642 l 232 174 b 125 217 223 186 192 217 b 0 84 53 217 0 173 z m 148 154 b 232 102 212 154 232 115 b 233 107 232 99 233 102 l 235 -179 b 134 -72 207 -156 160 -111 b 92 58 98 -17 92 36 b 92 75 92 62 92 68 b 148 154 92 105 96 154 z"
    },
    accidentalThreeQuarterTonesFlatZimmermann: {
      x_min: 0,
      x_max: 422,
      y_min: -176,
      y_max: 452,
      ha: 628,
      o: "m 608 84 b 482 217 608 173 554 217 b 376 174 416 217 384 186 l 379 632 b 360 651 379 642 370 651 l 348 651 b 330 632 338 651 330 642 l 336 -235 b 354 -253 336 -245 344 -253 b 363 -249 359 -253 360 -251 b 501 -145 363 -249 442 -202 b 608 84 543 -105 608 -26 z m 459 154 b 516 75 511 154 516 105 b 516 58 516 68 516 62 b 474 -72 516 36 510 -17 b 373 -179 448 -111 400 -156 l 374 107 b 376 102 374 102 376 99 b 459 154 376 115 396 154 z m 0 84 b 107 -145 0 -26 65 -105 b 245 -249 166 -202 245 -249 b 253 -253 248 -251 249 -253 b 272 -235 264 -253 272 -245 l 278 632 b 259 651 278 642 269 651 l 248 651 b 229 632 238 651 229 642 l 232 174 b 125 217 223 186 192 217 b 0 84 53 217 0 173 z m 148 154 b 232 102 212 154 232 115 b 233 107 232 99 233 102 l 235 -179 b 134 -72 207 -156 160 -111 b 92 58 98 -17 92 36 b 92 75 92 62 92 68 b 148 154 92 105 96 154 z"
    },
    accidentalQuarterToneSharpStein: {
      x_min: 0,
      x_max: 180,
      y_min: -316,
      y_max: 320,
      ha: 636,
      o: "m 243 144 b 259 164 252 145 259 156 l 259 249 b 239 269 259 261 251 269 b 235 268 238 269 236 268 l 150 251 l 150 461 l 109 461 l 109 242 l 16 222 b 0 203 7 220 0 212 l 0 120 b 20 99 0 108 9 99 b 24 99 22 99 23 99 l 109 117 l 109 -121 l 16 -141 b 0 -160 7 -143 0 -151 l 0 -243 b 20 -264 0 -255 9 -264 b 24 -264 22 -264 23 -264 l 109 -246 l 109 -455 l 150 -455 l 150 -238 l 243 -219 b 259 -199 252 -217 259 -207 l 259 -114 b 239 -95 259 -102 251 -95 b 235 -95 238 -95 236 -95 l 150 -112 l 150 125 z"
    },
    accidentalThreeQuarterTonesSharpStein: {
      x_min: 0,
      x_max: 290,
      y_min: -328,
      y_max: 339,
      ha: 667,
      o: "m 400 158 b 416 179 409 160 416 170 l 416 264 b 397 284 416 275 409 284 b 393 284 396 284 395 284 l 348 274 l 348 488 l 308 488 l 308 265 l 223 248 l 223 465 l 184 465 l 184 240 l 108 225 l 108 442 l 69 442 l 69 216 l 16 204 b 0 186 7 203 0 194 l 0 102 b 20 82 0 91 9 82 b 24 82 22 82 23 82 l 69 92 l 69 -147 l 16 -158 b 0 -177 7 -160 0 -168 l 0 -261 b 20 -281 0 -272 9 -281 b 24 -281 22 -281 23 -281 l 69 -272 l 69 -472 l 108 -472 l 108 -264 l 184 -248 l 184 -451 l 223 -451 l 223 -240 l 308 -223 l 308 -426 l 348 -426 l 348 -215 l 400 -204 b 418 -184 409 -203 418 -193 l 418 -99 b 397 -79 418 -88 409 -79 b 393 -79 396 -79 395 -79 l 348 -89 l 348 148 z m 184 -122 l 108 -138 l 108 99 l 184 115 z m 223 122 l 308 140 l 308 -98 l 223 -115 z"
    },
    accidentalBuyukMucennebFlat: {
      x_min: 0,
      x_max: 277,
      y_min: -176,
      y_max: 454,
      ha: 630,
      o: "m 396 115 b 279 225 387 173 354 225 b 158 171 204 225 164 179 l 160 317 l 336 419 l 336 482 l 161 380 l 161 488 l 336 590 l 336 654 l 163 552 l 164 634 b 144 654 164 645 156 654 l 127 654 b 107 634 115 654 107 645 l 108 520 l 0 456 l 0 393 l 108 456 l 109 350 l 0 285 l 0 222 l 109 287 l 114 -235 b 134 -253 114 -246 122 -253 b 145 -251 138 -253 141 -252 b 323 -114 145 -251 242 -204 b 399 79 377 -52 399 20 b 396 115 399 92 397 104 z m 297 58 b 255 -85 297 36 291 -30 b 154 -184 230 -122 181 -163 l 158 96 b 240 153 161 109 181 153 b 297 73 292 153 297 104 b 297 58 297 66 297 62 z"
    },
    accidentalBuyukMucennebSharp: {
      x_min: 0,
      x_max: 348,
      y_min: -332,
      y_max: 334,
      ha: 666,
      o: "m 494 121 b 482 125 491 122 485 125 b 478 125 481 125 480 125 l 354 91 l 354 148 l 412 164 b 425 183 419 166 425 176 l 425 268 b 408 287 425 278 418 287 b 402 285 406 287 403 285 l 354 272 l 354 481 l 317 481 l 317 262 l 186 226 l 186 436 l 148 436 l 148 216 l 89 200 b 76 183 82 199 76 190 l 76 98 b 84 84 76 92 79 86 b 95 81 86 82 92 81 b 99 81 96 81 98 81 l 148 94 l 148 35 l 14 -1 b 0 -20 7 -3 0 -13 l 0 -104 b 7 -118 0 -109 3 -115 b 19 -122 10 -120 16 -122 b 23 -121 20 -122 22 -121 l 148 -88 l 148 -147 l 89 -163 b 76 -180 82 -164 76 -173 l 76 -181 l 76 -265 b 95 -282 76 -275 85 -282 b 99 -282 96 -282 98 -282 l 148 -269 l 148 -478 l 186 -478 l 186 -259 l 317 -225 l 317 -433 l 354 -433 l 354 -215 l 412 -199 b 425 -181 419 -197 425 -189 l 425 -95 b 418 -81 425 -89 422 -84 b 406 -76 415 -79 409 -76 b 402 -78 405 -76 403 -78 l 354 -91 l 354 -32 l 488 4 b 501 22 495 6 501 14 l 501 107 b 494 121 501 112 498 118 z m 317 138 l 317 81 l 186 45 l 186 104 z m 186 -137 l 186 -78 l 317 -42 l 317 -101 z"
    },
    accidentalBakiyeFlat: {
      x_min: 0,
      x_max: 277,
      y_min: -176,
      y_max: 454,
      ha: 630,
      o: "m 396 115 b 279 225 387 173 354 225 b 158 171 204 225 164 179 l 161 348 l 336 452 l 336 516 l 161 413 l 164 634 b 144 654 164 645 156 654 l 127 654 b 107 634 115 654 107 645 l 109 382 l 0 318 l 0 255 l 109 318 l 114 -235 b 134 -253 114 -246 122 -253 b 145 -251 138 -253 143 -252 b 323 -114 145 -251 242 -204 b 399 79 377 -52 399 20 b 396 115 399 92 397 104 z m 297 58 b 255 -85 297 36 291 -30 b 156 -184 230 -122 183 -163 l 158 96 b 240 153 161 109 181 153 b 297 73 292 153 297 104 b 297 58 297 66 297 62 z"
    },
    accidentalKucukMucennebSharp: {
      x_min: 0,
      x_max: 348,
      y_min: -316,
      y_max: 318,
      ha: 634,
      o: "m 494 121 b 482 125 491 124 487 125 b 478 124 481 125 480 124 l 269 68 l 269 127 l 412 164 b 425 181 420 167 425 173 l 425 266 b 418 282 425 272 422 279 b 406 285 415 285 410 285 b 402 285 405 285 403 285 l 269 249 l 269 458 l 232 458 l 232 239 l 89 200 b 76 181 81 197 76 190 l 76 98 b 84 84 76 92 79 86 b 95 79 86 81 91 79 b 99 81 96 79 98 81 l 232 115 l 232 58 l 14 -3 b 0 -20 6 -6 0 -12 l 0 -104 b 7 -118 0 -109 3 -115 b 19 -122 10 -121 14 -122 b 23 -122 20 -122 22 -122 l 232 -66 l 232 -124 l 89 -163 b 76 -180 81 -166 76 -171 l 76 -264 b 84 -279 76 -269 79 -276 b 95 -282 86 -282 91 -282 b 99 -282 96 -282 98 -282 l 232 -246 l 232 -455 l 269 -455 l 269 -236 l 412 -199 b 425 -180 420 -196 425 -189 l 425 -95 b 418 -81 425 -89 422 -84 b 406 -76 415 -78 410 -76 b 402 -78 405 -76 403 -78 l 269 -114 l 269 -55 l 487 4 b 501 22 495 7 501 13 l 501 107 b 494 121 501 112 498 118 z"
    },
    articAccentAbove: {
      x_min: 0,
      x_max: 361,
      y_min: 0,
      y_max: 235,
      ha: 235,
      o: "m 26 337 b 20 338 24 337 22 338 b 0 318 9 338 0 330 l 0 285 b 14 266 0 276 7 269 l 323 170 l 14 72 b 0 53 7 69 0 62 l 0 20 b 20 0 0 9 9 0 b 26 1 22 0 24 1 l 505 150 b 520 170 513 153 520 161 b 505 189 520 179 513 186 z"
    },
    articAccentBelow: {
      x_min: 0,
      x_max: 361,
      y_min: -235,
      y_max: 0,
      ha: 235,
      o: "m 26 -1 b 20 0 24 -1 22 0 b 0 -20 9 0 0 -9 l 0 -53 b 14 -72 0 -62 7 -69 l 323 -168 l 14 -266 b 0 -285 7 -269 0 -276 l 0 -318 b 20 -338 0 -330 9 -338 b 26 -337 22 -338 24 -337 l 505 -189 b 520 -168 513 -186 520 -177 b 505 -150 520 -160 513 -153 z"
    },
    articTenutoAbove: {
      x_min: 0,
      x_max: 316,
      y_min: 0,
      y_max: 46,
      ha: 46,
      o: "m 20 66 b 0 46 9 66 0 58 l 0 20 b 20 0 0 9 9 0 l 435 0 b 455 20 446 0 455 9 l 455 46 b 435 66 455 58 446 66 z"
    },
    articTenutoBelow: {
      x_min: 0,
      x_max: 316,
      y_min: -46,
      y_max: 0,
      ha: 46,
      o: "m 20 0 b 0 -20 9 0 0 -9 l 0 -46 b 20 -66 0 -58 9 -66 l 435 -66 b 455 -46 446 -66 455 -58 l 455 -20 b 435 0 455 -9 446 0 z"
    },
    articStaccatoAbove: {
      x_min: 0,
      x_max: 78,
      y_min: 0,
      y_max: 78,
      ha: 78,
      o: "m 16 16 b 96 16 39 -6 73 -6 b 96 95 118 39 118 73 b 16 95 73 118 39 118 b 16 16 -6 73 -6 39 z"
    },
    articStaccatoBelow: {
      x_min: 0,
      x_max: 78,
      y_min: -78,
      y_max: 0,
      ha: 78,
      o: "m 16 -96 b 96 -96 39 -118 73 -118 b 96 -17 118 -73 118 -39 b 16 -17 73 6 39 6 b 16 -96 -6 -39 -6 -73 z"
    },
    articStaccatissimoAbove: {
      x_min: 0,
      x_max: 127,
      y_min: 0,
      y_max: 248,
      ha: 248,
      o: "m 163 357 b 150 353 154 357 150 353 l 99 300 b 92 295 96 297 95 295 b 85 300 89 295 88 297 l 35 353 b 22 357 35 353 30 357 b 0 338 13 357 0 351 b 73 22 0 323 73 22 b 92 0 75 16 78 0 b 111 22 107 0 109 16 b 183 338 111 22 183 323 b 163 357 183 351 171 357 z"
    },
    articStaccatissimoBelow: {
      x_min: 0,
      x_max: 127,
      y_min: -248,
      y_max: 0,
      ha: 248,
      o: "m 20 -357 b 33 -353 29 -357 33 -353 l 84 -300 b 91 -295 86 -297 88 -295 b 98 -300 94 -295 95 -297 l 148 -353 b 161 -357 148 -353 153 -357 b 183 -338 170 -357 183 -351 b 109 -22 183 -323 109 -22 b 91 0 108 -16 105 0 b 72 -22 76 0 73 -16 b 0 -338 72 -22 0 -323 b 20 -357 0 -351 12 -357 z"
    },
    articMarcatoAbove: {
      x_min: 1,
      x_max: 296,
      y_min: 0,
      y_max: 253,
      ha: 253,
      o: "m 36 10 l 173 239 l 298 10 b 317 0 301 4 310 0 l 408 0 b 426 20 419 0 426 9 b 425 30 426 23 426 27 l 230 356 b 213 364 226 361 222 363 b 196 356 207 364 199 361 l 1 30 z"
    },
    articMarcatoBelow: {
      x_min: 0,
      x_max: 295,
      y_min: -253,
      y_max: 0,
      ha: 253,
      o: "m 390 -10 l 253 -239 l 128 -10 b 109 0 125 -4 117 0 l 19 0 b 0 -20 7 0 0 -9 b 1 -30 0 -23 0 -27 l 196 -356 b 213 -364 200 -361 204 -363 b 230 -356 219 -364 228 -361 l 425 -30 z"
    },
    fermataAbove: {
      x_min: 0,
      x_max: 622,
      y_min: 0,
      y_max: 368,
      ha: 368,
      o: "m 778 374 b 448 530 642 521 523 530 b 120 374 373 530 255 521 b 0 65 49 297 0 143 b 20 19 0 37 6 19 b 161 265 60 19 40 143 b 445 373 268 372 410 373 b 448 373 446 373 446 373 b 451 373 449 373 449 373 b 734 265 485 373 628 372 b 876 19 855 143 835 19 b 896 65 890 19 896 36 b 778 374 896 143 848 298 z m 348 99 b 448 0 348 45 393 0 b 547 99 503 0 547 45 b 448 199 547 154 503 199 b 348 99 393 199 348 154 z"
    },
    fermataBelow: {
      x_min: 0,
      x_max: 622,
      y_min: -368,
      y_max: 0,
      ha: 368,
      o: "m 778 -374 b 896 -65 848 -298 896 -143 b 876 -19 896 -36 890 -19 b 734 -265 835 -19 855 -143 b 451 -373 628 -372 485 -373 b 448 -373 449 -373 449 -373 b 445 -373 446 -373 446 -373 b 161 -265 410 -373 268 -372 b 20 -19 40 -143 60 -19 b 0 -65 6 -19 0 -37 b 120 -374 0 -143 49 -297 b 448 -530 255 -521 373 -530 b 778 -374 523 -530 642 -521 z m 348 -99 b 448 -199 348 -154 393 -199 b 547 -99 503 -199 547 -154 b 448 0 547 -45 503 0 b 348 -99 393 0 348 -45 z"
    },
    fermataLongAbove: {
      x_min: 0,
      x_max: 623,
      y_min: 0,
      y_max: 368,
      ha: 368,
      o: "m 40 0 l 40 399 l 858 399 l 858 0 l 897 0 l 897 510 b 877 530 897 521 888 530 l 20 530 b 0 510 9 530 0 521 l 0 0 z m 350 148 b 449 49 350 94 395 49 b 547 148 504 49 547 94 b 449 248 547 203 504 248 b 350 148 395 248 350 203 z"
    },
    fermataLongBelow: {
      x_min: 0,
      x_max: 623,
      y_min: -368,
      y_max: 0,
      ha: 368,
      o: "m 0 -510 b 20 -530 0 -521 9 -530 l 877 -530 b 897 -510 888 -530 897 -521 l 897 0 l 858 0 l 858 -399 l 40 -399 l 40 0 l 0 0 z m 350 -148 b 449 -248 350 -203 395 -248 b 547 -148 504 -248 547 -203 b 449 -49 547 -94 504 -49 b 350 -148 395 -49 350 -94 z"
    },
    fermataVeryLongAbove: {
      x_min: 0,
      x_max: 842,
      y_min: 0,
      y_max: 549,
      ha: 549,
      o: "m 276 0 l 276 399 l 936 399 l 936 0 l 976 0 l 976 510 b 956 530 976 521 968 530 l 256 530 b 236 510 245 530 236 521 l 236 0 z m 507 148 b 606 49 507 94 552 49 b 706 148 661 49 706 94 b 606 248 706 203 661 248 b 507 148 552 248 507 203 z m 40 0 l 40 661 l 1172 661 l 1172 0 l 1212 0 l 1212 772 b 1192 791 1212 783 1204 791 l 20 791 b 0 772 9 791 0 783 l 0 0 z"
    },
    fermataVeryLongBelow: {
      x_min: 0,
      x_max: 842,
      y_min: -549,
      y_max: 0,
      ha: 549,
      o: "m 236 -510 b 256 -530 236 -521 245 -530 l 956 -530 b 976 -510 968 -530 976 -521 l 976 0 l 936 0 l 936 -399 l 276 -399 l 276 0 l 236 0 z m 507 -148 b 606 -248 507 -203 552 -248 b 706 -148 661 -248 706 -203 b 606 -49 706 -94 661 -49 b 507 -148 552 -49 507 -94 z m 0 -772 b 20 -791 0 -783 9 -791 l 1192 -791 b 1212 -772 1204 -791 1212 -783 l 1212 0 l 1172 0 l 1172 -661 l 40 -661 l 40 0 l 0 0 z"
    },
    fermataShortAbove: {
      x_min: 0,
      x_max: 642,
      y_min: 0,
      y_max: 45