"""

Spacial score (SPS) is an empirical scoring system to express the spacial complexity of a compound
in an uniform manner and on a highly granular scale for ranking and comparison between molecules. [1]
SPS takes into account the fraction of sp3 hybridized carbons and the fraction of stereogenic carbons.

By default, this module generates the normalized spacial score (nSPS), which is a variation of the SPS score
that considers the size of the molecule.
To obtain the nSPS score the SPS score is divided by the total number of heavy atoms in the analyzed molecule.

SPS = sum(h*s*r*n*n)
nSPS = SPS/a

Where:
h = Atom hybridisation term
s = Stereoisomeric term
r = Non-aromatic ring term
n = Number of heavy atom neighbors
a = Total number of heavy atoms in the molecule

The SPS function in this module takes a mol object and returns either the absolute score (normalize=False) or the score normalized by the number of heavy atoms (normalize=True (default)).

The original code implementation can be found at: https://github.com/frog2000/Spacial-Score/blob/main/spacial_score.py

[1] Krzyzanowski, A.; Pahl, A.; Grigalunas, M.; Waldmann, H. Spacial Score─A Comprehensive Topological Indicator for Small-Molecule Complexity. J. Med. Chem. 2023. https://doi.org/10.1021/acs.jmedchem.3c00689.
"""
from __future__ import annotations
import collections
from collections import defaultdict
from rdkit import Chem
from rdkit.Chem.ChemUtils.DescriptorUtilities import setDescriptorVersion
from rdkit.Chem import rdmolops
import typing
__all__ = ['Chem', 'SPS', 'defaultdict', 'rdmolops', 'setDescriptorVersion']
class _SpacialScore:
    """
    Class intended for calculating spacial score (SPS) and size-normalised SPS (nSPS) for small organic molecules
    """
    _hybridisations: typing.ClassVar[collections.defaultdict]  # value = defaultdict(<function _SpacialScore.<lambda> at 0x7f2fa2132830>, {rdkit.Chem.rdchem.HybridizationType.SP: 1, rdkit.Chem.rdchem.HybridizationType.SP2: 2, rdkit.Chem.rdchem.HybridizationType.SP3: 3})
    def __init__(self, mol, normalize = True):
        ...
    def _accountForHybridisation(self, atom):
        """
        Calculates the hybridisation score for a single atom in a molecule
        """
    def _accountForNeighbors(self, atom):
        """
        Calculates the neighbour score for a single atom in a molecule
                The second power allows to account for branching in the molecular structure
        """
    def _accountForRing(self, atom):
        """
        Calculates the ring score for a single atom in a molecule
        """
    def _accountForStereo(self, atom_idx):
        """
        Calculates the stereo score for a single atom in a molecule
        """
    def _calculateScoreForAtom(self, atom_idx):
        """
        Calculates the total score for a single atom in a molecule
        """
    def calculateSpacialScore(self):
        """
        Calculates the total spacial score for a molecule
        """
    def findDoubleBondsStereo(self):
        """
        Finds indeces of stereo double bond atoms (E/Z)
        """
    def findStereoAtomIdxs(self, includeUnassigned = True):
        """
        Finds indices of atoms that are (pseudo)stereo/chiralcentres, in respect to the attached groups (does not account for double bond isomers)
        """
def SPS(mol, normalize = True):
    """
    Calculates the SpacialScore descriptor. By default, the score is normalized by the number of heavy atoms (nSPS) resulting in a float value,
        otherwise (normalize=False) the absolute score is returned as an integer.
        
    """
