import sys
import threading
import seeed_mlx9064x
from serial import Serial
from PyQt5.QtWidgets import (
        QApplication,
        QGraphicsView,
        QGraphicsScene,
        QGraphicsPixmapItem,
        QGraphicsTextItem,
        QGraphicsEllipseItem,
        QGraphicsLineItem,
        QGraphicsBlurEffect
    )
from PyQt5.QtGui import QPainter, QBrush, QColor, QFont, QPixmap
from PyQt5.QtCore import QThread, QObject, pyqtSignal, QPointF, Qt


def mapValue(value, curMin, curMax, desMin, desMax):
    curDistance = value - curMax
    if curDistance == 0:
        return desMax
    curRange = curMax - curMin
    direction = 1 if curDistance > 0 else -1
    ratio = curRange / curDistance
    desRange = desMax - desMin
    value = desMax + (desRange / ratio)
    return value


def constrain(value, down, up):
    value = up if value > up else value
    value = down if value < down else value
    return value        


def isDigital(value):
    try:
        if value == "nan":
            return False
        else:
            float(value)
        return True
    except ValueError:
        return False


hetaData = []
lock = threading.Lock()
minHue = 180
maxHue = 360
ChipType = "MLX90640"

class DataReader(QThread):
    
    drawRequire = pyqtSignal()

    I2C = 0,
    SERIAL = 1
    MODE = I2C
    # pixel_num = 192
    pixel_num = 768
    def __init__(self, port,ChipType = "MLX90640"):
        super(DataReader, self).__init__()
        self.frameCount = 0
        # i2c mode
        if ChipType == "MLX90640":
            DataReader.pixel_num = 768
        elif ChipType == "MLX90641":
            DataReader.pixel_num = 192
        if port == 'I2C':
            if ChipType == "MLX90640":
                self.dataHandle = seeed_mlx9064x.grove_mxl90640()
                self.dataHandle.refresh_rate = seeed_mlx9064x.RefreshRate.REFRESH_8_HZ
            elif ChipType == "MLX90641":
                self.dataHandle = seeed_mlx9064x.grove_mxl90641()
                self.dataHandle.refresh_rate = seeed_mlx9064x.RefreshRate.REFRESH_8_HZ
            self.readData = self.i2cRead
        else:
            self.MODE = DataReader.SERIAL
            self.port = port
            self.dataHandle = Serial(self.port, 115200, timeout=5)
            self.readData = self.serialRead

    def i2cRead(self):
        hetData = [0]*DataReader.pixel_num
        self.dataHandle.getFrame(hetData)
        return hetData

    def serialRead(self):
        # hetData = [0]*DataReader.pixel_num
        hetData = self.dataHandle.read_until(terminator=b'\r\n')
        hetData = str(hetData, encoding="utf8").split(",")
        hetData = hetData[:-1]
        return hetData

    def run(self):
        # throw first frame
        self.readData()
        while True:
            maxHet = 0
            minHet = 500
            tempData = []
            nanCount = 0

            # hetData = self.imageLarger(self.readData(),32,24)
            hetData = self.readData()
            if  len(hetData) < DataReader.pixel_num :
                continue

            for i in range(0, DataReader.pixel_num):
                curCol = i % 32
                newValueForNanPoint = 0
                curData = None

                if i < len(hetData) and isDigital(hetData[i]):
                    curData = float(format(hetData[i],'.2f'))
                else:
                    interpolationPointCount = 0
                    sumValue = 0
                    print("curCol",curCol,"i",i)

                    abovePointIndex = i-32
                    if (abovePointIndex>0):
                        if hetData[abovePointIndex] is not "nan" :
                            interpolationPointCount += 1
                            sumValue += float(hetData[abovePointIndex])

                    belowPointIndex = i+32
                    if (belowPointIndex<DataReader.pixel_num):
                        print(" ")
                        if hetData[belowPointIndex] is not "nan" :
                            interpolationPointCount += 1
                            sumValue += float(hetData[belowPointIndex])
                            
                    leftPointIndex = i -1
                    if (curCol != 31):
                        if hetData[leftPointIndex]  is not "nan" :
                            interpolationPointCount += 1
                            sumValue += float(hetData[leftPointIndex])

                    rightPointIndex = i + 1
                    if (belowPointIndex<DataReader.pixel_num):
                        if (curCol != 0):
                            if hetData[rightPointIndex] is not "nan" :
                                interpolationPointCount += 1
                                sumValue += float(hetData[rightPointIndex])

                    curData =  sumValue /interpolationPointCount
                    # For debug :
                    # print(abovePointIndex,belowPointIndex,leftPointIndex,rightPointIndex)
                    # print("newValueForNanPoint",newValueForNanPoint," interpolationPointCount" , interpolationPointCount ,"sumValue",sumValue)
                    nanCount +=1

                tempData.append(curData)
                maxHet = tempData[i] if tempData[i] > maxHet else maxHet
                minHet = tempData[i] if tempData[i] < minHet else minHet

            if maxHet == 0 or minHet == 500:
                continue
            # For debug :
            # if nanCount > 0 :
            #     print("____@@@@@@@ nanCount " ,nanCount , " @@@@@@@____")
           
            lock.acquire()
            hetaData.append(
                {
                    "frame": tempData,
                    "maxHet": maxHet,
                    "minHet": minHet
                }
            )
            lock.release()
            self.drawRequire.emit()
            self.frameCount = self.frameCount + 1
            print("data->" + str(self.frameCount))
        self.com.close()
        

class painter(QGraphicsView):
    narrowRatio = int(sys.argv[5]) if len(sys.argv) >= 6 else 1
    useBlur = sys.argv[6] != "False" if len(sys.argv) >= 7 else True
    pixelSize = int(15 / narrowRatio)
    width = int (480 / narrowRatio) 
    height = int(360 / narrowRatio)
    width = int(480 / narrowRatio) 
    height = int(360 / narrowRatio)    
    width = int (480 / narrowRatio) 
    height = int(360 / narrowRatio)
    fontSize = int(30 / narrowRatio)
    anchorLineSize = int(100 / narrowRatio)
    ellipseRadius = int(8 / narrowRatio)
    textInterval = int(90 / narrowRatio)
    col = width / pixelSize
    line = height / pixelSize
    centerIndex = int(round(((line / 2 - 1) * col) + col / 2))
    frameCount = 0
    baseZValue = 0
    textLineHeight = fontSize + 10
    blurRaduis = 50  # Smoother improvement
    def __init__(self):
        super(painter, self).__init__()
        self.setFixedSize(self.width, self.height + self.textLineHeight)
        self.setHorizontalScrollBarPolicy(Qt.ScrollBarAlwaysOff)
        self.setVerticalScrollBarPolicy(Qt.ScrollBarAlwaysOff)
        self.scene = QGraphicsScene()
        self.setScene(self.scene)
        if len(sys.argv) >= 2:
            if sys.argv[2] == "MLX90641":
                self.blurRaduis = 25
                self.ChipType = "MLX90641"
            elif sys.argv[2] == "MLX90640":
                self.blurRaduis = 50
                self.ChipType = "MLX90640"         
        # center het text item
        self.centerTextItem = QGraphicsTextItem()
        self.centerTextItem.setPos(self.width / 2 - self.fontSize, 0)
        self.centerTextItem.setZValue(self.baseZValue + 1)
        self.scene.addItem(self.centerTextItem)
        # center anchor item
        centerX = self.width / 2
        centerY = self.height / 2
        self.ellipseItem = QGraphicsEllipseItem(
                0, 0, 
                self.ellipseRadius * 2, 
                self.ellipseRadius * 2
            )
        self.horLineItem = QGraphicsLineItem(0, 0, self.anchorLineSize, 0)
        self.verLineItem = QGraphicsLineItem(0, 0, 0, self.anchorLineSize)
        self.ellipseItem.setPos(
                centerX - self.ellipseRadius, 
                centerY - self.ellipseRadius
            )
        self.horLineItem.setPos(centerX - self.anchorLineSize / 2, centerY)
        self.verLineItem.setPos(centerX, centerY - self.anchorLineSize / 2)
        self.ellipseItem.setPen(QColor(Qt.white))
        self.horLineItem.setPen(QColor(Qt.white))
        self.verLineItem.setPen(QColor(Qt.white))
        self.ellipseItem.setZValue(self.baseZValue + 1)
        self.horLineItem.setZValue(self.baseZValue + 1)
        self.verLineItem.setZValue(self.baseZValue + 1)
        self.scene.addItem(self.ellipseItem)
        self.scene.addItem(self.horLineItem)
        self.scene.addItem(self.verLineItem)
        # camera item
        self.cameraBuffer = QPixmap(self.width, self.height + self.textLineHeight)
        self.cameraItem = QGraphicsPixmapItem()
        if self.useBlur:
            self.gusBlurEffect = QGraphicsBlurEffect()
            self.gusBlurEffect.setBlurRadius(self.blurRaduis)
            self.cameraItem.setGraphicsEffect(self.gusBlurEffect)
        self.cameraItem.setPos(0, 0)
        self.cameraItem.setZValue(self.baseZValue)
        self.scene.addItem(self.cameraItem)
        # het text item
        self.hetTextBuffer = QPixmap(self.width, self.textLineHeight)
        self.hetTextItem = QGraphicsPixmapItem()
        self.hetTextItem.setPos(0, self.height)
        self.hetTextItem.setZValue(self.baseZValue)
        self.scene.addItem(self.hetTextItem)

    def draw(self):
        if len(hetaData) == 0:
            return
        font = QFont()
        color = QColor()
        font.setPointSize(self.fontSize)
        font.setFamily("Microsoft YaHei")
        font.setLetterSpacing(QFont.AbsoluteSpacing, 0)
        index = 0
        lock.acquire()
        frame = hetaData.pop(0)
        lock.release()
        maxHet = frame["maxHet"]
        minHet = frame["minHet"]
        frame = frame["frame"]
        p = QPainter(self.cameraBuffer)
        p.fillRect(
                0, 0, self.width, 
                self.height + self.textLineHeight, 
                QBrush(QColor(Qt.black))
            )
        # draw camera
        color = QColor()
        if self.ChipType == "MLX90641":
            for yIndex in range(int(self.height / self.pixelSize / 2 )):
                for xIndex in range(int(self.width / self.pixelSize  / 2 )):
                    tempData = constrain(mapValue(frame[index], minHet, maxHet, minHue, maxHue), minHue, maxHue)
                    color.setHsvF(tempData / 360, 1.0, 1.0)
                    p.fillRect(
                        xIndex * self.pixelSize * 2,
                        yIndex * self.pixelSize * 2 ,
                        self.pixelSize * 2, self.pixelSize * 2,
                        QBrush(color)
                    )
                    index = index + 1
            if self.centerIndex == 0 or self.centerIndex>=192:
                self.centerIndex = 6*16+8            
        else:
            for yIndex in range(int(self.height / self.pixelSiz)):
                for xIndex in range(int(self.width / self.pixelSize)):
                    tempData = constrain(mapValue(frame[index], minHet, maxHet, minHue, maxHue), minHue, maxHue)
                    color.setHsvF(tempData / 360, 1.0, 1.0)
                    p.fillRect(
                        xIndex * self.pixelSize,
                        yIndex * self.pixelSize,
                        self.pixelSize, self.pixelSize,
                        QBrush(color)
                    )
                    index = index + 1          
        self.cameraItem.setPixmap(self.cameraBuffer)
        # draw text
        p = QPainter(self.hetTextBuffer)
        p.fillRect(
                0, 0, self.width, 
                self.height + self.textLineHeight, 
                QBrush(QColor(Qt.black))
            )
        hetDiff = maxHet - minHet
        bastNum = round(minHet)
        interval = round(hetDiff / 5)
        for i in range(5):
            hue = constrain(mapValue((bastNum + (i * interval)), minHet, maxHet, minHue, maxHue), minHue, maxHue)
            color.setHsvF(hue / 360, 1.0, 1.0)
            p.setPen(color)
            p.setFont(font)
            p.drawText(i * self.textInterval, self.fontSize + 3, str(bastNum + (i * interval)) + "°")
        self.hetTextItem.setPixmap(self.hetTextBuffer)
        # draw center het text
        cneter = round(frame[self.centerIndex], 1)
        centerText = "<font color=white>%s</font>"
        self.centerTextItem.setFont(font)
        self.centerTextItem.setHtml(centerText % (str(cneter) + "°"))
        self.frameCount = self.frameCount + 1
        print("picture->"+str(self.frameCount))

def run():
    global minHue
    global maxHue
    global ChipType
    if len(sys.argv) <= 2 or sys.argv[1] == "-h":
        print("Usage: %s PortName ChipType [minHue] [maxHue] [NarrowRatio] [UseBlur]" % sys.argv[0])
        exit(0)
    if len(sys.argv) >= 5:
        minHue = int(sys.argv[3])
        maxHue = int(sys.argv[4])
    port = sys.argv[1]
    if len(sys.argv) >= 2:
        ChipType = sys.argv[2]
    app = QApplication(sys.argv)
    window = painter()
    dataThread = DataReader(port,ChipType)
    dataThread.drawRequire.connect(window.draw)
    dataThread.start()
    window.show()
    app.exec_()
    

run()
