"""Prefect flows for interacting with Census."""

from prefect import flow, task

from prefect_census.syncs import CensusSync


@flow
async def run_census_sync(census_sync: CensusSync):
    """A flow for triggering a Census sync run and waiting for completion.

    Args:
        census_sync: The Census sync job block to trigger.

    Returns:
        The result of the sync run.
    """
    census_sync_run = await task(census_sync.trigger.aio)(census_sync)

    sync_status = await task(census_sync_run.wait_for_completion.aio)(census_sync_run)

    return await task(census_sync_run.fetch_result.aio)(
        census_sync_run, wait_for=[sync_status]
    )
