"""Utilities for common interactions with the Census API"""
from json import JSONDecodeError
from typing import Optional

from httpx import HTTPStatusError


def extract_user_message(error: HTTPStatusError) -> Optional[str]:
    """
    Extract user message from an error response from the Census API.

    Args:
        error: An HTTPStatusError raised by httpx

    Returns:
        The status from Census API response or None if a status cannot
            be extracted.
    """
    try:
        response_payload = error.response.json()
        user_message = response_payload.get("status", None)
        return user_message
    except JSONDecodeError:
        pass
